# automatically generated file, don't edit



# Copyright 2011 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::DE;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20210921211831;

my $formatters = [
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            3[02]|
            40|
            [68]9
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3,13})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            2(?:
              0[1-389]|
              12[0-8]
            )|
            3(?:
              [35-9][15]|
              4[015]
            )|
            906|
            2(?:
              [13][14]|
              2[18]
            )|
            (?:
              2[4-9]|
              4[2-9]|
              [579][1-9]|
              [68][1-8]
            )1
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3,12})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            [24-6]|
            3(?:
              3(?:
                0[1-467]|
                2[127-9]|
                3[124578]|
                7[1257-9]|
                8[1256]|
                9[145]
              )|
              4(?:
                2[135]|
                4[13578]|
                9[1346]
              )|
              5(?:
                0[14]|
                2[1-3589]|
                6[1-4]|
                7[13468]|
                8[13568]
              )|
              6(?:
                2[1-489]|
                3[124-6]|
                6[13]|
                7[12579]|
                8[1-356]|
                9[135]
              )|
              7(?:
                2[1-7]|
                4[145]|
                6[1-5]|
                7[1-4]
              )|
              8(?:
                21|
                3[1468]|
                6|
                7[1467]|
                8[136]
              )|
              9(?:
                0[12479]|
                2[1358]|
                4[134679]|
                6[1-9]|
                7[136]|
                8[147]|
                9[1468]
              )
            )|
            70[2-8]|
            8(?:
              0[2-9]|
              [1-8]
            )|
            90[7-9]|
            [79][1-9]|
            3[68]4[1347]|
            3(?:
              47|
              60
            )[1356]|
            3(?:
              3[46]|
              46|
              5[49]
            )[1246]|
            3[4579]3[1357]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{2,11})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '138',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '3',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{5})(\\d{2,10})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '181',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{5,11})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            1(?:
              3|
              80
            )|
            9
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d)(\\d{4,10})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '1[67]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{7,8})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '8',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{7,12})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '18500',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{5})(\\d{6})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '7',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '18[68]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{7})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '15[0568]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{5})(\\d{6})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '15[1279]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{7})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '18',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{8})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            1(?:
              6[023]|
              7
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{7,8})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '15[279]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{2})(\\d{7})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '15',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{8})'
                }
              ];

my $validators = {
                'fixed_line' => '
          32\\d{9,11}|
          49[3-6]\\d{10}|
          49[0-7]\\d{3,9}|
          (?:
            [34]0|
            [68]9
          )\\d{3,13}|
          (?:
            2(?:
              0[1-689]|
              [1-3569]\\d|
              4[0-8]|
              7[1-7]|
              8[0-7]
            )|
            3(?:
              [3569]\\d|
              4[0-79]|
              7[1-7]|
              8[1-8]
            )|
            4(?:
              1[02-9]|
              [2-48]\\d|
              5[0-6]|
              6[0-8]|
              7[0-79]
            )|
            5(?:
              0[2-8]|
              [124-6]\\d|
              [38][0-8]|
              [79][0-7]
            )|
            6(?:
              0[02-9]|
              [1-358]\\d|
              [47][0-8]|
              6[1-9]
            )|
            7(?:
              0[2-8]|
              1[1-9]|
              [27][0-7]|
              3\\d|
              [4-6][0-8]|
              8[0-5]|
              9[013-7]
            )|
            8(?:
              0[2-9]|
              1[0-79]|
              2\\d|
              3[0-46-9]|
              4[0-6]|
              5[013-9]|
              6[1-8]|
              7[0-8]|
              8[0-24-6]
            )|
            9(?:
              0[6-9]|
              [1-4]\\d|
              [589][0-7]|
              6[0-8]|
              7[0-467]
            )
          )\\d{3,12}
        ',
                'geographic' => '
          32\\d{9,11}|
          49[3-6]\\d{10}|
          49[0-7]\\d{3,9}|
          (?:
            [34]0|
            [68]9
          )\\d{3,13}|
          (?:
            2(?:
              0[1-689]|
              [1-3569]\\d|
              4[0-8]|
              7[1-7]|
              8[0-7]
            )|
            3(?:
              [3569]\\d|
              4[0-79]|
              7[1-7]|
              8[1-8]
            )|
            4(?:
              1[02-9]|
              [2-48]\\d|
              5[0-6]|
              6[0-8]|
              7[0-79]
            )|
            5(?:
              0[2-8]|
              [124-6]\\d|
              [38][0-8]|
              [79][0-7]
            )|
            6(?:
              0[02-9]|
              [1-358]\\d|
              [47][0-8]|
              6[1-9]
            )|
            7(?:
              0[2-8]|
              1[1-9]|
              [27][0-7]|
              3\\d|
              [4-6][0-8]|
              8[0-5]|
              9[013-7]
            )|
            8(?:
              0[2-9]|
              1[0-79]|
              2\\d|
              3[0-46-9]|
              4[0-6]|
              5[013-9]|
              6[1-8]|
              7[0-8]|
              8[0-24-6]
            )|
            9(?:
              0[6-9]|
              [1-4]\\d|
              [589][0-7]|
              6[0-8]|
              7[0-467]
            )
          )\\d{3,12}
        ',
                'mobile' => '
          15[0-25-9]\\d{8}|
          1(?:
            6[023]|
            7\\d
          )\\d{7,8}
        ',
                'pager' => '
          16(?:
            4\\d{1,10}|
            [89]\\d{1,11}
          )
        ',
                'personal_number' => '700\\d{8}',
                'specialrate' => '(
          180\\d{5,11}|
          13(?:
            7[1-6]\\d\\d|
            8
          )\\d{4}
        )|(
          (?:
            137[7-9]|
            900(?:
              [135]|
              9\\d
            )
          )\\d{6}
        )|(
          18(?:
            1\\d{5,11}|
            [2-9]\\d{8}
          )
        )',
                'toll_free' => '800\\d{7,12}',
                'voip' => ''
              };
my %areanames = ();
$areanames{de} = {"496321", "Neustadt\ an\ der\ Weinstraße",
"4934901", "Roßlau\ Elbe",
"499656", "Moosbach\ bei\ Vohenstrauß",
"499567", "Seßlach\-Gemünda",
"496364", "Nußbach\ Pfalz",
"498807", "Dießen\ am\ Ammersee",
"4935248", "Schönfeld\ bei\ Großenhain",
"4936072", "Weißenborn\-Lüderode",
"4938234", "Born\ Darß",
"49221", "Köln",
"498633", "Tüßling",
"495053", "Faßberg\-Müden",
"498170", "Straßlach\-Dingharting",
"495384", "Seesen\-Groß\ Rhüden",
"499242", "Gößweinstein",
"4939976", "Groß\ Bützin",
"4935726", "Groß\ Särchen",
"494684", "Langeneß\ Hallig",
"49911", "Nürnberg",
"4939883", "Groß\ Dölln",
"494483", "Ovelgönne\-Großenmeer",
"498367", "Roßhaupten\ Forggensee",
"492339", "Sprockhövel\-Haßlinghausen",
"494509", "Groß\ Grönau",
"4934493", "Gößnitz\ Thüringen",
"496663", "Steinau\ an\ der\ Straße",
"4935952", "Großröhrsdorf\ OL",
"499636", "Plößberg",
"494497", "Barßel\-Harkebrügge",
"4934445", "Stößen",
"497355", "Hochdorf\ Riß",
"4936949", "Obermaßfeld\-Grimmenthal",
"493647", "Pößneck",
"4936705", "Oberweißbach\ Thüringer\ Wald",
"496252", "Heppenheim\ Bergstraße",
"4939934", "Groß\ Plasten",
"497351", "Biberach\ an\ der\ Riß",
"495064", "Groß\ Düngen",
"4936484", "Knau\ bei\ Pößneck",
"497162", "Süßen",
"4935240", "Tauscha\ bei\ Großenhain",
"4989", "München",
"495827", "Unterlüß",
"4935753", "Großräschen",
"4935938", "Großpostwitz\ OL",
"498536", "Kößlarn",
"499141", "Weißenburg\ in\ Bayern",
"4935841", "Großschönau\ Sachsen",
"492203", "Köln\-Porz",};
$areanames{en} = {"497422", "Schramberg",
"493886", "Gadebusch",
"496332", "Zweibrücken",
"493546", "Lübben\ Spreewald",
"496534", "Mülheim\ Mosel",
"492645", "Vettelschoss",
"497541", "Friedrichshafen",
"4935200", "Arnsdorf\ bei\ Dresden",
"497327", "Dischingen",
"497655", "Feldberg\-Altglashütten",
"496473", "Leun",
"492551", "Steinfurt\-Burgsteinfurt",
"497806", "Bad\ Peterstal\-Griesbach",
"4939264", "Kroppenstedt",
"4933966", "Dranse",
"499174", "Hilpoltstein",
"499359", "Karlstadt\-Wiesenfeld",
"4939221", "Möckern\ bei\ Magdeburg",
"499466", "Stamsried",
"495946", "Georgsdorf",
"495376", "Wesendorf\ Kreis\ Gifhorn",
"496221", "Heidelberg",
"4937341", "Ehrenfriedersdorf",
"497256", "Philippsburg",
"4936702", "Lauscha",
"497175", "Leinzell",
"492246", "Lohmar\ Rheinland",
"495752", "Auetal\-Hattendorf",
"494621", "Schleswig",
"495695", "Twistetal",
"4936335", "Grosswechsungen",
"4934206", "Rötha",
"4938466", "Jürgenshagen",
"498402", "Münchsmünster",
"499654", "Pleystein",
"4936653", "Lehesten\ Thüringer\ Wald",
"497331", "Geislingen\ an\ der\ Steige",
"4937464", "Schöneck\ Vogtland",
"496421", "Marburg",
"496344", "Schwegenheim",
"497777", "Sauldorf",
"497733", "Engen\ Hegau",
"496500", "Waldrach",
"496542", "Bullay",
"496393", "Fischbach\ bei\ Dahn",
"499266", "Mitwitz",
"494153", "Lauenburg\ Elbe",
"4936845", "Gehlberg",
"496237", "Maxdorf",
"497664", "Freiburg\-Tiengen",
"495726", "Wiedensahl",
"497066", "Bad\ Rappenau\-Bonfeld",
"4937421", "Oelsnitz\ Vogtland",
"496109", "Frankfurt\-Bergen\-Enkheim",
"497222", "Rastatt",
"494249", "Bassum\-Nordwohlde",
"492678", "Büchel\ bei\ Cochem",
"49911", "Nuremberg",
"496843", "Gersheim",
"499665", "Königstein\ Oberpfalz",
"4938228", "Dettmannsdorf\-Kölzow",
"494673", "Joldelund",
"494637", "Sterup",
"496583", "Palzem",
"498202", "Althegnenberg",
"496894", "St\ Ingbert",
"498553", "Spiegelau",
"492158", "Grefrath\ bei\ Krefeld",
"4933369", "Oderberg",
"4938227", "Lüdershagen\ bei\ Barth",
"499187", "Altdorf\ bei\ Nürnberg",
"492446", "Heimbach\ Eifel",
"498628", "Kienberg\ Oberbayern",
"4936925", "Marksuhl",
"497148", "Grossbottwar",
"495320", "Torfhaus",
"497456", "Haiterbach",
"4939200", "Gommern",
"497941", "Öhringen",
"498064", "Au\ bei\ Bad\ Aibling",
"497371", "Riedlingen\ Württemberg",
"493946", "Quedlinburg",
"497773", "Bodman\-Ludwigshafen",
"4935264", "Strehla",
"492951", "Büren",
"496397", "Leimen\ Pfalz",
"49651", "Trier",
"499091", "Monheim\ Schwaben",
"498666", "Teisendorf",
"4937438", "Bad\ Brambach",
"496722", "Rüdesheim\ am\ Rhein",
"4934495", "Dobitschen",
"492301", "Holzwickede",
"494861", "Tönning",
"499142", "Treuchtlingen",
"496233", "Frankenthal\ Pfalz",
"4937437", "Bad\ Elster",
"492638", "Waldbreitbach",
"495546", "Scheden",
"496587", "Zerf",
"49465", "Sylt",
"494633", "Satrup",
"499602", "Neustadt\ an\ der\ Waldnaab",
"498265", "Pfaffenhausen\ Schwaben",
"498454", "Karlshuld",
"4936042", "Tonna",
"494839", "Wöhrden\ Dithmarschen",
"4933654", "Fünfeichen",
"494708", "Ringstedt",
"496484", "Beselich",
"495768", "Petershagen\-Heimsen",
"498557", "Mauth",
"493695", "Bad\ Salzungen",
"499183", "Burgthann",
"4933769", "Töpchin",
"492596", "Nordkirchen",
"494764", "Gnarrenburg\-Klenkendorf",
"499228", "Thurnau",
"4938231", "Barth",
"495704", "Petershagen\-Friedewalde",
"495251", "Paderborn",
"496574", "Hasborn",
"496372", "Bruchmühlbach\-Miesau",
"494684", "Langeness\ Hallig",
"493496", "Köthen\ Anhalt",
"496433", "Hadamar",
"496477", "Greifenstein\-Nenderoth",
"493726", "Flöha",
"497323", "Gerstetten",
"498868", "Schwabsoien",
"497721", "Villingen\ im\ Schwarzwald",
"499134", "Neunkirchen\ am\ Brand",
"496085", "Waldsolms",
"4939995", "Nossendorf",
"4933209", "Caputh",
"498380", "Achberg",
"495336", "Semmenstedt",
"499825", "Herrieden",
"4936628", "Zeulenroda",
"496292", "Seckach",
"492836", "Wachtendonk",
"498055", "Halfing",
"4935697", "Bagenz",
"497135", "Brackenheim",
"495451", "Ibbenbüren",
"499428", "Kirchroth",
"494755", "Ihlienworth",
"497824", "Schwanau",
"498303", "Waltenhofen",
"496756", "Winterbach\ Soonwald",
"4936375", "Kindelbrück",
"4936735", "Probstzella",
"496284", "Mudau",
"4935698", "Hornow",
"492162", "Viersen",
"498465", "Kipfenberg",
"498254", "Altomünster",
"4936023", "Horsmar",
"4936076", "Niederorschel",
"498082", "Schwindegg",
"499451", "Schierling",
"496052", "Bad\ Orb",
"498295", "Altenmünster\ Schwaben",
"498538", "Pocking\-Hartkirchen",
"495428", "Melle\-Neuenkirchen",
"494743", "Langen\ bei\ Bremerhaven",
"492133", "Dormagen",
"494971", "Esens",
"498375", "Weitnau",
"494527", "Bosau",
"4939202", "Gross\ Ammensleben",
"494794", "Worpswede\-Ostersode",
"492566", "Legden",
"498043", "Jachenau",
"498094", "Steinhöring",
"496462", "Gladenbach",
"49760", "Oberried\ Breisgau",
"494138", "Betzendorf\ Kreis\ Lüneburg",
"4938454", "Kritzkow",
"4936337", "Schiedungen",
"4936764", "Neuhaus\-Schierschnitz",
"497261", "Sinsheim",
"495825", "Wieren",
"499336", "Bütthard",
"4936338", "Bleicherode",
"4935362", "Schönewalde\ bei\ Herzberg",
"492325", "Wanne\-Eickel",
"492657", "Uersfeld",
"492041", "Bottrop",
"495602", "Hessisch\ Lichtenau",
"4939391", "Lückstedt",
"494662", "Leck",
"498348", "Bidingen",
"497051", "Calw",
"494224", "Gross\ Ippener",
"4936847", "Steinbach\-Hallenberg",
"495228", "Vlotho\-Exter",
"494531", "Bad\ Oldesloe",
"495183", "Lamspringe",
"499704", "Euerdorf",
"4936204", "Stotternheim",
"496329", "Weidenthal\ Pfalz",
"499251", "Münchberg",
"492192", "Hückeswagen",
"498725", "Wurmannsquick",
"4936848", "Wernshausen",
"494923", "Krummhörn\-Pewsum",
"497705", "Wolterdingen\ Schwarzw",
"492928", "Soest\-Ostönnen",
"4933363", "Altenhof\ Kreis\ Barnim",
"4936927", "Unterellen",
"493466", "Artern\ Unstrut",
"497461", "Tuttlingen",
"495509", "Rosdorf\ Kreis\ Göttingen",
"4938225", "Trinwillershagen",
"496262", "Aglasterhausen",
"498131", "Dachau",
"4938784", "Kleinow\ Kreis\ Prignitz",
"492775", "Driedorf",
"496026", "Grossostheim",
"4936928", "Neuenhof\ Thüringen",
"493909", "Klötze\ Altmark",
"495142", "Eschede",
"496624", "Heringen\ Werra",
"499546", "Burgebrach",
"494856", "Kronprinzenkoog",
"495665", "Guxhagen",
"4937435", "Reuth\ bei\ Plauen",
"494605", "Medelby",
"492409", "Stolberg\-Gressenich",
"496068", "Beerfelden",
"4934497", "Langenleuba\-Niederhain",
"495187", "Delligsen",
"498545", "Hofkirchen\ Bayern",
"496681", "Hilders",
"496004", "Lich\-Eberstadt",
"4937606", "Lengenfeld\ Vogtland",
"4935202", "Klingenberg\ Sachsen",
"494927", "Krummhörn\-Loquard",
"498651", "Bad\ Reichenhall",
"4934498", "Rositz",
"496855", "Freisen",
"497762", "Wehr\ Baden",
"494281", "Zeven",
"4933763", "Bestensee",
"495266", "Lemgo\-Kirchheide",
"496458", "Rosenthal\ Hessen",
"4939854", "Kleptow",
"495022", "Wietzen",
"494206", "Stuhr\-Heiligenrode",
"496146", "Hochheim\ am\ Main",
"492735", "Neunkirchen\ Siegerl",
"498171", "Wolfratshausen",
"496205", "Hockenheim",
"499726", "Euerbach",
"4939362", "Grieben\ bei\ Tangerhütte",
"49511", "Hannover",
"496864", "Mettlach",
"4933203", "Kleinmachnow",
"4939997", "Jarmen",
"497682", "Elzach",
"492137", "Neuss\-Norf",
"495056", "Winsen\-Meissendorf",
"494747", "Beverstedt",
"492173", "Langenfeld\ Rheinland",
"498335", "Fellheim",
"494931", "Norden",
"4936625", "Langenwetzendorf",
"494523", "Malente",
"4939998", "Loitz\ bei\ Demmin",
"495654", "Herleshausen",
"496761", "Simmern\ Hunsrück",
"496363", "Niederkirchen",
"492528", "Ennigerloh\-Enniger",
"4938797", "Karstädt\ Kreis\ Prignitz",
"495909", "Wettrup",
"4936029", "Menteroda",
"4936377", "Rastenberg",
"494178", "Radbruch",
"4936737", "Drognitz",
"496405", "Laubach\ Hessen",
"495174", "Lahstedt",
"494406", "Berne",
"495466", "Merzen",
"497643", "Herbolzheim\ Breisgau",
"496258", "Gernsheim",
"492859", "Wesel\-Bislich",
"499376", "Collenberg",
"498123", "Moosinning",
"4935695", "Simmersdorf",
"499946", "Hohenwarth\ bei\ Kötzing",
"494481", "Hatten\-Sandkrug",
"492653", "Kaisersesch",
"494822", "Kellinghusen",
"4936738", "Königsee",
"4936378", "Ostramondra",
"492262", "Wiehl",
"496184", "Langenselbold",
"4939296", "Welsleben",
"496775", "Strüth\ Taunus",
"4933089", "Himmelpfort",
"4938723", "Kladrum",
"492624", "Höhr\-Grenzhausen",
"493863", "Crivitz",
"498379", "Waltenhofen\-Oberdorf",
"497235", "Unterreichenbach\ Kreis\ Calw",
"494776", "Osten\-Altendorf",
"4935751", "Welzow",
"495829", "Wriedel",
"4935025", "Liebstadt",
"4939923", "Priborn",
"4934343", "Regis\-Breitingen",
"4939887", "Gerswalde",
"499234", "Neusorg",
"493364", "Eisenhüttenstadt",
"496192", "Hofheim\ am\ Taunus",
"493562", "Forst\ Lausitz",
"495623", "Edertal",
"498076", "Pfaffing",
"494554", "Wahlstedt",
"494352", "Damp",
"49209", "Gelsenkirchen",
"4936944", "Rentwertshausen",
"496041", "Glauburg",
"4935472", "Schlepzig",
"495962", "Herzlake",
"4938872", "Rehna",
"499977", "Arnschwang",
"499933", "Wallersdorf",
"4935894", "Hähnichen",
"4939888", "Lychen",
"497034", "Ehningen",
"494902", "Jemgum\-Ditzum",
"499347", "Wittighausen",
"499521", "Hassfurt",
"497636", "Münstertal\ Schwarzwald",
"493631", "Nordhausen\ Thüringen",
"497388", "Pfronstetten",
"499442", "Riedenburg",
"498687", "Taching\-Tengling",
"499128", "Feucht",
"499283", "Rehau",
"498020", "Weyarn",
"4937365", "Sayda",
"495151", "Hameln",
"496325", "Lambrecht\ Pfalz",
"497435", "Albstadt\-Laufen",
"496657", "Hofbieber",
"494326", "Wankendorf",
"4939822", "Kratzeburg",
"498165", "Neufahrn\ bei\ Freising",
"4939080", "Kalbe\ Milde",
"497083", "Bad\ Herrenalb",
"492367", "Henrichenburg",
"4934607", "Wettin",
"499872", "Heilsbronn",
"4939059", "Wegenstedt",
"4933601", "Podelzig",
"492462", "Linnich",
"496133", "Oppenheim",
"4934423", "Heuckewalde",
"495671", "Hofgeismar",
"499242", "Gössweinstein",
"497191", "Backnang",
"4933473", "Zechin",
"492779", "Greifenstein\-Beilstein",
"4939773", "Altwarp",
"49861", "Traunstein",
"496566", "Körperich",
"497042", "Vaihingen\ an\ der\ Enz",
"499573", "Staffelstein\ Oberfranken",
"495505", "Hardegsen",
"4933732", "Hennickendorf\ bei\ Luckenwalde",
"497709", "Wutach",
"494257", "Schweringen",
"492052", "Velbert\-Langenberg",
"499434", "Bodenwöhr",
"497838", "Nordrach",
"4934322", "Rosswein",
"498683", "Tittmoning",
"499287", "Selb",
"498549", "Vilshofen\-Pleinting",
"497248", "Marxzell",
"497475", "Burladingen",
"496653", "Burghaun",
"4935843", "Hirschfelde\ bei\ Zittau",
"498102", "Höhenkirchen\-Siegertsbrunn",
"495863", "Zernien",
"492761", "Olpe\ Biggesee",
"499832", "Wassertrüdingen",
"494803", "Pahlen",
"492363", "Datteln",
"4939751", "Penkun",
"4933451", "Heckelberg",
"492405", "Würselen",
"494609", "Eggebek",
"497620", "Schopfheim\-Gersbach",
"495631", "Korbach",
"496173", "Kronberg\ im\ Taunus",
"4939405", "Hötensleben",
"498642", "Übersee",
"49921", "Bayreuth",
"494149", "Fredenbeck",
"492739", "Wilnsdorf",
"497122", "St\ Johann\ Württemberg",
"4933433", "Buckow\ Märkische\ Schweiz",
"496209", "Mörlenbach",
"494954", "Moormerland",
"495308", "Lehre",
"493962", "Penzlin\ bei\ Waren",
"4938488", "Demen",
"492864", "Reken",
"494502", "Lübeck\-Travemünde",
"499533", "Untermerzbach",
"4933332", "Gartz\ Oder",
"495364", "Velpke",
"495562", "Dassel\-Markoldendorf",
"493623", "Friedrichroda",
"499474", "Schmidmühlen",
"494253", "Asendorf\ Kreis\ Diepholz",
"4934722", "Preusslitz",
"499166", "Münchsteinach",
"499921", "Regen",
"496735", "Eppelsheim",
"499075", "Glött",
"492205", "Rösrath",
"4939481", "Hedersleben\ bei\ Aschersleben",
"4938323", "Prohn",
"497395", "Ehingen\-Dächingen",
"493867", "Lübstorf",
"499844", "Obernzenn",
"499382", "Gerolzhofen",
"497275", "Kandel",
"497448", "Seewald",
"4938422", "Neukloster",
"497156", "Ditzingen",
"4939957", "Gielow",
"4935822", "Hagenwerder",
"494736", "Butjadingen\-Tossens",
"498634", "Garching\ an\ der\ Alz",
"492681", "Altenkirchen\ Westerwald",
"494453", "Zetel",
"499274", "Hollfeld",
"497585", "Ostrach",
"4934743", "Ermsleben",
"4934905", "Wörlitz",
"495355", "Frellstedt",
"492606", "Winningen\ Mosel",
"4938758", "Dömitz",
"4935773", "Schleife",
"498036", "Stephanskirchen\ Simssee",
"492855", "Voerde\ Niederrhein",
"495196", "Wietzendorf",
"499741", "Bad\ Brückenau",
"495905", "Beesten",
"49941", "Regensburg",
"499343", "Lauda\-Königshofen",
"496409", "Biebertal",
"494965", "Surwold",
"494330", "Emkendorf",
"498361", "Nesselwang",
"499973", "Furth\ im\ Wald",
"499937", "Oberpöring",
"499394", "Esselbach",
"497676", "Feldberg\ Schwarzwald",
"4933922", "Karwesee",
"493671", "Saalfeld\ Saale",
"4938757", "Neustadt\-Glewe",
"4933234", "Wustermark",
"496158", "Riedstadt",
"499080", "Harburg\ Schwaben",
"496446", "Hohenahr",
"495274", "Nieheim",
"499355", "Frammersbach",
"499627", "Freudenberg\ Oberpfalz",
"498223", "Ichenhausen",
"493537", "Jessen\ Elster",
"493573", "Senftenberg",
"492843", "Rheinberg",
"499905", "Bernried\ Niederbayern",
"4933083", "Schulzendorf\ Kreis\ Oberhavel",
"4933746", "Werbig\ bei\ Jüterbog",
"499196", "Wiesenttal",
"4935726", "Gross\ Särchen",
"492583", "Sassenberg",
"495741", "Lübbecke",
"498732", "Frontenhausen",
"495937", "Geeste\-Gross\ Hesepe",
"495973", "Neuenkirchen\ Kreis\ Steinfurt",
"4934385", "Mutzschen",
"49541", "Osnabrück",
"495592", "Gleichen\-Bremke",
"497853", "Kehl\-Bodersweier",
"494445", "Visbek\ Kreis\ Vechta",
"4938729", "Marnitz",
"4938355", "Züssow",
"492237", "Kerpen\ Rheinland\-Türnich",
"497904", "Ilshofen",
"492273", "Kerpen\-Horrem",
"496707", "Windesheim",
"497570", "Sigmaringen\-Gutenstein",
"4936693", "Crossen\ an\ der\ Elster",
"4934292", "Brandis\ bei\ Wurzen",
"493984", "Prenzlau",
"4935028", "Krippen",
"496678", "Wildeck\-Hönebach",
"494848", "Rantrum",
"495584", "Hattorf\ am\ Harz",
"492421", "Düren",
"495382", "Bad\ Gandersheim",
"495844", "Clenze",
"4939929", "Jabel\ bei\ Waren",
"4938736", "Goldberg",
"4938376", "Zirchow",
"497203", "Walzbachtal",
"492974", "Schmallenberg\-Fredeburg",
"492542", "Gescher",
"492393", "Sundern\-Allendorf",
"4939885", "Jakobshagen",
"497552", "Pfullendorf",
"497354", "Erolzheim",
"4935027", "Weesenstein",
"4937368", "Deutschneudorf",
"499631", "Tirschenreuth",
"496105", "Mörfelden\-Walldorf",
"498271", "Meitingen",
"494245", "Neuenkirchen\ bei\ Bassum",
"494478", "Cappeln\ Oldenburg",
"493521", "Meissen",
"49395", "Neubrandenburg",
"4934605", "Gröbers",
"49521", "Bielefeld",
"493933", "Genthin",
"4935820", "Zodel",
"4935955", "Pulsnitz",
"4939053", "Süplingen",
"498423", "Titting",
"498744", "Gerzen",
"495533", "Bodenwerder",
"494181", "Buchholz\ in\ der\ Nordheide",
"4937367", "Lengefeld\ Erzgebirge",
"499562", "Sonnefeld",
"499364", "Zellingen",
"496246", "Eich\ Rheinhessen",
"495474", "Stemwede\-Dielingen",
"494106", "Quickborn\ Kreis\ Pinneberg",
"4934672", "Rossleben",
"495921", "Nordhorn",
"495166", "Walsrode\-Kirchboitzen",
"4933920", "Walsleben\ bei\ Neuruppin",
"497365", "Essingen\ Württemberg",
"497930", "Boxberg\ Baden",
"497403", "Dunningen",
"496876", "Weiskirchen\ Saar",
"494646", "Mohrkirch",
"4933876", "Buschow",
"498841", "Murnau\ am\ Staffelsee",
"492332", "Gevelsberg",
"498581", "Waldkirchen\ Niederbayern",
"492534", "Münster\-Roxel",
"494875", "Stafstedt",
"496645", "Ulrichstein",
"495832", "Hankensbüttel",
"498506", "Bad\ Höhenstadt",
"492473", "Simmerath",
"49291", "Meschede",
"496551", "Prüm",
"4939779", "Eggesin",
"4933479", "Küstrin\-Kietz",
"4939031", "Dähre",
"499671", "Oberviechtach",
"495242", "Rheda\-Wiedenbrück",
"493592", "Kirschau",
"4936084", "Heuthen",
"498231", "Königsbrunn\ bei\ Augsburg",
"494260", "Visselhövede\-Wittorf",
"496162", "Reinheim\ Odenwald",
"493394", "Wittstock\ Dosse",
"493973", "Pasewalk",
"493937", "Osterburg\ Altmark",
"497746", "Wutöschingen",
"49341", "Leipzig",
"493741", "Plauen",
"4933052", "Leegebruch",
"495573", "Uslar\-Volpriehausen",
"498427", "Wellheim",
"492983", "Winterberg\-Siedlinghausen",
"4939726", "Ducherow",
"499505", "Litzendorf",
"4934632", "Mücheln\ Geiseltal",
"4935936", "Sohland\ Spree",
"495434", "Essen\ Oldenburg",
"498322", "Oberstdorf",
"4938293", "Kühlungsborn\ Ostseebad",
"4936644", "Hirschberg\ Saale",
"497302", "Pfaffenhofen\ an\ der\ Roth",
"497340", "Neenstetten",
"497504", "Horgenzell",
"495283", "Lügde\-Rischenau",
"495128", "Hohenhameln",
"4939408", "Hadmersleben",
"4933708", "Rangsdorf",
"492292", "Windeck\ Sieg",
"496836", "Überherrn",
"499151", "Hersbruck",
"495850", "Neetze",
"493844", "Schwaan",
"493382", "Lehnin",
"492942", "Geseke",
"499867", "Geslau",
"494835", "Albersdorf\ Holstein",
"492574", "Saerbeck",
"492372", "Hemer",
"496660", "Steinau\-Marjoss",
"4933836", "Butzow\ bei\ Brandenburg",
"495872", "Stoetze",
"4939407", "Seehausen\ Börde",
"497952", "Gerabronn",
"492433", "Hückelhoven",
"494124", "Glückstadt",
"497568", "Bad\ Wurzach\-Hauerz",
"4938485", "Dabel",
"4933439", "Fredersdorf\-Vogelsdorf",
"498269", "Unteregg\ bei\ Mindelheim",
"493921", "Burg\ bei\ Magdeburg",
"496596", "Üdersdorf",
"499829", "Flachslanden",
"495234", "Horn\-Bad\ Meinberg",
"497161", "Göppingen",
"4935053", "Glashütte\ Sachsen",
"4934224", "Belgern\ Sachsen",
"4939955", "Jürgenstorf",
"4939820", "Triepkendorf",
"493533", "Elsterwerda",
"49355", "Cottbus",
"4939082", "Mieste",
"492587", "Ennigerloh\-Westkirchen",
"4934261", "Kühren\ bei\ Wurzen",
"4935326", "Schönborn\ Kreis\ Elbe\-Elster",
"499962", "Schwarzach\ Niederbayern",
"495347", "Burgdorf\ bei\ Salzgitter",
"4934785", "Sandersleben",
"495933", "Lathen",
"495977", "Spelle",
"498772", "Mallersdorf\-Pfaffenberg",
"494238", "Neddenaverbergen",
"495521", "Herzberg\ am\ Harz",
"498431", "Neuburg\ an\ der\ Donau",
"492484", "Mechernich\-Eiserfey",
"495442", "Barnstorf\ Kreis\ Diepholz",
"4939976", "Gross\ Bützin",
"498469", "Freystadt\-Burggriesbach",
"496301", "Otterbach\ Pfalz",
"4938755", "Eldena",
"495035", "Gross\ Munzel",
"496703", "Wöllstein\ Rheinhessen",
"492233", "Hürth\ Rheinland",
"4937208", "Auerswalde",
"496386", "Altenkirchen\ Pfalz",
"496638", "Schwalmtal\-Renzendorf",
"494385", "Hohenfelde\ bei\ Kiel",
"4937207", "Hainichen\ Sachsen",
"492934", "Sundern\-Altenhellefeld",
"495483", "Lienen",
"4934907", "Jeber\-Bergfrieden",
"498195", "Weil\ Kreis\ Landsberg\ am\ Lech",
"49251", "Münster",
"497139", "Neuenstadt\ am\ Kocher",
"4936465", "Oberndorf\ bei\ Apolda",
"492722", "Attendorn",
"498404", "Oberdolling",
"497138", "Schwaigern",
"499652", "Waidhaus",
"498507", "Neuburg\ am\ Inn",
"492436", "Wegberg\-Rödgen",
"494758", "Nordleda",
"495754", "Extertal\-Bremke",
"496639", "Ottrau",
"495286", "Ottenstein\ Niedersachsen",
"498468", "Altmannstein\-Pondorf",
"494261", "Rotenburg\ Wümme",
"498230", "Gablingen",
"495201", "Halle\ Westfalen",
"496833", "Rehlingen\-Siersburg",
"494239", "Dörverden\-Westen",
"4937321", "Frankenstein\ Sachsen",
"499172", "Georgensgmünd",
"494107", "Siek\ Kreis\ Stormarn",
"496247", "Worms\-Pfeddersheim",
"495167", "Walsrode\-Westenholz",
"4939241", "Leitzkau",
"496661", "Schlüchtern",
"497527", "Wolfegg",
"492753", "Erndtebrück",
"495851", "Dahlenburg",
"492351", "Lüdenscheid",
"496532", "Zeltingen\-Rachtig",
"493976", "Torgelow\ bei\ Ueckermünde",
"499828", "Rügland",
"497424", "Spaichingen",
"493346", "Seelow",
"497743", "Ühlingen\-Birkendorf",
"496334", "Thaleischweiler\-Fröschen",
"497971", "Gaildorf",
"495685", "Knüllwald",
"4933200", "Bergholz\-Rehbrücke",
"4937364", "Reitzenhain\ Erzgebirge",
"497025", "Neuffen",
"4936703", "Gräfenthal",
"497569", "Isny\-Eisenbach",
"4936945", "Henneberg",
"495401", "Georgsmarienhütte",
"498268", "Tussenhausen",
"4935895", "Klitten",
"495520", "Braunlage",
"494461", "Jever",
"494705", "Wremen",
"495765", "Raddestorf",
"498751", "Mainburg",
"4935024", "Stadt\ Wehlen",
"499225", "Stadtsteinach",
"496706", "Wallhausen\ Nahe",
"492236", "Wesseling\ Rheinland",
"496383", "Glan\-Münchweiler",
"4936606", "Kraftsdorf",
"4933760", "Münchehofe\ Kreis\ Dahme\-Spreewald",
"498204", "Mickhausen",
"495129", "Söhlde",
"496781", "Idar\-Oberstein",
"4936652", "Wurzbach",
"499197", "Egloffstein",
"495936", "Twist",
"497224", "Gernsbach",
"4939209", "Wanzleben",
"4933237", "Paulinenaue",
"497662", "Vogtsburg\ im\ Kaiserstuhl",
"496593", "Hillesheim\ Eifel",
"496447", "Langgöns\-Niederkleen",
"499626", "Hohenburg",
"497531", "Konstanz",
"492635", "Rheinbrohl",
"496544", "Rhaunen",
"4933238", "Senzke",
"496342", "Schweigen\-Rechtenbach",
"494762", "Kutenholz",
"495702", "Petershagen\-Lahde",
"496482", "Runkel",
"496821", "Neunkirchen\ Saar",
"4934904", "Oranienbaum",
"4937204", "Lichtenstein\ Sachsen",
"496387", "Sankt\ Julian",
"499604", "Wernberg\-Köblitz",
"497145", "Markgröningen",
"4936022", "Grossengottern",
"499081", "Nördlingen",
"498452", "Geisenfeld",
"499193", "Höchstadt\ an\ der\ Aisch",
"493685", "Hildburghausen",
"492586", "Beelen",
"495976", "Salzbergen",
"495346", "Liebenburg",
"492501", "Münster\-Hiltrup",
"4935241", "Lommatzsch",
"499144", "Pleinfeld",
"496597", "Jünkerath",
"496724", "Stromberg\ Hunsrück",
"496443", "Ehringshausen\ Dill",
"49631", "Kaiserslautern",
"498062", "Bruckmühl\ Mangfall",
"497571", "Sigmaringen",
"498226", "Bibertal",
"493576", "Weisswasser",
"492675", "Ediger\-Eller",
"494479", "Molbergen\-Peheim",
"498252", "Schrobenhausen",
"496095", "Bessenbach",
"4936043", "Kirchheilingen",
"498503", "Neuhaus\ am\ Inn",
"494180", "Königsmoor",
"496282", "Walldürn",
"492164", "Jüchen\-Otzenrath",
"4939061", "Weferlingen",
"4934691", "Könnern",
"493765", "Reichenbach\ Vogtland",
"4933704", "Baruth\ Mark",
"497822", "Ettenheim",
"494849", "Hooge",
"4939404", "Ausleben",
"496837", "Wallerfangen",
"496873", "Nonnweiler",
"494643", "Gelting\ Angeln",
"4938206", "Graal\-Müritz\ Seeheilbad",
"498426", "Walting\ Kreis\ Eichstätt",
"496550", "Irrhausen",
"495536", "Holzminden\-Neuhaus",
"4936648", "Dittersdorf\ bei\ Schleiz",
"496294", "Krautheim\ Jagst",
"496243", "Monsheim",
"4933093", "Fürstenberg\ Havel",
"494103", "Wedel",
"4936087", "Wüstheuterode",
"499132", "Herzogenaurach",
"4934466", "Janisroda",
"4935209", "Mohorn",
"498802", "Huglfing",
"495163", "Fallingbostel\-Dorfmark",
"4936647", "Saalburg\ Thüringen",
"496159", "Messel",
"497747", "Berau",
"496374", "Weilerbach",
"494682", "Amrum",
"496572", "Manderscheid\ Eifel",
"497931", "Bad\ Mergentheim",
"4936020", "Ebeleben",
"497621", "Lörrach",
"499536", "Kirchlauter",
"4933362", "Liepe\ Kreis\ Barnim",
"492525", "Beckum\-Neubeckum",
"494256", "Hilgermissen",
"495132", "Lehrte",
"499163", "Dachsbach",
"494175", "Egestorf\ Nordheide",
"498141", "Fürstenfeldbruck",
"496408", "Buseck",
"4936741", "Bad\ Blankenburg",
"498092", "Grafing\ bei\ München",
"496255", "Lindenfels",
"496464", "Angelburg",
"498285", "Burtenbach",
"496567", "Oberkail",
"499920", "Bischofsmais",
"494327", "Grossenaspe",
"494806", "Sarzbüttel",
"492366", "Herten\ Westfalen",
"494792", "Worpswede",
"497449", "Baiersbronn\-Obertal",
"494422", "Sande\ Kreis\ Friesl",
"494541", "Ratzeburg",
"494881", "Friedrichstadt",
"496054", "Birstein",
"498686", "Petting",
"498338", "Böhen",
"4934604", "Niemberg",
"496805", "Kleinblittersdorf",
"496656", "Ebersburg",
"498084", "Taufkirchen\ Vils",
"4935954", "Grossharthau",
"495193", "Schneverdingen",
"498766", "Gammelsdorf",
"496622", "Bebra",
"499346", "Grünsfeld",
"499976", "Rötz",
"496264", "Neudenau",
"497673", "Schönau\ im\ Schwarzwald",
"496455", "Frankenau\ Hessen",
"4939884", "Hassleben\ bei\ Prenzlau",
"492182", "Grevenbroich\-Kapellen",
"495144", "Wathlingen",
"4936948", "Römhild",
"494148", "Drochtersen\-Assel",
"4938354", "Wusterhusen",
"492738", "Netphen",
"494456", "Varel\-Altjührden",
"495309", "Lehre\-Wendhausen",
"492603", "Bad\ Ems",
"4935363", "Fermerswalde",
"4936947", "Jüchsen",
"498033", "Oberaudorf",
"4934384", "Grossbothen",
"497153", "Plochingen",
"494608", "Handewitt",
"494331", "Rendsburg",
"494777", "Cadenberge",
"494733", "Butjadingen\-Burhave",
"4936871", "Bad\ Colberg\-Heldburg",
"493425", "Wurzen",
"4937291", "Augustusburg",
"4933235", "Friesack",
"498548", "Vilshofen\-Sandbach",
"497249", "Stutensee",
"496120", "Aarbergen",
"494222", "Ganderkesee",
"495604", "Grossalmerode",
"4939203", "Barleben",
"496858", "Ottweiler\-Fürth",
"492680", "Mündersbach",
"494664", "Neukirchen\ bei\ Niebüll",
"492925", "Warstein\-Allagen",
"496691", "Schwalmstadt",
"497708", "Geisingen\-Leipferdingen",
"497839", "Schapbach",
"495197", "Soltau\-Frielingen",
"499936", "Wallerfing",
"497633", "Staufen\ im\ Breisgau",
"4936464", "Wormstedt",
"492778", "Siegbach",
"4938754", "Leussow\ bei\ Ludwigslust",
"495024", "Rohrsen\ Kreis\ Nienburg\ Weser",
"4936421", "Camburg",
"497764", "Herrischried",
"495626", "Bad\ Zwesten",
"492607", "Kobern\-Gondorf",
"498073", "Gars\ am\ Inn",
"499401", "Neutraubling",
"4933202", "Töplitz",
"497157", "Waldenbuch",
"494371", "Burg\ auf\ Fehmarn",
"494941", "Aurich",
"498345", "Stöttwang",
"494773", "Lamstedt",
"494737", "Stadland\-Schwei",
"499765", "Trappstadt",
"496002", "Ober\-Mörlen",
"495225", "Spenge",
"4939954", "Stavenhagen\ Reuterstadt",
"498728", "Geratskirchen",
"499129", "Wendelstein",
"493866", "Cambs",
"499576", "Lichtenfels\-Isling",
"494824", "Krempe",
"497755", "Weilheim\ Kreis\ Waldshut",
"497389", "Heroldstatt",
"4933762", "Zeuthen",
"495172", "Ilsede",
"494135", "Kirchgellersen",
"492745", "Brachbach\ Sieg",
"4938484", "Ventschow",
"499167", "Oberscheinfeld",
"499851", "Dinkelsbühl",
"496136", "Nieder\-Olm",
"498021", "Waakirchen",
"495828", "Himbergen",
"4939363", "Angern",
"496563", "Kyllburg",
"494323", "Bornhöved",
"494721", "Cuxhaven",
"495652", "Bad\ Sooden\-Allendorf",
"4933984", "Blumenthal\ bei\ Pritzwalk",
"497684", "Glottertal",
"494491", "Friesoythe",
"4937756", "Breitenbrunn\ Erzgebirge",
"4936645", "Mühltroff",
"495425", "Borgholzhausen",
"498535", "Haarbach",
"4936085", "Reinholterode",
"498378", "Buchenberg\ bei\ Kempten",
"499286", "Oberkotzau",
"4935203", "Tharandt",
"499201", "Gesees",
"498650", "Marktschellenberg",
"4934422", "Osterfeld",
"499321", "Kitzingen",
"499444", "Siegenburg",
"499723", "Röthlein",
"496027", "Stockstadt\ am\ Main",
"499493", "Beratzhausen",
"4933472", "Golzow\ bei\ Seelow",
"495358", "Bahrdorf\-Mackendorf",
"4939772", "Rothemühl",
"4936924", "Mihla",
"495964", "Lähden",
"4938788", "Gross\ Warnow",
"492858", "Hünxe",
"497032", "Herrenberg",
"499547", "Zapfendorf",
"4933636", "Steinhöfel\ Kreis\ Oder\-Spree",
"493564", "Schwarze\ Pumpe",
"4936961", "Bad\ Liebenstein",
"495908", "Wietmarschen\-Lohne",
"493362", "Erkner",
"494354", "Fleckeby",
"494179", "Winsen\-Tönnhausen",
"4933733", "Stülpe",
"494552", "Leezen",
"494968", "Neulehe",
"495263", "Barntrup",
"499232", "Wunsiedel",
"494203", "Weyhe\ bei\ Bremen",
"492065", "Duisburg\-Rheinhausen",
"4938787", "Glöwen",
"492529", "Oelde\-Stromberg",
"49981", "Ansbach",
"49208", "Oberhausen\ Rheinland",
"4936844", "Rohr\ Thüringen",
"492208", "Niederkassel",
"499078", "Mertingen",
"496809", "Grossrosseln",
"4939451", "Wasserleben",
"492963", "Brilon\-Messinghausen",
"4936208", "Ermstedt",
"498170", "Strasslach\-Dingharting",
"4939823", "Rechlin",
"497445", "Pfalzgrafenweiler",
"494853", "Sankt\ Michaelisdonn",
"4937465", "Tannenbergsthal\ Vogtland",
"492622", "Bendorf\ am\ Rhein",
"498152", "Herrsching\ am\ Ammersee",
"4936207", "Plaue\ Thüringen",
"492264", "Marienheide",
"492455", "Waldfeucht",
"496182", "Seligenstadt",
"494403", "Bad\ Zwischenahn",
"492054", "Essen\-Kettwig",
"493641", "Jena",
"4938457", "Krakow\ am\ See",
"4939922", "Dambeck\ bei\ Röbel",
"4936334", "Wolkramshausen",
"4934342", "Neukieritzsch",
"497646", "Weisweil\ Breisgau",
"494365", "Heringsdorf\ Holstein",
"499337", "Gaukönigshofen",
"499373", "Amorbach",
"497044", "Mönsheim",
"499943", "Lam\ Oberpfalz",
"495305", "Sickte",
"492656", "Virneburg",
"499771", "Bad\ Neustadt\ an\ der\ Saale",
"496031", "Friedberg\ Hessen",
"4935473", "Neu\ Lübbenau",
"4938458", "Zehna",
"4938873", "Carlow",
"499293", "Berg\ Oberfranken",
"495955", "Esterwegen",
"499244", "Betzenstein",
"4934443", "Teuchern",
"4934299", "Gaschwitz",
"4935601", "Peitz",
"495053", "Fassberg\-Müden",
"494480", "Ovelgönne\-Strückhausen",
"492255", "Euskirchen\-Flamersheim",
"492464", "Aldenhoven\ bei\ Jülich",
"494526", "Ascheberg\ Holstein",
"4938722", "Raduhn",
"492567", "Ahaus\-Alstätte",
"497478", "Hirrlingen",
"499874", "Neuendettelsau",
"497245", "Durmersheim",
"496525", "Irrel",
"497181", "Schorndorf\ Württemberg",
"4939265", "Löderburg",
"492408", "Aachen\-Kornelimünster",
"4936374", "Weissensee",
"4936734", "Leutenberg",
"499472", "Hohenfels\ Oberpfalz",
"494407", "Wardenburg",
"4934742", "Sylda",
"495467", "Voltlage",
"499947", "Neukirchen\ bei\ Hl\ Blut",
"492862", "Südlohn",
"494504", "Ratekau",
"494340", "Achterwehr",
"499377", "Freudenberg\-Boxtal",
"499333", "Sommerhausen",
"494302", "Kirchbarkau",
"4938794", "Cumlosen",
"495564", "Dassel",
"496071", "Dieburg",
"4935772", "Rietschen",
"495362", "Wolfsburg\-Fallersleben",
"498046", "Bad\ Heilbrunn",
"497124", "Trochtelfingen\ Hohenz",
"494952", "Rhauderfehn",
"4935433", "Vetschau",
"495508", "Gleichen\-Rittmarshausen",
"4934973", "Osternienburg",
"493964", "Bredenfelde\ bei\ Strasburg",
"497835", "Zell\ am\ Harmersbach",
"4933923", "Flecken\ Zechlin",
"494746", "Hagen\ bei\ Bremerhaven",
"4938851", "Zarrentin",
"4939994", "Metschow",
"4935451", "Dahme\ Brandenburg",
"4938322", "Richtenberg",
"498104", "Sauerlach",
"497260", "Sinsheim\-Hilsbach",
"499834", "Theilenhofen",
"492563", "Stadtlohn",
"496328", "Elmstein",
"4939050", "Bartensleben",
"498349", "Stötten\ am\ Auerberg",
"498168", "Attenkirchen",
"4938423", "Bad\ Kleinen",
"4933843", "Niemegk",
"4935823", "Ostritz",
"4939089", "Bismark\ Altmark",
"496745", "Gondershausen",
"499392", "Faulbach\ Unterfranken",
"496023", "Alzenau\ in\ Unterfranken",
"499727", "Schonungen\-Marktsteinach",
"4939857", "Drense",
"499497", "Seubersdorf\ in\ der\ Oberpfalz",
"4933432", "Müncheberg",
"499543", "Hirschaid",
"4933676", "Friedland\ bei\ Beeskow",
"497072", "Gomaringen",
"498561", "Pfarrkirchen\ Niederbayern",
"495555", "Moringen\-Fredelsloh",
"4939858", "Bietikow",
"4933333", "Tantow",
"494139", "Hohnstorf\ Elbe",
"4933655", "Grunow\ Kreis\ Oder\-Spree",
"496147", "Trebur",
"495641", "Warburg",
"494207", "Oyten",
"497385", "Gomadingen",
"499272", "Fichtelberg",
"4934494", "Ehrenhain",
"495186", "Salzhemmendorf\-Wallensen",
"4939601", "Friedland",
"495101", "Pattensen",
"499384", "Schwanfeld",
"499842", "Uffenheim",
"4935842", "Oderwitz",
"494161", "Buxtehude",
"4933080", "Marienthal\ Kreis\ Oberhavel",
"494926", "Krummhörn\-Greetsiel",
"4934639", "Wallendorf\ Luppe",
"492691", "Adenau",
"494857", "Barlt",
"495429", "Melle\-Wellingholzhausen",
"4935265", "Glaubitz",
"4938785", "Berge\ bei\ Perleberg",
"499186", "Lauterhofen\ Oberpfalz",
"492593", "Ascheberg\ Westfalen",
"497352", "Ochsenhausen",
"492447", "Dahlem\ bei\ Kall",
"497554", "Heiligenberg\ Baden",
"495842", "Schnega",
"495384", "Seesen\-Gross\ Rhüden",
"495582", "Sankt\ Andreasberg",
"499101", "Langenzenn",
"492972", "Schmallenberg",
"497457", "Rottenburg\-Ergenzingen",
"496635", "Kirtorf",
"499090", "Rain\ Lech",
"494636", "Langballig",
"493874", "Ludwigslust",
"499429", "Rain\ Niederbayern",
"497940", "Künzelsau",
"4938224", "Gresenhorst",
"495594", "Bovenden\-Reyershausen",
"4934776", "Rothenschirmbach",
"496236", "Neuhofen\ Pfalz",
"4936205", "Gräfenroda",
"495250", "Delbrück\ Westfalen",
"4939829", "Blankenförde",
"4939426", "Hessen",
"492383", "Bönen",
"4939006", "Miesterhorst",
"4937467", "Klingenthal\ Sachsen",
"495883", "Lemgow",
"4939052", "Erxleben\ bei\ Haldensleben",
"498734", "Reisbach\ Niederbayern",
"495543", "Staufenberg\ Niedersachsen",
"499555", "Schlüsselfeld\-Aschbach",
"493771", "Aue\ Sachsen",
"493943", "Wernigerode",
"498869", "Kinsau",
"4938320", "Tribsees",
"493337", "Biesenthal\ Brandenburg",
"499267", "Nordhalben",
"494235", "Langwedel\-Etelsen",
"493994", "Malchin",
"4934673", "Heldrungen",
"499641", "Grafenwöhr",
"495272", "Brakel\ Westfalen",
"4937468", "Treuen\ Vogtland",
"498663", "Ruhpolding",
"498306", "Ronsberg",
"496753", "Meisenheim",
"494191", "Kaltenkirchen\ Holstein",
"496351", "Eisenberg\ Pfalz",
"4936692", "Bürgel",
"492532", "Ostbevern",
"4935876", "Weissenberg\ Sachsen",
"4934293", "Naunhof\ bei\ Grimma",
"499229", "Mainleus",
"498381", "Lindenberg\ im\ Allgäu",
"492334", "Hagen\-Hohenlimburg",
"495834", "Wittingen\-Knesebeck",
"498783", "Rohr\ in\ Niederbayern",
"494838", "Tellingstedt",
"497257", "Bruchsal\-Untergrombach",
"497720", "Schwenningen\ am\ Neckar",
"495769", "Steyerberg\-Voigtei",
"497565", "Aichstetten\ Kreis\ Ravensburg",
"492247", "Neunkirchen\-Seelscheid",
"4938455", "Plaaz",
"495060", "Bodenburg",
"49381", "Rostock",
"492661", "Bad\ Marienberg\ Westerwald",
"498591", "Obernzell",
"495472", "Bad\ Essen",
"4933976", "Wutike",
"4939267", "Schneidlingen",
"492639", "Anhausen\ Kreis\ Neuwied",
"494435", "Grossenkneten",
"499467", "Michelsneukirchen",
"495333", "Dettum",
"495377", "Ehra\-Lessien",
"495947", "Laar\ Vechte",
"4934926", "Pretzsch\ Elbe",
"498742", "Velden\ Vils",
"495731", "Bad\ Oeynhausen",
"4939346", "Tucheim",
"499564", "Bad\ Rodach",
"492833", "Kerken",
"4939268", "Egeln",
"4933082", "Menz\ Kreis\ Oberhavel",
"493493", "Bitterfeld",
"496436", "Dornburg\ Hessen",
"497326", "Neresheim",
"493723", "Hohenstein\-Ernstthal",
"497807", "Neuried\ Ortenaukreis",
"493321", "Nauen\ Brandenburg",
"497954", "Kirchberg\ an\ der\ Jagst",
"494122", "Uetersen",
"496220", "Wilhelmsfeld",
"496757", "Becherbach\ bei\ Kirn",
"4934979", "Wulfen\ Sachsen\-Anhalt",
"4935439", "Zinnitz",
"498823", "Mittenwald",
"492993", "Marsberg\-Canstein",
"4935694", "Gosda\ bei\ Klinge",
"492374", "Iserlohn\-Letmathe",
"492159", "Meerbusch\-Osterath",
"492944", "Rietberg\-Mastholte",
"492572", "Emsdetten",
"4933929", "Gühlen\-Glienicke",
"498629", "Palling",
"495874", "Soltendieck",
"497253", "Bad\ Schönborn",
"496648", "Bad\ Salzschlirf",
"4933470", "Lietzen",
"492294", "Morsbach\ Sieg",
"492243", "Eitorf",
"497502", "Wolpertswende",
"497304", "Blaustein\ Württemberg",
"495045", "Springe\-Bennigsen",
"4935829", "Gersdorf\ bei\ Görlitz",
"49871", "Landshut",
"498324", "Hindelang",
"4938301", "Putbus",
"495432", "Löningen",
"4933849", "Wiesenburg\ Mark",
"4938429", "Glasin",
"4936624", "Teichwolframsdorf",
"498441", "Pfaffenhofen\ an\ der\ Ilm",
"496108", "Mühlheim\ am\ Main",
"499463", "Wald\ Oberpfalz",
"494248", "Bassum\-Neubruchhausen",
"494475", "Molbergen",
"4935052", "Kipsdorf\ Kurort",
"495943", "Emlichheim",
"495337", "Kissenbrück",
"495373", "Hillerse\ Kreis\ Gifhorn",
"492873", "Isselburg\-Werth",
"492837", "Weeze",
"4938826", "Dassow",
"4939083", "Messdorf",
"499305", "Estenfeld",
"4939746", "Krackow",
"495771", "Rahden\ Westfalen",
"493883", "Hagenow",
"499955", "Mamming",
"495293", "Paderborn\-Dahl",
"493727", "Mittweida",
"496476", "Mengerskirchen",
"495244", "Rietberg",
"496164", "Reichelsheim\ Odenwald",
"493594", "Bischofswerda",
"497803", "Gengenbach",
"492597", "Senden\ Westfalen",
"49581", "Uelzen",
"492724", "Finnentrop\-Serkenrode",
"492443", "Mechernich",
"4933657", "Steinsdorf\ Brandenburg",
"49231", "Dortmund",
"4934651", "Rossla",
"494845", "Ostenfeld\ Husum",
"492932", "Neheim\-Hüsten",
"497453", "Altensteig\ Württemberg",
"496675", "Breitenbach\ am\ Herzberg",
"493834", "Greifswald",
"496586", "Beuren\ Hochwald",
"496501", "Konz",
"4939855", "Parmen\-Weggun",
"496420", "Lahntal",
"497965", "Ellwangen\-Röhlingen",
"498556", "Haidmühle",
"496155", "Griesheim\ Hessen",
"492482", "Hellenthal",
"495321", "Goslar",
"492821", "Kleve\ Niederrhein",
"496276", "Hesseneck",
"4935267", "Diesbar\-Seusslitz",
"495444", "Wagenfeld",
"495723", "Bad\ Nenndorf",
"497063", "Bad\ Wimpfen",
"492387", "Drensteinfurt\-Walstedde",
"499964", "Stallwang",
"495493", "Neuenkirchen\ Kreis\ Vechta",
"499358", "Gössenheim",
"498774", "Bayerbach\ bei\ Ergoldsbach",
"4934244", "Mockrehna",
"493731", "Freiberg\ Sachsen",
"4933053", "Zehlendorf\ Kreis\ Oberhavel",
"499908", "Schöfweg",
"4937434", "Bobenneukirchen",
"497736", "Tengen",
"493377", "Zossen\ Brandenburg",
"4938720", "Grebbin",
"493947", "Thale",
"4935268", "Stauchitz",
"49335", "Frankfurt\ \(Oder\)",
"496396", "Hinterweidenthal",
"498241", "Buchloe",
"4934633", "Braunsbedra",
"494275", "Ehrenburg",
"499263", "Ludwigsstadt",
"498667", "Seeon\-Seebruck",
"4938292", "Kröpelin",
"494156", "Talkau",
"495232", "Lage\ Lippe",
"495233", "Steinheim\ Westfalen",
"495277", "Höxter\-Fürstenau",
"49391", "Magdeburg",
"493437", "Grimma",
"493473", "Aschersleben\ Sachsen\-Anhalt",
"4939455", "Schierke",
"498856", "Penzberg",
"499262", "Wallenfels",
"4940", "Hamburg",
"493332", "Schwedt\/Oder",
"4938370", "Kröslin",
"499624", "Ensdorf\ Oberpfalz",
"494938", "Hagermarsch",
"4933673", "Weichensdorf",
"495934", "Haren\-Rütenbrock",
"497226", "Bühl\-Sand",
"498571", "Simbach\ am\ Inn",
"494885", "Bergenhusen",
"495492", "Steinfeld\ Oldenburg",
"497062", "Beilstein\ Württemberg",
"4933336", "Passow\ Kreis\ Uckermark",
"494545", "Seedorf\ Lauenburg",
"495722", "Bückeburg",
"4935385", "Annaburg",
"49551", "Göttingen",
"494488", "Westerstede",
"496704", "Langenlonsheim",
"498281", "Thannhausen\ Schwaben",
"492234", "Frechen",
"497907", "Schwäbisch\ Hall\-Sulzdorf",
"498206", "Egling\ an\ der\ Paar",
"493987", "Templin",
"496251", "Bensheim",
"497452", "Nagold",
"492977", "Schmallenberg\-Bödefeld",
"492933", "Sundern\ Sauerland",
"498145", "Mammendorf",
"4936965", "Stadtlengsfeld",
"494171", "Winsen\ Luhe",
"497625", "Zell\ im\ Wiesental",
"497357", "Attenweiler",
"495484", "Lienen\-Kattenvenne",
"492521", "Beckum",
"4934955", "Gossa",
"497802", "Oberkirch\ Baden",
"4939224", "Büden",
"4935605", "Komptendorf",
"495085", "Burgdorf\-Ehlershausen",
"492850", "Rees\-Haldern",
"495292", "Lichtenau\-Atteln",
"4937344", "Crottendorf\ Sachsen",
"493421", "Torgau",
"493542", "Lübbenau\ Spreewald",
"4933870", "Zollchow\ bei\ Rathenow",
"497426", "Gosheim",
"493344", "Bad\ Freienwalde",
"496336", "Dellfeld",
"499367", "Unterpleichfeld",
"4935436", "Laasow\ bei\ Calau",
"492984", "Hallenberg",
"494335", "Hohn\ bei\ Rendsburg",
"492872", "Rhede\ Westfalen",
"495372", "Meinersen",
"495574", "Oberweser",
"496061", "Michelstadt",
"495942", "Uelsen",
"4934976", "Gröbzig",
"499462", "Falkenstein\ Oberpfalz",
"495433", "Badbergen",
"4933926", "Herzberg\ Mark",
"495284", "Schwalenberg",
"499070", "Tapfheim",
"492242", "Hennef\ Sieg",
"497503", "Wilhelmsdorf\ Württemberg",
"4939320", "Schinne",
"493583", "Zittau",
"498178", "Icking",
"493843", "Güstrow",
"496039", "Karben",
"497252", "Bretten",
"499779", "Nordheim\ von\ der\ Rhön",
"496451", "Frankenberg\ Eder",
"4935826", "Königshain\ bei\ Görlitz",
"492573", "Nordwalde",
"498406", "Böhmfeld",
"4938426", "Neuburg\-Steinhausen",
"4933846", "Dippmannsdorf",
"492992", "Marsberg",
"498822", "Oberammergau",
"4939749", "Grambow\ bei\ Pasewalk",
"494288", "Horstedt\ Kreis\ Rotenburg",
"492434", "Wegberg",
"494123", "Barmstedt",
"4935455", "Walddrehna",
"493722", "Limbach\-Oberfrohna",
"4938855", "Lübtheen",
"49351", "Dresden",
"4938308", "Göhren\ Rügen",
"495221", "Herford",
"4933830", "Ziesar",
"494295", "Emtinghausen",
"494945", "Grossefehn\-Timmel",
"496296", "Ahorn\ Baden",
"4938876", "Roggendorf",
"498341", "Kaufbeuren",
"492832", "Kevelaer",
"4935476", "Wittmannsdorf\-Bückchen",
"499363", "Arnstein\ Unterfranken",
"498424", "Nassenfels",
"495534", "Eschershausen\ an\ der\ Lenne",
"498743", "Geisenhausen",
"495332", "Schöppenstedt",
"499761", "Bad\ Königshofen\ im\ Grabfeld",
"4934446", "Grosskorbetha",
"4938307", "Poseritz",
"499405", "Bad\ Abbach",
"49591", "Lingen\ \(Ems\)",
"495437", "Menslage",
"495473", "Ostercappeln",
"4939292", "Biederitz",
"4935930", "Seitschen",
"493847", "Sternberg",
"498138", "Schwabhausen\ bei\ Dachau",
"49221", "Cologne",
"497404", "Epfendorf",
"498782", "Pfeffenhausen",
"4933979", "Wusterhausen\ Dosse",
"492533", "Münster\-Nienberge",
"4939349", "Parey\ Elbe",
"492166", "Mönchengladbach\-Rheydt",
"492921", "Soest",
"496695", "Jesberg",
"494127", "Westerhorn",
"492474", "Nideggen\-Schmidt",
"4934929", "Straach",
"496752", "Kirn\ Nahe",
"496726", "Lorch\ Rheingau",
"498662", "Siegsdorf\ Kreis\ Traunstein",
"493433", "Borna\ Stadt",
"4939605", "Gross\ Nemerow",
"49345", "Halle\ Saale",
"495237", "Augustdorf",
"495273", "Beverungen",
"499205", "Vorbach",
"493372", "Jüterbog",
"498224", "Offingen\ Donau",
"493574", "Lauchhammer",
"495109", "Ronnenberg",
"4933633", "Spreenhagen",
"494169", "Sauensiek",
"494348", "Schönkirchen",
"495542", "Witzenhausen",
"495882", "Gorleben",
"494495", "Friesoythe\-Thüle",
"495344", "Lengede",
"492382", "Ahlen\ Westfalen",
"492844", "Rheinberg\-Orsoy",
"495421", "Dissen\ am\ Teutoburger\ Wald",
"498531", "Pocking",
"492584", "Warendorf\-Milte",
"499146", "Markt\ Berolzheim",
"497854", "Kehl\-Goldscheuer",
"494725", "Helgoland",
"492274", "Elsdorf\ Rheinland",
"497903", "Mainhardt",
"4938234", "Born\ Darss",
"4934658", "Hayn\ Harz",
"499681", "Windischeschenbach",
"497268", "Bad\ Rappenau\-Obergimpern",
"499855", "Dentlein\ am\ Forst",
"499606", "Pfreimd",
"498025", "Miesbach",
"49241", "Aachen",
"497204", "Malsch\-Völkersbach",
"492973", "Eslohe\ Sauerland",
"492937", "Arnsberg\-Oeventrop",
"4939826", "Blankensee\ bei\ Neustrelitz",
"495583", "Braunlage\-Hohegeiss",
"494131", "Lüneburg",
"492741", "Betzdorf",
"4934779", "Abberode",
"495843", "Wustrow\ Wendland",
"497353", "Schwendi",
"492394", "Neuenrade\-Affeln",
"497751", "Waldshut",
"4939009", "Badel",
"492592", "Selm",
"4936201", "Walschleben",
"495681", "Homberg\ Efze",
"4935387", "Seyda",
"497345", "Langenau\ Württemberg",
"496187", "Schöneck",
"497975", "Untergröningen",
"495855", "Nahrendorf",
"498157", "Feldafing",
"494666", "Ladelund",
"492627", "Braubach",
"4939458", "Heudeber",
"495606", "Zierenberg",
"492355", "Schalksmühle",
"4933832", "Rogäsen",
"497728", "Niedereschach",
"496665", "Sinntal\-Altengronau",
"499843", "Burgbernheim",
"492905", "Bestwig\-Ramsbeck",
"4939394", "Hohenberg\-Krusemark",
"494830", "Süderhastedt",
"498861", "Schongau",
"4935388", "Klöden",
"492196", "Wermelskirchen",
"4933679", "Wendisch\ Rietz",
"495068", "Elze\ Leine",
"4939457", "Benneckenstein\ Harz",
"494265", "Fintel",
"494454", "Jade",
"499273", "Bad\ Berneck\ im\ Fichtelgebirge",
"49212", "Solingen",
"495205", "Bielefeld\-Sennestadt",
"493462", "Bad\ Dürrenberg",
"498677", "Burghausen\ Salzach",
"498633", "Tüssling",
"4938781", "Mellen",
"4936967", "Geisa",
"4935343", "Hirschfeld\ bei\ Elsterwerda",
"49611", "Wiesbaden",
"494557", "Blunk",
"498708", "Weihmichl\-Unterneuhausen",
"499344", "Gerchsheim",
"499542", "Schesslitz",
"4933056", "Mühlenbeck\ Kreis\ Oberhavel",
"497073", "Ammerbuch",
"499974", "Traitsching",
"499421", "Straubing",
"4938842", "Lüttenmark",
"498764", "Mauern\ Kreis\ Freising",
"4939722", "Sarnow\ bei\ Anklam",
"495146", "Wietze",
"4934636", "Schafstädt",
"4935932", "Guttau",
"496022", "Obernburg\ am\ Main",
"4936968", "Rossdorf\ Rhön",
"495458", "Hopsten",
"499393", "Rothenfels\ Unterfranken",
"496266", "Hassmersheim",
"496056", "Bad\ Soden\-Salmünster",
"498684", "Fridolfing",
"492631", "Neuwied",
"496654", "Gersfeld\ Rhön",
"4935608", "Gross\ Ossnig",
"498086", "Buchbach\ Oberbayern",
"492308", "Unna\-Hemmerde",
"495808", "Gerdau",
"492958", "Büren\-Harth",
"492562", "Gronau\ Westfalen",
"494804", "Nordhastedt",
"492364", "Haltern\ Westfalen",
"4938332", "Gross\ Bisdorf",
"495864", "Jameln",
"497948", "Öhringen\-Ohrnberg",
"4935607", "Jänschwalde",
"493329", "Stahnsdorf",
"495258", "Salzkotten",
"4933933", "Lindow\ Mark",
"496466", "Dautphetal\-Friedensdorf",
"496785", "Herrstein",
"4936761", "Heubisch",
"496174", "Königstein\ im\ Taunus",
"496359", "Grünstadt",
"499221", "Kulmbach",
"498389", "Weissensberg",
"4939743", "Zerrenthin",
"4939086", "Jävenitz",
"4938823", "Selmsdorf",
"494953", "Bunde",
"495363", "Wolfsburg\-Vorsfelde",
"493624", "Ohrdruf",
"4935322", "Doberlug\-Kirchhain",
"499332", "Marktbreit",
"494303", "Schlesen",
"495761", "Stolzenau",
"492863", "Velen",
"499534", "Burgpreppach",
"495405", "Hasbergen\ Kreis\ Osnabrück",
"4938451", "Hoppenrade\ bei\ Güstrow",
"497021", "Kirchheim\ unter\ Teck",
"499473", "Kallmünz",
"494254", "Eystrup",
"494465", "Friedeburg\ Ostfriesland",
"49991", "Deggendorf",
"4939972", "Walkendorf",
"497575", "Messkirch",
"499284", "Schwarzenbach\ an\ der\ Saale",
"4939387", "Havelberg",
"492671", "Cochem",
"4938305", "Gingst",
"4938858", "Lassahn",
"4934296", "Groitzsch\ bei\ Pegau",
"4935873", "Herrnhut",
"4939388", "Goldbeck\ Altm",
"497084", "Schömberg\ bei\ Neuenbürg",
"492505", "Altenberge\ Westfalen",
"493606", "Heiligenstadt\ Heilbad",
"4938732", "Gallin\ bei\ Lübz",
"4938372", "Usedom",
"493681", "Suhl",
"496428", "Stadtallendorf",
"49906", "Donauwörth",
"495052", "Hermannsburg",
"497141", "Ludwigsburg\ Württemberg",
"4933973", "Zernitz\ bei\ Neustadt\ Dosse",
"496134", "Mainz\-Kastel",
"499085", "Alerheim",
"4934923", "Cobbelsdorf",
"492151", "Krefeld",
"499292", "Konradsreuth",
"494957", "Detern",
"498621", "Trostberg",
"499350", "Eussenheim\-Hundsbach",
"496825", "Illingen\ Saar",
"4939343", "Jerichow",
"494826", "Hohenlockstedt",
"4935722", "Lauta\ bei\ Hoyerswerda",
"495367", "Rühen",
"4933742", "Oehna\ Brandenburg",
"499574", "Marktzeuln",
"499942", "Viechtach",
"492867", "Heiden\ Kreis\ Borken",
"494307", "Raisdorf",
"499372", "Klingenberg\ am\ Main",
"495462", "Ankum",
"4939932", "Malchow\ bei\ Waren",
"494402", "Rastede",
"499433", "Nabburg",
"495329", "Schulenberg\ im\ Oberharz",
"497935", "Schrozberg",
"496183", "Erlensee",
"496228", "Schönau\ Odenwald",
"498153", "Wessling",
"492623", "Ransbach\-Baumbach",
"4939833", "Mirow\ Kreis\ Neustrelitz",
"494852", "Brunsbüttel",
"4939608", "Staven",
"4933872", "Hohennauen",
"499847", "Ergersheim",
"492962", "Olsberg",
"492558", "Horstmar",
"498249", "Ettringen\ Wertach",
"4939607", "Kotelow",
"499484", "Brennberg",
"4934773", "Schwittersdorf",
"494240", "Syke\-Heiligenfelde",
"496142", "Rüsselsheim",
"499277", "Warmensteinach",
"495026", "Steimbke",
"499233", "Arzberg\ Oberfranken",
"494202", "Achim\ bei\ Bremen",
"498637", "Lohkirchen",
"495262", "Extertal",
"494553", "Geschendorf",
"4939003", "Jübar",
"493761", "Werdau\ Sachsen",
"497485", "Empfingen",
"4939423", "Wegeleben",
"495624", "Bad\ Emstal",
"497033", "Weil\ Der\ Stadt",
"4939322", "Tangermünde",
"499492", "Parsberg",
"49951", "Bamberg",
"496509", "Büdlich",
"499722", "Werneck",
"499397", "Wertheim\-Dertingen",
"4939851", "Göritz\ bei\ Prenzlau",
"495528", "Gieboldehausen",
"4937325", "Niederbobritzsch",
"494231", "Verden\ Aller",
"4936783", "Gehren\ Thüringen",
"499645", "Eschenbach\ in\ der\ Oberpfalz",
"499551", "Burgwindheim",
"4939245", "Loburg",
"496669", "Neuhof\-Hauswurz",
"4933604", "Lebus",
"495859", "Thomasburg",
"492359", "Kierspe",
"492174", "Burscheid\ Rheinland",
"499876", "Rohr\ Mittelfranken",
"493928", "Schönebeck\ Elbe",
"495653", "Sontra",
"494524", "Scharbeutz\-Pönitz",
"494322", "Bordesholm",
"4939862", "Schmölln\ bei\ Prenzlau",
"496562", "Speicher",
"496364", "Nussbach\ Pfalz",
"4938203", "Bad\ Doberan",
"499246", "Pegnitz\-Trockau",
"4934463", "Bad\ Kösen",
"499105", "Grosshabersdorf",
"4934362", "Mügeln\ bei\ Oschatz",
"497644", "Kenzingen",
"495137", "Seelze",
"495173", "Uetze",
"492056", "Heiligenhaus",
"496631", "Alsfeld",
"494269", "Ahausen\-Kirchwalsede",
"492654", "Polch",
"496308", "Olsbrücken",
"495209", "Gütersloh\-Friedrichsdorf",
"498124", "Forstern\ Oberbayern",
"497046", "Zaberfeld",
"497130", "Löwenstein\ Württemberg",
"4935754", "Klettwitz",
"4937297", "Thum\ Sachsen",
"492266", "Lindlar",
"496003", "Rosbach\ von\ der\ Höhe",
"494772", "Oberndorf\ Oste",
"4937298", "Oelsnitz\ Erzgebirge",
"4936453", "Mellingen",
"4936878", "Oberland",
"49211", "Düsseldorf",
"498238", "Gessertshausen",
"494431", "Wildeshausen",
"498460", "Berching\-Holnstein",
"497561", "Leutkirch\ im\ Allgäu",
"4935891", "Rothenburg\ OL",
"495409", "Hilter\ am\ Teutoburger\ Wald",
"494356", "Gross\ Wittensee",
"498072", "Haag\ in\ Oberbayern",
"4936941", "Wasungen",
"494469", "Wangerooge",
"496196", "Bad\ Soden\ am\ Taunus",
"499446", "Altmannstein",
"498385", "Hergatz",
"499158", "Offenhausen\ Mittelfranken",
"497632", "Badenweiler",
"494195", "Hartenholm",
"495121", "Hildesheim",
"499820", "Lehrberg",
"496789", "Heimbach\ Nahe",
"496627", "Nentershausen\ Hessen",
"496355", "Albisheim\ Pfrimm",
"495966", "Meppen\-Apeldorn",
"494223", "Ganderkesee\-Bookholzberg",
"494188", "Welle\ Nordheide",
"492509", "Nottuln\-Appelhülsen",
"499951", "Landau\ an\ der\ Isar",
"4935245", "Burkhardswalde\-Munzig",
"4939484", "Harzgerode",
"494732", "Stadland\-Rodenkirchen",
"496007", "Rosbach\-Rodheim",
"495775", "Diepenau",
"495184", "Freden\ Leine",
"4934202", "Delitzsch",
"497579", "Schwenningen\ Baden",
"499638", "Neualbenreuth",
"4936603", "Weida",
"494924", "Moormerland\-Oldersum",
"497152", "Leonberg\ Württemberg",
"4938462", "Baumgarten",
"493528", "Radeberg",
"494471", "Cloppenburg",
"498445", "Gerolsbach",
"499386", "Prosselsheim",
"498032", "Rohrdorf\ Kreis\ Rosenheim",
"495041", "Springe\ Deister",
"492602", "Montabaur",
"496558", "Büdesheim\ Eifel",
"4937600", "Neumark\ Sachsen",
"4936427", "Dornburg\ Saale",
"4933962", "Heiligengrabe",
"497672", "St\ Blasien",
"492183", "Rommerskirchen",
"492228", "Remagen\-Rolandseck",
"499089", "Bissingen\-Unterringingen",
"4936428", "Stadtroda",
"496623", "Rotenburg\ an\ der\ Fulda",
"495192", "Munster",
"494271", "Sulingen",
"498245", "Türkheim\ Wertach",
"4933397", "Wandlitz",
"496867", "Perl",
"493735", "Marienberg\ Sachsen",
"4939754", "Löcknitz\ Vorpom",
"4933454", "Wölsickendorf\/Wollenberg",
"494744", "Loxstedt",
"494423", "Fedderwarden",
"4933398", "Werneuchen",
"495657", "Meissner",
"494793", "Hambergen",
"495325", "Goslar\-Hahnenklee",
"4936482", "Triptis",
"496151", "Darmstadt",
"499836", "Gunzenhausen\-Cronheim",
"497939", "Schrozberg\-Spielbach",
"492825", "Uedem",
"498106", "Vaterstetten",
"496505", "Kordel",
"493966", "Cölpin",
"497126", "Burladingen\-Melchingen",
"497961", "Ellwangen\ Jagst",
"498093", "Glonn\ Kreis\ Ebersberg",
"492428", "Niederzier",
"499162", "Scheinfeld",
"494841", "Husum\ Nordsee",
"495177", "Edemissen\-Abbensen",
"494506", "Stockelsdorf\-Krumbeck",
"492451", "Geilenkirchen",
"4939248", "Dobritz",
"496573", "Gillenfeld",
"494683", "Oldsum",
"497441", "Freudenstadt",
"497522", "Wangen\ im\ Allgäu",
"49771", "Donaueschingen",
"496434", "Bad\ Camberg",
"4937328", "Grossschirma",
"497324", "Herbrechtingen",
"498803", "Peissenberg",
"495162", "Fallingbostel",
"494102", "Ahrensburg",
"499177", "Heideck",
"499133", "Baiersdorf\ Mittelfranken",
"494140", "Estorf\ Kreis\ Stade",
"496242", "Osthofen",
"4939247", "Güterglück",
"4939366", "Kehnert",
"499566", "Meeder",
"4937327", "Rechenberg\-Bienenmühle",
"497629", "Tegernau\ Baden",
"496872", "Losheim\ am\ See",
"494642", "Kappeln\ Schlei",
"4939034", "Fleetmark",
"499748", "Motten",
"497823", "Seelbach\ Schutter",
"498368", "Halblech",
"496128", "Taunusstein",
"496283", "Hardheim\ Odenwald",
"4937602", "Kirchberg\ Sachsen",
"498304", "Wildpoldsried",
"4938209", "Sanitz\ bei\ Rostock",
"498502", "Fürstenzell",
"495836", "Wittingen\-Radenbeck",
"492688", "Kroppach",
"4935206", "Kreischa\ bei\ Dresden",
"499657", "Waldthurn",
"499325", "Kleinlangheim",
"498253", "Pöttmes",
"492336", "Schwelm",
"496347", "Hochstadt\ Pfalz",
"497774", "Eigeltingen",
"498063", "Feldkirchen\-Westerham",
"496400", "Mücke",
"494339", "Christiansholm",
"496442", "Braunfels",
"493996", "Teterow",
"4936459", "Blankenhain\ Thüringen",
"497667", "Breisach\ am\ Rhein",
"496234", "Mutterstadt",
"4933231", "Pausin",
"4937295", "Lugau\ Erzgebirge",
"4936875", "Straufhain\-Streufdorf",
"499192", "Gräfenberg",
"492251", "Euskirchen",
"498453", "Reichertshofen\ Oberbayern",
"499928", "Kirchdorf\ im\ Wald",
"494634", "Husby",
"493876", "Perleberg",
"496897", "Sulzbach\ Saar",
"4937382", "Geringswalde",
"495951", "Werlte",
"496483", "Selters\ Taunus",
"492801", "Xanten",
"494361", "Oldenburg\ in\ Holstein",
"495703", "Hille",
"497556", "Uhldingen\-Mühlhofen",
"498330", "Legau",
"499184", "Deining\ Oberpfalz",
"496035", "Reichelsheim\ Wetterau",
"494763", "Gnarrenburg",
"495301", "Lehre\-Essenrode",
"499775", "Schönau\ an\ der\ Brend",
"492546", "Coesfeld\-Lette",
"497734", "Gailingen",
"49641", "Giessen",
"496343", "Bad\ Bergzabern",
"4935248", "Schönfeld\ bei\ Grossenhain",
"499409", "Pielenhofen",
"496741", "St\ Goar",
"498067", "Tuntenhausen",
"494154", "Trittau",
"496394", "Bundenthal",
"496592", "Daun",
"497663", "Eichstetten",
"496274", "Waldbrunn\ Odenwald",
"4935247", "Zehren\ Sachsen",
"495446", "Rehden",
"495158", "Hemeringen",
"499966", "Wiesenfelden",
"495820", "Suhlendorf",
"4934221", "Schildau\ Gneisenaustadt",
"497831", "Hausach",
"4936072", "Weissenborn\-Lüderode",
"498457", "Vohburg\ an\ der\ Donau",
"496844", "Blieskastel\-Altheim",
"493836", "Wolgast",
"496382", "Lauterecken",
"494674", "Ockholm",
"496584", "Wellen\ Mosel",
"496893", "Saarbrücken\-Ensheim",
"498554", "Schönberg\ Niederbayern",
"498370", "Wiggensbach",
"4936425", "Isserstedt",
"495707", "Petershagen\ Weser",
"499735", "Massbach",
"494767", "Bremervörde\-Bevern",
"4939206", "Eichenbarleben",
"497742", "Klettgau",
"496533", "Morbach\ Hunsrück",
"496166", "Fischbachtal",
"493596", "Neustadt\ in\ Sachsen",
"494499", "Barssel",
"492695", "Insul",
"496474", "Villmar\-Aumenau",
"492752", "Bad\ Laasphe",
"495246", "Verl",
"498807", "Diessen\ am\ Ammersee",
"495105", "Barsinghausen",
"4936081", "Arenshausen",
"492770", "Eschenburg",
"498326", "Fischen\ im\ Allgäu",
"499173", "Thalmässing",
"494165", "Hollenstedt\ Nordheide",
"4933395", "Zerpenschleuse",
"49621", "Mannheim",
"499209", "Emtmannsberg",
"492296", "Reichshof\-Brüchermühle",
"496832", "Beckingen\-Reimsbach",
"493386", "Premnitz",
"499528", "Donnersdorf",
"495645", "Borgentreich\-Borgholz",
"497381", "Münsingen",
"49461", "Flensburg",
"493301", "Oranienburg",
"496048", "Büdingen\-Eckartshausen",
"495551", "Northeim",
"497306", "Vöhringen\ Iller",
"496287", "Limbach\ Baden",
"4936254", "Friedrichswerth",
"498565", "Dietersburg\-Baumgarten",
"498029", "Kreuth\ bei\ Tegernsee",
"499653", "Eslarn",
"498257", "Inchenhofen",
"497557", "Herdwangen\-Schönach",
"492723", "Kirchhundem",
"492444", "Schleiden\-Gemünd",
"495821", "Bad\ Bevensen",
"499120", "Leinburg",
"4935329", "Dollenchen",
"495482", "Tecklenburg",
"4935021", "Königstein\ Sächsische\ Schweiz",
"4938326", "Grimmen",
"492547", "Rosendahl\-Osterwick",
"497454", "Sulz\ am\ Neckar",
"497265", "Angelbachtal",
"498028", "Fischbachau",
"496049", "Kefenrod",
"493877", "Wittenberge",
"4939000", "Beetzendorf",
"49385", "Schwerin",
"492232", "Brühl\ Rheinland",
"499529", "Oberaurach",
"497666", "Denzlingen",
"49531", "Braunschweig",
"495443", "Lemförde",
"495724", "Obernkirchen",
"4934746", "Giersleben",
"493661", "Greiz",
"49281", "Wesel",
"499208", "Bindlach",
"495932", "Haren\ Ems",
"498773", "Neufahrn\ in\ Niederbayern",
"494975", "Westerholt\ Ostfriesland",
"499963", "Konzell",
"495494", "Holdorf\ Niedersachsen",
"493334", "Eberswalde",
"496346", "Annweiler\ am\ Trifels",
"498291", "Zusmarshausen",
"494498", "Saterland\-Ramsloh",
"499622", "Hirschau\ Oberpfalz",
"4935755", "Ortrand",
"499264", "Küps",
"498824", "Oberau\ Loisach",
"492994", "Marsberg\-Westheim",
"492432", "Wassenberg",
"497953", "Blaufelden",
"4939037", "Pretzier",
"492771", "Dillenburg",
"499656", "Moosbach\ bei\ Vohenstrauss",
"498135", "Sulzemoos",
"495837", "Sprakensehl",
"495873", "Eimke",
"492337", "Hagen\-Dahl",
"4935939", "Hochkirch",
"492373", "Menden\ Sauerland",
"499805", "Burgoberbach",
"492943", "Erwitte",
"492293", "Nümbrecht",
"4934920", "Kropstädt",
"4939038", "Henningen",
"497254", "Waghäusel",
"497465", "Emmingen\-Liptingen",
"496698", "Schrecksbach",
"495282", "Schieder\-Schwalenberg",
"492244", "Königswinter\-Oberpleis",
"4933970", "Neustadt\ Dosse",
"497303", "Illertissen",
"498721", "Eggenfelden",
"499255", "Marktleugast",
"499464", "Walderbach",
"498323", "Immenstadt\ im\ Allgäu",
"49340", "Dessau\ Anh",
"499176", "Allersberg",
"4933839", "Wusterwitz",
"492874", "Isselburg",
"494535", "Nahe",
"499567", "Sesslach\-Gemünda",
"4933436", "Prötzel",
"492982", "Medebach",
"4937361", "Neuhausen\ Erzgebirge",
"495572", "Bodenfelde",
"495944", "Hoogstede",
"4933672", "Pfaffendorfb\ Beeskow",
"495159", "Coppenbrügge\-Bisperode",
"495374", "Isenbüttel",
"494298", "Lilienthal",
"4937324", "Reinsberg\ Sachsen",
"494948", "Wiesmoor\-Marcardsmoor",
"497055", "Neuweiler\ Kreis\ Calw",
"495294", "Hövelhof\-Espeln",
"493342", "Neuenhagen\ bei\ Berlin",
"496536", "Kleinich",
"493544", "Luckau\ Brandenburg",
"496163", "Höchst\ im\ Odenwald",
"499408", "Altenthann",
"497804", "Oppenau",
"492045", "Bottrop\-Kirchhellen",
"4939244", "Steutz",
"4933605", "Boossen",
"493447", "Altenburg\ Thüringen",
"4933701", "Grossbeeren",
"496286", "Walldürn\-Rippberg",
"4939329", "Möringen",
"4939401", "Neuwegersleben",
"496754", "Martinstein",
"492472", "Monschau",
"497957", "Kressberg",
"495833", "Brome",
"496201", "Weinheim\ Bergstr",
"498784", "Hohenthann",
"494141", "Stade",
"4936258", "Friemar",
"492947", "Anröchte",
"492377", "Wickede\ Ruhr",
"492333", "Ennepetal",
"4939740", "Nechlin",
"492297", "Wildbergerhütte",
"497402", "Fluorn\-Winzeln",
"497440", "Bad\ Rippoldsau",
"497826", "Schuttertal",
"494285", "Rhade\ bei\ Zeven",
"497307", "Senden\ Iller",
"499929", "Ruhmannsfelden",
"4936257", "Luisenthal\ Thüringen",
"493821", "Ribnitz\-Damgarten",
"498806", "Utting\ am\ Ammersee",
"4934426", "Kayna",
"496851", "St\ Wendel",
"498327", "Rettenberg",
"4939776", "Hintersee",
"498541", "Vilshofen\ Niederbayern",
"499563", "Rödental",
"4933476", "Neuhardenberg",
"492834", "Straelen",
"495334", "Hornburg\ Kreis\ Wolfenbüttel",
"4933632", "Hangelsberg",
"498422", "Dollnstein",
"495532", "Stadtoldendorf",
"494338", "Alt\ Duvenstedt",
"493494", "Wolfen",
"495661", "Melsungen",
"496167", "Modautal",
"495247", "Harsewinkel",
"49331", "Potsdam",
"493443", "Weissenfels\ Sachsen\-Anhalt",
"493724", "Burgstädt",
"4934901", "Rosslau\ Elbe",
"494485", "Elsfleth\-Huntorf",
"492689", "Dierdorf",
"495706", "Porta\ Westfalica",
"4939293", "Dreileben",
"497553", "Salem\ Baden",
"492594", "Dülmen",
"492392", "Werdohl",
"494766", "Basdahl",
"497202", "Karlsbad",
"496129", "Schlangenbad",
"492543", "Billerbeck\ Westfalen",
"497240", "Pfinztal",
"4938726", "Spornitz",
"495383", "Lutter\ am\ Barenberge",
"498456", "Lenting",
"499749", "Oberbach\ Unterfranken",
"496401", "Grünberg\ Hessen",
"498369", "Rückholz",
"496765", "Gemünden\ Hunsrück",
"497628", "Efringen\-Kirchen",
"492272", "Bedburg\ Erft",
"493679", "Neuhaus\ am\ Rennweg",
"496486", "Katzenelnbogen",
"495447", "Lembruch",
"4939926", "Grabowhöfe",
"4938379", "Benz\ Usedom",
"4939485", "Gernrode\ Harz",
"497852", "Willstätt",
"495593", "Bovenden\-Lenglern",
"4934346", "Narsdorf",
"495544", "Reinhardshagen",
"498733", "Mengkofen",
"495300", "Salzgitter\-Üfingen",
"492582", "Everswinkel",
"492384", "Welver",
"498331", "Memmingen",
"492842", "Kamp\-Lintfort",
"494935", "Juist",
"493944", "Blankenburg\ Harz",
"498222", "Burgau\ Schwaben",
"498066", "Bad\ Feilnbach",
"498664", "Chieming",
"4935244", "Krögis",
"496024", "Schöllkrippen",
"499447", "Essing",
"4933932", "Fehrbellin",
"4938351", "Mesekenhagen",
"499544", "Baunach",
"499972", "Waldmünchen",
"499342", "Wertheim",
"4935056", "Altenberg\ Sachsen",
"4939742", "Brüssow\ bei\ Pasewalk",
"498762", "Wartenberg\ Oberbayern",
"496626", "Wildeck\-Obersuhl",
"4938822", "Diedrichshagen\ bei\ Grevesmühlen",
"4935323", "Sonnewalde",
"494357", "Sehestedt\ Eider",
"494625", "Jübek",
"492429", "Hürtgenwald",
"495691", "Bad\ Arolsen",
"494452", "Zetel\-Neuenburg",
"497171", "Schwäbisch\ Gmünd",
"493464", "Sangerhausen",
"4939973", "Altkalen",
"4939881", "Ringenwalde\ bei\ Templin",
"4936874", "Schönbrunn\ bei\ Hildburghaus",
"497938", "Mulfingen\ Jagst",
"4937294", "Grünhainichen",
"499383", "Wiesentheid",
"4934381", "Colditz",
"497651", "Titisee\-Neustadt",
"4938333", "Horst\ bei\ Grimmen",
"492555", "Schöppingen",
"492641", "Bad\ Neuenahr\-Ahrweiler",
"497545", "Immenstaad\ am\ Bodensee",
"492267", "Wipperfürth",
"4936744", "Remda",
"499088", "Mönchsdeggingen",
"495136", "Burgdorf\ Kreis\ Hannover",
"496150", "Weiterstadt",
"494252", "Bruchhausen\-Vilsen",
"493622", "Waltershausen\ Thüringen",
"495563", "Kreiensen",
"4935342", "Mühlberg\ Elbe",
"494503", "Timmendorfer\ Strand",
"499532", "Maroldsweisach",
"499334", "Giebelstadt",
"493963", "Woldegk",
"497123", "Metzingen\ Württemberg",
"4938843", "Bennin",
"4939723", "Krien",
"4939035", "Kuhfelde",
"499661", "Sulzbach\-Rosenberg",
"4935933", "Neschwitz",
"496172", "Bad\ Homburg\ von\ der\ Höhe",
"496559", "Leidenborn",
"4938296", "Rerik\ Ostseebad",
"497578", "Wald\ Hohenz",
"499639", "Mähring",
"4933607", "Briesen\ Mark",
"493529", "Heidenau\ Sachsen",
"494426", "Wangerland\-Horumersiel",
"494796", "Teufelsmoor",
"496670", "Ludwigsau\ Hessen",
"492362", "Dorsten",
"499833", "Heidenheim\ Mittelfranken",
"4935951", "Neukirch\ Lausitz",
"494802", "Wrohm",
"492564", "Vreden",
"4934601", "Teutschenthal",
"495862", "Hitzacker\ Elbe",
"4933833", "Wollin\ bei\ Brandenburg",
"4933608", "Jacobsdorf\ Mark",
"496652", "Hünfeld",
"492508", "Drensteinfurt",
"494189", "Undeloh",
"497335", "Wiesensteig",
"496425", "Rauschenberg\ Hessen",
"498682", "Laufen\ Salzach",
"495464", "Alfhausen",
"495255", "Altenbeken",
"4936255", "Goldbach\ bei\ Gotha",
"4934772", "Helbra",
"494404", "Elsfleth",
"495176", "Edemissen",
"492053", "Velbert\-Neviges",
"496788", "Sien",
"49203", "Duisburg",
"4939002", "Oebisfelde",
"493691", "Eisenach\ Thüringen",
"4939422", "Badersleben",
"4939056", "Klüden",
"499374", "Eschau",
"499572", "Burgkunstadt",
"497043", "Maulbronn",
"499944", "Miltach",
"493967", "Oertzenhof\ bei\ Strasburg",
"499294", "Regnitzlosau",
"4939323", "Schönhausen\ Elbe",
"497127", "Neckartenzlingen",
"4935973", "Stolpen",
"4938481", "Witzin",
"494468", "Friedeburg\-Reepsholt",
"499243", "Pottenstein",
"496132", "Ingelheim\ am\ Rhein",
"494230", "Verden\-Walle",
"498261", "Mindelheim",
"492463", "Titz",
"4933457", "Altreetz",
"498239", "Langenneufnach",
"495054", "Bergen\-Sülze",
"4933394", "Blumberg\ Kreis\ Barnim",
"494865", "Osterhever",
"499873", "Abenberg\-Wassermungenau",
"499837", "Haundorf",
"497082", "Neuenbürg\ Württemberg",
"496630", "Schwalmtal\-Storndorf",
"495656", "Waldkappel",
"492305", "Castrop\-Rauxel",
"495805", "Oetzen",
"4939832", "Wesenberg",
"4933458", "Falkenberg\ Mark",
"492955", "Büren\-Wewelsburg",
"4933873", "Grosswudicke",
"4933981", "Putlitz",
"496866", "Perl\-Nennig",
"497375", "Obermarchtal",
"499282", "Naila",
"497945", "Wüstenrot",
"499443", "Abensberg",
"4933972", "Breddin",
"49931", "Würzburg",
"499724", "Stadtlauringen",
"494268", "Bötersen",
"498461", "Beilngries",
"4936424", "Kahla\ Thüringen",
"495208", "Leopoldshöhe",
"4938751", "Picher",
"4934922", "Mühlanger",
"499932", "Osterhofen",
"494903", "Wymeer",
"4939342", "Gladau",
"498705", "Altfraunhofen",
"495963", "Bawinkel",
"4935723", "Bernsdorf\ OL",
"494353", "Ascheffel",
"4933743", "Blönsdorf",
"4933086", "Grieben\ Kreis\ Oberhavel",
"495622", "Fritzlar",
"493563", "Spremberg",
"494751", "Otterndorf",
"4936461", "Bad\ Sulza",
"494204", "Thedinghausen",
"496144", "Bischofsheim\ bei\ Rüsselsheim",
"4939933", "Vollrathsruhe",
"495264", "Kalletal",
"495455", "Tecklenburg\-Brochterbeck",
"497131", "Heilbronn\ Neckar",
"497348", "Beimerstetten",
"499482", "Wörth\ an\ der\ Donau",
"498051", "Prien\ am\ Chiemsee",
"495858", "Hitzacker\-Wietzetze",
"4935872", "Neusalza\-Spremberg",
"496081", "Usingen",
"492964", "Brilon\-Alme",
"4939951", "Faulenrost",
"492358", "Meinerzhagen\-Valbert",
"4939488", "Güntersberge",
"4934781", "Greifenhagen",
"496668", "Birstein\-Lichenroth",
"494854", "Friedrichskoog",
"497725", "Königsfeld\ im\ Schwarzwald",
"4938373", "Katzow",
"4938733", "Karbow\-Vietlübbe",
"495529", "Rhumspringe",
"495065", "Sibbesse",
"4939487", "Friedrichsbrunn",
"492263", "Engelskirchen",
"494823", "Wilster",
"492652", "Mendig",
"496508", "Hetzerath\ Mosel",
"498122", "Erding",
"497642", "Endingen\ Kaiserstuhl",
"492425", "Nideggen\-Embken",
"499436", "Nittenau",
"496467", "Hatzfeld\ Eder",
"4936331", "Ilfeld",
"496362", "Alsenz",
"495071", "Schwarmstedt",
"496564", "Neuerburg\ Eifel",
"4938391", "Altenkirchen\ Rügen",
"494441", "Vechta",
"498248", "Lamerdingen",
"493603", "Bad\ Langensalza",
"494324", "Brokstedt",
"49471", "Bremerhaven",
"494522", "Plön",
"495745", "Stemwede\-Levern",
"499901", "Hengersberg\ Bayern",
"497683", "Simonswald",
"499351", "Gemünden\ am\ Main",
"4934954", "Roitzsch\ bei\ Bitterfeld",
"4939225", "Altengrabow",
"492150", "Meerbusch\-Lank",
"496057", "Flörsbachtal",
"4935604", "Krieschow",
"495328", "Altenau\ Harz",
"4936452", "Berlstedt",
"496229", "Neckarsteinach",
"4935797", "Schwepnitz",
"4936026", "Struth\ bei\ Mühlhausen",
"492828", "Emmerich\-Elten",
"4938202", "Volkenshagen",
"4937609", "Wolkenburg\ Mulde",
"4936964", "Dermbach\ Rhön",
"496555", "Bleialf",
"498585", "Grainet",
"494871", "Hohenwestedt",
"496641", "Lauterbach\ Hessen",
"495147", "Uetze\-Hänigsen",
"498845", "Bad\ Kohlgrub",
"496267", "Fahrenbach\ Baden",
"497634", "Sulzburg",
"4934462", "Laucha\ Unstrut",
"4934363", "Cavertitz",
"495023", "Liebenau\ Kreis\ Nieburg\ Weser",
"499236", "Nagel",
"492225", "Meckenheim\ Rheinland",
"498074", "Schnaitsee",
"494556", "Ahrensbök\-Gnissau",
"497361", "Aalen",
"493366", "Beeskow",
"497763", "Murg",
"4936921", "Wutha\-Farnroda",
"498395", "Tannheim\ Württemberg",
"496429", "Schweinsberg\ Hessen",
"4936782", "Schmiedefeld\ am\ Rennsteig",
"495925", "Wietmarschen",
"494774", "Hechthausen",
"4935384", "Steinsdorf\ bei\ Jessen",
"4939398", "Gross\ Garz",
"494185", "Marxen\ Auetal",
"4939454", "Elbingerode\ Harz",
"496186", "Grosskrotzenburg",
"4936841", "Schleusingen",
"494667", "Dagebüll",
"499635", "Bärnau",
"4939397", "Geestgottberg",
"494241", "Bassum",
"495607", "Fuldatal",
"493525", "Riesa",
"492626", "Selters\ Westferwald",
"4939863", "Seehausen\ bei\ Prenzlau",
"496101", "Bad\ Vilbel",
"495194", "Bispingen",
"495143", "Winsen\ Aller",
"498860", "Bernbeuren",
"499396", "Urspringen\ bei\ Lohr",
"497674", "Todtmoos",
"496263", "Neckargerach",
"498388", "Hergensweiler",
"495027", "Linsburg",
"499276", "Bischofsgrün",
"499155", "Simmelsdorf",
"498636", "Ampfing",
"495259", "Bad\ Driburg\-Neuenheerse",
"498034", "Brannenburg",
"492604", "Nassau\ Lahn",
"496358", "Kriegsfeld",
"494922", "Borkum",
"497154", "Kornwestheim",
"497949", "Pfedelbach\-Untersteinbach",
"493328", "Teltow",
"499846", "Ipsheim",
"492193", "Dabringhausen",
"499420", "Feldkirchen\ Niederbayern",
"494734", "Stadland\-Seefeld",
"495182", "Gronau\ Leine",
"499099", "Kaisheim",
"4939604", "Wildberg\ bei\ Altentreptow",
"492309", "Waltrop",
"493745", "Falkenstein\ Vogtland",
"4934491", "Schmölln\ Thüringen",
"4936483", "Ziegenrück",
"499675", "Altendorf\ am\ Nabburg",
"494663", "Süderlügum",
"495603", "Gudensberg",
"495366", "Jembke",
"49761", "Freiburg\ im\ Breisgau",
"494827", "Wacken",
"495459", "Hörstel",
"498191", "Landsberg\ am\ Lech",
"492866", "Dorsten\-Rhade",
"499164", "Langenfeld\ Mittelfranken",
"494381", "Lütjenburg",
"4933963", "Wulfersdorf\ bei\ Wittstock",
"4936731", "Unterloquitz",
"4936371", "Schlossvippach",
"498709", "Eching\ Niederbayern",
"495031", "Wunstorf",
"496305", "Hochspeyer",
"492630", "Mülheim\-Kärlich",
"498042", "Lenggries",
"4938791", "Bad\ Wilsnack",
"494956", "Uplengen",
"495525", "Walkenried",
"498435", "Ehekirchen",
"495069", "Nordstemmen",
"499648", "Neustadt\ am\ Kulm",
"497729", "Tennenbronn",
"492132", "Meerbusch\-Büderich",
"494742", "Dorum",
"4939384", "Arendsee\ Altmark",
"4939991", "Daberkow",
"499220", "Kasendorf\-Azendorf",
"496053", "Wächtersbach",
"4938854", "Redefin",
"4934203", "Zwenkau",
"4935454", "Uckro",
"4936602", "Ronneburg\ Thüringen",
"498083", "Isen",
"493925", "Stassfurt",
"497165", "Göppingen\-Hohenstaufen",
"4933206", "Fichtenwalde",
"499525", "Königsberg\ in\ Bayern",
"495648", "Brakel\-Gehrden",
"492536", "Münster\-Albachten",
"498407", "Grossmehring",
"493635", "Kölleda",
"492163", "Schwalmtal\ Niederrhein",
"4937383", "Lunzenau",
"496045", "Gedern",
"498340", "Baisweil",
"498504", "Tittling",
"498302", "Görisried",
"497269", "Sulzfeld\ Baden",
"496874", "Wadern\-Nunkirchen",
"494644", "Karby",
"4935795", "Königsbrück",
"496293", "Schefflenz",
"499366", "Geroldshausen\ Unterfranken",
"4937347", "Bärenstein\ Kreis\ Annaberg",
"497231", "Pforzheim",
"495164", "Hodenhagen",
"496244", "Westhofen\ Rheinhessenen",
"495476", "Ostercappeln\-Venne",
"494104", "Aumühle\ bei\ Hamburg",
"495108", "Gehrden\ Han",
"496432", "Diez",
"4937348", "Oberwiesenthal\ Kurort",
"497322", "Giengen\ an\ der\ Brenz",
"494349", "Dänischenhagen",
"497524", "Bad\ Waldsee",
"494168", "Neu\ Wulmstorf\-Elstorf",
"496771", "St\ Goarshausen",
"496373", "Schönenberg\-Kübelberg",
"496337", "Grossbundenbach",
"497427", "Schömberg\ bei\ Balingen",
"495586", "Wieda",
"495846", "Gartow\ Niedersachsen",
"4937752", "Eibenstock",
"497356", "Schemmerhofen",
"4938221", "Marlow",
"494561", "Neustadt\ in\ Holstein",
"499182", "Velburg",
"497906", "Braunsbach",
"497195", "Winnenden",
"498139", "Röhrmoos",
"493901", "Salzwedel",
"499738", "Rottershausen",
"49681", "Saarbrücken",
"4937603", "Wildenfels",
"496078", "Gross\-Umstadt",
"495675", "Trendelburg",
"498207", "Affing",
"494632", "Steinbergkirche",
"499603", "Floss",
"497227", "Lichtenau\ Baden",
"4939395", "Wanzer",
"4933766", "Teupitz",
"499194", "Ebermannstadt",
"498161", "Freising",
"496232", "Speyer",
"499143", "Pappenheim\ Mittelfranken",
"494539", "Westerau",
"496723", "Oestrich\-Winkel",
"496444", "Bischoffen",
"495276", "Marienmünster",
"496321", "Neustadt\ an\ der\ Weinstrasse",
"497431", "Albstadt\-Ebingen",
"498857", "Benediktbeuern",
"495155", "Emmerthal",
"496887", "Schmelz\ Saar",
"494289", "Kirchtimke",
"499925", "Bayerisch\ Eisenstein",
"498179", "Eurasburg\ an\ der\ Loisach",
"498552", "Grafenau\ Niederbayern",
"499778", "Fladungen",
"498203", "Grossaitingen",
"495635", "Vöhl",
"4934654", "Stolberg\ Harz",
"496582", "Freudenburg",
"499607", "Luhe\-Wildenau",
"4969", "Frankfurt\ am\ Main",
"496384", "Konken",
"496842", "Blieskastel",
"494672", "Langenhorn",
"492520", "Wadersloh\-Diestedde",
"497223", "Bühl\ Baden",
"4937431", "Mehltheuer\ Vogtland",
"4936450", "Kranichfeld",
"492401", "Baesweiler",
"4934241", "Jesewitz",
"4933366", "Chorin",
"499147", "Nennslingen",
"496272", "Hirschhorn\ Neckar",
"492486", "Nettersheim",
"495236", "Blomberg\-Grossenmarpe",
"494152", "Geesthacht",
"493476", "Hettstedt\ Sachsen\-Anhalt",
"496727", "Gensingen",
"496594", "Birresborn",
"496392", "Hauenstein\ Pfalz",
"497471", "Hechingen",
"496543", "Büchenbeuren",
"492129", "Haan\ Rheinland",
"497732", "Radolfzell\ am\ Bodensee",
"493675", "Sonneberg\ Thüringen",
"498403", "Pförring",
"4933969", "Stepenitz",
"495901", "Fürstenau\ bei\ Bramsche",
"499745", "Wildflecken",
"494961", "Papenburg",
"498365", "Wertach",
"494126", "Horst\ Holstein",
"495351", "Helmstedt",
"493501", "Pirna",
"492851", "Rees",
"495753", "Auetal\-Bernsen",
"497506", "Wangen\-Leupolz",
"493586", "Neugersdorf\ Sachsen",
"494489", "Apen",
"492685", "Flammersfeld",
"496834", "Bous",
"497581", "Saulgau",
"4935691", "Bärenklau\ NL",
"497841", "Achern",
"496297", "Ravenstein\ Baden",
"497271", "Wörth\ am\ Rhein",
"495436", "Nortrup",
"4936621", "Elsterberg\ bei\ Plauen",
"492754", "Bad\ Laasphe\-Feudingen",
"4938304", "Garz\ Rügen",
"497391", "Ehingen\ Donau",
"496472", "Weilmünster",
"494939", "Baltrum",
"499071", "Dillingen\ an\ der\ Donau",
"496731", "Alzey",
"497423", "Oberndorf\ am\ Neckar",
"497744", "Stühlingen",
"496333", "Waldfischbach\-Burgalben",
"496051", "Gelnhausen",
"492636", "Burgbrohl",
"493535", "Herzberg\ Elster",
"4939297", "Eickendorf\ Kreis\ Schönebeck",
"492388", "Hamm\-Uentrop",
"499625", "Kastl\ bei\ Amberg",
"494950", "Holtland",
"4935033", "Rosenthal\ Sächsische\ Schweiz",
"499357", "Gräfendorf\ Bayern",
"4935725", "Wittichenau",
"4933745", "Petkus",
"4934386", "Dürrweitzschen\ bei\ Grimma",
"498081", "Dorfen\ Stadt",
"499452", "Langquaid",
"4939298", "Barby\ Elbe",
"494447", "Vechta\-Langförden",
"495935", "Twist\-Schöninghsdorf",
"493378", "Ludwigsfelde",
"496439", "Holzappel",
"494972", "Langeoog",
"499907", "Zenting",
"494544", "Berkenthin",
"497329", "Steinheim\ am\ Albuch",
"494342", "Preetz\ Kreis\ Plön",
"494884", "Schwabstedt",
"4939886", "Milmersdorf",
"496461", "Biedenkopf",
"492235", "Erftstadt",
"4939489", "Strassberg\ Harz",
"495033", "Wunstorf\-Grossenheidorn",
"492598", "Senden\-Ottmarsbocholt",
"4938735", "Plau\ am\ See",
"4938375", "Koserow",
"4934263", "Hohburg",
"495766", "Rehburg\-Loccum",
"498193", "Geltendorf",
"497624", "Grenzach\-Wyhlen",
"494706", "Schiffdorf",
"494892", "Schenefeld\ Mittelholstein",
"495485", "Ladbergen",
"4938356", "Behrenhoff",
"494383", "Grebin",
"497262", "Eppingen",
"4938302", "Sagard",
"498144", "Grafrath",
"497026", "Lenningen",
"492838", "Sonsbeck",
"495686", "Schwarzenborn\ Knüll",
"497052", "Bad\ Liebenzell",
"496239", "Bobenheim\-Roxheim",
"4935975", "Hohnstein",
"499270", "Creussen",
"496107", "Kelsterbach",
"494247", "Affinghausen",
"495601", "Schauenburg",
"495084", "Hambühren",
"4939325", "Vinzelberg",
"498630", "Oberneukirchen",
"494661", "Niebüll",
"499252", "Helmbrechts",
"4934606", "Teicha\ Sachsen\-Anhalt",
"492191", "Remscheid",
"4934652", "Allstedt",
"494532", "Bargteheide",
"4936253", "Georgenthal\ Thüringer\ Wald",
"499503", "Oberhaid\ Oberfranken",
"492985", "Winterberg\-Niedersfeld",
"494334", "Bredenbek\ bei\ Rendsburg",
"4935600", "Döbern\ NL",
"497462", "Immendingen",
"499189", "Berg\ bei\ Neumarkt\ in\ der\ Oberpfalz",
"4933875", "Rhinow",
"495285", "Bad\ Pyrmont\-Kleinenberg",
"497367", "Aalen\-Ebnat",
"496758", "Waldböckelheim",
"499426", "Oberschneiding",
"494639", "Schafflund",
"492435", "Erkelenz\-Lövenich",
"496261", "Mosbach\ Baden",
"495141", "Celle",
"499802", "Ansbach\-Katterbach",
"496647", "Herbstein\-Stockhausen",
"494833", "Wesselburen",
"494877", "Hennstedt\ bei\ Itzehoe",
"49201", "Essen",
"494550", "Bühnsdorf",
"4939033", "Wallstawe",
"4935935", "Kleinwelka",
"4937754", "Zwönitz",
"495378", "Sassenburg\-Platendorf",
"493935", "Tangerhütte",
"494294", "Riede\ Kreis\ Verden",
"495948", "Itterbeck",
"494243", "Twistringen",
"499468", "Zell\ Oberpfalz",
"496103", "Langen\ Hessen",
"4938845", "Kaarssen",
"498670", "Reischach\ Kreis\ Altötting",
"4933986", "Falkenhagen\ Kreis\ Prignitz",
"499404", "Nittendorf",
"497808", "Hohberg\ bei\ Offenburg",
"497739", "Hilzingen",
"498652", "Berchtesgaden",
"494159", "Basthorst",
"496682", "Tann\ Rhön",
"494944", "Wiesmoor",
"495535", "Polle",
"4938850", "Gammelin",
"492620", "Neuhäusel\ Westerwald",
"495021", "Nienburg\ Weser",
"4938486", "Gustävel",
"497761", "Bad\ Säckingen",
"4933835", "Golzow\ bei\ Brandenburg",
"494282", "Sittensen",
"497363", "Lauchheim",
"4939051", "Calvörde",
"496694", "Neukirchen\ Knüll",
"4933609", "Brieskow\-Finkenheerd",
"496589", "Kell\ am\ See",
"496849", "Kirkel",
"492248", "Hennef\-Uckerath",
"494873", "Aukrug",
"494837", "Neuenkirchen\ Dithmarschen",
"499865", "Adelshofen\ Mittelfranken",
"497258", "Oberderdingen\-Flehingen",
"496643", "Herbstein",
"496096", "Wiesen\ Unterfranken",
"492676", "Ulmen",
"498225", "Jettingen\-Scheppach",
"499353", "Karlstadt",
"4939975", "Thürkow",
"4935325", "Rückersdorf\ bei\ Finsterwalde",
"499204", "Plankenfels",
"4939956", "Neukalen",
"499268", "Teuschnitz",
"494724", "Cuxhaven\-Lüdingworth",
"49431", "Kiel",
"494443", "Dinklage",
"493601", "Mühlhausen\ Thüringen",
"497681", "Waldkirch\ Breisgau",
"495345", "Baddeckenstedt",
"4936691", "Eisenberg\ Thüringen",
"494494", "Bösel\ Oldenburg",
"493338", "Bernau\ Brandenburg",
"495975", "Rheine\-Mesum",
"493686", "Eisfeld",
"492585", "Warendorf\-Hoetmar",
"492845", "Neukirchen\-Vluyn",
"499903", "Schöllnach",
"496479", "Waldbrunn\ Westerwald",
"494932", "Norderney",
"499854", "Wittelshofen",
"497458", "Ebhausen",
"497146", "Remseck\ am\ Neckar",
"498024", "Holzkirchen",
"4939600", "Zwiedorf",
"496762", "Kastellaun",
"492448", "Hellenthal\-Rescheid",
"492275", "Kerpen\-Buir",
"495037", "Bad\ Rehburg",
"492156", "Willich\-Anrath",
"495073", "Neustadt\-Esperke",
"494482", "Hatten",
"494821", "Itzehoe",
"492395", "Finnentrop\-Rönkhausen",
"4938756", "Grabow",
"495854", "Bleckede\-Barskamp",
"497393", "Munderkingen",
"4935728", "Uhyst\ Spree",
"492354", "Meinerzhagen",
"4933748", "Treuenbrietzen",
"492552", "Steinfurt\-Borghorst",
"496331", "Pirmasens",
"497542", "Tettnang",
"499073", "Gundelfingen\ an\ der\ Donau",
"497974", "Bühlerzell",
"492203", "Cologne\-Porz",
"494529", "Süsel\-Bujendorf",
"497344", "Blaubeuren",
"496733", "Gau\-Odernheim",
"4935771", "Bad\ Muskau",
"496066", "Michelstadt\-Vielbrunn",
"4933747", "Marzahna",
"496222", "Wiesloch",
"4935727", "Burghammer",
"494120", "Ellerhoop",
"4934741", "Frose",
"4939295", "Zuchau",
"494858", "Sankt\ Margarethen\ Holstein",
"496664", "Sinntal\-Sterbfritz",
"497273", "Hagenbach\ Pfalz",
"497237", "Neulingen\ Enzkreis",
"492904", "Bestwig",
"492853", "Schermbeck",
"495751", "Rinteln",
"4938378", "Heringsdorf\ Seebad",
"4938738", "Karow\ bei\ Lübz",
"494622", "Taarstedt",
"4939382", "Kamern",
"495353", "Königslutter\ am\ Elm",
"499498", "Laaber",
"497583", "Bad\ Schussenried",
"499728", "Wülfershausen\ Unterfranken",
"494264", "Sottrum\ Kreis\ Rotenburg",
"494455", "Jade\-Schweiburg",
"497843", "Renchen",
"495204", "Steinhagen\ Westfalen",
"4938377", "Zinnowitz",
"4938737", "Ganzlin",
"494208", "Grasberg",
"4936604", "Münchenbernsdorf",
"496456", "Haina\ Kloster",
"4938321", "Martensdorf\ bei\ Stralsund",
"494963", "Dörpen",
"499975", "Waldmünchen\-Geigant",
"4939483", "Ballenstedt",
"499345", "Külsheim\ Baden",
"4935026", "Dürrröhrsdorf\-Dittersbach",
"4935452", "Golssen",
"495903", "Emsbüren",
"498765", "Bruckberg\ Niederbayern",
"4938852", "Wittenburg",
"49791", "Schwäbisch\ Hall",
"498851", "Kochel\ am\ See",
"4939328", "Rochau",
"496655", "Neuhof\ Kreis\ Fulda",
"497473", "Mössingen",
"496327", "Neustadt\-Lachen",
"496806", "Heusweiler",
"497534", "Reichenau\ Baden",
"497332", "Lauterstein",
"496422", "Kirchhain",
"498685", "Kirchanschöring",
"496541", "Traben\-Trarbach",
"496881", "Lebach",
"4936259", "Tabarz\ Thüringer\ Wald",
"492403", "Eschweiler\ Rheinland",
"4939327", "Klietz",
"4937366", "Rübenau",
"497221", "Baden\-Baden",
"492365", "Marl",
"494805", "Schafstedt",
"495865", "Gusborn",
"498167", "Zolling",
"498754", "Volkenschwand",
"493907", "Gardelegen",
"499948", "Eschlkam",
"4939753", "Strasburg",
"499378", "Eichenbühl\-Riedern",
"4933878", "Nennhausen",
"496256", "Lampertheim\-Hüttenfeld",
"495468", "Bramsche\-Engter",
"496175", "Friedrichsdorf\ Taunus",
"496784", "Weierbach",
"494408", "Hude\ Oldenburg",
"4935841", "Grossschönau\ Sachsen",
"495404", "Westerkappeln",
"494176", "Marschacht",
"4933877", "Nitzahn",
"494464", "Wittmund\-Carolinensiel",
"494255", "Martfeld",
"495507", "Ebergötzen",
"492526", "Sendenhorst",
"4939602", "Kleeth",
"499535", "Pfarrweisach",
"4938848", "Vellahn",
"496323", "Edenkoben",
"492568", "Heek",
"497477", "Jungingen\ bei\ Hechingen",
"492952", "Rüthen",
"497433", "Balingen",
"4939728", "Medow\ bei\ Anklam",
"4934464", "Freyburg\ Unstrut",
"496721", "Bingen\ am\ Rhein",
"499092", "Wemding",
"494929", "Ihlow\ Kreis\ Aurich",
"4938204", "Broderstorf",
"499285", "Kirchenlamitz",
"497574", "Gammertingen",
"497942", "Neuenstein\ Württemberg",
"4936962", "Vacha",
"4935938", "Grosspostwitz\ OL",
"4939727", "Spantekow",
"495426", "Glandorf",
"498536", "Kösslarn",
"492407", "Herzogenrath\-Kohlscheid",
"4938847", "Boizenburg\ Elbe",
"4939771", "Ueckermünde",
"4939039", "Bonese",
"494862", "Garding",
"492504", "Telgte",
"497085", "Enzklösterle",
"492302", "Witten",
"4935937", "Prischwitz",
"495802", "Wrestedt",
"495840", "Schnackenburg",
"499141", "Weissenburg\ in\ Bayern",
"4938300", "Insel\ Hiddensee",
"4933838", "Päwesin",
"496824", "Ottweiler",
"4933603", "Falkenhagen\ bei\ Seelow",
"499338", "Röttingen\ Unterfranken",
"499084", "Bissingen\ Schwaben",
"496135", "Bodenheim\ Rhein",
"4936784", "Stützerbach",
"494136", "Scharnebeck",
"495252", "Bad\ Lippspringe",
"4933837", "Brielow",
"495503", "Nörten\-Hardenberg",
"4939452", "Ilsenburg",
"4939406", "Harbke",
"499575", "Weismain",
"494563", "Scharbeutz\-Haffkrug",
"493865", "Holthusen",
"497722", "Triberg\ im\ Schwarzwald",
"494749", "Schiffdorf\-Geestenseth",
"49751", "Ravensburg",
"496371", "Landstuhl",
"495062", "Holle\ bei\ Hildesheim",
"4939978", "Gross\ Roge",
"496737", "Köngernheim",
"496773", "Kamp\-Bornhofen",
"497934", "Weikersheim",
"492207", "Kürten\-Dürscheid",
"499077", "Bachhagel",
"495226", "Bruchmühlen\ Westfalen",
"499766", "Grosswenkheim",
"496291", "Adelsheim",
"498346", "Pforzen",
"4935327", "Priessen",
"4939977", "Jördenstorf",
"4934341", "Geithain",
"4939921", "Ankershagen",
"497277", "Wörth\-Büchelberg",
"497233", "Niefern\-Öschelbronn",
"497484", "Simmersfeld",
"4935753", "Grossräschen",
"492857", "Rees\-Mehr",
"499548", "Mühlhausen\ Mittelfranken",
"495625", "Naumburg\ Hessen",
"495357", "Grasleben",
"496028", "Sulzbach\ am\ Main",
"497587", "Hosskirch",
"495452", "Mettingen\ Westfalen",
"4937206", "Frankenberg\ Sachsen",
"4936454", "Magdala",
"4938721", "Ziegendorf",
"499360", "Thüngen",
"499935", "Stephansposching",
"494967", "Rhauderfehn\-Burlage",
"492161", "Mönchengladbach",
"4934906", "Raguhn",
"4935602", "Drebkau",
"498702", "Wörth\ an\ der\ Isar",
"495907", "Geeste",
"4934924", "Zahna",
"493774", "Schwarzenberg",
"4939344", "Güsen",
"4933968", "Meyenburg\ Kreis\ Prignitz",
"4936422", "Reinstädt\ Thüringen",
"498450", "Ingolstadt\-Zuchering",
"493991", "Waren\ Müritz",
"496526", "Bollendorf",
"4933974", "Dessow",
"499644", "Pressath",
"497246", "Malsch\ Kreis\ Karlsruhe",
"4933967", "Freyenstein",
"494525", "Ahrensbök",
"4936075", "Dingelstädt\ Eichsfeld",
"492256", "Mechernich\-Satzvey",
"495742", "Preussisch\ Oldendorf",
"498377", "Unterthingau",
"498333", "Babenhausen\ Schwaben",
"492175", "Leichlingen\ Rheinland",
"498731", "Dingolfing",
"496403", "Linden\ Hessen",
"4935874", "Bernstadt\ an\ der\ Eigen",
"4934208", "Löbnitz\ bei\ Delitzsch",
"493871", "Parchim",
"499349", "Werbach\-Wenkheim",
"4937320", "Mulda\ Sachsen",
"495956", "Rastdorf",
"4934207", "Zwochau",
"495306", "Cremlingen",
"492655", "Weibern",
"492327", "Bochum\-Wattenscheid",
"495827", "Unterlüss",
"494366", "Grömitz\-Cismar",
"497551", "Überlingen\ Bodensee",
"497645", "Freiamt",
"495381", "Seesen",
"499104", "Emskirchen",
"492422", "Kreuzau",
"492541", "Coesfeld",
"4933201", "Gross\ Glienicke",
"492369", "Dorsten\-Wulfen",
"4939424", "Schwanebeck\ Sachsen\-Anhalt",
"4939004", "Köckte\ bei\ Gardelegen",
"492456", "Selfkant",
"494603", "Havetoft",
"499632", "Waldsassen",
"497158", "Neuhausen\ auf\ den\ Fildern",
"493441", "Zeitz",
"4934774", "Röblingen\ am\ See",
"495663", "Spangenberg",
"493522", "Grossenhain\ Sachsen",
"49371", "Chemnitz\ Sachsen",
"497446", "Lossburg",
"498272", "Wertingen",
"496853", "Marpingen",
"498392", "Markt\ Rettenbach",
"498250", "Hilgertshausen\-Tandern",
"498727", "Falkenberg\ Niederbayern",
"495922", "Bad\ Bentheim",
"496659", "Eichenzell",
"494182", "Tostedt",
"498543", "Aidenbach",
"495734", "Bergkirchen\ Westfalen",
"499561", "Coburg",
"493629", "Stadtilm",
"492066", "Duisburg\-Homberg",
"492222", "Bornheim\ Rheinland",
"497707", "Bräunlingen",
"495198", "Schneverdingen\-Wintermoor",
"492664", "Rennerod",
"498038", "Vogtareuth",
"494194", "Sievershütten",
"496552", "Olzheim",
"4938226", "Dierhagen\ Ostseebad",
"492608", "Welschneudorf",
"498582", "Röhrnbach",
"4989", "Munich",
"498384", "Röthenbach\ Allgäu",
"492331", "Hagen\ Westfalen",
"495831", "Wittingen",
"496203", "Ladenburg",
"492777", "Breitscheid\ Hessen",
"492733", "Hilchenbach",
"494143", "Drochtersen",
"494778", "Wingst",
"499672", "Neunburg\ vorm\ Wald",
"495241", "Gütersloh",
"494607", "Janneby",
"4937605", "Hartenstein\ Sachsen",
"498232", "Schwabmünchen",
"496161", "Brensbach",
"493591", "Bautzen",
"4936742", "Uhlstädt",
"494925", "Hinte",
"499289", "Schwarzenbach\ am\ Wald",
"498321", "Sonthofen",
"496857", "Namborn",
"498444", "Schweitenkirchen",
"498723", "Arnstorf",
"4937436", "Weischlitz",
"4933361", "Joachimsthal",
"495185", "Duingen",
"498547", "Osterhofen\-Gergweis",
"495774", "Wagenfeld\-Ströhen",
"497386", "Hayingen",
"492291", "Waldbröl",
"493381", "Brandenburg\ an\ der\ Havel",
"499152", "Hartenstein\ Mittelfranken",
"4935240", "Tauscha\ bei\ Grossenhain",
"493306", "Gransee",
"497703", "Bonndorf\ im\ Schwarzwald",
"495556", "Lindau\ Harz",
"497951", "Crailsheim",
"49881", "Weilheim\ in\ Oberbayern",
"496139", "Budenheim",
"492371", "Iserlohn",
"492941", "Lippstadt",
"492737", "Netphen\-Deuz",
"492773", "Haiger",
"4939393", "Werben\ Elbe",
"496207", "Wald\-Michelbach",
"499170", "Schwanstetten",
"496746", "Pfalzfeld",
"498293", "Welden\ bei\ Augsburg",
"4938824", "Mallentin",
"4939744", "Rothenklempenow",
"497162", "Süssen",
"4936626", "Auma",
"494328", "Rickling",
"493663", "Schleiz",
"495522", "Osterode\ am\ Harz",
"498432", "Burgheim",
"49571", "Minden\ Westfalen",
"495324", "Vienenburg",
"492824", "Kalkar",
"495441", "Diepholz",
"499961", "Mitterfels",
"498337", "Altenstadt\ Iller",
"498373", "Altusried",
"499126", "Eckental",
"493869", "Dümmer",
"498771", "Ergoldsbach",
"494745", "Bad\ Bederkesa",
"493831", "Stralsund",
"4935696", "Briesnig",
"496407", "Rabenau\ Hessen",
"497836", "Schiltach",
"496504", "Thalfang",
"496340", "Wörth\-Schaidt",
"496302", "Winnweiler",
"4937292", "Oederan",
"498045", "Lenggries\-Fall",
"496568", "Wolsfeld",
"492323", "Herne",
"492721", "Lennestadt",
"4937349", "Scheibenberg",
"495823", "Bienenbüttel",
"4935793", "Elstra",
"497660", "St\ Peter\ Schwarzwald",
"495939", "Sustrum",
"4936021", "Schlotheim",
"497657", "Eisenbach\ Hochschwarzwald",
"496435", "Wallmerod",
"497325", "Sontheim\ an\ der\ Brenz",
"4936077", "Grossbodungen",
"492261", "Gummersbach",
"4933965", "Herzsprung\ bei\ Wittstock",
"492647", "Kesseling",
"498053", "Bad\ Endorf",
"497748", "Grafenhausen\ Hochschwarzwald",
"499823", "Leutershausen",
"492758", "Bad\ Berleburg\-Girkhausen",
"496083", "Weilrod",
"493561", "Guben",
"494753", "Balje",
"49214", "Leverkusen",
"497566", "Argenbühl",
"494351", "Eckernförde",
"497133", "Lauffen\ am\ Neckar",
"4936336", "Klettenberg",
"4934205", "Markranstädt",
"496838", "Saarwellingen",
"49971", "Bad\ Kissingen",
"499324", "Dettelbach",
"499522", "Eltmann",
"496709", "Fürfeld\ Kreis\ Bad\ Kreuznach",
"499441", "Kelheim",
"4935242", "Nossen",
"498463", "Greding",
"493632", "Sondershausen",
"495126", "Algermissen",
"495961", "Haselünne",
"496042", "Büdingen\ Hessen",
"495152", "Hessisch\ Oldendorf",
"494236", "Kirchlinteln",
"497775", "Mühlingen",
"497184", "Kaisersbach",
"4936846", "Suhl\-Dietzhausen",
"4938233", "Prerow\ Ostseebad",
"499556", "Geiselwind",
"4934692", "Alsleben\ Saale",
"4939062", "Bebertal",
"492461", "Jülich",
"496235", "Schifferstadt",
"499871", "Windsbach",
"4936926", "Creuzburg",
"497192", "Murrhardt",
"4933634", "Berkenbrück\ Kreis\ Oder\-Spree",
"495672", "Bad\ Karlshafen",
"499241", "Pegnitz",
"498263", "Breitenbrunn\ Schwaben",
"494635", "Sörup",
"492051", "Velbert",
"496636", "Romrod",
"495650", "Cornberg",
"493644", "Apolda",
"4936870", "Masserberg",
"497041", "Mühlacker",
"499774", "Oberelsbach",
"493693", "Meiningen",
"499185", "Mühlhausen\ Oberpfalz",
"496034", "Wöllstadt",
"494155", "Büchen",
"4937608", "Waldenburg\ Sachsen",
"494276", "Borstel\ bei\ Sulingen",
"496395", "Münchweiler\ an\ der\ Rodalb",
"4934496", "Nöbdenitz",
"497735", "Öhningen",
"499198", "Heiligenstadt\ in\ Oberfranken",
"4937607", "Ebersbrunn\ Sachsen",
"492762", "Wenden\ Südsauerland",
"496275", "Rothenberg\ Odenwald",
"495130", "Wedemark",
"499831", "Gunzenhausen",
"497121", "Reutlingen",
"498555", "Perlesreut",
"497966", "Unterschneidheim",
"4937423", "Adorf\ Vogtland",
"4933674", "Trebatsch",
"499869", "Wettringen\ Mittelfranken",
"493961", "Altentreptow",
"498267", "Dirlewang",
"4939399", "Kleinau",
"495632", "Willingen\ Upland",
"498641", "Grassau\ Kreis\ Traunstein",
"496585", "Ralingen",
"499663", "Neukirchen\ bei\ Sulzbach\-Rosenberg",
"494846", "Hattstedt",
"496676", "Hohenroda\ Hessen",
"4939242", "Prödel",
"499922", "Zwiesel",
"494501", "Kastorf\ Holstein",
"4937322", "Brand\-Erbisdorf",
"495561", "Einbeck",
"496074", "Rödermark",
"499734", "Burkardroth",
"492694", "Wershofen",
"4936651", "Lobenstein",
"495168", "Walsrode\-Stellichte",
"494108", "Rosengarten\ Kreis\ Harburg",
"496475", "Weilmünster\-Wolfenhausen",
"497653", "Lenzkirch",
"4939996", "Törpin",
"499956", "Eichendorf\-Aufhausen",
"492643", "Altenahr",
"499306", "Kist",
"498057", "Aschau\-Sachrang",
"496620", "Philippsthal\ Werra",
"499827", "Lichtenau\ Mittelfranken",
"499381", "Volkach",
"496087", "Waldems",
"497528", "Neukirch\ bei\ Tettnang",
"494164", "Harsefeld",
"4937343", "Jöhstadt",
"496122", "Hofheim\-Wallau",
"495693", "Volkmarsen",
"494757", "Wanna",
"4938796", "Viesecke",
"497173", "Heubach",
"4936376", "Straussfurt",
"4936736", "Arnsgereuth",
"492682", "Hamm\ Sieg",
"4939223", "Theessen",
"495644", "Willebadessen\-Peckelsheim",
"493672", "Rudolstadt",
"498467", "Kinding",
"49202", "Wuppertal",
"492103", "Hilden",
"499742", "Kalbach\ Rhön",
"498362", "Füssen",
"498564", "Johanniskirchen",
"494843", "Viöl",
"497455", "Dornhan",
"496673", "Haunetal",
"497264", "Bad\ Rappenau",
"496637", "Feldatal",
"495131", "Garbsen",
"498142", "Olching",
"497622", "Schopfheim",
"4933637", "Beerfelde",
"492445", "Schleiden\ Eifel",
"4933051", "Nassenheide",
"497963", "Adelmannsfelden",
"4933638", "Rüdersdorf\ bei\ Berlin",
"498091", "Kirchseeon",
"499666", "Illschwang",
"498509", "Ruderting",
"493578", "Kamenz",
"494421", "Wilhelmshaven",
"497529", "Waldburg\ Württemberg",
"495495", "Vörden\ Kreis\ Vechta",
"494882", "Lunden",
"494344", "Schönberg\ Holstein",
"494974", "Neuharlingersiel",
"494542", "Mölln\ Lauenburg",
"494393", "Boostedt",
"495725", "Lindhorst\ bei\ Stadthagen",
"494791", "Osterholz\-Scharmbeck",
"4939005", "Kusey",
"498640", "Reit\ Im\ Winkl",
"4939425", "Dingelstedt\ am\ Huy",
"494273", "Kirchdorf\ bei\ Sulingen",
"494237", "Bendingbostel",
"499265", "Pressig",
"499454", "Aufhausen\ Oberpfalz",
"4934653", "Rottleberode",
"4936252", "Tambach\-Dietharz",
"4934775", "Wippra",
"493335", "Finowfurt",
"495978", "Hörstel\-Dreierwalde",
"492588", "Harsewinkel\-Greffen",
"494109", "Tangstedt\ Bz\ Hamburg",
"4936206", "Grossfahner",
"496249", "Guntersblum",
"498134", "Odelzhausen",
"492181", "Grevenbroich",
"499804", "Aurach",
"4938456", "Langhagen\ bei\ Güstrow",
"496621", "Bad\ Hersfeld",
"4938859", "Alt\ Zachun",
"495127", "Harsum",
"498825", "Krün",
"4934262", "Falkenhain\ bei\ Wurzen",
"4939081", "Kakerbeck\ Sachsen\-Anhalt",
"495043", "Lauenau",
"495696", "Bad\ Arolsen\-Landau",
"4935875", "Obercunnersdorf\ bei\ Löbau",
"4939389", "Schollene",
"492245", "Much",
"497567", "Leutkirch\-Friesenhofen",
"4936766", "Schalkau",
"497176", "Spraitbach",
"499868", "Schillingsfürst",
"497255", "Graben\-Neudorf",
"497464", "Talheim\ Kreis\ Tuttlingen",
"4938303", "Sellin\ Ostseebad",
"499303", "Eibelstadt",
"494332", "Hamdorf\ bei\ Rendsburg",
"494534", "Steinburg\ Kreis\ Storman",
"496449", "Ehringshausen\-Katzenfurt",
"499701", "Sandberg\ Unterfranken",
"495375", "Müden\ Aller",
"495945", "Wilsum",
"4935032", "Langenhennersdorf",
"499254", "Gefrees",
"499465", "Neukirchen\-Balbini",
"494473", "Emstek",
"4936074", "Worbis",
"49491", "Leer\ Ostfriesland",
"4930", "Berlin",
"4934925", "Bad\ Schmiedeberg",
"497805", "Appenweier",
"499199", "Kunreuth",
"495082", "Langlingen",
"4939345", "Parchen",
"497656", "Schluchsee",
"4933975", "Dannenwalde\ Kreis\ Prignitz",
"495295", "Lichtenau\ Westfalen",
"499953", "Pilsting",
"497054", "Wildberg\ Württemberg",
"494221", "Delmenhorst",
"492646", "Königsfeld\ Eifel",
"498785", "Rottenburg\-Oberroning",
"498466", "Denkendorf\ Oberbayern",
"495123", "Schellerten",
"4935609", "Drachhausen",
"496692", "Neustadt\ Hessen",
"496755", "Odernheim\ am\ Glan",
"494756", "Odisheim",
"497563", "Kisslegg",
"494284", "Selsingen",
"497136", "Bad\ Friedrichshall",
"494942", "Südbrookmerland",
"498056", "Eggstätt",
"4937384", "Wechselburg",
"492835", "Issum",
"494372", "Westfehmarn",
"499307", "Altertheim",
"496684", "Hofbieber\-Schwarzbach",
"499826", "Weidenbach\ Mittelfranken",
"495335", "Schladen",
"496599", "Weidenbach\ bei\ Gerolstein",
"494477", "Lastrup\-Hemmelte",
"494433", "Dötlingen",
"499402", "Regenstauf",
"498654", "Freilassing",
"496086", "Grävenwiesbach",
"4939745", "Hetzdorf\ bei\ Strasburg",
"493725", "Zschopau",
"4938825", "Klütz",
"4934291", "Borsdorf",
"496190", "Hattersheim\ am\ Main",
"494292", "Ritterhude",
"495171", "Peine",
"496633", "Homberg\ Ohm",
"496677", "Neuenstein\ Hessen",
"494847", "Oster\-Ohrstedt",
"4939856", "Beenz\ bei\ Prenzlau",
"4934671", "Bad\ Frankenhausen\ Kyffhäuser",
"4933677", "Glienicke\ bei\ Beeskow",
"492238", "Pulheim",
"496708", "Bad\ Münster\ am\ Stein\-Ebernburg",
"494484", "Hude\-Wüsting",
"4939459", "Hasselfelde",
"492595", "Olfen",
"49811", "Hallbergmoos",
"497967", "Jagstzell",
"496764", "Rheinböllen",
"4935389", "Holzdorf\ Elster",
"499852", "Feuchtwangen",
"4933678", "Storkow\ Mark",
"498266", "Kirchheim\ in\ Schwaben",
"498022", "Tegernsee",
"4939032", "Mahlsdorf\ bei\ Salzwedel",
"495545", "Hedemünden",
"494492", "Saterland",
"492385", "Hamm\-Rhynern",
"494934", "Marienhafe",
"499628", "Ursensollen",
"492759", "Bad\ Berleburg\-Aue",
"49451", "Lübeck",
"496157", "Pfungstadt",
"494722", "Cuxhaven\-Altenbruch",
"495651", "Eschwege",
"498665", "Inzell",
"496861", "Merzig",
"499202", "Waischenfeld",
"494233", "Blender",
"494277", "Schwaförden",
"4936969", "Merkers",
"493375", "Königs\ Wusterhausen",
"499553", "Ebrach\ Oberfranken",
"4937604", "Mosel",
"499545", "Buttenheim",
"4933452", "Neulewin",
"4939752", "Blumenhagen\ bei\ Strasburg",
"496569", "Bickendorf",
"492776", "Bad\ Endbach\-Hartenrod",
"498320", "Missen\-Wilhams",
"499651", "Vohenstrauss",
"494262", "Visselhövede",
"497383", "Münsingen\-Buttenhausen",
"4936484", "Knau\ bei\ Pössneck",
"495202", "Oerlinghausen",
"4933635", "Arensdorf\ Kreis\ Oder\-Spree",
"494624", "Kropp",
"499938", "Moos\ Niederbayern",
"4939603", "Burg\ Stargard",
"493303", "Birkenwerder",
"497706", "Oberbaldingen",
"495553", "Kalefeld",
"4934659", "Blankenheim\ bei\ Sangerhausen",
"493868", "Rastow",
"499171", "Roth\ Mittelfranken",
"4934721", "Nienburg\ Saale",
"492902", "Warstein",
"498726", "Schönau\ Niederbayern",
"4933331", "Casekow",
"496224", "Sandhausen\ Baden",
"497950", "Schnelldorf",
"4939427", "Ströbeck",
"4939007", "Tangeln",
"496531", "Bernkastel\-Kues",
"497544", "Markdorf",
"494329", "Langwedel\ Holstein",
"497972", "Gschwend\ bei\ Gaildorf",
"497300", "Roggenburg",
"495852", "Bleckede",
"4939008", "Kunrau",
"492554", "Laer\ Kreis\ Steinfurt",
"497447", "Baiersbronn\-Schwarzenberg",
"4939428", "Pabstorf",
"492352", "Altena\ Westfalen",
"495307", "Braunschweig\-Wenden",
"4939383", "Sandau\ Elbe",
"499335", "Aub\ Kreis\ Würzburg",
"494367", "Grossenbrode",
"495826", "Suderburg",
"495402", "Bissendorf\ Kreis\ Osnabrück",
"4933841", "Belzig",
"4938309", "Trent",
"494462", "Wittmund",
"4935877", "Cunewalde",
"496138", "Mommenheim",
"4938464", "Bernitt",
"496782", "Birkenfeld\ Nahe",
"497833", "Hornberg\ Schwarzwaldbahn",
"4939482", "Gatersleben",
"498752", "Au\ in\ der\ Hallertau",
"495957", "Lindern\ Oldenburg",
"4934204", "Schkeuditz",
"4935453", "Drahnsdorf",
"4938853", "Drönnewitz\ bei\ Hagenow",
"497247", "Linkenheim\-Hochstetten",
"492565", "Gronau\-Epe",
"4933921", "Zechlinerhütte",
"497661", "Kirchzarten",
"4933977", "Gumtow",
"4939266", "Förderstedt",
"499288", "Bad\ Steben",
"4939347", "Kade",
"498376", "Sulzberg\ Allgäu",
"492257", "Reckerscheid",
"499123", "Lauf\ an\ der\ Pegnitz",
"4934927", "Globig\-Bleddin",
"497334", "Deggingen",
"496743", "Bacharach",
"496424", "Ebsdorfergrund",
"497532", "Meersburg",
"496341", "Landau\ in\ der\ Pfalz",
"4933978", "Segeletz",
"498296", "Villenbach",
"4933964", "Fretzdorf",
"496527", "Oberweis",
"494779", "Freiburg\ Elbe",
"4939348", "Klitsche",
"4939030", "Brunau",
"4934928", "Seegrehna",
"4935752", "Ruhland",
"494761", "Bremervörde",
"495303", "Wendeburg",
"492803", "Wesel\-Büderich",
"499945", "Arnbruck",
"494363", "Lensahn",
"499375", "Freudenberg\ Baden",
"498039", "Rott\ am\ Inn",
"495465", "Neuenkirchen\ bei\ Bramsche",
"495254", "Paderborn\-Schloss\ Neuhaus",
"494405", "Edewecht",
"496406", "Lollar",
"499082", "Oettingen\ in\ Bayern",
"495199", "Schneverdingen\-Heber",
"494258", "Schwarme",
"497837", "Oberharmersbach",
"495953", "Börger",
"4934953", "Gräfenhainichen",
"493628", "Arnstadt",
"499295", "Töpen",
"4935603", "Burg\ Spreewald",
"492304", "Schwerte",
"494864", "Oldenswort",
"492502", "Nottuln",
"497243", "Ettlingen",
"496658", "Poppenhausen\ Wasserkuppe",
"4934441", "Hohenmölsen",
"495804", "Rätzlingen\ Kreis\ Uelzen",
"499127", "Rosstal\ Mittelfranken",
"4938827", "Kalkhorst",
"492253", "Bad\ Münstereifel",
"498336", "Erkheim",
"4939747", "Züsedom",
"4938871", "Mühlen\ Eichsen",
"495055", "Fassberg",
"4935471", "Birkenhainchen",
"497572", "Mengen\ Württemberg",
"497944", "Kupferzell",
"498061", "Bad\ Aibling",
"497374", "Uttenweiler",
"496747", "Emmelshausen",
"497159", "Renningen",
"4939748", "Viereck",
"492368", "Oer\-Erkenschwick",
"496523", "Holsthum",
"4938828", "Schönberg",
"492954", "Rüthen\-Oestereiden",
"499094", "Tagmersheim",
"4933656", "Bahro",
"499560", "Grub\ am\ Forst",
"4935383", "Elster\ Elbe",
"498704", "Altdorf\-Pfettrach",
"4933602", "Alt\ Zeschdorf",
"496281", "Buchen\ Odenwald",
"499495", "Breitenbrunn\ Oberpfalz",
"498251", "Aichach",
"499725", "Poppenhausen\ Unterfranken",
"494458", "Wiefelstede\-Spohle",
"496206", "Lampertheim",
"4939821", "Carpin",
"494146", "Stade\-Bützfleth",
"492736", "Burbach\ Siegerl",
"496145", "Flörsheim\ am\ Main",
"497387", "Hohenstein\ Württemberg",
"494205", "Ottersberg",
"4933675", "Tauche",
"495454", "Hörstel\-Riesenbeck",
"495265", "Dörentrup",
"499978", "Schönthal\ Oberpfalz",
"499348", "Werbach\-Gamburg",
"4939453", "Derenburg",
"497482", "Horb\-Dettingen",
"493307", "Zehdenick",
"497821", "Lahr\ Schwarzwald",
"4934321", "Leisnig",
"4935266", "Heyda\ bei\ Riesa",
"496856", "St\ Wendel\-Niederkirchen",
"499131", "Erlangen",
"498801", "Seeshaupt",
"492330", "Herdecke",
"4933731", "Trebbin",
"498546", "Windorf\-Otterskirchen",
"4936963", "Dorndorf\ Rhön",
"495064", "Gross\ Düngen",
"496571", "Wittlich",
"494681", "Wyk\ auf\ Föhr",
"492453", "Heinsberg\-Randerath",
"497932", "Niederstetten\ Württemberg",
"494606", "Wanderup",
"4934364", "Wermsdorf",
"497443", "Dornstetten",
"49731", "Ulm\ Donau",
"497724", "St\ Georgen\ im\ Schwarzwald",
"494855", "Eddelak",
"492743", "Daaden",
"494177", "Drage\ Elbe",
"494133", "Wittorf\ Kreis\ Lüneburg",
"499102", "Wilhermsdorf",
"492424", "Vettweiss",
"4933393", "Gross\ Schönebeck\ Kreis\ Barnim",
"495841", "Lüchow\ Wendland",
"4935201", "Langebrück",
"492971", "Schmallenberg\-Dorlar",
"497753", "Albbruck",
"492527", "Lippetal\-Lippborg",
"495506", "Adelebsen",
"497351", "Biberach\ an\ der\ Riss",
"496565", "Dudeldorf",
"499683", "Friedenfels",
"496029", "Mömbris",
"4933874", "Stechow\ Brandenburg",
"499549", "Lisberg",
"496257", "Seeheim\-Jugenheim",
"493981", "Neustrelitz",
"495423", "Versmold",
"498533", "Rotthalmünster",
"495744", "Hüllhorst",
"4939361", "Lüderitz",
"498166", "Allershausen\ Oberbayern",
"496326", "Deidesheim",
"497436", "Messstetten\-Oberdigisheim",
"4935974", "Hinterhermsdorf",
"493431", "Döbeln",
"499642", "Kemnath\ Stadt",
"495271", "Höxter",
"49821", "Augsburg",
"493772", "Schneeberg\ Erzgebirge",
"4939324", "Kläden\ bei\ Stendal",
"494748", "Stubben\ bei\ Bremerhaven",
"4935249", "Basslitz",
"498382", "Lindau\ Bodensee",
"498584", "Breitenberg\ Niederbayern",
"497635", "Schliengen",
"496457", "Burgwald\ Eder",
"494192", "Bad\ Bramstedt",
"496554", "Waxweiler",
"4936608", "Seelingstädt\ bei\ Gera",
"492923", "Lippetal\-Herzfeld",
"496352", "Kirchheimbolanden",
"498075", "Amerang",
"492662", "Hachenburg",
"499339", "Ippesheim",
"492224", "Bad\ Honnef",
"4938374", "Lassan\ bei\ Wolgast",
"4936607", "Niederpöllnitz",
"494184", "Hanstedt\ Nordheide",
"498741", "Vilsbiburg",
"494775", "Grossenwörden",
"499763", "Sulzdorf\ an\ der\ Lederhecke",
"49841", "Ingolstadt\ Donau",
"498343", "Aitrang",
"495732", "Löhne",
"4936423", "Orlamünde",
"498394", "Lautrach",
"495471", "Bohmte",
"498592", "Wegscheid\ Niederbayern",
"497236", "Keltern",
"495924", "Bad\ Bentheim\-Gildehaus",
"494928", "Ihlow\-Riepe",
"499634", "Wiesau",
"493322", "Falkensee",
"498274", "Buttenwiesen",
"4939934", "Gross\ Plasten",
"4933744", "Hohenseefeld",
"4935724", "Lohsa",
"496776", "Dachsenhausen",
"495223", "Bünde",
"492571", "Greven\ Westfalen",
"4939201", "Wolmirstedt",
"496453", "Gemünden\ Wohra",
"497675", "Bernau\ Baden",
"494966", "Neubörger",
"494121", "Elmshorn",
"4937293", "Eppendorf\ Sachsen",
"495906", "Lünne",
"492927", "Neuengeseke",
"4936458", "Bad\ Berka",
"495195", "Neuenkirchen\ bei\ Soltau",
"4936873", "Themar",
"492856", "Hamminkeln\-Brünen",
"498035", "Raubling",
"494409", "Westerstede\-Ocholt",
"495356", "Helmstedt\-Barmke",
"492605", "Löf",
"497420", "Deisslingen",
"497586", "Herbertingen",
"4935792", "Ossling",
"493581", "Görlitz",
"4938334", "Grammendorf",
"493841", "Wismar",
"499154", "Pommelsbrunn",
"494735", "Butjadingen\-Stollhamm",
"4935361", "Schlieben",
"496063", "Bad\ König",
"495772", "Espelkamp",
"498347", "Friesenried",
"495431", "Quakenbrück",
"498442", "Wolnzach",
"497276", "Herxheim\ bei\ Landau\ Pfalz",
"499674", "Schönsee",
"498234", "Bobingen",
"493391", "Neuruppin",
"4935324", "Crinitz",
"499076", "Wittislingen",
"492206", "Overath",
"493423", "Eilenburg",
"496736", "Bechenheim",
"493744", "Auerbach\ Vogtland",
"499165", "Sugenheim",
"492747", "Molzhain",
"494137", "Barendorf",
"494173", "Wulfsen",
"492931", "Arnsberg",
"492523", "Wadersloh",
"497220", "Forbach\-Hundsbach",
"494209", "Schwanewede",
"4937329", "Grosshartmannsdorf",
"496304", "Wolfstein\ Pfalz",
"496502", "Schweich",
"499729", "Grettstadt",
"498283", "Neuburg\ an\ der\ Kammel",
"496253", "Fürth\ Odenwald",
"4933834", "Pritzerbe",
"4939392", "Rönnebeck\ Sachsen\-Anhalt",
"499499", "Painten",
"498537", "Bad\ Füssing\-Aigen",
"498573", "Ering",
"492406", "Herzogenrath",
"495427", "Melle\-Buer",
"4938207", "Stäbelow",
"494859", "Windbergen",
"4934467", "Eckartsberga",
"495322", "Bad\ Harzburg",
"495524", "Bad\ Lauterberg\ im\ Harz",
"498434", "Rennertshofen",
"492822", "Emmerich",
"4936743", "Teichel",
"4935934", "Grossdubrau",
"4937755", "Schönheide\ Erzgebirge",
"497476", "Bisingen",
"495231", "Detmold",
"496803", "Mandelbachtal\-Ommersheim",
"497164", "Boll\ Kreis\ Göppingen",
"493471", "Bernburg\ Saale",
"494528", "Schönwalde\ am\ Bungsberg",
"4936646", "Tanna\ bei\ Schleiz",
"4938208", "Kavelstorf",
"4939724", "Klein\ Bünzow",
"49961", "Weiden\ in\ der\ Oberpfalz",
"4938844", "Gülze",
"496044", "Schotten\ Hessen",
"499427", "Leiblfing",
"497031", "Böblingen",
"498505", "Hutthurm",
"499524", "Zeil\ am\ Main",
"494876", "Reher\ Holstein",
"496093", "Laufach",
"496646", "Grebenau",
"493634", "Sömmerda",
"498671", "Altötting",
"496875", "Nonnweiler\-Primstal",
"492449", "Blankenheim\ Ahr",
"499231", "Marktredwitz",
"497459", "Nagold\-Hochdorf",
"493361", "Fürstenwalde\ Spree",
"494551", "Bad\ Segeberg",
"493763", "Glauchau",
"497366", "Abtsgmünd",
"49561", "Kassel",
"498867", "Rottenbuch\ Oberbayern",
"495165", "Rethem\ Aller",
"494105", "Seevetal",
"496478", "Greifenstein\-Ulm",
"496245", "Biblis",
"4938232", "Zingst\ Ostseebad",
"499269", "Tettau\ Kreis\ Kronach",
"496181", "Hanau",
"4936041", "Bad\ Tennstedt",
"494246", "Twistringen\-Heiligenloh",
"492621", "Lahnstein",
"496106", "Rodgau",
"497525", "Aulendorf",
"498151", "Starnberg",
"4939390", "Iden",
"4936605", "Bad\ Köstritz",
"498558", "Hohenau\ Niederbayern",
"495767", "Warmsen",
"496032", "Bad\ Nauheim",
"497259", "Östringen\-Odenheim",
"494707", "Langen\-Neuenwalde",
"499772", "Bischofsheim\ an\ der\ Rhön",
"499431", "Schwandorf",
"496588", "Pluwig",
"496848", "Homburg\-Einöd",
"495674", "Grebenstein",
"497143", "Besigheim",
"4935243", "Weinböhla",
"497194", "Spiegelberg",
"498623", "Kirchweidach",
"4936946", "Erbenhausen\ Thüringen",
"492153", "Nettetal\-Lobberich",
"499227", "Neuenmarkt",
"494158", "Roseburg",
"494446", "Bakum\ Kreis\ Vechta",
"496398", "Vorderweidenthal",
"4939294", "Gross\ Rosenburg",
"497738", "Steisslingen",
"499195", "Adelsdorf\ Mittelfranken",
"493683", "Schmalkalden",
"499906", "Mariaposching",
"499469", "Roding\-Neubäu",
"497182", "Welzheim",
"492673", "Ellenz\-Poltersdorf",
"492637", "Weissenthurm",
"499356", "Burgsinn",
"496445", "Schöffengrund",
"495379", "Sassenburg\-Grussendorf",
"495154", "Aerzen",
"4937342", "Cranzahl",
"495763", "Uchte",
"498196", "Pürgen",
"492861", "Borken\ Westfalen",
"49361", "Erfurt",
"499732", "Hammelburg",
"494703", "Loxstedt\-Donnern",
"495361", "Wolfsburg",
"499471", "Burglengenfeld",
"4939222", "Möser",
"494638", "Tarp",
"497023", "Weilheim\ an\ der\ Teck",
"499924", "Bodenmais",
"495634", "Waldeck\-Sachsenhausen",
"496385", "Reichenbach\-Steegen",
"497147", "Sachsenheim\ Württemberg",
"494951", "Weener",
"499223", "Rugendorf",
"492157", "Nettetal\-Kaldenkirchen",
"496050", "Biebergemünd",
"495036", "Neustadt\-Schneeren",
"499188", "Postbauer\-Heng",
"492764", "Welschen\ Ennest",
"492677", "Lutzerath",
"492633", "Brohl\-Lützing",
"496238", "Dirmstein",
"492839", "Straelen\-Herongen",
"4936701", "Lichte",
"495339", "Gielde",
"496595", "Dockweiler",
"499423", "Geiselhöring",
"499744", "Zeitlofs\-Detter",
"498562", "Triftern",
"4937422", "Markneukirchen",
"497071", "Tübingen",
"498364", "Seeg",
"499391", "Marktheidenfeld",
"494836", "Hennstedt\ Dithmarschen",
"4939243", "Nedlitz\ bei\ Zerbst",
"496835", "Beckingen",
"498631", "Mühldorf\ am\ Inn",
"492684", "Puderbach\ Westerwald",
"495642", "Warburg\-Scherfede",
"499271", "Thurnau\-Alladorf",
"492599", "Ascheberg\-Herbern",
"496124", "Bad\ Schwalbach",
"4937323", "Lichtenberg\ Erzgebirge",
"4936785", "Gräfinau\-Angstedt",
"493379", "Mahlow",
"499841", "Bad\ Windsheim",
"493949", "Oschersleben\ Bode",
"495102", "Laatzen",
"497328", "Königsbronn",
"496438", "Hünfelden",
"494162", "Jork",
"498669", "Traunreut",
"4937757", "Rittersgrün",
"495683", "Wabern\ Hessen",
"497745", "Jestetten",
"4934465", "Bad\ Bibra",
"4938205", "Tessin\ bei\ Rostock",
"492692", "Kelberg",
"492389", "Werne",
"492755", "Bad\ Berleburg\-Schwarzenau",
"4939365", "Bellingen\ bei\ Stendal",
"497654", "Löffingen",
"492693", "Antweiler",
"496535", "Osann\-Monzel",
"492644", "Linz\ am\ Rhein",
"495682", "Borken\ Hessen",
"497056", "Gechingen",
"496298", "Möckmühl",
"4936330", "Grossberndten",
"494536", "Steinhorst\ Lauenburg",
"499175", "Spalt",
"494163", "Horneburg\ Niederelbe",
"499256", "Stammbach",
"498862", "Steingaden\ Oberbayern",
"495103", "Wennigsen\ Deister",
"495849", "Waddeweitz",
"4935205", "Ottendorf\-Okrilla",
"495694", "Diemelstadt",
"497466", "Beuron",
"495643", "Borgentreich",
"493461", "Merseburg\ Saale",
"497174", "Mögglingen",
"4936083", "Uder",
"496021", "Aschaffenburg",
"498136", "Markt\ Indersdorf",
"4936643", "Thimmendorf",
"4938294", "Neubukow",
"499655", "Tännesberg",
"494920", "Wirdum",
"498563", "Bad\ Birnbach\ Rottal",
"4934242", "Hohenpriessnitz",
"4937432", "Pausa\ Vogtland",
"492104", "Mettmann",
"499422", "Bogen\ Niederbayern",
"4935692", "Kerkwitz",
"499369", "Uettingen",
"499148", "Ettenstatt",
"492632", "Andernach",
"496345", "Albersweiler",
"4937296", "Stollberg\ Erzgebirge",
"494346", "Gettorf",
"494976", "Spiekeroog",
"492561", "Ahaus",
"4936920", "Grossenlupnitz",
"497665", "March\ Breisgau",
"496728", "Ober\-Hilbersheim",
"4934223", "Dommitzsch",
"49711", "Stuttgart",
"4935054", "Lauenstein\ Sachsen",
"499222", "Presseck",
"499664", "Hahnbach",
"4936622", "Triebes",
"497022", "Nürtingen",
"499608", "Kohlberg\ Oberpfalz",
"4936840", "Trusetal",
"497266", "Kirchardt",
"493647", "Pössneck",
"496073", "Babenhausen\ Hessen",
"494740", "Loxstedt\-Dedesdorf",
"499733", "Münnerstadt",
"499777", "Ostheim\ von\ der\ Rhön",
"494702", "Sandstedt",
"499331", "Ochsenfurt",
"4935365", "Falkenberg\ Elster",
"498065", "Tuntenhausen\-Schönau",
"495439", "Bersenbrück",
"497228", "Forbach",
"4936949", "Obermassfeld\-Grimmenthal",
"4936694", "Schkölen\ Thüringen",
"497183", "Rudersberg\ Württemberg",
"492672", "Treis\-Karden",
"494936", "Grossheide",
"493682", "Zella\-Mehlis",
"496888", "Lebach\-Steinbach",
"495051", "Bergen\ Kreis\ Celle",
"498858", "Kochel\-Walchensee",
"492152", "Kempen",
"496485", "Nentershausen\ Westerwald",
"4939205", "Langenweddingen",
"498622", "Tacherting\-Peterskirchen",
"496766", "Kisselbach",
"494129", "Haseldorf",
"497142", "Bietigheim\-Bissingen",
"4933233", "Ketzin",
"4936426", "Ottendorf\ bei\ Stadtroda",
"495461", "Bramsche\ Hase",
"494401", "Brake\ Unterweser",
"493643", "Weimar\ Thüringen",
"498208", "Eurasburg\ bei\ Augsburg",
"494765", "Ebersdorf\ bei\ Bremervörde",
"499773", "Unsleben",
"499737", "Wartmannsroth",
"496033", "Butzbach",
"4933084", "Gutengermendorf",
"495705", "Petershagen\-Windheim",
"499371", "Miltenberg",
"494486", "Edewecht\-Friedrichsfehn",
"499941", "Kötzting",
"4933396", "Klosterfelde",
"494851", "Marne",
"492697", "Blankenheim\-Ahrhütte",
"496575", "Landscheid",
"496338", "Hornbach\ Pfalz",
"497428", "Rosenfeld",
"499824", "Dietenhofen",
"498054", "Breitbrunn\ am\ Chiemsee",
"4938222", "Semlow",
"4936730", "Sitzendorf",
"4936370", "Grossenehrich",
"498656", "Anger",
"494167", "Apensen",
"499135", "Hessdorf\ Mittelfranken",
"496084", "Schmitten\ Taunus",
"492961", "Brilon",
"498805", "Hohenpeissenberg",
"494286", "Gyhum",
"493762", "Crimmitschau",
"4939054", "Flechtingen",
"494754", "Bülkau",
"497825", "Kippenheim",
"495647", "Lichtenau\-Kleinenberg",
"495261", "Lemgo",
"497134", "Weinsberg",
"499721", "Schweinfurt",
"498464", "Dietfurt\ an\ der\ Altmühl",
"496092", "Heimbuchenthal",
"499323", "Iphofen",
"498176", "Egling\ bei\ Wolfratshausen",
"499491", "Hemau",
"496285", "Walldürn\-Altheim",
"493331", "Angermünde",
"4933434", "Herzfelde\ bei\ Strausberg",
"498294", "Horgau",
"497336", "Lonsee",
"498550", "Philippsreut",
"493733", "Annaberg\-Buchholz",
"496426", "Fronhausen",
"49375", "Zwickau",
"496580", "Zemmer",
"499647", "Kirchenthumbach",
"496802", "Völklingen\-Lauterbach",
"498243", "Fuchstal",
"499261", "Kronach",
"492823", "Goch",
"495721", "Stadthagen",
"4939246", "Lindau\ Anh",
"494795", "Garlstedt",
"495323", "Clausthal\-Zellerfeld",
"4937326", "Frauenstein\ Sachsen",
"494425", "Wangerland\-Hooksiel",
"498374", "Dietmannsried",
"495491", "Damme\ Dümmer",
"498572", "Tann\ Niederbayern",
"4936649", "Gefell\ bei\ Schleiz",
"4935844", "Oybin\ Kurort",
"498095", "Aying",
"496252", "Heppenheim\ Bergstrasse",
"4934492", "Lucka",
"498282", "Krumbach\ Schwaben",
"496503", "Hermeskeil",
"4935208", "Radeburg",
"494828", "Lägerdorf",
"492441", "Kall",
"498679", "Burgkirchen\ an\ der\ Alz",
"495824", "Bad\ Bodenteich",
"492324", "Hattingen\ Ruhr",
"49271", "Siegen",
"492522", "Oelde",
"495135", "Burgwedel\-Fuhrberg",
"497451", "Horb\ am\ Neckar",
"499107", "Trautskirchen",
"4935207", "Moritzburg",
"494172", "Salzhausen",
"494559", "Wensin",
"4938792", "Lenzen\ \(Elbe\)",
"497546", "Oberteuringen",
"493881", "Grevesmühlen",
"493541", "Calau",
"4935774", "Boxberg\ Sachsen",
"492556", "Metelen",
"493327", "Werder\ Havel",
"4938220", "Wustrow\ Ostseebad",
"4936732", "Könitz",
"4936372", "Kleinneuhausen",
"49831", "Kempten\ Allgäu",
"498443", "Hohenwart\ Paar",
"498724", "Massing",
"499461", "Roding",
"492871", "Bocholt",
"496226", "Meckesheim",
"495773", "Stemwede\-Wehdem",
"496062", "Erbach\ Odenwald",
"495941", "Neuenhaus\ Dinkel",
"495371", "Gifhorn",
"4938324", "Velgast",
"497251", "Bruchsal",
"4936601", "Hermsdorf\ Thüringen",
"492667", "Stein\-Neukirch",
"499439", "Neunburg\-Kemnath",
"497704", "Geisingen\ Baden",
"4939992", "Görmin",
"492241", "Siegburg",
"494626", "Treia",
"498821", "Garmisch\-Partenkirchen",
"492991", "Marsberg\-Bredelar",
"496357", "Standenbühl",
"496625", "Niederaula",
"492774", "Dietzhölztal",
"496452", "Battenberg\ Eder",
"498387", "Weiler\-Simmerberg",
"495028", "Pennigsehl",
"495222", "Bad\ Salzuflen",
"493491", "Lutherstadt\ Wittenberg",
"4938392", "Sassnitz",
"495066", "Sarstedt",
"495664", "Morschen",
"4936332", "Ellrich",
"4939924", "Stuer",
"497726", "Bad\ Dürrheim",
"494604", "Grossenwiehe",
"4934344", "Kohren\-Sahlis",
"493721", "Meinersdorf",
"495608", "Söhrewald",
"498593", "Untergriesbach",
"4935246", "Ziegenhain\ Sachsen",
"494668", "Klanxbüll",
"496854", "Oberthal\ Saar",
"498544", "Eging\ am\ See",
"495733", "Vlotho",
"495777", "Diepenau\-Essern",
"498342", "Marktoberdorf",
"4936943", "Bettenhausen\ Thüringen",
"4936705", "Oberweissbach\ Thüringer\ Wald",
"492831", "Geldern",
"495331", "Wolfenbüttel",
"499762", "Saal\ an\ der\ Saale",
"4935893", "Mücka",
"496268", "Hüffenhardt",
"495456", "Westerkappeln\-Velpe",
"496430", "Hahnstätten",
"4938724", "Siggelkow",
"4937430", "Eichigt",
"495148", "Steinhorst\ Niedersachsen",
"4936451", "Buttelstedt",
"4939208", "Loitsche",
"492663", "Westerburg\ Westerwald",
"498706", "Vilsheim",
"492922", "Werl",
"496353", "Freinsheim",
"496751", "Bad\ Sobernheim",
"494193", "Henstedt\-Ulzburg",
"494959", "Dollart",
"496204", "Viernheim",
"4939207", "Colbitz",
"492734", "Freudenberg\ Westfalen",
"498781", "Rottenburg\ an\ der\ Laaber",
"494144", "Himmelpforten",
"4933239", "Gross\ Behnitz",
"498383", "Grünenbach\ Allgäu",
"4936922", "Gerstungen",
"4939774", "Mönkebude",
"493941", "Halberstadt",
"4933474", "Neutrebbin",
"493371", "Luckenwalde",
"497946", "Bretzfeld",
"497376", "Langenenslingen",
"493773", "Johanngeorgenstadt",
"493737", "Rochlitz",
"499643", "Auerbach\ in\ der\ Oberpfalz",
"496865", "Mettlach\-Orscholz",
"498661", "Grabenstätt\ Chiemsee",
"4934424", "Reuden\ bei\ Zeitz",
"494630", "Barderup",
"498247", "Bad\ Wörishofen",
"4934461", "Nebra\ Unstrut",
"495806", "Barum\ bei\ Bad\ Bevensen",
"492827", "Goch\-Hassum",
"495327", "Bad\ Grund\ Harz",
"495655", "Wanfried",
"492306", "Lünen",
"499180", "Pyrbaum",
"495541", "Hann\.\ Münden",
"496058", "Gründau",
"495422", "Melle",
"4938201", "Gelbensande",
"498532", "Griesbach\ im\ Rottal",
"492381", "Hamm\ Westfalen",
"498334", "Bad\ Grönenbach",
"496404", "Lich\ Hessen",
"4936842", "Oberhof\ Thüringen",
"499682", "Erbendorf",
"496507", "Neumagen\-Dhron",
"498639", "Neumarkt\-Sankt\ Veit",
"492591", "Lüdinghausen",
"499279", "Mistelgau",
"4936781", "Grossbreitenbach",
"495175", "Lehrte\-Arpke",
"496468", "Dautphetal\-Mornshausen",
"494132", "Amelinghausen",
"492742", "Wissen",
"499103", "Cadolzburg",
"497442", "Baiersbronn",
"4939853", "Holzendorf\ bei\ Prenzlau",
"498276", "Baar\ Schwaben",
"4933338", "Stolpe\/Oder",
"492357", "Herscheid\ Westfalen",
"492625", "Ochtendung",
"4938482", "Warin",
"495857", "Bleckede\-Brackede",
"4935020", "Struppen",
"499636", "Plössberg",
"496774", "Kaub",
"497347", "Dietenheim",
"497977", "Oberrot\ bei\ Gaildorf",
"492452", "Heinsberg\ Rheinland",
"497933", "Creglingen",
"496185", "Hammersbach\ Hessen",
"4933764", "Mittenwalde\ Mark",
"4933337", "Altkünkendorf",
"4939421", "Osterwieck",
"494186", "Buchholz\-Trelde",
"4939001", "Apenburg",
"497234", "Tiefenbronn",
"496667", "Steinau\-Ulmbach",
"495926", "Engden",
"495161", "Walsrode",
"496241", "Worms",
"4934771", "Querfurt",
"494101", "Pinneberg",
"4934635", "Bad\ Lauchstädt",
"495139", "Burgwedel",
"497483", "Horb\-Mühringen",
"494555", "Seedorf\ bei\ Bad\ Segeberg",
"496871", "Wadern",
"492226", "Rheinbach",
"4933055", "Kremmen",
"495207", "Schloss\ Holte\-Stukenbrock",
"494641", "Süderbrarup",
"4933982", "Hoppenrade\ Kreis\ Prignitz",
"499235", "Thierstein",
"494267", "Lauenbrück",
"4939831", "Feldberg",
"498846", "Uffing\ am\ Staffelsee",
"498586", "Hauzenberg",
"496556", "Pronsfeld",
"498501", "Thyrnau",
"4934978", "Radegast\ Kreis\ Köthen",
"496441", "Wetzlar",
"496324", "Hassloch",
"49671", "Bad\ Kreuznach",
"497434", "Winterlingen",
"4936462", "Ossmannstedt",
"496522", "Mettendorf",
"4933928", "Wildberg\ Brandenburg",
"497573", "Stetten\ am\ kalten\ Markt",
"4939341", "Redekin",
"4934977", "Quellendorf",
"499191", "Forchheim\ Oberfranken",
"495746", "Rödinghausen",
"492252", "Zülpich",
"4934921", "Kemberg",
"4938752", "Zierzow\ bei\ Ludwigslust",
"4933927", "Linum",
"497242", "Rheinstetten",
"4933971", "Kyritz\ Brandenburg",
"4938428", "Hohenkirchen\ bei\ Wismar",
"4933848", "Raben",
"494508", "Krummesse",
"4935828", "Reichenbach\ OL",
"493904", "Haldensleben",
"495952", "Sögel",
"4933204", "Beelitz\ Mark",
"4937360", "Olbernhau",
"496787", "Niederbrombach",
"499083", "Möttingen",
"496629", "Schenklengsfeld",
"4934782", "Mansfeld\ Südharz",
"494467", "Wittmund\-Funnix",
"4935827", "Nieder\-Seifersdorf",
"499435", "Schwarzenfeld",
"4938427", "Blowatz",
"4933847", "Görzke",
"4939952", "Grammentin",
"495407", "Wallenhorst",
"492426", "Nörvenich",
"4939085", "Zichtau",
"494362", "Heiligenhafen",
"492802", "Alpen",
"497128", "Sonnenbühl",
"494564", "Schashagen",
"495302", "Vechelde",
"493968", "Schönbeck",
"495504", "Friedland\ Kreis\ Göttingen",
"4939882", "Gollin",
"4939400", "Wefensleben",
"497166", "Adelberg",
"4935478", "Goyatz",
"4938453", "Mistorf",
"496591", "Gerolstein",
"497474", "Haigerloch",
"497577", "Veringenstadt",
"497533", "Allensbach",
"496742", "Boppard",
"4938821", "Lüdersdorf",
"4934295", "Krensitz",
"4939741", "Jatznick",
"492404", "Alsdorf\ Rheinland",
"499122", "Schwabach",
"49721", "Karlsruhe",
"4935477", "Rietzneuendorf\-Friedrichshof",
"4938352", "Kemnitz\ bei\ Greifswald",
"4933931", "Rheinsberg\ Mark",
"492507", "Havixbeck",
"4938306", "Samtens",
"494955", "Westoverledingen",
"496827", "Eppelborn",
"498753", "Elsendorf\ Niederbayern",
"496306", "Trippstadt",
"499087", "Marktoffingen",
"497832", "Haslach\ im\ Kinzigtal",
"496783", "Baumholder",
"492058", "Wülfrath",
"496381", "Kusel",
"4934382", "Nerchau",
"494463", "Wangerland",
"495403", "Bad\ Iburg",
"492865", "Raesfeld",
"494305", "Westensee",
"495365", "Wolfsburg\-Neindorf",
"492353", "Halver",
"498236", "Fischach",
"499676", "Winklarn",
"492751", "Bad\ Berleburg",
"495853", "Neu\ Darchau",
"497394", "Schelklingen",
"499074", "Höchstädt\ an\ der\ Donau",
"497937", "Dörzbach",
"497973", "Obersontheim",
"492204", "Bensberg",
"4934328", "Hartha\ bei\ Döbeln",
"49741", "Rottweil",
"496734", "Flonheim",
"497343", "Buch\ bei\ Illertissen",
"495659", "Ringgau",
"4937200", "Wittgensdorf\ bei\ Chemnitz",
"4933364", "Gross\ Ziethen\ Kreis\ Barnim",
"497741", "Tiengen\ Hochrhein",
"496869", "Merzig\-Silwingen",
"492268", "Kürten",
"4935341", "Bad\ Liebenwerda",
"4938783", "Dallmin",
"4934327", "Waldheim\ Sachsen",
"499845", "Oberdachstetten",
"497274", "Germersheim",
"492903", "Meschede\-Freienohl",
"496663", "Steinau\ an\ der\ Strasse",
"493302", "Hennigsdorf",
"495552", "Katlenburg",
"495354", "Jerxheim",
"493504", "Dippoldiswalde",
"4939828", "Wustrow\ Kreis\ Mecklenburg\-Strelitz",
"498635", "Pleiskirchen",
"495203", "Werther\ Westfalen",
"499156", "Neuhaus\ an\ der\ Pegnitz",
"496831", "Saarlouis",
"497584", "Altshausen",
"494263", "Scheessel",
"499448", "Hausen\ Niederbayern",
"497844", "Rheinau",
"499275", "Speichersdorf",
"497382", "Römerstein",
"4934602", "Landsberg\ Sachsen\-Anhalt",
"499395", "Triefenstein",
"4935952", "Grossröhrsdorf\ OL",
"4934656", "Wallhausen\ Sachsen\-Anhalt",
"4939827", "Schwarz\ bei\ Neustrelitz",
"495904", "Lengerich\ Emsl",
"496198", "Eppstein",
"494964", "Rhede\ Ems",
"4936203", "Vieselbach",
"494358", "Loose\ bei\ Eckernförde",
"499354", "Rieneck",
"4935386", "Prettin",
"499179", "Freystadt",
"4933653", "Ziltendorf",
"499552", "Burghaslach",
"499203", "Neudrossenfeld",
"496130", "Schwabenheim\ an\ der\ Selz",
"495156", "Coppenbrügge",
"494232", "Langwedel\ Kreis\ Verden",
"4933335", "Pinnow\ Kreis\ Uckermark",
"495448", "Barver",
"495275", "Höxter\-Ottbergen",
"493435", "Oschatz",
"494723", "Cuxhaven\-Altenwalde",
"494444", "Goldenstedt",
"494321", "Neumünster",
"4939859", "Fürstenwerder",
"4939456", "Altenbrak",
"494547", "Gudow\ Lauenburg",
"499904", "Lalling",
"4939402", "Völpke",
"494493", "Friesoythe\-Gehlenberg",
"4933702", "Wünsdorf",
"498023", "Bayrischzell",
"4935263", "Gröditz\ bei\ Riesa",
"499853", "Wilburgstetten",
"495676", "Liebenau\ Hessen",
"495074", "Rodewald",
"496561", "Bitburg",
"4936966", "Kaltennordheim",
"4934638", "Zöschen",
"497905", "Langenburg",
"499280", "Selbitz\ Oberfranken",
"499659", "Leuchtenberg",
"4933631", "Bad\ Saarow\-Pieskow",
"497355", "Hochdorf\ Riss",
"497627", "Steinen\ Kreis\ Lörrach",
"49481", "Heide\ Holstein",
"495845", "Bergen\ Dumme",
"495585", "Herzberg\-Sieber",
"493838", "Bergen\ auf\ Rügen",
"492975", "Schmallenberg\-Oberkirchen",
"4934637", "Frankleben",
"494293", "Ottersberg\-Fischerhude",
"4933925", "Wustrau\-Altfriesack",
"497669", "St\ Märgen",
"4935435", "Gollmitz\ bei\ Calau",
"498328", "Balderschwang",
"494244", "Harpstedt",
"4934975", "Görzig\ Kreis\ Köthen",
"496104", "Heusenstamm",
"495475", "Bohmte\-Hunteburg",
"495248", "Langenberg\ Kreis\ Gütersloh",
"4937202", "Claussnitz\ bei\ Chemnitz",
"494432", "Dötlingen\-Brettorf",
"499403", "Donaustauf",
"496349", "Billigheim\-Ingenheim",
"4936024", "Diedorf\ bei\ Mühlhausen",
"494771", "Hemmoor",
"4934956", "Zörbig",
"498745", "Bodenkirchen",
"494337", "Jevenstedt",
"499365", "Rimpar",
"494943", "Grossefehn",
"4935606", "Briesen\ bei\ Cottbus",
"492948", "Lippstadt\-Rebbeke",
"492378", "Fröndenberg\-Langschede",
"493860", "Raben\ Steinfeld",
"498071", "Wasserburg\ am\ Inn",
"497364", "Oberkochen",
"4939087", "Jerchel\ Altmark",
"497562", "Isny\ im\ Allgäu",
"497958", "Rot\ Am\ See\-Brettheim",
"4933845", "Borkheide",
"4938425", "Kirchdorf\ Poel",
"4934600", "Ostrau\ Saalkreis",
"4935825", "Kodersdorf",
"497308", "Nersingen",
"499480", "Sünching",
"496693", "Neuental",
"496046", "Ortenberg\ Hessen",
"492535", "Sendenhorst\-Albersloh",
"494874", "Todenbüttel",
"496644", "Grebenhain",
"493636", "Greussen",
"4939088", "Letzlingen",
"499526", "Riedbach",
"497631", "Müllheim\ Baden",
"4934445", "Stössen",
"494297", "Ottersberg\-Posthausen",
"499952", "Eichendorf",
"499568", "Neustadt\ bei\ Coburg",
"4939386", "Seehausen\ Altmark",
"495083", "Hohne\ bei\ Celle",
"4935475", "Straupitz",
"4938875", "Schlagsdorf\ bei\ Gadebusch",
"493395", "Pritzwalk",
"4934297", "Liebertwolkwitz",
"497151", "Waiblingen",
"493448", "Meuselwitz\ Thüringen",
"4938459", "Laage",
"495435", "Berge\ bei\ Quakenbrück",
"499407", "Wenzenbach",
"494472", "Lastrup",
"4935022", "Bad\ Schandau",
"494731", "Nordenham",
"499340", "Königheim\-Brehmen",
"4934298", "Taucha\ bei\ Leipzig",
"499504", "Stadelhofen",
"4938856", "Pritzier\ bei\ Hagenow",
"494947", "Aurich\-Ogenbargen",
"499302", "Rottendorf\ Unterfranken",
"4935456", "Terpt",
"494333", "Erfde",
"494769", "Bremervörde\-Iselersheim",
"492338", "Breckerfeld",
"4939263", "Unseburg",
"493585", "Löbau",
"492686", "Weyerbusch",
"495838", "Gross\ Oesingen",
"497505", "Fronreute",
"498031", "Rosenheim\ Oberbayern",
"495042", "Bad\ Münder\ am\ Deister",
"492601", "Nauort",
"496126", "Idstein",
"494125", "Seestermühe",
"498366", "Oy\-Mittelberg",
"495191", "Soltau",
"499746", "Zeitlofs",
"496697", "Willingshausen",
"498459", "Manching",
"492575", "Greven\-Reckenfeld",
"494834", "Büsum",
"497671", "Todtnau",
"4938750", "Malliss",
"498809", "Wessobrunn",
"4934325", "Mochau\-Lüttewitz",
"494272", "Siedenburg",
"499207", "Königsfeld\ Oberfranken",
"493475", "Lutherstadt\ Eisleben",
"4938789", "Wolfshagen\ bei\ Perleberg",
"495235", "Blomberg\ Lippe",
"496152", "Gross\-Gerau",
"492485", "Schleiden\-Dreiborn",
"493998", "Demmin",
"494392", "Nortorf\ bei\ Neumünster",
"4939606", "Glienke",
"494543", "Nusse",
"494883", "Süderstapel",
"494497", "Barssel\-Harkebrügge",
"498027", "Dietramszell",
"495636", "Lichtenfels\-Goddelsheim",
"496650", "Hosenfeld",
"492548", "Dülmen\-Rorup",
"499857", "Schopfloch\ Mittelfranken",
"4939825", "Wokuhl",
"4936209", "Klettbach",
"495034", "Neustadt\-Hagen",
"498259", "Schiltberg",
"4937463", "Bergen\ Vogtland",
"497558", "Illmensee",
"497962", "Fichtenau",
"4933671", "Lieberose",
"4937362", "Seiffen\ Erzgebirge",
"498194", "Vilgertshofen",
"497623", "Rheinfelden\ Baden",
"499161", "Neustadt\ an\ der\ Aisch",
"498143", "Inning\ am\ Ammersee",
"499926", "Frauenau",
"494842", "Nordstrand",
"494384", "Selent",
"492360", "Haltern\-Lippramsdorf",
"496672", "Eiterfeld",
"492935", "Sundern\-Hachen",
"4934222", "Arzberg\ bei\ Torgau",
"499341", "Tauberbischofsheim",
"498363", "Pfronten",
"499971", "Cham",
"492102", "Ratingen",
"499424", "Strasskirchen",
"4939084", "Lindstedt",
"496047", "Altenstadt\ Hessen",
"498761", "Moosburg\ an\ der\ Isar",
"498405", "Stammham\ bei\ Ingolstadt",
"497150", "Korntal\-Münchingen",
"4936623", "Berga\ Elster",
"499527", "Knetzgau",
"494451", "Varel\ Jadebusen",
"498258", "Sielenbach",
"497172", "Lorch\ Württemberg",
"492683", "Asbach\ Westerwald",
"495755", "Kalletal\-Varenholz",
"4933205", "Michendorf",
"495692", "Wolfhagen",
"4939999", "Tutow",
"496123", "Eltville\ am\ Rhein",
"4935693", "Lauschütz",
"4936028", "Kammerforst\ Thüringen",
"495190", "Soltau\-Emmingen",
"496578", "Salmtal",
"494336", "Owschlag",
"497425", "Trossingen",
"496335", "Trulben",
"492642", "Remagen",
"495684", "Frielendorf",
"495086", "Celle\-Scheuen",
"497652", "Hinterzarten",
"4935796", "Panschwitz\-Kuckau",
"4936027", "Lengenfeld\ Unterm\ Stein",
"4936739", "Rottenbach",
"4936379", "Holzengel",
"4936071", "Teistungen",
"498808", "Pähl",
"494704", "Drangstedt",
"493621", "Gotha\ Thüringen",
"495764", "Steyerberg",
"497626", "Kandern",
"499531", "Ebern",
"498146", "Moorenweis",
"497024", "Wendlingen\ am\ Neckar",
"499923", "Teisnach",
"4936082", "Ershausen",
"494251", "Hoya",
"498458", "Gaimersheim",
"499662", "Vilseck",
"4936642", "Harra",
"495633", "Diemelsee",
"495677", "Calden\-Westuffeln",
"498205", "Dasing",
"496171", "Oberursel\ Taunus",
"494768", "Hipstedt",
"492339", "Sprockhövel\-Hasslinghausen",
"4937433", "Gutenfürst",
"4933054", "Liebenwalde",
"4934243", "Bad\ Düben",
"495839", "Wittingen\-Ohrdorf",
"492361", "Recklinghausen",
"495861", "Dannenberg\ Elbe",
"492763", "Drolshagen\-Bleche",
"4936940", "Oepfershausen",
"494546", "Mustin\ Lauenburg",
"497225", "Gaggenau",
"492634", "Rengsdorf",
"498681", "Waging\ am\ See",
"496545", "Blankenrath",
"496651", "Rasdorf",
"495157", "Emmerthal\-Börry",
"499569", "Sesslach",
"4939396", "Neukirchen\ Altmark",
"4933765", "Märkisch\ Buchholz",
"499571", "Lichtenfels\ Bayern",
"496898", "Völklingen",
"499927", "Kirchberg\ Wald",
"497309", "Weissenhorn",
"494320", "Heidmühlen",
"497144", "Marbach\ am\ Neckar",
"498026", "Hausham",
"497959", "Frankenhardt",
"499605", "Weiherhammer",
"499856", "Dürrwangen",
"496131", "Mainz",
"498262", "Mittelneufnach",
"495673", "Immenhausen\ Hessen",
"492154", "Willich",
"492379", "Menden\-Asbeck",
"497193", "Sulzbach\ an\ der\ Murr",
"498624", "Obing",
"4936849", "Kleinschmalkalden",
"497081", "Bad\ Wildbad",
"499145", "Solnhofen",
"4937601", "Mülsen\ Skt\ Jacob",
"494496", "Friesoythe\-Markhausen",
"496348", "Offenbach\ an\ der\ Queich",
"499281", "Hof\ Saale",
"4938223", "Saal\ Vorpom",
"492674", "Bad\ Bertrich",
"4936929", "Ruhla",
"499206", "Mistelgau\-Obernsees",
"495153", "Salzhemmendorf",
"4933365", "Lüdersdorf\ Kreis\ Barnim",
"496725", "Gau\-Algesheim",
"497668", "Ihringen",
"498367", "Rosshaupten\ Forggensee",
"499931", "Plattling",
"496696", "Gilserberg",
"496043", "Nidda",
"494770", "Wischhafen",
"499747", "Geroda\ Bayern",
"492165", "Jüchen",
"498462", "Berching",
"496094", "Weibersbrunn",
"493677", "Ilmenau\ Thüringen",
"49365", "Gera",
"4933232", "Brieselang",
"499523", "Hofheim\ in\ Unterfranken",
"492687", "Horhausen\ Westerwald",
"497132", "Neckarsulm",
"499658", "Georgenberg",
"493764", "Meerane",
"496127", "Niedernhausen\ Taunus",
"495621", "Bad\ Wildungen",
"494752", "Neuhaus\ Oste",
"496082", "Niederreifenberg",
"4934294", "Rackwitz",
"499406", "Mintraching",
"499822", "Bechhofen\ an\ der\ Heide",
"499481", "Pfatter",
"494946", "Grossefehn\-Bagband",
"496295", "Rosenberg\ Baden",
"498052", "Aschau\ im\ Chiemgau",
"494296", "Schwanewede\-Aschwarden",
"496375", "Wallhalben",
"4937381", "Penig",
"49261", "Koblenz\ am\ Rhein",
"493861", "Plate",
"499178", "Abenberg\ Mittelfranken",
"494466", "Wittmund\-Ardorf",
"4938461", "Bützow",
"4933207", "Gross\ Kreutz",
"492427", "Nideggen",
"494174", "Stelle\ Kreis\ Harburg",
"495406", "Belm",
"495822", "Ebstorf",
"4939993", "Hohenmocker",
"495481", "Lengerich\ Westfalen",
"492524", "Ennigerloh",
"496701", "Sprendlingen\ Rheinhessen",
"498284", "Ziemetshausen",
"498756", "Nandlstadt",
"496303", "Enkenbach\-Alsenborn",
"4933208", "Fahrland",
"496786", "Kempfeld",
"496465", "Breidenbach\ bei\ Biedenkopf",
"496254", "Lautertal\ Odenwald",
"4933844", "Brück\ Brandenburg",
"4938424", "Bobitz",
"4938793", "Dergenthin",
"495931", "Meppen",
"4937346", "Geyer",
"498574", "Wittibreut",
"4936025", "Körner",
"498372", "Obergünzburg",
"492269", "Kierspe\-Rönsahl",
"4939226", "Hohenziatz",
"496868", "Mettlach\-Tünsdorf",
"4936373", "Buttstädt",
"4936733", "Kaulsdorf",
"495523", "Bad\ Sachsa",
"498433", "Königsmoos",
"496804", "Mandelbachtal",
"497163", "Ebersbach\ an\ der\ Fils",
"498085", "Sankt\ Wolfgang",
"495658", "Wehretal",
"493923", "Zerbst",
"4933924", "Rägelin",
"4935434", "Altdöbern",
"493531", "Finsterwalde",
"496055", "Freigericht",
"498292", "Dinkelscherben",
"499621", "Amberg\ Oberpfalz",
"496265", "Billigheim\ Baden",
"496454", "Lichtenfels\-Sachsenberg",
"492772", "Herborn\ Hessen",
"498847", "Obersöchering",
"4936481", "Neustadt\ an\ der\ Orla",
"495145", "Beedenbostel",
"4934493", "Gössnitz\ Thüringen",
"496557", "Hallschlag",
"4937439", "Jocketa",
"492431", "Erkelenz",
"497702", "Blumberg\ Baden",
"495281", "Bad\ Pyrmont",
"4933230", "Börnicke\ Kreis\ Havelland",
"492750", "Diedenshausen",
"495206", "Bielefeld\-Jöllenbeck",
"492227", "Bornheim\-Merten",
"499153", "Schnaittach",
"494266", "Brockel",
"492981", "Winterberg\ Westfalen",
"4933767", "Friedersdorf\ bei\ Berlin",
"495571", "Uslar",
"494187", "Holm\-Seppensen",
"492195", "Radevormwald",
"49851", "Passau",
"498722", "Gangkofen",
"496666", "Freiensteinau",
"495605", "Kaufungen\ Hessen",
"4933768", "Prieros",
"498233", "Kissing",
"499673", "Tiefenbach\ Oberpfalz",
"499637", "Falkenberg\ Oberpfalz",
"494665", "Emmelsbüll\-Horsbüll",
"497976", "Sulzbach\-Laufen",
"497346", "Illerkirchberg",
"493971", "Anklam",
"4933334", "Greiffenberg",
"496008", "Echzell",
"493341", "Strausberg",
"4939861", "Gramzow\ bei\ Prenzlau",
"494142", "Steinkirchen\ Kreis\ Stade",
"492732", "Kreuztal",
"497129", "Lichtenstein\ Württemberg",
"496202", "Schwetzingen",
"493969", "Siedenbollentin",
"498583", "Neureichenau",
"499861", "Rothenburg\ ob\ der\ Tauber",
"496553", "Schönecken",
"4936843", "Benshausen",
"492924", "Möhnesee",
"492471", "Roetgen\ Eifel",
"498649", "Schleching",
"496628", "Oberaula",
"497765", "Rickenbach\ Hotzenwald",
"497486", "Horb\-Altheim",
"492223", "Königswinter",
"499157", "Alfeld\ Mittelfranken",
"494509", "Gross\ Grönau",
"497520", "Bodnegg",
"4939824", "Hohenzieritz",
"495025", "Estorf\ Weser",
"498344", "Westendorf\ bei\ Kaufbeuren",
"4936923", "Treffurt",
"498542", "Ortenburg",
"4933367", "Friedrichswalde\ Brandenburg",
"4938229", "Bad\ Sülze",
"498421", "Eichstätt\ Bayern",
"494183", "Jesteburg",
"495531", "Holzminden",
"499764", "Höchheim",
"495923", "Schüttorf",
"498393", "Holzgünz",
"4934361", "Dahlen\ Sachsen",
"496852", "Nohfelden",
"498273", "Nordendorf",
"498237", "Aindling",
"4933368", "Hohensaaten",
"493523", "Coswig\ bei\ Dresden",
"495662", "Felsberg\ Hessen",
"4934324", "Ostrau\ Sachsen",
"494602", "Freienwill",
"499633", "Mitterteich",
"499677", "Oberviechtach\-Pullenried",
"497936", "Schrozberg\-Bartenstein",
"495224", "Enger\ Westfalen",
"4933734", "Felgentreu",
"493931", "Stendal",
"499708", "Bad\ Bocklet",
"494134", "Embsen\ Kreis\ Lüneburg",
"492744", "Herdorf",
"492423", "Langerwehe",
"4936640", "Remptendorf",
"499190", "Heroldsbach",
"492391", "Plettenberg",
"497754", "Görwihl",
"494825", "Burg\ Dithmarschen",
"492271", "Bergheim\ Erft",
"496826", "Bexbach",
"496307", "Schopp",
"495138", "Sehnde",
"499086", "Fremdingen",
"496440", "Kölschhausen",
"496402", "Hungen",
"495971", "Rheine",
"497685", "Gutach\-Bleibach",
"495341", "Salzgitter",
"4938393", "Binz\ Ostseebad",
"492841", "Moers",
"498332", "Ottobeuren",
"495424", "Bad\ Rothenfelde",
"492581", "Warendorf",
"498534", "Tettenweis",
"495743", "Espelkamp\-Gestringen",
"4936333", "Heringen\ Helme",
"492506", "Münster\-Wolbeck",
"495527", "Duderstadt",
"493605", "Leinefelde",
"497851", "Kehl",
"4934444", "Lützen",
"4938874", "Lützow",
"498221", "Günzburg",
"493571", "Hoyerswerda",
"4935474", "Schönwalde\ bei\ Lübben",
"497576", "Krauchenwies",
"4935892", "Horka\ OL",
"498703", "Essenbach",
"495965", "Klein\ Berssen",
"496356", "Carlsberg\ Pfalz",
"498638", "Waldkraiburg",
"4938731", "Lübz",
"4938371", "Karlshagen",
"4938327", "Elmenhorst\ Vorpom",
"4934783", "Gerbstedt",
"499278", "Weidenberg",
"499445", "Neustadt\ an\ der\ Donau",
"49228", "Bonn",
"498386", "Oberstaufen",
"4935055", "Höckendorf\ bei\ Dippoldiswalde",
"499398", "Birkenfeld\ bei\ Würzburg",
"4939953", "Schwinkendorf",
"495453", "Recke",
"492064", "Dinslaken",
"496195", "Kelkheim\ Taunus",
"492666", "Freilingen\ Westerwald",
"494627", "Dörpstedt",
"49781", "Offenburg",
"4938328", "Miltzow",
"494355", "Rieseby",
"497232", "Königsbach\-Stein",
"4939931", "Röbel\ Müritz",
"496059", "Jossgrund",
"4937209", "Einsiedel\ bei\ Chemnitz",
"4936463", "Gebstedt",
"4934909", "Aken\ Elbe",
"496227", "Walldorf\ Baden",
"4933741", "Niedergörsdorf",
"492454", "Gangelt",
"492265", "Reichshof\-Eckenhagen",
"496772", "Nastätten",
"495063", "Bad\ Salzdetfurth",
"4938753", "Wöbbelin",
"499848", "Simmershofen",
"497444", "Alpirsbach",
"497723", "Furtwangen\ im\ Schwarzwald",
"492557", "Wettringen\ Kreis\ Steinfurt",
"496431", "Limburg\ an\ der\ Lahn",
"497321", "Heidenheim\ an\ der\ Brenz",
"494958", "Jemgum",
"497045", "Oberderdingen",
"492804", "Xanten\-Marienbaum",
"494562", "Grömitz",
"494364", "Dahme\ Kreis\ Ostholstein",
"4939036", "Binde",
"499181", "Neumarkt\ in\ der\ Oberpfalz",
"495502", "Dransfeld",
"4938295", "Satow\ bei\ Bad\ Doberan",
"495304", "Meine",
"4933983", "Gross\ Pankow\ Kreis\ Prignitz",
"495253", "Bad\ Driburg",
"499106", "Markt\ Erlbach",
"4935204", "Wilsdruff",
"499245", "Obertrubach",
"494631", "Glücksburg\ Ostsee",
"496269", "Gundelsheim\ Württemberg",
"494308", "Schwedeneck",
"495954", "Lorup",
"495368", "Parsau",
"493902", "Diesdorf\ Altm",
"495149", "Wienhausen",
"4939852", "Schönermark\ bei\ Prenzlau",
"495803", "Rosche",
"496231", "Hochdorf\-Assenheim",
"4938483", "Brüel",
"492303", "Unna",
"4935971", "Sebnitz",
"494863", "Sankt\ Peter\-Ording",
"497244", "Weingarten\ Baden",
"499875", "Wolframs\-Eschenbach",
"492590", "Dülmen\-Buldern",
"495609", "Ahnatal",
"4939409", "Eilsleben",
"4939321", "Arneburg",
"4933437", "Reichenberg\ bei\ Strausberg",
"492254", "Weilerswist",
"492465", "Inden",
"4939364", "Dolle",
"497771", "Stockach",
"497943", "Schöntal\ Jagst",
"496427", "Cölbe\-Schönstadt",
"497373", "Zwiefalten",
"497337", "Nellingen\ Alb",
"499093", "Polsingen",
"499646", "Freihung",
"496524", "Rodershausen",
"4933438", "Altlandsberg",
"496322", "Bad\ Dürkheim",
"497432", "Albstadt\-Tailfingen",
"492953", "Wünnenberg",
"494505", "Stockelsdorf\-Curau",
"4937369", "Wolkenstein",
"495565", "Einbeck\-Wenzen",
"495257", "Hövelhof",
"4933831", "Weseram",
"499438", "Fensterbach",
"497834", "Wolfach",
"4934603", "Nauendorf\ Sachsen\-Anhalt",
"499260", "Wilhelmsthal\ Oberfranken",
"496841", "Homburg\ Saar",
"494671", "Bredstedt",
"4935953", "Burkau",
"4939055", "Hörsingen",
"496581", "Saarburg",
"498551", "Freyung",
"497125", "Bad\ Urach",
"4936256", "Wechmar",
"496506", "Welschbillig",
"493965", "Burow\ bei\ Altentreptow",
"4936202", "Neudietendorf",
"496271", "Eberbach\ Baden",
"492826", "Kranenburg\ Niederrhein",
"498105", "Gilching",
"495807", "Altenmedingen",
"499835", "Ehingen\ Mittelfranken",
"4935931", "Königswartha",
"492307", "Kamen",
"495326", "Langelsheim",
"4939721", "Liepen\ bei\ Anklam",
"4938841", "Neuhaus\ Elbe",
"492440", "Nettersheim\-Tondorf",
"4939777", "Borkenfriede",
"4933477", "Trebnitz\ bei\ Müncheberg",
"492402", "Stolberg\ Rheinland",
"497731", "Singen\ Hohentwiel",
"496744", "Oberwesel",
"497333", "Laichingen",
"496423", "Wetter\ Hessen",
"497947", "Forchtenberg",
"4938782", "Reetz\ bei\ Perleberg",
"494151", "Schwarzenbek",
"499097", "Marxheim",
"497472", "Rottenburg\ am\ Neckar",
"492957", "Wünnenberg\-Haaren",
"496391", "Dahn",
"4933478", "Gross\ Neuendorf",
"498246", "Waal",
"49234", "Bochum",
"4939778", "Ferdinandshof\ bei\ Torgelow",
"495902", "Freren",
"498707", "Adlkofen",
"494962", "Papenburg\-Aschendorf",
"494558", "Todesfelde",
"4933085", "Seilershof",
"498678", "Marktl",
"4938331", "Rakow\ Vorpom",
"499238", "Röslau",
"4938727", "Mestlin",
"4934383", "Trebsen\ Mulde",
"495457", "Hopsten\-Schale",
"497384", "Schelklingen\-Hütten",
"497842", "Kappelrodeck",
"497582", "Bad\ Buchau",
"494829", "Wewelsfleth",
"4939204", "Niederndodeleben",
"495352", "Schöningen",
"493304", "Velten",
"495554", "Moringen",
"4938728", "Domsühl",
"494623", "Böklund",
"492852", "Hamminkeln",
"498446", "Pörnbach",
"499385", "Kolitzheim",
"4939883", "Gross\ Dölln",
"497272", "Rülzheim",
"4939971", "Gnoien",
"492628", "Rhens",
"4934347", "Oelzschau\ bei\ Borna",
"498158", "Tutzing",
"4938452", "Lalendorf",
"4939927", "Nossentiner\ Hütte",
"496223", "Neckargemünd",
"496188", "Kahl\ am\ Main",
"495776", "Preussisch\ Ströhen",
"4934348", "Frohburg",
"496732", "Wörrstadt",
"497543", "Kressbronn\ am\ Bodensee",
"499072", "Lauingen\ Donau",
"492202", "Bergisch\ Gladbach",
"4939928", "Möllenhagen",
"495067", "Bockenem",
"4935364", "Lebusa",
"497727", "Vöhrenbach",
"492553", "Ochtrup",
"4936762", "Steinach\ Thüringen",
"4938353", "Gützkow\ bei\ Greifswald",
"497250", "Kraichtal",
"496471", "Weilburg",
"497392", "Laupheim",
"4936695", "Söllmnitz",
"497641", "Emmendingen",
"4936200", "Elxleben\ bei\ Arnstadt",
"4939959", "Dargun",
"496634", "Gemünden\ Felda",
"497267", "Gemmingen",
"492545", "Rosendahl\-Darfeld",
"492651", "Mayen",
"499776", "Mellrichstadt",
"496036", "Wölfersheim",
"497555", "Deggenhausertal",
"498121", "Markt\ Schwaben",
"4935057", "Hermsdorf\ Erzgebirge",
"494483", "Ovelgönne\-Grossenmeer",
"495072", "Neustadt\-Mandelsloh",
"4938325", "Rolofshagen",
"496361", "Rockenhausen",
"496763", "Kirchberg\ Hunsrück",
"4935058", "Pretzschendorf",
"492938", "Ense",
"494977", "Blomberg\ Ostfriesland",
"494933", "Dornum\ Ostfriesland",
"4935756", "Hosena",
"494347", "Flintbek",
"498735", "Gangkofen\-Kollbach",
"4938780", "Lanz\ Brandenburg",
"492171", "Leverkusen\-Opladen",
"497429", "Egesheim",
"496339", "Grosssteinhausen",
"494442", "Lohne\ Oldenburg",
"494521", "Eutin",
"4938759", "Tewswoos",
"495238", "Nieheim\-Himmighausen",
"494234", "Dörverden",
"4937203", "Gersdorf\ bei\ Chemnitz",
"4935775", "Pechern",
"499554", "Untersteinbach\ Unterfranken",
"499352", "Lohr\ am\ Main",
"4939291", "Calbe\ Saale",
"4934903", "Coswig\ Anhalt",
"4934745", "Winningen\ Sachsen\-Anhalt",
"492335", "Wetter\ Ruhr",
"4933094", "Löwenberg",
"494872", "Hanerau\-Hademarschen",
"496642", "Schlitz",
"499326", "Markt\ Einersheim",
"498137", "Petershausen",
"495835", "Wahrenholz",
"493588", "Niesky",
"494128", "Kollmar",
"497564", "Bad\ Wurzach",
"494283", "Tarmstedt",
"497362", "Bopfingen",
"4933989", "Sadenbeck",
"497467", "Neuhausen\ ob\ Eck",
"4938297", "Moitin",
"4933652", "Neuzelle",
"499565", "Untersiemau",
"494537", "Sülfeld\ Holstein",
"4933606", "Müllrose",
"496683", "Ehrenberg\ Rhön",
"499720", "Üchtelhausen",
"494434", "Colnrade",
"499257", "Zell\ Oberfranken",
"493445", "Naumburg\ Saale",
"495438", "Bakum\-Lüsche",
"4933435", "Rehfelde",
"496102", "Neu\-Isenburg",
"497229", "Iffezheim",
"494242", "Syke",
"4938450", "Tarnow\ bei\ Bützow",
"4939403", "Gröningen\ Sachsen\-Anhalt",
"4933703", "Sperenberg",
"492945", "Lippstadt\-Benninghausen",
"499803", "Colmberg",
"494832", "Meldorf",
"492375", "Balve",
"498133", "Haimhausen\ Oberbayern",
"498177", "Münsing\ Starnberger\ See",
"495875", "Emmendorf",
"4934609", "Salzmünde",
"4939057", "Rätzlingen\ Sachsen\-Anhalt",
"49661", "Fulda",
"497955", "Wallhausen\ Württemberg",
"4937462", "Rothenkirchen\ Vogtland",
"497305", "Erbach\ Donau",
"494287", "Heeslingen\-Boitzen",
"4937363", "Zöblitz",
"495044", "Springe\-Eldagsen",
"497463", "Mühlheim\ an\ der\ Donau",
"492538", "Drensteinfurt\-Rinkerode",
"495646", "Willebadessen",
"4939058", "Uthmöden",
"492295", "Ruppichteroth",
"493385", "Rathenow",
"494533", "Reinfeld\ Holstein",
"495181", "Alfeld\ Leine",
"4933456", "Wriezen",
"499502", "Frensdorf",
"494166", "Ahlerstedt",
"494921", "Emden\ Stadt",
"498657", "Ramsau\ bei\ Berchtesgaden",
"498325", "Oberstaufen\-Thalkirchdorf",
"496020", "Heigenbrücken",
"499253", "Weissenstadt",
"494474", "Garrel",
"4933475", "Letschin",
"495245", "Herzebrock\-Clarholz",
"4939775", "Ahlbeck\ bei\ Torgelow",
"492696", "Nohn\ Eifel",
"492043", "Gladbeck",
"496165", "Breuberg",
"4934425", "Droyssig",
"499149", "Weissenburg\-Suffersheim",
"49421", "Bremen",
"499954", "Simbach\ Niederbayern",
"497053", "Bad\ Teinach\-Zavelstein",
"494844", "Pellworm",
"494382", "Wangels",
"4933088", "Falkenthal",
"4939262", "Güsten\ Anh",
"497263", "Waibstadt",
"496674", "Friedewald\ Hessen",
"494893", "Hohenaspe",
"499736", "Oberthulba",
"498192", "Schondorf\ am\ Ammersee",
"494487", "Grossenkneten\-Huntlosen",
"492725", "Lennestadt\-Oedingen",
"4938725", "Gross\ Godems",
"495032", "Neustadt\ am\ Rübenberge",
"498041", "Bad\ Tölz",
"497358", "Eberhardzell\-Füramoos",
"497964", "Stödtlen",
"4933087", "Bredereiche",
"495848", "Trebel",
"49441", "Oldenburg",
"494343", "Laboe",
"494973", "Wittmund\-Burhafe",
"499965", "Sankt\ Englmar",
"494741", "Nordholz\ bei\ Bremerhaven",
"492131", "Neuss",
"4936704", "Steinheid",
"496154", "Ober\-Ramstadt",
"494394", "Bokhorst",
"495445", "Drebber",
"495278", "Höxter\-Ovenhausen",
"494274", "Varrel\ bei\ Sulingen",
"499453", "Thalmassing",
"4939889", "Boitzenburg",
"4935023", "Bad\ Gottleuba",
"4939925", "Wredenhagen",
"4934345", "Bad\ Lausick",};

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+49|\D)//g;
      my $self = bless({ number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:0)//;
      $self = bless({ number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;