# automatically generated file, don't edit



# Copyright 2011 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::AT;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20210921211828;

my $formatters = [
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            1(?:
              11|
              [2-9]
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d)(\\d{3,12})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '517',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '5[079]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3,5})'
                },
                {
                  'format' => '$1',
                  'intl_format' => 'NA',
                  'leading_digits' => '1',
                  'pattern' => '(\\d{6})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            (?:
              31|
              4
            )6|
            51|
            6(?:
              5[0-3579]|
              [6-9]
            )|
            7(?:
              20|
              32|
              8
            )|
            [89]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3,10})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            [2-467]|
            5[2-6]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{3,9})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '5',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{3,4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '5',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{4})(\\d{4,7})'
                }
              ];

my $validators = {
                'fixed_line' => '
          1(?:
            11\\d|
            [2-9]\\d{3,11}
          )|
          (?:
            316|
            463|
            (?:
              51|
              66|
              73
            )2
          )\\d{3,10}|
          (?:
            2(?:
              1[467]|
              2[13-8]|
              5[2357]|
              6[1-46-8]|
              7[1-8]|
              8[124-7]|
              9[1458]
            )|
            3(?:
              1[1-578]|
              3[23568]|
              4[5-7]|
              5[1378]|
              6[1-38]|
              8[3-68]
            )|
            4(?:
              2[1-8]|
              35|
              7[1368]|
              8[2457]
            )|
            5(?:
              2[1-8]|
              3[357]|
              4[147]|
              5[12578]|
              6[37]
            )|
            6(?:
              13|
              2[1-47]|
              4[135-8]|
              5[468]
            )|
            7(?:
              2[1-8]|
              35|
              4[13478]|
              5[68]|
              6[16-8]|
              7[1-6]|
              9[45]
            )
          )\\d{4,10}
        ',
                'geographic' => '
          1(?:
            11\\d|
            [2-9]\\d{3,11}
          )|
          (?:
            316|
            463|
            (?:
              51|
              66|
              73
            )2
          )\\d{3,10}|
          (?:
            2(?:
              1[467]|
              2[13-8]|
              5[2357]|
              6[1-46-8]|
              7[1-8]|
              8[124-7]|
              9[1458]
            )|
            3(?:
              1[1-578]|
              3[23568]|
              4[5-7]|
              5[1378]|
              6[1-38]|
              8[3-68]
            )|
            4(?:
              2[1-8]|
              35|
              7[1368]|
              8[2457]
            )|
            5(?:
              2[1-8]|
              3[357]|
              4[147]|
              5[12578]|
              6[37]
            )|
            6(?:
              13|
              2[1-47]|
              4[135-8]|
              5[468]
            )|
            7(?:
              2[1-8]|
              35|
              4[13478]|
              5[68]|
              6[16-8]|
              7[1-6]|
              9[45]
            )
          )\\d{4,10}
        ',
                'mobile' => '
          6(?:
            5[0-3579]|
            6[013-9]|
            [7-9]\\d
          )\\d{4,10}
        ',
                'pager' => '',
                'personal_number' => '',
                'specialrate' => '(
          8(?:
            10|
            2[018]
          )\\d{6,10}|
          828\\d{5}
        )|(
          9(?:
            0[01]|
            3[019]
          )\\d{6,10}
        )',
                'toll_free' => '800\\d{6,10}',
                'voip' => '
          5(?:
            0[1-9]|
            17|
            [79]\\d
          )\\d{2,10}|
          7[28]0\\d{6,10}
        '
              };
my %areanames = ();
$areanames{en} = {"435413", "St\.\ Leonhard\ im\ Pitztal",
"434266", "Strassburg",
"436217", "Mattsee",
"432738", "Fels\ am\ Wagram",
"433172", "Weiz",
"437288", "Ulrichsberg",
"433454", "Leutschach",
"432612", "Oberpullendorf",
"437673", "Schwanenstadt",
"436455", "Untertauern",
"433622", "Bad\ Aussee",
"436138", "St\.\ Wolfgang\ im\ Salzkammergut",
"433150", "Paldau",
"437713", "Schardenberg",
"432772", "Neulengbach",
"433455", "Arnfels",
"436454", "Mandling",
"434252", "Wernberg",
"436219", "Obertrum\ am\ See",
"432259", "Münchendorf",
"432680", "St\.\ Margarethen\ im\ Burgenland",
"433858", "Mitterdorf\ im\ Mürztal",
"437249", "Bad\ Schallerbach",
"432257", "Klausen\-Leopoldsdorf",
"4318", "Vienna",
"434733", "Malta",
"432143", "Kittsee",
"437247", "Kematen\ am\ Innbach",
"433176", "Stubenberg",
"435553", "Raggal",
"433464", "Gross\ St\.\ Florian",
"432231", "Purkersdorf",
"434357", "St\.\ Paul\ im\ Lavanttal",
"434262", "Treibach",
"433465", "Pölfing\-Brunn",
"437488", "Steinakirchen\ am\ Forst",
"434256", "Nötsch\ im\ Gailtal",
"436417", "Hüttschlag",
"434784", "Mallnitz",
"433514", "Seckau",
"432524", "Kautendorf",
"435213", "Scharnitz",
"434359", "Reichenfels",
"432525", "Gnadendorf",
"432616", "Lockenhaus",
"434785", "Ausserfragant",
"433515", "St\.\ Lorenzen\ bei\ Knittelfeld",
"432641", "Kirchberg\ am\ Wechsel",
"434226", "St\.\ Margareten\ im\ Rosental",
"432267", "Sierndorf",
"432554", "Stützenhofen",
"432555", "Herrnbaumgarten",
"432913", "Hötzelsdorf",
"432269", "Niederfellabrunn",
"435523", "Götzis",
"432215", "Probstdorf",
"436224", "Hintersee",
"433868", "Tragöss",
"436225", "Eugendorf",
"432214", "Kopfstetten",
"433136", "Dobl",
"437482", "Scheibbs",
"433145", "Edelschrott",
"432816", "Karlstift",
"436563", "Uttendorf",
"435264", "Mieming",
"435557", "St\.\ Gallenkirch",
"434353", "Prebl",
"436136", "Gosau",
"433144", "Köflach",
"432271", "Ried\ am\ Riederberg",
"435265", "Nassereith",
"435559", "Brand",
"437286", "Lembach\ im\ Mühlkreis",
"432736", "Paudorf",
"437754", "Waldzell",
"434825", "Grosskirchheim",
"432745", "Pyhra",
"436413", "Wagrain",
"434268", "Friesach",
"434824", "Heiligenblut",
"437755", "Mettmach",
"432744", "Kasten\ bei\ Böheimkirchen",
"433571", "Möderbrugg",
"437724", "Mauerkirchen",
"434855", "Assling",
"432263", "Grossrussbach",
"437443", "Ybbsitz",
"433862", "Bruck\ an\ der\ Mur",
"433856", "Veitsch",
"437684", "Frankenmarkt",
"432841", "Vitis",
"432618", "Markt\ St\.\ Martin",
"435417", "Roppen",
"437764", "Riedau",
"435515", "Au",
"436132", "Bad\ Ischl",
"434230", "Globasnitz",
"437765", "Lambrechten",
"435514", "Bezau",
"436213", "Oberhofen\ am\ Irrsee",
"434258", "Gummern",
"432812", "Gross\ Gerungs",
"437719", "Taufkirchen\ an\ der\ Pram",
"433132", "Kumberg",
"437486", "Lunz\ am\ See",
"435254", "Sölden",
"434761", "Stockenboi",
"432732", "Krems\ an\ der\ Donau",
"436240", "Krispl",
"437717", "St\.\ Aegidi",
"435255", "Umhausen",
"437282", "Neufelden",
"433178", "St\.\ Ruprecht\ an\ der\ Raab",
"437945", "St\.\ Oswald\ bei\ Freistadt",
"432954", "Göllersdorf",
"435224", "Wattens",
"433866", "Breitenau\ am\ Hochlantsch",
"437944", "Sandl",
"435225", "Fulpmes",
"432955", "Grossweikersdorf",
"4316", "Vienna",
"432253", "Oberwaltersdorf",
"432147", "Zurndorf",
"437243", "Marchtrenk",
"434228", "Feistritz\ im\ Rosental",
"433852", "Mürzzuschlag",
"435282", "Zell\ am\ Ziller",
"434768", "Kleblach\-Lind",
"437255", "Losenstein",
"433171", "Gasen",
"432244", "Langenzersdorf",
"433383", "Burgau",
"432236", "Mödling",
"432245", "Wolkersdorf\ im\ Weinviertel",
"437254", "Grossraming",
"435677", "Vils",
"435633", "Hägerau",
"432943", "Obritz",
"432611", "Mannersdorf\ an\ der\ Rabnitz",
"437953", "Liebenau",
"435243", "Maurach",
"433885", "Greith",
"433536", "St\.\ Peter\ am\ Kammersberg",
"436544", "Rauris",
"4346", "Klagenfurt",
"432646", "Kirchschlag\ in\ der\ Buckligen\ Welt",
"432635", "Neunkirchen",
"434221", "Gallizien",
"436545", "Bruck\ an\ der\ Grossglocknerstrasse",
"432634", "Gutenstein",
"435550", "Thüringen",
"433884", "Wegscheid",
"432982", "Horn",
"432874", "Martinsberg",
"435374", "Walchsee",
"437662", "Seewalchen\ am\ Attersee",
"437225", "Hargelsberg",
"435572", "Dornbirn",
"432875", "Grafenschlag",
"437224", "St\.\ Florian",
"432763", "St\.\ Veit\ an\ der\ Gölsen",
"435375", "Kössen",
"432232", "Fischamend",
"437217", "St\.\ Veit\ im\ Mühlkreis",
"432683", "Purbach\ am\ Neusiedler\ See",
"435286", "Ginzling",
"433123", "St\.\ Oswald\ bei\ Plankenwarth",
"433833", "Traboch",
"432278", "Absdorf",
"437265", "Pabneukirchen",
"433637", "Gams\ bei\ Hieflau",
"437219", "Vorderweissenbach",
"437264", "Windhaag\ bei\ Perg",
"434843", "Ausservillgraten",
"432723", "Rabenstein\ an\ der\ Pielach",
"437743", "Maria\ Schmolln",
"433335", "Pöllau",
"432848", "Pfaffenschlag\ bei\ Waidhofen",
"432642", "Aspangberg\-St\.\ Peter",
"433532", "Murau",
"432753", "Gansbach",
"433334", "Kaindorf",
"434237", "Miklauzhof",
"434273", "Reifnitz",
"436247", "Grossgmain",
"435443", "Galtür",
"435576", "Hohenems",
"433578", "Obdach",
"434239", "St\.\ Kanzian\ am\ Klopeiner\ See",
"437666", "Attersee",
"433153", "Riegersburg",
"432986", "Irnfritz",
"437213", "Bad\ Leonfelden",
"432272", "Tulln\ an\ der\ Donau",
"433127", "Peggau",
"432687", "Siegendorf",
"437240", "Sipbachzell",
"433633", "Landl",
"432238", "Kaltenleutgeben",
"432164", "Rohrau",
"434847", "Obertilliach",
"432689", "Hornstein",
"432165", "Hainburg\ a\.d\.\ Donau",
"434766", "Millstatt",
"433861", "Aflenz",
"437747", "Kirchberg\ bei\ Mattighofen",
"433159", "Bad\ Gleichenberg",
"432757", "Pöchlarn",
"43662", "Salzburg",
"433572", "Judenburg",
"434277", "Glanegg",
"434233", "Griffen",
"435449", "Fliess",
"436243", "Abtenau",
"432842", "Waidhofen\ an\ der\ Thaya",
"432648", "Hochneukirchen",
"434279", "Sirnitz",
"435447", "Flirsch",
"433157", "Kapfenstein",
"432949", "Niederfladnitz",
"434285", "Tröpolach",
"433387", "Söchau",
"434284", "Kirchbach",
"435673", "Ehrwald",
"432276", "Reidling",
"437563", "Spital\ am\ Pyhrn",
"436131", "Obertraun",
"432731", "Idolsberg",
"435288", "Fügen",
"434762", "Spittal\ an\ der\ Drau",
"437281", "Aigen\ im\ Mühlkreis",
"432947", "Theras",
"437413", "Marbach\ an\ der\ Donau",
"432988", "Neupölla",
"434350", "Bad\ St\.\ Leonhard\ im\ Lavanttal",
"433576", "Bretstein",
"435578", "Höchst",
"432714", "Rossatz",
"432769", "Türnitz",
"432715", "Weissenkirchen\ in\ der\ Wachau",
"432674", "Weissenbach\ an\ der\ Triesting",
"433684", "St\.\ Martin\ am\ Grimming",
"433114", "Markt\ Hartmannsdorf",
"435334", "Westendorf",
"433115", "Studenzen",
"433685", "Gröbming",
"432846", "Raabs\ an\ der\ Thaya",
"435335", "Hopfgarten\ im\ Brixental",
"432767", "Hohenberg",
"432247", "Deutsch\-Wagram",
"437565", "St\.\ Pankraz",
"435675", "Tannheim",
"434283", "St\.\ Stefan\ im\ Gailtal",
"435674", "Bichlbach",
"437257", "Grünburg",
"437564", "Hinterstoder",
"437415", "Altenmarkt\,\ Yspertal",
"432532", "Zistersdorf",
"432249", "Gross\-Enzersdorf",
"436588", "Lofer",
"434872", "Huben",
"437414", "Weins\-Isperdorf",
"434718", "Dellach",
"433588", "Katsch\ an\ der\ Mur",
"433848", "Eisenerz",
"437259", "Sierning",
"436278", "Ostermiething",
"436547", "Kaprun",
"432713", "Spitz",
"433140", "St\.\ Martin\ am\ Wöllmissberg",
"435276", "Gschnitz",
"432673", "Altenmarkt\ an\ der\ Triesting",
"432637", "Grünbach\ am\ Schneeberg",
"437612", "Gmunden",
"434242", "Villach",
"437229", "Traun",
"436232", "Mondsee",
"435333", "Söll",
"436549", "Piesendorf",
"432877", "Grainbrunn",
"432288", "Auersthal",
"433113", "Pischelsdorf\ in\ der\ Steiermark",
"433683", "Donnersbach",
"437750", "Andrichsfurt",
"435472", "Prutz",
"437227", "Neuhofen\ an\ der\ Krems",
"432639", "Bad\ Fischau",
"437214", "Reichenthal",
"437269", "Baumgartenberg",
"437215", "Hellmonsödt",
"435582", "Klösterle",
"432163", "Petronell\-Carnuntum",
"433634", "Hieflau",
"434876", "Kals\ am\ Grossglockner",
"433635", "Radmer",
"437267", "Mönchdorf",
"432536", "Drösing",
"433611", "Johnsbach",
"432621", "Sieggraben",
"434235", "Bleiburg",
"434246", "Radenthein",
"435510", "Damüls",
"437616", "Grünau\ im\ Almtal",
"435272", "Steinach\ am\ Brenner",
"434234", "Ruden",
"433337", "Vorau",
"436432", "Bad\ Hofgastein",
"437231", "Herzogsdorf",
"435238", "Zirl",
"435476", "Serfaus",
"436244", "Golling\ an\ der\ Salzach",
"433339", "Friedberg",
"436245", "Hallein",
"436478", "Zederhaus",
"433846", "Kalwang",
"433125", "Übelbach",
"432685", "Rust",
"434716", "Lesachtal",
"433586", "Mühlen",
"432169", "Trautmannsdorf\ an\ der\ Leitha",
"432684", "Schützen\ am\ Gebirge",
"433834", "Wald\ am\ Schoberpass",
"433124", "Gratkorn",
"432167", "Neusiedl\ am\ See",
"432725", "Frankenfels",
"432576", "Ernstbrunn",
"437263", "Bad\ Zell",
"432724", "Schwarzenbach\ an\ der\ Pielach",
"434275", "Ebene\ Reichenau",
"437744", "Munderfing",
"432755", "Mank",
"435232", "Kematen\ in\ Tirol",
"433472", "Mureck",
"432286", "Obersiebenbrunn",
"434274", "Velden\ am\ Wörther\ See",
"436472", "Mauterndorf",
"437745", "Lochen",
"432754", "Loosdorf",
"437736", "Pram",
"433333", "Sebersdorf",
"433155", "Fehring",
"435445", "Kappl",
"435278", "Navis",
"435444", "Ischgl",
"436276", "Nussdorf\ am\ Haunsberg",
"435635", "Elmen",
"432538", "Velm\-Götzendorf",
"432243", "Klosterneuburg",
"433385", "Ilz",
"436582", "Saalfelden\ am\ Steinernen\ Meer",
"437253", "Wolfern",
"435634", "Elbigenalp",
"433582", "Scheifling",
"434712", "Greifenburg",
"433842", "Leoben",
"432572", "Mistelbach",
"437955", "Königswiesen",
"432944", "Haugsdorf",
"437954", "St\.\ Georgen\ am\ Walde",
"432945", "Zellerndorf",
"435244", "Jenbach",
"432717", "Unter\-Meisling",
"433689", "St\.\ Nikolai\ im\ Sölktal",
"437732", "Haag\ am\ Hausruck",
"433119", "St\.\ Marein\ bei\ Graz",
"436543", "Taxenbach",
"436476", "St\.\ Margarethen\ im\ Lungau",
"435339", "Wildschönau",
"432282", "Gänserndorf",
"432633", "Markt\ Piesting",
"433476", "Bad\ Radkersburg",
"435245", "Hinterriss",
"433883", "Terz",
"433460", "Soboth",
"435236", "Gries\ im\ Sellrain",
"437471", "Neustadtl\ an\ der\ Donau",
"435337", "Brixlegg",
"435373", "Ebbs",
"436272", "Oberndorf\ bei\ Salzburg",
"432765", "Kaumberg",
"433687", "Schladming",
"433117", "Eggersdorf\ bei\ Graz",
"432719", "Dross",
"432873", "Kottes",
"437223", "Enns",
"432764", "Hainfeld",
"437618", "Neukirchen\,\ Altmünster",
"434248", "Treffen",
"436215", "Strasswalchen",
"433366", "Kohfidisch",
"437763", "Kopfing\ im\ Innkreis",
"435513", "Hittisau",
"432662", "Gloggnitz",
"436214", "Henndorf\ am\ Wallersee",
"435253", "Längenfeld",
"433457", "Gleinstätten",
"436457", "Flachau",
"433352", "Oberwart",
"437432", "Strengberg",
"435223", "Hall\ in\ Tirol",
"432953", "Nappersdorf",
"433616", "Selzthal",
"432626", "Mattersburg",
"437943", "Windhaag\ bei\ Freistadt",
"433322", "Güssing",
"432786", "Oberwölbling",
"437478", "Oed\-Oehling",
"432254", "Ebreichsdorf",
"437245", "Lambach",
"437236", "Pregarten",
"432176", "Tadten",
"432160", "Jois",
"432255", "Deutsch\ Brodersdorf",
"437244", "Sattledt",
"432666", "Reichenau",
"436564", "Krimml",
"433467", "Schwanberg",
"435263", "Silz",
"434355", "Gemmersdorf",
"433362", "Grosspetersdorf",
"436565", "Neukirchen\ am\ Grossvenediger",
"436467", "Mühlbach\ am\ Hochkönig",
"434354", "Preitenegg",
"433143", "Krottendorf",
"433356", "Markt\ Allhau",
"437753", "Eberschwang",
"432527", "Wulzeshofen",
"436414", "Grossarl",
"435358", "Ellmau",
"432858", "Moorbad\ Harbach",
"434212", "St\.\ Veit\ an\ der\ Glan",
"433469", "St\.\ Oswald\ im\ Freiland",
"436415", "Schwarzach\ im\ Pongau",
"434823", "Tresdorf\,\ Rangersdorf",
"432743", "Böheimkirchen",
"437588", "Ried\ im\ Traunkreis",
"433680", "Donnersbachwald",
"432557", "Bernhardsthal",
"437723", "Altheim",
"433326", "Stegersbach",
"437444", "Opponitz",
"432264", "Rückersdorf\,\ Harmannsdorf",
"432828", "Rappottenstein",
"436229", "Hof\ bei\ Salzburg",
"432622", "Wiener\ Neustadt",
"434853", "Ainet",
"437445", "Hollenstein\ an\ der\ Ybbs",
"437278", "Neukirchen\ am\ Walde",
"432265", "Hausleiten",
"433612", "Liezen",
"433182", "Wildon",
"436227", "St\.\ Gilgen",
"432172", "Frauenkirchen",
"437683", "Frankenburg\ am\ Hausruck",
"437232", "St\.\ Martin\ im\ Mühlkreis",
"432782", "Herzogenburg",
"435554", "Sonntag",
"432630", "Ternitz",
"433463", "Stainz",
"435352", "St\.\ Johann\ in\ Tirol",
"432852", "Gmünd",
"437759", "Antiesenhofen",
"436463", "Annaberg\-Lungötz",
"433147", "Salla",
"437582", "Kirchdorf\ an\ der\ Krems",
"432749", "Prinzersdorf",
"433513", "Bischoffeld",
"434783", "Reisseck",
"437757", "Gurten",
"432523", "Kirchstetten\,\ Neudorf\ bei\ Staatz",
"435214", "Leutasch",
"432747", "Ober\-Grafendorf",
"433149", "Geistthal",
"437250", "Maria\ Neustift",
"437727", "Ach",
"432915", "Drosendorf\-Zissersdorf",
"436471", "Tweng",
"437238", "Mauthausen",
"432914", "Japons",
"437476", "Aschbach\-Markt",
"435524", "Satteins",
"436223", "Anthering",
"432822", "Zwettl\,\ Lower\ Austria",
"437729", "Neukirchen\ an\ der\ Enknach",
"432628", "Felixdorf",
"437272", "Eferding",
"433618", "Hohentauern",
"432213", "Lassee",
"435525", "Nenzing",
"437586", "Pettenbach",
"435414", "Wenns",
"437767", "Eggerding",
"433581", "Oberwölz",
"432856", "Weitra",
"435356", "Kitzbühel",
"435517", "Riezlern",
"433358", "Litzelsdorf",
"4313", "Vienna",
"432862", "Heidenreichstein",
"433453", "Ehrenhausen",
"437674", "Attnang\-Puchheim",
"435519", "Schröcken",
"437714", "Esternberg",
"43732", "Linz",
"437675", "Ampflwang\ im\ Hausruckwald",
"436453", "Filzmoos",
"432957", "Hohenwarth",
"437472", "Amstetten",
"437947", "Kefermarkt",
"434734", "Rennweg",
"432144", "Deutsch\ Jahrndorf",
"432959", "Sitzendorf\ an\ der\ Schmida",
"437276", "Peuerbach",
"437260", "Waldhausen",
"437949", "Rainbach\ im\ Mühlkreis",
"434735", "Kremsbrücke",
"432145", "Prellenkirchen",
"432826", "Rastenfeld",
"433328", "Kukmirn",
"437948", "Hirschbach\ im\ Mühlkreis",
"436226", "Fuschl\ am\ See",
"433329", "Jennersdorf",
"432958", "Maissau",
"432216", "Leopoldsdorf\ im\ Marchfelde",
"437221", "Hörsching",
"432556", "Grosskrut",
"433327", "St\.\ Michael\ im\ Burgenland",
"436541", "Saalbach",
"434224", "Pischeldorf",
"437473", "Blindenmarkt",
"432631", "Pöttsching",
"434225", "Grafenstein",
"432615", "Lutzmannsburg",
"436452", "Radstadt",
"433516", "Kleinlobming",
"432526", "Stronsdorf",
"435518", "Mellau",
"433357", "Pinkafeld",
"432774", "Innermanzing",
"434254", "Faak\ am\ See",
"433624", "Pichl\-Kainisch",
"433452", "Leibnitz",
"432614", "Kleinwarasdorf",
"434255", "Arnoldstein",
"432863", "Eggern",
"435230", "Sellrain",
"432667", "Schwarzau\ im\ Gebirge",
"433466", "Eibiswald",
"433174", "Birkfeld",
"433359", "Loipersdorf\-Kitzladen",
"436466", "Werfenweng",
"436470", "Atzmannsdorf",
"437251", "Schiedlberg",
"433175", "Anger",
"432629", "Warth\,\ Lower\ Austria",
"433619", "Oppenberg",
"437237", "St\.\ Georgen\ an\ der\ Gusen",
"437273", "Aschach\ an\ der\ Donau",
"434858", "Nikolsdorf",
"432212", "Orth\ an\ der\ Donau",
"432177", "Podersdorf\ am\ See",
"432823", "Grossglobnitz",
"437728", "Schwand\ im\ Innkreis",
"437239", "Lichtenberg",
"432627", "Pitten",
"433617", "Gaishorn\ am\ See",
"434710", "Oberdrauburg",
"433331", "St\.\ Lorenzen\ am\ Wechsel",
"432552", "Poysdorf",
"433148", "Kainach\ bei\ Voitsberg",
"433456", "Fresing",
"437261", "Schönau\ im\ Mühlkreis",
"432522", "Laa\ an\ der\ Thaya",
"436456", "Obertauern",
"433512", "Knittelfeld",
"434782", "Obervellach",
"434264", "Klein\ St\.\ Paul",
"437583", "Kremsmünster",
"432748", "Kilb",
"436462", "Bischofshofen",
"432853", "Schrems",
"434265", "Weitensfeld\ im\ Gurktal",
"435353", "Waidring",
"433462", "Deutschlandsberg",
"437758", "Obernberg\ am\ Inn",
"432783", "Traismauer",
"437277", "Waizenkirchen",
"437233", "Feldkirchen\ an\ der\ Donau",
"432827", "Schönbach",
"432173", "Gols",
"437682", "Vöcklamarkt",
"433864", "St\.\ Marein\ im\ Mürztal",
"437279", "Haibach\ ob\ der\ Donau",
"435226", "Neustift\ im\ Stubaital",
"432956", "Ziersdorf",
"434852", "Lienz",
"433613", "Admont",
"433183", "St\.\ Georgen\ an\ der\ Stiefing",
"432623", "Pottendorf",
"433865", "Kindberg",
"436228", "Faistenau",
"432829", "Schweiggers",
"437722", "Braunau\ am\ Inn",
"437946", "Gutau",
"435256", "Untergurgl",
"434822", "Winklern",
"432742", "St\.\ Pölten",
"436468", "Werfen",
"435359", "Hochfilzen",
"434213", "Launsdorf",
"433468", "St\.\ Oswald\ ob\ Eibiswald",
"432859", "Brand\-Nagelberg",
"437752", "Ried\ im\ Innkreis",
"437587", "Wartberg\ an\ der\ Krems",
"437485", "Gaming",
"433142", "Voitsberg",
"433363", "Rechnitz",
"437766", "Andorf",
"432857", "Bad\ Grosspertholz",
"4312", "Vienna",
"434240", "Bad\ Kleinkirchheim",
"437484", "Göstling\ an\ der\ Ybbs",
"435262", "Telfs",
"435516", "Doren",
"435357", "Kirchberg\ in\ Tirol",
"433854", "Langenwang",
"435331", "Brandenberg",
"433855", "Krieglach",
"437479", "Ardagger",
"437942", "Freistadt",
"433323", "Eberau",
"432711", "Dürnstein",
"437433", "Wallsee",
"437477", "St\.\ Peter\ in\ der\ Au",
"432952", "Hollabrunn",
"432734", "Langenlois",
"433353", "Oberschützen",
"4314", "Vienna",
"437284", "Oberkappel",
"432735", "Hadersdorf\ am\ Kamp",
"432746", "Wilhelmsburg",
"434826", "Mörtschach",
"435252", "Oetz",
"437285", "Hofkirchen\ im\ Mühlkreis",
"436458", "Hüttau",
"432663", "Schottwien",
"435266", "Ötztal\-Bahnhof",
"435512", "Egg",
"433134", "Heiligenkreuz\ am\ Waasen",
"436135", "Bad\ Goisern",
"432814", "Langschlag",
"437762", "Raab",
"432815", "Grossschönau",
"433135", "Kalsdorf\ bei\ Graz",
"436134", "Hallstatt",
"433146", "Modriach",
"432985", "Gars\ am\ Kamp",
"437619", "Kirchham",
"437665", "Unterach\ am\ Attersee",
"435477", "Tösens",
"435575", "Langen\ bei\ Bregenz",
"432872", "Ottenschlag",
"432984", "Eggenburg",
"432718", "Lichtenau\ im\ Waldviertel",
"435574", "Bregenz",
"435372", "Kufstein",
"437664", "Weyregg\ am\ Attersee",
"434247", "Afritz",
"433882", "Mariazell",
"437617", "Traunkirchen",
"432632", "Pernitz",
"433118", "Sinabelkirchen",
"433688", "Tauplitz",
"432283", "Angern\ an\ der\ March",
"436542", "Zell\ am\ See",
"435338", "Kundl",
"433336", "Waldbach",
"437733", "Neumarkt\ im\ Hausruckkreis",
"4317", "Vienna",
"434877", "Prägraten\ am\ Grossvenediger",
"437266", "Bad\ Kreuzen",
"432573", "Wilfersdorf",
"433843", "St\.\ Michael\ in\ Obersteiermark",
"435285", "Mayrhofen",
"434879", "St\.\ Veit\ in\ Defereggen",
"434713", "Techendorf",
"433583", "Unzmarkt",
"437252", "Steyr",
"436583", "Leogang",
"435284", "Gerlos",
"432242", "St\.\ Andrä\-Wördern",
"435376", "Thiersee",
"436221", "Koppl",
"432876", "Els",
"437226", "Wilhering",
"435279", "St\.\ Jodok\ am\ Brenner",
"433332", "Hartberg",
"432644", "Grimmenstein",
"436546", "Fusch\ an\ der\ Grossglocknerstrasse",
"436473", "Mariapfarr",
"433534", "Stadl\ an\ der\ Mur",
"432645", "Wiesmath",
"433535", "Krakaudorf",
"433473", "Straden",
"432636", "Puchberg\ am\ Schneeberg",
"433886", "Weichselboden",
"437262", "Perg",
"437357", "Kleinreifling",
"432235", "Maria\-Lanzendorf",
"432246", "Gerasdorf\ bei\ Wien",
"433461", "Trahütten",
"432234", "Gramatneusiedl",
"437256", "Ternberg",
"436461", "Dienten\ am\ Hochkönig",
"432168", "Mannersdorf\ am\ Leithagebirge",
"433338", "Lafnitz",
"435336", "Alpbach",
"436479", "Muhr",
"432845", "Weikertschlag\ an\ der\ Thaya",
"433116", "Kirchbach\ in\ Steiermark",
"433686", "Haus",
"435239", "Kühtai",
"432844", "Karlstein\ an\ der\ Thaya",
"436477", "St\.\ Michael\ im\ Lungau",
"433574", "Pusterwald",
"436433", "Dorfgastein",
"432716", "Gföhl",
"435273", "Matrei\ am\ Brenner",
"433477", "St\.\ Peter\ am\ Ottersbach",
"433575", "St\.\ Johann\ am\ Tauern",
"437353", "Gaflenz",
"437751", "St\.\ Martin\ im\ Innkreis",
"432162", "Bruck\ an\ der\ Leitha",
"432741", "Flinsbach",
"435583", "Lech",
"437268", "Grein",
"432275", "Atzenbrugg",
"434286", "Weissbriach",
"433141", "Hirschegg",
"432274", "Sieghartskirchen",
"435473", "Nauders",
"432638", "Winzendorf\-Muthmannsdorf",
"433112", "Gleisdorf",
"433682", "Stainach",
"436277", "St\.\ Pantaleon",
"436233", "Oberwang",
"436548", "Niedernsill",
"435332", "Wörgl",
"432289", "Matzen",
"432951", "Guntersdorf",
"434243", "Bodensdorf",
"432672", "Berndorf",
"437613", "Laakirchen",
"437228", "Kematen\ an\ der\ Krems",
"432878", "Traunstein",
"437941", "Neumarkt\ im\ Mühlkreis",
"432287", "Strasshof\ an\ der\ Nordbahn",
"432712", "Aggsbach",
"432166", "Parndorf",
"437258", "Bad\ Hall",
"433849", "Vordernberg",
"434873", "St\.\ Jakob\ in\ Defereggen",
"432248", "Markgrafneusiedl",
"432533", "Neusiedl\ an\ der\ Zaya",
"432577", "Asparn\ an\ der\ Zaya",
"437230", "Altenberg\ bei\ Linz",
"436589", "Unken",
"436484", "Lessach",
"434717", "Steinfeld",
"433587", "Schönberg\-Lachtal",
"433847", "Trofaiach",
"434282", "Hermagor",
"432620", "Willendorf",
"435474", "Pfunds",
"436235", "Thalgau",
"436246", "Grödig",
"437667", "St\.\ Georgen\ im\ Attergau",
"436234", "Zell\ am\ Moos",
"435577", "Lustenau",
"435248", "Steinberg\ am\ Rofan",
"435475", "Feichten",
"437241", "Steinerkirchen\ an\ der\ Traun",
"432987", "St\.\ Leonhard\ am\ Hornerwald",
"437614", "Vorchdorf",
"432768", "St\.\ Aegyd\ am\ Neuwalde",
"437480", "Langau\,\ Gaming",
"434244", "Bad\ Bleiberg",
"432989", "Brunn\ an\ der\ Wild",
"437615", "Scharnstein",
"434236", "Eberndorf",
"434245", "Feistritz\ an\ der\ Drau",
"435579", "Alberschwende",
"433636", "Wildalpen",
"434874", "Virgen",
"437412", "Ybbs\ an\ der\ Donau",
"432535", "Hohenau\ an\ der\ March",
"435289", "Häusling",
"432534", "Niedersulz",
"434875", "Matrei\ in\ Osttirol",
"437216", "Helfenberg",
"437562", "Windischgarsten",
"435672", "Reutte",
"436483", "Göriach",
"432948", "Weitersfeld",
"435287", "Tux",
"434278", "Gnesau",
"432649", "Mönichkirchen",
"432758", "Pöggstall",
"432843", "Dobersberg",
"437280", "Schwarzenberg\ am\ Böhmerwald",
"436242", "Russbach\ am\ Pass\ Gschütt",
"437748", "Eggelsberg",
"433158", "St\.\ Anna\ am\ Aigen",
"434232", "Völkermarkt",
"436434", "Bad\ Gastein",
"432647", "Krumbach\,\ Lower\ Austria",
"433573", "Fohnsdorf",
"433537", "St\.\ Georgen\ ob\ Murau",
"435448", "Pettneu\ am\ Arlberg",
"435275", "Trins",
"435274", "Gries\ am\ Brenner",
"435585", "Dalaas",
"432688", "Steinbrunn",
"432239", "Breitenfurt\ bei\ Wien",
"433632", "St\.\ Gallen",
"437416", "Wieselburg",
"437355", "Weyer",
"434848", "Kartitsch",
"432728", "Wienerbruck",
"435676", "Jungholz",
"437212", "Zwettl\ an\ der\ Rodl",
"432237", "Gaaden",
"437566", "Rosenau\ am\ Hengstpass",
"432273", "Tulbing",
"433152", "Feldbach",
"434238", "Eisenkappel\-Vellach",
"433579", "Pöls",
"435442", "Landeck",
"432610", "Horitschon",
"432847", "Gross\-Siegharts",
"432766", "Kleinzell",
"434272", "Pörtschach\ am\ Wörther\ See",
"432752", "Melk",
"435246", "Achenkirch",
"433577", "Zeltweg",
"436474", "Tamsweg",
"432643", "Lichtenegg",
"433533", "Turrach",
"433475", "Hürth",
"433170", "Fischbach",
"436475", "Ramingstein",
"432849", "Schwarzenau",
"433474", "Deutsch\ Goritz",
"437742", "Mattighofen",
"435234", "Axams",
"432946", "Pulkau",
"434842", "Sillian",
"432722", "Kirchberg\ an\ der\ Pielach",
"432279", "Kirchberg\ am\ Wagram",
"437218", "Grosstraberg",
"437956", "Unterweissenbach",
"433832", "Kraubath\ an\ der\ Mur",
"432682", "Eisenstadt",
"433386", "Grosssteinbach",
"434220", "Köttmannsdorf",
"432233", "Pressbaum",
"432277", "Zwentendorf",
"433638", "Palfau",
"432762", "Lilienfeld",
"435573", "Hörbranz",
"435446", "St\.\ Anton\ am\ Arlberg",
"436274", "Lamprechtshausen",
"437663", "Steinbach\ am\ Attersee",
"432983", "Sigmundsherberg",
"437746", "Friedburg",
"437735", "Gaspoltshofen",
"432285", "Marchegg",
"435242", "Schwaz",
"432756", "St\.\ Leonhard\ am\ Forst",
"437734", "Hofkirchen\ an\ der\ Trattnach",
"432284", "Oberweiden",
"434276", "Feldkirchen\ in\ Kärnten",
"432575", "Ladendorf",
"437952", "Weitersfelden",
"435678", "Weissenbach\ am\ Lech",
"432574", "Gaweinstal",
"432726", "Puchenstuben",
"434846", "Abfaltersbach",
"432942", "Retz",
"437711", "Suben",
"434767", "Rothenthurn",
"435632", "Stanzach",
"433844", "Kammern\ im\ Liesingtal",
"433382", "Fürstenfeld",
"433584", "Neumarkt\ in\ Steiermark",
"434714", "Dellach\ im\ Drautal",
"434769", "Möllbrücke",
"436584", "Maria\ Alm\ am\ Steinernen\ Meer",
"432686", "Drassburg",
"433585", "St\.\ Lambrecht",
"434715", "Kötschach\-Mauthen",
"435283", "Kaltenbach",
"433845", "Mautern\ in\ Steiermark",
"433126", "Frohnleiten",
"433853", "Spital\ am\ Semmering",
"434229", "Krumpendorf\ am\ Wörther\ See",
"437242", "Wels",
"432252", "Baden",
"434227", "Ferlach",
"433324", "Strem",
"437435", "St\.\ Valentin",
"432266", "Stockerau",
"437434", "Haag",
"433325", "Heiligenkreuz\ im\ Lafnitztal",
"434257", "Fürnitz",
"437283", "Sarleinsbach",
"432733", "Schönberg\ am\ Kamp",
"433354", "Bernstein",
"433179", "Passail",
"436416", "Lend",
"432617", "Drassmarkt",
"435418", "Schönwies",
"433355", "Stadtschlaining",
"433133", "Nestelbach",
"433177", "Puch\ bei\ Weiz",
"432813", "Arbesbach",
"432664", "Semmering",
"436566", "Bramberg\ am\ Wildkogel",
"436212", "Seekirchen\ am\ Wallersee",
"437718", "Waldkirchen\ am\ Wesen",
"432619", "Lackendorf",
"434356", "Lavamünd",
"436133", "Ebensee",
"432665", "Prein\ an\ der\ Rax",
"432256", "Leobersdorf",
"437234", "Ottensheim",
"432784", "Perschling",
"432175", "Apetlon",
"436241", "St\.\ Koloman",
"437246", "Gunskirchen",
"437235", "Gallneukirchen",
"432174", "Wallern\ im\ Burgenland",
"433614", "Rottenmann",
"433184", "Wolfsberg\ im\ Schwarzautal",
"432624", "Ebenfurth",
"433863", "Turnau",
"434231", "Mittertrixen",
"432625", "Bad\ Sauerbrunn",
"437442", "Waidhofen\ an\ der\ Ybbs",
"433615", "Trieben",
"433185", "Preding",
"432262", "Korneuburg",
"434269", "Flattnitz",
"43316", "Graz",
"434215", "Liebenfels",
"433631", "Unterlaussa",
"436412", "St\.\ Johann\ im\ Pongau",
"435558", "Gaschurn",
"4319", "Vienna",
"434214", "Brückl",
"433364", "Hannersdorf",
"437211", "Reichenau\ im\ Mühlkreis",
"434352", "Wolfsberg",
"434267", "Metnitz",
"433365", "Deutsch\ Schützen\-Eisenberg",
"436562", "Mittersill",
"436216", "Neumarkt\ am\ Wallersee",
"437483", "Oberndorf\ an\ der\ Melk",
"437274", "Alkoven",
"433869", "St\.\ Katharein\ an\ der\ Laming",
"434736", "Innerkrems",
"432146", "Nickelsdorf",
"432825", "Göpfritz\ an\ der\ Wild",
"437448", "Kematen\ an\ der\ Ybbs",
"432268", "Grossmugl",
"433151", "Gnas",
"435522", "Feldkirch",
"435441", "See",
"432824", "Allentsteig",
"432912", "Geras",
"433867", "Pernegg\ an\ der\ Mur",
"435280", "Hochfügen",
"434271", "Steuerberg",
"43512", "Innsbruck",
"437676", "Ottnang\ am\ Hausruck",
"435212", "Seefeld\ in\ Tirol",
"434358", "St\.\ Andrä",
"437716", "Münzkirchen",
"437489", "Purgstall\ an\ der\ Erlauf",
"435355", "Jochberg",
"432855", "Waldenstein",
"434263", "Hüttenberg",
"437584", "Molln",
"436418", "Kleinarl",
"435354", "Fieberbrunn",
"435552", "Bludenz",
"437487", "Gresten",
"437585", "Klaus\ an\ der\ Pyhrnbahn",
"432854", "Kirchberg\ am\ Walde",
"433857", "Neuberg\ an\ der\ Mürz",
"435526", "Laterns",
"434732", "Gmünd\ in\ Kärnten",
"432142", "Gattendorf",
"434223", "Maria\ Saal",
"432230", "Schwadorf",
"437475", "Hausmening\,\ Neuhofen\ an\ der\ Ybbs",
"437248", "Grieskirchen",
"433859", "Mürzsteg",
"437474", "Euratsfeld",
"432916", "Riegersburg\,\ Hardegg",
"432258", "Alland",
"437287", "Peilstein\ im\ Mühlviertel",
"434253", "St\.\ Jakob\ im\ Rosental",
"432865", "Litschau",
"437712", "Schärding",
"432773", "Eichgraben",
"4315", "Vienna",
"432864", "Kautzen",
"433623", "Bad\ Mitterndorf",
"432613", "Deutschkreutz",
"437672", "Vöcklabruck",
"432739", "Tiefenfucha",
"433137", "Söding",
"433173", "Ratten",
"437289", "Rohrbach\ in\ Oberösterreich",
"435556", "Schruns",
"436137", "Strobl",
"435412", "Imst",};
$areanames{de} = {"434253", "Sankt\ Jakob\ im\ Rosental",
"4315", "Wien",
"434358", "Sankt\ Andrä",
"433869", "Sankt\ Katharein\ an\ der\ Laming",
"432268", "Großmugl",
"436412", "Sankt\ Johann\ im\ Pongau",
"4319", "Wien",
"436241", "Sankt\ Koloman",
"432617", "Draßmarkt",
"437435", "Sankt\ Valentin",
"435678", "Weißenbach\ am\ Lech",
"432686", "Draßburg",
"433585", "Sankt\ Lambrecht",
"435446", "Sankt\ Anton\ am\ Arlberg",
"432756", "Sankt\ Leonhard\ am\ Forst",
"437218", "Großtraberg",
"437956", "Unterweißenbach",
"433386", "Großsteinbach",
"432233", "Preßbaum",
"432847", "Groß\-Siegharts",
"433632", "Sankt\ Gallen",
"437566", "Rosenau\ am\ Hengstpaß",
"436242", "Rußbach\ am\ Paß\ Gschütt",
"433158", "Sankt\ Anna\ am\ Aigen",
"433537", "Sankt\ Georgen\ ob\ Murau",
"432647", "Krumbach\,\ Niederösterreich",
"437667", "Sankt\ Georgen\ im\ Attergau",
"432987", "Sankt\ Leonhard\ am\ Hornerwald",
"432768", "Sankt\ Aegyd\ am\ Neuwalde",
"434873", "Sankt\ Jakob\ in\ Defereggen",
"436277", "Sankt\ Pantaleon",
"437751", "Sankt\ Martin\ im\ Innkreis",
"434286", "Weißbriach",
"436477", "Sankt\ Michael\ im\ Lungau",
"433477", "Sankt\ Peter\ am\ Ottersbach",
"433575", "Sankt\ Johann\ am\ Tauern",
"435279", "Sankt\ Jodok\ am\ Brenner",
"436546", "Fusch\ an\ der\ Großglocknerstraße",
"4317", "Wien",
"434877", "Prägraten\ am\ Großvenediger",
"433843", "Sankt\ Michael\ in\ Obersteiermark",
"434879", "Sankt\ Veit\ in\ Defereggen",
"432242", "Sankt\ Andrä\-Wördern",
"4314", "Wien",
"432815", "Großschönau",
"437477", "Sankt\ Peter\ in\ der\ Au",
"432742", "Sankt\ Pölten",
"433468", "Sankt\ Oswald\ ob\ Eibiswald",
"432857", "Bad\ Großpertholz",
"4312", "Wien",
"433864", "Sankt\ Marein\ im\ Mürztal",
"433183", "Sankt\ Georgen\ an\ der\ Stiefing",
"434264", "Klein\ Sankt\ Paul",
"432629", "Warth\,\ Niederösterreich",
"437237", "Sankt\ Georgen\ an\ der\ Gusen",
"432823", "Großglobnitz",
"433331", "Sankt\ Lorenzen\ am\ Wechsel",
"433327", "Sankt\ Michael\ im\ Burgenland",
"432556", "Großkrut",
"4313", "Wien",
"432822", "Zwettl\-Niederösterreich",
"435352", "Sankt\ Johann\ in\ Tirol",
"434783", "Reißeck",
"436227", "Sankt\ Gilgen",
"437232", "Sankt\ Martin\ im\ Mühlkreis",
"433362", "Großpetersdorf",
"436565", "Neukirchen\ am\ Großvenediger",
"436414", "Großarl",
"433469", "Sankt\ Oswald\ im\ Freiland",
"434212", "Sankt\ Veit\ an\ der\ Glan",
"436215", "Straßwalchen",
"433689", "Sankt\ Nikolai\ im\ Sölktal",
"433119", "Sankt\ Marein\ bei\ Graz",
"436476", "Sankt\ Margarethen\ im\ Lungau",
"435245", "Hinterriß",
"432719", "Droß",
"437954", "Sankt\ Georgen\ am\ Walde",
"436276", "Nußdorf\ am\ Haunsberg",
"433834", "Wald\ am\ Schoberpaß",
"434876", "Kals\ am\ Großglockner",
"433140", "Sankt\ Martin\ am\ Wöllmißberg",
"437565", "Sankt\ Pankraz",
"434283", "Sankt\ Stefan\ im\ Gailtal",
"432249", "Groß\-Enzersdorf",
"434350", "Bad\ Sankt\ Leonhard\ im\ Lavanttal",
"432715", "Weißenkirchen\ in\ der\ Wachau",
"432674", "Weißenbach\ an\ der\ Triesting",
"433684", "Sankt\ Martin\ am\ Grimming",
"435449", "Fließ",
"432642", "Aspangberg\-Sankt\ Peter",
"436247", "Großgmain",
"434239", "Sankt\ Kanzian\ am\ Klopeiner\ See",
"437217", "Sankt\ Veit\ im\ Mühlkreis",
"433123", "Sankt\ Oswald\ bei\ Plankenwarth",
"437219", "Vorderweißenbach",
"434843", "Außervillgraten",
"433536", "Sankt\ Peter\ am\ Kammersberg",
"436545", "Bruck\ an\ der\ Großglocknerstraße",
"437224", "Sankt\ Florian",
"432763", "Sankt\ Veit\ an\ der\ Gölsen",
"437254", "Großraming",
"437945", "Sankt\ Oswald\ bei\ Freistadt",
"432955", "Großweikersdorf",
"4316", "Wien",
"432618", "Markt\ Sankt\ Martin",
"432812", "Groß\ Gerungs",
"437717", "Sankt\ Aegidi",
"433178", "Sankt\ Ruprecht\ an\ der\ Raab",
"432263", "Großrußbach",
"435557", "Sankt\ Gallenkirch",
"434825", "Großkirchheim",
"434226", "Sankt\ Margareten\ im\ Rosental",
"433868", "Tragöß",
"433464", "Groß\ Sankt\ Florian",
"434357", "Sankt\ Paul\ im\ Lavanttal",
"433515", "Sankt\ Lorenzen\ bei\ Knittelfeld",
"434785", "Außerfragant",
"432680", "Sankt\ Margarethen\ im\ Burgenland",
"4318", "Wien",
"435413", "Sankt\ Leonhard\ im\ Pitztal",
"434266", "Straßburg",
"436138", "Sankt\ Wolfgang\ im\ Salzkammergut",};

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+43|\D)//g;
      my $self = bless({ number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:0)//;
      $self = bless({ number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;