# automatically generated file, don't edit



# Copyright 2011 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::NZ;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20210309172132;

my $formatters = [
                {
                  'format' => '$1 $2',
                  'leading_digits' => '8[1-579]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3,8})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            50(?:
              [0367]|
              88
            )|
            [89]0
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{2,3})'
                },
                {
                  'format' => '$1-$2 $3',
                  'leading_digits' => '
            24|
            [346]|
            7[2-57-9]|
            9[2-9]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d)(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            2(?:
              10|
              74
            )|
            [59]|
            80
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{3,4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            1|
            2[028]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3,4})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            2(?:
              [169]|
              7[0-35-9]
            )|
            7|
            86
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{3,5})'
                }
              ];

my $validators = {
                'fixed_line' => '
          24099\\d{3}|
          (?:
            3[2-79]|
            [49][2-9]|
            6[235-9]|
            7[2-57-9]
          )\\d{6}
        ',
                'geographic' => '
          24099\\d{3}|
          (?:
            3[2-79]|
            [49][2-9]|
            6[235-9]|
            7[2-57-9]
          )\\d{6}
        ',
                'mobile' => '
          2[0-27-9]\\d{7,8}|
          21\\d{6}
        ',
                'pager' => '[28]6\\d{6,7}',
                'personal_number' => '70\\d{7}',
                'specialrate' => '(
          (?:
            11\\d{5}|
            50(?:
              0[08]|
              30|
              66|
              77|
              88
            )
          )\\d{3}|
          90\\d{6,8}
        )|(
          8(?:
            1[6-9]|
            22|
            3\\d|
            4[045]|
            5[459]|
            7[0-3579]|
            90
          )\\d{2,7}
        )',
                'toll_free' => '
          508\\d{6,7}|
          80\\d{6,8}
        ',
                'voip' => ''
              };
my %areanames = ();
$areanames{en} = {"649215", "Auckland",
"6439726", "Timaru",
"646307", "Featherston",
"6439755", "Rangiora",
"6467553", "New\ Plymouth",
"6462424", "Wanganui",
"6496512", "Whangarei",
"6435531", "Nelson",
"6439766", "Balclutha",
"646867", "Gisborne",
"6433919", "Haast",
"6437444", "Takaka",
"647870", "Te\ Awamutu",
"647871", "Te\ Awamutu",
"6475824", "Hamilton",
"6475480", "Tauranga",
"6432646", "Timaru",
"6499042", "Hibiscus\ Coast",
"643552", "Dunedin",
"643667", "Christchurch",
"6475626", "Taupo",
"6499001", "Auckland",
"6449081", "Paraparaumu",
"6499011", "Kaitaia",
"643441", "Queenstown",
"6434241", "Rangiora",
"6472197", "Tauranga",
"64423", "Wellington",
"6435885", "Invercargill",
"6435507", "Ashburton",
"6435517", "Lawrence",
"64957", "Auckland",
"6469577", "Ohakune",
"6435663", "Twizel",
"6468692", "Gisborne",
"649348", "Auckland",
"6434405", "Alexandra",
"6447771", "Paraparaumu",
"649888", "Auckland",
"6473933", "Rotorua",
"6462609", "Pahiatua",
"6462144", "Ruatoria",
"6462619", "Featherston",
"6492229", "Hibiscus\ Coast",
"646765", "Stratford",
"6433951", "Timaru",
"643941", "Christchurch",
"6479240", "Taupo",
"643940", "Christchurch",
"6435556", "Fairlie",
"643750", "Haast",
"643751", "Fox\ Glacier",
"6439874", "Cromwell",
"6499476", "Auckland",
"6465616", "Hawera",
"6465606", "Waiouru",
"647957", "Hamilton",
"6479752", "Rotorua",
"6436589", "Otautau",
"6475828", "Hamilton",
"6499296", "Kaitaia",
"6436596", "Queenstown",
"6437448", "Haast",
"6479845", "Paeroa",
"6478082", "Tauranga",
"6437472", "Lawrence",
"6467776", "Levin",
"6472629", "Taupo",
"6496995", "Maungaturoto",
"6432990", "Lumsden",
"647921", "Rotorua",
"647920", "Rotorua",
"644894", "Wellington",
"6469713", "Stratford",
"646373", "Masterton",
"644203", "Wellington",
"6474441", "Waihi",
"647839", "Hamilton",
"643749", "Christchurch",
"647856", "Hamilton",
"6466553", "New\ Plymouth",
"643571", "Nelson",
"64757", "Tauranga",
"6498851", "Pukekohe",
"6466997", "New\ Plymouth",
"647852", "Hamilton",
"6472126", "Otorohanga",
"6432443", "Christchurch",
"6436992", "Greymouth",
"6439000", "Christchurch",
"6439010", "Queenstown",
"6499810", "Hibiscus\ Coast",
"6473924", "Paeroa",
"646835", "Napier\/Hastings",
"6434276", "Palmerston",
"643767", "Greymouth",
"6463918", "Wanganui",
"6468992", "Wairoa",
"6493933", "Kaikohe",
"6463908", "Wairoa",
"647888", "Matamata",
"6495530", "Great\ Barrier\ Island",
"647960", "Hamilton",
"647348", "Rotorua",
"647961", "Hamilton",
"6432608", "Dunedin",
"6432618", "Culverden",
"643305", "Ashburton\/Akaroa\/Chatham\ Islands",
"6466009", "Waiouru",
"644498", "Wellington",
"6433985", "Alexandra",
"649845", "Auckland",
"6434993", "Alexandra",
"643697", "Geraldine",
"644905", "Paraparaumu",
"647215", "Rotorua",
"6479001", "Hamilton",
"64944", "Auckland",
"6439276", "Nelson",
"6435680", "Dunedin",
"647460", "Rotorua",
"6432429", "Timaru",
"6439317", "Gore",
"6463914", "Stratford",
"6463904", "Napier",
"6439293", "Blenheim",
"6472813", "Waihi",
"6472803", "Waihi",
"643651", "Nelson",
"644928", "Wellington",
"6462157", "Stratford",
"6473928", "Te\ Awamutu",
"6469302", "Napier",
"6469312", "Ohakune",
"6495562", "Whangarei",
"6432735", "Mt\ Cook",
"643432", "Oamaru",
"649984", "Auckland",
"6439325", "Kaikoura",
"649913", "Auckland",
"643436", "Kurow",
"646274", "Hawera",
"6462139", "Palmerston\ North",
"6462106", "Pahiatua",
"6469854", "Waipukurau",
"6435952", "Christchurch",
"6439331", "Greymouth",
"6434293", "Haast",
"649957", "Pukekohe",
"6436505", "Culverden",
"649420", "Helensville",
"6443331", "Wellington",
"649421", "Hibiscus\ Coast",
"643539", "Nelson",
"6432721", "Motueka",
"6463990", "Featherston",
"6436567", "Ranfurly",
"6437457", "Darfield",
"6432816", "Waimate",
"6466522", "Palmerston\ North",
"6492006", "Helensville",
"6432806", "Edendale",
"6495588", "Hibiscus\ Coast",
"6436613", "Wanaka",
"6442820", "Wellington",
"646903", "Palmerston\ North",
"644296", "Paraparaumu",
"6439098", "Akaroa",
"6436527", "Haast",
"6439045", "Twizel",
"644292", "Paraparaumu",
"6435677", "Ranfurly",
"6479296", "Tauranga",
"6468887", "Gisborne",
"6432614", "Akaroa",
"646366", "Levin",
"6436999", "Nelson",
"6436635", "Fairlie",
"644650", "Wellington",
"6472821", "Hamilton",
"6434285", "Cheviot",
"649320", "Auckland",
"646362", "Levin",
"6442429", "Paraparaumu",
"6439532", "Timaru",
"644436", "Wellington",
"6468999", "Napier",
"6472222", "Hamilton",
"643304", "Ashburton\/Akaroa\/Chatham\ Islands",
"6469271", "Pahiatua",
"6462120", "Palmerston\ North",
"644904", "Paraparaumu",
"6462160", "Masterton",
"646834", "Napier\/Hastings",
"6432713", "Ashburton",
"6437460", "Waitangi\ \(Chatham\ Is\.\)",
"649816", "Auckland",
"6469003", "Napier\/Hastings",
"643419", "Balclutha",
"6439285", "Invercargill",
"6445952", "Wellington",
"649812", "Auckland",
"6466002", "Napier",
"6466012", "Pahiatua",
"6479049", "Te\ Kuiti",
"643332", "Christchurch",
"6472198", "Opotiki",
"6472145", "Huntly",
"6469578", "Marton",
"6436621", "Culverden",
"646863", "Gisborne",
"643336", "Christchurch",
"6435518", "Milton",
"6435508", "Cheviot",
"6499451", "Warkworth",
"649230", "Pukekohe",
"6439880", "Greymouth",
"646377", "Masterton",
"6469309", "Mokau",
"6437447", "Greymouth",
"6469319", "Masterton",
"649390", "Auckland",
"6439026", "Riverton",
"649391", "Auckland",
"6433993", "Te\ Anau",
"6439066", "Hokitika",
"644571", "Wellington",
"6439055", "Fairlie",
"644570", "Wellington",
"6432225", "Greymouth",
"6474650", "Morrinsville",
"6439520", "Dunedin",
"6462811", "New\ Plymouth",
"6462801", "Palmerston\ North",
"6495569", "Maungaturoto",
"6475827", "Hamilton",
"6462415", "Levin",
"64336", "Christchurch",
"6498901", "Pukekohe",
"649985", "Auckland",
"6435514", "Palmerston",
"6469290", "Napier\/Hastings",
"6435504", "Christchurch",
"6469574", "Taihape",
"6439346", "Christchurch",
"6472194", "Whakatane",
"6497770", "Whangarei",
"6442608", "Paraparaumu",
"6473996", "Otorohanga",
"643226", "Otautau",
"6468300", "Napier",
"6494701", "Whangarei",
"6466529", "Pahiatua",
"6496519", "Maungaturoto",
"6465620", "New\ Plymouth",
"6496509", "Pukekohe",
"6462154", "New\ Plymouth",
"646764", "Stratford",
"647812", "Hamilton",
"6433912", "Motueka",
"647357", "Rotorua",
"6435546", "Greymouth",
"6463907", "Waipukurau",
"6463917", "Wanganui",
"6439314", "Winton",
"6433941", "Blenheim",
"647533", "Tauranga",
"6466998", "New\ Plymouth",
"6463925", "Waiouru",
"6478131", "Otorohanga",
"6492835", "Kaikohe",
"6449120", "Wellington",
"6432631", "Gore",
"643693", "Geraldine",
"6499049", "Great\ Barrier\ Island",
"6434236", "Amberley",
"6469246", "Palmerston\ North",
"6439852", "Cheviot",
"6432656", "Nelson",
"64332", "Christchurch",
"6432625", "Twizel",
"6436686", "Invercargill",
"6469614", "Levin",
"6436524", "Hokitika",
"6435674", "Milton",
"649214", "Auckland",
"6432617", "Cheviot",
"6468884", "Palmerston\ North",
"6432607", "Dunedin",
"6437454", "Ashburton",
"6436564", "Milton",
"6439745", "Greymouth",
"6462602", "Palmerston\ North",
"6492222", "Auckland",
"6437483", "Otautau",
"6478073", "Tokoroa\/Putaruru",
"6477770", "Tauranga",
"6468822", "Masterton",
"649581", "Auckland",
"649580", "Auckland",
"6436582", "Riverton",
"6439710", "Timaru",
"6439700", "Nelson",
"6466994", "Ohakune",
"644895", "Paraparaumu",
"649953", "Auckland",
"6439450", "Invercargill",
"6437479", "Edendale",
"6439318", "Lumsden",
"6439081", "Ashburton",
"6475610", "Putaruru\/Tokoroa",
"6475600", "Hamilton",
"6473927", "Te\ Kuiti",
"6439863", "Motueka",
"6499063", "Hibiscus\ Coast",
"6478590", "Hamilton",
"6468261", "Masterton",
"643468", "Dunedin",
"6462158", "Opunake",
"6479855", "Taupo",
"6436568", "Roxburgh",
"6437458", "Kaikoura",
"644975", "Paraparaumu",
"647390", "Hamilton",
"6435678", "Roxburgh",
"6472622", "Tauranga",
"647391", "Hamilton",
"6468888", "Masterton",
"649917", "Auckland",
"6439097", "Darfield",
"6436528", "Westport",
"646322", "Marton",
"649948", "Auckland",
"6467529", "Mokau",
"6479711", "Whangamata",
"649801", "Auckland",
"646326", "Palmerston\ North",
"643968", "Christchurch",
"6437771", "Blenheim",
"644915", "Wellington",
"6473946", "Taupo",
"64943", "Whangarei",
"6496997", "Hibiscus\ Coast",
"6439284", "Blenheim",
"6499552", "Dargaville",
"6439079", "Murchison",
"6499879", "Warkworth",
"6437481", "Invercargill",
"6478071", "Otorohanga",
"6468252", "Dannevirke",
"6432650", "Christchurch",
"6434230", "Christchurch",
"6469240", "Gisborne",
"647547", "Tauranga",
"647926", "Tauranga",
"6472609", "Whangamata",
"6472144", "Matamata",
"6436680", "Akaroa",
"6479101", "Rotorua",
"647922", "Whakatane",
"643217", "Invercargill",
"646385", "Ohakune",
"6432228", "Wanaka",
"6432633", "Otautau",
"6496009", "Pukekohe",
"6435992", "Fox\ Glacier",
"6496019", "Auckland",
"647867", "Thames",
"649477", "Auckland",
"646845", "Napier\/Hastings",
"6434284", "Wanaka",
"6478133", "Putaruru\/Tokoroa",
"6472424", "Tauranga",
"6479422", "Tauranga",
"643788", "Westport",
"6436634", "Mt\ Cook",
"647307", "Whakatane",
"6462418", "Palmerston\ North",
"6468249", "Opunake",
"643756", "Hokitika",
"644260", "Wellington",
"6479847", "Te\ Awamutu",
"6468809", "Masterton",
"6468819", "Mokau",
"6465626", "Ruatoria",
"6435540", "Edendale",
"6433943", "Amberley",
"643752", "Franz\ Josef",
"643248", "Lumsden",
"649966", "Auckland",
"6442199", "Paraparaumu",
"6435887", "Invercargill",
"6479713", "Morrinsville",
"6472148", "Waihi",
"644886", "Wellington",
"6477882", "Hamilton",
"643942", "Christchurch",
"6472195", "Rotorua",
"6469575", "Waiouru",
"6437773", "Dunedin",
"649962", "Auckland",
"643527", "Motueka",
"6435515", "Oamaru",
"6462629", "Levin",
"6435505", "Akaroa",
"643946", "Invercargill",
"6435527", "Alexandra",
"646839", "Napier\/Hastings",
"6434222", "Gore",
"6493208", "Helensville",
"649403", "Kawakawa",
"6439288", "Ashburton",
"6434262", "Alexandra",
"6499631", "Pukekohe",
"647876", "Te\ Kuiti",
"649849", "Auckland",
"6496882", "Auckland",
"6439456", "Riverton",
"643442", "Queenstown",
"6475616", "Whangamata",
"6475606", "Matamata",
"6439083", "Cheviot",
"6468263", "Napier",
"647872", "Te\ Awamutu",
"644909", "Wellington",
"6494312", "Warkworth",
"6499061", "Hibiscus\ Coast",
"6439861", "Nelson",
"643446", "Roxburgh",
"6439757", "Waitangi\ \(Chatham\ Is\.\)",
"6493990", "Great\ Barrier\ Island",
"649827", "Auckland",
"6462414", "Napier",
"6477776", "Whangamata",
"6436638", "Kurow",
"649903", "Auckland",
"643983", "Christchurch",
"6439739", "Invercargill",
"6434288", "Cromwell",
"6439716", "Geraldine",
"6439706", "Nelson",
"6472428", "Taupo",
"6478090", "Thames",
"6432224", "Invercargill",
"6436507", "Kaikoura",
"6436517", "Motueka",
"6432624", "Milton",
"6499422", "Helensville",
"649298", "Auckland",
"644290", "Paraparaumu",
"6499462", "Whangarei",
"6432664", "Christchurch",
"643930", "Christchurch",
"6436623", "Amberley",
"649422", "Warkworth",
"6439744", "Queenstown",
"6435692", "Takaka",
"6479858", "Whakatane",
"6437466", "Cromwell",
"6432711", "Akaroa",
"6437455", "Cheviot",
"6436565", "Twizel",
"649426", "Hibiscus\ Coast",
"6468885", "New\ Plymouth",
"6435675", "Twizel",
"6469615", "Masterton",
"6439047", "Alexandra",
"6432742", "Twizel",
"6436525", "Franz\ Josef",
"6469001", "New\ Plymouth",
"643688", "Timaru",
"6439315", "Tokanui",
"6469273", "New\ Plymouth",
"6462126", "Pahiatua",
"6498018", "Whangarei",
"6462155", "Hawera",
"646856", "Waipukurau",
"643430", "Mt\ Cook",
"643431", "Oamaru",
"6462166", "Opunake",
"6499101", "Pukekohe",
"646348", "Wanganui",
"6472823", "Whakatane",
"6432737", "Palmerston",
"6478992", "Paeroa",
"6492834", "Kawakawa",
"6439327", "Ashburton",
"6463924", "Marton",
"6433987", "Cromwell",
"6473990", "Te\ Awamutu",
"6436649", "Gore",
"647462", "Taupo",
"643955", "Dunedin",
"6479021", "Te\ Awamutu",
"647849", "Hamilton",
"6469289", "Taihape",
"647466", "Tauranga",
"6494703", "Whangarei",
"6439748", "Dunedin",
"6479854", "Rotorua",
"6469296", "Levin",
"6432668", "Blenheim",
"6492428", "Hibiscus\ Coast",
"6439340", "Mt\ Cook",
"6432628", "Ranfurly",
"644213", "Wellington",
"647903", "Hamilton",
"6497776", "Hibiscus\ Coast",
"6478128", "Huntly",
"647827", "Hamilton",
"643979", "Christchurch",
"6466995", "Opunake",
"6474656", "Te\ Awamutu",
"6463928", "Pahiatua",
"6439526", "Twizel",
"643455", "Dunedin",
"6462813", "Wanganui",
"6492838", "Pukekohe",
"6462803", "Palmerston\ North",
"6472116", "Thames",
"6439886", "Haast",
"646769", "New\ Plymouth",
"647850", "Hamilton",
"643576", "Nelson",
"647851", "Hamilton",
"6439020", "Gore",
"6499453", "Warkworth",
"6436652", "Winton",
"6439060", "Greymouth",
"6433991", "Invercargill",
"6466509", "Napier\/Waipukurau",
"6435686", "Gore",
"6479003", "Thames",
"6499469", "Maungaturoto",
"643221", "Invercargill",
"6439270", "Greymouth",
"647989", "Taupo",
"6435884", "Dunedin",
"646758", "New\ Plymouth",
"647834", "Hamilton",
"649473", "Auckland",
"6496998", "Helensville",
"647863", "Waihi",
"6479501", "Opotiki",
"6432749", "Wanaka",
"643213", "Invercargill",
"6435699", "Amberley",
"6434404", "Alexandra",
"6434991", "Cromwell",
"6436546", "Fairlie",
"647543", "Tauranga",
"6437445", "Fox\ Glacier",
"6434270", "Oamaru",
"647362", "Rotorua",
"6439754", "Darfield",
"6479848", "Te\ Kuiti",
"6462425", "Masterton",
"6439057", "Waimate",
"6432752", "Te\ Anau",
"6493931", "Whangarei",
"647366", "Rotorua",
"6498853", "Whangarei",
"649236", "Pukekohe",
"646214", "Gisborne",
"644572", "Wellington",
"6432227", "Queenstown",
"6466551", "New\ Plymouth",
"649232", "Pukekohe",
"6432441", "Christchurch",
"6472120", "Putaruru\/Tokoroa",
"6462417", "Wanganui",
"6475825", "Hamilton",
"649392", "Auckland",
"6439006", "Nelson",
"6478999", "Hamilton",
"6462222", "Ohakune",
"6439016", "Alexandra",
"644576", "Wellington",
"6434350", "Twizel",
"6493207", "Hibiscus\ Coast",
"6436611", "Rangiora",
"6432810", "Franz\ Josef",
"6498822", "Kaikohe",
"6432800", "Te\ Anau",
"644931", "Wellington",
"6435528", "Ranfurly",
"6469282", "Mokau",
"6436642", "Milton",
"6439287", "Oamaru",
"6479290", "Hamilton",
"6496994", "Dargaville",
"643331", "Christchurch",
"643454", "Dunedin",
"6472147", "Paeroa",
"646953", "Palmerston\ North\ W100",
"6439333", "Franz\ Josef",
"6434291", "Westport",
"64926", "Auckland",
"649811", "Auckland",
"644818", "Wellington",
"6435888", "Timaru",
"649810", "Auckland",
"6432723", "Takaka",
"6443333", "Paraparaumu",
"6463996", "Palmerston\ North",
"6436637", "Twizel",
"649407", "Kaikohe",
"643487", "Dunedin",
"647377", "Taupo",
"6462100", "Levin",
"6472427", "Rotorua",
"6434287", "Queenstown",
"6439875", "Ranfurly",
"6439291", "Dunedin",
"6436659", "Haast",
"6472132", "Taupo",
"6439758", "Ashburton",
"643523", "Murchison",
"6479844", "Otorohanga",
"6472811", "Tauranga",
"6472801", "Huntly",
"644527", "Wellington",
"6473931", "Whangamata",
"6499872", "Whangarei",
"643409", "Queenstown",
"6479857", "Opotiki",
"6433984", "Roxburgh",
"6439048", "Lawrence",
"646321", "Marton",
"6435550", "Fox\ Glacier",
"6499559", "Whangarei",
"6433953", "Geraldine",
"6479246", "Thames",
"6472602", "Hamilton",
"646844", "Napier\/Hastings",
"6472612", "Te\ Awamutu",
"6434243", "Akaroa",
"6436518", "Murchison",
"649633", "Auckland",
"6436508", "Rangiora",
"6468259", "Levin",
"6435661", "Fairlie",
"6463940", "Levin",
"6478140", "Rotorua",
"6432738", "Oamaru",
"647893", "Taumarunui",
"6468242", "Ruatoria",
"6432640", "Hokitika",
"6499003", "Warkworth",
"6449083", "Wellington",
"6499013", "Kawakawa",
"644551", "Paraparaumu",
"649558", "Auckland",
"646279", "Hawera",
"644550", "Wellington",
"6435999", "Christchurch",
"6475620", "Tauranga",
"6496012", "Kawakawa",
"6498017", "Hibiscus\ Coast",
"6439720", "Blenheim",
"644914", "Wellington",
"6468802", "New\ Plymouth",
"6439760", "Twizel",
"6468812", "Waiouru",
"643612", "Timaru",
"6467551", "New\ Plymouth",
"6435533", "Murchison",
"6473925", "Putaruru\/Tokoroa",
"649582", "Auckland",
"6492427", "Warkworth",
"6436504", "Cheviot",
"6474443", "Matamata",
"6477889", "Whakatane",
"6432627", "Alexandra",
"6432615", "Amberley",
"6475958", "Taupo",
"6432996", "Riverton",
"6434269", "Twizel",
"6433988", "Wanaka",
"6439044", "Milton",
"6469711", "New\ Plymouth",
"6434229", "Winton",
"6439747", "Wanaka",
"647322", "Whakatane",
"64933", "Auckland",
"6436590", "Nelson",
"647823", "Hamilton",
"6463915", "Opunake",
"6463905", "Napier",
"6467770", "Gisborne",
"643415", "Balclutha",
"6439269", "Dunedin",
"6499470", "Hibiscus\ Coast",
"6439732", "Otautau",
"6492837", "Hibiscus\ Coast",
"6473847", "Taupo",
"6439324", "Darfield",
"6463927", "Dannevirke",
"6465610", "Napier",
"6465600", "Palmerston\ North",
"6432734", "Waimate",
"643260", "Christchurch",
"6475950", "Hamilton",
"649980", "Auckland",
"6435554", "Cromwell",
"6433980", "Milton",
"6473997", "Te\ Kuiti",
"6462809", "Napier\/Hastings",
"6462819", "Levin",
"649297", "Auckland",
"6499719", "Whangarei",
"6495561", "Whangarei",
"6469311", "Palmerston\ North",
"6469301", "Ruatoria",
"6472133", "Taupo",
"6463944", "Featherston",
"6439347", "Christchurch",
"6499459", "Maungaturoto",
"6435685", "Tokanui",
"643654", "Timaru",
"6499478", "Pukekohe",
"649235", "Pukekohe",
"6475624", "Rotorua",
"644488", "Wellington",
"6436643", "Balclutha",
"6432644", "Westport",
"6498823", "Kaitaia",
"64937", "Auckland",
"6465608", "Dannevirke",
"6465618", "Masterton",
"6439015", "Wanaka",
"6469283", "Opunake",
"6478144", "Tauranga",
"6439005", "Invercargill",
"6475826", "Hamilton",
"646329", "Palmerston\ North",
"649638", "Auckland",
"643687", "Timaru",
"6466521", "Palmerston\ North",
"6439027", "Winton",
"6432722", "Murchison",
"6436598", "Wanaka",
"6437446", "Franz\ Josef",
"6499298", "Pukekohe",
"6439764", "Lawrence",
"6462426", "Levin",
"6443332", "Wellington",
"6439332", "Hokitika",
"6439067", "Franz\ Josef",
"6469022", "Hawera",
"646347", "Wanganui",
"646653", "Wanganui",
"6435951", "Christchurch",
"649424", "Hibiscus\ Coast",
"6439724", "Blenheim",
"6467778", "Wairoa",
"6432753", "Winton",
"6469279", "Levin",
"6436500", "Christchurch",
"6468991", "Gisborne",
"64635", "Palmerston\ North",
"6463995", "Marton",
"647828", "Huntly",
"6436991", "Culverden",
"6472829", "Tauranga",
"6462223", "Palmerston\ North",
"649249", "Auckland",
"6439040", "Balclutha",
"6498852", "Warkworth",
"6435558", "Waimate",
"6439728", "Franz\ Josef",
"6467774", "Dannevirke",
"6439768", "Ranfurly",
"647464", "Hamilton",
"6436594", "Waimate",
"6436629", "Christchurch",
"6479002", "Matamata",
"6432730", "Blenheim",
"6432648", "Geraldine",
"6472457", "Rotorua",
"6465604", "Ohakune",
"6465614", "Wanganui",
"6439320", "Akaroa",
"6499474", "Helensville",
"6475628", "Tauranga",
"6439876", "Roxburgh",
"6437471", "Kurow",
"6478081", "Rotorua",
"6435880", "Dunedin",
"6478450", "Hamilton",
"6468269", "New\ Plymouth",
"6439274", "Queenstown",
"6434400", "Alexandra",
"6492008", "Hibiscus\ Coast",
"6432808", "Westport",
"6432818", "Christchurch",
"6479751", "Tauranga",
"64456", "Wellington",
"6439733", "Te\ Anau",
"6479298", "Taupo",
"6435560", "Mt\ Cook",
"6479245", "Matamata",
"647308", "Whakatane",
"6479709", "Matamata",
"643615", "Timaru",
"6479719", "Te\ Kuiti",
"64438", "Wellington",
"6474442", "Morrinsville",
"649585", "Auckland",
"649478", "Auckland",
"6434274", "Kurow",
"647868", "Thames",
"6439750", "Kaikoura",
"6437779", "Invercargill",
"6462623", "Stratford",
"643218", "Invercargill",
"647980", "Hamilton",
"6473926", "Taumarunui",
"647981", "Hamilton",
"644891", "Wellington",
"644890", "Wellington",
"6472124", "Matamata",
"646753", "New\ Plymouth",
"6478097", "Whakatane",
"6498880", "Helensville",
"6462108", "Ohakune",
"6462118", "Waipukurau",
"6432616", "Ashburton",
"6499012", "Kawakawa",
"6432995", "Winton",
"6479294", "Hamilton",
"6496990", "Kaitaia",
"6432606", "Dunedin",
"6449082", "Wellington",
"6499002", "Auckland",
"6432639", "Edendale",
"643528", "Motueka",
"6496013", "Whangarei",
"644439", "Wellington",
"647325", "Opotiki",
"6478139", "Whangamata",
"6499041", "Helensville",
"643444", "Ranfurly",
"6468243", "Napier",
"6432804", "Riverton",
"6432814", "Mt\ Cook",
"6468813", "Taihape",
"6449740", "Paraparaumu",
"6468803", "Gisborne",
"6435532", "Motueka",
"6432657", "Motueka",
"6496511", "Whangarei",
"6434237", "Culverden",
"6439278", "Invercargill",
"646369", "Levin",
"6469247", "Wanganui",
"6436687", "Nelson",
"6433949", "Rangiora",
"6462104", "Marton",
"6462114", "Waipukurau",
"6433952", "Fairlie",
"644939", "Wellington",
"649964", "Auckland",
"6472128", "Waihi",
"6499873", "Kaitaia",
"6439073", "Motueka",
"643339", "Christchurch",
"643944", "Christchurch",
"646986", "Gisborne",
"6468691", "Gisborne",
"6434278", "Roxburgh",
"643412", "Balclutha",
"6472613", "Putaruru\/Tokoroa",
"6472603", "Hamilton",
"6463906", "Napier",
"6463916", "Mokau",
"6435547", "Blenheim",
"649828", "Auckland",
"6434242", "Darfield",
"6432660", "Christchurch",
"6468262", "Napier",
"6492420", "Auckland",
"6494313", "Warkworth",
"647925", "Tauranga",
"6496883", "Auckland",
"646657", "Masterton",
"646343", "Wanganui",
"6432620", "Palmerston",
"643439", "Oamaru",
"6439082", "Culverden",
"644528", "Wellington",
"6473998", "Taumarunui",
"644916", "Wellington",
"6473945", "Tauranga",
"646969", "New\ Plymouth",
"643614", "Timaru",
"6436581", "Invercargill",
"643683", "Timaru",
"6468821", "Featherston",
"6439740", "Christchurch",
"644299", "Paraparaumu",
"6437772", "Timaru",
"649557", "Auckland",
"6465625", "Gisborne",
"643755", "Hokitika",
"6439028", "Edendale",
"6499297", "Hibiscus\ Coast",
"6436597", "Cromwell",
"6479712", "Te\ Awamutu",
"6467777", "Napier",
"6477883", "Hamilton",
"6474449", "Opotiki",
"649666", "Auckland",
"6439068", "Fox\ Glacier",
"6434263", "Lawrence",
"6463920", "Palmerston\ North",
"6499477", "Pukekohe",
"6472621", "Tauranga",
"6492830", "Auckland",
"6434223", "Otautau",
"646382", "Taihape",
"646842", "Napier\/Hastings",
"6465617", "Mokau",
"6465607", "Taihape",
"649590", "Auckland",
"6479850", "Tokoroa",
"6432632", "Lumsden",
"6435557", "Geraldine",
"6499019", "Maungaturoto",
"644370", "Wellington",
"6499009", "Auckland",
"6473994", "Rotorua",
"6478132", "Paeroa",
"6435993", "Mt\ Cook",
"6433942", "Akaroa",
"649965", "Auckland",
"646761", "Opunake",
"6472196", "Taupo",
"6433911", "Nelson",
"6439344", "Timaru",
"6469576", "Dannevirke",
"6435506", "Amberley",
"6435516", "Balclutha",
"6435539", "Otautau",
"6432647", "Fairlie",
"6492221", "Auckland",
"649211", "Auckland",
"6462611", "Napier",
"6472458", "Rotorua",
"6477775", "Huntly",
"649210", "Auckland",
"6462601", "Palmerston\ North",
"6439705", "Motueka",
"6475627", "Taupo",
"643731", "Greymouth",
"6439715", "Timaru",
"6499553", "Kaikohe",
"64930", "Auckland",
"64338", "Christchurch",
"6433959", "Balclutha",
"6439455", "Otautau",
"6434249", "Kaikoura",
"6475605", "Huntly",
"6439727", "Dunedin",
"6475615", "Waihi",
"6478595", "Hamilton",
"6439024", "Lumsden",
"6468253", "Marton",
"643445", "Cromwell",
"6439851", "Culverden",
"6439767", "Alexandra",
"646757", "New\ Plymouth",
"6437465", "Waimate",
"6432817", "Christchurch",
"6437456", "Culverden",
"6436566", "Kurow",
"6492007", "Warkworth",
"6432807", "Tokanui",
"6439280", "Nelson",
"6479297", "Tauranga",
"6468886", "Wanganui",
"649425", "Warkworth",
"6435676", "Kurow",
"6436526", "Fox\ Glacier",
"6462802", "Palmerston\ North",
"647557", "Tauranga",
"6469616", "Featherston",
"6462812", "Napier\/Hastings",
"649394", "Auckland",
"6436684", "Dunedin",
"6472140", "Putaruru\/Tokoroa",
"6436653", "Edendale",
"6432654", "Blenheim",
"6499452", "Warkworth",
"6434234", "Darfield",
"647832", "Hamilton",
"643742", "Dunedin",
"6436630", "Takaka",
"6494702", "Whangarei",
"643655", "Dunedin",
"647836", "Hamilton",
"6462107", "Dannevirke",
"6469890", "Gisborne",
"6472420", "Hamilton",
"6434280", "Queenstown",
"6469029", "Opunake",
"6439316", "Edendale",
"6462125", "Taihape",
"6435544", "Winton",
"6432729", "Westport",
"6462156", "Hawera",
"646855", "Waipukurau",
"6462165", "Stratford",
"6432658", "Murchison",
"6469295", "Wanganui",
"643300", "Ashburton\/Akaroa\/Chatham\ Islands",
"6434238", "Waitangi\ \(Chatham\ Is\.\)",
"6439277", "Invercargill",
"649840", "Auckland",
"6469272", "Featherston",
"647211", "Hamilton",
"644901", "Wellington",
"6472221", "Tauranga",
"649908", "Auckland",
"6497775", "Helensville",
"6436688", "Waitangi\ \(Chatham\ Is\.\)",
"647210", "Hamilton",
"644900", "Wellington",
"6439531", "Timaru",
"6498859", "Kaitaia",
"643956", "Timaru",
"644817", "Wellington",
"6472822", "Rotorua",
"6478993", "Waihi",
"6434277", "Ranfurly",
"6439885", "Fox\ Glacier",
"6472115", "Taumarunui",
"6436622", "Cheviot",
"6479019", "Whangamata",
"6479009", "Hamilton",
"647378", "Taupo",
"6499463", "Whangarei",
"64997", "Auckland",
"6435548", "Westport",
"6439050", "Geraldine",
"647590", "Hamilton",
"6499423", "Great\ Barrier\ Island",
"643488", "Dunedin",
"649408", "Kaitaia",
"6466011", "Marton",
"6466001", "Napier",
"6474655", "Te\ Kuiti",
"6439525", "Milton",
"6432220", "Dunedin",
"6445951", "Wellington",
"6466996", "Stratford",
"6478094", "Tauranga",
"643456", "Dunedin",
"6432743", "Kurow",
"646831", "Napier\/Hastings",
"6435693", "Nelson",
"643452", "Wanaka",
"6472127", "Paeroa",
"6462410", "New\ Plymouth",
"644280", "Wellington",
"6439458", "Edendale",
"6439310", "Invercargill",
"644281", "Wellington",
"6434299", "Haast",
"6475608", "Otorohanga",
"6475618", "Opotiki",
"6478598", "Hamilton",
"6465624", "Featherston",
"6462150", "New\ Plymouth",
"647347", "Rotorua",
"6477778", "Te\ Awamutu",
"646365", "Palmerston\ North",
"6443708", "Paraparaumu",
"64483", "Wellington",
"647887", "Morrinsville",
"6436619", "Cheviot",
"6479022", "Morrinsville",
"6436636", "Waimate",
"643768", "Greymouth",
"6439708", "Murchison",
"6434286", "Christchurch",
"6439718", "Mt\ Cook",
"6449124", "Wellington",
"6432423", "Dunedin",
"6433992", "Riverton",
"64941", "Auckland",
"6436651", "Riverton",
"647854", "Hamilton",
"6439299", "Murchison",
"6472146", "Otorohanga",
"6472809", "Otorohanga",
"6472819", "Rotorua",
"6463997", "Palmerston\ North",
"644497", "Wellington",
"643335", "Christchurch",
"6465950", "Palmerston\ North",
"6436560", "Palmerston",
"6437450", "Westport",
"649815", "Auckland",
"6493206", "Pukekohe",
"6435670", "Palmerston",
"6468880", "Napier\/Hastings",
"6439286", "Cromwell",
"647245", "Hamilton",
"6473944", "Tauranga",
"6436520", "Greymouth",
"6469610", "Wanganui",
"6432226", "Timaru",
"6469012", "Waiouru",
"644803", "Wellington",
"6469002", "Hawera",
"6466990", "Mokau",
"6432741", "Milton",
"6466013", "Featherston",
"6439704", "Murchison",
"643963", "Christchurch",
"6439714", "Waimate",
"6466003", "Ruatoria",
"6445953", "Wellington",
"6434999", "Dunedin",
"6432712", "Amberley",
"6439007", "Dunedin",
"649458", "Dargaville",
"6439017", "Cromwell",
"6435691", "Murchison",
"6462416", "Waipukurau",
"6477774", "Thames",
"6499461", "Whangarei",
"6436547", "Geraldine",
"6478594", "Hamilton",
"6439025", "Otautau",
"6475604", "Hamilton",
"6475614", "Thames",
"6499421", "Hibiscus\ Coast",
"6439454", "Lumsden",
"6473948", "Opotiki",
"6473995", "Putaruru\/Tokoroa",
"649589", "Auckland",
"6466559", "Mokau",
"643225", "Otautau",
"646964", "Wanganui",
"643463", "Palmerston",
"649958", "Helensville",
"6478991", "Whangamata",
"6444887", "Paraparaumu",
"6432449", "Queenstown",
"646272", "Hawera",
"649986", "Whangarei",
"6498691", "Maungaturoto",
"6435687", "Lumsden",
"6439345", "Christchurch",
"6472223", "Hamilton",
"6493939", "Auckland",
"649982", "Whangarei",
"643434", "Oamaru",
"6439533", "Geraldine",
"6474658", "Waihi",
"6439528", "Lawrence",
"6463926", "Taihape",
"6472623", "Tauranga",
"646868", "Gisborne",
"6492836", "Kaitaia",
"6434261", "Balclutha",
"6492809", "Maungaturoto",
"646308", "Featherston",
"6434221", "Invercargill",
"6462164", "New\ Plymouth",
"6449008", "Paraparaumu",
"6493944", "Hibiscus\ Coast",
"6472118", "Taumarunui",
"6477881", "Hamilton",
"6462124", "Marton",
"6435545", "Gore",
"644467", "Wellington",
"6432997", "Edendale",
"6468823", "Napier\/Hastings",
"6468308", "Napier",
"6437464", "Timaru",
"6436583", "Te\ Anau",
"6439746", "Dunedin",
"6499062", "Hibiscus\ Coast",
"6434235", "Akaroa",
"6439862", "Nelson",
"6432655", "Nelson",
"6469298", "Masterton",
"6492426", "Whangarei",
"6432626", "Kurow",
"649887", "Auckland",
"6496881", "Auckland",
"649347", "Auckland",
"643923", "Nelson",
"6436685", "Nelson",
"6497778", "Pukekohe",
"6479102", "Rotorua",
"644896", "Wellington",
"6436579", "Wanaka",
"6498016", "Hibiscus\ Coast",
"6469200", "Gisborne",
"6462128", "Ohakune",
"647958", "Hamilton",
"6439853", "Amberley",
"644892", "Paraparaumu",
"6473338", "Rotorua",
"64935", "Auckland",
"6462168", "Featherston",
"647589", "Hamilton",
"6435669", "Wanaka",
"6468251", "Wanganui",
"6439884", "Franz\ Josef",
"644555", "Wellington",
"6478072", "Paeroa",
"6437482", "Lumsden",
"647982", "Hamilton",
"6492223", "Auckland",
"6462613", "Waipukurau",
"6462603", "Palmerston\ North",
"6499551", "Whangarei",
"6474654", "Taumarunui",
"6439524", "Oamaru",
"6478095", "Taupo",
"647986", "Hamilton",
"649399", "Auckland",
"6497774", "Warkworth",
"6472190", "Whakatane",
"649239", "Pukekohe",
"646325", "Palmerston\ North",
"6467559", "New\ Plymouth",
"6469570", "Palmerston\ North",
"6433913", "Murchison",
"6435500", "Christchurch",
"6469294", "Palmerston\ North",
"6435510", "Darfield",
"6479856", "Tauranga",
"6437468", "Wanaka",
"6479421", "Tauranga",
"6479247", "Hamilton",
"6435991", "Franz\ Josef",
"644393", "Paraparaumu",
"6439004", "Gore",
"6477777", "Hamilton",
"6432645", "Greymouth",
"6469712", "New\ Plymouth",
"6439717", "Fairlie",
"6475625", "Rotorua",
"6439707", "Takaka",
"6475617", "Whakatane",
"643732", "Greymouth",
"6439725", "Christchurch",
"6475607", "Morrinsville",
"649216", "Auckland",
"6439457", "Winton",
"6479091", "Taupo",
"6462621", "New\ Plymouth",
"649212", "Auckland",
"6439756", "Akaroa",
"6439765", "Milton",
"643736", "Greymouth",
"647846", "Hamilton",
"6473920", "Huntly",
"644493", "Wellington",
"6478597", "Hamilton",
"647386", "Taupo",
"6479753", "Taupo",
"647883", "Putaruru\/Tokoroa",
"646766", "New\ Plymouth",
"647343", "Rotorua",
"6435526", "Kurow",
"6439090", "Rangiora",
"6439731", "Gore",
"646762", "Stratford",
"6435555", "Timaru",
"6437473", "Milton",
"6478083", "Hamilton",
"643393", "Christchurch",
"6435886", "Invercargill",
"6474648", "Huntly",
"6435684", "Winton",
"6499069", "Pukekohe",
"6439869", "Blenheim",
"6463998", "Palmerston\ North",
"6436595", "Mt\ Cook",
"6499295", "Kaikohe",
"6436548", "Waimate",
"6435662", "Geraldine",
"6468693", "Gisborne",
"6479846", "Taumarunui",
"6465627", "Levin",
"6463900", "Gisborne",
"644587", "Wellington",
"6495538", "Auckland",
"6479109", "Opotiki",
"6432889", "Blenheim",
"6472611", "Matamata",
"6467775", "Palmerston\ North",
"6472601", "Hamilton",
"649429", "Great\ Barrier\ Island",
"643467", "Dunedin",
"6499475", "Hibiscus\ Coast",
"6465605", "Marton",
"6465615", "Wanganui",
"646324", "Palmerston\ North",
"6499871", "Whangarei",
"6439071", "Motueka",
"6473932", "Rotorua",
"6478079", "Hamilton",
"6439018", "Ranfurly",
"6499818", "Great\ Barrier\ Island",
"6439008", "Timaru",
"6496513", "Whangarei",
"6463994", "Dannevirke",
"64320", "Gore",
"6467552", "New\ Plymouth",
"644910", "Wellington",
"649918", "Auckland",
"6468811", "Marton",
"6468801", "Wanganui",
"6435688", "Queenstown",
"6469850", "Napier",
"6496011", "Kaikohe",
"643967", "Christchurch",
"6432610", "Darfield",
"6496996", "Warkworth",
"6473947", "Whakatane",
"6468241", "Gisborne",
"6499043", "Hibiscus\ Coast",
"6444888", "Paraparaumu",
"6437440", "Nelson",
"649814", "Auckland",
"6474639", "Opotiki",
"6462420", "Palmerston\ North",
"643450", "Queenstown",
"646836", "Napier\/Hastings",
"643451", "Queenstown",
"6434275", "Milton",
"6435953", "Christchurch",
"649883", "Auckland",
"6434292", "Hokitika",
"647855", "Hamilton",
"644889", "Wellington",
"644934", "Wellington",
"6474657", "Thames",
"6439527", "Kurow",
"6436641", "Lawrence",
"649969", "Auckland",
"6469281", "Wairoa",
"643334", "Christchurch",
"6472125", "Huntly",
"643949", "Dunedin",
"6466523", "Palmerston\ North",
"6498821", "Dargaville",
"6442129", "Paraparaumu",
"6475820", "Hamilton",
"6479029", "Waihi",
"6436612", "Akaroa",
"6472802", "Paeroa",
"6472812", "Tauranga",
"6469313", "Marton",
"6439275", "Nelson",
"643951", "Dunedin",
"6469303", "Waipukurau",
"643950", "Dunedin",
"6469297", "Masterton",
"646364", "Levin",
"6472131", "Rotorua",
"6449031", "Paraparaumu",
"6433999", "Otautau",
"6497777", "Auckland",
"644463", "Wellington",
"644619", "Wellington",
"6439292", "Timaru",
"6479244", "Tauranga",
"643306", "Ashburton\/Akaroa\/Chatham\ Islands",
"6432998", "Tokanui",
"649846", "Auckland",
"644902", "Paraparaumu",
"6433986", "Queenstown",
"643449", "Alexandra",
"6495563", "Whangarei",
"643302", "Ashburton\/Akaroa\/Chatham\ Islands",
"647216", "Rotorua",
"644906", "Paraparaumu",
"6432719", "Waitangi\ \(Chatham\ Is\.\)",
"6432736", "Dunedin",
"646590", "Palmerston\ North",
"6434992", "Ranfurly",
"6439326", "Rangiora",
"6469019", "Pahiatua",
"6469009", "Palmerston\ North",
"646378", "Masterton",
"6439870", "Queenstown",
"649200", "Auckland",
"6462105", "Taihape",
"6462115", "Wairoa",
"643224", "Invercargill",
"646965", "Wanganui\ W100",
"6462127", "Dannevirke",
"6466549", "Ruatoria",
"643740", "Christchurch",
"643741", "Christchurch",
"6462167", "Mokau",
"6473337", "Rotorua",
"6432805", "Winton",
"6432815", "Fairlie",
"646211", "Napier",
"6437467", "Queenstown",
"6462221", "Gisborne",
"64953", "Auckland",
"6436993", "Kaikoura",
"6432442", "Christchurch",
"6466552", "New\ Plymouth",
"6439046", "Kurow",
"6432994", "Otautau",
"6479295", "Whakatane",
"6493932", "Dargaville",
"6468993", "Taihape",
"6432751", "Riverton",
"6436506", "Darfield",
"649213", "Auckland",
"6436998", "Blenheim",
"646974", "Napier",
"6473930", "Waihi",
"6495564", "Whangarei",
"6435551", "Franz\ Josef",
"6439735", "Lumsden",
"647843", "Hamilton",
"6433956", "Dunedin",
"644496", "Wellington",
"6468998", "Napier",
"6463912", "New\ Plymouth",
"649220", "Auckland",
"6463902", "Gisborne",
"6434246", "Waitangi\ \(Chatham\ Is\.\)",
"6469304", "Wairoa",
"6469314", "Waiouru",
"6433917", "Franz\ Josef",
"6463941", "Masterton",
"644219", "Wellington",
"6435660", "Haast",
"6432641", "Franz\ Josef",
"6492227", "Whangarei",
"6462617", "Masterton",
"6462607", "Taihape",
"6478141", "Taupo",
"6475483", "Tauranga",
"643236", "Winton",
"6466524", "Ohakune",
"6499006", "Whangarei",
"6432612", "Rangiora",
"6499016", "Kaikohe",
"6475621", "Tauranga",
"647858", "Hamilton",
"647886", "Putaruru\/Tokoroa",
"6472199", "Opotiki",
"646763", "Opunake",
"647346", "Rotorua",
"6469852", "Napier",
"6439721", "Blenheim",
"6435954", "Christchurch",
"6469579", "Pahiatua",
"6467550", "New\ Plymouth",
"647882", "Putaruru\/Tokoroa",
"6435536", "Invercargill",
"6439857", "Akaroa",
"6439761", "Kurow",
"6435519", "Twizel",
"6462625", "Hawera",
"6435509", "Culverden",
"6479229", "Opotiki",
"6468805", "Wanganui",
"6468815", "Pahiatua",
"6469308", "Opunake",
"6469318", "Levin",
"6473922", "Morrinsville",
"6474446", "Otorohanga",
"6468994", "Waipukurau",
"6432993", "Balclutha",
"6496015", "Maungaturoto",
"6436994", "Murchison",
"6436587", "Gore",
"6495568", "Kawakawa",
"6469710", "New\ Plymouth",
"6468245", "Wairoa",
"6468827", "New\ Plymouth",
"644298", "Paraparaumu",
"649291", "Auckland",
"6479747", "Te\ Kuiti",
"649954", "Auckland",
"6436591", "Nelson",
"644922", "Wellington",
"646341", "Wanganui",
"646968", "New\ Plymouth\ W100",
"6467771", "New\ Plymouth",
"6472605", "Thames",
"6472615", "Te\ Kuiti",
"6442609", "Paraparaumu",
"644529", "Wellington",
"646375", "Pahiatua",
"6439092", "Rangiora",
"6499471", "Hibiscus\ Coast",
"643438", "Kurow",
"644205", "Wellington",
"6472627", "Rotorua",
"643681", "Timaru",
"6499875", "Dargaville",
"6439075", "Takaka",
"643680", "Fairlie",
"6466528", "Dannevirke",
"649600", "Auckland",
"6465611", "Napier",
"6465601", "Palmerston\ North",
"6496518", "Kawakawa",
"6496508", "Hibiscus\ Coast",
"6439271", "Westport",
"646304", "Featherston",
"6479006", "Taupo",
"6435683", "Te\ Anau",
"6469468", "Featherston",
"646864", "Ruatoria",
"6478084", "Hamilton",
"6437474", "Oamaru",
"6466999", "New\ Plymouth",
"643489", "Dunedin",
"649409", "Kaitaia",
"6479500", "Whakatane",
"646833", "Napier\/Hastings",
"6439872", "Alexandra",
"6434990", "Queenstown",
"6479754", "Tauranga",
"6499048", "Pukekohe",
"649886", "Auckland",
"6434271", "Balclutha",
"643303", "Ashburton\/Akaroa\/Chatham\ Islands",
"6498817", "Hibiscus\ Coast",
"6493930", "Whangarei",
"6495533", "Whangarei",
"647213", "Hamilton",
"644903", "Wellington",
"644462", "Wellington",
"6436645", "Ranfurly",
"6466007", "Stratford",
"6466550", "New\ Plymouth",
"649909", "Auckland",
"643989", "Nelson",
"6498856", "Maungaturoto",
"6443990", "Paraparaumu",
"6498825", "Maungaturoto",
"644466", "Wellington",
"647220", "Tauranga",
"6432440", "Christchurch",
"6472121", "Te\ Kuiti",
"6439003", "Ashburton",
"6469285", "Hawera",
"6499044", "Hibiscus\ Coast",
"6434351", "Mt\ Cook",
"6436610", "Kaikoura",
"6462225", "Levin",
"6432811", "Fox\ Glacier",
"6432801", "Lumsden",
"6479291", "Hamilton",
"6462137", "Palmerston\ North",
"6499747", "Dargaville",
"6439319", "Otautau",
"6437478", "Twizel",
"6432755", "Edendale",
"6439336", "Cromwell",
"6432427", "Greymouth",
"6434290", "Greymouth",
"649915", "Auckland",
"6432726", "Franz\ Josef",
"6437442", "Murchison",
"6496514", "Whangarei",
"6462159", "Mokau",
"6462422", "Napier\/Hastings",
"6463993", "Pahiatua",
"6437459", "Rangiora",
"644897", "Wellington",
"6436569", "Alexandra",
"6435679", "Alexandra",
"6462101", "Levin",
"6468889", "Levin",
"6436529", "Westport",
"6439290", "Christchurch",
"6472810", "Tauranga",
"647987", "Tauranga",
"6472800", "Thames",
"6436655", "Westport",
"6468997", "Napier",
"6433918", "Fox\ Glacier",
"6436626", "Akaroa",
"6436584", "Winton",
"6436997", "Motueka",
"643977", "Christchurch",
"6432710", "Christchurch",
"6468824", "Wanganui",
"6437463", "Mt\ Cook",
"6466992", "Hawera",
"6469000", "New\ Plymouth",
"6469010", "Taihape",
"6469276", "Wanganui",
"6462123", "Palmerston\ North",
"649248", "Auckland",
"644240", "Wellington",
"6439858", "Kaikoura",
"6462163", "New\ Plymouth",
"6493943", "Helensville",
"647829", "Hamilton",
"6472826", "Matamata",
"6499100", "Pukekohe",
"6462608", "Dannevirke",
"6492228", "Warkworth",
"6462618", "Masterton",
"647847", "Hamilton",
"6472624", "Whakatane",
"646865", "Gisborne",
"6473991", "Whakatane",
"6468303", "Napier",
"6436588", "Lumsden",
"6494706", "Whangarei",
"6475829", "Hamilton",
"6495567", "Kaitaia",
"6479020", "Te\ Awamutu",
"6478995", "Matamata",
"6469317", "Pahiatua",
"644806", "Wellington",
"6433914", "Takaka",
"6469307", "Stratford",
"6437449", "Hokitika",
"6469293", "New\ Plymouth",
"649639", "Auckland",
"646328", "Palmerston\ North",
"6439341", "Fairlie",
"6462152", "New\ Plymouth",
"643966", "Christchurch",
"644802", "Wellington",
"6439312", "Riverton",
"646650", "Napier",
"643962", "Christchurch",
"6497773", "Dargaville",
"646651", "Napier",
"649983", "Whangarei",
"643903", "Christchurch",
"6439523", "Balclutha",
"6474653", "Putaruru\/Tokoroa",
"6468882", "Napier\/Hastings",
"6435672", "Balclutha",
"6472628", "Taupo",
"6462816", "Gisborne",
"6432745", "Roxburgh",
"6436522", "Greymouth",
"6462806", "Napier\/Hastings",
"6462604", "Ohakune",
"6462149", "Ruatoria",
"646273", "Hawera",
"6462614", "Wairoa",
"6492224", "Auckland",
"6435695", "Fox\ Glacier",
"644586", "Wellington",
"649914", "Auckland",
"6466527", "Taihape",
"6499716", "Helensville",
"6469045", "Waipukurau",
"6437452", "Akaroa",
"6436562", "Balclutha",
"6439883", "Hokitika",
"649550", "Auckland",
"6479748", "Taumarunui",
"6499465", "Dargaville",
"6439854", "Waitangi\ \(Chatham\ Is\.\)",
"649551", "Auckland",
"6499456", "Kaikohe",
"643466", "Dunedin",
"644834", "Paraparaumu",
"6439061", "Greymouth",
"649869", "Auckland",
"6499425", "Auckland",
"649829", "Auckland",
"64687", "Napier\/Hastings",
"6499047", "Pukekohe",
"6479230", "Opotiki",
"644810", "Wellington",
"649818", "Auckland",
"6437480", "Gore",
"6478070", "Morrinsville",
"649847", "Auckland",
"6496507", "Helensville",
"6494315", "Warkworth",
"6432651", "Queenstown",
"6496517", "Kaitaia",
"6434231", "Christchurch",
"643338", "Christchurch",
"6469241", "Napier",
"643307", "Ashburton\/Akaroa\/Chatham\ Islands",
"6436681", "Dunedin",
"6479100", "Rotorua",
"649930", "Auckland",
"647217", "Taupo",
"644938", "Wellington",
"644907", "Wellington",
"6432424", "Nelson",
"6469202", "Levin",
"646837", "Wairoa",
"6432636", "Te\ Anau",
"6434265", "Milton",
"6432609", "Mt\ Cook",
"6432619", "Christchurch",
"6466008", "Ohakune",
"649652", "Warkworth",
"6478136", "Te\ Awamutu",
"643922", "Nelson",
"6449123", "Wellington",
"646368", "Levin",
"6434225", "Edendale",
"643926", "Christchurch",
"646975", "Napier",
"6465623", "Opunake",
"6469572", "Palmerston\ North",
"6435512", "Rangiora",
"6435502", "Christchurch",
"647315", "Opotiki",
"6433946", "Culverden",
"649431", "Maungaturoto",
"6435541", "Te\ Anau",
"643529", "Nelson",
"6472192", "Whakatane",
"6477885", "Tauranga",
"6479716", "Waihi",
"6432428", "Queenstown",
"644204", "Wellington",
"6437477", "Roxburgh",
"646374", "Dannevirke",
"6472224", "Taupo",
"6439534", "Mt\ Cook",
"6437776", "Cromwell",
"6473929", "Thames",
"647983", "Hamilton",
"643219", "Invercargill",
"644893", "Wellington",
"646750", "Mokau",
"647869", "Thames",
"646751", "New\ Plymouth",
"649479", "Auckland",
"6499748", "Whangarei",
"647551", "Tauranga",
"6462138", "Palmerston\ North",
"6435995", "Darfield",
"647309", "Whakatane",
"6499630", "Pukekohe",
"6439453", "Te\ Anau",
"6475613", "Te\ Awamutu",
"647549", "Tauranga",
"6475603", "Hamilton",
"644392", "Wellington",
"6468255", "Pahiatua",
"6439860", "Nelson",
"6493991", "Pukekohe",
"6478593", "Hamilton",
"6498814", "Pukekohe",
"6477773", "Taupo",
"6495589", "Pukekohe",
"6466004", "Waipukurau",
"6439713", "Mt\ Cook",
"6439099", "Kaikoura",
"6439703", "Takaka",
"6478091", "Matamata",
"6445954", "Wellington",
"6499555", "Kawakawa",
"6466508", "Napier\/Wairoa",
"644913", "Wellington",
"6465621", "New\ Plymouth",
"646858", "Waipukurau",
"6499468", "Kawakawa",
"6435543", "Tokanui",
"6433940", "Westport",
"643686", "Timaru",
"6499428", "Warkworth",
"6472607", "Paeroa",
"6472625", "Opotiki",
"6496999", "Auckland",
"644920", "Wellington",
"646342", "Wanganui",
"647894", "Taumarunui",
"6432630", "Christchurch",
"6449121", "Wellington",
"6478130", "Morrinsville",
"6432748", "Cromwell",
"646346", "Wanganui",
"6479852", "Whangamata",
"6435698", "Hokitika",
"6499877", "Maungaturoto",
"649919", "Auckland",
"6432653", "Wanaka",
"6434233", "Rangiora",
"649634", "Auckland",
"6469243", "New\ Plymouth",
"649292", "Auckland",
"646843", "Napier\/Hastings",
"6468817", "Stratford",
"6468807", "Gisborne",
"6479849", "Thames",
"6436654", "Tokanui",
"647974", "Hamilton",
"6436683", "Rangiora",
"649296", "Auckland",
"6496017", "Great\ Barrier\ Island",
"649428", "Hibiscus\ Coast",
"6496007", "Helensville",
"6468825", "Gisborne",
"6468247", "Mokau",
"6478998", "Hamilton",
"6478076", "Te\ Awamutu",
"6437486", "Tokanui",
"6436585", "Tokanui",
"647881", "Matamata",
"647880", "Matamata",
"6462605", "Marton",
"6477771", "Whakatane",
"6439742", "Christchurch",
"6462615", "Gisborne",
"6435694", "Franz\ Josef",
"6492225", "Pukekohe",
"6435529", "Roxburgh",
"64334", "Christchurch",
"647968", "Hamilton",
"64936", "Auckland",
"6432744", "Ranfurly",
"6439711", "Geraldine",
"6439701", "Nelson",
"6478093", "Rotorua",
"6499424", "Auckland",
"6475611", "Taumarunui",
"6475601", "Hamilton",
"643390", "Christchurch",
"6432622", "Balclutha",
"6439451", "Invercargill",
"649405", "Kaikohe",
"643485", "Lawrence",
"643230", "Invercargill",
"6435889", "Timaru",
"6442197", "Paraparaumu",
"6439080", "Ashburton",
"643231", "Invercargill",
"6432662", "Christchurch",
"6468260", "Featherston",
"6499066", "Helensville",
"6462627", "Wanganui",
"6499464", "Whangarei",
"6439855", "Rangiora",
"647824", "Hamilton",
"6478591", "Hamilton",
"6478994", "Tauranga",
"6463922", "Palmerston\ North",
"6473842", "Taupo",
"6492832", "Dargaville",
"6439737", "Tokanui",
"6479710", "Putaruru\/Tokoroa",
"649905", "Auckland",
"6436658", "Fox\ Glacier",
"6437770", "Nelson",
"6439759", "Cromwell",
"6433915", "Greymouth",
"646213", "Wanganui",
"6472820", "Hamilton",
"6434224", "Te\ Anau",
"6439049", "Palmerston",
"643782", "Westport",
"6499558", "Great\ Barrier\ Island",
"647332", "Rotorua",
"6434264", "Kurow",
"6477884", "Tauranga",
"6469270", "Marton",
"6462121", "Palmerston\ North",
"647544", "Tauranga",
"6436519", "Takaka",
"643246", "Tokanui",
"6436509", "Waitangi\ \(Chatham\ Is\.\)",
"6462161", "Masterton",
"6468258", "Waiouru",
"6473331", "Rotorua",
"6432739", "Balclutha",
"643214", "Invercargill",
"6437461", "Fairlie",
"6462227", "Napier",
"6432716", "Darfield",
"6462412", "Gisborne",
"647864", "Thames",
"6469006", "Gisborne",
"6469016", "Ohakune",
"6432222", "Christchurch",
"647304", "Whakatane",
"6435998", "Rangiora",
"644209", "Wellington",
"6432425", "Invercargill",
"644525", "Wellington",
"646379", "Masterton",
"6496884", "Auckland",
"6432757", "Lumsden",
"6439052", "Mt\ Cook",
"643743", "Christchurch",
"647833", "Hamilton",
"6494314", "Warkworth",
"647928", "Tauranga",
"6436620", "Kaikoura",
"6498815", "Helensville",
"6439023", "Te\ Anau",
"6499450", "Warkworth",
"6468254", "Ohakune",
"6439881", "Greymouth",
"643448", "Alexandra",
"6433996", "Edendale",
"647878", "Te\ Kuiti",
"644460", "Wellington",
"644461", "Wellington",
"643524", "Takaka",
"6477888", "Taupo",
"6439063", "Westport",
"6472142", "Te\ Awamutu",
"6499554", "Kaitaia",
"6434268", "Roxburgh",
"6439282", "Christchurch",
"6433989", "Waimate",
"6445955", "Wellington",
"6474651", "Otorohanga",
"6439521", "Dunedin",
"6462810", "Gisborne",
"6466005", "Mokau",
"6436647", "Te\ Anau",
"6462800", "Palmerston\ North",
"6469287", "Ohakune",
"647905", "Taupo",
"6434228", "Tokanui",
"643417", "Milton",
"6498900", "Pukekohe",
"643948", "Invercargill",
"6469291", "Gisborne",
"643453", "Dunedin",
"6439343", "Waimate",
"646954", "Palmerston\ North\ W100",
"6439535", "Fairlie",
"649968", "Auckland",
"6497771", "Kaikohe",
"6472225", "Rotorua",
"649881", "Auckland",
"644888", "Wellington",
"649880", "Auckland",
"6439268", "Dunedin",
"6434282", "Queenstown",
"6473993", "Te\ Awamutu",
"6469892", "Gisborne",
"6435994", "Ashburton",
"646601", "Napier",
"6479026", "Paeroa",
"6468301", "Napier",
"6494700", "Whangarei",
"6436632", "Murchison",
"6466556", "Stratford",
"644524", "Wellington",
"6498850", "Great\ Barrier\ Island",
"6432747", "Queenstown",
"6439042", "Oamaru",
"6466525", "Marton",
"6472123", "Morrinsville",
"6499878", "Warkworth",
"6439001", "Christchurch",
"6439011", "Queenstown",
"6499811", "Hibiscus\ Coast",
"6435697", "Westport",
"6432446", "Blenheim",
"649552", "Pukekohe",
"6462624", "Opunake",
"647865", "Whangamata",
"649475", "Auckland",
"646847", "Napier\/Hastings",
"6499467", "Kaitaia",
"6434273", "Lawrence",
"6499726", "Kawakawa",
"643215", "Invercargill",
"649959", "Hibiscus\ Coast",
"646387", "Waiouru",
"6472608", "Waihi",
"6435955", "Christchurch",
"647305", "Whakatane",
"6493936", "Maungaturoto",
"649588", "Auckland",
"6495531", "Helensville",
"6436502", "Amberley",
"6439322", "Culverden",
"644801", "Wellington",
"6432229", "Dunedin",
"6439734", "Edendale",
"643960", "Christchurch",
"6496008", "Hibiscus\ Coast",
"643961", "Christchurch",
"6496018", "Auckland",
"649941", "Auckland",
"649940", "Auckland",
"6478997", "Morrinsville",
"6495565", "Dargaville",
"6432732", "Fairlie",
"6434996", "Roxburgh",
"6462419", "Masterton",
"646656", "Levin",
"6468248", "New\ Plymouth",
"6468808", "Palmerston\ North",
"6435681", "Invercargill",
"6468818", "Opunake",
"6479000", "Hamilton",
"644917", "Wellington",
"6479010", "Thames",
"649459", "Whangarei",
"6469305", "New\ Plymouth",
"6469315", "Taihape",
"6439273", "Blenheim",
"64357", "Blenheim",
"6479045", "Taumarunui",
"6442198", "Paraparaumu",
"6439296", "Invercargill",
"6472604", "Hamilton",
"649825", "Auckland",
"6472149", "Whangamata",
"6472614", "Otorohanga",
"6472816", "Morrinsville",
"6472806", "Matamata",
"6462628", "Wanganui",
"6499874", "Kawakawa",
"6493209", "Great\ Barrier\ Island",
"6446509", "Paraparaumu",
"6439289", "Akaroa",
"6462103", "Levin",
"6433982", "Kurow",
"6469020", "Stratford",
"6468995", "Napier",
"6439330", "Westport",
"6436657", "Franz\ Josef",
"643769", "Greymouth",
"6434296", "Greymouth",
"6432720", "Nelson",
"6463991", "Masterton",
"6443330", "Wellington",
"6468804", "Napier",
"6468814", "Dannevirke",
"6434353", "Twizel",
"6442821", "Wellington",
"64992", "Auckland",
"6432813", "Geraldine",
"6432803", "Otautau",
"6468244", "Waipukurau",
"6436639", "Oamaru",
"6436995", "Westport",
"6436616", "Geraldine",
"643525", "Takaka",
"6439738", "Winton",
"6496014", "Dargaville",
"6434289", "Wanaka",
"6472429", "Whakatane",
"6479293", "Hamilton",
"6439723", "Blenheim",
"6467525", "Mokau",
"6439763", "Palmerston",
"6435530", "Nelson",
"647837", "Hamilton",
"6468257", "Taihape",
"6478143", "Opotiki",
"6469284", "Stratford",
"6475481", "Tauranga",
"6479859", "Tauranga",
"6498824", "Kawakawa",
"6432643", "Haast",
"649635", "Auckland",
"6499557", "Warkworth",
"6499000", "Auckland",
"6449080", "Paraparaumu",
"6496992", "Kawakawa",
"649238", "Pukekohe",
"6499010", "Kaitaia",
"644391", "Wellington",
"6436644", "Alexandra",
"6475623", "Tauranga",
"644390", "Wellington",
"647552", "Tauranga",
"6436576", "Cromwell",
"6478085", "Tauranga",
"6432758", "Otautau",
"6437475", "Palmerston",
"6434240", "Ashburton",
"646756", "New\ Plymouth",
"647895", "Taumarunui",
"6498019", "Pukekohe",
"6435666", "Oamaru",
"6479842", "Matamata",
"6463943", "Masterton",
"646752", "New\ Plymouth",
"6447770", "Paraparaumu",
"6462228", "Wanganui",
"647959", "Hamilton",
"6479241", "Whakatane",
"6435997", "Amberley",
"6435553", "Wanaka",
"6433950", "Waitangi\ \(Chatham\ Is\.\)",
"6499473", "Helensville",
"6436648", "Lumsden",
"643984", "Blenheim",
"6435562", "Invercargill",
"6434267", "Ranfurly",
"6465613", "Wairoa",
"6434402", "Alexandra",
"6465603", "Palmerston\ North",
"6434227", "Riverton",
"6469288", "Waiouru",
"6439749", "Christchurch",
"643457", "Dunedin",
"6432669", "Rangiora",
"6436593", "Nelson",
"6492429", "Pukekohe",
"6432629", "Roxburgh",
"6477887", "Te\ Awamutu",
"646946", "Masterton",
"6478129", "Matamata",
"6435882", "Dunedin",
"6467773", "Wanganui",
"643921", "Blenheim",
"649650", "Auckland",
"643920", "Rangiora",
"6498882", "Whangarei",
"643484", "Dunedin",
"649404", "Kawakawa",
"6439267", "Dunedin",
"6492839", "Whangarei",
"6432991", "Milton",
"647374", "Taupo",
"647825", "Hamilton",
"6462224", "Masterton",
"643669", "Christchurch",
"643413", "Balclutha",
"6469716", "Opunake",
"6499045", "Hibiscus\ Coast",
"6439752", "Cheviot",
"6496515", "Dargaville",
"643957", "Timaru",
"643420", "Christchurch",
"6474440", "Paeroa",
"643421", "Christchurch",
"644816", "Wellington",
"6432754", "Tokanui",
"649476", "Auckland",
"6462421", "New\ Plymouth",
"6499457", "Kaitaia",
"6435534", "Takaka",
"647866", "Thames",
"6437441", "Motueka",
"6499725", "Hibiscus\ Coast",
"643216", "Invercargill",
"6435956", "Christchurch",
"647862", "Paeroa",
"6493935", "Kawakawa",
"647306", "Whakatane",
"643212", "Invercargill",
"6473999", "Taupo",
"649892", "Auckland",
"6466555", "Hawera",
"6462817", "Napier",
"6462807", "Napier\/Hastings",
"6436640", "Palmerston",
"649555", "Auckland",
"6499014", "Dargaville",
"6479292", "Hamilton",
"6449084", "Wellington",
"6499004", "Hibiscus\ Coast",
"6466526", "Waiouru",
"6499717", "Whangarei",
"6432802", "Gore",
"6498820", "Whangarei",
"6432812", "Haast",
"6475821", "Hamilton",
"6469280", "Waipukurau",
"6432445", "Greymouth",
"64962", "Auckland",
"647949", "Hamilton",
"649233", "Pukekohe",
"647334", "Rotorua",
"6472130", "Tauranga",
"6449030", "Paraparaumu",
"6439029", "Tokanui",
"6469316", "Dannevirke",
"6469306", "Hawera",
"6434244", "Amberley",
"6474448", "Taumarunui",
"6439069", "Haast",
"647546", "Tauranga",
"6433954", "Lawrence",
"647927", "Tauranga",
"6433983", "Ranfurly",
"6462102", "Levin",
"647542", "Tauranga",
"644399", "Wellington",
"6495566", "Kaikohe",
"6434995", "Te\ Anau",
"6432733", "Geraldine",
"649640", "Auckland",
"647877", "Te\ Kuiti",
"6472827", "Tauranga",
"6439871", "Queenstown",
"643447", "Alexandra",
"6499018", "Maungaturoto",
"643660", "Christchurch",
"644245", "Wellington",
"6499008", "Pukekohe",
"646952", "Palmerston\ North\ W100",
"6439323", "Cheviot",
"643418", "Balclutha",
"6439295", "Nelson",
"649826", "Auckland",
"6469277", "Gisborne",
"6472805", "Morrinsville",
"6472815", "Whakatane",
"649822", "Auckland",
"646861", "Gisborne",
"6439272", "Timaru",
"6435538", "Lumsden",
"643522", "Nelson",
"6472122", "Te\ Awamutu",
"644887", "Wellington",
"6472459", "Rotorua",
"649967", "Auckland",
"6462220", "New\ Plymouth",
"6436996", "Takaka",
"6436615", "Ashburton",
"643526", "Motueka",
"643947", "Invercargill",
"6433958", "Oamaru",
"6474444", "Hamilton",
"6468996", "Napier",
"6432750", "Invercargill",
"6436503", "Ashburton",
"6434248", "Cheviot",
"6434295", "Fox\ Glacier",
"6436627", "Waitangi\ \(Chatham\ Is\.\)",
"6434272", "Alexandra",
"649636", "Auckland",
"649294", "Auckland",
"6498883", "Whangarei",
"646857", "Waipukurau",
"6498854", "Hibiscus\ Coast",
"649632", "Auckland",
"649949", "Auckland",
"649451", "Auckland",
"6479090", "Taupo",
"6473921", "Matamata",
"6439753", "Amberley",
"6467555", "New\ Plymouth",
"643657", "Queenstown",
"6462620", "New\ Plymouth",
"643469", "Dunedin",
"6465602", "Palmerston\ North",
"6465612", "Waipukurau",
"649583", "Auckland",
"6473935", "Rotorua",
"6439730", "Invercargill",
"6499472", "Great\ Barrier\ Island",
"6439091", "Rangiora",
"643684", "Timaru",
"6435563", "Queenstown",
"649951", "Auckland",
"6439338", "Queenstown",
"649950", "Auckland",
"6478086", "Hamilton",
"6437476", "Ranfurly",
"647896", "Taumarunui",
"6467772", "Hawera",
"6435883", "Dunedin",
"6479717", "Otorohanga",
"6436592", "Nelson",
"6479014", "Matamata",
"6479004", "Te\ Awamutu",
"6432728", "Haast",
"644589", "Wellington",
"6435665", "Waimate",
"647892", "Taumarunui",
"646344", "Wanganui",
"6437777", "Christchurch",
"649427", "Hibiscus\ Coast",
"6432659", "Takaka",
"6469249", "Masterton",
"6434239", "Christchurch",
"647323", "Whakatane",
"6463942", "Masterton",
"6479843", "Morrinsville",
"6472610", "Morrinsville",
"6472600", "Hamilton",
"6463901", "Gisborne",
"6463911", "New\ Plymouth",
"64983", "Auckland",
"6436689", "Christchurch",
"6433947", "Darfield",
"6498858", "Kaikohe",
"6478137", "Thames",
"64331", "Rangiora\/Amberley\/Culverden\/Darfield\/Cheviot\/Kaikoura",
"6432637", "Winton",
"6435552", "Queenstown",
"6499870", "Whangarei",
"6439070", "Motueka",
"649281", "Auckland",
"649280", "Auckland",
"6439762", "Oamaru",
"6468810", "Ohakune",
"6468800", "Napier\/Hastings",
"6496516", "Kaikohe",
"6479018", "Putaruru\/Tokoroa",
"6479008", "Rotorua",
"6432724", "Greymouth",
"6469851", "Napier",
"6439722", "Blenheim",
"6435549", "Hokitika",
"6439334", "Fox\ Glacier",
"644815", "Wellington",
"6496993", "Whangarei",
"6496010", "Kaitaia",
"6475622", "Tauranga",
"6432611", "Kaikoura",
"647826", "Huntly",
"6478142", "Whakatane",
"643690", "Waimate",
"6432642", "Fox\ Glacier",
"6499046", "Pukekohe",
"6469715", "Mokau",
"6472626", "Rotorua",
"647838", "Hamilton",
"6434260", "Oamaru",
"646754", "New\ Plymouth",
"6463923", "Ohakune",
"647923", "Whakatane",
"6462808", "Napier\/Hastings",
"6462818", "New\ Plymouth",
"6473843", "Taupo",
"6492833", "Warkworth",
"6434220", "Invercargill",
"646345", "Wanganui",
"6499718", "Whangarei",
"646370", "Masterton",
"643288", "Christchurch",
"649237", "Pukekohe",
"6499458", "Kawakawa",
"6479746", "Opotiki",
"643685", "Fairlie",
"644577", "Wellington",
"6477880", "Hamilton",
"6469274", "New\ Plymouth",
"643753", "Hokitika",
"6499479", "Pukekohe",
"6478092", "Huntly",
"6465609", "Pahiatua",
"6468826", "Levin",
"6465619", "Masterton",
"6478075", "Te\ Kuiti",
"6437485", "Te\ Anau",
"6439743", "Christchurch",
"6436586", "Edendale",
"64927", "Auckland",
"6436624", "Darfield",
"6436599", "Blenheim",
"6499299", "Whangarei",
"6432663", "Christchurch",
"6496880", "Auckland",
"6474447", "Te\ Kuiti",
"6432623", "Lawrence",
"649295", "Auckland",
"6467779", "Masterton",
"6469201", "Ruatoria",
"6469278", "Gisborne",
"647372", "Taupo",
"649406", "Kaitaia",
"643486", "Dunedin",
"6436682", "Dunedin",
"6499454", "Whangarei",
"6469242", "Levin",
"6434232", "Ashburton",
"6499065", "Helensville",
"6439865", "Murchison",
"6439856", "Darfield",
"649889", "Auckland",
"6468250", "Stratford",
"6432652", "Cromwell",
"6435537", "Winton",
"647376", "Taupo",
"649402", "Kawakawa",
"643482", "Dunedin",
"649349", "Auckland",
"649963", "Auckland",
"6472828", "Tauranga",
"6462616", "Ruatoria",
"6492226", "Helensville",
"6462606", "Waiouru",
"6462804", "Palmerston\ North",
"6462814", "Hawera",
"643943", "Christchurch",
"6435559", "Haast",
"6499007", "Kaikohe",
"6499017", "Kaikohe",
"6434247", "Kaikoura",
"6472191", "Whakatane",
"6439729", "Fox\ Glacier",
"6435542", "Riverton",
"6439769", "Roxburgh",
"6435501", "Christchurch",
"6435511", "Kaikoura",
"6469571", "Palmerston\ North",
"643982", "Christchurch",
"649902", "Warkworth",
"6436628", "Ashburton",
"6433916", "Hokitika",
"647873", "Otorohanga",
"6479853", "Putaruru",
"6479420", "Tauranga",
"6494704", "Whangarei",
"6432649", "Waimate",
"6433957", "Palmerston",
"643443", "Wanaka",
"6435990", "Hokitika",
"6439311", "Invercargill",
"6433944", "Ashburton",
"646654", "Gisborne",
"649423", "Warkworth",
"6468268", "New\ Plymouth",
"6462151", "New\ Plymouth",
"6439342", "Geraldine",
"6434359", "Twizel",
"6492009", "Pukekohe",
"6432809", "Hokitika",
"6432819", "Christchurch",
"643538", "Nelson",
"6436633", "Geraldine",
"646388", "Taihape",
"6469893", "Ruatoria",
"6473992", "Opotiki",
"6478134", "Taumarunui",
"6434283", "Cromwell",
"6479299", "Rotorua",
"6432634", "Invercargill",
"643270", "Christchurch",
"649554", "Hibiscus\ Coast",
"6432426", "Blenheim",
"6479708", "Thames",
"6479718", "Taumarunui",
"6472143", "Morrinsville",
"6439337", "Wanaka",
"644526", "Wellington",
"6436650", "Otautau",
"643653", "Blenheim",
"6437778", "Greymouth",
"6432727", "Fox\ Glacier",
"6436561", "Oamaru",
"6437451", "Blenheim",
"6432715", "Culverden",
"6439283", "Rangiora",
"6469005", "Wanganui",
"6499746", "Kawakawa",
"644918", "Wellington",
"6436521", "Greymouth",
"6469611", "Wanganui",
"6462109", "Waiouru",
"6462119", "Wairoa",
"6435671", "Oamaru",
"6468881", "Napier\/Hastings",
"644212", "Wellington",
"6432223", "Akaroa",
"6432638", "Tokanui",
"6498857", "Dargaville",
"6466991", "Wanganui",
"6445956", "Wellington",
"6478138", "Waihi",
"6432740", "Lawrence",
"6466006", "Opunake",
"6435690", "Motueka",
"647906", "Taupo",
"6469040", "Wairoa",
"6462413", "Gisborne",
"6498816", "Great\ Barrier\ Island",
"6468264", "Palmerston\ North",
"6439279", "Christchurch",
"6499460", "Whangarei",
"6433995", "Tokanui",
"6439084", "Amberley",
"644499", "Wellington",
"6433948", "Kaikoura",
"6499420", "Pukekohe",
"647463", "Whakatane",
"647350", "Rotorua",
"647351", "Rotorua",
"64335", "Christchurch",
"647349", "Rotorua",
"647889", "Morrinsville",
"6472129", "Whangamata",
"6478990", "Thames",
"6442125", "Paraparaumu",
"6479025", "Huntly",
"6479007", "Whakatane",
"643239", "Invercargill",
"6498690", "Kawakawa",
"6434279", "Twizel",
"6437774", "Queenstown",
"6439536", "Waimate",
"6472226", "Te\ Kuiti",
"6479714", "Huntly",
"6436617", "Cromwell",
"6478074", "Taumarunui",
"6437484", "Riverton",
"6436563", "Lawrence",
"6437453", "Amberley",
"6435673", "Lawrence",
"6468883", "Palmerston\ North",
"6439522", "Dunedin",
"6474652", "Paeroa",
"6424", "Scott\ Base",
"6439281", "Christchurch",
"646949", "Levin\ W100",
"6436523", "Hokitika",
"6469613", "Levin",
"6432420", "Christchurch",
"6472141", "Te\ Kuiti",
"646363", "Levin",
"6434297", "Westport",
"6436656", "Hokitika",
"6439882", "Westport",
"643520", "Blenheim",
"643521", "Nelson",
"6436625", "Rangiora",
"644464", "Wellington",
"649439", "Dargaville",
"6436631", "Motueka",
"6468302", "Napier",
"646306", "Featherston",
"649820", "Auckland",
"646862", "Gisborne",
"644819", "Wellington",
"6469891", "Gisborne",
"6434281", "Queenstown",
"6439313", "Te\ Anau",
"646951", "Palmerston\ North",
"6469275", "Wanganui",
"6439297", "Takaka",
"6474649", "Matamata",
"6497772", "Kaitaia",
"649813", "Auckland",
"6469292", "Ruatoria",
"6499068", "Pukekohe",
"6439868", "Blenheim",
"643666", "Christchurch",
"649884", "Auckland",
"6472817", "Taupo",
"6472807", "Te\ Awamutu",
"6463999", "Palmerston\ North",
"6462153", "New\ Plymouth",
"6473332", "Rotorua",
"644805", "Wellington",
"647541", "Tauranga",
"6436549", "Mt\ Cook",
"64354", "Nelson",
"6493942", "Great\ Barrier\ Island",
"643965", "Christchurch",
"6462162", "Masterton",
"6472220", "Tauranga",
"6479108", "Whakatane",
"6432888", "Nelson",
"6495539", "Auckland",
"6439530", "Timaru",
"6462122", "Palmerston\ North",
"643590", "Christchurch",
"6496100", "Pukekohe",
"6434997", "Lawrence",
"6494705", "Whangarei",
"6439019", "Roxburgh",
"6499819", "Helensville",
"6478078", "Whangamata",
"6439009", "Greymouth",
"6478996", "Huntly",
"6448880", "Paraparaumu",
"6499727", "Whangarei",
"643465", "Palmerston",
"6499466", "Kaikohe",
"6499455", "Dargaville",
"6435689", "Otautau",
"6499064", "Helensville",
"6439864", "Takaka",
"649890", "Auckland",
"6493937", "Warkworth",
"6499426", "Auckland",
"6466993", "Waiouru",
"646759", "New\ Plymouth",
"6466010", "Taihape",
"6432746", "Alexandra",
"6462805", "Napier\/Hastings",
"6466000", "Napier",
"6462815", "Wairoa",
"643211", "Invercargill",
"6432221", "Nelson",
"6466557", "Stratford",
"647988", "Rotorua",
"6445950", "Wellington",
"6432447", "Timaru",
"6435696", "Haast",
"6462411", "New\ Plymouth",
"6444889", "Paraparaumu",
"6437462", "Geraldine",
"643234", "Riverton",
"6478592", "Hamilton",
"6474638", "Opotiki",
"643692", "Geraldine",
"6432661", "Christchurch",
"6439452", "Gore",
"643696", "Geraldine",
"6432621", "Oamaru",
"6475602", "Hamilton",
"6475612", "Te\ Kuiti",
"6439702", "Nelson",
"6439712", "Fairlie",
"6492807", "Helensville",
"6439266", "Dunedin",
"647884", "Morrinsville",
"6469014", "Dannevirke",
"6469004", "Napier\/Hastings",
"6468820", "Palmerston\ North",
"6477772", "Rotorua",
"6439741", "Christchurch",
"6432714", "Cheviot",
"6436580", "Invercargill",
"643425", "Dunedin",
"6442128", "Paraparaumu",
"649282", "Auckland",
"646976", "Napier",
"647857", "Hamilton",
"6433945", "Cheviot",
"643206", "Edendale",
"6433998", "Lumsden",
"644494", "Wellington",
"6477886", "Rotorua",
"647312", "Whakatane",
"6469869", "Ruatoria",
"6432635", "Riverton",
"6434266", "Palmerston",
"644250", "Wellington",
"6432999", "Invercargill",
"6472620", "Tauranga",
"6473841", "Taupo",
"6492831", "Maungaturoto",
"6478135", "Te\ Kuiti",
"64952", "Auckland",
"6463921", "Palmerston\ North",
"6434226", "Lumsden",
"643762", "Greymouth",
"643925", "Christchurch",
"6432718", "Rangiora",
"649956", "Auckland",
"644924", "Wellington",
"6479851", "Waihi",
"649952", "Auckland",
"6469008", "Palmerston\ North",
"6449122", "Wellington",
"6435996", "Akaroa",
"6479715", "Paeroa",
"644297", "Paraparaumu",
"646278", "Hawera",
"6472193", "Whakatane",
"6436577", "Cromwell",
"6466548", "Ruatoria",
"6469573", "Palmerston\ North",
"649988", "Whangarei",
"6437775", "Wanaka",
"6465622", "Stratford",
"6435667", "Waitangi\ \(Chatham\ Is\.\)",
"6433910", "Nelson",
"6435503", "Christchurch",
"6435513", "Waitangi\ \(Chatham\ Is\.\)",
"64347", "Dunedin",
"6492220", "Auckland",
"646967", "New\ Plymouth",
"6462610", "Napier",
"6462600", "Palmerston\ North",
"649452", "Auckland",
"646323", "Palmerston\ North",
"6479249", "Huntly",
"6499556", "Maungaturoto",
"6439085", "Waitangi\ \(Chatham\ Is\.\)",
"649630", "Auckland",
"6469203", "New\ Plymouth",
"649631", "Auckland",
"6433994", "Winton",
"6468256", "Palmerston\ North",
"6439850", "Ashburton",
"643437", "Oamaru",
"6467557", "New\ Plymouth",
"647970", "Hamilton",
"6437470", "Balclutha",
"6439459", "Tokanui",
"6478080", "Hamilton",
"649817", "Auckland",
"6478451", "Hamilton",
"6435881", "Dunedin",
"6475609", "Paeroa",
"6434298", "Hokitika",
"6475619", "Hamilton",
"6434245", "Culverden",
"643924", "Christchurch",
"6478599", "Hamilton",
"6435650", "Greymouth",
"6479750", "Tauranga",
"6477779", "Putaruru\/Tokoroa",
"64447", "Wellington",
"647218", "Tauranga",
"643980", "Christchurch",
"6434401", "Cromwell",
"6443709", "Paraparaumu",
"6434994", "Palmerston",
"643981", "Christchurch",
"6436618", "Blenheim",
"643337", "Christchurch",
"643308", "Ashburton\/Akaroa\/Chatham\ Islands",
"6439709", "Motueka",
"6439719", "Waimate",
"6435561", "Dunedin",
"6439736", "Riverton",
"6433955", "Mt\ Cook",
"644495", "Wellington",
"647885", "Putaruru\/Tokoroa",
"647345", "Rotorua",
"6493934", "Kaitaia",
"646367", "Levin",
"6439298", "Motueka",
"6472808", "Putaruru\/Tokoroa",
"6472818", "Rotorua",
"6473923", "Otorohanga",
"6435535", "Invercargill",
"6499067", "Pukekohe",
"6439751", "Culverden",
"646838", "Wairoa",
"6462626", "Mokau",
"6432444", "Nelson",
"64497", "Wellington",
"643235", "Invercargill",
"643481", "Dunedin",
"649401", "Kaikohe",
"649400", "Kaikohe",
"644437", "Wellington",
"6499015", "Dargaville",
"6432992", "Gore",
"644777", "Wellington",
"6499005", "Auckland",
"64337", "Christchurch",
"6498881", "Hibiscus\ Coast",
"6466554", "Hawera",
"6432613", "Waitangi\ \(Chatham\ Is\.\)",
"643249", "Te\ Anau",
"6496991", "Kaikohe",
"6496016", "Warkworth",
"6434998", "Dunedin",
"6436614", "Timaru",
"6437487", "Winton",
"6478077", "Waihi",
"6499040", "Helensville",
"6468246", "Hawera",
"6475482", "Tauranga",
"6468816", "Hawera",
"6496510", "Whangarei",
"6468806", "New\ Plymouth",
"643789", "Westport",
"6449741", "Paraparaumu",
"6466579", "Featherston",
"6434294", "Franz\ Josef",
"6469853", "Wairoa",
"6479107", "Whakatane",
"6432887", "Nelson",
"6474445", "Hamilton",
"6473949", "Taupo",
"646376", "Pahiatua",
"6466558", "Opunake",
"6479242", "Rotorua",
"646372", "Masterton",
"6499876", "Kaikohe",
"6432448", "Dunedin",
"644202", "Wellington",
"6479841", "Huntly",
"6468690", "Gisborne",
"6472804", "Whangamata",
"6472814", "Putaruru\/Tokoroa",
"6499728", "Dargaville",
"6463903", "Ruatoria",
"6463913", "Hawera",
"6493938", "Auckland",
"6472616", "Taumarunui",
"6439294", "Dunedin",
"6472606", "Huntly",
"643250", "Christchurch",
"6439529", "Palmerston",
"6474659", "Whangamata",
"6433981", "Twizel",
"6492808", "Great\ Barrier\ Island",
"6479027", "Paeroa",
"6495560", "Whangarei",
"6442127", "Paraparaumu",
"6473934", "Rotorua",
"646768", "New\ Plymouth",
"6499733", "Warkworth",
"6435664", "Timaru",
"647853", "Hamilton",
"6472119", "Thames",
"6469310", "Wanganui",
"6469300", "Gisborne",
"6479005", "Tauranga",
"6474637", "Opotiki",
"64948", "Auckland",
"644590", "Wellington",
"643978", "Christchurch",
"6436646", "Roxburgh",
"6498855", "Kawakawa",
"644465", "Wellington",
"6468309", "Napier",
"6466520", "Palmerston\ North",
"6498826", "Warkworth",
"6469286", "Dannevirke",
"6475823", "Hamilton",
"6437443", "Nelson",
"6469299", "Napier\/Hastings",
"643738", "Greymouth",
"647848", "Hamilton",
"6463992", "Levin",
"6462423", "Gisborne",
"6467554", "New\ Plymouth",
"644210", "Wellington",
"6435950", "Christchurch",
"649218", "Auckland",
"644211", "Wellington",
"6497779", "Great\ Barrier\ Island",
"6433997", "Gore",
"6436501", "Akaroa",
"649912", "Auckland",
"6432756", "Gore",
"6495532", "Warkworth",
"6439335", "Haast",
"6436578", "Wanaka",
"6468990", "Ruatoria",
"6469025", "Mokau",
"6462129", "Waiouru",
"6432725", "Hokitika",
"649916", "Auckland",
"6473339", "Taupo",
"6462169", "Featherston",
"643433", "Oamaru",
"6435668", "Kurow",
"646349", "Wanganui",
"6469714", "Hawera",
"643464", "Dunedin",
"64925", "Auckland",
"6462226", "Napier",
"6439012", "Queenstown",
"6439002", "Rangiora",
"6432717", "Kaikoura",
"6436990", "Cheviot",
"643689", "Waimate",
"646327", "Marton",
"6442420", "Wellington",
"6469007", "Masterton",
"6469017", "Marton",
"6479040", "Otorohanga",
"644293", "Paraparaumu",
"6467558", "New\ Plymouth",
"6435682", "Riverton",
"643964", "Christchurch",
"6432731", "Timaru",
"644666", "Wellington",
"644804", "Wellington",
"6437469", "Alexandra",
"649299", "Auckland",
"6439873", "Wanaka",
"6439321", "Amberley",};

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+64|\D)//g;
      my $self = bless({ number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:0)//;
      $self = bless({ number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;