# automatically generated file, don't edit



# Copyright 2011 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::JE;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20201204215956;

my $formatters = [
                {
                  'format' => '$1 $2',
                  'leading_digits' => '8001111',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '845464',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{2})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '800',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{6})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            1(?:
              3873|
              5(?:
                242|
                39[4-6]
              )|
              (?:
                697|
                768
              )[347]|
              9467
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{5})(\\d{4,5})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            1(?:
              [2-69][02-9]|
              [78]
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{5,6})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            [25]|
            7(?:
              0|
              6(?:
                [03-9]|
                2[356]
              )
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '7',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{6})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '[1389]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{4})'
                }
              ];

my $validators = {
                'fixed_line' => '1534[0-24-8]\\d{5}',
                'geographic' => '1534[0-24-8]\\d{5}',
                'mobile' => '
          7(?:
            (?:
              (?:
                50|
                82
              )9|
              937
            )\\d|
            7(?:
              00[378]|
              97[7-9]
            )
          )\\d{5}
        ',
                'pager' => '
          76(?:
            464|
            652
          )\\d{5}|
          76(?:
            0[0-2]|
            2[356]|
            34|
            4[01347]|
            5[49]|
            6[0-369]|
            77|
            81|
            9[139]
          )\\d{6}
        ',
                'personal_number' => '701511\\d{4}',
                'specialrate' => '(
          (?:
            8(?:
              4(?:
                4(?:
                  4(?:
                    05|
                    42|
                    69
                  )|
                  703
                )|
                5(?:
                  041|
                  800
                )
              )|
              7(?:
                0002|
                1206
              )
            )|
            90(?:
              066[59]|
              1810|
              71(?:
                07|
                55
              )
            )
          )\\d{4}
        )|(
          (?:
            3(?:
              0(?:
                07(?:
                  35|
                  81
                )|
                8901
              )|
              3\\d{4}|
              4(?:
                4(?:
                  4(?:
                    05|
                    42|
                    69
                  )|
                  703
                )|
                5(?:
                  041|
                  800
                )
              )|
              7(?:
                0002|
                1206
              )
            )|
            55\\d{4}
          )\\d{4}
        )',
                'toll_free' => '
          80(?:
            07(?:
              35|
              81
            )|
            8901
          )\\d{4}
        ',
                'voip' => '56\\d{8}'
              };
my %areanames = ();
$areanames{en} = {"441366", "Downham\ Market",
"441862", "Tain",
"441340", "Craigellachie\ \(Aberlour\)",
"441322", "Dartford",
"441566", "Launceston",
"441625", "Macclesfield",
"4418519", "Great\ Bernera",
"441540", "Kingussie",
"441522", "Lincoln",
"441669", "Rothbury",
"441377", "Driffield",
"441503", "Looe",
"441577", "Kinross",
"441303", "Folkestone",
"4412296", "Barrow\-in\-Furness",
"441770", "Isle\ of\ Arran",
"441270", "Crewe",
"441490", "Corwen",
"441429", "Hartlepool",
"4414308", "Market\ Weighton",
"4414301", "North\ Cave\/Market\ Weighton",
"441747", "Shaftesbury",
"441683", "Moffat",
"4416867", "Llanidloes",
"44147986", "Cairngorm",
"441465", "Girvan",
"441584", "Ludlow",
"4416861", "Newtown\/Llanidloes",
"441384", "Dudley",
"4414307", "Market\ Weighton",
"441789", "Stratford\-upon\-Avon",
"441939", "Wem",
"441289", "Berwick\-upon\-Tweed",
"4414344", "Bellingham",
"441994", "St\ Clears",
"4416868", "Newtown",
"441841", "Newquay\ \(Padstow\)",
"441604", "Northampton",
"441953", "Wymondham",
"441972", "Glenborrodale",
"441206", "Colchester",
"4419642", "Hornsea",
"441706", "Rochdale",
"442841", "Rostrevor",
"44147981", "Aviemore",
"441763", "Royston",
"441691", "Oswestry",
"441263", "Cromer",
"441628", "Maidenhead",
"441529", "Sleaford",
"441590", "Lymington",
"442825", "Ballymena",
"4412291", "Barrow\-in\-Furness\/Millom",
"441208", "Bodmin",
"441329", "Fareham",
"441869", "Bicester",
"441708", "Romford",
"4412298", "Barrow\-in\-Furness",
"441724", "Scunthorpe",
"441825", "Uckfield",
"441224", "Aberdeen",
"441451", "Stow\-on\-the\-Wold",
"441980", "Amesbury",
"4414306", "Market\ Weighton",
"441565", "Knutsford",
"441626", "Newton\ Abbot",
"4417687", "Keswick",
"441730", "Petersfield",
"441422", "Halifax",
"441440", "Haverhill",
"441883", "Caterham",
"441466", "Huntly",
"441337", "Ladybank",
"441403", "Horsham",
"4418909", "Ayton",
"441297", "Axminster",
"441212", "Birmingham",
"441477", "Holmes\ Chapel",
"441797", "Rye",
"4419759", "Alford\ \(Aberdeen\)",
"441650", "Cemmaes\ Road",
"441944", "West\ Heslerton",
"441282", "Burnley",
"441932", "Weybridge",
"441782", "Stoke\-on\-Trent",
"441828", "Coupar\ Angus",
"441368", "Dunbar",
"441484", "Huddersfield",
"4415072", "Spilsby\ \(Horncastle\)",
"441568", "Leominster",
"4416866", "Newtown",
"442828", "Larne",
"4412297", "Millom",
"441910", "Tyneside\/Durham\/Sunderland",
"441205", "Boston",
"441641", "Strathy",
"442891", "Bangor\ \(Co\.\ Down\)",
"4414238", "Harrogate",
"44113", "Leeds",
"4414231", "Harrogate\/Boroughbridge",
"441786", "Stirling",
"441286", "Caernarfon",
"441684", "Malvern",
"441528", "Laggan",
"441209", "Redruth",
"441328", "Fakenham",
"441591", "Llanwrtyd\ Wells",
"441709", "Rotherham",
"44239", "Portsmouth",
"441981", "Wormbridge",
"441450", "Hawick",
"441304", "Dover",
"4413390", "Aboyne\/Ballater",
"442868", "Kesh",
"441829", "Tarporley",
"44291", "Cardiff",
"441369", "Dunoon",
"441677", "Bedale",
"441978", "Wrexham",
"441569", "Stonehaven",
"441954", "Madingley",
"441603", "Norwich",
"441911", "Tyneside\/Durham\/Sunderland",
"441666", "Malmesbury",
"441525", "Leighton\ Buzzard",
"4418476", "Tongue",
"442829", "Kilrea",
"442890", "Belfast",
"441622", "Maidstone",
"441865", "Oxford",
"441764", "Crieff",
"441325", "Darlington",
"441264", "Andover",
"441383", "Dunfermline",
"441462", "Hitchin",
"441837", "Okehampton",
"441651", "Oldmeldrum",
"4415074", "Alford\ \(Lincs\)",
"441583", "Carradale",
"4414237", "Harrogate",
"441993", "Witney",
"442837", "Armagh",
"441216", "Birmingham",
"441884", "Tiverton",
"441935", "Yeovil",
"441785", "Stafford",
"4418477", "Tongue",
"441285", "Cirencester",
"441428", "Haslemere",
"441771", "Maud",
"441491", "Henley\-on\-Thames",
"441271", "Barnstaple",
"441550", "Llandovery",
"441404", "Honiton",
"441350", "Dunkeld",
"441702", "Southend\-on\-Sea",
"441202", "Bournemouth",
"441757", "Selby",
"441341", "Barmouth",
"441257", "Coppull",
"441668", "Bamburgh",
"44117", "Bristol",
"4414236", "Harrogate",
"441723", "Scarborough",
"441967", "Strontian",
"441223", "Cambridge",
"441665", "Alnwick",
"441526", "Martin",
"4415395", "Grange\-over\-Sands",
"441562", "Kidderminster",
"442877", "Limavady",
"441326", "Falmouth",
"4413395", "Aboyne",
"441866", "Kilchrenan",
"441362", "Dereham",
"441483", "Guildford",
"441840", "Camelford",
"441822", "Tavistock",
"4414342", "Bellingham",
"441803", "Torquay",
"441629", "Matlock",
"442840", "Banbridge",
"441690", "Betws\-y\-Coed",
"441877", "Callander",
"442866", "Enniskillen",
"4418478", "Thurso",
"441900", "Workington",
"4413393", "Aboyne",
"441215", "Birmingham",
"4419644", "Patrington",
"441469", "Killingholme",
"441788", "Rugby",
"4414379", "Haverfordwest",
"441938", "Welshpool",
"4413881", "Bishop\ Auckland\/Stanhope\ \(Eastgate\)",
"441425", "Ringwood",
"441288", "Bude",
"4419467", "Gosforth",
"4418471", "Thurso\/Tongue",
"441943", "Guiseley",
"441637", "Newquay",
"441630", "Market\ Drayton",
"441726", "St\ Austell",
"441262", "Bridlington",
"441226", "Barnsley",
"441624", "Isle\ of\ Man",
"4414309", "Market\ Weighton",
"441952", "Telford",
"441608", "Chipping\ Norton",
"441870", "Isle\ of\ Benbecula",
"4418906", "Ayton",
"441697", "Brampton",
"4418518", "Stornoway",
"4418511", "Great\ Bernera\/Stornoway",
"44292", "Cardiff",
"441588", "Bishops\ Castle",
"442870", "Coleraine",
"441388", "Bishop\ Auckland",
"441464", "Insch",
"441371", "Great\ Dunmow",
"442889", "Fivemiletown",
"4414340", "Bellingham\/Haltwhistle\/Hexham",
"441946", "Whitehaven",
"441409", "Holsworthy",
"441571", "Lochinver",
"4418517", "Stornoway",
"441250", "Blairgowrie",
"441889", "Rugeley",
"441750", "Selkirk",
"441431", "Helmsdale",
"44114", "Sheffield",
"441995", "Garstang",
"4419756", "Strathdon",
"441357", "Strathaven",
"441502", "Lowestoft",
"441241", "Arbroath",
"441557", "Kirkcudbright",
"441302", "Doncaster",
"441806", "Shetland",
"44147983", "Boat\ of\ Garten",
"441323", "Eastbourne",
"441863", "Ardgay",
"4416869", "Newtown",
"441769", "South\ Molton",
"4419757", "Strathdon",
"4418901", "Coldstream\/Ayton",
"441269", "Ammanford",
"442830", "Newry",
"441808", "Tomatin",
"441725", "Rockbourne",
"441364", "Ashburton",
"441824", "Ruthin",
"4418908", "Coldstream",
"441488", "Hungerford",
"441225", "Bath",
"4414343", "Haltwhistle",
"441830", "Kirkwhelpington",
"4418516", "Great\ Bernera",
"441564", "Lapworth",
"441959", "Westerham",
"441948", "Whitchurch",
"4413392", "Aboyne",
"442897", "Saintfield",
"441933", "Wellingborough",
"441647", "Moretonhampstead",
"441283", "Burton\-on\-Trent",
"4412299", "Millom",
"4414345", "Haltwhistle",
"441670", "Morpeth",
"442882", "Omagh",
"441689", "Orpington",
"441213", "Birmingham",
"441457", "Glossop",
"4413873", "Langholm",
"441586", "Campbeltown",
"441945", "Wisbech",
"441386", "Evesham",
"441882", "Kinloch\ Rannoch",
"441728", "Saxmundham",
"441485", "Hunstanton",
"441309", "Forres",
"441228", "Carlisle",
"441663", "New\ Mills",
"4419758", "Strathdon",
"441291", "Chepstow",
"441471", "Isle\ of\ Skye\ \-\ Broadford",
"441509", "Loughborough",
"441531", "Ledbury",
"4418907", "Ayton",
"4419751", "Alford\ \(Aberdeen\)\/Strathdon",
"441606", "Northwich",
"441204", "Bolton",
"441805", "Torrington",
"44247", "Coventry",
"441704", "Southport",
"442886", "Cookstown",
"441917", "Sunderland",
"441992", "Lea\ Valley",
"441949", "Whatton",
"4419645", "Hornsea",
"441406", "Holbeach",
"441886", "Bromyard\ \(Knightwick\/Leigh\ Sinton\)",
"441671", "Newton\ Stewart",
"441463", "Inverness",
"441382", "Dundee",
"441685", "Merthyr\ Tydfil",
"441582", "Luton",
"441623", "Mansfield",
"4415394", "Hawkshead",
"4419643", "Patrington",
"441768", "Penrith",
"4413394", "Ballater",
"4414239", "Boroughbridge",
"441268", "Basildon",
"441809", "Tomdoun",
"441305", "Dorchester",
"441489", "Bishops\ Waltham",
"441974", "Llanon",
"441505", "Johnstone",
"441790", "Spilsby",
"441729", "Settle",
"441470", "Isle\ of\ Skye\ \-\ Edinbane",
"441290", "Cumnock",
"441308", "Bridport",
"441508", "Brooke",
"441955", "Wick",
"441330", "Banchory",
"441524", "Lancaster",
"441864", "Abington\ \(Crawford\)",
"441530", "Coalville",
"441324", "Falkirk",
"441765", "Ripon",
"441237", "Bideford",
"441737", "Redhill",
"441987", "Ebbsfleet",
"4414376", "Haverfordwest",
"441688", "Isle\ of\ Mull\ \-\ Tobermory",
"441397", "Fort\ William",
"4415070", "Louth\/Alford\ \(Lincs\)\/Spilsby\ \(Horncastle\)",
"441597", "Llandrindod\ Wells",
"441934", "Weston\-super\-Mare",
"441885", "Pencombe",
"441784", "Staines",
"441284", "Bury\ St\ Edmunds",
"441942", "Wigan",
"4415075", "Spilsby\ \(Horncastle\)",
"441871", "Castlebay",
"441920", "Ware",
"442885", "Ballygawley",
"441405", "Goole",
"441389", "Dumbarton",
"442871", "Londonderry",
"4415073", "Louth",
"441306", "Dorking",
"441631", "Oban",
"441857", "Sanday",
"441506", "Bathgate",
"4414377", "Haverfordwest",
"441563", "Kilmarnock",
"441609", "Northallerton",
"441823", "Taunton",
"441363", "Crediton",
"441482", "Kingston\-upon\-Hull",
"441664", "Melton\ Mowbray",
"4418479", "Tongue",
"44115", "Nottingham",
"441766", "Porthmadog",
"441722", "Salisbury",
"441740", "Sedgefield",
"4414371", "Haverfordwest\/Clynderwen\ \(Clunderwen\)",
"4414378", "Haverfordwest",
"441497", "Hay\-on\-Wye",
"441277", "Brentwood",
"441777", "Retford",
"441570", "Lampeter",
"441214", "Birmingham",
"441408", "Golspie",
"441547", "Knighton",
"441888", "Turriff",
"441424", "Hastings",
"4419640", "Hornsea\/Patrington",
"441347", "Easingwold",
"441751", "Pickering",
"441407", "Holyhead",
"441661", "Prudhoe",
"441793", "Swindon",
"441916", "Tyneside",
"442887", "Dungannon",
"441452", "Gloucester",
"441293", "Crawley",
"441473", "Ipswich",
"441348", "Fishguard",
"441333", "Peat\ Inn\ \(Leven\ \(Fife\)\)",
"441887", "Aberfeldy",
"441548", "Kingsbridge",
"441559", "Llandysul",
"4414300", "North\ Cave\/Market\ Weighton",
"441359", "Pakenham",
"441211", "Birmingham",
"4417683", "Appleby",
"441254", "Blackburn",
"441778", "Bourne",
"441754", "Skegness",
"441278", "Bridgwater",
"4418514", "Great\ Bernera",
"441855", "Ballachulish",
"441656", "Bridgend",
"4412293", "Millom",
"441775", "Spalding",
"441874", "Brecon",
"441495", "Pontypool",
"441858", "Market\ Harborough",
"441275", "Clevedon",
"441931", "Shap",
"4414372", "Clynderwen\ \(Clunderwen\)",
"4416860", "Newtown\/Llanidloes",
"441909", "Worksop",
"441446", "Barry",
"441460", "Chard",
"441634", "Medway",
"441736", "Penzance",
"441642", "Middlesbrough",
"441620", "North\ Berwick",
"441986", "Bungay",
"442892", "Lisburn",
"441236", "Coatbridge",
"441545", "Llanarth",
"4414349", "Bellingham",
"4412295", "Barrow\-in\-Furness",
"44118", "Reading",
"441892", "Tunbridge\ Wells",
"441243", "Chichester",
"441743", "Shrewsbury",
"441687", "Mallaig",
"441738", "Perth",
"4418904", "Coldstream",
"441988", "Wigtown",
"4416863", "Llanidloes",
"4420", "London",
"441598", "Lynton",
"441398", "Dulverton",
"441915", "Sunderland",
"441200", "Clitheroe",
"4412290", "Barrow\-in\-Furness\/Millom",
"441700", "Rothesay",
"441373", "Frome",
"4416865", "Newtown",
"441352", "Mold",
"441856", "Orkney",
"441573", "Kelso",
"441307", "Forfar",
"441655", "Maybole",
"441433", "Hathersage",
"441923", "Watford",
"441267", "Carmarthen",
"441767", "Sandy",
"441445", "Gairloch",
"441957", "Mid\ Yell",
"441776", "Stranraer",
"441276", "Camberley",
"441496", "Port\ Ellen",
"4414305", "North\ Cave",
"441902", "Wolverhampton",
"441674", "Montrose",
"441595", "Lerwick\,\ Foula\ \&\ Fair\ Isle",
"442842", "Kircubbin",
"441692", "North\ Walsham",
"442820", "Ballycastle",
"441918", "Tyneside",
"441395", "Budleigh\ Salterton",
"441842", "Thetford",
"441899", "Biggar",
"441360", "Killearn",
"4419754", "Alford\ \(Aberdeen\)",
"441971", "Scourie",
"441346", "Fraserburgh",
"4414303", "North\ Cave",
"441985", "Warminster",
"441834", "Narberth",
"441560", "Moscow",
"441546", "Lochgilphead",
"441235", "Abingdon",
"4414230", "Harrogate\/Boroughbridge",
"4418902", "Coldstream",
"441963", "Wincanton",
"441227", "Canterbury",
"441727", "St\ Albans",
"4413885", "Stanhope\ \(Eastgate\)",
"441492", "Colwyn\ Bay",
"441449", "Stowmarket",
"441253", "Blackpool",
"4418475", "Thurso",
"441772", "Preston",
"441753", "Slough",
"441794", "Romsey",
"4416973", "Wigton",
"441458", "Glastonbury",
"441895", "Uxbridge",
"441474", "Gravesend",
"441294", "Ardrossan",
"441989", "Ross\-on\-Wye",
"441239", "Cardigan",
"4413391", "Aboyne\/Ballater",
"441599", "Kyle",
"441542", "Keith",
"441334", "St\ Andrews",
"441520", "Lochcarron",
"4418473", "Thurso",
"4413398", "Aboyne",
"442895", "Belfast",
"441342", "East\ Grinstead",
"441534", "Jersey",
"441320", "Fort\ Augustus",
"442898", "Belfast",
"441947", "Whitby",
"441919", "Durham",
"441633", "Newport",
"442821", "Martinstown",
"4415079", "Alford\ \(Lincs\)",
"441561", "Laurencekirk",
"441455", "Hinckley",
"4413397", "Ballater",
"441361", "Duns",
"441821", "Kinrossie",
"441970", "Aberystwyth",
"441807", "Ballindalloch",
"441556", "Castle\ Douglas",
"441873", "Abergavenny",
"441852", "Kilmelford",
"441356", "Brechin",
"4419752", "Alford\ \(Aberdeen\)",
"441487", "Warboys",
"441659", "Sanquhar",
"441558", "Llandeilo",
"4413396", "Ballater",
"441905", "Worcester",
"441210", "Birmingham",
"441358", "Ellon",
"4415396", "Sedbergh",
"441779", "Peterhead",
"441420", "Alton",
"441279", "Bishops\ Stortford",
"441442", "Hemel\ Hempstead",
"441499", "Inveraray",
"442896", "Belfast",
"441982", "Builth\ Wells",
"441646", "Milford\ Haven",
"441732", "Sevenoaks",
"441244", "Chester",
"441845", "Thirsk",
"441744", "St\ Helens",
"441896", "Galashiels",
"4418512", "Stornoway",
"441392", "Exeter",
"441349", "Dingwall",
"441695", "Skelmersdale",
"441592", "Kirkcaldy",
"441549", "Lairg",
"441456", "Glenurquhart",
"441621", "Maldon",
"441997", "Strathpeffer",
"441912", "Tyneside",
"4414374", "Clynderwen\ \(Clunderwen\)",
"441698", "Motherwell",
"4419649", "Hornsea",
"441833", "Barnard\ Castle",
"441387", "Dumfries",
"4414233", "Boroughbridge",
"441848", "Thornhill",
"4413880", "Bishop\ Auckland\/Stanhope\ \(Eastgate\)",
"441780", "Stamford",
"441859", "Harris",
"441280", "Buckingham",
"4418470", "Thurso\/Tongue",
"441924", "Wakefield",
"441673", "Market\ Rasen",
"441652", "Brigg",
"4414235", "Harrogate",
"441908", "Milton\ Keynes",
"441555", "Lanark",
"441461", "Gretna",
"441355", "East\ Kilbride",
"441600", "Monmouth",
"441638", "Newmarket",
"4419755", "Alford\ \(Aberdeen\)",
"441287", "Guisborough",
"441787", "Sudbury",
"442893", "Ballyclare",
"441937", "Wetherby",
"441643", "Minehead",
"441580", "Cranbrook",
"4418510", "Great\ Bernera\/Stornoway",
"441380", "Devizes",
"4414347", "Hexham",
"441255", "Clacton\-on\-Sea",
"441878", "Lochboisdale",
"4414304", "North\ Cave",
"441854", "Ullapool",
"441929", "Wareham",
"44281", "Northern\ Ireland",
"4419753", "Strathdon",
"441875", "Tranent",
"4416864", "Llanidloes",
"441258", "Blandford",
"441274", "Bradford",
"4418903", "Coldstream",
"441494", "High\ Wycombe",
"441758", "Pwllheli",
"4414348", "Hexham",
"441676", "Meriden",
"441439", "Helmsley",
"4412180", "Birmingham",
"4414341", "Bellingham\/Haltwhistle\/Hexham",
"441579", "Liskeard",
"441968", "Penicuik",
"441379", "Diss",
"442310", "Portsmouth",
"442881", "Newtownstewart",
"441667", "Nairn",
"441635", "Newbury",
"441344", "Bracknell",
"441427", "Gainsborough",
"4418905", "Ayton",
"441332", "Derby",
"441544", "Kington",
"4413882", "Stanhope\ \(Eastgate\)",
"441249", "Chippenham",
"441292", "Ayr",
"441217", "Birmingham",
"441472", "Grimsby",
"4418472", "Thurso",
"441453", "Dursley",
"441792", "Swansea",
"441749", "Shepton\ Mallet",
"441843", "Thanet",
"441480", "Huntingdon",
"441951", "Colonsay",
"441838", "Dalmally",
"4412294", "Barrow\-in\-Furness",
"442843", "Newcastle\ \(Co\.\ Down\)",
"441761", "Temple\ Cloud",
"4414232", "Harrogate",
"441261", "Banff",
"441914", "Tyneside",
"4418900", "Coldstream\/Ayton",
"442838", "Portadown",
"441256", "Basingstoke",
"441977", "Pontefract",
"441756", "Skipton",
"441678", "Bala",
"44116", "Leicester",
"441654", "Machynlleth",
"441903", "Worthing",
"441922", "Walsall",
"44161", "Manchester",
"441432", "Hereford",
"441327", "Daventry",
"441444", "Haywards\ Heath",
"441527", "Redditch",
"441681", "Isle\ of\ Mull\ \-\ Fionnphort",
"441876", "Lochmaddy",
"442867", "Lisnaskea",
"441353", "Ely",
"4418515", "Stornoway",
"441372", "Esher",
"441675", "Coleshill",
"441553", "Kings\ Lynn",
"441572", "Oakham",
"4417684", "Pooley\ Bridge",
"4419750", "Alford\ \(Aberdeen\)\/Strathdon",
"441594", "Lydney",
"441394", "Felixstowe",
"441539", "Kendal",
"44147985", "Dulnain\ Bridge",
"441720", "Isles\ of\ Scilly",
"441636", "Newark\-on\-Trent",
"441799", "Saffron\ Walden",
"441501", "Harthill",
"441479", "Grantown\-on\-Spey",
"441299", "Bewdley",
"441242", "Cheltenham",
"441984", "Watchet\ \(Williton\)",
"441835", "St\ Boswells",
"4414346", "Hexham",
"4418513", "Stornoway",
"441301", "Arrochar",
"441234", "Bedford",
"441567", "Killin",
"4414373", "Clynderwen\ \(Clunderwen\)",
"441436", "Helensburgh",
"441827", "Tamworth",
"4412292", "Barrow\-in\-Furness",
"441367", "Faringdon",
"4413399", "Ballater",
"441576", "Lockerbie",
"4415077", "Louth",
"4414234", "Boroughbridge",
"4415242", "Hornby",
"442827", "Ballymoney",
"441376", "Braintree",
"441872", "Truro",
"441795", "Sittingbourne",
"441295", "Banbury",
"441475", "Greenock",
"4414375", "Clynderwen\ \(Clunderwen\)",
"44147982", "Nethy\ Bridge",
"441481", "Guernsey",
"441950", "Sandwick",
"441335", "Ashbourne",
"441644", "New\ Galloway",
"442894", "Antrim",
"441246", "Chesterfield",
"441535", "Keighley",
"441760", "Swaffham",
"441746", "Bridgnorth",
"441260", "Congleton",
"441543", "Cannock",
"4419646", "Patrington",
"44141", "Glasgow",
"441538", "Ipstones",
"441343", "Elgin",
"441454", "Chipping\ Sodbury",
"441798", "Pulborough",
"441300", "Cerne\ Abbas",
"441478", "Isle\ of\ Skye\ \-\ Portree",
"441298", "Buxton",
"441721", "Peebles",
"44241", "Coventry",
"441707", "Welwyn\ Garden\ City",
"441207", "Consett",
"441752", "Plymouth",
"441773", "Ripley",
"441252", "Aldershot",
"4415071", "Louth\/Alford\ \(Lincs\)\/Spilsby\ \(Horncastle\)",
"441493", "Great\ Yarmouth",
"441273", "Brighton",
"4415078", "Alford\ \(Lincs\)",
"441926", "Warwick",
"441680", "Isle\ of\ Mull\ \-\ Craignure",
"441962", "Winchester",
"441381", "Fortrose",
"441575", "Kirriemuir",
"441904", "York",
"441653", "Malton",
"442879", "Magherafelt",
"441672", "Marlborough",
"441581", "New\ Luce",
"441375", "Grays\ Thurrock",
"4419647", "Patrington",
"441879", "Scarinish",
"44238", "Southampton",
"441928", "Runcorn",
"441435", "Heathfield",
"441467", "Inverurie",
"441832", "Clopton",
"441245", "Chelmsford",
"441536", "Kettering",
"441844", "Thame",
"441745", "Rhyl",
"441639", "Neath",
"441913", "Durham",
"441796", "Pitlochry",
"4414302", "North\ Cave",
"441476", "Grantham",
"441296", "Aylesbury",
"442844", "Downpatrick",
"441694", "Church\ Stretton",
"4416862", "Llanidloes",
"4415076", "Louth",
"441593", "Lybster",
"441733", "Peterborough",
"441983", "Isle\ of\ Wight",
"441233", "Ashford\ \(Kent\)",
"441248", "Bangor\ \(Gwynedd\)",
"4414370", "Haverfordwest\/Clynderwen\ \(Clunderwen\)",
"441748", "Richmond",
"441880", "Tarbert",
"441443", "Pontypridd",
"441259", "Alloa",
"44131", "Edinburgh",
"441759", "Pocklington",
"441925", "Warrington",
"441438", "Stevenage",
"4416974", "Raughton\ Head",
"44151", "Liverpool",
"4419641", "Hornsea\/Patrington",
"441578", "Lauder",
"441969", "Leyburn",
"442880", "Carrickmore",
"442311", "Southampton",
"441554", "Llanelli",
"4419648", "Hornsea",
"44147984", "Carrbridge",
"4418474", "Thurso",
"441400", "Honington",
"441354", "Chatteris",};

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+44|\D)//g;
      my $self = bless({ number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      my $prefix = qr/^(?:0|([0-24-8]\d{5})$)/;
      my @matches = $number =~ /$prefix/;
      if (defined $matches[-1]) {
        no warnings 'uninitialized';
        $number =~ s/$prefix/1534$1/;
      }
      else {
        $number =~ s/$prefix//;
      }
      $self = bless({ number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;