package Data::Password::zxcvbn::RankedDictionaries::English;
use strict;
use warnings;
# VERSION
# ABSTRACT: ranked dictionaries for common words

=head1 DESCRIPTION

This is a data file used by L<<
C<Data::Password::zxcvbn::Match::Dictionary> >>, and is generated by
the L<<
C<build-ranked-dictionaries>|https://bitbucket.org/broadbean/p5-data-password-zxcvbn/src/master/maint/build-ranked-dictionaries
>> program when building the distribution.


=cut

our %ranked_dictionaries = (
  english_female_names => {
                            abbey  => 1465, abbie  => 992, abby   => 672,
                            abigail
                                   => 506, ada    => 306,
                            adah   => 2927, adaline
                                   => 2729,
                            addie  => 499, adela  => 699, adelaida
                                   => 1360,
                            adelaide
                                   => 973, adele  => 510,
                            adelia => 1752, adelina
                                   => 1088,
                            adeline
                                   => 616, adell  => 1322,
                            adella => 1595, adelle => 1934, adena  => 3250, adina  => 1834, adria  => 1717,
                            adriana
                                   => 503, adriane
                                   => 1501,
                            adrianna
                                   => 1401, adrianne
                                   => 1016,
                            adrien => 3182, adriene
                                   => 2728,
                            adrienne
                                   => 387, afton  => 1924,
                            agatha => 1071, agnes  => 216, agnus  => 3622, agripina
                                   => 3021,
                            agueda => 3621, agustina
                                   => 1689,
                            aida   => 543, aide   => 2883, aiko   => 3249, aileen => 663, ailene => 2882,
                            aimee  => 489, aisha  => 880, akiko  => 2252, akilah => 3181, alaina => 1264,
                            alaine => 3698, alana  => 768, alane  => 3327, alanna => 1464, alayna => 3540,
                            alba   => 935, alberta
                                   => 328,
                            albertha
                                   => 1616, albertina
                                   => 2133,
                            albertine
                                   => 1933, albina => 1487,
                            alda   => 1353, alease => 2763, alecia => 1087, aleen  => 2926, aleida => 2425,
                            aleisha
                                   => 3395, alejandra
                                   => 770,
                            alejandrina
                                   => 1991, alena  => 1810,
                            alene  => 1098, alesha => 1500, aleshia
                                   => 2807,
                            alesia => 1453, alessandra
                                   => 3180,
                            aleta  => 1400, aletha => 1178, alethea
                                   => 1858,
                            alethia
                                   => 2200, alexa  => 1158,
                            alexandra
                                   => 389, alexandria
                                   => 723,
                            alexia => 1677, alexis => 446, alfreda
                                   => 875,
                            alfredia
                                   => 3394, alia   => 2074,
                            alica  => 2073, alice  => 51, alicia => 152, alida  => 1670, alina  => 1194,
                            aline  => 812, alisa  => 585, alise  => 2396, alisha => 488, alishia
                                   => 2688,
                            alisia => 2657, alison => 342, alissa => 832, alita  => 2844, alix   => 2513,
                            aliza  => 2727, alla   => 2474, alleen => 2881, allegra
                                   => 2339,
                            allena => 3467, allene => 1000, allie  => 740, alline => 2546, allison
                                   => 226,
                            allyn  => 3782, allyson
                                   => 751,
                            alma   => 195, almeda => 1643, almeta => 2587, alona  => 3781, alpha  => 1234,
                            alta   => 601, altagracia
                                   => 1399,
                            altha  => 2229, althea => 765, alvera => 2424, alverta
                                   => 3123,
                            alvina => 1105, alyce  => 841, alycia => 1572, alysa  => 3179, alyse  => 2369,
                            alysha => 2199, alysia => 1708, alyson => 937, alyssa => 439, amada  => 1751,
                            amal   => 3539, amalia => 867, amanda => 40, amber  => 139, amberly
                                   => 2762,
                            amee   => 3466, amelia => 327, amie   => 764, amiee  => 3465, amina  => 2032,
                            amira  => 3620, ammie  => 2450, amparo => 877, amy    => 32, ana    => 180,
                            anabel => 1452, analisa
                                   => 3326,
                            anamaria
                                   => 3065, anastacia
                                   => 1889,
                            anastasia
                                   => 869, andera => 3248,
                            andra  => 1342, andrea => 81, andree => 2228, andria => 1209, anette => 2132,
                            angela => 29, angele => 2618, angelena
                                   => 2726,
                            angelia
                                   => 639, angelic
                                   => 2368,
                            angelica
                                   => 385, angelika
                                   => 2227,
                            angelina
                                   => 407, angeline
                                   => 632,
                            angelique
                                   => 921, angelita
                                   => 901,
                            angella
                                   => 1792, angelyn
                                   => 3325,
                            angie  => 323, angila => 3780, angla  => 3324, angle  => 2367, anglea => 1766,
                            anika  => 1912, anisa  => 2969, anisha => 2925, anissa => 1313, anita  => 136,
                            anitra => 1669, anja   => 3393, anjanette
                                   => 2177,
                            anjelica
                                   => 3392, ann    => 48,
                            anna   => 33, annabel
                                   => 1688,
                            annabell
                                   => 2299, annabelle
                                   => 780,
                            annalee
                                   => 2545, annalisa
                                   => 2656,
                            annamae
                                   => 2423, annamaria
                                   => 2880,
                            annamarie
                                   => 1321, anne   => 85,
                            anneliese
                                   => 1857, annelle
                                   => 3779,
                            annemarie
                                   => 1167, annett => 2687,
                            annetta
                                   => 1134, annette
                                   => 175,
                            annice => 2512, annie  => 97, annika => 3464, annis  => 2298, annita => 3020,
                            annmarie
                                   => 904, antionette
                                   => 971,
                            antoinette
                                   => 356, antonetta
                                   => 3323,
                            antonette
                                   => 1238, antonia
                                   => 418,
                            antonietta
                                   => 2395, antonina
                                   => 1911,
                            anya   => 2005, apolonia
                                   => 2761,
                            april  => 142, apryl  => 2686, araceli
                                   => 845,
                            aracelis
                                   => 2685, aracely
                                   => 1555,
                            arcelia
                                   => 1875, ardath => 3391,
                            ardelia
                                   => 3778, ardell => 2655,
                            ardella
                                   => 2059, ardelle
                                   => 3463,
                            ardis  => 1499, ardith => 1498, aretha => 1187, argelia
                                   => 2843,
                            ariana => 1294, ariane => 2725, arianna
                                   => 2251,
                            arianne
                                   => 2806, arica  => 3178,
                            arie   => 2724, arielle
                                   => 1740,
                            arla   => 2366, arlean => 3390, arleen => 1021, arlena => 2449, arlene => 223,
                            arletha
                                   => 2842, arletta
                                   => 2276,
                            arlette
                                   => 1932, arlinda
                                   => 3064,
                            arline => 856, arlyne => 3538, armanda
                                   => 2723,
                            armandina
                                   => 2968, armida => 1509,
                            arminda
                                   => 2684, arnetta
                                   => 2106,
                            arnette
                                   => 3462, arnita => 2365,
                            artie  => 1508, arvilla
                                   => 2422,
                            asha   => 1791, ashanti
                                   => 2924,
                            ashely => 1687, ashlea => 3619, ashlee => 752, ashleigh
                                   => 996,
                            ashley => 63, ashli  => 2058, ashlie => 1615, ashly  => 1628, ashlyn => 2544,
                            ashton => 1554, asley  => 3618, assunta
                                   => 2654,
                            astrid => 1377, asuncion
                                   => 2250,
                            athena => 1076, audie  => 2394, audra  => 682, audrea => 2297, audrey => 173,
                            audria => 3777, audrie => 3776, audry  => 1580, augusta
                                   => 864,
                            augustina
                                   => 2296, aundrea
                                   => 2617,
                            aura   => 1228, aurea  => 1765, aurelia
                                   => 862,
                            aurora => 518, aurore => 2879, autumn => 641, ava    => 718, avelina
                                   => 2249,
                            avis   => 739, avril  => 3697, awilda => 1642, ayako  => 3177, ayana  => 2072,
                            ayanna => 2131, ayesha => 1856, azalee => 3389, azucena
                                   => 2616,
                            azzie  => 3247, babara => 2152, babette
                                   => 2130,
                            bambi  => 1437, barabara
                                   => 3696,
                            barb   => 1122, barbar => 2653, barbara
                                   => 4,
                            barbera
                                   => 2586, barbie => 1874,
                            barbra => 692, bari   => 3775, barrie => 2878, basilia
                                   => 3537,
                            beata  => 3019, beatrice
                                   => 170,
                            beatris
                                   => 3388, beatriz
                                   => 627,
                            beaulah
                                   => 3018, bebe   => 3536,
                            becki  => 2841, beckie => 2031, becky  => 283, belen  => 1283, belia  => 2151,
                            belinda
                                   => 301, belkis => 3246,
                            bella  => 1133, belle  => 1012, belva  => 1197, benita => 750, berenice
                                   => 1855,
                            berna  => 3063, bernadette
                                   => 393,
                            bernadine
                                   => 701, bernarda
                                   => 3062,
                            bernardina
                                   => 3535, bernardine
                                   => 2840,
                            berneice
                                   => 2511, bernetta
                                   => 2295,
                            bernice
                                   => 172, berniece
                                   => 1166,
                            bernita
                                   => 1398, berta  => 850,
                            bertha => 156, bertie => 934, beryl  => 906, bess   => 1054, bessie => 219,
                            beth   => 198, bethanie
                                   => 3176,
                            bethann
                                   => 2543, bethany
                                   => 391,
                            bethel => 2004, betsey => 2683, betsy  => 421, bette  => 589, bettie => 541,
                            bettina
                                   => 1179, betty  => 14,
                            bettyann
                                   => 3617, bettye => 688,
                            beula  => 3774, beulah => 355, beverlee
                                   => 2176,
                            beverley
                                   => 951, beverly
                                   => 73,
                            bianca => 686, bibi   => 3017, billi  => 3322, billie => 274, billye => 1975,
                            birdie => 1029, birgit => 2248, blanca => 379, blanch => 1412, blanche
                                   => 317,
                            blondell
                                   => 3016, blossom
                                   => 2839,
                            blythe => 2542, bobbi  => 657, bobbie => 284, bobbye => 1946, bobette
                                   => 3534,
                            bong   => 3245, bonita => 495, bonnie => 88, bonny  => 1425, branda => 2541,
                            brande => 3321, brandee
                                   => 1668,
                            brandi => 316, brandie
                                   => 945,
                            brandy => 272, breana => 3533, breann => 2838, breanna
                                   => 1148,
                            breanne
                                   => 1764, bree   => 1923,
                            brenda => 31, brenna => 1205, briana => 844, brianna
                                   => 714,
                            brianne
                                   => 1050, bridget
                                   => 364,
                            bridgett
                                   => 900, bridgette
                                   => 696,
                            brigette
                                   => 1418, brigid => 2057,
                            brigida
                                   => 2338, brigitte
                                   => 936,
                            brinda => 2682, britany
                                   => 2088,
                            britney
                                   => 923, britni => 2030,
                            britta => 2760, brittaney
                                   => 3320,
                            brittani
                                   => 1564, brittanie
                                   => 3015,
                            brittany
                                   => 186, britteny
                                   => 3773,
                            brittney
                                   => 531, brittni
                                   => 2247,
                            brittny
                                   => 2923, bronwyn
                                   => 2473,
                            brook  => 1352, brooke => 390, bruna  => 3319, brunilda
                                   => 2056,
                            bryanna
                                   => 3772, brynn  => 2615,
                            buena  => 3695, bula   => 3694, bulah  => 3014, bunny  => 2922, burma  => 3693,
                            caitlin
                                   => 544, caitlyn
                                   => 1523,
                            calandra
                                   => 2967, calista
                                   => 3771,
                            callie => 656, camelia
                                   => 2003,
                            camellia
                                   => 3532, cami   => 1750,
                            camie  => 2921, camila => 3692, camilla
                                   => 991,
                            camille
                                   => 475, cammie => 2246,
                            cammy  => 3461, candace
                                   => 338,
                            candance
                                   => 1667, candelaria
                                   => 1430,
                            candi  => 1249, candice
                                   => 357,
                            candida
                                   => 1104, candie => 2029,
                            candis => 1666, candra => 3770, candy  => 558, candyce
                                   => 2448,
                            caprice
                                   => 2198, cara   => 509,
                            caren  => 1064, cari   => 1027, caridad
                                   => 1185,
                            carie  => 1963, carin  => 1651, carina => 1479, carisa => 2585, carissa
                                   => 910,
                            carita => 3175, carla  => 201, carlee => 3318, carleen
                                   => 1472,
                            carlena
                                   => 3769, carlene
                                   => 784,
                            carletta
                                   => 2087, carley => 2447,
                            carli  => 2920, carlie => 2393, carline
                                   => 2175,
                            carlita
                                   => 3691, carlota
                                   => 1739,
                            carlotta
                                   => 1369, carlyn => 1854,
                            carma  => 1734, carman => 1397, carmel => 1150, carmela
                                   => 622,
                            carmelia
                                   => 3531, carmelina
                                   => 2421,
                            carmelita
                                   => 1165, carmella
                                   => 776,
                            carmen => 111, carmina
                                   => 3174,
                            carmon => 2614, carol  => 18, carola => 2837, carolann
                                   => 1809,
                            carole => 271, carolee
                                   => 1540,
                            carolin
                                   => 3013, carolina
                                   => 577,
                            caroline
                                   => 246, caroll => 3768,
                            carolyn
                                   => 42, carolyne
                                   => 2294,
                            carolynn
                                   => 1853, caroyln
                                   => 3173,
                            carri  => 1790, carrie => 129, caryl  => 1526, carylon
                                   => 3616,
                            caryn  => 1004, casandra
                                   => 899,
                            casie  => 2150, casimira
                                   => 3530,
                            cassandra
                                   => 265, cassaundra
                                   => 3061,
                            cassey => 3767, cassi  => 3317, cassie => 550, cassondra
                                   => 3060,
                            cassy  => 3316, catalina
                                   => 717,
                            catarina
                                   => 2584, caterina
                                   => 2446,
                            catharine
                                   => 1196, catherin
                                   => 3529,
                            catherina
                                   => 3766, catherine
                                   => 46,
                            cathern
                                   => 3059, catheryn
                                   => 3528,
                            cathey => 2364, cathi  => 1822, cathie => 1376, cathleen
                                   => 638,
                            cathrine
                                   => 1121, cathryn
                                   => 897,
                            cathy  => 163, catina => 1351, catrice
                                   => 3765,
                            catrina
                                   => 1041, cayla  => 3690,
                            cecelia
                                   => 436, cecila => 2197,
                            cecile => 592, cecilia
                                   => 314,
                            cecille
                                   => 3387, cecily => 1686,
                            celena => 2337, celesta
                                   => 3122,
                            celeste
                                   => 507, celestina
                                   => 2028,
                            celestine
                                   => 1063, celia  => 366,
                            celina => 955, celinda
                                   => 3527,
                            celine => 2129, celsa  => 3315, ceola  => 2805, chae   => 3526, chana  => 1605,
                            chanda => 1387, chandra
                                   => 732,
                            chanel => 1333, chanell
                                   => 3058,
                            chanelle
                                   => 2877, chantal
                                   => 1324,
                            chantay
                                   => 3386, chante => 2420,
                            chantel
                                   => 1067, chantell
                                   => 2363,
                            chantelle
                                   => 1627, chara  => 3460,
                            charis => 3172, charise
                                   => 2445,
                            charissa
                                   => 1656, charisse
                                   => 1411,
                            charita
                                   => 3314, charity
                                   => 625,
                            charla => 1142, charleen
                                   => 1312,
                            charlena
                                   => 3615, charlene
                                   => 218,
                            charlesetta
                                   => 3313, charlette
                                   => 1775,
                            charline
                                   => 1332, charlott
                                   => 3385,
                            charlotte
                                   => 130, charlsie
                                   => 3614,
                            charlyn
                                   => 3244, charmain
                                   => 3459,
                            charmaine
                                   => 800, charolette
                                   => 1789,
                            chasidy
                                   => 3764, chasity
                                   => 838,
                            chassidy
                                   => 3763, chastity
                                   => 1220,
                            chau   => 2681, chaya  => 2002, chelsea
                                   => 400,
                            chelsey
                                   => 970, chelsie
                                   => 1424,
                            cher   => 2804, chere  => 3171, cheree => 2876, cherelle
                                   => 3458,
                            cheri  => 504, cherie => 563, cherilyn
                                   => 2966,
                            cherise
                                   => 1604, cherish
                                   => 2320,
                            cherly => 1525, cherlyn
                                   => 3457,
                            cherri => 1685, cherrie
                                   => 1641,
                            cherryl
                                   => 2472, chery  => 2836,
                            cheryl => 59, cheryle
                                   => 1497,
                            cheryll
                                   => 2362, cheyenne
                                   => 1640,
                            chia   => 3312, chieko => 3456, ching  => 2835, chiquita
                                   => 1245,
                            chrissy
                                   => 1406, christa
                                   => 548,
                            christal
                                   => 1140, christeen
                                   => 2444,
                            christel
                                   => 1579, christen
                                   => 1075,
                            christena
                                   => 2443, christene
                                   => 1945,
                            christi
                                   => 646, christia
                                   => 3613,
                            christiana
                                   => 1676, christiane
                                   => 1788,
                            christie
                                   => 422, christin
                                   => 1097,
                            christina
                                   => 70, christine
                                   => 43,
                            christinia
                                   => 3243, christy
                                   => 256,
                            chrystal
                                   => 807, chun   => 1873,
                            ciara  => 1626, cicely => 2540, ciera  => 2226, cierra => 1614, cinda  => 1639,
                            cinderella
                                   => 3311, cindi  => 1053,
                            cindie => 3762, cindy  => 113, cinthia
                                   => 1486,
                            cira   => 3525, claire => 296, clara  => 144, clare  => 769, claretha
                                   => 3242,
                            claretta
                                   => 3612, claribel
                                   => 1888,
                            clarice
                                   => 629, clarinda
                                   => 3524,
                            clarine
                                   => 2471, claris => 3455,
                            clarisa
                                   => 3310, clarissa
                                   => 720,
                            clarita
                                   => 2613, classie
                                   => 3170,
                            claudette
                                   => 637, claudia
                                   => 232,
                            claudie
                                   => 2759, claudine
                                   => 830,
                            clelia => 3454, clemencia
                                   => 3012,
                            clementina
                                   => 1990, clementine
                                   => 1287,
                            clemmie
                                   => 2361, cleo   => 578,
                            cleopatra
                                   => 2392, cleora => 2583,
                            cleotilde
                                   => 3384, cleta  => 1650,
                            clora  => 2965, clorinda
                                   => 2834,
                            clotilde
                                   => 2293, codi   => 3761,
                            coleen => 878, colene => 3383, coletta
                                   => 2612,
                            colette
                                   => 817, colleen
                                   => 225,
                            collen => 2319, collene
                                   => 3760,
                            collette
                                   => 1311, concepcion
                                   => 724,
                            conception
                                   => 2964, concetta
                                   => 933,
                            concha => 3611, conchita
                                   => 2128,
                            connie => 106, constance
                                   => 230,
                            consuela
                                   => 2127, consuelo
                                   => 559,
                            contessa
                                   => 3382, cora   => 304,
                            coral  => 1471, coralee
                                   => 2803,
                            coralie
                                   => 3121, corazon
                                   => 1910,
                            cordelia
                                   => 1243, cordia => 3381,
                            cordie => 2611, coreen => 2126, corene => 1707, coretta
                                   => 2105,
                            cori   => 1171, corie  => 2318, corina => 874, corine => 805, corinna
                                   => 1463,
                            corinne
                                   => 538, corliss
                                   => 2292,
                            cornelia
                                   => 685, corrie => 1307,
                            corrin => 3689, corrina
                                   => 1808,
                            corrine
                                   => 722, corrinne
                                   => 3380,
                            cortney
                                   => 963, courtney
                                   => 243,
                            creola => 2919, criselda
                                   => 2722,
                            crissy => 2419, crista => 2071, cristal
                                   => 1336,
                            cristen
                                   => 2610, cristi => 1821,
                            cristie
                                   => 2582, cristin
                                   => 1887,
                            cristina
                                   => 428, cristine
                                   => 1553,
                            cristy => 1164, crysta => 3453, crystal
                                   => 102,
                            crystle
                                   => 3610, cyndi  => 1649,
                            cyndy  => 3120, cynthia
                                   => 28,
                            cyrstal
                                   => 3688, cythia => 1886,
                            dacia  => 2802, dagmar => 2317, dagny  => 3759, dahlia => 2125, daina  => 2918,
                            daine  => 3687, daisey => 2149, daisy  => 291, dalene => 3169, dalia  => 1132,
                            dalila => 2148, damaris
                                   => 1195,
                            dana   => 178, danae  => 2510, danelle
                                   => 1331,
                            danette
                                   => 1047, dani   => 1852,
                            dania  => 1962, danica => 1763, daniela
                                   => 1086,
                            daniele
                                   => 1851, daniell
                                   => 2758,
                            daniella
                                   => 1462, danielle
                                   => 150,
                            danika => 2609, danille
                                   => 2801,
                            danita => 1204, dann   => 3452, danna  => 1052, dannette
                                   => 2539,
                            dannielle
                                   => 1872, danuta => 2608,
                            danyel => 2875, danyell
                                   => 2800,
                            danyelle
                                   => 1931, daphine
                                   => 2291,
                            daphne => 600, dara   => 1094, darcel => 3309, darcey => 3523, darci  => 1507,
                            darcie => 1638, darcy  => 774, daria  => 1461, darla  => 459, darleen
                                   => 1279,
                            darlena
                                   => 3057, darlene
                                   => 157,
                            darline
                                   => 1637, davida => 1684,
                            davina => 1613, dawn   => 105, dawna  => 1375, dawne  => 2470, dayle  => 2245,
                            dayna  => 1003, daysi  => 3609, deadra => 3056, deana  => 662, deandra
                                   => 2316,
                            deandrea
                                   => 3379, deane  => 2469,
                            deann  => 944, deanna => 257, deanne => 809, debbi  => 2027, debbie => 141,
                            debbra => 1871, debby  => 1037, debera => 3378, debi   => 1341, debora => 562,
                            deborah
                                   => 25, debra  => 39,
                            debrah => 1306, debroah
                                   => 2225,
                            dede   => 3451, dedra  => 1625, dee    => 674, deeann => 2104, deeanna
                                   => 3522,
                            deedee => 2963, deedra => 3011, deena  => 861, deetta => 3686, deidra => 966,
                            deidre => 837, deirdre
                                   => 842,
                            deja   => 3450, delaine
                                   => 2757,
                            delana => 2196, delcie => 3521, delena => 2581, delfina
                                   => 1272,
                            delia  => 450, delicia
                                   => 2538,
                            delila => 3608, delilah
                                   => 1040,
                            delinda
                                   => 2124, delisa => 2224,
                            dell   => 2275, della  => 371, delma  => 1018, delmy  => 3449, delois => 1116,
                            deloise
                                   => 2962, delora => 1909,
                            deloras
                                   => 3607, delores
                                   => 220,
                            deloris
                                   => 501, delorse
                                   => 3241,
                            delpha => 2652, delphia
                                   => 1787,
                            delphine
                                   => 1049, delsie => 3010,
                            delta  => 2001, demetra
                                   => 1624,
                            demetria
                                   => 1017, demetrice
                                   => 2580,
                            dena   => 554, denae  => 3308, deneen => 1833, denese => 2579, denice => 959,
                            denise => 74, denisha
                                   => 2468,
                            denisse
                                   => 3606, denita => 1974,
                            denna  => 1820, dennise
                                   => 1961,
                            denyse => 3685, deonna => 3055, desirae
                                   => 1908,
                            desire => 2336, desiree
                                   => 417,
                            despina
                                   => 3009, dessie => 976,
                            destiny
                                   => 1020, detra  => 2360,
                            devona => 2195, devora => 2721, devorah
                                   => 2680,
                            dian   => 1366, diana  => 96, diane  => 50, diann  => 909, dianna => 411,
                            dianne => 275, diedra => 2467, diedre => 2578, dierdre
                                   => 3307,
                            digna  => 2274, dimple => 2720, dina   => 565, dinah  => 1085, dinorah
                                   => 3240,
                            dione  => 2335, dionna => 2509, dionne => 903, divina => 3758, dixie  => 468,
                            dodie  => 3605, dollie => 795, dolly  => 670, dolores
                                   => 171,
                            doloris
                                   => 2508, domenica
                                   => 1870,
                            dominga
                                   => 1154, dominica
                                   => 2917,
                            dominique
                                   => 651, dominque
                                   => 2194,
                            domitila
                                   => 2916, domonique
                                   => 2537,
                            dona   => 728, donella
                                   => 3239,
                            donetta
                                   => 2466, donette
                                   => 3520,
                            donita => 1396, donna  => 17, donnetta
                                   => 3306,
                            donnette
                                   => 3305, donya  => 2536,
                            dora   => 247, dorathy
                                   => 2334,
                            dorcas => 1293, doreatha
                                   => 3684,
                            doreen => 415, dorene => 1203, doretha
                                   => 965,
                            dorethea
                                   => 3683, doretta
                                   => 2756,
                            dori   => 1506, doria  => 3238, dorie  => 2577, dorinda
                                   => 1395,
                            dorine => 2055, doris  => 55, dorla  => 3448, dorotha
                                   => 1850,
                            dorothea
                                   => 569, dorothy
                                   => 10,
                            dorris => 1131, dortha => 1335, dorthea
                                   => 1749,
                            dorthey
                                   => 3237, dorthy => 513,
                            dottie => 1011, dotty  => 3119, dovie  => 1213, dreama => 2418, drema  => 2651,
                            drucilla
                                   => 2026, drusilla
                                   => 2333,
                            dulce  => 1346, dulcie => 3168, dung   => 2507, dusti  => 3118, dwana  => 3447,
                            dyan   => 2576, earlean
                                   => 2290,
                            earleen
                                   => 2391, earlene
                                   => 782,
                            earlie => 3167, earline
                                   => 716,
                            earnestine
                                   => 775, eartha => 1733,
                            easter => 1345, eboni  => 1706, ebonie => 2833, ebony  => 479, echo   => 2679,
                            edda   => 2650, edelmira
                                   => 1922,
                            eden   => 1732, edie   => 1436, edith  => 117, edna   => 109, edra   => 3682,
                            edris  => 3304, edwina => 791, edyth  => 3054, edythe => 995, effie  => 514,
                            ehtel  => 3166, eileen => 204, eilene => 2961, eladia => 3604, elaina => 1522,
                            elaine => 127, elana  => 1748, elane  => 3165, elanor => 2607, elayne => 2123,
                            elba   => 940, elda   => 987, eldora => 1819, eleanor
                                   => 148,
                            eleanora
                                   => 1885, eleanore
                                   => 1026,
                            elease => 2086, elena  => 405, elene  => 3519, eleni  => 2359, elenor => 1394,
                            elenora
                                   => 1989, elenore
                                   => 2755,
                            eleonor
                                   => 3377, eleonora
                                   => 3446,
                            eleonore
                                   => 3236, elfreda
                                   => 3518,
                            elfrieda
                                   => 2874, elfriede
                                   => 1731,
                            elia   => 1036, eliana => 2442, elicia => 2273, elida  => 1015, elidia => 3681,
                            elin   => 3303, elina  => 2873, elinor => 771, elinore
                                   => 3008,
                            elisa  => 478, elisabeth
                                   => 542,
                            elise  => 591, elisha => 975, elissa => 1143, eliz   => 3117, eliza  => 694,
                            elizabet
                                   => 3603, elizabeth
                                   => 5,
                            elizbeth
                                   => 2015, elizebeth
                                   => 1365,
                            elke   => 2332, ella   => 209, ellamae
                                   => 3116,
                            ellan  => 3680, ellen  => 126, ellena => 3757, elli   => 3756, ellie  => 1129,
                            elly   => 2506, ellyn  => 2244, elma   => 648, elmira => 1818, elna   => 1612,
                            elnora => 731, elodia => 2054, elois  => 2678, eloisa => 1062, eloise => 433,
                            elouise
                                   => 1193, elsa   => 464,
                            elsie  => 197, elsy   => 3602, elva   => 537, elvera => 1786, elvia  => 840,
                            elvie  => 2315, elvina => 2606, elvira => 449, elwanda
                                   => 3115,
                            elyse  => 1176, elza   => 3235, emelda => 2358, emelia => 1884, emelina
                                   => 3302,
                            emeline
                                   => 3164, emely  => 3053,
                            emerald
                                   => 2799, emerita
                                   => 2832,
                            emiko  => 2314, emilee => 1960, emilia => 749, emilie => 990, emily  => 99,
                            emma   => 134, emmaline
                                   => 3517,
                            emmie  => 2147, emmy   => 2103, emogene
                                   => 1730,
                            enda   => 3755, enedina
                                   => 1603,
                            eneida => 2272, enid   => 889, enola  => 2193, enriqueta
                                   => 1460,
                            epifania
                                   => 2575, erica  => 169,
                            ericka => 729, erika  => 294, erin   => 160, erinn  => 2719, erlene => 2146,
                            erlinda
                                   => 1120, erline => 2535,
                            erma   => 378, ermelinda
                                   => 2505,
                            erminia
                                   => 2718, erna   => 888,
                            ernestina
                                   => 1014, ernestine
                                   => 402,
                            eryn   => 2872, esmeralda
                                   => 754,
                            esperanza
                                   => 572, essie  => 461,
                            esta   => 1959, estefana
                                   => 3601,
                            estela => 712, estell => 2014, estella
                                   => 525,
                            estelle
                                   => 410, ester  => 602,
                            esther => 132, estrella
                                   => 1594,
                            etha   => 2915, ethel  => 125, ethelene
                                   => 2534,
                            ethelyn
                                   => 1602, ethyl  => 2243,
                            etsuko => 3679, etta   => 520, ettie  => 3678, eufemia
                                   => 3052,
                            eugena => 3516, eugenia
                                   => 547,
                            eugenie
                                   => 1907, eula   => 429,
                            eulah  => 3600, eulalia
                                   => 1344,
                            euna   => 2914, eunice => 322, eura   => 3599, eusebia
                                   => 3234,
                            eustolia
                                   => 3301, eva    => 140,
                            evalyn => 1648, evangelina
                                   => 885,
                            evangeline
                                   => 816, eve    => 756,
                            evelia => 1683, evelin => 2504, evelina
                                   => 1958,
                            eveline
                                   => 2013, evelyn => 57,
                            evelyne
                                   => 1988, evelynn
                                   => 3754,
                            evette => 1192, evia   => 3515, evie   => 1442, evita  => 3598, evon   => 1601,
                            evonne => 1485, exie   => 2649, fabiola
                                   => 1320,
                            faith  => 471, fallon => 1944, fannie => 339, fanny  => 930, farah  => 2192,
                            farrah => 1521, fatima => 1024, fatimah
                                   => 3233,
                            faustina
                                   => 2271, faviola
                                   => 3753,
                            fawn   => 1381, fay    => 567, faye   => 305, felecia
                                   => 948,
                            felica => 1729, felice => 1832, felicia
                                   => 279,
                            felicidad
                                   => 2960, felicita
                                   => 1163,
                            felicitas
                                   => 1524, felipa => 1423,
                            felisa => 1883, felisha
                                   => 1505,
                            fermina
                                   => 3677, fern   => 536,
                            fernanda
                                   => 2270, fernande
                                   => 3114,
                            ferne  => 1705, fidela => 3113, fidelia
                                   => 3597,
                            filomena
                                   => 1182, fiona  => 1774,
                            flavia => 2174, fleta  => 3232, flor   => 1191, flora  => 348, florance
                                   => 2173,
                            florence
                                   => 107, florencia
                                   => 1973,
                            florene
                                   => 1623, florentina
                                   => 2053,
                            floretta
                                   => 2648, floria => 3445,
                            florinda
                                   => 2052, florine
                                   => 926,
                            florrie
                                   => 3444, flossie
                                   => 702,
                            floy   => 1292, fonda  => 1593, fran   => 831, francene
                                   => 3007,
                            frances
                                   => 47, francesca
                                   => 922,
                            franchesca
                                   => 3163, francie
                                   => 2647,
                            francina
                                   => 2574, francine
                                   => 500,
                            francisca
                                   => 526, francoise
                                   => 2717,
                            fransisca
                                   => 3676, freda  => 423,
                            fredda => 3376, frederica
                                   => 2172,
                            fredericka
                                   => 2331, fredia => 2223,
                            fredricka
                                   => 3231, freeda => 2171,
                            freida => 894, frida  => 3051, frieda => 633, fumiko => 2503, gabriela
                                   => 610,
                            gabriele
                                   => 1987, gabriella
                                   => 1256,
                            gabrielle
                                   => 640, gail   => 155,
                            gala   => 3375, gale   => 668, galina => 3230, garnet => 1441, garnett
                                   => 2170,
                            gaye   => 1217, gayla  => 979, gayle  => 370, gaylene
                                   => 2605,
                            gaynell
                                   => 1716, gaynelle
                                   => 2798,
                            gearldine
                                   => 2573, gema   => 3752,
                            gemma  => 1578, gena   => 843, genesis
                                   => 3050,
                            geneva => 299, genevie
                                   => 3374,
                            genevieve
                                   => 329, genevive
                                   => 3514,
                            genia  => 2502, genie  => 2313, genna  => 3049, gennie => 2646, genny  => 2959,
                            genoveva
                                   => 1286, georgann
                                   => 3112,
                            georgeann
                                   => 3048, georgeanna
                                   => 3162,
                            georgene
                                   => 2012, georgetta
                                   => 1906,
                            georgette
                                   => 829, georgia
                                   => 229,
                            georgiana
                                   => 1248, georgiann
                                   => 2958,
                            georgianna
                                   => 1291, georgianne
                                   => 3596,
                            georgie
                                   => 1350, georgina
                                   => 693,
                            georgine
                                   => 2312, geraldine
                                   => 161,
                            geralyn
                                   => 1592, gerda  => 1435,
                            geri   => 999, germaine
                                   => 960,
                            gerri  => 1340, gertha => 2441, gertie => 1278, gertrud
                                   => 2169,
                            gertrude
                                   => 206, gertrudis
                                   => 3675,
                            gertude
                                   => 2831, ghislaine
                                   => 3674,
                            gianna => 2797, gidget => 3229, gigi   => 1972, gilberte
                                   => 3751,
                            gilda  => 915, gillian
                                   => 1181,
                            gilma  => 3673, gina   => 212, ginette
                                   => 2871,
                            ginger => 419, ginny  => 1305, giovanna
                                   => 1577,
                            gisela => 1125, gisele => 1647, giselle
                                   => 1496,
                            gita   => 3300, giuseppina
                                   => 3111,
                            gladis => 1682, glady  => 2191, gladys => 103, glayds => 3373, glenda => 240,
                            glendora
                                   => 2168, glenna => 609,
                            glennie
                                   => 2572, glennis
                                   => 2269,
                            glinda => 2268, gloria => 56, glory  => 1728, glynda => 2604, glynis => 2796,
                            golda  => 1600, goldie => 549, grace  => 114, gracia => 2190, gracie => 620,
                            graciela
                                   => 604, grayce => 2830,
                            grazyna
                                   => 3443, gregoria
                                   => 1237,
                            greta  => 704, gretchen
                                   => 435,
                            gretta => 1905, gricelda
                                   => 2870,
                            grisel => 3372, griselda
                                   => 1013,
                            guadalupe
                                   => 300, gudrun => 2417,
                            guillermina
                                   => 1061, gussie => 989,
                            gwen   => 441, gwenda => 2390, gwendolyn
                                   => 260,
                            gwenn  => 2533, gwyn   => 2716, gwyneth
                                   => 3299,
                            hailey => 1563, haley  => 698, halina => 2222, halley => 3228, hallie => 887,
                            hana   => 2085, hanh   => 2645, hannah => 362, hannelore
                                   => 2167,
                            harriet
                                   => 312, harriett
                                   => 745,
                            harriette
                                   => 1184, hassie => 3110,
                            hattie => 311, haydee => 1177, hayley => 1230, hazel  => 138, heather
                                   => 53,
                            hedwig => 1675, hedy   => 2532, heide  => 2051, heidi  => 239, heidy  => 3750,
                            heike  => 3109, helaine
                                   => 3298,
                            helen  => 15, helena => 576, helene => 535, helga  => 914, hellen => 1319,
                            henrietta
                                   => 438, henriette
                                   => 2122,
                            herlinda
                                   => 1233, herma  => 3297,
                            hermelinda
                                   => 1539, hermila
                                   => 3513,
                            hermina
                                   => 2330, hermine
                                   => 2025,
                            herminia
                                   => 953, herta  => 2754,
                            hertha => 3006, hettie => 1591, hiedi  => 3108, hien   => 3442, hilaria
                                   => 2644,
                            hilary => 711, hilda  => 259, hilde  => 2677, hildegard
                                   => 1251,
                            hildegarde
                                   => 2501, hildred
                                   => 2500,
                            hillary
                                   => 763, hilma  => 1957,
                            hiroko => 2121, hisako => 3296, holli  => 1380, hollie => 918, holly  => 185,
                            hortencia
                                   => 1043, hortense
                                   => 1440,
                            hortensia
                                   => 1715, hsiu   => 3512,
                            hulda  => 1693, huong  => 1882, hyacinth
                                   => 2531,
                            hyon   => 2440, hyun   => 2120, ida    => 182, idalia => 1665, idell  => 1956,
                            idella => 1263, iesha  => 2050, ignacia
                                   => 2119,
                            ila    => 703, ilana  => 2416, ilda   => 2499, ileana => 1429, ileen  => 3047,
                            ilene  => 802, iliana => 1727, illa   => 3371, ilona  => 1664, ilse   => 1562,
                            iluminada
                                   => 2643, imelda => 852,
                            imogene
                                   => 605, ina    => 540,
                            indira => 2267, inell  => 2415, ines   => 932, inez   => 324, inga   => 1590,
                            inge   => 1520, ingeborg
                                   => 1576,
                            inger  => 2266, ingrid => 545, inocencia
                                   => 2715,
                            iola   => 1010, iona   => 1055, ione   => 1124, iraida => 3161, irena  => 1663,
                            irene  => 76, irina  => 2357, iris   => 321, irma   => 251, irmgard
                                   => 1955,
                            isabel => 309, isabell
                                   => 1123,
                            isabella
                                   => 952, isabelle
                                   => 593,
                            isadora
                                   => 3595, isaura => 2389,
                            isela  => 1904, isidra => 2714, isis   => 2530, isobel => 2957, iva    => 546,
                            ivana  => 2414, ivelisse
                                   => 2795,
                            ivette => 1074, ivonne => 1229, ivy    => 673, izetta => 3107, izola  => 2913,
                            jacalyn
                                   => 1738, jacelyn
                                   => 2912,
                            jacinda
                                   => 2753, jacinta
                                   => 1611,
                            jackeline
                                   => 1881, jackelyn
                                   => 3441,
                            jacki  => 2102, jackie => 233, jacklyn
                                   => 893,
                            jackqueline
                                   => 3295, jaclyn => 619,
                            jacqualine
                                   => 2388, jacque => 1262,
                            jacquelin
                                   => 1216, jacqueline
                                   => 86,
                            jacquelyn
                                   => 377, jacquelyne
                                   => 2642,
                            jacquelynn
                                   => 2439, jacquetta
                                   => 3160,
                            jacqui => 3440, jacquie
                                   => 2794,
                            jacquiline
                                   => 2676, jacquline
                                   => 1006,
                            jacqulyn
                                   => 2118, jada   => 1561,
                            jade   => 958, jadwiga
                                   => 2571,
                            jaimee => 3294, jaimie => 1519, jaleesa
                                   => 2641,
                            jalisa => 2911, jama   => 3749, jamee  => 3227, jami   => 730, jamie  => 146,
                            jamika => 3511, jamila => 1547, jammie => 1714, jan    => 336, jana   => 440,
                            janae  => 1869, janay  => 2675, jane   => 77, janean => 3293, janee  => 2752,
                            janeen => 1379, janel  => 1077, janell => 931, janella
                                   => 3005,
                            janelle
                                   => 532, janene => 1849,
                            janessa
                                   => 2084, janet  => 45,
                            janeth => 2221, janett => 2166, janetta
                                   => 2024,
                            janette
                                   => 556, janey  => 1817,
                            jani   => 3510, janice => 66, janie  => 332, janiece
                                   => 3370,
                            janina => 1405, janine => 582, janis  => 420, janise => 2793, janita => 2311,
                            jann   => 2498, janna  => 859, jannet => 2751, jannette
                                   => 1304,
                            jannie => 902, janyce => 3594, jaqueline
                                   => 1019,
                            jaquelyn
                                   => 3672, jasmin => 984,
                            jasmine
                                   => 397, jaunita
                                   => 1747,
                            jaye   => 2829, jayme  => 1149, jaymie => 2869, jayna  => 3004, jayne  => 618,
                            jazmin => 1589, jazmine
                                   => 2165,
                            jean   => 58, jeana  => 1330, jeane  => 1518, jeanelle
                                   => 2910,
                            jeanene
                                   => 2387, jeanett
                                   => 3106,
                            jeanetta
                                   => 1447, jeanette
                                   => 190,
                            jeanice
                                   => 2956, jeanie => 742,
                            jeanine
                                   => 630, jeanmarie
                                   => 2828,
                            jeanna => 1039, jeanne => 199, jeannetta
                                   => 3748,
                            jeannette
                                   => 359, jeannie
                                   => 466,
                            jeannine
                                   => 661, jeffie => 3593,
                            jena   => 1034, jenae  => 3369, jene   => 2750, jenee  => 3105, jenell => 2049,
                            jenelle
                                   => 1478, jenette
                                   => 1986,
                            jeneva => 3671, jeni   => 2189, jenice => 2674, jenifer
                                   => 552,
                            jeniffer
                                   => 1393, jenine => 2329,
                            jenise => 2145, jenna  => 442, jennefer
                                   => 2220,
                            jennell
                                   => 3439, jennette
                                   => 1546,
                            jenni  => 1495, jennie => 261, jennifer
                                   => 6,
                            jenniffer
                                   => 1807, jennine
                                   => 3159,
                            jenny  => 278, jeraldine
                                   => 1746,
                            jeri   => 678, jerica => 2909, jerilyn
                                   => 1646,
                            jerlene
                                   => 3509, jerri  => 773,
                            jerrica
                                   => 2749, jerrie => 1538,
                            jesenia
                                   => 2070, jesica => 1299,
                            jessenia
                                   => 2310, jessi  => 2083,
                            jessia => 3592, jessica
                                   => 26,
                            jessie => 214, jessika
                                   => 2908,
                            jestine
                                   => 3591, jesusa => 2640,
                            jesusita
                                   => 3590, jetta  => 2792,
                            jettie => 1806, jewel  => 508, jewell => 566, jill   => 159, jillian
                                   => 568,
                            jina   => 2101, jinny  => 3747, joan   => 62, joana  => 1903, joane  => 3003,
                            joanie => 1456, joann  => 164, joanna => 320, joanne => 147, joannie
                                   => 2748,
                            joaquina
                                   => 3508, jocelyn
                                   => 595,
                            jodee  => 2144, jodi   => 331, jodie  => 643, jody   => 395, joeann => 2413,
                            joella => 2356, joelle => 1242, joellen
                                   => 1470,
                            joetta => 1745, joette => 3368, johana => 2639, johanna
                                   => 473,
                            johanne
                                   => 3226, johna  => 2827,
                            johnetta
                                   => 1744, johnette
                                   => 3104,
                            johnna => 1227, johnsie
                                   => 3292,
                            joie   => 3746, jolanda
                                   => 2638,
                            joleen => 1552, jolene => 606, jolie  => 2082, joline => 3158, jolyn  => 2791,
                            jolynn => 1704, jona   => 2529, jone   => 3002, jonell => 2000, jonelle
                                   => 2048,
                            jong   => 3670, joni   => 597, jonie  => 3103, jonna  => 1662, jonnie => 1374,
                            josefa => 863, josefina
                                   => 465,
                            josefine
                                   => 3438, joselyn
                                   => 2047,
                            josephina
                                   => 1484, josephine
                                   => 121,
                            josette
                                   => 1244, josie  => 527,
                            joslyn => 2265, josphine
                                   => 2790,
                            jovan  => 3437, jovita => 1266, joy    => 228, joya   => 3367, joyce  => 49,
                            joycelyn
                                   => 1422, joye   => 2117,
                            juana  => 358, juanita
                                   => 135,
                            judi   => 969, judie  => 1816, judith => 64, judy   => 69, jule   => 3225,
                            julee  => 2465, julene => 3224, juli   => 1298, julia  => 89, juliana
                                   => 811,
                            juliane
                                   => 2673, juliann
                                   => 1785,
                            julianna
                                   => 1208, julianne
                                   => 789,
                            julie  => 52, julieann
                                   => 3291,
                            julienne
                                   => 2386, juliet => 892,
                            julieta
                                   => 1762, julietta
                                   => 3589,
                            juliette
                                   => 860, julissa
                                   => 1805,
                            jung   => 1175, junie  => 3290, junita => 2528, junko  => 3507, justa  => 3157,
                            justina
                                   => 988, justine
                                   => 647,
                            jutta  => 2164, kacey  => 1743, kaci   => 1930, kacie  => 1880, kacy   => 2438,
                            kaila  => 2747, kaitlin
                                   => 924,
                            kaitlyn
                                   => 994, kala   => 1560,
                            kaleigh
                                   => 3289, kaley  => 2570,
                            kali   => 1985, kallie => 3588, kalyn  => 3366, kamala => 3156, kami   => 1349,
                            kamilah
                                   => 3155, kandace
                                   => 1868,
                            kandi  => 1571, kandice
                                   => 1570,
                            kandis => 2826, kandra => 3506, kandy  => 1703, kanesha
                                   => 3669,
                            kanisha
                                   => 3223, kara   => 376,
                            karan  => 1831, kareen => 3102, karen  => 13, karena => 2907, karey  => 2219,
                            kari   => 409, karie  => 1610, karima => 3436, karin  => 530, karina => 755,
                            karine => 2637, karisa => 3288, karissa
                                   => 1459,
                            karla  => 365, karleen
                                   => 2527,
                            karlene
                                   => 1804, karly  => 2906,
                            karlyn => 3435, karma  => 2412, karmen => 2355, karol  => 1255, karole => 3745,
                            karoline
                                   => 3154, karolyn
                                   => 1504,
                            karon  => 1202, karren => 2023, karri  => 1636, karrie => 1084, karry  => 3668,
                            kary   => 2789, karyl  => 2636, karyn  => 882, kasandra
                                   => 1867,
                            kasey  => 814, kasha  => 3434, kasi   => 3587, kasie  => 2569, kassandra
                                   => 1421,
                            kassie => 2289, kate   => 452, katelin
                                   => 3101,
                            katelyn
                                   => 846, katelynn
                                   => 3001,
                            katerine
                                   => 3586, kathaleen
                                   => 2081,
                            katharina
                                   => 2046, katharine
                                   => 642,
                            katharyn
                                   => 3287, kathe  => 2497,
                            katheleen
                                   => 3286, katherin
                                   => 2188,
                            katherina
                                   => 3667, katherine
                                   => 61,
                            kathern
                                   => 2218, katheryn
                                   => 908,
                            kathey => 2496, kathi  => 978, kathie => 823, kathleen
                                   => 36,
                            kathlene
                                   => 1661, kathline
                                   => 3433,
                            kathlyn
                                   => 1773, kathrin
                                   => 2868,
                            kathrine
                                   => 798, kathryn
                                   => 82,
                            kathryne
                                   => 1803, kathy  => 71,
                            kathyrn
                                   => 1866, kati   => 2069,
                            katia  => 2603, katie  => 192, katina => 905, katlyn => 2354, katrice
                                   => 2568,
                            katrina
                                   => 295, kattie => 2011,
                            katy   => 788, kay    => 268, kayce  => 3153, kaycee => 3365, kaye   => 806,
                            kayla  => 334, kaylee => 1660, kayleen
                                   => 2353,
                            kayleigh
                                   => 2242, kaylene
                                   => 2143,
                            kazuko => 2288, kecia  => 1802, keeley => 3505, keely  => 1494, keena  => 2602,
                            keesha => 2010, keiko  => 1902, keila  => 3000, keira  => 3744, keisha => 607,
                            keitha => 2867, keli   => 1929, kelle  => 2713, kellee => 2264, kelli  => 361,
                            kellie => 455, kelly  => 67, kellye => 2263, kelsey => 539, kelsi  => 2955,
                            kelsie => 1921, kemberly
                                   => 3222,
                            kena   => 2601, kenda  => 2866, kendal => 3221, kendra => 396, kenia  => 2954,
                            kenisha
                                   => 2287, kenna  => 1772,
                            kenya  => 794, kenyatta
                                   => 1815,
                            kenyetta
                                   => 2022, kera   => 3220,
                            keren  => 3046, keri   => 611, kerri  => 522, kerrie => 1161, kerstin
                                   => 2865,
                            kesha  => 1329, keshia => 1343, keturah
                                   => 3100,
                            keva   => 3743, khadijah
                                   => 3585,
                            khalilah
                                   => 3504, kiana  => 2352,
                            kiara  => 1737, kiera  => 2142, kiersten
                                   => 2788,
                            kiesha => 2141, kiley  => 2116, kim    => 118, kimber => 2217, kimberely
                                   => 1726,
                            kimberlee
                                   => 983, kimberley
                                   => 574,
                            kimberli
                                   => 1954, kimberlie
                                   => 2464,
                            kimberly
                                   => 24, kimbery
                                   => 2635,
                            kimbra => 3666, kimi   => 2999, kimiko => 2672, kina   => 3285, kindra => 2163,
                            kira   => 1103, kirsten
                                   => 614,
                            kirstie
                                   => 3432, kirstin
                                   => 1742,
                            kisha  => 1128, kittie => 3219, kitty  => 943, kiyoko => 3099, kizzie => 3218,
                            kizzy  => 1943, klara  => 2825, kori   => 1545, kortney
                                   => 3217,
                            kourtney
                                   => 2068, krishna
                                   => 3742,
                            krissy => 2905, krista => 383, kristal
                                   => 1174,
                            kristan
                                   => 1635, kristeen
                                   => 3503,
                            kristel
                                   => 2495, kristen
                                   => 193,
                            kristi => 315, kristian
                                   => 1865,
                            kristie
                                   => 486, kristin
                                   => 213,
                            kristina
                                   => 286, kristine
                                   => 337,
                            kristle
                                   => 3741, kristy => 350,
                            kristyn
                                   => 1761, krysta => 2385,
                            krystal
                                   => 406, krysten
                                   => 2953,
                            krystin
                                   => 3216, krystina
                                   => 2952,
                            krystle
                                   => 1009, krystyna
                                   => 1634,
                            kyla   => 1271, kylee  => 1702, kylie  => 1139, kymberly
                                   => 2351,
                            kyoko  => 2951, kyong  => 1428, kyra   => 1410, kyung  => 1446, lacey  => 608,
                            lachelle
                                   => 2824, laci   => 1848,
                            lacie  => 1559, lacresha
                                   => 3740,
                            lacy   => 891, ladawn => 3284, ladonna
                                   => 665,
                            lael   => 3431, lahoma => 3283, laila  => 1984, laine  => 3584, lajuana
                                   => 2904,
                            lakeesha
                                   => 3364, lakeisha
                                   => 834,
                            lakendra
                                   => 3215, lakenya
                                   => 3430,
                            lakesha
                                   => 998, lakeshia
                                   => 1434,
                            lakia  => 2950, lakiesha
                                   => 2787,
                            lakisha
                                   => 790, lakita => 3098,
                            lala   => 2823, lamonica
                                   => 3665,
                            lana   => 458, lanell => 2463, lanelle
                                   => 2903,
                            lanette
                                   => 1645, lani   => 1701,
                            lanie  => 3045, lanita => 1920, lannie => 3152, lanora => 3097, laquanda
                                   => 2822,
                            laquita
                                   => 1247, larae  => 2216,
                            laraine
                                   => 2634, laree  => 3739,
                            larhonda
                                   => 2100, larisa => 2045,
                            larissa
                                   => 1113, larita => 3044,
                            laronda
                                   => 2567, larraine
                                   => 3738,
                            larue  => 1622, lasandra
                                   => 2712,
                            lashanda
                                   => 1458, lashandra
                                   => 3664,
                            lashaun
                                   => 3429, lashaunda
                                   => 3363,
                            lashawn
                                   => 1093, lashawna
                                   => 3583,
                            lashawnda
                                   => 2949, lashay => 3737,
                            lashell
                                   => 3663, lashon => 2998,
                            lashonda
                                   => 968, lashunda
                                   => 2115,
                            lasonya
                                   => 2864, latanya
                                   => 980,
                            latarsha
                                   => 2902, latasha
                                   => 494,
                            latashia
                                   => 2711, latesha
                                   => 2566,
                            latia  => 2384, laticia
                                   => 2099,
                            latina => 2821, latisha
                                   => 691,
                            latonia
                                   => 1318, latonya
                                   => 557,
                            latoria
                                   => 2215, latosha
                                   => 1368,
                            latoya => 367, latoyia
                                   => 2863,
                            latrice
                                   => 1033, latricia
                                   => 1310,
                            latrina
                                   => 2098, latrisha
                                   => 2786,
                            launa  => 2600, laura  => 22, lauralee
                                   => 3096,
                            lauran => 3582, laure  => 2437, laureen
                                   => 1378,
                            laurel => 534, lauren => 162, laurena
                                   => 3736,
                            laurene
                                   => 1847, lauretta
                                   => 1138,
                            laurette
                                   => 1537, lauri  => 913,
                            laurice
                                   => 2565, laurie => 191,
                            laurinda
                                   => 2997, laurine
                                   => 2309,
                            lauryn => 2785, lavada => 1784, lavelle
                                   => 3362,
                            lavenia
                                   => 2996, lavera => 2494,
                            laverna
                                   => 2009, laverne
                                   => 444,
                            laveta => 3043, lavette
                                   => 2784,
                            lavina => 1445, lavinia
                                   => 1879,
                            lavon  => 1439, lavona => 2948, lavonda
                                   => 1659,
                            lavone => 3662, lavonia
                                   => 2493,
                            lavonna
                                   => 2820, lavonne
                                   => 801,
                            lawana => 2162, lawanda
                                   => 819,
                            lawanna
                                   => 2599, layla  => 2350,
                            lea    => 645, leah   => 266, lean   => 3214, leana  => 2114, leandra
                                   => 1700,
                            leann  => 695, leanna => 876, leanne => 660, leanora
                                   => 3502,
                            leatha => 1633, leatrice
                                   => 1433,
                            lecia  => 3581, leda   => 1795, leeann => 974, leeanna
                                   => 2492,
                            leeanne
                                   => 2308, leena  => 3042,
                            leesa  => 1771, leia   => 3095, leida  => 3580, leigh  => 430, leigha => 3501,
                            leighann
                                   => 2564, leila  => 684,
                            leilani
                                   => 1339, leisa  => 1373,
                            leisha => 2746, lekisha
                                   => 3213,
                            lela   => 472, lelah  => 3500, lelia  => 898, lena   => 255, lenita => 3661,
                            lenna  => 2187, lennie => 1736, lenora => 519, lenore => 733, leola  => 599,
                            leoma  => 3094, leona  => 277, leonarda
                                   => 2241,
                            leone  => 1338, leonia => 2947, leonida
                                   => 3660,
                            leonie => 2491, leonila
                                   => 2490,
                            leonor => 855, leonora
                                   => 1212,
                            leonore
                                   => 2563, leontine
                                   => 3093,
                            leora  => 1070, leota  => 1147, lera   => 2214, lesa   => 950, lesha  => 3659,
                            lesia  => 2097, leslee => 1725, lesley => 594, lesli  => 1830, leslie => 143,
                            lessie => 866, leta   => 947, letha  => 710, leticia
                                   => 381,
                            letisha
                                   => 2901, letitia
                                   => 942,
                            lettie => 1108, letty  => 2044, lezlie => 2710, liana  => 1724, liane  => 1814,
                            lianne => 2995, libbie => 3282, libby  => 977, liberty
                                   => 2562,
                            librada
                                   => 2709, lida   => 1469,
                            lidia  => 721, lien   => 1971, lieselotte
                                   => 3361,
                            ligia  => 2213, lila   => 457, lili   => 2489, lilia  => 767, lilian => 810,
                            liliana
                                   => 865, lilla  => 2008,
                            lilli  => 3428, lillia => 3360, lilliam
                                   => 3499,
                            lillian
                                   => 98, lilliana
                                   => 3498,
                            lillie => 231, lilly  => 708, lily   => 634, lina   => 808, linda  => 3,
                            lindsay
                                   => 298, lindsey
                                   => 297,
                            lindsy => 3497, lindy  => 1328, linette
                                   => 1674,
                            ling   => 2349, linh   => 1928, linnea => 1503, linnie => 1348, linsey => 1901,
                            lisa   => 11, lisabeth
                                   => 3496,
                            lisandra
                                   => 3212, lisbeth
                                   => 2526,
                            lise   => 1493, lisette
                                   => 1392,
                            lisha  => 2383, lissa  => 1801, lissette
                                   => 1359,
                            lita   => 1681, livia  => 2462, liz    => 912, liza   => 779, lizabeth
                                   => 1492,
                            lizbeth
                                   => 1536, lizeth => 3281,
                            lizette
                                   => 1327, lizzette
                                   => 2745,
                            lizzie => 613, loida  => 2525, lois   => 91, loise  => 3495, lola   => 353,
                            lolita => 925, loma   => 2461, lona   => 1066, londa  => 3092, loni   => 1970,
                            lonna  => 2113, lora   => 413, loraine
                                   => 746,
                            loralee
                                   => 2994, lore   => 2328,
                            lorean => 3658, loree  => 1969, loreen => 1942, lorelei
                                   => 1770,
                            lorena => 454, lorene => 463, lorenza
                                   => 1427,
                            loreta => 2946, loretta
                                   => 188,
                            lorette
                                   => 2993, lori   => 78,
                            loria  => 2992, loriann
                                   => 2561,
                            lorie  => 664, lorilee
                                   => 3735,
                            lorina => 2900, lorinda
                                   => 1621,
                            lorine => 1201, loris  => 2744, lorita => 2862, lorna  => 555, lorraine
                                   => 165,
                            lorretta
                                   => 1713, lorri  => 1119,
                            lorriane
                                   => 2945, lorrie => 772,
                            lorrine
                                   => 3734, lory   => 2560,
                            lottie => 521, lou    => 586, louann => 1207, louanne
                                   => 2382,
                            louella
                                   => 946, louetta
                                   => 3579,
                            louisa => 781, louise => 83, loura  => 3657, lourdes
                                   => 533,
                            lourie => 3733, louvenia
                                   => 2096,
                            lovella
                                   => 2436, lovetta
                                   => 3732,
                            lovie  => 1517, loyce  => 2043, luana  => 1919, luann  => 813, luanna => 3494,
                            luanne => 1200, luba   => 3578, luci   => 2944, lucia  => 469, luciana
                                   => 1829,
                            lucie  => 1432, lucienne
                                   => 1783,
                            lucila => 1211, lucile => 659, lucilla
                                   => 3041,
                            lucille
                                   => 145, lucina => 1983,
                            lucinda
                                   => 512, lucrecia
                                   => 2067,
                            lucretia
                                   => 1083, lucy   => 207,
                            ludie  => 2460, ludivina
                                   => 2991,
                            luella => 649, luetta => 2899, luisa  => 677, luise  => 2524, lula   => 352,
                            lulu   => 1391, lupe   => 584, lupita => 1680, lura   => 1157, lurlene
                                   => 3359,
                            lurline
                                   => 2186, luvenia
                                   => 1968,
                            luz    => 345, lyda   => 1632, lydia  => 241, lyla   => 1846, lynda  => 325,
                            lyndia => 2943, lyndsay
                                   => 1712,
                            lyndsey
                                   => 1404, lynell => 2523,
                            lynelle
                                   => 2411, lynetta
                                   => 2783,
                            lynette
                                   => 426, lynn   => 166,
                            lynna  => 3427, lynne  => 373, lynnette
                                   => 873,
                            lynsey => 2598, mabel  => 252, mabelle
                                   => 2898,
                            mable  => 401, machelle
                                   => 1800,
                            macie  => 2262, mackenzie
                                   => 1533,
                            macy   => 2307, madalene
                                   => 3656,
                            madaline
                                   => 2161, madalyn
                                   => 1982,
                            madelaine
                                   => 3091, madeleine
                                   => 895,
                            madelene
                                   => 2990, madeline
                                   => 326,
                            madelyn
                                   => 858, madge  => 822,
                            madie  => 2021, madlyn => 2559, madonna
                                   => 1112,
                            mae    => 289, maegan => 1918, mafalda
                                   => 3151,
                            magali => 3150, magaly => 2020, magan  => 2410, magaret
                                   => 2488,
                            magda  => 1254, magdalen
                                   => 2708,
                            magdalena
                                   => 679, magdalene
                                   => 1358,
                            magen  => 2459, maggie => 333, magnolia
                                   => 1468,
                            mahalia
                                   => 3655, mai    => 884,
                            maia   => 2597, maida  => 2240, maile  => 2782, maira  => 1941, maire  => 2942,
                            maisha => 3211, maisie => 3426, majorie
                                   => 1232,
                            makeda => 3731, malena => 3730, malia  => 1769, malika => 2239, malinda
                                   => 759,
                            malisa => 2212, malissa
                                   => 1065,
                            malka  => 3210, mallie => 2819, mallory
                                   => 783,
                            malorie
                                   => 2989, malvina
                                   => 3577,
                            mamie  => 351, mammie => 2286, mana   => 2707, manda  => 2261, mandi  => 1153,
                            mandie => 2941, mandy  => 462, manie  => 3358, manuela
                                   => 667,
                            maple  => 2487, mara   => 896, maragaret
                                   => 3357,
                            maragret
                                   => 2897, maranda
                                   => 1417,
                            marcela
                                   => 1190, marcelene
                                   => 3576,
                            marcelina
                                   => 1386, marceline
                                   => 2706,
                            marcell
                                   => 3729, marcella
                                   => 404,
                            marcelle
                                   => 1277, marcene
                                   => 3149,
                            marchelle
                                   => 3280, marci  => 854,
                            marcia => 234, marcie => 778, marcy  => 676, mardell
                                   => 3493,
                            maren  => 2211, marg   => 3425, margaret
                                   => 9,
                            margareta
                                   => 2596, margarete
                                   => 1658,
                            margarett
                                   => 1953, margaretta
                                   => 2327,
                            margarette
                                   => 1483, margarita
                                   => 302,
                            margarite
                                   => 1981, margart
                                   => 2348,
                            marge  => 1180, margene
                                   => 3090,
                            margeret
                                   => 2160, margert
                                   => 2743,
                            margery
                                   => 793, marget => 2705,
                            margherita
                                   => 2940, margie => 263,
                            margit => 2140, margo  => 654, margorie
                                   => 2326,
                            margot => 972, margret
                                   => 650,
                            margrett
                                   => 3356, marguerita
                                   => 2558,
                            marguerite
                                   => 310, margurite
                                   => 2066,
                            margy  => 3654, marhta => 3279, mari   => 828, maria  => 7, mariah => 1241,
                            mariam => 1297, marian => 244, mariana
                                   => 890,
                            marianela
                                   => 3492, mariann
                                   => 1372,
                            marianna
                                   => 1059, marianne
                                   => 375,
                            maribel
                                   => 587, maribeth
                                   => 1599,
                            marica => 2861, maricela
                                   => 792,
                            maricruz
                                   => 3575, marie  => 44,
                            mariel => 2210, mariela
                                   => 1828,
                            mariella
                                   => 3491, marielle
                                   => 3490,
                            marietta
                                   => 853, mariette
                                   => 2988,
                            mariko => 2742, marilee
                                   => 1416,
                            marilou
                                   => 1845, marilu => 2671,
                            marilyn
                                   => 80, marilynn
                                   => 1082,
                            marina => 487, marinda
                                   => 2741,
                            marion => 177, marisa => 623, marisela
                                   => 1069,
                            marisha
                                   => 2987, marisol
                                   => 628,
                            marissa
                                   => 529, marita => 1420,
                            maritza
                                   => 658, marivel
                                   => 2781,
                            marjorie
                                   => 128, marjory
                                   => 1189,
                            marketta
                                   => 3574, markita
                                   => 2306,
                            marla  => 492, marlana
                                   => 2557,
                            marleen
                                   => 2185, marlen => 2704,
                            marlena
                                   => 1199, marlene
                                   => 238,
                            marline
                                   => 2860, marlo  => 1569,
                            marlyn => 1270, marlys => 1226, marna  => 2159, marni  => 2209, marnie => 1390,
                            marquerite
                                   => 1482, marquetta
                                   => 2347,
                            marquita
                                   => 917, marquitta
                                   => 3278,
                            marsha => 253, marta  => 470, marth  => 3089, martha => 38, marti  => 1558,
                            martina
                                   => 653, martine
                                   => 1782,
                            marva  => 851, marvel => 1535, marvella
                                   => 3277,
                            marvis => 3040, mary   => 1, marya  => 2458, maryalice
                                   => 2633,
                            maryam => 2457, maryann
                                   => 340,
                            maryanna
                                   => 2896, maryanne
                                   => 815,
                            marybelle
                                   => 3355, marybeth
                                   => 1008,
                            maryellen
                                   => 911, maryetta
                                   => 3728,
                            maryjane
                                   => 1048, maryjo => 1673,
                            marylee
                                   => 1813, marylin
                                   => 1438,
                            maryln => 3727, marylou
                                   => 735,
                            marylouise
                                   => 3088, marylyn
                                   => 1864,
                            marylynn
                                   => 2986, maryrose
                                   => 3148,
                            masako => 1967, matha  => 3573, mathilda
                                   => 1900,
                            mathilde
                                   => 2595, matilda
                                   => 683,
                            matilde
                                   => 1111, mattie => 249,
                            maud   => 1326, maude  => 551, maudie => 1038, maura  => 883, maureen
                                   => 224,
                            maurine
                                   => 1032, maurita
                                   => 3726,
                            mavis  => 655, maxie  => 1516, maxima => 3572, maximina
                                   => 3424,
                            maxine => 250, maya   => 1102, maybell
                                   => 2556,
                            maybelle
                                   => 1477, maye   => 2486,
                            mayme  => 1127, mayola => 3087, mayra  => 617, mazie  => 1588, meagan => 681,
                            meaghan
                                   => 1357, mechelle
                                   => 1699,
                            meda   => 3571, megan  => 151, meggan => 2703, meghan => 431, meghann
                                   => 2260,
                            melaine
                                   => 2702, melani => 2985,
                            melania
                                   => 3423, melanie
                                   => 187,
                            melany => 2435, melba  => 480, melda  => 2818, melia  => 3209, melida => 2984,
                            melina => 1481, melinda
                                   => 221,
                            melisa => 736, melissa
                                   => 30,
                            melissia
                                   => 2632, melita => 2983,
                            mellie => 2485, mellisa
                                   => 982,
                            mellissa
                                   => 1130, melodee
                                   => 3039,
                            melodi => 3570, melodie
                                   => 1156,
                            melody => 344, melonie
                                   => 1587,
                            melony => 1544, melva  => 818, melvina
                                   => 1303,
                            melynda
                                   => 2434, mendy  => 2780,
                            mercedes
                                   => 424, mercedez
                                   => 3147,
                            mercy  => 1575, meredith
                                   => 425,
                            meri   => 2555, merideth
                                   => 3276,
                            meridith
                                   => 2484, merilyn
                                   => 2184,
                            merissa
                                   => 3725, merlene
                                   => 2139,
                            merlyn => 3086, merna  => 2325, merri  => 2138, merrie => 2740, merrilee
                                   => 3038,
                            merry  => 1092, mertie => 3653, meryl  => 1760, meta   => 1543, mia    => 719,
                            mica   => 2779, micaela
                                   => 1223,
                            micha  => 3724, michaela
                                   => 1002,
                            michaele
                                   => 3208, michele
                                   => 154,
                            michelina
                                   => 3146, micheline
                                   => 2324,
                            michell
                                   => 962, michelle
                                   => 21,
                            michiko
                                   => 2080, micki  => 2112,
                            mickie => 1917, miesha => 3275, migdalia
                                   => 1073,
                            mignon => 2778, miguelina
                                   => 2554,
                            mika   => 2701, mikaela
                                   => 3422,
                            miki   => 2859, mikki  => 2111, mila   => 2007, milagro
                                   => 2522,
                            milagros
                                   => 748, milda  => 2895,
                            mildred
                                   => 60, milissa
                                   => 1598,
                            millicent
                                   => 907, millie => 636,
                            milly  => 3354, mimi   => 1215, mina   => 981, minda  => 2777, mindi  => 1620,
                            mindy  => 460, minerva
                                   => 707,
                            ming   => 3037, minna  => 2409, minnie => 237, minta  => 3652, mira   => 1781,
                            miranda
                                   => 467, mireille
                                   => 2631,
                            mirella
                                   => 2894, mireya => 1426,
                            miriam => 281, mirian => 1542, mirna  => 1160, mirta  => 1609, mirtha => 2670,
                            misha  => 2858, missy  => 1170, misti  => 1219, mistie => 3723, misty  => 288,
                            mitsue => 3651, mitsuko
                                   => 2893,
                            mittie => 1451, mitzi  => 827, mitzie => 2776, miyoko => 3274, modesta
                                   => 1679,
                            moira  => 1711, mollie => 583, molly  => 313, mona   => 414, monet  => 3207,
                            monica => 131, monika => 967, monique
                                   => 330,
                            monnie => 3206, monserrate
                                   => 2433,
                            moriah => 2982, mozell => 1863, mozella
                                   => 2381,
                            mozelle
                                   => 1240, muoi   => 3145,
                            muriel => 403, myesha => 3650, myong  => 1780, myra   => 380, myriam => 1491,
                            myrl   => 3273, myrle  => 2380, myrna  => 491, myrta  => 3649, myrtice
                                   => 1812,
                            myrtie => 2238, myrtis => 1309, myrtle => 254, myung  => 2379, nada   => 1710,
                            nadene => 3144, nadia  => 821, nadine => 408, naida  => 3648, nakesha
                                   => 3353,
                            nakia  => 1198, nakisha
                                   => 1940,
                            nakita => 2285, nana   => 2408, nancee => 3569, nancey => 3272, nanci  => 1415,
                            nancie => 2432, nancy  => 12, nanette
                                   => 799,
                            nannette
                                   => 1515, nannie => 744,
                            naoma  => 2158, naomi  => 270, narcisa
                                   => 2553,
                            natacha
                                   => 3271, natalia
                                   => 871,
                            natalie
                                   => 215, natalya
                                   => 3568,
                            natasha
                                   => 307, natashia
                                   => 2739,
                            nathalie
                                   => 1276, natisha
                                   => 3036,
                            natividad
                                   => 1347, natosha
                                   => 2284,
                            necole => 3647, neda   => 2892, nedra  => 1317, neida  => 3722, nelda  => 706,
                            nelia  => 2095, nelida => 1844, nell   => 570, nella  => 1723, nelle  => 1619,
                            nellie => 236, nelly  => 964, nena   => 1514, nenita => 3035, neoma  => 1980,
                            neomi  => 3421, nereida
                                   => 1269,
                            nerissa
                                   => 2483, nery   => 2981,
                            neta   => 2110, nettie => 482, neva   => 734, nevada => 3085, ngan   => 3352,
                            ngoc   => 2094, nguyet => 3420, nichelle
                                   => 1916,
                            nichol => 1939, nichole
                                   => 398,
                            nicholle
                                   => 3646, nicki  => 1231,
                            nickie => 1999, nickole
                                   => 2378,
                            nicol  => 2431, nicola => 1403, nicolasa
                                   => 1938,
                            nicole => 68, nicolette
                                   => 1672,
                            nicolle
                                   => 2042, nida   => 3084,
                            nidia  => 1568, niesha => 3083, niki   => 1325, nikia  => 2157, nikita => 1224,
                            nikki  => 524, nikole => 1979, nila   => 1476, nilda  => 1051, nilsa  => 1759,
                            nina   => 264, ninfa  => 1794, nisha  => 3082, nita   => 785, nobuko => 3419,
                            noelia => 1631, noella => 1998, noelle => 941, noemi  => 777, nohemi => 2980,
                            nola   => 700, noma   => 2630, nona   => 826, nora   => 262, norah  => 2629,
                            noreen => 760, norene => 1574, noriko => 2738, norine => 1722, norma  => 94,
                            nova   => 1480, novella
                                   => 1475,
                            nubia  => 3489, nydia  => 1532, nyla   => 2456, obdulia
                                   => 2700,
                            ocie   => 1735, octavia
                                   => 957,
                            odelia => 2775, odessa => 743, odette => 1768, odilia => 2407, ofelia => 680,
                            ola    => 581, olene  => 2939, oleta  => 1261, olevia => 3645, olga   => 273,
                            olimpia
                                   => 2774, olinda => 3143,
                            oliva  => 1862, olive  => 445, olivia => 347, ollie  => 484, olympia
                                   => 2079,
                            omega  => 2699, oneida => 2183, onie   => 3488, onita  => 3081, opal   => 341,
                            ophelia
                                   => 824, ora    => 481,
                            oralee => 3351, oralia => 1110, oretha => 3350, orpha  => 1534, ossie  => 2041,
                            otelia => 3644, otilia => 1741, ouida  => 1758, ozell  => 3721, ozella => 2669,
                            ozie   => 3349, paige  => 596, palma  => 1799, palmira
                                   => 3080,
                            pam    => 360, pamala => 1001, pamela => 37, pamelia
                                   => 2137,
                            pamella
                                   => 2208, pamila => 3720,
                            pamula => 3205, pandora
                                   => 2628,
                            pansy  => 939, paola  => 1793, parthenia
                                   => 3204,
                            particia
                                   => 1966, pasty  => 3487,
                            pat    => 382, patience
                                   => 1997,
                            patria => 2773, patrica
                                   => 573,
                            patrice
                                   => 496, patricia
                                   => 2,
                            patrina
                                   => 2040, patsy  => 258,
                            patti  => 453, pattie => 1079, patty  => 368, paula  => 95, paulene
                                   => 2857,
                            pauletta
                                   => 2283, paulette
                                   => 412,
                            paulina
                                   => 1146, pauline
                                   => 133,
                            paulita
                                   => 3418, pearl  => 222,
                            pearle => 2039, pearlene
                                   => 2323,
                            pearlie
                                   => 757, pearline
                                   => 1188,
                            pearly => 3079, peggie => 1474, peggy  => 101, penelope
                                   => 747,
                            penney => 2455, penni  => 2627, pennie => 1531, penny  => 267, perla  => 1236,
                            petra  => 603, petrina
                                   => 2377,
                            petronila
                                   => 3270, phebe  => 3417,
                            phillis
                                   => 1118, philomena
                                   => 1210,
                            phung  => 3269, phuong => 1409, phylicia
                                   => 2772,
                            phylis => 1408, phyliss
                                   => 1450,
                            phyllis
                                   => 93, piedad => 2668,
                            pilar  => 1141, ping   => 3348, pinkie => 1843, polly  => 564, porsche
                                   => 3347,
                            porsha => 2322, portia => 1091, precious
                                   => 1316,
                            pricilla
                                   => 1173, princess
                                   => 1260,
                            priscila
                                   => 3142, priscilla
                                   => 269,
                            providencia
                                   => 2856, prudence
                                   => 1530,
                            pura   => 3034, qiana  => 2305, queenie
                                   => 1952,
                            quiana => 2136, quyen  => 3078, rachael
                                   => 399,
                            rachal => 3203, racheal
                                   => 1060,
                            rachel => 79, rachele
                                   => 2207,
                            rachell
                                   => 2078, rachelle
                                   => 598,
                            racquel
                                   => 1779, rae    => 727,
                            raeann => 2406, raelene
                                   => 3268,
                            rafaela
                                   => 1101, raguel => 2771,
                            raina  => 2093, raisa  => 2891, ramona => 292, ramonita
                                   => 2065,
                            rana   => 1978, ranae  => 2521, randa  => 1842, randee => 2520, randi  => 689,
                            ranee  => 3077, raquel => 437, rasheeda
                                   => 2698,
                            rashida
                                   => 1757, raven  => 1268,
                            raye   => 2346, raylene
                                   => 2626,
                            raymonde
                                   => 3719, rayna  => 2064,
                            reanna => 3267, reatha => 2345, reba   => 516, rebbeca
                                   => 2282,
                            rebbecca
                                   => 2237, rebeca => 1007,
                            rebecca
                                   => 34, rebecka
                                   => 2855,
                            rebekah
                                   => 511, reda   => 2625,
                            reena  => 3346, refugia
                                   => 2938,
                            regena => 2092, regenia
                                   => 2304,
                            regina => 168, regine => 3643, reginia
                                   => 3202,
                            reiko  => 2697, reina  => 1137, reita  => 3416, rema   => 3345, remedios
                                   => 2376,
                            remona => 3266, rena   => 490, renae  => 985, renata => 1290, renate => 1289,
                            renay  => 3344, renda  => 3415, renea  => 1756, renee  => 181, renetta
                                   => 2696,
                            renita => 1115, renna  => 3567, ressie => 2937, reta   => 1136, retha  => 1023,
                            retta  => 1996, reva   => 836, reyna  => 928, reynalda
                                   => 2770,
                            rhea   => 916, rheba  => 3566, rhiannon
                                   => 1551,
                            rhoda  => 697, rhona  => 2737, rhonda => 137, ricarda
                                   => 3486,
                            richelle
                                   => 1259, ricki  => 2817,
                            rikki  => 1965, rima   => 3565, rina   => 1597, risa   => 1964, rita   => 104,
                            riva   => 3201, rivka  => 3033, robbi  => 3076, robbin => 1046, robbyn => 3414,
                            robena => 3718, roberta
                                   => 184,
                            robin  => 100, robyn  => 386, rochel => 3032, rochell
                                   => 2594,
                            rochelle
                                   => 434, rocio  => 993,
                            rolanda
                                   => 1644, rolande
                                   => 3642,
                            roma   => 1258, romaine
                                   => 2321,
                            romana => 1899, romelia
                                   => 2077,
                            romona => 1214, rona   => 1414, ronda  => 497, roni   => 1951, ronna  => 1573,
                            ronni  => 2236, rosa   => 112, rosalba
                                   => 1288,
                            rosalee
                                   => 1031, rosalia
                                   => 1005,
                            rosalie
                                   => 388, rosalina
                                   => 1285,
                            rosalind
                                   => 624, rosalinda
                                   => 766,
                            rosaline
                                   => 1827, rosalva
                                   => 1630,
                            rosalyn
                                   => 715, rosamaria
                                   => 3141,
                            rosamond
                                   => 2091, rosana => 2303,
                            rosann => 2344, rosanna
                                   => 886,
                            rosanne
                                   => 847, rosaria
                                   => 1811,
                            rosario
                                   => 580, rosaura
                                   => 1692,
                            rose   => 65, roseann
                                   => 833,
                            roseanna
                                   => 1467, roseanne
                                   => 1169,
                            roselee
                                   => 3265, roselia
                                   => 3343,
                            roseline
                                   => 2816, rosella
                                   => 872,
                            roselle
                                   => 2769, roselyn
                                   => 1302,
                            rosemarie
                                   => 416, rosemary
                                   => 203,
                            rosena => 3564, rosenda
                                   => 3717,
                            rosetta
                                   => 561, rosette
                                   => 3641,
                            rosia  => 2405, rosie  => 319, rosina => 1371, rosio  => 3342, rosita => 1058,
                            roslyn => 797, rossana
                                   => 2979,
                            rossie => 3563, rosy   => 3075, rowena => 927, roxana => 1172, roxane => 1466,
                            roxann => 1222, roxanna
                                   => 1126,
                            roxanne
                                   => 384, roxie  => 796,
                            rozanne
                                   => 3264, rozella
                                   => 2519,
                            rubi   => 3200, rubie  => 1950, ruby   => 90, rubye  => 1385, rufina => 1861,
                            ruth   => 19, rutha  => 2736, ruthann
                                   => 1356,
                            ruthanne
                                   => 3031, ruthe  => 3074,
                            ruthie => 705, ryann  => 3199, sabina => 1275, sabine => 1898, sabra  => 1778,
                            sabrina
                                   => 308, sacha  => 2854,
                            sachiko
                                   => 2206, sade   => 1608,
                            sadie  => 392, sadye  => 3030, salena => 2235, salina => 1550, sallie => 517,
                            sally  => 167, salome => 2090, samantha
                                   => 176,
                            samara => 2205, samatha
                                   => 1109,
                            samella
                                   => 3413, samira => 2624,
                            sana   => 3640, sanda  => 3073, sandee => 3140, sandi  => 1100, sandie => 2768,
                            sandra => 16, sandy  => 318, sanjuana
                                   => 1419,
                            sanjuanita
                                   => 1413, sanora => 2593,
                            santa  => 1155, santina
                                   => 2404,
                            sara   => 84, sarah  => 23, sarai  => 3639, saran  => 3638, sari   => 2281,
                            sarina => 2182, sarita => 1596, sasha  => 857, saturnina
                                   => 3485,
                            saundra
                                   => 762, savanna
                                   => 2403,
                            savannah
                                   => 868, scarlet
                                   => 2402,
                            scarlett
                                   => 1389, sebrina
                                   => 2623,
                            seema  => 3716, selena => 786, selene => 2302, selina => 997, selma  => 669,
                            sena   => 3198, senaida
                                   => 3412,
                            serafina
                                   => 3139, serena => 738,
                            serina => 2063, serita => 2936, setsuko
                                   => 3138,
                            shae   => 3137, shaina => 1502, shakia => 3029, shakira
                                   => 2204,
                            shakita
                                   => 3197, shala  => 2978,
                            shalanda
                                   => 2935, shalon => 3341,
                            shalonda
                                   => 1557, shameka
                                   => 1364,
                            shamika
                                   => 1513, shan   => 3411,
                            shana  => 615, shanae => 2890, shanda => 1117, shandi => 3637, shandra
                                   => 1841,
                            shaneka
                                   => 2135, shanel => 3340,
                            shanell
                                   => 1798, shanelle
                                   => 2482,
                            shani  => 1840, shanice
                                   => 2109,
                            shanika
                                   => 1586, shaniqua
                                   => 3136,
                            shanita
                                   => 1839, shanna => 575,
                            shannan
                                   => 1698, shannon
                                   => 123,
                            shanon => 1250, shanta => 1367, shantae
                                   => 3636,
                            shantay
                                   => 3263, shante => 1384,
                            shantel
                                   => 1282, shantell
                                   => 1777,
                            shantelle
                                   => 2853, shanti => 3410,
                            shaquana
                                   => 3262, shaquita
                                   => 2977,
                            shara  => 1449, sharan => 3135, sharda => 3196, sharee => 1878, sharell
                                   => 3715,
                            sharen => 1877, shari  => 474, sharice
                                   => 3339,
                            sharie => 2889, sharika
                                   => 3562,
                            sharilyn
                                   => 3261, sharita
                                   => 1977,
                            sharla => 1355, sharleen
                                   => 2481,
                            sharlene
                                   => 949, sharmaine
                                   => 3635,
                            sharolyn
                                   => 3260, sharon => 20,
                            sharonda
                                   => 1281, sharri => 2767,
                            sharron
                                   => 726, sharyl => 2375,
                            sharyn => 1323, shasta => 1838, shauna => 635, shaunda
                                   => 2815,
                            shaunna
                                   => 2518, shaunta
                                   => 3134,
                            shaunte
                                   => 3195, shavon => 2062,
                            shavonda
                                   => 3194, shavonne
                                   => 2592,
                            shawana
                                   => 2517, shawanda
                                   => 1897,
                            shawanna
                                   => 3259, shawna => 477,
                            shawnda
                                   => 2156, shawnee
                                   => 2134,
                            shawnna
                                   => 2516, shawnta
                                   => 3484,
                            shay   => 1896, shayla => 1107, shayna => 1444, sheba  => 3338, sheena => 631,
                            sheila => 124, sheilah
                                   => 2591,
                            shela  => 2480, shelba => 2155, shelby => 505, shelia => 369, shella => 2852,
                            shelley
                                   => 349, shelli => 1239,
                            shellie
                                   => 1068, shelly => 290,
                            shemeka
                                   => 2814, shemika
                                   => 2401,
                            shena  => 1927, shenika
                                   => 3258,
                            shenita
                                   => 2667, shenna => 3634,
                            shera  => 2976, sheree => 839, sherell
                                   => 3193,
                            sheri  => 374, sherice
                                   => 3561,
                            sherie => 1431, sherika
                                   => 2813,
                            sherill
                                   => 3072, sherilyn
                                   => 1895,
                            sherise
                                   => 3071, sherita
                                   => 1490,
                            sherlene
                                   => 3560, sherley
                                   => 2374,
                            sherly => 2373, sherlyn
                                   => 2552,
                            sheron => 1837, sherrell
                                   => 2280,
                            sherri => 293, sherrie
                                   => 498,
                            sherril
                                   => 3409, sherrill
                                   => 1448,
                            sherron
                                   => 1767, sherry => 119,
                            sherryl
                                   => 1567, shery  => 2695,
                            sheryl => 303, sheryll
                                   => 2888,
                            shiela => 1090, shila  => 3133, shiloh => 3633, shira  => 2430, shirely
                                   => 2851,
                            shirl  => 2850, shirlee
                                   => 1585,
                            shirleen
                                   => 2666, shirlene
                                   => 1363,
                            shirley
                                   => 27, shirly => 1691,
                            shizue => 3257, shizuko
                                   => 3559,
                            shona  => 2089, shonda => 1042, shondra
                                   => 3558,
                            shonna => 2181, shonta => 2975, shoshana
                                   => 2479,
                            shyla  => 2974, sibyl  => 1697, sierra => 961, signe  => 2234, sigrid => 1671,
                            silvana
                                   => 2622, silvia => 448,
                            sima   => 2973, simona => 1937, simone => 687, simonne
                                   => 2934,
                            sina   => 3557, sindy  => 2259, siobhan
                                   => 1755,
                            sirena => 3408, sixta  => 3714, slyvia => 2343, socorro
                                   => 652,
                            sofia  => 741, soila  => 3632, solange
                                   => 2590,
                            soledad
                                   => 1072, somer  => 3337,
                            sommer => 2038, sona   => 3556, sondra => 621, sonia  => 280, sonja  => 456,
                            sonya  => 335, sook   => 2342, sophia => 432, sophie => 451, soraya => 2478,
                            sparkle
                                   => 3336, stacee => 3483,
                            stacey => 210, staci  => 644, stacia => 1221, stacie => 502, stacy  => 179,
                            starla => 1407, stasia => 3070, stefani
                                   => 1797,
                            stefania
                                   => 2429, stefanie
                                   => 579,
                            stefany
                                   => 3256, steffanie
                                   => 2258,
                            stella => 245, stepanie
                                   => 3132,
                            stephaine
                                   => 1584, stephane
                                   => 2019,
                            stephani
                                   => 1618, stephania
                                   => 2972,
                            stephanie
                                   => 41, stephany
                                   => 1253,
                            stephenie
                                   => 1274, stephine
                                   => 1721,
                            stephnie
                                   => 3555, stormy => 1936,
                            suanne => 3713, sudie  => 2233, sue    => 196, sueann => 2477, suellen
                                   => 2076,
                            sulema => 3335, sumiko => 3334, sunni  => 3712, sunny  => 1337, sunshine
                                   => 1796,
                            susan  => 8, susana => 590, susann => 1894, susanna
                                   => 835,
                            susannah
                                   => 1549, susanne
                                   => 588,
                            susie  => 346, susy   => 2735, suzan  => 1106, suzann => 2006, suzanna
                                   => 1265,
                            suzanne
                                   => 153, suzette
                                   => 804,
                            suzi   => 3192, suzie  => 1776, suzy   => 1629, svetlana
                                   => 2812,
                            sybil  => 671, syble  => 1566, sylvia => 120, sylvie => 2849, synthia
                                   => 2341,
                            syreeta
                                   => 2454, tabatha
                                   => 737,
                            tabetha
                                   => 2279, tabitha
                                   => 483,
                            taina  => 3554, taisha => 2734, tajuana
                                   => 3553,
                            takako => 3711, takisha
                                   => 2257,
                            talia  => 1657, talisha
                                   => 2400,
                            talitha
                                   => 2694, tama   => 3131,
                            tamala => 2180, tamar  => 1754, tamara => 227, tamatha
                                   => 1915,
                            tambra => 3130, tameika
                                   => 2665,
                            tameka => 761, tamekia
                                   => 2340,
                            tamela => 1159, tamera => 920, tamesha
                                   => 2621,
                            tami   => 476, tamica => 2301, tamie  => 1926, tamika => 560, tamiko => 1860,
                            tamisha
                                   => 2733, tammara
                                   => 2278,
                            tammera
                                   => 3028, tammi  => 803,
                            tammie => 493, tammy  => 75, tamra  => 879, tana   => 1145, tandra => 3710,
                            tandy  => 3129, taneka => 2933, tanesha
                                   => 1617,
                            tangela
                                   => 1720, tania  => 753,
                            tanika => 1655, tanisha
                                   => 787,
                            tanja  => 1949, tanna  => 2232, tanya  => 235, tara   => 202, tarah  => 2061,
                            taren  => 3482, tari   => 3027, tarra  => 3026, tarsha => 1836, taryn  => 1035,
                            tasha  => 447, tashia => 2693, tashina
                                   => 3128,
                            tasia  => 2848, tatiana
                                   => 1206,
                            tatyana
                                   => 3069, taunya => 3709,
                            tawana => 1095, tawanda
                                   => 1455,
                            tawanna
                                   => 1607, tawna  => 3552,
                            tawny  => 2203, tawnya => 1489, tayna  => 3708, teena  => 1529, tegan  => 3631,
                            teisha => 3481, telma  => 3480, temeka => 2664, temika => 3479, tempie => 3333,
                            tena   => 1273, tenesha
                                   => 3551,
                            tenisha
                                   => 1893, tennie => 2372,
                            tennille
                                   => 2300, teodora
                                   => 1925,
                            teofila
                                   => 3707, tequila
                                   => 2663,
                            tera   => 1081, tereasa
                                   => 2589,
                            teresa => 54, terese => 1388, teresia
                                   => 3191,
                            teresita
                                   => 1045, teressa
                                   => 1383,
                            teri   => 427, terica => 3550, terina => 3190, terisa => 2932, terra  => 954,
                            terresa
                                   => 2231, terri  => 205,
                            terrie => 709, terrilyn
                                   => 3549,
                            tesha  => 2551, tessa  => 849, tessie => 1080, thalia => 2108, thao   => 2399,
                            thea   => 1280, theda  => 1296, thelma => 122, theodora
                                   => 1044,
                            theola => 2692, theresa
                                   => 72,
                            therese
                                   => 553, theresia
                                   => 2202,
                            theressa
                                   => 2971, thersa => 1859,
                            thomasena
                                   => 3630, thomasina
                                   => 1696,
                            thomasine
                                   => 2371, thora  => 2811,
                            thresa => 1995, thuy   => 1454, tia    => 725, tiana  => 1257, tianna => 2428,
                            tiara  => 1168, tien   => 3407, tiera  => 2970, tierra => 1541, tiesha => 2256,
                            tifany => 3255, tiffaney
                                   => 2887,
                            tiffani
                                   => 1144, tiffanie
                                   => 1457,
                            tiffany
                                   => 110, tiffiny
                                   => 1935,
                            tijuana
                                   => 3189, tilda  => 3406,
                            tillie => 1025, timika => 3478, tina   => 92, tinisha
                                   => 2931,
                            tisa   => 3706, tish   => 3629, tisha  => 919, tobi   => 2847, tobie  => 3332,
                            toccara
                                   => 3628, tomasa => 1152,
                            tomeka => 1556, tomi   => 2766, tomika => 1976, tomiko => 2732, tommye => 3025,
                            tomoko => 2398, tona   => 2930, tonda  => 2476, tonette
                                   => 3477,
                            toni   => 287, tonia  => 626, tonie  => 2255, tonisha
                                   => 3405,
                            tonita => 3705, tonja  => 1218, tonya  => 208, tora   => 3548, tori   => 956,
                            torie  => 3404, torri  => 3068, torrie => 3127, tosha  => 1267, toshia => 3254,
                            toshiko
                                   => 2691, tova   => 3403,
                            towanda
                                   => 2550, toya   => 1488,
                            tracee => 1914, tracey => 276, traci  => 394, tracie => 528, tracy  => 108,
                            trang  => 2549, treasa => 2886, treena => 3627, trena  => 1362, tresa  => 1473,
                            tressa => 1443, tressie
                                   => 1678,
                            treva  => 1028, tricia => 443, trina  => 515, trinh  => 2810, trinity
                                   => 2179,
                            trish  => 1583, trisha => 523, trista => 1246, trudi  => 2037, trudie => 2018,
                            trudy  => 571, trula  => 2588, tula   => 3476, tuyet  => 2453, twana  => 2060,
                            twanda => 3024, twanna => 2731, twila  => 929, twyla  => 1315, tyesha => 2254,
                            tyisha => 3402, tynisha
                                   => 3626,
                            tyra   => 1295, ulrike => 3253, ursula => 612, usha   => 2690, vada   => 1186,
                            valarie
                                   => 713, valda  => 2178,
                            valene => 3023, valentina
                                   => 1252,
                            valeri => 3067, valeria
                                   => 825,
                            valerie
                                   => 149, valery => 2475,
                            vallie => 2017, valorie
                                   => 1334,
                            valrie => 2929, vanda  => 2427, vanesa => 2154, vanessa
                                   => 194,
                            vanetta
                                   => 3126, vania  => 3252,
                            vanita => 2452, vanna  => 3401, vannesa
                                   => 3331,
                            vannessa
                                   => 1994, vashti => 2885,
                            vasiliki
                                   => 3704, veda   => 1078,
                            velda  => 1225, velia  => 1654, vella  => 2548, velma  => 282, velva  => 1606,
                            velvet => 2107, vena   => 2201, venessa
                                   => 1284,
                            venetta
                                   => 3475, venice => 2253,
                            venita => 1361, vennie => 3400, venus  => 1162, veola  => 2689, vera   => 217,
                            verda  => 1096, verdell
                                   => 2397,
                            verdie => 2515, verena => 2514, vergie => 1512, verla  => 1301, verlene
                                   => 2620,
                            verlie => 2619, verline
                                   => 3703,
                            verna  => 354, vernell
                                   => 1151,
                            vernetta
                                   => 2036, vernia => 3547,
                            vernice
                                   => 1089, vernie => 1826,
                            vernita
                                   => 1753, verona => 1695,
                            veronica
                                   => 158, veronika
                                   => 3702,
                            veronique
                                   => 3330, versie => 2153,
                            vertie => 3066, vesta  => 1114, veta   => 2662, vicenta
                                   => 1719,
                            vickey => 1382, vicki  => 200, vickie => 248, vicky  => 372, victoria
                                   => 116,
                            victorina
                                   => 3625, vida   => 1057,
                            vikki  => 1300, vilma  => 870, vina   => 1718, vincenza
                                   => 1948,
                            vinita => 3624, vinnie => 2075, viola  => 242, violet => 285, violeta
                                   => 1308,
                            violette
                                   => 1993, virgen => 3022,
                            virgie => 690, virgina
                                   => 1022,
                            virginia
                                   => 35, vita   => 1582,
                            viva   => 1825, vivan  => 2230, vivian => 183, viviana
                                   => 1314,
                            vivien => 2035, vivienne
                                   => 2016,
                            voncile
                                   => 3474, vonda  => 938,
                            vonnie => 1824, waltraud
                                   => 2661,
                            wanda  => 87, waneta => 2765, wanetta
                                   => 3701,
                            wanita => 1690, wava   => 3125, wendi  => 848, wendie => 3329, wendolyn
                                   => 3188,
                            wendy  => 115, wenona => 3328, whitney
                                   => 363,
                            wilda  => 881, wilhelmina
                                   => 1030,
                            wilhemina
                                   => 3700, willa  => 666,
                            willena
                                   => 3546, willene
                                   => 1913,
                            willetta
                                   => 3473, willette
                                   => 2451,
                            willia => 2277, williemae
                                   => 2809,
                            willodean
                                   => 3399, wilma  => 211,
                            windy  => 1370, winifred
                                   => 485,
                            winnie => 675, winnifred
                                   => 1354,
                            winona => 1056, wonda  => 2660, wynell => 3545, wynona => 1835, xenia  => 3124,
                            xiao   => 3398, xiomara
                                   => 1511,
                            xochitl
                                   => 2730, xuan   => 3187,
                            yadira => 1235, yaeko  => 3544, yael   => 3472, yahaira
                                   => 3186,
                            yajaira
                                   => 3251, yanira => 2426,
                            yasmin => 1528, yasmine
                                   => 2884,
                            yasuko => 2928, yelena => 3185, yesenia
                                   => 820,
                            yessenia
                                   => 2846, yetta  => 1694,
                            yevette
                                   => 3471, ying   => 1947,
                            yoko   => 1892, yolanda
                                   => 189,
                            yolande
                                   => 2034, yolando
                                   => 2659,
                            yolonda
                                   => 1527, yoshie => 3470,
                            yoshiko
                                   => 1548, youlanda
                                   => 3184,
                            yuette => 3623, yuki   => 3469, yukiko => 2658, yuko   => 2547, yulanda
                                   => 2845,
                            yung   => 2808, yuonne => 3397, yuri   => 2764, yuriko => 3543, yvette => 343,
                            yvone  => 3468, yvonne => 174, zada   => 3396, zaida  => 1823, zana   => 3699,
                            zandra => 1891, zelda  => 986, zella  => 1099, zelma  => 758, zena   => 1653,
                            zenaida
                                   => 1183, zenia  => 3542,
                            zenobia
                                   => 1876, zetta  => 3183,
                            zina   => 1652, zita   => 2033, zofia  => 2370, zoila  => 1135, zola   => 1510,
                            zona   => 1565, zonia  => 3541, zora   => 1581, zoraida
                                   => 1402,
                            zula   => 1709, zulema => 1992, zulma  => 1890
                          },
  english_male_names   => {
                            aaron  => 77, abdul  => 697, abe    => 715,
                            abel   => 427, abraham
                                   => 312,
                            abram  => 883, adalberto
                                   => 875,
                            adam   => 69, adan   => 642, adolfo => 496, adolph => 559, adrian => 214,
                            agustin
                                   => 493, ahmad  => 742,
                            ahmed  => 837, alan   => 89, albert => 54, alberto
                                   => 250,
                            alden  => 746, aldo   => 711, alec   => 782, alejandro
                                   => 277,
                            alex   => 151, alfonso
                                   => 298,
                            alfonzo
                                   => 766, alfred => 121,
                            alfredo
                                   => 249, ali    => 536,
                            allan  => 234, alonso => 1006, alonzo => 394, alphonse
                                   => 692,
                            alphonso
                                   => 567, alton  => 324,
                            alva   => 669, alvaro => 540, alvin  => 163, amado  => 809, ambrose
                                   => 919,
                            amos   => 412, andre  => 207, andreas
                                   => 930,
                            andres => 315, andrew => 35, andy   => 262, angel  => 197, angelo => 294,
                            anibal => 805, anthony
                                   => 22,
                            antione
                                   => 962, antoine
                                   => 468,
                            anton  => 515, antone => 829, antonio
                                   => 98,
                            antony => 667, antwan => 745, archie => 325, arden  => 905, ariel  => 696,
                            arlen  => 946, arlie  => 986, armand => 539, armando
                                   => 240,
                            arnoldo
                                   => 978, arnulfo
                                   => 705,
                            aron   => 724, arron  => 666, arthur => 48, arturo => 276, aubrey => 433,
                            augustine
                                   => 679, augustus
                                   => 795,
                            aurelio
                                   => 628, avery  => 556,
                            barney => 604, barry  => 136, bart   => 499, basil  => 576, beau   => 610,
                            ben    => 203, benedict
                                   => 940,
                            benito => 486, benjamin
                                   => 66,
                            bennie => 333, benny  => 341, bernard
                                   => 137,
                            bernardo
                                   => 572, bernie => 646,
                            bert   => 396, bertram
                                   => 863,
                            bill   => 154, billy  => 73, blaine => 489, blake  => 308, bob    => 246,
                            bobby  => 82, boris  => 720, brad   => 209, bradford
                                   => 409,
                            bradley
                                   => 124, bradly => 832,
                            brain  => 525, branden
                                   => 641,
                            brandon
                                   => 68, brant  => 769,
                            brendan
                                   => 424, brendon
                                   => 844,
                            brent  => 187, brenton
                                   => 774,
                            bret   => 444, brett  => 196, brian  => 20, brice  => 814, broderick
                                   => 1005,
                            bruce  => 67, bruno  => 598, bryan  => 100, bryce  => 467, bryon  => 538,
                            bud    => 798, buddy  => 510, buford => 645, burl   => 834, burt   => 738,
                            buster => 895, byron  => 255, caleb  => 386, calvin => 150, cameron
                                   => 303,
                            carey  => 521, carl   => 47, carlo  => 625, carlos => 80, carlton
                                   => 301,
                            carmelo
                                   => 603, carmine
                                   => 678,
                            carrol => 909, cary   => 431, casey  => 248, cecil  => 205, cedric => 347,
                            cedrick
                                   => 985, cesar  => 316,
                            chad   => 118, chadwick
                                   => 681,
                            charles
                                   => 8, charley
                                   => 623,
                            charlie
                                   => 189, chas   => 901,
                            chauncey
                                   => 790, chester
                                   => 204,
                            chet   => 862, chi    => 828, chong  => 887, chris  => 94, christian
                                   => 221,
                            christoper
                                   => 765, christopher
                                   => 11,
                            chuck  => 478, chung  => 874, clair  => 644, clarence
                                   => 91,
                            claud  => 914, claude => 217, claudio
                                   => 778,
                            clay   => 406, clayton
                                   => 235,
                            clement
                                   => 594, clemente
                                   => 904,
                            cletus => 854, cleveland
                                   => 476,
                            cliff  => 534, clifford
                                   => 144,
                            clifton
                                   => 258, clint  => 374,
                            clinton
                                   => 224, clyde  => 179,
                            cody   => 231, colby  => 602, colin  => 338, collin => 631, colton => 966,
                            columbus
                                   => 861, conrad => 399,
                            cordell
                                   => 934, corey  => 174,
                            cornelius
                                   => 403, cornell
                                   => 664,
                            cory   => 216, coy    => 595, craig  => 88, cristobal
                                   => 918,
                            cristopher
                                   => 961, curt   => 491,
                            curtis => 110, cyril  => 673, cyrus  => 672, dale   => 107, dallas => 372,
                            damian => 479, damien => 503, damion => 827, damon  => 320, dan    => 172,
                            dane   => 542, danial => 638, daniel => 12, danilo => 913, dannie => 802,
                            danny  => 99, dante  => 593, darell => 1004, daren  => 657, darin  => 411,
                            dario  => 817, darius => 529, darnell
                                   => 418,
                            daron  => 886, darrel => 391, darrell
                                   => 159,
                            darren => 228, darrick
                                   => 848,
                            darrin => 422, darron => 894, darryl => 219, darwin => 508, daryl  => 260,
                            dave   => 251, david  => 6, dean   => 166, deandre
                                   => 752,
                            deangelo
                                   => 954, delbert
                                   => 337,
                            delmar => 615, delmer => 816, demarcus
                                   => 853,
                            demetrius
                                   => 459, denis  => 502,
                            dennis => 40, denny  => 587, denver => 632, deon   => 764, derek  => 158,
                            derick => 563, derrick
                                   => 171,
                            deshawn
                                   => 908, desmond
                                   => 506,
                            devin  => 351, devon  => 495, dewayne
                                   => 440,
                            dewey  => 381, dewitt => 773, dexter => 408, dick   => 619, diego  => 558,
                            dino   => 749, dion   => 592, dirk   => 640, domenic
                                   => 893,
                            domingo
                                   => 432, dominic
                                   => 335,
                            dominick
                                   => 428, don    => 131,
                            donald => 15, dong   => 892, donn   => 784, donnell
                                   => 586,
                            donnie => 285, donny  => 608, donovan
                                   => 575,
                            donte  => 868, dorian => 729, doug   => 291, douglas
                                   => 45,
                            douglass
                                   => 933, drew   => 379,
                            duane  => 206, dudley => 600, dustin => 169, dusty  => 698, dwain  => 867,
                            dwayne => 238, dwight => 239, dylan  => 477, earl   => 96, earle  => 714,
                            earnest
                                   => 340, eddie  => 132,
                            eddy   => 581, edgar  => 200, edgardo
                                   => 781,
                            edison => 907, edmond => 438, edmund => 345, edmundo
                                   => 994,
                            eduardo
                                   => 270, edward => 19,
                            edwardo
                                   => 653, edwin  => 130,
                            efrain => 455, efren  => 744, elbert => 397, elden  => 1003, eldon  => 461,
                            eli    => 466, elias  => 395, elijah => 430, eliseo => 741, elliot => 507,
                            ellsworth
                                   => 936, elmer  => 208,
                            elmo   => 723, eloy   => 728, elroy  => 903, elton  => 475, elvin  => 519,
                            elvis  => 571, elwood => 527, emanuel
                                   => 436,
                            emerson
                                   => 648, emery  => 589,
                            emil   => 439, emile  => 722, emilio => 429, emmanuel
                                   => 448,
                            emmett => 434, emmitt => 885, emory  => 634, enoch  => 843, enrique
                                   => 272,
                            erasmo => 924, eric   => 33, erich  => 680, erick  => 389, erik   => 218,
                            ernest => 84, ernesto
                                   => 302,
                            ernie  => 490, errol  => 651, ervin  => 380, erwin  => 485, esteban
                                   => 514,
                            ethan  => 460, eugene => 79, eugenio
                                   => 702,
                            eusebio
                                   => 891, evan   => 283,
                            everett
                                   => 243, everette
                                   => 726,
                            ezekiel
                                   => 900, ezequiel
                                   => 923,
                            ezra   => 709, fabian => 551, faustino
                                   => 777,
                            fausto => 945, federico
                                   => 583,
                            felipe => 332, felix  => 241, felton => 922, ferdinand
                                   => 707,
                            fermin => 873, fernando
                                   => 223,
                            fidel  => 532, filiberto
                                   => 953,
                            florencio
                                   => 847, florentino
                                   => 902,
                            floyd  => 161, forest => 686, forrest
                                   => 356,
                            francesco
                                   => 949, francis
                                   => 123,
                            francisco
                                   => 140, frank  => 31,
                            frankie
                                   => 390, franklyn
                                   => 993,
                            fred   => 71, freddie
                                   => 273,
                            freddy => 465, frederic
                                   => 618,
                            frederick
                                   => 127, fredric
                                   => 831,
                            fredrick
                                   => 275, fritz  => 760,
                            gabriel
                                   => 210, galen  => 612,
                            garfield
                                   => 880, garland
                                   => 453,
                            garret => 944, garry  => 329, garth  => 671, gary   => 26, gaston => 952,
                            gavin  => 588, gaylord
                                   => 951,
                            genaro => 662, gene   => 192, geoffrey
                                   => 330,
                            george => 16, gerald => 58, geraldo
                                   => 860,
                            gerard => 290, gerardo
                                   => 334,
                            gerry  => 565, gil    => 740, gilbert
                                   => 191,
                            gilberto
                                   => 373, gino   => 780,
                            giovanni
                                   => 670, giuseppe
                                   => 852,
                            glen   => 180, glenn  => 114, gonzalo
                                   => 562,
                            grady  => 401, graig  => 992, granville
                                   => 956,
                            greg   => 167, gregg  => 349, gregorio
                                   => 509,
                            gregory
                                   => 37, grover => 474,
                            guillermo
                                   => 339, gus    => 555,
                            gustavo
                                   => 368, hal    => 524,
                            hank   => 822, hans   => 487, harlan => 505, harland
                                   => 977,
                            harley => 458, harold => 44, harry  => 70, hassan => 851, haywood
                                   => 899,
                            heath  => 456, hector => 181, henry  => 46, herb   => 929, herbert
                                   => 126,
                            heriberto
                                   => 585, herman => 175,
                            herschel
                                   => 668, hershel
                                   => 735,
                            hilario
                                   => 797, hilton => 866,
                            hipolito
                                   => 872, hiram  => 574,
                            hobert => 984, hollis => 606, homer  => 289, hong   => 942, horace => 309,
                            horacio
                                   => 813, hosea  => 968,
                            hoyt   => 898, hubert => 293, huey   => 865, hugh   => 236, hugo   => 384,
                            humberto
                                   => 447, hung   => 665,
                            hyman  => 921, ian    => 244, ignacio
                                   => 385,
                            ira    => 314, irvin  => 415, irving => 360, irwin  => 620, isaac  => 257,
                            isaiah => 554, isaias => 871, isiah  => 721, isidro => 613, ismael => 377,
                            israel => 354, isreal => 943, issac  => 599, ivan   => 252, ivory  => 755,
                            jacinto
                                   => 991, jack   => 53,
                            jacob  => 119, jacques
                                   => 650,
                            jaime  => 247, jake   => 369, jamaal => 772, jamal  => 494, jamar  => 719,
                            jame   => 661, jamel  => 690, james  => 1, jamey  => 876, jamison
                                   => 846,
                            jared  => 213, jarod  => 928, jarred => 783, jarrett
                                   => 695,
                            jarrod => 500, jarvis => 597, jason  => 24, jasper => 483, javier => 222,
                            jay    => 147, jayson => 591, jed    => 807, jeff   => 117, jefferey
                                   => 836,
                            jeffery
                                   => 115, jeffrey
                                   => 30,
                            jeffry => 541, jerald => 437, jeramy => 996, jere   => 1002, jeremiah
                                   => 282,
                            jeremy => 76, jermaine
                                   => 355,
                            jerold => 759, jerome => 160, jeromy => 983, jerrell
                                   => 982,
                            jerrod => 733, jerrold
                                   => 820,
                            jerry  => 39, jess   => 445, jesse  => 87, jesus  => 125, jim    => 148,
                            jimmie => 242, jimmy  => 97, joaquin
                                   => 504,
                            joe    => 51, joel   => 129, joesph => 543, joey   => 278, john   => 2,
                            johnathan
                                   => 317, johnathon
                                   => 616,
                            johnie => 694, johnnie
                                   => 253,
                            johnny => 95, jon    => 152, jonah  => 819, jonas  => 685, jonathan
                                   => 55,
                            jonathon
                                   => 331, jordon => 912,
                            jorge  => 168, jose   => 28, josef  => 727, joseph => 9, josh   => 383,
                            joshua => 38, josiah => 768, jospeh => 965, josue  => 652, juan   => 52,
                            jude   => 932, judson => 779, jules  => 739, julian => 256, julio  => 232,
                            julius => 284, junior => 464, justin => 56, kareem => 718, karl   => 215,
                            keenan => 857, keith  => 59, kelvin => 321, ken    => 245, kendall
                                   => 470,
                            kendrick
                                   => 528, keneth => 990,
                            kenneth
                                   => 17, kennith
                                   => 677,
                            kenny  => 292, kent   => 267, kenton => 826, kermit => 512, kerry  => 311,
                            keven  => 796, kevin  => 23, kieth  => 754, kip    => 833, kirk   => 264,
                            korey  => 964, kory   => 794, kraig  => 981, kris   => 553, kristofer
                                   => 976,
                            kristopher
                                   => 365, kurt   => 233,
                            kurtis => 627, kyle   => 122, lamar  => 404, lamont => 452, lance  => 230,
                            landon => 639, lanny  => 717, larry  => 29, laurence
                                   => 376,
                            lavern => 737, lawerence
                                   => 882,
                            lawrence
                                   => 63, lazaro => 691,
                            leandro
                                   => 980, leif   => 995,
                            leland => 358, lemuel => 736, lenard => 789, lenny  => 810, leo    => 162,
                            leon   => 157, leonard
                                   => 105,
                            leonardo
                                   => 482, leonel => 633,
                            leopoldo
                                   => 725, leroy  => 139,
                            les    => 751, lester => 186, levi   => 366, lincoln
                                   => 660,
                            lino   => 927, linwood
                                   => 609,
                            lionel => 370, lloyd  => 155, lon    => 676, lonnie => 229, lonny  => 925,
                            loren  => 336, lorenzo
                                   => 305,
                            louie  => 450, louis  => 75, lowell => 348, loyd   => 557, luciano
                                   => 699,
                            lucien => 706, lucio  => 732, lucius => 975, luigi  => 989, luis   => 102,
                            luke   => 288, luther => 280, lyle   => 296, lyman  => 767, lyndon => 856,
                            lynwood
                                   => 1001, mac    => 818,
                            malcolm
                                   => 318, malcom => 963,
                            malik  => 957, manual => 950, manuel => 108, marc   => 193, marcel => 535,
                            marcelino
                                   => 624, marcellus
                                   => 974,
                            marcelo
                                   => 793, marco  => 326,
                            marcos => 367, marcus => 141, margarito
                                   => 747,
                            mariano
                                   => 637, mario  => 138,
                            mark   => 14, markus => 864, marlin => 531, marlon => 435, marquis
                                   => 716,
                            marty  => 371, marvin => 112, mathew => 226, matt   => 297, matthew
                                   => 25,
                            maurice
                                   => 176, mauricio
                                   => 573,
                            mauro  => 801, max    => 237, maximo => 879, mckinley
                                   => 878,
                            mel    => 792, melvin => 120, merle  => 410, merlin => 621, merrill
                                   => 622,
                            mervin => 688, micah  => 454, michael
                                   => 4,
                            michal => 1000, michale
                                   => 955,
                            micheal
                                   => 142, michel => 548,
                            mickey => 473, miguel => 145, mike   => 103, mikel  => 842, milan  => 926,
                            milford
                                   => 762, millard
                                   => 560,
                            milo   => 806, milton => 201, minh   => 850, miquel => 890, mitch  => 713,
                            mitchel
                                   => 687, modesto
                                   => 948,
                            mohamed
                                   => 815, mohammad
                                   => 636,
                            mohammed
                                   => 703, moises => 530,
                            monte  => 488, monty  => 549, mose   => 941, moses  => 414, moshe  => 841,
                            myles  => 684, myron  => 344, napoleon
                                   => 758,
                            nathan => 106, nathanael
                                   => 939,
                            nathanial
                                   => 911, nathaniel
                                   => 198,
                            ned    => 545, neil   => 220, nestor => 605, neville
                                   => 906,
                            nicholas
                                   => 64, nick   => 279,
                            nickolas
                                   => 577, nicky  => 960,
                            nicolas
                                   => 375, nigel  => 743,
                            noah   => 400, noe    => 569, noel   => 342, nolan  => 520, norbert
                                   => 518,
                            norberto
                                   => 757, norman => 111,
                            normand
                                   => 753, numbers
                                   => 643,
                            octavio
                                   => 663, odell  => 596,
                            odis   => 788, olen   => 804, olin   => 776, omar   => 306, omer   => 870,
                            oren   => 840, orlando
                                   => 299,
                            orval  => 800, orville
                                   => 378,
                            oscar  => 146, osvaldo
                                   => 750,
                            oswaldo
                                   => 935, otha   => 889,
                            otis   => 286, otto   => 441, owen   => 361, pablo  => 304, pasquale
                                   => 635,
                            patrick
                                   => 42, paul   => 13,
                            pedro  => 170, percy  => 407, pete   => 327, peter  => 43, phil   => 402,
                            philip => 93, phillip
                                   => 85,
                            pierre => 463, porfirio
                                   => 787,
                            preston
                                   => 323, quentin
                                   => 492,
                            quincy => 580, quintin
                                   => 845,
                            quinton
                                   => 523, rafael => 199,
                            raleigh
                                   => 881, ralph  => 62,
                            ramiro => 398, ramon  => 188, randal => 419, randall
                                   => 135,
                            randell
                                   => 693, randolph
                                   => 328,
                            randy  => 78, raphael
                                   => 537,
                            rashad => 884, raul   => 202, ray    => 128, rayford
                                   => 917,
                            raymon => 916, raymond
                                   => 36,
                            raymundo
                                   => 656, refugio
                                   => 748,
                            reggie => 552, reginald
                                   => 194,
                            reinaldo
                                   => 731, renaldo
                                   => 973,
                            renato => 897, rene   => 269, reuben => 480, rex    => 300, reynaldo
                                   => 443,
                            rhett  => 931, ricardo
                                   => 183,
                            richard
                                   => 7, richie => 812,
                            rick   => 185, rickey => 313, rickie => 568, ricky  => 133, rico   => 771,
                            rigoberto
                                   => 566, rob    => 526,
                            robbie => 469, robby  => 659, robert => 3, roberto
                                   => 178,
                            robt   => 821, rocco  => 561, rocky  => 462, rod    => 522, roderick
                                   => 310,
                            rodger => 457, rodney => 109, rodolfo
                                   => 343,
                            rodrick
                                   => 730, rodrigo
                                   => 564,
                            rogelio
                                   => 392, roger  => 50,
                            roland => 212, rolando
                                   => 405,
                            rolf   => 972, rolland
                                   => 825,
                            roman  => 417, romeo  => 590, ron    => 211, ronald => 21, ronnie => 153,
                            ronny  => 674, roosevelt
                                   => 353,
                            rory   => 550, roscoe => 513, rosendo
                                   => 761,
                            roy    => 65, royce  => 471, ruben  => 195, rubin  => 712, rudolf => 971,
                            rudolph
                                   => 319, rudy   => 322,
                            rueben => 979, rufus  => 362, rupert => 824, russ   => 683, russel => 484,
                            russell
                                   => 81, rusty  => 547,
                            ryan   => 49, sal    => 799, salvador
                                   => 263,
                            salvatore
                                   => 346, sam    => 184,
                            sammie => 546, sammy  => 364, samual => 888, samuel => 60, sanford
                                   => 601,
                            sang   => 763, santo  => 970, saul   => 416, scot   => 578, scott  => 32,
                            scottie
                                   => 701, scotty => 517,
                            sean   => 92, sebastian
                                   => 582,
                            sergio => 265, seth   => 266, seymour
                                   => 700,
                            shad   => 969, shane  => 182, shaun  => 295, shawn  => 90, shayne => 910,
                            sheldon
                                   => 388, sherman
                                   => 350,
                            sherwood
                                   => 915, shon   => 999,
                            sidney => 254, silas  => 617, simon  => 359, solomon
                                   => 516,
                            stan   => 481, stanford
                                   => 839,
                            stanley
                                   => 104, stefan => 607,
                            stephan
                                   => 449, stephen
                                   => 34,
                            sterling
                                   => 472, steve  => 74,
                            steven => 18, stevie => 675, stuart => 274, sung   => 823, sydney => 710,
                            sylvester
                                   => 352, tad    => 786,
                            ted    => 225, teddy  => 442, teodoro
                                   => 877,
                            terence
                                   => 393, terrance
                                   => 268,
                            terrell
                                   => 413, terrence
                                   => 271,
                            terry  => 57, thad   => 708, thaddeus
                                   => 533,
                            thanh  => 808, theo   => 859, theodore
                                   => 143,
                            theron => 655, thomas => 10, thurman
                                   => 544,
                            tim    => 164, timmy  => 421, timothy
                                   => 27,
                            titus  => 920, tobias => 849, toby   => 425, tod    => 791, todd   => 86,
                            tom    => 149, tomas  => 387, tommie => 420, tommy  => 156, toney  => 938,
                            tony   => 101, tory   => 811, travis => 116, trent  => 446, trenton
                                   => 626,
                            trevor => 287, trey   => 756, trinidad
                                   => 785,
                            tristan
                                   => 658, troy   => 134,
                            truman => 614, tuan   => 959, tyler  => 190, tyree  => 835, tyrell => 855,
                            tyron  => 869, tyrone => 227, tyson  => 497, ulysses
                                   => 584,
                            valentin
                                   => 704, van    => 426,
                            vance  => 501, vern   => 570, vernon => 177, vicente
                                   => 451,
                            victor => 83, vince  => 579, vincent
                                   => 113,
                            vincenzo
                                   => 998, virgil => 261,
                            virgilio
                                   => 937, vito   => 630,
                            waldo  => 830, wally  => 988, walter => 41, waylon => 967, wayne  => 72,
                            weldon => 611, wendell
                                   => 281,
                            werner => 858, wesley => 165, weston => 734, wilber => 896, wilbert
                                   => 357,
                            wilbur => 307, wilburn
                                   => 682,
                            wilford
                                   => 654, wilfred
                                   => 382,
                            wilfredo
                                   => 498, willard
                                   => 259,
                            william
                                   => 5, willian
                                   => 997,
                            willie => 61, willy  => 838, wilmer => 647, wilton => 770, winford
                                   => 987,
                            winfred
                                   => 629, winston
                                   => 423,
                            woodrow
                                   => 363, xavier => 511,
                            yong   => 775, zachariah
                                   => 803,
                            zachary
                                   => 173, zachery
                                   => 649,
                            zack   => 947, zackary
                                   => 958,
                            zane   => 689
                          },
  english_surnames     => {
                            abad    => 8178, abarca  => 8177, abbate  => 6557,
                            abbott  => 419, abdullah
                                    => 4903,
                            abell   => 3549, abercrombie
                                    => 4827,
                            abernathy
                                    => 1432, abernethy
                                    => 7548,
                            abeyta  => 4866, ables   => 4865, abner   => 3892, abney   => 2301,
                            abrahamson
                                    => 9421, abrams  => 1168,
                            abramson
                                    => 4864, abrego  => 6457,
                            abreu   => 2435, abron   => 9307, absher  => 6556, abshire => 7079,
                            abston  => 9666, acevedo => 784, aceves  => 7902, acker   => 2110,
                            ackerman
                                    => 1196, ackley  => 4044,
                            acklin  => 8392, acord   => 6748, acosta  => 466, acree   => 4418,
                            acton   => 5822, acuff   => 8080, acuna   => 2809, adair   => 1568,
                            adame   => 2795, adames  => 6065, adamo   => 8968, adams   => 34,
                            adamski => 8519, adamson => 2022, adcock  => 2059, addington
                                    => 5546,
                            addis   => 6957, addison => 1594, adelman => 9665, adkins  => 363,
                            adkinson
                                    => 7716, adkison => 8629,
                            adkisson
                                    => 7817, adler   => 2104,
                            adorno  => 4935, agee    => 1980, agnew   => 3126, agosto  => 5630,
                            aguayo  => 4043, aguero  => 7816, aguiar  => 3527, aguila  => 7901,
                            aguilar => 331, aguilera
                                    => 1809,
                            aguirre => 732, ahearn  => 6956, ahern   => 3413, ahlers  => 7400,
                            ahner   => 6329, ahrens  => 3394, ahumada => 8277, aiello  => 3728,
                            aiken   => 2081, aikens  => 4515, ainsworth
                                    => 2538,
                            aitken  => 7399, aker    => 7313, akers   => 941, akin    => 3057,
                            akins   => 1322, alamo   => 9189, alanis  => 5304, alaniz  => 1979,
                            alarcon => 3412, albanese
                                    => 4579,
                            albano  => 7147, albaugh => 7547, albee   => 9420, albers  => 2954,
                            alberts => 5157, albertson
                                    => 2762,
                            albin   => 6676, albino  => 8276, albrecht
                                    => 1874,
                            albright
                                    => 1144, albritton
                                    => 4198,
                            albro   => 9306, alcala  => 3457, alcantar
                                    => 5087,
                            alcantara
                                    => 5584, alcaraz => 4610,
                            alcorn  => 3125, aldana  => 7546, alday   => 9419, alder   => 8854,
                            alderete
                                    => 7545, alderman
                                    => 2396,
                            alderson
                                    => 5043, aldrich => 1423,
                            aldridge
                                    => 1195, alegria => 9915,
                            alejo   => 9664, aleman  => 2676, alessi  => 6555, alexander
                                    => 92,
                            alfano  => 6883, alfaro  => 1642, alford  => 782, alger   => 3631,
                            alicea  => 2412, alkire  => 8853, allain  => 6882, allaire => 9305,
                            allard  => 2272, alleman => 6224, allen   => 26, alley   => 1813,
                            alleyne => 4760, allgood => 5042, allman  => 3684, allmon  => 8391,
                            alloway => 9304, allred  => 1608, almanza => 3212, almaraz => 5086,
                            almazan => 8518, almeida => 2693, almodovar
                                    => 9188,
                            almon   => 9663, almond  => 3323, almonte => 4484, alpert  => 7398,
                            alston  => 773, alsup   => 6822, altamirano
                                    => 5432,
                            althoff => 9187, altizer => 9303, altman  => 1846, alvarado
                                    => 387,
                            alvardo => 7995, alvares => 9914, alvarez => 209, alverez => 6747,
                            alverson
                                    => 7994, alves   => 3071,
                            alvey   => 6821, alvis   => 7993, amador  => 2468, aman    => 7815,
                            amann   => 9662, amaral  => 3727, amaro   => 5821, amato   => 2719,
                            amaya   => 2021, ambriz  => 4826, amburgey
                                    => 8753,
                            amerson => 4970, ames    => 1098, amey    => 7633, amezquita
                                    => 9532,
                            amick   => 6389, amin    => 6064, ammerman
                                    => 8628,
                            ammons  => 2913, amundson
                                    => 4042,
                            anaya   => 1458, ancheta => 8176, anders  => 2048, andersen
                                    => 889,
                            anderson
                                    => 11, anderton
                                    => 5041,
                            andes   => 7814, andino  => 6675, andrade => 970, andreasen
                                    => 9661,
                            andresen
                                    => 6063, andress => 6619,
                            andrews => 174, andrus  => 3357, andujar => 8852, ange    => 8627,
                            angell  => 4417, anglin  => 2434, anguiano
                                    => 4635,
                            angulo  => 3707, angus   => 6746, anselmo => 8275, ansley  => 6116,
                            anson   => 5682, antonelli
                                    => 7715,
                            anzalone
                                    => 8967, aparicio
                                    => 5871,
                            apodaca => 2709, aponte  => 1718, appel   => 3994, appleby => 4483,
                            applegate
                                    => 2530, appleton
                                    => 4041,
                            applewhite
                                    => 4333, appling => 6277,
                            aquilar => 7026, aquino  => 2256, aragon  => 1675, araiza  => 6674,
                            arana   => 5920, aranda  => 2708, arango  => 6955, araujo  => 4040,
                            arbogast
                                    => 4416, arbuckle
                                    => 6881,
                            arce    => 2188, arceneaux
                                    => 5226,
                            archambault
                                    => 6820, archer  => 886,
                            archibald
                                    => 2953, archuleta
                                    => 2349,
                            arciniega
                                    => 7900, ardoin  => 5006,
                            arellano
                                    => 1268, arenas  => 6456,
                            arevalo => 2404, argo    => 6276, arguelles
                                    => 8079,
                            arguello
                                    => 5820, argueta => 5870,
                            arias   => 1057, arispe  => 9066, armbruster
                                    => 5681,
                            armendariz
                                    => 4363, armenta => 3780,
                            armentrout
                                    => 6745, armes   => 7992,
                            armijo  => 3201, armistead
                                    => 8517,
                            armitage
                                    => 6554, armour  => 4634,
                            armstead
                                    => 2433, armstrong
                                    => 179,
                            arndt   => 2692, arneson => 8274, arnett  => 2127, arnold  => 163,
                            arnone  => 8078, aronson => 5303, arredondo
                                    => 1593,
                            arreola => 3034, arriaga => 3307, arrington
                                    => 981,
                            arriola => 4254, arrowood
                                    => 5189,
                            arroyo  => 880, arruda  => 5727, arsenault
                                    => 2375,
                            arteaga => 2794, artis   => 2168, artrip  => 8851, arvizu  => 7544,
                            arwood  => 7479, arzola  => 7714, asberry => 7478, asbury  => 3526,
                            ascencio
                                    => 9186, ashbaugh
                                    => 8516,
                            ashburn => 5726, ashby   => 1558, ashcraft
                                    => 2321,
                            ashe    => 3306, asher   => 2329, ashford => 2691, ashmore => 3802,
                            ashworth
                                    => 2761, askew   => 1640,
                            askins  => 7312, aston   => 5725, astorga => 9418, atchison
                                    => 3494,
                            atchley => 4553, atencio => 6168, atherton
                                    => 3286,
                            athey   => 7991, atkin   => 9302, atkins  => 450, atkinson
                                    => 562,
                            attaway => 6455, atterberry
                                    => 9913,
                            atwater => 6819, atwell  => 2644, atwood  => 1454, aube    => 8175,
                            aubin   => 6553, aubuchon
                                    => 8966,
                            aucoin  => 4482, audet   => 6880, audette => 6223, auger   => 4552,
                            auguste => 9660, augustin
                                    => 8390,
                            auld    => 7632, ault    => 3865, aultman => 7899, austin  => 186,
                            auten   => 6505, autrey  => 5473, autry   => 3456, avalos  => 1746,
                            avant   => 4451, avelar  => 5583, avent   => 7025, averett => 7311,
                            averill => 6062, avila   => 541, aviles  => 1825, avina   => 6744,
                            axtell  => 9912, ayala   => 461, aycock  => 4450, ayer    => 6618,
                            ayers   => 598, ayotte  => 6454, ayres   => 2411, azar    => 8515,
                            azevedo => 4863, azure   => 7898, babb    => 1607, babbitt => 4862,
                            babcock => 1449, baber   => 4225, babin   => 2675, babineaux
                                    => 6222,
                            baca    => 1178, bach    => 3094, bachman => 2585, bachmann
                                    => 9301,
                            backer  => 6617, backes  => 9911, backman => 6221, backus  => 4391,
                            bacon   => 906, bade    => 6954, bader   => 3566, badger  => 2969,
                            badgett => 8273, badillo => 4088, baer    => 2017, baez    => 1356,
                            baeza   => 4715, bagby   => 4801, baggett => 1863, bagley  => 1824,
                            bagwell => 2432, bahena  => 5680, bahr    => 4481, baier   => 6453,
                            bailes  => 7477, bailey  => 58, baillargeon
                                    => 7024,
                            baily   => 5679, bain    => 1567, baines  => 3008, bair    => 2623,
                            baird   => 795, baisden => 8389, baker   => 35, bakke   => 7023,
                            bakken  => 8272, bakker  => 7476, balch   => 5472, balcom  => 7813,
                            balderas
                                    => 3252, baldridge
                                    => 4133,
                            baldwin => 311, bales   => 2201, ball    => 295, ballance
                                    => 7475,
                            ballard => 392, ballenger
                                    => 6388,
                            ballentine
                                    => 7897, ballesteros
                                    => 4969,
                            ballew  => 4332, ballinger
                                    => 4132,
                            ballou  => 4157, baltazar
                                    => 6452,
                            balzer  => 7990, banas   => 6953, bancroft
                                    => 5085,
                            banda   => 2348, bandy   => 2660, bane    => 4514, bangs   => 7989,
                            banister
                                    => 6275, banker  => 6504,
                            bankhead
                                    => 8626, banks   => 204,
                            bankston
                                    => 3110, banner  => 4253,
                            banning => 9659, bannister
                                    => 2885,
                            bannon  => 6451, banta   => 4902, banuelos
                                    => 3251,
                            baptiste
                                    => 2820, barahona
                                    => 7238,
                            barajas => 1406, baran   => 4714, baranowski
                                    => 8388,
                            barba   => 3801, barbee  => 2340, barber  => 308, barbieri
                                    => 6552,
                            barbosa => 2502, barbour => 1839, barboza => 5397, barclay => 2300,
                            bard    => 4156, barden  => 3779, bardwell
                                    => 7078,
                            barefoot
                                    => 7631, barela  => 3800,
                            barfield
                                    => 2183, barger  => 1758,
                            barham  => 3799, barhorst
                                    => 6450,
                            barker  => 291, barkley => 2200, barksdale
                                    => 1964,
                            barley  => 8514, barlow  => 859, barnard => 1156, barner  => 4759,
                            barnes  => 75, barnett => 253, barnette
                                    => 2779,
                            barnhart
                                    => 1584, barnhill
                                    => 2747,
                            barns   => 5972, barnum  => 4674, barnwell
                                    => 4551,
                            baron   => 1899, barone  => 3141, barr    => 617, barragan
                                    => 4673,
                            barraza => 2850, barre   => 8513, barrera => 785, barreras
                                    => 8965,
                            barreto => 4015, barrett => 258, barrette
                                    => 9417,
                            barrick => 7146, barrientos
                                    => 4067,
                            barringer
                                    => 4224, barrios => 1800,
                            barron  => 632, barros  => 6115, barroso => 9065, barrow  => 1532,
                            barrows => 2746, barstow => 9792, barta   => 7022, bartel  => 6061,
                            bartell => 7310, bartels => 3726, bartelt => 8752, barter  => 9531,
                            barth   => 1871, bartholomew
                                    => 2040,
                            bartlett
                                    => 612, bartley => 1576,
                            barton  => 428, bartz   => 4800, barwick => 9185, bascom  => 8271,
                            bash    => 6016, basham  => 2579, bashaw  => 6743, basile  => 4513,
                            basinger
                                    => 7812, baskerville
                                    => 6114,
                            baskin  => 3876, basnight
                                    => 9910,
                            bass    => 413, bassett => 1319, basso   => 6015, bastian => 4758,
                            batchelder
                                    => 4713, batchelor
                                    => 2912,
                            bateman => 1431, bates   => 271, batey   => 6328, batista => 2595,
                            batiste => 3423, batres  => 9909, batson  => 3512, battaglia
                                    => 3344,
                            batten  => 3211, battista
                                    => 8270,
                            battles => 3343, batton  => 7543, batts   => 2093, batty   => 7542,
                            baty    => 7811, baucom  => 6551, bauder  => 8964, bauer   => 619,
                            baugh   => 2146, baugher => 6060, baughman
                                    => 2132,
                            baum    => 1934, bauman  => 2016, baumann => 3070, baumgardner
                                    => 3976,
                            baumgartner
                                    => 3237, baur    => 7896,
                            bautista
                                    => 1393, baxley  => 3822,
                            baxter  => 502, bayer   => 3033, bayles  => 7474, bayless => 4712,
                            baylor  => 3586, bayne   => 3842, baynes  => 9791, bays    => 3915,
                            bazan   => 6952, bazemore
                                    => 7145,
                            beach   => 823, beacham => 9658, beadle  => 7895, beagle  => 9064,
                            beahm   => 9908, beaird  => 7144, beal    => 1392, beale   => 3007,
                            beall   => 2622, beals   => 3548, beam    => 1757, beaman  => 4252,
                            beamer  => 7630, beamon  => 4087, bean    => 631, beane   => 3864,
                            beard   => 539, bearden => 1703, beardsley
                                    => 4155,
                            beasley => 508, beason  => 5188, beaton  => 6274, beattie => 2760,
                            beatty  => 991, beaty   => 2047, beauchamp
                                    => 2460,
                            beaudette
                                    => 7473, beaudoin
                                    => 2984,
                            beaudry => 4277, beaulieu
                                    => 1963,
                            beaumont
                                    => 7143, beauregard
                                    => 3476,
                            beaver  => 1496, beavers => 1799, becerra => 1779, bechtel => 4154,
                            bechtold
                                    => 5869, beck    => 275,
                            becker  => 358, beckett => 2431, beckford
                                    => 6818,
                            beckham => 2509, beckley => 5919, beckman => 1789, beckner => 7629,
                            beckstead
                                    => 9300, beckwith
                                    => 2508,
                            becnel  => 3210, becton  => 8850, bedard  => 3475, bedell  => 4331,
                            bedford => 3019, bednar  => 9184, bedwell => 6449, beebe   => 1808,
                            beech   => 6742, beecher => 5302, beeler  => 3455, beem    => 8512,
                            beeman  => 4512, beene   => 7472, beers   => 2901, beery   => 5819,
                            beesley => 8269, beeson  => 4039, begay   => 1614, beggs   => 6059,
                            begley  => 2467, behling => 7237, behnke  => 9530, behr    => 6387,
                            behrens => 2507, beier   => 9299, beiler  => 9298, bejarano
                                    => 6741,
                            belanger
                                    => 1462, belcher => 930,
                            belden  => 6616, belew   => 7628, belisle => 6327, belk    => 4711,
                            belknap => 7988, bell    => 56, bellamy => 1574, beller  => 6879,
                            bellinger
                                    => 4757, belliveau
                                    => 9297,
                            bello   => 2558, bellows => 6113, belton  => 3093, beltran => 1059,
                            beltz   => 7236, bemis   => 4633, benally => 5121, benavides
                                    => 1583,
                            benavidez
                                    => 2410, benbow  => 7810,
                            benda   => 9529, bender  => 735, benedetto
                                    => 6673,
                            benefield
                                    => 3683, benfield
                                    => 5724,
                            benford => 4672, benge   => 4197, bengtson
                                    => 9416,
                            benham  => 4632, benites => 8625, benitez => 1267, benn    => 5354,
                            benner  => 2306, bennet  => 5509, bennett => 73, benning => 7713,
                            bennington
                                    => 7894, benoit  => 1479,
                            benson  => 305, bentley => 697, benton  => 658, bentz   => 4710,
                            benz    => 6014, berard  => 5771, berardi => 9528, berg    => 668,
                            bergen  => 4578, berger  => 771, bergeron
                                    => 1050,
                            bergin  => 6386, berglund
                                    => 6878,
                            bergman => 1592, bergmann
                                    => 6273,
                            bergquist
                                    => 7471, bergstrom
                                    => 3547,
                            berkey  => 7541, berkley => 6013, berkowitz
                                    => 5431,
                            berman  => 1969, bermudez
                                    => 1646,
                            bernabe => 9415, bernal  => 1173, bernardi
                                    => 9414,
                            berndt  => 4901, berner  => 7142, bernhardt
                                    => 4066,
                            bernier => 1898, bernstein
                                    => 1778,
                            berrios => 2494, berry   => 161, berryhill
                                    => 5582,
                            berryman
                                    => 3665, berthiaume
                                    => 9907,
                            bertrand
                                    => 2994, bertsch => 9413,
                            berube  => 2778, bessette
                                    => 6058,
                            betancourt
                                    => 2255, bethea  => 2391,
                            bethune => 7809, bettencourt
                                    => 4223,
                            bettis  => 4175, betts   => 1207, betz    => 3725, bevan   => 7808,
                            beveridge
                                    => 6448, bevins  => 4086,
                            bevis   => 7807, bewley  => 7627, beyer   => 1843, bianchi => 5156,
                            bianco  => 5084, bias    => 4511, bibb    => 6550, bibbs   => 6057,
                            bice    => 5187, bickel  => 4825, bickerstaff
                                    => 7712,
                            bickford
                                    => 3092, bickley => 9296,
                            bicknell
                                    => 9183, biddle  => 2488,
                            bidwell => 5508, bieber  => 6447, bierman => 4900, bigelow => 2557,
                            biggers => 6672, biggerstaff
                                    => 6877,
                            biggs   => 1276, bigham  => 4671, bigler  => 5545, bigley  => 8077,
                            bilbrey => 7397, biles   => 6740, biller  => 7806, billings
                                    => 1124,
                            billingsley
                                    => 2167, billington
                                    => 5678,
                            billiot => 3778, billman => 8624, bills   => 2584, billups => 2636,
                            bilodeau
                                    => 3959, bilyeu  => 7021,
                            binder  => 2612, binette => 6876, binford => 7396, bingaman
                                    => 7626,
                            bingham => 1025, binion  => 5818, binkley => 3607, binns   => 6112,
                            birch   => 2566, birchfield
                                    => 5677,
                            bird    => 845, birdsall
                                    => 8623,
                            birdsong
                                    => 4631, birdwell
                                    => 6951,
                            birkholz
                                    => 9527, birnbaum
                                    => 8622,
                            biron   => 9063, birt    => 8387, bischoff
                                    => 4577,
                            bish    => 6167, bishop  => 206, bissell => 5971, bisson  => 3682,
                            bissonnette
                                    => 4799, bitner  => 8386,
                            bittle  => 8963, bittner => 3546, bivens  => 2872, bivins  => 3545,
                            bixby   => 6446, bixler  => 4670, bjork   => 8751, black   => 143,
                            blackburn
                                    => 646, blackford
                                    => 5396,
                            blackman
                                    => 1606, blackmon
                                    => 1255,
                            blackmore
                                    => 6615, blackshear
                                    => 5723,
                            blackstock
                                    => 6272, blackstone
                                    => 7805,
                            blackwell
                                    => 543, blackwood
                                    => 3393,
                            blades  => 7235, blagg   => 9906, blain   => 5395, blair   => 340,
                            blais   => 3124, blaisdell
                                    => 6220,
                            blakely => 2266, blakemore
                                    => 7470,
                            blakeney
                                    => 5544, blakeslee
                                    => 7987,
                            blakey  => 7469, blakley => 7077, blakney => 7309, blalock => 1818,
                            blanc   => 7234, blanchard
                                    => 653,
                            blanchette
                                    => 3225, blanco  => 1254,
                            bland   => 894, blanding
                                    => 5629,
                            blaney  => 7233, blank   => 1831, blankenship
                                    => 545,
                            blanks  => 4276, blanton => 954, blaser  => 9182, blasingame
                                    => 8849,
                            blassingame
                                    => 9657, blatt   => 9295,
                            blaylock
                                    => 3250, blazer  => 6671,
                            bledsoe => 1453, blevins => 637, bliss   => 1648, blizzard
                                    => 6111,
                            bloch   => 7020, blocker => 2529, blodgett
                                    => 2900,
                            blomquist
                                    => 7804, bloodworth
                                    => 6549,
                            bloom   => 1210, bloomer => 5543, bloomfield
                                    => 4861,
                            bloomquist
                                    => 8750, blosser => 9412,
                            blough  => 9790, blouin  => 8268, blount  => 1246, bluhm   => 7625,
                            blum    => 1817, blumberg
                                    => 8848,
                            blume   => 5120, blumenthal
                                    => 7540,
                            blunt   => 2745, boardman
                                    => 4609,
                            boatman => 4131, boatner => 9294, boatright
                                    => 4014,
                            boatwright
                                    => 3777, bobb    => 8267,
                            bobbitt => 3606, bober   => 9905, bobo    => 2403, bocanegra
                                    => 6670,
                            bock    => 2862, boddie  => 5581, bode    => 4390, boden   => 6817,
                            bodie   => 9411, bodine  => 6614, bodnar  => 7232, bodner  => 9293,
                            boehm   => 3565, boettcher
                                    => 4065,
                            bogan   => 3006, bogard  => 7711, bogart  => 5770, bogdan  => 9656,
                            boger   => 5676, boggess => 6503, boggs   => 887, bogle   => 4576,
                            bogue   => 9292, bohanan => 9291, bohannan
                                    => 8511,
                            bohannon
                                    => 2474, bohn    => 3493,
                            bohon   => 9789, boisvert
                                    => 3706,
                            bojorquez
                                    => 6502, boland  => 3605,
                            bolanos => 6056, bolden  => 984, bolding => 5628, boldt   => 7141,
                            bolduc  => 2911, bolen   => 3342, boles   => 1753, boley   => 7893,
                            bolick  => 5675, bolin   => 2328, boling  => 2487, bolinger
                                    => 6012,
                            bolling => 3863, bollinger
                                    => 2126,
                            bollman => 8962, bolt    => 3454, bolton  => 826, bolyard => 7892,
                            boman   => 8510, bomar   => 7986, bonanno => 8174, bonar   => 9062,
                            bond    => 497, bonds   => 1589, bondurant
                                    => 9290,
                            boner   => 8961, boney   => 6669, bonham  => 4480, bonilla => 1088,
                            bonin   => 6166, bonneau => 9289, bonnell => 6445, bonner  => 751,
                            bonnett => 5769, bonney  => 5040, bono    => 6385, bontrager
                                    => 8847,
                            booher  => 4934, booker  => 560, bookman => 8266, bookout => 8385,
                            boone   => 432, boose   => 9410, booth   => 523, boothe  => 3032,
                            boozer  => 5186, bopp    => 8265, borchardt
                                    => 8621,
                            borchers
                                    => 8620, bordeaux
                                    => 8384,
                            bordelon
                                    => 3544, borden  => 1725,
                            borders => 2583, boren   => 2793, borg    => 5155, borges  => 2952,
                            borja   => 8076, borkholder
                                    => 8749,
                            borkowski
                                    => 6875, borman  => 9526,
                            borowski
                                    => 5817, borrego => 3862,
                            borrero => 8173, borst   => 6950, borton  => 9061, borum   => 9904,
                            bosch   => 5430, bosco   => 7710, bosley  => 4196, bosse   => 9060,
                            bost    => 4510, bostic  => 2265, bostick => 3173, bostwick
                                    => 5154,
                            boswell => 1146, bosworth
                                    => 4509,
                            botelho => 7308, botello => 4449, botkin  => 9288, bott    => 5272,
                            bottoms => 3681, botts   => 4550, bouchard
                                    => 1599,
                            boucher => 885, boudreau
                                    => 2199,
                            boudreaux
                                    => 1674, bouffard
                                    => 7019,
                            boughton
                                    => 6548, bouie   => 7231,
                            boulanger
                                    => 8509, bouldin => 5225,
                            boulware
                                    => 8383, bounds  => 3041,
                            bourassa
                                    => 6219, bourdon => 8960,
                            bourg   => 6271, bourgeois
                                    => 1685,
                            bourland
                                    => 9655, bourne  => 2674,
                            bourque => 2278, bousquet
                                    => 6165,
                            boutin  => 5429, bouton  => 6444, boutte  => 6218, boutwell
                                    => 4709,
                            bova    => 7985, bove    => 5039, bowden  => 1103, bowe    => 4756,
                            bowen   => 307, bowens  => 2254, bower   => 1181, bowers  => 426,
                            bowes   => 5394, bowie   => 1968, bowker  => 7140, bowler  => 4275,
                            bowles  => 1214, bowlin  => 3005, bowling => 1037, bowman  => 230,
                            bowser  => 1737, bowyer  => 6110, boyce   => 911, boyd    => 128,
                            boyer   => 593, boyes   => 8619, boyett  => 4669, boyette => 4112,
                            boykin  => 1467, boykins => 5083, boylan  => 4668, boyle   => 860,
                            boyles  => 1752, boynton => 3356, bozarth => 6739, bozeman => 3705,
                            braaten => 8748, brace   => 4708, bracey  => 6326, brack   => 8382,
                            bracken => 3993, brackett
                                    => 2718,
                            brackin => 9654, bracy   => 5005, bradberry
                                    => 6443,
                            bradburn
                                    => 9409, bradbury
                                    => 3543,
                            braddock
                                    => 6109, braddy  => 6949,
                            braden  => 1788, bradfield
                                    => 6948,
                            bradshaw
                                    => 621, brady   => 407,
                            bragdon => 8508, bragg   => 1271, braggs  => 8959, brainard
                                    => 7395,
                            braithwaite
                                    => 4667, brake   => 4968,
                            braley  => 6613, bramble => 7803, bramblett
                                    => 8381,
                            brame   => 7984, bramlett
                                    => 5082,
                            brammer => 7307, branch  => 636, brandenburg
                                    => 3585,
                            brandes => 8172, brandt  => 935, branham => 2039, brann   => 5081,
                            brannan => 4362, brannen => 7983, brannon => 1823, branscum
                                    => 7891,
                            branson => 2673, branstetter
                                    => 9059,
                            brantley
                                    => 1143, branton => 5970,
                            branum  => 6947, brasfield
                                    => 9408,
                            brashear
                                    => 5542, brashears
                                    => 9181,
                            brasher => 4755, braswell
                                    => 1702,
                            bratcher
                                    => 3157, brathwaite
                                    => 9407,
                            bratton => 3172, braud   => 5471, brauer  => 6612, braun   => 997,
                            bravo   => 1505, brawley => 5918, brawner => 5271, braxton => 1724,
                            bray    => 720, brayton => 8075, brazell => 8507, brazelton
                                    => 9287,
                            braziel => 8506, brazier => 7982, breault => 6384, breaux  => 2327,
                            breazeale
                                    => 7539, breckenridge
                                    => 5153,
                            breeden => 2480, breedlove
                                    => 3082,
                            breen   => 2565, brehm   => 4508, breland => 4251, bremer  => 6217,
                            brennan => 655, brenneman
                                    => 7230,
                            brenner => 2020, breslin => 9286, bresnahan
                                    => 7802,
                            bressler
                                    => 9406, breton  => 5080,
                            bretz   => 7394, breuer  => 9285, breunig => 4707, brewer  => 233,
                            brewington
                                    => 4330, brewster
                                    => 1182,
                            brewton => 5722, briceno => 7890, bricker => 4798, brickey => 8505,
                            bridgeman
                                    => 6501, bridgers
                                    => 8171,
                            bridges => 446, bridgewater
                                    => 8170,
                            bridwell
                                    => 8747, brien   => 5428,
                            briggs  => 399, brigham => 4250, bright  => 799, brigman => 9058,
                            briley  => 3958, brill   => 3798, brim    => 3957, brimmer => 7889,
                            brindle => 9903, brink   => 2430, brinker => 7139, brinkerhoff
                                    => 9653,
                            brinkley
                                    => 2072, brinkman
                                    => 3236,
                            brinson => 2198, brinton => 7981, briones => 3264, brisco  => 7138,
                            briscoe => 1967, briseno => 3821, brisson => 8504, brister => 5721,
                            bristow => 4706, brito   => 2605, britt   => 769, brittain
                                    => 3474,
                            brittingham
                                    => 8503, britton => 1022,
                            broadbent
                                    => 7888, broaddus
                                    => 7393,
                            broadnax
                                    => 4038, broadus => 7229,
                            broadwater
                                    => 6383, brochu  => 7709,
                            brock   => 410, brockington
                                    => 5674,
                            brockman
                                    => 3123, brockway
                                    => 5816,
                            brode   => 9180, brodeur => 5627, brodie  => 4705, brodsky => 7887,
                            brody   => 3975, brogan  => 3664, brogdon => 6382, brokaw  => 7392,
                            bromley => 4130, bronson => 2125, brooker => 6270, brookins
                                    => 3974,
                            brooks  => 70, brookshire
                                    => 4111,
                            broom   => 5673, broome  => 2443, broomfield
                                    => 8502,
                            brophy  => 6055, brotherton
                                    => 4549,
                            brough  => 8264, broughton
                                    => 2454,
                            broussard
                                    => 1019, brousseau
                                    => 8746,
                            browder => 3184, brower  => 1906, brown   => 5, browne  => 1364,
                            brownell
                                    => 4013, brownfield
                                    => 6547,
                            browning
                                    => 604, brownlee
                                    => 2339,
                            broyles => 2604, brubaker
                                    => 2819,
                            bruder  => 9284, bruggeman
                                    => 9405,
                            bruhn   => 9788, brumbaugh
                                    => 5580,
                            brumfield
                                    => 2603, brumley => 5079,
                            brummett
                                    => 5119, brundage
                                    => 6269,
                            brune   => 7137, brunelle
                                    => 4860,
                            bruner  => 1630, brunet  => 5507, brunette
                                    => 7801,
                            brunner => 2065, bruns   => 2717, brunson => 1290, brust   => 8745,
                            bruton  => 3542, bryant  => 91, bryson  => 1405, bucci   => 7708,
                            buchan  => 9525, buchanan
                                    => 403,
                            bucher  => 4037, buchholz
                                    => 4548,
                            buchman => 9787, buck    => 664, buckingham
                                    => 3663,
                            buckles => 5427, buckley => 659, buckman => 4933, buckner => 862,
                            budd    => 4308, budde   => 6946, buehler => 4899, buell   => 4797,
                            bueno   => 2493, buenrostro
                                    => 8380,
                            buettner
                                    => 7980, buffington
                                    => 2549,
                            bufford => 8169, bugbee  => 9652, bugg    => 5038, buggs   => 5353,
                            buie    => 4153, bulger  => 8379, bullard => 1162, bullen  => 8618,
                            buller  => 6668, bullington
                                    => 5393,
                            bullins => 6546, bullis  => 7707, bulloch => 9786, bullock => 537,
                            bulter  => 6108, bumgardner
                                    => 6945,
                            bumgarner
                                    => 3650, bumpus  => 9524,
                            bunce   => 8617, bunch   => 920, bundy   => 1941, bunker  => 3525,
                            bunn    => 2153, bunnell => 3453, buntin  => 9651, bunting => 3422,
                            bunton  => 5626, burbach => 9785, burbank => 4249, burch   => 762,
                            burcham => 5352, burchell
                                    => 7979,
                            burchett
                                    => 2537, burchette
                                    => 7468,
                            burchfield
                                    => 2968, burd    => 7391,
                            burden  => 1974, burdett => 4754, burdette
                                    => 2672,
                            burdick => 1955, burdine => 6164, burford => 4824, burg    => 6011,
                            burge   => 2690, burger  => 1314, burgess => 319, burgett => 4932,
                            burgin  => 5672, burgos  => 1316, burk    => 2242, burke   => 226,
                            burkes  => 7136, burkett => 1258, burkey  => 6816, burkhalter
                                    => 5270,
                            burkhardt
                                    => 4389, burkhart
                                    => 1736,
                            burkhead
                                    => 9523, burkholder
                                    => 3749,
                            burks   => 809, burleigh
                                    => 6874,
                            burleson
                                    => 2360, burley  => 3040,
                            burlingame
                                    => 7018, burmeister
                                    => 5269,
                            burnell => 5579, burnett => 455, burnette
                                    => 1466,
                            burney  => 2442, burnham => 1805, burns   => 136, burnside
                                    => 2759,
                            burr    => 1551, burrell => 1121, burress => 5671, burris  => 818,
                            burroughs
                                    => 1448, burrow  => 3630,
                            burrows => 1838, burrus  => 5004, burruss => 8744, burse   => 8743,
                            burson  => 5224, burton  => 215, burwell => 4931, busby   => 1571,
                            busch   => 1764, bush    => 280, bushey  => 4547, bushman => 6268,
                            bushnell
                                    => 5185, buss    => 3452,
                            bussard => 8074, busse   => 5768, bussell => 4753, bussey  => 3276,
                            bustamante
                                    => 2249, bustos  => 3604,
                            butcher => 1313, butler  => 87, butterfield
                                    => 2226,
                            butterworth
                                    => 7017, butts   => 994,
                            butz    => 7538, buxton  => 4036, buzzard => 8742, buzzell => 5720,
                            byars   => 3374, bybee   => 5815, byer    => 8168, byerly  => 6381,
                            byers   => 829, byington
                                    => 6815,
                            byler   => 4752, bynum   => 1465, byram   => 9404, byrd    => 242,
                            byrge   => 9283, byrne   => 1056, byrnes  => 2707, byrum   => 5351,
                            caballero
                                    => 1854, caban   => 3956,
                            cabe    => 7800, cabral  => 2139, cabrales
                                    => 8501,
                            cabrera => 705, caceres => 6738, caddell => 6611, cade    => 2729,
                            cadena  => 4608, cadwell => 7978, cady    => 2808, caesar  => 5578,
                            caffey  => 7228, cagle   => 1908, cahill  => 1424, cahoon  => 5719,
                            cain    => 438, caine   => 7467, caines  => 7706, cairns  => 5268,
                            calabrese
                                    => 3841, calabro => 8073,
                            calahan => 8958, calder  => 5078, caldera => 5267, calderon
                                    => 759,
                            caldwell
                                    => 250, calfee  => 8741,
                            calhoon => 9784, calhoun => 525, calkins => 2758, callaghan
                                    => 3914,
                            callahan
                                    => 550, callan  => 6814,
                            callaway
                                    => 2058, callen  => 5541,
                            callender
                                    => 3411, callihan
                                    => 7537,
                            callis  => 4448, callison
                                    => 6737,
                            calloway
                                    => 1391, calton  => 7306,
                            calvert => 1487, calvillo
                                    => 5625,
                            calvo   => 6380, calzada => 7227, camacho => 630, camara  => 4110,
                            camarena
                                    => 7016, camargo => 8616,
                            camarillo
                                    => 3451, cambell => 3748,
                            camire  => 8500, cammack => 8740, campa   => 9179, campagna
                                    => 7390,
                            campbell
                                    => 44, camper  => 6442,
                            campion => 7536, campo   => 7705, campos  => 548, campuzano
                                    => 8263,
                            canaday => 8072, canady  => 3410, canale  => 9057, canales => 1897,
                            canas   => 9178, candelario
                                    => 6736,
                            candler => 7977, canfield
                                    => 2420,
                            cann    => 6944, cannady => 5223, canning => 7305, cannon  => 344,
                            cano    => 1238, cansler => 9282, cantara => 7704, canter  => 4415,
                            cantin  => 9650, cantor  => 5969, cantrell
                                    => 756,
                            cantu   => 692, cantwell
                                    => 3603,
                            canty   => 2643, capel   => 8739, capers  => 4796, caples  => 9649,
                            caplinger
                                    => 9281, capone  => 5470,
                            capps   => 1253, capuano => 8071, caputo  => 4329, caraballo
                                    => 2642,
                            caraway => 4064, carbajal
                                    => 3704,
                            carballo
                                    => 9902, carbaugh
                                    => 5540,
                            carbone => 2231, carden  => 3018, cardenas
                                    => 687,
                            carder  => 3649, cardin  => 6667, cardinale
                                    => 7886,
                            cardona => 1723, cardone => 9648, cardoso => 7885, cardoza => 3305,
                            cardwell
                                    => 1803, cargile => 8738,
                            cargill => 4930, carillo => 6010, carle   => 9901, carleton
                                    => 6500,
                            carlile => 6379, carlin  => 2621, carlisle
                                    => 1194,
                            carlock => 8378, carlsen => 7226, carlson => 235, carlucci
                                    => 8846,
                            carlyle => 6054, carmack => 4152, carmichael
                                    => 1209,
                            carmody => 5426, carmona => 1770, carnahan
                                    => 2792,
                            carnell => 8845, carner  => 7015, carnes  => 1923, carney  => 833,
                            caro    => 3355, caron   => 1538, carothers
                                    => 4575,
                            carpenter
                                    => 180, carpentier
                                    => 9177,
                            carper  => 4274, carpio  => 8167, carr    => 194, carranza
                                    => 2216,
                            carrasco
                                    => 1727, carrasquillo
                                    => 4574,
                            carraway
                                    => 4823, carreiro
                                    => 8957,
                            carrell => 4307, carreno => 7624, carreon => 4666, carrera => 4035,
                            carreras
                                    => 8844, carrero => 5425,
                            carrico => 3891, carrier => 1656, carrigan
                                    => 4479,
                            carrillo
                                    => 597, carrington
                                    => 1928,
                            carrion => 3421, carrizales
                                    => 8262,
                            carroll => 168, carron  => 9056, carruth => 6053, carruthers
                                    => 5392,
                            carson  => 425, carswell
                                    => 3747,
                            cartagena
                                    => 5718, carter  => 38,
                            cartier => 8737, cartwright
                                    => 1069,
                            carty   => 4328, caruso  => 2103, caruthers
                                    => 4507,
                            carvajal
                                    => 6325, carvalho
                                    => 3249,
                            carver  => 719, carwile => 9403, casanova
                                    => 4222,
                            casares => 5469, casarez => 4447, casas   => 3091, casavant
                                    => 8736,
                            cascio  => 8070, cash    => 825, cashion => 9280, cashman => 4607,
                            casiano => 6052, casias  => 7623, casillas
                                    => 2234,
                            caskey  => 3584, cason   => 2109, casper  => 2419, cass    => 3322,
                            cassady => 5350, cassel  => 8499, cassell => 3992, cassidy => 1279,
                            cassity => 7535, castaneda
                                    => 806,
                            castano => 8166, castanon
                                    => 7135,
                            casteel => 2910, castellano
                                    => 3648,
                            castellanos
                                    => 2026, castelli
                                    => 8843,
                            castello
                                    => 8615, castellon
                                    => 8842,
                            caster  => 9055, castillo
                                    => 196,
                            castleberry
                                    => 3004, castleman
                                    => 6735,
                            casto   => 5037, caston  => 6813, castor  => 5036, castorena
                                    => 8614,
                            castrejon
                                    => 9783, castro  => 260,
                            caswell => 2929, catalan => 7304, catalano
                                    => 3564,
                            cataldo => 9176, catchings
                                    => 8377,
                            cate    => 4195, cater   => 6812, cates   => 1229, cathcart
                                    => 5391,
                            catlett => 4151, catlin  => 6943, cato    => 2728, caton   => 4859,
                            catron  => 3541, caudell => 7703, caudill => 1270, caudle  => 3409,
                            cauley  => 7702, caulfield
                                    => 7225,
                            causey  => 2209, cauthen => 6441, cavallo => 8841, cavanaugh
                                    => 2092,
                            cavazos => 1798, cavender
                                    => 6378,
                            caver   => 9279, cavin   => 8261, caviness
                                    => 6811,
                            cawley  => 6324, cawthon => 7622, caylor  => 7621, cazares => 4221,
                            ceasar  => 7134, ceballos
                                    => 4630,
                            cedeno  => 5222, cedillo => 5424, ceja    => 4194, celaya  => 9278,
                            celis   => 9402, centeno => 3408, cepeda  => 4327, cerda   => 2516,
                            cerna   => 8956, cervantes
                                    => 706,
                            cervantez
                                    => 5814, chabot  => 6810,
                            chacon  => 1622, chadwell
                                    => 7133,
                            chaffee => 6009, chaffin => 2807, chaffins
                                    => 9401,
                            chafin  => 4751, chaidez => 9782, chaisson
                                    => 4704,
                            chalfant
                                    => 8498, chalmers
                                    => 3235,
                            chamberlain
                                    => 953, chamberland
                                    => 9522,
                            chamberlin
                                    => 2818, chambers
                                    => 266,
                            chamblee
                                    => 5717, chambless
                                    => 6216,
                            chambliss
                                    => 3934, chamness
                                    => 6942,
                            champlin
                                    => 5423, chan    => 672,
                            chancey => 5968, chandler
                                    => 297,
                            chaney  => 776, chang   => 607, chao    => 4967, chapa   => 2284,
                            chaparro
                                    => 8165, chapin  => 2831,
                            chaplin => 4306, chapman => 198, chappel => 9400, chappell
                                    => 1060,
                            chapple => 8164, chaput  => 8955, charbonneau
                                    => 7466,
                            charest => 8163, charette
                                    => 5349,
                            charland
                                    => 8613, charlton
                                    => 2659,
                            charpentier
                                    => 9647, charron => 4703,
                            chartier
                                    => 6008, chase   => 457,
                            chasse  => 4858, chastain
                                    => 1940,
                            chasteen
                                    => 6377, chatfield
                                    => 9054,
                            chatham => 6545, chatman => 1422, chauvin => 6544, chavarria
                                    => 2429,
                            chavers => 8612, chaves  => 3933, chavez  => 184, chavira => 8376,
                            chavis  => 1922, cheatham
                                    => 2248,
                            chee    => 5767, cheek   => 1783, cheeks  => 5266, cheever => 9277,
                            chen    => 638, chenault
                                    => 5035,
                            cheney  => 1989, cheng   => 2091, chenoweth
                                    => 5422,
                            cherry  => 686, chesley => 8840, chesney => 9053, chesser => 3680,
                            chesson => 7701, chestnut
                                    => 2277,
                            cheung  => 3140, chevalier
                                    => 4966,
                            chew    => 4012, chewning
                                    => 8375,
                            chiang  => 7389, chiasson
                                    => 9900,
                            chico   => 9399, chidester
                                    => 7700,
                            childers
                                    => 925, childress
                                    => 924,
                            childs  => 898, chiles  => 4795, chilson => 9052, chilton => 3373,
                            chin    => 1486, chinn   => 4150, chipman => 5421, chisholm
                                    => 2359,
                            chism   => 3583, chisolm => 2884, chitwood
                                    => 4063,
                            chiu    => 4149, choate  => 2292, choe    => 5152, choi    => 1297,
                            choquette
                                    => 9781, chou    => 5539,
                            chouinard
                                    => 6941, chow    => 2492,
                            chrisman
                                    => 4414, christensen
                                    => 396,
                            christenson
                                    => 2338, christiansen
                                    => 1582,
                            christianson
                                    => 2689, christman
                                    => 3156,
                            christner
                                    => 7976, christofferso
                                    => 9051,
                            christopherso
                                    => 4857, chronister
                                    => 7534,
                            chumley => 6873, chunn   => 8954, churchill
                                    => 2326,
                            churchwell
                                    => 6809, cifuentes
                                    => 9398,
                            cimino  => 6610, cintron => 2383, cioffi  => 7799, cisco   => 5151,
                            cisneros
                                    => 1076, claar   => 6051,
                            clack   => 7620, claiborne
                                    => 7224,
                            clancy  => 2594, clanton => 3109, clapp   => 3108, clapper => 5034,
                            clardy  => 7798, clark   => 20, clarke  => 434, clarkson
                                    => 2791,
                            clary   => 2316, clausen => 4085, claussen
                                    => 7619,
                            clawson => 3139, claxton => 6107, clayborn
                                    => 9050,
                            claycomb
                                    => 6666, claypool
                                    => 5301,
                            claypoole
                                    => 6808, claytor => 7388,
                            cleary  => 2108, cleaver => 6050, cleaves => 8162, cleek   => 9646,
                            clegg   => 3746, cleghorn
                                    => 6376,
                            cleland => 8497, clem    => 3183, clemens => 2528, clements
                                    => 805,
                            clemmer => 5577, clemmons
                                    => 3090,
                            clemons => 792, clevenger
                                    => 2071,
                            click   => 3647, clift   => 5184, cline   => 528, clinkscales
                                    => 8374,
                            cloninger
                                    => 7387, clontz  => 9397,
                            clopton => 9780, cloud   => 1954, clough  => 2909, clouse  => 4174,
                            clouser => 9396, cloutier
                                    => 2025,
                            clover  => 7132, clow    => 7618, clower  => 7617, clowers => 8611,
                            cloyd   => 7223, cluck   => 9521, cluff   => 8069, clyburn => 5917,
                            clymer  => 8610, coakley => 4794, coan    => 8373, coates  => 1186,
                            coats   => 1797, cobb    => 368, cobbs   => 2883, coble   => 2908,
                            cobos   => 5813, coburn  => 1997, cochran => 456, cochrane
                                    => 3473,
                            cockerham
                                    => 5716, cockrell
                                    => 2466,
                            coddington
                                    => 8953, coelho  => 8260,
                            coen    => 7465, cofer   => 4898, coffelt => 7699, coffey  => 746,
                            coffield
                                    => 9645, coffin  => 2706,
                            coffman => 1029, cofield => 4478, cogan   => 8259, cogburn => 9779,
                            coggins => 4034, cogswell
                                    => 7797,
                            cohan   => 9175, cohen   => 335, cohn    => 3089, coil    => 8161,
                            coker   => 1136, colangelo
                                    => 7222,
                            colbert => 1123, colburn => 2486, coldiron
                                    => 8496,
                            cole    => 103, colella => 6215, coleman => 78, coles   => 1804,
                            coley   => 1629, colgan  => 8839, collado => 3820, collard => 6375,
                            collazo => 2264, collett => 4129, colletti
                                    => 7386,
                            colley  => 3003, collier => 442, collings
                                    => 8609,
                            collins => 48, collinsworth
                                    => 7221,
                            collis  => 9778, collum  => 7616, colman  => 6374, colombo => 6665,
                            colon   => 385, colquitt
                                    => 6664,
                            colson  => 2928, colston => 4305, colter  => 6106, colucci => 5576,
                            colunga => 4793, colvin  => 1275, colwell => 3155, colyer  => 9520,
                            combs   => 484, comeau  => 5118, comeaux => 4062, comer   => 1651,
                            compton => 788, comstock
                                    => 2620,
                            conant  => 5670, conard  => 9395, conaway => 3540, conde   => 5265,
                            conder  => 8952, condon  => 2593, cone    => 2777, coney   => 4665,
                            confer  => 7615, congdon => 7014, conger  => 3776, conklin => 1176,
                            conley  => 453, conlin  => 6663, conlon  => 4792, conn    => 1353,
                            connally
                                    => 8068, connell => 1554,
                            connelly
                                    => 1430, conner  => 362,
                            conners => 3775, connolly
                                    => 1152,
                            connor  => 934, connors => 1588, conover => 3081, conroy  => 1878,
                            constantine
                                    => 6049, constantino
                                    => 6662,
                            conte   => 3890, conti   => 2899, contreras
                                    => 500,
                            converse
                                    => 5264, conway  => 579,
                            conwell => 6214, conyers => 3285, cook    => 54, cooke   => 867,
                            cooks   => 2927, cooksey => 3889, cookson => 8160, cooley  => 749,
                            coolidge
                                    => 8495, coombs  => 3171,
                            coomer  => 6105, coomes  => 9777, coon    => 1515, cooney  => 2453,
                            coonrod => 8951, coons   => 3662, cooper  => 60, coots   => 9519,
                            cope    => 1306, copeland
                                    => 405,
                            copenhaver
                                    => 7220, copley  => 3138,
                            coppage => 7796, copple  => 9776, coppock => 9518, coppola => 3861,
                            corbett => 969, corbin  => 1058, corbitt => 3724, corby   => 9899,
                            corcoran
                                    => 1668, cordeiro
                                    => 5263,
                            corder  => 4750, cordero => 1312, cordes  => 5506, cordle  => 8838,
                            cordoba => 8067, cordova => 959, coria   => 9174, corley  => 1352,
                            cormier => 1261, cornejo => 4109, cornelison
                                    => 6940,
                            cornett => 1235, cornish => 2337, cornwell
                                    => 2299,
                            corona  => 1478, coronado
                                    => 1700,
                            coronel => 7464, corpuz  => 7463, corr    => 8159, corrado => 9276,
                            corral  => 3002, corrales
                                    => 5505,
                            correa  => 1092, correia => 3407, correll => 4546, corrigan
                                    => 3200,
                            corriveau
                                    => 6213, corso   => 6373,
                            corson  => 5868, cortes  => 1382, cortese => 8066, cortez  => 433,
                            cortinas
                                    => 9898, corum   => 6661,
                            corwin  => 3913, cosby   => 2485, cosentino
                                    => 8258,
                            cosey   => 9275, cosgrove
                                    => 3511,
                            cosme   => 4629, cosper  => 6440, coss    => 7013, cossey  => 9517,
                            costa   => 933, costanzo
                                    => 7385,
                            costello
                                    => 1107, coston  => 5390,
                            cota    => 2582, cote    => 786, cothran => 3888, cotten  => 4606,
                            cotter  => 2735, cottingham
                                    => 5183,
                            cottle  => 4193, cotto   => 4929, cotton  => 752, cottrell
                                    => 1822,
                            cottrill
                                    => 8735, couch   => 1064,
                            coughlin
                                    => 2197, coulombe
                                    => 5967,
                            coulson => 6163, coulter => 1346, countryman
                                    => 6543,
                            counts  => 2790, cournoyer
                                    => 9173,
                            coursey => 9775, courson => 6162, courtemanche
                                    => 9774,
                            courtright
                                    => 9644, coury   => 9643,
                            cousins => 2727, couto   => 9897, couture => 1812, covarrubias
                                    => 5003,
                            covell  => 9172, covert  => 3372, covey   => 3563, covington
                                    => 916,
                            cowan   => 878, cowans  => 6807, coward  => 3450, cowart  => 2428,
                            cowden  => 6806, cowell  => 3991, cowen   => 5002, cowgill => 7884,
                            cowles  => 3797, cowley  => 3796, cox     => 62, coyle   => 1717,
                            coyne   => 3137, cozart  => 5715, crabb   => 5117, crabtree
                                    => 979,
                            craddock
                                    => 3248, craft   => 791,
                            crafton => 6104, craighead
                                    => 7975,
                            crain   => 1510, cram    => 6734, cramer  => 1005, crampton
                                    => 7384,
                            crandall
                                    => 1587, crandell
                                    => 5077,
                            cranford
                                    => 3341, cranmer => 8837,
                            crase   => 9516, craven  => 1933, cravens => 5300, craver  => 6212,
                            crawford
                                    => 127, crawley => 2283,
                            cray    => 8494, crayton => 3182, creamer => 3510, creasy  => 8065,
                            creech  => 1870, creed   => 4220, creekmore
                                    => 6007,
                            creel   => 3088, creighton
                                    => 3031,
                            crenshaw
                                    => 1495, crespo  => 2080,
                            cress   => 4219, creswell
                                    => 8734,
                            crews   => 1172, cribb   => 7462, cribbs  => 5624, crick   => 8950,
                            crider  => 2658, crigger => 8493, crim    => 5966, crimmins
                                    => 9171,
                            criner  => 8372, crippen => 7795, crisp   => 1877, criss   => 5033,
                            crissman
                                    => 8158, crist   => 2501,
                            criswell
                                    => 3703, critchlow
                                    => 9642,
                            crites  => 5032, crittenden
                                    => 3406,
                            crittendon
                                    => 9515, crochet => 8257,
                            crocker => 1132, crockett
                                    => 1067,
                            croft   => 1890, cromer  => 2926, cromwell
                                    => 2358,
                            crone   => 7698, cronin  => 1708, cronk   => 5669, crook   => 1756,
                            crooks  => 2581, croom   => 5182, cropper => 5714, crosby  => 667,
                            cross   => 322, crossland
                                    => 6499,
                            crossley
                                    => 5262, crossman
                                    => 4304,
                            crosson => 7533, croteau => 2734, crotty  => 6939, crouch  => 1043,
                            crouse  => 2175, crow    => 1021, crowder => 1180, crowe   => 891,
                            crowell => 1418, crowl   => 8371, crowley => 917, crowson => 7012,
                            crowther
                                    => 8492, croy    => 4928,
                            crozier => 5867, cruce   => 7974, crum    => 958, crumb   => 7076,
                            crumbley
                                    => 9641, crumley => 5389,
                            crump   => 1284, crumpler
                                    => 6938,
                            crumpton
                                    => 4173, cruse   => 3405,
                            crutcher
                                    => 2641, crutchfield
                                    => 2817,
                            cruz    => 113, cuellar => 1939, cuevas  => 1044, culberson
                                    => 8836,
                            culbertson
                                    => 2757, culbreth
                                    => 6805,
                            cull    => 7532, cullen  => 1581, culler  => 5538, culley  => 7883,
                            cullinan
                                    => 9514, cullins => 9394,
                            cullum  => 7882, culp    => 2253, culpepper
                                    => 2196,
                            culver  => 1550, cumberbatch
                                    => 8835,
                            cumming => 6323, cummings
                                    => 309,
                            cummins => 1231, cundiff => 4791, cunha   => 7075, cunningham
                                    => 172,
                            cuomo   => 5812, cupp    => 3562, curcio  => 8064, cureton => 4897,
                            curiel  => 4388, curl    => 6048, curlee  => 9640, curley  => 2145,
                            curran  => 1226, currey  => 8733, currie  => 1525, currier => 2225,
                            currin  => 6103, curry   => 288, curtin  => 3449, curtiss => 6439,
                            curtsinger
                                    => 9896, cusack  => 8491,
                            cushing => 4218, cushman => 3646, cusick  => 5388, custer  => 2907,
                            cuthbertson
                                    => 7697, cutler  => 1853,
                            cutlip  => 9895, cutright
                                    => 8370,
                            cutshall
                                    => 7383, cutts   => 9773,
                            dabbs   => 4248, dabney  => 3819, dabrowski
                                    => 8949,
                            dacosta => 4303, dade    => 8732, daggett => 4965, dagostino
                                    => 4273,
                            dahl    => 1333, dahlberg
                                    => 7696,
                            dahlgren
                                    => 6660, daigle  => 1739,
                            dail    => 7011, dailey  => 929, dalessandro
                                    => 6659,
                            dalessio
                                    => 6733, daley   => 1283,
                            dalrymple
                                    => 4605, dalton  => 540,
                            daly    => 1151, damato  => 6161, dambrosio
                                    => 7131,
                            dameron => 6438, damiano => 7614, damico  => 2635, dampier => 7881,
                            damron  => 3107, dancy   => 3106, dandrea => 5001, dandridge
                                    => 6322,
                            danford => 7794, danforth
                                    => 4217,
                            dang    => 3354, dangelo => 3105, dangerfield
                                    => 7695,
                            daniels => 144, danielson
                                    => 2898,
                            danley  => 6006, danner  => 2688, dansby  => 5150, dantzler
                                    => 5076,
                            darby   => 1473, dardar  => 4664, darden  => 1491, darr    => 4749,
                            darrah  => 8834, darrow  => 4663, dart    => 8157, dasher  => 6804,
                            dashiell
                                    => 8490, dasilva => 3539,
                            daugherty
                                    => 770, daughtery
                                    => 9772,
                            daughtry
                                    => 3955, davalos => 9393,
                            davenport
                                    => 458, daves   => 7010,
                            davey   => 4790, davidson
                                    => 243,
                            davie   => 7694, davies  => 947, davila  => 1034, davis   => 6, davison => 1289,
                            davisson
                                    => 7303, davy    => 7880,
                            dawes   => 4545, dawkins => 1402, dawson  => 283, daye    => 5468,
                            dayton  => 3538, deanda  => 5221, deangelis
                                    => 4628,
                            deans   => 6047, dearborn
                                    => 6160,
                            dearing => 4477, dearman => 7531, deas    => 6102, deason  => 4476,
                            deatherage
                                    => 9274, deaton  => 1921,
                            deaver  => 7130, deberry => 4033, deboer  => 4272, debolt  => 9513,
                            debord  => 9771, debose  => 5965, decamp  => 9392, decarlo => 6372,
                            decastro
                                    => 6267, decicco => 9512,
                            deckard => 5964, decker  => 564, decosta => 5149, decoteau
                                    => 4475,
                            dedmon  => 9770, dedrick => 9170, deegan  => 8156, deel    => 7219,
                            deemer  => 9049, deen    => 5420, deering => 4474, dees    => 2925,
                            deese   => 4748, deeter  => 9769, defazio => 8489, defelice
                                    => 6872,
                            deforest
                                    => 7973, degraff => 9391,
                            degraw  => 8155, degroot => 8369, deguzman
                                    => 6437,
                            dehaan  => 9048, dehart  => 2671, dehaven => 4506, deherrera
                                    => 7879,
                            deitz   => 6732, dejesus => 852, dejong  => 7793, delacruz
                                    => 850,
                            delafuente
                                    => 5299, delagarza
                                    => 2657,
                            delancey
                                    => 8488, delaney => 810,
                            delano  => 5713, delao   => 7009, delapaz => 5181, delapena
                                    => 9511,
                            delarosa
                                    => 1031, delatorre
                                    => 2057,
                            delcastillo
                                    => 9169, deleo   => 8833,
                            deleon  => 522, delgadillo
                                    => 3537,
                            delgado => 330, delisle => 4413, delk    => 6046, dellinger
                                    => 2897,
                            deloach => 2271, deloatch
                                    => 9047,
                            delong  => 1655, delorenzo
                                    => 7613,
                            delossantos
                                    => 2592, delozier
                                    => 7792,
                            delp    => 6436, delreal => 8832, delrio  => 4387, delrosario
                                    => 7302,
                            deltoro => 7461, deluca  => 2312, delucia => 9390, deluna  => 5116,
                            delvalle
                                    => 2382, delvecchio
                                    => 8731,
                            demaio  => 8831, demarco => 2776, demars  => 7218, demello => 6266,
                            dement  => 6265, demers  => 3122, deming  => 5220, demoss  => 5115,
                            demps   => 8830, dempsey => 1075, dendy   => 6435, denham  => 2906,
                            denison => 4822, denman  => 4148, dennard => 5963, denney  => 2491,
                            dennie  => 9894, denning => 3001, dennison
                                    => 1506,
                            densmore
                                    => 5348, denson  => 1821,
                            dent    => 1866, denton  => 1049, depalma => 7972, depasquale
                                    => 9389,
                            depew   => 5000, depriest
                                    => 4573,
                            derosa  => 3875, derose  => 7382, derosier
                                    => 6731,
                            derouen => 7878, derr    => 3472, derry   => 5668, derryberry
                                    => 7217,
                            desai   => 4361, desalvo => 8063, desantiago
                                    => 9639,
                            desantis
                                    => 3080, deschamps
                                    => 9510,
                            deshields
                                    => 9768, desilva => 5261,
                            desimone
                                    => 3795, desjardins
                                    => 4247,
                            desmarais
                                    => 5148, desousa => 9767,
                            desouza => 8368, despain => 6937, desrochers
                                    => 5866,
                            desroches
                                    => 9638, desrosiers
                                    => 4604,
                            destefano
                                    => 5575, detwiler
                                    => 7301,
                            deutsch => 4326, devaney => 7460, devaughn
                                    => 7612,
                            devault => 8608, deveau  => 8829, dever   => 4964, deville => 6159,
                            devine  => 1293, devito  => 3321, devlin  => 2806, devoe   => 4386,
                            devore  => 2282, devries => 2993, dewall  => 8828, dewar   => 8062,
                            dewberry
                                    => 7381, deweese => 5260,
                            dews    => 6211, deyo    => 8730, deyoung => 4108, dial    => 2634,
                            diamond => 1401, dias    => 1896, diaz    => 94, dibble  => 4107,
                            dibenedetto
                                    => 8948, dicarlo => 6434,
                            dicken  => 6730, dickens => 1260, dickenson
                                    => 5031,
                            dickerson
                                    => 464, dickey  => 1070,
                            dickinson
                                    => 1018, dickman => 5766,
                            dicks   => 5537, dickson => 703, diehl   => 2010, diemer  => 9509,
                            diep    => 7008, dieter  => 9508, dietrich
                                    => 1962,
                            dietz   => 1830, diez    => 7530, diggins => 7791, diggs   => 1537,
                            digiacomo
                                    => 7790, digiovanni
                                    => 7459,
                            dileo   => 8947, dill    => 1498, dillard => 772, diller  => 8607,
                            dilley  => 5916, dillingham
                                    => 5219,
                            dillion => 6158, dillman => 6157, dillon  => 725, dillow  => 6871,
                            dills   => 9637, dilorenzo
                                    => 7789,
                            dilworth
                                    => 4702, dimaggio
                                    => 6264,
                            dimarco => 7971, dimas   => 8946, dimmick => 8487, dinardo => 9636,
                            dineen  => 8606, dinger  => 7216, dingess => 5259, dingle  => 4246,
                            dingman => 5574, dingus  => 8061, dinh    => 5623, dinkins => 3954,
                            dinsmore
                                    => 5467, dinwiddie
                                    => 9168,
                            diorio  => 8060, dipasquale
                                    => 9766,
                            dipietro
                                    => 5915, dirks   => 7970,
                            dishman => 5030, dismuke => 7611, distefano
                                    => 6005,
                            dittman => 8605, dittmer => 8256, dixon   => 133, dixson  => 6870,
                            dizon   => 7877, doak    => 6498, doan    => 3136, doane   => 4896,
                            dobbins => 1716, dobbs   => 1816, dobson  => 1113, doby    => 7458,
                            dockery => 2465, dodd    => 923, dodds   => 4011, dodge   => 1294,
                            dodson  => 626, doering => 6433, doerr   => 4572, doggett => 5347,
                            doherty => 1249, doiron  => 8154, dolan   => 1282, dolby   => 9273,
                            dole    => 7215, dolphin => 9507, dombrowski
                                    => 5466,
                            dominguez
                                    => 481, dominquez
                                    => 3932,
                            donahoe => 8945, donahue => 963, donaldson
                                    => 691,
                            donato  => 3990, donegan => 8367, donelson
                                    => 7788,
                            dones   => 9388, doney   => 7007, donley  => 4128, donnelly
                                    => 1120,
                            donner  => 6729, donofrio
                                    => 5865,
                            donohoe => 7787, donohue => 2578, doody   => 7693, dooley  => 1062,
                            doolittle
                                    => 3989, dorado  => 7380,
                            doran   => 1662, dore    => 5962, dorman  => 2009, dorn    => 2861,
                            dorr    => 5258, dorsett => 5573, dorsey  => 536, dortch  => 3774,
                            dorton  => 7876, doss    => 1206, doster  => 8827, dostie  => 7379,
                            dotson  => 669, doty    => 1575, doucet  => 4747, doucette
                                    => 4084,
                            doud    => 7786, dougherty
                                    => 888,
                            doughty => 2536, dove    => 1673, dover   => 3030, dowd    => 2263,
                            dowdell => 4192, dowden  => 6936, dowdle  => 9167, dowdy   => 1596,
                            dowell  => 2024, dowler  => 9046, dowling => 1953, downer  => 5864,
                            downes  => 4106, downey  => 1061, downie  => 9272, downing => 961,
                            downs   => 843, doyle   => 382, doyon   => 6321, dozier  => 1735,
                            draeger => 9635, drain   => 4446, drake   => 415, drakeford
                                    => 9765,
                            drakes  => 9893, draper  => 1165, drayton => 3773, drees   => 7006,
                            dreher  => 5298, dreiling
                                    => 9634,
                            drennan => 6320, drennen => 7129, dressler
                                    => 5765,
                            drews   => 8153, dreyer  => 5961, driggers
                                    => 4127,
                            drinkard
                                    => 9633, driscoll
                                    => 1332,
                            driskell
                                    => 5346, driskill
                                    => 8826,
                            driver  => 1682, drouin  => 7875, drumm   => 8486, drummond
                                    => 1368,
                            drury   => 2951, dryden  => 5114, drye    => 7610, duarte  => 1164,
                            dubay   => 9387, dube    => 1775, dubin   => 9506, dubois  => 1072,
                            dubose  => 1713, ducharme
                                    => 4505,
                            duckett => 3121, duckworth
                                    => 1996,
                            duclos  => 8485, duda    => 6210, dudek   => 6542, duenas  => 4789,
                            duff    => 1834, duffey  => 6156, duffield
                                    => 9045,
                            duffy   => 778, dufour  => 7005, dufrene => 7692, dufresne
                                    => 5764,
                            dugan   => 1452, dugas   => 3818, duggan  => 2381, dugger  => 2940,
                            duggins => 7457, duguay  => 8825, duhon   => 5811, duke    => 767,
                            dukes   => 1193, dulaney => 4191, duley   => 8604, dulin   => 7128,
                            dumas   => 1266, dumont  => 4032, dunagan => 6155, dunaway => 2716,
                            dunbar  => 987, duncan  => 169, dunford => 6371, dungan  => 7529,
                            dunham  => 1135, dunigan => 7609, dunkin  => 6869, dunkle  => 6609,
                            dunkley => 9632, dunlap  => 742, dunleavy
                                    => 7456,
                            dunlop  => 6541, dunmire => 9044, dunn    => 153, dunne   => 3471,
                            dunnigan
                                    => 9271, dunning => 2479,
                            dunphy  => 8944, dunson  => 6803, dunston => 6209, dunton  => 6208,
                            duong   => 3536, duplessis
                                    => 6728,
                            dupont  => 2744, dupre   => 1873, dupree  => 1217, duprey  => 5914,
                            dupuis  => 2733, duque   => 6727, duquette
                                    => 5712,
                            duran   => 533, durand  => 3794, durant  => 2102, durante => 8729,
                            durbin  => 2033, durden  => 3392, duren   => 8255, durfee  => 6207,
                            durgin  => 9166, durham  => 615, durkee  => 5913, durkin  => 3931,
                            duron   => 6802, durr    => 3509, durrant => 9386, durrett => 5810,
                            durso   => 8824, durst   => 4788, dusek   => 9385, dutcher => 4963,
                            dutra   => 6154, dutton  => 1600, duval   => 2983, duvall  => 1472,
                            dvorak  => 4895, dwyer   => 1167, dycus   => 9043, dyer    => 498,
                            dyess   => 9270, dyke    => 5809, dykes   => 1793, dykstra => 4473,
                            dyson   => 2087, eaddy   => 7874, eades   => 4627, eads    => 4126,
                            eady    => 5147, eagan   => 6004, eakin   => 7378, eakins  => 7300,
                            ealey   => 9505, eames   => 7608, eanes   => 7969, earles  => 9631,
                            earley  => 2805, earls   => 3817, earp    => 7214, easley  => 1504,
                            eason   => 1520, easterday
                                    => 7968,
                            easterling
                                    => 2871, easterwood
                                    => 9764,
                            eastman => 1413, easton  => 3284, eastwood
                                    => 5465,
                            eatmon  => 7785, eaton   => 527, eaves   => 2640, ebeling => 9165,
                            eberhardt
                                    => 5711, eberhart
                                    => 8823,
                            eberle  => 5464, eberly  => 6935, ebersole
                                    => 7607,
                            ebert   => 2270, ebner   => 7967, eccles  => 7074, eccleston
                                    => 9504,
                            echevarria
                                    => 3353, echeverria
                                    => 5863,
                            echols  => 1522, eckard  => 8728, eckenrode
                                    => 8484,
                            ecker   => 7213, eckert  => 1763, eckhardt
                                    => 6801,
                            eckhoff => 9503, eckles  => 9630, ecklund => 8727, eckman  => 6101,
                            eckstein
                                    => 6934, eddings => 5622,
                            eddington
                                    => 8059, eddins  => 5345,
                            edelman => 6045, edelstein
                                    => 5763,
                            edenfield
                                    => 9763, edens   => 4360,
                            edgerton
                                    => 5808, edgington
                                    => 8726,
                            edington
                                    => 6263, edmiston
                                    => 5762,
                            edmonds => 1142, edmondson
                                    => 1707,
                            edmonson
                                    => 5667, edmunds => 4302,
                            edmundson
                                    => 7784, edson   => 5666,
                            edwards => 47, eells   => 8943, egan    => 1376, egbert  => 4603,
                            eggen   => 9384, egger   => 7783, eggers  => 4472, eggert  => 5572,
                            eggleston
                                    => 2347, ehlers  => 4602,
                            ehlert  => 9502, ehrhardt
                                    => 9383,
                            ehrlich => 4856, eichelberger
                                    => 6868,
                            eicher  => 6262, eichhorn
                                    => 7212,
                            eichler => 7782, eidson  => 5807, eiland  => 6370, eilers  => 9042,
                            eisele  => 8254, eisenberg
                                    => 4701,
                            eisenhauer
                                    => 9164, eklund  => 7873,
                            elam    => 2003, elder   => 875, eldred  => 5075, eldredge
                                    => 5297,
                            eldridge
                                    => 996, eley    => 5571,
                            elgin   => 7872, eliason => 6497, elizalde
                                    => 9501,
                            elizondo
                                    => 2982, elkin   => 8822,
                            elkins  => 1011, elledge => 6100, ellender
                                    => 8152,
                            eller   => 2015, ellinger
                                    => 6540,
                            ellingson
                                    => 5257, ellington
                                    => 2233,
                            elliott => 183, ellis   => 109, ellison => 588, ellzey  => 9629,
                            elmore  => 1004, elrod   => 2325, elson   => 7073, elston  => 3535,
                            elswick => 7871, elwell  => 4746, embree  => 6867, embrey  => 8725,
                            embry   => 3170, emerick => 4626, emmert  => 6319, emmons  => 2336,
                            emrich  => 8724, emrick  => 8151, encarnacion
                                    => 7781,
                            encinas => 9892, enciso  => 8603, enders  => 9762, endicott
                                    => 5761,
                            endres  => 6608, endsley => 7127, engel   => 1363, engelhardt
                                    => 5463,
                            engen   => 9628, engle   => 1477, englehart
                                    => 8942,
                            engleman
                                    => 8150, engler  => 5504,
                            englert => 5113, engram  => 8366, engstrom
                                    => 5074,
                            enloe   => 7528, enlow   => 9627, ennis   => 1820, enos    => 3275,
                            enright => 3874, enriquez
                                    => 1241,
                            ensley  => 8941, ensor   => 7870, epley   => 7606, epperson
                                    => 1860,
                            epps    => 1302, epstein => 2789, erdman  => 4894, erdmann => 4010,
                            erickson
                                    => 359, ericson => 5180,
                            erikson => 9163, ernst   => 1734, erskine => 4962, erving  => 9162,
                            escalante
                                    => 2656, escalera
                                    => 8602,
                            escamilla
                                    => 2535, escobar => 960,
                            escobedo
                                    => 1787, eshelman
                                    => 7299,
                            eskew   => 6318, eskridge
                                    => 4147,
                            eslinger
                                    => 8601, espada  => 9161,
                            esparza => 1179, espinal => 2830, espino  => 3745, espinosa
                                    => 1102,
                            espinoza
                                    => 468, esposito
                                    => 1618,
                            esqueda => 7780, esquibel
                                    => 5760,
                            esquivel
                                    => 1697, essary  => 8253,
                            esser   => 8821, estabrook
                                    => 6539,
                            estep   => 2230, estes   => 625, esteves => 9761, estevez => 4146,
                            estrada => 376, etheridge
                                    => 1938,
                            ethridge
                                    => 3873, etienne => 8149,
                            etter   => 6099, eubank  => 4544, eubanks => 1367, eudy    => 5503,
                            eure    => 8723, evangelista
                                    => 6432,
                            evans   => 46, eveland => 8483, evens   => 8820, evenson => 5536,
                            everhart
                                    => 2473, everitt => 8819,
                            everly  => 9269, evers   => 3247, eversole
                                    => 6153,
                            everson => 3930, ewald   => 5387, ewell   => 5386, ewers   => 8482,
                            ewing   => 748, exley   => 9760, exum    => 5535, eyler   => 7527,
                            eyre    => 7298, ezell   => 1706, ezzell  => 8481, faber   => 3320,
                            fabrizio
                                    => 7869, fagan   => 1705,
                            fagundes
                                    => 9759, fahey   => 3340,
                            fain    => 2967, fairbanks
                                    => 2756,
                            fairchild
                                    => 1920, faircloth
                                    => 4601,
                            fairfield
                                    => 8722, fairley => 2882,
                            fairman => 9041, faison  => 2992, fajardo => 3135, falco   => 7004,
                            falcon  => 2527, falcone => 4745, falconer
                                    => 9160,
                            falgoust
                                    => 5462, falgout => 7377,
                            falk    => 2705, falkner => 7126, fancher => 4359, fanelli => 6866,
                            fang    => 7779, fann    => 7072, fannin  => 4190, fanning => 2611,
                            fant    => 5296, farber  => 4999, faria   => 5029, farias  => 3154,
                            farina  => 5806, faris   => 4662, farkas  => 5710, farley  => 726,
                            farlow  => 9758, farmer  => 329, farnham => 6206, farnsworth
                                    => 2131,
                            farnum  => 9891, farr    => 1222, farrar  => 1869, farrell => 582,
                            farrer  => 9626, farrington
                                    => 2564,
                            farris  => 967, farrow  => 2409, farthing
                                    => 7868,
                            farwell => 6369, fasano  => 8480, fassett => 6658, faucett => 9382,
                            faucher => 7211, faught  => 8365, faulk   => 1672, faulkner
                                    => 675,
                            faust   => 1755, favela  => 5862, fawcett => 4125, fazio   => 5419,
                            feagin  => 9159, feaster => 4661, featherston
                                    => 7605,
                            featherstone
                                    => 6800, fecteau => 6538,
                            feder   => 7297, fedor   => 8940, feeley  => 7210, feeney  => 3448,
                            fehr    => 8600, feinberg
                                    => 7003,
                            feinstein
                                    => 8148, felder  => 1782,
                            feldman => 1301, feldmann
                                    => 9268,
                            feliciano
                                    => 1247, felker  => 4571,
                            feller  => 4821, fellers => 8599, fellows => 3793, feltner => 7778,
                            felts   => 4009, felty   => 8818, fender  => 4216, fenderson
                                    => 8147,
                            fendley => 7777, fenn    => 4855, fennell => 2247, fenner  => 3391,
                            fenske  => 8598, fenton  => 1661, fenwick => 4215, ferebee => 5570,
                            fergerson
                                    => 9757, ferguson
                                    => 150,
                            ferland => 5960, fernandes
                                    => 2408,
                            fernandez
                                    => 212, ferrante
                                    => 4854,
                            ferrara => 2526, ferrari => 3840, ferraro => 2939, ferree  => 7776,
                            ferreira
                                    => 1351, ferrel  => 8817,
                            ferrell => 755, ferrer  => 2704, ferretti
                                    => 7966,
                            ferri   => 7604, ferrin  => 8364, ferris  => 1200, ferro   => 4271,
                            fessler => 8252, fetter  => 5028, fetters => 9756, fewell  => 7125,
                            fick    => 5385, fidler  => 5073, fiedler => 4961, fielder => 3772,
                            fielding
                                    => 5072, fields  => 191,
                            fierro  => 3224, fife    => 3702, fifield => 6496, figueroa
                                    => 424,
                            fike    => 4385, fikes   => 6537, fillmore
                                    => 4998,
                            finch   => 836, fincher => 2950, findlay => 5959, findley => 3029,
                            fink    => 1119, finke   => 8479, finkel  => 9381, finkelstein
                                    => 7526,
                            finkle  => 8251, finlay  => 7525, finley  => 649, finn    => 1381,
                            finnegan
                                    => 3561, finnell => 7603,
                            finnerty
                                    => 9890, finney  => 1732,
                            fiore   => 3679, fiorentino
                                    => 8939,
                            firestone
                                    => 8938, firth   => 8146,
                            fischer => 493, fiscus  => 7965, fisher  => 108, fishman => 3223,
                            fisk    => 2500, fiske   => 7691, fitch   => 1345, fite    => 3839,
                            fitts   => 3492, fitz    => 5912, fitzgerald
                                    => 380,
                            fitzhugh
                                    => 6933, fitzpatrick
                                    => 779,
                            fitzsimmons
                                    => 3339, fitzwater
                                    => 5218,
                            flack   => 5958, flagg   => 3645, flaherty
                                    => 1792,
                            flake   => 7455, flanagan
                                    => 957,
                            flanders
                                    => 2726, flanigan
                                    => 4008,
                            flannery
                                    => 2896, flannigan
                                    => 9040,
                            flatt   => 5759, fleck   => 3435, fleenor => 6261, fleetwood
                                    => 5911,
                            fleischer
                                    => 7071, fleming => 239,
                            flemming
                                    => 3701, flesher => 8363,
                            fleshman
                                    => 9039, fletcher
                                    => 269,
                            fleury  => 5665, flick   => 4301, flickinger
                                    => 8721,
                            flinn   => 5910, flint   => 1650, flood   => 1691, flores  => 85,
                            florez  => 3661, florio  => 8478, flory   => 6098, flournoy
                                    => 3973,
                            flowers => 367, fluellen
                                    => 8250,
                            fluker  => 7296, flynn   => 467, flynt   => 8597, fogarty => 3929,
                            fogel   => 6097, fogg    => 4031, fogle   => 2452, foley   => 611,
                            folger  => 9500, follett => 7964, folse   => 3338, folsom  => 2602,
                            foltz   => 3953, fong    => 2981, fonseca => 2591, fontaine
                                    => 2101,
                            fontana => 6003, fontanez
                                    => 8477,
                            fontenot
                                    => 1008, fontes  => 7209,
                            foote   => 1688, foran   => 8720, forbes  => 854, forbis  => 8058,
                            forcier => 8719, ford    => 97, forde   => 4700, fordham => 5112,
                            fordyce => 9499, fore    => 5502, forehand
                                    => 7775,
                            foreman => 847, forester
                                    => 6317,
                            foret   => 3700, forman  => 2252, forney  => 3524, forsberg
                                    => 6431,
                            forster => 3912, forsyth => 2991, forsythe
                                    => 2380,
                            forte   => 2441, fortenberry
                                    => 3420,
                            fortier => 2305, fortin  => 2478, fortner => 2195, fortney => 4245,
                            fortson => 6726, fortuna => 8249, fortunato
                                    => 7454,
                            foshee  => 8816, foss    => 2038, foster  => 89, foti    => 8362,
                            foulk   => 8937, fountain
                                    => 1204,
                            fournier
                                    => 1461, foust   => 2174,
                            fouts   => 5217, fowler  => 232, fowlkes => 4172, fox     => 177,
                            foxworth
                                    => 6607, frady   => 8361,
                            fraga   => 6316, fraire  => 9625, fraizer => 8815, frakes  => 9624,
                            fraley  => 2173, frampton
                                    => 8057,
                            franck  => 7690, franco  => 736, francois
                                    => 2816,
                            franke  => 4853, frankel => 4852, franklin
                                    => 189,
                            franko  => 8718, franks  => 840, frantz  => 2451, franz   => 2938,
                            franzen => 5957, fraser  => 1171, frasher => 8936, frausto => 6657,
                            frawley => 6315, frazee  => 5664, frazer  => 3678, frazier => 225,
                            frechette
                                    => 6002, fredericks
                                    => 3744,
                            frederickson
                                    => 6865, fredette
                                    => 5861,
                            fredricks
                                    => 8814, fredrickson
                                    => 3743,
                            freed   => 3508, freedman
                                    => 3371,
                            freeland
                                    => 4124, freeman => 118,
                            freer   => 8935, freese  => 4007, fregoso => 7867, freitag => 6430,
                            freitas => 2980, fretwell
                                    => 7208,
                            freund  => 3560, frey    => 1096, frias   => 3209, frick   => 3523,
                            fricke  => 7124, friedman
                                    => 893,
                            friel   => 6429, frierson
                                    => 3559,
                            friesen => 5956, frink   => 5621, frisbee => 8717, frisbie => 6314,
                            frisby  => 5805, frisch  => 6932, frison  => 9158, fritch  => 9498,
                            frith   => 5344, fritsch => 8934, fritts  => 4543, frizzell
                                    => 3699,
                            froehlich
                                    => 7002, fromm   => 8248,
                            frost   => 644, fruge   => 7963, fry     => 764, fryar   => 8813,
                            frye    => 774, fryer   => 3698, fryman  => 9623, fuchs   => 2755,
                            fudge   => 5620, fuentes => 695, fugate  => 1745, fuhrman => 5027,
                            fujimoto
                                    => 8596, fulbright
                                    => 7376,
                            fulcher => 3602, fulford => 5758, fulgham => 8933, fulk    => 5071,
                            fulkerson
                                    => 4189, fulks   => 5955,
                            fuller  => 219, fullerton
                                    => 3404,
                            fullmer => 5757, fullwood
                                    => 9622,
                            fulmer  => 3017, fulton  => 757, fults   => 7602, fultz   => 2178,
                            funches => 8595, funderburk
                                    => 3507,
                            fung    => 5569, funk    => 1234, funke   => 7375, funkhouser
                                    => 7123,
                            fuqua   => 3352, furlong => 4105, furlow  => 9497, furman  => 2687,
                            furr    => 2843, furst   => 8716, furtado => 4960, fusco   => 3723,
                            fuson   => 9267, fussell => 5568, futch   => 8715, futrell => 5534,
                            gabaldon
                                    => 9038, gabbard => 4214,
                            gabel   => 4542, gable   => 2849, gabrielson
                                    => 9496,
                            gadbois => 9037, gaddis  => 2490, gaddy   => 2966, gadsden => 9889,
                            gadson  => 4959, gaffney => 2346, gafford => 9495, gage    => 1591,
                            gagliano
                                    => 7962, gagliardi
                                    => 7866,
                            gagne   => 1531, gagnon  => 986, gailey  => 5756, gainer  => 5804,
                            gaines  => 488, gainey  => 3860, gaitan  => 5179, gaither => 2194,
                            galan   => 6799, galarza => 3274, galaviz => 9494, galbraith
                                    => 3447,
                            galbreath
                                    => 5178, gales   => 7601,
                            galicia => 7453, galindo => 1237, gall    => 4244, gallagher
                                    => 487,
                            gallaher
                                    => 4660, gallant => 2418,
                            gallardo
                                    => 1760, gallaway
                                    => 7374,
                            gallego => 6536, gallegos
                                    => 557,
                            galligan
                                    => 8145, gallimore
                                    => 9755,
                            gallion => 8360, gallman => 7373, gallo   => 1645, galloway
                                    => 728,
                            gallup  => 6260, galvan  => 900, galvez  => 2655, galvin  => 3134,
                            gamache => 5216, gambill => 7122, gambino => 9380, gamble  => 702,
                            gamboa  => 2577, gambrell
                                    => 4325,
                            gamez   => 2208, gammage => 9379, gammon  => 4358, gandy   => 2269,
                            ganey   => 9754, gann    => 1916, gannon  => 2130, gant    => 1914,
                            gantt   => 2686, gantz   => 8359, gaona   => 5146, garay   => 3928,
                            garber  => 3000, garces  => 9378, garcia  => 17, gard    => 7001,
                            gardea  => 9493, gardiner
                                    => 2357,
                            gardner => 157, garey   => 8812, garibay => 4445, garica  => 6152,
                            garlock => 8811, garman  => 4659, garmon  => 3491, garner  => 323,
                            garnes  => 9377, garnica => 9753, garofalo
                                    => 8056,
                            garrard => 8144, garren  => 8810, garretson
                                    => 6368,
                            garrett => 221, garrick => 5619, garrido => 5111, garris  => 3283,
                            garrison
                                    => 512, garrity => 4444,
                            garrow  => 8476, gartman => 9752, gartner => 5663, garton  => 7961,
                            garver  => 6367, garvey  => 2965, garvin  => 2037, garza   => 213,
                            gasaway => 8594, gaskill => 5256, gaskin  => 3319, gaskins => 1995,
                            gaspar  => 5177, gaspard => 6931, gasper  => 7865, gass    => 3722,
                            gassaway
                                    => 8143, gast    => 7774,
                            gastelum
                                    => 6930, gates   => 460,
                            gatewood
                                    => 3558, gathers => 9157,
                            gatlin  => 2056, gatling => 5755, gattis  => 6929, gatto   => 6366,
                            gaudet  => 6259, gaudette
                                    => 6606,
                            gaudreau
                                    => 8358, gaughan => 8357,
                            gaul    => 6428, gault   => 4061, gause   => 4699, gauthier
                                    => 1786,
                            gauvin  => 8475, gay     => 681, gayden  => 8474, gaylor  => 4658,
                            gaynor  => 4384, gaytan  => 4243, gayton  => 6928, gearhart
                                    => 4104,
                            geary   => 2298, gebhardt
                                    => 7070,
                            gebhart => 6605, geddes  => 7773, geer    => 3771, gehring => 6725,
                            gehrke  => 6604, geier   => 7772, geiger  => 1613, geis    => 7600,
                            geise   => 9621, geisler => 4744, geissler
                                    => 9036,
                            geist   => 5567, gelinas => 8593, geller  => 4743, gendron => 5110,
                            genovese
                                    => 5618, gentile => 2472,
                            gentry  => 596, geraci  => 9156, gerber  => 2129, gerdes  => 5215,
                            gerena  => 8592, gerhardt
                                    => 6044,
                            gerhart => 7771, gerken  => 9888, gerlach => 4742, germain => 4471,
                            gervais => 5214, getchell
                                    => 9751,
                            geter   => 6365, getty   => 7689, getz    => 3629, geyer   => 4600,
                            gholston
                                    => 7864, giannini
                                    => 9750,
                            giardina
                                    => 9887, gibb    => 8473,
                            gibbons => 999, gibbs   => 378, gibson  => 111, giddens => 4625,
                            giddings
                                    => 6258, gideon  => 7372,
                            giese   => 4741, giffin  => 7295, gifford => 1580, giglio  => 6724,
                            giguere => 7207, gilbertson
                                    => 4030,
                            gilbreath
                                    => 4006, gilchrist
                                    => 2079,
                            gilder  => 8809, gile    => 8591, giles   => 645, gilkey  => 6205,
                            gill    => 386, gillam  => 6043, gillard => 4657, gilleland
                                    => 9266,
                            gillen  => 3079, gillenwater
                                    => 7294,
                            gilles  => 7960, gillespie
                                    => 694,
                            gillett => 6798, gillette
                                    => 2276,
                            gilley  => 2417, gilliam => 855, gilliard
                                    => 5860,
                            gillies => 8472, gilligan
                                    => 4927,
                            gilliland
                                    => 2172, gillis  => 1438,
                            gillispie
                                    => 6096, gillman => 5662,
                            gillum  => 4213, gilman  => 2161, gilmer  => 3952, gilmore => 480,
                            gilpin  => 4383, gilreath
                                    => 5954,
                            gilroy  => 7293, gilson  => 3582, gilstrap
                                    => 6603,
                            ginder  => 8247, gingerich
                                    => 7121,
                            gingras => 8471, gingrich
                                    => 7599,
                            ginn    => 3056, ginsberg
                                    => 6095,
                            ginter  => 7688, giordano
                                    => 2395,
                            gipson  => 1274, girard  => 1988, giron   => 3770, girouard
                                    => 8932,
                            giroux  => 3816, gish    => 4740, gist    => 3055, gittens => 6864,
                            givens  => 1131, gladden => 3054, gladney => 3581, gladstone
                                    => 8055,
                            glantz  => 9886, glasco  => 8808, glaser  => 3120, glasper => 7371,
                            glaspie => 9620, glass   => 570, glasscock
                                    => 6797,
                            glasser => 6927, glassman
                                    => 7069,
                            glaze   => 3887, glazer  => 8246, glazier => 8590, gleason => 1259,
                            glick   => 5026, glidden => 5418, glidewell
                                    => 6656,
                            glisson => 6001, glover  => 333, gluck   => 7292, glynn   => 3069,
                            goad    => 2949, gober   => 5859, goble   => 3053, godbey  => 8470,
                            goddard => 1549, godfrey => 956, godin   => 6535, godinez => 3988,
                            godoy   => 4958, godsey  => 4412, godwin  => 1175, goebel  => 3644,
                            goetz   => 2014, goff    => 824, goforth => 2743, goggin  => 9035,
                            goguen  => 9265, goines  => 6863, goings  => 4997, goins   => 1042,
                            gokey   => 9492, goldberg
                                    => 1041,
                            golden  => 551, goldenberg
                                    => 9264,
                            goldfarb
                                    => 8356, golding => 4188,
                            goldman => 1404, goldsberry
                                    => 5953,
                            goldsmith
                                    => 1690, goldstein
                                    => 1010,
                            goldston
                                    => 9491, golightly
                                    => 8931,
                            gomes   => 1444, gomez   => 116, gonsalez
                                    => 7120,
                            gonsalves
                                    => 3792, gonzales
                                    => 90,
                            gonzalez
                                    => 36, gooch   => 2187,
                            goodale => 5909, goodall => 5566, goode   => 1170, goodell => 4893,
                            gooden  => 2144, goodin  => 3951, gooding => 3987, goodlett
                                    => 9490,
                            goodloe => 7863, goodman => 355, goodrich
                                    => 1503,
                            goodrum => 7770, goodsell
                                    => 8142,
                            goodson => 1687, goodwin => 348, goodwyn => 9619, goodyear
                                    => 9155,
                            goolsby => 3950, gordan  => 6926, gorden  => 9154, gordon  => 137,
                            gordy   => 6602, gore    => 966, goree   => 8355, gorham  => 3222,
                            gorman  => 1016, gormley => 7291, gorrell => 9263, gorski  => 5709,
                            gorton  => 6862, goshorn => 7290, gosnell => 4851, goss    => 912,
                            gosselin
                                    => 4357, gossett => 2450,
                            gott    => 4957, gottlieb
                                    => 5343,
                            gottschalk
                                    => 8141, goudy   => 9489,
                            gouge   => 7769, gough   => 2610, gould   => 716, goulding
                                    => 9153,
                            goulet  => 3522, gourdine
                                    => 8930,
                            gourley => 4926, gouveia => 8589, govan   => 5754, gove    => 6796,
                            govea   => 8714, gowan   => 7524, gowdy   => 9749, gowen   => 5908,
                            gower   => 4123, goyette => 8588, graber  => 4787, grable  => 9748,
                            grabowski
                                    => 4356, graf    => 2166,
                            graff   => 2842, grafton => 8713, gragg   => 3986, graham  => 99,
                            grainger
                                    => 8807, grajeda => 6861,
                            grammer => 5109, granado => 5907, granados
                                    => 3208,
                            grandberry
                                    => 9262, granger => 1437,
                            granier => 9747, granillo
                                    => 8806,
                            grant   => 148, grantham
                                    => 2078,
                            grasso  => 4996, grau    => 8469, gravely => 6495, graver  => 9261,
                            graves  => 254, gravitt => 7370, gravois => 7206, gray    => 67,
                            graybill
                                    => 5384, grayer  => 9746,
                            grays   => 7523, grayson => 1374, graziano
                                    => 5108,
                            greathouse
                                    => 3838, greaves => 5501,
                            greco   => 2138, greeley => 6257, green   => 33, greenawalt
                                    => 9488,
                            greenberg
                                    => 1628, greene  => 182,
                            greenfield
                                    => 2440, greenhaw
                                    => 8712,
                            greening
                                    => 8245, greenlaw
                                    => 8468,
                            greenleaf
                                    => 5025, greenman
                                    => 9152,
                            greenspan
                                    => 9260, greenwald
                                    => 5295,
                            greenway
                                    => 6860, greenwell
                                    => 5176,
                            greenwood
                                    => 1091, greer   => 388,
                            greeson => 7862, greggs  => 9745, gregoire
                                    => 4355,
                            gregor  => 6204, greig   => 7768, greiner => 3370, grenier => 2754,
                            gresham => 2260, gribble => 6494, grice   => 3028, grider  => 4083,
                            grieco  => 7068, griego  => 4850, grier   => 1712, griffen => 4698,
                            griffey => 6723, griffin => 93, griffis => 3181, griffith
                                    => 312,
                            griffiths
                                    => 2402, grigg   => 4995,
                            griggs  => 932, grigsby => 2137, grijalva
                                    => 5383,
                            grillo  => 6364, grim    => 4656, grimaldi
                                    => 7959,
                            grimaldo
                                    => 7289, grimes  => 499,
                            grimm   => 1288, grimmett
                                    => 5255,
                            grimsley
                                    => 5070, grindle => 8054,
                            grindstaff
                                    => 9885, griner  => 8053,
                            grinnell
                                    => 9259, grisby  => 8587,
                            grisham => 3068, grissett
                                    => 9487,
                            grissom => 2177, griswold
                                    => 3390,
                            grizzle => 5661, groce   => 3721, groff   => 4171, grogan  => 2401,
                            groh    => 8140, grondin => 9486, grooms  => 2924, groover => 9258,
                            grose   => 5660, gross   => 379, grossman
                                    => 1785,
                            grosso  => 7369, grote   => 8805, groth   => 5417, grove   => 1287,
                            groves  => 1068, grubb   => 1837, grubbs  => 1326, grube   => 6363,
                            gruber  => 2345, grullon => 9744, grundy  => 6203, guajardo
                                    => 2315,
                            guardado
                                    => 5906, guarino => 5382,
                            guay    => 4270, guenther
                                    => 3027,
                            guerin  => 3697, guerra  => 554, guerrero
                                    => 375,
                            guertin => 5753, guevara => 1654, guffey  => 3246, guice   => 9743,
                            guido   => 4187, guidry  => 1350, guilford
                                    => 7958,
                            guillen => 2320, guillory
                                    => 1711,
                            guillot => 7000, guimond => 7205, guinn   => 1889, guiterrez
                                    => 8804,
                            gulick  => 6601, gulledge
                                    => 6859,
                            gullett => 5175, gulley  => 2590, gully   => 9257, gumm    => 7452,
                            gump    => 7861, gunderson
                                    => 2379,
                            gunn    => 1090, gunter  => 1099, gunther => 3389, gupta   => 5952,
                            gupton  => 7204, gurley  => 2390, gurney  => 4994, gurrola => 6795,
                            gurule  => 6362, gusman  => 6256, gustafson
                                    => 1225,
                            gustin  => 4786, guth    => 7522, guthrie => 856, gutierez
                                    => 9884,
                            gutierrez
                                    => 192, gutshall
                                    => 7521,
                            guyer   => 4739, guyette => 8244, guyton  => 2394, guzman  => 292,
                            gwaltney
                                    => 9151, gwin    => 5858,
                            gwinn   => 4411, haack   => 9485, haag    => 2601, haas    => 882,
                            haase   => 4082, haber   => 5708, haberman
                                    => 7957,
                            habib   => 9742, hacker  => 1961, hackett => 1436, hackler => 6202,
                            hackman => 6600, hackney => 2654, hackworth
                                    => 5659,
                            haddad  => 4186, hadden  => 3859, haddix  => 5213, haddock => 4504,
                            haden   => 9376, hadfield
                                    => 8354,
                            hadley  => 1325, hadlock => 8139, hafer   => 6427, haffner => 7520,
                            hafner  => 7687, haga    => 8467, hagan   => 1403, hagans  => 5533,
                            hagar   => 8466, hage    => 6925, hageman => 6722, hagen   => 1344,
                            hager   => 1343, hagerman
                                    => 5500,
                            hagerty => 6858, haggard => 2923, haggerty
                                    => 2804,
                            haggins => 9150, hagler  => 5461, hagood  => 7067, hague   => 5617,
                            hagy    => 8138, hahn    => 808, haider  => 9484, haigh   => 7066,
                            haight  => 3282, haigler => 9883, haile   => 5951, haines  => 1053,
                            haire   => 6094, hairston
                                    => 1201,
                            haith   => 7860, hake    => 6361, halbert => 4410, halcomb => 3337,
                            hale    => 272, hales   => 3490, halford => 6924, hall    => 25,
                            hallam  => 9375, halle   => 7767, hallenbeck
                                    => 9618,
                            haller  => 3628, hallett => 4655, halliburton
                                    => 7368,
                            halliday
                                    => 6426, hallman => 3336,
                            hallmark
                                    => 6255, hallock => 4503,
                            halloran
                                    => 6000, halloway
                                    => 9617,
                            hallowell
                                    => 7119, halpern => 6425,
                            halpin  => 6151, halsey  => 3791, halstead
                                    => 3627,
                            halter  => 6093, halterman
                                    => 8803,
                            halverson
                                    => 3388, halvorsen
                                    => 8052,
                            halvorson
                                    => 4502, hamann  => 6042,
                            hamblin => 2609, hambrick
                                    => 4300,
                            hamby   => 1751, hamel   => 2534, hamer   => 3052, hames   => 8353,
                            hamill  => 4541, hamilton
                                    => 98,
                            hamlett => 4570, hamlin  => 1380, hamm    => 998, hammack => 6041,
                            hamman  => 8352, hammel  => 7118, hammer  => 1557, hammers => 7367,
                            hammett => 3234, hammock => 4569, hammon  => 6313, hammond => 366,
                            hammonds
                                    => 2002, hammons => 1919,
                            hamner  => 7117, hampson => 8465, hampton => 351, hamrick => 2670,
                            hance   => 5905, hancock => 486, handley => 2803, handy   => 1784,
                            hanes   => 2895, haney   => 839, hanke   => 8586, hankins => 1224,
                            hanks   => 1681, hanley  => 1573, hanlon  => 3039, hann    => 5616,
                            hanna   => 877, hannan  => 4029, hanner  => 8243, hannigan
                                    => 7956,
                            hannon  => 2374, hannum  => 9374, hanrahan
                                    => 5565,
                            hansel  => 6092, hansen  => 211, hanshaw => 9373, hanson  => 227,
                            haralson
                                    => 9372, harbaugh
                                    => 6999,
                            harber  => 7519, harbin  => 2427, harbison
                                    => 4738,
                            hardaway
                                    => 4028, hardcastle
                                    => 6721,
                            hardee  => 4081, hardeman
                                    => 6424,
                            harden  => 978, hardesty
                                    => 2725,
                            hardie  => 6655, hardiman
                                    => 4993,
                            hardin  => 553, harding => 642, hardison
                                    => 2215,
                            hardman => 2426, hardnett
                                    => 8242,
                            hardt   => 9256, hardwick
                                    => 2742,
                            hardy   => 286, hare    => 1605, hargett => 4269, hargis  => 3078,
                            hargrave
                                    => 4060, hargrove
                                    => 1141,
                            harjo   => 9741, harker  => 5342, harkey  => 7288, harkins => 2291,
                            harkless
                                    => 9882, harkness
                                    => 5341,
                            harless => 4185, harlow  => 2548, harman  => 1811, harmon  => 336,
                            harms   => 2086, harner  => 8351, harness => 2860, harney  => 4568,
                            haro    => 4122, harp    => 1987, harper  => 176, harr    => 3927,
                            harrel  => 9255, harrell => 530, harrelson
                                    => 4299,
                            harrigan
                                    => 4737, harrill => 9254,
                            harriman
                                    => 4354, harrington
                                    => 431,
                            harris  => 14, harrison
                                    => 110,
                            harrod  => 5107, harrold => 7598, harshman
                                    => 9483,
                            hart    => 171, harte   => 9616, harter  => 3051, hartfield
                                    => 5615,
                            hartford
                                    => 4992, hartle  => 5803,
                            hartley => 873, hartman => 518, hartmann
                                    => 3434,
                            hartnett
                                    => 4145, hartsell
                                    => 6493,
                            hartsfield
                                    => 5707, hartshorn
                                    => 7686,
                            hartsock
                                    => 6923, hartung => 5752,
                            hartwell
                                    => 3742, hartwig => 5069,
                            harty   => 7766, hartz   => 7518, hartzell
                                    => 4324,
                            hartzog => 7287, harvell => 5564, harvey  => 214, harville
                                    => 7065,
                            harvin  => 8051, harwell => 3580, harwood => 3304, hash    => 5802,
                            hashimoto
                                    => 6998, haskell => 2669,
                            haskin  => 8929, haskins => 1321, haslam  => 9371, hass    => 3369,
                            hassell => 3335, hassett => 8350, hassler => 7765, hasson  => 6091,
                            hastings
                                    => 974, hasty   => 5212,
                            hatch   => 1112, hatcher => 918, hatchett
                                    => 3368,
                            hatfield
                                    => 641, hathaway
                                    => 1239,
                            hathcock
                                    => 6534, hathorn => 8711,
                            hatley  => 3677, hatmaker
                                    => 9615,
                            hatten  => 5460, hatter  => 7286, hatton  => 2124, hauck   => 4892,
                            haug    => 5857, haugen  => 3233, haugh   => 7451, haught  => 7285,
                            haun    => 4925, haupt   => 5254, hauser  => 2281, hausman => 9253,
                            havard  => 7064, havens  => 2314, haviland
                                    => 7685,
                            hawes   => 2563, hawk    => 1617, hawkes  => 5614, hawkins => 152,
                            hawkinson
                                    => 7955, hawks   => 2232,
                            hawley  => 1769, hawn    => 7517, haworth => 4298, haws    => 5856,
                            hawthorne
                                    => 1750, hayashi => 6997,
                            hayden  => 743, haydon  => 7284, hayes   => 95, haygood => 4540,
                            hayman  => 7063, hayner  => 8137, haynes  => 277, haynie  => 5340,
                            hays    => 801, hayward => 1960, hayworth
                                    => 9252,
                            hazard  => 6492, hazelton
                                    => 4501,
                            hazelwood
                                    => 4697, hazen   => 4382,
                            hazlett => 5294, hazzard => 5106, heacock => 9370, headley => 2788,
                            headrick
                                    => 2948, heady   => 7954,
                            heald   => 5801, healey  => 2964, healy   => 1476, heaney  => 7859,
                            hearn   => 1536, hearne  => 5024, hearns  => 8802, heater  => 8349,
                            heatherly
                                    => 8464, heaton  => 2207,
                            hebert  => 685, hecht   => 4470, heck    => 2055, hecker  => 5855,
                            heckman => 3180, hedden  => 7764, hedge   => 5999, hedgepeth
                                    => 4144,
                            hedges  => 3026, hedlund => 9881, hedrick => 1342, heffernan
                                    => 5023,
                            heffner => 3199, hefley  => 9614, heflin  => 3521, hefner  => 3119,
                            hegarty => 8710, hegwood => 8801, heil    => 6201, heilman => 4242,
                            heim    => 3153, hein    => 2562, heine   => 5658, heinemann
                                    => 9482,
                            heinrich
                                    => 4059, heins   => 7366,
                            heintz  => 5253, heinz   => 3025, heise   => 7953, heiser  => 5293,
                            heisler => 4849, heitman => 9149, helfrich
                                    => 8585,
                            helgeson
                                    => 8348, helland => 9880,
                            heller  => 1233, hellman => 6922, helm    => 1973, helman  => 6921,
                            helmer  => 5998, helmick => 4443, helms   => 910, helmuth => 8463,
                            helton  => 1126, helwig  => 8347, hembree => 3949, hemenway
                                    => 8800,
                            hemingway
                                    => 6090, hemphill
                                    => 1671,
                            hendershot
                                    => 4956, henderson
                                    => 77,
                            hendley => 5904, hendon  => 3886, hendren => 6040, hendrick
                                    => 2947,
                            hendricks
                                    => 682, hendrickson
                                    => 1047,
                            hendrix => 837, hendry  => 6312, henke   => 3579, henkel  => 6089,
                            henley  => 1221, hennessey
                                    => 3858,
                            hennessy
                                    => 4442, hennig  => 8928,
                            henning => 2356, henninger
                                    => 5613,
                            henriques
                                    => 7283, henriquez
                                    => 4539,
                            hensel  => 7597, henshaw => 4785, hensley => 496, henson  => 558,
                            henton  => 7858, hepburn => 7596, hepler  => 7116, hepner  => 7952,
                            hepworth
                                    => 9879, herbst  => 4538,
                            herd    => 4820, heredia => 3087, hereford
                                    => 6423,
                            hering  => 8799, hermann => 3696, hermanson
                                    => 9878,
                            hermes  => 7516, hermosillo
                                    => 7684,
                            hernadez
                                    => 5706, hernandes
                                    => 5022,
                            hernandez
                                    => 28, herndon => 1572,
                            herod   => 7115, herold  => 4696, heron   => 6794, herr    => 3263,
                            herren  => 5854, herrera => 245, herrick => 2724, herrin  => 3948,
                            herring => 609, herrington
                                    => 1604,
                            herrmann
                                    => 2373, herrod  => 8709,
                            herron  => 1002, hersey  => 4736, hersh   => 8050, hershberger
                                    => 3601,
                            hershey => 6654, hertel  => 6653, hertz   => 7365, herzog  => 2319,
                            hess    => 535, hesse   => 4409, hessler => 9877, hesson  => 8049,
                            hester  => 723, heston  => 8798, hetrick => 4241, hetzel  => 8136,
                            heuer   => 8462, hewes   => 9740, hewett  => 4624, hewitt  => 846,
                            hewlett => 5853, heyer   => 6793, heyward => 3911, heywood => 7062,
                            hiatt   => 2378, hibbard => 3273, hibbert => 8708, hibbler => 8048,
                            hibbs   => 5532, hickerson
                                    => 4695,
                            hickey  => 1014, hickman => 574, hickok  => 8346, hickox  => 8135,
                            hicks   => 126, hickson => 3534, hidalgo => 2251, hiebert => 9034,
                            hiers   => 8707, higa    => 6039, higbee  => 7857, higdon  => 2829,
                            higginbotham
                                    => 2114, higgins => 341,
                            higgs   => 3016, highsmith
                                    => 6254,
                            hight   => 4537, hightower
                                    => 1300,
                            higley  => 7203, hilbert => 4599, hilburn => 6996, hildebrand
                                    => 2946,
                            hildebrandt
                                    => 5381, hildreth
                                    => 3118,
                            hileman => 7951, hiles   => 5174, hill    => 32, hillard => 3872,
                            hiller  => 3885, hilliard
                                    => 1087,
                            hillis  => 4536, hillman => 1791, hillyer => 7595, himes   => 2506,
                            hinckley
                                    => 7114, hindman => 3741,
                            hinds   => 1759, hine    => 7950, hines   => 310, hinkle  => 1038,
                            hinkley => 6491, hinman  => 5145, hinnant => 8797, hinojos => 9613,
                            hinojosa
                                    => 1731, hinrichs
                                    => 7202,
                            hinshaw => 6360, hinson  => 1412, hinton  => 708, hintz   => 5499,
                            hinz    => 7450, hipp    => 5211, hipps   => 9876, hirsch  => 1865,
                            hirst   => 6857, hitchcock
                                    => 1952,
                            hite    => 2280, hitt    => 2905, hively  => 9875, hixon   => 4535,
                            hixson  => 4103, hoag    => 4212, hoagland
                                    => 4819,
                            hoang   => 2775, hoard   => 5531, hobart  => 6920, hobbs   => 565,
                            hobgood => 9033, hobson  => 1548, hoch    => 5380, hochstetler
                                    => 4353,
                            hock    => 8047, hockenberry
                                    => 6253,
                            hocker  => 9874, hockett => 6792, hocking => 9369, hodgdon => 9368,
                            hodge   => 465, hodges  => 360, hodgkins
                                    => 6150,
                            hodgson => 3207, hodson  => 4441, hoefer  => 9251, hoeft   => 8927,
                            hoekstra
                                    => 8461, hoelscher
                                    => 5498,
                            hoey    => 6359, hofer   => 5459, hoff    => 1768, hoffer  => 5852,
                            hoffman => 234, hoffmann
                                    => 2439,
                            hofmann => 4297, hofmeister
                                    => 9739,
                            hogan   => 440, hogg    => 2841, hoggard => 5751, hogue   => 1502,
                            hohman  => 9873, hoke    => 4027, holbert => 5252, holbrook
                                    => 1191,
                            holcomb => 835, holcombe
                                    => 3470,
                            holden  => 802, holder  => 753, holeman => 9032, holguin => 3221,
                            holifield
                                    => 5612, holladay
                                    => 7594,
                            holland => 238, hollander
                                    => 5339,
                            hollar  => 4735, hollaway
                                    => 9031,
                            holleman
                                    => 9148, hollenbeck
                                    => 3947,
                            holler  => 4694, holley  => 896, holliday
                                    => 1199,
                            hollifield
                                    => 5292, holliman
                                    => 4296,
                            hollinger
                                    => 6088, hollingshead
                                    => 6791,
                            hollingsworth
                                    => 1116, hollins => 2459,
                            hollister
                                    => 5458, holloman
                                    => 2859,
                            hollon  => 9147, holloway
                                    => 409,
                            hollowell
                                    => 5338, holm    => 2203,
                            holman  => 690, holmberg
                                    => 6652,
                            holmes  => 139, holmgren
                                    => 6995,
                            holmquist
                                    => 6490, holsinger
                                    => 8345,
                            holst   => 6200, holstein
                                    => 7763,
                            holston => 4818, holt    => 267, holte   => 9250, holter  => 8344,
                            holthaus
                                    => 10000, holton  => 2043,
                            holtz   => 3972, holtzclaw
                                    => 8796,
                            holtzman
                                    => 9481, holzer  => 6199,
                            holzman => 9612, homan   => 3446, honaker => 4440, honea   => 6790,
                            honeycutt
                                    => 1535, hood    => 459,
                            hooker  => 1421, hooks   => 1414, hooper  => 761, hoopes  => 7364,
                            hoosier => 9999, hooten  => 5021, hoover  => 507, hopkins => 244,
                            hoppe   => 3469, hopper  => 727, hopson  => 1913, horan   => 3489,
                            hord    => 6720, horgan  => 7949, horn    => 514, hornback
                                    => 5903,
                            hornbeck
                                    => 7515, hornbuckle
                                    => 8795,
                            horne   => 683, horner  => 1318, horning => 4268, hornsby => 3198,
                            horowitz
                                    => 3468, horrell => 9998,
                            horrocks
                                    => 8046, horsley => 3695,
                            horst   => 4240, horstman
                                    => 9872,
                            horta   => 8460, horton  => 256, horvath => 2753, horwitz => 8926,
                            hosey   => 4891, hoskin  => 9249, hoskins => 1055, hoskinson
                                    => 9030,
                            hosler  => 9146, hosley  => 9145, hosmer  => 8241, hostetler
                                    => 3387,
                            hostetter
                                    => 5902, hotaling
                                    => 9871,
                            hotchkiss
                                    => 4408, houchens
                                    => 8343,
                            houchin => 9144, houck   => 2100, hough   => 1696, houghtaling
                                    => 9029,
                            houghton
                                    => 2685, houk    => 4784,
                            houle   => 2241, houlihan
                                    => 7113,
                            houser  => 1248, housley => 6599, housman => 8706, houston => 395,
                            hovey   => 7061, hovis   => 5611, howard  => 63, howarth => 7201,
                            howe    => 707, howell  => 208, howells => 7762, hower   => 7449,
                            howerton
                                    => 3720, howery  => 9997,
                            howes   => 3926, howie   => 7282, howland => 2304, howlett => 5457,
                            howley  => 9996, howse   => 7281, howze   => 6252, hoye    => 8342,
                            hoyer   => 8925, hoyle   => 2464, hoyos   => 8584, hsieh   => 8924,
                            huang   => 1704, hubbard => 314, hubbell => 4890, hubble  => 8134,
                            hubbs   => 5530, huber   => 858, hubler  => 9367, huck    => 7200,
                            huckaby => 4991, hudak   => 6087, huddleston
                                    => 1556,
                            hudgens => 3857, hudgins => 1994, hudnall => 6651, hudson  => 155,
                            hudspeth
                                    => 4102, huebner => 6149,
                            huerta  => 1273, huertas => 7448, huff    => 422, huffman => 479,
                            hufford => 6038, huggins => 1159, hughes  => 84, hughey  => 3578,
                            hughley => 9870, hughs   => 7856, huie    => 7280, hulbert => 4990,
                            hulett  => 4693, huling  => 9738, hull    => 602, hulse   => 4734,
                            hulsey  => 2653, humbert => 7199, humble  => 4989, hume    => 4295,
                            humes   => 3318, hummel  => 2019, hummer  => 8133, humphrey
                                    => 531,
                            humphreys
                                    => 1937, humphries
                                    => 1726,
                            hundley => 2633, huneycutt
                                    => 5068,
                            hungerford
                                    => 7363, hunley  => 6489,
                            hunnicutt
                                    => 7362, hunsaker
                                    => 5379,
                            hunsicker
                                    => 8794, hunsinger
                                    => 9995,
                            hunt    => 142, hunter  => 125, huntington
                                    => 3694,
                            huntley => 1730, huntsman
                                    => 6856,
                            hupp    => 5337, hurd    => 1265, hurdle  => 6598, hurlburt
                                    => 8459,
                            hurley  => 709, hurst   => 584, hurtado => 2192, hurwitz => 9869,
                            huskey  => 3643, huskins => 9611, huss    => 5251, hussain => 9028,
                            hussey  => 3206, husted  => 6650, huston  => 1749, hutchens
                                    => 3642,
                            hutcherson
                                    => 2619, hutcheson
                                    => 3488,
                            hutchings
                                    => 2858, hutchins
                                    => 915,
                            hutchinson
                                    => 534, hutchison
                                    => 1220,
                            huth    => 6597, hutson  => 1951, hutt    => 7593, hutter  => 9737,
                            hutto   => 3220, hutton  => 1635, huynh   => 1598, hwang   => 3367,
                            hyatt   => 1670, hyde    => 853, hyden   => 6086, hyder   => 5291,
                            hyland  => 3815, hylton  => 3946, hymel   => 9248, hynes   => 3467,
                            hysell  => 8240, ibanez  => 6311, ibarra  => 914, ibrahim => 5563,
                            ickes   => 8458, iglesias
                                    => 4988,
                            ikeda   => 9366, imes    => 6358, imhoff  => 6310, infante => 5144,
                            ingalls => 4101, ingersoll
                                    => 4469,
                            ingham  => 7514, ingle   => 3262, ingraham
                                    => 3884,
                            ingram  => 342, iniguez => 9365, inman   => 1153, innes   => 9480,
                            innis   => 9479, inouye  => 9994, iorio   => 9364, ippolito
                                    => 9993,
                            irby    => 2224, irick   => 8457, irizarry
                                    => 1927,
                            irons   => 3945, irvine  => 2999, isaacs  => 2113, isaacson
                                    => 3386,
                            isbell  => 2240, isenberg
                                    => 6251,
                            isham   => 5378, islas   => 7592, isley   => 7447, ismail  => 9363,
                            isom    => 2214, ison    => 2600, iverson => 1888, ives    => 3487,
                            ivey    => 1051, ivie    => 6148, izaguirre
                                    => 7683,
                            izquierdo
                                    => 9247, izzo    => 5173,
                            jablonski
                                    => 4924, jackman => 4058,
                            jackson => 12, jaco    => 7948, jacobi  => 7761, jacobo  => 6719,
                            jacobs  => 217, jacobsen
                                    => 1566,
                            jacobson
                                    => 680, jacoby  => 2945,
                            jacquez => 7591, jaeger  => 2840, jaffe   => 4889, jager   => 9868,
                            jaggers => 7198, jahn    => 7590, jahnke  => 6718, jaimes  => 6198,
                            jalbert => 7855, jamerson
                                    => 4783,
                            jameson => 1882, jamieson
                                    => 4143,
                            janes   => 2815, janik   => 9992, janke   => 9610, jankowski
                                    => 3910,
                            jansen  => 2077, janson  => 7589, janssen => 3334, janzen  => 9736,
                            jaques  => 7361, jaquez  => 5800, jara    => 5851, jaramillo
                                    => 1272,
                            jarboe  => 8341, jardine => 6717, jarman  => 4294, jarmon  => 6085,
                            jarrell => 1932, jasso   => 4239, jauregui
                                    => 6649,
                            jaworski
                                    => 6596, jaynes  => 3506,
                            jeanbaptiste
                                    => 7682, jeanlouis
                                    => 7513,
                            jeffcoat
                                    => 5143, jefferies
                                    => 3179,
                            jeffers => 1390, jefferson
                                    => 417,
                            jeffords
                                    => 8923, jeffreys
                                    => 8239,
                            jeffries
                                    => 1115, jellison
                                    => 9609,
                            jemison => 4692, jenkins => 79, jenks   => 5067, jennings
                                    => 252,
                            jensen  => 240, jenson  => 3660, jepson  => 7279, jerkins => 9867,
                            jernigan
                                    => 1597, jeske   => 8045,
                            jessee  => 7588, jessen  => 4782, jessup  => 3403, jester  => 5497,
                            jeter   => 2064, jett    => 2438, jetton  => 9991, jewett  => 3303,
                            jiles   => 4598, jimenez => 255, jimerson
                                    => 5901,
                            jiminez => 5105, jinks   => 6533, jobe    => 2703, johannsen
                                    => 9027,
                            johansen
                                    => 3261, johanson
                                    => 5705,
                            johns   => 544, johnsen => 5172, johnson => 2, johnston
                                    => 203,
                            johnstone
                                    => 4733, johson  => 9608,
                            joiner  => 1340, jolin   => 7947, jolley  => 3117, jolly   => 1547,
                            jones   => 4, joplin  => 7760, jordan  => 105, jorgensen
                                    => 1509,
                            jorgenson
                                    => 3505, josephson
                                    => 6309,
                            josey   => 7681, joslin  => 4323, jost    => 6422, joubert => 6595,
                            jourdan => 9362, jowers  => 7946, joyner  => 730, juarez  => 590,
                            judd    => 1565, judkins => 4005, julien  => 7060, jumper  => 7854,
                            jurado  => 6994, jurgens => 9866, justice => 813, justis  => 9607,
                            justus  => 3769, kaczmarek
                                    => 8705,
                            kaelin  => 8922, kagan   => 9478, kahl    => 4781, kahle   => 7446,
                            kahler  => 5250, kahn    => 2206, kain    => 6855, kaiser  => 1097,
                            kalinowski
                                    => 9477, kaminski
                                    => 2715,
                            kaminsky
                                    => 7197, kammerer
                                    => 8238,
                            kamp    => 7759, kanagy  => 9990, kane    => 657, kang    => 2036,
                            kangas  => 9735, kanter  => 9143, kantor  => 8340, kaplan  => 1208,
                            kapp    => 5997, karcher => 9606, karnes  => 4888, karns   => 6147,
                            karp    => 6250, karpinski
                                    => 9026,
                            karr    => 2904, kasper  => 3659, kass    => 8237, kasten  => 6357,
                            kastner => 5750, kates   => 7278, kato    => 5290, katz    => 1017,
                            kauffman
                                    => 1475, kaufman => 822,
                            kaufmann
                                    => 5996, kautz   => 6716,
                            kavanagh
                                    => 6146, kavanaugh
                                    => 6356,
                            kaylor  => 4732, kayser  => 7445, kean    => 6084, keane   => 3504,
                            kearney => 1490, kearns  => 1926, kearse  => 6648, keating => 2054,
                            keaton  => 2525, keck    => 3385, keefe   => 3351, keefer  => 3232,
                            keegan  => 3104, keel    => 3103, keele   => 6715, keeler  => 2576,
                            keeling => 2828, keen    => 1379, keene   => 1514, keener  => 2632,
                            keeney  => 3219, keesee  => 7512, keeter  => 8132, keeton  => 2963,
                            keever  => 8339, keffer  => 8704, kegley  => 9605, kehoe   => 4352,
                            keil    => 5704, keim    => 5020, keiser  => 5657, keister => 4267,
                            keitt   => 8338, kelch   => 9142, kell    => 4266, kellam  => 6083,
                            kellar  => 4955, kelleher
                                    => 3445,
                            keller  => 296, kellerman
                                    => 5703,
                            kellett => 9734, kelley  => 188, kellner => 6355, kellogg => 1912,
                            kellum  => 3856, kelm    => 8456, kelso   => 3067, kelton  => 7196,
                            kemp    => 521, kemper  => 3245, kempf   => 5336, kempton => 8921,
                            kendricks
                                    => 8455, kennard => 5496,
                            kennedy => 131, kennelly
                                    => 9141,
                            kenner  => 5171, kennett => 9733, kenney  => 1150, kennison
                                    => 9604,
                            kennon  => 5900, kenworthy
                                    => 9140,
                            kenyon  => 2268, keough  => 8920, keown   => 8236, kephart => 8235,
                            kepler  => 7360, kerber  => 9989, kerby   => 6249, kerley  => 5749,
                            kern    => 1213, kerner  => 9603, kerney  => 9602, kerns   => 1508,
                            kerr    => 639, kerrigan
                                    => 5562,
                            kersey  => 4170, kershaw => 6308, kershner
                                    => 7680,
                            kerwin  => 9476, kesler  => 7195, kessel  => 8454, kessinger
                                    => 6789,
                            kessler => 1036, kester  => 4439, kesterson
                                    => 8583,
                            ketcham => 5656, ketchum => 3719, ketron  => 6993, key     => 699,
                            keyes   => 1686, keys    => 1138, keyser  => 4026, khan    => 1471,
                            khoury  => 6145, kibler  => 5456, kidd    => 831, kidder  => 4534,
                            kidwell => 3600, kiefer  => 3718, kieffer => 4954, kiel    => 6532,
                            kiely   => 7444, kiernan => 6992, kifer   => 9601, kiger   => 5950,
                            kight   => 6421, kilburn => 4987, kilby   => 7059, kile    => 5949,
                            kilgore => 1286, killebrew
                                    => 7112,
                            killen  => 7443, killian => 1950, killingsworth
                                    => 4848,
                            killion => 4780, killough
                                    => 5748,
                            kilmer  => 4407, kilpatrick
                                    => 2032,
                            kimball => 993, kimberlin
                                    => 8582,
                            kimble  => 1546, kimbrell
                                    => 3599,
                            kimbro  => 7111, kimbrough
                                    => 1887,
                            kimes   => 6354, kimmel  => 3015, kimsey  => 6788, kimura  => 4923,
                            kinard  => 3433, kincaid => 1519, kinch   => 9025, kinchen => 9600,
                            kinder  => 2297, kindle  => 7945, kindred => 4887, king    => 29,
                            kingery => 6037, kingsbury
                                    => 4293,
                            kingsley
                                    => 3066, kingston
                                    => 4351,
                            kinlaw  => 6420, kinley  => 9988, kinnard => 6919, kinney  => 804,
                            kinsella
                                    => 6918, kinser  => 6307,
                            kinsey  => 1774, kinsler => 8234, kinsley => 8581, kinslow => 8453,
                            kinzer  => 7758, kipp    => 4350, kirby   => 478, kircher => 9024,
                            kirchner
                                    => 3384, kirkendall
                                    => 8337,
                            kirkham => 5104, kirkland
                                    => 830,
                            kirkman => 5210, kirkpatrick
                                    => 980,
                            kirksey => 5170, kirkwood
                                    => 3231,
                            kirsch  => 4438, kirschner
                                    => 4953,
                            kirtley => 8703, kirwan  => 7587, kiser   => 1603, kish    => 4004,
                            kisner  => 7511, kissel  => 8131, kissinger
                                    => 6787,
                            kistler => 5747, kitchens
                                    => 2752,
                            kite    => 4691, kittle  => 6917, kittredge
                                    => 9987,
                            kittrell
                                    => 5289, kitts   => 6531,
                            kizer   => 4886, klassen => 8919, klatt   => 5995, klaus   => 5994,
                            klein   => 397, kline   => 678, kling   => 4349, klingensmith
                                    => 4437,
                            klinger => 3626, klink   => 6353, klotz   => 5335, klug    => 4468,
                            knapp   => 677, knecht  => 8336, kneeland
                                    => 9732,
                            knepp   => 9139, knepper => 6530, knight  => 149, knighten
                                    => 6786,
                            knighton
                                    => 6594, knisely => 9138,
                            knisley => 6529, knoll   => 3302, knopp   => 5948, knorr   => 8452,
                            knott   => 2335, knotts  => 4057, knowles => 866, knowlton
                                    => 2881,
                            knox    => 567, knudsen => 2741, knudson => 3641, knuth   => 8335,
                            knutson => 1660, kobayashi
                                    => 6488,
                            koch    => 651, kocher  => 4986, koehler => 1684, koehn   => 4500,
                            koenig  => 1612, koepke  => 9475, koerner => 5288, koester => 4436,
                            koger   => 7853, kohl    => 3503, kohler  => 1911, kohn    => 3693,
                            kolar   => 9986, kolb    => 2505, kollar  => 9731, koller  => 5495,
                            konrad  => 7944, koon    => 4623, koonce  => 3024, koons   => 5249,
                            koontz  => 2723, koopman => 8044, kopec   => 9599, kopp    => 2962,
                            korn    => 5416, kornegay
                                    => 4467,
                            korte   => 7852, koski   => 5103, koss    => 6248, koster  => 5415,
                            kovac   => 8233, kovach  => 3598, kovacs  => 4885, koval   => 9246,
                            kowal   => 5561, kowalczyk
                                    => 6593,
                            kowalewski
                                    => 7943, kowalski
                                    => 2136,
                            kozak   => 3909, koziol  => 7942, kozlowski
                                    => 3260,
                            kraemer => 4348, kraft   => 1460, krall   => 7851, kramer  => 485,
                            krantz  => 4884, kranz   => 5102, kratz   => 6306, kratzer => 8043,
                            kraus   => 2290, krause  => 977, krauss  => 3625, krawczyk
                                    => 8334,
                            krebs   => 2437, kremer  => 4597, kress   => 5377, krick   => 7277,
                            krieg   => 7941, krieger => 3533, kroeger => 5899, krohn   => 8042,
                            krol    => 8130, kroll   => 3597, kropp   => 7276, krouse  => 7586,
                            krueger => 964, krug    => 3944, kruger  => 2239, krull   => 8793,
                            krumm   => 8451, krupa   => 9598, krupp   => 9597, kruse   => 1639,
                            kubiak  => 8702, kubik   => 9137, kucera  => 8041, kuehl   => 7757,
                            kuehn   => 4654, kugler  => 8129, kuhl    => 4567, kuhlman => 6487,
                            kuhlmann
                                    => 7940, kuhn    => 1086,
                            kuhns   => 4622, kujawa  => 7110, kulp    => 8580, kumar   => 4435,
                            kunkel  => 3272, kunkle  => 5209, kuntz   => 3486, kunz    => 3502,
                            kunze   => 9474, kurth   => 7442, kurtz   => 1389, kushner => 7585,
                            kuster  => 8333, kutz    => 5414, kuykendall
                                    => 2533,
                            kwan    => 4596, kwiatkowski
                                    => 7058,
                            kwon    => 6082, kwong   => 9730, kyles   => 4817, kyser   => 6352,
                            labarbera
                                    => 7679, labarge => 9136,
                            labbe   => 3402, labelle => 3925, labonte => 4121, laborde => 9245,
                            laboy   => 4779, labrecque
                                    => 5610,
                            labrie  => 5799, lacasse => 4778, lach    => 8332, lachance
                                    => 2524,
                            lachapelle
                                    => 8918, lackey  => 1355,
                            laclair => 7850, lacombe => 6197, lacour  => 7441, lacourse
                                    => 9729,
                            lacroix => 2722, ladd    => 1638, ladner  => 1139, lafave  => 6714,
                            lafayette
                                    => 7194, lafferty
                                    => 3768,
                            laflamme
                                    => 3837, lafleur => 2937,
                            lafollette
                                    => 8701, lafond  => 6991,
                            lafontaine
                                    => 6592, laforge => 9361,
                            lafountain
                                    => 5798, lafrance
                                    => 5208,
                            lafreniere
                                    => 7275, lagasse => 7193,
                            laguna  => 7359, lagunas => 7440, lahr    => 4292, lail    => 5142,
                            laing   => 4566, lair    => 5455, laird   => 1399, lajoie  => 5287,
                            lakey   => 6305, lakin   => 7358, laliberte
                                    => 5169,
                            lally   => 5947, lalonde => 4777, lamanna => 8232, lamarre => 9865,
                            lamas   => 8331, lamb    => 430, lambert => 268, lambrecht
                                    => 8579,
                            lamere  => 7849, lamkin  => 8128, lamm    => 2639, lammers => 6990,
                            lamontagne
                                    => 4238, lamoreaux
                                    => 8700,
                            lamothe => 7274, lamoureux
                                    => 6247,
                            lampe   => 5141, lamphere
                                    => 9360,
                            lampkin => 5101, lampley => 7584, lancaster
                                    => 812,
                            landa   => 6196, landau  => 9244, lander  => 5609, landeros
                                    => 5746,
                            landers => 1373, landes  => 6036, landin  => 6916, landis  => 1667,
                            landreth
                                    => 4621, landrum => 1905,
                            landry  => 614, landwehr
                                    => 9023,
                            lane    => 173, laney   => 2922, lang    => 483, langan  => 8231,
                            langdon => 3317, lange   => 1203, langer  => 3871, langevin
                                    => 7192,
                            langford
                                    => 1411, langham => 4816,
                            langley => 865, langlois
                                    => 3102,
                            langston
                                    => 1349, lanham  => 2668,
                            lanier  => 1443, lankford
                                    => 2053,
                            lanning => 3908, lansing => 8330, lantz   => 2774, lanza   => 5376,
                            lapierre
                                    => 4595, laplant => 9985,
                            laplante
                                    => 3133, lapoint => 8699,
                            lapointe
                                    => 2556, laporte => 3366,
                            lapp    => 5454, laprade => 9984, lara    => 599, largent => 5375,
                            larimore
                                    => 9596, larios  => 7678,
                            lariviere
                                    => 8127, lark    => 5745,
                            larkin  => 1216, larkins => 4883, larocca => 7848, laroche => 3924,
                            larochelle
                                    => 5993, larock  => 8578,
                            larosa  => 5608, larose  => 3316, larrabee
                                    => 4466,
                            larrison
                                    => 9243, larsen  => 506,
                            larson  => 224, lasalle => 6144, lasater => 6785, lash    => 3401,
                            lasher  => 5655, lashley => 3883, laskey  => 9983, laskowski
                                    => 7057,
                            lasky   => 7939, lasley  => 5494, lasseter
                                    => 8698,
                            lassiter
                                    => 1616, laster  => 3116,
                            latham  => 1078, lathan  => 7109, lathrop => 4499, latimer => 3169,
                            latimore
                                    => 9242, latour  => 7439,
                            latta   => 4533, lattimore
                                    => 3740,
                            lauderdale
                                    => 6591, lauer   => 3739,
                            laughlin
                                    => 1972, laureano
                                    => 6784,
                            laurent => 4952, lauria  => 9595, laux    => 7273, lauzon  => 8917,
                            lavallee
                                    => 4347, lavalley
                                    => 4922,
                            lavender
                                    => 3400, lavergne
                                    => 5168,
                            laverty => 8126, lavigne => 2702, lavin   => 5529, lavine  => 8125,
                            lavoie  => 2499, lawhorn => 3943, lawing  => 9728, lawler  => 1876,
                            lawless => 3271, lawlor  => 5607, lawson  => 190, lawton  => 2182,
                            layfield
                                    => 7056, layman  => 2827,
                            laymon  => 9727, layne   => 2018, layton  => 1845, lazar   => 6713,
                            lazarus => 6304, lazenby => 9594, lazo    => 5493, leach   => 606,
                            leahy   => 3014, leake   => 3692, leaks   => 9864, leal    => 1185,
                            lear    => 2839, leary   => 1634, leasure => 9135, leath   => 5167,
                            leatherman
                                    => 4265, leathers
                                    => 4322,
                            leatherwood
                                    => 4882, leavitt => 2090,
                            lebeau  => 6989, lebel   => 7357, leblanc => 603, leboeuf => 4184,
                            lebron  => 3624, lebrun  => 5850, lechner => 8040, lechuga => 9593,
                            leclair => 2608, leclaire
                                    => 8697,
                            leclerc => 5248, lecompte
                                    => 5797,
                            ledbetter
                                    => 1299, lederman
                                    => 8696,
                            ledesma => 2489, ledet   => 4169, ledezma => 6486, ledford => 1447,
                            ledger  => 8916, ledoux  => 2990, leduc   => 7847, lee     => 23,
                            leech   => 4346, leeper  => 3855, lees    => 4025, lefebvre
                                    => 3466,
                            lefevre => 5374, leffler => 7677, lefkowitz
                                    => 8915,
                            lefler  => 7676, leflore => 5898, leftwich
                                    => 5744,
                            legault => 8039, leger   => 2979, legere  => 7438, legette => 9982,
                            legg    => 3152, leggett => 1959, legrand => 4594, lehman  => 1024,
                            lehmann => 2944, lehr    => 5528, leibowitz
                                    => 6485,
                            leighton
                                    => 3333, leija   => 5796,
                            leiker  => 8450, leininger
                                    => 7356,
                            leister => 7583, leitch  => 9241, leite   => 9863, leith   => 8577,
                            leitner => 9726, leiva   => 6590, lejeune => 5492, lemaire => 9981,
                            lemaster
                                    => 3596, lemay   => 2751,
                            lemieux => 2449, lemire  => 5491, lemke   => 3465, lemley  => 5992,
                            lemmon  => 3532, lemmons => 6081, lemoine => 4653, lemon   => 1710,
                            lemons  => 1807, lemos   => 5849, lemus   => 2631, lenhart => 6712,
                            lenihan => 9473, lennon  => 3520, lennox  => 6246, lenoir  => 5334,
                            lent    => 5702, lentz   => 1836, lenz    => 2880, leong   => 5490,
                            leonhardt
                                    => 9022, leos    => 7108,
                            lepage  => 6143, lepore  => 7510, leppert => 9134, lerch   => 8124,
                            lerma   => 3230, lerner  => 3623, leroux  => 9980, lesher  => 6647,
                            lesko   => 6988, lesperance
                                    => 8914,
                            lessard => 3622, letendre
                                    => 6854,
                            letourneau
                                    => 4532, letson  => 9592,
                            lett    => 4985, leung   => 2998, levan   => 8695, levasseur
                                    => 4731,
                            leveille
                                    => 8576, leverett
                                    => 4847,
                            levesque
                                    => 2123, levin   => 1958,
                            levine  => 828, levinson
                                    => 5489,
                            levitt  => 6142, levy    => 766, lewallen
                                    => 8230,
                            lewandowski
                                    => 2714, lewellen
                                    => 7509,
                            lewin   => 5654, lewis   => 22, leyba   => 7191, leyva   => 2085,
                            lheureux
                                    => 4921, liang   => 5207,
                            liberatore
                                    => 9359, licata  => 9021,
                            licon   => 9979, liddell => 3942, liddle  => 8694, lieb    => 6987,
                            lieberman
                                    => 3923, liggett => 6419,
                            liggins => 5100, lightfoot
                                    => 2857,
                            lightner
                                    => 3870, ligon   => 3259,
                            likens  => 9978, liles   => 2008, lillard => 5946, lilley  => 2894,
                            lima    => 2787, limon   => 3218, linares => 3168, lind    => 1748,
                            lindahl => 8329, lindberg
                                    => 2961,
                            linde   => 9977, lindell => 6986, lindeman
                                    => 5606,
                            lindemann
                                    => 9133, linden  => 5560,
                            linder  => 2099, linderman
                                    => 8575,
                            lindgren
                                    => 3836, lindholm
                                    => 7190,
                            lindley => 2561, lindner => 4776, lindo   => 8574, lindquist
                                    => 2471,
                            lindsley
                                    => 8693, lindstrom
                                    => 3814,
                            lineberry
                                    => 6418, linehan => 9725,
                            lingenfelter
                                    => 8229, lingerfelt
                                    => 7437,
                            lingle  => 6985, lingo   => 7846, link    => 1362, linker  => 6035,
                            linkous => 3444, linn    => 1936, linton  => 2143, linville
                                    => 3717,
                            lipinski
                                    => 9132, lippert => 5166,
                            lippincott
                                    => 9862, lipps   => 8449,
                            lipscomb
                                    => 1852, lipsey  => 6528,
                            liptak  => 9240, lipton  => 9591, lira    => 2826, lirette => 8913,
                            liriano => 9590, lister  => 3432, liston  => 6853, litchfield
                                    => 6141,
                            litteral
                                    => 9861, littlefield
                                    => 1935,
                            littlejohn
                                    => 1895, littles => 8328,
                            littleton
                                    => 2599, litton  => 5527,
                            littrell
                                    => 5488, lively  => 2400,
                            livengood
                                    => 6351, livermore
                                    => 9724,
                            livesay => 7055, livingston
                                    => 633,
                            lizarraga
                                    => 8228, lizotte => 5701,
                            llamas  => 5247, llanes  => 7508, llanos  => 9723, llewellyn
                                    => 4434,
                            lockard => 4565, locke   => 1052, lockett => 1410, lockhart
                                    => 931,
                            locklear
                                    => 2504, lockman => 7845,
                            lockridge
                                    => 6527, lockwood
                                    => 1331,
                            loeb    => 8573, loeffler
                                    => 5487,
                            loehr   => 7844, loera   => 3658, loesch  => 7938, lofgren => 8912,
                            loftin  => 3595, loftis  => 2750, lofton  => 1796, loftus  => 4168,
                            logan   => 412, loggins => 5333, logsdon => 2555, logue   => 3621,
                            lohman  => 6195, lohr    => 4291, loiselle
                                    => 9472,
                            lollar  => 7756, lollis  => 8327, lomas   => 5700, lomax   => 2448,
                            lombard => 3594, lombardi
                                    => 2344,
                            lombardo
                                    => 1993, lomeli  => 4690,
                            lonergan
                                    => 8326, loney   => 6783,
                            long    => 82, longley => 7272, longmire
                                    => 7937,
                            longo   => 3077, longoria
                                    => 1513,
                            longstreet
                                    => 9471, loomis  => 1699,
                            looney  => 1545, looper  => 6915, loos    => 6034, loper   => 3557,
                            lopes   => 1931, lopez   => 31, lopresti
                                    => 9589,
                            lorenz  => 2084, lorenzen
                                    => 8325,
                            loring  => 9470, lott    => 758, lotz    => 8692, loucks  => 4433,
                            loudermilk
                                    => 6417, lough   => 6914,
                            loughlin
                                    => 8691, loughran
                                    => 9469,
                            lounsbury
                                    => 9358, louque  => 7582,
                            louviere
                                    => 9131, lovato  => 4381,
                            loveday => 8911, lovejoy => 3167, lovelace
                                    => 2246,
                            lovelady
                                    => 5945, loveland
                                    => 5246,
                            loveless
                                    => 3166, lovell  => 1110,
                            lovett  => 1407, lovette => 9468, lovins  => 8690, lowder  => 6033,
                            lowe    => 251, lowery  => 583, lowman  => 3813, lowrance
                                    => 8324,
                            lowrey  => 5605, lowrie  => 9130, lowry   => 1105, lowther => 6589,
                            loya    => 3922, lozada  => 4652, lozano  => 903, lozier  => 7436,
                            lozoya  => 7936, lubin   => 7675, lucas   => 263, luce    => 2684,
                            lucero  => 879, lucey   => 9860, lucier  => 6303, luckett => 2960,
                            luckey  => 5526, ludlow  => 8572, ludwick => 6782, ludwig  => 1701,
                            lueck   => 7674, luedtke => 9357, luevano => 5140, lugo    => 946,
                            lujan   => 1595, lukas   => 8689, lukens  => 7355, luker   => 4321,
                            lukes   => 9588, lumley  => 9129, lumpkin => 2364, lumpkins
                                    => 8910,
                            luna    => 443, lund    => 1155, lundberg
                                    => 3501,
                            lunde   => 8571, lundgren
                                    => 4100,
                            lundin  => 9020, lundquist
                                    => 5099,
                            lundy   => 1485, lunn    => 4290, lunsford
                                    => 1689,
                            lunt    => 7354, luong   => 4056, luper   => 8792, lupo    => 5245,
                            lusby   => 9976, lusk    => 1523, lussier => 5066, luster  => 3065,
                            lutes   => 6781, luttrell
                                    => 3165,
                            lutz    => 942, lydon   => 7189, lykins  => 5332, lyles   => 1398,
                            lynch   => 220, lyon    => 972, lyons   => 300, lytle   => 2107,
                            maas    => 3657, mabe    => 3115, mabrey  => 8791, mabry   => 1904,
                            macaluso
                                    => 7054, macarthur
                                    => 5653,
                            macdonald
                                    => 721, macdougall
                                    => 6140,
                            mace    => 2447, macedo  => 6646, macfarlane
                                    => 6913,
                            macgregor
                                    => 5206, mach    => 5486,
                            machado => 1949, machuca => 7053, macias  => 817, maciel  => 5098,
                            mack    => 325, mackay  => 3399, mackey  => 919, mackie  => 3676,
                            mackin  => 9467, mackinnon
                                    => 7581,
                            macklin => 3205, maclean => 3577, macleod => 4080, maclin  => 9859,
                            macmillan
                                    => 4237, macneil => 7580,
                            macomber
                                    => 5525, macon   => 2554,
                            macpherson
                                    => 4183, madden  => 821,
                            maddox  => 661, maddux  => 4564, maddy   => 9019, mader   => 5795,
                            madera  => 4055, madewell
                                    => 7353,
                            madigan => 4211, madison => 949, madore  => 5897, madrid  => 1521,
                            madrigal
                                    => 2181, madsen  => 1733,
                            madson  => 7579, maeda   => 8570, maes    => 3556, maestas => 2848,
                            magallanes
                                    => 7507, magallon
                                    => 9466,
                            magana  => 2001, magdaleno
                                    => 7843,
                            magee   => 952, mager   => 9587, magers  => 9722, maggard => 3985,
                            maggio  => 4775, magill  => 5244, magner  => 9858, magness => 6984,
                            magnuson
                                    => 3907, magoon  => 9018,
                            magruder
                                    => 6194, maguire => 2042,
                            mahaffey
                                    => 3835, mahan   => 2152,
                            mahaney => 9857, maher   => 1530, mahler  => 4774, mahon   => 2142,
                            mahone  => 5848, mahoney => 928, mahurin => 8790, maier   => 2575,
                            maillet => 9856, mailloux
                                    => 9128,
                            maines  => 7673, mair    => 8448, maisonet
                                    => 9127,
                            majewski
                                    => 7352, majors  => 2523,
                            maki    => 3675, makowski
                                    => 7351,
                            malave  => 5019, maldonado
                                    => 356,
                            malek   => 7107, maley   => 6852, malin   => 9465, malinowski
                                    => 5205,
                            mallard => 4142, mallett => 4651, mallette
                                    => 6912,
                            malley  => 3620, mallon  => 6983, malloy  => 1722, malone  => 365,
                            maloney => 985, malott  => 9126, maloy   => 6193, manahan => 9125,
                            mancilla
                                    => 8688, mancini => 3431,
                            mancuso => 2786, mandel  => 4345, mandell => 9124, mandeville
                                    => 8569,
                            maness  => 3519, maney   => 9586, manfredi
                                    => 9356,
                            mangan  => 6780, mangrum => 4563, mangum  => 2618, manigault
                                    => 9585,
                            manion  => 6139, manis   => 6911, manke   => 8789, manley  => 1001,
                            mann    => 324, manning => 334, mannino => 5373, manns   => 3640,
                            manos   => 8447, manriquez
                                    => 8446,
                            mansell => 7506, mansfield
                                    => 1348,
                            manske  => 9975, manson  => 3101, mansour => 5794, mantooth
                                    => 7578,
                            manus   => 8323, manzanares
                                    => 6588,
                            manzano => 5065, manzo   => 3834, mapes   => 4846, maples  => 2393,
                            mapp    => 5286, marable => 6245, marasco => 8445, marble  => 3833,
                            marcano => 5847, marceau => 8568, marchan => 9974, marchand
                                    => 3854,
                            marchant
                                    => 5139, marchese
                                    => 5372,
                            marchetti
                                    => 6587, marciano
                                    => 8322,
                            marcotte
                                    => 3576, marcoux => 7577,
                            marcum  => 1292, marden  => 8227, mardis  => 7672, marek   => 5896,
                            mares   => 2630, marez   => 8788, margolis
                                    => 9464,
                            mariani => 8567, marin   => 1269, marinelli
                                    => 6851,
                            marino  => 1205, mariscal
                                    => 7435,
                            markel  => 7671, marker  => 4406, markey  => 6526, markham => 2180,
                            markle  => 5285, markley => 3853, markowitz
                                    => 6910,
                            marks   => 573, marlar  => 9463, marler  => 4003, marley  => 5138,
                            marlow  => 2179, marlowe => 3383, maroney => 7052, marotta => 7350,
                            marquardt
                                    => 4210, marques => 8444,
                            marquez => 454, marr    => 2773, marra   => 4236, marrero => 1166,
                            marriott
                                    => 6244, marron  => 8226,
                            marroquin
                                    => 2772, marrs   => 4562,
                            marrufo => 6711, marsden => 8787, marsh   => 414, marshall
                                    => 114,
                            marshburn
                                    => 9855, marston => 5097,
                            marte   => 7188, martel  => 2259, martell => 2598, martens => 3114,
                            martin  => 15, martindale
                                    => 3164,
                            martineau
                                    => 5895, martinelli
                                    => 6779,
                            martines
                                    => 5991, martinez
                                    => 18,
                            martino => 2165, martins => 3464, martinson
                                    => 3971,
                            martz   => 3315, marx    => 2484, mascarenas
                                    => 6484,
                            mashburn
                                    => 5064, mason   => 129,
                            massa   => 4951, massaro => 8909, masse   => 6778, massenburg
                                    => 9462,
                            massengale
                                    => 6645, massengill
                                    => 9355,
                            massey  => 423, massie  => 2667, masson  => 9017, mast    => 3852,
                            masters => 1435, masterson
                                    => 2666,
                            mastin  => 5894, mata    => 1033, matheny => 2936, mather  => 4950,
                            matherly
                                    => 5846, matherne
                                    => 4845,
                            mathers => 5485, mathes  => 4465, matheson
                                    => 3812,
                            mathews => 491, mathewson
                                    => 6416,
                            mathias => 3656, mathieu => 6350, mathis  => 435, mathison
                                    => 4593,
                            matias  => 4141, matlock => 1925, matney  => 3738, matos   => 1570,
                            matson  => 1886, matsumoto
                                    => 8225,
                            matta   => 5453, matte   => 8038, mattern => 6777, matteson
                                    => 3790,
                            matthes => 9461, matthews
                                    => 162,
                            matthias
                                    => 9239, mattingly
                                    => 1986,
                            mattis  => 9354, mattison
                                    => 2921,
                            mattos  => 3767, mattox  => 2289, mattson => 1781, matus   => 9721,
                            matz    => 6192, mauck   => 9854, mauk    => 8566, mauldin => 2160,
                            mauney  => 6710, maupin  => 3332, maurer  => 1512, maus    => 6776,
                            maxey   => 2701, maxfield
                                    => 3970,
                            maxon   => 8321, maxson  => 6850, maxwell => 371, mayberry
                                    => 1627,
                            mayer   => 781, mayers  => 3691, mayes   => 990, mayfield
                                    => 874,
                            mayhew  => 3301, mayle   => 5484, maynard => 581, mayne   => 8037,
                            maynor  => 6982, mayo    => 741, mayorga => 5893, mays    => 670,
                            maze    => 4498, mazur   => 4844, mazurek => 8687, mazza   => 3906,
                            mazzola => 7505, mazzone => 9123, mcabee  => 4843, mcadams => 2355,
                            mcadoo  => 5892, mcafee  => 2652, mcaleer => 9122, mcalister
                                    => 2377,
                            mcallister
                                    => 945, mcalpin => 6415,
                            mcalpine
                                    => 5944, mcanally
                                    => 5990,
                            mcandrew
                                    => 7271, mcardle => 5652,
                            mcarthur
                                    => 2458, mcatee  => 6032,
                            mcauley => 6191, mcauliffe
                                    => 7187,
                            mcavoy  => 5891, mcbee   => 3197, mcbeth  => 8786, mcbrayer
                                    => 7755,
                            mcbride => 394, mcbroom => 4842, mcbryde => 7842, mcburney
                                    => 7434,
                            mccabe  => 1035, mccafferty
                                    => 4841,
                            mccaffrey
                                    => 3314, mccain  => 1188,
                            mccaleb => 6849, mccall  => 595, mccalla => 6909, mccallister
                                    => 3575,
                            mccallum
                                    => 3100, mccammon
                                    => 8320,
                            mccandless
                                    => 5243, mccann  => 940,
                            mccants => 3969, mccardle
                                    => 9238,
                            mccarley
                                    => 6848, mccarroll
                                    => 9016,
                            mccarron
                                    => 8123, mccarter
                                    => 2363,
                            mccarthy
                                    => 374, mccartney
                                    => 2238,
                            mccarty => 747, mccarver
                                    => 7270,
                            mccary  => 6349, mccaskill
                                    => 3574,
                            mccaslin
                                    => 5651, mccauley
                                    => 1223,
                            mccay   => 8565, mcchesney
                                    => 6414,
                            mcclain => 492, mcclanahan
                                    => 2893,
                            mcclary => 4002, mcclean => 6483, mccleary
                                    => 3984,
                            mcclellan
                                    => 1109, mcclelland
                                    => 1833,
                            mcclendon
                                    => 1163, mcclintock
                                    => 2989,
                            mcclinton
                                    => 4001, mccloskey
                                    => 3163,
                            mccloud => 1695, mccluney
                                    => 9353,
                            mcclung => 2721, mcclure => 578, mcclurg => 5793, mccluskey
                                    => 5137,
                            mccollough
                                    => 6586, mccollum
                                    => 1281,
                            mccomas => 5943, mccomb  => 6644, mccombs => 2547, mcconnell
                                    => 640,
                            mccool  => 3281, mccord  => 1189, mccorkle
                                    => 2856,
                            mccormack
                                    => 2046, mccormick
                                    => 408,
                            mccourt => 6585, mccowan => 6243, mccown  => 4405, mccoy   => 207,
                            mccracken
                                    => 1494, mccrae  => 8036,
                            mccraney
                                    => 9720, mccrary => 2135,
                            mccraw  => 5371, mccray  => 820, mccrea  => 4380, mccready
                                    => 6709,
                            mccreary
                                    => 3300, mccree  => 9121,
                            mccrory => 4264, mccubbin
                                    => 8122,
                            mccue   => 3258, mccullar
                                    => 9120,
                            mccullen
                                    => 9853, mcculley
                                    => 4344,
                            mcculloch
                                    => 2855, mccullough
                                    => 652,
                            mccullum
                                    => 7670, mccully => 6643,
                            mccune  => 3382, mccurdy => 2311, mccurley
                                    => 9973,
                            mccurry => 4054, mccusker
                                    => 7935,
                            mccutchen
                                    => 5890, mccutcheon
                                    => 3196,
                            mcdade  => 3851, mcdaniel
                                    => 278,
                            mcdaniels
                                    => 3217, mcdavid => 5370,
                            mcdermott
                                    => 1046, mcdevitt
                                    => 4650,
                            mcdonald
                                    => 112, mcdonnell
                                    => 2607,
                            mcdonough
                                    => 1361, mcdougal
                                    => 3280,
                            mcdougald
                                    => 7433, mcdougall
                                    => 3983,
                            mcdougle
                                    => 8908, mcdowell
                                    => 555,
                            mcduffie
                                    => 2288, mceachern
                                    => 5792,
                            mcelhaney
                                    => 4592, mcelrath
                                    => 7576,
                            mcelroy => 1066, mcelveen
                                    => 8785,
                            mcelyea => 8907, mcentee => 9119, mcentire
                                    => 7186,
                            mcevoy  => 4620, mcewen  => 3350, mcfadden
                                    => 827,
                            mcfall  => 3132, mcfalls => 9719, mcfarland
                                    => 717,
                            mcfarlane
                                    => 2638, mcfarlin
                                    => 6190,
                            mcgaha  => 6642, mcgann  => 6708, mcgarry => 5242, mcgarvey
                                    => 9718,
                            mcgary  => 6584, mcgaughey
                                    => 9972,
                            mcgee   => 328, mcgehee => 3716, mcghee  => 983, mcgill  => 1071,
                            mcginley
                                    => 5136, mcginn  => 4379,
                            mcginnis
                                    => 965, mcginty => 4619,
                            mcglone => 8319, mcglothlin
                                    => 5559,
                            mcglynn => 6242, mcgough => 4235, mcgovern
                                    => 2425,
                            mcgowan => 790, mcgowen => 8443, mcgrady => 9971, mcgrath => 975,
                            mcgraw  => 1251, mcgregor
                                    => 1971,
                            mcgrew  => 2988, mcgriff => 3982, mcgruder
                                    => 7349,
                            mcguigan
                                    => 7754, mcguinness
                                    => 5845,
                            mcguire => 445, mchale  => 4984, mchenry => 2522, mchone  => 9015,
                            mchugh  => 1903, mcilwain
                                    => 6641,
                            mcinerney
                                    => 7753, mcinnis => 3113,
                            mcintire
                                    => 2700, mcintosh
                                    => 650,
                            mcinturff
                                    => 8906, mcintyre
                                    => 688,
                            mciver  => 5331, mckain  => 8784, mckamey => 7669, mckay   => 745,
                            mckean  => 5096, mckee   => 618, mckeehan
                                    => 8224,
                            mckeever
                                    => 3715, mckellar
                                    => 6482,
                            mckelvey
                                    => 4464, mckenna => 1360,
                            mckenney
                                    => 3639, mckenzie
                                    => 441,
                            mckeon  => 3905, mckeown => 3737, mckibben
                                    => 5889,
                            mckie   => 8121, mckim   => 5989, mckinney
                                    => 262,
                            mckinnie
                                    => 8686, mckinnon
                                    => 1683,
                            mckinsey
                                    => 9460, mckinzie
                                    => 6525,
                            mckissick
                                    => 6707, mcknight
                                    => 663,
                            mckown  => 7269, mckoy   => 4404, mclain  => 1666, mclamb  => 9014,
                            mclane  => 4099, mclaren => 4773, mclaughlin
                                    => 401,
                            mclaurin
                                    => 2847, mclean  => 592,
                            mclellan
                                    => 4343, mclemore
                                    => 2699,
                            mclendon
                                    => 2389, mcleod  => 834,
                            mclin   => 7348, mcloughlin
                                    => 6524,
                            mcmahan => 2122, mcmahon => 861, mcmann  => 8035, mcmanus => 1257,
                            mcmaster
                                    => 3638, mcmasters
                                    => 8223,
                            mcmath  => 9459, mcmichael
                                    => 4167,
                            mcmillan
                                    => 666, mcmillen
                                    => 3013,
                            mcmillian
                                    => 1862, mcmillin
                                    => 5095,
                            mcmillion
                                    => 9852, mcmillon
                                    => 6847,
                            mcminn  => 5284, mcmorris
                                    => 5791,
                            mcmullan
                                    => 9352, mcmullen
                                    => 1359,
                            mcmullin
                                    => 4209, mcmurray
                                    => 2943,
                            mcmurry => 6908, mcmurtry
                                    => 9458,
                            mcnabb  => 2574, mcnair  => 1383, mcnally => 1528, mcnamara
                                    => 1358,
                            mcnamee => 4263, mcnary  => 7934, mcnatt  => 9584, mcnaughton
                                    => 9457,
                            mcneal  => 1177, mcneely => 2651, mcneese => 7668, mcneil  => 713,
                            mcneill => 1183, mcnew   => 5452, mcniel  => 8034, mcnulty => 2424,
                            mcnutt  => 2423, mcpeak  => 5524, mcphail => 5369, mcphee  => 5790,
                            mcpherson
                                    => 783, mcquade => 8564,
                            mcquaid => 9583, mcqueen => 1129, mcquiston
                                    => 8033,
                            mcrae   => 1338, mcreynolds
                                    => 3655,
                            mcroberts
                                    => 7667, mcshane => 6523,
                            mcspadden
                                    => 9582, mcswain => 3398,
                            mcsweeney
                                    => 8563, mcvay   => 3299,
                            mcveigh => 9970, mcvey   => 2935, mcvicker
                                    => 9717,
                            mcwhirter
                                    => 8562, mcwhorter
                                    => 2159,
                            mcwilliams
                                    => 1337, meacham => 3463,
                            mead    => 1250, meade   => 1084, meader  => 8222, meador  => 2287,
                            meadors => 8032, meadows => 674, meads   => 9456, meagher => 4342,
                            mears   => 3531, mease   => 7933, meaux   => 9581, mebane  => 8685,
                            mecham  => 5942, medeiros
                                    => 1493,
                            medellin
                                    => 6241, medford => 5650,
                            medina  => 231, medley  => 1859, medlin  => 2879, medlock => 3573,
                            medrano => 1637, meece   => 9851, meehan  => 2318, meek    => 2213,
                            meeker  => 3216, meekins => 6240, meeks   => 902, mefford => 5789,
                            mehta   => 6583, meier   => 1544, meiners => 8783, meisner => 9351,
                            meissner
                                    => 7347, meister => 4689,
                            mejia   => 656, mejias  => 6907, melancon
                                    => 3050,
                            melanson
                                    => 5063, melcher => 6906,
                            melchor => 7051, meldrum => 8905, mele    => 7752, melendez
                                    => 724,
                            melgar  => 7185, mellen  => 9237, mello   => 2838, mellon  => 5330,
                            mellott => 6706, melnick => 6582, melo    => 5062, melson  => 7346,
                            melton  => 495, melville
                                    => 7841,
                            mena    => 2354, menard  => 2164, menchaca
                                    => 4730,
                            mendelson
                                    => 9580, mendenhall
                                    => 2846,
                            mendes  => 4289, mendez  => 279, mendiola
                                    => 6905,
                            mendonca
                                    => 9350, mendosa => 9579,
                            mendoza => 228, menefee => 6522, menendez
                                    => 3076,
                            meneses => 6189, menjivar
                                    => 8318,
                            menke   => 5988, mentzer => 8904, menzel  => 9578, meraz   => 4497,
                            mercado => 613, merced  => 8782, mercer  => 734, merchant
                                    => 1819,
                            mercier => 2825, mercurio
                                    => 5604,
                            merida  => 6775, merino  => 5283, merkel  => 6302, merkle  => 6904,
                            merrell => 4024, merriam => 8781, merrick => 2870, merrifield
                                    => 5844,
                            merriman
                                    => 3811, merritt => 561,
                            merriweather
                                    => 4531, merryman
                                    => 6138,
                            mertens => 6413, mertz   => 5451, merwin  => 7504, mesa    => 3195,
                            messenger
                                    => 3430, messer  => 1232,
                            messick => 5843, messier => 5061, messina => 2573, messinger
                                    => 8120,
                            messner => 5842, mestas  => 8442, metcalf => 1219, metcalfe
                                    => 6239,
                            metheny => 8903, metoyer => 8902, metts   => 5241, metz    => 1409,
                            metzger => 1729, metzler => 3194, meunier => 8119, meyer   => 205,
                            meyers  => 511, meza    => 1118, miceli  => 8221, michaelis
                                    => 8561,
                            michaels
                                    => 2013, michaelson
                                    => 6412,
                            michalak
                                    => 7184, michalski
                                    => 5368,
                            michaud => 1386, michels => 4262, michelson
                                    => 9118,
                            mickel  => 8684, mickelson
                                    => 4341,
                            mickens => 4000, mickle  => 5699, middaugh
                                    => 7106,
                            middendorf
                                    => 9577, middlebrook
                                    => 9850,
                            middlebrooks
                                    => 5413, middleton
                                    => 634,
                            midgett => 7183, midkiff => 5941, miele   => 5987, mielke  => 6981,
                            mier    => 6903, mikell  => 7751, mikesell
                                    => 7432,
                            milam   => 2324, milano  => 5558, milazzo => 9117, milburn => 2892,
                            miles   => 264, miley   => 4234, millan  => 4688, millar  => 5523,
                            millen  => 7575, miller  => 7, millet  => 5888, millett => 8441,
                            millican
                                    => 7503, milligan
                                    => 1101,
                            milliken
                                    => 3690, milliner
                                    => 9236,
                            millner => 7050, mills   => 146, millsap => 5986, millsaps
                                    => 7574,
                            milne   => 3789, milner  => 2258, milstead
                                    => 9235,
                            mims    => 1372, minard  => 7182, mincey  => 4463, miner   => 1190,
                            mingo   => 6080, minick  => 9849, mink    => 4320, minnich => 7268,
                            minnick => 3419, minnis  => 9576, minor   => 884, minter  => 2572,
                            minton  => 1885, mintz   => 3112, minyard => 9013, mirabal => 8901,
                            miramontes
                                    => 5135, mireles => 2606,
                            misner  => 9116, mistretta
                                    => 9575,
                            mitchell
                                    => 39, mitchem => 4378,
                            mitchum => 6137, mitton  => 8780, mixon   => 1844, miyamoto
                                    => 8683,
                            mize    => 2106, mizell  => 5094, moats   => 4949, moberg  => 8560,
                            moberly => 8900, mobley  => 992, mock    => 1586, modica  => 8682,
                            modlin  => 6481, moeller => 2223, moen    => 3500, moffatt => 6238,
                            moffett => 2052, moffitt => 2740, mohan   => 6846, mohler  => 5412,
                            mohr    => 1644, moise   => 8899, mojica  => 2532, molina  => 477,
                            molinaro
                                    => 9716, moline  => 6980,
                            moll    => 3714, moller  => 5841, molloy  => 5329, molnar  => 6031,
                            monaco  => 3968, monaghan
                                    => 3999,
                            monahan => 2045, moncada => 8220, moncrief
                                    => 5788,
                            mondragon
                                    => 4098, monette => 9012,
                            mong    => 7502, monge   => 6411, monger  => 6136, moniz   => 3270,
                            monk    => 1985, monreal => 9848, monroe  => 470, monroy  => 5060,
                            monson  => 2959, montague
                                    => 2837,
                            montalvo
                                    => 2031, montanez
                                    => 2070,
                            montano => 1400, monteiro
                                    => 7345,
                            monteith
                                    => 9234, montejano
                                    => 9847,
                            monteleone
                                    => 9349, montelongo
                                    => 6581,
                            montemayor
                                    => 4023, montenegro
                                    => 4233,
                            montero => 3049, montes  => 995, montez  => 3850, montgomery
                                    => 200,
                            monti   => 7344, montiel => 6410, montoya => 552, monzon  => 7573,
                            moody   => 369, moon    => 665, mooney  => 789, mooneyham
                                    => 8681,
                            moore   => 9, moorefield
                                    => 8680,
                            moorehead
                                    => 4983, moorer  => 5887,
                            moores  => 8559, moorhead
                                    => 7343,
                            moorman => 3941, mora    => 904, morabito
                                    => 7572,
                            morales => 130, moralez => 6135, moran   => 404, morano  => 9455,
                            moreau  => 2878, morehead
                                    => 3064,
                            morehouse
                                    => 4649, moreira => 4881,
                            morel   => 4729, moreland
                                    => 1534,
                            morell  => 7750, morelli => 6409, morello => 8118, morelock
                                    => 8117,
                            moreno  => 229, morey   => 2553, morgan  => 55, mori    => 7666,
                            moriarty
                                    => 3485, morin   => 693,
                            morita  => 9574, moritz  => 5840, morley  => 2629, morman  => 8317,
                            morningstar
                                    => 9969, morrell => 2205,
                            morrill => 3023, morris  => 51, morrison
                                    => 210,
                            morrissette
                                    => 5134, morrissey
                                    => 2151,
                            morrow  => 472, morse   => 627, mortensen
                                    => 3381,
                            mortenson
                                    => 5985, mortimer
                                    => 4920,
                            morton  => 418, mosby   => 3048, moseley => 1385, mosely  => 5367,
                            moser   => 938, mosher  => 1802, mosier  => 3257, moskowitz
                                    => 7932,
                            mosley  => 504, mosqueda
                                    => 5522,
                            moss    => 326, mossman => 9115, mota    => 4208, moten   => 4166,
                            motes   => 9968, motley  => 2237, moton   => 6301, mott    => 1790,
                            motta   => 8031, moua    => 4815, moulton => 1948, moultrie
                                    => 4022,
                            mounts  => 6774, mouser  => 9846, mouton  => 4232, mowery  => 3530,
                            mowry   => 6134, moxley  => 5649, moya    => 2030, moye    => 2891,
                            moyer   => 1000, moyers  => 4561, moynihan
                                    => 6705,
                            mozingo => 9715, mudd    => 4772, mudge   => 9714, mueller => 520,
                            muir    => 3063, mulcahy => 5018, mulder  => 7431, muldoon => 7430,
                            muldrow => 7181, mulford => 8898, mulholland
                                    => 4687,
                            mulkey  => 3869, mull    => 2683, mullane => 9967, mullaney
                                    => 9348,
                            mullen  => 763, mullenax
                                    => 9454,
                            mullens => 4432, muller  => 1147, mulligan
                                    => 2463,
                            mullikin
                                    => 9966, mullin  => 2824,
                            mullinax
                                    => 6348, mullings
                                    => 9845,
                            mullins => 304, mullis  => 3380, mulvaney
                                    => 7105,
                            mulvey  => 6521, mulvihill
                                    => 9347,
                            mumford => 5165, mummert => 9346, muncy   => 2457, munday  => 7501,
                            mundell => 8219, mundy   => 3689, munford => 7931, munger  => 4165,
                            munguia => 4648, muniz   => 1073, munn    => 3637, munos   => 8030,
                            munoz   => 294, munro   => 4880, munroe  => 5328, munsey  => 8218,
                            munson  => 1543, murakami
                                    => 9965,
                            murchison
                                    => 6079, murdoch => 6347,
                            murdock => 1145, murguia => 8558, murillo => 1328, muro    => 5787,
                            murphey => 5204, murphree
                                    => 6773,
                            murphy  => 57, murr    => 7342, murray  => 117, murrell => 2222,
                            murry   => 1881, muse    => 2515, musgrave
                                    => 6346,
                            musgrove
                                    => 3418, musick  => 4948,
                            musselman
                                    => 4182, musser  => 3131,
                            musso   => 8440, mutchler
                                    => 9573,
                            muth    => 6845, mutter  => 9453, myatt   => 6844, myer    => 4647,
                            myers   => 96, myhre   => 8316, myrick  => 1564, nabors  => 3397,
                            nadeau  => 1384, nader   => 8679, nadler  => 8439, nagel   => 2732,
                            nagle   => 2498, nagy    => 2836, najera  => 3130, nakagawa
                                    => 9233,
                            nakamura
                                    => 3998, nakano  => 6843,
                            nall    => 3766, nalley  => 5839, nally   => 9452, nance   => 1023,
                            napier  => 1441, napoli  => 6902, napolitano
                                    => 5017,
                            napper  => 6480, naquin  => 1653, naranjo => 3849, narcisse
                                    => 8779,
                            nardi   => 7104, nardone => 8315, narvaez => 4021, nash    => 448,
                            nason   => 4207, natal   => 7840, natale  => 4403, natoli  => 9964,
                            naughton
                                    => 7341, naugle  => 9114,
                            nault   => 9844, nauman  => 8897, naumann => 7571, nava    => 1533,
                            navarra => 7429, navarrete
                                    => 3593,
                            navarrette
                                    => 8557, navarro => 529,
                            navas   => 9843, nave    => 5203, naylor  => 1698, nazario => 4840,
                            neace   => 5450, neal    => 249, neale   => 6133, nealy   => 3555,
                            neary   => 5984, necaise => 4231, needham => 2531, neel    => 3654,
                            neeley  => 2823, neely   => 1032, neese   => 5786, neff    => 1489,
                            negrete => 2552, negron  => 1553, neill   => 2854, neilsen => 9451,
                            neilson => 4431, nellis  => 9345, nelms   => 3636, nelsen  => 5133,
                            nelson  => 37, nemeth  => 4097, neri    => 6132, nero    => 5557,
                            nesbit  => 4728, nesbitt => 1880, nesmith => 3765, ness    => 2978,
                            nester  => 5202, netherton
                                    => 9572,
                            nettles => 2353, neubauer
                                    => 6078,
                            neufeld => 9344, neuman  => 2890, neumann => 2245, nevarez => 3047,
                            nevels  => 6408, neves   => 7180, nevin   => 8778, nevins  => 6640,
                            newberry
                                    => 2000, newbold => 9232,
                            newby   => 1894, newcomb => 1773, newcomer
                                    => 8029,
                            newell  => 890, newhouse
                                    => 5016,
                            newkirk => 2617, newland => 5132, newlin  => 6842, newman  => 276,
                            newsom  => 2163, newsome => 951, newson  => 5015, newton  => 339,
                            nguyen  => 216, nicholes
                                    => 9231,
                            nicholls
                                    => 4919, nichols => 147,
                            nicholson
                                    => 469, nickel  => 3788,
                            nickell => 4947, nickels => 5483, nickelson
                                    => 7570,
                            nickens => 6772, nickerson
                                    => 1563,
                            nickles => 6520, nicks   => 6979, nicoletti
                                    => 9230,
                            nielsen => 794, nielson => 2051, nieman  => 6639, niemann => 8678,
                            niemeyer
                                    => 8217, niemi   => 5131,
                            nieto   => 2050, nieves  => 842, nightingale
                                    => 6841,
                            nigro   => 6519, nilsen  => 8216, nilson  => 8777, nilsson => 6407,
                            nimmons => 8314, nino    => 5282, nipper  => 8028, nissen  => 5838,
                            nixon   => 585, noble   => 610, nobles  => 2069, nocera  => 9842,
                            nock    => 7267, noland  => 2334, nolasco => 6901, nolen   => 2333,
                            noles   => 7500, nolette => 9343, nolin   => 8313, noll    => 3882,
                            nolte   => 5327, noonan  => 2698, norberg => 9342, norcross
                                    => 9229,
                            nord    => 5648, nordin  => 9228, nordstrom
                                    => 5366,
                            norfleet
                                    => 3554, noriega => 2889,
                            norris  => 285, norsworthy
                                    => 8677,
                            northcutt
                                    => 4646, northrop
                                    => 7428,
                            northrup
                                    => 6978, norton  => 421,
                            norvell => 6479, norwood => 1082, novak   => 1013, novotny => 4079,
                            nowak   => 2063, nowakowski
                                    => 9011,
                            nowell  => 4096, nowicki => 6345, nowlin  => 3592, noyes   => 2388,
                            nugent  => 1893, null    => 3868, nunes   => 3012, nunez   => 391,
                            nunley  => 3462, nunn    => 1709, nunnally
                                    => 6478,
                            nunnery => 8116, nuno    => 7665, nuss    => 7749, nussbaum
                                    => 7340,
                            nutt    => 3298, nutter  => 3904, nutting => 9113, nyberg  => 7427,
                            nygaard => 8027, nystrom => 7339, oakes   => 1388, oakley  => 1492,
                            oaks    => 3297, oates   => 3075, obannon => 8026, ober    => 7338,
                            oberg   => 5449, oberle  => 9841, obregon => 7748, obrian  => 4771,
                            obrien  => 259, obryan  => 3674, obryant => 5743, ocampo  => 2372,
                            ocasio  => 2888, ochoa   => 679, ochs    => 4053, oconnell
                                    => 883,
                            oconner => 3484, oconnor => 474, odaniel => 7049, oday    => 7499,
                            oden    => 3229, odle    => 7266, odom    => 777, odonnell
                                    => 768,
                            odum    => 4020, offutt  => 6840, ogburn  => 6300, ogden   => 1611,
                            ogilvie => 9341, ogle    => 1970, oglesby => 2362, ogletree
                                    => 6299,
                            ogrady  => 4946, ohalloran
                                    => 8676,
                            ohanlon => 9340, ohara   => 1378, ohare   => 6077, ohler   => 9571,
                            ojeda   => 2007, okane   => 9713, okeefe  => 2128, okelley => 6237,
                            olander => 7048, oldaker => 9339, oldenburg
                                    => 9112,
                            oldfield
                                    => 9338, oldham  => 2035,
                            olds    => 3736, oleary  => 1562, oleson  => 7179, olguin  => 6406,
                            olinger => 4839, oliphant
                                    => 3365,
                            olivares
                                    => 2275, olivarez
                                    => 2877,
                            olivas  => 2551, oliveira
                                    => 3111,
                            oliver  => 199, olivera => 4496, oliveri => 9111, olivier => 6236,
                            olivo   => 3764, oller   => 7498, ollis   => 7497, olmos   => 4879,
                            olmstead
                                    => 2713, olney   => 6405,
                            oloughlin
                                    => 7747, olsen   => 516,
                            olson   => 167, olszewski
                                    => 6404,
                            olvera  => 2343, omalley => 2422, omara   => 5521, omeara  => 6580,
                            oneal   => 482, oneil   => 849, oneill  => 676, oney    => 8312,
                            ontiveros
                                    => 2876, oquendo => 4230,
                            oquinn  => 5556, orcutt  => 5365, ordonez => 3443, ordway  => 6704,
                            orear   => 9110, oreilly => 3062, orellana
                                    => 3518,
                            orman   => 7664, ormsby  => 7569, orndorff
                                    => 8311,
                            ornelas => 2023, orona   => 9840, oropeza => 9712, orosco  => 3269,
                            orourke => 2029, orozco  => 944, orr     => 563, orta    => 3713,
                            ortega  => 352, ortego  => 5448, orth    => 4206, ortiz   => 115,
                            orton   => 4261, osborn  => 733, osborne => 373, osburn  => 3228,
                            osgood  => 3038, oshaughnessy
                                    => 8675,
                            oshea   => 3712, oshiro  => 8556, osman   => 8025, osorio  => 2462,
                            osteen  => 3735, oster   => 4918, osterman
                                    => 6771,
                            ostler  => 8896, ostrander
                                    => 2814,
                            ostrom  => 7337, ostrowski
                                    => 8215,
                            osullivan
                                    => 3296, osuna   => 5837,
                            oswald  => 2869, oswalt  => 3981, otero   => 1446, otey    => 8115,
                            otoole  => 2628, otte    => 6900, otten   => 5886, ottinger
                                    => 6518,
                            oubre   => 6344, ouellette
                                    => 1602,
                            ousley  => 5164, outlaw  => 2296, ovalle  => 6839, overbey => 9109,
                            overby  => 3734, overcash
                                    => 7178,
                            overman => 4770, overstreet
                                    => 2068,
                            overton => 1309, overturf
                                    => 7047,
                            oviedo  => 8895, owens   => 106, owensby => 7663, owings  => 4878,
                            owsley  => 6235, oxendine
                                    => 7662,
                            oxley   => 6770, oyler   => 6298, ozuna   => 4917, pabon   => 5014,
                            pace    => 601, pacheco => 568, packard => 2682, packer  => 3483,
                            paddock => 4377, padgett => 1149, padilla => 389, padron  => 4462,
                            paez    => 5983, pagan   => 1040, pagano  => 4319, page    => 293,
                            pagel   => 8024, paine   => 2279, painter => 1244, paiva   => 8776,
                            paiz    => 7930, palacio => 5982, palacios
                                    => 1236,
                            palen   => 9839, palermo => 4982, palladino
                                    => 6579,
                            palmer  => 145, palmieri
                                    => 5940,
                            palmore => 5059, palmquist
                                    => 9570,
                            palomares
                                    => 9010, palomino
                                    => 5482,
                            palomo  => 5603, palumbo => 2616, panek   => 8555, pang    => 6076,
                            paniagua
                                    => 6188, pankey  => 6297,
                            pannell => 2977, pantoja => 3268, paolucci
                                    => 9569,
                            pape    => 3867, papenfuss
                                    => 9711,
                            pappas  => 2399, paquette
                                    => 1832,
                            paquin  => 5093, parada  => 7929, paradis => 2681, pardo   => 3881,
                            pardue  => 4618, pare    => 5939, paredes => 3204, parente => 9568,
                            parenteau
                                    => 5013, parham  => 1371,
                            parikh  => 9963, parisi  => 4769, parke   => 5938, parker  => 45,
                            parkerson
                                    => 8775, parkhurst
                                    => 4916,
                            parkin  => 7839, parkins => 7177, parkinson
                                    => 3011,
                            parkman => 6477, parks   => 282, parmenter
                                    => 6838,
                            parmer  => 5937, parnell => 1810, parr    => 1626, parra   => 1615,
                            parrett => 7661, parris  => 1978, parrish => 532, parrott => 2067,
                            parry   => 2875, parsley => 4981, parson  => 1579, parsons => 400,
                            partain => 6296, partee  => 7496, partida => 4727, partin  => 2987,
                            partlow => 8114, parton  => 4340, partridge
                                    => 2446,
                            pascal  => 9108, paschal => 4591, paschall
                                    => 4915,
                            pascoe  => 8554, pascual => 4914, pasillas
                                    => 9337,
                            pasley  => 8023, passmore
                                    => 3832,
                            pastore => 6703, pastrana
                                    => 8894,
                            pate    => 811, patel   => 524, paterson
                                    => 3074,
                            patillo => 8774, patino  => 3442, patnode => 7746, patten  => 1884,
                            patterson
                                    => 83, pattison
                                    => 4617,
                            patton  => 353, paugh   => 8674, pauley  => 2739, paulin  => 7176,
                            paulino => 5326, paulk   => 4205, paull   => 9107, paulsen => 2456,
                            paulson => 1610, paulus  => 6578, pauly   => 9450, pavlik  => 9710,
                            pawlak  => 9106, pawlowski
                                    => 9105,
                            paxton  => 2098, payan   => 9227, payne   => 159, paynter => 6837,
                            payton  => 1065, peabody => 4838, peachey => 1868, peacock => 1366,
                            peake   => 4877, pearce  => 897, pearcy  => 7928, pearlman
                                    => 9962,
                            pearman => 5602, pearsall
                                    => 4204,
                            pearson => 237, peart   => 7336, pease   => 2089, peaslee => 8113,
                            peavey  => 8438, peavy   => 6836, peay    => 8437, peck    => 698,
                            peckham => 4495, pecoraro
                                    => 8553,
                            peden   => 5201, pedersen
                                    => 1957,
                            pederson
                                    => 2076, pedigo  => 4288,
                            pedraza => 5281, pedroza => 4140, peebles => 2835, peek    => 2712,
                            peel    => 3810, peele   => 4530, peeler  => 3848, peeples => 3193,
                            peery   => 6343, pegram  => 7046, pegues  => 5785, peiffer => 8436,
                            peirce  => 8773, pelayo  => 4980, pelfrey => 8310, pelham  => 8435,
                            pelkey  => 4945, pell    => 6977, pellegrini
                                    => 8112,
                            pellegrino
                                    => 4095, pellerin
                                    => 5836,
                            pelletier
                                    => 1243, peloquin
                                    => 8022,
                            peltier => 3809, pelton  => 5130, peluso  => 8552, pemberton
                                    => 2332,
                            pena    => 274, pence   => 2455, pender  => 4052, pendergast
                                    => 8551,
                            pendergrass
                                    => 2813, pendleton
                                    => 1561,
                            pendley => 6702, penick  => 7175, penland => 6295, penley  => 7265,
                            penn    => 1212, pennell => 3331, penner  => 6577, pennington
                                    => 647,
                            pennock => 8893, penrod  => 4181, penson  => 9961, penton  => 6187,
                            peoples => 1128, pepe    => 6476, pepin   => 4979, pepper  => 1930,
                            peppers => 4913, perales => 3192, peralta => 1738, peraza  => 7045,
                            percival
                                    => 9838, perdomo => 6769,
                            perdue  => 1497, perea   => 3997, pereira => 1647, peres   => 5742,
                            pereyra => 8214, perez   => 40, perkins => 154, perlman => 6475,
                            permenter
                                    => 8021, pernell => 7660,
                            perrault
                                    => 8213, perreault
                                    => 3279,
                            perreira
                                    => 7174, perri   => 5936,
                            perrin  => 3429, perrine => 5935, perron  => 3635, perrone => 4686,
                            perrotta
                                    => 7659, perry   => 80,
                            perryman
                                    => 2162, persaud => 5012,
                            persinger
                                    => 6342, pesce   => 8212,
                            peterkin
                                    => 8434, peterman
                                    => 2771,
                            peters  => 187, petersen
                                    => 509,
                            peterson
                                    => 66, petit   => 3295,
                            petree  => 8550, petrella
                                    => 9226,
                            petri   => 9960, petrie  => 3591, petrillo
                                    => 8111,
                            petro   => 6976, petrone => 9959, petry   => 5981, pettaway
                                    => 6576,
                            pettengill
                                    => 9449, petterson
                                    => 6403,
                            pettey  => 9009, pettiford
                                    => 6294,
                            pettigrew
                                    => 3787, pettis  => 3673,
                            pettit  => 1518, pettus  => 4318, pettway => 4019, petty   => 715,
                            peyton  => 3203, pfaff   => 4494, pfeffer => 6341, pfeifer => 3634,
                            pfeiffer
                                    => 2352, pfister => 6474,
                            pham    => 1240, phan    => 2483, phares  => 8892, pharr   => 4944,
                            phelan  => 2482, phelps  => 444, phifer  => 4078, philbrick
                                    => 7745,
                            philips => 4120, phillips
                                    => 43,
                            philpot => 4590, philpott
                                    => 6835,
                            phinney => 7658, phipps  => 1095, piatt   => 6638, piazza  => 4164,
                            picard  => 2770, pichardo
                                    => 4260,
                            pickard => 2589, pickel  => 8110, pickens => 1657, pickering
                                    => 2075,
                            pickett => 739, pickle  => 4529, pieper  => 5200, pierce  => 160,
                            piercy  => 5447, pierson => 1007, pifer   => 7568, pigg    => 4339,
                            pike    => 989, pilcher => 4077, pilgrim => 5835, pilkington
                                    => 4560,
                            pimental
                                    => 6234, pimentel
                                    => 2105,
                            pina    => 1470, pinard  => 8433, pinckney
                                    => 3786,
                            pinder  => 4912, pineda  => 1094, pinero  => 8549, pinheiro
                                    => 9958,
                            pinkard => 7657, pinkerton
                                    => 3763,
                            pinkham => 5698, pinkney => 4094, pinkston
                                    => 3619,
                            pinney  => 8891, pino    => 3553, pinon   => 7335, pinson  => 2229,
                            pinto   => 2785, piotrowski
                                    => 8432,
                            piper   => 1108, pipkin  => 3267, pippin  => 3428, pires   => 6030,
                            pirtle  => 4461, pisano  => 6899, pitchford
                                    => 7103,
                            pitcock => 9837, pitman  => 3967, pitre   => 3441, pitt    => 2342,
                            pittman => 406, pitts   => 452, pitzer  => 6975, pixley  => 9104,
                            pizarro => 5446, placencia
                                    => 7656,
                            plaisance
                                    => 9008, plank   => 4317,
                            plante  => 3202, plascencia
                                    => 6402,
                            plata   => 9836, platt   => 1278, plemmons
                                    => 8211,
                            pless   => 6517, plotkin => 8673, plott   => 7927, plourde => 4616,
                            plowman => 6293, plumb   => 5364, plumlee => 7744, plumley => 5445,
                            plummer => 1003, plunkett
                                    => 2976,
                            plyler  => 8672, poche   => 8109, poff    => 6974, pogue   => 3191,
                            pohl    => 5011, pohlman => 9336, poindexter
                                    => 2286,
                            pointer => 3256, poirier => 1867, poisson => 5934, polak   => 9335,
                            polanco => 2398, polen   => 9835, poling  => 3921, polito  => 8210,
                            polk    => 922, pollack => 2812, pollak  => 8772, pollard => 760,
                            polley  => 5411, pollock => 1230, polson  => 5647, polston => 7426,
                            pomerleau
                                    => 7743, pomeroy => 3831,
                            pompey  => 8309, ponce   => 988, pond    => 2853, ponder  => 1947,
                            poole   => 411, pooler  => 5555, poore   => 2845, pope    => 372,
                            popham  => 8431, popovich
                                    => 7838,
                            popp    => 3903, porras  => 4430, porter  => 124, porterfield
                                    => 2738,
                            portillo
                                    => 1946, portis  => 4402,
                            posada  => 6898, posey   => 1304, posner  => 8430, poss    => 8209,
                            poston  => 2874, poteat  => 6075, poteet  => 6292, potter  => 347,
                            potts   => 729, poulin  => 2191, pouliot => 8108, poulos  => 6233,
                            poulsen => 8890, poulson => 8020, powe    => 4316, powell  => 81,
                            powers  => 289, poynter => 6131, prado   => 1999, prater  => 1291,
                            prather => 1621, pratt   => 398, preciado
                                    => 5697,
                            preece  => 4460, prejean => 9957, premo   => 9567, prendergast
                                    => 5834,
                            prentice
                                    => 3364, prentiss
                                    => 7742,
                            prescott
                                    => 1665, presley => 1552,
                            presnell
                                    => 6637, pressley
                                    => 1977,
                            prevost => 5646, prewitt => 2351, price   => 72, prichard
                                    => 3022,
                            prickett
                                    => 6973, priddy  => 5325,
                            pridemore
                                    => 6340, pridgen => 2934,
                            priebe  => 9956, priest  => 1851, priester
                                    => 7173,
                            priestley
                                    => 9007, prieto  => 2650,
                            primm   => 7334, prince  => 577, prindle => 8208, prine   => 6834,
                            pringle => 1918, prins   => 9955, prisco  => 8889, pritchard
                                    => 1106,
                            pritchett
                                    => 1370, privett => 8107,
                            probst  => 4837, prochaska
                                    => 9448,
                            procter => 9447, proctor => 901, proffitt
                                    => 2571,
                            prokop  => 9954, propst  => 4429, prosser => 3499, proulx  => 5058,
                            prouty  => 6768, provencher
                                    => 5410,
                            provenzano
                                    => 9006, provost => 3363,
                            pruett  => 1902, pruitt  => 549, pryce   => 9953, pryor   => 943,
                            puckett => 864, puente  => 2802, puentes => 8671, puga    => 5240,
                            pugh    => 622, pugliese
                                    => 6074,
                            puleo   => 7102, pulido  => 2834, pullen  => 2228, pulley  => 3552,
                            pulliam => 1892, pullum  => 9225, pulver  => 6186, puma    => 7926,
                            pumphrey
                                    => 5239, purcell => 1320,
                            purdy   => 2158, purifoy => 8019, purkey  => 7172, purnell => 2477,
                            purser  => 5363, pursley => 6767, purvis  => 1469, puryear => 4615,
                            putman  => 2627, putnam  => 1336, pyatt   => 8207, pyle    => 1945,
                            pyles   => 4528, quach   => 7264, quackenbush
                                    => 7925,
                            quade   => 6766, qualls  => 2157, quan    => 4876, quarles => 2074,
                            quattlebaum
                                    => 8018, quesada => 4911,
                            quesenberry
                                    => 8670, quevedo => 8106,
                            quezada => 2097, quigley => 2244, quijano => 7655, quiles  => 5601,
                            quillen => 3966, quimby  => 4401, quinlan => 3762, quinn   => 370,
                            quinones
                                    => 1045, quinonez
                                    => 3618,
                            quint   => 8771, quintana
                                    => 1154,
                            quintanilla
                                    => 2171, quintero
                                    => 1148,
                            quirk   => 5362, quiroga => 9709, quiroz  => 1944, raab    => 6701,
                            rabb    => 7425, rabe    => 6700, raber   => 8429, rabideau
                                    => 7333,
                            rabinowitz
                                    => 7263, rabon   => 8206,
                            raby    => 4645, racine  => 4589, rackley => 5129, radcliff
                                    => 5885,
                            radcliffe
                                    => 5010, rademacher
                                    => 5600,
                            rader   => 1842, radford => 1984, radke   => 8548, radtke  => 5128,
                            rael    => 4943, rafferty
                                    => 3440,
                            ragan   => 2933, rager   => 6185, ragin   => 8669, ragland => 1542,
                            raglin  => 9834, ragsdale
                                    => 1777,
                            ragusa  => 9708, rahman  => 6636, rahn    => 5092, railey  => 6765,
                            rainbolt
                                    => 8308, rainer  => 7495,
                            raines  => 1187, rainey  => 1081, rains   => 2470, rainwater
                                    => 4459,
                            rakes   => 6575, raley   => 3733, ralls   => 9707, ralston => 2227,
                            ramage  => 4814, rambo   => 4813, ramer   => 5520, rameriz => 6574,
                            ramey   => 1228, ramires => 8428, ramirez => 68, ramos   => 134,
                            ramsay  => 3711, ramsdell
                                    => 8017,
                            ramsey  => 301, rancourt
                                    => 6764,
                            rand    => 3294, randazzo
                                    => 5599,
                            randel  => 8668, randle  => 1484, randles => 9224, raney   => 3037,
                            rangel  => 905, rankin  => 876, rankins => 4726, ransdell
                                    => 8547,
                            ransom  => 1620, ranson  => 6401, raper   => 5057, raposa  => 8307,
                            rapp    => 2310, rasberry
                                    => 6763,
                            rascon  => 5324, rash    => 2749, rashid  => 7424, rasmussen
                                    => 844,
                            ratchford
                                    => 7837, ratcliff
                                    => 2221,
                            ratcliffe
                                    => 6400, rathbone
                                    => 5481,
                            rathbun => 5933, rathburn
                                    => 8888,
                            ratliff => 819, rauch   => 3427, rausch  => 4119, rawlings
                                    => 2649,
                            rawlins => 3572, rawls   => 2648, rawson  => 4588, raya    => 7171,
                            rayborn => 6699, rayburn => 3010, rayfield
                                    => 8205,
                            raymer  => 5884, rayner  => 5554, raynor  => 3785, razo    => 3761,
                            reagan  => 1694, reale   => 9833, ream    => 7170, reames  => 9005,
                            reams   => 5127, reardon => 2012, rearick => 9446, reaves  => 1649,
                            reavis  => 4428, reber   => 5480, recio   => 9103, rector  => 1772,
                            redd    => 1815, redden  => 3313, reddick => 2801, redding => 1744,
                            reddy   => 3227, redfield
                                    => 9566,
                            redford => 8306, reding  => 9334, redman  => 2121, redmon  => 3517,
                            redmond => 1335, redwine => 8427, reece   => 1093, reed    => 53,
                            reeder  => 1429, reedy   => 2503, reel    => 4338, rees    => 2514,
                            reese   => 343, reeser  => 9952, reeve   => 4118, reeves  => 316,
                            regalado
                                    => 3349, regan   => 1754,
                            regis   => 9004, rego    => 5696, rehm    => 8667, reich   => 2720,
                            reichard
                                    => 6972, reichel => 8204,
                            reichert
                                    => 3086, reid    => 218,
                            reider  => 9565, reidy   => 9564, reiff   => 7262, reilly  => 787,
                            reimer  => 4527, reimers => 7836, reiner  => 7261, reinert => 7654,
                            reinhard
                                    => 8887, reinhardt
                                    => 2570,
                            reinhart
                                    => 3847, reinhold
                                    => 7653,
                            reinke  => 6130, reis    => 2822, reiser  => 8426, reisinger
                                    => 9223,
                            reiss   => 4259, reiter  => 2521, reitz   => 4163, rembert => 4526,
                            remillard
                                    => 5056, remington
                                    => 4493,
                            remy    => 6833, renaud  => 5598, render  => 8546, rendon  => 2407,
                            reneau  => 8203, renfro  => 2665, renfroe => 5409, renfrow => 5741,
                            renn    => 8305, renner  => 2323, rennie  => 7924, renninger
                                    => 9333,
                            reno    => 3330, renshaw => 6635, rentas  => 9102, renteria
                                    => 1901,
                            renwick => 9563, renz    => 8304, repp    => 7567, resendez
                                    => 4768,
                            resnick => 7494, ressler => 8303, resto   => 8886, restrepo
                                    => 9706,
                            rettig  => 9562, reuter  => 3996, revell  => 6516, revels  => 6971,
                            revis   => 6832, reyes   => 135, reynolds
                                    => 107,
                            reynoso => 2436, rheaume => 9222, rhee    => 8105, rhinehart
                                    => 4644,
                            rhoades => 1601, rhoads  => 2303, rhoden  => 4051, rhodes  => 273,
                            rhone   => 5784, rhymes  => 8770, rhyne   => 4139, ribeiro => 7332,
                            ricard  => 9705, ricci   => 2975, ricciardi
                                    => 7044,
                            riccio  => 7923, rice    => 140, rich    => 542, richards
                                    => 201,
                            richardson
                                    => 61, richburg
                                    => 5444,
                            richerson
                                    => 6698, richert => 8666,
                            richey  => 1308, richman => 4685, richmond
                                    => 673,
                            richter => 1140, rickard => 2986, ricker  => 2546, rickert => 6697,
                            rickett => 9832, ricketts
                                    => 2262,
                            rickman => 3266, ricks   => 1198, riddell => 4076, riddick => 2120,
                            riddle  => 765, ridenhour
                                    => 6696,
                            ridenour
                                    => 3190, rideout => 6399,
                            rider   => 2044, ridgeway
                                    => 2520,
                            ridgway => 6073, ridings => 8545, ridley  => 1992, riedel  => 4525,
                            riegel  => 9003, rieger  => 6695, riehl   => 8544, riendeau
                                    => 6515,
                            ries    => 5519, rife    => 3760, riffe   => 6762, riffle  => 5740,
                            rigby   => 3830, rigdon  => 7741, riggins => 2545, riggle  => 6970,
                            riggs   => 775, rigney  => 5645, rigsby  => 2942, riker   => 8016,
                            riles   => 8202, riley   => 178, rimmer  => 5883, rinaldi => 3784,
                            rincon  => 4162, rinehart
                                    => 2141,
                            ringer  => 5644, ringler => 8015, ringo   => 9221, rinker  => 7835,
                            riojas  => 5238, riordan => 4400, rios    => 361, rioux   => 7101,
                            ripley  => 3244, rippy   => 7260, riser   => 9831, risher  => 9951,
                            risinger
                                    => 6634, risley  => 6573,
                            risner  => 6339, ritchey => 3293, ritchie => 1125, rittenhouse
                                    => 4684,
                            ritter  => 982, ritz    => 4978, rivard  => 4138, rivas   => 654,
                            rivera  => 59, rivero  => 4229, rivers  => 620, rives   => 6969,
                            rizo    => 7922, rizzi   => 9704, rizzo   => 2387, roach   => 671,
                            roan    => 8425, roane   => 7834, roark   => 1625, robb    => 2257,
                            robbins => 338, roberge => 3379, roberson
                                    => 427,
                            roberts => 41, robertson
                                    => 141,
                            robeson => 8424, robey   => 4050, robichaud
                                    => 5443,
                            robichaux
                                    => 5643, robidoux
                                    => 9101,
                            robinett
                                    => 6473, robinette
                                    => 2062,
                            robins  => 2274, robinson
                                    => 19,
                            robison => 1134, robitaille
                                    => 9002,
                            robledo => 4161, robles  => 538, robson  => 3653, roby    => 2469,
                            rocha   => 863, roche   => 1743, rochon  => 9830, rockett => 7100,
                            rockwell
                                    => 2096, rockwood
                                    => 8423,
                            rodarte => 5280, rodas   => 6184, roddy   => 4180, roden   => 3417,
                            rodgers => 337, rodman  => 4287, rodrigez
                                    => 6761,
                            rodrigue
                                    => 3226, rodrigues
                                    => 1184,
                            rodriguez
                                    => 21, rodriques
                                    => 6633,
                            rodriquez
                                    => 265, roebuck => 4315,
                            roeder  => 6760, roehl   => 9332, roemer  => 7169, roesch  => 8665,
                            roesler => 8543, rogan   => 7168, rogers  => 52, rogerson
                                    => 9950,
                            rogge   => 9561, rohan   => 9949, rohde   => 4203, rohr    => 3617,
                            rohrbach
                                    => 9948, rohrbaugh
                                    => 9947,
                            rohrer  => 6338, rojas   => 571, rojo    => 4643, roldan  => 3672,
                            rolen   => 9100, rolfe   => 4376, rolle   => 8302, roller  => 3571,
                            rollins => 701, rollo   => 7423, rolon   => 5323, romano  => 1339,
                            romer   => 9220, romero  => 222, romig   => 9331, romine  => 4492,
                            romo    => 1636, rondeau => 5322, rondon  => 9445, rone    => 8104,
                            roney   => 3151, rood    => 4642, rook    => 8103, rooker  => 5932,
                            rooks   => 4427, rooney  => 1829, roop    => 5882, roos    => 7167,
                            root    => 1560, roper   => 1365, roque   => 4075, rorie   => 8664,
                            rosado  => 909, rosales => 798, rosas   => 1296, rosati  => 8769,
                            roseberry
                                    => 5199, roseboro
                                    => 8301,
                            roselli => 9001, roseman => 7043, rosemond
                                    => 7566,
                            rosen   => 1387, rosenbaum
                                    => 3616,
                            rosenberg
                                    => 1264, rosenberger
                                    => 4836,
                            rosenberry
                                    => 8422, rosenblatt
                                    => 7422,
                            rosenblum
                                    => 5739, rosenfeld
                                    => 4875,
                            rosenthal
                                    => 1828, rosner  => 8885,
                            ross    => 76, rosser  => 3348, rossi   => 1354, rossiter
                                    => 7565,
                            rossman => 5980, rosson  => 9099, rost    => 7331, roth    => 580,
                            rothe   => 9703, rother  => 9946, rothman => 4874, rothrock
                                    => 8542,
                            rothstein
                                    => 6291, rothwell
                                    => 8102,
                            rotz    => 7493, rouleau => 7166, rounds  => 2711, roundtree
                                    => 3980,
                            roundy  => 5642, rountree
                                    => 3312,
                            rourke  => 7099, rouse   => 872, roush   => 2376, rousseau
                                    => 3189,
                            roussel => 3902, routh   => 7042, roux    => 8014, rowan   => 1721,
                            rowden  => 5738, rowe    => 350, rowell  => 1578, rowland => 737,
                            rowles  => 7165, rowlett => 6472, rowley  => 1924, roybal  => 3979,
                            royer   => 3188, royster => 3061, royston => 7098, rozell  => 9219,
                            rozier  => 5198, ruano   => 7259, ruark   => 9945, rubalcava
                                    => 8201,
                            rubenstein
                                    => 7740, rubino  => 5197,
                            rubinstein
                                    => 9218, rubio   => 1009,
                            ruble   => 4683, ruch    => 5979, rucker  => 1006, ruckman => 8663,
                            rudd    => 1609, rudder  => 9944, ruddy   => 9330, ruder   => 9444,
                            rudnick => 7921, rueda   => 6514, ruelas  => 4725, ruff    => 1728,
                            ruffin  => 1211, ruffner => 7041, rugg    => 8541, ruggiero
                                    => 4587,
                            ruggles => 5783, ruhl    => 6471, ruiz    => 175, rummel  => 7164,
                            rumph   => 5597, rumsey  => 5408, rundell => 7330, runge   => 4873,
                            runion  => 5737, runkle  => 8662, runnels => 5407, runyan  => 3732,
                            runyon  => 2220, rupe    => 7258, rupp    => 3085, ruppert => 5596,
                            rusch   => 8661, rush    => 624, rushing => 1263, rushton => 7257,
                            rusk    => 5279, russo   => 662, rust    => 2647, rutan   => 8013,
                            rutherford
                                    => 950, rutkowski
                                    => 7739,
                            rutland => 4942, rutledge
                                    => 803,
                            rutter  => 4228, ruvalcaba
                                    => 5518,
                            ryals   => 4559, ryder   => 1715, ryerson => 9943, rymer   => 9000,
                            saad    => 6398, saari   => 6572, saavedra
                                    => 2519,
                            sabin   => 4682, sabo    => 3920, sabol   => 7421, sacco   => 4049,
                            sachs   => 4910, sackett => 6397, saddler => 4286, sadler  => 1341,
                            sadowski
                                    => 5321, saechao => 8300,
                            saenz   => 1357, saez    => 6183, safford => 5833, sage    => 2769,
                            sager   => 2697, sagers  => 9829, sain    => 6290, saito   => 7163,
                            saiz    => 4941, sala    => 7329, salas   => 700, salazar => 315,
                            salcedo => 2920, salcido => 3278, saldana => 1680, saldivar
                                    => 4018,
                            saleh   => 7492, salerno => 3808, salgado => 1242, salguero
                                    => 9942,
                            salinas => 547, salisbury
                                    => 2170,
                            sallee  => 3498, salley  => 3416, salmeron
                                    => 9702,
                            salmon  => 2112, salmons => 6396, salo    => 8299, salomon => 8200,
                            salter  => 1559, salters => 8298, saltsman
                                    => 9560,
                            saltzman
                                    => 8421, salyer  => 4117,
                            salyers => 6470, salzman => 8199, samaniego
                                    => 4641,
                            sammons => 3060, samons  => 5517, samora  => 7833, sample  => 1875,
                            samples => 3150, sampson => 718, sams    => 1693, samson  => 2664,
                            samuels => 1048, samuelson
                                    => 4872,
                            sanabria
                                    => 4835, sanborn => 2295,
                            sanches => 4048, sanchez => 50, sandberg
                                    => 4017,
                            sander  => 2784, sanderlin
                                    => 8660,
                            sanders => 71, sanderson
                                    => 1161,
                            sandidge
                                    => 8297, sandifer
                                    => 5196,
                            sandler => 5881, sandlin => 3178, sandoval
                                    => 377,
                            sands   => 1624, sandstrom
                                    => 6337,
                            sandusky
                                    => 7652, sanfilippo
                                    => 9443,
                            sanger  => 9701, sankey  => 6336, sanmiguel
                                    => 7097,
                            sanner  => 9217, sansom  => 7096, sansone => 6335, santacruz
                                    => 6129,
                            santamaria
                                    => 5641, santana => 704,
                            santangelo
                                    => 9559, santiago
                                    => 284,
                            santillan
                                    => 5695, santini => 9098,
                            santistevan
                                    => 8884, santoro => 4179,
                            santos  => 320, santoyo => 6513, santucci
                                    => 9558,
                            sapp    => 1440, sappington
                                    => 7651,
                            sarabia => 7738, saravia => 9216, sargeant
                                    => 7564,
                            sargent => 841, sarmiento
                                    => 5595,
                            sartain => 7420, sartin  => 5320, sarver  => 5319, sasaki  => 7650,
                            sass    => 6694, sasser  => 3149, satchell
                                    => 8999,
                            sather  => 8101, sato    => 4399, satterfield
                                    => 2134,
                            satterlee
                                    => 8998, satterwhite
                                    => 4724,
                            sattler => 6289, sauceda => 4375, saucedo => 1742, saucier => 2974,
                            sauer   => 2273, sauls   => 3243, saunders
                                    => 383,
                            sauter  => 8659, savage  => 515, saville => 6897, savino  => 8100,
                            savoie  => 5516, savoy   => 3396, sawicki => 7563, sawyer  => 462,
                            sawyers => 3395, saxon   => 3759, saxton  => 2800, sayer   => 8198,
                            sayers  => 3919, sayles  => 4940, saylor  => 2028, sayre   => 3807,
                            scaggs  => 9097, scaife  => 8540, scala   => 8296, scales  => 1910,
                            scalf   => 6469, scalise => 6896, scanlan => 5640, scanlon => 2783,
                            scannell
                                    => 8883, scarberry
                                    => 6288,
                            scarborough
                                    => 2176, scarbrough
                                    => 2997,
                            scates  => 8997, schaaf  => 7040, schaal  => 7491, schade  => 6632,
                            schaefer
                                    => 908, schaeffer
                                    => 2083,
                            schafer => 1375, schaff  => 9828, schaffer
                                    => 1659,
                            schaffner
                                    => 6759, schall  => 8539,
                            schaller
                                    => 6395, schank  => 9827,
                            schantz => 9329, scharf  => 6631, schatz  => 5195, schaub  => 6758,
                            schauer => 7832, scheel  => 7256, scheer  => 5055, scheetz => 9215,
                            scheffler
                                    => 5694, scheid  => 9214,
                            schell  => 2082, scheller
                                    => 7328,
                            schenck => 4723, schenk  => 4285, scherer => 3084, schermerhorn
                                    => 8295,
                            schexnayder
                                    => 6182, schick  => 5832,
                            schiff  => 6571, schiffer
                                    => 9826,
                            schiffman
                                    => 7920, schiller
                                    => 3829,
                            schilling
                                    => 2204, schindler
                                    => 3828,
                            schlegel
                                    => 4977, schleicher
                                    => 7490,
                            schlosser
                                    => 4524, schlueter
                                    => 6232,
                            schmid  => 2588, schmidt => 193, schmit  => 7419, schmitt => 1100,
                            schmitz => 1439, schneck => 9328, schneider
                                    => 303,
                            schnell => 5442, schock  => 6757, schoen  => 4767, schoenfeld
                                    => 7737,
                            schofield
                                    => 2219, scholl  => 3758,
                            scholz  => 5978, schooley
                                    => 8996,
                            schoonmaker
                                    => 6756, schoonover
                                    => 4074,
                            schorr  => 8995, schott  => 3277, schrader
                                    => 2212,
                            schram  => 6693, schramm => 4227, schreck => 7831, schreiber
                                    => 1976,
                            schreiner
                                    => 3940, schrimsher
                                    => 8197,
                            schrock => 4834, schroder
                                    => 4398,
                            schroeder
                                    => 517, schrum  => 9327,
                            schubert
                                    => 2919, schuck  => 7418,
                            schuetz => 9096, schuh   => 7830, schuler => 2150, schuller
                                    => 7039,
                            schulman
                                    => 5693, schulte => 2416,
                            schultz => 290, schulz  => 1641, schulze => 3671, schumacher
                                    => 1814,
                            schumaker
                                    => 8994, schuman => 5163,
                            schumann
                                    => 5054, schuster
                                    => 1983,
                            schutt  => 6630, schutte => 9442, schutz  => 5053, schuyler
                                    => 8196,
                            schwab  => 2149, schwartz
                                    => 393,
                            schwarz => 2186, schweitzer
                                    => 3148,
                            scofield
                                    => 5361, scoggins
                                    => 3482,
                            scoville
                                    => 7162, scranton
                                    => 9557,
                            scribner
                                    => 3965, scrivner
                                    => 8420,
                            scroggins
                                    => 2218, scruggs => 1305,
                            scull   => 8099, scully  => 3633, scurlock
                                    => 9556,
                            scurry  => 7829, seabolt => 6468, seabrook
                                    => 8419,
                            seager  => 9555, seagraves
                                    => 7919,
                            seal    => 2317, seale   => 4093, sealey  => 7562, seals   => 1218,
                            sealy   => 5639, seaman  => 2095, seamon  => 9326, searcy  => 2696,
                            searle  => 4722, searles => 5052, sears   => 740, seaton  => 2958,
                            seaver  => 7095, seavey  => 7255, seawright
                                    => 8012,
                            seay    => 1529, sebring => 9941, sechrist
                                    => 8538,
                            secor   => 9441, seda    => 7327, sedillo => 6128, seeger  => 6287,
                            seeley  => 3129, seely   => 4202, segal   => 4116, segarra => 8011,
                            segars  => 9700, seger   => 4909, segovia => 4458, segura  => 1408,
                            seibel  => 7161, seiber  => 6629, seibert => 3362, seidel  => 3670,
                            seidl   => 9440, seifert => 2918, seiler  => 3731, seitz   => 2415,
                            selby   => 2193, sellars => 4115, sellers => 608, sells   => 3162,
                            selman  => 7094, selph   => 9554, seltzer => 6755, semple  => 8195,
                            seng    => 6467, senn    => 4812, senter  => 7561, sepulveda
                                    => 2569,
                            sequeira
                                    => 8768, serafin => 9940,
                            sergent => 7736, serio   => 9939, serna   => 2006, serra   => 5692,
                            serrano => 572, serrato => 5479, servin  => 9938, sessoms => 4640,
                            setser  => 7828, settles => 4073, setzer  => 5237, severance
                                    => 6754,
                            severson
                                    => 3329, sevier  => 8418,
                            sevigny => 7038, sevilla => 5278, seward  => 2302, sewell  => 1077,
                            sexton  => 600, seymore => 3615, shackelford
                                    => 2513,
                            shackleford
                                    => 7093, shade   => 2695,
                            shaeffer
                                    => 9213, shafer  => 1028,
                            shaffer => 489, shah    => 1861, shahan  => 9095, shamblin
                                    => 8194,
                            shanahan
                                    => 4137, shaner  => 4397,
                            shank   => 2731, shankle => 6394, shanklin
                                    => 5638,
                            shanks  => 2211, shapiro => 1417, sharkey => 3614, sharma  => 5637,
                            sharp   => 306, sharpe  => 814, shatley => 8882, shattuck
                                    => 5594,
                            shaughnessy
                                    => 6831, shaul   => 9937,
                            shaver  => 1483, shavers => 7417, shaw    => 138, shawver => 8993,
                            shea    => 871, shealy  => 5318, shearer => 1679, shearin => 8658,
                            shears  => 5736, shedd   => 6466, sheehan => 1111, sheehy  => 8294,
                            sheets  => 1428, sheffer => 8767, sheffield
                                    => 1202,
                            shehan  => 9553, sheilds => 9825, shell   => 2034, shelton => 257,
                            shenk   => 8417, shepard => 684, shepardson
                                    => 8881,
                            sheperd => 9439, shephard
                                    => 3669,
                            shepherd
                                    => 505, sheppard
                                    => 628,
                            sherer  => 5553, sherlock
                                    => 6334,
                            sherrard
                                    => 9212, sherrer => 7254,
                            sherrod => 2267, sherwin => 6830, shetler => 8098, shewmaker
                                    => 9824,
                            shick   => 7489, shields => 513, shifflett
                                    => 3688,
                            shiflett
                                    => 8657, shilling
                                    => 5831,
                            shim    => 8537, shimizu => 9211, shin    => 2932, shinault
                                    => 9699,
                            shinn   => 2580, shipe   => 6286, shipley => 1507, shipman => 1633,
                            shipp   => 1850, shippy  => 8656, shirey  => 4523, shirk   => 5880,
                            shively => 3461, shiver  => 5931, shivers => 4047, shoaf   => 9094,
                            shockey => 5194, shockley
                                    => 1841,
                            shoemake
                                    => 4586, shoemaker
                                    => 948,
                            shoffner
                                    => 5977, shook   => 1330,
                            shoop   => 5830, shope   => 6895, shores  => 3632, shorey  => 9823,
                            shorter => 2512, shortridge
                                    => 8416,
                            shortt  => 9210, shotwell
                                    => 6753,
                            shoup   => 4639, shouse  => 4811, showalter
                                    => 5735,
                            showers => 4976, shrader => 3378, shreve  => 5193, shriver => 4558,
                            shropshire
                                    => 5277, shrout  => 9325,
                            shroyer => 8415, shrum   => 5276, shryock => 8880, shubert => 6127,
                            shuck   => 6692, shuey   => 9936, shuler  => 2119, shull   => 2748,
                            shults  => 6181, shultz  => 1527, shumaker
                                    => 3481,
                            shuman  => 3255, shumate => 3242, shumpert
                                    => 7649,
                            shumway => 5406, shunk   => 9822, shupe   => 4681, shuster => 5405,
                            shute   => 9093, shutt   => 5782, sibert  => 7416, sibley  => 2917,
                            siciliano
                                    => 9552, sickler => 7092,
                            sickles => 9698, sieber  => 9697, siebert => 5360, siegel  => 1451,
                            siegfried
                                    => 8097, sievers => 5404,
                            sifuentes
                                    => 6691, sigala  => 9324,
                            sigler  => 2811, sigman  => 7415, sigmon  => 4284, sikes   => 2236,
                            sikora  => 5691, sikorski
                                    => 8992,
                            siler   => 2646, sill    => 7735, sills   => 3978, silva   => 236,
                            silvas  => 6180, silveira
                                    => 4810,
                            silverberg
                                    => 9209, silverman
                                    => 2133,
                            silvers => 3710, silverstein
                                    => 5403,
                            silvestri
                                    => 8991, silvey  => 4975,
                            simard  => 7326, simas   => 7488, simkins => 9935, simmers => 8655,
                            simmon  => 6393, simmons => 88, simms   => 955, simonds => 4680,
                            simoneau
                                    => 7253, simoneaux
                                    => 7252,
                            simons  => 1158, simonsen
                                    => 8766,
                            simonson
                                    => 3480, simonton
                                    => 7251,
                            simpkins
                                    => 2169, simpson => 121,
                            sims    => 185, sinclair
                                    => 962,
                            sine    => 8654, sines   => 6894, singh   => 1114, singletary
                                    => 1900,
                            singleton
                                    => 436, singley => 6690,
                            sinnott => 9551, sipe    => 4426, sipes   => 3570, sipple  => 6179,
                            sirois  => 5441, sisco   => 3613, sisk    => 2118, sisler  => 9550,
                            sisneros
                                    => 5515, sisson  => 2444,
                            sistrunk
                                    => 7037, sitton  => 7734,
                            sizemore
                                    => 1215, sizer   => 9208,
                            skaggs  => 1632, skeen   => 4160, skeens  => 7414, skelly  => 7560,
                            skelton => 1943, skiba   => 9438, skidmore
                                    => 2250,
                            skiles  => 4809, skinner => 475, skipper => 3292, slack   => 2680,
                            slade   => 2005, slagle  => 3291, slate   => 5317, slater  => 807,
                            slaton  => 3866, slattery
                                    => 3783,
                            slaugh  => 8765, slaughter
                                    => 881,
                            slavin  => 5879, slay    => 6126, slayton => 4016, sledge  => 2294,
                            sleeper => 8414, sloan   => 589, sloat   => 6968, slocum  => 2782,
                            slone   => 2350, slover  => 8193, sluder  => 8879, slusher => 6178,
                            smalley => 2414, smalls  => 1720, smallwood
                                    => 1416,
                            smedley => 7160, smelser => 8536, smiley  => 1174, smith   => 1,
                            smither => 9092, smitherman
                                    => 4871,
                            smithers
                                    => 4766, smithey => 9696,
                            smithson
                                    => 3290, smock   => 5552,
                            smoot   => 2679, smothers
                                    => 3328,
                            smtih   => 7250, smyth   => 3516, snapp   => 5930, snavely => 8413,
                            snead   => 2852, sneed   => 1285, snell   => 1054, snelling
                                    => 7249,
                            snelson => 8990, snider  => 797, snipes  => 3265, snoddy  => 9091,
                            snodgrass
                                    => 1982, snook   => 4092,
                            snow    => 503, snowden => 1966, snyder  => 170, soares  => 2957,
                            sobel   => 8653, sobers  => 9090, socha   => 9207, soderberg
                                    => 9821,
                            sohn    => 7918, soileau => 4201, sokol   => 5051, solano  => 2810,
                            solares => 8989, solari  => 9820, solberg => 6231, soler   => 5781,
                            soles   => 9089, solis   => 643, soliz   => 2844, sollars => 7159,
                            soloman => 7413, solorio => 4314, solorzano
                                    => 6177,
                            somers  => 2868, somerville
                                    => 3880,
                            sommers => 2476, sommerville
                                    => 7412,
                            songer  => 8412, sonnenberg
                                    => 9695,
                            sonnier => 4283, soper   => 4282, sorensen
                                    => 1117,
                            sorenson
                                    => 1741, soria   => 3479,
                            soriano => 2615, sorrell => 3161, sorrells
                                    => 4374,
                            sorrentino
                                    => 8988, sosa    => 838,
                            sosebee => 9323, sotelo  => 2550, soto    => 247, sotomayor
                                    => 8878,
                            soucy   => 5162, souder  => 9088, souders => 9087, soukup  => 7559,
                            soule   => 4091, sours   => 9086, sousa   => 1827, southall
                                    => 9206,
                            southard
                                    => 3529, southerland
                                    => 3160,
                            southwick
                                    => 7558, southworth
                                    => 5514,
                            souza   => 1442, sowards => 9085, sowder  => 6628, sowell  => 2406,
                            sowers  => 2544, spaeth  => 8877, spahn   => 9322, spalding
                                    => 3439,
                            spangler
                                    => 1457, spann   => 1956,
                            spano   => 8535, sparkman
                                    => 3147,
                            sparks  => 420, sparrow => 3146, spates  => 7557, spaulding
                                    => 1324,
                            speakman
                                    => 9084, spear   => 2155,
                            spearman
                                    => 3021, spears  => 635,
                            specht  => 7411, speck   => 5636, spector => 7158, speer   => 1942,
                            speight => 3901, speights
                                    => 9819,
                            speller => 8876, spellman
                                    => 3289,
                            spence  => 710, spencer => 156, sperling
                                    => 5593,
                            sperry  => 3730, spicer  => 1482, spiegel => 5976, spielman
                                    => 7036,
                            spiers  => 7917, spies   => 7157, spiker  => 6465, spikes  => 4974,
                            spiller => 4425, spillman
                                    => 3900,
                            spina   => 6570, spindler
                                    => 8875,
                            spinelli
                                    => 5478, spinks  => 3652,
                            spires  => 5316, spitler => 7916, spitz   => 8411, spitzer => 4765,
                            spivey  => 976, spooner => 2973, spotts  => 8764, spradlin
                                    => 3361,
                            spradling
                                    => 8534, spraggins
                                    => 7915,
                            sprague => 1311, spratt  => 8096, sprayberry
                                    => 7914,
                            spriggs => 3806, springer
                                    => 927,
                            sprinkle
                                    => 4491, sproul  => 7556,
                            sprouse => 3187, spruill => 2543, spry    => 8410, spurgeon
                                    => 3899,
                            spurlin => 8874, spurling
                                    => 8652,
                            spurlock
                                    => 2235, squire  => 6689,
                            squires => 1849, sroka   => 8987, staab   => 9437, staats  => 6967,
                            stabler => 8651, stack   => 2972, stackhouse
                                    => 3757,
                            stadler => 6125, stafford
                                    => 556,
                            stagg   => 7733, staggs  => 3177, stagner => 8010, stahl   => 1524,
                            stahlman
                                    => 9436, staley  => 1459,
                            stallard
                                    => 6230, stallings
                                    => 1427,
                            stallworth
                                    => 2694, stalnaker
                                    => 6569,
                            stalvey => 9694, stambaugh
                                    => 7091,
                            stamey  => 6285, stamm   => 3756, stamper => 2117, stamps  => 2710,
                            stancil => 4490, standifer
                                    => 6893,
                            standish
                                    => 8873, standley
                                    => 5009,
                            standridge
                                    => 6512, stanek  => 9549,
                            stanfield
                                    => 2371, stanfill
                                    => 6176,
                            stanger => 7156, stanhope
                                    => 9548,
                            stannard
                                    => 9693, stansberry
                                    => 4226,
                            stansbury
                                    => 4457, stanton => 796,
                            staples => 1517, stapleton
                                    => 1397,
                            stapp   => 9818, starbuck
                                    => 8872,
                            starcher
                                    => 8763, stark   => 754,
                            starke  => 9547, starkey => 1929, starks  => 1197, starling
                                    => 2867,
                            starnes => 1569, starr   => 971, starrett
                                    => 9692,
                            staten  => 2916, statler => 9817, staton  => 1488, staub   => 6627,
                            stauffer
                                    => 3311, stclair => 2370,
                            stcyr   => 6688, steadman
                                    => 3782,
                            stearns => 1795, stebbins
                                    => 5050,
                            steck   => 7913, stedman => 8095, steed   => 2568, steele  => 287,
                            steelman
                                    => 5440, steen   => 2066,
                            stefanski
                                    => 9816, steffen => 3241,
                            steffens
                                    => 6687, steffey => 9815,
                            stegall => 3590, steger  => 5359, steib   => 6626, steiger => 7155,
                            stein   => 731, steinbach
                                    => 7648,
                            steinberg
                                    => 2663, steiner => 1481,
                            steinke => 6392, steinman
                                    => 6966,
                            steinmetz
                                    => 4373, stell   => 9546,
                            stelly  => 8293, stenger => 9083, stennett
                                    => 9691,
                            stenson => 8409, stephens
                                    => 158,
                            stephenson
                                    => 569, stepp   => 2202,
                            stern   => 1396, sternberg
                                    => 6284,
                            sterner => 5236, sterrett
                                    => 9082,
                            stevens => 122, stevenson
                                    => 318,
                            steverson
                                    => 7732, steward => 1030,
                            stewart => 49, stgeorge
                                    => 8986,
                            stgermain
                                    => 5551, sthilaire
                                    => 6464,
                            stice   => 9321, stickler
                                    => 7154,
                            stickley
                                    => 8871, stickney
                                    => 4585,
                            stidham => 3460, stier   => 8009, stiffler
                                    => 6391,
                            stiles  => 1315, stillman
                                    => 4072,
                            stills  => 9934, stillwell
                                    => 3426,
                            stiltner
                                    => 3046, stilwell
                                    => 5592,
                            stimpson
                                    => 8870, stine   => 2737,
                            stines  => 8650, stinnett
                                    => 2781,
                            stinson => 913, stites  => 5780, stith   => 4908, stitt   => 3755,
                            stiver  => 9545, stivers => 7912, stjohn  => 1909, stlaurent
                                    => 8408,
                            stlouis => 5591, stockdale
                                    => 6568,
                            stocker => 4522, stockman
                                    => 4424,
                            stocks  => 4521, stockstill
                                    => 9814,
                            stockton
                                    => 1794, stockwell
                                    => 5126,
                            stoddard
                                    => 1907, stoffel => 7090,
                            stogner => 8094, stoker  => 3939, stokes  => 381, stoll   => 3145,
                            stollings
                                    => 6892, stoltz  => 5477,
                            stoltzfus
                                    => 4679, stone   => 151,
                            stoner  => 1848, stonge  => 4136, stoops  => 5734, storer  => 5929,
                            storey  => 1858, storms  => 4638, stott   => 3898, stotts  => 6463,
                            stouffer
                                    => 6124, stout   => 722,
                            stovall => 1541, stover  => 1169, stowe   => 2662, stowell => 4870,
                            stowers => 4258, stpeter => 8407, stpierre
                                    => 2866,
                            strachan
                                    => 8192, strader => 4281,
                            strahan => 6625, strain  => 2903, strait  => 4372, straka  => 8008,
                            straley => 7410, strand  => 2971, strang  => 9320, strasser
                                    => 7487,
                            stratton
                                    => 1295, straub  => 3977,
                            strauch => 9319, strauss => 2542, strawn  => 4520, strawser
                                    => 6752,
                            strayer => 8985, streeter
                                    => 2049,
                            streit  => 8649, stribling
                                    => 5513,
                            stricker
                                    => 7089, strickland
                                    => 345,
                            strickler
                                    => 4614, stricklin
                                    => 4280,
                            stringer
                                    => 1369, stringfellow
                                    => 6072,
                            stringfield
                                    => 8869, stringham
                                    => 8762,
                            stripling
                                    => 7647, strobel => 5476,
                            strode  => 6567, stroh   => 6071, strom   => 4178, stroman => 5315,
                            stromberg
                                    => 5733, strong  => 576,
                            strope  => 9933, strother
                                    => 2637,
                            stroud  => 1083, stroup  => 3964, stroupe => 9813, strouse => 7035,
                            struble => 6175, strunk  => 3478, stubblefield
                                    => 2560,
                            stubbs  => 1307, stuckey => 2736, studebaker
                                    => 9690,
                            studer  => 4371, stull   => 3099, stultz  => 5690, stump   => 2413,
                            stumpf  => 5125, sturdivant
                                    => 3897,
                            sturgeon
                                    => 3215, sturges => 8093,
                            sturgill
                                    => 3186, sturgis => 3896,
                            sturm   => 3497, sturtevant
                                    => 8007,
                            stutz   => 8292, stutzman
                                    => 4557,
                            styron  => 9435, suarez  => 714, suazo   => 7827, suber   => 4519,
                            sublett => 6070, sudduth => 5732, suggs   => 1395, suiter  => 6229,
                            sullins => 6228, sullivan
                                    => 100,
                            sumlin  => 9318, summerlin
                                    => 3895,
                            summers => 449, summerville
                                    => 5049,
                            summey  => 9812, sumner  => 1327, sumpter => 3083, sumrall => 5550,
                            sundberg
                                    => 6283, sunderland
                                    => 5235,
                            sundquist
                                    => 9205, surber  => 5234,
                            surles  => 8984, surratt => 4114, sussman => 6029, suter   => 7409,
                            sutherland
                                    => 1127, sutphin => 5689,
                            sutter  => 3098, suttle  => 6686, suttles => 5314, sutton  => 261,
                            suzuki  => 5008, svoboda => 7088, swafford
                                    => 2369,
                            swaim   => 6028, swain   => 895, swan    => 1252, swaney  => 7087,
                            swanger => 8648, swank   => 3377, swann   => 1981, swanner => 8291,
                            swanson => 354, swarey  => 6566, swart   => 8647, swartz  => 1137,
                            swearingen
                                    => 3963, sweatman
                                    => 9689,
                            sweatt  => 5928, sweeney => 575, sweeny  => 8533, sweitzer
                                    => 6829,
                            swensen => 9204, swenson => 1468, swett   => 6174, swick   => 8092,
                            swift   => 1192, swiger  => 6027, swilley => 9081, swindell
                                    => 5313,
                            swindle => 4833, swinehart
                                    => 9203,
                            swiney  => 9688, swinford
                                    => 8006,
                            swingle => 9811, swink   => 6069, swinney => 4808, swinson => 7248,
                            swint   => 8091, swinton => 5512, swisher => 2931, switzer => 2111,
                            swope   => 3894, sydnor  => 7247, sykes   => 738, symonds => 8983,
                            symons  => 8005, synder  => 8090, szabo   => 4939, szeto   => 9932,
                            szymanski
                                    => 4456, tabares => 9544,
                            tabb    => 4518, taber   => 3360, tabor   => 1643, tackett => 1678,
                            tadlock => 8868, tafoya  => 4279, taft    => 2645, taggart => 3020,
                            tague   => 8004, tait    => 5161, takahashi
                                    => 5927,
                            talamantes
                                    => 8646, talarico
                                    => 9080,
                            talavera
                                    => 7408, talbert => 2285,
                            talbot  => 1585, talbott => 3528, taliaferro
                                    => 7246,
                            talkington
                                    => 8645, tallant => 9931,
                            tallent => 3962, talley  => 816, tallman => 4370, tally   => 9687,
                            talton  => 7325, tamayo  => 3073, tamez   => 6390, tanaka  => 3045,
                            tang    => 1801, tanguay => 7646, tankersley
                                    => 4613,
                            tanksley
                                    => 9317, tanner  => 566,
                            tapia   => 1080, tapley  => 5878, tapp    => 3709, tapper  => 8761,
                            tarango => 6227, tarantino
                                    => 9316,
                            tarbox  => 8191, tardif  => 7645, tardiff => 5829, tarpley => 7911,
                            tarr    => 4313, tarrant => 5048, tart    => 6965, tarter  => 6565,
                            tarver  => 3059, tarvin  => 9686, tasker  => 8190, tate    => 321,
                            tatro   => 4764, tatum   => 939, tauber  => 9685, tavares => 2587,
                            tavarez => 6624, taveras => 6226, taylor  => 10, teague  => 1089,
                            teal    => 3214, teasley => 6685, tedder  => 5439, tedeschi
                                    => 8290,
                            tedesco => 4721, tedford => 6684, teel    => 2368, teeter  => 3515,
                            teeters => 8089, teets   => 8289, teixeira
                                    => 5635,
                            tejada  => 3551, tejeda  => 3805, telford => 7731, telles  => 6564,
                            tellez  => 3240, tellier => 9930, tello   => 5634, templeton
                                    => 2041,
                            templin => 8088, tennant => 3097, tenney  => 3569, tennison
                                    => 8288,
                            tennyson
                                    => 5779, tenorio => 6462,
                            teran   => 7245, terrazas
                                    => 4807,
                            terrill => 3938, terwilliger
                                    => 6964,
                            tesch   => 6123, teske   => 9202, tessier => 6828, testa   => 4369,
                            tester  => 8760, testerman
                                    => 7555,
                            teter   => 7554, tetreault
                                    => 4584,
                            thach   => 8406, thacker => 1347, thames  => 3846, tharp   => 1915,
                            tharpe  => 5511, thatcher
                                    => 3589,
                            thaxton => 6461, thayer  => 1526, theis   => 4720, theisen => 4455,
                            theiss  => 8644, thelen  => 8003, theobald
                                    => 7153,
                            theriault
                                    => 3754, theriot => 3918,
                            theroux => 9201, therrien
                                    => 4612,
                            theus   => 9929, thibault
                                    => 4583,
                            thibeault
                                    => 5590, thibodeau
                                    => 2518,
                            thibodeaux
                                    => 2497, thiel   => 3827,
                            thiele  => 8087, thielen => 5688, thies   => 5877, thigpen => 2541,
                            thom    => 4806, thoma   => 5687, thomason
                                    => 1130,
                            thomasson
                                    => 7553, thompkins
                                    => 5007,
                            thompson
                                    => 16, thoms   => 9684,
                            thomsen => 3514, thomson => 1256, thorn   => 2367, thornberry
                                    => 8532,
                            thornburg
                                    => 3753, thorne  => 1464,
                            thornhill
                                    => 3438, thornton
                                    => 327,
                            thorp   => 4071, thorpe  => 1334, thorsen => 9928, thorson => 5124,
                            thorton => 3185, thrash  => 3668, thrasher
                                    => 2154,
                            threadgill
                                    => 8002, threatt => 8086,
                            thrift  => 7034, throckmorton
                                    => 8405,
                            thrower => 5312, thurber => 5589, thurlow => 9543, thurmond
                                    => 4832,
                            thurston
                                    => 1857, tibbetts
                                    => 3781,
                            tibbs   => 2678, tice    => 3128, tichenor
                                    => 8982,
                            tidwell => 1160, tierney => 2915, tighe   => 6282, tigner  => 9683,
                            tijerina
                                    => 2768, tilghman
                                    => 7324,
                            tiller  => 3612, tillery => 2851, tillett => 7826, tilley  => 1658,
                            tillis  => 6173, tillman => 696, tillotson
                                    => 6281,
                            tilton  => 2996, timberlake
                                    => 5686,
                            timm    => 3687, timmerman
                                    => 4177,
                            timmins => 8759, timmons => 1377, timms   => 6026, tims    => 8404,
                            tincher => 6333, tindall => 4090, tindell => 9434, tindle  => 8403,
                            tiner   => 9433, tingle  => 5926, tingley => 7323, tinker  => 3879,
                            tinney  => 5685, tinnin  => 9432, tinsley => 1767, tippett => 8643,
                            tipton  => 1085, tirado  => 2331, tisdale => 2586, tittle  => 7407,
                            tobar   => 7730, tobey   => 5438, tobin   => 1500, toland  => 7152,
                            tolar   => 9682, tolbert => 1074, toledo  => 2833, tolentino
                                    => 5549,
                            toler   => 2887, toles   => 8981, toliver => 3127, tolle   => 6563,
                            tollefson
                                    => 7552, tolley  => 4089,
                            tollison
                                    => 8980, tolliver
                                    => 2496,
                            tolman  => 5778, tolson  => 5777, toman   => 9927, tomaszewski
                                    => 9431,
                            tomblin => 8642, tomes   => 8402, tomlin  => 2243, tomlinson
                                    => 1122,
                            tompkins
                                    => 1280, toms    => 5233,
                            toner   => 6172, tong    => 3611, toole   => 4719, tooley  => 5047,
                            toombs  => 4805, toomer  => 8287, toomey  => 5046, toon    => 6891,
                            topete  => 9681, topper  => 9315, topping => 7729, torain  => 9430,
                            torgerson
                                    => 5232, toro    => 3176,
                            torre   => 8189, torrence
                                    => 3477,
                            torres  => 65, torrey  => 4907, torrez  => 1864, toscano => 4257,
                            toth    => 1891, totten  => 3752, toussaint
                                    => 5437,
                            tovar   => 1555, towe    => 6683, towery  => 8641, towle   => 4278,
                            towne   => 4368, towner  => 6225, townes  => 3845, townley => 6511,
                            townsel => 9079, townsend
                                    => 346,
                            townsley
                                    => 7728, trader  => 6890,
                            trafton => 9926, trahan  => 2073, trainor => 4423, tramel  => 7406,
                            trammel => 7910, trammell
                                    => 2445,
                            tran    => 429, trantham
                                    => 4312,
                            trapp   => 2956, trask   => 3347, traub   => 9810, traver  => 9078,
                            trawick => 7727, traxler => 9429, traylor => 1714, traynor => 7086,
                            treadway
                                    => 3437, treadwell
                                    => 2865,
                            treece  => 4804, trejo   => 1677, tremblay
                                    => 3144,
                            tressler
                                    => 9200, trevino => 546,
                            trexler => 7244, tribble => 3415, trice   => 3009, trigg   => 5925,
                            triggs  => 9680, trimble => 1872, triplett
                                    => 1420,
                            tripp   => 1298, troche  => 9077, trombley
                                    => 4135,
                            trosclair
                                    => 9199, trost   => 7644,
                            trotman => 5588, trott   => 4973, trotta  => 8979, trotter => 1310,
                            trottier
                                    => 7825, troup   => 7909,
                            troupe  => 5311, trout   => 2140, troutman
                                    => 2309,
                            troutt  => 8978, trowbridge
                                    => 4200,
                            troxel  => 9076, troxell => 7033, troxler => 8401, troyer  => 5876,
                            truax   => 5192, trudeau => 3686, trueblood
                                    => 7726,
                            truelove
                                    => 8640, truesdale
                                    => 5436,
                            truesdell
                                    => 8977, truett  => 7725,
                            truex   => 9925, truitt  => 2873, trujillo
                                    => 587,
                            trull   => 6122, trump   => 7486, truong  => 2190, truss   => 7032,
                            trussell
                                    => 5633, trusty  => 7908,
                            tsai    => 6025, tsang   => 6827, tsosie  => 4637, tubbs   => 2308,
                            tucci   => 5731, tuck    => 2767, tucker  => 123, tudor   => 4337,
                            tufts   => 9075, tuggle  => 3175, tull    => 6121, tullis  => 6510,
                            tully   => 4454, tunnell => 5924, tunstall
                                    => 6460,
                            tupper  => 7322, turcotte
                                    => 4906,
                            turek   => 9428, turgeon => 6459, turk    => 2766, turley  => 2864,
                            turman  => 3878, turnage => 4396, turnbow => 6068, turnbull
                                    => 3254,
                            turner  => 42, turney  => 3213, turpin  => 2210, tussey  => 9542,
                            tuten   => 9198, tutt    => 7085, tuttle  => 1063, tweed   => 7551,
                            tweedy  => 8531, twigg   => 6623, twilley => 8639, twitchell
                                    => 8758,
                            twitty  => 6889, twombly => 8286, twomey  => 6509, twyman  => 7643,
                            tyndall => 5475, tyner   => 3327, tynes   => 6562, tyrrell => 5510,
                            tyus    => 7642, ulibarri
                                    => 6682,
                            ullman  => 7321, ulloa   => 4556, ullrich => 7641, ulmer   => 4159,
                            ulrich  => 1840, umana   => 9809, underhill
                                    => 3425,
                            underwood
                                    => 439, unger   => 2061,
                            unknow  => 8188, unruh   => 5548, upchurch
                                    => 2540,
                            updike  => 9679, upham   => 9427, upshaw  => 3159, upton   => 2011,
                            urbina  => 2985, urena   => 4336, urias   => 4938, uribe   => 2386,
                            urquhart
                                    => 6024, urrutia => 6963,
                            usher   => 3917, ussery  => 4367, utley   => 3288, utter   => 5875,
                            utterback
                                    => 9678, vaca    => 6171,
                            vaccaro => 5730, vachon  => 5776, vaden   => 6888, vadnais => 8638,
                            vail    => 2481, vaillancourt
                                    => 5358,
                            valadez => 2517, valdes  => 2397, valdez  => 313, valdivia
                                    => 5310,
                            valdovinos
                                    => 7640, valencia
                                    => 848,
                            valente => 6067, valenti => 3804, valentine
                                    => 660,
                            valentino
                                    => 4311, valenzuela
                                    => 780,
                            valera  => 9808, valerio => 3239, valero  => 7639, valladares
                                    => 5275,
                            valle   => 1480, vallee  => 8530, vallejo => 2765, vallejos
                                    => 8976,
                            valles  => 3036, valliere
                                    => 6622,
                            valverde
                                    => 5309, vanarsdale
                                    => 9677,
                            vanatta => 8400, vanburen
                                    => 3826,
                            vanbuskirk
                                    => 5123, vancleave
                                    => 7485,
                            vandenberg
                                    => 5587, vanderpool
                                    => 4489,
                            vandeusen
                                    => 9074, vandiver
                                    => 3937,
                            vandusen
                                    => 5357, vandyke => 2116,
                            vanegas => 6681, vang    => 870, vanhook => 8187, vanhoose
                                    => 3513,
                            vanhorn => 2366, vanhouten
                                    => 5775,
                            vankirk => 8529, vanlandingham
                                    => 6751,
                            vanmeter
                                    => 3359, vann    => 1664,
                            vannatta
                                    => 8637, vanness => 7151,
                            vannoy  => 5828, vanover => 3825, vanpelt => 4395, vanscoy => 8528,
                            vansickle
                                    => 4582, vantassel
                                    => 8285,
                            vanvalkenburg
                                    => 8757, vanwinkle
                                    => 3496,
                            vanwormer
                                    => 9314, vanzandt
                                    => 8399,
                            vanzant => 6887, varela  => 1771, varga   => 5402, vargas  => 241,
                            vargo   => 5160, varnado => 7084, varnell => 9541, varner  => 1456,
                            varney  => 2185, vasques => 8398, vasquez => 195, vassallo
                                    => 8636,
                            vassar  => 7724, vasser  => 9426, vaughan => 750, vaughn  => 281,
                            vaught  => 2764, vazquez => 463, veach   => 5774, veal    => 3588,
                            veasey  => 8635, veatch  => 9073, vega    => 332, veilleux
                                    => 4555,
                            vela    => 1277, velarde => 5773, velasco => 1835, velasquez
                                    => 605,
                            velazquez
                                    => 868, velez   => 623,
                            veliz   => 6332, veloz   => 7907, venable => 3174, venegas => 3376,
                            venezia => 9540, ventura => 1450, verdin  => 3610, verdugo => 6023,
                            verduzco
                                    => 4831, vereen  => 6750,
                            vergara => 3961, vermillion
                                    => 4581,
                            verner  => 9924, verret  => 6826, verrill => 9807, vest    => 2361,
                            vestal  => 5923, vetter  => 3044, vick    => 1623, vickers => 1104,
                            vickery => 2730, vidal   => 2539, vidrine => 5827, vieira  => 3936,
                            viera   => 3358, vierra  => 5274, vigil   => 1079, vigue   => 8186,
                            villa   => 926, villagomez
                                    => 4176,
                            villalba
                                    => 7638, villalobos
                                    => 1511,
                            villalpando
                                    => 6280, villani => 9676,
                            villanueva
                                    => 907, villar  => 7824,
                            villareal
                                    => 3326, villarreal
                                    => 594,
                            villasenor
                                    => 3587, villatoro
                                    => 7243,
                            villegas
                                    => 1157, villeneuve
                                    => 8634,
                            vinci   => 8975, vines   => 2307, vineyard
                                    => 5091,
                            vining  => 4678, vinson  => 851, vinyard => 8756, viramontes
                                    => 9313,
                            visser  => 8527, vitale  => 3035, voelker => 7031, vogel   => 1133,
                            vogler  => 7030, vogt    => 1663, voight  => 7823, voigt   => 4199,
                            volk    => 4718, volkman => 8001, vollmer => 5922, volpe   => 4803,
                            volz    => 4134, voorhees
                                    => 5191,
                            voss    => 1262, vowell  => 8284, voyles  => 6825, vreeland
                                    => 9806,
                            vroman  => 8974, vuong   => 6621, wachter => 4394, wacker  => 6561,
                            waddell => 1227, waddle  => 4830, wade    => 246, wadley  => 6120,
                            wadsworth
                                    => 2597, wagers  => 7320,
                            wages   => 6170, waggoner
                                    => 2156,
                            wagner  => 164, wagoner => 1991, wagstaff
                                    => 6962,
                            waguespack
                                    => 9425, wahl    => 2511,
                            wainscott
                                    => 9539, wainwright
                                    => 4869,
                            waite   => 1747, waiters => 8867, waites  => 5435, waits   => 4310,
                            wakefield
                                    => 1965, wakeman => 9923,
                            walcott => 7484, walczak => 7723, wald    => 7483, walden  => 937,
                            waldman => 6119, waldon  => 4972, waldrep => 9675, waldron => 1619,
                            waldrop => 2341, waldrup => 8283, walker  => 24, walkup  => 9805,
                            wall    => 494, wallace => 101, wallen  => 3708, waller  => 689,
                            walley  => 6680, wallin  => 4256, walling => 2626, wallis  => 2088,
                            walls   => 616, walmsley
                                    => 9804,
                            walser  => 8866, walsh   => 299, walston => 3568, walters => 248,
                            walther => 4517, waltman => 7637, walton  => 349, waltz   => 4905,
                            walz    => 4335, wampler => 3651, wamsley => 9922, wang    => 892,
                            wanner  => 9674, ward    => 64, wardell => 7319, warden  => 2094,
                            wardlaw => 8185, wardlow => 8865, ware    => 476, warfield
                                    => 2832,
                            wargo   => 7083, waring  => 5190, warman  => 8282, warner  => 317,
                            warnke  => 8633, warnock => 4334, warr    => 8632, warren  => 132,
                            warrick => 5045, warrington
                                    => 5356,
                            warwick => 4904, washam  => 8864, washburn
                                    => 1501,
                            washer  => 8397, washington
                                    => 86,
                            wasserman
                                    => 5975, wasson  => 2995,
                            watanabe
                                    => 4393, waterhouse
                                    => 6749,
                            waterman
                                    => 2115, waters  => 390,
                            watford => 6458, watkins => 166, watson  => 69, watt    => 1826,
                            watters => 2625, watterson
                                    => 6279,
                            watts   => 270, waugh   => 2322, wayland => 7405, wayman  => 4453,
                            waymire => 8973, weakley => 9072, weatherby
                                    => 5921,
                            weatherford
                                    => 2902, weatherly
                                    => 3043,
                            weathers
                                    => 1847, weathersby
                                    => 4717,
                            weatherspoon
                                    => 4422, weaver  => 181,
                            webb    => 120, webber  => 968, weber   => 298, webster => 364, weddington
                                    => 9197,
                            weddle  => 3729, wedgeworth
                                    => 9803,
                            weed    => 3346, weeden  => 7822, weekley => 5826, weeks   => 629,
                            weems   => 2510, weese   => 6824, wegener => 9196, wegner  => 4763,
                            weibel  => 9673, weidman => 7150, weidner => 4829, weigand => 7821,
                            weigel  => 5231, weikel  => 8972, weil    => 4762, weiland => 5401,
                            weiler  => 4309, weimer  => 4488, weinberg
                                    => 3877,
                            weinberger
                                    => 8396, weiner  => 2148,
                            weinstein
                                    => 2385, weintraub
                                    => 6886,
                            weir    => 1445, weis    => 3609, weisberg
                                    => 8184,
                            weise   => 5729, weiser  => 6331, weisman => 6679, weiss   => 586,
                            weissman
                                    => 7906, weitzel => 7318,
                            welborn => 4636, welch   => 223, welker  => 3751, weller  => 1806,
                            wellman => 2027, wells   => 119, welsh   => 1039, welter  => 7082,
                            welton  => 5090, welty   => 5230, wendel  => 5474, wendling
                                    => 8526,
                            wendt   => 2624, wenger  => 3824, wentworth
                                    => 2970,
                            wentz   => 3459, wentzel => 8525, wenzel  => 2799, wert    => 5400,
                            werth   => 6678, werts   => 8863, wertz   => 2763, wescott => 5229,
                            wesner  => 9921, wessel  => 5122, wessels => 8000, wesson  => 4421,
                            west    => 104, westberg
                                    => 8971,
                            westberry
                                    => 8524, westbrook
                                    => 1540,
                            westbrooks
                                    => 6169, westcott
                                    => 4677,
                            wester  => 3608, westerfield
                                    => 7722,
                            westerman
                                    => 5874, westfall
                                    => 2559,
                            westfield
                                    => 9672, westgate
                                    => 8862,
                            westlake
                                    => 9195, westlund
                                    => 7999,
                            westman => 8861, westmoreland
                                    => 2313,
                            westover
                                    => 5873, westphal
                                    => 4554,
                            wetherell
                                    => 9194, wethington
                                    => 7905,
                            wetmore => 5728, wetzel  => 1879, wexler  => 6508, weyant  => 9538,
                            whalen  => 1419, whaley  => 1027, wharton => 2780, whatley => 1776,
                            wheat   => 2189, wheatley
                                    => 1975,
                            wheaton => 3253, wheeler => 197, wheelock
                                    => 7998,
                            whelan  => 3550, whetstone
                                    => 4366,
                            whetzel => 9071, whidden => 9312, whipkey => 9802, whipple => 2004,
                            whisenant
                                    => 6823, whisenhunt
                                    => 7820,
                            whisler => 8395, whitacre
                                    => 5308,
                            whitaker
                                    => 473, whitcomb
                                    => 3096,
                            white   => 13, whiteaker
                                    => 9671,
                            whited  => 3424, whitefield
                                    => 8755,
                            whitehead
                                    => 510, whitehouse
                                    => 4365,
                            whitehurst
                                    => 2798, whiteley
                                    => 6507,
                            whiteman
                                    => 4070, whitener
                                    => 5089,
                            whitesell
                                    => 7482, whiteside
                                    => 2941,
                            whitesides
                                    => 9537, whitfield
                                    => 815,
                            whitford
                                    => 5228, whiting => 2184,
                            whitley => 869, whitlock
                                    => 1676,
                            whitlow => 2914, whitman => 1631, whitmer => 5088, whitmire
                                    => 3310,
                            whitmore
                                    => 1719, whitson => 2405,
                            whitt   => 1590, whittaker
                                    => 1499,
                            whitted => 5355, whittemore
                                    => 4937,
                            whitten => 1539, whittier
                                    => 7317,
                            whittington
                                    => 1740, whittle => 2797,
                            whitton => 7721, whitworth
                                    => 2614,
                            whorton => 5159, whyte   => 3823, wible   => 9801, wick    => 3844,
                            wicker  => 2495, wickersham
                                    => 9800,
                            wickham => 4069, wicklund
                                    => 7636,
                            wickman => 8631, wicks   => 2596, wideman => 8085, widener => 6961,
                            widmer  => 7316, widner  => 8084, wiebe   => 9424, wiegand => 5434,
                            wieland => 6022, wiener  => 5632, wiens   => 9311, wiese   => 3375,
                            wiesner => 9536, wiest   => 9920, wigfall => 5825, wiggins => 490,
                            wigginton
                                    => 8860, wiggs   => 6560,
                            wight   => 6118, wigley  => 8183, wilbanks
                                    => 2661,
                            wilborn => 4761, wilbourn
                                    => 8394,
                            wilcher => 5684, wilcox  => 451, wilde   => 2567, wilder  => 744,
                            wildman => 6066, wilds   => 7819, wiles   => 2261, wiley   => 526,
                            wilfong => 5433, wilhelm => 1883, wilhite => 3667, wilhoit => 8523,
                            wiliams => 9799, wilk    => 6960, wilke   => 3685, wilken  => 9798,
                            wilkens => 6021, wilkerson
                                    => 447,
                            wilkes  => 1434, wilkey  => 7635, wilkie  => 5158, wilkins => 437,
                            wilkinson
                                    => 559, wilks   => 2384,
                            willaims
                                    => 8522, willams => 8182,
                            willcox => 8970, wille   => 7550, willett => 1856, willey  => 1998,
                            willhite
                                    => 8181, williams
                                    => 3,
                            williamson
                                    => 202, williford
                                    => 3095,
                            willingham
                                    => 1762, willis  => 165,
                            willison
                                    => 8281, willman => 7481,
                            willoughby
                                    => 1761, wills   => 1012,
                            willson => 2821, wilmot  => 6020, wilmoth => 3666, wilson  => 8,
                            wilt    => 3436, wiltse  => 9423, wimberly
                                    => 3287,
                            wimbush => 8180, wimer   => 7242, wimmer  => 4487, winburn => 8521,
                            winbush => 9919, winchell
                                    => 5586,
                            winchester
                                    => 3158, winder  => 5585,
                            windham => 2330, windle  => 7404, windley => 9670, windom  => 7241,
                            windsor => 4158, winebrenner
                                    => 9193,
                            winegar => 8630, wines   => 7081, winfield
                                    => 2613,
                            winfree => 9918, winfrey => 3414, wingard => 4452, wingate => 3325,
                            winger  => 5307, wingert => 9535, wingfield
                                    => 3324,
                            wingo   => 4971, winkelman
                                    => 7315,
                            winkle  => 7240, winkler => 1433, winn    => 1394, winslow => 1692,
                            winstead
                                    => 2392, winter  => 936,
                            winters => 591, winton  => 5824, wireman => 8280, wirth   => 3309,
                            wirtz   => 9534, wise    => 384, wiseman => 1245, wisner  => 6620,
                            wisniewski
                                    => 3495, witcher => 3935,
                            witham  => 5974, withers => 2461, witherspoon
                                    => 1516,
                            withrow => 3803, witkowski
                                    => 6019,
                            witmer  => 7314, witt    => 800, witte   => 3458, witten  => 7403,
                            wittman => 6885, wofford => 2365, wojciechowski
                                    => 9917,
                            wojcik  => 5306, wolcott => 4113, wold    => 4516, wolf    => 471,
                            wolfe   => 302, wolfenbarger
                                    => 7634,
                            wolff   => 1463, wolfgang
                                    => 8083,
                            wolford => 2421, wolfson => 7029, wolter  => 7549, wolters => 8279,
                            wolverton
                                    => 9192, womack  => 921,
                            womble  => 4486, wong    => 416, wood    => 74, woodall => 1652,
                            woodard => 519, woodberry
                                    => 9669,
                            woodbury
                                    => 3750, woodcock
                                    => 2955,
                            woodell => 9916, woodford
                                    => 5547,
                            woodham => 7080, woodhouse
                                    => 5227,
                            woodland
                                    => 5399, woodley => 3143,
                            woodman => 5044, woodring
                                    => 6018,
                            woodruff
                                    => 1020, woodrum => 7904,
                            woods   => 102, woodside
                                    => 8859,
                            woodson => 1317, woodward
                                    => 648,
                            woodworth
                                    => 2886, woody   => 1415,
                            woodyard
                                    => 8278, woolard => 5973,
                            wooldridge
                                    => 3345, woolery => 6559,
                            wooley  => 3893, woolf   => 6117, woolfolk
                                    => 7402,
                            woolford
                                    => 9070, woolley => 4420,
                            woolridge
                                    => 7720, woolsey => 4364,
                            woosley => 6506, wooster => 8179, wooten  => 857, wooton  => 8082,
                            worden  => 3042, workman => 832, worley  => 1015, worrell => 2060,
                            worsham => 4046, worsley => 7719, wortham => 3916, worthen => 5305,
                            worthington
                                    => 1766, worthy  => 2677,
                            wortman => 6278, wotring => 9533, wozniak => 4868, wray    => 1455,
                            wren    => 2293, wrenn   => 4936, wright  => 30, wrigley => 8858,
                            wroblewski
                                    => 8857, wulf    => 7718,
                            wulff   => 9797, wunderlich
                                    => 7149,
                            wurth   => 6959, wyant   => 3960, wyatt   => 501, wyche   => 4676,
                            wyckoff => 4580, wylie   => 2475, wyman   => 2147, wymer   => 9668,
                            wynn    => 793, wynne   => 3142, wyrick  => 4611, wysocki => 6330,
                            xiong   => 1474, yaeger  => 9069, yager   => 4485, yamada  => 4828,
                            yamamoto
                                    => 3843, yamashita
                                    => 9796,
                            yancey  => 1990, yancy   => 4419, yandell => 7818, yanez   => 2217,
                            yang    => 712, yarber  => 7028, yarborough
                                    => 4255,
                            yarbrough
                                    => 899, yardley => 9795,
                            yarnell => 9422, yates   => 357, yazzie  => 1577, ybarra  => 1426,
                            yeager  => 1303, yeary   => 8754, yelverton
                                    => 9310,
                            yepez   => 7903, yerger  => 9667, yetter  => 9309, yeung   => 7997,
                            yingling
                                    => 5398, yoakum  => 8393,
                            yockey  => 7239, yocum   => 4045, yoder   => 973, yoho    => 5683,
                            yoon    => 3567, yoshida => 5772, yost    => 1780, youmans => 4867,
                            young   => 27, youngblood
                                    => 1425,
                            youngman
                                    => 6884, youngs  => 5273,
                            yount   => 3072, younts  => 7148, yuen    => 5823, zabala  => 9191,
                            zabel   => 9068, zacharias
                                    => 9067,
                            zackery => 9794, zahn    => 5631, zajac   => 7401, zamarripa
                                    => 8081,
                            zambrano
                                    => 3995, zamora  => 711,
                            zamudio => 5872, zapata  => 1669, zaragoza
                                    => 3058,
                            zarate  => 2930, zavala  => 1329, zayas   => 4802, zeigler => 1917,
                            zelaya  => 6017, zeller  => 3308, zellers => 7717, zellmer => 9308,
                            zeman   => 9793, zendejas
                                    => 8520,
                            zepeda  => 1765, zerbe   => 8969, zeringue
                                    => 7027,
                            zhang   => 3238, zhao    => 7996, ziegler => 1323, zielinski
                                    => 2863,
                            zimmer  => 1855, zimmerman
                                    => 402,
                            zimmermann
                                    => 4716, zink    => 4068,
                            zinn    => 4392, zirkle  => 9190, zito    => 6558, zook    => 2796,
                            zorn    => 6677, zuber   => 4675, zucker  => 7480, zuckerman
                                    => 8856,
                            zukowski
                                    => 8855, zumwalt => 6958,
                            zuniga  => 1026
                          },
  english_wikipedia    => {
                            "'aliabad"
                                     => 29457,
                            "'best"  => 10152, "'black" => 18881, "'blue"  => 28758, "'bout"  => 28263,
                            "'cause" => 22167, "'first" => 23530, "'free"  => 25327, "'golden"
                                     => 26379,
                            "'good"  => 18287, "'great" => 21411, "'green" => 25930, "'high"  => 25123,
                            "'home"  => 28018, "'king"  => 24881, "'little"
                                     => 21470,
                            "'live"  => 28182, "'love"  => 25218, "'most"  => 25403, "'national"
                                     => 25534,
                            "'ndrangheta"
                                     => 29916, "'olya"  => 14252,
                            "'open"  => 29569, "'real"  => 24587, "'round" => 23353, "'special"
                                     => 27945,
                            "'that"  => 19539, "'the"   => 2672, "'there" => 23997, "'this"  => 16473,
                            "'well"  => 26274, "'what"  => 15039, "'when"  => 27894, "'white" => 21403,
                            "'world" => 29007, "1,000th"
                                     => 29837,
                            "100th"  => 6685, "101st"  => 11841, "102nd"  => 20687, "103rd"  => 19667,
                            "104th"  => 18244, "105th"  => 20668, "106th"  => 20547, "107th"  => 20234,
                            "1080p"  => 26616, "108th"  => 20105, "109th"  => 19898, "10th"   => 2222,
                            "110th"  => 17149, "111th"  => 17664, "112th"  => 18957, "113th"  => 15594,
                            "114th"  => 23348, "115th"  => 23613, "116th"  => 19776, "117th"  => 23279,
                            "118th"  => 26396, "119th"  => 27015, "11th"   => 2253, "120th"  => 24122,
                            "121st"  => 25805, "124th"  => 28247, "125cc"  => 23765, "125th"  => 15294,
                            "126th"  => 26243, "127th"  => 28255, "128th"  => 29109, "12th"   => 2033,
                            "130th"  => 28922, "131st"  => 29274, "135th"  => 27656, "13th"   => 2101,
                            "140th"  => 29875, "148th"  => 29731, "14th"   => 2212, "1500m"  => 23456,
                            "1500s"  => 28861, "150th"  => 12622, "153rd"  => 29602, "157th"  => 29268,
                            "15th"   => 2127, "1600s"  => 19823, "160th"  => 27882, "161st"  => 29633,
                            "1620s"  => 26893, "1630s"  => 21976, "1640s"  => 23894, "1650s"  => 24425,
                            "1660s"  => 24907, "1670s"  => 27947, "1680s"  => 26586, "1690s"  => 27472,
                            "16th"   => 1877, "1700s"  => 16484, "1720s"  => 24131, "1730s"  => 21686,
                            "173rd"  => 29244, "1740s"  => 21378, "1750s"  => 20067, "175th"  => 28507,
                            "1760s"  => 17828, "1770s"  => 16884, "1780s"  => 16024, "1790s"  => 14366,
                            "17th"   => 1777, "1800s"  => 7659, "180deg" => 19440, "180th"  => 27374,
                            "1820s"  => 9677, "1830s"  => 7341, "1840s"  => 7044, "1850s"  => 6032,
                            "1860s"  => 5916, "1870s"  => 5578, "1880s"  => 4713, "1890s"  => 5065,
                            "18th"   => 1478, "1900s"  => 5957, "1910s"  => 9510, "1920s"  => 2143,
                            "1930s"  => 1722, "1940s"  => 2527, "1950s"  => 1328, "1960s"  => 967,
                            "1970s"  => 882, "1980s"  => 844, "1990s"  => 943, "19th"   => 816,
                            "1up.com"
                                     => 27197, "2/1st"  => 29880,
                            "2000s"  => 2961, "200th"  => 14658, "2010s"  => 9804, "20th"   => 946,
                            "21st"   => 2626, "22nd"   => 5534, "23rd"   => 5593, "24th"   => 5311,
                            "250cc"  => 22697, "250th"  => 28551, "25th"   => 4317, "26th"   => 5912,
                            "27th"   => 5996, "300th"  => 20392, "30deg"  => 24304, "30th"   => 5276,
                            "360deg" => 19383, "400th"  => 23207, "45deg"  => 20723, "49ers"  => 6579,
                            "4kids"  => 27895, "4x100"  => 9896, "4x100m" => 23939, "4x200"  => 18620,
                            "4x400"  => 20127, "500cc"  => 24644, "500th"  => 21156, "509th"  => 29889,
                            "50th"   => 5188, "60deg"  => 23835, "76ers"  => 13048, "90deg"  => 15687,
                            "`abdu'l"
                                     => 19165, "a.f.c"  => 13926,
                            "a.k.a"  => 7692, "a.m."   => 4541, aachen   => 10481, aagpbl   => 25124,
                            aalborg  => 16237, aaliyah  => 22028, aalto    => 21242, aamir    => 22159,
                            aargau   => 22604, aarhus   => 11839, aarti    => 29226, ababa    => 13273,
                            abacetus => 22131, abalone  => 26038, abandoned
                                     => 1551,
                            abandonment
                                     => 8323, abandons => 15495,
                            abatement
                                     => 26763, abbas    => 6934,
                            abbasabad
                                     => 25417, abbasi   => 23023,
                            abbasid  => 12618, abbasids => 25392, abbess   => 13610, abbeville
                                     => 18065,
                            abbeys   => 19325, abbot    => 4936, abbots   => 14744, abbotsford
                                     => 17283,
                            abbottabad
                                     => 24011, abbreviated
                                     => 4242,
                            abbreviation
                                     => 7508, abbreviations
                                     => 13817,
                            abdel    => 10876, abdicate => 19108, abdicated
                                     => 14762,
                            abdication
                                     => 13364, abdomen  => 7236,
                            abdomina => 19976, abdulaziz
                                     => 15708,
                            abdullahi
                                     => 27474, abdur    => 19253,
                            abdus    => 27267, abelian  => 12020, abellio  => 24464, abenaki  => 23311,
                            abercorn => 29932, abercromby
                                     => 28732,
                            aberdare => 17389, aberdeen => 4366, aberdeenshire
                                     => 13063,
                            abergavenny
                                     => 22589, aberrations
                                     => 24733,
                            aberystwyth
                                     => 14356, abeyance => 22695,
                            abhay    => 28039, abhishek => 22674, abidjan  => 20087, abies    => 23403,
                            abilene  => 14410, abilities
                                     => 3037,
                            ability  => 1061, abingdon => 13340, abington => 21391, abitibi  => 29561,
                            abitur   => 22742, abkhaz   => 19804, abkhazia => 11251, abkhazian
                                     => 26151,
                            ablation => 20608, ablaze   => 20086, abnormalities
                                     => 10417,
                            abode    => 12775, abolish  => 10505, abolished
                                     => 3215,
                            abolishing
                                     => 14674, abolishment
                                     => 26626,
                            abolition
                                     => 5673, abolitionist
                                     => 10545,
                            abolitionists
                                     => 18565, aboriginal
                                     => 3727,
                            aboriginals
                                     => 20934, aborigines
                                     => 11146,
                            abortions
                                     => 12172, abortive => 14862,
                            "about.com"
                                     => 18276, above    => 492,
                            abrahamic
                                     => 23889, abramoff => 20748,
                            abrasion => 22613, abrasive => 15054, abridged => 14544, abroad   => 2347,
                            abrogated
                                     => 26821, abruptly => 7494,
                            abruzzo  => 17300, absalom  => 27888, abscess  => 22170, absence  => 2442,
                            absent   => 4273, absentia => 16753, absinthe => 25265, absolutism
                                     => 26161,
                            absolutist
                                     => 28736, absorbed => 3764,
                            absorber => 22977, absorbers
                                     => 21836,
                            absorbing
                                     => 9339, absorbs  => 14318,
                            absorption
                                     => 6163, abstained
                                     => 18581,
                            abstaining
                                     => 27515, abstention
                                     => 25932,
                            abstentions
                                     => 27317, abstract => 3943,
                            abstracted
                                     => 12287, abstracting
                                     => 14045,
                            abstraction
                                     => 8964, abstractions
                                     => 21454,
                            abstracts
                                     => 13844, absurdist
                                     => 29626,
                            abteilung
                                     => 28562, "abu'l"  => 21660,
                            abubakar => 22957, abuja    => 17882, abundance
                                     => 5856,
                            abundances
                                     => 29920, abundant => 4920,
                            abuse    => 2566, abusers  => 26711, abuses   => 7716, abutment => 28573,
                            abutments
                                     => 20725, abuts    => 26489,
                            abutting => 26358, abwehr   => 22985, abyss    => 10550, abyssinia
                                     => 21113,
                            abyssinian
                                     => 22998, "ac/dc"  => 13961,
                            acacia   => 10380, academia => 6586, academic => 880, academica
                                     => 23534,
                            academical
                                     => 18372, academically
                                     => 10124,
                            academician
                                     => 13599, academicians
                                     => 23646,
                            academics
                                     => 4221, academie => 8364,
                            academies
                                     => 7617, academy  => 483,
                            acadia   => 13277, acadian  => 13878, acadians => 15953, accademia
                                     => 12561,
                            accede   => 26654, acceded  => 17153, accelerate
                                     => 8951,
                            accelerated
                                     => 6160, accelerates
                                     => 20751,
                            accelerating
                                     => 11707, acceleration
                                     => 6304,
                            accelerator
                                     => 10471, accelerators
                                     => 19395,
                            accented => 17336, accentuated
                                     => 21878,
                            accenture
                                     => 28848, acceptability
                                     => 28809,
                            acceptance
                                     => 4037, accepted => 1124,
                            acceptor => 15485, accepts  => 5129, access   => 671, accessed => 4693,
                            accesses => 19772, accessibility
                                     => 8482,
                            accessible
                                     => 2768, accessing
                                     => 10951,
                            accession
                                     => 6203, accessories
                                     => 6380,
                            accion   => 28855, acclaim  => 3877, acclaimed
                                     => 3524,
                            acclamation
                                     => 20123, accolade => 14540,
                            accolades
                                     => 7071, accommodate
                                     => 3281,
                            accommodated
                                     => 10381, accommodates
                                     => 14183,
                            accommodation
                                     => 4257, accompanied
                                     => 1945,
                            accompanies
                                     => 10631, accompaniment
                                     => 8509,
                            accompanist
                                     => 17773, accompany
                                     => 5595,
                            accompanying
                                     => 4346, accomplishments
                                     => 5932,
                            accord   => 6786, accordance
                                     => 3960,
                            accorded => 10458, according
                                     => 217,
                            accordingly
                                     => 4583, accordion
                                     => 9840,
                            accordionist
                                     => 29942, accords  => 11799,
                            account  => 1177, accountability
                                     => 6643,
                            accountancy
                                     => 13876, accounted
                                     => 5702,
                            accounting
                                     => 3632, accounts => 2085,
                            accra    => 12046, accreditation
                                     => 4924,
                            accredited
                                     => 3992, accrediting
                                     => 16144,
                            accretion
                                     => 19163, accrington
                                     => 14804,
                            accrue   => 23993, accrued  => 17520, accumulate
                                     => 9944,
                            accumulated
                                     => 5937, accumulates
                                     => 18445,
                            accumulating
                                     => 12747, accumulation
                                     => 7674,
                            accumulations
                                     => 25513, accumulator
                                     => 22597,
                            accuracy => 4015, accurate => 3196, accurately
                                     => 5668,
                            accusative
                                     => 17752, accused  => 1879,
                            acetate  => 11380, acetic   => 17003, acetone  => 22384, acetyl   => 17943,
                            acetylcholine
                                     => 17328, acetylene
                                     => 23882,
                            achaea   => 19251, achaemenid
                                     => 17728,
                            acharya  => 13134, achievable
                                     => 19194,
                            achieve  => 2088, achieved => 1311, achievement
                                     => 2365,
                            achievements
                                     => 3191, achievers
                                     => 29422,
                            achieves => 11504, achieving
                                     => 4068,
                            acid     => 1860, acidic   => 9013, acidification
                                     => 27395,
                            acidity  => 15237, acids    => 4805, acknowledged
                                     => 3709,
                            acknowledgement
                                     => 14388,
                            acknowledges
                                     => 10133, acknowledging
                                     => 10084,
                            acknowledgment
                                     => 17177,
                            acland   => 20307, acleris  => 29343, acolytes => 26952, acorn    => 11663,
                            acorns   => 21674, acoustic => 3132, acoustical
                                     => 21345,
                            acoustically
                                     => 25336, acoustics
                                     => 11992,
                            acquiesced
                                     => 27448, acquire  => 3867,
                            acquired => 942, acquires => 12426, acquiring
                                     => 5330,
                            acquisition
                                     => 2690, acquisitions
                                     => 6807,
                            acquitted
                                     => 6928, acraea   => 25277,
                            acre     => 4239, acreage  => 17010, acres    => 2722, acrimonious
                                     => 21001,
                            acrobatic
                                     => 15578, acrobatics
                                     => 22153,
                            acrocercops
                                     => 25056, acronym  => 6832,
                            acronyms => 25595, acropolis
                                     => 13984,
                            across   => 425, acrylic  => 13040, act      => 306, action   => 495,
                            actions  => 1442, activated
                                     => 3817,
                            activates
                                     => 11407, activating
                                     => 12464,
                            activation
                                     => 5274, active   => 581,
                            actively => 3158, activision
                                     => 16611,
                            activism => 5406, activist => 2919, activists
                                     => 3717,
                            activities
                                     => 635, activity => 1040,
                            actor    => 798, actors   => 1919, actress  => 1137, actresses
                                     => 7404,
                            acts     => 1305, actual   => 1677, actuaries
                                     => 29609,
                            actuated => 21928, actuator => 22808, actuators
                                     => 21267,
                            acuity   => 21620, acumen   => 19072, acura    => 21603, acute    => 4570,
                            acutely  => 21642, acyclic  => 27683, adagio   => 22328, adalbert => 16707,
                            adamantly
                                     => 28300, adana    => 14085,
                            adapt    => 6333, adaptability
                                     => 24994,
                            adaptable
                                     => 16699, adaptation
                                     => 2355,
                            adaptations
                                     => 5112, adapted  => 2072,
                            adapter  => 11705, adapters => 18877, adapting => 9439, adaption => 13710,
                            adaptive => 7242, adaptor  => 24632, adapts   => 20006, adare    => 29922,
                            adarsh   => 24301, added    => 514, adder    => 21364, adding   => 2111,
                            addition => 383, additional
                                     => 675,
                            additionally
                                     => 1797, additions
                                     => 5023,
                            additive => 9966, additives
                                     => 13766,
                            addressed
                                     => 3331, addresses
                                     => 4500,
                            addressing
                                     => 5381, adds     => 4391,
                            adelphi  => 17846, adenauer => 22645, adenine  => 25770, adenosine
                                     => 18600,
                            adept    => 11399, adequacy => 25002, adequate => 4582, adequately
                                     => 9058,
                            adhere   => 9140, adhered  => 12627, adherence
                                     => 10275,
                            adherent => 18908, adherents
                                     => 8736,
                            adheres  => 16655, adhering => 15444, adhesion => 11561, adhesives
                                     => 22533,
                            adiabatic
                                     => 22517, adidas   => 13308,
                            adipose  => 21263, adirondack
                                     => 14061,
                            aditi    => 29275, aditya   => 14781, adiyaman => 26435, adjacent => 1736,
                            adjectival
                                     => 25640, adjective
                                     => 9039,
                            adjectives
                                     => 10827, adjoined => 24558,
                            adjoining
                                     => 5480, adjoins  => 17301,
                            adjoint  => 17314, adjudged => 20767, adjudicated
                                     => 27389,
                            adjudication
                                     => 22157, adjunct  => 7854,
                            adjustable
                                     => 9824, adjusted => 5386,
                            adjusts  => 22958, adjutant => 7982, administered
                                     => 3042,
                            administering
                                     => 10379, administers
                                     => 10185,
                            administracion
                                     => 23412,
                            administrated
                                     => 19448, administration
                                     => 693,
                            administrations
                                     => 9720,
                            administrative
                                     => 805, administratively
                                     => 8032,
                            administrator
                                     => 3561, administrators
                                     => 5745,
                            admiral  => 2129, admirals => 11981, admiralty
                                     => 5502,
                            admission
                                     => 3665, admissions
                                     => 6795,
                            admits   => 5549, admitted => 1928, admixture
                                     => 21045,
                            adnan    => 14884, adobe    => 6882, adolescents
                                     => 9830,
                            adolf    => 4760, adolphe  => 12967, adolphus => 14542, adonis   => 16540,
                            adoor    => 27110, adopted  => 1107, adopting => 6142, adopts   => 10897,
                            adorn    => 18200, adorned  => 8913, adrenergic
                                     => 22001,
                            adriaan  => 24280, adriano  => 16489, adrianople
                                     => 21867,
                            adriatic => 8612, adsorption
                                     => 19084,
                            adult    => 1418, adulterous
                                     => 26734,
                            adulthood
                                     => 7822, adults   => 2078,
                            advaita  => 19069, advance  => 1661, advanced => 1041, advancement
                                     => 5055,
                            advancements
                                     => 13759, advances => 4385,
                            advancing
                                     => 4331, advantageous
                                     => 11388,
                            advantages
                                     => 4427, advent   => 5054,
                            adventist
                                     => 8694, adventists
                                     => 17440,
                            adventurer
                                     => 11306, adventurers
                                     => 13929,
                            adventures
                                     => 2895, adverb   => 28797,
                            adverbs  => 22142, adversarial
                                     => 24864,
                            adverse  => 5622, adversely
                                     => 12653,
                            advert   => 13464, advertised
                                     => 6681,
                            advertisement
                                     => 5896, advertisements
                                     => 5315,
                            advertiser
                                     => 10673, advertisers
                                     => 11444,
                            advertising
                                     => 2108, adverts  => 15449,
                            advised  => 3953, adviser  => 4687, advisers => 8889, advises  => 9249,
                            advisor  => 3371, advisories
                                     => 17766,
                            advisors => 7201, advisory => 2612, advocacy => 4396, advocate => 3041,
                            advocated
                                     => 4383, advocates
                                     => 4787,
                            advocating
                                     => 7648, aechmea  => 22784,
                            aegean   => 9476, aegis    => 11793, aegon    => 22301, aeneas   => 16449,
                            aeneid   => 23398, aeolian  => 20663, aerial   => 3506, aerials  => 26790,
                            aerobatic
                                     => 17393, aerobatics
                                     => 25036,
                            aerobic  => 13889, aerodrome
                                     => 7919,
                            aerodynamic
                                     => 9714, aerodynamics
                                     => 14778,
                            aeroflot => 23521, aeronautica
                                     => 20744,
                            aeronautical
                                     => 9176, aeronautics
                                     => 9832,
                            aeronautique
                                     => 26533, aeroplane
                                     => 12523,
                            aeroplanes
                                     => 20753, aeros    => 22791,
                            aerosmith
                                     => 14240, aerosols => 26340,
                            aerospace
                                     => 5307, aeschylus
                                     => 23540,
                            aesop    => 19033, aesthetic
                                     => 5000,
                            aesthetically
                                     => 14919, aesthetics
                                     => 7923,
                            aethelred
                                     => 22021, aethelstan
                                     => 28532,
                            aether   => 20785, affairs  => 1059, affected => 1837, affecting
                                     => 5032,
                            affectionately
                                     => 11832,
                            affective
                                     => 15395, afferent => 27101,
                            affiliate
                                     => 3061, affiliated
                                     => 2287,
                            affiliates
                                     => 6259, affiliation
                                     => 4591,
                            affiliations
                                     => 8085, affine   => 12460,
                            affinis  => 24291, affinities
                                     => 16933,
                            affinity => 6772, affirmation
                                     => 15300,
                            affirmed => 7834, affirming
                                     => 14757,
                            affirms  => 18465, affix    => 28338, affixed  => 14274, affixes  => 23073,
                            afflicted
                                     => 11638, affluence
                                     => 24054,
                            affluent => 8158, affordability
                                     => 21463,
                            affordable
                                     => 5841, afforded => 9373,
                            affording
                                     => 23056, affords  => 15966,
                            afghan   => 4666, afghanistan
                                     => 2339,
                            afghans  => 14903, aficionados
                                     => 24194,
                            afield   => 14534, afire    => 29101, afonso   => 11732, aforementioned
                                     => 6624,
                            aforesaid
                                     => 24560, afoul    => 27057,
                            africa   => 572, african  => 539, africana => 20783, africans => 6850,
                            africanus
                                     => 20718, afridi   => 27658,
                            afrika   => 16151, afrikaans
                                     => 10629,
                            afrikaner
                                     => 19081, aftab    => 22420,
                            after    => 30, aftermarket
                                     => 18132,
                            aftermath
                                     => 2729, aftershocks
                                     => 25371,
                            afterward
                                     => 4681, afterwards
                                     => 1905,
                            afterword
                                     => 25657, afzal    => 24536,
                            against  => 101, agaricus => 27944, agassi   => 22003, agassiz  => 19363,
                            agate    => 21154, agave    => 21753, agder    => 18526, age      => 140,
                            aged     => 1592, ageing   => 11506, agence   => 23555, agencies => 2235,
                            agency   => 1078, agents   => 2271, ages     => 1834, aggie    => 18678,
                            aggies   => 10815, agglomeration
                                     => 15196,
                            aggregate
                                     => 3433, aggregated
                                     => 16269,
                            aggregates
                                     => 14287, aggregating
                                     => 23224,
                            aggregation
                                     => 11084, aggregations
                                     => 29474,
                            aggregator
                                     => 11284, aggression
                                     => 6496,
                            aggressively
                                     => 9984, aggressiveness
                                     => 22405,
                            aggrieved
                                     => 28388, agile    => 11491,
                            agility  => 11980, agincourt
                                     => 22763,
                            aging    => 5108, agios    => 17868, agitation
                                     => 10242,
                            agnieszka
                                     => 22776, agnostic => 11898,
                            agong    => 26347, agonist  => 13207, agonists => 19185, agora    => 20172,
                            agrarian => 8305, agreement
                                     => 1022,
                            agreements
                                     => 3908, agrees   => 4014,
                            agribusiness
                                     => 20647, agricola => 19063,
                            agricultural
                                     => 1436, agriculture
                                     => 1594,
                            agrippa  => 17745, agrippina
                                     => 26050,
                            agronomy => 25760, aground  => 10224, aguascalientes
                                     => 23053,
                            agung    => 27854, agusta   => 29778, aharon   => 21191, ahmadabad
                                     => 18783,
                            ahmadinejad
                                     => 15439, ahmadiyya
                                     => 16465,
                            ahmedabad
                                     => 10148, ahmednagar
                                     => 23409,
                            ahmet    => 14147, ahvaz    => 24686, aichi    => 12446, aicte    => 22190,
                            aided    => 4306, aiden    => 21571, aikido   => 15715, ailerons => 16115,
                            ailing   => 12441, ailments => 14242, ailsa    => 28297, aimed    => 2530,
                            aiming   => 6727, aims     => 3022, aintree  => 22836, air      => 208,
                            airasia  => 29194, airbase  => 13296, airborne => 4225, airbus   => 8134,
                            aircraft => 468, aircrew  => 13570, aircrews => 19437, airdate  => 14438,
                            airdrie  => 17528, aired    => 1383, aires    => 3457, airfield => 3417,
                            airfields
                                     => 8609, airflow  => 14083,
                            airfoil  => 18794, airframe => 12121, airframes
                                     => 21254,
                            airing   => 3720, airings  => 23443, airlift  => 8100, airline  => 2912,
                            airliner => 12404, airliners
                                     => 16556,
                            airlines => 2494, airmail  => 25954, airmen   => 9863, airplay  => 5436,
                            airport  => 610, airports => 4634, airs     => 5226, airship  => 10493,
                            airships => 16782, airshow  => 20138, airspeed => 16776, airstrike
                                     => 21535,
                            airstrikes
                                     => 15779, airtel   => 22675,
                            airtime  => 18102, airways  => 4841, airworthiness
                                     => 28840,
                            aishwarya
                                     => 24153, aisles   => 10776,
                            aisne    => 14467, ajaccio  => 22994, ajith    => 24745, ajmer    => 18796,
                            akademi  => 13083, akademie => 18990, akali    => 25968, akash    => 24058,
                            akb48    => 22592, akbar    => 7804, akershus => 19714, akhenaten
                                     => 21307,
                            akhtar   => 14489, akira    => 10220, akita    => 15319, akiva    => 21207,
                            akkadian => 15736, akram    => 20170, akron    => 8250, akshay   => 21223,
                            akuma    => 28908, alabama  => 1806, alain    => 7552, alamein  => 18848,
                            alamos   => 13405, aland    => 9311, alania   => 27104, alanine  => 25443,
                            alappuzha
                                     => 23872, alaric   => 21770,
                            alasdair => 20761, alaska   => 2583, alaskan  => 10968, alastair => 14825,
                            alauddin => 27224, alava    => 20317, albacete => 21693, albania  => 3991,
                            albanian => 3884, albanians
                                     => 10433,
                            albans   => 9440, albany   => 3904, albarn   => 22469, albatros => 17508,
                            albatrosses
                                     => 28536, albedo   => 16406,
                            albeit   => 4889, albemarle
                                     => 13845,
                            albertus => 28617, albertville
                                     => 25418,
                            albini   => 24584, albion   => 4997, alborz   => 22591, album    => 97,
                            albumin  => 25237, albums   => 902, albuquerque
                                     => 7638,
                            alcalde  => 17803, alcatel  => 26647, alchemical
                                     => 23773,
                            alchemist
                                     => 14935, alchemy  => 12432,
                            alcibiades
                                     => 25481, alcoa    => 19860,
                            alcoholism
                                     => 9030, alcohols => 16093,
                            aldeburgh
                                     => 24703, aldehyde => 18326,
                            aldehydes
                                     => 23891, aldermen => 12948,
                            alderney => 22402, aldershot
                                     => 11073,
                            aldrin   => 29324, aldwych  => 28734, alegre   => 12905, aleister => 26900,
                            alekhine => 24355, aleksandar
                                     => 13310,
                            aleksander
                                     => 13814, aleksandr
                                     => 8407,
                            aleksandra
                                     => 20829, aleksandrovich
                                     => 18745,
                            aleksei  => 15909, aleksey  => 19575, alentejo => 28579, aleph    => 26210,
                            aleppo   => 8771, alerts   => 12794, alesi    => 22234, alessandria
                                     => 20596,
                            alessandro
                                     => 8068, alesund  => 23280,
                            aleut    => 27180, aleutian => 15111, alexandr => 29337, alexandre
                                     => 7167,
                            alexandrian
                                     => 19037, alexandrov
                                     => 28023,
                            alexandrovich
                                     => 22489, alexandru
                                     => 12431,
                            alexei   => 10507, alexey   => 15742, alexios  => 14967, alexius  => 28151,
                            alfie    => 15207, alfons   => 24104, alfreton => 25907, algae    => 7009,
                            algal    => 18774, algarve  => 16375, algebra  => 4231, algebraic
                                     => 6414,
                            algebraically
                                     => 26068, algebras => 10895,
                            algeciras
                                     => 22325, algeria  => 4433,
                            algerian => 6457, algernon => 17912, algiers  => 8673, algol    => 18322,
                            algoma   => 21625, algonquian
                                     => 16362,
                            algonquin
                                     => 14432, algorithm
                                     => 3477,
                            algorithmic
                                     => 18412, algorithms
                                     => 5219,
                            alhaji   => 26918, alhambra => 15861, aliabad  => 14958, alianza  => 17123,
                            aliasing => 25727, alicante => 15570, alienation
                                     => 12090,
                            aligarh  => 16680, alighieri
                                     => 28488,
                            align    => 6025, aligned  => 5250, aligning => 17591, alignment
                                     => 4421,
                            alignments
                                     => 16619, aligns   => 26442,
                            alito    => 25408, aliyah   => 14276, aliyev   => 19202, alkali   => 12536,
                            alkaline => 10851, alkaloid => 21184, alkaloids
                                     => 17014,
                            alkene   => 25321, alkenes  => 25319, alkmaar  => 22501, alkyl    => 16806,
                            allahabad
                                     => 10812, allama   => 26437,
                            allegany => 19701, allegation
                                     => 11520,
                            allegations
                                     => 3613, allege   => 17761,
                            alleged  => 2303, allegedly
                                     => 3397,
                            alleges  => 14758, allegheny
                                     => 7271,
                            allegiance
                                     => 6023, alleging => 8546,
                            allegorical
                                     => 12250, allegories
                                     => 27269,
                            allegory => 12395, allegro  => 14847, allele   => 12675, alleles  => 14437,
                            allendale
                                     => 27662, allentown
                                     => 12245,
                            allerton => 22993, alleviate
                                     => 9467,
                            alleviated
                                     => 24095, alleviating
                                     => 25076,
                            alleviation
                                     => 24223, alleyn   => 29269,
                            allgemeine
                                     => 19315, alliance => 1394,
                            alliances
                                     => 7859, allianz  => 22316,
                            allied   => 1895, allier   => 24569, allies   => 2363, allium   => 17544,
                            allmusic => 4106, alloa    => 20475, allocate => 13801, allocated
                                     => 4181,
                            allocates
                                     => 28234, allocating
                                     => 18777,
                            allocation
                                     => 6127, allocations
                                     => 16943,
                            allosteric
                                     => 26742, allotment
                                     => 13883,
                            allotments
                                     => 16846, allotted => 9246,
                            allow    => 932, allowable
                                     => 17901,
                            allowed  => 645, allowing => 1349, allows   => 1222, alloy    => 6690,
                            alloys   => 9866, allround => 22778, allstars => 27921, allsvenskan
                                     => 13087,
                            allude   => 21410, alluded  => 13171, alludes  => 12726, alluding => 15840,
                            allusion => 12045, allusions
                                     => 12311,
                            alluvial => 11384, alluvium => 26196, allying  => 26642, almagro  => 20789,
                            almanac  => 12638, almanack => 25879, almaty   => 16371, almeria  => 15388,
                            almirante
                                     => 24359, almshouses
                                     => 21421,
                            alnwick  => 24169, aloft    => 16890, alois    => 16302, along    => 180,
                            alongside
                                     => 1164, alouettes
                                     => 13467,
                            aloysius => 15200, alpes    => 11445, alphabet => 4638, alphabetic
                                     => 19911,
                            alphabetical
                                     => 9223, alphabetically
                                     => 12139,
                            alphabets
                                     => 15910, alphanumeric
                                     => 23769,
                            alpina   => 25509, alpine   => 3737, alpini   => 29834, alps     => 5069,
                            alsace   => 8647, alsatian => 23586, also     => 22, alstom   => 18463,
                            altai    => 15235, altair   => 20194, altamont => 26566, altan    => 29116,
                            altarpiece
                                     => 11349, altarpieces
                                     => 22559,
                            altars   => 12204, alter    => 4772, alteration
                                     => 9468,
                            alterations
                                     => 6680, altered  => 3507,
                            alternate
                                     => 2697, alternated
                                     => 12318,
                            alternately
                                     => 9087, alternates
                                     => 14197,
                            alternating
                                     => 5991, alternation
                                     => 18718,
                            alternative
                                     => 1258, alternatively
                                     => 5004,
                            alternatives
                                     => 5969, although => 185,
                            altimeter
                                     => 29611, altitude => 2902,
                            altitudes
                                     => 7994, alto     => 5546,
                            altona   => 16940, altoona  => 17460, altos    => 18144, altrincham
                                     => 16878,
                            alumina  => 21819, aluminium
                                     => 5457,
                            aluminum => 5246, alumna   => 21959, alumnae  => 21817, alumni   => 2944,
                            alumnus  => 7392, alvar    => 21336, alveolar => 13638, alzheimer
                                     => 8391,
                            amadeus  => 10811, amadou   => 26697, amalfi   => 25639, amalgam  => 15965,
                            amalgamate
                                     => 26725, amalgamated
                                     => 6562,
                            amalgamation
                                     => 7794, amalie   => 19771,
                            amami    => 26493, amanita  => 22740, amarillo => 12832, amarna   => 18895,
                            amass    => 22867, amassed  => 8126, amassing => 15513, amasya   => 23498,
                            amata    => 27038, amateur  => 1694, amateurliga
                                     => 27825,
                            amazon   => 4840, "amazon.com"
                                     => 11693,
                            amazonas => 16737, amazonia => 29957, amazonian
                                     => 18775,
                            amazons  => 16651, ambala   => 27625, ambassador
                                     => 2168,
                            ambassadors
                                     => 7249, ambedkar => 18277,
                            ambient  => 6835, ambiguities
                                     => 24620,
                            ambiguity
                                     => 9726, ambiguous
                                     => 7561,
                            ambika   => 29791, ambitions
                                     => 7718,
                            ambivalent
                                     => 17240, ambon    => 23026,
                            amboy    => 18657, ambroise => 27956, ambulatory
                                     => 18725,
                            ambushes => 19050, amedeo   => 23137, ameer    => 27633, amelie   => 19101,
                            amend    => 10028, amended  => 5266, amending => 16167, amendment
                                     => 2581,
                            amendments
                                     => 6021, amenhotep
                                     => 21950,
                            amenities
                                     => 6211, amenity  => 22596,
                            america  => 343, american => 76, americana
                                     => 10056,
                            americanism
                                     => 29624, americans
                                     => 1419,
                            americas => 4027, amerika  => 26330, amerindian
                                     => 17754,
                            amerindians
                                     => 27080, amersfoort
                                     => 28652,
                            amersham => 29480, amesbury => 29082, amethyst => 22382, amhara   => 20607,
                            amharic  => 19709, amherst  => 7444, amicably => 21344, amicus   => 17957,
                            amide    => 21831, amidships
                                     => 17251,
                            amidst   => 7666, amiens   => 11662, amiga    => 8696, amigaos  => 27822,
                            amine    => 14444, amines   => 19650, amino    => 5170, amirabad => 24595,
                            amitabh  => 17671, amity    => 17388, amjad    => 25893, amman    => 9784,
                            ammonia  => 9284, ammonian => 28391, ammonite => 26075, ammonites
                                     => 28220,
                            ammonium => 12108, ammunition
                                     => 3584,
                            amnesty  => 6045, among    => 228, amongst  => 1995, amorphous
                                     => 14769,
                            amory    => 23159, amount   => 1049, amounted => 7247, amounting
                                     => 11360,
                            amounts  => 2995, ampere   => 24821, amphetamine
                                     => 18612,
                            amphibian
                                     => 14119, amphibians
                                     => 9891,
                            amphibious
                                     => 5903, amphitheater
                                     => 12241,
                            amphitheatre
                                     => 11922, amphoe   => 16184,
                            amplification
                                     => 11780, amplified
                                     => 11854,
                            amplifier
                                     => 8273, amplifiers
                                     => 9649,
                            amplify  => 18459, amplifying
                                     => 28513,
                            amplitude
                                     => 8501, amplitudes
                                     => 22807,
                            amputated
                                     => 16924, amputee  => 28701,
                            amrita   => 22439, amritsar => 14449, amstel   => 22441, amsterdam
                                     => 2935,
                            amstrad  => 20001, amtrak   => 6776, amuro    => 23821, amusements
                                     => 24991,
                            amygdala => 19743, amyloid  => 19807, an       => 16, "an/fps" => 19006,
                            anabaptist
                                     => 28115, anabolic => 20964,
                            anachronistic
                                     => 22126, anaconda => 18238,
                            anacostia
                                     => 19062, anaerobic
                                     => 13419,
                            anaesthesia
                                     => 23049, anaheim  => 7523,
                            anais    => 29618, anakin   => 27254, analgesic
                                     => 18458,
                            analog   => 4111, analogies
                                     => 21838,
                            analogous
                                     => 6999, analogs  => 21107,
                            analogue => 7645, analogues
                                     => 17342,
                            analyse  => 15374, analysed => 11914, analyses => 6341, analysing
                                     => 17144,
                            analysis => 1079, analyst  => 5336, analysts => 6898, analyte  => 27347,
                            analytic => 8568, analytical
                                     => 7118,
                            analytically
                                     => 28500, analytics
                                     => 10035,
                            analyzed => 6608, analyzer => 18530, analyzes => 14156, anambra  => 28969,
                            anamorphic
                                     => 22851, anand    => 8124,
                            ananda   => 13548, anant    => 28534, anarchic => 27828, anarchism
                                     => 10892,
                            anarchist
                                     => 6425, anarchists
                                     => 10666,
                            anarcho  => 14162, anastasius
                                     => 25898,
                            anathema => 24851, anatole  => 22567, anatoli  => 25743, anatolia => 8283,
                            anatolian
                                     => 13792, anatoly  => 13843,
                            anatomic => 29113, anatomical
                                     => 9928,
                            anatomist
                                     => 20702, anatomy  => 5233,
                            anbar    => 19187, ancaster => 29616, ancestor => 5041, ancestors
                                     => 4373,
                            ancestral
                                     => 5782, ancestry => 4052,
                            anchor   => 3418, anchorage
                                     => 7943,
                            anchored => 5868, anchoring
                                     => 14041,
                            anchors  => 9067, ancien   => 20743, ancient  => 821, ancients => 15842,
                            ancillary
                                     => 13345, and      => 3,
                            "and/or" => 2375, andalucia
                                     => 22739,
                            andalus  => 18353, andalusia
                                     => 10923,
                            andalusian
                                     => 15406, andaman  => 13757,
                            andante  => 27619, andean   => 11211, anderlecht
                                     => 15771,
                            andersson
                                     => 11390, andesite => 25287,
                            andhra   => 5131, andorra  => 11294, andover  => 10332, andrei   => 7642,
                            andrej   => 23109, andretti => 13162, andreu   => 29390, andrey   => 11431,
                            andriy   => 20896, androgen => 20032, androgynous
                                     => 23742,
                            android  => 5167, androids => 24207, andromeda
                                     => 14114,
                            andromedae
                                     => 28839, andronicus
                                     => 28937,
                            andronikos
                                     => 18822, andrzej  => 12082,
                            anecdotal
                                     => 15903, anecdotes
                                     => 12072,
                            anemone  => 16864, anemones => 27708, anfield  => 15233, angara   => 29339,
                            angeles  => 706, angelis  => 26051, angelou  => 17178, angered  => 7713,
                            angering => 24496, angevin  => 22496, angiogenesis
                                     => 22296,
                            angiosperms
                                     => 29870, angiotensin
                                     => 25734,
                            angkor   => 18418, anglais  => 29478, angled   => 11428, angler   => 22653,
                            anglers  => 15416, angles   => 5361, anglesey => 12844, anglia   => 8684,
                            anglian  => 14836, anglican => 3422, anglicanism
                                     => 21188,
                            anglicans
                                     => 16259, anglicised
                                     => 16873,
                            anglicized
                                     => 16936, anglo    => 2653,
                            anglophone
                                     => 16551, angola   => 5169,
                            angolan  => 11978, angouleme
                                     => 20207,
                            angra    => 20821, angrily  => 10099, anguilla => 17259, angular  => 6638,
                            anhalt   => 9040, anheuser => 21395, anhui    => 13006, anhydride
                                     => 26089,
                            anhydrous
                                     => 23700, aniline  => 29314,
                            animal   => 1414, animals  => 1279, animas   => 29644, animate  => 16521,
                            animated => 2399, animating
                                     => 27361,
                            animation
                                     => 2769, animations
                                     => 11416,
                            animator => 9949, animators
                                     => 13784,
                            animatronic
                                     => 27640, animax   => 28804,
                            anime    => 3017, anion    => 14707, anions   => 20589, anisotropic
                                     => 26327,
                            anisotropy
                                     => 25365, aniston  => 26785,
                            anjali   => 17638, anjou    => 11670, ankara   => 7997, annales  => 18319,
                            annals   => 7265, annam    => 29970, annan    => 12607, annandale
                                     => 18916,
                            annapolis
                                     => 8709, annapurna
                                     => 25357,
                            annealing
                                     => 24889, annecy   => 24256,
                            annenberg
                                     => 21488, annesley => 25433,
                            annex    => 7000, annexation
                                     => 6833,
                            annexe   => 26129, annexed  => 4824, annexes  => 28232, annexing => 21802,
                            annihilated
                                     => 15418, annihilation
                                     => 12743,
                            anniston => 29767, anniversary
                                     => 1788,
                            annotated
                                     => 12925, annotation
                                     => 19040,
                            annotations
                                     => 16116, announced
                                     => 362,
                            announcements
                                     => 9456, announcer
                                     => 5967,
                            announcers
                                     => 13425, announces
                                     => 7999,
                            announcing
                                     => 5754, annual   => 648,
                            annually => 2102, annuals  => 20202, annuities
                                     => 23914,
                            annuity  => 14833, annular  => 17640, annulus  => 27452, annum    => 10070,
                            annunciation
                                     => 14140, anode    => 14189,
                            anointing
                                     => 24274, anomalies
                                     => 12522,
                            anomalous
                                     => 16141, anorthosis
                                     => 24516,
                            another  => 177, ansar    => 16309, ansbach  => 21621, anschluss
                                     => 20950,
                            anselm   => 14049, ansett   => 25144, ansgar   => 28596, anstruther
                                     => 29178,
                            answerable
                                     => 27303, antagonism
                                     => 17688,
                            antagonist
                                     => 7108, antagonists
                                     => 11097,
                            antalya  => 14780, antananarivo
                                     => 23219,
                            antarctic
                                     => 3872, antarctica
                                     => 5095,
                            antebellum
                                     => 15017, antecedent
                                     => 18026,
                            antecedents
                                     => 18005, antelope => 10512,
                            antena   => 29294, antenna  => 5077, antennae => 11164, antennas => 9447,
                            anterior => 5859, anteriorly
                                     => 18638,
                            anthem   => 4623, anthemic => 27977, anthems  => 13788, anthers  => 22204,
                            anthologies
                                     => 8624, anthologized
                                     => 25906,
                            anthology
                                     => 4132, anthracite
                                     => 19606,
                            anthropogenic
                                     => 18684, anthropological
                                     => 10571,
                            anthropologist
                                     => 8451, anthropologists
                                     => 12474,
                            anthropology
                                     => 5110, anthropomorphic
                                     => 12891,
                            anti     => 722, antiaircraft
                                     => 17089,
                            antibacterial
                                     => 22558, antibody => 9953,
                            antic    => 25467, anticipated
                                     => 5091,
                            anticipates
                                     => 23671, antidepressant
                                     => 19677,
                            antietam => 18194, antifungal
                                     => 27980,
                            antigen  => 10123, antigens => 14620, antigone => 23198, antigonus
                                     => 22351,
                            antigua  => 9517, antilles => 9636, antimatter
                                     => 22408,
                            antimicrobial
                                     => 16519, antimony => 19070,
                            antioch  => 7311, antiochus
                                     => 14921,
                            antioquia
                                     => 18580, antioxidant
                                     => 19649,
                            antioxidants
                                     => 26605, antipathy
                                     => 23505,
                            antipope => 25316, antipsychotic
                                     => 26429,
                            antipsychotics
                                     => 29242,
                            antiquarian
                                     => 11268, antiquaries
                                     => 18166,
                            antiquary
                                     => 19066, antiquities
                                     => 8411,
                            antiquity
                                     => 6003, antiretroviral
                                     => 28538,
                            antisemitic
                                     => 12444, antisemitism
                                     => 10779,
                            antisubmarine
                                     => 14283, antitank => 26436,
                            antithesis
                                     => 21111, antitrust
                                     => 11917,
                            antiviral
                                     => 21377, antivirus
                                     => 21892,
                            antiwar  => 26501, antofagasta
                                     => 25654,
                            antonescu
                                     => 19661, antoni   => 13498,
                            antonin  => 13525, antonine => 29090, antonino => 29978, antoninus
                                     => 24572,
                            antonis  => 27967, antonius => 18940, antonov  => 17360, antrim   => 8631,
                            antti    => 25189, antwerp  => 5650, anupam   => 28208, anuradhapura
                                     => 20078,
                            anyang   => 23852, anzac    => 10285, anzio    => 23817, aomori   => 17946,
                            aortic   => 14802, aosta    => 18899, aotearoa => 23953, aoyama   => 23946,
                            apache   => 6355, apaches  => 18324, apalachicola
                                     => 29325,
                            apartheid
                                     => 6593, apartments
                                     => 3666,
                            apennines
                                     => 25999, apertura => 11938,
                            aperture => 7458, apertures
                                     => 25621,
                            apex     => 5716, aphasia  => 22066, aphid    => 26215, aphids   => 21034,
                            aphorisms
                                     => 27157, aphrodite
                                     => 14513,
                            apical   => 10765, apnea    => 22811, apocalyptic
                                     => 10581,
                            apocrypha
                                     => 24685, apocryphal
                                     => 15961,
                            apocynaceae
                                     => 28980, apoel    => 17425,
                            apogee   => 16243, apolitical
                                     => 22971,
                            apollinaire
                                     => 28576, apollo   => 4199,
                            apollon  => 19105, apollonia
                                     => 29245,
                            apollonius
                                     => 23462, apologetics
                                     => 24940,
                            apologised
                                     => 14844, apologises
                                     => 26568,
                            apologist
                                     => 29009, apoptosis
                                     => 11762,
                            apoptotic
                                     => 25349, apostasy => 18321,
                            apostate => 24537, apostle  => 7895, apostles => 7301, apostol  => 28381,
                            apostolate
                                     => 26587, apostolic
                                     => 5013,
                            appalachia
                                     => 19558, appalachian
                                     => 7235,
                            appalachians
                                     => 24208, apparatus
                                     => 5931,
                            apparel  => 9564, apparent => 2506, apparitions
                                     => 20131,
                            appeal   => 1857, appealed => 4682, appeals  => 3277, appear   => 972,
                            appearance
                                     => 707, appearances
                                     => 930,
                            appeared => 361, appearing
                                     => 2075,
                            appears  => 845, appeasement
                                     => 23364,
                            appellant
                                     => 19656, appellate
                                     => 8217,
                            appellation
                                     => 12368, appendages
                                     => 16202,
                            appended => 15046, appendices
                                     => 26332,
                            appenzell
                                     => 28742, applauded
                                     => 13174,
                            appliances
                                     => 8919, applicability
                                     => 17315,
                            applicable
                                     => 5927, applicant
                                     => 8962,
                            applicants
                                     => 6466, application
                                     => 1312,
                            applications
                                     => 1380, applied  => 1121,
                            applies  => 4528, apply    => 2374, applying => 4499, appoint  => 6441,
                            appointed
                                     => 415, appointee
                                     => 18819,
                            appointees
                                     => 17384, appointing
                                     => 9756,
                            appoints => 11939, appomattox
                                     => 16899,
                            apportioned
                                     => 19416, apportionment
                                     => 19596,
                            appraisal
                                     => 12025, appreciable
                                     => 22964,
                            apprentice
                                     => 5585, apprenticed
                                     => 10301,
                            apprentices
                                     => 13605, apprenticeship
                                     => 7518,
                            apprenticeships
                                     => 24361,
                            approach => 1113, approachable
                                     => 27879,
                            approached
                                     => 2904, approaches
                                     => 2972,
                            appropriated
                                     => 10194, appropriately
                                     => 9208,
                            appropriateness
                                     => 26218,
                            appropriation
                                     => 10383, appropriations
                                     => 8326,
                            approval => 2431, approvals
                                     => 20088,
                            approved => 1495, approving
                                     => 13432,
                            approx   => 8540, approximate
                                     => 6014,
                            approximated
                                     => 14623, approximately
                                     => 524,
                            approximates
                                     => 24240, approximating
                                     => 24646,
                            approximation
                                     => 7253, approximations
                                     => 17025,
                            apuestas => 26246, apulia   => 14726, aqaba    => 26176, aquaculture
                                     => 12211,
                            aquaria  => 23632, aquarium => 6604, aquariums
                                     => 18515,
                            aquatic  => 4915, aquatics => 7622, aqueduct => 8439, aqueducts
                                     => 20469,
                            aqueous  => 11078, aquifer  => 14087, aquifers => 20786, aquila   => 17513,
                            aquileia => 22262, aquinas  => 10456, aquitaine
                                     => 10467,
                            arab     => 1713, arabella => 21241, arabesque
                                     => 29200,
                            arabi    => 19409, arabia   => 3601, arabian  => 5443, arabic   => 2368,
                            arabidopsis
                                     => 28851, arable   => 10828,
                            arabs    => 5352, arafat   => 14924, aragonese
                                     => 15312,
                            aragorn  => 26695, arakan   => 20593, aramaic  => 9825, araneta  => 26117,
                            arapaho  => 21380, ararat   => 15898, arashi   => 25292, arbiter  => 19692,
                            arbitrage
                                     => 22605, arbitrarily
                                     => 12721,
                            arbitrary
                                     => 5840, arbitration
                                     => 6863,
                            arbitron => 26245, arbor    => 7742, arborea  => 25259, arboreal => 14030,
                            arboretum
                                     => 8767, arbroath => 17844,
                            arbuthnot
                                     => 21071, arcade   => 4139,
                            arcades  => 12077, arcadia  => 9683, arcana   => 22202, arch     => 3306,
                            archaea  => 20698, archaeological
                                     => 2656,
                            archaeologist
                                     => 7487, archaeologists
                                     => 7073,
                            archaeology
                                     => 4520, archaic  => 7498,
                            archangel
                                     => 11920, archbishop
                                     => 2384,
                            archbishopric
                                     => 13187, archbishops
                                     => 13334,
                            archdeacon
                                     => 8606, archdeaconry
                                     => 17242,
                            archdiocesan
                                     => 27568, archdiocese
                                     => 4761,
                            archduchess
                                     => 20772, archduke => 10473,
                            arched   => 7526, archeological
                                     => 7708,
                            archeologist
                                     => 22165, archeologists
                                     => 20659,
                            archeology
                                     => 15451, archers  => 10154,
                            archery  => 7296, arches   => 5760, archetypal
                                     => 16625,
                            archetype
                                     => 15803, archetypes
                                     => 20305,
                            archiepiscopal
                                     => 28808,
                            archimandrite
                                     => 28945, archimedes
                                     => 16622,
                            archipelago
                                     => 5162, architect
                                     => 1546,
                            architects
                                     => 3002, architectural
                                     => 2215,
                            architecturally
                                     => 13127,
                            architecture
                                     => 1086, architectures
                                     => 11745,
                            archiv   => 19182, archival => 8789, archive  => 3789, archived => 12481,
                            archives => 3167, archiving
                                     => 19036,
                            archivist
                                     => 14996, archon   => 25203,
                            arcot    => 24680, arcseconds
                                     => 29669,
                            arctic   => 3864, arctiidae
                                     => 7429,
                            ardabil  => 12564, ardashir => 29148, ardeche  => 25270, ardeidae => 29030,
                            ardennes => 12968, ardent   => 9778, ardmore  => 21074, ardrossan
                                     => 27565,
                            arduous  => 15501, are      => 18, area     => 98, areal    => 29963,
                            areas    => 363, arecibo  => 23316, arena    => 1726, arenabowl
                                     => 26774,
                            arendal  => 27440, arequipa => 22047, areva    => 28487, arezzo   => 20995,
                            argent   => 9012, argentina
                                     => 1870,
                            argentine
                                     => 2973, argentinean
                                     => 29659,
                            argentines
                                     => 23365, argentinian
                                     => 11719,
                            argentino
                                     => 17557, argentinos
                                     => 24628,
                            arges    => 27304, arginine => 20937, argonaut => 27329, argonauts
                                     => 10826,
                            argonne  => 16984, argos    => 13585, argosy   => 29434, arguably => 5594,
                            argued   => 1765, argues   => 3369, argumentation
                                     => 24037,
                            arguments
                                     => 3861, argus    => 11381,
                            argyle   => 9318, argyll   => 10036, aria     => 5364, ariadne  => 18383,
                            arian    => 16939, ariege   => 27366, aries    => 14389, arima    => 28606,
                            arion    => 23457, arise    => 5309, arisen   => 10846, arises   => 7041,
                            arising  => 6888, arista   => 13944, aristide => 18307, aristocracy
                                     => 8310,
                            aristocrat
                                     => 12179, aristocratic
                                     => 7475,
                            aristocrats
                                     => 12712, aristophanes
                                     => 22644,
                            aristotelian
                                     => 17373, aristotle
                                     => 6826,
                            arithmetic
                                     => 7425, arizona  => 1707,
                            arjun    => 10880, arjuna   => 13909, arkady   => 26838, arkansas => 2120,
                            arkham   => 18817, arkhangelsk
                                     => 17093,
                            arkwright
                                     => 23367, arles    => 15215,
                            arlington
                                     => 5297, armada   => 10017,
                            armadale => 27357, armagh   => 8876, armagnac => 29483, armament => 5725,
                            armaments
                                     => 12850, armature => 24542,
                            armband  => 26624, armbar   => 27323, armed    => 1319, armee    => 13830,
                            armen    => 25671, armenia  => 3852, armenian => 2774, armenians
                                     => 7211,
                            armia    => 26955, armidale => 22856, armies   => 3253, armin    => 15946,
                            armistice
                                     => 6995, armor    => 3994,
                            armored  => 4474, armorial => 23411, armory   => 9511, armoured => 4189,
                            armoury  => 20132, army     => 215, arnaldo  => 26559, arnaud   => 14344,
                            arnaz    => 27438, arnhem   => 12601, arnulf   => 20526, aromatic => 9349,
                            aroostook
                                     => 27786, arose    => 4009,
                            arousal  => 14696, arpad    => 21857, arran    => 15571, arranged => 2031,
                            arrangement
                                     => 2639, arranger => 8353,
                            arrangers
                                     => 29759, arranges => 10127,
                            arras    => 13575, array    => 3549, arrayed  => 26225, arrays   => 9605,
                            arrears  => 20128, arrests  => 6475, arriba   => 27835, arriva   => 13654,
                            arrival  => 1932, arrivals => 10354, arrived  => 951, arrives  => 3232,
                            arriving => 2668, arrondissement
                                     => 7163,
                            arrondissements
                                     => 22235,
                            arrow    => 4424, arrowheads
                                     => 26392,
                            arrows   => 6545, arsenal  => 3504, arsene   => 22747, arsenio  => 25521,
                            arslan   => 21346, art      => 255, artaxerxes
                                     => 26839,
                            artefact => 27337, artefacts
                                     => 9518,
                            artem    => 27500, artemis  => 11524, artemisia
                                     => 17505,
                            arterial => 9054, artes    => 12297, artesian => 26686, arthritis
                                     => 10510,
                            arthropod
                                     => 25498, arthropods
                                     => 13609,
                            arthurian
                                     => 16436, article  => 870,
                            articled => 21902, articles => 1337, articular
                                     => 22299,
                            articulated
                                     => 8021, articulates
                                     => 28711,
                            articulating
                                     => 26591, articulation
                                     => 10864,
                            artifacts
                                     => 4099, artificial
                                     => 3052,
                            artificially
                                     => 11046, artigas  => 27152,
                            artillery
                                     => 1673, artin    => 26423,
                            artisan  => 13097, artisanal
                                     => 24505,
                            artisans => 9474, artist   => 608, artiste  => 17886, artistes => 14687,
                            artistic => 1972, artistically
                                     => 15610,
                            artistry => 13245, artists  => 658, artois   => 16836, arts     => 454,
                            artur    => 12995, artwork  => 3353, artworks => 8681, artyom   => 26712,
                            aruna    => 24845, arunachal
                                     => 15535,
                            arundel  => 10391, arundell => 24152, arusha   => 24838, arvid    => 25485,
                            arvind   => 23077, aryeh    => 27098, as       => 8, asahi    => 13157,
                            asansol  => 27024, asante   => 21387, asaph    => 23424, ascap    => 14612,
                            ascend   => 12259, ascendancy
                                     => 17034,
                            ascendant
                                     => 28092, ascended => 8574,
                            ascending
                                     => 8800, ascends  => 17276,
                            ascenso  => 25122, ascent   => 6919, ascents  => 16960, ascertained
                                     => 18826,
                            ascetic  => 14298, asceticism
                                     => 24067,
                            ascetics => 29397, aschaffenburg
                                     => 27126,
                            ascii    => 11724, ascoli   => 19927, ascot    => 10455, ascribe  => 25607,
                            ascribed => 9504, ascribes => 28523, asean    => 10625, asesoria => 26761,
                            asexual  => 18289, asghar   => 26163, ashbourne
                                     => 24652,
                            ashburton
                                     => 19699, ashbury  => 29231,
                            ashdod   => 23171, ashdown  => 21018, asheville
                                     => 12276,
                            ashfield => 18146, ashikaga => 21104, ashina   => 23300, ashkelon => 24712,
                            ashkenazi
                                     => 12527, ashland  => 9969,
                            ashlar   => 15245, ashok    => 11259, ashoka   => 14747, ashore   => 6516,
                            ashraf   => 14324, ashram   => 11432, ashtabula
                                     => 27105,
                            ashur    => 28875, ashwin   => 29538, asia     => 1035, "asia/oceania"
                                     => 24950,
                            asian    => 961, asians   => 11483, asiatic  => 9186, asimov   => 12292,
                            asistencia
                                     => 24544, asker    => 22383,
                            asmara   => 23740, asociacion
                                     => 16809,
                            aspartate
                                     => 28672, aspect   => 3040,
                            aspects  => 1924, asperger => 23862, aspergillus
                                     => 21081,
                            asphalt  => 7566, aspinall => 25204, aspirated
                                     => 14712,
                            aspiration
                                     => 13443, aspirations
                                     => 8672,
                            aspired  => 16833, aspires  => 22018, aspiring => 8344, asquith  => 15379,
                            assad    => 10257, assailants
                                     => 17899,
                            assam    => 6097, assamese => 12818, assange  => 25858, assassinate
                                     => 9603,
                            assassinated
                                     => 6266, assassinating
                                     => 25914,
                            assassination
                                     => 3708, assassinations
                                     => 14194,
                            assault  => 2358, assaults => 8585, assay    => 12692, assays   => 18209,
                            assemblage
                                     => 13056, assemblages
                                     => 21869,
                            assembled
                                     => 3648, assembles
                                     => 21988,
                            assemblies
                                     => 6437, assembling
                                     => 11625,
                            assembly => 657, assemblyman
                                     => 14810,
                            assemblymen
                                     => 25765, assen    => 28472,
                            assent   => 10780, assert   => 7945, asserted => 5252, asserting
                                     => 9858,
                            assertion
                                     => 8826, assertions
                                     => 13354,
                            asserts  => 7292, assess   => 6088, assessed => 5680, assesses => 20190,
                            assessing
                                     => 9379, assessment
                                     => 2824,
                            assessments
                                     => 7808, assessor => 15804,
                            assessors
                                     => 28118, asset    => 4515,
                            assets   => 2491, assigned => 1098, assigns  => 9215, assimilate
                                     => 17545,
                            assimilated
                                     => 10388, assimilation
                                     => 9544,
                            assiniboine
                                     => 22399, assisi   => 14307,
                            assist   => 2370, assistance
                                     => 1824,
                            assistant
                                     => 906, assistants
                                     => 7110,
                            assisted => 2521, assisting
                                     => 5524,
                            assistive
                                     => 28598, assists  => 3222,
                            assize   => 28347, assizes  => 25353, associacao
                                     => 18893,
                            associate
                                     => 1903, associated
                                     => 669,
                            associates
                                     => 3482, association
                                     => 289,
                            associations
                                     => 3095, associative
                                     => 13794,
                            associazione
                                     => 23907, assortment
                                     => 11636,
                            assumed  => 1925, assumes  => 6339, assumption
                                     => 4584,
                            assyria  => 13500, assyrian => 7357, assyrians
                                     => 13001,
                            astana   => 15125, aster    => 15356, asteraceae
                                     => 18070,
                            asterisk => 14269, asterism => 26415, asterix  => 19313, astern   => 22757,
                            asteroid => 6103, asteroids
                                     => 11118,
                            astley   => 14885, astor    => 10008, astoria  => 10699, astra    => 10708,
                            astragalus
                                     => 23502, astrakhan
                                     => 19733,
                            astride  => 22488, astro    => 10638, astrodome
                                     => 29219,
                            astrolabe
                                     => 28856, astrologer
                                     => 18219,
                            astrologers
                                     => 23879, astrological
                                     => 16121,
                            astrology
                                     => 10211, astronautics
                                     => 23213,
                            astronomer
                                     => 6840, astronomers
                                     => 9718,
                            astronomical
                                     => 5286, astronomy
                                     => 4785,
                            astrophysical
                                     => 20898, astrophysicist
                                     => 25109,
                            astrophysics
                                     => 12585, astros   => 8225,
                            asturian => 20562, asturias => 9448, asuka    => 20071, asura    => 19828,
                            aswan    => 26393, asylum   => 4673, asylums  => 23925, asymmetric
                                     => 10901,
                            asymmetrical
                                     => 13752, asymmetry
                                     => 17266,
                            asymptomatic
                                     => 19875, asymptotic
                                     => 16274,
                            asymptotically
                                     => 25427,
                            asynchronous
                                     => 15373, at       => 13,
                            atacama  => 22754, atalanta => 17320, atari    => 7132, ataturk  => 14512,
                            ataxia   => 21342, atelier  => 14207, ateneo   => 12153, athabasca
                                     => 18816,
                            athabaskan
                                     => 26443, athanasius
                                     => 17037,
                            atheism  => 13066, atheist  => 8487, atheistic
                                     => 28555,
                            athenaeum
                                     => 15408, athenian => 9618,
                            athenians
                                     => 14247, athens   => 2677,
                            atherosclerosis
                                     => 23942,
                            athlete  => 3083, athletes => 2496, athletic => 1525, athleticism
                                     => 25844,
                            athletics
                                     => 1548, athlon   => 28745,
                            athlone  => 18342, athol    => 21706, atholl   => 21274, atlanta  => 2003,
                            atlante  => 28719, atlantic => 1216, atlantique
                                     => 21922,
                            atlantiques
                                     => 24052, atlantis => 7455,
                            atlas    => 4902, atlases  => 27765, atletico => 6394, atman    => 22724,
                            atmosphere
                                     => 2852, atmospheres
                                     => 18476,
                            atmospheric
                                     => 4800, atoll    => 7662,
                            atolls   => 20403, atom     => 5429, atomic   => 3603, atoms    => 4966,
                            atonement
                                     => 14260, atop     => 5404,
                            atpase   => 20759, atria    => 27400, atrial   => 17380, atrium   => 10890,
                            atrocities
                                     => 8959, atsushi  => 25161,
                            attache  => 11195, attached => 1832, attaches => 13299, attaching
                                     => 12989,
                            attachment
                                     => 5826, attack   => 543,
                            attacked => 1459, attackers
                                     => 8163,
                            attacking
                                     => 3126, attacks  => 1281,
                            attain   => 7087, attainable
                                     => 24320,
                            attainder
                                     => 25276, attained => 4668,
                            attaining
                                     => 9167, attainment
                                     => 13005,
                            attains  => 15837, attempt  => 869, attempted
                                     => 1449,
                            attempting
                                     => 2827, attempts => 1376,
                            attenborough
                                     => 16953, attend   => 1843,
                            attendance
                                     => 2839, attendances
                                     => 13823,
                            attended => 617, attendees
                                     => 7727,
                            attending
                                     => 2485, attends  => 8542,
                            attentional
                                     => 27804, attenuated
                                     => 20861,
                            attenuation
                                     => 16746, attestation
                                     => 25499,
                            attested => 6970, attesting
                                     => 28054,
                            attests  => 24421, atticus  => 21777, attila   => 13838, attire   => 9934,
                            attitudes
                                     => 5375, attlee   => 21927,
                            attock   => 28733, attract  => 3956, attracting
                                     => 5950,
                            attraction
                                     => 3444, attractions
                                     => 3983,
                            attractiveness
                                     => 17427,
                            attracts => 6423, attributable
                                     => 13330,
                            attribute
                                     => 7057, attributed
                                     => 2449,
                            attributes
                                     => 4624, attributing
                                     => 17263,
                            attribution
                                     => 8956, attributions
                                     => 24286,
                            attrition
                                     => 13685, atypical => 12515,
                            auburn   => 5044, auckland => 3367, auctioned
                                     => 11290,
                            auctions => 11807, audacious
                                     => 20038,
                            auden    => 20091, audible  => 12787, audience => 1341, audiences
                                     => 3446,
                            audiencia
                                     => 20316, audio    => 1996,
                            audiobook
                                     => 17778, audiobooks
                                     => 23229,
                            audiovisual
                                     => 15358, audit    => 6213,
                            auditing => 13770, auditioned
                                     => 8056,
                            auditor  => 8000, auditorium
                                     => 4631,
                            auditoriums
                                     => 27636, auditors => 15041,
                            auditory => 9854, audits   => 15465, audley   => 19272, audubon  => 12593,
                            augment  => 12815, augmentation
                                     => 17081,
                            augmented
                                     => 7330, augmenting
                                     => 24420,
                            augsburg => 8854, august   => 161, augustan => 25862, augustana
                                     => 28307,
                            augustinian
                                     => 11701, augustinians
                                     => 26042,
                            augusto  => 10978, augustow => 28584, aulus    => 27457, aural    => 20443,
                            aurangabad
                                     => 17963, aurangzeb
                                     => 15285,
                            aurel    => 28893, aurelian => 23583, aureus   => 18909, aurobindo
                                     => 22164,
                            auschwitz
                                     => 9036, auspices => 7290,
                            auspicious
                                     => 14416, austen   => 10082,
                            austere  => 14728, austerity
                                     => 13047,
                            austerlitz
                                     => 28360, austral  => 20020,
                            australasia
                                     => 11313, australasian
                                     => 10738,
                            australia
                                     => 331, australian
                                     => 409,
                            australians
                                     => 5726, australis
                                     => 13962,
                            austria  => 1626, austrian => 2054, austrians
                                     => 9645,
                            austro   => 6421, austronesian
                                     => 15447,
                            authenticated
                                     => 20244, authentication
                                     => 10136,
                            authenticity
                                     => 7965, author   => 673,
                            authored => 3239, authoring
                                     => 13966,
                            authorisation
                                     => 17170, authorise
                                     => 29086,
                            authorised
                                     => 7289, authorising
                                     => 24973,
                            authoritarian
                                     => 9595, authoritarianism
                                     => 24600,
                            authoritative
                                     => 9566, authorities
                                     => 1340,
                            authority
                                     => 889, authorized
                                     => 3434,
                            authorizing
                                     => 13460, authors  => 1980,
                            authorship
                                     => 8479, autism   => 7395,
                            autistic => 14224, auto     => 3195, autobahn => 15249, autobiographical
                                     => 6876,
                            autobiographies
                                     => 25095,
                            autobiography
                                     => 4109, autobot  => 14641,
                            autobots => 10976, autocephalous
                                     => 29555,
                            autochthonous
                                     => 29765, autocratic
                                     => 17655,
                            autodesk => 24057, autodromo
                                     => 24226,
                            autofocus
                                     => 24720, autoimmune
                                     => 13742,
                            automaker
                                     => 20214, automakers
                                     => 21404,
                            automata => 17016, automate => 20420, automated
                                     => 4982,
                            automatic
                                     => 2573, automatically
                                     => 3554,
                            automation
                                     => 7328, automaton
                                     => 15512,
                            automobile
                                     => 3522, automobiles
                                     => 6891,
                            automorphism
                                     => 19958, automotive
                                     => 4834,
                            autonoma => 19522, autonomic
                                     => 18398,
                            autonomist
                                     => 28896, autonomous
                                     => 2929,
                            autonomously
                                     => 21934, autonomy => 4731,
                            autoroute
                                     => 15894, autos    => 27501,
                            autosomal
                                     => 13155, autovia  => 28452,
                            auvergne => 15090, auxerre  => 19176, auxiliaries
                                     => 15411,
                            auxiliary
                                     => 3955, avail    => 10775,
                            availability
                                     => 3945, available
                                     => 403,
                            avalanche
                                     => 7816, avalanches
                                     => 22095,
                            avalon   => 9203, avanti   => 26809, avars    => 20713, avatars  => 16457,
                            aveiro   => 27671, avellino => 22476, avengers => 6324, avenida  => 13981,
                            avenue   => 1012, avenues  => 7948, average  => 356, averaged => 4361,
                            averages => 7312, averaging
                                     => 5563,
                            avesta   => 29908, avestan  => 25223, aveyron  => 26660, avian    => 12089,
                            aviation => 1908, aviator  => 9062, aviators => 13594, avicenna => 22861,
                            avignon  => 12131, avionics => 13920, aviv     => 5236, avoca    => 24139,
                            avocets  => 29955, avoidance
                                     => 9689,
                            avoided  => 4608, avoids   => 9859, avondale => 16920, avowed   => 24348,
                            avraham  => 17327, awadh    => 26497, awaited  => 9981, awakening
                                     => 7973,
                            awakens  => 12917, awami    => 17480, award    => 257, awarded  => 527,
                            awardee  => 28206, awardees => 25370, awarding => 7831, awards   => 402,
                            awareness
                                     => 2763, awash    => 28627,
                            axial    => 9943, axillary => 22927, axils    => 25346, axiom    => 10882,
                            axiomatic
                                     => 24465, axioms   => 11499,
                            axis     => 2975, axles    => 11803, axonal   => 28757, axons    => 16520,
                            ayacucho => 26064, ayatollah
                                     => 13335,
                            aydin    => 16537, aykroyd  => 25800, aylesbury
                                     => 13306,
                            aylmer   => 19740, ayman    => 27538, aymara   => 16569, ayodhya  => 20750,
                            ayrshire => 10397, ayrton   => 19715, ayumi    => 21112, ayurveda => 17984,
                            ayurvedic
                                     => 18648, ayutthaya
                                     => 16821,
                            ayyubid  => 25047, azadegan => 25091, azalea   => 16554, azarenka => 21755,
                            azerbaijan
                                     => 3001, azerbaijani
                                     => 7896,
                            azerbaijanis
                                     => 25137, azeri    => 16137,
                            azhar    => 16475, azimuth  => 18841, azores   => 9560, aztec    => 9060,
                            azteca   => 14144, aztecs   => 13513, azuma    => 29365, azusa    => 21951,
                            "b'nai"  => 20579, "b.o.b"  => 27201, "b.tech" => 25079, "b/hip"  => 8811,
                            b0d3fb   => 26223, "ba'ath" => 15733, baba     => 5694, babar    => 21639,
                            babbage  => 26604, babbler  => 23825, babol    => 26087, babur    => 18900,
                            babylon  => 7051, babylonia
                                     => 18215,
                            babylonian
                                     => 9356, babylonians
                                     => 25249,
                            bacall   => 28301, baccalaureate
                                     => 9259,
                            bacharach
                                     => 20417, bachata  => 28880,
                            bachchan => 14425, bachelor => 1718, bacillus => 18590, backa    => 20050,
                            backbench
                                     => 25121, backcountry
                                     => 20382,
                            backdrop => 7853, backdrops
                                     => 26282,
                            backed   => 3096, backend  => 29698, backfield
                                     => 20212,
                            background
                                     => 720, backgrounds
                                     => 5839,
                            backing  => 3295, backlash => 10119, backstory
                                     => 13824,
                            backstroke
                                     => 8846, backward => 7072,
                            backwaters
                                     => 28497, bacolod  => 23826,
                            bacteria => 3927, bacterial
                                     => 6655,
                            bacteriology
                                     => 25284, bacterium
                                     => 10824,
                            bactria  => 27092, bactrian => 26370, badajoz  => 17884, badakhshan
                                     => 25012,
                            badawi   => 27449, baden    => 4714, badged   => 19438, badgers  => 11008,
                            badlands => 20956, badminton
                                     => 6232,
                            baekje   => 18178, baerum   => 23561, baffin   => 19565, bafta    => 8564,
                            bagan    => 16425, baghdad  => 5392, baghdadi => 24988, bagot    => 24830,
                            bagram   => 26807, bagrat   => 27917, bagration
                                     => 23738,
                            baguio   => 20193, "baha'i" => 7139, "baha'is"
                                     => 10702,
                            "baha'u'llah"
                                     => 16221, bahadur  => 8808,
                            bahamian => 19041, bahawalpur
                                     => 24495,
                            bahia    => 8524, bahman   => 27698, bahn     => 6128, bahnhof  => 25516,
                            bahrain  => 5906, bahraini => 15295, bahram   => 19406, bahru    => 20445,
                            baikal   => 18143, baikonur => 24997, baile    => 23404, bailiwick
                                     => 23535,
                            bainimarama
                                     => 25798, bajaj    => 24238,
                            bajnoksag
                                     => 18763, bakar    => 23027,
                            bakeries => 17526, bakers   => 15644, bakersfield
                                     => 10802,
                            bakhsh   => 16956, bakhtiari
                                     => 18234,
                            bakri    => 28471, bakufu   => 27282, bakunin  => 26816, balad    => 29610,
                            balaji   => 17618, balan    => 20775, balanced => 5366, balances => 12777,
                            balanchine
                                     => 19536, balancing
                                     => 8944,
                            balconies
                                     => 14436, balearic => 16067,
                            balikpapan
                                     => 28325, balinese => 16207,
                            balkan   => 6611, balkans  => 7294, balkh    => 26401, ballad   => 4585,
                            ballads  => 7008, ballarat => 11002, ballast  => 10373, ballet   => 2712,
                            ballets  => 12008, balliol  => 12854, ballo    => 28429, ballooning
                                     => 29687,
                            ballot   => 3915, balloting
                                     => 17229,
                            ballots  => 5756, ballymena
                                     => 22127,
                            balmain  => 14721, baloch   => 14920, balochistan
                                     => 11244,
                            baloncesto
                                     => 24115, balsa    => 25606,
                            balthasar
                                     => 21169, balti    => 26615,
                            baltic   => 4122, baltimore
                                     => 2042,
                            baltistan
                                     => 21899, balto    => 27321,
                            baluchestan
                                     => 13863, baluchistan
                                     => 23105,
                            balustrade
                                     => 16954, balzac   => 17230,
                            bamako   => 20517, bamberg  => 14133, bamboo   => 6315, banaras  => 25767,
                            banat    => 13991, banbury  => 14672, banca    => 20444, banco    => 10429,
                            bancorp  => 29460, band     => 155, bandai   => 13657, bandar   => 11243,
                            bandaranaike
                                     => 27049, bande    => 29267,
                            banded   => 10132, bandera  => 23017, bandicoot
                                     => 26987,
                            banding  => 16851, bandini  => 27324, bandit   => 10953, bandits  => 8216,
                            bandleader
                                     => 12367, bandmate => 14458,
                            bandmates
                                     => 14654, bandon   => 25293,
                            bandra   => 22043, bands    => 1400, bandstand
                                     => 15425,
                            bandung  => 14248, bandura  => 26041, bandwidth
                                     => 7291,
                            banff    => 13289, banga    => 29702, bangalore
                                     => 5287,
                            banger   => 28981, bangkok  => 5617, bangla   => 15250, bangladesh
                                     => 2658,
                            bangladeshi
                                     => 9272, bangor   => 8131,
                            bangui   => 27478, banishment
                                     => 17684,
                            banja    => 15827, banjo    => 8430, bank     => 507, banka    => 26205,
                            banked   => 16828, bankers  => 9489, banking  => 2950, banknote => 16270,
                            banknotes
                                     => 9839, bankruptcy
                                     => 3748,
                            banksia  => 10782, bankstown
                                     => 15939,
                            banned   => 2821, banners  => 9532, bannockburn
                                     => 29563,
                            banovina => 26033, banque   => 17044, banqueting
                                     => 29509,
                            banquets => 20257, banshees => 24175, banska   => 18389, bantam   => 14588,
                            bantamweight
                                     => 11467, bantu    => 11461,
                            banyan   => 22788, baptised => 10076, baptismal
                                     => 14478,
                            baptisms => 21374, baptist  => 2591, baptistery
                                     => 27632,
                            baptists => 11167, barack   => 5183, baraka   => 24913, barangay => 8708,
                            barangays
                                     => 9234, barat    => 24543,
                            barbadian
                                     => 21525, barbados => 6678,
                            barbarian
                                     => 10607, barbarism
                                     => 29006,
                            barbarossa
                                     => 11954, barbary  => 14600,
                            barbed   => 11323, barberini
                                     => 21814,
                            barbican => 16805, barbuda  => 14526, barbus   => 21572, barca    => 17958,
                            barcelona
                                     => 2844, barclays => 12687,
                            barda    => 24891, bardhaman
                                     => 26307,
                            bardic   => 29909, bardot   => 27052, bards    => 21423, bareilly => 23512,
                            barents  => 24041, barges   => 10032, baring   => 16191, barisal  => 18737,
                            barisan  => 20504, baritone => 8370, barium   => 16817, barnabas => 14565,
                            barnegat => 29535, barnet   => 9620, barneveld
                                     => 25667,
                            barnsley => 8658, barnstable
                                     => 21910,
                            barnstaple
                                     => 17250, barnstormers
                                     => 29641,
                            baroda   => 16104, barometric
                                     => 19869,
                            baroness => 8499, baronet  => 3616, baronetage
                                     => 10422,
                            baronetcies
                                     => 29760, baronetcy
                                     => 8204,
                            baronets => 9091, baronial => 21127, baronies => 20653, barons   => 7790,
                            barony   => 6890, baroque  => 4002, barque   => 19173, barrack  => 20891,
                            barracks => 4244, barrage  => 8343, barranquilla
                                     => 23096,
                            barred   => 6941, barrels  => 6883, barrens  => 23990, barrichello
                                     => 16781,
                            barrier  => 3970, barriers => 5830, barrio   => 9509, barrister
                                     => 7472,
                            barristers
                                     => 19073, barrymore
                                     => 12579,
                            bartin   => 28803, bartok   => 14868, bartoli  => 23721, barua    => 29493,
                            baruch   => 14403, barzani  => 28755, basal    => 5468, basalt   => 10007,
                            basaltic => 17564, basalts  => 26360, bascule  => 28823, base     => 510,
                            baseball => 781, based    => 125, basel    => 5759, baseline => 9455,
                            baseman  => 6699, basemen  => 27986, bases    => 2720, basescu  => 25766,
                            bashar   => 19237, bashkortostan
                                     => 24021,
                            basic    => 1140, basie    => 16604, basilan  => 23021, basildon => 24102,
                            basilica => 5296, basilicata
                                     => 28345,
                            basilisk => 29928, basin    => 2182, basingstoke
                                     => 15645,
                            basins   => 8236, basis    => 996, basketball
                                     => 732,
                            basque   => 5238, basques  => 21495, basra    => 13365, bassano  => 24373,
                            basse    => 16428, basses   => 15149, basset   => 18487, bassey   => 22892,
                            bassist  => 3581, bassists => 25402, bassline => 22882, bassoon  => 15490,
                            bassoons => 22707, basti    => 27792, bastia   => 20333, bastion  => 11148,
                            bastions => 17407, bastogne => 24792, bastrop  => 28282, bataan   => 15689,
                            bataille => 28685, batang   => 26283, batangas => 18115, batavia  => 10535,
                            batavian => 21561, batches  => 14303, batgirl  => 24888, bathgate => 25366,
                            bathhouse
                                     => 20301, bathory  => 20203,
                            bathurst => 8366, batik    => 27772, batley   => 22690, baton    => 6151,
                            batons   => 24173, bats     => 4241, batsman  => 4688, batsmen  => 10451,
                            battalion
                                     => 1390, battalions
                                     => 3971,
                            batted   => 4184, batters  => 8519, battersea
                                     => 15231,
                            battery  => 2301, batticaloa
                                     => 26268,
                            batting  => 3007, battle   => 344, battlecruiser
                                     => 16880,
                            battlecruisers
                                     => 17012,
                            battled  => 8195, battlefield
                                     => 4488,
                            battlefields
                                     => 17072, battlements
                                     => 22472,
                            battleship
                                     => 6360, battleships
                                     => 7720,
                            battlestar
                                     => 16697, batumi   => 28173,
                            bauhaus  => 14805, bauxite  => 20321, bavaria  => 4158, bavarian => 5790,
                            bay      => 542, bayamon  => 24698, bayan    => 14557, bayerische
                                     => 28643,
                            bayern   => 7653, bayernliga
                                     => 27381,
                            bayesian => 14648, bayeux   => 23057, bayezid  => 25910, bayonet  => 12913,
                            bayonets => 20083, bayonne  => 14047, bayou    => 9926, bayreuth => 14042,
                            bayshore => 29399, bayside  => 18273, bayswater
                                     => 27196,
                            bayview  => 21064, bazaar   => 8773, bazar    => 11688, bbwaa    => 28183,
                            "be'er"  => 27795, beaches  => 4486, beachhead
                                     => 18885,
                            beacons  => 15548, beaconsfield
                                     => 22038,
                            beaked   => 22973, beaks    => 16263, beams    => 6714, beano    => 25092,
                            bearcats => 19260, bearers  => 10423, bearing  => 3074, bearn    => 22934,
                            bears    => 2175, beaten   => 3276, beatification
                                     => 17227,
                            beatified
                                     => 17515, beatle   => 24066,
                            beatles  => 4420, beatrix  => 15366, beatz    => 26718, beaufort => 8903,
                            beautification
                                     => 22385,
                            beauvoir => 24049, beaux    => 8180, beaverbrook
                                     => 28712,
                            beaverton
                                     => 24822, bebop    => 16568,
                            became   => 82, beckenham
                                     => 26211,
                            becket   => 14823, become   => 281, becomes  => 1154, becoming => 753,
                            bedchamber
                                     => 22606, bedfordshire
                                     => 9593,
                            bedouin  => 12221, bedouins => 27327, bedrock  => 10325, beechcraft
                                     => 19919,
                            beeching => 17102, beehive  => 18125, beekeeping
                                     => 26486,
                            been     => 37, beermen  => 23374, beersheba
                                     => 17061,
                            beeston  => 20612, beetle   => 3304, beetles  => 6237, befell   => 28611,
                            before   => 89, befriended
                                     => 8533,
                            befriending
                                     => 24735, befriends
                                     => 11328,
                            began    => 144, beginner => 15178, beginners
                                     => 13799,
                            beginning
                                     => 550, beginnings
                                     => 5367,
                            begins   => 1259, begum    => 12482, begun    => 2263, behalf   => 2504,
                            behavioral
                                     => 5559, behaviors
                                     => 6008,
                            behaviour
                                     => 3328, behavioural
                                     => 13444,
                            behaviours
                                     => 14068, beheaded => 10930,
                            behest   => 10714, beijing  => 2535, being    => 86, beinn    => 26434,
                            beira    => 18093, beirut   => 6197, beitar   => 20722, belafonte
                                     => 24413,
                            belarus  => 5068, belarusian
                                     => 6905,
                            belarusians
                                     => 27981, belatedly
                                     => 24514,
                            belchatow
                                     => 25302, belem    => 20787,
                            belfast  => 3866, belfort  => 19506, belfry   => 13707, belgaum  => 15743,
                            belge    => 28814, belgian  => 2421, belgians => 16330, belgique => 28351,
                            belgium  => 1964, belgorod => 26411, belgrade => 4086, belgrano => 14968,
                            belichick
                                     => 29095, belief   => 2443,
                            beliefs  => 3264, believed => 832, believers
                                     => 7913,
                            belisarius
                                     => 25116, belize   => 6922,
                            belizean => 24670, bellarmine
                                     => 28618,
                            bellary  => 28675, bellas   => 16735, bellator => 12217, bellefonte
                                     => 27900,
                            belleville
                                     => 12729, bellevue => 9740,
                            belleza  => 19872, bellingham
                                     => 14301,
                            bellinzona
                                     => 29276, belmont  => 6778,
                            beloit   => 20209, belonged => 2562, belonging
                                     => 2716,
                            belorussian
                                     => 25382, below    => 593,
                            belsen   => 26847, beltway  => 14293, belvidere
                                     => 25831,
                            belvoir  => 20757, bemidji  => 28017, benares  => 26995, benaud   => 29699,
                            benazir  => 19604, bencher  => 24308, benches  => 9656, benchmark
                                     => 10577,
                            benchmarking
                                     => 24353, benchmarks
                                     => 18439,
                            bendigo  => 12874, bendix   => 20902, benedictine
                                     => 7513,
                            benedictines
                                     => 25176, benediction
                                     => 26996,
                            benefactors
                                     => 16224, benefice => 16292,
                            benefices
                                     => 27819, beneficial
                                     => 5959,
                            beneficiaries
                                     => 11858, benefited
                                     => 7373,
                            benefiting
                                     => 13472, benefits => 2274,
                            benefitted
                                     => 19932, benelux  => 17962,
                            benetton => 16299, benfica  => 9282, bengal   => 3180, bengali  => 4899,
                            bengals  => 8313, bengaluru
                                     => 16913,
                            benghazi => 14786, bengt    => 22525, benin    => 7869, benno    => 27055,
                            bentham  => 16603, benthic  => 15865, bentinck => 21015, benue    => 27392,
                            benzene  => 14816, benzodiazepine
                                     => 21947,
                            benzodiazepines
                                     => 17056,
                            beograd  => 18813, beowulf  => 15579, bequeathed
                                     => 9719,
                            bequest  => 13179, bequests => 25269, berar    => 27889, berat    => 26333,
                            berates  => 26871, berber   => 9908, berbers  => 18842, berdych  => 29398,
                            berea    => 23012, berengar => 25820, berets   => 20452, berezovsky
                                     => 28854,
                            bergamo  => 13846, bergerac => 23710, bergson  => 27919, berhad   => 19968,
                            beria    => 25477, bering   => 13064, berisha  => 28558, berkeley => 3140,
                            berkhamsted
                                     => 28168, berklee  => 15025,
                            berks    => 14871, berkshire
                                     => 5766,
                            berle    => 24993, berlin   => 1204, berliner => 11886, berlioz  => 16347,
                            berlusconi
                                     => 13270, bermondsey
                                     => 23333,
                            bermudian
                                     => 22229, bernadotte
                                     => 21479,
                            bernd    => 15265, berne    => 14152, berners  => 24932, bernese  => 16686,
                            bernini  => 19683, bernoulli
                                     => 16677,
                            berth    => 7062, berthed  => 19902, berthier => 28983, berthing => 25471,
                            berths   => 12865, bertolt  => 23408, berwickshire
                                     => 27847,
                            berwyn   => 29420, besancon => 18022, besant   => 26148, besar    => 18416,
                            beset    => 15972, besiege  => 22123, besieged => 6695, besiegers
                                     => 29461,
                            besieging
                                     => 16460, besiktas => 15553,
                            bespoke  => 17560, bessarabia
                                     => 14864,
                            bessel   => 24884, bessemer => 20111, best     => 162, bestowed => 6843,
                            bestowing
                                     => 27444, bestows  => 29495,
                            bests    => 15700, bestseller
                                     => 8888,
                            bestsellers
                                     => 22677, bestselling
                                     => 12152,
                            beta     => 3265, betel    => 24392, bethesda => 11765, bethlehem
                                     => 7553,
                            bethnal  => 22502, betis    => 20080, betjeman => 28316, betrothal
                                     => 23562,
                            betrothed
                                     => 15564, bettered => 20982,
                            betterment
                                     => 18955, betula   => 23607,
                            between  => 57, beverages
                                     => 7767,
                            bexar    => 20109, bexley   => 19283, beyonce  => 8858, beziers  => 28172,
                            bezirksliga
                                     => 24637, bhadra   => 28363,
                            bhagat   => 19738, bhagavad => 21588, bhagavata
                                     => 23876,
                            bhagwan  => 26369, bhakti   => 15998, bhangra  => 28454, bharat   => 11220,
                            bharata  => 22692, bharathi => 24529, bharati  => 16811, bharatiya
                                     => 11609,
                            bharatpur
                                     => 28432, bharti   => 22217,
                            bhasa    => 28721, bhaskar  => 19100, bhattacharya
                                     => 18008,
                            bhavan   => 16701, bhavani  => 22834, bhima    => 20862, bhojpuri => 23913,
                            bhopal   => 11063, bhubaneswar
                                     => 16533,
                            bhumibol => 26899, bhushan  => 17451, bhutan   => 6877, bhutanese
                                     => 18447,
                            bhutto   => 10446, biafra   => 20229, biala    => 14613, bialystok
                                     => 9735,
                            biannual => 19518, biarritz => 21513, biases   => 15668, biathlete
                                     => 24178,
                            biathlon => 11568, bible    => 2258, biblical => 3700, bibliographic
                                     => 19526,
                            bibliographical
                                     => 27939,
                            bibliography
                                     => 4750, biblioteca
                                     => 18415,
                            bibliotheca
                                     => 21876, bibliotheque
                                     => 15478,
                            bicameral
                                     => 17362, bicarbonate
                                     => 20454,
                            bicentenary
                                     => 28241, bicester => 25721,
                            bicol    => 23682, bicolor  => 20285, bicycle  => 3834, bicycles => 7704,
                            bicycling
                                     => 19408, bicyclists
                                     => 28044,
                            bidar    => 27023, bidders  => 20335, bideford => 23660, biden    => 14424,
                            bidirectional
                                     => 21516, bielefeld
                                     => 17734,
                            bielsk   => 28084, bielsko  => 23803, biennale => 9640, biennial => 8489,
                            bifurcation
                                     => 22534, biggar   => 28829,
                            bighorn  => 16429, bight    => 15893, bihar    => 6146, bihari   => 19686,
                            bijapur  => 17903, bijelo   => 28845, bikaner  => 21871, biking   => 10424,
                            bikram   => 28003, bilaspur => 25450, bilateral
                                     => 6588,
                            bilayer  => 25546, bilbao   => 9462, bilinear => 24790, bilingual
                                     => 6798,
                            bilingualism
                                     => 22412, billboard
                                     => 1388,
                            bille    => 29532, billed   => 5657, billiards
                                     => 13411,
                            billion  => 1405, bimonthly
                                     => 17091,
                            binaries => 22975, binary   => 4753, binding  => 3154, bindings => 18886,
                            binds    => 8231, bingen   => 21893, binghamton
                                     => 11392,
                            bingley  => 23114, binocular
                                     => 23186,
                            binomial => 12876, bioavailability
                                     => 25768,
                            biochemical
                                     => 11318, biochemist
                                     => 19957,
                            biochemistry
                                     => 8765, biodiesel
                                     => 16510,
                            biodiversity
                                     => 6603, bioengineering
                                     => 29548,
                            biofuel  => 19871, biofuels => 16557, biogas   => 26241, biogeography
                                     => 27890,
                            biographer
                                     => 6361, biographers
                                     => 15658,
                            biographical
                                     => 6625, biographies
                                     => 7975,
                            biography
                                     => 808, bioinformatics
                                     => 15132,
                            biologist
                                     => 8845, biologists
                                     => 12812,
                            biology  => 2664, biomarker
                                     => 29057,
                            biomarkers
                                     => 24887, biomass  => 9847,
                            biome    => 25106, biomechanics
                                     => 29819,
                            biomedical
                                     => 8237, bionic   => 17441,
                            biophysical
                                     => 29202, biophysics
                                     => 19412,
                            biopic   => 14938, biosciences
                                     => 29384,
                            biosphere
                                     => 11246, biosynthesis
                                     => 12519,
                            biota    => 23793, biotechnology
                                     => 8027,
                            biotic   => 24192, bipartite
                                     => 21392,
                            bipedal  => 23778, biplane  => 9838, biplanes => 24829, bipolar  => 10647,
                            birding  => 22380, birdlife => 15432, birdman  => 19077, birds    => 1526,
                            birdwatching
                                     => 26717, birger   => 21970,
                            birkbeck => 22067, birkenau => 27081, birkenfeld
                                     => 24326,
                            birkenhead
                                     => 12573, birkin   => 28669,
                            birla    => 18733, birmingham
                                     => 2136,
                            birth    => 1223, birthplace
                                     => 5272,
                            births   => 7138, biscay   => 13307, bisected => 18299, bisects  => 24219,
                            bisexual => 8220, bisexuality
                                     => 24953,
                            bishkek  => 25834, bishopric
                                     => 7807,
                            bishoprics
                                     => 23384, bishops  => 3171,
                            bismarck => 8278, bismuth  => 19856, bison    => 8420, bisons   => 17279,
                            bissau   => 12621, bistrica => 28365, bistrita => 25969, biswas   => 23909,
                            bitcoin  => 17554, bithynia => 25221, bitmap   => 23325, bitola   => 23104,
                            bitterly => 12457, bittern  => 27802, bitterns => 26594, bittorrent
                                     => 20958,
                            bitumen  => 18335, bituminous
                                     => 22580,
                            bivalve  => 18157, bivalves => 23507, biweekly => 22532, bizet    => 20350,
                            bizkit   => 28011, bjarne   => 27588, bjelke   => 25725, bjorn    => 9629,
                            blackadder
                                     => 20433, blackberry
                                     => 11025,
                            blackbirds
                                     => 29338, blackfoot
                                     => 18722,
                            blackfriars
                                     => 18359, blackhawk
                                     => 18641,
                            blackhawks
                                     => 10502, blackheath
                                     => 18367,
                            blackish => 9094, blacklist
                                     => 18369,
                            blacklisted
                                     => 17999, blackmails
                                     => 23072,
                            blackpool
                                     => 5960, blackrock
                                     => 17589,
                            blacks   => 4177, blacksburg
                                     => 29215,
                            blacksmith
                                     => 8587, blacksmiths
                                     => 20076,
                            blacktown
                                     => 26121, blackwall
                                     => 28585,
                            bladed   => 14064, blagoevgrad
                                     => 24483,
                            blagojevich
                                     => 24068, blamey   => 29334,
                            blantyre => 25304, blaster  => 15194, blasts   => 11974, blavatsky
                                     => 24094,
                            blazers  => 9789, blazon   => 12210, blended  => 8877, blending => 9767,
                            blends   => 11017, blenheim => 14050, blenny   => 21051, bleriot  => 23776,
                            bletchley
                                     => 17857, blige    => 17069,
                            bligh    => 15562, blighted => 24267, blistering
                                     => 21786,
                            blitz    => 8614, blitzkrieg
                                     => 22893,
                            bloc     => 5797, block    => 1167, blockade => 5742, blockaded
                                     => 18536,
                            blockading
                                     => 15223, blockbuster
                                     => 9652,
                            blockers => 19754, blockhouse
                                     => 18713,
                            blocks   => 2329, blocs    => 25038, bloemfontein
                                     => 17991,
                            blog     => 3743, blogger  => 10169, bloggers => 13140, blogging => 15822,
                            blogs    => 8007, blois    => 16664, blomfield
                                     => 29119,
                            bloodiest
                                     => 24717, bloodlines
                                     => 24654,
                            bloomberg
                                     => 8738, bloomington
                                     => 9874,
                            blooms   => 14182, bloomsburg
                                     => 24545,
                            bloomsbury
                                     => 14229, bloor    => 18175,
                            blotch   => 17974, blotches => 20200, blucher  => 20218, blue     => 589,
                            bluebird => 15566, bluefield
                                     => 29835,
                            bluegill => 28362, bluegrass
                                     => 8185,
                            blues    => 1844, bluestone
                                     => 23606,
                            bluesy   => 26930, bluetooth
                                     => 12052,
                            bluffs   => 11420, bluish   => 12822, blurring => 21614, blyth    => 12955,
                            blyton   => 29526, board    => 339, boarders => 14954, boardings
                                     => 24922,
                            boards   => 3062, boars    => 23116, boasted  => 9520, boasting => 15071,
                            boasts   => 7343, boaters  => 23239, boating  => 8340, boats    => 2186,
                            boatswain
                                     => 23445, boavista => 26880,
                            boban    => 29717, bobcats  => 12540, bobsledder
                                     => 22715,
                            bobsleigh
                                     => 16051, boccaccio
                                     => 24554,
                            bocelli  => 26043, bochum   => 14995, bodhisattva
                                     => 19405,
                            bodied   => 8262, bodies   => 1696, bodleian => 19810, bodmin   => 20018,
                            body     => 407, bodybuilder
                                     => 20485,
                            bodybuilding
                                     => 13746, bodywork => 13634,
                            boeing   => 4114, boeotia  => 28280, boers    => 16127, bofors   => 18545,
                            bogdanov => 29904, bogdanovich
                                     => 28834,
                            boggy    => 23003, bogie    => 15420, bogies   => 16123, bognor   => 29997,
                            bogor    => 28213, bogota   => 8768, bohdan   => 25781, boheme   => 17916,
                            bohemia  => 6279, bohemian => 6618, bohemians
                                     => 15904,
                            bohemond => 26155, bohol    => 18974, bohun    => 29591, boiler   => 6227,
                            boilermakers
                                     => 21390, boilers  => 7505,
                            boise    => 8648, boisterous
                                     => 26290,
                            bojan    => 24902, bolagh   => 19573, bold     => 3767, boldface => 22593,
                            boldklub => 25208, boldly   => 16691, boldness => 26463, bolero   => 21296,
                            boleslav => 25988, boleslaw => 11608, boletus  => 26438, boleyn   => 16335,
                            bolingbroke
                                     => 25142, bolivarian
                                     => 21044,
                            bolivia  => 4555, bolivian => 9074, bollywood
                                     => 5794,
                            bologna  => 5708, bolshevik
                                     => 8551,
                            bolsheviks
                                     => 9801, bolshevism
                                     => 25130,
                            bolshoi  => 17036, bolstered
                                     => 14942,
                            boltzmann
                                     => 17431, bolzano  => 21006,
                            bombarded
                                     => 11814, bombardment
                                     => 4386,
                            bombardments
                                     => 21381, bombastic
                                     => 27703,
                            bombay   => 4801, bomber   => 3728, bombers  => 3914, bombing  => 3113,
                            bombings => 7185, bombs    => 4134, bonaire  => 26094, bonanza  => 15227,
                            bonaventure
                                     => 15925, boneh    => 24494,
                            bonfires => 26487, boniface => 10590, bonito   => 25828, bonnaroo => 29925,
                            bonne    => 21671, bonsai   => 20240, bonus    => 2800, bonuses  => 10977,
                            booed    => 19890, book     => 212, bookings => 18161, booklet  => 7616,
                            booklist => 23696, bookmaker
                                     => 26922,
                            bookmakers
                                     => 23236, books    => 476,
                            bookseller
                                     => 14023, booksellers
                                     => 16045,
                            bookshop => 15394, boolean  => 12147, boomed   => 20813, boomers  => 21710,
                            booms    => 18972, boomtown => 24585, boosted  => 10272, boosting => 14080,
                            bootcamp => 24908, booting  => 26355, bootle   => 25200, bootleg  => 11901,
                            bootlegging
                                     => 28195, bootstrap
                                     => 24463,
                            borac    => 27242, boras    => 27801, borax    => 26452, border   => 872,
                            bordered => 4320, bordering
                                     => 7266,
                            borderland
                                     => 29803, borderlands
                                     => 21047,
                            boreal   => 13964, borehole => 26343, borgo    => 21244, borisov  => 23067,
                            born     => 80, borne    => 5894, borneo   => 6667, bornholm => 23741,
                            borno    => 28015, boron    => 12620, borough  => 1590, boroughs => 7243,
                            borromeo => 19234, borrower => 15669, borrowers
                                     => 15115,
                            borrowings
                                     => 21557, borrows  => 15487,
                            borussia => 11573, boscombe => 29279, bosna    => 29756, bosnia   => 3453,
                            bosniak  => 17138, bosniaks => 19576, bosnian  => 6104, boson    => 21017,
                            bosons   => 23853, bosphorus
                                     => 22485,
                            bossier  => 18481, boston   => 954, botafogo => 21376, botanic  => 10213,
                            botanical
                                     => 4976, botanist => 6684,
                            botanists
                                     => 16938, botany   => 6837,
                            botev    => 22492, both     => 88, botha    => 16845, botswana => 7540,
                            bottleneck
                                     => 16467, bottlenecks
                                     => 27629,
                            bottlenose
                                     => 26650, bottling => 14069,
                            bouchet  => 21746, bougainville
                                     => 14351,
                            bouillon => 25542, boulder  => 6556, boulders => 11321, boulevard
                                     => 3101,
                            boulevards
                                     => 18913, boulez   => 23508,
                            boulogne => 11456, boult    => 26911, boundaries
                                     => 2520,
                            boundary => 2030, bounded  => 4215, bounding => 22103, bourbons => 26449,
                            bourchier
                                     => 24385, bourgeoisie
                                     => 13811,
                            bourges  => 19229, bourgogne
                                     => 20471,
                            bournemouth
                                     => 8240, boutiques
                                     => 16306,
                            bouts    => 8890, bovine   => 17873, bowed    => 12852, bowery   => 15697,
                            bowl     => 1452, bowled   => 6829, bowlers  => 9787, bowls    => 6950,
                            boxer    => 4197, boxing   => 2884, boxset   => 24506, boyaca   => 28209,
                            boyar    => 25625, boyars   => 23666, boyband  => 28333, boycott  => 6497,
                            boycotted
                                     => 13466, boycotts => 20619,
                            boyhood  => 13972, boylston => 26724, "boys/girls"
                                     => 23620,
                            bozorg   => 26025, braathens
                                     => 25673,
                            brabant  => 10452, braced   => 13678, brachiopods
                                     => 29476,
                            bracket  => 8079, bracketed
                                     => 22057,
                            brackets => 8017, brackish => 13741, bracknell
                                     => 22898,
                            bracts   => 18105, bradenton
                                     => 22045,
                            bradman  => 12305, braganza => 18007, brahe    => 23537, brahma   => 10126,
                            brahman  => 12768, brahmana => 28135, brahmaputra
                                     => 18782,
                            brahmi   => 24132, brahmin  => 9428, brahmins => 11075, brahmo   => 24867,
                            brahms   => 11106, braille  => 10236, brainchild
                                     => 16403,
                            brainstem
                                     => 24083, braintree
                                     => 17652,
                            braking  => 8977, bramall  => 24237, bramley  => 23195, brampton => 11903,
                            branagh  => 26216, branca   => 22148, branched => 8440, branches => 2104,
                            branching
                                     => 8729, brand    => 1370,
                            branded  => 4392, brandeis => 13020, branding => 6231, brands   => 3474,
                            brandywine
                                     => 16812, braniff  => 22629,
                            branko   => 18139, brankovic
                                     => 27205,
                            brantford
                                     => 17682, braque   => 26149,
                            brasenose
                                     => 21942, brasil   => 8583,
                            brasileira
                                     => 26116, brasileiro
                                     => 13403,
                            brasilia => 13694, brasiliensis
                                     => 29209,
                            brasov   => 17115, bratislava
                                     => 8702,
                            brattleboro
                                     => 28914, braunfels
                                     => 29839,
                            braunschweig
                                     => 13291, bravery  => 6172,
                            braves   => 5389, brazil   => 1274, brazilian
                                     => 2035,
                            brazilians
                                     => 14317, brazos   => 18588,
                            brazzaville
                                     => 18212, breaches => 13198,
                            breaching
                                     => 16177, breads   => 20332,
                            breadth  => 10087, breakage => 23830, breakaway
                                     => 9089,
                            breakers => 10232, breakout => 9214, breakthrough
                                     => 4733,
                            breakwater
                                     => 16133, bream    => 19963,
                            breastfeeding
                                     => 16891, breaststroke
                                     => 8710,
                            breccia  => 29628, brechin  => 19729, brecker  => 29405, breckinridge
                                     => 15891,
                            brecon   => 15963, bred     => 5523, breda    => 12319, breech   => 12058,
                            breeches => 21240, breed    => 3404, breeder  => 11549, breeders => 7732,
                            breeding => 2796, breeds   => 5798, brega    => 28820, breguet  => 23221,
                            breisgau => 24555, bremen   => 6424, bremerhaven
                                     => 21591,
                            bremerton
                                     => 19331, brentano => 29634,
                            brentford
                                     => 9122, brentwood
                                     => 12424,
                            brera    => 26224, breslau  => 11459, brest    => 8264, bretagne => 22105,
                            brethren => 7705, bretton  => 21303, breuning => 14532, brevet   => 11849,
                            breviary => 29864, brevis   => 21650, brevity  => 20779, breweries
                                     => 10212,
                            brewers  => 7317, brewery  => 4437, brewing  => 6571, brezhnev => 16710,
                            briain   => 29894, briarcliff
                                     => 25520,
                            brick    => 2131, bricklayer
                                     => 27315,
                            brickwork
                                     => 15763, brickworks
                                     => 21844,
                            brickyard
                                     => 22049, bridge   => 522,
                            bridged  => 18174, bridgehead
                                     => 14020,
                            bridgend => 17797, bridgeport
                                     => 9657,
                            bridgestone
                                     => 22062, bridgetown
                                     => 22863,
                            bridging => 11828, bridgnorth
                                     => 26388,
                            bridgwater
                                     => 18520, bridle   => 18943,
                            bridlington
                                     => 25735, bridport => 25181,
                            brief    => 1756, briefly  => 1729, brienne  => 25714, brigade  => 1302,
                            brigades => 5508, brigadier
                                     => 4044,
                            brigands => 29117, brigantine
                                     => 27552,
                            brightly => 10274, brightness
                                     => 9655,
                            brighton => 3844, brigs    => 28976, brine    => 14309, brisbane => 2795,
                            bristles => 17927, bristol  => 2433, britain  => 857, britannia
                                     => 9018,
                            britannica
                                     => 12157, british  => 164,
                            briton   => 16493, britons  => 12167, britpop  => 24861, brixton  => 14396,
                            broad    => 1819, broadband
                                     => 6961,
                            broadcast
                                     => 838, broadcaster
                                     => 4622,
                            broadcasters
                                     => 6485, broadcasting
                                     => 1420,
                            broadcasts
                                     => 2998, broadened
                                     => 12232,
                            broadening
                                     => 16409, broader  => 4788,
                            broadest => 19198, broadleaf
                                     => 21312,
                            broadly  => 5710, broadmoor
                                     => 26113,
                            broadsheet
                                     => 19039, broadside
                                     => 13728,
                            broadsides
                                     => 25077, broadway => 2024,
                            brocade  => 27800, broch    => 24549, brockton => 23235, brockville
                                     => 26154,
                            broglie  => 25869, brokerage
                                     => 11857,
                            brokered => 15924, brome    => 23770, bromeliad
                                     => 28004,
                            bromide  => 15926, bromine  => 21068, brompton => 16708, bromsgrove
                                     => 23842,
                            bromwich => 9182, broncos  => 5388, brondby  => 19819, bronfman => 28398,
                            bronislaw
                                     => 26904, bronte   => 16629,
                            bronx    => 5620, bronze   => 1399, bronzes  => 15576, broodmare
                                     => 17076,
                            broods   => 24053, brookfield
                                     => 14164,
                            brookhaven
                                     => 19734, brookings
                                     => 16394,
                            brooklands
                                     => 19505, brooklyn => 2369,
                            brookville
                                     => 29355, brookwood
                                     => 24125,
                            "bros."  => 4563, brothels => 14398, brotherhood
                                     => 5440,
                            brothers => 868, broward  => 14984, brownian => 23859, brownish => 7590,
                            browns   => 4953, brownsville
                                     => 12234,
                            browser  => 6222, browsers => 11862, bruford  => 28784, bruges   => 12780,
                            brugge   => 16989, bruin    => 24853, bruins   => 6483, brumbies => 27745,
                            brunei   => 7681, brunel   => 14166, brunswick
                                     => 3155,
                            brussels => 3781, bruxelles
                                     => 20881,
                            bryansk  => 23897, brythonic
                                     => 28075,
                            bskyb    => 24557, bubblegum
                                     => 18563,
                            buble    => 25242, bubonic  => 24121, buccal   => 28913, buccaneer
                                     => 20796,
                            buccaneers
                                     => 7678, buccleuch
                                     => 29956,
                            bucculatrix
                                     => 27255, bucharest
                                     => 5592,
                            buchenwald
                                     => 21194, buckethead
                                     => 24956,
                            buckeye  => 15177, buckeyes => 12214, buckinghamshire
                                     => 7752,
                            buckskin => 29280, buckwheat
                                     => 20390,
                            bucuresti
                                     => 13145, budapest => 4533,
                            buddha   => 4696, buddhas  => 20114, buddhism => 4091, buddhist => 2853,
                            buddhists
                                     => 10733, budding  => 12538,
                            buddleja => 20016, budejovice
                                     => 21574,
                            budget   => 1561, budgetary
                                     => 13371,
                            budgeted => 17764, budgeting
                                     => 18914,
                            budgets  => 9237, budokan  => 25475, buducnost
                                     => 27376,
                            buenos   => 3464, buffalo  => 2413, buffaloes
                                     => 14866,
                            buffer   => 7099, buffering
                                     => 26448,
                            buffers  => 17095, buffett  => 14916, buffon   => 24866, buganda  => 23266,
                            bugatti  => 19350, bugle    => 12991, build    => 1050, builder  => 5156,
                            builders => 6323, building => 192, buildings
                                     => 579,
                            builds   => 6660, buildup  => 11317, built    => 176, bukhara  => 18874,
                            bukhari  => 20177, bukit    => 11297, bukovina => 19800, bulacan  => 17932,
                            bulawayo => 19822, bulbophyllum
                                     => 8251,
                            bulbous  => 18970, bulbul   => 22241, bulgakov => 29017, bulgaria => 2963,
                            bulgarian
                                     => 3009, bulgarians
                                     => 11018,
                            bulgars  => 24635, bulge    => 11869, bulk     => 3827, bulkeley => 27040,
                            bulkhead => 18441, bulkheads
                                     => 22329,
                            bulldogs => 5211, bulletins
                                     => 11882,
                            bullfighting
                                     => 24022, bullhead => 26308,
                            bullitt  => 24532, bullpen  => 12682, bulls    => 4876, bullseye => 21499,
                            bullying => 7256, bulwark  => 21592, bulwer   => 28574, bumblebee
                                     => 15989,
                            bunbury  => 17950, bundaberg
                                     => 22953,
                            bundesbahn
                                     => 26908, bundesliga
                                     => 5447,
                            bundesstrasse
                                     => 18864, bundestag
                                     => 14377,
                            bundeswehr
                                     => 16155, bundled  => 11242,
                            bundles  => 10749, bungalow => 11798, bungalows
                                     => 17530,
                            bunkers  => 12007, bunuel   => 23881, bunyan   => 20141, buoyancy => 14079,
                            buoyant  => 20017, buoyed   => 26183, buoys    => 20544, burdwan  => 27605,
                            bureau   => 1403, bureaucracy
                                     => 9676,
                            bureaucratic
                                     => 11123, bureaus  => 14946,
                            buren    => 10563, burgas   => 18253, burgenland
                                     => 25700,
                            burgeoning
                                     => 11275, burgesses
                                     => 18769,
                            burgh    => 10125, burghers => 21341, burghley => 25015, burghs   => 16576,
                            burgundian
                                     => 16262, burgundians
                                     => 29302,
                            burgundy => 7352, burial   => 3291, burials  => 8140, buried   => 1262,
                            burkina  => 7968, burkinabe
                                     => 28450,
                            burlesque
                                     => 11150, burlington
                                     => 5979,
                            burmese  => 5855, burnaby  => 15990, burne    => 23755, burnet   => 14742,
                            burnie   => 20817, burra    => 27430, burrard  => 29681, burrowing
                                     => 16442,
                            bursa    => 16061, bursaries
                                     => 28366,
                            bursary  => 24450, burslem  => 23318, bursts   => 10176, burundi  => 10172,
                            burwood  => 24188, busan    => 11044, buses    => 2592, bushehr  => 19061,
                            bushels  => 27115, bushfire => 24771, bushfires
                                     => 21872,
                            bushido  => 23725, bushland => 21945, bushwick => 29107, busiest  => 7376,
                            business => 272, businesses
                                     => 1740,
                            businessman
                                     => 2632, businessmen
                                     => 6755,
                            businesspeople
                                     => 27595,
                            businessperson
                                     => 23309,
                            businessweek
                                     => 19585, busing   => 26516,
                            buskerud => 26951, busoni   => 24522, busta    => 20245, busters  => 18437,
                            bustling => 17285, busway   => 20221, butte    => 9185, butterfly
                                     => 3592,
                            buttes   => 26628, buttress => 19605, buttresses
                                     => 13683,
                            butyl    => 29097, buyout   => 11843, buzau    => 29770, buzzcocks
                                     => 25616,
                            by       => 11, bycatch  => 29291, bydgoszcz
                                     => 11932,
                            bygone   => 28069, bylaw    => 29315, bypass   => 4448, bypassed => 10372,
                            bypasses => 15348, bypassing
                                     => 11717,
                            byproduct
                                     => 17723, byproducts
                                     => 24117,
                            byrds    => 14463, bystrica => 18607, bytes    => 10203, bytow    => 24677,
                            byung    => 26842, byway    => 14817, byzantine
                                     => 3064,
                            byzantines
                                     => 10137, byzantium
                                     => 12039,
                            caballeros
                                     => 27955, cabaret  => 7631,
                            cabildo  => 24965, cabinet  => 1768, cabins   => 8449, cable    => 1852,
                            cables   => 6138, cablevision
                                     => 21008,
                            cabling  => 24179, cabrillo => 29240, cabriolet
                                     => 24423,
                            cacao    => 20282, cache    => 7102, caches   => 17499, caching  => 23005,
                            cacique  => 28371, cacti    => 20040, cadastral
                                     => 19610,
                            cadbury  => 14296, caddo    => 17195, cadence  => 14431, cadet    => 4929,
                            cadets   => 5706, cadfael  => 28678, cadre    => 11334, cadres   => 15091,
                            caernarfon
                                     => 22610, caerphilly
                                     => 24593,
                            caesarea => 15748, caesarean
                                     => 27692,
                            caesars  => 16791, caesium  => 19999, caetano  => 18671, cafes    => 8790,
                            caffe    => 26014, cagayan  => 15121, cagliari => 13377, cahiers  => 29145,
                            caicos   => 18025, cairn    => 12784, cairo    => 4398, caithness
                                     => 16575,
                            caius    => 18192, cajon    => 23621, calabar  => 25324, calabria => 10313,
                            calais   => 8459, calamities
                                     => 27281,
                            calatrava
                                     => 26072, calaveras
                                     => 27425,
                            calcareous
                                     => 14865, calcio   => 10704,
                            calcite  => 18973, calcium  => 5223, calculate
                                     => 7202,
                            calculated
                                     => 4023, calculates
                                     => 18180,
                            calculation
                                     => 6506, calculations
                                     => 6632,
                            calculators
                                     => 16483, calculus => 7384,
                            calcutta => 5304, caldas   => 18924, caledon  => 24574, caledonia
                                     => 7596,
                            caledonian
                                     => 9389, calendar => 2645,
                            calendars
                                     => 12557, calgary  => 3736,
                            caliban  => 28207, calibers => 23864, calibration
                                     => 12490,
                            calibre  => 11137, calicut  => 15058, caliente => 23148, "calif." => 25484,
                            california
                                     => 324, californian
                                     => 12778,
                            californians
                                     => 26212, californica
                                     => 24982,
                            caligula => 18375, calinescu
                                     => 26687,
                            calipers => 29637, caliph   => 8164, caliphate
                                     => 9819,
                            caliphs  => 22108, callao   => 19367, called   => 116, calligrapher
                                     => 24007,
                            calligraphic
                                     => 29328, calligraphy
                                     => 11676,
                            calliope => 27548, calliostoma
                                     => 23703,
                            callisto => 25987, callsign => 11647, callum   => 14043, callus   => 24846,
                            caloptilia
                                     => 25364, caloric  => 27660,
                            caltech  => 14936, caltrans => 28503, calum    => 28663, calumet  => 14616,
                            calvados => 18804, calvary  => 11356, calvinism
                                     => 18872,
                            calvinist
                                     => 12754, calvinistic
                                     => 28228,
                            calvinists
                                     => 24118, calypso  => 13033,
                            calyx    => 19274, camarines
                                     => 23062,
                            camas    => 27927, camber   => 18707, camberley
                                     => 24920,
                            camberwell
                                     => 16317, cambodia => 4940,
                            cambodian
                                     => 8760, cambrai  => 15799,
                            cambria  => 13379, cambrian => 9970, cambridge
                                     => 1574,
                            cambridgeshire
                                     => 8746, camden   => 5590,
                            camels   => 11928, cameo    => 5195, cameos   => 13502, camerata => 27811,
                            cameroon => 5444, cameroonian
                                     => 15983,
                            camillus => 28408, camino   => 12702, cammell  => 26317, camogie  => 12396,
                            camorra  => 26417, camouflage
                                     => 9231,
                            camouflaged
                                     => 19806, camp     => 811,
                            campaign => 509, campaigned
                                     => 6018,
                            campaigner
                                     => 13082, campaigners
                                     => 18942,
                            campaigning
                                     => 6799, campaigns
                                     => 2614,
                            campania => 13528, campanian
                                     => 25416,
                            campanile
                                     => 25619, campbells
                                     => 29780,
                            campbelltown
                                     => 22694, campeche => 19508,
                            campeonato
                                     => 7959, camperdown
                                     => 26236,
                            campground
                                     => 11226, campgrounds
                                     => 18656,
                            camphor  => 26126, campinas => 24336, camps    => 2782, campsites
                                     => 14989,
                            campus   => 843, campuses => 4607, campy    => 28965, camshaft => 16012,
                            camshafts
                                     => 29371, camus    => 18316,
                            canaan   => 11991, canaanite
                                     => 21206,
                            canada   => 360, canadensis
                                     => 22821,
                            canadian => 475, canadians
                                     => 6101,
                            canadiens
                                     => 7581, canal    => 1492,
                            "canal+" => 22314, canals   => 6456, canandaigua
                                     => 26789,
                            canara   => 25522, canaria  => 21221, canarian => 28226, canary   => 7189,
                            canaveral
                                     => 17256, canberra => 5231,
                            cancellation
                                     => 5891, cancelled
                                     => 2959,
                            cancer   => 1333, cancerous
                                     => 19681,
                            cancers  => 9485, cancion  => 28385, candidacy
                                     => 6652,
                            candidate
                                     => 1090, candidates
                                     => 1619,
                            candidature
                                     => 21675, candide  => 25653,
                            candido  => 18225, canis    => 15626, canisius => 26929, cannabinoid
                                     => 27823,
                            cannabis => 7604, cannes   => 5750, cannibalism
                                     => 15145,
                            cannock  => 27645, cannonball
                                     => 14191,
                            cannons  => 7016, canoe    => 5933, canoeing => 10310, canoeist => 18193,
                            canoer   => 12468, canoes   => 11547, canon    => 3500, canonical
                                     => 6686,
                            canonically
                                     => 28205, canonization
                                     => 17461,
                            canonized
                                     => 15193, canons   => 8101,
                            canopies => 19349, canopus  => 26804, canopy   => 6930, cantabria
                                     => 17788,
                            cantabrian
                                     => 26466, cantata  => 10605,
                            cantatas => 16459, canteen  => 12813, canterbury
                                     => 3770,
                            cantilever
                                     => 12663, cantilevered
                                     => 24352,
                            canton   => 3051, cantonal => 14081, cantonese
                                     => 8528,
                            cantonment
                                     => 12799, cantons  => 10101,
                            cantus   => 27970, canucks  => 8866, canute   => 23134, canvas   => 5741,
                            canvases => 14619, canwest  => 25822, canyon   => 3219, canyons  => 12497,
                            capabilities
                                     => 3628, capability
                                     => 3988,
                            capablanca
                                     => 28533, capacitance
                                     => 14433,
                            capacities
                                     => 7706, capacitive
                                     => 24184,
                            capacitor
                                     => 11877, capacitors
                                     => 12428,
                            capacity => 1037, capcom   => 11441, cape     => 1505, capensis => 27516,
                            capes    => 18947, capillary
                                     => 15116,
                            capistrano
                                     => 25703, capita   => 2546,
                            capital  => 482, capitalisation
                                     => 29296,
                            capitalise
                                     => 23609, capitalism
                                     => 6415,
                            capitalist
                                     => 7401, capitalists
                                     => 15949,
                            capitalization
                                     => 14774,
                            capitalized
                                     => 13842, capitalizing
                                     => 24332,
                            capitals => 5913, capitol  => 3726, capitulated
                                     => 17416,
                            capitulation
                                     => 12436, capoeira => 23199,
                            cappadocia
                                     => 18765, capped   => 5422,
                            cappella => 9407, capping  => 18382, caproni  => 26441, caps     => 3826,
                            capsid   => 29164, capsized => 15947, capstone => 22230, capsule  => 7300,
                            captain  => 670, captaincy
                                     => 9920,
                            captained
                                     => 5738, captaining
                                     => 16147,
                            captains => 6336, caption  => 14517, captions => 20324, captives => 9008,
                            captivity
                                     => 6166, captors  => 14479,
                            capture  => 1809, captured => 1126, captures => 7744, capturing
                                     => 4633,
                            capua    => 17666, capuchin => 16834, carabidae
                                     => 14999,
                            carabinieri
                                     => 28421, caracalla
                                     => 27237,
                            caracas  => 8558, caracol  => 25294, caragiale
                                     => 23287,
                            carapace => 16667, caravan  => 8006, caravans => 16869, carbide  => 14391,
                            carbine  => 13887, carbines => 23641, carbohydrate
                                     => 14384,
                            carbohydrates
                                     => 14336, carbon   => 2142,
                            carbonate
                                     => 9262, carbonated
                                     => 21385,
                            carbonates
                                     => 27005, carbondale
                                     => 19458,
                            carbonic => 29173, carboniferous
                                     => 12327,
                            carbons  => 26796, carbonyl => 15303, carboxylic
                                     => 19181,
                            carburetors
                                     => 25194, carburettor
                                     => 26570,
                            carcasses
                                     => 18688, carcassonne
                                     => 24513,
                            carcinogen
                                     => 27178, carcinogenic
                                     => 21396,
                            carcinoma
                                     => 12330, cardamom => 24998,
                            cardiff  => 3721, cardinal => 2767, cardinalate
                                     => 25543,
                            cardinality
                                     => 21394, cardinals
                                     => 3364,
                            cardiomyopathy
                                     => 24428,
                            cardiovascular
                                     => 8600, career   => 119,
                            careers  => 4024, caregivers
                                     => 16657,
                            carell   => 22895, carers   => 24319, caretaker
                                     => 7412,
                            caretakers
                                     => 22041, carex    => 20195,
                            cargo    => 2460, cargoes  => 17872, carib    => 25562, caribbean
                                     => 2478,
                            caribe   => 27812, cariboo  => 20464, caricature
                                     => 13682,
                            caricatures
                                     => 15609, caricom  => 25708,
                            carillon => 17150, carinae  => 16110, carinthia
                                     => 13839,
                            carinthian
                                     => 28929, carioca  => 25226,
                            carling  => 19707, carlist  => 15917, carlito  => 26806, carlsbad => 18894,
                            carlsberg
                                     => 21138, carlsson => 20575,
                            carmarthen
                                     => 15692, carmarthenshire
                                     => 16802,
                            carmelite
                                     => 15817, carmelites
                                     => 22442,
                            carnarvon
                                     => 20848, carnatic => 11468,
                            carnation
                                     => 19126, carnaval => 21545,
                            carne    => 20233, carnegie => 4205, carniola => 10463, carnivals
                                     => 20419,
                            carnivores
                                     => 18083, carnivorous
                                     => 11926,
                            carnot   => 22324, carolinas
                                     => 14574,
                            carolingian
                                     => 13144, carotene => 28682,
                            carpark  => 25675, carpathian
                                     => 13910,
                            carpathians
                                     => 17966, carpets  => 10991,
                            carpi    => 23570, carre    => 17571, carrefour
                                     => 24862,
                            carriages
                                     => 7184, carriageway
                                     => 10596,
                            carrickfergus
                                     => 24984, carried  => 864,
                            carriers => 4105, carries  => 2878, carrollton
                                     => 16837,
                            cars     => 1073, cartan   => 24283, cartels  => 18433, carteret => 20977,
                            cartesian
                                     => 12164, carthage => 8472,
                            carthaginian
                                     => 14843, carthaginians
                                     => 19401,
                            carthusian
                                     => 27487, cartilage
                                     => 12290,
                            cartilaginous
                                     => 28112, cartographer
                                     => 17067,
                            cartographers
                                     => 20047, cartographic
                                     => 24672,
                            cartography
                                     => 18159, cartoon  => 3533,
                            cartooning
                                     => 23866, cartoonist
                                     => 7348,
                            cartoonists
                                     => 14545, cartoons => 5082,
                            cartridge
                                     => 5636, cartridges
                                     => 8336,
                            carts    => 11684, carved   => 3619, carvings => 9109, casal    => 28985,
                            casals   => 25243, cascades => 11343, cascading
                                     => 20711,
                            casco    => 21036, casemate => 25453, casemates
                                     => 18661,
                            casement => 19601, cases    => 796, cashel   => 17588, cashew   => 22220,
                            casimir  => 9876, casks    => 25239, caspase  => 26311, caspian  => 9751,
                            cassation
                                     => 24892, cassava  => 13181,
                            cassavetes
                                     => 29002, cassette => 6140,
                            cassettes
                                     => 14434, cassia   => 22672,
                            cassini  => 16858, cassino  => 18987, cast     => 859, castaway => 26495,
                            castaways
                                     => 26178, caste    => 5476,
                            castel   => 14525, castellan
                                     => 22364,
                            castelo  => 18191, castes   => 9308, castile  => 5771, castilian
                                     => 12288,
                            casting  => 3703, castings => 17246, castle   => 736, castleford
                                     => 13635,
                            castlemaine
                                     => 24612, castlereagh
                                     => 23945,
                            castles  => 5983, castleton
                                     => 20955,
                            castletown
                                     => 24767, castra   => 25645,
                            castration
                                     => 23087, castrum  => 25213,
                            casts    => 9416, casualties
                                     => 3019,
                            casualty => 7694, catalans => 19716, catalog  => 5014, cataloged
                                     => 26631,
                            catalogue
                                     => 4676, catalogued
                                     => 15839,
                            catalonia
                                     => 6540, catalunya
                                     => 13985,
                            catalyses
                                     => 16992, catalysis
                                     => 16501,
                            catalyst => 6498, catalysts
                                     => 13216,
                            catalytic
                                     => 9370, catalyze => 21147,
                            catalyzed
                                     => 15036, catalyzes
                                     => 10799,
                            catamaran
                                     => 22368, catamarca
                                     => 27670,
                            catapulted
                                     => 21842, catapults
                                     => 26946,
                            cataract => 17400, catastrophes
                                     => 29079,
                            catastrophic
                                     => 9189, catawba  => 18252,
                            catcher  => 6258, catchers => 17730, catchment
                                     => 7773,
                            catchphrase
                                     => 13658, catchphrases
                                     => 27518,
                            catechism
                                     => 13153, categorical
                                     => 16964,
                            categories
                                     => 2345, categorised
                                     => 16026,
                            categorization
                                     => 16287,
                            categorize
                                     => 19517, categorized
                                     => 7288,
                            category => 1395, catenary => 24395, caterham => 21271, caterpillar
                                     => 11235,
                            caterpillars
                                     => 13772, caters   => 10879,
                            catfish  => 9406, cathal   => 21182, catharina
                                     => 21279,
                            catharines
                                     => 16852, cathay   => 20724,
                            cathedral
                                     => 1544, cathedrals
                                     => 11071,
                            cathode  => 11694, catholic => 609, catholicism
                                     => 5618,
                            catholicos
                                     => 17793, catholics
                                     => 3836,
                            catholique
                                     => 25262, cation   => 15204,
                            cationic => 29935, cations  => 18365, catocala => 27648, catolica => 18480,
                            catshark => 25559, catskill => 16631, cattaraugus
                                     => 28394,
                            cattle   => 2568, catullus => 28034, cauca    => 21097, caucasians
                                     => 27697,
                            caucasus => 6343, cauchy   => 15173, caucus   => 6305, caucuses => 17352,
                            caudal   => 12011, causa    => 14895, causal   => 10054, causality
                                     => 17309,
                            causation
                                     => 17523, causative
                                     => 17252,
                            caused   => 759, causes   => 1648, causeway => 8477, causing  => 1739,
                            caustic  => 18672, cautioned
                                     => 16907,
                            cautions => 19093, cavaliers
                                     => 9644,
                            cavalli  => 25880, cavalry  => 2018, cavalrymen
                                     => 20905,
                            cavan    => 12846, cavendish
                                     => 9292,
                            cavernous
                                     => 29655, caverns  => 14095,
                            caversham
                                     => 27984, caves    => 4614,
                            cavite   => 13046, cavities => 13089, cavity   => 6482, cavour   => 28272,
                            caxias   => 27809, caxton   => 25489, cayley   => 19127, cayuga   => 16454,
                            "cd/dvd" => 20279, ceara    => 19299, ceased   => 2560, ceasefire
                                     => 8974,
                            ceasing  => 16165, ceausescu
                                     => 17312,
                            cebuano  => 24753, cedar    => 4508, ceded    => 7187, ceding   => 22682,
                            ceilings => 9672, celebi   => 28053, celebrated
                                     => 2074,
                            celebrates
                                     => 8048, celebrations
                                     => 4380,
                            celebrities
                                     => 4619, celebrity
                                     => 3471,
                            celestial
                                     => 7190, celje    => 20069,
                            cellars  => 13849, celle    => 18035, cellist  => 11129, cello    => 6665,
                            cellos   => 26782, cells    => 1314, cellular => 4852, celluloid
                                     => 23055,
                            cellulose
                                     => 12388, celsius  => 11311,
                            celta    => 22332, celtic   => 3112, celtics  => 8426, celts    => 14700,
                            cement   => 5019, cemented => 11048, cementing
                                     => 21826,
                            cements  => 27766, cemeteries
                                     => 6507,
                            cemetery => 1306, cenel    => 23029, cenotaph => 19399, cenozoic => 20791,
                            censor   => 10642, censored => 10327, censoring
                                     => 28509,
                            censors  => 13370, censorship
                                     => 5550,
                            census   => 374, censuses => 12162, cent     => 3590, centaur  => 13912,
                            centauri => 15051, centaurs => 28014, centaurus
                                     => 29149,
                            centenary
                                     => 6870, centennial
                                     => 5885,
                            center   => 239, centered => 3361, centering
                                     => 15166,
                            centerline
                                     => 21025, centerpiece
                                     => 11761,
                            centers  => 2020, centerville
                                     => 19259,
                            centimeters
                                     => 6567, centimetres
                                     => 13104,
                            centipede
                                     => 25078, central  => 219,
                            centrale => 18496, centralia
                                     => 24787,
                            centralised
                                     => 15661, centrality
                                     => 22035,
                            centralization
                                     => 21227,
                            centralized
                                     => 8037, centrally
                                     => 8942,
                            centre   => 417, centred  => 6051, centrepiece
                                     => 20010,
                            centres  => 3106, centreville
                                     => 25267,
                            centric  => 11545, centrifugal
                                     => 13860,
                            centrifuge
                                     => 24778, centrist => 13901,
                            centro   => 7770, centrum  => 19934, centuries
                                     => 1464,
                            centurion
                                     => 13996, centurions
                                     => 20986,
                            century  => 154, cephalopod
                                     => 27319,
                            cephalopods
                                     => 18679, cerambycidae
                                     => 5949,
                            ceramic  => 6165, ceramics => 6844, cerberus => 17578, cercle   => 13993,
                            cereals  => 12440, cerebellar
                                     => 21405,
                            cerebral => 7342, cerebrospinal
                                     => 25138,
                            ceredigion
                                     => 19172, ceremonial
                                     => 4927,
                            ceremonially
                                     => 26012, ceremonies
                                     => 4038,
                            ceres    => 14413, cerevisiae
                                     => 23955,
                            cerrado  => 29544, cerro    => 9174, certain  => 748, certificate
                                     => 3157,
                            certificates
                                     => 6902, certification
                                     => 3849,
                            certifications
                                     => 11451,
                            certified
                                     => 2515, certifies
                                     => 29964,
                            certify  => 17594, certifying
                                     => 14883,
                            certiorari
                                     => 19228, cervical => 10296,
                            cesare   => 11000, ceske    => 19586, cessation
                                     => 10676,
                            cession  => 16973, cetaceans
                                     => 21586,
                            cetinje  => 25884, ceuta    => 19641, ceylon   => 6296, ceylonese
                                     => 29554,
                            cezanne  => 18036, "ch'uan" => 26943, chabad   => 15021, chaco    => 14579,
                            chadian  => 18800, chagall  => 24100, chagatai => 27455, chagos   => 28379,
                            chagrin  => 15428, chahar   => 17180, chaharmahal
                                     => 20894,
                            chaim    => 12582, chain    => 1624, chaining => 26732, chains   => 4279,
                            chaired  => 4540, chairing => 20578, chairlift
                                     => 24181,
                            chairman => 813, chairmanship
                                     => 11094,
                            chairmen => 12709, chairperson
                                     => 7918,
                            chairwoman
                                     => 15304, chaitanya
                                     => 21052,
                            chakra   => 14120, chakraborty
                                     => 17883,
                            chalcedon
                                     => 21039, chaldean => 17343,
                            chalice  => 16031, chalky   => 29751, challenge
                                     => 1351,
                            challenged
                                     => 3275, challenger
                                     => 4810,
                            challengers
                                     => 11509, challenges
                                     => 2891,
                            challenging
                                     => 4329, chalon   => 26974,
                            chalukya => 20969, chalukyas
                                     => 23590,
                            chamber  => 1630, chambered
                                     => 12613,
                            chambersburg
                                     => 26009, chambre  => 22255,
                            chameleon
                                     => 13353, chamonix => 29054,
                            champaign
                                     => 10235, champion => 886,
                            championed
                                     => 9746, championing
                                     => 20430,
                            championnat
                                     => 15069, champions
                                     => 1170,
                            championship
                                     => 293, championships
                                     => 580,
                            champlain
                                     => 11232, champs   => 11998,
                            chancel  => 6020, chancellery
                                     => 18100,
                            chancellor
                                     => 2657, chancellors
                                     => 14927,
                            chancellorsville
                                     => 22099,
                            chancery => 10755, chand    => 12342, chandan  => 23518, chandigarh
                                     => 13202,
                            chandos  => 20966, chandragupta
                                     => 25549,
                            chandran => 26704, chandrasekhar
                                     => 24507,
                            "chang'an"
                                     => 10624, changchun
                                     => 19457,
                            changeable
                                     => 28051, changeover
                                     => 23212,
                            changer  => 22470, changers => 29311, changes  => 725, changeup => 27997,
                            changi   => 19443, changsha => 16894, chania   => 27469, channel  => 592,
                            channels => 2293, chanson  => 18742, chansons => 22376, chanted  => 15263,
                            chanter  => 28723, chantilly
                                     => 18577,
                            chantry  => 21487, chants   => 11616, chaotic  => 8686, chaparral
                                     => 14872,
                            chapel   => 1567, chapelle => 13639, chapels  => 8460, chaplain => 5531,
                            chaplaincy
                                     => 22967, chaplains
                                     => 12856,
                            chapter  => 1702, chapters => 3236, chapultepec
                                     => 27554,
                            character
                                     => 424, characterisation
                                     => 17028,
                            characterise
                                     => 26472, characterised
                                     => 6303,
                            characteristic
                                     => 2830, characteristically
                                     => 14394,
                            characteristics
                                     => 2112,
                            characterization
                                     => 8337,
                            characterizations
                                     => 21983,
                            characterize
                                     => 10420, characterized
                                     => 2476,
                            characterizes
                                     => 13686, characterizing
                                     => 17187,
                            characters
                                     => 676, charadriiformesfamily
                                     => 16006,
                            charan   => 17043, charaxes => 25892, charcoal => 8741, charcot  => 22508,
                            charente => 15341, charentes
                                     => 26549,
                            charged  => 1882, chargers => 7049, charing  => 15256, chariots => 15318,
                            charismatic
                                     => 8950, charitable
                                     => 4075,
                            charities
                                     => 5614, charlemagne
                                     => 9333,
                            charleroi
                                     => 16275, charleston
                                     => 4220,
                            charlestown
                                     => 14326, charleville
                                     => 26353,
                            charlevoix
                                     => 26645, charlottenburg
                                     => 24452,
                            charlottesville
                                     => 13450,
                            charlottetown
                                     => 16005, charly   => 21019,
                            chart    => 760, charted  => 4473, charter  => 1950, chartered
                                     => 4612,
                            charterhouse
                                     => 15520, charteris
                                     => 24191,
                            charters => 8669, charting => 6386, chartres => 16420, charts   => 1778,
                            chasers  => 18941, chasseurs
                                     => 21830,
                            chassis  => 4441, chastised
                                     => 28919,
                            chateau  => 4553, chateaux => 27738, chatelet => 24196, chatillon
                                     => 23167,
                            chatsworth
                                     => 17879, chattahoochee
                                     => 19480,
                            chattanooga
                                     => 8455, chatterjee
                                     => 13905,
                            chaucer  => 13850, chaudhary
                                     => 19245,
                            chaumont => 28438, chautauqua
                                     => 16212,
                            chauvel  => 28413, chavo    => 25067, cheaply  => 15852, chechen  => 10506,
                            chechens => 23299, chechnya => 13666, checkerboard
                                     => 29463,
                            checkpoints
                                     => 14188, checksum => 27961,
                            cheeked  => 28129, cheeses  => 15585, cheetahs => 18304, cheil    => 19178,
                            chekhov  => 14760, chelan   => 29721, chelm    => 19986, chelmno  => 27601,
                            chelmsford
                                     => 12168, cheltenham
                                     => 6936,
                            chelyabinsk
                                     => 19115, chemical => 1581,
                            chemically
                                     => 11185, chemicals
                                     => 4818,
                            chemin   => 18825, chemins  => 25329, chemist  => 6532, chemistry
                                     => 2394,
                            chemists => 13640, chemnitz => 19781, chemotherapy
                                     => 9857,
                            chenango => 27618, chenar   => 24510, chengde  => 27114, chengdu  => 11145,
                            chennai  => 4636, chepstow => 24235, chequered
                                     => 26323,
                            chera    => 25286, cherbourg
                                     => 14601,
                            chernihiv
                                     => 28791, chernivtsi
                                     => 28912,
                            chernobyl
                                     => 14965, cherokee => 5182,
                            cherokees
                                     => 25763, chert    => 23840,
                            chertsey => 24411, cherwell => 27416, chesapeake
                                     => 7361,
                            chesham  => 22748, cheshire => 5259, cheshmeh => 12562, chess    => 2731,
                            chesterfield
                                     => 8137, chetnik  => 20424,
                            chetniks => 18995, chetwynd => 29048, chevrolet
                                     => 5861,
                            chevrons => 25472, chhattisgarh
                                     => 14178,
                            chiapas  => 12127, chiara   => 22270, chiba    => 10587, chicago  => 651,
                            chicagoland
                                     => 29498, chicane  => 21512,
                            chichester
                                     => 8674, chickamauga
                                     => 18109,
                            chickasaw
                                     => 14798, chidambaram
                                     => 21072,
                            chief    => 413, chiefdom => 24344, chiefdoms
                                     => 29378,
                            chiefly  => 5719, chiefs   => 3301, chieftain
                                     => 10413,
                            chieftains
                                     => 12655, chievo   => 21622,
                            chihuahua
                                     => 10774, chikara  => 19335,
                            childcare
                                     => 16496, childe   => 26798,
                            childhood
                                     => 2065, childless
                                     => 9796,
                            children => 202, chile    => 2453, chilean  => 4340, chileans => 24634,
                            chillicothe
                                     => 22684, chilliwack
                                     => 23381,
                            chiloe   => 26857, chiltern => 16168, chimneys => 11028, chimpanzees
                                     => 14663,
                            china    => 461, chine    => 28527, chinensis
                                     => 27624,
                            chinese  => 526, chinna   => 25964, chinook  => 13510, chios    => 21007,
                            chipmunks
                                     => 19160, chippenham
                                     => 21766,
                            chippewa => 12332, chipset  => 17768, chipsets => 24213, chirac   => 17967,
                            chiral   => 14112, chiranjeevi
                                     => 29255,
                            chiron   => 26022, chiropractic
                                     => 15199,
                            chishti  => 28201, chisinau => 14417, chiswick => 18254, chita    => 23789,
                            chitra   => 21992, chitral  => 24594, chittagong
                                     => 11114,
                            chivalric
                                     => 25073, chivas   => 18135,
                            chiyoda  => 29866, chloride => 6811, chlorides
                                     => 29543,
                            chlorinated
                                     => 29505, chlorine => 10790,
                            chlorophyll
                                     => 19051, chloroplast
                                     => 25603,
                            chloroplasts
                                     => 24014, choctaw  => 11345,
                            choir    => 2596, choirmaster
                                     => 24772,
                            choirs   => 8827, choiseul => 29353, chojnice => 27122, chola    => 9633,
                            cholas   => 19688, cholera  => 9466, choline  => 28376, cholmondeley
                                     => 26623,
                            chomsky  => 13668, chongqing
                                     => 11184,
                            chopin   => 9754, chopra   => 10962, choral   => 5674, chorale  => 11128,
                            chord    => 5533, chords   => 7597, choreographed
                                     => 8714,
                            choreographer
                                     => 7478, choreographers
                                     => 17288,
                            choreographic
                                     => 26722, choreography
                                     => 7682,
                            chorister
                                     => 27908, choristers
                                     => 23920,
                            chorley  => 16942, chorus   => 3197, choruses => 13175, chosen   => 1278,
                            choshu   => 29749, chota    => 29312, chowk    => 18594, chrissie => 20268,
                            christchurch
                                     => 6153, christendom
                                     => 20023,
                            christened
                                     => 10427, christgau
                                     => 15718,
                            christiaan
                                     => 22009, christiania
                                     => 17119,
                            christianity
                                     => 2675, christianization
                                     => 21764,
                            christianized
                                     => 28463, christians
                                     => 2847,
                            christology
                                     => 28511, christoph
                                     => 9384,
                            christophe
                                     => 10910, christos => 19878,
                            christus => 29859, chroma   => 22912, chromatic
                                     => 11080,
                            chromatin
                                     => 18387, chromatography
                                     => 15070,
                            chrome   => 7829, chromosomal
                                     => 16329,
                            chromosome
                                     => 6503, chromosomes
                                     => 9590,
                            chronic  => 4543, chronicle
                                     => 3627,
                            chronicled
                                     => 12225, chronicler
                                     => 11435,
                            chroniclers
                                     => 18136, chronicles
                                     => 4949,
                            chronicling
                                     => 16440, chronicon
                                     => 24289,
                            chrono   => 23050, chronological
                                     => 7572,
                            chronologically
                                     => 13761,
                            chronology
                                     => 8189, chrysalis
                                     => 18169,
                            chrysanthemum
                                     => 25940, chrysler => 6620,
                            chrysostom
                                     => 22120, chuan    => 11909,
                            chukchi  => 25833, chula    => 24015, chulalongkorn
                                     => 21890,
                            church   => 147, churches => 1463, churchmen
                                     => 27146,
                            churchyard
                                     => 7459, chuvash  => 23919,
                            ciaran   => 18635, cibernetico
                                     => 25230,
                            cicada   => 29169, cicero   => 8916, cichlid  => 19956, cichlids => 27470,
                            cidade   => 26653, ciechanow
                                     => 27229,
                            cielo    => 19820, ciencias => 27575, cieszyn  => 16227, cilia    => 16543,
                            cilicia  => 15148, cilla    => 25462, cimarron => 19792, cincinnati
                                     => 2749,
                            cinder   => 16914, cinema   => 2079, cinemas  => 7217, cinemascope
                                     => 25758,
                            cinematic
                                     => 8211, cinematographer
                                     => 8029,
                            cinematographers
                                     => 21760,
                            cinematography
                                     => 7537, cineplex => 28022,
                            cinta    => 23722, cipher   => 10046, ciphers  => 19571, ciphertext
                                     => 23556,
                            circa    => 5050, circadian
                                     => 16794,
                            circassian
                                     => 20563, circassians
                                     => 25063,
                            circe    => 21235, circle   => 1821, circuit  => 1488, circuitous
                                     => 29831,
                            circuitry
                                     => 13674, circuits => 5174,
                            circular => 3238, circulated
                                     => 6689,
                            circulates
                                     => 27370, circulating
                                     => 8689,
                            circulation
                                     => 3234, circumnavigation
                                     => 18760,
                            circumpolar
                                     => 29329, circumscribed
                                     => 19445,
                            circumscription
                                     => 28707,
                            circumvent
                                     => 15272, circumvented
                                     => 28984,
                            circuses => 22150, cirencester
                                     => 21211,
                            cirrus   => 18532, cistercian
                                     => 11959,
                            cistercians
                                     => 28416, cistern  => 19712,
                            cisterns => 23402, citadel  => 6428, citation => 4292, citations
                                     => 7370,
                            cited    => 2200, cites    => 6167, citibank => 20427, cities   => 782,
                            citigroup
                                     => 18978, citing   => 3348,
                            citizen  => 2597, citizenry
                                     => 19642,
                            citizens => 1327, citizenship
                                     => 3399,
                            citrate  => 23965, citric   => 24478, citroen  => 10664, citrus   => 7762,
                            citta    => 16768, city     => 54, cityscape
                                     => 19384,
                            citytv   => 27121, ciudad   => 8233, civet    => 27537, civic    => 3056,
                            civil    => 471, civilian => 2348, civilians
                                     => 3573,
                            civilisation
                                     => 13111, civilisations
                                     => 28392,
                            civilizations
                                     => 9387, civitas  => 23373,
                            clackamas
                                     => 24783, cladding => 16958,
                            clade    => 8219, clades   => 19295, cladistic
                                     => 23560,
                            cladogram
                                     => 18354, claes    => 22257,
                            claim    => 1338, claimant => 11630, claimants
                                     => 12843,
                            claimed  => 825, claiming => 2430, claims   => 1194, clairvaux
                                     => 29166,
                            clan     => 2389, clandestine
                                     => 9429,
                            clandestinely
                                     => 25755, clann    => 22820,
                            clans    => 6289, clapboard
                                     => 19003,
                            clapham  => 13485, clapton  => 9372, claremont
                                     => 8873,
                            clarendon
                                     => 12233, claret   => 26029,
                            clarified
                                     => 9490, clarifies
                                     => 25544,
                            clarinet => 7331, clarinetist
                                     => 18346,
                            clarinets
                                     => 18743, clarion  => 13188,
                            clarks   => 26571, clarksburg
                                     => 27726,
                            clarksville
                                     => 17366, clash    => 5316,
                            clashed  => 8838, clashes  => 6634, clasico  => 28677, clasps   => 24262,
                            class    => 287, classed  => 9381, classes  => 1185, classic  => 1267,
                            classical
                                     => 1252, classically
                                     => 12544,
                            classicism
                                     => 16901, classicist
                                     => 20247,
                            classics => 4123, classification
                                     => 2008,
                            classifications
                                     => 8764,
                            classified
                                     => 2100, classifier
                                     => 21711,
                            classifiers
                                     => 26240, classifies
                                     => 14441,
                            classify => 9890, classifying
                                     => 14003,
                            classmate
                                     => 9845, classroom
                                     => 4212,
                            classrooms
                                     => 4635, claudius => 9424,
                            clause   => 4147, clauses  => 8573, clausura => 12929, clave    => 25432,
                            clays    => 16786, cleanly  => 23956, clearances
                                     => 17111,
                            clearest => 27761, clearfield
                                     => 21659,
                            clearinghouse
                                     => 25141, clearings
                                     => 23878,
                            clearwater
                                     => 11047, cleave   => 19945,
                            cleaved  => 21784, cleburne => 25720, cleese   => 21788, cleft    => 14302,
                            clemenceau
                                     => 25644, clemson  => 8825,
                            clerestory
                                     => 18801, clergy   => 4176,
                            clergyman
                                     => 8159, clergymen
                                     => 16101,
                            cleric   => 10682, clerical => 8543, clerics  => 11009, clerked  => 27091,
                            clerkenwell
                                     => 27750, clermont => 10575,
                            cleves   => 18645, cliched  => 25533, cliffs   => 5722, clijsters
                                     => 23844,
                            climactic
                                     => 16279, climate  => 1214,
                            climates => 8772, climatic => 9472, climax   => 6623, climbers => 10355,
                            climbs   => 8142, clinch   => 10597, clinched => 9312, clinching
                                     => 16108,
                            clinical => 2220, clinician
                                     => 19358,
                            clinicians
                                     => 15392, clinics  => 6744,
                            clinker  => 27369, clips    => 6246, clique   => 12445, cliques  => 26305,
                            clitheroe
                                     => 25195, clive    => 6589,
                            clivina  => 23627, clockwise
                                     => 8384,
                            cloister => 11963, cloisters
                                     => 21818,
                            clonal   => 28539, clones   => 9626, clonmel  => 27988, clontarf => 25169,
                            closed   => 701, closely  => 1642, clostridium
                                     => 26059,
                            closure  => 2954, closures => 12174, cloth    => 4711, clothing => 2607,
                            clove    => 25438, cloverleaf
                                     => 16322,
                            clovis   => 13317, club     => 131, clube    => 8002, clubs    => 1007,
                            clumps   => 17704, cluny    => 18668, cluster  => 3851, clustered
                                     => 11943,
                            clustering
                                     => 14088, clusters => 5018,
                            clutch   => 7726, clwyd    => 24334, clydebank
                                     => 21088,
                            coach    => 474, coached  => 3027, coachella
                                     => 17475,
                            coaches  => 2629, coaching => 2199, coadjutor
                                     => 17092,
                            coagulation
                                     => 20371, coahuila => 15197,
                            coal     => 1646, coalesce => 25976, coalesced
                                     => 24696,
                            coalfield
                                     => 15780, coalfields
                                     => 24163,
                            coalition
                                     => 2005, coalitions
                                     => 14335,
                            coarse   => 9165, coarser  => 27307, coast    => 516, coastal  => 1840,
                            coastline
                                     => 5869, coastlines
                                     => 20534,
                            coasts   => 7347, coatbridge
                                     => 25980,
                            coated   => 7684, coating  => 8063, coatings => 12433, coauthor => 28702,
                            coauthored
                                     => 21077, coaxial  => 16574,
                            cobain   => 15530, cobalt   => 10218, cobbled  => 23974, cobblestone
                                     => 22390,
                            cobden   => 24811, cobham   => 15399, cobol    => 28826, cobra    => 6881,
                            cobras   => 17616, coburg   => 11303, cochabamba
                                     => 21129,
                            cochin   => 10411, cochise  => 20949, cochlear => 22800, cockatoo => 21004,
                            cocker   => 15107, cockerell
                                     => 24650,
                            cocking  => 29488, cockpit  => 6292, cockpits => 23360, cocos    => 20235,
                            cocteau  => 19008, code     => 917, codec    => 17236, codecs   => 23290,
                            codeine  => 24916, codename => 13661, codenamed
                                     => 12623,
                            codes    => 3508, codeshare
                                     => 29366,
                            codex    => 6000, codice_1 => 9798, codice_2 => 13662, codice_3 => 16867,
                            codice_4 => 18700, codice_5 => 21708, codice_6 => 23748, codice_7 => 25856,
                            codice_8 => 27526, codice_9 => 29568, codices  => 21130, codification
                                     => 20397,
                            codified => 10956, coding   => 6637, codon    => 22278, codrington
                                     => 27539,
                            coeducational
                                     => 10472, coefficient
                                     => 7153,
                            coefficients
                                     => 7736, coenzyme => 24276,
                            coercive => 16999, coetzee  => 24848, coeur    => 13158, coexistence
                                     => 17200,
                            cofactor => 20210, cofounded
                                     => 25196,
                            cofounder
                                     => 23339, cognate  => 13113,
                            cognates => 25246, cognition
                                     => 9947,
                            cognitive
                                     => 3996, cognomen => 27899,
                            cohabitation
                                     => 24329, coherence
                                     => 13309,
                            coherent => 8516, cohesion => 12084, cohesive => 12496, cohomology
                                     => 14635,
                            cohort   => 11758, cohorts  => 18490, coiled   => 15159, coils    => 12057,
                            coimbatore
                                     => 11872, coimbra  => 12537,
                            coin     => 4034, coinage  => 8883, coincide => 7252, coincided
                                     => 6916,
                            coincident
                                     => 26304, coincidentally
                                     => 9536,
                            coincides
                                     => 11983, coinciding
                                     => 10979,
                            coined   => 4719, coining  => 17854, coins    => 3046, coking   => 29494,
                            "col."   => 5520, colborne => 28763, colchester
                                     => 7192,
                            coldest  => 13290, coldfield
                                     => 24356,
                            coldplay => 15410, coldstream
                                     => 20507,
                            coldwater
                                     => 19275, colegio  => 10947,
                            coleophora
                                     => 11217, coleophoridae
                                     => 20440,
                            coleoptera
                                     => 29781, coleraine
                                     => 18534,
                            coleridge
                                     => 11222, colfax   => 19647,
                            colgate  => 13483, colima   => 21284, coliseum => 7315, collaborate
                                     => 7820,
                            collaborated
                                     => 3141, collaborates
                                     => 13105,
                            collaborating
                                     => 7476, collaboration
                                     => 1974,
                            collaborationist
                                     => 26424,
                            collaborations
                                     => 5827, collaborative
                                     => 4872,
                            collaboratively
                                     => 20286,
                            collaborator
                                     => 7188, collaborators
                                     => 7729,
                            collagen => 13279, collages => 19939, collapse => 3026, collapses
                                     => 10382,
                            collapsible
                                     => 27770, collated => 18795,
                            colle    => 22935, colleagues
                                     => 3381,
                            collectable
                                     => 29517, collected
                                     => 1764,
                            collectible
                                     => 13123, collectibles
                                     => 19626,
                            collecting
                                     => 3780, collection
                                     => 613,
                            collections
                                     => 2049, collective
                                     => 2735,
                            collectively
                                     => 5031, collectives
                                     => 23455,
                            collectivization
                                     => 24451,
                            collector
                                     => 3981, collectors
                                     => 5229,
                            collects => 8184, college  => 137, colleges => 2017, collegiate
                                     => 3170,
                            collegiately
                                     => 19514, collegio => 29060,
                            collegium
                                     => 16290, collided => 8607,
                            collider => 21870, colliding
                                     => 17174,
                            collieries
                                     => 15156, colliers => 27139,
                            colliery => 7274, collingwood
                                     => 7739,
                            collision
                                     => 4963, collisions
                                     => 10011,
                            colloidal
                                     => 28716, colloquial
                                     => 10884,
                            colloquially
                                     => 8385, colloquium
                                     => 28615,
                            colmar   => 24399, colne    => 19966, cologne  => 4860, colombia => 2788,
                            colombian
                                     => 5152, colombians
                                     => 29281,
                            colonels => 11154, colonia  => 11530, colonial => 1636, colonialism
                                     => 11027,
                            colonials
                                     => 19397, colonies => 2951,
                            colonisation
                                     => 14737, colonised
                                     => 22838,
                            colonist => 20108, colonists
                                     => 5879,
                            colonization
                                     => 6848, colonize => 17628,
                            colonized
                                     => 13491, colonizers
                                     => 24777,
                            colonizing
                                     => 25912, colony   => 1836,
                            colophon => 27776, color    => 1064, colorado => 1586, coloration
                                     => 9744,
                            coloratura
                                     => 29382, colorectal
                                     => 19839,
                            colored  => 3370, colorless
                                     => 15745,
                            colors   => 2398, colossus => 14216, colour   => 2145, colouration
                                     => 17077,
                            coloured => 4532, colourful
                                     => 8937,
                            colouring
                                     => 15470, colourless
                                     => 23779,
                            colours  => 3432, colquhoun
                                     => 26119,
                            "colspan=12"
                                     => 20820, "colspan=3|total"
                                     => 11921,
                            "colspan=3|turnout"
                                     => 23319,
                            "colspan=9"
                                     => 11271, "colspan=9|"
                                     => 14551,
                            colt     => 5519, coltrane => 13119, colts    => 5385, columba  => 14573,
                            columbia => 1014, columbian
                                     => 8896,
                            columbine
                                     => 19026, columella
                                     => 18535,
                            column   => 2152, columnar => 23838, columnist
                                     => 5087,
                            columns  => 2943, colwyn   => 27213, comarca  => 13406, combat   => 1269,
                            combatant
                                     => 10914, combatants
                                     => 9956,
                            combating
                                     => 12608, combats  => 25817,
                            combe    => 15321, combination
                                     => 1758,
                            combinations
                                     => 5773, combinatorial
                                     => 15143,
                            combinatorics
                                     => 20900, combine  => 4438,
                            combined => 1105, combines => 5033, combining
                                     => 4275,
                            combos   => 22636, combustion
                                     => 6218,
                            comcast  => 10108, comdr    => 20566, comeback => 4769, comedian => 4133,
                            comedians
                                     => 8891, comedic  => 7894,
                            comedie  => 20364, comedienne
                                     => 24189,
                            comedies => 7881, comedy   => 1069, comet    => 6513, comets   => 9599,
                            comic    => 1499, comical  => 12584, comically
                                     => 23991,
                            comics   => 1714, comilla  => 28169, comintern
                                     => 13882,
                            comique  => 16405, comite   => 18889, comix    => 23270, command  => 618,
                            commandant
                                     => 6274, commanded
                                     => 2429,
                            commander
                                     => 883, commanders
                                     => 4230,
                            commandery
                                     => 15741, commanding
                                     => 3100,
                            commando => 6130, commandos
                                     => 9368,
                            commands => 4690, commedia => 21879, commemorate
                                     => 5073,
                            commemorated
                                     => 7015, commemorates
                                     => 8955,
                            commemorating
                                     => 7754, commemoration
                                     => 8122,
                            commemorations
                                     => 17878,
                            commemorative
                                     => 6802, commenced
                                     => 3045,
                            commencement
                                     => 7844, commences
                                     => 16432,
                            commencing
                                     => 9230, commendation
                                     => 9818,
                            commendations
                                     => 24034, commended
                                     => 8918,
                            commending
                                     => 28460, commentaries
                                     => 7728,
                            commentary
                                     => 3285, commentated
                                     => 26884,
                            commentating
                                     => 28199, commentator
                                     => 4789,
                            commentators
                                     => 5822, commented
                                     => 2665,
                            commenting
                                     => 6028, comments => 3131,
                            commerce => 2163, commercial
                                     => 624,
                            commercialization
                                     => 14472,
                            commercialize
                                     => 27519, commercialized
                                     => 17928,
                            commercially
                                     => 3944, commercials
                                     => 4503,
                            commissar
                                     => 14910, commissariat
                                     => 19442,
                            commissars
                                     => 25378, commissary
                                     => 16487,
                            commission
                                     => 620, commissioned
                                     => 1411,
                            commissioner
                                     => 2043, commissioners
                                     => 4462,
                            commissioning
                                     => 7496, commissions
                                     => 4790,
                            commitments
                                     => 6853, commits  => 10319,
                            committee
                                     => 442, committeeman
                                     => 28738,
                            committees
                                     => 3360, commodities
                                     => 8034,
                            commodity
                                     => 7407, commodore
                                     => 4947,
                            commodores
                                     => 15325, common   => 347,
                            commonalities
                                     => 29968, commonality
                                     => 23242,
                            commoners
                                     => 14036, commonly => 979,
                            commonplace
                                     => 10140, commons  => 2588,
                            commonwealth
                                     => 1762, communal => 5809,
                            communaute
                                     => 21977, commune  => 1623,
                            communes => 6039, communicable
                                     => 27318,
                            communicated
                                     => 10271, communicates
                                     => 15369,
                            communication
                                     => 1583, communications
                                     => 1444,
                            communicative
                                     => 18692, communion
                                     => 6134,
                            communism
                                     => 5696, communist
                                     => 1321,
                            communists
                                     => 4683, communities
                                     => 1063,
                            community
                                     => 227, commutation
                                     => 22275,
                            commutative
                                     => 13052, commutator
                                     => 27815,
                            commuted => 8734, commuter => 5271, commuters
                                     => 10266,
                            commutes => 27127, commuting
                                     => 13415,
                            comoros  => 14701, compact  => 3484, compacted
                                     => 21792,
                            compaction
                                     => 26691, compactness
                                     => 29490,
                            compagnie
                                     => 13554, compania => 21125,
                            companies
                                     => 633, companion
                                     => 3395,
                            companions
                                     => 6007, company  => 113,
                            compaq   => 20707, comparable
                                     => 4517,
                            comparative
                                     => 4994, comparatively
                                     => 7336,
                            compared => 1153, compares => 8402, comparison
                                     => 2787,
                            comparisons
                                     => 6673, compasses
                                     => 28602,
                            compatibility
                                     => 7649, compatible
                                     => 4484,
                            compatriot
                                     => 12689, compatriots
                                     => 17173,
                            compendium
                                     => 11936, compensate
                                     => 7525,
                            compensation
                                     => 3539, compensatory
                                     => 19038,
                            compete  => 1751, competed => 962, competence
                                     => 8579,
                            competences
                                     => 25853, competencies
                                     => 16844,
                            competency
                                     => 14346, competes => 5218,
                            competing
                                     => 2245, competition
                                     => 489,
                            competitions
                                     => 2039, competitive
                                     => 2302,
                            competitively
                                     => 17107, competitiveness
                                     => 10868,
                            competitor
                                     => 4727, competitors
                                     => 3621,
                            compilation
                                     => 2198, compilations
                                     => 7637,
                            compile  => 10606, compiled => 3223, compiler => 7941, compilers
                                     => 14365,
                            compiles => 20160, compiling
                                     => 8193,
                            complainant
                                     => 28567, complained
                                     => 5056,
                            complaints
                                     => 4224, complement
                                     => 5283,
                            complementary
                                     => 7688, complemented
                                     => 10885,
                            complementing
                                     => 20807, complements
                                     => 15446,
                            complete => 684, completed
                                     => 481,
                            completeness
                                     => 16326, completes
                                     => 10836,
                            completing
                                     => 2739, completion
                                     => 2170,
                            completions
                                     => 16824, complex  => 724,
                            complexes
                                     => 5789, complexities
                                     => 15508,
                            complexity
                                     => 4325, compliance
                                     => 4942,
                            compliant
                                     => 9383, complicity
                                     => 15727,
                            complied => 12110, complies => 18983, comply   => 5804, complying
                                     => 19142,
                            component
                                     => 2342, components
                                     => 1981,
                            compose  => 7161, composed => 848, composer => 1484, composers
                                     => 3497,
                            composes => 17980, composing
                                     => 6308,
                            composite
                                     => 4721, composites
                                     => 14604,
                            compositing
                                     => 28656, composition
                                     => 1622,
                            compositional
                                     => 12289, compositions
                                     => 3087,
                            compostela
                                     => 16343, composting
                                     => 22292,
                            compound => 2913, compounded
                                     => 12178,
                            compounding
                                     => 18014, compounds
                                     => 3604,
                            comprehensible
                                     => 27806,
                            comprehensive
                                     => 2579, comprehensively
                                     => 19196,
                            compressed
                                     => 6754, compressing
                                     => 25748,
                            compression
                                     => 5155, compressive
                                     => 23401,
                            compressor
                                     => 11013, compressors
                                     => 18910,
                            comprise => 5491, comprised
                                     => 4332,
                            comprises
                                     => 2920, comprising
                                     => 3496,
                            comptroller
                                     => 10612, compulsory
                                     => 5547,
                            computable
                                     => 21748, computation
                                     => 8201,
                            computational
                                     => 5884, computationally
                                     => 20351,
                            computations
                                     => 16468, compute  => 9239,
                            computed => 8284, computer => 787, computerised
                                     => 26944,
                            computerized
                                     => 12036, computers
                                     => 2784,
                            computes => 23541, computing
                                     => 3599,
                            comte    => 7798, comune   => 6987, comyn    => 23653, conakry  => 29455,
                            conan    => 6757, concacaf => 8590, concave  => 9730, conceals => 26481,
                            conceded => 7532, concedes => 26547, conceding
                                     => 11542,
                            conceicao
                                     => 24638, conceit  => 27006,
                            conceived
                                     => 3820, concentrated
                                     => 3386,
                            concentrates
                                     => 11996, concentration
                                     => 2495,
                            concentrations
                                     => 5284, concentric
                                     => 12351,
                            concept  => 1052, conceptions
                                     => 14874,
                            concepts => 2988, conceptual
                                     => 6462,
                            conceptualization
                                     => 28080,
                            conceptualized
                                     => 18732,
                            conceptually
                                     => 16080, concerning
                                     => 2587,
                            concerns => 2062, concert  => 1158, concerted
                                     => 13891,
                            concertgebouw
                                     => 25850, concerti => 29053,
                            concertmaster
                                     => 22962, concerto => 5119,
                            concertos
                                     => 11893, concerts => 2185,
                            concession
                                     => 6947, concessions
                                     => 7562,
                            conciliation
                                     => 18699, conciliatory
                                     => 21667,
                            concise  => 13408, conclave => 11394, conclude => 6792, concluded
                                     => 1899,
                            concludes
                                     => 5608, concluding
                                     => 6550,
                            conclusion
                                     => 2700, concomitant
                                     => 22282,
                            concord  => 6711, concordance
                                     => 25374,
                            concordat
                                     => 19191, concordia
                                     => 9188,
                            concours => 22631, concourse
                                     => 10522,
                            concrete => 2206, concubine
                                     => 13129,
                            concubines
                                     => 18871, concurred
                                     => 15907,
                            concurrence
                                     => 19891, concurrency
                                     => 8667,
                            concurrent
                                     => 6250, concurrently
                                     => 6663,
                            concurring
                                     => 20662, condemnation
                                     => 9914,
                            condemned
                                     => 3999, condemns => 19764,
                            condensate
                                     => 22010, condensation
                                     => 12161,
                            condense => 26973, condensed
                                     => 9797,
                            condenser
                                     => 18985, condensing
                                     => 23655,
                            condita  => 22777, conditional
                                     => 7226,
                            conditionally
                                     => 28235, conditioned
                                     => 8879,
                            conditions
                                     => 913, condoleezza
                                     => 25751,
                            condominium
                                     => 12303, condominiums
                                     => 13747,
                            condor   => 10784, condorcet
                                     => 26300,
                            condors  => 27527, conducive
                                     => 14355,
                            conduct  => 2164, conductance
                                     => 21584,
                            conducted
                                     => 1099, conducting
                                     => 3514,
                            conduction
                                     => 12252, conductive
                                     => 13620,
                            conductivity
                                     => 11221, conductor
                                     => 3242,
                            conductors
                                     => 8183, conducts => 6659,
                            conduits => 27265, conestoga
                                     => 24980,
                            confectionery
                                     => 15322, confederacy
                                     => 6765,
                            confederate
                                     => 2745, confederates
                                     => 8490,
                            confederation
                                     => 4069, confederations
                                     => 14488,
                            conference
                                     => 521, conferences
                                     => 3235,
                            conferencing
                                     => 18823, conferred
                                     => 5892,
                            conferring
                                     => 18550, confers  => 17654,
                            confesses
                                     => 8360, confessions
                                     => 8804,
                            confessor
                                     => 13271, confidently
                                     => 20312,
                            configurable
                                     => 26011, configuration
                                     => 3492,
                            configurations
                                     => 7995, configure
                                     => 21682,
                            configured
                                     => 9412, confined => 5058,
                            confinement
                                     => 8693, confirmed
                                     => 1415,
                            confiscated
                                     => 6805, confiscation
                                     => 14498,
                            conflagration
                                     => 28696, conflated
                                     => 25480,
                            conflict => 1372, conflicting
                                     => 7746,
                            conflicts
                                     => 3511, confluence
                                     => 5328,
                            conform  => 8662, conformal
                                     => 18091,
                            conformance
                                     => 27238, conformation
                                     => 13327,
                            conformational
                                     => 19547,
                            conformed
                                     => 21048, conforming
                                     => 15942,
                            conformist
                                     => 23083, conformity
                                     => 11737,
                            conforms => 20802, confounding
                                     => 29393,
                            confraternity
                                     => 22482, confrontation
                                     => 5763,
                            confrontations
                                     => 13574,
                            confronts
                                     => 6536, confucian
                                     => 11133,
                            confucianism
                                     => 14904, confucius
                                     => 13506,
                            confusingly
                                     => 20580, confusion
                                     => 3566,
                            congenital
                                     => 9973, congested
                                     => 14272,
                            congestion
                                     => 7344, congestive
                                     => 21270,
                            congke   => 29992, conglomerate
                                     => 8566,
                            conglomerates
                                     => 19012, congo    => 3431,
                            congolese
                                     => 11015, congregants
                                     => 27373,
                            congregate
                                     => 19279, congregation
                                     => 2757,
                            congregational
                                     => 7488, congregationalist
                                     => 22181,
                            congregations
                                     => 5911, congress => 752,
                            congresses
                                     => 7924, congressional
                                     => 2747,
                            congreve => 28028, congruence
                                     => 22465,
                            congruent
                                     => 19015, conic    => 18719,
                            conical  => 8874, conidae  => 21450, conifer  => 15453, coniferous
                                     => 13716,
                            conifers => 16763, coniston => 28387, conjecture
                                     => 8073,
                            conjectured
                                     => 15581, conjectures
                                     => 20199,
                            conjugate
                                     => 12054, conjugated
                                     => 17474,
                            conjugation
                                     => 14305, conjunction
                                     => 3467,
                            conjunctions
                                     => 27775, conmebol => 19205,
                            connacht => 9692, connaught
                                     => 13907,
                            connected
                                     => 1263, connecticut
                                     => 1965,
                            connecting
                                     => 2602, connections
                                     => 2561,
                            connective
                                     => 14775, connectivity
                                     => 7695,
                            connector
                                     => 7154, connectors
                                     => 11074,
                            connects => 3177, connemara
                                     => 27859,
                            connexion
                                     => 22248, connoisseurs
                                     => 29319,
                            connotation
                                     => 16109, connotations
                                     => 13007,
                            conor    => 13482, conquered
                                     => 4185,
                            conqueror
                                     => 9780, conquerors
                                     => 18778,
                            conquest => 3325, conquests
                                     => 10855,
                            conquistador
                                     => 21598, conquistadors
                                     => 21020,
                            conrail  => 16204, conscript
                                     => 27531,
                            conscripted
                                     => 14568, conscription
                                     => 9105,
                            conscripts
                                     => 16418, consecrate
                                     => 29093,
                            consecrated
                                     => 4774, consecration
                                     => 8582,
                            consecrators
                                     => 17572, consecutive
                                     => 1688,
                            consecutively
                                     => 12824, conseil  => 14227,
                            consejo  => 15948, consensus
                                     => 4042,
                            consent  => 3889, consents => 27585, consequence
                                     => 3614,
                            consequent
                                     => 11096, consequential
                                     => 25466,
                            consequently
                                     => 3108, conservancy
                                     => 10019,
                            conservation
                                     => 1774, conservationist
                                     => 18071,
                            conservationists
                                     => 21022,
                            conservatism
                                     => 11747, conservative
                                     => 1277,
                            conservatives
                                     => 4266, conservatoire
                                     => 10462,
                            conservator
                                     => 22530, conservatories
                                     => 25193,
                            conservatorium
                                     => 20523,
                            conservators
                                     => 28752, conservatory
                                     => 4397,
                            conserved
                                     => 7564, conserving
                                     => 17858,
                            considerable
                                     => 2015, considerably
                                     => 3689,
                            considerations
                                     => 6282, considered
                                     => 345,
                            considers
                                     => 4063, consigned
                                     => 22700,
                            consignment
                                     => 24797, consist  => 3039,
                            consisted
                                     => 1497, consistency
                                     => 7030,
                            consistent
                                     => 3010, consistently
                                     => 3932,
                            consisting
                                     => 1687, consistory
                                     => 16054,
                            consists => 837, console  => 4459, consoles => 8160, consolidate
                                     => 8947,
                            consolidated
                                     => 4001, consolidating
                                     => 12732,
                            consolidation
                                     => 6273, consonant
                                     => 7241,
                            consonants
                                     => 7175, consort  => 5687,
                            consortia
                                     => 29091, consortium
                                     => 4575,
                            consorts => 17437, conspecific
                                     => 24479,
                            conspicuous
                                     => 7977, conspicuously
                                     => 20521,
                            conspirators
                                     => 10720, constables
                                     => 12806,
                            constabulary
                                     => 10003, constant => 1960,
                            constanta
                                     => 19064, constantin
                                     => 10551,
                            constantinople
                                     => 4253, constantius
                                     => 17914,
                            constants
                                     => 10223, constellation
                                     => 5777,
                            consternation
                                     => 20719, constituencies
                                     => 4706,
                            constituency
                                     => 1520, constituent
                                     => 4796,
                            constituents
                                     => 8634, constitute
                                     => 4375,
                            constituted
                                     => 4661, constitutes
                                     => 6793,
                            constituting
                                     => 11449, constitution
                                     => 1239,
                            constitutional
                                     => 2166, constitutionality
                                     => 13600,
                            constitutionally
                                     => 13588,
                            constitutions
                                     => 11369, constitutive
                                     => 19914,
                            constrain
                                     => 24863, constrained
                                     => 10102,
                            constraint
                                     => 9435, constraints
                                     => 5575,
                            constricted
                                     => 25431, constriction
                                     => 23918,
                            construct
                                     => 3469, constructed
                                     => 922,
                            constructing
                                     => 5966, construction
                                     => 399,
                            constructions
                                     => 7951, constructivism
                                     => 23375,
                            constructivist
                                     => 22268,
                            constructor
                                     => 14770, constructors
                                     => 13209,
                            constructs
                                     => 10403, consul   => 5042,
                            consular => 11653, consulates
                                     => 15694,
                            consuls  => 14832, consulship
                                     => 15937,
                            consultancy
                                     => 8603, consultant
                                     => 3454,
                            consultants
                                     => 8143, consultation
                                     => 6319,
                            consultations
                                     => 12928, consultative
                                     => 10371,
                            consulted
                                     => 7214, consulting
                                     => 3973,
                            consume  => 7627, consumer => 2528, consumerism
                                     => 19954,
                            consumers
                                     => 3857, consuming
                                     => 7431,
                            consumption
                                     => 3065, contactless
                                     => 29083,
                            contador => 19446, contagion
                                     => 24810,
                            contain  => 1761, contained
                                     => 1534,
                            container
                                     => 5295, containers
                                     => 7079,
                            containing
                                     => 1447, contains => 688,
                            contaminant
                                     => 25626, contaminants
                                     => 13495,
                            contamination
                                     => 7160, contemplated
                                     => 13301,
                            contemplates
                                     => 23604, contemplation
                                     => 14803,
                            contemplative
                                     => 16856, contemporaneous
                                     => 13516,
                            contemporaries
                                     => 6033, contemporary
                                     => 969,
                            contend  => 10450, contended
                                     => 10219,
                            contender
                                     => 7432, contenders
                                     => 9301,
                            contending
                                     => 17202, contends => 13096,
                            content  => 1163, contention
                                     => 7113,
                            contentious
                                     => 10085, contents => 3860,
                            contest  => 1527, contestant
                                     => 4702,
                            contestants
                                     => 3966, contested
                                     => 2482,
                            contests => 5709, context  => 1983, contexts => 6705, contextual
                                     => 14835,
                            contiguous
                                     => 8843, continent
                                     => 3832,
                            continental
                                     => 2323, continents
                                     => 6737,
                            contingent
                                     => 6077, contingents
                                     => 17223,
                            continual
                                     => 10356, continually
                                     => 5893,
                            continuation
                                     => 5075, continue => 1001,
                            continued
                                     => 341, continues
                                     => 1125,
                            continuing
                                     => 2001, continuity
                                     => 5038,
                            continuo => 17447, continuous
                                     => 2475,
                            continuously
                                     => 4070, continuum
                                     => 8856,
                            contour  => 12553, contours => 15381, contra   => 9479, contraception
                                     => 14353,
                            contraceptive
                                     => 18233, contract => 649,
                            contracted
                                     => 4194, contracting
                                     => 8331,
                            contractor
                                     => 5583, contractors
                                     => 6467,
                            contracts
                                     => 3071, contractual
                                     => 9805,
                            contractually
                                     => 27508, contradicted
                                     => 13071,
                            contradiction
                                     => 10495, contradictions
                                     => 13690,
                            contradictory
                                     => 10258, contradicts
                                     => 17432,
                            contraindications
                                     => 27278,
                            contralto
                                     => 22936, contrapuntal
                                     => 27943,
                            contras  => 25737, contrast => 1869, contrasted
                                     => 8347,
                            contrasting
                                     => 8403, contrasts
                                     => 8400,
                            contravention
                                     => 26047, contre   => 23717,
                            contribute
                                     => 3383, contributed
                                     => 1542,
                            contributes
                                     => 6190, contributing
                                     => 2873,
                            contribution
                                     => 2381, contributions
                                     => 1918,
                            contributor
                                     => 4630, contributors
                                     => 5917,
                            contributory
                                     => 23296, contrived
                                     => 17218,
                            control  => 335, controllable
                                     => 20595,
                            controlled
                                     => 1477, controller
                                     => 4602,
                            controllers
                                     => 7929, controls => 3028,
                            controversial
                                     => 2128, controversially
                                     => 11472,
                            controversies
                                     => 6004, controversy
                                     => 1706,
                            conurbation
                                     => 18611, conus    => 12091,
                            convair  => 18320, convalescence
                                     => 29607,
                            convalescent
                                     => 23677, convection
                                     => 8166,
                            convective
                                     => 16885, convened => 7221,
                            convener => 24824, conveniences
                                     => 28591,
                            convening
                                     => 21035, convenor => 25314,
                            convent  => 4490, convention
                                     => 1294,
                            conventional
                                     => 2542, conventionally
                                     => 12258,
                            conventions
                                     => 4439, convents => 17716,
                            converge => 10138, converged
                                     => 16842,
                            convergence
                                     => 7151, convergent
                                     => 13272,
                            converges
                                     => 15602, converging
                                     => 17088,
                            conversely
                                     => 6942, conversion
                                     => 2531,
                            conversions
                                     => 9211, convert  => 3926,
                            converted
                                     => 1506, converter
                                     => 10155,
                            converters
                                     => 16009, converting
                                     => 6114,
                            converts => 7270, convex   => 7034, convey   => 7369, conveyance
                                     => 20560,
                            conveyed => 8853, conveying
                                     => 14300,
                            conveys  => 14439, convicts => 9444, convinces
                                     => 7126,
                            convincingly
                                     => 16001, convocation
                                     => 13501,
                            convolution
                                     => 20582, convoy   => 3441,
                            convoys  => 7949, conwy    => 18606, conyngham
                                     => 27493,
                            cooch    => 26522, cooder   => 29170, cookery  => 15462, coolant  => 14897,
                            cooled   => 6314, cooling  => 4692, cooperated
                                     => 11200,
                            cooperates
                                     => 19146, cooperation
                                     => 2422,
                            cooperative
                                     => 4102, cooperatively
                                     => 23429,
                            cooperatives
                                     => 11120, cooperstown
                                     => 21761,
                            coordinate
                                     => 5150, coordinated
                                     => 5560,
                            coordinates
                                     => 4074, coordinating
                                     => 7663,
                            coordination
                                     => 5002, coordinator
                                     => 4360,
                            coordinators
                                     => 18658, coorg    => 28540,
                            coors    => 19023, coote    => 21781, copa     => 4531, copacabana
                                     => 26622,
                            copan    => 29042, copelatus
                                     => 19097,
                            copenhagen
                                     => 3688, copepods => 25641,
                            copies   => 1429, copious  => 17478, copper   => 2551, copra    => 28016,
                            coptic   => 9507, copts    => 29232, copula   => 25470, copulation
                                     => 20588,
                            copying  => 9374, copyist  => 29782, copyright
                                     => 3617,
                            copyrighted
                                     => 12871, copyrights
                                     => 15367,
                            copywriter
                                     => 25970, coquitlam
                                     => 20971,
                            coraciiformesfamily
                                     => 29239,
                            corals   => 13043, corbet   => 17358, corbusier
                                     => 18099,
                            cordillera
                                     => 11986, core     => 1438,
                            corelli  => 28266, cores    => 9506, corfu    => 13505, corgan   => 23006,
                            corgi    => 29809, corinth  => 10431, corinthian
                                     => 11409,
                            corinthians
                                     => 11480, coriolis => 26058,
                            cork     => 3207, cormac   => 17919, cormorant
                                     => 19184,
                            cormorants
                                     => 19770, corneal  => 16762,
                            corneille
                                     => 27964, cornel   => 28521,
                            cornelis => 12760, cornerback
                                     => 10287,
                            cornerstone
                                     => 8254, cornet   => 14372,
                            cornhill => 28077, cornhuskers
                                     => 14955,
                            cornice  => 10797, cornices => 22599, cornwall => 3809, corolla  => 13120,
                            corollary
                                     => 20090, coromandel
                                     => 22285,
                            coronal  => 23513, coronation
                                     => 4893,
                            corot    => 28368, "corp."  => 7096, corporate
                                     => 1952,
                            corporation
                                     => 926, corporations
                                     => 4203,
                            corps    => 920, corpus   => 5354, correctional
                                     => 7469,
                            corrections
                                     => 8120, corrective
                                     => 13547,
                            correctness
                                     => 15309, corrects => 26617,
                            corregidor
                                     => 22012, correlate
                                     => 14163,
                            correlated
                                     => 8895, correlates
                                     => 15586,
                            correlation
                                     => 6401, correlations
                                     => 14650,
                            correspond
                                     => 6300, corresponded
                                     => 9690,
                            correspondence
                                     => 4243, correspondences
                                     => 20926,
                            correspondent
                                     => 4336, correspondents
                                     => 12104,
                            corresponding
                                     => 2752, correspondingly
                                     => 16630,
                            corresponds
                                     => 5528, corridor => 3870,
                            corridors
                                     => 9270, corrientes
                                     => 22213,
                            corroborated
                                     => 18013, corrosion
                                     => 8829,
                            corrugated
                                     => 12359, corruption
                                     => 2892,
                            corsair  => 15786, corsairs => 23272, corsica  => 10024, corsican => 17395,
                            corte    => 20002, cortex   => 6493, cortical => 12592, corticosteroids
                                     => 26866,
                            cortisol => 20654, coruna   => 15528, corus    => 21333, corvallis
                                     => 20646,
                            corvette => 8819, corvettes
                                     => 14053,
                            corvinus => 22843, corvus   => 25128, cosimo   => 16000, cosine   => 21651,
                            cosmas   => 26879, cosmic   => 6036, cosmodrome
                                     => 22662,
                            cosmological
                                     => 14608, cosmology
                                     => 10621,
                            cosmonaut
                                     => 18746, cosmonauts
                                     => 23959,
                            cosmopolitan
                                     => 9267, cosmopterigidae
                                     => 17306,
                            cosmos   => 8517, cosplay  => 26638, cossack  => 10959, cossacks => 10357,
                            cossidae => 19921, cost     => 790, costal   => 11373, costco   => 29395,
                            costly   => 6505, costs    => 1695, costumed => 16356, cosworth => 17536,
                            cotabato => 22197, coterminous
                                     => 28714,
                            cotes    => 17941, cotswold => 20028, cottages => 7390, cottbus  => 22369,
                            cottonwood
                                     => 14681, cougar   => 12111,
                            cougars  => 8410, coulee   => 23233, coulomb  => 20146, coulthard
                                     => 15362,
                            council  => 249, councillor
                                     => 4784,
                            councillors
                                     => 5053, councilors
                                     => 15509,
                            councils => 3965, counsellors
                                     => 24732,
                            counsels => 23481, countable
                                     => 18009,
                            counted  => 4252, counter  => 2231, counteract
                                     => 13804,
                            counterattack
                                     => 9927, counterattacked
                                     => 24119,
                            counterattacks
                                     => 20259,
                            counterbalance
                                     => 23264,
                            counterclockwise
                                     => 22696,
                            counterculture
                                     => 17046,
                            countered
                                     => 10339, countering
                                     => 17609,
                            counterinsurgency
                                     => 23713,
                            countermeasure
                                     => 29074,
                            countermeasures
                                     => 14826,
                            counteroffensive
                                     => 22318,
                            counterpart
                                     => 5227, counterparts
                                     => 5481,
                            counterpoint
                                     => 12442, counters => 10489,
                            counterterrorism
                                     => 21700,
                            counterweight
                                     => 22852, countess => 5158,
                            counties => 1750, countries
                                     => 487,
                            country  => 220, countryside
                                     => 4423,
                            countrywide
                                     => 22484, county   => 105,
                            countywide
                                     => 16049, coup     => 3030,
                            coupe    => 6052, coupes   => 20270, coupled  => 4315, coupler  => 23362,
                            couplers => 25557, couples  => 1885, couplet  => 19644, couplets => 20943,
                            coupling => 7519, couplings
                                     => 22624,
                            coups    => 18626, courant  => 17829, courbet  => 24487, courland => 19369,
                            cours    => 21772, courses  => 1550, coursework
                                     => 13802,
                            court    => 246, courtauld
                                     => 27551,
                            courtenay
                                     => 12169, courtesan
                                     => 21635,
                            courthouses
                                     => 21587, courtier => 14022,
                            courtiers
                                     => 16041, courtly  => 18429,
                            courts   => 1705, courtyard
                                     => 5713,
                            courtyards
                                     => 16892, coutinho => 26791,
                            covalent => 16384, covalently
                                     => 26690,
                            covariance
                                     => 17511, covariant
                                     => 20878,
                            cove     => 4659, covenant => 6654, covenanters
                                     => 25083,
                            covenants
                                     => 17210, covent   => 9911,
                            coventry => 5102, cover    => 746, coverage => 2014, covered  => 895,
                            covering => 2041, coverings
                                     => 21874,
                            covers   => 1345, coverts  => 21310, coves    => 28815, coveted  => 9790,
                            cowboys  => 4356, cowdenbeath
                                     => 23936,
                            cowes    => 21175, cowper   => 16767, cowries  => 28730, coxae    => 18993,
                            coxed    => 20446, coxeter  => 17785, coxless  => 22032, coxswain => 22705,
                            coyotes  => 10574, cpusa    => 26733, crackdown
                                     => 12201,
                            cracow   => 21159, cradock  => 27011, crafted  => 8157, crafting => 15557,
                            crafts   => 5455, craftsman
                                     => 10115,
                            craftsmen
                                     => 9264, crags    => 19427,
                            craigie  => 24300, craigslist
                                     => 29440,
                            craiova  => 20174, crambidae
                                     => 6789,
                            cranbrook
                                     => 18075, cranial  => 13336,
                            crankcase
                                     => 24445, crankshaft
                                     => 14117,
                            crappie  => 26684, crassus  => 18965, crataegus
                                     => 28146,
                            crater   => 3773, craters  => 8448, crawler  => 24412, crayfish => 17322,
                            creamery => 20308, create   => 763, created  => 296, creates  => 3274,
                            creating => 1381, creation => 1139, creationism
                                     => 18057,
                            creationist
                                     => 24931, creative => 1942,
                            creativity
                                     => 6011, creator  => 3387,
                            creators => 6607, credential
                                     => 20527,
                            creditable
                                     => 27799, credited => 1892,
                            crediting
                                     => 22635, creditor => 14698,
                            creditors
                                     => 8414, credits  => 2144,
                            creek    => 853, creeks   => 9151, cremona  => 15224, creole   => 8053,
                            creoles  => 21388, creosote => 26544, crescent => 5530, cressida => 27922,
                            crest    => 4434, crested  => 11136, creston  => 29763, crests   => 14743,
                            crestwood
                                     => 26671, cretaceous
                                     => 6721,
                            cretan   => 15281, crete    => 7196, creuse   => 29115, crevices => 17959,
                            crew     => 1045, crewe    => 8469, crewed   => 19643, crewmembers
                                     => 22002,
                            crewmen  => 13060, cricket  => 1157, cricketer
                                     => 3089,
                            cricketers
                                     => 10630, cricketing
                                     => 17610,
                            crimea   => 8192, crimean  => 7575, criminality
                                     => 22751,
                            criminology
                                     => 14195, crimson  => 5810,
                            crises   => 9294, crisis   => 1719, crispa   => 28310, cristiano
                                     => 17467,
                            cristo   => 12758, criteria => 3302, criterion
                                     => 7117,
                            criterium
                                     => 21611, critic   => 2117,
                            critical => 924, criticality
                                     => 29600,
                            critically
                                     => 4138, criticised
                                     => 3916,
                            criticises
                                     => 23856, criticising
                                     => 14255,
                            criticism
                                     => 1790, criticisms
                                     => 6118,
                            criticized
                                     => 2130, criticizes
                                     => 12872,
                            criticizing
                                     => 8176, critics  => 1195,
                            critique => 6451, critiqued
                                     => 19687,
                            critiques
                                     => 12329, croat    => 14585,
                            croatia  => 2907, croatian => 2930, croats   => 9350, crocodiles
                                     => 12576,
                            crocodilians
                                     => 27843, crocus   => 27852,
                            crohn    => 23763, croix    => 7962, cromarty => 29172, cronenberg
                                     => 27495,
                            cronulla => 15417, crop     => 4124, cropping => 20073, crops    => 3103,
                            crore    => 11733, crores   => 16730, crossbar => 18040, crosse   => 14717,
                            crosses  => 2905, crossing => 1827, crossings
                                     => 7504,
                            crossover
                                     => 6301, crossovers
                                     => 19545,
                            crossrail
                                     => 25981, crossroad
                                     => 27286,
                            crossroads
                                     => 6866, crosstown
                                     => 17576,
                            croton   => 18728, crowdfunding
                                     => 18030,
                            crowds   => 5783, crowdsourcing
                                     => 27025,
                            crown    => 1355, crowned  => 3900, crowns   => 9216, croydon  => 7880,
                            crucial  => 3977, crucially
                                     => 22637,
                            cruciate => 16379, crucible => 15617, crucifixion
                                     => 11131,
                            cruciform
                                     => 17121, crude    => 6017,
                            cruised  => 14008, cruiser  => 4312, cruisers => 6440, cruiserweight
                                     => 16610,
                            cruises  => 8373, crumlin  => 28645, crusade  => 6306, crusader => 9390,
                            crusaders
                                     => 7074, crusades => 12547,
                            crusading
                                     => 28430, crustacean
                                     => 24220,
                            crustaceans
                                     => 11052, crustal  => 23423,
                            cruzeiro => 18305, crvena   => 28900, cryogenic
                                     => 18274,
                            cryptanalysis
                                     => 26636, cryptographic
                                     => 14279,
                            cryptography
                                     => 12896, crystalline
                                     => 9737,
                            crystallization
                                     => 19488,
                            crystallized
                                     => 22491, crystallographic
                                     => 26403,
                            crystallography
                                     => 17920,
                            crystals => 6416, csiro    => 21998, ctesiphon
                                     => 25486,
                            cthulhu  => 18313, cuatro   => 22576, cuauhtemoc
                                     => 24438,
                            cuba     => 2636, cuban    => 3527, cubana   => 27990, cubic    => 5628,
                            cubism   => 16488, cubist   => 18935, cubitt   => 27873, cubs     => 5138,
                            cuckoos  => 21171, cuddalore
                                     => 25233,
                            cuernavaca
                                     => 27341, cuisine  => 4404,
                            cuisines => 15519, culinary => 7857, culled   => 20661, culling  => 25429,
                            culloden => 24331, culminate
                                     => 20369,
                            culminated
                                     => 6091, culminates
                                     => 15130,
                            culminating
                                     => 6135, culmination
                                     => 10888,
                            culpeper => 21953, culprits => 24060, cult     => 3212, cultivar => 11209,
                            cultivars
                                     => 9875, cultivate
                                     => 10734,
                            cultivated
                                     => 4957, cultivation
                                     => 4234,
                            cultivators
                                     => 21542, cults    => 12643,
                            cultura  => 17186, cultural => 723, culturally
                                     => 7474,
                            culture  => 557, cultured => 12509, cultures => 3075, culvert  => 21963,
                            culverts => 28593, cumann   => 25334, cumans   => 24874, cumberland
                                     => 4445,
                            cumbersome
                                     => 17113, cumbia   => 22092,
                            cumbria  => 8928, cumulative
                                     => 8372,
                            cumulus  => 14575, cunard   => 15615, cuneiform
                                     => 15713,
                            cunxu    => 22969, cup      => 270, cupola   => 11777, curacao  => 12521,
                            curacies => 29812, curacy   => 19375, curate   => 9795, curated  => 8383,
                            curative => 22676, curator  => 5758, curatorial
                                     => 21452,
                            curators => 15649, curia    => 13395, curiae   => 26511, curiosities
                                     => 21673,
                            curiously
                                     => 15018, curitiba => 21789,
                            curler   => 18870, curlew   => 23130, curling  => 6083, curragh  => 21100,
                            currencies
                                     => 11661, currency => 3519,
                            current  => 375, currently
                                     => 321,
                            currents => 6099, curricula
                                     => 11508,
                            curricular
                                     => 9417, curriculum
                                     => 2855,
                            cursive  => 19079, cursor   => 18042, curtail  => 20024, curtailed
                                     => 12617,
                            curvature
                                     => 8973, curve    => 3656,
                            curved   => 4970, curves   => 5235, curvilinear
                                     => 24454,
                            curving  => 11949, curzon   => 14060, cusco    => 18772, cusps    => 23496,
                            custodians
                                     => 26959, custom   => 2880,
                            customarily
                                     => 17818, customary
                                     => 6662,
                            customers
                                     => 2252, customised
                                     => 26560,
                            customizable
                                     => 19048, customization
                                     => 16612,
                            customize
                                     => 17446, customized
                                     => 9905,
                            customs  => 3139, custos   => 26535, cutaneous
                                     => 15343,
                            cutoff   => 13655, cutscenes
                                     => 23988,
                            cuttack  => 20009, cuttings => 14445, cuttlefish
                                     => 27316,
                            cutty    => 29142, cuvier   => 23804, cuyahoga => 17607, cuzco    => 25793,
                            cyanobacteria
                                     => 20804, cybele   => 29692,
                            cyber    => 7171, cybermen => 21330, cybernetic
                                     => 19503,
                            cybernetics
                                     => 19500, cyberpunk
                                     => 21299,
                            cybersecurity
                                     => 27406, cybertron
                                     => 14232,
                            cycle    => 1727, cycled   => 24886, cycles   => 5141, cyclic   => 8408,
                            cyclical => 18421, cyclin   => 20658, cycling  => 3547, cyclist  => 5268,
                            cycliste => 29520, cyclists => 7230, cyclo    => 20466, cyclone  => 3982,
                            cyclones => 7985, cyclonic => 21467, cygnus   => 21699, cylinder => 3079,
                            cylinders
                                     => 7246, cylindrical
                                     => 7156,
                            cymbals  => 14122, cymru    => 12960, cypress  => 8526, cyprinidae
                                     => 29667,
                            cypriot  => 7547, cypriots => 16085, cyprus   => 3600, cyrenaica
                                     => 22356,
                            cyrene   => 27467, cyrillic => 6968, cysteine => 16399, cystic   => 16642,
                            cysts    => 17099, cytochrome
                                     => 14548,
                            cytokine => 20811, cytokines
                                     => 17892,
                            cytoplasm
                                     => 13896, cytoplasmic
                                     => 15247,
                            cytoskeleton
                                     => 25690, cytosol  => 25517,
                            cytosolic
                                     => 28790, cytotoxic
                                     => 22386,
                            czech    => 1871, czechoslovak
                                     => 7840,
                            czechoslovakia
                                     => 4804, czechs   => 15022,
                            czeslaw  => 28164, czestochowa
                                     => 18250,
                            "d'affaires"
                                     => 19042, "d'amato"
                                     => 24687,
                            "d'amico"
                                     => 29197, "d'amore"
                                     => 20044,
                            "d'arc"  => 28396, "d'art"  => 14986, "d'arte" => 29525, "d'auvergne"
                                     => 29802,
                            "d'azur" => 20604, "d'estaing"
                                     => 25917,
                            "d'este" => 18747, "d'etat" => 7112, "d'etudes"
                                     => 20406,
                            "d'histoire"
                                     => 23347, "d'hondt"
                                     => 22060,
                            "d'honneur"
                                     => 11950, "d'italia"
                                     => 10852,
                            "d'ivoire"
                                     => 9901, "d'orleans"
                                     => 17679,
                            "d'oro"  => 23705, "d'orsay"
                                     => 27422,
                            "d'oyly" => 16074, "d'souza"
                                     => 21774,
                            "d.c."   => 2514, "d.c.."  => 13512, dabrowa  => 18571, dabrowka => 29969,
                            dacian   => 16180, dacians  => 28134, dacre    => 22024, daedalus => 23635,
                            daegu    => 14869, daejeon  => 23968, daemon   => 18868, daewoo   => 18312,
                            daffodil => 29427, dafydd   => 19691, dagbladet
                                     => 25998,
                            dagenham => 14110, dagestan => 15274, dagobert => 29266, dahomey  => 20125,
                            daigo    => 24159, daihatsu => 26703, daiichi  => 28728, daily    => 904,
                            daimler  => 10284, daimyo   => 12387, dairies  => 24298, dairy    => 4519,
                            daisuke  => 18662, dakar    => 10854, dakota   => 2730, dakotas  => 23929,
                            dakshina => 25545, dalek    => 14898, daleks   => 11997, dalglish => 25075,
                            dalhousie
                                     => 13114, dalian   => 13390,
                            dalit    => 16716, dalits   => 23004, dalla    => 21474, dallara  => 27403,
                            "dallas/fort"
                                     => 29635, dalles   => 25901,
                            dalmatia => 11010, dalmatian
                                     => 15994,
                            daltrey  => 23133, damage   => 1201, damaged  => 1943, damages  => 4735,
                            daman    => 20947, damascus => 5989, dame     => 3305, dammed   => 16033,
                            damming  => 21043, damodar  => 22487, dampers  => 23977, damping  => 16223,
                            dams     => 6082, damselfly
                                     => 27443,
                            danbury  => 15878, danby    => 23533, dancefloor
                                     => 25949,
                            dancehall
                                     => 15918, dancers  => 4271,
                            dances   => 4505, dandenong
                                     => 17810,
                            danish   => 1887, danse    => 19602, dansk    => 28061, danske   => 28187,
                            dantes   => 29713, danube   => 6079, danubian => 24033, danville => 11391,
                            danza    => 24215, danzig   => 9650, daoist   => 24335, darbar   => 29573,
                            darbhanga
                                     => 27631, dardanelles
                                     => 16818,
                            daredevils
                                     => 29972, darfur   => 12469,
                            dargah   => 21957, darjeeling
                                     => 14937,
                            darke    => 29598, darkening
                                     => 25870,
                            darker   => 5247, darkly   => 18946, darko    => 21304, darkseid => 21203,
                            darlington
                                     => 7397, darmstadt
                                     => 10439,
                            darpa    => 17549, darreh   => 10482, darshan  => 18867, darters  => 27231,
                            dartford => 15746, dartmoor => 18427, dartmouth
                                     => 6346,
                            darts    => 7464, darul    => 20219, darwen   => 21612, darya    => 19618,
                            dashes   => 21609, dasht    => 13146, dassault => 18033, data     => 538,
                            database => 2874, databases
                                     => 6825,
                            dataset  => 18527, datasets => 20157, dated    => 2201, dates    => 1655,
                            dative   => 19995, datsun   => 24876, datuk    => 18080, datum    => 20095,
                            daugava  => 24229, daugavpils
                                     => 29910,
                            daughters
                                     => 2021, dauntless
                                     => 25029,
                            davao    => 12422, daventry => 26004, davide   => 17760, davos    => 17486,
                            dawla    => 16816, day      => 126, dayak    => 28470, dayal    => 23636,
                            dayan    => 19224, days     => 326, daytime  => 4723, daytona  => 6984,
                            deacons  => 13541, deactivation
                                     => 21690,
                            deadliest
                                     => 12580, deadlock => 15448,
                            deadlocked
                                     => 26607, deadman  => 24431,
                            deadpan  => 29411, deadpool => 19014, deadwood => 21246, deafness => 17518,
                            dealerships
                                     => 16019, deanery  => 10806,
                            death    => 197, deathmatch
                                     => 25496,
                            deaths   => 2464, deauville
                                     => 23047,
                            debate   => 1975, debated  => 6520, debates  => 5302, debian   => 17532,
                            debit    => 14550, debrecen => 19746, debris   => 5397, debtor   => 13750,
                            debtors  => 18181, debug    => 26652, debugger => 27423, debugging
                                     => 19289,
                            debussy  => 14259, debut    => 418, debutant => 17235, debuted  => 1935,
                            debuting => 8598, debuts   => 10010, decadal  => 29514, decade   => 1721,
                            decades  => 1621, decals   => 25801, decarboxylase
                                     => 29777,
                            decathlon
                                     => 13915, decatur  => 9687,
                            decay    => 5264, decayed  => 15591, decays   => 18162, decca    => 9425,
                            deccan   => 11314, deceased => 4227, deceleration
                                     => 24661,
                            december => 175, decentralization
                                     => 17430,
                            decentralized
                                     => 13397, decepticon
                                     => 14998,
                            decepticons
                                     => 12719, decided  => 568,
                            decider  => 10662, decides  => 2577, deciduous
                                     => 8404,
                            decimal  => 8940, decimated
                                     => 13249,
                            decisive => 5036, decisively
                                     => 11706,
                            deckers  => 23007, decking  => 27751, decks    => 8213, declan   => 14054,
                            declaration
                                     => 3005, declarations
                                     => 12226,
                            declarative
                                     => 20825, declared => 1145,
                            declares => 7579, declaring
                                     => 5383,
                            declassified
                                     => 18505, declension
                                     => 19521,
                            declination
                                     => 23902, decline  => 2114,
                            declined => 2195, declines => 9375, declining
                                     => 5267,
                            decoding => 13809, decolonization
                                     => 27387,
                            decommissioned
                                     => 5194, decommissioning
                                     => 10052,
                            decomposes
                                     => 23085, decomposition
                                     => 8133,
                            decompression
                                     => 14035, decorated
                                     => 2932,
                            decoration
                                     => 4489, decorations
                                     => 5257,
                            decorative
                                     => 4649, decrease => 3692,
                            decreased
                                     => 4017, decreases
                                     => 6762,
                            decreasing
                                     => 6429, decree   => 3913,
                            decreed  => 10492, decrees  => 10166, decried  => 20388, decrypt  => 29718,
                            dedekind => 27379, dedham   => 21833, dedicated
                                     => 1044,
                            dedicates
                                     => 23038, dedicating
                                     => 17707,
                            dedication
                                     => 4819, dedications
                                     => 25289,
                            deduced  => 13010, deduces  => 22915, deducted => 15047, deeded   => 18211,
                            deemed   => 3184, deeming  => 20932, deepa    => 27949, deepak   => 16666,
                            deepen   => 18501, deepened => 15549, deepening
                                     => 16011,
                            deepwater
                                     => 14662, deer     => 3577,
                            deerfield
                                     => 14950, defamation
                                     => 9747,
                            defamatory
                                     => 23884, default  => 4946,
                            defaulted
                                     => 20620, defaults => 24548,
                            defeat   => 1128, defeated => 662, defeating
                                     => 2148,
                            defeats  => 5642, defect   => 8165, defected => 9512, defecting
                                     => 26334,
                            defection
                                     => 13562, defections
                                     => 23996,
                            defectors
                                     => 20380, defects  => 7076,
                            defence  => 1434, defenceman
                                     => 9907,
                            defencemen
                                     => 29704, defences => 6420,
                            defendants
                                     => 6262, defended => 3012,
                            defender => 3048, defenders
                                     => 4677,
                            defends  => 11868, defense  => 899, defensed => 29235, defenseman
                                     => 14622,
                            defenses => 5836, defensible
                                     => 22264,
                            defensive
                                     => 1888, defensively
                                     => 19210,
                            defensor => 29786, deferred => 11139, defiance => 9334, deficiencies
                                     => 11035,
                            deficiency
                                     => 7215, deficient
                                     => 10950,
                            deficit  => 5601, deficits => 10948, definable
                                     => 29127,
                            define   => 3546, defined  => 1202, defines  => 4311, defining => 4855,
                            definition
                                     => 1845, definitions
                                     => 5061,
                            definitive
                                     => 6064, definitively
                                     => 13220,
                            deflation
                                     => 24143, deflected
                                     => 14724,
                            deflection
                                     => 14830, deflections
                                     => 27741,
                            deforestation
                                     => 10364, deformation
                                     => 10199,
                            deformations
                                     => 27860, deformities
                                     => 23380,
                            deftones => 28911, defunct  => 4180, degc     => 3886, degeneracy
                                     => 29670,
                            degenerated
                                     => 18278, degeneration
                                     => 13592,
                            degeneres
                                     => 17987, degli    => 14265,
                            degradation
                                     => 6363, degraded => 9187,
                            degrades => 24817, degree   => 528, degrees  => 1732, dehestan => 12857,
                            dehradun => 19139, dehydrogenase
                                     => 10543,
                            deified  => 25634, deities  => 6087, deity    => 4937, dejan    => 18452,
                            dejected => 29664, dekalb   => 13765, delaunay => 24236, delaware => 2893,
                            delayed  => 3206, delays   => 5516, delegate => 4495, delegated
                                     => 11218,
                            delegates
                                     => 3875, delegation
                                     => 4054,
                            delegations
                                     => 11565, deleted  => 7091,
                            deleterious
                                     => 20755, deleting => 21962,
                            deletion => 11795, deletions
                                     => 24462,
                            deleuze  => 26479, delft    => 13749, delgada  => 28603, delhi    => 2432,
                            deliberation
                                     => 14607, deliberations
                                     => 16062,
                            deliberative
                                     => 24814, delimitation
                                     => 14859,
                            delimited
                                     => 20941, delineated
                                     => 16267,
                            delineation
                                     => 26760, delinquency
                                     => 17216,
                            delisted => 16092, delius   => 25445, delivered
                                     => 1936,
                            delivers => 6993, "dell'arte"
                                     => 26957,
                            delle    => 11160, dello    => 21771, deloitte => 18097, delonge  => 29309,
                            delos    => 23652, delphi   => 12791, delray   => 24165, deluge   => 18128,
                            deluxe   => 6392, delved   => 29508, delves   => 24490, demand   => 1737,
                            demanded => 3442, demands  => 2967, demarcated
                                     => 23605,
                            demarcation
                                     => 15760, dementieva
                                     => 29437,
                            demerara => 28397, demersal => 28264, demesne  => 21829, demetrios
                                     => 27481,
                            demilitarized
                                     => 23595, demise   => 5092,
                            demo     => 4125, demobilisation
                                     => 25843,
                            demobilised
                                     => 29001, demobilization
                                     => 20639,
                            demobilized
                                     => 17075, democracies
                                     => 15534,
                            democracy
                                     => 2510, democrat => 2723,
                            democratic
                                     => 777, democratically
                                     => 14385,
                            democratization
                                     => 19060,
                            democrats
                                     => 2823, demographic
                                     => 5736,
                            demographics
                                     => 1759, demography
                                     => 9724,
                            demolish => 11853, demolished
                                     => 2519,
                            demolishing
                                     => 17445, demolition
                                     => 4625,
                            demonstrate
                                     => 4152, demonstrated
                                     => 2737,
                            demonstrates
                                     => 6622, demonstrating
                                     => 6255,
                            demonstration
                                     => 4064, demonstrations
                                     => 4943,
                            demonstrative
                                     => 22802, demonstrator
                                     => 16069,
                            demonstrators
                                     => 9708, demoralized
                                     => 24427,
                            demos    => 6912, demosthenes
                                     => 22846,
                            demoted  => 9463, demotic  => 29167, demotion => 20343, denali   => 23315,
                            denbigh  => 21575, denbighshire
                                     => 19774,
                            dench    => 24968, dendrites
                                     => 25566,
                            dendritic
                                     => 17334, dengeki  => 23558,
                            dengue   => 23845, denied   => 2313, denizens => 26017, denmark  => 1921,
                            denominated
                                     => 18683, denomination
                                     => 6226,
                            denominational
                                     => 10483,
                            denominations
                                     => 6041, denote   => 6978,
                            denoted  => 7032, denotes  => 6374, denoting => 11031, denounce => 16681,
                            denounced
                                     => 6585, denounces
                                     => 27258,
                            denouncing
                                     => 13420, dense    => 4127,
                            densely  => 7306, denser   => 16602, densities
                                     => 10935,
                            density  => 987, dentate  => 15306, dentistry
                                     => 9773,
                            dentition
                                     => 21209, denunciation
                                     => 22601,
                            denys    => 15006, depart   => 8012, departed => 2802, departement
                                     => 10122,
                            departements
                                     => 28999, departing
                                     => 6364,
                            department
                                     => 297, departmental
                                     => 10053,
                            departments
                                     => 2534, departs  => 10618,
                            departure
                                     => 2332, departures
                                     => 10848,
                            depeche  => 16990, dependence
                                     => 6879,
                            dependencies
                                     => 10399, dependency
                                     => 8842,
                            dependent
                                     => 2794, dependents
                                     => 17701,
                            depending
                                     => 1923, depict   => 6461,
                            depicted => 2978, depicting
                                     => 4182,
                            depiction
                                     => 5984, depictions
                                     => 7199,
                            depicts  => 4295, depleted => 8762, depleting
                                     => 27354,
                            depletion
                                     => 11830, deplored => 26001,
                            deploy   => 8025, deployable
                                     => 24499,
                            deployed => 2567, deploying
                                     => 11125,
                            deployment
                                     => 3895, deployments
                                     => 10198,
                            deploys  => 26159, depolarization
                                     => 25587,
                            depopulated
                                     => 17394, depopulation
                                     => 25120,
                            deportation
                                     => 8538, deportations
                                     => 16755,
                            deported => 6777, deportees
                                     => 27524,
                            deportes => 15122, deportiva
                                     => 22523,
                            deportivo
                                     => 8664, deposed  => 6651,
                            deposited
                                     => 5947, depositing
                                     => 21002,
                            depositors
                                     => 25627, deposits => 3695,
                            depot    => 3153, depots   => 10479, deprecated
                                     => 22250,
                            depreciation
                                     => 18934, depression
                                     => 2077,
                            depressions
                                     => 13283, deprivation
                                     => 10961,
                            deptford => 15777, depth    => 2126, deputation
                                     => 23259,
                            deputies => 4737, deputy   => 1249, derailment
                                     => 19104,
                            derbies  => 26692, derby    => 2549, derbyshire
                                     => 5379,
                            derecho  => 27079, deregulation
                                     => 13960,
                            dereham  => 29853, derelict => 10739, derided  => 17650, derivation
                                     => 8798,
                            derivations
                                     => 22642, derivative
                                     => 5028,
                            derivatives
                                     => 6113, derive   => 6724,
                            derived  => 1458, derives  => 4248, deriving => 11850, dermal   => 19838,
                            dermatitis
                                     => 18596, dermatology
                                     => 18896,
                            dermot   => 16203, derrida  => 17921, derulo   => 29431, dervish  => 23709,
                            derwent  => 13321, desalination
                                     => 18477,
                            descartes
                                     => 13382, descend  => 8799,
                            descendant
                                     => 4754, descendants
                                     => 2946,
                            descended
                                     => 4440, descendent
                                     => 17687,
                            descendents
                                     => 13956, descending
                                     => 6842,
                            descends => 8718, descent  => 2473, descentralizado
                                     => 28095,
                            deschutes
                                     => 29858, described
                                     => 355,
                            describes
                                     => 1716, describing
                                     => 2890,
                            description
                                     => 1077, descriptions
                                     => 5124,
                            descriptive
                                     => 8406, descriptor
                                     => 21321,
                            descriptors
                                     => 25023, desegregation
                                     => 15323,
                            deseret  => 18971, desert   => 2141, deserters
                                     => 17960,
                            desertification
                                     => 24075,
                            deserts  => 10359, deshmukh => 24990, deshpande
                                     => 29849,
                            design   => 327, designate
                                     => 8680,
                            designated
                                     => 1150, designates
                                     => 15929,
                            designating
                                     => 13884, designation
                                     => 2860,
                            designations
                                     => 8446, designator
                                     => 23643,
                            designed => 441, designer => 2160, designers
                                     => 4153,
                            designing
                                     => 4843, designs  => 1781,
                            desirability
                                     => 24791, desirable
                                     => 6599,
                            desired  => 3734, desiring => 16586, desktop  => 6034, desktops => 24449,
                            despatch => 22256, despatched
                                     => 19364,
                            despatches
                                     => 14314, despite  => 440,
                            despot   => 18843, dessau   => 16875, destination
                                     => 3133,
                            destinations
                                     => 4413, destino  => 28889,
                            destitute
                                     => 13943, destroyed
                                     => 1081,
                            destroyer
                                     => 3653, destroyers
                                     => 5143,
                            destruction
                                     => 2281, detachable
                                     => 17086,
                            detached => 5437, detachment
                                     => 4863,
                            detachments
                                     => 10579, detailed => 2364,
                            detailing
                                     => 7006, detained => 5847,
                            detainee => 18422, detainees
                                     => 9326,
                            detect   => 4898, detectable
                                     => 15494,
                            detected => 4645, detecting
                                     => 9923,
                            detection
                                     => 4161, detects  => 15584,
                            deter    => 11635, detergents
                                     => 24630,
                            deteriorated
                                     => 7516, deteriorating
                                     => 10141,
                            deterioration
                                     => 9451, determinant
                                     => 13026,
                            determinants
                                     => 17976, determination
                                     => 4417,
                            determinations
                                     => 23037,
                            determine
                                     => 1929, determined
                                     => 1498,
                            determines
                                     => 6249, determining
                                     => 4641,
                            determinism
                                     => 17356, deterministic
                                     => 13195,
                            deterred => 22467, deterrence
                                     => 17874,
                            detested => 27183, dethroned
                                     => 22586,
                            detonated
                                     => 11281, detoxification
                                     => 29776,
                            detractors
                                     => 15164, detrimental
                                     => 10504,
                            detritus => 20674, detroit  => 1801, deuterium
                                     => 19730,
                            deuteronomy
                                     => 19912, deutsche => 4850,
                            deutschen
                                     => 18511, deutscher
                                     => 13536,
                            deutsches
                                     => 16709, deutschland
                                     => 12880,
                            devaluation
                                     => 20084, devalued => 28795,
                            devanagari
                                     => 17455, devarajan
                                     => 29991,
                            devas    => 21729, develop  => 1254, developed
                                     => 379,
                            developer
                                     => 3652, developers
                                     => 3591,
                            developing
                                     => 1486, development
                                     => 225,
                            developmental
                                     => 5405, developmentally
                                     => 26869,
                            developments
                                     => 2875, develops => 4355,
                            deventer => 27991, devi     => 6037, deviates => 23514, deviation
                                     => 8802,
                            deviations
                                     => 13418, device   => 1697,
                            devices  => 1890, devils   => 5325, devised  => 5691, devises  => 26958,
                            devizes  => 22393, devoid   => 11208, devolution
                                     => 15413,
                            devolved => 13389, devonian => 11368, devonport
                                     => 13196,
                            devonshire
                                     => 11712, devoted  => 2627,
                            devotee  => 13433, devotees => 7884, devotes  => 18599, devotional
                                     => 10494,
                            devotions
                                     => 21839, devout   => 9587,
                            dewsbury => 17695, dexterity
                                     => 20414,
                            dezong   => 18739, dhabi    => 8954, dhaka    => 6788, dhamma   => 25440,
                            dharma   => 7938, dharwad  => 22657, dhawan   => 26848, dhivehi  => 28156,
                            dhoni    => 29855, diabetes => 5586, diacritic
                                     => 25167,
                            diacritics
                                     => 20261, diadem   => 27861,
                            diaghilev
                                     => 26803, diagnosed
                                     => 4364,
                            diagnoses
                                     => 16766, diagnostic
                                     => 6223,
                            diagnostics
                                     => 14782, diagonal => 7902,
                            diagonally
                                     => 15004, diagonals
                                     => 25724,
                            diagram  => 6242, diagrams => 9604, dialect  => 3336, dialectal
                                     => 22524,
                            dialectic
                                     => 19637, dialectical
                                     => 18579,
                            dialects => 4308, dialog   => 11704, dialogue => 3144, dialogues
                                     => 9528,
                            diameter => 2490, diameters
                                     => 15479,
                            diamondbacks
                                     => 11883, diaries  => 7573,
                            diario   => 17847, diarist  => 23933, diaspora => 6889, diatoms  => 27845,
                            diatonic => 17887, dichomeris
                                     => 17905,
                            dichotomy
                                     => 16757, dictated => 9495,
                            dictator => 8123, dictatorial
                                     => 17978,
                            dictatorship
                                     => 7114, diction  => 19655,
                            dictionaries
                                     => 10645, dictionary
                                     => 3848,
                            dictionnaire
                                     => 29308, dictum   => 29840,
                            didactic => 17008, diddley  => 22603, diderot  => 21445, died     => 211,
                            dielectric
                                     => 12835, diels    => 29206,
                            diemen   => 18959, dieppe   => 15757, diesel   => 2925, diesels  => 19052,
                            dietary  => 8491, diets    => 11845, differ   => 4051, differed => 7228,
                            differences
                                     => 1902, different
                                     => 238,
                            differentiable
                                     => 16446,
                            differential
                                     => 4296, differentials
                                     => 23118,
                            differentiate
                                     => 7769, differentiated
                                     => 8785,
                            differentiates
                                     => 19552,
                            differentiating
                                     => 16789,
                            differentiation
                                     => 7556,
                            differing
                                     => 6276, differs  => 4600,
                            difficulties
                                     => 2869, difficulty
                                     => 3055,
                            diffraction
                                     => 11296, diffuse  => 10608,
                            diffused => 21465, diffusion
                                     => 7149,
                            digestive
                                     => 11273, digimon  => 17907,
                            digipak  => 27007, digit    => 5880, digital  => 887, digitally
                                     => 7048,
                            digitisation
                                     => 28935, digitised
                                     => 26520,
                            digitization
                                     => 26364, digitized
                                     => 15809,
                            digits   => 6617, dignitaries
                                     => 10171,
                            digraph  => 28108, digraphs => 28963, dihedral => 19892, dijon    => 14408,
                            dilapidated
                                     => 12326, dilemmas => 20472,
                            diliman  => 24971, dilip    => 19591, dilute   => 16216, diluted  => 15198,
                            dilution => 17039, dimensional
                                     => 3244,
                            dimensionality
                                     => 29367,
                            dimensionless
                                     => 21372, dimensions
                                     => 3683,
                            dimer    => 20436, dimethyl => 25774, diminished
                                     => 6519,
                            diminishes
                                     => 23818, diminishing
                                     => 12081,
                            diminutive
                                     => 10999, dimitar  => 21367,
                            dimitrie => 29136, dimitrios
                                     => 21365,
                            dimitris => 19933, dimitrov => 19123, dimorphic
                                     => 22350,
                            dimorphism
                                     => 16386, dinamo   => 8368,
                            dinar    => 20574, dinars   => 29901, dinas    => 29947, dinesh   => 21010,
                            dingoes  => 28949, diocesan => 7318, diocese  => 1867, dioceses => 8602,
                            diocletian
                                     => 15096, diode    => 13241,
                            diodes   => 16692, diodorus => 20383, dioecious
                                     => 24904,
                            diogenes => 19494, diogo    => 18297, dionysius
                                     => 13050,
                            dionysus => 15919, dioxide  => 5417, diphosphate
                                     => 19092,
                            diphthong
                                     => 26670, diphthongs
                                     => 18454,
                            diplo    => 28828, diploid  => 18001, diploma  => 3881, diplomacy
                                     => 6845,
                            diplomas => 12113, diplomat => 4466, diplomatic
                                     => 2760,
                            diplomats
                                     => 8580, dipole   => 12828,
                            diptera  => 24492, dirac    => 13854, direct   => 875, directed => 502,
                            directing
                                     => 3878, direction
                                     => 1074,
                            directional
                                     => 7878, directive
                                     => 6445,
                            directives
                                     => 12802, directly => 936,
                            director => 294, directorate
                                     => 6271,
                            directorates
                                     => 24896, directorial
                                     => 8286,
                            directories
                                     => 13925, directors
                                     => 1731,
                            directorship
                                     => 14815, directory
                                     => 5715,
                            directs  => 8837, directv  => 14475, directx  => 23257, dirichlet
                                     => 18583,
                            disabilities
                                     => 5450, disability
                                     => 4988,
                            disabled => 3921, disabling
                                     => 17026,
                            disadvantage
                                     => 8086, disadvantaged
                                     => 9794,
                            disadvantages
                                     => 8904, disaffected
                                     => 19751,
                            disagreed
                                     => 7843, disagreements
                                     => 8394,
                            disallowed
                                     => 15695, disambiguation
                                     => 1554,
                            disapproval
                                     => 11223, disapproved
                                     => 12830,
                            disarmament
                                     => 10747, disassembled
                                     => 17270,
                            disasters
                                     => 7157, disband  => 12983,
                            disbanded
                                     => 3094, disbanding
                                     => 11197,
                            disbandment
                                     => 14235, disc     => 2048,
                            discal   => 12282, discard  => 15264, discarded
                                     => 7539,
                            discarding
                                     => 20677, discards => 27808,
                            discern  => 16876, discerned
                                     => 22343,
                            discernible
                                     => 17074, discharge
                                     => 4601,
                            discharged
                                     => 5774, discharges
                                     => 12142,
                            disciple => 7004, disciples
                                     => 6515,
                            disciplinarian
                                     => 28952,
                            disciplinary
                                     => 6855, discipline
                                     => 3494,
                            disciplines
                                     => 4469, disclaimer
                                     => 20336,
                            disclose => 10304, disclosed
                                     => 8253,
                            discloses
                                     => 29620, disclosing
                                     => 19847,
                            disclosures
                                     => 18002, discography
                                     => 3443,
                            discontent
                                     => 10261, discontented
                                     => 28037,
                            discontinuation
                                     => 15601,
                            discontinued
                                     => 3318, discontinuing
                                     => 26289,
                            discontinuity
                                     => 20530, discontinuous
                                     => 17371,
                            discos   => 26091, discounted
                                     => 11192,
                            discounts
                                     => 13923, discourages
                                     => 25746,
                            discourse
                                     => 6177, discourses
                                     => 13019,
                            discovered
                                     => 935, discoverer
                                     => 13808,
                            discoverers
                                     => 28625, discoveries
                                     => 6105,
                            discovering
                                     => 6059, discovers
                                     => 3405,
                            discovery
                                     => 1792, discredited
                                     => 13995,
                            discrete => 6120, discretionary
                                     => 15801,
                            discriminant
                                     => 28229, discriminate
                                     => 14860,
                            discriminated
                                     => 15489, discrimination
                                     => 3463,
                            discriminatory
                                     => 11260,
                            discs    => 5990, discursive
                                     => 29126,
                            discus   => 8991, discusses
                                     => 6194,
                            discussions
                                     => 3948, discworld
                                     => 22355,
                            disease  => 1234, diseases => 2865, disembark
                                     => 23868,
                            disembarked
                                     => 15574, disembarking
                                     => 26963,
                            disembodied
                                     => 24833, disenchanted
                                     => 19931,
                            disenfranchised
                                     => 21000,
                            disengagement
                                     => 22207, disestablished
                                     => 19353,
                            disestablishment
                                     => 26319,
                            disguising
                                     => 24424, disinfection
                                     => 28137,
                            disintegration
                                     => 13542,
                            disjoint => 17926, disjointed
                                     => 24376,
                            disjunct => 26430, disk     => 3752, disliked => 8091, dislocation
                                     => 18392,
                            dislocations
                                     => 26986, dismantled
                                     => 6600,
                            dismantling
                                     => 13368, dismay   => 10881,
                            dismayed => 16380, dismembered
                                     => 21608,
                            dismissal
                                     => 6119, dismissals
                                     => 22632,
                            dismissed
                                     => 2773, dismisses
                                     => 14358,
                            dismounted
                                     => 15915, disney   => 2193,
                            disobedience
                                     => 12123, disorder => 3315,
                            disordered
                                     => 20358, disorders
                                     => 4077,
                            disparate
                                     => 11892, disparities
                                     => 16183,
                            disparity
                                     => 12508, dispatched
                                     => 5821,
                            dispatches
                                     => 11804, dispatching
                                     => 19609,
                            dispel   => 23289, dispensary
                                     => 15706,
                            dispensation
                                     => 16732, dispensed
                                     => 16720,
                            dispersal
                                     => 9733, disperse => 10860,
                            dispersed
                                     => 6161, dispersing
                                     => 21658,
                            dispersion
                                     => 10343, displaced
                                     => 4992,
                            displacement
                                     => 5298, displacements
                                     => 22584,
                            displacing
                                     => 15251, display  => 1531,
                            displayed
                                     => 2580, displaying
                                     => 6434,
                            displays => 3237, disposals
                                     => 20441,
                            disposed => 8932, dispositions
                                     => 20912,
                            dispossessed
                                     => 20801, disproportionate
                                     => 14157,
                            disproportionately
                                     => 16156,
                            disproved
                                     => 22906, dispute  => 2539,
                            disputed => 4170, disputes => 4250, disqualification
                                     => 10192,
                            disqualified
                                     => 7448, disregarded
                                     => 15273,
                            disregarding
                                     => 20399, disrepair
                                     => 9793,
                            disrupted
                                     => 7899, disruption
                                     => 7936,
                            disruptions
                                     => 17361, disruptive
                                     => 13539,
                            dissatisfaction
                                     => 10097,
                            dissatisfied
                                     => 9494, disseminate
                                     => 15049,
                            disseminated
                                     => 13946, disseminating
                                     => 18371,
                            dissemination
                                     => 10020, dissension
                                     => 22287,
                            dissent  => 8434, dissented
                                     => 20412,
                            dissenters
                                     => 15677, dissenting
                                     => 11364,
                            dissertation
                                     => 6149, dissertations
                                     => 20554,
                            dissident
                                     => 10476, dissidents
                                     => 12206,
                            dissipated
                                     => 9534, dissipating
                                     => 16951,
                            dissipation
                                     => 16565, dissociation
                                     => 15568,
                            dissolution
                                     => 4425, dissolved
                                     => 3198,
                            dissolves
                                     => 17597, dissolving
                                     => 13904,
                            dissonance
                                     => 18198, dissonant
                                     => 24446,
                            dissuaded
                                     => 25232, distal   => 10532,
                            distance => 999, distanced
                                     => 13947,
                            distances
                                     => 4587, distant  => 3676,
                            distantly
                                     => 15897, distillation
                                     => 12337,
                            distilled
                                     => 13037, distilleries
                                     => 21669,
                            distillers
                                     => 22660, distillery
                                     => 9119,
                            distilling
                                     => 22219, distinct => 1858,
                            distinction
                                     => 2644, distinctions
                                     => 8515,
                            distinctive
                                     => 2789, distinctively
                                     => 15510,
                            distinctiveness
                                     => 27499,
                            distinguish
                                     => 3980, distinguishable
                                     => 13375,
                            distinguished
                                     => 1668, distinguishes
                                     => 9245,
                            distinguishing
                                     => 7285, distorted
                                     => 8713,
                            distorting
                                     => 24799, distortion
                                     => 7933,
                            distortions
                                     => 16672, distribute
                                     => 6078,
                            distributed
                                     => 1723, distributes
                                     => 10425,
                            distributing
                                     => 7443, distribution
                                     => 912,
                            distributions
                                     => 7323, distributive
                                     => 20428,
                            distributor
                                     => 6526, distributors
                                     => 8090,
                            district => 104, districts
                                     => 1171,
                            distrito => 20046, distrusted
                                     => 24296,
                            disturbances
                                     => 8910, disulfide
                                     => 16863,
                            disuse   => 13833, disused  => 9382, ditches  => 11375, ditton   => 26601,
                            diurnal  => 13647, divan    => 24270, divas    => 14154, dived    => 19119,
                            diver    => 7722, diverge  => 17004, diverged => 13235, divergence
                                     => 10565,
                            divergent
                                     => 11365, diverges => 20438,
                            diverging
                                     => 19682, diverse  => 2557,
                            diversification
                                     => 13159,
                            diversified
                                     => 8507, diversifying
                                     => 27022,
                            diversity
                                     => 3329, diverted => 7387,
                            diverts  => 29080, divested => 18331, divestment
                                     => 27402,
                            divide   => 4514, divided  => 995, dividend => 12646, dividends
                                     => 12862,
                            divider  => 24272, divides  => 7409, dividing => 6228, divination
                                     => 16157,
                            divine   => 3091, divinely => 23904, diving   => 3819, divinity => 6587,
                            divisao  => 23510, divisible
                                     => 18489,
                            divisie  => 18150, division => 221, divisional
                                     => 5631,
                            divisione
                                     => 15087, divisions
                                     => 1728,
                            divisive => 16770, divisor  => 19169, divisors => 24051, divizia  => 22911,
                            divya    => 17856, diwali   => 19359, diwan    => 16366, dixieland
                                     => 21904,
                            dixit    => 22388, diyarbakir
                                     => 23338,
                            django   => 17408, djibouti => 11763, djing    => 24893, djokovic => 13391,
                            djurgarden
                                     => 26157, djurgardens
                                     => 23438,
                            dmitry   => 9107, dmytro   => 25974, dnieper  => 16683, dniester => 24347,
                            dnipro   => 24278, dnipropetrovsk
                                     => 17519,
                            dobie    => 23812, dobro    => 27842, dobruja  => 26450, doc      => 20,
                            docent   => 23807, docked   => 10856, docklands
                                     => 15699,
                            dockyard => 9423, dockyards
                                     => 25652,
                            doctoral => 4460, doctorate
                                     => 3526,
                            doctorates
                                     => 12741, doctrinal
                                     => 12606,
                            doctrine => 3183, doctrines
                                     => 8357,
                            docudrama
                                     => 25580, document => 2236,
                            documenta
                                     => 29631, documentaries
                                     => 5739,
                            documentary
                                     => 1457, documentation
                                     => 4969,
                            documented
                                     => 3216, documenting
                                     => 8641,
                            documents
                                     => 1884, dodecahedron
                                     => 26824,
                            dodgers  => 5083, dogfight => 25931, dogma    => 12992, dogmatic => 16694,
                            dolmen   => 25789, dolomite => 17823, dolomites
                                     => 29693,
                            dolphins => 5358, domain   => 2029, domaine  => 24110, domains  => 4896,
                            dome     => 3529, domed    => 11543, domenico => 9505, domes    => 10039,
                            domesday => 7710, domestic => 1496, domestically
                                     => 9565,
                            domesticated
                                     => 10996, domestication
                                     => 18552,
                            domhnall => 29513, dominance
                                     => 5362,
                            dominant => 2646, dominate => 6112, dominated
                                     => 2280,
                            dominates
                                     => 10103, dominating
                                     => 8324,
                            domination
                                     => 6801, domingos => 26666,
                            domini   => 15276, dominican
                                     => 3774,
                            dominicans
                                     => 15032, dominion => 5462,
                            dominions
                                     => 13022, dominus  => 27132,
                            domitian => 20487, domnall  => 24343, domus    => 23550, donal    => 18543,
                            donated  => 2419, donatello
                                     => 20148,
                            donates  => 20075, donations
                                     => 4213,
                            donau    => 26302, donbass  => 19979, doncaster
                                     => 6943,
                            donegal  => 8812, donetsk  => 9637, dongguan => 29189, donington
                                     => 18296,
                            donitz   => 26801, donizetti
                                     => 16523,
                            donja    => 25430, donji    => 20960, donne    => 17541, donned   => 19268,
                            donning  => 22887, donors   => 6730, doordarshan
                                     => 20158,
                            dopamine => 10931, dopaminergic
                                     => 29647,
                            doping   => 8637, doppler  => 11659, dorchester
                                     => 9781,
                            dorde    => 26709, dordevic => 28869, dordogne => 18809, dordrecht
                                     => 20121,
                            doric    => 11923, dorid    => 26886, dorje    => 20879, dorking  => 24398,
                            dormancy => 24809, dormant  => 9139, dormer   => 16967, dormers  => 19373,
                            dormitories
                                     => 11770, dormitory
                                     => 8599,
                            dorsal   => 4888, dorsally => 21114, dorset   => 5727, dorsum   => 14139,
                            dortmund => 9336, doses    => 8315, dosing   => 25506, dothan   => 27360,
                            douai    => 19385, douala   => 23024, double   => 858, doubled  => 5127,
                            doubleheader
                                     => 19357, doubles  => 2326,
                            doublet  => 29436, doubling => 8067, doubs    => 21582, doubtless
                                     => 20818,
                            douro    => 20989, dowager  => 8214, dowlatabad
                                     => 29250,
                            downbeat => 25490, downed   => 10111, downfall => 8462, downforce
                                     => 29158,
                            downgraded
                                     => 11908, download => 3540,
                            downloadable
                                     => 9367, downloads
                                     => 8036,
                            downplayed
                                     => 21434, downsized
                                     => 24211,
                            downstream
                                     => 5079, downton  => 22362,
                            downtown => 1608, downturn => 11613, downward => 7930, downwards
                                     => 12384,
                            downwind => 25113, dowry    => 10710, "dr."    => 761, draco    => 19203,
                            draconian
                                     => 26458, draft    => 1209,
                            drafted  => 2505, drafting => 7873, drafts   => 10487, draftsman
                                     => 17433,
                            dragan   => 15992, dragon   => 2436, dragonflies
                                     => 23142,
                            dragonlance
                                     => 25709, dragons  => 3701,
                            dragoon  => 12552, dragoons => 10320, drainage => 4349, drainages
                                     => 27604,
                            drained  => 6698, draining => 9958, drains   => 7363, drama    => 985,
                            dramas   => 6013, dramatic => 2548, dramatically
                                     => 4904,
                            dramatised
                                     => 25583, dramatist
                                     => 11619,
                            dramatists
                                     => 20736, dramatization
                                     => 26834,
                            dramatized
                                     => 19336, drammen  => 19985,
                            drapery  => 21596, drastically
                                     => 8094,
                            draught  => 10243, draughts => 26420, draughtsman
                                     => 17709,
                            draupadi => 28888, drava    => 18731, dravid   => 27345, dravida  => 16941,
                            dravidian
                                     => 15648, draw     => 1330,
                            drawdown => 28131, drawing  => 2191, drawings => 3735, drawn    => 1744,
                            draws    => 4035, dreadnought
                                     => 15138,
                            dreadnoughts
                                     => 21894, dreamcast
                                     => 16233,
                            dreamland
                                     => 24160, dreamwave
                                     => 26432,
                            dreamworks
                                     => 13302, dredd    => 13789,
                            drenthe  => 22551, dresden  => 5421, dressage => 12909, dressings
                                     => 17006,
                            drexel   => 12559, dreyfus  => 12098, driest   => 16855, drifters => 22309,
                            drilled  => 10368, drillers => 28180, drilling => 6278, drina    => 25866,
                            driven   => 2052, drivers  => 2488, drivetrain
                                     => 23683,
                            drizzt   => 27375, drogheda => 15950, droit    => 22118, drome    => 23210,
                            drone    => 9303, drooping => 27547, droplet  => 23464, droplets => 15012,
                            drosera  => 25983, drosophila
                                     => 14019,
                            drought  => 5747, droughts => 15621, druce    => 25659, druid    => 15210,
                            druids   => 18286, drum     => 2836, drummer  => 2408, drummers => 11778,
                            drumming => 9827, drums    => 2359, druze    => 12977, dryandra => 25937,
                            drydock  => 16250, dryness  => 28214, dual     => 2425, dualism  => 19930,
                            duality  => 12306, dubai    => 4497, dubbed   => 3416, dubbing  => 11870,
                            dubbo    => 27999, dublin   => 1910, dubliners
                                     => 27525,
                            dubrovnik
                                     => 12997, dubstep  => 18199,
                            ducal    => 11463, ducati   => 17748, ducats   => 26007, duchies  => 16567,
                            duchovny => 22129, duchy    => 3896, ductile  => 27704, due      => 184,
                            duel     => 6179, duels    => 17782, duet     => 4986, duets    => 10830,
                            dufferin => 17869, dugdale  => 24377, dugouts  => 27769, duisburg => 14105,
                            dukakis  => 22616, dukedom  => 17729, dukla    => 22271, dulcimer => 28766,
                            duller   => 22132, duluth   => 9853, dulwich  => 14524, dumbarton
                                     => 11783,
                            dumfries => 11633, dumitru  => 26440, dunams   => 17792, dunbartonshire
                                     => 24960,
                            dunblane => 27586, dundalk  => 14414, dundee   => 5353, dunder   => 29003,
                            dunedin  => 8244, dunes    => 7233, dunfermline
                                     => 12373,
                            dungannon
                                     => 22547, dungeons => 6657,
                            dunhill  => 26171, dunhuang => 28917, dunkeld  => 24741, dunkirk  => 10972,
                            dunstable
                                     => 21739, dunster  => 29771,
                            dunwich  => 27504, duodenum => 29847, duomo    => 25434, duopoly  => 23662,
                            dupage   => 25600, duplicated
                                     => 12883,
                            duplicates
                                     => 20057, duplication
                                     => 12443,
                            dupri    => 26673, duquesne => 12231, durability
                                     => 10975,
                            durable  => 9200, durango  => 12476, duration => 3602, durations
                                     => 22733,
                            durban   => 9031, durbar   => 21173, durer    => 18753, durga    => 10656,
                            durgapur => 25736, during   => 41, durkheim => 22188, durrani  => 18701,
                            durres   => 21217, duryodhana
                                     => 27576,
                            dusan    => 13329, dushanbe => 26534, dusky    => 15595, dusseldorf
                                     => 7529,
                            dutch    => 892, dutchess => 18647, dutchman => 14230, duties   => 1876,
                            duvalier => 27609, duxbury  => 28380, dvina    => 28148, dwarf    => 5439,
                            dwarfed  => 29822, dwarfism => 28973, dwarfs   => 12156, dwarka   => 28630,
                            dwarves  => 13580, dwellers => 10280, dwelling => 5403, dwellings
                                     => 6288,
                            dwelt    => 20756, dwindled => 12962, dwindling
                                     => 13523,
                            dynamic  => 3257, dynamical
                                     => 12720,
                            dynamically
                                     => 13281, dynamics => 4278,
                            dynamism => 24568, dynamo   => 6573, dynamos  => 22960, dynastic => 10610,
                            dynasties
                                     => 8065, dynasty  => 1556,
                            dyschirius
                                     => 28731, dysentery
                                     => 17418,
                            dysfunction
                                     => 10549, dysplasia
                                     => 19466,
                            dystopian
                                     => 18440, dystrophy
                                     => 18677,
                            "e.g."   => 3203, e9e9e9   => 13189, each     => 124, eagerness
                                     => 25872,
                            eagle    => 2545, eagles   => 2934, ealing   => 12546, eamon    => 16152,
                            eamonn   => 18880, eared    => 13369, earldom  => 10193, earlier  => 656,
                            earliest => 1780, early    => 95, earmarked
                                     => 14740,
                            earned   => 862, earner   => 27358, earners  => 20740, earnestly
                                     => 28858,
                            earning  => 2649, earnings => 6406, earns    => 11357, earth    => 743,
                            earthen  => 12954, earthenware
                                     => 20676,
                            earthquake
                                     => 2927, earthquakes
                                     => 6546,
                            earths   => 16291, earthwork
                                     => 19243,
                            earthworks
                                     => 12506, earthworms
                                     => 24384,
                            eased    => 14374, easement => 21164, easily   => 1654, east     => 138,
                            eastbound
                                     => 9038, eastbourne
                                     => 12386,
                            eastenders
                                     => 8931, eastern  => 393,
                            easternmost
                                     => 11531, eastgate => 28517,
                            eastlake => 25503, eastleigh
                                     => 19530,
                            eastward => 6465, eastwards
                                     => 10233,
                            eateries => 23283, ebbsfleet
                                     => 27451,
                            ebenezer => 12149, ebook    => 20869, ebooks   => 26375, ebrahim  => 20839,
                            eccellenza
                                     => 23308, eccentricity
                                     => 14879,
                            ecclesia => 23702, ecclesiastic
                                     => 23002,
                            ecclesiastical
                                     => 4378, ecclestone
                                     => 27384,
                            echelons => 21796, echoed   => 10460, echoes   => 9328, echoing  => 14637,
                            echolocation
                                     => 27680, ecija    => 22848,
                            eclectic => 7689, eclecticism
                                     => 28835,
                            eclipse  => 5332, eclipsed => 12713, eclipses => 15605, eclipsing
                                     => 22818,
                            ecliptic => 20997, ecole    => 5659, ecoles   => 25698, ecological
                                     => 4689,
                            ecologically
                                     => 17029, ecologist
                                     => 19027,
                            ecologists
                                     => 25048, ecology  => 3985,
                            ecommerce
                                     => 26781, econometric
                                     => 27760,
                            econometrics
                                     => 24203, economic => 587,
                            economical
                                     => 7701, economically
                                     => 5611,
                            economics
                                     => 1864, economies
                                     => 6872,
                            economist
                                     => 4704, economists
                                     => 7888,
                            economy  => 1057, ecoregion
                                     => 12466,
                            ecoregions
                                     => 20451, ecosystem
                                     => 6630,
                            ecosystems
                                     => 7775, ecotourism
                                     => 18717,
                            ecowas   => 28383, ecozone  => 18224, ecuador  => 4019, ecuadorian
                                     => 10401,
                            ecumenical
                                     => 8424, ecumenism
                                     => 27884,
                            edessa   => 18616, edgbaston
                                     => 19151,
                            edge     => 1362, edged    => 7433, edges    => 4020, edgewater
                                     => 21727,
                            edgewood => 19121, edging   => 16750, edgware  => 22083, edible   => 8117,
                            edict    => 8902, edicts   => 17944, edifice  => 12261, edifices => 24807,
                            edina    => 24419, edinburgh
                                     => 2171,
                            edirne   => 23357, edited   => 2053, editing  => 3862, edition  => 715,
                            editions => 2440, editor   => 890, editorial
                                     => 3160,
                            editorials
                                     => 12096, editors  => 3958,
                            editorship
                                     => 14056, edits    => 12479,
                            edmonton => 3821, edoardo  => 25153, edouard  => 9095, edsel    => 23332,
                            eduard   => 8422, educate  => 6524, educated => 1508, educates => 16073,
                            educating
                                     => 9156, education
                                     => 218,
                            educational
                                     => 1212, educationalist
                                     => 25995,
                            educationist
                                     => 21736, educations
                                     => 27971,
                            educator => 4832, educators
                                     => 7136,
                            edvard   => 15384, edwardes => 25989, edwardian
                                     => 13258,
                            edwardsville
                                     => 27821, eelam    => 20586,
                            eerste   => 15359, eesti    => 25618, efendi   => 24921, effect   => 807,
                            effected => 11236, effective
                                     => 1382,
                            effectively
                                     => 2214, effectiveness
                                     => 4568,
                            effector => 24266, effects  => 989, effendi  => 19903, efficacy => 7643,
                            efficiencies
                                     => 17842, efficiency
                                     => 2985,
                            efficient
                                     => 3057, efficiently
                                     => 7491,
                            effigies => 22796, effigy   => 13545, effingham
                                     => 22031,
                            effluent => 20271, effort   => 1271, effortlessly
                                     => 21409,
                            efforts  => 1051, egalitarian
                                     => 15656,
                            eglin    => 19965, eglinton => 14580, eglise   => 21208, egmont   => 19941,
                            egremont => 27727, egret    => 27148, egrets   => 19940, egypt    => 1672,
                            egyptian => 2356, egyptians
                                     => 8508,
                            egyptologist
                                     => 22824, egyptologists
                                     => 25358,
                            egyptology
                                     => 26232, ehime    => 23790,
                            eifel    => 22518, eigenvalue
                                     => 19110,
                            eigenvalues
                                     => 15086, eigenvectors
                                     => 26863,
                            eight    => 478, eighteens
                                     => 13859,
                            eighteenth
                                     => 5258, eighth   => 2007,
                            eilat    => 23983, eilean   => 23715, einar    => 15526, eindhoven
                                     => 11377,
                            einer    => 29195, eintracht
                                     => 15291,
                            eireann  => 9293, eisenach => 19568, eisenbahn
                                     => 25590,
                            eisenhower
                                     => 6334, eishockey
                                     => 23061,
                            eisteddfod
                                     => 19520, ejaculation
                                     => 25528,
                            ejecta   => 24028, ejected  => 8644, ejection => 13935, ejercito => 29945,
                            ekaterina
                                     => 19310, ekiti    => 23046,
                            ekstraklasa
                                     => 21539, elaborate
                                     => 4097,
                            elaborated
                                     => 9432, elaborately
                                     => 15349,
                            elaborates
                                     => 23139, elaborating
                                     => 25523,
                            elaboration
                                     => 16748, elachista
                                     => 16339,
                            elachistidae
                                     => 26510, elapsed  => 16904,
                            elastic  => 9118, elasticity
                                     => 15060,
                            elblag   => 22686, elche    => 26775, eldar    => 28698, elderly  => 4313,
                            eldest   => 2688, eldorado => 16377, eleazar  => 20513, elect    => 4449,
                            elected  => 366, electing => 10615, election => 276, elections
                                     => 855,
                            elective => 10329, electives
                                     => 16983,
                            elector  => 7789, electoral
                                     => 1770,
                            electorate
                                     => 4741, electorates
                                     => 12237,
                            electors => 7845, electric => 1120, electrical
                                     => 2183,
                            electrically
                                     => 10021, electricity
                                     => 2438,
                            electrics
                                     => 26453, electrification
                                     => 8328,
                            electrified
                                     => 7234, electrifying
                                     => 26727,
                            electro  => 6389, electroacoustic
                                     => 25016,
                            electrochemical
                                     => 17130,
                            electrocution
                                     => 28918, electrode
                                     => 9732,
                            electrodes
                                     => 10665, electrodynamics
                                     => 24577,
                            electrolysis
                                     => 21255, electrolyte
                                     => 14048,
                            electrolytic
                                     => 21083, electromagnetic
                                     => 6528,
                            electromagnetism
                                     => 22701,
                            electromechanical
                                     => 20732,
                            electron => 3923, electronic
                                     => 1504,
                            electronica
                                     => 10891, electronically
                                     => 10349,
                            electronics
                                     => 3269, electrons
                                     => 5499,
                            electrophilic
                                     => 28956, electrophoresis
                                     => 21670,
                            electropop
                                     => 19620, electrostatic
                                     => 12994,
                            elects   => 9332, elegans  => 13518, elegantly
                                     => 22633,
                            elegiac  => 27958, elegies  => 28837, elegy    => 16749, elektra  => 12021,
                            element  => 1982, elemental
                                     => 10250,
                            elementary
                                     => 1803, elements => 941,
                            elevated => 3053, elevating
                                     => 17985,
                            elevation
                                     => 2219, elevations
                                     => 6813,
                            eleventh => 4506, elfin    => 29587, elfman   => 27118, elfsborg => 28000,
                            elgar    => 13224, eliade   => 25097, elicit   => 15956, elicited => 17422,
                            eliciting
                                     => 29735, eliezer  => 16382,
                            eligibility
                                     => 6192, eligible => 2743,
                            elihu    => 25818, eliminated
                                     => 2304,
                            eliminates
                                     => 12248, eliminating
                                     => 5956,
                            elimination
                                     => 3740, eliminations
                                     => 21775,
                            eliminator
                                     => 23575, eliot    => 7209,
                            elite    => 2640, elites   => 10525, elitserien
                                     => 15592,
                            eliya    => 29375, eliyahu  => 24444, elizabethan
                                     => 10547,
                            elizabethtown
                                     => 20693, elkhart  => 20681,
                            elkhorn  => 22173, elland   => 21150, ellesmere
                                     => 15664,
                            ellice   => 26921, ellipse  => 17516, ellipsoid
                                     => 18255,
                            elliptic => 10488, elliptical
                                     => 9856,
                            elmhurst => 22444, elmwood  => 17197, elongate => 14165, elongated
                                     => 7334,
                            elongation
                                     => 19244, eloquence
                                     => 18130,
                            elphaba  => 27325, elphinstone
                                     => 20137,
                            elsevier => 19519, elsewhere
                                     => 2525,
                            elstree  => 23294, eltham   => 21105, elucidate
                                     => 27202,
                            elucidated
                                     => 23788, elven    => 18975,
                            elwes    => 27211, elysees  => 20577, elysium  => 28597, elytra   => 26765,
                            emacs    => 25665, email    => 4990, emails   => 10980, emamzadeh
                                     => 23975,
                            emanating
                                     => 16935, emancipation
                                     => 8319,
                            embankment
                                     => 9247, embankments
                                     => 18761,
                            embarcadero
                                     => 29061, embargo  => 11042,
                            embarkation
                                     => 21858, embarked => 4145,
                            embarking
                                     => 12265, embarks  => 21046,
                            embassies
                                     => 10256, embassy  => 3174,
                            embattled
                                     => 20541, embed    => 24606,
                            embedded => 4674, embedding
                                     => 13578,
                            embellished
                                     => 14611, embellishment
                                     => 29636,
                            embellishments
                                     => 24388,
                            emblazoned
                                     => 20269, emblem   => 6297,
                            emblematic
                                     => 17402, emblems  => 14086,
                            embodied => 9491, embodies => 15230, embody   => 17063, embodying
                                     => 24621,
                            emboldened
                                     => 27433, embossed => 18303,
                            embraced => 6945, embraces => 12764, embraer  => 19257, embroidered
                                     => 12119,
                            embroidery
                                     => 11750, embroiled
                                     => 11823,
                            embryo   => 10267, embryology
                                     => 26354,
                            embryonic
                                     => 10584, emcee    => 19664,
                            emden    => 18366, emerge   => 5478, emerged  => 2382, emergence
                                     => 5175,
                            emergent => 13081, emerges  => 7823, emerging => 3213, emeritus => 5178,
                            emigrant => 15547, emigrants
                                     => 10632,
                            emigrate => 12317, emigrated
                                     => 4059,
                            emigrating
                                     => 15770, emigration
                                     => 6948,
                            emigre   => 15968, emigres  => 20623, emiliano => 20974, eminem   => 10321,
                            eminent  => 5532, eminescu => 29785, emirate  => 12705, emirates => 5704,
                            emirati  => 27424, emirs    => 28782, emissaries
                                     => 18000,
                            emission => 5920, emissions
                                     => 4343,
                            emits    => 15607, emitted  => 9524, emitter  => 18208, emitters => 29706,
                            emitting => 12530, emlyn    => 28846, emmanuelle
                                     => 23771,
                            emmaus   => 24715, emmeline => 28128, emmerdale
                                     => 14997,
                            emmet    => 17183, emmylou  => 24338, emotive  => 21016, emperor  => 901,
                            emperors => 7040, emphasis => 2812, emphasise
                                     => 16966,
                            emphasised
                                     => 11165, emphasises
                                     => 19287,
                            emphasising
                                     => 19328, emphasize
                                     => 7123,
                            emphasized
                                     => 5249, emphasizes
                                     => 7477,
                            emphasizing
                                     => 8716, empire   => 699,
                            empires  => 8834, empirical
                                     => 6554,
                            empirically
                                     => 17930, empiricism
                                     => 24608,
                            emplaced => 27897, emplacement
                                     => 22804,
                            emplacements
                                     => 18831, employ   => 4861,
                            employed => 1385, employees
                                     => 1629,
                            employer => 4599, employers
                                     => 4581,
                            employing
                                     => 5769, employment
                                     => 2069,
                            employs  => 4697, empoli   => 28093, emporia  => 19769, empower  => 12486,
                            empowered
                                     => 9885, empowering
                                     => 13913,
                            empowerment
                                     => 8984, empowers => 24224,
                            empresa  => 26506, empress  => 3909, empties  => 11487, emulate  => 10874,
                            emulated => 15135, emulation
                                     => 14033,
                            emulator => 16955, emulators
                                     => 27246,
                            emulsion => 19053, enable   => 3568, enabled  => 3359, enables  => 4795,
                            enabling => 4542, enact    => 11087, enacted  => 4371, enacting => 14840,
                            enactment
                                     => 8963, enactments
                                     => 22515,
                            enamel   => 10801, encamped => 18787, encampment
                                     => 12993,
                            encampments
                                     => 27559, encapsulated
                                     => 17948,
                            encapsulation
                                     => 25129, encased  => 15860,
                            encephalopathy
                                     => 23811,
                            encircle => 19840, encircled
                                     => 11866,
                            encirclement
                                     => 15545, encircles
                                     => 26083,
                            encircling
                                     => 17199, enclave  => 10346,
                            enclaves => 15606, enclosed => 4557, encloses => 21483, enclosing
                                     => 13595,
                            enclosure
                                     => 7148, enclosures
                                     => 13386,
                            encode   => 12841, encoded  => 4536, encoder  => 20903, encodes  => 11735,
                            encoding => 6822, encodings
                                     => 26344,
                            encompass
                                     => 9210, encompassed
                                     => 9126,
                            encompasses
                                     => 5093, encompassing
                                     => 7377,
                            encores  => 24917, encounter
                                     => 3520,
                            encountered
                                     => 3470, encountering
                                     => 11353,
                            encounters
                                     => 4534, encourage
                                     => 3407,
                            encouraged
                                     => 2346, encourages
                                     => 6061,
                            encroached
                                     => 25348, encroaching
                                     => 20641,
                            encroachment
                                     => 14680, encrypt  => 29421,
                            encryption
                                     => 8450, encyclical
                                     => 15975,
                            encyclopaedia
                                     => 10419, encyclopedia
                                     => 5279,
                            encyclopedic
                                     => 19464, end      => 142,
                            endangered
                                     => 3840, endeared => 28774,
                            endeavored
                                     => 24313, endeavors
                                     => 9937,
                            endeavour
                                     => 9903, endeavoured
                                     => 20933,
                            endeavours
                                     => 15279, ended    => 663,
                            endemic  => 2462, endemol  => 27297, enderby  => 26103, endgame  => 17231,
                            ending   => 1445, endocrine
                                     => 15954,
                            endocrinology
                                     => 22302, endocytosis
                                     => 28975,
                            endogenous
                                     => 14465, endometrial
                                     => 28972,
                            endoplasmic
                                     => 23051, endorsed => 4471,
                            endorsement
                                     => 7593, endorsements
                                     => 12242,
                            endorses => 22721, endorsing
                                     => 15088,
                            endoscopic
                                     => 26488, endoscopy
                                     => 29617,
                            endothelial
                                     => 14677, endow    => 27227,
                            endowed  => 7483, endowment
                                     => 5819,
                            endowments
                                     => 15728, endpoint => 17164,
                            endpoints
                                     => 18628, endurance
                                     => 6038,
                            endured  => 8359, endures  => 24936, enduring => 6682, enduro   => 27036,
                            endymion => 26575, endzone  => 20421, enemy    => 1386, energetic
                                     => 7262,
                            energetically
                                     => 21538, energia  => 23240,
                            energie  => 28404, energies => 7855, energon  => 25851, energy   => 583,
                            enfeoffed
                                     => 27156, enfield  => 9093,
                            enforce  => 6327, enforceable
                                     => 20434,
                            enforced => 6291, enforcement
                                     => 2601,
                            enforcers
                                     => 20492, enforces => 21758,
                            enforcing
                                     => 9834, engage   => 3375,
                            engagements
                                     => 7259, engages  => 8742,
                            engaging => 4939, engendered
                                     => 21732,
                            engine   => 680, engined  => 7542, engineer => 1571, engineered
                                     => 5889,
                            engineering
                                     => 810, engineers
                                     => 2298,
                            engines  => 1620, england  => 278, englewood
                                     => 15740,
                            english  => 222, englishmen
                                     => 16980,
                            engraved => 6851, engraver => 9492, engravers
                                     => 21840,
                            engraving
                                     => 8750, engravings
                                     => 10205,
                            engulfed => 15073, enhance  => 4381, enhanced => 3775, enhancement
                                     => 8389,
                            enhancements
                                     => 11714, enhances => 12669,
                            enhancing
                                     => 7747, enigmatic
                                     => 13323,
                            eniwetok => 14736, enjoined => 28646, enlai    => 26345, enlarge  => 14746,
                            enlarged => 4579, enlargement
                                     => 11629,
                            enlarging
                                     => 18509, enlightenment
                                     => 6518,
                            enlil    => 29510, enlisted => 3448, enlisting
                                     => 14380,
                            enlistment
                                     => 14354, enlists  => 16257,
                            enmity   => 15031, ennio    => 23857, enniskillen
                                     => 22224,
                            ennobled => 19619, enplanements
                                     => 26130,
                            enquiry  => 11157, enraged  => 8594, enrich   => 14688, enriched => 9053,
                            enrichment
                                     => 9402, enrico   => 9248,
                            enroll   => 9138, enrolled => 2958, enrolling
                                     => 12685,
                            enrollment
                                     => 3530, enrollments
                                     => 25707,
                            enrolls  => 16831, enrolment
                                     => 13835,
                            enron    => 17103, enschede => 25435, ensemble => 2896, ensembles
                                     => 7480,
                            enshrined
                                     => 11874, ensign   => 7765,
                            enslaved => 9743, enslavement
                                     => 20246,
                            ensued   => 7324, ensues   => 12439, ensuing  => 5081, ensure   => 2056,
                            ensured  => 6471, ensures  => 7922, ensuring => 5234, entablature
                                     => 19378,
                            entailed => 13671, entangled
                                     => 14251,
                            entanglement
                                     => 19303, entente  => 15055,
                            enter    => 1656, entered  => 713, entering => 2080, enterprise
                                     => 2456,
                            enters   => 2923, entertainer
                                     => 8333,
                            entertainers
                                     => 11517, entertainment
                                     => 1058,
                            entertainments
                                     => 15529,
                            entertains
                                     => 29830, enthalpy => 22727,
                            enthroned
                                     => 15747, enthusiast
                                     => 10167,
                            enthusiastically
                                     => 12744,
                            enthusiasts
                                     => 7067, entirely => 1639,
                            entirety => 6390, entities => 4195, entitled => 1288, entitlement
                                     => 16289,
                            entitlements
                                     => 25839, entity   => 3495,
                            entombed => 20189, entomological
                                     => 21691,
                            entomologist
                                     => 13412, entomology
                                     => 15731,
                            entrance => 1643, entrances
                                     => 7522,
                            entrant  => 14846, entrants => 7002, entre    => 14407, entrenched
                                     => 11103,
                            entrepreneur
                                     => 4172, entrepreneurial
                                     => 10576,
                            entrepreneurs
                                     => 6668, entrepreneurship
                                     => 7976,
                            entries  => 4003, entropy  => 8500, entrusted
                                     => 7017,
                            entry    => 1401, enugu    => 21322, enumerated
                                     => 14888,
                            enumeration
                                     => 19818, enveloped
                                     => 17098,
                            enveloping
                                     => 28760, enver    => 20415,
                            environment
                                     => 1072, environmental
                                     => 1250,
                            environmentalism
                                     => 18712,
                            environmentalist
                                     => 14125,
                            environmentalists
                                     => 15935,
                            environmentally
                                     => 8691,
                            environments
                                     => 3823, environs => 13550,
                            envisaged
                                     => 10990, envisioned
                                     => 7741,
                            envisions
                                     => 25696, envoy    => 7801,
                            envoys   => 13106, enzymatic
                                     => 17468,
                            enzyme   => 3003, enzymes  => 6106, enzymology
                                     => 13606,
                            eocene   => 11746, eparchy  => 16169, ephemera => 26557, ephemeral
                                     => 15622,
                            ephesus  => 15984, ephraim  => 12435, epic     => 3459, epicenter
                                     => 16917,
                            epics    => 13713, epidemic => 6446, epidemics
                                     => 13636,
                            epidemiological
                                     => 19019,
                            epidemiology
                                     => 9849, epidermal
                                     => 21665,
                            epidermis
                                     => 19011, epigenetic
                                     => 18294,
                            epigrams => 26540, epilepsy => 10442, epilogue => 11703, epiphytic
                                     => 29832,
                            epirus   => 12349, episcopacy
                                     => 20857,
                            episcopal
                                     => 3220, episcopalian
                                     => 19696,
                            episcopate
                                     => 13228, episode  => 446,
                            episodes => 1047, episodic => 12672, epistemic
                                     => 26316,
                            epistemological
                                     => 20764,
                            epistemology
                                     => 14686, epistle  => 12128,
                            epistles => 13786, epitaph  => 11911, epithelial
                                     => 12541,
                            epithelium
                                     => 15719, epithet  => 7618,
                            epithets => 23143, epitomized
                                     => 28490,
                            epoch    => 8926, epochs   => 23815, eponym   => 24364, eponymous
                                     => 5707,
                            epsilon  => 10034, epsom    => 9335, epworth  => 28462, equal    => 1647,
                            equaled  => 19402, equaling => 27681, equalised
                                     => 18052,
                            equaliser
                                     => 14170, equalising
                                     => 28194,
                            equality => 3912, equalization
                                     => 18770,
                            equalized
                                     => 26474, equalled => 14976,
                            equalling
                                     => 21749, equally  => 3535,
                            equated  => 14702, equates  => 19175, equating => 20874, equation => 2960,
                            equations
                                     => 4141, equator  => 9242,
                            equatorial
                                     => 7849, equestrian
                                     => 6767,
                            equidistant
                                     => 22410, equilateral
                                     => 23275,
                            equilibria
                                     => 25816, equilibrium
                                     => 5487,
                            equine   => 13997, equip    => 11403, equipment
                                     => 1024,
                            equipments
                                     => 24498, equipped => 2023,
                            equipping
                                     => 16463, equitable
                                     => 10643,
                            equities => 21014, equity   => 3750, equivalence
                                     => 9302,
                            equivalent
                                     => 1881, equivalently
                                     => 13278,
                            equivalents
                                     => 11051, equus    => 25924,
                            era      => 764, eradicate
                                     => 13499,
                            eradicated
                                     => 18466, eradicating
                                     => 28545,
                            eradication
                                     => 13184, erasmus  => 9892,
                            erasure  => 20326, erbil    => 29475, ercole   => 25103, erdogan  => 15441,
                            erdos    => 20228, erebidae => 14931, erebus   => 25787, erect    => 6821,
                            erected  => 2467, erectile => 23154, erecting => 15613, erection => 10045,
                            erectus  => 23516, eredivisie
                                     => 11680,
                            eretz    => 26554, erfurt   => 14801, ergative => 29026, ergonomic
                                     => 28920,
                            ergonomics
                                     => 24349, erhard   => 19161,
                            ericsson => 10617, erie     => 4811, erigeron => 24796, eriksson => 14423,
                            erinsborough
                                     => 23323, eritrea  => 9263,
                            eritrean => 15409, erlangen => 19296, erlewine => 14149, ermine   => 21656,
                            ernakulam
                                     => 16285, erode    => 14670,
                            eroded   => 8567, erosion  => 5380, erotica  => 19360, eroticism
                                     => 26118,
                            erroneous
                                     => 12353, erroneously
                                     => 10000,
                            error    => 2846, errors   => 3997, ersatz   => 29350, erste    => 28628,
                            erstwhile
                                     => 10889, erudite  => 21602,
                            erudition
                                     => 27204, erupted  => 7125,
                            erupting => 25198, eruption => 6743, eruptions
                                     => 9768,
                            eruptive => 25836, erupts   => 22211, erythrocytes
                                     => 28831,
                            erzhu    => 26705, erzurum  => 22352, esbjerg  => 23938, escadrille
                                     => 23473,
                            escalated
                                     => 10573, escalation
                                     => 14703,
                            escalators
                                     => 17945, escapees => 20535,
                            escapement
                                     => 24705, escapes  => 5378,
                            escapist => 28925, escarpment
                                     => 10712,
                            eschatology
                                     => 26577, escherichia
                                     => 21696,
                            eschewed => 23249, eschewing
                                     => 29549,
                            escola   => 22151, escondido
                                     => 23602,
                            escorial => 29482, escorted => 6376, escorting
                                     => 9539,
                            escuela  => 13699, escutcheon
                                     => 26982,
                            esher    => 26086, eskisehir
                                     => 28287,
                            eslamabad
                                     => 19592, esoteric => 10633,
                            espanol  => 14609, espanola => 13903, espanyol => 20045, especial => 24078,
                            esperance
                                     => 18170, esperanto
                                     => 10696,
                            espionage
                                     => 7969, espirito => 19155,
                            esplanade
                                     => 14334, espn     => 4318,
                            "espn.com"
                                     => 25093, espn2    => 22124,
                            espoo    => 22453, esporte  => 17024, espoused => 14096, esprit   => 18771,
                            esque    => 14327, esquimalt
                                     => 24743,
                            essayist => 11143, essays   => 3865, essen    => 11198, essendon => 9115,
                            essential
                                     => 2458, essentially
                                     => 2695,
                            essex    => 3175, establish
                                     => 1671,
                            established
                                     => 256, establishes
                                     => 8092,
                            establishing
                                     => 2550, establishment
                                     => 1500,
                            establishments
                                     => 6382, estadio  => 7179,
                            estado   => 14599, estate   => 957, estates  => 3130, estefan  => 19901,
                            esteghlal
                                     => 21948, esterhazy
                                     => 21225,
                            estero   => 20019, estimate => 3850, estimated
                                     => 1173,
                            estimates
                                     => 3593, estimating
                                     => 12610,
                            estimation
                                     => 9540, estimations
                                     => 29092,
                            estimator
                                     => 16096, estimators
                                     => 28694,
                            estonia  => 3899, estonian => 4941, estonians
                                     => 21997,
                            estoril  => 19918, estradiol
                                     => 26853,
                            estrellas
                                     => 24909, estuaries
                                     => 13797,
                            estuarine
                                     => 18958, estuary  => 6530,
                            estudiantes
                                     => 17311, estudios => 26565,
                            esztergom
                                     => 24535, "etc."   => 5206,
                            "etc.."  => 23128, etching  => 13333, etchings => 15165, ethanol  => 8001,
                            ethereal => 17181, ethernet => 9220, ethical  => 4978, ethiopia => 4201,
                            ethiopian
                                     => 5584, ethiopians
                                     => 21313,
                            ethmia   => 24285, ethnic   => 1698, ethnically
                                     => 9393,
                            ethnicities
                                     => 14723, ethnicity
                                     => 6601,
                            ethniki  => 18852, ethnikos => 28989, ethno    => 19153, ethnographer
                                     => 24944,
                            ethnographic
                                     => 11191, ethnography
                                     => 14812,
                            ethnological
                                     => 25101, ethnologist
                                     => 26237,
                            ethnologue
                                     => 24369, ethnology
                                     => 17739,
                            ethnomusicology
                                     => 28895,
                            ethos    => 11111, ethylene => 14409, etihad   => 26924, etiology => 19854,
                            etobicoke
                                     => 19284, etoile   => 20103,
                            etruria  => 24656, etruscan => 12487, etruscans
                                     => 22939,
                            ettore   => 20456, etude    => 25715, etudes   => 13615, etymological
                                     => 18798,
                            etymologically
                                     => 23871,
                            etymologies
                                     => 24234, etymology
                                     => 3790,
                            euboea   => 27212, eucalyptus
                                     => 10279,
                            eucharist
                                     => 11595, eucharistic
                                     => 17630,
                            euclid   => 12926, euclidean
                                     => 8817,
                            eudonia  => 29708, eugen    => 11067, eugenics => 14945, eukaryotes
                                     => 15297,
                            eukaryotic
                                     => 13262, eunuchs  => 16500,
                            euphemia => 24422, euphorbia
                                     => 19735,
                            euphorbiaceae
                                     => 26743, euphrates
                                     => 13705,
                            eupithecia
                                     => 11237, eurasia  => 11427,
                            eurasian => 8656, eureka   => 9516, euripides
                                     => 19790,
                            euro     => 3671, eurobasket
                                     => 12378,
                            eurocopter
                                     => 28012, eurocup  => 16297,
                            eurodance
                                     => 24844, eurogamer
                                     => 22673,
                            euroleague
                                     => 10834, europa   => 5684,
                            europe   => 435, "europe/africa"
                                     => 20356,
                            european => 320, europeans
                                     => 4985,
                            euros    => 7824, eurosport
                                     => 27445,
                            eurostar => 23699, eurovision
                                     => 4166,
                            eurozone => 16421, eurydice => 25257, eusebian => 25916, eusebius => 13764,
                            eustace  => 13881, euston   => 16466, euthanasia
                                     => 12931,
                            euthanized
                                     => 29539, evacuated
                                     => 5145,
                            evacuation
                                     => 5451, evacuations
                                     => 20455,
                            evacuees => 19953, evade    => 10928, evaded   => 16530, evaluate => 6408,
                            evaluated
                                     => 6261, evaluates
                                     => 15176,
                            evaluating
                                     => 9041, evaluation
                                     => 3545,
                            evaluations
                                     => 10810, evanescence
                                     => 28988,
                            evangelical
                                     => 4174, evangelicals
                                     => 17898,
                            evangelion
                                     => 25088, evangelism
                                     => 15541,
                            evangelist
                                     => 8986, evangelistic
                                     => 20706,
                            evangelists
                                     => 16545, evangelization
                                     => 19695,
                            evanston => 13688, evansville
                                     => 11879,
                            evaporates
                                     => 29135, evaporation
                                     => 11734,
                            evenings => 7224, evenly   => 8723, event    => 388, eventing => 18424,
                            events   => 391, eventual => 3455, eventually
                                     => 414,
                            everard  => 21615, evergreen
                                     => 6558,
                            everton  => 6442, everyman => 18939, evesham  => 19461, evgeni   => 29653,
                            evgeny   => 19736, eviction => 9438, evictions
                                     => 25007,
                            evidenced
                                     => 7875, evidences
                                     => 17662,
                            evident  => 4384, evocation
                                     => 27142,
                            evocative
                                     => 15229, evoke    => 12253,
                            evoked   => 13670, evokes   => 15316, evoking  => 18239, evolution
                                     => 2292,
                            evolutionarily
                                     => 26150,
                            evolutionary
                                     => 4817, evolutions
                                     => 25841,
                            evolve   => 7629, evolved  => 2719, evolves  => 15632, evolving => 7670,
                            evora    => 23828, exacerbated
                                     => 10847,
                            exacted  => 27797, exaggerated
                                     => 8332,
                            exaltation
                                     => 27600, examination
                                     => 2826,
                            examinations
                                     => 5498, examined => 4156,
                            examiners
                                     => 15843, examines => 8276,
                            example  => 368, examples => 1295, exams    => 5464, exarchate
                                     => 23119,
                            excalibur
                                     => 15977, excavate => 21550,
                            excavated
                                     => 5812, excavating
                                     => 20313,
                            excavation
                                     => 6357, excavations
                                     => 5189,
                            excavator
                                     => 29911, excavators
                                     => 25252,
                            exceed   => 5160, exceeded => 5638, exceeding
                                     => 6732,
                            exceeds  => 8341, excel    => 9400, excelled => 7947, excellence
                                     => 3114,
                            excelling
                                     => 24275, excelsior
                                     => 12892,
                            excepting
                                     => 17106, exception
                                     => 2251,
                            exceptional
                                     => 4763, exceptionally
                                     => 6985,
                            exceptions
                                     => 4307, excerpt  => 12035,
                            excerpts => 9822, excess   => 3803, excesses => 15065, excessive
                                     => 4611,
                            excessively
                                     => 12987, exchange => 1071,
                            exchanged
                                     => 6042, exchanger
                                     => 19561,
                            exchangers
                                     => 26294, exchanges
                                     => 6024,
                            exchequer
                                     => 10012, excise   => 12409,
                            excised  => 23034, excision => 21683, excitation
                                     => 13736,
                            excitatory
                                     => 23329, exclaim  => 22087,
                            exclaimed
                                     => 17629, exclaiming
                                     => 29452,
                            exclaims => 26730, exclave  => 19549, exclude  => 8581, excluded => 4728,
                            excludes => 12335, excluding
                                     => 5343,
                            exclusion
                                     => 6734, exclusive
                                     => 2683,
                            exclusively
                                     => 2584, exclusivity
                                     => 19022,
                            excommunicated
                                     => 13374,
                            excommunication
                                     => 15114,
                            excreted => 19922, excretion
                                     => 20741,
                            excursion
                                     => 10667, excursions
                                     => 11171,
     