# This Makefile.PL for PBKDF2-Tiny was generated by
# inc::MakeMaker <self>
# and Dist::Zilla::Plugin::MakeMaker::Awesome 0.27.
# Don't edit it but the dist.ini and plugins used to construct it.

use strict;
use warnings;

use 5.006;
use ExtUtils::MakeMaker 6.17;

my %WriteMakefileArgs = (
  "ABSTRACT" => "Minimalist PBKDF2 (RFC 2898) with HMAC-SHA1 or HMAC-SHA2",
  "AUTHOR" => "David Golden <dagolden\@cpan.org>",
  "CONFIGURE_REQUIRES" => {
    "Config" => 0,
    "ExtUtils::MakeMaker" => "6.17",
    "File::Spec" => 0,
    "Text::ParseWords" => 0
  },
  "DISTNAME" => "PBKDF2-Tiny",
  "EXE_FILES" => [],
  "LICENSE" => "apache",
  "NAME" => "PBKDF2::Tiny",
  "PREREQ_PM" => {
    "Carp" => 0,
    "Exporter" => "5.57",
    "strict" => 0,
    "warnings" => 0
  },
  "TEST_REQUIRES" => {
    "ExtUtils::MakeMaker" => 0,
    "File::Spec" => 0,
    "Test::More" => "0.88"
  },
  "VERSION" => "0.002",
  "test" => {
    "TESTS" => "t/*.t"
  }
);

my %FallbackPrereqs = (
  "Carp" => 0,
  "Exporter" => "5.57",
  "ExtUtils::MakeMaker" => 0,
  "File::Spec" => 0,
  "Test::More" => "0.88",
  "strict" => 0,
  "warnings" => 0
);

unless ( eval { ExtUtils::MakeMaker->VERSION(6.63_03) } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

if ( $] < 5.010 ) {
    if ( !parse_args()->{PUREPERL_ONLY} && can_cc() ) {
        $WriteMakefileArgs{PREREQ_PM}{'Digest::SHA'} = 0;
    }
    else {
        $WriteMakefileArgs{PREREQ_PM}{'Digest::SHA::PurePerl'} = 0;
    }
}

WriteMakefile(%WriteMakefileArgs);

use Config ();
use File::Spec ();
use Text::ParseWords ();

# check if we can run some command
sub can_run {
        my ($cmd) = @_;

        my $_cmd = $cmd;
        return $_cmd if (-x $_cmd or $_cmd = MM->maybe_command($_cmd));

        for my $dir ((split /$Config::Config{path_sep}/, $ENV{PATH}), '.') {
                next if $dir eq '';
                my $abs = File::Spec->catfile($dir, $_[0]);
                return $abs if (-x $abs or $abs = MM->maybe_command($abs));
        }

        return;
}

# can we locate a (the) C compiler
sub can_cc {
        my @chunks = split(/ /, $Config::Config{cc}) or return;

        # $Config{cc} may contain args; try to find out the program part
        while (@chunks) {
                return can_run("@chunks") || (pop(@chunks), next);
        }

        return;
}

# XXX this is gross, but apparently it's the least gross option?
sub parse_args {
    my $tmp = {};
    # copied from EUMM
    ExtUtils::MakeMaker::parse_args(
        $tmp,
        Text::ParseWords::shellwords($ENV{PERL_MM_OPT} || ''),
        @ARGV,
    );
    return $tmp->{ARGS} || {};
}
