package OpenInteract2::SQLInstall::WhatsNew;

# $Id: WhatsNew.pm,v 1.2 2004/02/25 16:05:47 lachoy Exp $

use strict;
use base qw( OpenInteract2::SQLInstall );

my %FILES = (
 default => [ 'whats_new.sql' ],
 pg      => [ 'whats_new.sql', 'whats_new_sequence.sql' ],
 oracle  => [ 'whats_new_oracle.sql', 'whats_new_sequence.sql' ],
 ib      => [ 'whats_new.sql', 'whats_new_generator.sql' ],
);

sub get_migration_information {
    my ( $self ) = @_;
    my %new_info = (
        spops_class => 'OpenInteract2::WhatsNew',
        table       => 'new_listing',
    );
    return [ \%new_info ];
}

sub get_structure_set {
    return 'whats_new';
}

sub get_structure_file {
    my ( $self, $set, $type ) = @_;
    if ( $type eq 'Oracle' ) {
        return $FILES{oracle};
    }
    elsif ( $type eq 'Pg' ) {
        return $FILES{pg};
    }
    elsif ( $type eq 'InterBase' ) {
        return $FILES{ib};
    }
    else {
        return $FILES{default};
    }
}

sub get_security_file {
    return 'install_security.dat';
}

1;
