use ExtUtils::MakeMaker;
WriteMakefile(
    NAME	=> 'Finance::Shares',
    VERSION	=> '0.05',
    ABSTRACT	=> 'Collecting and tracking share prices',
    AUTHOR      => 'Christopher Willmot <chris@willmot.org>',
    NORECURS    => 1,
    PREREQ_PM	=> { 
	#'Test::More'		    => 0,
	'Date::Calc'                => 0,
	'Text::CSV_XS'              => 0,
	'LWP::UserAgent'            => 0,
	'DBIx::Namespace'           => 0.03,
	'PostScript::File'	    => 1.00,
	'PostScript::Graph::Bar'    => 0.03,
	'PostScript::Graph::Key'    => 1.00,
	'PostScript::Graph::Paper'  => 1.00,
	'PostScript::Graph::Style'  => 1.00,
	'PostScript::Graph::XY'	    => 0.04,
    },
    EXE_FILES => [ 'fs_model' ],
    PM	=> {
	'Shares/Averages.pm'	=> '$(INST_LIBDIR)/Shares/Averages.pm',
	'Shares/Bands.pm'   	=> '$(INST_LIBDIR)/Shares/Bands.pm',
	'Shares/Chart.pm'	=> '$(INST_LIBDIR)/Shares/Chart.pm',
	'Shares/Model.pm'   	=> '$(INST_LIBDIR)/Shares/Model.pm',
	'Shares/MySQL.pm'	=> '$(INST_LIBDIR)/Shares/MySQL.pm',
	'Shares/Sample.pm'	=> '$(INST_LIBDIR)/Shares/Sample.pm',
    },
    MAN3PODS => {
	'Shares/Averages.pm'	=> '$(INST_LIBDIR)/Shares/Averages.pod',
	'Shares/Bands.pm'   	=> '$(INST_LIBDIR)/Shares/Bands.pod',
	'Shares/Chart.pm'	=> '$(INST_LIBDIR)/Shares/Chart.pod',
	'Shares/Model.pm'   	=> '$(INST_LIBDIR)/Shares/Model.pod',
	'Shares/MySQL.pm'	=> '$(INST_LIBDIR)/Shares/MySQL.pod',
	'Shares/Sample.pm'	=> '$(INST_LIBDIR)/Shares/Sample.pod',
	'Shares/Lesson1.pod'	=> '$(INST_LIBDIR)/Shares/Lesson1.pod',
	'Shares/Lesson2.pod'	=> '$(INST_LIBDIR)/Shares/Lesson2.pod',
	'Shares/Lesson3.pod'	=> '$(INST_LIBDIR)/Shares/Lesson3.pod',
	'Shares/Lesson4.pod'	=> '$(INST_LIBDIR)/Shares/Lesson4.pod',
    },
);
