/*
 * XXX - We need a description of the file here
 *
 * $Id: /parrotcode/trunk/compilers/imcc/parser.h 3385 2007-05-05T14:41:57.057265Z bernhard  $
 */

#ifndef PARROT_IMCC_PARSER_H_GUARD
#define PARROT_IMCC_PARSER_H_GUARD

#ifdef PARSER_MAIN
#  define EXTERN
#else
#  define EXTERN extern
#endif

typedef struct _IdList {
    char* id;
    int unique_reg;
    struct _IdList*  next;
} IdList;

#include "imcparser.h"

/* short ranged globals for lexer state */
EXTERN int is_def;

/* bison */
PARROT_API EXTERN int yydebug;

#define KEY_BIT(argnum) (1 << (argnum))

/* An opaque pointer. */
#ifndef YY_TYPEDEF_YY_SCANNER_T
#  define YY_TYPEDEF_YY_SCANNER_T
typedef void* yyscan_t;
#endif

SymReg * macro(Interp *, char *name);

PARROT_API int yyparse(yyscan_t, Interp*);
PARROT_API int yylex(YYSTYPE *, yyscan_t, Interp*);
PARROT_API int yylex_destroy(yyscan_t);
PARROT_API int do_yylex_init(Interp*, yyscan_t*);

int yylex_init(yyscan_t*);
int yyget_column(yyscan_t);
void yyset_column(int column_no , yyscan_t);
int yyerror(yyscan_t, Interp*, char *);

/* These are generated by flex. YY_EXTRA_TYPE is used also by flex, so
 * defining it is handy: we do not need typecasts. */
#define YY_EXTRA_TYPE Interp*
YY_EXTRA_TYPE yyget_extra(yyscan_t yyscanner );
void yyset_extra(YY_EXTRA_TYPE user_defined ,yyscan_t yyscanner );

void op_fullname(char * dest, const char * name, SymReg * args[], int, int);
PARROT_API void open_comp_unit(void);
void register_compilers(Parrot_Interp);
void *imcc_eval_pasm(Parrot_Interp, const char *s);
void *imcc_eval_pir(Parrot_Interp, const char *s);
int try_find_op(Parrot_Interp, IMC_Unit *, char *, SymReg **, int, int, int);
Instruction * multi_keyed(Interp *interp, IMC_Unit *, char *name,
    SymReg ** r, int nr, int keyvec, int emit);

extern void compile_file(Interp *interp, FILE *file, void *);
extern void compile_string(Interp *interp, char *, void *);

int at_eof(yyscan_t yyscanner);

#endif /* PARROT_IMCC_PARSER_H_GUARD */

/*
 * Local variables:
 *   c-file-style: "parrot"
 * End:
 * vim: expandtab shiftwidth=4:
 */
