package HTML::Dojo::src;
1;
__DATA__
__CPAN_DIR__ src
__CPAN_FILE__ src/DeferredList.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.require("dojo.Deferred");
dojo.provide("dojo.DeferredList");
dojo.DeferredList = function (list, fireOnOneCallback, fireOnOneErrback, consumeErrors, canceller) {
	this.list = list;
	this.resultList = new Array(this.list.length);
	this.chain = [];
	this.id = this._nextId();
	this.fired = -1;
	this.paused = 0;
	this.results = [null, null];
	this.canceller = canceller;
	this.silentlyCancelled = false;
	if (this.list.length === 0 && !fireOnOneCallback) {
		this.callback(this.resultList);
	}
	this.finishedCount = 0;
	this.fireOnOneCallback = fireOnOneCallback;
	this.fireOnOneErrback = fireOnOneErrback;
	this.consumeErrors = consumeErrors;
	var index = 0;
	var _this = this;
	dojo.lang.forEach(this.list, function (d) {
		var _index = index;
		d.addCallback(function (r) {
			_this._cbDeferred(_index, true, r);
		});
		d.addErrback(function (r) {
			_this._cbDeferred(_index, false, r);
		});
		index++;
	});
};
dojo.inherits(dojo.DeferredList, dojo.Deferred);
dojo.lang.extend(dojo.DeferredList, {_cbDeferred:function (index, succeeded, result) {
	this.resultList[index] = [succeeded, result];
	this.finishedCount += 1;
	if (this.fired !== 0) {
		if (succeeded && this.fireOnOneCallback) {
			this.callback([index, result]);
		} else {
			if (!succeeded && this.fireOnOneErrback) {
				this.errback(result);
			} else {
				if (this.finishedCount == this.list.length) {
					this.callback(this.resultList);
				}
			}
		}
	}
	if (!succeeded && this.consumeErrors) {
		result = null;
	}
	return result;
}, gatherResults:function (deferredList) {
	var d = new dojo.DeferredList(deferredList, false, true, false);
	d.addCallback(function (results) {
		var ret = [];
		for (var i = 0; i < results.length; i++) {
			ret.push(results[i][1]);
		}
		return ret;
	});
	return d;
}});


__CPAN_FILE__ src/ns.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.ns");
dojo.ns = {namespaces:{}, failed:{}, loading:{}, loaded:{}, register:function (name, module, resolver, noOverride) {
	if (!noOverride || !this.namespaces[name]) {
		this.namespaces[name] = new dojo.ns.Ns(name, module, resolver);
	}
}, allow:function (name) {
	if (this.failed[name]) {
		return false;
	}
	if ((djConfig.excludeNamespace) && (dojo.lang.inArray(djConfig.excludeNamespace, name))) {
		return false;
	}
	return ((name == this.dojo) || (!djConfig.includeNamespace) || (dojo.lang.inArray(djConfig.includeNamespace, name)));
}, get:function (name) {
	return this.namespaces[name];
}, require:function (name) {
	var ns = this.namespaces[name];
	if ((ns) && (this.loaded[name])) {
		return ns;
	}
	if (!this.allow(name)) {
		return false;
	}
	if (this.loading[name]) {
		dojo.debug("dojo.namespace.require: re-entrant request to load namespace \"" + name + "\" must fail.");
		return false;
	}
	var req = dojo.require;
	this.loading[name] = true;
	try {
		if (name == "dojo") {
			req("dojo.namespaces.dojo");
		} else {
			if (!dojo.hostenv.moduleHasPrefix(name)) {
				dojo.registerModulePath(name, "../" + name);
			}
			req([name, "manifest"].join("."), false, true);
		}
		if (!this.namespaces[name]) {
			this.failed[name] = true;
		}
	}
	finally {
		this.loading[name] = false;
	}
	return this.namespaces[name];
}};
dojo.ns.Ns = function (name, module, resolver) {
	this.name = name;
	this.module = module;
	this.resolver = resolver;
	this._loaded = [];
	this._failed = [];
};
dojo.ns.Ns.prototype.resolve = function (name, domain, omitModuleCheck) {
	if (!this.resolver || djConfig["skipAutoRequire"]) {
		return false;
	}
	var fullName = this.resolver(name, domain);
	if ((fullName) && (!this._loaded[fullName]) && (!this._failed[fullName])) {
		var req = dojo.require;
		req(fullName, false, true);
		if (dojo.hostenv.findModule(fullName, false)) {
			this._loaded[fullName] = true;
		} else {
			if (!omitModuleCheck) {
				dojo.raise("dojo.ns.Ns.resolve: module '" + fullName + "' not found after loading via namespace '" + this.name + "'");
			}
			this._failed[fullName] = true;
		}
	}
	return Boolean(this._loaded[fullName]);
};
dojo.registerNamespace = function (name, module, resolver) {
	dojo.ns.register.apply(dojo.ns, arguments);
};
dojo.registerNamespaceResolver = function (name, resolver) {
	var n = dojo.ns.namespaces[name];
	if (n) {
		n.resolver = resolver;
	}
};
dojo.registerNamespaceManifest = function (module, path, name, widgetModule, resolver) {
	dojo.registerModulePath(name, path);
	dojo.registerNamespace(name, widgetModule, resolver);
};
dojo.registerNamespace("dojo", "dojo.widget");


__CPAN_FILE__ src/date.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.date");
dojo.deprecated("dojo.date", "use one of the modules in dojo.date.* instead", "0.5");


__CPAN_FILE__ src/Deferred.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.Deferred");
dojo.require("dojo.lang.func");
dojo.Deferred = function (canceller) {
	this.chain = [];
	this.id = this._nextId();
	this.fired = -1;
	this.paused = 0;
	this.results = [null, null];
	this.canceller = canceller;
	this.silentlyCancelled = false;
};
dojo.lang.extend(dojo.Deferred, {getFunctionFromArgs:function () {
	var a = arguments;
	if ((a[0]) && (!a[1])) {
		if (dojo.lang.isFunction(a[0])) {
			return a[0];
		} else {
			if (dojo.lang.isString(a[0])) {
				return dj_global[a[0]];
			}
		}
	} else {
		if ((a[0]) && (a[1])) {
			return dojo.lang.hitch(a[0], a[1]);
		}
	}
	return null;
}, makeCalled:function () {
	var deferred = new dojo.Deferred();
	deferred.callback();
	return deferred;
}, repr:function () {
	var state;
	if (this.fired == -1) {
		state = "unfired";
	} else {
		if (this.fired == 0) {
			state = "success";
		} else {
			state = "error";
		}
	}
	return "Deferred(" + this.id + ", " + state + ")";
}, toString:dojo.lang.forward("repr"), _nextId:(function () {
	var n = 1;
	return function () {
		return n++;
	};
})(), cancel:function () {
	if (this.fired == -1) {
		if (this.canceller) {
			this.canceller(this);
		} else {
			this.silentlyCancelled = true;
		}
		if (this.fired == -1) {
			this.errback(new Error(this.repr()));
		}
	} else {
		if ((this.fired == 0) && (this.results[0] instanceof dojo.Deferred)) {
			this.results[0].cancel();
		}
	}
}, _pause:function () {
	this.paused++;
}, _unpause:function () {
	this.paused--;
	if ((this.paused == 0) && (this.fired >= 0)) {
		this._fire();
	}
}, _continue:function (res) {
	this._resback(res);
	this._unpause();
}, _resback:function (res) {
	this.fired = ((res instanceof Error) ? 1 : 0);
	this.results[this.fired] = res;
	this._fire();
}, _check:function () {
	if (this.fired != -1) {
		if (!this.silentlyCancelled) {
			dojo.raise("already called!");
		}
		this.silentlyCancelled = false;
		return;
	}
}, callback:function (res) {
	this._check();
	this._resback(res);
}, errback:function (res) {
	this._check();
	if (!(res instanceof Error)) {
		res = new Error(res);
	}
	this._resback(res);
}, addBoth:function (cb, cbfn) {
	var enclosed = this.getFunctionFromArgs(cb, cbfn);
	if (arguments.length > 2) {
		enclosed = dojo.lang.curryArguments(null, enclosed, arguments, 2);
	}
	return this.addCallbacks(enclosed, enclosed);
}, addCallback:function (cb, cbfn) {
	var enclosed = this.getFunctionFromArgs(cb, cbfn);
	if (arguments.length > 2) {
		enclosed = dojo.lang.curryArguments(null, enclosed, arguments, 2);
	}
	return this.addCallbacks(enclosed, null);
}, addErrback:function (cb, cbfn) {
	var enclosed = this.getFunctionFromArgs(cb, cbfn);
	if (arguments.length > 2) {
		enclosed = dojo.lang.curryArguments(null, enclosed, arguments, 2);
	}
	return this.addCallbacks(null, enclosed);
	return this.addCallbacks(null, cbfn);
}, addCallbacks:function (cb, eb) {
	this.chain.push([cb, eb]);
	if (this.fired >= 0) {
		this._fire();
	}
	return this;
}, _fire:function () {
	var chain = this.chain;
	var fired = this.fired;
	var res = this.results[fired];
	var self = this;
	var cb = null;
	while (chain.length > 0 && this.paused == 0) {
		var pair = chain.shift();
		var f = pair[fired];
		if (f == null) {
			continue;
		}
		try {
			res = f(res);
			fired = ((res instanceof Error) ? 1 : 0);
			if (res instanceof dojo.Deferred) {
				cb = function (res) {
					self._continue(res);
				};
				this._pause();
			}
		}
		catch (err) {
			fired = 1;
			res = err;
		}
	}
	this.fired = fired;
	this.results[fired] = res;
	if ((cb) && (this.paused)) {
		res.addBoth(cb);
	}
}});


__CPAN_FILE__ src/animation.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.animation");
dojo.require("dojo.animation.Animation");
dojo.deprecated("dojo.animation is slated for removal in 0.5; use dojo.lfx instead.", "0.5");


__CPAN_FILE__ src/behavior.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.behavior");
dojo.require("dojo.event.*");
dojo.require("dojo.experimental");
dojo.experimental("dojo.behavior");
dojo.behavior = new function () {
	function arrIn(obj, name) {
		if (!obj[name]) {
			obj[name] = [];
		}
		return obj[name];
	}
	function forIn(obj, scope, func) {
		var tmpObj = {};
		for (var x in obj) {
			if (typeof tmpObj[x] == "undefined") {
				if (!func) {
					scope(obj[x], x);
				} else {
					func.call(scope, obj[x], x);
				}
			}
		}
	}
	this.behaviors = {};
	this.add = function (behaviorObj) {
		var tmpObj = {};
		forIn(behaviorObj, this, function (behavior, name) {
			var tBehavior = arrIn(this.behaviors, name);
			if ((dojo.lang.isString(behavior)) || (dojo.lang.isFunction(behavior))) {
				behavior = {found:behavior};
			}
			forIn(behavior, function (rule, ruleName) {
				arrIn(tBehavior, ruleName).push(rule);
			});
		});
	};
	this.apply = function () {
		dojo.profile.start("dojo.behavior.apply");
		var r = dojo.render.html;
		var safariGoodEnough = (!r.safari);
		if (r.safari) {
			var uas = r.UA.split("AppleWebKit/")[1];
			if (parseInt(uas.match(/[0-9.]{3,}/)) >= 420) {
				safariGoodEnough = true;
			}
		}
		if ((dj_undef("behaviorFastParse", djConfig) ? (safariGoodEnough) : djConfig["behaviorFastParse"])) {
			this.applyFast();
		} else {
			this.applySlow();
		}
		dojo.profile.end("dojo.behavior.apply");
	};
	this.matchCache = {};
	this.elementsById = function (id, handleRemoved) {
		var removed = [];
		var added = [];
		arrIn(this.matchCache, id);
		if (handleRemoved) {
			var nodes = this.matchCache[id];
			for (var x = 0; x < nodes.length; x++) {
				if (nodes[x].id != "") {
					removed.push(nodes[x]);
					nodes.splice(x, 1);
					x--;
				}
			}
		}
		var tElem = dojo.byId(id);
		while (tElem) {
			if (!tElem["idcached"]) {
				added.push(tElem);
			}
			tElem.id = "";
			tElem = dojo.byId(id);
		}
		this.matchCache[id] = this.matchCache[id].concat(added);
		dojo.lang.forEach(this.matchCache[id], function (node) {
			node.id = id;
			node.idcached = true;
		});
		return {"removed":removed, "added":added, "match":this.matchCache[id]};
	};
	this.applyToNode = function (node, action, ruleSetName) {
		if (typeof action == "string") {
			dojo.event.topic.registerPublisher(action, node, ruleSetName);
		} else {
			if (typeof action == "function") {
				if (ruleSetName == "found") {
					action(node);
				} else {
					dojo.event.connect(node, ruleSetName, action);
				}
			} else {
				action.srcObj = node;
				action.srcFunc = ruleSetName;
				dojo.event.kwConnect(action);
			}
		}
	};
	this.applyFast = function () {
		dojo.profile.start("dojo.behavior.applyFast");
		forIn(this.behaviors, function (tBehavior, id) {
			var elems = dojo.behavior.elementsById(id);
			dojo.lang.forEach(elems.added, function (elem) {
				forIn(tBehavior, function (ruleSet, ruleSetName) {
					if (dojo.lang.isArray(ruleSet)) {
						dojo.lang.forEach(ruleSet, function (action) {
							dojo.behavior.applyToNode(elem, action, ruleSetName);
						});
					}
				});
			});
		});
		dojo.profile.end("dojo.behavior.applyFast");
	};
	this.applySlow = function () {
		dojo.profile.start("dojo.behavior.applySlow");
		var all = document.getElementsByTagName("*");
		var allLen = all.length;
		for (var x = 0; x < allLen; x++) {
			var elem = all[x];
			if ((elem.id) && (!elem["behaviorAdded"]) && (this.behaviors[elem.id])) {
				elem["behaviorAdded"] = true;
				forIn(this.behaviors[elem.id], function (ruleSet, ruleSetName) {
					if (dojo.lang.isArray(ruleSet)) {
						dojo.lang.forEach(ruleSet, function (action) {
							dojo.behavior.applyToNode(elem, action, ruleSetName);
						});
					}
				});
			}
		}
		dojo.profile.end("dojo.behavior.applySlow");
	};
};
dojo.addOnLoad(dojo.behavior, "apply");


__CPAN_FILE__ src/hostenv_adobesvg.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

if (typeof window == "undefined") {
	dojo.raise("attempt to use adobe svg hostenv when no window object");
}
with (dojo.render) {
	name = navigator.appName;
	ver = parseFloat(navigator.appVersion, 10);
	switch (navigator.platform) {
	  case "MacOS":
		os.osx = true;
		break;
	  case "Linux":
		os.linux = true;
		break;
	  case "Windows":
		os.win = true;
		break;
	  default:
		os.linux = true;
		break;
	}
	svg.capable = true;
	svg.support.builtin = true;
	svg.adobe = true;
}
dojo.hostenv.println = function (s) {
	try {
		var ti = document.createElement("text");
		ti.setAttribute("x", "50");
		var yPos = 25 + 15 * document.getElementsByTagName("text").length;
		ti.setAttribute("y", yPos);
		var tn = document.createTextNode(s);
		ti.appendChild(tn);
		document.documentElement.appendChild(ti);
	}
	catch (e) {
	}
};
dojo.debug = function () {
	if (!djConfig.isDebug) {
		return;
	}
	var args = arguments;
	if (typeof dojo.hostenv.println != "function") {
		dojo.raise("attempt to call dojo.debug when there is no dojo.hostenv println implementation (yet?)");
	}
	var isJUM = dj_global["jum"];
	var s = isJUM ? "" : "DEBUG: ";
	for (var i = 0; i < args.length; ++i) {
		s += args[i];
	}
	if (isJUM) {
		jum.debug(s);
	} else {
		dojo.hostenv.println(s);
	}
};
dojo.hostenv.startPackage("dojo.hostenv");
dojo.hostenv.name_ = "adobesvg";
dojo.hostenv.anonCtr = 0;
dojo.hostenv.anon = {};
dojo.hostenv.nameAnonFunc = function (anonFuncPtr, namespaceObj) {
	var ret = "_" + this.anonCtr++;
	var nso = (namespaceObj || this.anon);
	while (typeof nso[ret] != "undefined") {
		ret = "_" + this.anonCtr++;
	}
	nso[ret] = anonFuncPtr;
	return ret;
};
dojo.hostenv.modulesLoadedFired = false;
dojo.hostenv.modulesLoadedListeners = [];
dojo.hostenv.getTextStack = [];
dojo.hostenv.loadUriStack = [];
dojo.hostenv.loadedUris = [];
dojo.hostenv.modulesLoaded = function () {
	if (this.modulesLoadedFired) {
		return;
	}
	if ((this.loadUriStack.length == 0) && (this.getTextStack.length == 0)) {
		if (this.inFlightCount > 0) {
			dojo.debug("couldn't initialize, there are files still in flight");
			return;
		}
		this.modulesLoadedFired = true;
		var mll = this.modulesLoadedListeners;
		for (var x = 0; x < mll.length; x++) {
			mll[x]();
		}
	}
};
dojo.hostenv.getNewAnonFunc = function () {
	var ret = "_" + this.anonCtr++;
	while (typeof this.anon[ret] != "undefined") {
		ret = "_" + this.anonCtr++;
	}
	eval("dojo.nostenv.anon." + ret + " = function(){};");
	return [ret, this.anon[ret]];
};
dojo.hostenv.displayStack = function () {
	var oa = [];
	var stack = this.loadUriStack;
	for (var x = 0; x < stack.length; x++) {
		oa.unshift([stack[x][0], (typeof stack[x][2])]);
	}
	dojo.debug("<pre>" + oa.join("\n") + "</pre>");
};
dojo.hostenv.unwindUriStack = function () {
	var stack = this.loadUriStack;
	for (var x in dojo.hostenv.loadedUris) {
		for (var y = stack.length - 1; y >= 0; y--) {
			if (stack[y][0] == x) {
				stack.splice(y, 1);
			}
		}
	}
	var next = stack.pop();
	if ((!next) && (stack.length == 0)) {
		return;
	}
	for (var x = 0; x < stack.length; x++) {
		if ((stack[x][0] == next[0]) && (stack[x][2])) {
			next[2] == stack[x][2];
		}
	}
	var last = next;
	while (dojo.hostenv.loadedUris[next[0]]) {
		last = next;
		next = stack.pop();
	}
	while (typeof next[2] == "string") {
		try {
			dj_eval(next[2]);
			next[1](true);
		}
		catch (e) {
			dojo.debug("we got an error when loading " + next[0]);
			dojo.debug("error: " + e);
		}
		dojo.hostenv.loadedUris[next[0]] = true;
		dojo.hostenv.loadedUris.push(next[0]);
		last = next;
		next = stack.pop();
		if ((!next) && (stack.length == 0)) {
			break;
		}
		while (dojo.hostenv.loadedUris[next[0]]) {
			last = next;
			next = stack.pop();
		}
	}
	if (next) {
		stack.push(next);
		dojo.debug("### CHOKED ON: " + next[0]);
	}
};
dojo.hostenv.loadUri = function (uri, cb) {
	if (dojo.hostenv.loadedUris[uri]) {
		return;
	}
	var stack = this.loadUriStack;
	stack.push([uri, cb, null]);
	var tcb = function (contents) {
		if (contents.content) {
			contents = contents.content;
		}
		var next = stack.pop();
		if ((!next) && (stack.length == 0)) {
			dojo.hostenv.modulesLoaded();
			return;
		}
		if (typeof contents == "string") {
			stack.push(next);
			for (var x = 0; x < stack.length; x++) {
				if (stack[x][0] == uri) {
					stack[x][2] = contents;
				}
			}
			next = stack.pop();
		}
		if (dojo.hostenv.loadedUris[next[0]]) {
			dojo.hostenv.unwindUriStack();
			return;
		}
		stack.push(next);
		if (next[0] != uri) {
			if (typeof next[2] == "string") {
				dojo.hostenv.unwindUriStack();
			}
		} else {
			if (!contents) {
				next[1](false);
			} else {
				var deps = dojo.hostenv.getDepsForEval(next[2]);
				if (deps.length > 0) {
					eval(deps.join(";"));
				} else {
					dojo.hostenv.unwindUriStack();
				}
			}
		}
	};
	this.getText(uri, tcb, true);
};
dojo.hostenv.loadModule = function (modulename, exact_only, omit_module_check) {
	var module = this.findModule(modulename, 0);
	if (module) {
		return module;
	}
	if (typeof this.loading_modules_[modulename] !== "undefined") {
		dojo.debug("recursive attempt to load module '" + modulename + "'");
	} else {
		this.addedToLoadingCount.push(modulename);
	}
	this.loading_modules_[modulename] = 1;
	var relpath = modulename.replace(/\./g, "/") + ".js";
	var syms = modulename.split(".");
	var nsyms = modulename.split(".");
	if (syms[0] == "dojo") {
		syms[0] = "src";
	}
	var last = syms.pop();
	syms.push(last);
	var _this = this;
	var pfn = this.pkgFileName;
	if (last == "*") {
		modulename = (nsyms.slice(0, -1)).join(".");
		var module = this.findModule(modulename, 0);
		if (module) {
			_this.removedFromLoadingCount.push(modulename);
			return module;
		}
		var nextTry = function (lastStatus) {
			if (lastStatus) {
				module = _this.findModule(modulename, false);
				if ((!module) && (syms[syms.length - 1] != pfn)) {
					dojo.raise("Module symbol '" + modulename + "' is not defined after loading '" + relpath + "'");
				}
				if (module) {
					_this.removedFromLoadingCount.push(modulename);
					dojo.hostenv.modulesLoaded();
					return;
				}
			}
			syms.pop();
			syms.push(pfn);
			relpath = syms.join("/") + ".js";
			if (relpath.charAt(0) == "/") {
				relpath = relpath.slice(1);
			}
			_this.loadPath(relpath, ((!omit_module_check) ? modulename : null), nextTry);
		};
		nextTry();
	} else {
		relpath = syms.join("/") + ".js";
		modulename = nsyms.join(".");
		var nextTry = function (lastStatus) {
			if (lastStatus) {
				module = _this.findModule(modulename, false);
				if ((!module) && (syms[syms.length - 1] != pfn)) {
					dojo.raise("Module symbol '" + modulename + "' is not defined after loading '" + relpath + "'");
				}
				if (module) {
					_this.removedFromLoadingCount.push(modulename);
					dojo.hostenv.modulesLoaded();
					return;
				}
			}
			var setPKG = (syms[syms.length - 1] == pfn) ? false : true;
			syms.pop();
			if (setPKG) {
				syms.push(pfn);
			}
			relpath = syms.join("/") + ".js";
			if (relpath.charAt(0) == "/") {
				relpath = relpath.slice(1);
			}
			_this.loadPath(relpath, ((!omit_module_check) ? modulename : null), nextTry);
		};
		this.loadPath(relpath, ((!omit_module_check) ? modulename : null), nextTry);
	}
	return;
};
dojo.hostenv.async_cb = null;
dojo.hostenv.unWindGetTextStack = function () {
	if (dojo.hostenv.inFlightCount > 0) {
		setTimeout("dojo.hostenv.unWindGetTextStack()", 100);
		return;
	}
	dojo.hostenv.inFlightCount++;
	var next = dojo.hostenv.getTextStack.pop();
	if ((!next) && (dojo.hostenv.getTextStack.length == 0)) {
		dojo.hostenv.inFlightCount--;
		dojo.hostenv.async_cb = function () {
		};
		return;
	}
	dojo.hostenv.async_cb = next[1];
	window.getURL(next[0], function (result) {
		dojo.hostenv.inFlightCount--;
		dojo.hostenv.async_cb(result.content);
		dojo.hostenv.unWindGetTextStack();
	});
};
dojo.hostenv.getText = function (uri, async_cb, fail_ok) {
	try {
		if (async_cb) {
			dojo.hostenv.getTextStack.push([uri, async_cb, fail_ok]);
			dojo.hostenv.unWindGetTextStack();
		} else {
			return dojo.raise("No synchronous XMLHTTP implementation available, for uri " + uri);
		}
	}
	catch (e) {
		return dojo.raise("No XMLHTTP implementation available, for uri " + uri);
	}
};
dojo.hostenv.postText = function (uri, async_cb, text, fail_ok, mime_type, encoding) {
	var http = null;
	var async_callback = function (httpResponse) {
		if (!httpResponse.success) {
			dojo.raise("Request for uri '" + uri + "' resulted in " + httpResponse.status);
		}
		if (!httpResponse.content) {
			if (!fail_ok) {
				dojo.raise("Request for uri '" + uri + "' resulted in no content");
			}
			return null;
		}
		async_cb(httpResponse.content);
	};
	try {
		if (async_cb) {
			http = window.postURL(uri, text, async_callback, mimeType, encoding);
		} else {
			return dojo.raise("No synchronous XMLHTTP post implementation available, for uri " + uri);
		}
	}
	catch (e) {
		return dojo.raise("No XMLHTTP post implementation available, for uri " + uri);
	}
};
function dj_last_script_src() {
	var scripts = window.document.getElementsByTagName("script");
	if (scripts.length < 1) {
		dojo.raise("No script elements in window.document, so can't figure out my script src");
	}
	var li = scripts.length - 1;
	var xlinkNS = "http://www.w3.org/1999/xlink";
	var src = null;
	var script = null;
	while (!src) {
		script = scripts.item(li);
		src = script.getAttributeNS(xlinkNS, "href");
		li--;
		if (li < 0) {
			break;
		}
	}
	if (!src) {
		dojo.raise("Last script element (out of " + scripts.length + ") has no src");
	}
	return src;
}
if (!dojo.hostenv["library_script_uri_"]) {
	dojo.hostenv.library_script_uri_ = dj_last_script_src();
}
dojo.requireIf((djConfig["isDebug"] || djConfig["debugAtAllCosts"]), "dojo.debug");


__CPAN_FILE__ src/debug.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.debug");
dojo.debug = function () {
	if (!djConfig.isDebug) {
		return;
	}
	var args = arguments;
	if (dj_undef("println", dojo.hostenv)) {
		dojo.raise("dojo.debug not available (yet?)");
	}
	var isJUM = dj_global["jum"] && !dj_global["jum"].isBrowser;
	var s = [(isJUM ? "" : "DEBUG: ")];
	for (var i = 0; i < args.length; ++i) {
		if (!false && args[i] && args[i] instanceof Error) {
			var msg = "[" + args[i].name + ": " + dojo.errorToString(args[i]) + (args[i].fileName ? ", file: " + args[i].fileName : "") + (args[i].lineNumber ? ", line: " + args[i].lineNumber : "") + "]";
		} else {
			try {
				var msg = String(args[i]);
			}
			catch (e) {
				if (dojo.render.html.ie) {
					var msg = "[ActiveXObject]";
				} else {
					var msg = "[unknown]";
				}
			}
		}
		s.push(msg);
	}
	dojo.hostenv.println(s.join(" "));
};
dojo.debugShallow = function (obj) {
	if (!djConfig.isDebug) {
		return;
	}
	dojo.debug("------------------------------------------------------------");
	dojo.debug("Object: " + obj);
	var props = [];
	for (var prop in obj) {
		try {
			props.push(prop + ": " + obj[prop]);
		}
		catch (E) {
			props.push(prop + ": ERROR - " + E.message);
		}
	}
	props.sort();
	for (var i = 0; i < props.length; i++) {
		dojo.debug(props[i]);
	}
	dojo.debug("------------------------------------------------------------");
};
dojo.debugDeep = function (obj) {
	if (!djConfig.isDebug) {
		return;
	}
	if (!dojo.uri || !dojo.uri.dojoUri) {
		return dojo.debug("You'll need to load dojo.uri.* for deep debugging - sorry!");
	}
	if (!window.open) {
		return dojo.debug("Deep debugging is only supported in host environments with window.open");
	}
	var idx = dojo.debugDeep.debugVars.length;
	dojo.debugDeep.debugVars.push(obj);
	var url = (djConfig["dojoDebugDeepHtmlUrl"] || new dojo.uri.Uri(location, dojo.uri.moduleUri("dojo.debug", "deep.html")).toString()) + "?var=" + idx;
	var win = window.open(url, "_blank", "width=600, height=400, resizable=yes, scrollbars=yes, status=yes");
	try {
		win.debugVar = obj;
	}
	catch (e) {
	}
};
dojo.debugDeep.debugVars = [];


__CPAN_FILE__ src/hostenv_spidermonkey.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.hostenv.name_ = "spidermonkey";
dojo.hostenv.println = print;
dojo.hostenv.exit = function (exitcode) {
	quit(exitcode);
};
dojo.hostenv.getVersion = function () {
	return version();
};
if (typeof line2pc == "undefined") {
	dojo.raise("attempt to use SpiderMonkey host environment when no 'line2pc' global");
}
function dj_spidermonkey_current_file(depth) {
	var s = "";
	try {
		throw Error("whatever");
	}
	catch (e) {
		s = e.stack;
	}
	var matches = s.match(/[^@]*\.js/gi);
	if (!matches) {
		dojo.raise("could not parse stack string: '" + s + "'");
	}
	var fname = (typeof depth != "undefined" && depth) ? matches[depth + 1] : matches[matches.length - 1];
	if (!fname) {
		dojo.raise("could not find file name in stack string '" + s + "'");
	}
	return fname;
}
if (!dojo.hostenv.library_script_uri_) {
	dojo.hostenv.library_script_uri_ = dj_spidermonkey_current_file(0);
}
dojo.hostenv.loadUri = function (uri) {
	var ok = load(uri);
	return 1;
};
dojo.requireIf((djConfig["isDebug"] || djConfig["debugAtAllCosts"]), "dojo.debug");


__CPAN_FILE__ src/loader.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

(function () {
	var _addHostEnv = {pkgFileName:"__package__", loading_modules_:{}, loaded_modules_:{}, addedToLoadingCount:[], removedFromLoadingCount:[], inFlightCount:0, modulePrefixes_:{dojo:{name:"dojo", value:"src"}}, setModulePrefix:function (module, prefix) {
		this.modulePrefixes_[module] = {name:module, value:prefix};
	}, moduleHasPrefix:function (module) {
		var mp = this.modulePrefixes_;
		return Boolean(mp[module] && mp[module].value);
	}, getModulePrefix:function (module) {
		if (this.moduleHasPrefix(module)) {
			return this.modulePrefixes_[module].value;
		}
		return module;
	}, getTextStack:[], loadUriStack:[], loadedUris:[], post_load_:false, modulesLoadedListeners:[], unloadListeners:[], loadNotifying:false};
	for (var param in _addHostEnv) {
		dojo.hostenv[param] = _addHostEnv[param];
	}
})();
dojo.hostenv.loadPath = function (relpath, module, cb) {
	var uri;
	if (relpath.charAt(0) == "/" || relpath.match(/^\w+:/)) {
		uri = relpath;
	} else {
		uri = this.getBaseScriptUri() + relpath;
	}
	if (djConfig.cacheBust && dojo.render.html.capable) {
		uri += "?" + String(djConfig.cacheBust).replace(/\W+/g, "");
	}
	try {
		return !module ? this.loadUri(uri, cb) : this.loadUriAndCheck(uri, module, cb);
	}
	catch (e) {
		dojo.debug(e);
		return false;
	}
};
dojo.hostenv.loadUri = function (uri, cb) {
	if (this.loadedUris[uri]) {
		return true;
	}
	var contents = this.getText(uri, null, true);
	if (!contents) {
		return false;
	}
	this.loadedUris[uri] = true;
	if (cb) {
		contents = "(" + contents + ")";
	}
	var value = dj_eval(contents);
	if (cb) {
		cb(value);
	}
	return true;
};
dojo.hostenv.loadUriAndCheck = function (uri, moduleName, cb) {
	var ok = true;
	try {
		ok = this.loadUri(uri, cb);
	}
	catch (e) {
		dojo.debug("failed loading ", uri, " with error: ", e);
	}
	return Boolean(ok && this.findModule(moduleName, false));
};
dojo.loaded = function () {
};
dojo.unloaded = function () {
};
dojo.hostenv.loaded = function () {
	this.loadNotifying = true;
	this.post_load_ = true;
	var mll = this.modulesLoadedListeners;
	for (var x = 0; x < mll.length; x++) {
		mll[x]();
	}
	this.modulesLoadedListeners = [];
	this.loadNotifying = false;
	dojo.loaded();
};
dojo.hostenv.unloaded = function () {
	var mll = this.unloadListeners;
	while (mll.length) {
		(mll.pop())();
	}
	dojo.unloaded();
};
dojo.addOnLoad = function (obj, functionName) {
	var dh = dojo.hostenv;
	if (arguments.length == 1) {
		dh.modulesLoadedListeners.push(obj);
	} else {
		if (arguments.length > 1) {
			dh.modulesLoadedListeners.push(function () {
				obj[functionName]();
			});
		}
	}
	if (dh.post_load_ && dh.inFlightCount == 0 && !dh.loadNotifying) {
		dh.callLoaded();
	}
};
dojo.addOnUnload = function (obj, functionName) {
	var dh = dojo.hostenv;
	if (arguments.length == 1) {
		dh.unloadListeners.push(obj);
	} else {
		if (arguments.length > 1) {
			dh.unloadListeners.push(function () {
				obj[functionName]();
			});
		}
	}
};
dojo.hostenv.modulesLoaded = function () {
	if (this.post_load_) {
		return;
	}
	if (this.loadUriStack.length == 0 && this.getTextStack.length == 0) {
		if (this.inFlightCount > 0) {
			dojo.debug("files still in flight!");
			return;
		}
		dojo.hostenv.callLoaded();
	}
};
dojo.hostenv.callLoaded = function () {
	if (typeof setTimeout == "object" || (djConfig["useXDomain"] && dojo.render.html.opera)) {
		setTimeout("dojo.hostenv.loaded();", 0);
	} else {
		dojo.hostenv.loaded();
	}
};
dojo.hostenv.getModuleSymbols = function (modulename) {
	var syms = modulename.split(".");
	for (var i = syms.length; i > 0; i--) {
		var parentModule = syms.slice(0, i).join(".");
		if ((i == 1) && !this.moduleHasPrefix(parentModule)) {
			syms[0] = "../" + syms[0];
		} else {
			var parentModulePath = this.getModulePrefix(parentModule);
			if (parentModulePath != parentModule) {
				syms.splice(0, i, parentModulePath);
				break;
			}
		}
	}
	return syms;
};
dojo.hostenv._global_omit_module_check = false;
dojo.hostenv.loadModule = function (moduleName, exactOnly, omitModuleCheck) {
	if (!moduleName) {
		return;
	}
	omitModuleCheck = this._global_omit_module_check || omitModuleCheck;
	var module = this.findModule(moduleName, false);
	if (module) {
		return module;
	}
	if (dj_undef(moduleName, this.loading_modules_)) {
		this.addedToLoadingCount.push(moduleName);
	}
	this.loading_modules_[moduleName] = 1;
	var relpath = moduleName.replace(/\./g, "/") + ".js";
	var nsyms = moduleName.split(".");
	var syms = this.getModuleSymbols(moduleName);
	var startedRelative = ((syms[0].charAt(0) != "/") && !syms[0].match(/^\w+:/));
	var last = syms[syms.length - 1];
	var ok;
	if (last == "*") {
		moduleName = nsyms.slice(0, -1).join(".");
		while (syms.length) {
			syms.pop();
			syms.push(this.pkgFileName);
			relpath = syms.join("/") + ".js";
			if (startedRelative && relpath.charAt(0) == "/") {
				relpath = relpath.slice(1);
			}
			ok = this.loadPath(relpath, !omitModuleCheck ? moduleName : null);
			if (ok) {
				break;
			}
			syms.pop();
		}
	} else {
		relpath = syms.join("/") + ".js";
		moduleName = nsyms.join(".");
		var modArg = !omitModuleCheck ? moduleName : null;
		ok = this.loadPath(relpath, modArg);
		if (!ok && !exactOnly) {
			syms.pop();
			while (syms.length) {
				relpath = syms.join("/") + ".js";
				ok = this.loadPath(relpath, modArg);
				if (ok) {
					break;
				}
				syms.pop();
				relpath = syms.join("/") + "/" + this.pkgFileName + ".js";
				if (startedRelative && relpath.charAt(0) == "/") {
					relpath = relpath.slice(1);
				}
				ok = this.loadPath(relpath, modArg);
				if (ok) {
					break;
				}
			}
		}
		if (!ok && !omitModuleCheck) {
			dojo.raise("Could not load '" + moduleName + "'; last tried '" + relpath + "'");
		}
	}
	if (!omitModuleCheck && !this["isXDomain"]) {
		module = this.findModule(moduleName, false);
		if (!module) {
			dojo.raise("symbol '" + moduleName + "' is not defined after loading '" + relpath + "'");
		}
	}
	return module;
};
dojo.hostenv.startPackage = function (packageName) {
	var fullPkgName = String(packageName);
	var strippedPkgName = fullPkgName;
	var syms = packageName.split(/\./);
	if (syms[syms.length - 1] == "*") {
		syms.pop();
		strippedPkgName = syms.join(".");
	}
	var evaledPkg = dojo.evalObjPath(strippedPkgName, true);
	this.loaded_modules_[fullPkgName] = evaledPkg;
	this.loaded_modules_[strippedPkgName] = evaledPkg;
	return evaledPkg;
};
dojo.hostenv.findModule = function (moduleName, mustExist) {
	var lmn = String(moduleName);
	if (this.loaded_modules_[lmn]) {
		return this.loaded_modules_[lmn];
	}
	if (mustExist) {
		dojo.raise("no loaded module named '" + moduleName + "'");
	}
	return null;
};
dojo.kwCompoundRequire = function (modMap) {
	var common = modMap["common"] || [];
	var result = modMap[dojo.hostenv.name_] ? common.concat(modMap[dojo.hostenv.name_] || []) : common.concat(modMap["default"] || []);
	for (var x = 0; x < result.length; x++) {
		var curr = result[x];
		if (curr.constructor == Array) {
			dojo.hostenv.loadModule.apply(dojo.hostenv, curr);
		} else {
			dojo.hostenv.loadModule(curr);
		}
	}
};
dojo.require = function (resourceName) {
	dojo.hostenv.loadModule.apply(dojo.hostenv, arguments);
};
dojo.requireIf = function (condition, resourceName) {
	var arg0 = arguments[0];
	if ((arg0 === true) || (arg0 == "common") || (arg0 && dojo.render[arg0].capable)) {
		var args = [];
		for (var i = 1; i < arguments.length; i++) {
			args.push(arguments[i]);
		}
		dojo.require.apply(dojo, args);
	}
};
dojo.requireAfterIf = dojo.requireIf;
dojo.provide = function (resourceName) {
	return dojo.hostenv.startPackage.apply(dojo.hostenv, arguments);
};
dojo.registerModulePath = function (module, prefix) {
	return dojo.hostenv.setModulePrefix(module, prefix);
};
if (djConfig["modulePaths"]) {
	for (var param in djConfig["modulePaths"]) {
		dojo.registerModulePath(param, djConfig["modulePaths"][param]);
	}
}
dojo.setModulePrefix = function (module, prefix) {
	dojo.deprecated("dojo.setModulePrefix(\"" + module + "\", \"" + prefix + "\")", "replaced by dojo.registerModulePath", "0.5");
	return dojo.registerModulePath(module, prefix);
};
dojo.exists = function (obj, name) {
	var p = name.split(".");
	for (var i = 0; i < p.length; i++) {
		if (!obj[p[i]]) {
			return false;
		}
		obj = obj[p[i]];
	}
	return true;
};
dojo.hostenv.normalizeLocale = function (locale) {
	var result = locale ? locale.toLowerCase() : dojo.locale;
	if (result == "root") {
		result = "ROOT";
	}
	return result;
};
dojo.hostenv.searchLocalePath = function (locale, down, searchFunc) {
	locale = dojo.hostenv.normalizeLocale(locale);
	var elements = locale.split("-");
	var searchlist = [];
	for (var i = elements.length; i > 0; i--) {
		searchlist.push(elements.slice(0, i).join("-"));
	}
	searchlist.push(false);
	if (down) {
		searchlist.reverse();
	}
	for (var j = searchlist.length - 1; j >= 0; j--) {
		var loc = searchlist[j] || "ROOT";
		var stop = searchFunc(loc);
		if (stop) {
			break;
		}
	}
};
dojo.hostenv.localesGenerated;
dojo.hostenv.registerNlsPrefix = function () {
	dojo.registerModulePath("nls", "nls");
};
dojo.hostenv.preloadLocalizations = function () {
	if (dojo.hostenv.localesGenerated) {
		dojo.hostenv.registerNlsPrefix();
		function preload(locale) {
			locale = dojo.hostenv.normalizeLocale(locale);
			dojo.hostenv.searchLocalePath(locale, true, function (loc) {
				for (var i = 0; i < dojo.hostenv.localesGenerated.length; i++) {
					if (dojo.hostenv.localesGenerated[i] == loc) {
						dojo["require"]("nls.dojo_" + loc);
						return true;
					}
				}
				return false;
			});
		}
		preload();
		var extra = djConfig.extraLocale || [];
		for (var i = 0; i < extra.length; i++) {
			preload(extra[i]);
		}
	}
	dojo.hostenv.preloadLocalizations = function () {
	};
};
dojo.requireLocalization = function (moduleName, bundleName, locale, availableFlatLocales) {
	dojo.hostenv.preloadLocalizations();
	var targetLocale = dojo.hostenv.normalizeLocale(locale);
	var bundlePackage = [moduleName, "nls", bundleName].join(".");
	var bestLocale = "";
	if (availableFlatLocales) {
		var flatLocales = availableFlatLocales.split(",");
		for (var i = 0; i < flatLocales.length; i++) {
			if (targetLocale.indexOf(flatLocales[i]) == 0) {
				if (flatLocales[i].length > bestLocale.length) {
					bestLocale = flatLocales[i];
				}
			}
		}
		if (!bestLocale) {
			bestLocale = "ROOT";
		}
	}
	var tempLocale = availableFlatLocales ? bestLocale : targetLocale;
	var bundle = dojo.hostenv.findModule(bundlePackage);
	var localizedBundle = null;
	if (bundle) {
		if (djConfig.localizationComplete && bundle._built) {
			return;
		}
		var jsLoc = tempLocale.replace("-", "_");
		var translationPackage = bundlePackage + "." + jsLoc;
		localizedBundle = dojo.hostenv.findModule(translationPackage);
	}
	if (!localizedBundle) {
		bundle = dojo.hostenv.startPackage(bundlePackage);
		var syms = dojo.hostenv.getModuleSymbols(moduleName);
		var modpath = syms.concat("nls").join("/");
		var parent;
		dojo.hostenv.searchLocalePath(tempLocale, availableFlatLocales, function (loc) {
			var jsLoc = loc.replace("-", "_");
			var translationPackage = bundlePackage + "." + jsLoc;
			var loaded = false;
			if (!dojo.hostenv.findModule(translationPackage)) {
				dojo.hostenv.startPackage(translationPackage);
				var module = [modpath];
				if (loc != "ROOT") {
					module.push(loc);
				}
				module.push(bundleName);
				var filespec = module.join("/") + ".js";
				loaded = dojo.hostenv.loadPath(filespec, null, function (hash) {
					var clazz = function () {
					};
					clazz.prototype = parent;
					bundle[jsLoc] = new clazz();
					for (var j in hash) {
						bundle[jsLoc][j] = hash[j];
					}
				});
			} else {
				loaded = true;
			}
			if (loaded && bundle[jsLoc]) {
				parent = bundle[jsLoc];
			} else {
				bundle[jsLoc] = parent;
			}
			if (availableFlatLocales) {
				return true;
			}
		});
	}
	if (availableFlatLocales && targetLocale != bestLocale) {
		bundle[targetLocale.replace("-", "_")] = bundle[bestLocale.replace("-", "_")];
	}
};
(function () {
	var extra = djConfig.extraLocale;
	if (extra) {
		if (!extra instanceof Array) {
			extra = [extra];
		}
		var req = dojo.requireLocalization;
		dojo.requireLocalization = function (m, b, locale, availableFlatLocales) {
			req(m, b, locale, availableFlatLocales);
			if (locale) {
				return;
			}
			for (var i = 0; i < extra.length; i++) {
				req(m, b, extra[i], availableFlatLocales);
			}
		};
	}
})();


__CPAN_FILE__ src/storage.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.storage");
dojo.require("dojo.lang.*");
dojo.require("dojo.event.*");
dojo.storage = new function () {
};
dojo.declare("dojo.storage", null, {SUCCESS:"success", FAILED:"failed", PENDING:"pending", SIZE_NOT_AVAILABLE:"Size not available", SIZE_NO_LIMIT:"No size limit", namespace:"default", onHideSettingsUI:null, initialize:function () {
	dojo.unimplemented("dojo.storage.initialize");
}, isAvailable:function () {
	dojo.unimplemented("dojo.storage.isAvailable");
}, put:function (key, value, resultsHandler) {
	dojo.unimplemented("dojo.storage.put");
}, get:function (key) {
	dojo.unimplemented("dojo.storage.get");
}, hasKey:function (key) {
	return (this.get(key) != null);
}, getKeys:function () {
	dojo.unimplemented("dojo.storage.getKeys");
}, clear:function () {
	dojo.unimplemented("dojo.storage.clear");
}, remove:function (key) {
	dojo.unimplemented("dojo.storage.remove");
}, isPermanent:function () {
	dojo.unimplemented("dojo.storage.isPermanent");
}, getMaximumSize:function () {
	dojo.unimplemented("dojo.storage.getMaximumSize");
}, hasSettingsUI:function () {
	return false;
}, showSettingsUI:function () {
	dojo.unimplemented("dojo.storage.showSettingsUI");
}, hideSettingsUI:function () {
	dojo.unimplemented("dojo.storage.hideSettingsUI");
}, getType:function () {
	dojo.unimplemented("dojo.storage.getType");
}, isValidKey:function (keyName) {
	if ((keyName == null) || (typeof keyName == "undefined")) {
		return false;
	}
	return /^[0-9A-Za-z_]*$/.test(keyName);
}});
dojo.storage.manager = new function () {
	this.currentProvider = null;
	this.available = false;
	this._initialized = false;
	this._providers = [];
	this.namespace = "default";
	this.initialize = function () {
		this.autodetect();
	};
	this.register = function (name, instance) {
		this._providers[this._providers.length] = instance;
		this._providers[name] = instance;
	};
	this.setProvider = function (storageClass) {
	};
	this.autodetect = function () {
		if (this._initialized == true) {
			return;
		}
		var providerToUse = null;
		for (var i = 0; i < this._providers.length; i++) {
			providerToUse = this._providers[i];
			if (dojo.lang.isUndefined(djConfig["forceStorageProvider"]) == false && providerToUse.getType() == djConfig["forceStorageProvider"]) {
				providerToUse.isAvailable();
				break;
			} else {
				if (dojo.lang.isUndefined(djConfig["forceStorageProvider"]) == true && providerToUse.isAvailable()) {
					break;
				}
			}
		}
		if (providerToUse == null) {
			this._initialized = true;
			this.available = false;
			this.currentProvider = null;
			dojo.raise("No storage provider found for this platform");
		}
		this.currentProvider = providerToUse;
		for (var i in providerToUse) {
			dojo.storage[i] = providerToUse[i];
		}
		dojo.storage.manager = this;
		dojo.storage.initialize();
		this._initialized = true;
		this.available = true;
	};
	this.isAvailable = function () {
		return this.available;
	};
	this.isInitialized = function () {
		if (this.currentProvider.getType() == "dojo.storage.browser.FlashStorageProvider" && dojo.flash.ready == false) {
			return false;
		} else {
			return this._initialized;
		}
	};
	this.supportsProvider = function (storageClass) {
		try {
			var provider = eval("new " + storageClass + "()");
			var results = provider.isAvailable();
			if (results == null || typeof results == "undefined") {
				return false;
			}
			return results;
		}
		catch (exception) {
			return false;
		}
	};
	this.getProvider = function () {
		return this.currentProvider;
	};
	this.loaded = function () {
	};
};


__CPAN_FILE__ src/style.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.style");
dojo.require("dojo.lang.common");
dojo.kwCompoundRequire({browser:["dojo.html.style"]});
dojo.deprecated("dojo.style", "replaced by dojo.html.style", "0.5");
dojo.lang.mixin(dojo.style, dojo.html);


__CPAN_FILE__ src/data.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.data");
dojo.data = {};


__CPAN_FILE__ src/browser_debug_xd.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.browser_debug_xd");
dojo.nonDebugProvide = dojo.provide;
dojo.provide = function (resourceName) {
	var dbgQueue = dojo.hostenv["xdDebugQueue"];
	if (dbgQueue && dbgQueue.length > 0 && resourceName == dbgQueue["currentResourceName"]) {
		window.setTimeout("dojo.hostenv.xdDebugFileLoaded('" + resourceName + "')", 1);
	}
	dojo.nonDebugProvide.apply(dojo, arguments);
};
dojo.hostenv.xdDebugFileLoaded = function (resourceName) {
	var dbgQueue = this.xdDebugQueue;
	if (resourceName && resourceName == dbgQueue.currentResourceName) {
		dbgQueue.shift();
	}
	if (dbgQueue.length == 0) {
		dbgQueue.currentResourceName = null;
		this.xdNotifyLoaded();
	} else {
		dbgQueue.currentResourceName = dbgQueue[0].resourceName;
		var element = document.createElement("script");
		element.type = "text/javascript";
		element.src = dbgQueue[0].resourcePath;
		document.getElementsByTagName("head")[0].appendChild(element);
	}
};


__CPAN_FILE__ src/svg.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.svg");
dojo.require("dojo.lang.common");
dojo.require("dojo.dom");
dojo.mixin(dojo.svg, dojo.dom);
dojo.svg.graphics = dojo.svg.g = new function (d) {
	this.suspend = function () {
		try {
			d.documentElement.suspendRedraw(0);
		}
		catch (e) {
		}
	};
	this.resume = function () {
		try {
			d.documentElement.unsuspendRedraw(0);
		}
		catch (e) {
		}
	};
	this.force = function () {
		try {
			d.documentElement.forceRedraw();
		}
		catch (e) {
		}
	};
}(document);
dojo.svg.animations = dojo.svg.anim = new function (d) {
	this.arePaused = function () {
		try {
			return d.documentElement.animationsPaused();
		}
		catch (e) {
			return false;
		}
	};
	this.pause = function () {
		try {
			d.documentElement.pauseAnimations();
		}
		catch (e) {
		}
	};
	this.resume = function () {
		try {
			d.documentElement.unpauseAnimations();
		}
		catch (e) {
		}
	};
}(document);
dojo.svg.toCamelCase = function (selector) {
	var arr = selector.split("-"), cc = arr[0];
	for (var i = 1; i < arr.length; i++) {
		cc += arr[i].charAt(0).toUpperCase() + arr[i].substring(1);
	}
	return cc;
};
dojo.svg.toSelectorCase = function (selector) {
	return selector.replace(/([A-Z])/g, "-$1").toLowerCase();
};
dojo.svg.getStyle = function (node, cssSelector) {
	return document.defaultView.getComputedStyle(node, cssSelector);
};
dojo.svg.getNumericStyle = function (node, cssSelector) {
	return parseFloat(dojo.svg.getStyle(node, cssSelector));
};
dojo.svg.getOpacity = function (node) {
	return Math.min(1, dojo.svg.getNumericStyle(node, "fill-opacity"));
};
dojo.svg.setOpacity = function (node, opacity) {
	node.setAttributeNS(this.xmlns.svg, "fill-opacity", opacity);
	node.setAttributeNS(this.xmlns.svg, "stroke-opacity", opacity);
};
dojo.svg.clearOpacity = function (node) {
	node.setAttributeNS(this.xmlns.svg, "fill-opacity", "1.0");
	node.setAttributeNS(this.xmlns.svg, "stroke-opacity", "1.0");
};
dojo.svg.getCoords = function (node) {
	if (node.getBBox) {
		var box = node.getBBox();
		return {x:box.x, y:box.y};
	}
	return null;
};
dojo.svg.setCoords = function (node, coords) {
	var p = dojo.svg.getCoords();
	if (!p) {
		return;
	}
	var dx = p.x - coords.x;
	var dy = p.y - coords.y;
	dojo.svg.translate(node, dx, dy);
};
dojo.svg.getDimensions = function (node) {
	if (node.getBBox) {
		var box = node.getBBox();
		return {width:box.width, height:box.height};
	}
	return null;
};
dojo.svg.setDimensions = function (node, dim) {
	if (node.width) {
		node.width.baseVal.value = dim.width;
		node.height.baseVal.value = dim.height;
	} else {
		if (node.r) {
			node.r.baseVal.value = Math.min(dim.width, dim.height) / 2;
		} else {
			if (node.rx) {
				node.rx.baseVal.value = dim.width / 2;
				node.ry.baseVal.value = dim.height / 2;
			}
		}
	}
};
dojo.svg.translate = function (node, dx, dy) {
	if (node.transform && node.ownerSVGElement && node.ownerSVGElement.createSVGTransform) {
		var t = node.ownerSVGElement.createSVGTransform();
		t.setTranslate(dx, dy);
		node.transform.baseVal.appendItem(t);
	}
};
dojo.svg.scale = function (node, scaleX, scaleY) {
	if (!scaleY) {
		var scaleY = scaleX;
	}
	if (node.transform && node.ownerSVGElement && node.ownerSVGElement.createSVGTransform) {
		var t = node.ownerSVGElement.createSVGTransform();
		t.setScale(scaleX, scaleY);
		node.transform.baseVal.appendItem(t);
	}
};
dojo.svg.rotate = function (node, ang, cx, cy) {
	if (node.transform && node.ownerSVGElement && node.ownerSVGElement.createSVGTransform) {
		var t = node.ownerSVGElement.createSVGTransform();
		if (cx == null) {
			t.setMatrix(t.matrix.rotate(ang));
		} else {
			t.setRotate(ang, cx, cy);
		}
		node.transform.baseVal.appendItem(t);
	}
};
dojo.svg.skew = function (node, ang, axis) {
	var dir = axis || "x";
	if (node.transform && node.ownerSVGElement && node.ownerSVGElement.createSVGTransform) {
		var t = node.ownerSVGElement.createSVGTransform();
		if (dir != "x") {
			t.setSkewY(ang);
		} else {
			t.setSkewX(ang);
		}
		node.transform.baseVal.appendItem(t);
	}
};
dojo.svg.flip = function (node, axis) {
	var dir = axis || "x";
	if (node.transform && node.ownerSVGElement && node.ownerSVGElement.createSVGTransform) {
		var t = node.ownerSVGElement.createSVGTransform();
		t.setMatrix((dir != "x") ? t.matrix.flipY() : t.matrix.flipX());
		node.transform.baseVal.appendItem(t);
	}
};
dojo.svg.invert = function (node) {
	if (node.transform && node.ownerSVGElement && node.ownerSVGElement.createSVGTransform) {
		var t = node.ownerSVGElement.createSVGTransform();
		t.setMatrix(t.matrix.inverse());
		node.transform.baseVal.appendItem(t);
	}
};
dojo.svg.applyMatrix = function (node, a, b, c, d, e, f) {
	if (node.transform && node.ownerSVGElement && node.ownerSVGElement.createSVGTransform) {
		var m;
		if (b) {
			var m = node.ownerSVGElement.createSVGMatrix();
			m.a = a;
			m.b = b;
			m.c = c;
			m.d = d;
			m.e = e;
			m.f = f;
		} else {
			m = a;
		}
		var t = node.ownerSVGElement.createSVGTransform();
		t.setMatrix(m);
		node.transform.baseVal.appendItem(t);
	}
};
dojo.svg.group = function (nodes) {
	var p = nodes.item(0).parentNode;
	var g = document.createElementNS(this.xmlns.svg, "g");
	for (var i = 0; i < nodes.length; i++) {
		g.appendChild(nodes.item(i));
	}
	p.appendChild(g);
	return g;
};
dojo.svg.ungroup = function (g) {
	var p = g.parentNode;
	while (g.childNodes.length > 0) {
		p.appendChild(g.childNodes.item(0));
	}
	p.removeChild(g);
};
dojo.svg.getGroup = function (node) {
	var a = this.getAncestors(node);
	for (var i = 0; i < a.length; i++) {
		if (a[i].nodeType == this.ELEMENT_NODE && a[i].nodeName.toLowerCase() == "g") {
			return a[i];
		}
	}
	return null;
};
dojo.svg.bringToFront = function (node) {
	var n = this.getGroup(node) || node;
	n.ownerSVGElement.appendChild(n);
};
dojo.svg.sendToBack = function (node) {
	var n = this.getGroup(node) || node;
	n.ownerSVGElement.insertBefore(n, n.ownerSVGElement.firstChild);
};
dojo.svg.bringForward = function (node) {
	var n = this.getGroup(node) || node;
	if (this.getLastChildElement(n.parentNode) != n) {
		this.insertAfter(n, this.getNextSiblingElement(n), true);
	}
};
dojo.svg.sendBackward = function (node) {
	var n = this.getGroup(node) || node;
	if (this.getFirstChildElement(n.parentNode) != n) {
		this.insertBefore(n, this.getPreviousSiblingElement(n), true);
	}
};
dojo.svg.createNodesFromText = function (txt, wrap) {
	var docFrag = (new DOMParser()).parseFromString(txt, "text/xml").normalize();
	if (wrap) {
		return [docFrag.firstChild.cloneNode(true)];
	}
	var nodes = [];
	for (var x = 0; x < docFrag.childNodes.length; x++) {
		nodes.push(docFrag.childNodes.item(x).cloneNode(true));
	}
	return nodes;
};


__CPAN_FILE__ src/validate.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.validate");
dojo.require("dojo.validate.common");


__CPAN_FILE__ src/crypto.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.crypto");
dojo.crypto.cipherModes = {ECB:0, CBC:1, PCBC:2, CFB:3, OFB:4, CTR:5};
dojo.crypto.outputTypes = {Base64:0, Hex:1, String:2, Raw:3};


__CPAN_FILE__ src/docs.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.docs");
dojo.require("dojo.io.*");
dojo.require("dojo.event.topic");
dojo.require("dojo.rpc.JotService");
dojo.require("dojo.dom");
dojo.require("dojo.uri.Uri");
dojo.require("dojo.Deferred");
dojo.require("dojo.DeferredList");

/*
 * TODO:
 *
 * Package summary needs to compensate for "is"
 * Handle host environments
 * Deal with dojo.widget weirdness
 * Parse parameters
 * Limit function parameters to only the valid ones (Involves packing parameters onto meta during rewriting)
 *
 */

dojo.docs = new function() {
	this._url = dojo.uri.dojoUri("docscripts");
	this._rpc = new dojo.rpc.JotService;
	this._rpc.serviceUrl = dojo.uri.dojoUri("docscripts/jsonrpc.php");
};
dojo.lang.mixin(dojo.docs, {
	_count: 0,
	_callbacks: {function_names: []},
	_cache: {}, // Saves the JSON objects in cache
	require: function(/*String*/ require, /*bool*/ sync) {
		dojo.debug("require(): " + require);
		var parts = require.split("/");
		
		var size = parts.length;
		var deferred = new dojo.Deferred;
		var args = {
			mimetype: "text/json",
			load: function(type, data){
				dojo.debug("require(): loaded for " + require);
				
				if(parts[0] != "function_names") {
					for(var i = 0, part; part = parts[i]; i++){
						data = data[part];
					}
				}
				deferred.callback(data);
			},
			error: function(){
				deferred.errback();
			}
		};

		if(location.protocol == "file:"){
			if(size){
				if(parts[parts.length - 1] == "documentation"){
					parts[parts.length - 1] = "meta";
				}
			
				if(parts[0] == "function_names"){
					args.url = [this._url, "local_json", "function_names"].join("/");
				}else{
					var dirs = parts[0].split(".");
					args.url = [this._url, "local_json", dirs[0]].join("/");
					if(dirs.length > 1){
						args.url = [args.url, dirs[1]].join(".");
					}
				}
			}
		}
		
		dojo.io.bind(args);
		return deferred;
	},
	getFunctionNames: function(){
		return this.require("function_names"); // dojo.Deferred
	},
	unFormat: function(/*String*/ string){
		var fString = string;
		if(string.charAt(string.length - 1) == "_"){
			fString = [string.substring(0, string.length - 1), "*"].join("");
		}
		return fString;
	},
	getMeta: function(/*String*/ pkg, /*String*/ name, /*Function*/ callback, /*String?*/ id){
		// summary: Gets information about a function in regards to its meta data
		if(typeof name == "function"){
			// pId: a
			// pkg: ignore
			id = callback;
			callback = name;
			name = pkg;
			pkg = null;
			dojo.debug("getMeta(" + name + ")");
		}else{
			dojo.debug("getMeta(" + pkg + "/" + name + ")");
		}
		
		if(!id){
			id = "_";
		}
	},
	_withPkg: function(/*String*/ type, /*Object*/ data, /*Object*/ evt, /*Object*/ input, /*String*/ newType){
		dojo.debug("_withPkg(" + evt.name + ") has package: " + data[0]);
		evt.pkg = data[0];
		if("load" == type && evt.pkg){
			evt.type = newType;
		}else{
			if(evt.callbacks && evt.callbacks.length){
				evt.callbacks.shift()("error", {}, evt, evt.input);
			}
		}
	},
	_gotMeta: function(/*String*/ type, /*Object*/ data, /*Object*/ evt){
		dojo.debug("_gotMeta(" + evt.name + ")");

		var cached = dojo.docs._getCache(evt.pkg, evt.name, "meta", "functions", evt.id);
		if(cached.summary){
			data.summary = cached.summary;
		}
		if(evt.callbacks && evt.callbacks.length){
			evt.callbacks.shift()(type, data, evt, evt.input);
		}
	},
	getSrc: function(/*String*/ name, /*Function*/ callback, /*String?*/ id){
		// summary: Gets src file (created by the doc parser)
		dojo.debug("getSrc(" + name + ")");
		if(!id){
			id = "_";
		}
	},
	getDoc: function(/*String*/ name, /*Function*/ callback, /*String?*/ id){
		// summary: Gets external documentation stored on Jot for a given function
		dojo.debug("getDoc(" + name  + ")");

		if(!id){
			id = "_";
		}

		var input = {};

		input.type = "doc";
		input.name = name;
		input.callbacks = [callback];
	},
	_gotDoc: function(/*String*/ type, /*Array*/ data, /*Object*/ evt, /*Object*/ input){
		dojo.debug("_gotDoc(" + evt.type + ")");
		
		evt[evt.type] = data;
		if(evt.expects && evt.expects.doc){
			for(var i = 0, expect; expect = evt.expects.doc[i]; i++){
				if(!(expect in evt)){
					dojo.debug("_gotDoc() waiting for more data");
					return;
				}
			}
		}
		
		var cache = dojo.docs._getCache(evt.pkg, "meta", "functions", evt.name, evt.id, "meta");

		var description = evt.fn.description;
		cache.description = description;
		data = {
			returns: evt.fn.returns,
			id: evt.id,
			variables: []
		}
		if(!cache.parameters){
			cache.parameters = {};
		}
		for(var i = 0, param; param = evt.param[i]; i++){
			var fName = param["DocParamForm/name"];
			if(!cache.parameters[fName]){
				cache.parameters[fName] = {};
			}
			cache.parameters[fName].description = param["DocParamForm/desc"]
		}

		data.description = cache.description;
		data.parameters = cache.parameters;
		
		evt.type = "doc";
	
		if(evt.callbacks && evt.callbacks.length){
			evt.callbacks.shift()("load", data, evt, input);
		}
	},
	getPkgDoc: function(/*String*/ name, /*Function*/ callback){
		// summary: Gets external documentation stored on Jot for a given package
		dojo.debug("getPkgDoc(" + name + ")");
		var input = {};
	},
	getPkgInfo: function(/*String*/ name, /*Function*/ callback){
		// summary: Gets a combination of the metadata and external documentation for a given package
		dojo.debug("getPkgInfo(" + name + ")");

		var input = {
			expects: {
				pkginfo: ["pkgmeta", "pkgdoc"]
			},
			callback: callback
		};
		dojo.docs.getPkgMeta(input, name, dojo.docs._getPkgInfo);
		dojo.docs.getPkgDoc(input, name, dojo.docs._getPkgInfo);
	},
	_getPkgInfo: function(/*String*/ type, /*Object*/ data, /*Object*/ evt){
		dojo.debug("_getPkgInfo() for " + evt.type);
		var input = {};
		var results = {};
		if(typeof key == "object"){
			input = key;
			input[evt.type] = data;
			if(input.expects && input.expects.pkginfo){
				for(var i = 0, expect; expect = input.expects.pkginfo[i]; i++){
					if(!(expect in input)){
						dojo.debug("_getPkgInfo() waiting for more data");
						return;
					}
				}
			}
			results = input.pkgmeta;
			results.description = input.pkgdoc;
		}

		if(input.callback){
			input.callback("load", results, evt);
		}
	},
	getInfo: function(/*String*/ name, /*Function*/ callback){
		dojo.debug("getInfo(" + name + ")");
		var input = {
			expects: {
				"info": ["meta", "doc"]
			},
			callback: callback
		}
		dojo.docs.getMeta(input, name, dojo.docs._getInfo);
		dojo.docs.getDoc(input, name, dojo.docs._getInfo);
	},
	_getInfo: function(/*String*/ type, /*String*/ data, /*Object*/ evt, /*Object*/ input){
		dojo.debug("_getInfo(" + evt.type + ")");
		if(input && input.expects && input.expects.info){
			input[evt.type] = data;
			for(var i = 0, expect; expect = input.expects.info[i]; i++){
				if(!(expect in input)){
					dojo.debug("_getInfo() waiting for more data");
					return;
				}
			}
		}

		if(input.callback){
			input.callback("load", dojo.docs._getCache(evt.pkg, "meta", "functions", evt.name, evt.id, "meta"), evt, input);
		}
	},
	_getMainText: function(/*String*/ text){
		// summary: Grabs the innerHTML from a Jot Rech Text node
		dojo.debug("_getMainText()");
		return text.replace(/^<html[^<]*>/, "").replace(/<\/html>$/, "").replace(/<\w+\s*\/>/g, "");
	},
	getPackageMeta: function(/*Object*/ input){
		dojo.debug("getPackageMeta(): " + input.package);
		return this.require(input.package + "/meta", input.sync);
	},
	getFunctionMeta: function(/*Object*/ input){
		var package = input.package || "";
		var name = input.name;
		var id = input.id || "_";
		dojo.debug("getFunctionMeta(): " + name);

		if(!name) return;

		if(package){
			return this.require(package + "/meta/functions/" + name + "/" + id + "/meta");
		}else{
			this.getFunctionNames();
		}
	},
	getFunctionDocumentation: function(/*Object*/ input){
		var package = input.package || "";
		var name = input.name;
		var id = input.id || "_";
		dojo.debug("getFunctionDocumentation(): " + name);
		
		if(!name) return;
		
		if(package){
			return this.require(package + "/meta/functions/" + name + "/" + id + "/documentation");
		}
	},
	_onDocSearch: function(/*Object*/ input){
		var _this = this;
		var name = input.name.toLowerCase();
		if(!name) return;

		this.getFunctionNames().addCallback(function(data){
			dojo.debug("_onDocSearch(): function names loaded for " + name);

			var output = [];
			var list = [];
			var closure = function(pkg, fn) {
				return function(data){
					dojo.debug("_onDocSearch(): package meta loaded for: " + pkg);
					if(data.functions){
						var functions = data.functions;
						for(var key in functions){
							if(fn == key){
								var ids = functions[key];
								for(var id in ids){
									var fnMeta = ids[id];
									output.push({
										package: pkg,
										name: fn,
										id: id,
										summary: fnMeta.summary
									});
								}
							}
						}
					}
					return output;
				}
			}

			pkgLoop:
			for(var pkg in data){
				if(pkg.toLowerCase() == name){
					name = pkg;
					dojo.debug("_onDocSearch found a package");
					//dojo.docs._onDocSelectPackage(input);
					return;
				}
				for(var i = 0, fn; fn = data[pkg][i]; i++){
					if(fn.toLowerCase().indexOf(name) != -1){
						dojo.debug("_onDocSearch(): Search matched " + fn);
						var meta = _this.getPackageMeta({package: pkg});
						meta.addCallback(closure(pkg, fn));
						list.push(meta);

						// Build a list of all packages that need to be loaded and their loaded state.
						continue pkgLoop;
					}
				}
			}
			
			list = new dojo.DeferredList(list);
			list.addCallback(function(results){
				dojo.debug("_onDocSearch(): All packages loaded");
				_this._printFunctionResults(results[0][1]);
			});
		});
	},
	_onDocSearchFn: function(/*String*/ type, /*Array*/ data, /*Object*/ evt){
		dojo.debug("_onDocSearchFn(" + evt.name + ")");

		var name = evt.name || evt.pkg;

		dojo.debug("_onDocSearchFn found a function");

		evt.pkgs = packages;
		evt.pkg = name;
		evt.loaded = 0;
		for(var i = 0, pkg; pkg = packages[i]; i++){
			dojo.docs.getPkgMeta(evt, pkg, dojo.docs._onDocResults);
		}
	},
	_onPkgResults: function(/*String*/ type, /*Object*/ data, /*Object*/ evt, /*Object*/ input){
		dojo.debug("_onPkgResults(" + evt.type + ")");
		var description = "";
		var path = "";
		var methods = {};
		var requires = {};
		if(input){
			input[evt.type] = data;
			if(input.expects && input.expects.pkgresults){
				for(var i = 0, expect; expect = input.expects.pkgresults[i]; i++){
					if(!(expect in input)){
						dojo.debug("_onPkgResults() waiting for more data");
						return;
					}
				}
			}
			path = input.pkgdoc.path;
			description = input.pkgdoc.description;
			methods = input.pkgmeta.methods;
			requires = input.pkgmeta.requires;
		}
		var pkg = evt.name.replace("_", "*");
		var results = {
			path: path,
			description: description,
			size: 0,
			methods: [],
			pkg: pkg,
			requires: requires
		}
		var rePrivate = /_[^.]+$/;
		for(var method in methods){
			if(!rePrivate.test(method)){
				for(var pId in methods[method]){
					results.methods.push({
						pkg: pkg,
						name: method,
						id: pId,
						summary: methods[method][pId].summary
					})
				}
			}
		}
		results.size = results.methods.length;
		dojo.docs._printPkgResult(results);
	},
	_onDocResults: function(/*String*/ type, /*Object*/ data, /*Object*/ evt, /*Object*/ input){
		dojo.debug("_onDocResults(" + evt.name + "/" + input.pkg + ") " + type);
		++input.loaded;

		if(input.loaded == input.pkgs.length){
			var pkgs = input.pkgs;
			var name = input.pkg;
			var results = {methods: []};
			var rePrivate = /_[^.]+$/;
			data = dojo.docs._cache;

			for(var i = 0, pkg; pkg = pkgs[i]; i++){
				var methods = dojo.docs._getCache(pkg, "meta", "methods");
				for(var fn in methods){
					if(fn.toLowerCase().indexOf(name) == -1){
						continue;
					}
					if(fn != "requires" && !rePrivate.test(fn)){
						for(var pId in methods[fn]){
							var result = {
								pkg: pkg,
								name: fn,
								id: "_",
								summary: ""
							}
							if(methods[fn][pId].summary){
								result.summary = methods[fn][pId].summary;
							}
							results.methods.push(result);
						}
					}
				}
			}

			dojo.debug("Publishing docResults");
			dojo.docs._printFnResults(results);
		}
	},
	_printFunctionResults: function(results){
		dojo.debug("_printFnResults(): called");
		// summary: Call this function to send the /docs/function/results topic
	},
	_printPkgResult: function(results){
		dojo.debug("_printPkgResult(): called");
	},
	_onDocSelectFunction: function(/*Object*/ input){
		// summary: Get doc, meta, and src
		var name = input.name;
		var package = input.package || "";
		var id = input.id || "_";
		dojo.debug("_onDocSelectFunction(" + name + ")");
		if(!name || !package) return false;

		var pkgMeta = this.getPackageMeta({package: package});
		var meta = this.getFunctionMeta({package: package, name: name, id: id});
		var doc = this.getFunctionDocumentation({package: package, name: name, id: id});
		
		var list = new dojo.DeferredList([pkgMeta, meta, doc]);
		list.addCallback(function(results){
			dojo.debug("_onDocSelectFunction() loaded");
			for(var i = 0, result; result = results[i]; i++){
				dojo.debugShallow(result[1]);
			}
		});
		
		return list;
	},
	_onDocSelectPackage: function(/*Object*/ input){
		dojo.debug("_onDocSelectPackage(" + input.name + ")")
		input.expects = {
			"pkgresults": ["pkgmeta", "pkgdoc"]
		};
		dojo.docs.getPkgMeta(input, input.name, dojo.docs._onPkgResults);
		dojo.docs.getPkgDoc(input, input.name, dojo.docs._onPkgResults);
	},
	_onDocSelectResults: function(/*String*/ type, /*Object*/ data, /*Object*/ evt, /*Object*/ input){
		dojo.debug("_onDocSelectResults(" + evt.type + ", " + evt.name + ")");
		if(evt.type == "meta"){
			dojo.docs.getPkgMeta(input, evt.pkg, dojo.docs._onDocSelectResults);
		}
		if(input){
			input[evt.type] = data;
			if(input.expects && input.expects.docresults){
				for(var i = 0, expect; expect = input.expects.docresults[i]; i++){
					if(!(expect in input)){
						dojo.debug("_onDocSelectResults() waiting for more data");
						return;
					}
				}
			}
		}

		dojo.docs._printFunctionDetail(input);
	},
	
	_printFunctionDetail: function(results) {
		// summary: Call this function to send the /docs/function/detail topic event
	},

	selectFunction: function(/*String*/ name, /*String?*/ id){
		// summary: The combined information
	},
	savePackage: function(/*Object*/ callbackObject, /*String*/ callback, /*Object*/ parameters){
		dojo.event.kwConnect({
			srcObj: dojo.docs,
			srcFunc: "_savedPkgRpc",
			targetObj: callbackObject,
			targetFunc: callback,
			once: true
		});
		
		var props = {};
		var cache = dojo.docs._getCache(parameters.pkg, "meta");

		var i = 1;

		if(!cache.path){
			var path = "id";
			props[["pname", i].join("")] = "DocPkgForm/require";
			props[["pvalue", i++].join("")] = parameters.pkg;
		}else{
			var path = cache.path;
		}

		props.form = "//DocPkgForm";
		props.path = ["/WikiHome/DojoDotDoc/", path].join("");

		if(parameters.description){
			props[["pname", i].join("")] = "main/text";
			props[["pvalue", i++].join("")] = parameters.description;
		}
		
		dojo.docs._rpc.callRemote("saveForm",	props).addCallbacks(dojo.docs._pkgRpc, dojo.docs._pkgRpc);
	},
	_pkgRpc: function(data){
		if(data.name){
			dojo.docs._getCache(data["DocPkgForm/require"], "meta").path = data.name;
			dojo.docs._savedPkgRpc("load");
		}else{
			dojo.docs._savedPkgRpc("error");
		}
	},
	_savedPkgRpc: function(type){
	},
	functionPackages: function(/*String*/ name, /*Function*/ callback, /*Object*/ input){
		// summary: Gets the package associated with a function and stores it in the .pkg value of input
		dojo.debug("functionPackages() name: " + name);

		if(!input){
			input = {};
		}
		if(!input.callbacks){
			input.callbacks = [];
		}

		input.type = "function_names";
		input.name = name;
		input.callbacks.unshift(callback);
		input.callbacks.unshift(dojo.docs._functionPackages);
	},
	_functionPackages: function(/*String*/ type, /*Array*/ data, /*Object*/ evt){
		dojo.debug("_functionPackages() name: " + evt.name);
		evt.pkg = '';

		var results = [];
		var data = dojo.docs._cache['function_names'];
		for(var key in data){
			if(dojo.lang.inArray(data[key], evt.name)){
				dojo.debug("_functionPackages() package: " + key);
				results.push(key);
			}
		}

		if(evt.callbacks && evt.callbacks.length){
			evt.callbacks.shift()(type, results, evt, evt.input);
		}
	},
	setUserName: function(/*String*/ name){
		dojo.docs._userName = name;
		if(name && dojo.docs._password){
			dojo.docs._logIn();
		}
	},
	setPassword: function(/*String*/ password){
		dojo.docs._password = password;
		if(password && dojo.docs._userName){
			dojo.docs._logIn();
		}
	},
	_logIn: function(){
		dojo.io.bind({
			url: dojo.docs._rpc.serviceUrl.toString(),
			method: "post",
			mimetype: "text/json",
			content: {
				username: dojo.docs._userName,
				password: dojo.docs._password
			},
			load: function(type, data){
				if(data.error){
					dojo.docs.logInSuccess();
				}else{
					dojo.docs.logInFailure();
				}
			},
			error: function(){
				dojo.docs.logInFailure();
			}
		});
	},
	logInSuccess: function(){},
	logInFailure: function(){},
	_set: function(/*Object*/ base, /*String...*/ keys, /*String*/ value){
		var args = [];
		for(var i = 0, arg; arg = arguments[i]; i++){
			args.push(arg);
		}

		if(args.length < 3) return;
		base = args.shift();
		value = args.pop();
		var key = args.pop();
		for(var i = 0, arg; arg = args[i]; i++){
			if(typeof base[arg] != "object"){
				base[arg] = {};
			}
			base = base[arg];
		}
		base[key] = value;
	},
	_getCache: function(/*String...*/ keys){
		var obj = dojo.docs._cache;
		for(var i = 0; i < arguments.length; i++){
			var arg = arguments[i];
			if(!obj[arg]){
				obj[arg] = {};
			}
			obj = obj[arg];
		}
		return obj;
	}
});

dojo.event.topic.subscribe("/docs/search", dojo.docs, "_onDocSearch");
dojo.event.topic.subscribe("/docs/function/select", dojo.docs, "_onDocSelectFunction");
dojo.event.topic.subscribe("/docs/package/select", dojo.docs, "_onDocSelectPackage");

dojo.event.topic.registerPublisher("/docs/function/results", dojo.docs, "_printFunctionResults");
dojo.event.topic.registerPublisher("/docs/function/detail", dojo.docs, "_printFunctionDetail");
dojo.event.topic.registerPublisher("/docs/package/detail", dojo.docs, "_printPkgResult");

__CPAN_FILE__ src/regexp.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.regexp");
dojo.evalObjPath("dojo.regexp.us", true);
dojo.regexp.tld = function (flags) {
	flags = (typeof flags == "object") ? flags : {};
	if (typeof flags.allowCC != "boolean") {
		flags.allowCC = true;
	}
	if (typeof flags.allowInfra != "boolean") {
		flags.allowInfra = true;
	}
	if (typeof flags.allowGeneric != "boolean") {
		flags.allowGeneric = true;
	}
	var infraRE = "arpa";
	var genericRE = "aero|biz|com|coop|edu|gov|info|int|mil|museum|name|net|org|pro|travel|xxx|jobs|mobi|post";
	var ccRE = "ac|ad|ae|af|ag|ai|al|am|an|ao|aq|ar|as|at|au|aw|az|ba|bb|bd|be|bf|bg|bh|bi|bj|bm|bn|bo|br|" + "bs|bt|bv|bw|by|bz|ca|cc|cd|cf|cg|ch|ci|ck|cl|cm|cn|co|cr|cu|cv|cx|cy|cz|de|dj|dk|dm|do|dz|" + "ec|ee|eg|er|eu|es|et|fi|fj|fk|fm|fo|fr|ga|gd|ge|gf|gg|gh|gi|gl|gm|gn|gp|gq|gr|gs|gt|gu|gw|" + "gy|hk|hm|hn|hr|ht|hu|id|ie|il|im|in|io|ir|is|it|je|jm|jo|jp|ke|kg|kh|ki|km|kn|kr|kw|ky|kz|" + "la|lb|lc|li|lk|lr|ls|lt|lu|lv|ly|ma|mc|md|mg|mh|mk|ml|mm|mn|mo|mp|mq|mr|ms|mt|mu|mv|mw|mx|" + "my|mz|na|nc|ne|nf|ng|ni|nl|no|np|nr|nu|nz|om|pa|pe|pf|pg|ph|pk|pl|pm|pn|pr|ps|pt|pw|py|qa|" + "re|ro|ru|rw|sa|sb|sc|sd|se|sg|sh|si|sk|sl|sm|sn|sr|st|su|sv|sy|sz|tc|td|tf|tg|th|tj|tk|tm|" + "tn|to|tr|tt|tv|tw|tz|ua|ug|uk|us|uy|uz|va|vc|ve|vg|vi|vn|vu|wf|ws|ye|yt|yu|za|zm|zw";
	var a = [];
	if (flags.allowInfra) {
		a.push(infraRE);
	}
	if (flags.allowGeneric) {
		a.push(genericRE);
	}
	if (flags.allowCC) {
		a.push(ccRE);
	}
	var tldRE = "";
	if (a.length > 0) {
		tldRE = "(" + a.join("|") + ")";
	}
	return tldRE;
};
dojo.regexp.ipAddress = function (flags) {
	flags = (typeof flags == "object") ? flags : {};
	if (typeof flags.allowDottedDecimal != "boolean") {
		flags.allowDottedDecimal = true;
	}
	if (typeof flags.allowDottedHex != "boolean") {
		flags.allowDottedHex = true;
	}
	if (typeof flags.allowDottedOctal != "boolean") {
		flags.allowDottedOctal = true;
	}
	if (typeof flags.allowDecimal != "boolean") {
		flags.allowDecimal = true;
	}
	if (typeof flags.allowHex != "boolean") {
		flags.allowHex = true;
	}
	if (typeof flags.allowIPv6 != "boolean") {
		flags.allowIPv6 = true;
	}
	if (typeof flags.allowHybrid != "boolean") {
		flags.allowHybrid = true;
	}
	var dottedDecimalRE = "((\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.){3}(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])";
	var dottedHexRE = "(0[xX]0*[\\da-fA-F]?[\\da-fA-F]\\.){3}0[xX]0*[\\da-fA-F]?[\\da-fA-F]";
	var dottedOctalRE = "(0+[0-3][0-7][0-7]\\.){3}0+[0-3][0-7][0-7]";
	var decimalRE = "(0|[1-9]\\d{0,8}|[1-3]\\d{9}|4[01]\\d{8}|42[0-8]\\d{7}|429[0-3]\\d{6}|" + "4294[0-8]\\d{5}|42949[0-5]\\d{4}|429496[0-6]\\d{3}|4294967[01]\\d{2}|42949672[0-8]\\d|429496729[0-5])";
	var hexRE = "0[xX]0*[\\da-fA-F]{1,8}";
	var ipv6RE = "([\\da-fA-F]{1,4}\\:){7}[\\da-fA-F]{1,4}";
	var hybridRE = "([\\da-fA-F]{1,4}\\:){6}" + "((\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.){3}(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])";
	var a = [];
	if (flags.allowDottedDecimal) {
		a.push(dottedDecimalRE);
	}
	if (flags.allowDottedHex) {
		a.push(dottedHexRE);
	}
	if (flags.allowDottedOctal) {
		a.push(dottedOctalRE);
	}
	if (flags.allowDecimal) {
		a.push(decimalRE);
	}
	if (flags.allowHex) {
		a.push(hexRE);
	}
	if (flags.allowIPv6) {
		a.push(ipv6RE);
	}
	if (flags.allowHybrid) {
		a.push(hybridRE);
	}
	var ipAddressRE = "";
	if (a.length > 0) {
		ipAddressRE = "(" + a.join("|") + ")";
	}
	return ipAddressRE;
};
dojo.regexp.host = function (flags) {
	flags = (typeof flags == "object") ? flags : {};
	if (typeof flags.allowIP != "boolean") {
		flags.allowIP = true;
	}
	if (typeof flags.allowLocal != "boolean") {
		flags.allowLocal = false;
	}
	if (typeof flags.allowPort != "boolean") {
		flags.allowPort = true;
	}
	var domainNameRE = "([0-9a-zA-Z]([-0-9a-zA-Z]{0,61}[0-9a-zA-Z])?\\.)+" + dojo.regexp.tld(flags);
	var portRE = (flags.allowPort) ? "(\\:" + dojo.regexp.integer({signed:false}) + ")?" : "";
	var hostNameRE = domainNameRE;
	if (flags.allowIP) {
		hostNameRE += "|" + dojo.regexp.ipAddress(flags);
	}
	if (flags.allowLocal) {
		hostNameRE += "|localhost";
	}
	return "(" + hostNameRE + ")" + portRE;
};
dojo.regexp.url = function (flags) {
	flags = (typeof flags == "object") ? flags : {};
	if (typeof flags.scheme == "undefined") {
		flags.scheme = [true, false];
	}
	var protocolRE = dojo.regexp.buildGroupRE(flags.scheme, function (q) {
		if (q) {
			return "(https?|ftps?)\\://";
		}
		return "";
	});
	var pathRE = "(/([^?#\\s/]+/)*)?([^?#\\s/]+(\\?[^?#\\s/]*)?(#[A-Za-z][\\w.:-]*)?)?";
	return protocolRE + dojo.regexp.host(flags) + pathRE;
};
dojo.regexp.emailAddress = function (flags) {
	flags = (typeof flags == "object") ? flags : {};
	if (typeof flags.allowCruft != "boolean") {
		flags.allowCruft = false;
	}
	flags.allowPort = false;
	var usernameRE = "([\\da-z]+[-._+&'])*[\\da-z]+";
	var emailAddressRE = usernameRE + "@" + dojo.regexp.host(flags);
	if (flags.allowCruft) {
		emailAddressRE = "<?(mailto\\:)?" + emailAddressRE + ">?";
	}
	return emailAddressRE;
};
dojo.regexp.emailAddressList = function (flags) {
	flags = (typeof flags == "object") ? flags : {};
	if (typeof flags.listSeparator != "string") {
		flags.listSeparator = "\\s;,";
	}
	var emailAddressRE = dojo.regexp.emailAddress(flags);
	var emailAddressListRE = "(" + emailAddressRE + "\\s*[" + flags.listSeparator + "]\\s*)*" + emailAddressRE + "\\s*[" + flags.listSeparator + "]?\\s*";
	return emailAddressListRE;
};
dojo.regexp.integer = function (flags) {
	flags = (typeof flags == "object") ? flags : {};
	if (typeof flags.signed == "undefined") {
		flags.signed = [true, false];
	}
	if (typeof flags.separator == "undefined") {
		flags.separator = "";
	} else {
		if (typeof flags.groupSize == "undefined") {
			flags.groupSize = 3;
		}
	}
	var signRE = dojo.regexp.buildGroupRE(flags.signed, function (q) {
		return q ? "[-+]" : "";
	});
	var numberRE = dojo.regexp.buildGroupRE(flags.separator, function (sep) {
		if (sep == "") {
			return "(0|[1-9]\\d*)";
		}
		var grp = flags.groupSize, grp2 = flags.groupSize2;
		if (typeof grp2 != "undefined") {
			var grp2RE = "(0|[1-9]\\d{0," + (grp2 - 1) + "}([" + sep + "]\\d{" + grp2 + "})*[" + sep + "]\\d{" + grp + "})";
			return ((grp - grp2) > 0) ? "(" + grp2RE + "|(0|[1-9]\\d{0," + (grp - 1) + "}))" : grp2RE;
		}
		return "(0|[1-9]\\d{0," + (grp - 1) + "}([" + sep + "]\\d{" + grp + "})*)";
	});
	return signRE + numberRE;
};
dojo.regexp.realNumber = function (flags) {
	flags = (typeof flags == "object") ? flags : {};
	if (typeof flags.places != "number") {
		flags.places = Infinity;
	}
	if (typeof flags.decimal != "string") {
		flags.decimal = ".";
	}
	if (typeof flags.fractional == "undefined") {
		flags.fractional = [true, false];
	}
	if (typeof flags.exponent == "undefined") {
		flags.exponent = [true, false];
	}
	if (typeof flags.eSigned == "undefined") {
		flags.eSigned = [true, false];
	}
	var integerRE = dojo.regexp.integer(flags);
	var decimalRE = dojo.regexp.buildGroupRE(flags.fractional, function (q) {
		var re = "";
		if (q && (flags.places > 0)) {
			re = "\\" + flags.decimal;
			if (flags.places == Infinity) {
				re = "(" + re + "\\d+)?";
			} else {
				re = re + "\\d{" + flags.places + "}";
			}
		}
		return re;
	});
	var exponentRE = dojo.regexp.buildGroupRE(flags.exponent, function (q) {
		if (q) {
			return "([eE]" + dojo.regexp.integer({signed:flags.eSigned}) + ")";
		}
		return "";
	});
	return integerRE + decimalRE + exponentRE;
};
dojo.regexp.currency = function (flags) {
	flags = (typeof flags == "object") ? flags : {};
	if (typeof flags.signed == "undefined") {
		flags.signed = [true, false];
	}
	if (typeof flags.symbol == "undefined") {
		flags.symbol = "$";
	}
	if (typeof flags.placement != "string") {
		flags.placement = "before";
	}
	if (typeof flags.signPlacement != "string") {
		flags.signPlacement = "before";
	}
	if (typeof flags.separator == "undefined") {
		flags.separator = ",";
	}
	if (typeof flags.fractional == "undefined" && typeof flags.cents != "undefined") {
		dojo.deprecated("dojo.regexp.currency: flags.cents", "use flags.fractional instead", "0.5");
		flags.fractional = flags.cents;
	}
	if (typeof flags.decimal != "string") {
		flags.decimal = ".";
	}
	var signRE = dojo.regexp.buildGroupRE(flags.signed, function (q) {
		if (q) {
			return "[-+]";
		}
		return "";
	});
	var symbolRE = dojo.regexp.buildGroupRE(flags.symbol, function (symbol) {
		return "\\s?" + symbol.replace(/([.$?*!=:|\\\/^])/g, "\\$1") + "\\s?";
	});
	switch (flags.signPlacement) {
	  case "before":
		symbolRE = signRE + symbolRE;
		break;
	  case "after":
		symbolRE = symbolRE + signRE;
		break;
	}
	var flagsCopy = flags;
	flagsCopy.signed = false;
	flagsCopy.exponent = false;
	var numberRE = dojo.regexp.realNumber(flagsCopy);
	var currencyRE;
	switch (flags.placement) {
	  case "before":
		currencyRE = symbolRE + numberRE;
		break;
	  case "after":
		currencyRE = numberRE + symbolRE;
		break;
	}
	switch (flags.signPlacement) {
	  case "around":
		currencyRE = "(" + currencyRE + "|" + "\\(" + currencyRE + "\\)" + ")";
		break;
	  case "begin":
		currencyRE = signRE + currencyRE;
		break;
	  case "end":
		currencyRE = currencyRE + signRE;
		break;
	}
	return currencyRE;
};
dojo.regexp.us.state = function (flags) {
	flags = (typeof flags == "object") ? flags : {};
	if (typeof flags.allowTerritories != "boolean") {
		flags.allowTerritories = true;
	}
	if (typeof flags.allowMilitary != "boolean") {
		flags.allowMilitary = true;
	}
	var statesRE = "AL|AK|AZ|AR|CA|CO|CT|DE|DC|FL|GA|HI|ID|IL|IN|IA|KS|KY|LA|ME|MD|MA|MI|MN|MS|MO|MT|" + "NE|NV|NH|NJ|NM|NY|NC|ND|OH|OK|OR|PA|RI|SC|SD|TN|TX|UT|VT|VA|WA|WV|WI|WY";
	var territoriesRE = "AS|FM|GU|MH|MP|PW|PR|VI";
	var militaryRE = "AA|AE|AP";
	if (flags.allowTerritories) {
		statesRE += "|" + territoriesRE;
	}
	if (flags.allowMilitary) {
		statesRE += "|" + militaryRE;
	}
	return "(" + statesRE + ")";
};
dojo.regexp.time = function (flags) {
	dojo.deprecated("dojo.regexp.time", "Use dojo.date.parse instead", "0.5");
	flags = (typeof flags == "object") ? flags : {};
	if (typeof flags.format == "undefined") {
		flags.format = "h:mm:ss t";
	}
	if (typeof flags.amSymbol != "string") {
		flags.amSymbol = "AM";
	}
	if (typeof flags.pmSymbol != "string") {
		flags.pmSymbol = "PM";
	}
	var timeRE = function (format) {
		format = format.replace(/([.$?*!=:|{}\(\)\[\]\\\/^])/g, "\\$1");
		var amRE = flags.amSymbol.replace(/([.$?*!=:|{}\(\)\[\]\\\/^])/g, "\\$1");
		var pmRE = flags.pmSymbol.replace(/([.$?*!=:|{}\(\)\[\]\\\/^])/g, "\\$1");
		format = format.replace("hh", "(0[1-9]|1[0-2])");
		format = format.replace("h", "([1-9]|1[0-2])");
		format = format.replace("HH", "([01][0-9]|2[0-3])");
		format = format.replace("H", "([0-9]|1[0-9]|2[0-3])");
		format = format.replace("mm", "([0-5][0-9])");
		format = format.replace("m", "([1-5][0-9]|[0-9])");
		format = format.replace("ss", "([0-5][0-9])");
		format = format.replace("s", "([1-5][0-9]|[0-9])");
		format = format.replace("t", "\\s?(" + amRE + "|" + pmRE + ")\\s?");
		return format;
	};
	return dojo.regexp.buildGroupRE(flags.format, timeRE);
};
dojo.regexp.numberFormat = function (flags) {
	flags = (typeof flags == "object") ? flags : {};
	if (typeof flags.format == "undefined") {
		flags.format = "###-###-####";
	}
	var digitRE = function (format) {
		format = format.replace(/([.$*!=:|{}\(\)\[\]\\\/^])/g, "\\$1");
		format = format.replace(/\?/g, "\\d?");
		format = format.replace(/#/g, "\\d");
		return format;
	};
	return dojo.regexp.buildGroupRE(flags.format, digitRE);
};
dojo.regexp.buildGroupRE = function (a, re) {
	if (!(a instanceof Array)) {
		return re(a);
	}
	var b = [];
	for (var i = 0; i < a.length; i++) {
		b.push(re(a[i]));
	}
	return "(" + b.join("|") + ")";
};


__CPAN_FILE__ src/hostenv_rhino.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.hostenv.println = function (line) {
	if (arguments.length > 0) {
		print(arguments[0]);
		for (var i = 1; i < arguments.length; i++) {
			var valid = false;
			for (var p in arguments[i]) {
				valid = true;
				break;
			}
			if (valid) {
				dojo.debugShallow(arguments[i]);
			}
		}
	} else {
		print(line);
	}
};
dojo.locale = dojo.locale || java.util.Locale.getDefault().toString().replace("_", "-").toLowerCase();
dojo.render.name = dojo.hostenv.name_ = "rhino";
dojo.hostenv.getVersion = function () {
	return version();
};
if (dj_undef("byId")) {
	dojo.byId = function (id, doc) {
		if (id && (typeof id == "string" || id instanceof String)) {
			if (!doc) {
				doc = document;
			}
			return doc.getElementById(id);
		}
		return id;
	};
}
dojo.hostenv.loadUri = function (uri, cb) {
	try {
		var local = (new java.io.File(uri)).exists();
		if (!local) {
			try {
				var stream = (new java.net.URL(uri)).openStream();
				stream.close();
			}
			catch (e) {
				return false;
			}
		}
		if (cb) {
			var contents = (local ? readText : readUri)(uri, "UTF-8");
			cb(eval("(" + contents + ")"));
		} else {
			load(uri);
		}
		return true;
	}
	catch (e) {
		dojo.debug("rhino load('" + uri + "') failed. Exception: " + e);
		return false;
	}
};
dojo.hostenv.exit = function (exitcode) {
	quit(exitcode);
};
function dj_rhino_current_script_via_java(depth) {
	var optLevel = Packages.org.mozilla.javascript.Context.getCurrentContext().getOptimizationLevel();
	var caw = new java.io.CharArrayWriter();
	var pw = new java.io.PrintWriter(caw);
	var exc = new java.lang.Exception();
	var s = caw.toString();
	var matches = s.match(/[^\(]*\.js\)/gi);
	if (!matches) {
		throw Error("cannot parse printStackTrace output: " + s);
	}
	var fname = ((typeof depth != "undefined") && (depth)) ? matches[depth + 1] : matches[matches.length - 1];
	var fname = matches[3];
	if (!fname) {
		fname = matches[1];
	}
	if (!fname) {
		throw Error("could not find js file in printStackTrace output: " + s);
	}
	return fname;
}
function readText(path, encoding) {
	encoding = encoding || "utf-8";
	var jf = new java.io.File(path);
	var is = new java.io.FileInputStream(jf);
	return dj_readInputStream(is, encoding);
}
function readUri(uri, encoding) {
	var conn = (new java.net.URL(uri)).openConnection();
	encoding = encoding || conn.getContentEncoding() || "utf-8";
	var is = conn.getInputStream();
	return dj_readInputStream(is, encoding);
}
function dj_readInputStream(is, encoding) {
	var input = new java.io.BufferedReader(new java.io.InputStreamReader(is, encoding));
	try {
		var sb = new java.lang.StringBuffer();
		var line = "";
		while ((line = input.readLine()) !== null) {
			sb.append(line);
			sb.append(java.lang.System.getProperty("line.separator"));
		}
		return sb.toString();
	}
	finally {
		input.close();
	}
}
if (!djConfig.libraryScriptUri.length) {
	try {
		djConfig.libraryScriptUri = dj_rhino_current_script_via_java(1);
	}
	catch (e) {
		if (djConfig["isDebug"]) {
			print("\n");
			print("we have no idea where Dojo is located.");
			print("Please try loading rhino in a non-interpreted mode or set a");
			print("\n\tdjConfig.libraryScriptUri\n");
			print("Setting the dojo path to './'");
			print("This is probably wrong!");
			print("\n");
			print("Dojo will try to load anyway");
		}
		djConfig.libraryScriptUri = "./";
	}
}
dojo.doc = function () {
	return document;
};
dojo.body = function () {
	return document.body;
};
function setTimeout(func, delay) {
	var def = {sleepTime:delay, hasSlept:false, run:function () {
		if (!this.hasSlept) {
			this.hasSlept = true;
			java.lang.Thread.currentThread().sleep(this.sleepTime);
		}
		try {
			func();
		}
		catch (e) {
			dojo.debug("Error running setTimeout thread:" + e);
		}
	}};
	var runnable = new java.lang.Runnable(def);
	var thread = new java.lang.Thread(runnable);
	thread.start();
}
dojo.requireIf((djConfig["isDebug"] || djConfig["debugAtAllCosts"]), "dojo.debug");


__CPAN_FILE__ src/lang.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.lang");
dojo.require("dojo.lang.common");
dojo.deprecated("dojo.lang", "replaced by dojo.lang.common", "0.5");


__CPAN_FILE__ src/bootstrap1.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

var dj_global = this;
var dj_currentContext = this;
function dj_undef(name, object) {
	return (typeof (object || dj_currentContext)[name] == "undefined");
}
if (dj_undef("djConfig", this)) {
	var djConfig = {};
}
if (dj_undef("dojo", this)) {
	var dojo = {};
}
dojo.global = function () {
	return dj_currentContext;
};
dojo.locale = djConfig.locale;
dojo.version = {major:0, minor:4, patch:2, flag:"", revision:Number("$Rev: 7616 $".match(/[0-9]+/)[0]), toString:function () {
	with (dojo.version) {
		return major + "." + minor + "." + patch + flag + " (" + revision + ")";
	}
}};
dojo.evalProp = function (name, object, create) {
	if ((!object) || (!name)) {
		return undefined;
	}
	if (!dj_undef(name, object)) {
		return object[name];
	}
	return (create ? (object[name] = {}) : undefined);
};
dojo.parseObjPath = function (path, context, create) {
	var object = (context || dojo.global());
	var names = path.split(".");
	var prop = names.pop();
	for (var i = 0, l = names.length; i < l && object; i++) {
		object = dojo.evalProp(names[i], object, create);
	}
	return {obj:object, prop:prop};
};
dojo.evalObjPath = function (path, create) {
	if (typeof path != "string") {
		return dojo.global();
	}
	if (path.indexOf(".") == -1) {
		return dojo.evalProp(path, dojo.global(), create);
	}
	var ref = dojo.parseObjPath(path, dojo.global(), create);
	if (ref) {
		return dojo.evalProp(ref.prop, ref.obj, create);
	}
	return null;
};
dojo.errorToString = function (exception) {
	if (!dj_undef("message", exception)) {
		return exception.message;
	} else {
		if (!dj_undef("description", exception)) {
			return exception.description;
		} else {
			return exception;
		}
	}
};
dojo.raise = function (message, exception) {
	if (exception) {
		message = message + ": " + dojo.errorToString(exception);
	} else {
		message = dojo.errorToString(message);
	}
	try {
		if (djConfig.isDebug) {
			dojo.hostenv.println("FATAL exception raised: " + message);
		}
	}
	catch (e) {
	}
	throw exception || Error(message);
};
dojo.debug = function () {
};
dojo.debugShallow = function (obj) {
};
dojo.profile = {start:function () {
}, end:function () {
}, stop:function () {
}, dump:function () {
}};
function dj_eval(scriptFragment) {
	return dj_global.eval ? dj_global.eval(scriptFragment) : eval(scriptFragment);
}
dojo.unimplemented = function (funcname, extra) {
	var message = "'" + funcname + "' not implemented";
	if (extra != null) {
		message += " " + extra;
	}
	dojo.raise(message);
};
dojo.deprecated = function (behaviour, extra, removal) {
	var message = "DEPRECATED: " + behaviour;
	if (extra) {
		message += " " + extra;
	}
	if (removal) {
		message += " -- will be removed in version: " + removal;
	}
	dojo.debug(message);
};
dojo.render = (function () {
	function vscaffold(prefs, names) {
		var tmp = {capable:false, support:{builtin:false, plugin:false}, prefixes:prefs};
		for (var i = 0; i < names.length; i++) {
			tmp[names[i]] = false;
		}
		return tmp;
	}
	return {name:"", ver:dojo.version, os:{win:false, linux:false, osx:false}, html:vscaffold(["html"], ["ie", "opera", "khtml", "safari", "moz"]), svg:vscaffold(["svg"], ["corel", "adobe", "batik"]), vml:vscaffold(["vml"], ["ie"]), swf:vscaffold(["Swf", "Flash", "Mm"], ["mm"]), swt:vscaffold(["Swt"], ["ibm"])};
})();
dojo.hostenv = (function () {
	var config = {isDebug:false, allowQueryConfig:false, baseScriptUri:"", baseRelativePath:"", libraryScriptUri:"", iePreventClobber:false, ieClobberMinimal:true, preventBackButtonFix:true, delayMozLoadingFix:false, searchIds:[], parseWidgets:true};
	if (typeof djConfig == "undefined") {
		djConfig = config;
	} else {
		for (var option in config) {
			if (typeof djConfig[option] == "undefined") {
				djConfig[option] = config[option];
			}
		}
	}
	return {name_:"(unset)", version_:"(unset)", getName:function () {
		return this.name_;
	}, getVersion:function () {
		return this.version_;
	}, getText:function (uri) {
		dojo.unimplemented("getText", "uri=" + uri);
	}};
})();
dojo.hostenv.getBaseScriptUri = function () {
	if (djConfig.baseScriptUri.length) {
		return djConfig.baseScriptUri;
	}
	var uri = new String(djConfig.libraryScriptUri || djConfig.baseRelativePath);
	if (!uri) {
		dojo.raise("Nothing returned by getLibraryScriptUri(): " + uri);
	}
	var lastslash = uri.lastIndexOf("/");
	djConfig.baseScriptUri = djConfig.baseRelativePath;
	return djConfig.baseScriptUri;
};


__CPAN_FILE__ src/html.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.html");
dojo.require("dojo.html.*");
dojo.deprecated("dojo.html", "replaced by dojo.html.*", "0.5");


__CPAN_FILE__ src/hostenv_jsc.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

/*
 * JScript .NET jsc
 *
 */

dojo.hostenv.name_ = 'jsc';

// Sanity check this is the right hostenv.
// See the Rotor source code jscript/engine/globalobject.cs for what globals
// are available.
if((typeof ScriptEngineMajorVersion != 'function')||(ScriptEngineMajorVersion() < 7)){
	dojo.raise("attempt to use JScript .NET host environment with inappropriate ScriptEngine"); 
}

// for more than you wanted to know about why this import is required even if
// we fully qualify all symbols, see
// http://groups.google.com/groups?th=f050c7aeefdcbde2&rnum=12
import System;

dojo.hostenv.getText = function(uri){
	if(!System.IO.File.Exists(uri)){
		// dojo.raise("No such file '" + uri + "'");
		return 0;
	}
	var reader = new System.IO.StreamReader(uri);
	var contents : String = reader.ReadToEnd();
	return contents;
}

dojo.hostenv.loadUri = function(uri){
	var contents = this.getText(uri);
	if(!contents){
		dojo.raise("got no back contents from uri '" + uri + "': " + contents);
	}
	// TODO: in JScript .NET, eval will not affect the symbol table of the current code?
	var value = dj_eval(contents);
	dojo.debug("jsc eval of contents returned: ", value);
	return 1;

	// for an example doing runtime code compilation, see:
	// http://groups.google.com/groups?selm=eQ1aeciCBHA.1644%40tkmsftngp05&rnum=6
	// Microsoft.JScript or System.CodeDom.Compiler ?
	// var engine = new Microsoft.JScript.Vsa.VsaEngine()
	// what about loading a js file vs. a dll?
	// GetObject("script:" . uri);
}

/* The System.Environment object is useful:
    print ("CommandLine='" + System.Environment.CommandLine + "' " +
	   "program name='" + System.Environment.GetCommandLineArgs()[0] + "' " +
	   "CurrentDirectory='" + System.Environment.CurrentDirectory + "' " +
	   "StackTrace='" + System.Environment.StackTrace + "'");
*/

// same as System.Console.WriteLine
// sigh; Rotor treats symbol "print" at parse time without actually putting it
// in the builtin symbol table.
// Note that the print symbol is not available if jsc is run with the "/print-"
// option.
dojo.hostenv.println = function(s){
	print(s); // = print
}

dojo.hostenv.getLibraryScriptUri = function(){
	return System.Environment.GetCommandLineArgs()[0];
}

dojo.requireIf((djConfig["isDebug"] || djConfig["debugAtAllCosts"]), "dojo.debug");

__CPAN_FILE__ src/browser_debug.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.browser_debug");
dojo.hostenv.loadedUris.push("../src/bootstrap1.js");
dojo.hostenv.loadedUris.push("../src/loader.js");
dojo.hostenv.loadedUris.push("../src/hostenv_browser.js");
dojo.hostenv._loadedUrisListStart = dojo.hostenv.loadedUris.length;
function removeComments(contents) {
	contents = new String((!contents) ? "" : contents);
	contents = contents.replace(/^(.*?)\/\/(.*)$/mg, "$1");
	contents = contents.replace(/(\n)/mg, "__DOJONEWLINE");
	contents = contents.replace(/\/\*(.*?)\*\//g, "");
	return contents.replace(/__DOJONEWLINE/mg, "\n");
}
dojo.hostenv.getRequiresAndProvides = function (contents) {
	if (!contents) {
		return [];
	}
	var deps = [];
	var tmp;
	RegExp.lastIndex = 0;
	var testExp = /dojo.(hostenv.loadModule|hostenv.require|require|requireIf|kwCompoundRequire|hostenv.conditionalLoadModule|hostenv.startPackage|provide)\([\w\W]*?\)/mg;
	while ((tmp = testExp.exec(contents)) != null) {
		deps.push(tmp[0]);
	}
	return deps;
};
dojo.hostenv.getDelayRequiresAndProvides = function (contents) {
	if (!contents) {
		return [];
	}
	var deps = [];
	var tmp;
	RegExp.lastIndex = 0;
	var testExp = /dojo.(requireAfterIf)\([\w\W]*?\)/mg;
	while ((tmp = testExp.exec(contents)) != null) {
		deps.push(tmp[0]);
	}
	return deps;
};
dojo.clobberLastObject = function (objpath) {
	if (objpath.indexOf(".") == -1) {
		if (!dj_undef(objpath, dj_global)) {
			delete dj_global[objpath];
		}
		return true;
	}
	var syms = objpath.split(/\./);
	var base = dojo.evalObjPath(syms.slice(0, -1).join("."), false);
	var child = syms[syms.length - 1];
	if (!dj_undef(child, base)) {
		delete base[child];
		return true;
	}
	return false;
};
var removals = [];
function zip(arr) {
	var ret = [];
	var seen = {};
	for (var x = 0; x < arr.length; x++) {
		if (!seen[arr[x]]) {
			ret.push(arr[x]);
			seen[arr[x]] = true;
		}
	}
	return ret;
}
var old_dj_eval = dj_eval;
dj_eval = function () {
	return true;
};
dojo.hostenv.oldLoadUri = dojo.hostenv.loadUri;
dojo.hostenv.loadUri = function (uri, cb) {
	if (dojo.hostenv.loadedUris[uri]) {
		return true;
	}
	try {
		var text = this.getText(uri, null, true);
		if (!text) {
			return false;
		}
		if (cb) {
			var expr = old_dj_eval("(" + text + ")");
			cb(expr);
		} else {
			var requires = dojo.hostenv.getRequiresAndProvides(text);
			eval(requires.join(";"));
			dojo.hostenv.loadedUris.push(uri);
			dojo.hostenv.loadedUris[uri] = true;
			var delayRequires = dojo.hostenv.getDelayRequiresAndProvides(text);
			eval(delayRequires.join(";"));
		}
	}
	catch (e) {
		alert(e);
	}
	return true;
};
dojo.hostenv._writtenIncludes = {};
dojo.hostenv.writeIncludes = function (willCallAgain) {
	for (var x = removals.length - 1; x >= 0; x--) {
		dojo.clobberLastObject(removals[x]);
	}
	var depList = [];
	var seen = dojo.hostenv._writtenIncludes;
	for (var x = 0; x < dojo.hostenv.loadedUris.length; x++) {
		var curi = dojo.hostenv.loadedUris[x];
		if (!seen[curi]) {
			seen[curi] = true;
			depList.push(curi);
		}
	}
	dojo.hostenv._global_omit_module_check = true;
	for (var x = dojo.hostenv._loadedUrisListStart; x < depList.length; x++) {
		document.write("<script type='text/javascript' src='" + depList[x] + "'></script>");
	}
	document.write("<script type='text/javascript'>dojo.hostenv._global_omit_module_check = false;</script>");
	dojo.hostenv._loadedUrisListStart = 0;
	if (!willCallAgain) {
		dj_eval = old_dj_eval;
		dojo.hostenv.loadUri = dojo.hostenv.oldLoadUri;
	}
};


__CPAN_FILE__ src/json.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.json");
dojo.require("dojo.lang.func");
dojo.require("dojo.string.extras");
dojo.require("dojo.AdapterRegistry");
dojo.json = {jsonRegistry:new dojo.AdapterRegistry(), register:function (name, check, wrap, override) {
	dojo.json.jsonRegistry.register(name, check, wrap, override);
}, evalJson:function (json) {
	try {
		return eval("(" + json + ")");
	}
	catch (e) {
		dojo.debug(e);
		return json;
	}
}, serialize:function (o) {
	var objtype = typeof (o);
	if (objtype == "undefined") {
		return "undefined";
	} else {
		if ((objtype == "number") || (objtype == "boolean")) {
			return o + "";
		} else {
			if (o === null) {
				return "null";
			}
		}
	}
	if (objtype == "string") {
		return dojo.string.escapeString(o);
	}
	var me = arguments.callee;
	var newObj;
	if (typeof (o.__json__) == "function") {
		newObj = o.__json__();
		if (o !== newObj) {
			return me(newObj);
		}
	}
	if (typeof (o.json) == "function") {
		newObj = o.json();
		if (o !== newObj) {
			return me(newObj);
		}
	}
	if (objtype != "function" && typeof (o.length) == "number") {
		var res = [];
		for (var i = 0; i < o.length; i++) {
			var val = me(o[i]);
			if (typeof (val) != "string") {
				val = "undefined";
			}
			res.push(val);
		}
		return "[" + res.join(",") + "]";
	}
	try {
		window.o = o;
		newObj = dojo.json.jsonRegistry.match(o);
		return me(newObj);
	}
	catch (e) {
	}
	if (objtype == "function") {
		return null;
	}
	res = [];
	for (var k in o) {
		var useKey;
		if (typeof (k) == "number") {
			useKey = "\"" + k + "\"";
		} else {
			if (typeof (k) == "string") {
				useKey = dojo.string.escapeString(k);
			} else {
				continue;
			}
		}
		val = me(o[k]);
		if (typeof (val) != "string") {
			continue;
		}
		res.push(useKey + ":" + val);
	}
	return "{" + res.join(",") + "}";
}};


__CPAN_FILE__ src/string.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.string");
dojo.require("dojo.string.common");


__CPAN_FILE__ src/io.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.io");
dojo.require("dojo.io.*");
dojo.deprecated("dojo.io", "replaced by dojo.io.*", "0.5");


__CPAN_FILE__ src/experimental.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.experimental");
dojo.experimental = function (moduleName, extra) {
	var message = "EXPERIMENTAL: " + moduleName;
	message += " -- Not yet ready for use.  APIs subject to change without notice.";
	if (extra) {
		message += " " + extra;
	}
	dojo.debug(message);
};


__CPAN_FILE__ src/hostenv_dashboard.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.render.name = dojo.hostenv.name_ = "dashboard";
dojo.hostenv.println = function (message) {
	return alert(message);
};
dojo.hostenv.getXmlhttpObject = function (kwArgs) {
	if (widget.system && kwArgs) {
		if ((kwArgs.contentType && kwArgs.contentType.indexOf("text/") != 0) || (kwArgs.headers && kwArgs.headers["content-type"] && kwArgs.headers["content-type"].indexOf("text/") != 0)) {
			var curl = new dojo.hostenv.CurlRequest;
			curl._save = true;
			return curl;
		} else {
			if (kwArgs.method && kwArgs.method.toUpperCase() == "HEAD") {
				return new dojo.hostenv.CurlRequest;
			} else {
				if (kwArgs.headers && kwArgs.header.referer) {
					return new dojo.hostenv.CurlRequest;
				}
			}
		}
	}
	return new XMLHttpRequest;
};
dojo.hostenv.CurlRequest = function () {
	this.onreadystatechange = null;
	this.readyState = 0;
	this.responseText = "";
	this.responseXML = null;
	this.status = 0;
	this.statusText = "";
	this._method = "";
	this._url = "";
	this._async = true;
	this._referrer = "";
	this._headers = [];
	this._save = false;
	this._responseHeader = "";
	this._responseHeaders = {};
	this._fileName = "";
	this._username = "";
	this._password = "";
};
dojo.hostenv.CurlRequest.prototype.open = function (method, url, async, username, password) {
	this._method = method;
	this._url = url;
	if (async) {
		this._async = async;
	}
	if (username) {
		this._username = username;
	}
	if (password) {
		this._password = password;
	}
};
dojo.hostenv.CurlRequest.prototype.setRequestHeader = function (label, value) {
	switch (label) {
	  case "Referer":
		this._referrer = value;
		break;
	  case "content-type":
		break;
	  default:
		this._headers.push(label + "=" + value);
		break;
	}
};
dojo.hostenv.CurlRequest.prototype.getAllResponseHeaders = function () {
	return this._responseHeader;
};
dojo.hostenv.CurlRequest.prototype.getResponseHeader = function (headerLabel) {
	return this._responseHeaders[headerLabel];
};
dojo.hostenv.CurlRequest.prototype.send = function (content) {
	this.readyState = 1;
	if (this.onreadystatechange) {
		this.onreadystatechange.call(this);
	}
	var query = {sS:""};
	if (this._referrer) {
		query.e = this._referrer;
	}
	if (this._headers.length) {
		query.H = this._headers.join("&");
	}
	if (this._username) {
		if (this._password) {
			query.u = this._username + ":" + this._password;
		} else {
			query.u = this._username;
		}
	}
	if (content) {
		query.d = this.content;
		if (this._method != "POST") {
			query.G = "";
		}
	}
	if (this._method == "HEAD") {
		query.I = "";
	} else {
		if (this._save) {
			query.I = "";
		} else {
			query.i = "";
		}
	}
	var system = widget.system(dojo.hostenv.CurlRequest._formatCall(query, this._url), null);
	this.readyState = 2;
	if (this.onreadystatechange) {
		this.onreadystatechange.call(this);
	}
	if (system.errorString) {
		this.responseText = system.errorString;
		this.status = 0;
	} else {
		if (this._save) {
			this._responseHeader = system.outputString;
		} else {
			var split = system.outputString.replace(/\r/g, "").split("\n\n", 2);
			this._responseHeader = split[0];
			this.responseText = split[1];
		}
		split = this._responseHeader.split("\n");
		this.statusText = split.shift();
		this.status = this.statusText.split(" ")[1];
		for (var i = 0, header; header = split[i]; i++) {
			var header_split = header.split(": ", 2);
			this._responseHeaders[header_split[0]] = header_split[1];
		}
		if (this._save) {
			widget.system("/bin/mkdir cache", null);
			this._fileName = this._url.split("/").pop().replace(/\W/g, "");
			this._fileName += "." + this._responseHeaders["Content-Type"].replace(/[\r\n]/g, "").split("/").pop();
			delete query.I;
			query.o = "cache/" + this._fileName;
			system = widget.system(dojo.hostenv.CurlRequest._formatCall(query, this._url), null);
			if (!system.errorString) {
				this.responseText = "cache/" + this._fileName;
			}
		} else {
			if (this._method == "HEAD") {
				this.responseText = this._responseHeader;
			}
		}
	}
	this.readyState = 4;
	if (this.onreadystatechange) {
		this.onreadystatechange.call(this);
	}
};
dojo.hostenv.CurlRequest._formatCall = function (query, url) {
	var call = ["/usr/bin/curl"];
	for (var key in query) {
		if (query[key] != "") {
			call.push("-" + key + " '" + query[key].replace(/'/g, "'") + "'");
		} else {
			call.push("-" + key);
		}
	}
	call.push("'" + url.replace(/'/g, "'") + "'");
	return call.join(" ");
};
dojo.hostenv.exit = function () {
	if (widget.system) {
		widget.system("/bin/rm -rf cache/*", null);
	}
};


__CPAN_FILE__ src/loader_xd.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.hostenv.resetXd = function () {
	this.isXDomain = djConfig.useXDomain || false;
	this.xdTimer = 0;
	this.xdInFlight = {};
	this.xdOrderedReqs = [];
	this.xdDepMap = {};
	this.xdContents = [];
	this.xdDefList = [];
};
dojo.hostenv.resetXd();
dojo.hostenv.createXdPackage = function (contents, resourceName, resourcePath) {
	var deps = [];
	var depRegExp = /dojo.(require|requireIf|requireAll|provide|requireAfterIf|requireAfter|kwCompoundRequire|conditionalRequire|hostenv\.conditionalLoadModule|.hostenv\.loadModule|hostenv\.moduleLoaded)\(([\w\W]*?)\)/mg;
	var match;
	while ((match = depRegExp.exec(contents)) != null) {
		deps.push("\"" + match[1] + "\", " + match[2]);
	}
	var output = [];
	output.push("dojo.hostenv.packageLoaded({\n");
	if (deps.length > 0) {
		output.push("depends: [");
		for (var i = 0; i < deps.length; i++) {
			if (i > 0) {
				output.push(",\n");
			}
			output.push("[" + deps[i] + "]");
		}
		output.push("],");
	}
	output.push("\ndefinePackage: function(dojo){");
	output.push(contents);
	output.push("\n}, resourceName: '" + resourceName + "', resourcePath: '" + resourcePath + "'});");
	return output.join("");
};
dojo.hostenv.loadPath = function (relpath, module, cb) {
	var colonIndex = relpath.indexOf(":");
	var slashIndex = relpath.indexOf("/");
	var uri;
	var currentIsXDomain = false;
	if (colonIndex > 0 && colonIndex < slashIndex) {
		uri = relpath;
		this.isXDomain = currentIsXDomain = true;
	} else {
		uri = this.getBaseScriptUri() + relpath;
		colonIndex = uri.indexOf(":");
		slashIndex = uri.indexOf("/");
		if (colonIndex > 0 && colonIndex < slashIndex && (!location.host || uri.indexOf("http://" + location.host) != 0)) {
			this.isXDomain = currentIsXDomain = true;
		}
	}
	if (djConfig.cacheBust && dojo.render.html.capable) {
		uri += "?" + String(djConfig.cacheBust).replace(/\W+/g, "");
	}
	try {
		return ((!module || this.isXDomain) ? this.loadUri(uri, cb, currentIsXDomain, module) : this.loadUriAndCheck(uri, module, cb));
	}
	catch (e) {
		dojo.debug(e);
		return false;
	}
};
dojo.hostenv.loadUri = function (uri, cb, currentIsXDomain, module) {
	if (this.loadedUris[uri]) {
		return 1;
	}
	if (this.isXDomain) {
		if (uri.indexOf("__package__") != -1) {
			module += ".*";
		}
		this.xdOrderedReqs.push(module);
		if (currentIsXDomain) {
			this.xdInFlight[module] = true;
			this.inFlightCount++;
		}
		if (!this.xdTimer) {
			this.xdTimer = setInterval("dojo.hostenv.watchInFlightXDomain();", 100);
		}
		this.xdStartTime = (new Date()).getTime();
	}
	if (currentIsXDomain) {
		var lastIndex = uri.lastIndexOf(".");
		if (lastIndex <= 0) {
			lastIndex = uri.length - 1;
		}
		var xdUri = uri.substring(0, lastIndex) + ".xd";
		if (lastIndex != uri.length - 1) {
			xdUri += uri.substring(lastIndex, uri.length);
		}
		var element = document.createElement("script");
		element.type = "text/javascript";
		element.src = xdUri;
		if (!this.headElement) {
			this.headElement = document.getElementsByTagName("head")[0];
			if (!this.headElement) {
				this.headElement = document.getElementsByTagName("html")[0];
			}
		}
		this.headElement.appendChild(element);
	} else {
		var contents = this.getText(uri, null, true);
		if (contents == null) {
			return 0;
		}
		if (this.isXDomain && uri.indexOf("/nls/") == -1) {
			var pkg = this.createXdPackage(contents, module, uri);
			dj_eval(pkg);
		} else {
			if (cb) {
				contents = "(" + contents + ")";
			}
			var value = dj_eval(contents);
			if (cb) {
				cb(value);
			}
		}
	}
	this.loadedUris[uri] = true;
	return 1;
};
dojo.hostenv.packageLoaded = function (pkg) {
	var deps = pkg.depends;
	var requireList = null;
	var requireAfterList = null;
	var provideList = [];
	if (deps && deps.length > 0) {
		var dep = null;
		var insertHint = 0;
		var attachedPackage = false;
		for (var i = 0; i < deps.length; i++) {
			dep = deps[i];
			if (dep[0] == "provide" || dep[0] == "hostenv.moduleLoaded") {
				provideList.push(dep[1]);
			} else {
				if (!requireList) {
					requireList = [];
				}
				if (!requireAfterList) {
					requireAfterList = [];
				}
				var unpackedDeps = this.unpackXdDependency(dep);
				if (unpackedDeps.requires) {
					requireList = requireList.concat(unpackedDeps.requires);
				}
				if (unpackedDeps.requiresAfter) {
					requireAfterList = requireAfterList.concat(unpackedDeps.requiresAfter);
				}
			}
			var depType = dep[0];
			var objPath = depType.split(".");
			if (objPath.length == 2) {
				dojo[objPath[0]][objPath[1]].apply(dojo[objPath[0]], dep.slice(1));
			} else {
				dojo[depType].apply(dojo, dep.slice(1));
			}
		}
		var contentIndex = this.xdContents.push({content:pkg.definePackage, resourceName:pkg["resourceName"], resourcePath:pkg["resourcePath"], isDefined:false}) - 1;
		for (var i = 0; i < provideList.length; i++) {
			this.xdDepMap[provideList[i]] = {requires:requireList, requiresAfter:requireAfterList, contentIndex:contentIndex};
		}
		for (var i = 0; i < provideList.length; i++) {
			this.xdInFlight[provideList[i]] = false;
		}
	}
};
dojo.hostenv.xdLoadFlattenedBundle = function (moduleName, bundleName, locale, bundleData) {
	locale = locale || "root";
	var jsLoc = dojo.hostenv.normalizeLocale(locale).replace("-", "_");
	var bundlePackage = [moduleName, "nls", bundleName].join(".");
	var bundle = dojo.hostenv.startPackage(bundlePackage);
	bundle[jsLoc] = bundleData;
	var mapName = [moduleName, jsLoc, bundleName].join(".");
	var bundleMap = dojo.hostenv.xdBundleMap[mapName];
	if (bundleMap) {
		for (var param in bundleMap) {
			bundle[param] = bundleData;
		}
	}
};
dojo.hostenv.xdBundleMap = {};
dojo.xdRequireLocalization = function (moduleName, bundleName, locale, availableFlatLocales) {
	var locales = availableFlatLocales.split(",");
	var jsLoc = dojo.hostenv.normalizeLocale(locale);
	var bestLocale = "";
	for (var i = 0; i < locales.length; i++) {
		if (jsLoc.indexOf(locales[i]) == 0) {
			if (locales[i].length > bestLocale.length) {
				bestLocale = locales[i];
			}
		}
	}
	var fixedBestLocale = bestLocale.replace("-", "_");
	var bundlePackage = dojo.evalObjPath([moduleName, "nls", bundleName].join("."));
	if (bundlePackage && bundlePackage[fixedBestLocale]) {
		bundle[jsLoc.replace("-", "_")] = bundlePackage[fixedBestLocale];
	} else {
		var mapName = [moduleName, (fixedBestLocale || "root"), bundleName].join(".");
		var bundleMap = dojo.hostenv.xdBundleMap[mapName];
		if (!bundleMap) {
			bundleMap = dojo.hostenv.xdBundleMap[mapName] = {};
		}
		bundleMap[jsLoc.replace("-", "_")] = true;
		dojo.require(moduleName + ".nls" + (bestLocale ? "." + bestLocale : "") + "." + bundleName);
	}
};
(function () {
	var extra = djConfig.extraLocale;
	if (extra) {
		if (!extra instanceof Array) {
			extra = [extra];
		}
		dojo._xdReqLoc = dojo.xdRequireLocalization;
		dojo.xdRequireLocalization = function (m, b, locale, fLocales) {
			dojo._xdReqLoc(m, b, locale, fLocales);
			if (locale) {
				return;
			}
			for (var i = 0; i < extra.length; i++) {
				dojo._xdReqLoc(m, b, extra[i], fLocales);
			}
		};
	}
})();
dojo.hostenv.unpackXdDependency = function (dep) {
	var newDeps = null;
	var newAfterDeps = null;
	switch (dep[0]) {
	  case "requireIf":
	  case "requireAfterIf":
	  case "conditionalRequire":
		if ((dep[1] === true) || (dep[1] == "common") || (dep[1] && dojo.render[dep[1]].capable)) {
			newDeps = [{name:dep[2], content:null}];
		}
		break;
	  case "requireAll":
		dep.shift();
		newDeps = dep;
		dojo.hostenv.flattenRequireArray(newDeps);
		break;
	  case "kwCompoundRequire":
	  case "hostenv.conditionalLoadModule":
		var modMap = dep[1];
		var common = modMap["common"] || [];
		var newDeps = (modMap[dojo.hostenv.name_]) ? common.concat(modMap[dojo.hostenv.name_] || []) : common.concat(modMap["default"] || []);
		dojo.hostenv.flattenRequireArray(newDeps);
		break;
	  case "require":
	  case "requireAfter":
	  case "hostenv.loadModule":
		newDeps = [{name:dep[1], content:null}];
		break;
	}
	if (dep[0] == "requireAfterIf" || dep[0] == "requireIf") {
		newAfterDeps = newDeps;
		newDeps = null;
	}
	return {requires:newDeps, requiresAfter:newAfterDeps};
};
dojo.hostenv.xdWalkReqs = function () {
	var reqChain = null;
	var req;
	for (var i = 0; i < this.xdOrderedReqs.length; i++) {
		req = this.xdOrderedReqs[i];
		if (this.xdDepMap[req]) {
			reqChain = [req];
			reqChain[req] = true;
			this.xdEvalReqs(reqChain);
		}
	}
};
dojo.hostenv.xdEvalReqs = function (reqChain) {
	while (reqChain.length > 0) {
		var req = reqChain[reqChain.length - 1];
		var pkg = this.xdDepMap[req];
		if (pkg) {
			var reqs = pkg.requires;
			if (reqs && reqs.length > 0) {
				var nextReq;
				for (var i = 0; i < reqs.length; i++) {
					nextReq = reqs[i].name;
					if (nextReq && !reqChain[nextReq]) {
						reqChain.push(nextReq);
						reqChain[nextReq] = true;
						this.xdEvalReqs(reqChain);
					}
				}
			}
			var contents = this.xdContents[pkg.contentIndex];
			if (!contents.isDefined) {
				var content = contents.content;
				content["resourceName"] = contents["resourceName"];
				content["resourcePath"] = contents["resourcePath"];
				this.xdDefList.push(content);
				contents.isDefined = true;
			}
			this.xdDepMap[req] = null;
			var reqs = pkg.requiresAfter;
			if (reqs && reqs.length > 0) {
				var nextReq;
				for (var i = 0; i < reqs.length; i++) {
					nextReq = reqs[i].name;
					if (nextReq && !reqChain[nextReq]) {
						reqChain.push(nextReq);
						reqChain[nextReq] = true;
						this.xdEvalReqs(reqChain);
					}
				}
			}
		}
		reqChain.pop();
	}
};
dojo.hostenv.clearXdInterval = function () {
	clearInterval(this.xdTimer);
	this.xdTimer = 0;
};
dojo.hostenv.watchInFlightXDomain = function () {
	var waitInterval = (djConfig.xdWaitSeconds || 15) * 1000;
	if (this.xdStartTime + waitInterval < (new Date()).getTime()) {
		this.clearXdInterval();
		var noLoads = "";
		for (var param in this.xdInFlight) {
			if (this.xdInFlight[param]) {
				noLoads += param + " ";
			}
		}
		dojo.raise("Could not load cross-domain packages: " + noLoads);
	}
	for (var param in this.xdInFlight) {
		if (this.xdInFlight[param]) {
			return;
		}
	}
	this.clearXdInterval();
	this.xdWalkReqs();
	var defLength = this.xdDefList.length;
	for (var i = 0; i < defLength; i++) {
		var content = dojo.hostenv.xdDefList[i];
		if (djConfig["debugAtAllCosts"] && content["resourceName"]) {
			if (!this["xdDebugQueue"]) {
				this.xdDebugQueue = [];
			}
			this.xdDebugQueue.push({resourceName:content.resourceName, resourcePath:content.resourcePath});
		} else {
			content(dojo);
		}
	}
	for (var i = 0; i < this.xdContents.length; i++) {
		var current = this.xdContents[i];
		if (current.content && !current.isDefined) {
			current.content(dojo);
		}
	}
	this.resetXd();
	if (this["xdDebugQueue"] && this.xdDebugQueue.length > 0) {
		this.xdDebugFileLoaded();
	} else {
		this.xdNotifyLoaded();
	}
};
dojo.hostenv.xdNotifyLoaded = function () {
	this.inFlightCount = 0;
	this.callLoaded();
};
dojo.hostenv.flattenRequireArray = function (target) {
	if (target) {
		for (var i = 0; i < target.length; i++) {
			if (target[i] instanceof Array) {
				target[i] = {name:target[i][0], content:null};
			} else {
				target[i] = {name:target[i], content:null};
			}
		}
	}
};
dojo.hostenv.xdHasCalledPreload = false;
dojo.hostenv.xdRealCallLoaded = dojo.hostenv.callLoaded;
dojo.hostenv.callLoaded = function () {
	if (this.xdHasCalledPreload || dojo.hostenv.getModulePrefix("dojo") == "src" || !this.localesGenerated) {
		this.xdRealCallLoaded();
		this.xdHasCalledPreload = true;
	} else {
		if (this.localesGenerated) {
			this.registerNlsPrefix = function () {
				dojo.registerModulePath("nls", dojo.hostenv.getModulePrefix("dojo") + "/../nls");
			};
			this.preloadLocalizations();
		}
		this.xdHasCalledPreload = true;
	}
};


__CPAN_FILE__ src/dom.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.dom");
dojo.dom.ELEMENT_NODE = 1;
dojo.dom.ATTRIBUTE_NODE = 2;
dojo.dom.TEXT_NODE = 3;
dojo.dom.CDATA_SECTION_NODE = 4;
dojo.dom.ENTITY_REFERENCE_NODE = 5;
dojo.dom.ENTITY_NODE = 6;
dojo.dom.PROCESSING_INSTRUCTION_NODE = 7;
dojo.dom.COMMENT_NODE = 8;
dojo.dom.DOCUMENT_NODE = 9;
dojo.dom.DOCUMENT_TYPE_NODE = 10;
dojo.dom.DOCUMENT_FRAGMENT_NODE = 11;
dojo.dom.NOTATION_NODE = 12;
dojo.dom.dojoml = "http://www.dojotoolkit.org/2004/dojoml";
dojo.dom.xmlns = {svg:"http://www.w3.org/2000/svg", smil:"http://www.w3.org/2001/SMIL20/", mml:"http://www.w3.org/1998/Math/MathML", cml:"http://www.xml-cml.org", xlink:"http://www.w3.org/1999/xlink", xhtml:"http://www.w3.org/1999/xhtml", xul:"http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul", xbl:"http://www.mozilla.org/xbl", fo:"http://www.w3.org/1999/XSL/Format", xsl:"http://www.w3.org/1999/XSL/Transform", xslt:"http://www.w3.org/1999/XSL/Transform", xi:"http://www.w3.org/2001/XInclude", xforms:"http://www.w3.org/2002/01/xforms", saxon:"http://icl.com/saxon", xalan:"http://xml.apache.org/xslt", xsd:"http://www.w3.org/2001/XMLSchema", dt:"http://www.w3.org/2001/XMLSchema-datatypes", xsi:"http://www.w3.org/2001/XMLSchema-instance", rdf:"http://www.w3.org/1999/02/22-rdf-syntax-ns#", rdfs:"http://www.w3.org/2000/01/rdf-schema#", dc:"http://purl.org/dc/elements/1.1/", dcq:"http://purl.org/dc/qualifiers/1.0", "soap-env":"http://schemas.xmlsoap.org/soap/envelope/", wsdl:"http://schemas.xmlsoap.org/wsdl/", AdobeExtensions:"http://ns.adobe.com/AdobeSVGViewerExtensions/3.0/"};
dojo.dom.isNode = function (wh) {
	if (typeof Element == "function") {
		try {
			return wh instanceof Element;
		}
		catch (e) {
		}
	} else {
		return wh && !isNaN(wh.nodeType);
	}
};
dojo.dom.getUniqueId = function () {
	var _document = dojo.doc();
	do {
		var id = "dj_unique_" + (++arguments.callee._idIncrement);
	} while (_document.getElementById(id));
	return id;
};
dojo.dom.getUniqueId._idIncrement = 0;
dojo.dom.firstElement = dojo.dom.getFirstChildElement = function (parentNode, tagName) {
	var node = parentNode.firstChild;
	while (node && node.nodeType != dojo.dom.ELEMENT_NODE) {
		node = node.nextSibling;
	}
	if (tagName && node && node.tagName && node.tagName.toLowerCase() != tagName.toLowerCase()) {
		node = dojo.dom.nextElement(node, tagName);
	}
	return node;
};
dojo.dom.lastElement = dojo.dom.getLastChildElement = function (parentNode, tagName) {
	var node = parentNode.lastChild;
	while (node && node.nodeType != dojo.dom.ELEMENT_NODE) {
		node = node.previousSibling;
	}
	if (tagName && node && node.tagName && node.tagName.toLowerCase() != tagName.toLowerCase()) {
		node = dojo.dom.prevElement(node, tagName);
	}
	return node;
};
dojo.dom.nextElement = dojo.dom.getNextSiblingElement = function (node, tagName) {
	if (!node) {
		return null;
	}
	do {
		node = node.nextSibling;
	} while (node && node.nodeType != dojo.dom.ELEMENT_NODE);
	if (node && tagName && tagName.toLowerCase() != node.tagName.toLowerCase()) {
		return dojo.dom.nextElement(node, tagName);
	}
	return node;
};
dojo.dom.prevElement = dojo.dom.getPreviousSiblingElement = function (node, tagName) {
	if (!node) {
		return null;
	}
	if (tagName) {
		tagName = tagName.toLowerCase();
	}
	do {
		node = node.previousSibling;
	} while (node && node.nodeType != dojo.dom.ELEMENT_NODE);
	if (node && tagName && tagName.toLowerCase() != node.tagName.toLowerCase()) {
		return dojo.dom.prevElement(node, tagName);
	}
	return node;
};
dojo.dom.moveChildren = function (srcNode, destNode, trim) {
	var count = 0;
	if (trim) {
		while (srcNode.hasChildNodes() && srcNode.firstChild.nodeType == dojo.dom.TEXT_NODE) {
			srcNode.removeChild(srcNode.firstChild);
		}
		while (srcNode.hasChildNodes() && srcNode.lastChild.nodeType == dojo.dom.TEXT_NODE) {
			srcNode.removeChild(srcNode.lastChild);
		}
	}
	while (srcNode.hasChildNodes()) {
		destNode.appendChild(srcNode.firstChild);
		count++;
	}
	return count;
};
dojo.dom.copyChildren = function (srcNode, destNode, trim) {
	var clonedNode = srcNode.cloneNode(true);
	return this.moveChildren(clonedNode, destNode, trim);
};
dojo.dom.replaceChildren = function (node, newChild) {
	var nodes = [];
	if (dojo.render.html.ie) {
		for (var i = 0; i < node.childNodes.length; i++) {
			nodes.push(node.childNodes[i]);
		}
	}
	dojo.dom.removeChildren(node);
	node.appendChild(newChild);
	for (var i = 0; i < nodes.length; i++) {
		dojo.dom.destroyNode(nodes[i]);
	}
};
dojo.dom.removeChildren = function (node) {
	var count = node.childNodes.length;
	while (node.hasChildNodes()) {
		dojo.dom.removeNode(node.firstChild);
	}
	return count;
};
dojo.dom.replaceNode = function (node, newNode) {
	return node.parentNode.replaceChild(newNode, node);
};
dojo.dom.destroyNode = function (node) {
	if (node.parentNode) {
		node = dojo.dom.removeNode(node);
	}
	if (node.nodeType != 3) {
		if (dojo.evalObjPath("dojo.event.browser.clean", false)) {
			dojo.event.browser.clean(node);
		}
		if (dojo.render.html.ie) {
			node.outerHTML = "";
		}
	}
};
dojo.dom.removeNode = function (node) {
	if (node && node.parentNode) {
		return node.parentNode.removeChild(node);
	}
};
dojo.dom.getAncestors = function (node, filterFunction, returnFirstHit) {
	var ancestors = [];
	var isFunction = (filterFunction && (filterFunction instanceof Function || typeof filterFunction == "function"));
	while (node) {
		if (!isFunction || filterFunction(node)) {
			ancestors.push(node);
		}
		if (returnFirstHit && ancestors.length > 0) {
			return ancestors[0];
		}
		node = node.parentNode;
	}
	if (returnFirstHit) {
		return null;
	}
	return ancestors;
};
dojo.dom.getAncestorsByTag = function (node, tag, returnFirstHit) {
	tag = tag.toLowerCase();
	return dojo.dom.getAncestors(node, function (el) {
		return ((el.tagName) && (el.tagName.toLowerCase() == tag));
	}, returnFirstHit);
};
dojo.dom.getFirstAncestorByTag = function (node, tag) {
	return dojo.dom.getAncestorsByTag(node, tag, true);
};
dojo.dom.isDescendantOf = function (node, ancestor, guaranteeDescendant) {
	if (guaranteeDescendant && node) {
		node = node.parentNode;
	}
	while (node) {
		if (node == ancestor) {
			return true;
		}
		node = node.parentNode;
	}
	return false;
};
dojo.dom.innerXML = function (node) {
	if (node.innerXML) {
		return node.innerXML;
	} else {
		if (node.xml) {
			return node.xml;
		} else {
			if (typeof XMLSerializer != "undefined") {
				return (new XMLSerializer()).serializeToString(node);
			}
		}
	}
};
dojo.dom.createDocument = function () {
	var doc = null;
	var _document = dojo.doc();
	if (!dj_undef("ActiveXObject")) {
		var prefixes = ["MSXML2", "Microsoft", "MSXML", "MSXML3"];
		for (var i = 0; i < prefixes.length; i++) {
			try {
				doc = new ActiveXObject(prefixes[i] + ".XMLDOM");
			}
			catch (e) {
			}
			if (doc) {
				break;
			}
		}
	} else {
		if ((_document.implementation) && (_document.implementation.createDocument)) {
			doc = _document.implementation.createDocument("", "", null);
		}
	}
	return doc;
};
dojo.dom.createDocumentFromText = function (str, mimetype) {
	if (!mimetype) {
		mimetype = "text/xml";
	}
	if (!dj_undef("DOMParser")) {
		var parser = new DOMParser();
		return parser.parseFromString(str, mimetype);
	} else {
		if (!dj_undef("ActiveXObject")) {
			var domDoc = dojo.dom.createDocument();
			if (domDoc) {
				domDoc.async = false;
				domDoc.loadXML(str);
				return domDoc;
			} else {
				dojo.debug("toXml didn't work?");
			}
		} else {
			var _document = dojo.doc();
			if (_document.createElement) {
				var tmp = _document.createElement("xml");
				tmp.innerHTML = str;
				if (_document.implementation && _document.implementation.createDocument) {
					var xmlDoc = _document.implementation.createDocument("foo", "", null);
					for (var i = 0; i < tmp.childNodes.length; i++) {
						xmlDoc.importNode(tmp.childNodes.item(i), true);
					}
					return xmlDoc;
				}
				return ((tmp.document) && (tmp.document.firstChild ? tmp.document.firstChild : tmp));
			}
		}
	}
	return null;
};
dojo.dom.prependChild = function (node, parent) {
	if (parent.firstChild) {
		parent.insertBefore(node, parent.firstChild);
	} else {
		parent.appendChild(node);
	}
	return true;
};
dojo.dom.insertBefore = function (node, ref, force) {
	if ((force != true) && (node === ref || node.nextSibling === ref)) {
		return false;
	}
	var parent = ref.parentNode;
	parent.insertBefore(node, ref);
	return true;
};
dojo.dom.insertAfter = function (node, ref, force) {
	var pn = ref.parentNode;
	if (ref == pn.lastChild) {
		if ((force != true) && (node === ref)) {
			return false;
		}
		pn.appendChild(node);
	} else {
		return this.insertBefore(node, ref.nextSibling, force);
	}
	return true;
};
dojo.dom.insertAtPosition = function (node, ref, position) {
	if ((!node) || (!ref) || (!position)) {
		return false;
	}
	switch (position.toLowerCase()) {
	  case "before":
		return dojo.dom.insertBefore(node, ref);
	  case "after":
		return dojo.dom.insertAfter(node, ref);
	  case "first":
		if (ref.firstChild) {
			return dojo.dom.insertBefore(node, ref.firstChild);
		} else {
			ref.appendChild(node);
			return true;
		}
		break;
	  default:
		ref.appendChild(node);
		return true;
	}
};
dojo.dom.insertAtIndex = function (node, containingNode, insertionIndex) {
	var siblingNodes = containingNode.childNodes;
	if (!siblingNodes.length || siblingNodes.length == insertionIndex) {
		containingNode.appendChild(node);
		return true;
	}
	if (insertionIndex == 0) {
		return dojo.dom.prependChild(node, containingNode);
	}
	return dojo.dom.insertAfter(node, siblingNodes[insertionIndex - 1]);
};
dojo.dom.textContent = function (node, text) {
	if (arguments.length > 1) {
		var _document = dojo.doc();
		dojo.dom.replaceChildren(node, _document.createTextNode(text));
		return text;
	} else {
		if (node.textContent != undefined) {
			return node.textContent;
		}
		var _result = "";
		if (node == null) {
			return _result;
		}
		for (var i = 0; i < node.childNodes.length; i++) {
			switch (node.childNodes[i].nodeType) {
			  case 1:
			  case 5:
				_result += dojo.dom.textContent(node.childNodes[i]);
				break;
			  case 3:
			  case 2:
			  case 4:
				_result += node.childNodes[i].nodeValue;
				break;
			  default:
				break;
			}
		}
		return _result;
	}
};
dojo.dom.hasParent = function (node) {
	return Boolean(node && node.parentNode && dojo.dom.isNode(node.parentNode));
};
dojo.dom.isTag = function (node) {
	if (node && node.tagName) {
		for (var i = 1; i < arguments.length; i++) {
			if (node.tagName == String(arguments[i])) {
				return String(arguments[i]);
			}
		}
	}
	return "";
};
dojo.dom.setAttributeNS = function (elem, namespaceURI, attrName, attrValue) {
	if (elem == null || ((elem == undefined) && (typeof elem == "undefined"))) {
		dojo.raise("No element given to dojo.dom.setAttributeNS");
	}
	if (!((elem.setAttributeNS == undefined) && (typeof elem.setAttributeNS == "undefined"))) {
		elem.setAttributeNS(namespaceURI, attrName, attrValue);
	} else {
		var ownerDoc = elem.ownerDocument;
		var attribute = ownerDoc.createNode(2, attrName, namespaceURI);
		attribute.nodeValue = attrValue;
		elem.setAttributeNode(attribute);
	}
};


__CPAN_FILE__ src/hostenv_wsh.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.hostenv.name_ = "wsh";
if (typeof WScript == "undefined") {
	dojo.raise("attempt to use WSH host environment when no WScript global");
}
dojo.hostenv.println = WScript.Echo;
dojo.hostenv.getCurrentScriptUri = function () {
	return WScript.ScriptFullName();
};
dojo.hostenv.getText = function (fpath) {
	var fso = new ActiveXObject("Scripting.FileSystemObject");
	var istream = fso.OpenTextFile(fpath, 1);
	if (!istream) {
		return null;
	}
	var contents = istream.ReadAll();
	istream.Close();
	return contents;
};
dojo.hostenv.exit = function (exitcode) {
	WScript.Quit(exitcode);
};
dojo.requireIf((djConfig["isDebug"] || djConfig["debugAtAllCosts"]), "dojo.debug");


__CPAN_FILE__ src/AdapterRegistry.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.AdapterRegistry");
dojo.require("dojo.lang.func");
dojo.AdapterRegistry = function (returnWrappers) {
	this.pairs = [];
	this.returnWrappers = returnWrappers || false;
};
dojo.lang.extend(dojo.AdapterRegistry, {register:function (name, check, wrap, directReturn, override) {
	var type = (override) ? "unshift" : "push";
	this.pairs[type]([name, check, wrap, directReturn]);
}, match:function () {
	for (var i = 0; i < this.pairs.length; i++) {
		var pair = this.pairs[i];
		if (pair[1].apply(this, arguments)) {
			if ((pair[3]) || (this.returnWrappers)) {
				return pair[2];
			} else {
				return pair[2].apply(this, arguments);
			}
		}
	}
	throw new Error("No match found");
}, unregister:function (name) {
	for (var i = 0; i < this.pairs.length; i++) {
		var pair = this.pairs[i];
		if (pair[0] == name) {
			this.pairs.splice(i, 1);
			return true;
		}
	}
	return false;
}});


__CPAN_FILE__ src/hostenv_svg.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

if (typeof window == "undefined") {
	dojo.raise("attempt to use adobe svg hostenv when no window object");
}
dojo.debug = function () {
	if (!djConfig.isDebug) {
		return;
	}
	var args = arguments;
	var isJUM = dj_global["jum"];
	var s = isJUM ? "" : "DEBUG: ";
	for (var i = 0; i < args.length; ++i) {
		s += args[i];
	}
	if (isJUM) {
		jum.debug(s);
	} else {
		dojo.hostenv.println(s);
	}
};
dojo.render.name = navigator.appName;
dojo.render.ver = parseFloat(navigator.appVersion, 10);
switch (navigator.platform) {
  case "MacOS":
	dojo.render.os.osx = true;
	break;
  case "Linux":
	dojo.render.os.linux = true;
	break;
  case "Windows":
	dojo.render.os.win = true;
	break;
  default:
	dojo.render.os.linux = true;
	break;
}
dojo.render.svg.capable = true;
dojo.render.svg.support.builtin = true;
dojo.render.svg.moz = ((navigator.userAgent.indexOf("Gecko") >= 0) && (!((navigator.appVersion.indexOf("Konqueror") >= 0) || (navigator.appVersion.indexOf("Safari") >= 0))));
dojo.render.svg.adobe = (window.parseXML != null);
dojo.hostenv.startPackage("dojo.hostenv");
dojo.hostenv.println = function (s) {
	try {
		var ti = document.createElement("text");
		ti.setAttribute("x", "50");
		ti.setAttribute("y", (25 + 15 * document.getElementsByTagName("text").length));
		ti.appendChild(document.createTextNode(s));
		document.documentElement.appendChild(ti);
	}
	catch (e) {
	}
};
dojo.hostenv.name_ = "svg";
dojo.hostenv.setModulePrefix = function (module, prefix) {
};
dojo.hostenv.getModulePrefix = function (module) {
};
dojo.hostenv.getTextStack = [];
dojo.hostenv.loadUriStack = [];
dojo.hostenv.loadedUris = [];
dojo.hostenv.modules_ = {};
dojo.hostenv.modulesLoadedFired = false;
dojo.hostenv.modulesLoadedListeners = [];
dojo.hostenv.getText = function (uri, cb, data) {
	if (!cb) {
		var cb = function (result) {
			window.alert(result);
		};
	}
	if (!data) {
		window.getUrl(uri, cb);
	} else {
		window.postUrl(uri, data, cb);
	}
};
dojo.hostenv.getLibaryScriptUri = function () {
};
dojo.hostenv.loadUri = function (uri) {
};
dojo.hostenv.loadUriAndCheck = function (uri, module) {
};
dojo.hostenv.loadModule = function (moduleName) {
	var a = moduleName.split(".");
	var currentObj = window;
	var s = [];
	for (var i = 0; i < a.length; i++) {
		if (a[i] == "*") {
			continue;
		}
		s.push(a[i]);
		if (!currentObj[a[i]]) {
			dojo.raise("dojo.require('" + moduleName + "'): module does not exist.");
		} else {
			currentObj = currentObj[a[i]];
		}
	}
	return;
};
dojo.hostenv.startPackage = function (moduleName) {
	var a = moduleName.split(".");
	var currentObj = window;
	var s = [];
	for (var i = 0; i < a.length; i++) {
		if (a[i] == "*") {
			continue;
		}
		s.push(a[i]);
		if (!currentObj[a[i]]) {
			currentObj[a[i]] = {};
		}
		currentObj = currentObj[a[i]];
	}
	return;
};
if (window.parseXML) {
	window.XMLSerialzer = function () {
		function nodeToString(n, a) {
			function fixText(s) {
				return String(s).replace(/\&/g, "&amp;").replace(/>/g, "&gt;").replace(/</g, "&lt;");
			}
			function fixAttribute(s) {
				return fixText(s).replace(/\"/g, "&quot;");
			}
			switch (n.nodeType) {
			  case 1:
				var name = n.nodeName;
				a.push("<" + name);
				for (var i = 0; i < n.attributes.length; i++) {
					if (n.attributes.item(i).specified) {
						a.push(" " + n.attributes.item(i).nodeName.toLowerCase() + "=\"" + fixAttribute(n.attributes.item(i).nodeValue) + "\"");
					}
				}
				if (n.canHaveChildren || n.hasChildNodes()) {
					a.push(">");
					for (var i = 0; i < n.childNodes.length; i++) {
						nodeToString(n.childNodes.item(i), a);
					}
					a.push("</" + name + ">\n");
				} else {
					a.push(" />\n");
				}
				break;
			  case 3:
				a.push(fixText(n.nodeValue));
				break;
			  case 4:
				a.push("<![CDA" + "TA[\n" + n.nodeValue + "\n]" + "]>");
				break;
			  case 7:
				a.push(n.nodeValue);
				if (/(^<\?xml)|(^<\!DOCTYPE)/.test(n.nodeValue)) {
					a.push("\n");
				}
				break;
			  case 8:
				a.push("<!-- " + n.nodeValue + " -->\n");
				break;
			  case 9:
			  case 11:
				for (var i = 0; i < n.childNodes.length; i++) {
					nodeToString(n.childNodes.item(i), a);
				}
				break;
			  default:
				a.push("<!--\nNot Supported:\n\n" + "nodeType: " + n.nodeType + "\nnodeName: " + n.nodeName + "\n-->");
			}
		}
		this.serializeToString = function (node) {
			var a = [];
			nodeToString(node, a);
			return a.join("");
		};
	};
	window.DOMParser = function () {
		this.parseFromString = function (s) {
			return parseXML(s, window.document);
		};
	};
	window.XMLHttpRequest = function () {
		var uri = null;
		var method = "POST";
		var isAsync = true;
		var cb = function (d) {
			this.responseText = d.content;
			try {
				this.responseXML = parseXML(this.responseText, window.document);
			}
			catch (e) {
			}
			this.status = "200";
			this.statusText = "OK";
			if (!d.success) {
				this.status = "500";
				this.statusText = "Internal Server Error";
			}
			this.onload();
			this.onreadystatechange();
		};
		this.onload = function () {
		};
		this.readyState = 4;
		this.onreadystatechange = function () {
		};
		this.status = 0;
		this.statusText = "";
		this.responseBody = null;
		this.responseStream = null;
		this.responseXML = null;
		this.responseText = null;
		this.abort = function () {
			return;
		};
		this.getAllResponseHeaders = function () {
			return [];
		};
		this.getResponseHeader = function (n) {
			return null;
		};
		this.setRequestHeader = function (nm, val) {
		};
		this.open = function (meth, url, async) {
			method = meth;
			uri = url;
		};
		this.send = function (data) {
			var d = data || null;
			if (method == "GET") {
				getURL(uri, cb);
			} else {
				postURL(uri, data, cb);
			}
		};
	};
}
dojo.requireIf((djConfig["isDebug"] || djConfig["debugAtAllCosts"]), "dojo.debug");


__CPAN_FILE__ src/math.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.math");
dojo.math.degToRad = function (x) {
	return (x * Math.PI) / 180;
};
dojo.math.radToDeg = function (x) {
	return (x * 180) / Math.PI;
};
dojo.math.factorial = function (n) {
	if (n < 1) {
		return 0;
	}
	var retVal = 1;
	for (var i = 1; i <= n; i++) {
		retVal *= i;
	}
	return retVal;
};
dojo.math.permutations = function (n, k) {
	if (n == 0 || k == 0) {
		return 1;
	}
	return (dojo.math.factorial(n) / dojo.math.factorial(n - k));
};
dojo.math.combinations = function (n, r) {
	if (n == 0 || r == 0) {
		return 1;
	}
	return (dojo.math.factorial(n) / (dojo.math.factorial(n - r) * dojo.math.factorial(r)));
};
dojo.math.bernstein = function (t, n, i) {
	return (dojo.math.combinations(n, i) * Math.pow(t, i) * Math.pow(1 - t, n - i));
};
dojo.math.gaussianRandom = function () {
	var k = 2;
	do {
		var i = 2 * Math.random() - 1;
		var j = 2 * Math.random() - 1;
		k = i * i + j * j;
	} while (k >= 1);
	k = Math.sqrt((-2 * Math.log(k)) / k);
	return i * k;
};
dojo.math.mean = function () {
	var array = dojo.lang.isArray(arguments[0]) ? arguments[0] : arguments;
	var mean = 0;
	for (var i = 0; i < array.length; i++) {
		mean += array[i];
	}
	return mean / array.length;
};
dojo.math.round = function (number, places) {
	if (!places) {
		var shift = 1;
	} else {
		var shift = Math.pow(10, places);
	}
	return Math.round(number * shift) / shift;
};
dojo.math.sd = dojo.math.standardDeviation = function () {
	var array = dojo.lang.isArray(arguments[0]) ? arguments[0] : arguments;
	return Math.sqrt(dojo.math.variance(array));
};
dojo.math.variance = function () {
	var array = dojo.lang.isArray(arguments[0]) ? arguments[0] : arguments;
	var mean = 0, squares = 0;
	for (var i = 0; i < array.length; i++) {
		mean += array[i];
		squares += Math.pow(array[i], 2);
	}
	return (squares / array.length) - Math.pow(mean / array.length, 2);
};
dojo.math.range = function (a, b, step) {
	if (arguments.length < 2) {
		b = a;
		a = 0;
	}
	if (arguments.length < 3) {
		step = 1;
	}
	var range = [];
	if (step > 0) {
		for (var i = a; i < b; i += step) {
			range.push(i);
		}
	} else {
		if (step < 0) {
			for (var i = a; i > b; i += step) {
				range.push(i);
			}
		} else {
			throw new Error("dojo.math.range: step must be non-zero");
		}
	}
	return range;
};


__CPAN_FILE__ src/a11y.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.a11y");
dojo.require("dojo.uri.*");
dojo.require("dojo.html.common");
dojo.a11y = {imgPath:dojo.uri.moduleUri("dojo.widget", "templates/images"), doAccessibleCheck:true, accessible:null, checkAccessible:function () {
	if (this.accessible === null) {
		this.accessible = false;
		if (this.doAccessibleCheck == true) {
			this.accessible = this.testAccessible();
		}
	}
	return this.accessible;
}, testAccessible:function () {
	this.accessible = false;
	if (dojo.render.html.ie || dojo.render.html.mozilla) {
		var div = document.createElement("div");
		div.style.backgroundImage = "url(\"" + this.imgPath + "/tab_close.gif\")";
		dojo.body().appendChild(div);
		var bkImg = null;
		if (window.getComputedStyle) {
			var cStyle = getComputedStyle(div, "");
			bkImg = cStyle.getPropertyValue("background-image");
		} else {
			bkImg = div.currentStyle.backgroundImage;
		}
		var bUseImgElem = false;
		if (bkImg != null && (bkImg == "none" || bkImg == "url(invalid-url:)")) {
			this.accessible = true;
		}
		dojo.body().removeChild(div);
	}
	return this.accessible;
}, setCheckAccessible:function (bTest) {
	this.doAccessibleCheck = bTest;
}, setAccessibleMode:function () {
	if (this.accessible === null) {
		if (this.checkAccessible()) {
			dojo.render.html.prefixes.unshift("a11y");
		}
	}
	return this.accessible;
}};


__CPAN_FILE__ src/event.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.event");
dojo.require("dojo.event.*");
dojo.deprecated("dojo.event", "replaced by dojo.event.*", "0.5");


__CPAN_FILE__ src/hostenv_browser.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

if (typeof window != "undefined") {
	(function () {
		if (djConfig.allowQueryConfig) {
			var baseUrl = document.location.toString();
			var params = baseUrl.split("?", 2);
			if (params.length > 1) {
				var paramStr = params[1];
				var pairs = paramStr.split("&");
				for (var x in pairs) {
					var sp = pairs[x].split("=");
					if ((sp[0].length > 9) && (sp[0].substr(0, 9) == "djConfig.")) {
						var opt = sp[0].substr(9);
						try {
							djConfig[opt] = eval(sp[1]);
						}
						catch (e) {
							djConfig[opt] = sp[1];
						}
					}
				}
			}
		}
		if (((djConfig["baseScriptUri"] == "") || (djConfig["baseRelativePath"] == "")) && (document && document.getElementsByTagName)) {
			var scripts = document.getElementsByTagName("script");
			var rePkg = /(__package__|dojo|bootstrap1)\.js([\?\.]|$)/i;
			for (var i = 0; i < scripts.length; i++) {
				var src = scripts[i].getAttribute("src");
				if (!src) {
					continue;
				}
				var m = src.match(rePkg);
				if (m) {
					var root = src.substring(0, m.index);
					if (src.indexOf("bootstrap1") > -1) {
						root += "../";
					}
					if (!this["djConfig"]) {
						djConfig = {};
					}
					if (djConfig["baseScriptUri"] == "") {
						djConfig["baseScriptUri"] = root;
					}
					if (djConfig["baseRelativePath"] == "") {
						djConfig["baseRelativePath"] = root;
					}
					break;
				}
			}
		}
		var dr = dojo.render;
		var drh = dojo.render.html;
		var drs = dojo.render.svg;
		var dua = (drh.UA = navigator.userAgent);
		var dav = (drh.AV = navigator.appVersion);
		var t = true;
		var f = false;
		drh.capable = t;
		drh.support.builtin = t;
		dr.ver = parseFloat(drh.AV);
		dr.os.mac = dav.indexOf("Macintosh") >= 0;
		dr.os.win = dav.indexOf("Windows") >= 0;
		dr.os.linux = dav.indexOf("X11") >= 0;
		drh.opera = dua.indexOf("Opera") >= 0;
		drh.khtml = (dav.indexOf("Konqueror") >= 0) || (dav.indexOf("Safari") >= 0);
		drh.safari = dav.indexOf("Safari") >= 0;
		var geckoPos = dua.indexOf("Gecko");
		drh.mozilla = drh.moz = (geckoPos >= 0) && (!drh.khtml);
		if (drh.mozilla) {
			drh.geckoVersion = dua.substring(geckoPos + 6, geckoPos + 14);
		}
		drh.ie = (document.all) && (!drh.opera);
		drh.ie50 = drh.ie && dav.indexOf("MSIE 5.0") >= 0;
		drh.ie55 = drh.ie && dav.indexOf("MSIE 5.5") >= 0;
		drh.ie60 = drh.ie && dav.indexOf("MSIE 6.0") >= 0;
		drh.ie70 = drh.ie && dav.indexOf("MSIE 7.0") >= 0;
		var cm = document["compatMode"];
		drh.quirks = (cm == "BackCompat") || (cm == "QuirksMode") || drh.ie55 || drh.ie50;
		dojo.locale = dojo.locale || (drh.ie ? navigator.userLanguage : navigator.language).toLowerCase();
		dr.vml.capable = drh.ie;
		drs.capable = f;
		drs.support.plugin = f;
		drs.support.builtin = f;
		var tdoc = window["document"];
		var tdi = tdoc["implementation"];
		if ((tdi) && (tdi["hasFeature"]) && (tdi.hasFeature("org.w3c.dom.svg", "1.0"))) {
			drs.capable = t;
			drs.support.builtin = t;
			drs.support.plugin = f;
		}
		if (drh.safari) {
			var tmp = dua.split("AppleWebKit/")[1];
			var ver = parseFloat(tmp.split(" ")[0]);
			if (ver >= 420) {
				drs.capable = t;
				drs.support.builtin = t;
				drs.support.plugin = f;
			}
		} else {
		}
	})();
	dojo.hostenv.startPackage("dojo.hostenv");
	dojo.render.name = dojo.hostenv.name_ = "browser";
	dojo.hostenv.searchIds = [];
	dojo.hostenv._XMLHTTP_PROGIDS = ["Msxml2.XMLHTTP", "Microsoft.XMLHTTP", "Msxml2.XMLHTTP.4.0"];
	dojo.hostenv.getXmlhttpObject = function () {
		var http = null;
		var last_e = null;
		try {
			http = new XMLHttpRequest();
		}
		catch (e) {
		}
		if (!http) {
			for (var i = 0; i < 3; ++i) {
				var progid = dojo.hostenv._XMLHTTP_PROGIDS[i];
				try {
					http = new ActiveXObject(progid);
				}
				catch (e) {
					last_e = e;
				}
				if (http) {
					dojo.hostenv._XMLHTTP_PROGIDS = [progid];
					break;
				}
			}
		}
		if (!http) {
			return dojo.raise("XMLHTTP not available", last_e);
		}
		return http;
	};
	dojo.hostenv._blockAsync = false;
	dojo.hostenv.getText = function (uri, async_cb, fail_ok) {
		if (!async_cb) {
			this._blockAsync = true;
		}
		var http = this.getXmlhttpObject();
		function isDocumentOk(http) {
			var stat = http["status"];
			return Boolean((!stat) || ((200 <= stat) && (300 > stat)) || (stat == 304));
		}
		if (async_cb) {
			var _this = this, timer = null, gbl = dojo.global();
			var xhr = dojo.evalObjPath("dojo.io.XMLHTTPTransport");
			http.onreadystatechange = function () {
				if (timer) {
					gbl.clearTimeout(timer);
					timer = null;
				}
				if (_this._blockAsync || (xhr && xhr._blockAsync)) {
					timer = gbl.setTimeout(function () {
						http.onreadystatechange.apply(this);
					}, 10);
				} else {
					if (4 == http.readyState) {
						if (isDocumentOk(http)) {
							async_cb(http.responseText);
						}
					}
				}
			};
		}
		http.open("GET", uri, async_cb ? true : false);
		try {
			http.send(null);
			if (async_cb) {
				return null;
			}
			if (!isDocumentOk(http)) {
				var err = Error("Unable to load " + uri + " status:" + http.status);
				err.status = http.status;
				err.responseText = http.responseText;
				throw err;
			}
		}
		catch (e) {
			this._blockAsync = false;
			if ((fail_ok) && (!async_cb)) {
				return null;
			} else {
				throw e;
			}
		}
		this._blockAsync = false;
		return http.responseText;
	};
	dojo.hostenv.defaultDebugContainerId = "dojoDebug";
	dojo.hostenv._println_buffer = [];
	dojo.hostenv._println_safe = false;
	dojo.hostenv.println = function (line) {
		if (!dojo.hostenv._println_safe) {
			dojo.hostenv._println_buffer.push(line);
		} else {
			try {
				var console = document.getElementById(djConfig.debugContainerId ? djConfig.debugContainerId : dojo.hostenv.defaultDebugContainerId);
				if (!console) {
					console = dojo.body();
				}
				var div = document.createElement("div");
				div.appendChild(document.createTextNode(line));
				console.appendChild(div);
			}
			catch (e) {
				try {
					document.write("<div>" + line + "</div>");
				}
				catch (e2) {
					window.status = line;
				}
			}
		}
	};
	dojo.addOnLoad(function () {
		dojo.hostenv._println_safe = true;
		while (dojo.hostenv._println_buffer.length > 0) {
			dojo.hostenv.println(dojo.hostenv._println_buffer.shift());
		}
	});
	function dj_addNodeEvtHdlr(node, evtName, fp) {
		var oldHandler = node["on" + evtName] || function () {
		};
		node["on" + evtName] = function () {
			fp.apply(node, arguments);
			oldHandler.apply(node, arguments);
		};
		return true;
	}
	function dj_load_init(e) {
		var type = (e && e.type) ? e.type.toLowerCase() : "load";
		if (arguments.callee.initialized || (type != "domcontentloaded" && type != "load")) {
			return;
		}
		arguments.callee.initialized = true;
		if (typeof (_timer) != "undefined") {
			clearInterval(_timer);
			delete _timer;
		}
		var initFunc = function () {
			if (dojo.render.html.ie) {
				dojo.hostenv.makeWidgets();
			}
		};
		if (dojo.hostenv.inFlightCount == 0) {
			initFunc();
			dojo.hostenv.modulesLoaded();
		} else {
			dojo.hostenv.modulesLoadedListeners.unshift(initFunc);
		}
	}
	if (document.addEventListener) {
		if (dojo.render.html.opera || (dojo.render.html.moz && (djConfig["enableMozDomContentLoaded"] === true))) {
			document.addEventListener("DOMContentLoaded", dj_load_init, null);
		}
		window.addEventListener("load", dj_load_init, null);
	}
	if (dojo.render.html.ie && dojo.render.os.win) {
		document.attachEvent("onreadystatechange", function (e) {
			if (document.readyState == "complete") {
				dj_load_init();
			}
		});
	}
	if (/(WebKit|khtml)/i.test(navigator.userAgent)) {
		var _timer = setInterval(function () {
			if (/loaded|complete/.test(document.readyState)) {
				dj_load_init();
			}
		}, 10);
	}
	if (dojo.render.html.ie) {
		dj_addNodeEvtHdlr(window, "beforeunload", function () {
			dojo.hostenv._unloading = true;
			window.setTimeout(function () {
				dojo.hostenv._unloading = false;
			}, 0);
		});
	}
	dj_addNodeEvtHdlr(window, "unload", function () {
		dojo.hostenv.unloaded();
		if ((!dojo.render.html.ie) || (dojo.render.html.ie && dojo.hostenv._unloading)) {
			dojo.hostenv.unloaded();
		}
	});
	dojo.hostenv.makeWidgets = function () {
		var sids = [];
		if (djConfig.searchIds && djConfig.searchIds.length > 0) {
			sids = sids.concat(djConfig.searchIds);
		}
		if (dojo.hostenv.searchIds && dojo.hostenv.searchIds.length > 0) {
			sids = sids.concat(dojo.hostenv.searchIds);
		}
		if ((djConfig.parseWidgets) || (sids.length > 0)) {
			if (dojo.evalObjPath("dojo.widget.Parse")) {
				var parser = new dojo.xml.Parse();
				if (sids.length > 0) {
					for (var x = 0; x < sids.length; x++) {
						var tmpNode = document.getElementById(sids[x]);
						if (!tmpNode) {
							continue;
						}
						var frag = parser.parseElement(tmpNode, null, true);
						dojo.widget.getParser().createComponents(frag);
					}
				} else {
					if (djConfig.parseWidgets) {
						var frag = parser.parseElement(dojo.body(), null, true);
						dojo.widget.getParser().createComponents(frag);
					}
				}
			}
		}
	};
	dojo.addOnLoad(function () {
		if (!dojo.render.html.ie) {
			dojo.hostenv.makeWidgets();
		}
	});
	try {
		if (dojo.render.html.ie) {
			document.namespaces.add("v", "urn:schemas-microsoft-com:vml");
			document.createStyleSheet().addRule("v\\:*", "behavior:url(#default#VML)");
		}
	}
	catch (e) {
	}
	dojo.hostenv.writeIncludes = function () {
	};
	if (!dj_undef("document", this)) {
		dj_currentDocument = this.document;
	}
	dojo.doc = function () {
		return dj_currentDocument;
	};
	dojo.body = function () {
		return dojo.doc().body || dojo.doc().getElementsByTagName("body")[0];
	};
	dojo.byId = function (id, doc) {
		if ((id) && ((typeof id == "string") || (id instanceof String))) {
			if (!doc) {
				doc = dj_currentDocument;
			}
			var ele = doc.getElementById(id);
			if (ele && (ele.id != id) && doc.all) {
				ele = null;
				eles = doc.all[id];
				if (eles) {
					if (eles.length) {
						for (var i = 0; i < eles.length; i++) {
							if (eles[i].id == id) {
								ele = eles[i];
								break;
							}
						}
					} else {
						ele = eles;
					}
				}
			}
			return ele;
		}
		return id;
	};
	dojo.setContext = function (globalObject, globalDocument) {
		dj_currentContext = globalObject;
		dj_currentDocument = globalDocument;
	};
	dojo._fireCallback = function (callback, context, cbArguments) {
		if ((context) && ((typeof callback == "string") || (callback instanceof String))) {
			callback = context[callback];
		}
		return (context ? callback.apply(context, cbArguments || []) : callback());
	};
	dojo.withGlobal = function (globalObject, callback, thisObject, cbArguments) {
		var rval;
		var oldGlob = dj_currentContext;
		var oldDoc = dj_currentDocument;
		try {
			dojo.setContext(globalObject, globalObject.document);
			rval = dojo._fireCallback(callback, thisObject, cbArguments);
		}
		finally {
			dojo.setContext(oldGlob, oldDoc);
		}
		return rval;
	};
	dojo.withDoc = function (documentObject, callback, thisObject, cbArguments) {
		var rval;
		var oldDoc = dj_currentDocument;
		try {
			dj_currentDocument = documentObject;
			rval = dojo._fireCallback(callback, thisObject, cbArguments);
		}
		finally {
			dj_currentDocument = oldDoc;
		}
		return rval;
	};
}
dojo.requireIf((djConfig["isDebug"] || djConfig["debugAtAllCosts"]), "dojo.debug");
dojo.requireIf(djConfig["debugAtAllCosts"] && !window.widget && !djConfig["useXDomain"], "dojo.browser_debug");
dojo.requireIf(djConfig["debugAtAllCosts"] && !window.widget && djConfig["useXDomain"], "dojo.browser_debug_xd");


__CPAN_FILE__ src/iCalendar.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.require("dojo.cal.iCalendar");
dojo.deprecated("dojo.icalendar", "use dojo.cal.iCalendar isntead", "0.5");


__CPAN_FILE__ src/profile.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.profile");
dojo.profile = {_profiles:{}, _pns:[], start:function (name) {
	if (!this._profiles[name]) {
		this._profiles[name] = {iters:0, total:0};
		this._pns[this._pns.length] = name;
	} else {
		if (this._profiles[name]["start"]) {
			this.end(name);
		}
	}
	this._profiles[name].end = null;
	this._profiles[name].start = new Date();
}, end:function (name) {
	var ed = new Date();
	if ((this._profiles[name]) && (this._profiles[name]["start"])) {
		with (this._profiles[name]) {
			end = ed;
			total += (end - start);
			start = null;
			iters++;
		}
	} else {
		return true;
	}
}, dump:function (appendToDoc) {
	var tbl = document.createElement("table");
	with (tbl.style) {
		border = "1px solid black";
		borderCollapse = "collapse";
	}
	var hdr = tbl.createTHead();
	var hdrtr = hdr.insertRow(0);
	var cols = ["Identifier", "Calls", "Total", "Avg"];
	for (var x = 0; x < cols.length; x++) {
		var ntd = hdrtr.insertCell(x);
		with (ntd.style) {
			backgroundColor = "#225d94";
			color = "white";
			borderBottom = "1px solid black";
			borderRight = "1px solid black";
			fontFamily = "tahoma";
			fontWeight = "bolder";
			paddingLeft = paddingRight = "5px";
		}
		ntd.appendChild(document.createTextNode(cols[x]));
	}
	for (var x = 0; x < this._pns.length; x++) {
		var prf = this._profiles[this._pns[x]];
		this.end(this._pns[x]);
		if (prf.iters > 0) {
			var bdytr = tbl.insertRow(true);
			var vals = [this._pns[x], prf.iters, prf.total, parseInt(prf.total / prf.iters)];
			for (var y = 0; y < vals.length; y++) {
				var cc = bdytr.insertCell(y);
				cc.appendChild(document.createTextNode(vals[y]));
				with (cc.style) {
					borderBottom = "1px solid gray";
					paddingLeft = paddingRight = "5px";
					if (x % 2) {
						backgroundColor = "#e1f1ff";
					}
					if (y > 0) {
						textAlign = "right";
						borderRight = "1px solid gray";
					} else {
						borderRight = "1px solid black";
					}
				}
			}
		}
	}
	if (appendToDoc) {
		var ne = document.createElement("div");
		ne.id = "profileOutputTable";
		with (ne.style) {
			fontFamily = "Courier New, monospace";
			fontSize = "12px";
			lineHeight = "16px";
			borderTop = "1px solid black";
			padding = "10px";
		}
		if (document.getElementById("profileOutputTable")) {
			dojo.body().replaceChild(ne, document.getElementById("profileOutputTable"));
		} else {
			dojo.body().appendChild(ne);
		}
		ne.appendChild(tbl);
	}
	return tbl;
}};
dojo.profile.stop = dojo.profile.end;


__CPAN_FILE__ src/flash.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.flash");
dojo.require("dojo.string.*");
dojo.require("dojo.uri.*");
dojo.require("dojo.html.common");
dojo.flash = function () {
};
dojo.flash = {flash6_version:null, flash8_version:null, ready:false, _visible:true, _loadedListeners:new Array(), _installingListeners:new Array(), setSwf:function (fileInfo) {
	if (fileInfo == null || dojo.lang.isUndefined(fileInfo)) {
		return;
	}
	if (fileInfo.flash6 != null && !dojo.lang.isUndefined(fileInfo.flash6)) {
		this.flash6_version = fileInfo.flash6;
	}
	if (fileInfo.flash8 != null && !dojo.lang.isUndefined(fileInfo.flash8)) {
		this.flash8_version = fileInfo.flash8;
	}
	if (!dojo.lang.isUndefined(fileInfo.visible)) {
		this._visible = fileInfo.visible;
	}
	this._initialize();
}, useFlash6:function () {
	if (this.flash6_version == null) {
		return false;
	} else {
		if (this.flash6_version != null && dojo.flash.info.commVersion == 6) {
			return true;
		} else {
			return false;
		}
	}
}, useFlash8:function () {
	if (this.flash8_version == null) {
		return false;
	} else {
		if (this.flash8_version != null && dojo.flash.info.commVersion == 8) {
			return true;
		} else {
			return false;
		}
	}
}, addLoadedListener:function (listener) {
	this._loadedListeners.push(listener);
}, addInstallingListener:function (listener) {
	this._installingListeners.push(listener);
}, loaded:function () {
	dojo.flash.ready = true;
	if (dojo.flash._loadedListeners.length > 0) {
		for (var i = 0; i < dojo.flash._loadedListeners.length; i++) {
			dojo.flash._loadedListeners[i].call(null);
		}
	}
}, installing:function () {
	if (dojo.flash._installingListeners.length > 0) {
		for (var i = 0; i < dojo.flash._installingListeners.length; i++) {
			dojo.flash._installingListeners[i].call(null);
		}
	}
}, _initialize:function () {
	var installer = new dojo.flash.Install();
	dojo.flash.installer = installer;
	if (installer.needed() == true) {
		installer.install();
	} else {
		dojo.flash.obj = new dojo.flash.Embed(this._visible);
		dojo.flash.obj.write(dojo.flash.info.commVersion);
		dojo.flash.comm = new dojo.flash.Communicator();
	}
}};
dojo.flash.Info = function () {
	if (dojo.render.html.ie) {
		document.writeln("<script language=\"VBScript\" type=\"text/vbscript\">");
		document.writeln("Function VBGetSwfVer(i)");
		document.writeln("  on error resume next");
		document.writeln("  Dim swControl, swVersion");
		document.writeln("  swVersion = 0");
		document.writeln("  set swControl = CreateObject(\"ShockwaveFlash.ShockwaveFlash.\" + CStr(i))");
		document.writeln("  if (IsObject(swControl)) then");
		document.writeln("	swVersion = swControl.GetVariable(\"$version\")");
		document.writeln("  end if");
		document.writeln("  VBGetSwfVer = swVersion");
		document.writeln("End Function");
		document.writeln("</script>");
	}
	this._detectVersion();
	this._detectCommunicationVersion();
};
dojo.flash.Info.prototype = {version:-1, versionMajor:-1, versionMinor:-1, versionRevision:-1, capable:false, commVersion:6, installing:false, isVersionOrAbove:function (reqMajorVer, reqMinorVer, reqVer) {
	reqVer = parseFloat("." + reqVer);
	if (this.versionMajor >= reqMajorVer && this.versionMinor >= reqMinorVer && this.versionRevision >= reqVer) {
		return true;
	} else {
		return false;
	}
}, _detectVersion:function () {
	var versionStr;
	for (var testVersion = 25; testVersion > 0; testVersion--) {
		if (dojo.render.html.ie) {
			versionStr = VBGetSwfVer(testVersion);
		} else {
			versionStr = this._JSFlashInfo(testVersion);
		}
		if (versionStr == -1) {
			this.capable = false;
			return;
		} else {
			if (versionStr != 0) {
				var versionArray;
				if (dojo.render.html.ie) {
					var tempArray = versionStr.split(" ");
					var tempString = tempArray[1];
					versionArray = tempString.split(",");
				} else {
					versionArray = versionStr.split(".");
				}
				this.versionMajor = versionArray[0];
				this.versionMinor = versionArray[1];
				this.versionRevision = versionArray[2];
				var versionString = this.versionMajor + "." + this.versionRevision;
				this.version = parseFloat(versionString);
				this.capable = true;
				break;
			}
		}
	}
}, _JSFlashInfo:function (testVersion) {
	if (navigator.plugins != null && navigator.plugins.length > 0) {
		if (navigator.plugins["Shockwave Flash 2.0"] || navigator.plugins["Shockwave Flash"]) {
			var swVer2 = navigator.plugins["Shockwave Flash 2.0"] ? " 2.0" : "";
			var flashDescription = navigator.plugins["Shockwave Flash" + swVer2].description;
			var descArray = flashDescription.split(" ");
			var tempArrayMajor = descArray[2].split(".");
			var versionMajor = tempArrayMajor[0];
			var versionMinor = tempArrayMajor[1];
			if (descArray[3] != "") {
				var tempArrayMinor = descArray[3].split("r");
			} else {
				var tempArrayMinor = descArray[4].split("r");
			}
			var versionRevision = tempArrayMinor[1] > 0 ? tempArrayMinor[1] : 0;
			var version = versionMajor + "." + versionMinor + "." + versionRevision;
			return version;
		}
	}
	return -1;
}, _detectCommunicationVersion:function () {
	if (this.capable == false) {
		this.commVersion = null;
		return;
	}
	if (typeof djConfig["forceFlashComm"] != "undefined" && typeof djConfig["forceFlashComm"] != null) {
		this.commVersion = djConfig["forceFlashComm"];
		return;
	}
	if (dojo.render.html.safari == true || dojo.render.html.opera == true) {
		this.commVersion = 8;
	} else {
		this.commVersion = 6;
	}
}};
dojo.flash.Embed = function (visible) {
	this._visible = visible;
};
dojo.flash.Embed.prototype = {width:215, height:138, id:"flashObject", _visible:true, protocol:function () {
	switch (window.location.protocol) {
	  case "https:":
		return "https";
		break;
	  default:
		return "http";
		break;
	}
}, write:function (flashVer, doExpressInstall) {
	if (dojo.lang.isUndefined(doExpressInstall)) {
		doExpressInstall = false;
	}
	var containerStyle = new dojo.string.Builder();
	containerStyle.append("width: " + this.width + "px; ");
	containerStyle.append("height: " + this.height + "px; ");
	if (this._visible == false) {
		containerStyle.append("position: absolute; ");
		containerStyle.append("z-index: 10000; ");
		containerStyle.append("top: -1000px; ");
		containerStyle.append("left: -1000px; ");
	}
	containerStyle = containerStyle.toString();
	var objectHTML;
	var swfloc;
	if (flashVer == 6) {
		swfloc = dojo.flash.flash6_version;
		var dojoPath = djConfig.baseRelativePath;
		swfloc = swfloc + "?baseRelativePath=" + escape(dojoPath);
		objectHTML = "<embed id=\"" + this.id + "\" src=\"" + swfloc + "\" " + "	quality=\"high\" bgcolor=\"#ffffff\" " + "	width=\"" + this.width + "\" height=\"" + this.height + "\" " + "	name=\"" + this.id + "\" " + "	align=\"middle\" allowScriptAccess=\"sameDomain\" " + "	type=\"application/x-shockwave-flash\" swLiveConnect=\"true\" " + "	pluginspage=\"" + this.protocol() + "://www.macromedia.com/go/getflashplayer\">";
	} else {
		swfloc = dojo.flash.flash8_version;
		var swflocObject = swfloc;
		var swflocEmbed = swfloc;
		var dojoPath = djConfig.baseRelativePath;
		if (doExpressInstall) {
			var redirectURL = escape(window.location);
			document.title = document.title.slice(0, 47) + " - Flash Player Installation";
			var docTitle = escape(document.title);
			swflocObject += "?MMredirectURL=" + redirectURL + "&MMplayerType=ActiveX" + "&MMdoctitle=" + docTitle + "&baseRelativePath=" + escape(dojoPath);
			swflocEmbed += "?MMredirectURL=" + redirectURL + "&MMplayerType=PlugIn" + "&baseRelativePath=" + escape(dojoPath);
		}
		if (swflocEmbed.indexOf("?") == -1) {
			swflocEmbed += "?baseRelativePath=" + escape(dojoPath) + "' ";
		}
		objectHTML = "<object classid=\"clsid:d27cdb6e-ae6d-11cf-96b8-444553540000\" " + "codebase=\"" + this.protocol() + "://fpdownload.macromedia.com/pub/shockwave/cabs/flash/" + "swflash.cab#version=8,0,0,0\" " + "width=\"" + this.width + "\" " + "height=\"" + this.height + "\" " + "id=\"" + this.id + "\" " + "align=\"middle\"> " + "<param name=\"allowScriptAccess\" value=\"sameDomain\" /> " + "<param name=\"movie\" value=\"" + swflocObject + "\" /> " + "<param name=\"quality\" value=\"high\" /> " + "<param name=\"bgcolor\" value=\"#ffffff\" /> " + "<embed src=\"" + swflocEmbed + "' " + "quality=\"high\" " + "bgcolor=\"#ffffff\" " + "width=\"" + this.width + "\" " + "height=\"" + this.height + "\" " + "id=\"" + this.id + "\" " + "name=\"" + this.id + "\" " + "swLiveConnect=\"true\" " + "align=\"middle\" " + "allowScriptAccess=\"sameDomain\" " + "type=\"application/x-shockwave-flash\" " + "pluginspage=\"" + this.protocol() + "://www.macromedia.com/go/getflashplayer\" />" + "</object>";
	}
	objectHTML = "<div id=\"" + this.id + "Container\" style=\"" + containerStyle + "\"> " + objectHTML + "</div>";
	document.writeln(objectHTML);
}, get:function () {
	return document.getElementById(this.id);
}, setVisible:function (visible) {
	var container = dojo.byId(this.id + "Container");
	if (visible == true) {
		container.style.visibility = "visible";
	} else {
		container.style.position = "absolute";
		container.style.x = "-1000px";
		container.style.y = "-1000px";
		container.style.visibility = "hidden";
	}
}, center:function () {
	var elementWidth = this.width;
	var elementHeight = this.height;
	var scroll_offset = dojo.html.getScroll().offset;
	var viewport_size = dojo.html.getViewport();
	var x = scroll_offset.x + (viewport_size.width - elementWidth) / 2;
	var y = scroll_offset.y + (viewport_size.height - elementHeight) / 2;
	var container = dojo.byId(this.id + "Container");
	container.style.top = y + "px";
	container.style.left = x + "px";
}};
dojo.flash.Communicator = function () {
	if (dojo.flash.useFlash6()) {
		this._writeFlash6();
	} else {
		if (dojo.flash.useFlash8()) {
			this._writeFlash8();
		}
	}
};
dojo.flash.Communicator.prototype = {_writeFlash6:function () {
	var id = dojo.flash.obj.id;
	document.writeln("<script language=\"JavaScript\">");
	document.writeln("  function " + id + "_DoFSCommand(command, args){ ");
	document.writeln("	dojo.flash.comm._handleFSCommand(command, args); ");
	document.writeln("}");
	document.writeln("</script>");
	if (dojo.render.html.ie) {
		document.writeln("<SCRIPT LANGUAGE=VBScript> ");
		document.writeln("on error resume next ");
		document.writeln("Sub " + id + "_FSCommand(ByVal command, ByVal args)");
		document.writeln(" call " + id + "_DoFSCommand(command, args)");
		document.writeln("end sub");
		document.writeln("</SCRIPT> ");
	}
}, _writeFlash8:function () {
}, _handleFSCommand:function (command, args) {
	if (command != null && !dojo.lang.isUndefined(command) && /^FSCommand:(.*)/.test(command) == true) {
		command = command.match(/^FSCommand:(.*)/)[1];
	}
	if (command == "addCallback") {
		this._fscommandAddCallback(command, args);
	} else {
		if (command == "call") {
			this._fscommandCall(command, args);
		} else {
			if (command == "fscommandReady") {
				this._fscommandReady();
			}
		}
	}
}, _fscommandAddCallback:function (command, args) {
	var functionName = args;
	var callFunc = function () {
		return dojo.flash.comm._call(functionName, arguments);
	};
	dojo.flash.comm[functionName] = callFunc;
	dojo.flash.obj.get().SetVariable("_succeeded", true);
}, _fscommandCall:function (command, args) {
	var plugin = dojo.flash.obj.get();
	var functionName = args;
	var numArgs = parseInt(plugin.GetVariable("_numArgs"));
	var flashArgs = new Array();
	for (var i = 0; i < numArgs; i++) {
		var currentArg = plugin.GetVariable("_" + i);
		flashArgs.push(currentArg);
	}
	var runMe;
	if (functionName.indexOf(".") == -1) {
		runMe = window[functionName];
	} else {
		runMe = eval(functionName);
	}
	var results = null;
	if (!dojo.lang.isUndefined(runMe) && runMe != null) {
		results = runMe.apply(null, flashArgs);
	}
	plugin.SetVariable("_returnResult", results);
}, _fscommandReady:function () {
	var plugin = dojo.flash.obj.get();
	plugin.SetVariable("fscommandReady", "true");
}, _call:function (functionName, args) {
	var plugin = dojo.flash.obj.get();
	plugin.SetVariable("_functionName", functionName);
	plugin.SetVariable("_numArgs", args.length);
	for (var i = 0; i < args.length; i++) {
		var value = args[i];
		value = value.replace(/\0/g, "\\0");
		plugin.SetVariable("_" + i, value);
	}
	plugin.TCallLabel("/_flashRunner", "execute");
	var results = plugin.GetVariable("_returnResult");
	results = results.replace(/\\0/g, "\x00");
	return results;
}, _addExternalInterfaceCallback:function (methodName) {
	var wrapperCall = function () {
		var methodArgs = new Array(arguments.length);
		for (var i = 0; i < arguments.length; i++) {
			methodArgs[i] = arguments[i];
		}
		return dojo.flash.comm._execFlash(methodName, methodArgs);
	};
	dojo.flash.comm[methodName] = wrapperCall;
}, _encodeData:function (data) {
	var entityRE = /\&([^;]*)\;/g;
	data = data.replace(entityRE, "&amp;$1;");
	data = data.replace(/</g, "&lt;");
	data = data.replace(/>/g, "&gt;");
	data = data.replace("\\", "&custom_backslash;&custom_backslash;");
	data = data.replace(/\n/g, "\\n");
	data = data.replace(/\r/g, "\\r");
	data = data.replace(/\f/g, "\\f");
	data = data.replace(/\0/g, "\\0");
	data = data.replace(/\'/g, "\\'");
	data = data.replace(/\"/g, "\\\"");
	return data;
}, _decodeData:function (data) {
	if (data == null || typeof data == "undefined") {
		return data;
	}
	data = data.replace(/\&custom_lt\;/g, "<");
	data = data.replace(/\&custom_gt\;/g, ">");
	data = eval("\"" + data + "\"");
	return data;
}, _chunkArgumentData:function (value, argIndex) {
	var plugin = dojo.flash.obj.get();
	var numSegments = Math.ceil(value.length / 1024);
	for (var i = 0; i < numSegments; i++) {
		var startCut = i * 1024;
		var endCut = i * 1024 + 1024;
		if (i == (numSegments - 1)) {
			endCut = i * 1024 + value.length;
		}
		var piece = value.substring(startCut, endCut);
		piece = this._encodeData(piece);
		plugin.CallFunction("<invoke name=\"chunkArgumentData\" " + "returntype=\"javascript\">" + "<arguments>" + "<string>" + piece + "</string>" + "<number>" + argIndex + "</number>" + "</arguments>" + "</invoke>");
	}
}, _chunkReturnData:function () {
	var plugin = dojo.flash.obj.get();
	var numSegments = plugin.getReturnLength();
	var resultsArray = new Array();
	for (var i = 0; i < numSegments; i++) {
		var piece = plugin.CallFunction("<invoke name=\"chunkReturnData\" " + "returntype=\"javascript\">" + "<arguments>" + "<number>" + i + "</number>" + "</arguments>" + "</invoke>");
		if (piece == "\"\"" || piece == "''") {
			piece = "";
		} else {
			piece = piece.substring(1, piece.length - 1);
		}
		resultsArray.push(piece);
	}
	var results = resultsArray.join("");
	return results;
}, _execFlash:function (methodName, methodArgs) {
	var plugin = dojo.flash.obj.get();
	plugin.startExec();
	plugin.setNumberArguments(methodArgs.length);
	for (var i = 0; i < methodArgs.length; i++) {
		this._chunkArgumentData(methodArgs[i], i);
	}
	plugin.exec(methodName);
	var results = this._chunkReturnData();
	results = this._decodeData(results);
	plugin.endExec();
	return results;
}};
dojo.flash.Install = function () {
};
dojo.flash.Install.prototype = {needed:function () {
	if (dojo.flash.info.capable == false) {
		return true;
	}
	if (dojo.render.os.mac == true && !dojo.flash.info.isVersionOrAbove(8, 0, 0)) {
		return true;
	}
	if (!dojo.flash.info.isVersionOrAbove(6, 0, 0)) {
		return true;
	}
	return false;
}, install:function () {
	dojo.flash.info.installing = true;
	dojo.flash.installing();
	if (dojo.flash.info.capable == false) {
		var installObj = new dojo.flash.Embed(false);
		installObj.write(8);
	} else {
		if (dojo.flash.info.isVersionOrAbove(6, 0, 65)) {
			var installObj = new dojo.flash.Embed(false);
			installObj.write(8, true);
			installObj.setVisible(true);
			installObj.center();
		} else {
			alert("This content requires a more recent version of the Macromedia " + " Flash Player.");
			window.location.href = +dojo.flash.Embed.protocol() + "://www.macromedia.com/go/getflashplayer";
		}
	}
}, _onInstallStatus:function (msg) {
	if (msg == "Download.Complete") {
		dojo.flash._initialize();
	} else {
		if (msg == "Download.Cancelled") {
			alert("This content requires a more recent version of the Macromedia " + " Flash Player.");
			window.location.href = dojo.flash.Embed.protocol() + "://www.macromedia.com/go/getflashplayer";
		} else {
			if (msg == "Download.Failed") {
				alert("There was an error downloading the Flash Player update. " + "Please try again later, or visit macromedia.com to download " + "the latest version of the Flash plugin.");
			}
		}
	}
}};
dojo.flash.info = new dojo.flash.Info();


__CPAN_DIR__ src/rpc
__CPAN_FILE__ src/rpc/Deferred.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.rpc.Deferred");
dojo.require("dojo.Deferred");
dojo.deprecated("dojo.rpc.Deferred", "replaced by dojo.Deferred", "0.6");
dojo.rpc.Deferred = dojo.Deferred;
dojo.rpc.Deferred.prototype = dojo.Deferred.prototype;


__CPAN_FILE__ src/rpc/YahooService.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.rpc.YahooService");
dojo.require("dojo.rpc.RpcService");
dojo.require("dojo.rpc.JsonService");
dojo.require("dojo.json");
dojo.require("dojo.uri.*");
dojo.require("dojo.io.ScriptSrcIO");
dojo.rpc.YahooService = function (appId) {
	this.appId = appId;
	if (!appId) {
		this.appId = "dojotoolkit";
		dojo.debug("please initialize the YahooService class with your own", "application ID. Using the default may cause problems during", "deployment of your application");
	}
	if (djConfig["useXDomain"] && !djConfig["yahooServiceSmdUrl"]) {
		dojo.debug("dojo.rpc.YahooService: When using cross-domain Dojo builds," + " please save yahoo.smd to your domain and set djConfig.yahooServiceSmdUrl" + " to the path on your domain to yahoo.smd");
	}
	this.connect(djConfig["yahooServiceSmdUrl"] || dojo.uri.moduleUri("dojo.rpc", "yahoo.smd"));
	this.strictArgChecks = false;
};
dojo.inherits(dojo.rpc.YahooService, dojo.rpc.JsonService);
dojo.lang.extend(dojo.rpc.YahooService, {strictArgChecks:false, bind:function (method, parameters, deferredRequestHandler, url) {
	var params = parameters;
	if ((dojo.lang.isArrayLike(parameters)) && (parameters.length == 1)) {
		params = parameters[0];
	}
	params.output = "json";
	params.appid = this.appId;
	dojo.io.bind({url:url || this.serviceUrl, transport:"ScriptSrcTransport", content:params, jsonParamName:"callback", mimetype:"text/json", load:this.resultCallback(deferredRequestHandler), error:this.errorCallback(deferredRequestHandler), preventCache:true});
}});


__CPAN_FILE__ src/rpc/yahoo.smd
{
	"SMDVersion":".1",
	"objectName":"yahoo",
	"serviceType":"JSON-P",
	"methods":[
		//
		// MAPS 
		//
		{
			// http://developer.yahoo.com/maps/rest/V1/mapImage.html
			"name":"mapImage",
			"serviceURL": "http://api.local.yahoo.com/MapsService/V1/mapImage",
			"parameters":[
				{ "name":"street", "type":"STRING" },
				{ "name":"city", "type":"STRING" },
				{ "name":"zip", "type":"INTEGER" },
				{ "name":"location", "type":"STRING" },
				{ "name":"longitude", "type":"FLOAT" },
				{ "name":"latitude", "type":"FLOAT" },
				{ "name":"image_type", "type":"STRING" },
				{ "name":"image_width", "type":"INTEGER" },
				{ "name":"image_height", "type":"INTEGER" },
				{ "name":"zoom", "type":"INTEGER" },
				{ "name":"radius", "type":"INTEGER" }
			]
		},
		{
			// http://developer.yahoo.com/traffic/rest/V1/index.html
			"name":"trafficData",
			"serviceURL": "http://api.local.yahoo.com/MapsService/V1/trafficData",
			"parameters":[
				{ "name":"street", "type":"STRING" },
				{ "name":"city", "type":"STRING" },
				{ "name":"zip", "type":"INTEGER" },
				{ "name":"location", "type":"STRING" },
				{ "name":"longitude", "type":"FLOAT" },
				{ "name":"latitude", "type":"FLOAT" },
				{ "name":"severity", "type":"INTEGER" },
				{ "name":"include_map", "type":"INTEGER" },
				{ "name":"image_type", "type":"STRING" },
				{ "name":"image_width", "type":"INTEGER" },
				{ "name":"image_height", "type":"INTEGER" },
				{ "name":"zoom", "type":"INTEGER" },
				{ "name":"radius", "type":"INTEGER" }
			]
		},
		/*
			// Yahoo's geocoding service is f'd for JSON and Y! advises that it
			// may not be returning
		{
			// http://developer.yahoo.com/maps/rest/V1/geocode.html
			"name":"geocode",
			"serviceURL": "http://api.local.yahoo.com/MapsService/V1/geocode",
			"parameters":[
				{ "name":"street", "type":"STRING" },
				{ "name":"city", "type":"STRING" },
				{ "name":"zip", "type":"INTEGER" },
				{ "name":"location", "type":"STRING" }
			]
		},
		*/
		//
		// LOCAL SEARCH
		//
		{
			// http://developer.yahoo.com/search/local/V3/localSearch.html
			"name":"localSearch",
			"serviceURL": "http://api.local.yahoo.com/LocalSearchService/V3/localSearch",
			"parameters":[
				{ "name":"street", "type":"STRING" },
				{ "name":"city", "type":"STRING" },
				{ "name":"zip", "type":"INTEGER" },
				{ "name":"location", "type":"STRING" },
				{ "name":"listing_id", "type":"STRING" },
				{ "name":"sort", "type":"STRING" }, // "relevence", "title", "distance", or "rating"
				{ "name":"start", "type":"INTEGER" },
				{ "name":"radius", "type":"FLOAT" },
				{ "name":"results", "type":"INTEGER" }, // 1-50, defaults to 10
				{ "name":"longitude", "type":"FLOAT" },
				{ "name":"latitude", "type":"FLOAT" },
				{ "name":"category", "type":"INTEGER" },
				{ "name":"omit_category", "type":"INTEGER" },
				{ "name":"minimum_rating", "type":"INTEGER" }
			]
		},
		//
		// WEB SEARCH
		//
		{
			// http://developer.yahoo.com/search/web/V1/webSearch.html 
			"name":"webSearch",
			"serviceURL": "http://api.search.yahoo.com/WebSearchService/V1/webSearch",
			"parameters":[
				{ "name":"query", "type":"STRING" },
				{ "name":"type", "type":"STRING" }, // defaults to "all"
				{ "name":"region", "type":"STRING" }, // defaults to "us"
				{ "name":"results", "type":"INTEGER" }, // defaults to 10
				{ "name":"start", "type":"INTEGER" }, // defaults to 1
				{ "name":"format", "type":"STRING" }, // defaults to "any", can be "html", "msword", "pdf", "ppt", "rst", "txt", or "xls"
				{ "name":"adult_ok", "type":"INTEGER" }, // defaults to null
				{ "name":"similar_ok", "type":"INTEGER" }, // defaults to null
				{ "name":"language", "type":"STRING" }, // defaults to null
				{ "name":"country", "type":"STRING" }, // defaults to null
				{ "name":"site", "type":"STRING" }, // defaults to null
				{ "name":"subscription", "type":"STRING" }, // defaults to null
				{ "name":"license", "type":"STRING" } // defaults to "any"
			]
		},
		{
			// http://developer.yahoo.com/search/web/V1/spellingSuggestion.html
			"name":"spellingSuggestion",
			"serviceURL": "http://api.search.yahoo.com/WebSearchService/V1/spellingSuggestion",
			"parameters":[ { "name":"query", "type":"STRING" } ]
		},
		{
			// http://developer.yahoo.com/search/web/V1/relatedSuggestion.html
			"name":"spellingSuggestion",
			"serviceURL": "http://api.search.yahoo.com/WebSearchService/V1/relatedSuggestion",
			"parameters":[
				{ "name":"query", "type":"STRING" },
				{ "name":"results", "type":"INTEGER" } // 1-50, defaults to 10
			]
		},
		{
			// http://developer.yahoo.com/search/content/V1/termExtraction.html
			"name":"termExtraction",
			"serviceURL": "http://search.yahooapis.com/ContentAnalysisService/V1/termExtraction",
			"parameters":[
				{ "name":"query", "type":"STRING" },
				{ "name":"context", "type":"STRING" },
				{ "name":"results", "type":"INTEGER" } // 1-50, defaults to 10
			]
		},
		{
			// http://developer.yahoo.com/search/web/V1/contextSearch.html
			"name":"contextSearch",
			"serviceURL": "http://search.yahooapis.com/WebSearchService/V1/contextSearch",
			"parameters":[
				{ "name":"query", "type":"STRING" },
				{ "name":"context", "type":"STRING" },
				{ "name":"type", "type":"STRING" }, // defaults to "all"
				{ "name":"results", "type":"INTEGER" }, // defaults to 10
				{ "name":"start", "type":"INTEGER" }, // defaults to 1
				{ "name":"format", "type":"STRING" }, // defaults to "any", can be "html", "msword", "pdf", "ppt", "rst", "txt", or "xls"
				{ "name":"adult_ok", "type":"INTEGER" }, // defaults to null
				{ "name":"similar_ok", "type":"INTEGER" }, // defaults to null
				{ "name":"language", "type":"STRING" }, // defaults to null
				{ "name":"country", "type":"STRING" }, // defaults to null
				{ "name":"site", "type":"STRING" }, // defaults to null
				{ "name":"license", "type":"STRING" } // defaults to "any", could be "cc_any", "cc_commercial", "cc_modifiable"
			]
		},
		//
		// IMAGE SEARCH
		//
		{
			// http://developer.yahoo.com/search/image/V1/imageSearch.html
			"name":"imageSearch",
			"serviceURL": "http://api.search.yahoo.com/ImageSearchService/V1/imageSearch",
			"parameters":[
				{ "name":"query", "type":"STRING" },
				{ "name":"type", "type":"STRING" }, // defaults to "all", can by "any" or "phrase"
				{ "name":"results", "type":"INTEGER" }, // defaults to 10
				{ "name":"start", "type":"INTEGER" }, // defaults to 1
				{ "name":"format", "type":"STRING" }, // defaults to "any", can be "bmp", "gif", "jpeg", or "png"
				{ "name":"adult_ok", "type":"INTEGER" }, // defaults to null
				{ "name":"coloration", "type":"STRING" }, // "any", "color", or "bw"
				{ "name":"site", "type":"STRING" } // defaults to null
			]
		},
		//
		// SITE EXPLORER
		//
		{
			// http://developer.yahoo.com/search/siteexplorer/V1/inlinkData.html 
			"name":"inlinkData",
			"serviceURL": "http://api.search.yahoo.com/SiteExplorerService/V1/inlinkData",
			"parameters":[
				{ "name":"query", "type":"STRING" },
				{ "name":"type", "type":"STRING" }, // defaults to "all", can by "any" or "phrase"
				{ "name":"entire_site", "type":"INTEGER" }, // defaults to null
				{ "name":"omit_inlinks", "type":"STRING" }, // "domain" or "subdomain", defaults to null
				{ "name":"results", "type":"INTEGER" }, // defaults to 50
				{ "name":"start", "type":"INTEGER" }, // defaults to 1
				{ "name":"site", "type":"STRING" } // defaults to null
			]
		},
		{
			// http://developer.yahoo.com/search/siteexplorer/V1/pageData.html
			"name":"pageData",
			"serviceURL": "http://api.search.yahoo.com/SiteExplorerService/V1/pageData",
			"parameters":[
				{ "name":"query", "type":"STRING" },
				{ "name":"type", "type":"STRING" }, // defaults to "all", can by "any" or "phrase"
				{ "name":"domain_only", "type":"INTEGER" }, // defaults to null
				{ "name":"results", "type":"INTEGER" }, // defaults to 50
				{ "name":"start", "type":"INTEGER" }, // defaults to 1
				{ "name":"site", "type":"STRING" } // defaults to null
			]
		},
		//
		// MUSIC SEARCH
		//
		{
			// http://developer.yahoo.com/search/audio/V1/artistSearch.html
			"name":"artistSearch",
			"serviceURL": "http://api.search.yahoo.com/AudioSearchService/V1/artistSearch",
			"parameters":[
				{ "name":"artist", "type":"STRING" },
				{ "name":"artistid", "type":"STRING" },
				{ "name":"type", "type":"STRING" }, // "all", "any", or "phrase"
				{ "name":"results", "type":"INTEGER" }, // 1-50, defaults to 10
				{ "name":"start", "type":"INTEGER" } // defaults to 1
			]
		},
		{
			// http://developer.yahoo.com/search/audio/V1/albumSearch.html
			"name":"albumSearch",
			"serviceURL": "http://api.search.yahoo.com/AudioSearchService/V1/albumSearch",
			"parameters":[
				{ "name":"artist", "type":"STRING" },
				{ "name":"artistid", "type":"STRING" },
				{ "name":"album", "type":"STRING" },
				{ "name":"type", "type":"STRING" }, // "all", "any", or "phrase"
				{ "name":"results", "type":"INTEGER" }, // 1-50, defaults to 10
				{ "name":"start", "type":"INTEGER" } // defaults to 1
			]
		},
		{
			// http://developer.yahoo.com/search/audio/V1/songSearch.html
			"name":"songSearch",
			"serviceURL": "http://api.search.yahoo.com/AudioSearchService/V1/songSearch",
			"parameters":[
				{ "name":"artist", "type":"STRING" },
				{ "name":"artistid", "type":"STRING" },
				{ "name":"album", "type":"STRING" },
				{ "name":"albumid", "type":"STRING" },
				{ "name":"song", "type":"STRING" },
				{ "name":"songid", "type":"STRING" },
				{ "name":"type", "type":"STRING" }, // "all", "any", or "phrase"
				{ "name":"results", "type":"INTEGER" }, // 1-50, defaults to 10
				{ "name":"start", "type":"INTEGER" } // defaults to 1
			]
		},
		{
			// http://developer.yahoo.com/search/audio/V1/songDownloadLocation.html
			"name":"songDownloadLocation",
			"serviceURL": "http://api.search.yahoo.com/AudioSearchService/V1/songDownloadLocation",
			"parameters":[
				{ "name":"songid", "type":"STRING" },
				// "source" can contain:
				//	audiolunchbox artistdirect buymusic dmusic
				//	emusic epitonic garageband itunes yahoo
				//	livedownloads mp34u msn musicmatch mapster passalong
				//	rhapsody soundclick theweb
				{ "name":"source", "type":"STRING" },
				{ "name":"results", "type":"INTEGER" }, // 1-50, defaults to 10
				{ "name":"start", "type":"INTEGER" } // defaults to 1
			]
		},
		//
		// NEWS SEARCH
		//
		{
			// http://developer.yahoo.com/search/news/V1/newsSearch.html
			"name":"newsSearch",
			"serviceURL": "http://api.search.yahoo.com/NewsSearchService/V1/newsSearch",
			"parameters":[
				{ "name":"query", "type":"STRING" },
				{ "name":"type", "type":"STRING" }, // defaults to "all"
				{ "name":"results", "type":"INTEGER" }, // defaults to 10
				{ "name":"start", "type":"INTEGER" }, // defaults to 1
				{ "name":"sort", "type":"STRING" }, // "rank" or "date"
				{ "name":"language", "type":"STRING" }, // defaults to null
				{ "name":"site", "type":"STRING" } // defaults to null
			]
		}
		/*
		{
			// 
			"name":"",
			"serviceURL": "",
			"parameters":[
				{ "name":"street", "type":"STRING" },
			]
		}
		*/
	]
}

__CPAN_FILE__ src/rpc/RpcService.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.rpc.RpcService");
dojo.require("dojo.io.*");
dojo.require("dojo.json");
dojo.require("dojo.lang.func");
dojo.require("dojo.Deferred");
dojo.rpc.RpcService = function (url) {
	if (url) {
		this.connect(url);
	}
};
dojo.lang.extend(dojo.rpc.RpcService, {strictArgChecks:true, serviceUrl:"", parseResults:function (obj) {
	return obj;
}, errorCallback:function (deferredRequestHandler) {
	return function (type, e) {
		deferredRequestHandler.errback(new Error(e.message));
	};
}, resultCallback:function (deferredRequestHandler) {
	var tf = dojo.lang.hitch(this, function (type, obj, e) {
		if (obj["error"] != null) {
			var err = new Error(obj.error);
			err.id = obj.id;
			deferredRequestHandler.errback(err);
		} else {
			var results = this.parseResults(obj);
			deferredRequestHandler.callback(results);
		}
	});
	return tf;
}, generateMethod:function (method, parameters, url) {
	return dojo.lang.hitch(this, function () {
		var deferredRequestHandler = new dojo.Deferred();
		if ((this.strictArgChecks) && (parameters != null) && (arguments.length != parameters.length)) {
			dojo.raise("Invalid number of parameters for remote method.");
		} else {
			this.bind(method, arguments, deferredRequestHandler, url);
		}
		return deferredRequestHandler;
	});
}, processSmd:function (object) {
	dojo.debug("RpcService: Processing returned SMD.");
	if (object.methods) {
		dojo.lang.forEach(object.methods, function (m) {
			if (m && m["name"]) {
				dojo.debug("RpcService: Creating Method: this.", m.name, "()");
				this[m.name] = this.generateMethod(m.name, m.parameters, m["url"] || m["serviceUrl"] || m["serviceURL"]);
				if (dojo.lang.isFunction(this[m.name])) {
					dojo.debug("RpcService: Successfully created", m.name, "()");
				} else {
					dojo.debug("RpcService: Failed to create", m.name, "()");
				}
			}
		}, this);
	}
	this.serviceUrl = object.serviceUrl || object.serviceURL;
	dojo.debug("RpcService: Dojo RpcService is ready for use.");
}, connect:function (smdUrl) {
	dojo.debug("RpcService: Attempting to load SMD document from:", smdUrl);
	dojo.io.bind({url:smdUrl, mimetype:"text/json", load:dojo.lang.hitch(this, function (type, object, e) {
		return this.processSmd(object);
	}), sync:true});
}});


__CPAN_FILE__ src/rpc/__package__.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.kwCompoundRequire({common:[["dojo.rpc.JsonService", false, false]]});
dojo.provide("dojo.rpc.*");


__CPAN_FILE__ src/rpc/JotService.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.rpc.JotService");
dojo.require("dojo.rpc.RpcService");
dojo.require("dojo.rpc.JsonService");
dojo.require("dojo.json");
dojo.rpc.JotService = function () {
	this.serviceUrl = "/_/jsonrpc";
};
dojo.inherits(dojo.rpc.JotService, dojo.rpc.JsonService);
dojo.lang.extend(dojo.rpc.JotService, {bind:function (method, parameters, deferredRequestHandler, url) {
	dojo.io.bind({url:url || this.serviceUrl, content:{json:this.createRequest(method, parameters)}, method:"POST", mimetype:"text/json", load:this.resultCallback(deferredRequestHandler), error:this.errorCallback(deferredRequestHandler), preventCache:true});
}, createRequest:function (method, params) {
	var req = {"params":params, "method":method, "id":this.lastSubmissionId++};
	return dojo.json.serialize(req);
}});


__CPAN_FILE__ src/rpc/JsonService.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.rpc.JsonService");
dojo.require("dojo.rpc.RpcService");
dojo.require("dojo.io.*");
dojo.require("dojo.json");
dojo.require("dojo.lang.common");
dojo.rpc.JsonService = function (args) {
	if (args) {
		if (dojo.lang.isString(args)) {
			this.connect(args);
		} else {
			if (args["smdUrl"]) {
				this.connect(args.smdUrl);
			}
			if (args["smdStr"]) {
				this.processSmd(dj_eval("(" + args.smdStr + ")"));
			}
			if (args["smdObj"]) {
				this.processSmd(args.smdObj);
			}
			if (args["serviceUrl"]) {
				this.serviceUrl = args.serviceUrl;
			}
			if (typeof args["strictArgChecks"] != "undefined") {
				this.strictArgChecks = args.strictArgChecks;
			}
		}
	}
};
dojo.inherits(dojo.rpc.JsonService, dojo.rpc.RpcService);
dojo.extend(dojo.rpc.JsonService, {bustCache:false, contentType:"application/json-rpc", lastSubmissionId:0, callRemote:function (method, params) {
	var deferred = new dojo.Deferred();
	this.bind(method, params, deferred);
	return deferred;
}, bind:function (method, parameters, deferredRequestHandler, url) {
	dojo.io.bind({url:url || this.serviceUrl, postContent:this.createRequest(method, parameters), method:"POST", contentType:this.contentType, mimetype:"text/json", load:this.resultCallback(deferredRequestHandler), error:this.errorCallback(deferredRequestHandler), preventCache:this.bustCache});
}, createRequest:function (method, params) {
	var req = {"params":params, "method":method, "id":++this.lastSubmissionId};
	var data = dojo.json.serialize(req);
	dojo.debug("JsonService: JSON-RPC Request: " + data);
	return data;
}, parseResults:function (obj) {
	if (!obj) {
		return;
	}
	if (obj["Result"] != null) {
		return obj["Result"];
	} else {
		if (obj["result"] != null) {
			return obj["result"];
		} else {
			if (obj["ResultSet"]) {
				return obj["ResultSet"];
			} else {
				return obj;
			}
		}
	}
}});


__CPAN_DIR__ src/validate
__CPAN_FILE__ src/validate/common.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.validate.common");
dojo.require("dojo.regexp");
dojo.validate.isText = function (value, flags) {
	flags = (typeof flags == "object") ? flags : {};
	if (/^\s*$/.test(value)) {
		return false;
	}
	if (typeof flags.length == "number" && flags.length != value.length) {
		return false;
	}
	if (typeof flags.minlength == "number" && flags.minlength > value.length) {
		return false;
	}
	if (typeof flags.maxlength == "number" && flags.maxlength < value.length) {
		return false;
	}
	return true;
};
dojo.validate.isInteger = function (value, flags) {
	var re = new RegExp("^" + dojo.regexp.integer(flags) + "$");
	return re.test(value);
};
dojo.validate.isRealNumber = function (value, flags) {
	var re = new RegExp("^" + dojo.regexp.realNumber(flags) + "$");
	return re.test(value);
};
dojo.validate.isCurrency = function (value, flags) {
	var re = new RegExp("^" + dojo.regexp.currency(flags) + "$");
	return re.test(value);
};
dojo.validate._isInRangeCache = {};
dojo.validate.isInRange = function (value, flags) {
	value = value.replace(dojo.lang.has(flags, "separator") ? flags.separator : ",", "", "g").replace(dojo.lang.has(flags, "symbol") ? flags.symbol : "$", "");
	if (isNaN(value)) {
		return false;
	}
	flags = (typeof flags == "object") ? flags : {};
	var max = (typeof flags.max == "number") ? flags.max : Infinity;
	var min = (typeof flags.min == "number") ? flags.min : -Infinity;
	var dec = (typeof flags.decimal == "string") ? flags.decimal : ".";
	var cache = dojo.validate._isInRangeCache;
	var cacheIdx = value + "max" + max + "min" + min + "dec" + dec;
	if (typeof cache[cacheIdx] != "undefined") {
		return cache[cacheIdx];
	}
	var pattern = "[^" + dec + "\\deE+-]";
	value = value.replace(RegExp(pattern, "g"), "");
	value = value.replace(/^([+-]?)(\D*)/, "$1");
	value = value.replace(/(\D*)$/, "");
	pattern = "(\\d)[" + dec + "](\\d)";
	value = value.replace(RegExp(pattern, "g"), "$1.$2");
	value = Number(value);
	if (value < min || value > max) {
		cache[cacheIdx] = false;
		return false;
	}
	cache[cacheIdx] = true;
	return true;
};
dojo.validate.isNumberFormat = function (value, flags) {
	var re = new RegExp("^" + dojo.regexp.numberFormat(flags) + "$", "i");
	return re.test(value);
};
dojo.validate.isValidLuhn = function (value) {
	var sum, parity, curDigit;
	if (typeof value != "string") {
		value = String(value);
	}
	value = value.replace(/[- ]/g, "");
	parity = value.length % 2;
	sum = 0;
	for (var i = 0; i < value.length; i++) {
		curDigit = parseInt(value.charAt(i));
		if (i % 2 == parity) {
			curDigit *= 2;
		}
		if (curDigit > 9) {
			curDigit -= 9;
		}
		sum += curDigit;
	}
	return !(sum % 10);
};


__CPAN_FILE__ src/validate/us.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.validate.us");
dojo.require("dojo.validate.common");
dojo.validate.us.isCurrency = function (value, flags) {
	return dojo.validate.isCurrency(value, flags);
};
dojo.validate.us.isState = function (value, flags) {
	var re = new RegExp("^" + dojo.regexp.us.state(flags) + "$", "i");
	return re.test(value);
};
dojo.validate.us.isPhoneNumber = function (value) {
	var flags = {format:["###-###-####", "(###) ###-####", "(###) ### ####", "###.###.####", "###/###-####", "### ### ####", "###-###-#### x#???", "(###) ###-#### x#???", "(###) ### #### x#???", "###.###.#### x#???", "###/###-#### x#???", "### ### #### x#???", "##########"]};
	return dojo.validate.isNumberFormat(value, flags);
};
dojo.validate.us.isSocialSecurityNumber = function (value) {
	var flags = {format:["###-##-####", "### ## ####", "#########"]};
	return dojo.validate.isNumberFormat(value, flags);
};
dojo.validate.us.isZipCode = function (value) {
	var flags = {format:["#####-####", "##### ####", "#########", "#####"]};
	return dojo.validate.isNumberFormat(value, flags);
};


__CPAN_FILE__ src/validate/de.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.validate.de");
dojo.require("dojo.validate.common");
dojo.validate.isGermanCurrency = function (value) {
	var flags = {symbol:"\u20ac", placement:"after", signPlacement:"begin", decimal:",", separator:"."};
	return dojo.validate.isCurrency(value, flags);
};


__CPAN_FILE__ src/validate/jp.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.validate.jp");
dojo.require("dojo.validate.common");
dojo.validate.isJapaneseCurrency = function (value) {
	var flags = {symbol:"\xa5", fractional:false};
	return dojo.validate.isCurrency(value, flags);
};


__CPAN_FILE__ src/validate/__package__.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.require("dojo.validate");
dojo.kwCompoundRequire({common:["dojo.validate.check", "dojo.validate.datetime", "dojo.validate.de", "dojo.validate.jp", "dojo.validate.us", "dojo.validate.web"]});
dojo.provide("dojo.validate.*");


__CPAN_FILE__ src/validate/datetime.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.validate.datetime");
dojo.require("dojo.validate.common");
dojo.validate.isValidTime = function (value, flags) {
	dojo.deprecated("dojo.validate.datetime", "use dojo.date.parse instead", "0.5");
	var re = new RegExp("^" + dojo.regexp.time(flags) + "$", "i");
	return re.test(value);
};
dojo.validate.is12HourTime = function (value) {
	dojo.deprecated("dojo.validate.datetime", "use dojo.date.parse instead", "0.5");
	return dojo.validate.isValidTime(value, {format:["h:mm:ss t", "h:mm t"]});
};
dojo.validate.is24HourTime = function (value) {
	dojo.deprecated("dojo.validate.datetime", "use dojo.date.parse instead", "0.5");
	return dojo.validate.isValidTime(value, {format:["HH:mm:ss", "HH:mm"]});
};
dojo.validate.isValidDate = function (dateValue, format) {
	dojo.deprecated("dojo.validate.datetime", "use dojo.date.parse instead", "0.5");
	if (typeof format == "object" && typeof format.format == "string") {
		format = format.format;
	}
	if (typeof format != "string") {
		format = "MM/DD/YYYY";
	}
	var reLiteral = format.replace(/([$^.*+?=!:|\/\\\(\)\[\]\{\}])/g, "\\$1");
	reLiteral = reLiteral.replace("YYYY", "([0-9]{4})");
	reLiteral = reLiteral.replace("MM", "(0[1-9]|10|11|12)");
	reLiteral = reLiteral.replace("M", "([1-9]|10|11|12)");
	reLiteral = reLiteral.replace("DDD", "(00[1-9]|0[1-9][0-9]|[12][0-9][0-9]|3[0-5][0-9]|36[0-6])");
	reLiteral = reLiteral.replace("DD", "(0[1-9]|[12][0-9]|30|31)");
	reLiteral = reLiteral.replace("D", "([1-9]|[12][0-9]|30|31)");
	reLiteral = reLiteral.replace("ww", "(0[1-9]|[1-4][0-9]|5[0-3])");
	reLiteral = reLiteral.replace("d", "([1-7])");
	reLiteral = "^" + reLiteral + "$";
	var re = new RegExp(reLiteral);
	if (!re.test(dateValue)) {
		return false;
	}
	var year = 0, month = 1, date = 1, dayofyear = 1, week = 1, day = 1;
	var tokens = format.match(/(YYYY|MM|M|DDD|DD|D|ww|d)/g);
	var values = re.exec(dateValue);
	for (var i = 0; i < tokens.length; i++) {
		switch (tokens[i]) {
		  case "YYYY":
			year = Number(values[i + 1]);
			break;
		  case "M":
		  case "MM":
			month = Number(values[i + 1]);
			break;
		  case "D":
		  case "DD":
			date = Number(values[i + 1]);
			break;
		  case "DDD":
			dayofyear = Number(values[i + 1]);
			break;
		  case "ww":
			week = Number(values[i + 1]);
			break;
		  case "d":
			day = Number(values[i + 1]);
			break;
		}
	}
	var leapyear = (year % 4 == 0 && (year % 100 != 0 || year % 400 == 0));
	if (date == 31 && (month == 4 || month == 6 || month == 9 || month == 11)) {
		return false;
	}
	if (date >= 30 && month == 2) {
		return false;
	}
	if (date == 29 && month == 2 && !leapyear) {
		return false;
	}
	if (dayofyear == 366 && !leapyear) {
		return false;
	}
	return true;
};


__CPAN_FILE__ src/validate/web.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.validate.web");
dojo.require("dojo.validate.common");
dojo.validate.isIpAddress = function (value, flags) {
	var re = new RegExp("^" + dojo.regexp.ipAddress(flags) + "$", "i");
	return re.test(value);
};
dojo.validate.isUrl = function (value, flags) {
	var re = new RegExp("^" + dojo.regexp.url(flags) + "$", "i");
	return re.test(value);
};
dojo.validate.isEmailAddress = function (value, flags) {
	var re = new RegExp("^" + dojo.regexp.emailAddress(flags) + "$", "i");
	return re.test(value);
};
dojo.validate.isEmailAddressList = function (value, flags) {
	var re = new RegExp("^" + dojo.regexp.emailAddressList(flags) + "$", "i");
	return re.test(value);
};
dojo.validate.getEmailAddressList = function (value, flags) {
	if (!flags) {
		flags = {};
	}
	if (!flags.listSeparator) {
		flags.listSeparator = "\\s;,";
	}
	if (dojo.validate.isEmailAddressList(value, flags)) {
		return value.split(new RegExp("\\s*[" + flags.listSeparator + "]\\s*"));
	}
	return [];
};


__CPAN_FILE__ src/validate/creditCard.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.validate.creditCard");
dojo.require("dojo.lang.common");
dojo.require("dojo.validate.common");
dojo.validate.isValidCreditCard = function (value, ccType) {
	if (value && ccType && ((ccType.toLowerCase() == "er" || dojo.validate.isValidLuhn(value)) && (dojo.validate.isValidCreditCardNumber(value, ccType.toLowerCase())))) {
		return true;
	}
	return false;
};
dojo.validate.isValidCreditCardNumber = function (value, ccType) {
	if (typeof value != "string") {
		value = String(value);
	}
	value = value.replace(/[- ]/g, "");
	var results = [];
	var cardinfo = {"mc":"5[1-5][0-9]{14}", "ec":"5[1-5][0-9]{14}", "vi":"4([0-9]{12}|[0-9]{15})", "ax":"3[47][0-9]{13}", "dc":"3(0[0-5][0-9]{11}|[68][0-9]{12})", "bl":"3(0[0-5][0-9]{11}|[68][0-9]{12})", "di":"6011[0-9]{12}", "jcb":"(3[0-9]{15}|(2131|1800)[0-9]{11})", "er":"2(014|149)[0-9]{11}"};
	if (ccType && dojo.lang.has(cardinfo, ccType.toLowerCase())) {
		return Boolean(value.match(cardinfo[ccType.toLowerCase()]));
	} else {
		for (var p in cardinfo) {
			if (value.match("^" + cardinfo[p] + "$") != null) {
				results.push(p);
			}
		}
		return (results.length) ? results.join("|") : false;
	}
};
dojo.validate.isValidCvv = function (value, ccType) {
	if (typeof value != "string") {
		value = String(value);
	}
	var format;
	switch (ccType.toLowerCase()) {
	  case "mc":
	  case "ec":
	  case "vi":
	  case "di":
		format = "###";
		break;
	  case "ax":
		format = "####";
		break;
	  default:
		return false;
	}
	var flags = {format:format};
	if ((value.length == format.length) && (dojo.validate.isNumberFormat(value, flags))) {
		return true;
	}
	return false;
};


__CPAN_FILE__ src/validate/check.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.validate.check");
dojo.require("dojo.validate.common");
dojo.require("dojo.lang.common");
dojo.validate.check = function (form, profile) {
	var missing = [];
	var invalid = [];
	var results = {isSuccessful:function () {
		return (!this.hasInvalid() && !this.hasMissing());
	}, hasMissing:function () {
		return (missing.length > 0);
	}, getMissing:function () {
		return missing;
	}, isMissing:function (elemname) {
		for (var i = 0; i < missing.length; i++) {
			if (elemname == missing[i]) {
				return true;
			}
		}
		return false;
	}, hasInvalid:function () {
		return (invalid.length > 0);
	}, getInvalid:function () {
		return invalid;
	}, isInvalid:function (elemname) {
		for (var i = 0; i < invalid.length; i++) {
			if (elemname == invalid[i]) {
				return true;
			}
		}
		return false;
	}};
	if (profile.trim instanceof Array) {
		for (var i = 0; i < profile.trim.length; i++) {
			var elem = form[profile.trim[i]];
			if (dj_undef("type", elem) || elem.type != "text" && elem.type != "textarea" && elem.type != "password") {
				continue;
			}
			elem.value = elem.value.replace(/(^\s*|\s*$)/g, "");
		}
	}
	if (profile.uppercase instanceof Array) {
		for (var i = 0; i < profile.uppercase.length; i++) {
			var elem = form[profile.uppercase[i]];
			if (dj_undef("type", elem) || elem.type != "text" && elem.type != "textarea" && elem.type != "password") {
				continue;
			}
			elem.value = elem.value.toUpperCase();
		}
	}
	if (profile.lowercase instanceof Array) {
		for (var i = 0; i < profile.lowercase.length; i++) {
			var elem = form[profile.lowercase[i]];
			if (dj_undef("type", elem) || elem.type != "text" && elem.type != "textarea" && elem.type != "password") {
				continue;
			}
			elem.value = elem.value.toLowerCase();
		}
	}
	if (profile.ucfirst instanceof Array) {
		for (var i = 0; i < profile.ucfirst.length; i++) {
			var elem = form[profile.ucfirst[i]];
			if (dj_undef("type", elem) || elem.type != "text" && elem.type != "textarea" && elem.type != "password") {
				continue;
			}
			elem.value = elem.value.replace(/\b\w+\b/g, function (word) {
				return word.substring(0, 1).toUpperCase() + word.substring(1).toLowerCase();
			});
		}
	}
	if (profile.digit instanceof Array) {
		for (var i = 0; i < profile.digit.length; i++) {
			var elem = form[profile.digit[i]];
			if (dj_undef("type", elem) || elem.type != "text" && elem.type != "textarea" && elem.type != "password") {
				continue;
			}
			elem.value = elem.value.replace(/\D/g, "");
		}
	}
	if (profile.required instanceof Array) {
		for (var i = 0; i < profile.required.length; i++) {
			if (!dojo.lang.isString(profile.required[i])) {
				continue;
			}
			var elem = form[profile.required[i]];
			if (!dj_undef("type", elem) && (elem.type == "text" || elem.type == "textarea" || elem.type == "password") && /^\s*$/.test(elem.value)) {
				missing[missing.length] = elem.name;
			} else {
				if (!dj_undef("type", elem) && (elem.type == "select-one" || elem.type == "select-multiple") && (elem.selectedIndex == -1 || /^\s*$/.test(elem.options[elem.selectedIndex].value))) {
					missing[missing.length] = elem.name;
				} else {
					if (elem instanceof Array) {
						var checked = false;
						for (var j = 0; j < elem.length; j++) {
							if (elem[j].checked) {
								checked = true;
							}
						}
						if (!checked) {
							missing[missing.length] = elem[0].name;
						}
					}
				}
			}
		}
	}
	if (profile.required instanceof Array) {
		for (var i = 0; i < profile.required.length; i++) {
			if (!dojo.lang.isObject(profile.required[i])) {
				continue;
			}
			var elem, numRequired;
			for (var name in profile.required[i]) {
				elem = form[name];
				numRequired = profile.required[i][name];
			}
			if (elem instanceof Array) {
				var checked = 0;
				for (var j = 0; j < elem.length; j++) {
					if (elem[j].checked) {
						checked++;
					}
				}
				if (checked < numRequired) {
					missing[missing.length] = elem[0].name;
				}
			} else {
				if (!dj_undef("type", elem) && elem.type == "select-multiple") {
					var selected = 0;
					for (var j = 0; j < elem.options.length; j++) {
						if (elem.options[j].selected && !/^\s*$/.test(elem.options[j].value)) {
							selected++;
						}
					}
					if (selected < numRequired) {
						missing[missing.length] = elem.name;
					}
				}
			}
		}
	}
	if (dojo.lang.isObject(profile.dependencies) || dojo.lang.isObject(profile.dependancies)) {
		if (profile["dependancies"]) {
			dojo.deprecated("dojo.validate.check", "profile 'dependancies' is deprecated, please use " + "'dependencies'", "0.5");
			profile.dependencies = profile.dependancies;
		}
		for (name in profile.dependencies) {
			var elem = form[name];
			if (dj_undef("type", elem)) {
				continue;
			}
			if (elem.type != "text" && elem.type != "textarea" && elem.type != "password") {
				continue;
			}
			if (/\S+/.test(elem.value)) {
				continue;
			}
			if (results.isMissing(elem.name)) {
				continue;
			}
			var target = form[profile.dependencies[name]];
			if (target.type != "text" && target.type != "textarea" && target.type != "password") {
				continue;
			}
			if (/^\s*$/.test(target.value)) {
				continue;
			}
			missing[missing.length] = elem.name;
		}
	}
	if (dojo.lang.isObject(profile.constraints)) {
		for (name in profile.constraints) {
			var elem = form[name];
			if (!elem) {
				continue;
			}
			if (!dj_undef("tagName", elem) && (elem.tagName.toLowerCase().indexOf("input") >= 0 || elem.tagName.toLowerCase().indexOf("textarea") >= 0) && /^\s*$/.test(elem.value)) {
				continue;
			}
			var isValid = true;
			if (dojo.lang.isFunction(profile.constraints[name])) {
				isValid = profile.constraints[name](elem.value);
			} else {
				if (dojo.lang.isArray(profile.constraints[name])) {
					if (dojo.lang.isArray(profile.constraints[name][0])) {
						for (var i = 0; i < profile.constraints[name].length; i++) {
							isValid = dojo.validate.evaluateConstraint(profile, profile.constraints[name][i], name, elem);
							if (!isValid) {
								break;
							}
						}
					} else {
						isValid = dojo.validate.evaluateConstraint(profile, profile.constraints[name], name, elem);
					}
				}
			}
			if (!isValid) {
				invalid[invalid.length] = elem.name;
			}
		}
	}
	if (dojo.lang.isObject(profile.confirm)) {
		for (name in profile.confirm) {
			var elem = form[name];
			var target = form[profile.confirm[name]];
			if (dj_undef("type", elem) || dj_undef("type", target) || (elem.type != "text" && elem.type != "textarea" && elem.type != "password") || (target.type != elem.type) || (target.value == elem.value) || (results.isInvalid(elem.name)) || (/^\s*$/.test(target.value))) {
				continue;
			}
			invalid[invalid.length] = elem.name;
		}
	}
	return results;
};
dojo.validate.evaluateConstraint = function (profile, constraint, fieldName, elem) {
	var isValidSomething = constraint[0];
	var params = constraint.slice(1);
	params.unshift(elem.value);
	if (typeof isValidSomething != "undefined") {
		return isValidSomething.apply(null, params);
	}
	return false;
};


__CPAN_DIR__ src/animation
__CPAN_FILE__ src/animation/Timer.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.animation.Timer");
dojo.require("dojo.lang.timing.Timer");
dojo.deprecated("dojo.animation.Timer is now dojo.lang.timing.Timer", "0.5");
dojo.animation.Timer = dojo.lang.timing.Timer;


__CPAN_FILE__ src/animation/Animation.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.animation.Animation");
dojo.require("dojo.animation.AnimationEvent");
dojo.require("dojo.lang.func");
dojo.require("dojo.math");
dojo.require("dojo.math.curves");
dojo.deprecated("dojo.animation.Animation is slated for removal in 0.5; use dojo.lfx.* instead.", "0.5");
dojo.animation.Animation = function (curve, duration, accel, repeatCount, rate) {
	if (dojo.lang.isArray(curve)) {
		curve = new dojo.math.curves.Line(curve[0], curve[1]);
	}
	this.curve = curve;
	this.duration = duration;
	this.repeatCount = repeatCount || 0;
	this.rate = rate || 25;
	if (accel) {
		if (dojo.lang.isFunction(accel.getValue)) {
			this.accel = accel;
		} else {
			var i = 0.35 * accel + 0.5;
			this.accel = new dojo.math.curves.CatmullRom([[0], [i], [1]], 0.45);
		}
	}
};
dojo.lang.extend(dojo.animation.Animation, {curve:null, duration:0, repeatCount:0, accel:null, onBegin:null, onAnimate:null, onEnd:null, onPlay:null, onPause:null, onStop:null, handler:null, _animSequence:null, _startTime:null, _endTime:null, _lastFrame:null, _timer:null, _percent:0, _active:false, _paused:false, _startRepeatCount:0, play:function (gotoStart) {
	if (gotoStart) {
		clearTimeout(this._timer);
		this._active = false;
		this._paused = false;
		this._percent = 0;
	} else {
		if (this._active && !this._paused) {
			return;
		}
	}
	this._startTime = new Date().valueOf();
	if (this._paused) {
		this._startTime -= (this.duration * this._percent / 100);
	}
	this._endTime = this._startTime + this.duration;
	this._lastFrame = this._startTime;
	var e = new dojo.animation.AnimationEvent(this, null, this.curve.getValue(this._percent), this._startTime, this._startTime, this._endTime, this.duration, this._percent, 0);
	this._active = true;
	this._paused = false;
	if (this._percent == 0) {
		if (!this._startRepeatCount) {
			this._startRepeatCount = this.repeatCount;
		}
		e.type = "begin";
		if (typeof this.handler == "function") {
			this.handler(e);
		}
		if (typeof this.onBegin == "function") {
			this.onBegin(e);
		}
	}
	e.type = "play";
	if (typeof this.handler == "function") {
		this.handler(e);
	}
	if (typeof this.onPlay == "function") {
		this.onPlay(e);
	}
	if (this._animSequence) {
		this._animSequence._setCurrent(this);
	}
	this._cycle();
}, pause:function () {
	clearTimeout(this._timer);
	if (!this._active) {
		return;
	}
	this._paused = true;
	var e = new dojo.animation.AnimationEvent(this, "pause", this.curve.getValue(this._percent), this._startTime, new Date().valueOf(), this._endTime, this.duration, this._percent, 0);
	if (typeof this.handler == "function") {
		this.handler(e);
	}
	if (typeof this.onPause == "function") {
		this.onPause(e);
	}
}, playPause:function () {
	if (!this._active || this._paused) {
		this.play();
	} else {
		this.pause();
	}
}, gotoPercent:function (pct, andPlay) {
	clearTimeout(this._timer);
	this._active = true;
	this._paused = true;
	this._percent = pct;
	if (andPlay) {
		this.play();
	}
}, stop:function (gotoEnd) {
	clearTimeout(this._timer);
	var step = this._percent / 100;
	if (gotoEnd) {
		step = 1;
	}
	var e = new dojo.animation.AnimationEvent(this, "stop", this.curve.getValue(step), this._startTime, new Date().valueOf(), this._endTime, this.duration, this._percent);
	if (typeof this.handler == "function") {
		this.handler(e);
	}
	if (typeof this.onStop == "function") {
		this.onStop(e);
	}
	this._active = false;
	this._paused = false;
}, status:function () {
	if (this._active) {
		return this._paused ? "paused" : "playing";
	} else {
		return "stopped";
	}
}, _cycle:function () {
	clearTimeout(this._timer);
	if (this._active) {
		var curr = new Date().valueOf();
		var step = (curr - this._startTime) / (this._endTime - this._startTime);
		var fps = 1000 / (curr - this._lastFrame);
		this._lastFrame = curr;
		if (step >= 1) {
			step = 1;
			this._percent = 100;
		} else {
			this._percent = step * 100;
		}
		if (this.accel && this.accel.getValue) {
			step = this.accel.getValue(step);
		}
		var e = new dojo.animation.AnimationEvent(this, "animate", this.curve.getValue(step), this._startTime, curr, this._endTime, this.duration, this._percent, Math.round(fps));
		if (typeof this.handler == "function") {
			this.handler(e);
		}
		if (typeof this.onAnimate == "function") {
			this.onAnimate(e);
		}
		if (step < 1) {
			this._timer = setTimeout(dojo.lang.hitch(this, "_cycle"), this.rate);
		} else {
			e.type = "end";
			this._active = false;
			if (typeof this.handler == "function") {
				this.handler(e);
			}
			if (typeof this.onEnd == "function") {
				this.onEnd(e);
			}
			if (this.repeatCount > 0) {
				this.repeatCount--;
				this.play(true);
			} else {
				if (this.repeatCount == -1) {
					this.play(true);
				} else {
					if (this._startRepeatCount) {
						this.repeatCount = this._startRepeatCount;
						this._startRepeatCount = 0;
					}
					if (this._animSequence) {
						this._animSequence._playNext();
					}
				}
			}
		}
	}
}});


__CPAN_FILE__ src/animation/__package__.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.kwCompoundRequire({common:["dojo.animation.AnimationEvent", "dojo.animation.Animation", "dojo.animation.AnimationSequence"]});
dojo.provide("dojo.animation.*");
dojo.deprecated("dojo.Animation.* is slated for removal in 0.5; use dojo.lfx.* instead.", "0.5");


__CPAN_FILE__ src/animation/AnimationSequence.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.animation.AnimationSequence");
dojo.require("dojo.animation.AnimationEvent");
dojo.require("dojo.animation.Animation");
dojo.deprecated("dojo.animation.AnimationSequence is slated for removal in 0.5; use dojo.lfx.* instead.", "0.5");
dojo.animation.AnimationSequence = function (repeatCount) {
	this._anims = [];
	this.repeatCount = repeatCount || 0;
};
dojo.lang.extend(dojo.animation.AnimationSequence, {repeatCount:0, _anims:[], _currAnim:-1, onBegin:null, onEnd:null, onNext:null, handler:null, add:function () {
	for (var i = 0; i < arguments.length; i++) {
		this._anims.push(arguments[i]);
		arguments[i]._animSequence = this;
	}
}, remove:function (anim) {
	for (var i = 0; i < this._anims.length; i++) {
		if (this._anims[i] == anim) {
			this._anims[i]._animSequence = null;
			this._anims.splice(i, 1);
			break;
		}
	}
}, removeAll:function () {
	for (var i = 0; i < this._anims.length; i++) {
		this._anims[i]._animSequence = null;
	}
	this._anims = [];
	this._currAnim = -1;
}, clear:function () {
	this.removeAll();
}, play:function (gotoStart) {
	if (this._anims.length == 0) {
		return;
	}
	if (gotoStart || !this._anims[this._currAnim]) {
		this._currAnim = 0;
	}
	if (this._anims[this._currAnim]) {
		if (this._currAnim == 0) {
			var e = {type:"begin", animation:this._anims[this._currAnim]};
			if (typeof this.handler == "function") {
				this.handler(e);
			}
			if (typeof this.onBegin == "function") {
				this.onBegin(e);
			}
		}
		this._anims[this._currAnim].play(gotoStart);
	}
}, pause:function () {
	if (this._anims[this._currAnim]) {
		this._anims[this._currAnim].pause();
	}
}, playPause:function () {
	if (this._anims.length == 0) {
		return;
	}
	if (this._currAnim == -1) {
		this._currAnim = 0;
	}
	if (this._anims[this._currAnim]) {
		this._anims[this._currAnim].playPause();
	}
}, stop:function () {
	if (this._anims[this._currAnim]) {
		this._anims[this._currAnim].stop();
	}
}, status:function () {
	if (this._anims[this._currAnim]) {
		return this._anims[this._currAnim].status();
	} else {
		return "stopped";
	}
}, _setCurrent:function (anim) {
	for (var i = 0; i < this._anims.length; i++) {
		if (this._anims[i] == anim) {
			this._currAnim = i;
			break;
		}
	}
}, _playNext:function () {
	if (this._currAnim == -1 || this._anims.length == 0) {
		return;
	}
	this._currAnim++;
	if (this._anims[this._currAnim]) {
		var e = {type:"next", animation:this._anims[this._currAnim]};
		if (typeof this.handler == "function") {
			this.handler(e);
		}
		if (typeof this.onNext == "function") {
			this.onNext(e);
		}
		this._anims[this._currAnim].play(true);
	} else {
		var e = {type:"end", animation:this._anims[this._anims.length - 1]};
		if (typeof this.handler == "function") {
			this.handler(e);
		}
		if (typeof this.onEnd == "function") {
			this.onEnd(e);
		}
		if (this.repeatCount > 0) {
			this._currAnim = 0;
			this.repeatCount--;
			this._anims[this._currAnim].play(true);
		} else {
			if (this.repeatCount == -1) {
				this._currAnim = 0;
				this._anims[this._currAnim].play(true);
			} else {
				this._currAnim = -1;
			}
		}
	}
}});


__CPAN_FILE__ src/animation/AnimationEvent.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.animation.AnimationEvent");
dojo.require("dojo.lang.common");
dojo.deprecated("dojo.animation.AnimationEvent is slated for removal in 0.5; use dojo.lfx.* instead.", "0.5");
dojo.animation.AnimationEvent = function (animation, type, coords, startTime, currentTime, endTime, duration, percent, fps) {
	this.type = type;
	this.animation = animation;
	this.coords = coords;
	this.x = coords[0];
	this.y = coords[1];
	this.z = coords[2];
	this.startTime = startTime;
	this.currentTime = currentTime;
	this.endTime = endTime;
	this.duration = duration;
	this.percent = percent;
	this.fps = fps;
};
dojo.extend(dojo.animation.AnimationEvent, {coordsAsInts:function () {
	var cints = new Array(this.coords.length);
	for (var i = 0; i < this.coords.length; i++) {
		cints[i] = Math.round(this.coords[i]);
	}
	return cints;
}});


__CPAN_DIR__ src/debug
__CPAN_FILE__ src/debug/arrow_show.gif
GIF89a	 	  !/=)5*6$.",%4DZgt(8H&6F8HXAP_'3TaofrDSb*;Lhtq|,8!/<p|#1@#.(4                     !   ,    	 	  " QbYFYBbjrTR`"5%0W ;
__CPAN_FILE__ src/debug/spacer.gif
GIF89a	 	  @@@   gԈ0Ԉ*  2     P   $0  2  H   L  2  H   $h82         dtu꼐xqu!    p   u,     p  @      $                       @(H        p p,     tH(            @2              悰  @2S`@    H\Qm       鄑QH    頑QHm     D    0    PԈ   0    l       @   HQ8mHr8H  qՆ  `x     pm	     đ	     b  b                PHDpm     Hr8H  hHHP \ pDHccEH  Hr8H       pltHH  悰  !   ,    	 	   H*\p`@ ;
__CPAN_FILE__ src/debug/Firebug.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.debug.Firebug");
dojo.deprecated("dojo.debug.Firebug is slated for removal in 0.5; use dojo.debug.console instead.", "0.5");
if (dojo.render.html.moz) {
	if (console && console.log) {
		var consoleLog = function () {
			if (!djConfig.isDebug) {
				return;
			}
			var args = dojo.lang.toArray(arguments);
			args.splice(0, 0, "DEBUG: ");
			console.log.apply(console, args);
		};
		dojo.debug = consoleLog;
		dojo.debugDeep = consoleLog;
		dojo.debugShallow = function (obj) {
			if (!djConfig.isDebug) {
				return;
			}
			if (dojo.lang.isArray(obj)) {
				console.log("Array: ", obj);
				for (var i = 0; x < obj.length; i++) {
					console.log("	", "[" + i + "]", obj[i]);
				}
			} else {
				console.log("Object: ", obj);
				var propNames = [];
				for (var prop in obj) {
					propNames.push(prop);
				}
				propNames.sort();
				dojo.lang.forEach(propNames, function (prop) {
					try {
						console.log("	", prop, obj[prop]);
					}
					catch (e) {
						console.log("	", prop, "ERROR", e.message, e);
					}
				});
			}
		};
	} else {
		dojo.debug("dojo.debug.Firebug requires Firebug > 0.4");
	}
}


__CPAN_FILE__ src/debug/arrow_hide.gif
GIF89a	 	  )6'7H):K!/=)5%4C$/,9DSb%0)&5EO]kJXg;K[)9J )8HX .;$3Bdp|]jw                           !   ,    	 	   %d9VU1LVDO1c0IDRɢ! ;
__CPAN_FILE__ src/debug/console.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.debug.console");
dojo.require("dojo.logging.ConsoleLogger");
if (window.console) {
	if (console.info != null) {
		dojo.hostenv.println = function () {
			if (!djConfig.isDebug) {
				return;
			}
			console.info.apply(console, arguments);
		};
		dojo.debug = dojo.hostenv.println;
		dojo.debugDeep = dojo.debug;
		dojo.debugShallow = function (obj, showMethods, sort) {
			if (!djConfig.isDebug) {
				return;
			}
			showMethods = (showMethods != false);
			sort = (sort != false);
			if (obj == null || obj.constructor == null) {
				return dojo.debug(obj);
			}
			var type = obj.declaredClass;
			if (type == null) {
				type = obj.constructor.toString().match(/function\s*(.*)\(/);
				if (type) {
					type = type[1];
				}
			}
			if (type) {
				if (type == "String" || type == "Number") {
					return dojo.debug(type + ": ", obj);
				}
				if (showMethods && !sort) {
					var sortedObj = obj;
				} else {
					var propNames = [];
					if (showMethods) {
						for (var prop in obj) {
							propNames.push(prop);
						}
					} else {
						for (var prop in obj) {
							if (typeof obj[prop] != "function") {
								propNames.push(prop);
							} else {
								dojo.debug(prop);
							}
						}
					}
					if (sort) {
						propNames.sort();
					}
					var sortedObj = {};
					dojo.lang.forEach(propNames, function (prop) {
						sortedObj[prop] = obj[prop];
					});
				}
				return dojo.debug(type + ": %o\n%2.o", obj, sortedObj);
			}
			return dojo.debug(obj.constructor + ": ", obj);
		};
	} else {
		if (console.log != null) {
			dojo.hostenv.println = function () {
				if (!djConfig.isDebug) {
					return;
				}
				var args = dojo.lang.toArray(arguments);
				console.log("DEBUG: " + args.join(" "));
			};
			dojo.debug = dojo.hostenv.println;
		} else {
			dojo.debug("dojo.debug.console requires Firebug > 0.4");
		}
	}
} else {
	if (dojo.render.html.opera) {
		if (opera && opera.postError) {
			dojo.hostenv.println = opera.postError;
		} else {
			dojo.debug("dojo.debug.Opera requires Opera > 8.0");
		}
	}
}


__CPAN_FILE__ src/debug/deep.html
<html>
<head>
<title>Deep Debugger</title>
<script>

var tableRows = {};
var tableCels = {};
var tableObjs = {};
var tablesBuilt = {};
var tableShows = {};
var tableHides = {};

// IE: nodes w/id need to be redeclared or getElementById is b0rked
var frame = null;

window.onload = function(){
	// if IE loads this page too quickly (instantly) then 
	// window.debugVar might not have been set
	window.setTimeout(startMeUp, 100);
}

function startMeUp(){
	frame = document.getElementById('frame');
	// GET string 
	var index = location.search.split("=").pop();
	var debugObj = window.opener.dojo.debugDeep;
	var debugVar = debugObj.debugVars[index] || window.debugVar;
	buildTable('root', frame, debugVar);
}

function buildTable(path, parent, obj){
	var keys = [];
	var vals = [];
	for(var prop in obj){
		keys.push(prop);
		try {
			vals[prop] = obj[prop];
		} catch(E) {
			vals[prop] = 'ERROR: ' + E.message;
		}
	}
	keys.sort(keySorter);

	if (!keys.length){

		var div = document.createElement('div');
		div.appendChild(document.createTextNode('Object has no properties.'));

		parent.appendChild(div);
		return;
	}


	var t = document.createElement('table');
	t.border = "1";

	var tb = document.createElement('tbody');
	t.appendChild(tb);


	for(var i = 0; i < keys.length; i++) {
		buildTableRow(path+'-'+keys[i], tb, keys[i], vals[keys[i]]);
	}

	if (path == 'root'){
		//t.style.width = '90%';
	}
	t.style.width = '100%';

	parent.appendChild(t);

	tablesBuilt[path] = true;
}

function buildTableRow(path, tb, name, value) {

	var simpleType = typeof(value);
	var createSubrow = (simpleType == 'object');
	var complexType = simpleType;

	if (simpleType == 'object'){
		var cls = getConstructorClass(value);
		if (cls){
			if (cls == 'Object'){
			}else if (cls == 'Array'){
				complexType = 'array';
			}else{
				complexType += ' ('+cls+')';
			}
		}
	}

/*var tr1 = document.createElement('tr');
	var td1 = document.createElement('td');
	var td2 = document.createElement('td');
	var td3 = document.createElement('td');
	var td4 = document.createElement('td');*/

	var row = tb.rows.length;
	var tr1 = tb.insertRow(row++);
	var td1 = tr1.insertCell(0);
	var td2 = tr1.insertCell(1);
	var td3 = tr1.insertCell(2);
	var td4 = tr1.insertCell(3);
	
	tr1.style.verticalAlign = 'top';
	td1.style.verticalAlign = 'middle';

	td1.className = 'propPlus';
	td2.className = 'propName';
	td3.className = 'propType';
	td4.className = 'propVal';

	//tr1.appendChild(td1);
	//tr1.appendChild(td2);
	//tr1.appendChild(td3);
	//tr1.appendChild(td4);

	if (createSubrow){
		var img1 = document.createElement('img');
		img1.width = 9;
		img1.height = 9;
		img1.src = 'arrow_show.gif';
		var a1 = document.createElement('a');
		a1.appendChild(img1);
		a1.href = '#';
		a1.onclick = function(){ showTableRow(path); return false; };

		var img2 = document.createElement('img');
		img2.width = 9;
		img2.height = 9;
		img2.src = 'arrow_hide.gif';
		var a2 = document.createElement('a');
		a2.appendChild(img2);
		a2.href = '#';
		a2.onclick = function(){ hideTableRow(path); return false; };
		a2.style.display = 'none';

		tableShows[path] = a1;
		tableHides[path] = a2;

		td1.appendChild(a1);
		td1.appendChild(a2);
	}else{
		var img = document.createElement('img');
		img.width = 9;
		img.height = 9;
		img.src = 'spacer.gif';

		td1.appendChild(img);
	}

	td2.appendChild(document.createTextNode(name));
	td3.appendChild(document.createTextNode(complexType));
	td4.appendChild(buildPreBlock(value));

	//tb.appendChild(tr1);

	if (createSubrow){
		var tr2 = tb.insertRow(row++);
		var td5 = tr2.insertCell(0);
		var td6 = tr2.insertCell(1);
		
		//var tr2 = document.createElement('tr');
		//var td5 = document.createElement('td');
		//var td6 = document.createElement('td');

		td5.innerHTML = '&nbsp;';
		//td6.innerHTML = '&nbsp;';

		td6.colSpan = '3';

		tr2.appendChild(td5);
		tr2.appendChild(td6);

		tr2.style.display = 'none';

		tb.appendChild(tr2);

		tableRows[path] = tr2;
		tableCels[path] = td6;
		tableObjs[path] = value;
	}
}

function showTableRow(path){

	var tr = tableRows[path];
	var td = tableCels[path];
	var a1 = tableShows[path];
	var a2 = tableHides[path];

	if (!tablesBuilt[path]){

		//alert('building table for '+path);
		buildTable(path, td, tableObjs[path]);
	}

	tr.style.display = 'table-row';

	a1.style.display = 'none';
	a2.style.display = 'inline';
}

function hideTableRow(path){

	var tr = tableRows[path];
	var a1 = tableShows[path];
	var a2 = tableHides[path];

	tr.style.display = 'none';

	a1.style.display = 'inline';
	a2.style.display = 'none';
}

function buildPreBlock(value){

	//
	// how many lines ?
	//

	var s = ''+value;
	s = s.replace("\r\n", "\n");
	s = s.replace("\r", "");
	var lines = s.split("\n");


	if (lines.length < 2){

		if (lines[0].length < 60){

			var pre = document.createElement('pre');
			pre.appendChild(document.createTextNode(s));
			return pre;
		}
	}


	//
	// multiple lines :(
	//

	var preview = lines[0].substr(0, 60) + ' ...';

	var pre1 = document.createElement('pre');
	pre1.appendChild(document.createTextNode(preview));
	pre1.className = 'clicky';

	var pre2 = document.createElement('pre');
	pre2.appendChild(document.createTextNode(s));
	pre2.style.display = 'none';
	pre2.className = 'clicky';

	pre1.onclick = function(){
		pre1.style.display = 'none';
		pre2.style.display = 'block';
	}

	pre2.onclick = function(){
		pre1.style.display = 'block';
		pre2.style.display = 'none';
	}

	var pre = document.createElement('div');

	pre.appendChild(pre1);
	pre.appendChild(pre2);

	return pre;
}

function getConstructorClass(obj){

	if (!obj.constructor || !obj.constructor.toString) return;

	var m = obj.constructor.toString().match(/function\s*(\w+)/);

	if (m && m.length == 2) return m[1];

	return null;
}

function keySorter(a, b){

	if (a == parseInt(a) && b == parseInt(b)){

		return (parseInt(a) > parseInt(b)) ? 1 : ((parseInt(a) < parseInt(b)) ? -1 : 0);
	}

	// sort by lowercase string

	var a2 = String(a).toLowerCase();
	var b2 = String(b).toLowerCase();

	return (a2 > b2) ? 1 : ((a2 < b2) ? -1 : 0);
}

</script>
<style>

body {
	font-family: arial, helvetica, sans-serif;
}

table {
	border-width: 0px;
	border-spacing: 1px;
	border-collapse: separate;
}

td {
	border-width: 0px;
	padding: 2px;
}

img {
	border: 0;
}

pre {
	margin: 0;
	padding: 0;
	white-space: -moz-pre-wrap;  /* Mozilla, supported since 1999 */
	white-space: -pre-wrap;      /* Opera 4 - 6 */
	white-space: -o-pre-wrap;    /* Opera 7 */
	white-space: pre-wrap;       /* CSS3 - Text module (Candidate Recommendation) http://www.w3.org/TR/css3-text/#white-space */
	word-wrap: break-word;       /* IE 5.5+ */
}

pre.clicky {
	cursor: hand;
	cursor: pointer;
}

td.propPlus {
	width: 9px;
	background-color: #ddd;
}

td.propName {
	background-color: #ddd;
}

td.propType {
	background-color: #ddd;
}

td.propVal {
	background-color: #ddd;
}

</style>
</head>
<body>

<h2>Javascript Object Browser</h2>

<div id="frame"></div>

</body>
</html>
__CPAN_DIR__ src/selection
__CPAN_FILE__ src/selection/Selection.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.selection.Selection");
dojo.require("dojo.lang.array");
dojo.require("dojo.lang.func");
dojo.require("dojo.lang.common");
dojo.require("dojo.math");
dojo.declare("dojo.selection.Selection", null, {initializer:function (items, isCollection) {
	this.items = [];
	this.selection = [];
	this._pivotItems = [];
	this.clearItems();
	if (items) {
		if (isCollection) {
			this.setItemsCollection(items);
		} else {
			this.setItems(items);
		}
	}
}, items:null, selection:null, lastSelected:null, allowImplicit:true, length:0, isGrowable:true, _pivotItems:null, _pivotItem:null, onSelect:function (item) {
}, onDeselect:function (item) {
}, onSelectChange:function (item, selected) {
}, _find:function (item, inSelection) {
	if (inSelection) {
		return dojo.lang.find(this.selection, item);
	} else {
		return dojo.lang.find(this.items, item);
	}
}, isSelectable:function (item) {
	return true;
}, setItems:function () {
	this.clearItems();
	this.addItems.call(this, arguments);
}, setItemsCollection:function (collection) {
	this.items = collection;
}, addItems:function () {
	var args = dojo.lang.unnest(arguments);
	for (var i = 0; i < args.length; i++) {
		this.items.push(args[i]);
	}
}, addItemsAt:function (item, before) {
	if (this.items.length == 0) {
		return this.addItems(dojo.lang.toArray(arguments, 2));
	}
	if (!this.isItem(item)) {
		item = this.items[item];
	}
	if (!item) {
		throw new Error("addItemsAt: item doesn't exist");
	}
	var idx = this._find(item);
	if (idx > 0 && before) {
		idx--;
	}
	for (var i = 2; i < arguments.length; i++) {
		if (!this.isItem(arguments[i])) {
			this.items.splice(idx++, 0, arguments[i]);
		}
	}
}, removeItem:function (item) {
	var idx = this._find(item);
	if (idx > -1) {
		this.items.splice(idx, 1);
	}
	idx = this._find(item, true);
	if (idx > -1) {
		this.selection.splice(idx, 1);
	}
}, clearItems:function () {
	this.items = [];
	this.deselectAll();
}, isItem:function (item) {
	return this._find(item) > -1;
}, isSelected:function (item) {
	return this._find(item, true) > -1;
}, selectFilter:function (item, selection, add, grow) {
	return true;
}, update:function (item, add, grow, noToggle) {
	if (!this.isItem(item)) {
		return false;
	}
	if (this.isGrowable && grow) {
		if ((!this.isSelected(item)) && this.selectFilter(item, this.selection, false, true)) {
			this.grow(item);
			this.lastSelected = item;
		}
	} else {
		if (add) {
			if (this.selectFilter(item, this.selection, true, false)) {
				if (noToggle) {
					if (this.select(item)) {
						this.lastSelected = item;
					}
				} else {
					if (this.toggleSelected(item)) {
						this.lastSelected = item;
					}
				}
			}
		} else {
			this.deselectAll();
			this.select(item);
		}
	}
	this.length = this.selection.length;
	return true;
}, grow:function (toItem, fromItem) {
	if (!this.isGrowable) {
		return;
	}
	if (arguments.length == 1) {
		fromItem = this._pivotItem;
		if (!fromItem && this.allowImplicit) {
			fromItem = this.items[0];
		}
	}
	if (!toItem || !fromItem) {
		return false;
	}
	var fromIdx = this._find(fromItem);
	var toDeselect = {};
	var lastIdx = -1;
	if (this.lastSelected) {
		lastIdx = this._find(this.lastSelected);
		var step = fromIdx < lastIdx ? -1 : 1;
		var range = dojo.math.range(lastIdx, fromIdx, step);
		for (var i = 0; i < range.length; i++) {
			toDeselect[range[i]] = true;
		}
	}
	var toIdx = this._find(toItem);
	var step = fromIdx < toIdx ? -1 : 1;
	var shrink = lastIdx >= 0 && step == 1 ? lastIdx < toIdx : lastIdx > toIdx;
	var range = dojo.math.range(toIdx, fromIdx, step);
	if (range.length) {
		for (var i = range.length - 1; i >= 0; i--) {
			var item = this.items[range[i]];
			if (this.selectFilter(item, this.selection, false, true)) {
				if (this.select(item, true) || shrink) {
					this.lastSelected = item;
				}
				if (range[i] in toDeselect) {
					delete toDeselect[range[i]];
				}
			}
		}
	} else {
		this.lastSelected = fromItem;
	}
	for (var i in toDeselect) {
		if (this.items[i] == this.lastSelected) {
		}
		this.deselect(this.items[i]);
	}
	this._updatePivot();
}, growUp:function () {
	if (!this.isGrowable) {
		return;
	}
	var idx = this._find(this.lastSelected) - 1;
	while (idx >= 0) {
		if (this.selectFilter(this.items[idx], this.selection, false, true)) {
			this.grow(this.items[idx]);
			break;
		}
		idx--;
	}
}, growDown:function () {
	if (!this.isGrowable) {
		return;
	}
	var idx = this._find(this.lastSelected);
	if (idx < 0 && this.allowImplicit) {
		this.select(this.items[0]);
		idx = 0;
	}
	idx++;
	while (idx > 0 && idx < this.items.length) {
		if (this.selectFilter(this.items[idx], this.selection, false, true)) {
			this.grow(this.items[idx]);
			break;
		}
		idx++;
	}
}, toggleSelected:function (item, noPivot) {
	if (this.isItem(item)) {
		if (this.select(item, noPivot)) {
			return 1;
		}
		if (this.deselect(item)) {
			return -1;
		}
	}
	return 0;
}, select:function (item, noPivot) {
	if (this.isItem(item) && !this.isSelected(item) && this.isSelectable(item)) {
		this.selection.push(item);
		this.lastSelected = item;
		this.onSelect(item);
		this.onSelectChange(item, true);
		if (!noPivot) {
			this._addPivot(item);
		}
		this.length = this.selection.length;
		return true;
	}
	return false;
}, deselect:function (item) {
	var idx = this._find(item, true);
	if (idx > -1) {
		this.selection.splice(idx, 1);
		this.onDeselect(item);
		this.onSelectChange(item, false);
		if (item == this.lastSelected) {
			this.lastSelected = null;
		}
		this._removePivot(item);
		this.length = this.selection.length;
		return true;
	}
	return false;
}, selectAll:function () {
	for (var i = 0; i < this.items.length; i++) {
		this.select(this.items[i]);
	}
}, deselectAll:function () {
	while (this.selection && this.selection.length) {
		this.deselect(this.selection[0]);
	}
}, selectNext:function () {
	var idx = this._find(this.lastSelected);
	while (idx > -1 && ++idx < this.items.length) {
		if (this.isSelectable(this.items[idx])) {
			this.deselectAll();
			this.select(this.items[idx]);
			return true;
		}
	}
	return false;
}, selectPrevious:function () {
	var idx = this._find(this.lastSelected);
	while (idx-- > 0) {
		if (this.isSelectable(this.items[idx])) {
			this.deselectAll();
			this.select(this.items[idx]);
			return true;
		}
	}
	return false;
}, selectFirst:function () {
	this.deselectAll();
	var idx = 0;
	while (this.items[idx] && !this.select(this.items[idx])) {
		idx++;
	}
	return this.items[idx] ? true : false;
}, selectLast:function () {
	this.deselectAll();
	var idx = this.items.length - 1;
	while (this.items[idx] && !this.select(this.items[idx])) {
		idx--;
	}
	return this.items[idx] ? true : false;
}, _addPivot:function (item, andClear) {
	this._pivotItem = item;
	if (andClear) {
		this._pivotItems = [item];
	} else {
		this._pivotItems.push(item);
	}
}, _removePivot:function (item) {
	var i = dojo.lang.find(this._pivotItems, item);
	if (i > -1) {
		this._pivotItems.splice(i, 1);
		this._pivotItem = this._pivotItems[this._pivotItems.length - 1];
	}
	this._updatePivot();
}, _updatePivot:function () {
	if (this._pivotItems.length == 0) {
		if (this.lastSelected) {
			this._addPivot(this.lastSelected);
		}
	}
}, sorted:function () {
	return dojo.lang.toArray(this.selection).sort(dojo.lang.hitch(this, function (a, b) {
		var A = this._find(a), B = this._find(b);
		if (A > B) {
			return 1;
		} else {
			if (A < B) {
				return -1;
			} else {
				return 0;
			}
		}
	}));
}, updateSelected:function () {
	for (var i = 0; i < this.selection.length; i++) {
		if (this._find(this.selection[i]) < 0) {
			var removed = this.selection.splice(i, 1);
			this._removePivot(removed[0]);
		}
	}
	this.length = this.selection.length;
}});


__CPAN_DIR__ src/string
__CPAN_FILE__ src/string/common.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.string.common");
dojo.string.trim = function (str, wh) {
	if (!str.replace) {
		return str;
	}
	if (!str.length) {
		return str;
	}
	var re = (wh > 0) ? (/^\s+/) : (wh < 0) ? (/\s+$/) : (/^\s+|\s+$/g);
	return str.replace(re, "");
};
dojo.string.trimStart = function (str) {
	return dojo.string.trim(str, 1);
};
dojo.string.trimEnd = function (str) {
	return dojo.string.trim(str, -1);
};
dojo.string.repeat = function (str, count, separator) {
	var out = "";
	for (var i = 0; i < count; i++) {
		out += str;
		if (separator && i < count - 1) {
			out += separator;
		}
	}
	return out;
};
dojo.string.pad = function (str, len, c, dir) {
	var out = String(str);
	if (!c) {
		c = "0";
	}
	if (!dir) {
		dir = 1;
	}
	while (out.length < len) {
		if (dir > 0) {
			out = c + out;
		} else {
			out += c;
		}
	}
	return out;
};
dojo.string.padLeft = function (str, len, c) {
	return dojo.string.pad(str, len, c, 1);
};
dojo.string.padRight = function (str, len, c) {
	return dojo.string.pad(str, len, c, -1);
};


__CPAN_FILE__ src/string/Builder.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.string.Builder");
dojo.require("dojo.string");
dojo.require("dojo.lang.common");
dojo.string.Builder = function (str) {
	this.arrConcat = (dojo.render.html.capable && dojo.render.html["ie"]);
	var a = [];
	var b = "";
	var length = this.length = b.length;
	if (this.arrConcat) {
		if (b.length > 0) {
			a.push(b);
		}
		b = "";
	}
	this.toString = this.valueOf = function () {
		return (this.arrConcat) ? a.join("") : b;
	};
	this.append = function () {
		for (var x = 0; x < arguments.length; x++) {
			var s = arguments[x];
			if (dojo.lang.isArrayLike(s)) {
				this.append.apply(this, s);
			} else {
				if (this.arrConcat) {
					a.push(s);
				} else {
					b += s;
				}
				length += s.length;
				this.length = length;
			}
		}
		return this;
	};
	this.clear = function () {
		a = [];
		b = "";
		length = this.length = 0;
		return this;
	};
	this.remove = function (f, l) {
		var s = "";
		if (this.arrConcat) {
			b = a.join("");
		}
		a = [];
		if (f > 0) {
			s = b.substring(0, (f - 1));
		}
		b = s + b.substring(f + l);
		length = this.length = b.length;
		if (this.arrConcat) {
			a.push(b);
			b = "";
		}
		return this;
	};
	this.replace = function (o, n) {
		if (this.arrConcat) {
			b = a.join("");
		}
		a = [];
		b = b.replace(o, n);
		length = this.length = b.length;
		if (this.arrConcat) {
			a.push(b);
			b = "";
		}
		return this;
	};
	this.insert = function (idx, s) {
		if (this.arrConcat) {
			b = a.join("");
		}
		a = [];
		if (idx == 0) {
			b = s + b;
		} else {
			var t = b.split("");
			t.splice(idx, 0, s);
			b = t.join("");
		}
		length = this.length = b.length;
		if (this.arrConcat) {
			a.push(b);
			b = "";
		}
		return this;
	};
	this.append.apply(this, arguments);
};


__CPAN_FILE__ src/string/__package__.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.kwCompoundRequire({common:["dojo.string", "dojo.string.common", "dojo.string.extras", "dojo.string.Builder"]});
dojo.provide("dojo.string.*");


__CPAN_FILE__ src/string/extras.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.string.extras");
dojo.require("dojo.string.common");
dojo.require("dojo.lang.common");
dojo.require("dojo.lang.array");
dojo.string.substituteParams = function (template, hash) {
	var map = (typeof hash == "object") ? hash : dojo.lang.toArray(arguments, 1);
	return template.replace(/\%\{(\w+)\}/g, function (match, key) {
		if (typeof (map[key]) != "undefined" && map[key] != null) {
			return map[key];
		}
		dojo.raise("Substitution not found: " + key);
	});
};
dojo.string.capitalize = function (str) {
	if (!dojo.lang.isString(str)) {
		return "";
	}
	if (arguments.length == 0) {
		str = this;
	}
	var words = str.split(" ");
	for (var i = 0; i < words.length; i++) {
		words[i] = words[i].charAt(0).toUpperCase() + words[i].substring(1);
	}
	return words.join(" ");
};
dojo.string.isBlank = function (str) {
	if (!dojo.lang.isString(str)) {
		return true;
	}
	return (dojo.string.trim(str).length == 0);
};
dojo.string.encodeAscii = function (str) {
	if (!dojo.lang.isString(str)) {
		return str;
	}
	var ret = "";
	var value = escape(str);
	var match, re = /%u([0-9A-F]{4})/i;
	while ((match = value.match(re))) {
		var num = Number("0x" + match[1]);
		var newVal = escape("&#" + num + ";");
		ret += value.substring(0, match.index) + newVal;
		value = value.substring(match.index + match[0].length);
	}
	ret += value.replace(/\+/g, "%2B");
	return ret;
};
dojo.string.escape = function (type, str) {
	var args = dojo.lang.toArray(arguments, 1);
	switch (type.toLowerCase()) {
	  case "xml":
	  case "html":
	  case "xhtml":
		return dojo.string.escapeXml.apply(this, args);
	  case "sql":
		return dojo.string.escapeSql.apply(this, args);
	  case "regexp":
	  case "regex":
		return dojo.string.escapeRegExp.apply(this, args);
	  case "javascript":
	  case "jscript":
	  case "js":
		return dojo.string.escapeJavaScript.apply(this, args);
	  case "ascii":
		return dojo.string.encodeAscii.apply(this, args);
	  default:
		return str;
	}
};
dojo.string.escapeXml = function (str, noSingleQuotes) {
	str = str.replace(/&/gm, "&amp;").replace(/</gm, "&lt;").replace(/>/gm, "&gt;").replace(/"/gm, "&quot;");
	if (!noSingleQuotes) {
		str = str.replace(/'/gm, "&#39;");
	}
	return str;
};
dojo.string.escapeSql = function (str) {
	return str.replace(/'/gm, "''");
};
dojo.string.escapeRegExp = function (str) {
	return str.replace(/\\/gm, "\\\\").replace(/([\f\b\n\t\r[\^$|?*+(){}])/gm, "\\$1");
};
dojo.string.escapeJavaScript = function (str) {
	return str.replace(/(["'\f\b\n\t\r])/gm, "\\$1");
};
dojo.string.escapeString = function (str) {
	return ("\"" + str.replace(/(["\\])/g, "\\$1") + "\"").replace(/[\f]/g, "\\f").replace(/[\b]/g, "\\b").replace(/[\n]/g, "\\n").replace(/[\t]/g, "\\t").replace(/[\r]/g, "\\r");
};
dojo.string.summary = function (str, len) {
	if (!len || str.length <= len) {
		return str;
	}
	return str.substring(0, len).replace(/\.+$/, "") + "...";
};
dojo.string.endsWith = function (str, end, ignoreCase) {
	if (ignoreCase) {
		str = str.toLowerCase();
		end = end.toLowerCase();
	}
	if ((str.length - end.length) < 0) {
		return false;
	}
	return str.lastIndexOf(end) == str.length - end.length;
};
dojo.string.endsWithAny = function (str) {
	for (var i = 1; i < arguments.length; i++) {
		if (dojo.string.endsWith(str, arguments[i])) {
			return true;
		}
	}
	return false;
};
dojo.string.startsWith = function (str, start, ignoreCase) {
	if (ignoreCase) {
		str = str.toLowerCase();
		start = start.toLowerCase();
	}
	return str.indexOf(start) == 0;
};
dojo.string.startsWithAny = function (str) {
	for (var i = 1; i < arguments.length; i++) {
		if (dojo.string.startsWith(str, arguments[i])) {
			return true;
		}
	}
	return false;
};
dojo.string.has = function (str) {
	for (var i = 1; i < arguments.length; i++) {
		if (str.indexOf(arguments[i]) > -1) {
			return true;
		}
	}
	return false;
};
dojo.string.normalizeNewlines = function (text, newlineChar) {
	if (newlineChar == "\n") {
		text = text.replace(/\r\n/g, "\n");
		text = text.replace(/\r/g, "\n");
	} else {
		if (newlineChar == "\r") {
			text = text.replace(/\r\n/g, "\r");
			text = text.replace(/\n/g, "\r");
		} else {
			text = text.replace(/([^\r])\n/g, "$1\r\n").replace(/\r([^\n])/g, "\r\n$1");
		}
	}
	return text;
};
dojo.string.splitEscaped = function (str, charac) {
	var components = [];
	for (var i = 0, prevcomma = 0; i < str.length; i++) {
		if (str.charAt(i) == "\\") {
			i++;
			continue;
		}
		if (str.charAt(i) == charac) {
			components.push(str.substring(prevcomma, i));
			prevcomma = i + 1;
		}
	}
	components.push(str.substr(prevcomma));
	return components;
};


__CPAN_DIR__ src/html
__CPAN_FILE__ src/html/util.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.html.util");
dojo.require("dojo.html.layout");
dojo.html.getElementWindow = function (element) {
	return dojo.html.getDocumentWindow(element.ownerDocument);
};
dojo.html.getDocumentWindow = function (doc) {
	if (dojo.render.html.safari && !doc._parentWindow) {
		var fix = function (win) {
			win.document._parentWindow = win;
			for (var i = 0; i < win.frames.length; i++) {
				fix(win.frames[i]);
			}
		};
		fix(window.top);
	}
	if (dojo.render.html.ie && window !== document.parentWindow && !doc._parentWindow) {
		doc.parentWindow.execScript("document._parentWindow = window;", "Javascript");
		var win = doc._parentWindow;
		doc._parentWindow = null;
		return win;
	}
	return doc._parentWindow || doc.parentWindow || doc.defaultView;
};
dojo.html.gravity = function (node, e) {
	node = dojo.byId(node);
	var mouse = dojo.html.getCursorPosition(e);
	with (dojo.html) {
		var absolute = getAbsolutePosition(node, true);
		var bb = getBorderBox(node);
		var nodecenterx = absolute.x + (bb.width / 2);
		var nodecentery = absolute.y + (bb.height / 2);
	}
	with (dojo.html.gravity) {
		return ((mouse.x < nodecenterx ? WEST : EAST) | (mouse.y < nodecentery ? NORTH : SOUTH));
	}
};
dojo.html.gravity.NORTH = 1;
dojo.html.gravity.SOUTH = 1 << 1;
dojo.html.gravity.EAST = 1 << 2;
dojo.html.gravity.WEST = 1 << 3;
dojo.html.overElement = function (element, e) {
	element = dojo.byId(element);
	var mouse = dojo.html.getCursorPosition(e);
	var bb = dojo.html.getBorderBox(element);
	var absolute = dojo.html.getAbsolutePosition(element, true, dojo.html.boxSizing.BORDER_BOX);
	var top = absolute.y;
	var bottom = top + bb.height;
	var left = absolute.x;
	var right = left + bb.width;
	return (mouse.x >= left && mouse.x <= right && mouse.y >= top && mouse.y <= bottom);
};
dojo.html.renderedTextContent = function (node) {
	node = dojo.byId(node);
	var result = "";
	if (node == null) {
		return result;
	}
	for (var i = 0; i < node.childNodes.length; i++) {
		switch (node.childNodes[i].nodeType) {
		  case 1:
		  case 5:
			var display = "unknown";
			try {
				display = dojo.html.getStyle(node.childNodes[i], "display");
			}
			catch (E) {
			}
			switch (display) {
			  case "block":
			  case "list-item":
			  case "run-in":
			  case "table":
			  case "table-row-group":
			  case "table-header-group":
			  case "table-footer-group":
			  case "table-row":
			  case "table-column-group":
			  case "table-column":
			  case "table-cell":
			  case "table-caption":
				result += "\n";
				result += dojo.html.renderedTextContent(node.childNodes[i]);
				result += "\n";
				break;
			  case "none":
				break;
			  default:
				if (node.childNodes[i].tagName && node.childNodes[i].tagName.toLowerCase() == "br") {
					result += "\n";
				} else {
					result += dojo.html.renderedTextContent(node.childNodes[i]);
				}
				break;
			}
			break;
		  case 3:
		  case 2:
		  case 4:
			var text = node.childNodes[i].nodeValue;
			var textTransform = "unknown";
			try {
				textTransform = dojo.html.getStyle(node, "text-transform");
			}
			catch (E) {
			}
			switch (textTransform) {
			  case "capitalize":
				var words = text.split(" ");
				for (var i = 0; i < words.length; i++) {
					words[i] = words[i].charAt(0).toUpperCase() + words[i].substring(1);
				}
				text = words.join(" ");
				break;
			  case "uppercase":
				text = text.toUpperCase();
				break;
			  case "lowercase":
				text = text.toLowerCase();
				break;
			  default:
				break;
			}
			switch (textTransform) {
			  case "nowrap":
				break;
			  case "pre-wrap":
				break;
			  case "pre-line":
				break;
			  case "pre":
				break;
			  default:
				text = text.replace(/\s+/, " ");
				if (/\s$/.test(result)) {
					text.replace(/^\s/, "");
				}
				break;
			}
			result += text;
			break;
		  default:
			break;
		}
	}
	return result;
};
dojo.html.createNodesFromText = function (txt, trim) {
	if (trim) {
		txt = txt.replace(/^\s+|\s+$/g, "");
	}
	var tn = dojo.doc().createElement("div");
	tn.style.visibility = "hidden";
	dojo.body().appendChild(tn);
	var tableType = "none";
	if ((/^<t[dh][\s\r\n>]/i).test(txt.replace(/^\s+/))) {
		txt = "<table><tbody><tr>" + txt + "</tr></tbody></table>";
		tableType = "cell";
	} else {
		if ((/^<tr[\s\r\n>]/i).test(txt.replace(/^\s+/))) {
			txt = "<table><tbody>" + txt + "</tbody></table>";
			tableType = "row";
		} else {
			if ((/^<(thead|tbody|tfoot)[\s\r\n>]/i).test(txt.replace(/^\s+/))) {
				txt = "<table>" + txt + "</table>";
				tableType = "section";
			}
		}
	}
	tn.innerHTML = txt;
	if (tn["normalize"]) {
		tn.normalize();
	}
	var parent = null;
	switch (tableType) {
	  case "cell":
		parent = tn.getElementsByTagName("tr")[0];
		break;
	  case "row":
		parent = tn.getElementsByTagName("tbody")[0];
		break;
	  case "section":
		parent = tn.getElementsByTagName("table")[0];
		break;
	  default:
		parent = tn;
		break;
	}
	var nodes = [];
	for (var x = 0; x < parent.childNodes.length; x++) {
		nodes.push(parent.childNodes[x].cloneNode(true));
	}
	tn.style.display = "none";
	dojo.html.destroyNode(tn);
	return nodes;
};
dojo.html.placeOnScreen = function (node, desiredX, desiredY, padding, hasScroll, corners, tryOnly) {
	if (desiredX instanceof Array || typeof desiredX == "array") {
		tryOnly = corners;
		corners = hasScroll;
		hasScroll = padding;
		padding = desiredY;
		desiredY = desiredX[1];
		desiredX = desiredX[0];
	}
	if (corners instanceof String || typeof corners == "string") {
		corners = corners.split(",");
	}
	if (!isNaN(padding)) {
		padding = [Number(padding), Number(padding)];
	} else {
		if (!(padding instanceof Array || typeof padding == "array")) {
			padding = [0, 0];
		}
	}
	var scroll = dojo.html.getScroll().offset;
	var view = dojo.html.getViewport();
	node = dojo.byId(node);
	var oldDisplay = node.style.display;
	node.style.display = "";
	var bb = dojo.html.getBorderBox(node);
	var w = bb.width;
	var h = bb.height;
	node.style.display = oldDisplay;
	if (!(corners instanceof Array || typeof corners == "array")) {
		corners = ["TL"];
	}
	var bestx, besty, bestDistance = Infinity, bestCorner;
	for (var cidex = 0; cidex < corners.length; ++cidex) {
		var corner = corners[cidex];
		var match = true;
		var tryX = desiredX - (corner.charAt(1) == "L" ? 0 : w) + padding[0] * (corner.charAt(1) == "L" ? 1 : -1);
		var tryY = desiredY - (corner.charAt(0) == "T" ? 0 : h) + padding[1] * (corner.charAt(0) == "T" ? 1 : -1);
		if (hasScroll) {
			tryX -= scroll.x;
			tryY -= scroll.y;
		}
		if (tryX < 0) {
			tryX = 0;
			match = false;
		}
		if (tryY < 0) {
			tryY = 0;
			match = false;
		}
		var x = tryX + w;
		if (x > view.width) {
			x = view.width - w;
			match = false;
		} else {
			x = tryX;
		}
		x = Math.max(padding[0], x) + scroll.x;
		var y = tryY + h;
		if (y > view.height) {
			y = view.height - h;
			match = false;
		} else {
			y = tryY;
		}
		y = Math.max(padding[1], y) + scroll.y;
		if (match) {
			bestx = x;
			besty = y;
			bestDistance = 0;
			bestCorner = corner;
			break;
		} else {
			var dist = Math.pow(x - tryX - scroll.x, 2) + Math.pow(y - tryY - scroll.y, 2);
			if (bestDistance > dist) {
				bestDistance = dist;
				bestx = x;
				besty = y;
				bestCorner = corner;
			}
		}
	}
	if (!tryOnly) {
		node.style.left = bestx + "px";
		node.style.top = besty + "px";
	}
	return {left:bestx, top:besty, x:bestx, y:besty, dist:bestDistance, corner:bestCorner};
};
dojo.html.placeOnScreenPoint = function (node, desiredX, desiredY, padding, hasScroll) {
	dojo.deprecated("dojo.html.placeOnScreenPoint", "use dojo.html.placeOnScreen() instead", "0.5");
	return dojo.html.placeOnScreen(node, desiredX, desiredY, padding, hasScroll, ["TL", "TR", "BL", "BR"]);
};
dojo.html.placeOnScreenAroundElement = function (node, aroundNode, padding, aroundType, aroundCorners, tryOnly) {
	var best, bestDistance = Infinity;
	aroundNode = dojo.byId(aroundNode);
	var oldDisplay = aroundNode.style.display;
	aroundNode.style.display = "";
	var mb = dojo.html.getElementBox(aroundNode, aroundType);
	var aroundNodeW = mb.width;
	var aroundNodeH = mb.height;
	var aroundNodePos = dojo.html.getAbsolutePosition(aroundNode, true, aroundType);
	aroundNode.style.display = oldDisplay;
	for (var nodeCorner in aroundCorners) {
		var pos, desiredX, desiredY;
		var corners = aroundCorners[nodeCorner];
		desiredX = aroundNodePos.x + (nodeCorner.charAt(1) == "L" ? 0 : aroundNodeW);
		desiredY = aroundNodePos.y + (nodeCorner.charAt(0) == "T" ? 0 : aroundNodeH);
		pos = dojo.html.placeOnScreen(node, desiredX, desiredY, padding, true, corners, true);
		if (pos.dist == 0) {
			best = pos;
			break;
		} else {
			if (bestDistance > pos.dist) {
				bestDistance = pos.dist;
				best = pos;
			}
		}
	}
	if (!tryOnly) {
		node.style.left = best.left + "px";
		node.style.top = best.top + "px";
	}
	return best;
};
dojo.html.scrollIntoView = function (node) {
	if (!node) {
		return;
	}
	if (dojo.render.html.ie) {
		if (dojo.html.getBorderBox(node.parentNode).height <= node.parentNode.scrollHeight) {
			node.scrollIntoView(false);
		}
	} else {
		if (dojo.render.html.mozilla) {
			node.scrollIntoView(false);
		} else {
			var parent = node.parentNode;
			var parentBottom = parent.scrollTop + dojo.html.getBorderBox(parent).height;
			var nodeBottom = node.offsetTop + dojo.html.getMarginBox(node).height;
			if (parentBottom < nodeBottom) {
				parent.scrollTop += (nodeBottom - parentBottom);
			} else {
				if (parent.scrollTop > node.offsetTop) {
					parent.scrollTop -= (parent.scrollTop - node.offsetTop);
				}
			}
		}
	}
};


__CPAN_FILE__ src/html/display.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.html.display");
dojo.require("dojo.html.style");
dojo.html._toggle = function (node, tester, setter) {
	node = dojo.byId(node);
	setter(node, !tester(node));
	return tester(node);
};
dojo.html.show = function (node) {
	node = dojo.byId(node);
	if (dojo.html.getStyleProperty(node, "display") == "none") {
		dojo.html.setStyle(node, "display", (node.dojoDisplayCache || ""));
		node.dojoDisplayCache = undefined;
	}
};
dojo.html.hide = function (node) {
	node = dojo.byId(node);
	if (typeof node["dojoDisplayCache"] == "undefined") {
		var d = dojo.html.getStyleProperty(node, "display");
		if (d != "none") {
			node.dojoDisplayCache = d;
		}
	}
	dojo.html.setStyle(node, "display", "none");
};
dojo.html.setShowing = function (node, showing) {
	dojo.html[(showing ? "show" : "hide")](node);
};
dojo.html.isShowing = function (node) {
	return (dojo.html.getStyleProperty(node, "display") != "none");
};
dojo.html.toggleShowing = function (node) {
	return dojo.html._toggle(node, dojo.html.isShowing, dojo.html.setShowing);
};
dojo.html.displayMap = {tr:"", td:"", th:"", img:"inline", span:"inline", input:"inline", button:"inline"};
dojo.html.suggestDisplayByTagName = function (node) {
	node = dojo.byId(node);
	if (node && node.tagName) {
		var tag = node.tagName.toLowerCase();
		return (tag in dojo.html.displayMap ? dojo.html.displayMap[tag] : "block");
	}
};
dojo.html.setDisplay = function (node, display) {
	dojo.html.setStyle(node, "display", ((display instanceof String || typeof display == "string") ? display : (display ? dojo.html.suggestDisplayByTagName(node) : "none")));
};
dojo.html.isDisplayed = function (node) {
	return (dojo.html.getComputedStyle(node, "display") != "none");
};
dojo.html.toggleDisplay = function (node) {
	return dojo.html._toggle(node, dojo.html.isDisplayed, dojo.html.setDisplay);
};
dojo.html.setVisibility = function (node, visibility) {
	dojo.html.setStyle(node, "visibility", ((visibility instanceof String || typeof visibility == "string") ? visibility : (visibility ? "visible" : "hidden")));
};
dojo.html.isVisible = function (node) {
	return (dojo.html.getComputedStyle(node, "visibility") != "hidden");
};
dojo.html.toggleVisibility = function (node) {
	return dojo.html._toggle(node, dojo.html.isVisible, dojo.html.setVisibility);
};
dojo.html.setOpacity = function (node, opacity, dontFixOpacity) {
	node = dojo.byId(node);
	var h = dojo.render.html;
	if (!dontFixOpacity) {
		if (opacity >= 1) {
			if (h.ie) {
				dojo.html.clearOpacity(node);
				return;
			} else {
				opacity = 0.999999;
			}
		} else {
			if (opacity < 0) {
				opacity = 0;
			}
		}
	}
	if (h.ie) {
		if (node.nodeName.toLowerCase() == "tr") {
			var tds = node.getElementsByTagName("td");
			for (var x = 0; x < tds.length; x++) {
				tds[x].style.filter = "Alpha(Opacity=" + opacity * 100 + ")";
			}
		}
		node.style.filter = "Alpha(Opacity=" + opacity * 100 + ")";
	} else {
		if (h.moz) {
			node.style.opacity = opacity;
			node.style.MozOpacity = opacity;
		} else {
			if (h.safari) {
				node.style.opacity = opacity;
				node.style.KhtmlOpacity = opacity;
			} else {
				node.style.opacity = opacity;
			}
		}
	}
};
dojo.html.clearOpacity = function (node) {
	node = dojo.byId(node);
	var ns = node.style;
	var h = dojo.render.html;
	if (h.ie) {
		try {
			if (node.filters && node.filters.alpha) {
				ns.filter = "";
			}
		}
		catch (e) {
		}
	} else {
		if (h.moz) {
			ns.opacity = 1;
			ns.MozOpacity = 1;
		} else {
			if (h.safari) {
				ns.opacity = 1;
				ns.KhtmlOpacity = 1;
			} else {
				ns.opacity = 1;
			}
		}
	}
};
dojo.html.getOpacity = function (node) {
	node = dojo.byId(node);
	var h = dojo.render.html;
	if (h.ie) {
		var opac = (node.filters && node.filters.alpha && typeof node.filters.alpha.opacity == "number" ? node.filters.alpha.opacity : 100) / 100;
	} else {
		var opac = node.style.opacity || node.style.MozOpacity || node.style.KhtmlOpacity || 1;
	}
	return opac >= 0.999999 ? 1 : Number(opac);
};


__CPAN_FILE__ src/html/common.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.html.common");
dojo.require("dojo.lang.common");
dojo.require("dojo.dom");
dojo.lang.mixin(dojo.html, dojo.dom);
dojo.html.body = function () {
	dojo.deprecated("dojo.html.body() moved to dojo.body()", "0.5");
	return dojo.body();
};
dojo.html.getEventTarget = function (evt) {
	if (!evt) {
		evt = dojo.global().event || {};
	}
	var t = (evt.srcElement ? evt.srcElement : (evt.target ? evt.target : null));
	while ((t) && (t.nodeType != 1)) {
		t = t.parentNode;
	}
	return t;
};
dojo.html.getViewport = function () {
	var _window = dojo.global();
	var _document = dojo.doc();
	var w = 0;
	var h = 0;
	if (dojo.render.html.mozilla) {
		w = _document.documentElement.clientWidth;
		h = _window.innerHeight;
	} else {
		if (!dojo.render.html.opera && _window.innerWidth) {
			w = _window.innerWidth;
			h = _window.innerHeight;
		} else {
			if (!dojo.render.html.opera && dojo.exists(_document, "documentElement.clientWidth")) {
				var w2 = _document.documentElement.clientWidth;
				if (!w || w2 && w2 < w) {
					w = w2;
				}
				h = _document.documentElement.clientHeight;
			} else {
				if (dojo.body().clientWidth) {
					w = dojo.body().clientWidth;
					h = dojo.body().clientHeight;
				}
			}
		}
	}
	return {width:w, height:h};
};
dojo.html.getScroll = function () {
	var _window = dojo.global();
	var _document = dojo.doc();
	var top = _window.pageYOffset || _document.documentElement.scrollTop || dojo.body().scrollTop || 0;
	var left = _window.pageXOffset || _document.documentElement.scrollLeft || dojo.body().scrollLeft || 0;
	return {top:top, left:left, offset:{x:left, y:top}};
};
dojo.html.getParentByType = function (node, type) {
	var _document = dojo.doc();
	var parent = dojo.byId(node);
	type = type.toLowerCase();
	while ((parent) && (parent.nodeName.toLowerCase() != type)) {
		if (parent == (_document["body"] || _document["documentElement"])) {
			return null;
		}
		parent = parent.parentNode;
	}
	return parent;
};
dojo.html.getAttribute = function (node, attr) {
	node = dojo.byId(node);
	if ((!node) || (!node.getAttribute)) {
		return null;
	}
	var ta = typeof attr == "string" ? attr : new String(attr);
	var v = node.getAttribute(ta.toUpperCase());
	if ((v) && (typeof v == "string") && (v != "")) {
		return v;
	}
	if (v && v.value) {
		return v.value;
	}
	if ((node.getAttributeNode) && (node.getAttributeNode(ta))) {
		return (node.getAttributeNode(ta)).value;
	} else {
		if (node.getAttribute(ta)) {
			return node.getAttribute(ta);
		} else {
			if (node.getAttribute(ta.toLowerCase())) {
				return node.getAttribute(ta.toLowerCase());
			}
		}
	}
	return null;
};
dojo.html.hasAttribute = function (node, attr) {
	return dojo.html.getAttribute(dojo.byId(node), attr) ? true : false;
};
dojo.html.getCursorPosition = function (e) {
	e = e || dojo.global().event;
	var cursor = {x:0, y:0};
	if (e.pageX || e.pageY) {
		cursor.x = e.pageX;
		cursor.y = e.pageY;
	} else {
		var de = dojo.doc().documentElement;
		var db = dojo.body();
		cursor.x = e.clientX + ((de || db)["scrollLeft"]) - ((de || db)["clientLeft"]);
		cursor.y = e.clientY + ((de || db)["scrollTop"]) - ((de || db)["clientTop"]);
	}
	return cursor;
};
dojo.html.isTag = function (node) {
	node = dojo.byId(node);
	if (node && node.tagName) {
		for (var i = 1; i < arguments.length; i++) {
			if (node.tagName.toLowerCase() == String(arguments[i]).toLowerCase()) {
				return String(arguments[i]).toLowerCase();
			}
		}
	}
	return "";
};
if (dojo.render.html.ie && !dojo.render.html.ie70) {
	if (window.location.href.substr(0, 6).toLowerCase() != "https:") {
		(function () {
			var xscript = dojo.doc().createElement("script");
			xscript.src = "javascript:'dojo.html.createExternalElement=function(doc, tag){ return doc.createElement(tag); }'";
			dojo.doc().getElementsByTagName("head")[0].appendChild(xscript);
		})();
	}
} else {
	dojo.html.createExternalElement = function (doc, tag) {
		return doc.createElement(tag);
	};
}
dojo.html._callDeprecated = function (inFunc, replFunc, args, argName, retValue) {
	dojo.deprecated("dojo.html." + inFunc, "replaced by dojo.html." + replFunc + "(" + (argName ? "node, {" + argName + ": " + argName + "}" : "") + ")" + (retValue ? "." + retValue : ""), "0.5");
	var newArgs = [];
	if (argName) {
		var argsIn = {};
		argsIn[argName] = args[1];
		newArgs.push(args[0]);
		newArgs.push(argsIn);
	} else {
		newArgs = args;
	}
	var ret = dojo.html[replFunc].apply(dojo.html, args);
	if (retValue) {
		return ret[retValue];
	} else {
		return ret;
	}
};
dojo.html.getViewportWidth = function () {
	return dojo.html._callDeprecated("getViewportWidth", "getViewport", arguments, null, "width");
};
dojo.html.getViewportHeight = function () {
	return dojo.html._callDeprecated("getViewportHeight", "getViewport", arguments, null, "height");
};
dojo.html.getViewportSize = function () {
	return dojo.html._callDeprecated("getViewportSize", "getViewport", arguments);
};
dojo.html.getScrollTop = function () {
	return dojo.html._callDeprecated("getScrollTop", "getScroll", arguments, null, "top");
};
dojo.html.getScrollLeft = function () {
	return dojo.html._callDeprecated("getScrollLeft", "getScroll", arguments, null, "left");
};
dojo.html.getScrollOffset = function () {
	return dojo.html._callDeprecated("getScrollOffset", "getScroll", arguments, null, "offset");
};


__CPAN_FILE__ src/html/style.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.html.style");
dojo.require("dojo.html.common");
dojo.require("dojo.uri.Uri");
dojo.html.getClass = function (node) {
	node = dojo.byId(node);
	if (!node) {
		return "";
	}
	var cs = "";
	if (node.className) {
		cs = node.className;
	} else {
		if (dojo.html.hasAttribute(node, "class")) {
			cs = dojo.html.getAttribute(node, "class");
		}
	}
	return cs.replace(/^\s+|\s+$/g, "");
};
dojo.html.getClasses = function (node) {
	var c = dojo.html.getClass(node);
	return (c == "") ? [] : c.split(/\s+/g);
};
dojo.html.hasClass = function (node, classname) {
	return (new RegExp("(^|\\s+)" + classname + "(\\s+|$)")).test(dojo.html.getClass(node));
};
dojo.html.prependClass = function (node, classStr) {
	classStr += " " + dojo.html.getClass(node);
	return dojo.html.setClass(node, classStr);
};
dojo.html.addClass = function (node, classStr) {
	if (dojo.html.hasClass(node, classStr)) {
		return false;
	}
	classStr = (dojo.html.getClass(node) + " " + classStr).replace(/^\s+|\s+$/g, "");
	return dojo.html.setClass(node, classStr);
};
dojo.html.setClass = function (node, classStr) {
	node = dojo.byId(node);
	var cs = new String(classStr);
	try {
		if (typeof node.className == "string") {
			node.className = cs;
		} else {
			if (node.setAttribute) {
				node.setAttribute("class", classStr);
				node.className = cs;
			} else {
				return false;
			}
		}
	}
	catch (e) {
		dojo.debug("dojo.html.setClass() failed", e);
	}
	return true;
};
dojo.html.removeClass = function (node, classStr, allowPartialMatches) {
	try {
		if (!allowPartialMatches) {
			var newcs = dojo.html.getClass(node).replace(new RegExp("(^|\\s+)" + classStr + "(\\s+|$)"), "$1$2");
		} else {
			var newcs = dojo.html.getClass(node).replace(classStr, "");
		}
		dojo.html.setClass(node, newcs);
	}
	catch (e) {
		dojo.debug("dojo.html.removeClass() failed", e);
	}
	return true;
};
dojo.html.replaceClass = function (node, newClass, oldClass) {
	dojo.html.removeClass(node, oldClass);
	dojo.html.addClass(node, newClass);
};
dojo.html.classMatchType = {ContainsAll:0, ContainsAny:1, IsOnly:2};
dojo.html.getElementsByClass = function (classStr, parent, nodeType, classMatchType, useNonXpath) {
	useNonXpath = false;
	var _document = dojo.doc();
	parent = dojo.byId(parent) || _document;
	var classes = classStr.split(/\s+/g);
	var nodes = [];
	if (classMatchType != 1 && classMatchType != 2) {
		classMatchType = 0;
	}
	var reClass = new RegExp("(\\s|^)((" + classes.join(")|(") + "))(\\s|$)");
	var srtLength = classes.join(" ").length;
	var candidateNodes = [];
	if (!useNonXpath && _document.evaluate) {
		var xpath = ".//" + (nodeType || "*") + "[contains(";
		if (classMatchType != dojo.html.classMatchType.ContainsAny) {
			xpath += "concat(' ',@class,' '), ' " + classes.join(" ') and contains(concat(' ',@class,' '), ' ") + " ')";
			if (classMatchType == 2) {
				xpath += " and string-length(@class)=" + srtLength + "]";
			} else {
				xpath += "]";
			}
		} else {
			xpath += "concat(' ',@class,' '), ' " + classes.join(" ') or contains(concat(' ',@class,' '), ' ") + " ')]";
		}
		var xpathResult = _document.evaluate(xpath, parent, null, XPathResult.ANY_TYPE, null);
		var result = xpathResult.iterateNext();
		while (result) {
			try {
				candidateNodes.push(result);
				result = xpathResult.iterateNext();
			}
			catch (e) {
				break;
			}
		}
		return candidateNodes;
	} else {
		if (!nodeType) {
			nodeType = "*";
		}
		candidateNodes = parent.getElementsByTagName(nodeType);
		var node, i = 0;
	outer:
		while (node = candidateNodes[i++]) {
			var nodeClasses = dojo.html.getClasses(node);
			if (nodeClasses.length == 0) {
				continue outer;
			}
			var matches = 0;
			for (var j = 0; j < nodeClasses.length; j++) {
				if (reClass.test(nodeClasses[j])) {
					if (classMatchType == dojo.html.classMatchType.ContainsAny) {
						nodes.push(node);
						continue outer;
					} else {
						matches++;
					}
				} else {
					if (classMatchType == dojo.html.classMatchType.IsOnly) {
						continue outer;
					}
				}
			}
			if (matches == classes.length) {
				if ((classMatchType == dojo.html.classMatchType.IsOnly) && (matches == nodeClasses.length)) {
					nodes.push(node);
				} else {
					if (classMatchType == dojo.html.classMatchType.ContainsAll) {
						nodes.push(node);
					}
				}
			}
		}
		return nodes;
	}
};
dojo.html.getElementsByClassName = dojo.html.getElementsByClass;
dojo.html.toCamelCase = function (selector) {
	var arr = selector.split("-"), cc = arr[0];
	for (var i = 1; i < arr.length; i++) {
		cc += arr[i].charAt(0).toUpperCase() + arr[i].substring(1);
	}
	return cc;
};
dojo.html.toSelectorCase = function (selector) {
	return selector.replace(/([A-Z])/g, "-$1").toLowerCase();
};
if (dojo.render.html.ie) {
	dojo.html.getComputedStyle = function (node, property, value) {
		node = dojo.byId(node);
		if (!node || !node.style) {
			return value;
		}
		return node.currentStyle[dojo.html.toCamelCase(property)];
	};
	dojo.html.getComputedStyles = function (node) {
		return node.currentStyle;
	};
} else {
	dojo.html.getComputedStyle = function (node, property, value) {
		node = dojo.byId(node);
		if (!node || !node.style) {
			return value;
		}
		var s = document.defaultView.getComputedStyle(node, null);
		return (s && s[dojo.html.toCamelCase(property)]) || "";
	};
	dojo.html.getComputedStyles = function (node) {
		return document.defaultView.getComputedStyle(node, null);
	};
}
dojo.html.getStyleProperty = function (node, cssSelector) {
	node = dojo.byId(node);
	return (node && node.style ? node.style[dojo.html.toCamelCase(cssSelector)] : undefined);
};
dojo.html.getStyle = function (node, cssSelector) {
	var value = dojo.html.getStyleProperty(node, cssSelector);
	return (value ? value : dojo.html.getComputedStyle(node, cssSelector));
};
dojo.html.setStyle = function (node, cssSelector, value) {
	node = dojo.byId(node);
	if (node && node.style) {
		var camelCased = dojo.html.toCamelCase(cssSelector);
		node.style[camelCased] = value;
	}
};
dojo.html.setStyleText = function (target, text) {
	try {
		target.style.cssText = text;
	}
	catch (e) {
		target.setAttribute("style", text);
	}
};
dojo.html.copyStyle = function (target, source) {
	if (!source.style.cssText) {
		target.setAttribute("style", source.getAttribute("style"));
	} else {
		target.style.cssText = source.style.cssText;
	}
	dojo.html.addClass(target, dojo.html.getClass(source));
};
dojo.html.getUnitValue = function (node, cssSelector, autoIsZero) {
	var s = dojo.html.getComputedStyle(node, cssSelector);
	if ((!s) || ((s == "auto") && (autoIsZero))) {
		return {value:0, units:"px"};
	}
	var match = s.match(/(\-?[\d.]+)([a-z%]*)/i);
	if (!match) {
		return dojo.html.getUnitValue.bad;
	}
	return {value:Number(match[1]), units:match[2].toLowerCase()};
};
dojo.html.getUnitValue.bad = {value:NaN, units:""};
if (dojo.render.html.ie) {
	dojo.html.toPixelValue = function (element, styleValue) {
		if (!styleValue) {
			return 0;
		}
		if (styleValue.slice(-2) == "px") {
			return parseFloat(styleValue);
		}
		var pixelValue = 0;
		with (element) {
			var sLeft = style.left;
			var rsLeft = runtimeStyle.left;
			runtimeStyle.left = currentStyle.left;
			try {
				style.left = styleValue || 0;
				pixelValue = style.pixelLeft;
				style.left = sLeft;
				runtimeStyle.left = rsLeft;
			}
			catch (e) {
			}
		}
		return pixelValue;
	};
} else {
	dojo.html.toPixelValue = function (element, styleValue) {
		return (styleValue && (styleValue.slice(-2) == "px") ? parseFloat(styleValue) : 0);
	};
}
dojo.html.getPixelValue = function (node, styleProperty, autoIsZero) {
	return dojo.html.toPixelValue(node, dojo.html.getComputedStyle(node, styleProperty));
};
dojo.html.setPositivePixelValue = function (node, selector, value) {
	if (isNaN(value)) {
		return false;
	}
	node.style[selector] = Math.max(0, value) + "px";
	return true;
};
dojo.html.styleSheet = null;
dojo.html.insertCssRule = function (selector, declaration, index) {
	if (!dojo.html.styleSheet) {
		if (document.createStyleSheet) {
			dojo.html.styleSheet = document.createStyleSheet();
		} else {
			if (document.styleSheets[0]) {
				dojo.html.styleSheet = document.styleSheets[0];
			} else {
				return null;
			}
		}
	}
	if (arguments.length < 3) {
		if (dojo.html.styleSheet.cssRules) {
			index = dojo.html.styleSheet.cssRules.length;
		} else {
			if (dojo.html.styleSheet.rules) {
				index = dojo.html.styleSheet.rules.length;
			} else {
				return null;
			}
		}
	}
	if (dojo.html.styleSheet.insertRule) {
		var rule = selector + " { " + declaration + " }";
		return dojo.html.styleSheet.insertRule(rule, index);
	} else {
		if (dojo.html.styleSheet.addRule) {
			return dojo.html.styleSheet.addRule(selector, declaration, index);
		} else {
			return null;
		}
	}
};
dojo.html.removeCssRule = function (index) {
	if (!dojo.html.styleSheet) {
		dojo.debug("no stylesheet defined for removing rules");
		return false;
	}
	if (dojo.render.html.ie) {
		if (!index) {
			index = dojo.html.styleSheet.rules.length;
			dojo.html.styleSheet.removeRule(index);
		}
	} else {
		if (document.styleSheets[0]) {
			if (!index) {
				index = dojo.html.styleSheet.cssRules.length;
			}
			dojo.html.styleSheet.deleteRule(index);
		}
	}
	return true;
};
dojo.html._insertedCssFiles = [];
dojo.html.insertCssFile = function (URI, doc, checkDuplicates, fail_ok) {
	if (!URI) {
		return;
	}
	if (!doc) {
		doc = document;
	}
	var cssStr = dojo.hostenv.getText(URI, false, fail_ok);
	if (cssStr === null) {
		return;
	}
	cssStr = dojo.html.fixPathsInCssText(cssStr, URI);
	if (checkDuplicates) {
		var idx = -1, node, ent = dojo.html._insertedCssFiles;
		for (var i = 0; i < ent.length; i++) {
			if ((ent[i].doc == doc) && (ent[i].cssText == cssStr)) {
				idx = i;
				node = ent[i].nodeRef;
				break;
			}
		}
		if (node) {
			var styles = doc.getElementsByTagName("style");
			for (var i = 0; i < styles.length; i++) {
				if (styles[i] == node) {
					return;
				}
			}
			dojo.html._insertedCssFiles.shift(idx, 1);
		}
	}
	var style = dojo.html.insertCssText(cssStr, doc);
	dojo.html._insertedCssFiles.push({"doc":doc, "cssText":cssStr, "nodeRef":style});
	if (style && djConfig.isDebug) {
		style.setAttribute("dbgHref", URI);
	}
	return style;
};
dojo.html.insertCssText = function (cssStr, doc, URI) {
	if (!cssStr) {
		return;
	}
	if (!doc) {
		doc = document;
	}
	if (URI) {
		cssStr = dojo.html.fixPathsInCssText(cssStr, URI);
	}
	var style = doc.createElement("style");
	style.setAttribute("type", "text/css");
	var head = doc.getElementsByTagName("head")[0];
	if (!head) {
		dojo.debug("No head tag in document, aborting styles");
		return;
	} else {
		head.appendChild(style);
	}
	if (style.styleSheet) {
		var setFunc = function () {
			try {
				style.styleSheet.cssText = cssStr;
			}
			catch (e) {
				dojo.debug(e);
			}
		};
		if (style.styleSheet.disabled) {
			setTimeout(setFunc, 10);
		} else {
			setFunc();
		}
	} else {
		var cssText = doc.createTextNode(cssStr);
		style.appendChild(cssText);
	}
	return style;
};
dojo.html.fixPathsInCssText = function (cssStr, URI) {
	if (!cssStr || !URI) {
		return;
	}
	var match, str = "", url = "", urlChrs = "[\\t\\s\\w\\(\\)\\/\\.\\\\'\"-:#=&?~]+";
	var regex = new RegExp("url\\(\\s*(" + urlChrs + ")\\s*\\)");
	var regexProtocol = /(file|https?|ftps?):\/\//;
	regexTrim = new RegExp("^[\\s]*(['\"]?)(" + urlChrs + ")\\1[\\s]*?$");
	if (dojo.render.html.ie55 || dojo.render.html.ie60) {
		var regexIe = new RegExp("AlphaImageLoader\\((.*)src=['\"](" + urlChrs + ")['\"]");
		while (match = regexIe.exec(cssStr)) {
			url = match[2].replace(regexTrim, "$2");
			if (!regexProtocol.exec(url)) {
				url = (new dojo.uri.Uri(URI, url).toString());
			}
			str += cssStr.substring(0, match.index) + "AlphaImageLoader(" + match[1] + "src='" + url + "'";
			cssStr = cssStr.substr(match.index + match[0].length);
		}
		cssStr = str + cssStr;
		str = "";
	}
	while (match = regex.exec(cssStr)) {
		url = match[1].replace(regexTrim, "$2");
		if (!regexProtocol.exec(url)) {
			url = (new dojo.uri.Uri(URI, url).toString());
		}
		str += cssStr.substring(0, match.index) + "url(" + url + ")";
		cssStr = cssStr.substr(match.index + match[0].length);
	}
	return str + cssStr;
};
dojo.html.setActiveStyleSheet = function (title) {
	var i = 0, a, els = dojo.doc().getElementsByTagName("link");
	while (a = els[i++]) {
		if (a.getAttribute("rel").indexOf("style") != -1 && a.getAttribute("title")) {
			a.disabled = true;
			if (a.getAttribute("title") == title) {
				a.disabled = false;
			}
		}
	}
};
dojo.html.getActiveStyleSheet = function () {
	var i = 0, a, els = dojo.doc().getElementsByTagName("link");
	while (a = els[i++]) {
		if (a.getAttribute("rel").indexOf("style") != -1 && a.getAttribute("title") && !a.disabled) {
			return a.getAttribute("title");
		}
	}
	return null;
};
dojo.html.getPreferredStyleSheet = function () {
	var i = 0, a, els = dojo.doc().getElementsByTagName("link");
	while (a = els[i++]) {
		if (a.getAttribute("rel").indexOf("style") != -1 && a.getAttribute("rel").indexOf("alt") == -1 && a.getAttribute("title")) {
			return a.getAttribute("title");
		}
	}
	return null;
};
dojo.html.applyBrowserClass = function (node) {
	var drh = dojo.render.html;
	var classes = {dj_ie:drh.ie, dj_ie55:drh.ie55, dj_ie6:drh.ie60, dj_ie7:drh.ie70, dj_iequirks:drh.ie && drh.quirks, dj_opera:drh.opera, dj_opera8:drh.opera && (Math.floor(dojo.render.version) == 8), dj_opera9:drh.opera && (Math.floor(dojo.render.version) == 9), dj_khtml:drh.khtml, dj_safari:drh.safari, dj_gecko:drh.mozilla};
	for (var p in classes) {
		if (classes[p]) {
			dojo.html.addClass(node, p);
		}
	}
};


__CPAN_FILE__ src/html/color.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.require("dojo.html.style");
dojo.provide("dojo.html.color");
dojo.require("dojo.gfx.color");
dojo.require("dojo.lang.common");
dojo.html.getBackgroundColor = function (node) {
	node = dojo.byId(node);
	var color;
	do {
		color = dojo.html.getStyle(node, "background-color");
		if (color.toLowerCase() == "rgba(0, 0, 0, 0)") {
			color = "transparent";
		}
		if (node == document.getElementsByTagName("body")[0]) {
			node = null;
			break;
		}
		node = node.parentNode;
	} while (node && dojo.lang.inArray(["transparent", ""], color));
	if (color == "transparent") {
		color = [255, 255, 255, 0];
	} else {
		color = dojo.gfx.color.extractRGB(color);
	}
	return color;
};


__CPAN_FILE__ src/html/layout.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.html.layout");
dojo.require("dojo.html.common");
dojo.require("dojo.html.style");
dojo.require("dojo.html.display");
dojo.html.sumAncestorProperties = function (node, prop) {
	node = dojo.byId(node);
	if (!node) {
		return 0;
	}
	var retVal = 0;
	while (node) {
		if (dojo.html.getComputedStyle(node, "position") == "fixed") {
			return 0;
		}
		var val = node[prop];
		if (val) {
			retVal += val - 0;
			if (node == dojo.body()) {
				break;
			}
		}
		node = node.parentNode;
	}
	return retVal;
};
dojo.html.setStyleAttributes = function (node, attributes) {
	node = dojo.byId(node);
	var splittedAttribs = attributes.replace(/(;)?\s*$/, "").split(";");
	for (var i = 0; i < splittedAttribs.length; i++) {
		var nameValue = splittedAttribs[i].split(":");
		var name = nameValue[0].replace(/\s*$/, "").replace(/^\s*/, "").toLowerCase();
		var value = nameValue[1].replace(/\s*$/, "").replace(/^\s*/, "");
		switch (name) {
		  case "opacity":
			dojo.html.setOpacity(node, value);
			break;
		  case "content-height":
			dojo.html.setContentBox(node, {height:value});
			break;
		  case "content-width":
			dojo.html.setContentBox(node, {width:value});
			break;
		  case "outer-height":
			dojo.html.setMarginBox(node, {height:value});
			break;
		  case "outer-width":
			dojo.html.setMarginBox(node, {width:value});
			break;
		  default:
			node.style[dojo.html.toCamelCase(name)] = value;
		}
	}
};
dojo.html.boxSizing = {MARGIN_BOX:"margin-box", BORDER_BOX:"border-box", PADDING_BOX:"padding-box", CONTENT_BOX:"content-box"};
dojo.html.getAbsolutePosition = dojo.html.abs = function (node, includeScroll, boxType) {
	node = dojo.byId(node, node.ownerDocument);
	var ret = {x:0, y:0};
	var bs = dojo.html.boxSizing;
	if (!boxType) {
		boxType = bs.CONTENT_BOX;
	}
	var nativeBoxType = 2;
	var targetBoxType;
	switch (boxType) {
	  case bs.MARGIN_BOX:
		targetBoxType = 3;
		break;
	  case bs.BORDER_BOX:
		targetBoxType = 2;
		break;
	  case bs.PADDING_BOX:
	  default:
		targetBoxType = 1;
		break;
	  case bs.CONTENT_BOX:
		targetBoxType = 0;
		break;
	}
	var h = dojo.render.html;
	var db = document["body"] || document["documentElement"];
	if (h.ie) {
		with (node.getBoundingClientRect()) {
			ret.x = left - 2;
			ret.y = top - 2;
		}
	} else {
		if (document.getBoxObjectFor) {
			nativeBoxType = 1;
			try {
				var bo = document.getBoxObjectFor(node);
				ret.x = bo.x - dojo.html.sumAncestorProperties(node, "scrollLeft");
				ret.y = bo.y - dojo.html.sumAncestorProperties(node, "scrollTop");
			}
			catch (e) {
			}
		} else {
			if (node["offsetParent"]) {
				var endNode;
				if ((h.safari) && (node.style.getPropertyValue("position") == "absolute") && (node.parentNode == db)) {
					endNode = db;
				} else {
					endNode = db.parentNode;
				}
				if (node.parentNode != db) {
					var nd = node;
					if (dojo.render.html.opera) {
						nd = db;
					}
					ret.x -= dojo.html.sumAncestorProperties(nd, "scrollLeft");
					ret.y -= dojo.html.sumAncestorProperties(nd, "scrollTop");
				}
				var curnode = node;
				do {
					var n = curnode["offsetLeft"];
					if (!h.opera || n > 0) {
						ret.x += isNaN(n) ? 0 : n;
					}
					var m = curnode["offsetTop"];
					ret.y += isNaN(m) ? 0 : m;
					curnode = curnode.offsetParent;
				} while ((curnode != endNode) && (curnode != null));
			} else {
				if (node["x"] && node["y"]) {
					ret.x += isNaN(node.x) ? 0 : node.x;
					ret.y += isNaN(node.y) ? 0 : node.y;
				}
			}
		}
	}
	if (includeScroll) {
		var scroll = dojo.html.getScroll();
		ret.y += scroll.top;
		ret.x += scroll.left;
	}
	var extentFuncArray = [dojo.html.getPaddingExtent, dojo.html.getBorderExtent, dojo.html.getMarginExtent];
	if (nativeBoxType > targetBoxType) {
		for (var i = targetBoxType; i < nativeBoxType; ++i) {
			ret.y += extentFuncArray[i](node, "top");
			ret.x += extentFuncArray[i](node, "left");
		}
	} else {
		if (nativeBoxType < targetBoxType) {
			for (var i = targetBoxType; i > nativeBoxType; --i) {
				ret.y -= extentFuncArray[i - 1](node, "top");
				ret.x -= extentFuncArray[i - 1](node, "left");
			}
		}
	}
	ret.top = ret.y;
	ret.left = ret.x;
	return ret;
};
dojo.html.isPositionAbsolute = function (node) {
	return (dojo.html.getComputedStyle(node, "position") == "absolute");
};
dojo.html._sumPixelValues = function (node, selectors, autoIsZero) {
	var total = 0;
	for (var x = 0; x < selectors.length; x++) {
		total += dojo.html.getPixelValue(node, selectors[x], autoIsZero);
	}
	return total;
};
dojo.html.getMargin = function (node) {
	return {width:dojo.html._sumPixelValues(node, ["margin-left", "margin-right"], (dojo.html.getComputedStyle(node, "position") == "absolute")), height:dojo.html._sumPixelValues(node, ["margin-top", "margin-bottom"], (dojo.html.getComputedStyle(node, "position") == "absolute"))};
};
dojo.html.getBorder = function (node) {
	return {width:dojo.html.getBorderExtent(node, "left") + dojo.html.getBorderExtent(node, "right"), height:dojo.html.getBorderExtent(node, "top") + dojo.html.getBorderExtent(node, "bottom")};
};
dojo.html.getBorderExtent = function (node, side) {
	return (dojo.html.getStyle(node, "border-" + side + "-style") == "none" ? 0 : dojo.html.getPixelValue(node, "border-" + side + "-width"));
};
dojo.html.getMarginExtent = function (node, side) {
	return dojo.html._sumPixelValues(node, ["margin-" + side], dojo.html.isPositionAbsolute(node));
};
dojo.html.getPaddingExtent = function (node, side) {
	return dojo.html._sumPixelValues(node, ["padding-" + side], true);
};
dojo.html.getPadding = function (node) {
	return {width:dojo.html._sumPixelValues(node, ["padding-left", "padding-right"], true), height:dojo.html._sumPixelValues(node, ["padding-top", "padding-bottom"], true)};
};
dojo.html.getPadBorder = function (node) {
	var pad = dojo.html.getPadding(node);
	var border = dojo.html.getBorder(node);
	return {width:pad.width + border.width, height:pad.height + border.height};
};
dojo.html.getBoxSizing = function (node) {
	var h = dojo.render.html;
	var bs = dojo.html.boxSizing;
	if (((h.ie) || (h.opera)) && node.nodeName.toLowerCase() != "img") {
		var cm = document["compatMode"];
		if ((cm == "BackCompat") || (cm == "QuirksMode")) {
			return bs.BORDER_BOX;
		} else {
			return bs.CONTENT_BOX;
		}
	} else {
		if (arguments.length == 0) {
			node = document.documentElement;
		}
		var sizing;
		if (!h.ie) {
			sizing = dojo.html.getStyle(node, "-moz-box-sizing");
			if (!sizing) {
				sizing = dojo.html.getStyle(node, "box-sizing");
			}
		}
		return (sizing ? sizing : bs.CONTENT_BOX);
	}
};
dojo.html.isBorderBox = function (node) {
	return (dojo.html.getBoxSizing(node) == dojo.html.boxSizing.BORDER_BOX);
};
dojo.html.getBorderBox = function (node) {
	node = dojo.byId(node);
	return {width:node.offsetWidth, height:node.offsetHeight};
};
dojo.html.getPaddingBox = function (node) {
	var box = dojo.html.getBorderBox(node);
	var border = dojo.html.getBorder(node);
	return {width:box.width - border.width, height:box.height - border.height};
};
dojo.html.getContentBox = function (node) {
	node = dojo.byId(node);
	var padborder = dojo.html.getPadBorder(node);
	return {width:node.offsetWidth - padborder.width, height:node.offsetHeight - padborder.height};
};
dojo.html.setContentBox = function (node, args) {
	node = dojo.byId(node);
	var width = 0;
	var height = 0;
	var isbb = dojo.html.isBorderBox(node);
	var padborder = (isbb ? dojo.html.getPadBorder(node) : {width:0, height:0});
	var ret = {};
	if (typeof args.width != "undefined") {
		width = args.width + padborder.width;
		ret.width = dojo.html.setPositivePixelValue(node, "width", width);
	}
	if (typeof args.height != "undefined") {
		height = args.height + padborder.height;
		ret.height = dojo.html.setPositivePixelValue(node, "height", height);
	}
	return ret;
};
dojo.html.getMarginBox = function (node) {
	var borderbox = dojo.html.getBorderBox(node);
	var margin = dojo.html.getMargin(node);
	return {width:borderbox.width + margin.width, height:borderbox.height + margin.height};
};
dojo.html.setMarginBox = function (node, args) {
	node = dojo.byId(node);
	var width = 0;
	var height = 0;
	var isbb = dojo.html.isBorderBox(node);
	var padborder = (!isbb ? dojo.html.getPadBorder(node) : {width:0, height:0});
	var margin = dojo.html.getMargin(node);
	var ret = {};
	if (typeof args.width != "undefined") {
		width = args.width - padborder.width;
		width -= margin.width;
		ret.width = dojo.html.setPositivePixelValue(node, "width", width);
	}
	if (typeof args.height != "undefined") {
		height = args.height - padborder.height;
		height -= margin.height;
		ret.height = dojo.html.setPositivePixelValue(node, "height", height);
	}
	return ret;
};
dojo.html.getElementBox = function (node, type) {
	var bs = dojo.html.boxSizing;
	switch (type) {
	  case bs.MARGIN_BOX:
		return dojo.html.getMarginBox(node);
	  case bs.BORDER_BOX:
		return dojo.html.getBorderBox(node);
	  case bs.PADDING_BOX:
		return dojo.html.getPaddingBox(node);
	  case bs.CONTENT_BOX:
	  default:
		return dojo.html.getContentBox(node);
	}
};
dojo.html.toCoordinateObject = dojo.html.toCoordinateArray = function (coords, includeScroll, boxtype) {
	if (coords instanceof Array || typeof coords == "array") {
		dojo.deprecated("dojo.html.toCoordinateArray", "use dojo.html.toCoordinateObject({left: , top: , width: , height: }) instead", "0.5");
		while (coords.length < 4) {
			coords.push(0);
		}
		while (coords.length > 4) {
			coords.pop();
		}
		var ret = {left:coords[0], top:coords[1], width:coords[2], height:coords[3]};
	} else {
		if (!coords.nodeType && !(coords instanceof String || typeof coords == "string") && ("width" in coords || "height" in coords || "left" in coords || "x" in coords || "top" in coords || "y" in coords)) {
			var ret = {left:coords.left || coords.x || 0, top:coords.top || coords.y || 0, width:coords.width || 0, height:coords.height || 0};
		} else {
			var node = dojo.byId(coords);
			var pos = dojo.html.abs(node, includeScroll, boxtype);
			var marginbox = dojo.html.getMarginBox(node);
			var ret = {left:pos.left, top:pos.top, width:marginbox.width, height:marginbox.height};
		}
	}
	ret.x = ret.left;
	ret.y = ret.top;
	return ret;
};
dojo.html.setMarginBoxWidth = dojo.html.setOuterWidth = function (node, width) {
	return dojo.html._callDeprecated("setMarginBoxWidth", "setMarginBox", arguments, "width");
};
dojo.html.setMarginBoxHeight = dojo.html.setOuterHeight = function () {
	return dojo.html._callDeprecated("setMarginBoxHeight", "setMarginBox", arguments, "height");
};
dojo.html.getMarginBoxWidth = dojo.html.getOuterWidth = function () {
	return dojo.html._callDeprecated("getMarginBoxWidth", "getMarginBox", arguments, null, "width");
};
dojo.html.getMarginBoxHeight = dojo.html.getOuterHeight = function () {
	return dojo.html._callDeprecated("getMarginBoxHeight", "getMarginBox", arguments, null, "height");
};
dojo.html.getTotalOffset = function (node, type, includeScroll) {
	return dojo.html._callDeprecated("getTotalOffset", "getAbsolutePosition", arguments, null, type);
};
dojo.html.getAbsoluteX = function (node, includeScroll) {
	return dojo.html._callDeprecated("getAbsoluteX", "getAbsolutePosition", arguments, null, "x");
};
dojo.html.getAbsoluteY = function (node, includeScroll) {
	return dojo.html._callDeprecated("getAbsoluteY", "getAbsolutePosition", arguments, null, "y");
};
dojo.html.totalOffsetLeft = function (node, includeScroll) {
	return dojo.html._callDeprecated("totalOffsetLeft", "getAbsolutePosition", arguments, null, "left");
};
dojo.html.totalOffsetTop = function (node, includeScroll) {
	return dojo.html._callDeprecated("totalOffsetTop", "getAbsolutePosition", arguments, null, "top");
};
dojo.html.getMarginWidth = function (node) {
	return dojo.html._callDeprecated("getMarginWidth", "getMargin", arguments, null, "width");
};
dojo.html.getMarginHeight = function (node) {
	return dojo.html._callDeprecated("getMarginHeight", "getMargin", arguments, null, "height");
};
dojo.html.getBorderWidth = function (node) {
	return dojo.html._callDeprecated("getBorderWidth", "getBorder", arguments, null, "width");
};
dojo.html.getBorderHeight = function (node) {
	return dojo.html._callDeprecated("getBorderHeight", "getBorder", arguments, null, "height");
};
dojo.html.getPaddingWidth = function (node) {
	return dojo.html._callDeprecated("getPaddingWidth", "getPadding", arguments, null, "width");
};
dojo.html.getPaddingHeight = function (node) {
	return dojo.html._callDeprecated("getPaddingHeight", "getPadding", arguments, null, "height");
};
dojo.html.getPadBorderWidth = function (node) {
	return dojo.html._callDeprecated("getPadBorderWidth", "getPadBorder", arguments, null, "width");
};
dojo.html.getPadBorderHeight = function (node) {
	return dojo.html._callDeprecated("getPadBorderHeight", "getPadBorder", arguments, null, "height");
};
dojo.html.getBorderBoxWidth = dojo.html.getInnerWidth = function () {
	return dojo.html._callDeprecated("getBorderBoxWidth", "getBorderBox", arguments, null, "width");
};
dojo.html.getBorderBoxHeight = dojo.html.getInnerHeight = function () {
	return dojo.html._callDeprecated("getBorderBoxHeight", "getBorderBox", arguments, null, "height");
};
dojo.html.getContentBoxWidth = dojo.html.getContentWidth = function () {
	return dojo.html._callDeprecated("getContentBoxWidth", "getContentBox", arguments, null, "width");
};
dojo.html.getContentBoxHeight = dojo.html.getContentHeight = function () {
	return dojo.html._callDeprecated("getContentBoxHeight", "getContentBox", arguments, null, "height");
};
dojo.html.setContentBoxWidth = dojo.html.setContentWidth = function (node, width) {
	return dojo.html._callDeprecated("setContentBoxWidth", "setContentBox", arguments, "width");
};
dojo.html.setContentBoxHeight = dojo.html.setContentHeight = function (node, height) {
	return dojo.html._callDeprecated("setContentBoxHeight", "setContentBox", arguments, "height");
};


__CPAN_FILE__ src/html/__package__.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.kwCompoundRequire({common:["dojo.html.common", "dojo.html.style"]});
dojo.provide("dojo.html.*");


__CPAN_FILE__ src/html/metrics.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.html.metrics");
dojo.require("dojo.html.layout");
dojo.html.getScrollbar = function () {
	var scroll = document.createElement("div");
	scroll.style.width = "100px";
	scroll.style.height = "100px";
	scroll.style.overflow = "scroll";
	scroll.style.position = "absolute";
	scroll.style.top = "-300px";
	scroll.style.left = "0px";
	var test = document.createElement("div");
	test.style.width = "400px";
	test.style.height = "400px";
	scroll.appendChild(test);
	dojo.body().appendChild(scroll);
	var width = scroll.offsetWidth - scroll.clientWidth;
	dojo.body().removeChild(scroll);
	scroll.removeChild(test);
	scroll = test = null;
	return {width:width};
};
dojo.html.getFontMeasurements = function () {
	var heights = {"1em":0, "1ex":0, "100%":0, "12pt":0, "16px":0, "xx-small":0, "x-small":0, "small":0, "medium":0, "large":0, "x-large":0, "xx-large":0};
	if (dojo.render.html.ie) {
		document.documentElement.style.fontSize = "100%";
	}
	var div = document.createElement("div");
	div.style.position = "absolute";
	div.style.left = "-100px";
	div.style.top = "0";
	div.style.width = "30px";
	div.style.height = "1000em";
	div.style.border = "0";
	div.style.margin = "0";
	div.style.padding = "0";
	div.style.outline = "0";
	div.style.lineHeight = "1";
	div.style.overflow = "hidden";
	dojo.body().appendChild(div);
	for (var p in heights) {
		div.style.fontSize = p;
		heights[p] = Math.round(div.offsetHeight * 12 / 16) * 16 / 12 / 1000;
	}
	dojo.body().removeChild(div);
	div = null;
	return heights;
};
dojo.html._fontMeasurements = null;
dojo.html.getCachedFontMeasurements = function (recalculate) {
	if (recalculate || !dojo.html._fontMeasurements) {
		dojo.html._fontMeasurements = dojo.html.getFontMeasurements();
	}
	return dojo.html._fontMeasurements;
};
dojo.html.measureFragment = function (node, html, boxType) {
	var clone = node.cloneNode(true);
	clone.innerHTML = html;
	node.parentNode.appendChild(clone);
	var ret = dojo.html.getElementBox(clone, boxType);
	node.parentNode.removeChild(clone);
	clone = null;
	return ret;
};
dojo.html.getFittedFragment = function (node, html) {
	function cl(node) {
		var element = document.createElement(node.tagName);
		element.id = node.id + "-clone";
		element.className = node.className;
		for (var j = 0; j < node.attributes.length; j++) {
			if (node.attributes[j].specified) {
				if (node.attributes[j].nodeName.toLowerCase() != "style" && node.attributes[j].nodeName.toLowerCase() != "edited" && node.attributes[j].nodeName.toLowerCase() != "contenteditable" && node.attributes[j].nodeName.toLowerCase() != "id" && node.attributes[j].nodeName.toLowerCase() != "class") {
					element.setAttribute(node.attributes[j].nodeName.toLowerCase(), node.attributes[j].nodeValue);
				}
			}
		}
		return element;
	}
	var height = dojo.html.getFontMeasurements()["16px"];
	var n = cl(node);
	n.style.width = dojo.html.getBorderBox(node).width + "px";
	n.style.height = (height + 4) + "px";
	node.parentNode.appendChild(n);
	var rem = dojo.html.fitToElement(n, html);
	var ret = n.innerHTML;
	n.parentNode.removeChild(n);
	return ret;
};
dojo.html.fitToElement = function (node, html) {
	function cl(node) {
		var element = document.createElement(node.tagName);
		element.id = node.id + "-clone";
		element.className = node.className;
		for (var j = 0; j < node.attributes.length; j++) {
			if (node.attributes[j].specified) {
				if (node.attributes[j].nodeName.toLowerCase() != "style" && node.attributes[j].nodeName.toLowerCase() != "edited" && node.attributes[j].nodeName.toLowerCase() != "contenteditable" && node.attributes[j].nodeName.toLowerCase() != "id" && node.attributes[j].nodeName.toLowerCase() != "class") {
					element.setAttribute(node.attributes[j].nodeName.toLowerCase(), node.attributes[j].nodeValue);
				}
			}
		}
		return element;
	}
	var clone = cl(node);
	node.parentNode.appendChild(clone);
	var t = dojo.html.getBorderBox(node);
	clone.style.width = t.width + "px";
	var singletons = ["br", "img", "hr", "input", "!--"];
	var chop = ["<BR>", "<br>", "<br/>", "<br />", "<p></p>", "<P></P>"];
	var openTags = [];
	var str = html;
	var i = 0;
	var limit = str.length;
	var add = 0;
	var doLoop = true;
	clone.innerHTML = str;
	while (doLoop) {
		add = Math.round((limit - i) / 2);
		if (add <= 1) {
			doLoop = false;
		}
		i += add;
		clone.innerHTML = str.substr(0, i);
		if (clone.offsetHeight > t.height) {
			limit = i;
			i -= add;
		}
	}
	if (str.substr(0, i) != str) {
		var lastSpace = str.substr(0, i).lastIndexOf(" ");
		var lastNewLine = str.substr(0, i).lastIndexOf("\n");
		var lastGreater = str.substr(0, i).lastIndexOf(">");
		var lastLess = str.substr(0, i).lastIndexOf("<");
		if (lastLess <= lastGreater && lastNewLine == i - 1) {
			i = i;
		} else {
			if (lastSpace != -1 && lastSpace > lastGreater && lastGreater > lastLess) {
				i = lastSpace + 1;
			} else {
				if (lastLess > lastGreater) {
					i = lastLess;
				} else {
					if (lastGreater != -1) {
						i = lastGreater + 1;
					}
				}
			}
		}
	}
	str = str.substr(0, i);
	var ret = html.substr(str.length);
	var doPush = true;
	var tags = str.split("<");
	tags.shift();
	for (var j = 0; j < tags.length; j++) {
		tags[j] = tags[j].split(">")[0];
		if (tags[j].charAt(tags[j].length - 1) == "/") {
			continue;
		}
		if (tags[j].charAt(0) != "/") {
			for (var k = 0; k < singletons.length; k++) {
				if (tags[j].split(" ")[0].toLowerCase() == singletons[k]) {
					doPush = false;
				}
			}
			if (doPush) {
				openTags.push(tags[j]);
			}
			doPush = true;
		} else {
			openTags.pop();
		}
	}
	for (var j = 0; j < chop.length; j++) {
		if (ret.charAt(0) == "\n") {
			ret = ret.substr(1);
		}
		while (ret.indexOf(chop[j]) == 0) {
			ret = ret.substr(chop[j].length);
		}
	}
	for (var j = openTags.length - 1; j >= 0; j--) {
		if (str.lastIndexOf(openTags[j]) == (str.length - openTags[j].length - 1)) {
			str = str.substring(0, str.lastIndexOf(openTags[j]));
		} else {
			str += "</" + openTags[j] + ">";
		}
		if (ret.length > 0) {
			ret = "<" + openTags[j] + ">" + ret;
		}
	}
	for (var j = 0; j < chop.length; j++) {
		if (ret.charAt(0) == "\n") {
			ret = ret.substr(1);
		}
		while (ret.indexOf(chop[j]) == 0) {
			ret = ret.substr(chop[j].length);
		}
	}
	node.innerHTML = str;
	clone.parentNode.removeChild(clone);
	clone = null;
	return ret;
};


__CPAN_FILE__ src/html/selection.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.require("dojo.html.common");
dojo.provide("dojo.html.selection");
dojo.require("dojo.dom");
dojo.require("dojo.lang.common");
dojo.html.selectionType = {NONE:0, TEXT:1, CONTROL:2};
dojo.html.clearSelection = function () {
	var _window = dojo.global();
	var _document = dojo.doc();
	try {
		if (_window["getSelection"]) {
			if (dojo.render.html.safari) {
				_window.getSelection().collapse();
			} else {
				_window.getSelection().removeAllRanges();
			}
		} else {
			if (_document.selection) {
				if (_document.selection.empty) {
					_document.selection.empty();
				} else {
					if (_document.selection.clear) {
						_document.selection.clear();
					}
				}
			}
		}
		return true;
	}
	catch (e) {
		dojo.debug(e);
		return false;
	}
};
dojo.html.disableSelection = function (element) {
	element = dojo.byId(element) || dojo.body();
	var h = dojo.render.html;
	if (h.mozilla) {
		element.style.MozUserSelect = "none";
	} else {
		if (h.safari) {
			element.style.KhtmlUserSelect = "none";
		} else {
			if (h.ie) {
				element.unselectable = "on";
			} else {
				return false;
			}
		}
	}
	return true;
};
dojo.html.enableSelection = function (element) {
	element = dojo.byId(element) || dojo.body();
	var h = dojo.render.html;
	if (h.mozilla) {
		element.style.MozUserSelect = "";
	} else {
		if (h.safari) {
			element.style.KhtmlUserSelect = "";
		} else {
			if (h.ie) {
				element.unselectable = "off";
			} else {
				return false;
			}
		}
	}
	return true;
};
dojo.html.selectElement = function (element) {
	dojo.deprecated("dojo.html.selectElement", "replaced by dojo.html.selection.selectElementChildren", 0.5);
};
dojo.html.selectInputText = function (element) {
	var _window = dojo.global();
	var _document = dojo.doc();
	element = dojo.byId(element);
	if (_document["selection"] && dojo.body()["createTextRange"]) {
		var range = element.createTextRange();
		range.moveStart("character", 0);
		range.moveEnd("character", element.value.length);
		range.select();
	} else {
		if (_window["getSelection"]) {
			var selection = _window.getSelection();
			element.setSelectionRange(0, element.value.length);
		}
	}
	element.focus();
};
dojo.html.isSelectionCollapsed = function () {
	dojo.deprecated("dojo.html.isSelectionCollapsed", "replaced by dojo.html.selection.isCollapsed", 0.5);
	return dojo.html.selection.isCollapsed();
};
dojo.lang.mixin(dojo.html.selection, {getType:function () {
	if (dojo.doc()["selection"]) {
		return dojo.html.selectionType[dojo.doc().selection.type.toUpperCase()];
	} else {
		var stype = dojo.html.selectionType.TEXT;
		var oSel;
		try {
			oSel = dojo.global().getSelection();
		}
		catch (e) {
		}
		if (oSel && oSel.rangeCount == 1) {
			var oRange = oSel.getRangeAt(0);
			if (oRange.startContainer == oRange.endContainer && (oRange.endOffset - oRange.startOffset) == 1 && oRange.startContainer.nodeType != dojo.dom.TEXT_NODE) {
				stype = dojo.html.selectionType.CONTROL;
			}
		}
		return stype;
	}
}, isCollapsed:function () {
	var _window = dojo.global();
	var _document = dojo.doc();
	if (_document["selection"]) {
		return _document.selection.createRange().text == "";
	} else {
		if (_window["getSelection"]) {
			var selection = _window.getSelection();
			if (dojo.lang.isString(selection)) {
				return selection == "";
			} else {
				return selection.isCollapsed || selection.toString() == "";
			}
		}
	}
}, getSelectedElement:function () {
	if (dojo.html.selection.getType() == dojo.html.selectionType.CONTROL) {
		if (dojo.doc()["selection"]) {
			var range = dojo.doc().selection.createRange();
			if (range && range.item) {
				return dojo.doc().selection.createRange().item(0);
			}
		} else {
			var selection = dojo.global().getSelection();
			return selection.anchorNode.childNodes[selection.anchorOffset];
		}
	}
}, getParentElement:function () {
	if (dojo.html.selection.getType() == dojo.html.selectionType.CONTROL) {
		var p = dojo.html.selection.getSelectedElement();
		if (p) {
			return p.parentNode;
		}
	} else {
		if (dojo.doc()["selection"]) {
			return dojo.doc().selection.createRange().parentElement();
		} else {
			var selection = dojo.global().getSelection();
			if (selection) {
				var node = selection.anchorNode;
				while (node && node.nodeType != dojo.dom.ELEMENT_NODE) {
					node = node.parentNode;
				}
				return node;
			}
		}
	}
}, getSelectedText:function () {
	if (dojo.doc()["selection"]) {
		if (dojo.html.selection.getType() == dojo.html.selectionType.CONTROL) {
			return null;
		}
		return dojo.doc().selection.createRange().text;
	} else {
		var selection = dojo.global().getSelection();
		if (selection) {
			return selection.toString();
		}
	}
}, getSelectedHtml:function () {
	if (dojo.doc()["selection"]) {
		if (dojo.html.selection.getType() == dojo.html.selectionType.CONTROL) {
			return null;
		}
		return dojo.doc().selection.createRange().htmlText;
	} else {
		var selection = dojo.global().getSelection();
		if (selection && selection.rangeCount) {
			var frag = selection.getRangeAt(0).cloneContents();
			var div = document.createElement("div");
			div.appendChild(frag);
			return div.innerHTML;
		}
		return null;
	}
}, hasAncestorElement:function (tagName) {
	return (dojo.html.selection.getAncestorElement.apply(this, arguments) != null);
}, getAncestorElement:function (tagName) {
	var node = dojo.html.selection.getSelectedElement() || dojo.html.selection.getParentElement();
	while (node) {
		if (dojo.html.selection.isTag(node, arguments).length > 0) {
			return node;
		}
		node = node.parentNode;
	}
	return null;
}, isTag:function (node, tags) {
	if (node && node.tagName) {
		for (var i = 0; i < tags.length; i++) {
			if (node.tagName.toLowerCase() == String(tags[i]).toLowerCase()) {
				return String(tags[i]).toLowerCase();
			}
		}
	}
	return "";
}, selectElement:function (element) {
	var _window = dojo.global();
	var _document = dojo.doc();
	element = dojo.byId(element);
	if (_document.selection && dojo.body().createTextRange) {
		try {
			var range = dojo.body().createControlRange();
			range.addElement(element);
			range.select();
		}
		catch (e) {
			dojo.html.selection.selectElementChildren(element);
		}
	} else {
		if (_window["getSelection"]) {
			var selection = _window.getSelection();
			if (selection["removeAllRanges"]) {
				var range = _document.createRange();
				range.selectNode(element);
				selection.removeAllRanges();
				selection.addRange(range);
			}
		}
	}
}, selectElementChildren:function (element) {
	var _window = dojo.global();
	var _document = dojo.doc();
	element = dojo.byId(element);
	if (_document.selection && dojo.body().createTextRange) {
		var range = dojo.body().createTextRange();
		range.moveToElementText(element);
		range.select();
	} else {
		if (_window["getSelection"]) {
			var selection = _window.getSelection();
			if (selection["setBaseAndExtent"]) {
				selection.setBaseAndExtent(element, 0, element, element.innerText.length - 1);
			} else {
				if (selection["selectAllChildren"]) {
					selection.selectAllChildren(element);
				}
			}
		}
	}
}, getBookmark:function () {
	var bookmark;
	var _document = dojo.doc();
	if (_document["selection"]) {
		var range = _document.selection.createRange();
		bookmark = range.getBookmark();
	} else {
		var selection;
		try {
			selection = dojo.global().getSelection();
		}
		catch (e) {
		}
		if (selection) {
			var range = selection.getRangeAt(0);
			bookmark = range.cloneRange();
		} else {
			dojo.debug("No idea how to store the current selection for this browser!");
		}
	}
	return bookmark;
}, moveToBookmark:function (bookmark) {
	var _document = dojo.doc();
	if (_document["selection"]) {
		var range = _document.selection.createRange();
		range.moveToBookmark(bookmark);
		range.select();
	} else {
		var selection;
		try {
			selection = dojo.global().getSelection();
		}
		catch (e) {
		}
		if (selection && selection["removeAllRanges"]) {
			selection.removeAllRanges();
			selection.addRange(bookmark);
		} else {
			dojo.debug("No idea how to restore selection for this browser!");
		}
	}
}, collapse:function (beginning) {
	if (dojo.global()["getSelection"]) {
		var selection = dojo.global().getSelection();
		if (selection.removeAllRanges) {
			if (beginning) {
				selection.collapseToStart();
			} else {
				selection.collapseToEnd();
			}
		} else {
			dojo.global().getSelection().collapse(beginning);
		}
	} else {
		if (dojo.doc().selection) {
			var range = dojo.doc().selection.createRange();
			range.collapse(beginning);
			range.select();
		}
	}
}, remove:function () {
	if (dojo.doc().selection) {
		var selection = dojo.doc().selection;
		if (selection.type.toUpperCase() != "NONE") {
			selection.clear();
		}
		return selection;
	} else {
		var selection = dojo.global().getSelection();
		for (var i = 0; i < selection.rangeCount; i++) {
			selection.getRangeAt(i).deleteContents();
		}
		return selection;
	}
}});


__CPAN_FILE__ src/html/shadow.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.html.shadow");
dojo.require("dojo.lfx.shadow");
dojo.deprecated("dojo.html.shadow has been moved to dojo.lfx.", "0.5");
dojo.html.shadow = dojo.lfx.shadow;


__CPAN_FILE__ src/html/iframe.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.html.iframe");
dojo.require("dojo.html.util");
dojo.html.iframeContentWindow = function (iframe_el) {
	var win = dojo.html.getDocumentWindow(dojo.html.iframeContentDocument(iframe_el)) || dojo.html.iframeContentDocument(iframe_el).__parent__ || (iframe_el.name && document.frames[iframe_el.name]) || null;
	return win;
};
dojo.html.iframeContentDocument = function (iframe_el) {
	var doc = iframe_el.contentDocument || ((iframe_el.contentWindow) && (iframe_el.contentWindow.document)) || ((iframe_el.name) && (document.frames[iframe_el.name]) && (document.frames[iframe_el.name].document)) || null;
	return doc;
};
dojo.html.BackgroundIframe = function (node) {
	if (dojo.render.html.ie55 || dojo.render.html.ie60) {
		var html = "<iframe src='javascript:false'" + " style='position: absolute; left: 0px; top: 0px; width: 100%; height: 100%;" + "z-index: -1; filter:Alpha(Opacity=\"0\");' " + ">";
		this.iframe = dojo.doc().createElement(html);
		this.iframe.tabIndex = -1;
		if (node) {
			node.appendChild(this.iframe);
			this.domNode = node;
		} else {
			dojo.body().appendChild(this.iframe);
			this.iframe.style.display = "none";
		}
	}
};
dojo.lang.extend(dojo.html.BackgroundIframe, {iframe:null, onResized:function () {
	if (this.iframe && this.domNode && this.domNode.parentNode) {
		var outer = dojo.html.getMarginBox(this.domNode);
		if (outer.width == 0 || outer.height == 0) {
			dojo.lang.setTimeout(this, this.onResized, 100);
			return;
		}
		this.iframe.style.width = outer.width + "px";
		this.iframe.style.height = outer.height + "px";
	}
}, size:function (node) {
	if (!this.iframe) {
		return;
	}
	var coords = dojo.html.toCoordinateObject(node, true, dojo.html.boxSizing.BORDER_BOX);
	with (this.iframe.style) {
		width = coords.width + "px";
		height = coords.height + "px";
		left = coords.left + "px";
		top = coords.top + "px";
	}
}, setZIndex:function (node) {
	if (!this.iframe) {
		return;
	}
	if (dojo.dom.isNode(node)) {
		this.iframe.style.zIndex = dojo.html.getStyle(node, "z-index") - 1;
	} else {
		if (!isNaN(node)) {
			this.iframe.style.zIndex = node;
		}
	}
}, show:function () {
	if (this.iframe) {
		this.iframe.style.display = "block";
	}
}, hide:function () {
	if (this.iframe) {
		this.iframe.style.display = "none";
	}
}, remove:function () {
	if (this.iframe) {
		dojo.html.removeNode(this.iframe, true);
		delete this.iframe;
		this.iframe = null;
	}
}});


__CPAN_DIR__ src/html/images
__CPAN_FILE__ src/html/images/shadowBL.png
PNG

   
IHDR            gAMA  OX2   tEXtSoftware Adobe ImageReadyqe<   IDATx4 Dٲ!DH"
c<1zZ~_j84	8կ|Ȏ!UnHs ^S\NGD8pGY)q%	d4M"ʺͲN޶y.LeYxS_ =5bd5ʦ    IENDB`
__CPAN_FILE__ src/html/images/shadowTR.png
PNG

   
IHDR            gAMA  OX2   tEXtSoftware Adobe ImageReadyqe<   IDATx D(b%x]=Xt4Iqy&VJR;SZkh.`}':"`˲<1Ƽm[;+3ƤZ+
àbKB`*@{_%YZY >x{i>ׄ&nЄ]^`Ĵ,04 `ұ    IENDB`
__CPAN_FILE__ src/html/images/shadowBR.png
PNG

   
IHDR            gAMA  OX2   tEXtSoftware Adobe ImageReadyqe<   IDATx4OI <sE҄՝Z1u]"r*v O{cqiZډ*(bU	qٌ1r ) 霻sB^K'Z+Քw`oZJicL3K'ܶM ?    IENDB`
__CPAN_FILE__ src/html/images/shadowR.png
PNG

   
IHDR          C   gAMA  OX2   tEXtSoftware Adobe ImageReadyqe<   'IDATxbLII)g``
#H  @@    IENDB`
__CPAN_FILE__ src/html/images/shadowB.png
PNG

   
IHDR        d   gAMA  OX2   tEXtSoftware Adobe ImageReadyqe<  hIDATx1n0
Q}ܸХC<ɜ%:>A˨m߾ jZv   pFtum  -"  iG][6 Y7~ NAs~l 6 r7.9̖yk[;k6e6ϯm@ <wj ,  j[;3gS{Ʀف>J[DBm];s_ڣ y@ (ǎ|o^&[jM1@AGnm帶M  K_  񧟭-lj7v^_Zo&||3 x YvMm{d{  31Ws C7} ` |fZoN    IENDB`
__CPAN_FILE__ src/html/images/shadowL.png
PNG

   
IHDR          C   gAMA  OX2   tEXtSoftware Adobe ImageReadyqe<   &IDATxbLHHfee0(fdd4@ 
Zu    IENDB`
__CPAN_FILE__ src/html/images/shadowTL.png
PNG

   
IHDR            gAMA  OX2   tEXtSoftware Adobe ImageReadyqe<   IDATx,A0e[.qAΪ(QveY;rVkEymy8(R=ຮv][kIpHf.}c,Zf	>q&WGտ57=;@S	)챹âO 9uc    IENDB`
__CPAN_FILE__ src/html/images/shadowT.png
PNG

   
IHDR         8A   gAMA  OX2   tEXtSoftware Adobe ImageReadyqe<   *IDATxbHOOdb``b?%"Lqb\  7)    IENDB`
__CPAN_DIR__ src/event
__CPAN_FILE__ src/event/browser.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.event.browser");
dojo.require("dojo.event.common");
dojo._ie_clobber = new function () {
	this.clobberNodes = [];
	function nukeProp(node, prop) {
		try {
			node[prop] = null;
		}
		catch (e) {
		}
		try {
			delete node[prop];
		}
		catch (e) {
		}
		try {
			node.removeAttribute(prop);
		}
		catch (e) {
		}
	}
	this.clobber = function (nodeRef) {
		var na;
		var tna;
		if (nodeRef) {
			tna = nodeRef.all || nodeRef.getElementsByTagName("*");
			na = [nodeRef];
			for (var x = 0; x < tna.length; x++) {
				if (tna[x]["__doClobber__"]) {
					na.push(tna[x]);
				}
			}
		} else {
			try {
				window.onload = null;
			}
			catch (e) {
			}
			na = (this.clobberNodes.length) ? this.clobberNodes : document.all;
		}
		tna = null;
		var basis = {};
		for (var i = na.length - 1; i >= 0; i = i - 1) {
			var el = na[i];
			try {
				if (el && el["__clobberAttrs__"]) {
					for (var j = 0; j < el.__clobberAttrs__.length; j++) {
						nukeProp(el, el.__clobberAttrs__[j]);
					}
					nukeProp(el, "__clobberAttrs__");
					nukeProp(el, "__doClobber__");
				}
			}
			catch (e) {
			}
		}
		na = null;
	};
};
if (dojo.render.html.ie) {
	dojo.addOnUnload(function () {
		dojo._ie_clobber.clobber();
		try {
			if ((dojo["widget"]) && (dojo.widget["manager"])) {
				dojo.widget.manager.destroyAll();
			}
		}
		catch (e) {
		}
		if (dojo.widget) {
			for (var name in dojo.widget._templateCache) {
				if (dojo.widget._templateCache[name].node) {
					dojo.dom.destroyNode(dojo.widget._templateCache[name].node);
					dojo.widget._templateCache[name].node = null;
					delete dojo.widget._templateCache[name].node;
				}
			}
		}
		try {
			window.onload = null;
		}
		catch (e) {
		}
		try {
			window.onunload = null;
		}
		catch (e) {
		}
		dojo._ie_clobber.clobberNodes = [];
	});
}
dojo.event.browser = new function () {
	var clobberIdx = 0;
	this.normalizedEventName = function (eventName) {
		switch (eventName) {
		  case "CheckboxStateChange":
		  case "DOMAttrModified":
		  case "DOMMenuItemActive":
		  case "DOMMenuItemInactive":
		  case "DOMMouseScroll":
		  case "DOMNodeInserted":
		  case "DOMNodeRemoved":
		  case "RadioStateChange":
			return eventName;
			break;
		  default:
			var lcn = eventName.toLowerCase();
			return (lcn.indexOf("on") == 0) ? lcn.substr(2) : lcn;
			break;
		}
	};
	this.clean = function (node) {
		if (dojo.render.html.ie) {
			dojo._ie_clobber.clobber(node);
		}
	};
	this.addClobberNode = function (node) {
		if (!dojo.render.html.ie) {
			return;
		}
		if (!node["__doClobber__"]) {
			node.__doClobber__ = true;
			dojo._ie_clobber.clobberNodes.push(node);
			node.__clobberAttrs__ = [];
		}
	};
	this.addClobberNodeAttrs = function (node, props) {
		if (!dojo.render.html.ie) {
			return;
		}
		this.addClobberNode(node);
		for (var x = 0; x < props.length; x++) {
			node.__clobberAttrs__.push(props[x]);
		}
	};
	this.removeListener = function (node, evtName, fp, capture) {
		if (!capture) {
			var capture = false;
		}
		evtName = dojo.event.browser.normalizedEventName(evtName);
		if (evtName == "key") {
			if (dojo.render.html.ie) {
				this.removeListener(node, "onkeydown", fp, capture);
			}
			evtName = "keypress";
		}
		if (node.removeEventListener) {
			node.removeEventListener(evtName, fp, capture);
		}
	};
	this.addListener = function (node, evtName, fp, capture, dontFix) {
		if (!node) {
			return;
		}
		if (!capture) {
			var capture = false;
		}
		evtName = dojo.event.browser.normalizedEventName(evtName);
		if (evtName == "key") {
			if (dojo.render.html.ie) {
				this.addListener(node, "onkeydown", fp, capture, dontFix);
			}
			evtName = "keypress";
		}
		if (!dontFix) {
			var newfp = function (evt) {
				if (!evt) {
					evt = window.event;
				}
				var ret = fp(dojo.event.browser.fixEvent(evt, this));
				if (capture) {
					dojo.event.browser.stopEvent(evt);
				}
				return ret;
			};
		} else {
			newfp = fp;
		}
		if (node.addEventListener) {
			node.addEventListener(evtName, newfp, capture);
			return newfp;
		} else {
			evtName = "on" + evtName;
			if (typeof node[evtName] == "function") {
				var oldEvt = node[evtName];
				node[evtName] = function (e) {
					oldEvt(e);
					return newfp(e);
				};
			} else {
				node[evtName] = newfp;
			}
			if (dojo.render.html.ie) {
				this.addClobberNodeAttrs(node, [evtName]);
			}
			return newfp;
		}
	};
	this.isEvent = function (obj) {
		return (typeof obj != "undefined") && (obj) && (typeof Event != "undefined") && (obj.eventPhase);
	};
	this.currentEvent = null;
	this.callListener = function (listener, curTarget) {
		if (typeof listener != "function") {
			dojo.raise("listener not a function: " + listener);
		}
		dojo.event.browser.currentEvent.currentTarget = curTarget;
		return listener.call(curTarget, dojo.event.browser.currentEvent);
	};
	this._stopPropagation = function () {
		dojo.event.browser.currentEvent.cancelBubble = true;
	};
	this._preventDefault = function () {
		dojo.event.browser.currentEvent.returnValue = false;
	};
	this.keys = {KEY_BACKSPACE:8, KEY_TAB:9, KEY_CLEAR:12, KEY_ENTER:13, KEY_SHIFT:16, KEY_CTRL:17, KEY_ALT:18, KEY_PAUSE:19, KEY_CAPS_LOCK:20, KEY_ESCAPE:27, KEY_SPACE:32, KEY_PAGE_UP:33, KEY_PAGE_DOWN:34, KEY_END:35, KEY_HOME:36, KEY_LEFT_ARROW:37, KEY_UP_ARROW:38, KEY_RIGHT_ARROW:39, KEY_DOWN_ARROW:40, KEY_INSERT:45, KEY_DELETE:46, KEY_HELP:47, KEY_LEFT_WINDOW:91, KEY_RIGHT_WINDOW:92, KEY_SELECT:93, KEY_NUMPAD_0:96, KEY_NUMPAD_1:97, KEY_NUMPAD_2:98, KEY_NUMPAD_3:99, KEY_NUMPAD_4:100, KEY_NUMPAD_5:101, KEY_NUMPAD_6:102, KEY_NUMPAD_7:103, KEY_NUMPAD_8:104, KEY_NUMPAD_9:105, KEY_NUMPAD_MULTIPLY:106, KEY_NUMPAD_PLUS:107, KEY_NUMPAD_ENTER:108, KEY_NUMPAD_MINUS:109, KEY_NUMPAD_PERIOD:110, KEY_NUMPAD_DIVIDE:111, KEY_F1:112, KEY_F2:113, KEY_F3:114, KEY_F4:115, KEY_F5:116, KEY_F6:117, KEY_F7:118, KEY_F8:119, KEY_F9:120, KEY_F10:121, KEY_F11:122, KEY_F12:123, KEY_F13:124, KEY_F14:125, KEY_F15:126, KEY_NUM_LOCK:144, KEY_SCROLL_LOCK:145};
	this.revKeys = [];
	for (var key in this.keys) {
		this.revKeys[this.keys[key]] = key;
	}
	this.fixEvent = function (evt, sender) {
		if (!evt) {
			if (window["event"]) {
				evt = window.event;
			}
		}
		if ((evt["type"]) && (evt["type"].indexOf("key") == 0)) {
			evt.keys = this.revKeys;
			for (var key in this.keys) {
				evt[key] = this.keys[key];
			}
			if (evt["type"] == "keydown" && dojo.render.html.ie) {
				switch (evt.keyCode) {
				  case evt.KEY_SHIFT:
				  case evt.KEY_CTRL:
				  case evt.KEY_ALT:
				  case evt.KEY_CAPS_LOCK:
				  case evt.KEY_LEFT_WINDOW:
				  case evt.KEY_RIGHT_WINDOW:
				  case evt.KEY_SELECT:
				  case evt.KEY_NUM_LOCK:
				  case evt.KEY_SCROLL_LOCK:
				  case evt.KEY_NUMPAD_0:
				  case evt.KEY_NUMPAD_1:
				  case evt.KEY_NUMPAD_2:
				  case evt.KEY_NUMPAD_3:
				  case evt.KEY_NUMPAD_4:
				  case evt.KEY_NUMPAD_5:
				  case evt.KEY_NUMPAD_6:
				  case evt.KEY_NUMPAD_7:
				  case evt.KEY_NUMPAD_8:
				  case evt.KEY_NUMPAD_9:
				  case evt.KEY_NUMPAD_PERIOD:
					break;
				  case evt.KEY_NUMPAD_MULTIPLY:
				  case evt.KEY_NUMPAD_PLUS:
				  case evt.KEY_NUMPAD_ENTER:
				  case evt.KEY_NUMPAD_MINUS:
				  case evt.KEY_NUMPAD_DIVIDE:
					break;
				  case evt.KEY_PAUSE:
				  case evt.KEY_TAB:
				  case evt.KEY_BACKSPACE:
				  case evt.KEY_ENTER:
				  case evt.KEY_ESCAPE:
				  case evt.KEY_PAGE_UP:
				  case evt.KEY_PAGE_DOWN:
				  case evt.KEY_END:
				  case evt.KEY_HOME:
				  case evt.KEY_LEFT_ARROW:
				  case evt.KEY_UP_ARROW:
				  case evt.KEY_RIGHT_ARROW:
				  case evt.KEY_DOWN_ARROW:
				  case evt.KEY_INSERT:
				  case evt.KEY_DELETE:
				  case evt.KEY_F1:
				  case evt.KEY_F2:
				  case evt.KEY_F3:
				  case evt.KEY_F4:
				  case evt.KEY_F5:
				  case evt.KEY_F6:
				  case evt.KEY_F7:
				  case evt.KEY_F8:
				  case evt.KEY_F9:
				  case evt.KEY_F10:
				  case evt.KEY_F11:
				  case evt.KEY_F12:
				  case evt.KEY_F12:
				  case evt.KEY_F13:
				  case evt.KEY_F14:
				  case evt.KEY_F15:
				  case evt.KEY_CLEAR:
				  case evt.KEY_HELP:
					evt.key = evt.keyCode;
					break;
				  default:
					if (evt.ctrlKey || evt.altKey) {
						var unifiedCharCode = evt.keyCode;
						if (unifiedCharCode >= 65 && unifiedCharCode <= 90 && evt.shiftKey == false) {
							unifiedCharCode += 32;
						}
						if (unifiedCharCode >= 1 && unifiedCharCode <= 26 && evt.ctrlKey) {
							unifiedCharCode += 96;
						}
						evt.key = String.fromCharCode(unifiedCharCode);
					}
				}
			} else {
				if (evt["type"] == "keypress") {
					if (dojo.render.html.opera) {
						if (evt.which == 0) {
							evt.key = evt.keyCode;
						} else {
							if (evt.which > 0) {
								switch (evt.which) {
								  case evt.KEY_SHIFT:
								  case evt.KEY_CTRL:
								  case evt.KEY_ALT:
								  case evt.KEY_CAPS_LOCK:
								  case evt.KEY_NUM_LOCK:
								  case evt.KEY_SCROLL_LOCK:
									break;
								  case evt.KEY_PAUSE:
								  case evt.KEY_TAB:
								  case evt.KEY_BACKSPACE:
								  case evt.KEY_ENTER:
								  case evt.KEY_ESCAPE:
									evt.key = evt.which;
									break;
								  default:
									var unifiedCharCode = evt.which;
									if ((evt.ctrlKey || evt.altKey || evt.metaKey) && (evt.which >= 65 && evt.which <= 90 && evt.shiftKey == false)) {
										unifiedCharCode += 32;
									}
									evt.key = String.fromCharCode(unifiedCharCode);
								}
							}
						}
					} else {
						if (dojo.render.html.ie) {
							if (!evt.ctrlKey && !evt.altKey && evt.keyCode >= evt.KEY_SPACE) {
								evt.key = String.fromCharCode(evt.keyCode);
							}
						} else {
							if (dojo.render.html.safari) {
								switch (evt.keyCode) {
								  case 25:
									evt.key = evt.KEY_TAB;
									evt.shift = true;
									break;
								  case 63232:
									evt.key = evt.KEY_UP_ARROW;
									break;
								  case 63233:
									evt.key = evt.KEY_DOWN_ARROW;
									break;
								  case 63234:
									evt.key = evt.KEY_LEFT_ARROW;
									break;
								  case 63235:
									evt.key = evt.KEY_RIGHT_ARROW;
									break;
								  case 63236:
									evt.key = evt.KEY_F1;
									break;
								  case 63237:
									evt.key = evt.KEY_F2;
									break;
								  case 63238:
									evt.key = evt.KEY_F3;
									break;
								  case 63239:
									evt.key = evt.KEY_F4;
									break;
								  case 63240:
									evt.key = evt.KEY_F5;
									break;
								  case 63241:
									evt.key = evt.KEY_F6;
									break;
								  case 63242:
									evt.key = evt.KEY_F7;
									break;
								  case 63243:
									evt.key = evt.KEY_F8;
									break;
								  case 63244:
									evt.key = evt.KEY_F9;
									break;
								  case 63245:
									evt.key = evt.KEY_F10;
									break;
								  case 63246:
									evt.key = evt.KEY_F11;
									break;
								  case 63247:
									evt.key = evt.KEY_F12;
									break;
								  case 63250:
									evt.key = evt.KEY_PAUSE;
									break;
								  case 63272:
									evt.key = evt.KEY_DELETE;
									break;
								  case 63273:
									evt.key = evt.KEY_HOME;
									break;
								  case 63275:
									evt.key = evt.KEY_END;
									break;
								  case 63276:
									evt.key = evt.KEY_PAGE_UP;
									break;
								  case 63277:
									evt.key = evt.KEY_PAGE_DOWN;
									break;
								  case 63302:
									evt.key = evt.KEY_INSERT;
									break;
								  case 63248:
								  case 63249:
								  case 63289:
									break;
								  default:
									evt.key = evt.charCode >= evt.KEY_SPACE ? String.fromCharCode(evt.charCode) : evt.keyCode;
								}
							} else {
								evt.key = evt.charCode > 0 ? String.fromCharCode(evt.charCode) : evt.keyCode;
							}
						}
					}
				}
			}
		}
		if (dojo.render.html.ie) {
			if (!evt.target) {
				evt.target = evt.srcElement;
			}
			if (!evt.currentTarget) {
				evt.currentTarget = (sender ? sender : evt.srcElement);
			}
			if (!evt.layerX) {
				evt.layerX = evt.offsetX;
			}
			if (!evt.layerY) {
				evt.layerY = evt.offsetY;
			}
			var doc = (evt.srcElement && evt.srcElement.ownerDocument) ? evt.srcElement.ownerDocument : document;
			var docBody = ((dojo.render.html.ie55) || (doc["compatMode"] == "BackCompat")) ? doc.body : doc.documentElement;
			if (!evt.pageX) {
				evt.pageX = evt.clientX + (docBody.scrollLeft || 0);
			}
			if (!evt.pageY) {
				evt.pageY = evt.clientY + (docBody.scrollTop || 0);
			}
			if (evt.type == "mouseover") {
				evt.relatedTarget = evt.fromElement;
			}
			if (evt.type == "mouseout") {
				evt.relatedTarget = evt.toElement;
			}
			this.currentEvent = evt;
			evt.callListener = this.callListener;
			evt.stopPropagation = this._stopPropagation;
			evt.preventDefault = this._preventDefault;
		}
		return evt;
	};
	this.stopEvent = function (evt) {
		if (window.event) {
			evt.cancelBubble = true;
			evt.returnValue = false;
		} else {
			evt.preventDefault();
			evt.stopPropagation();
		}
	};
};


__CPAN_FILE__ src/event/topic.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.require("dojo.event.common");
dojo.provide("dojo.event.topic");
dojo.event.topic = new function () {
	this.topics = {};
	this.getTopic = function (topic) {
		if (!this.topics[topic]) {
			this.topics[topic] = new this.TopicImpl(topic);
		}
		return this.topics[topic];
	};
	this.registerPublisher = function (topic, obj, funcName) {
		var topic = this.getTopic(topic);
		topic.registerPublisher(obj, funcName);
	};
	this.subscribe = function (topic, obj, funcName) {
		var topic = this.getTopic(topic);
		topic.subscribe(obj, funcName);
	};
	this.unsubscribe = function (topic, obj, funcName) {
		var topic = this.getTopic(topic);
		topic.unsubscribe(obj, funcName);
	};
	this.destroy = function (topic) {
		this.getTopic(topic).destroy();
		delete this.topics[topic];
	};
	this.publishApply = function (topic, args) {
		var topic = this.getTopic(topic);
		topic.sendMessage.apply(topic, args);
	};
	this.publish = function (topic, message) {
		var topic = this.getTopic(topic);
		var args = [];
		for (var x = 1; x < arguments.length; x++) {
			args.push(arguments[x]);
		}
		topic.sendMessage.apply(topic, args);
	};
};
dojo.event.topic.TopicImpl = function (topicName) {
	this.topicName = topicName;
	this.subscribe = function (listenerObject, listenerMethod) {
		var tf = listenerMethod || listenerObject;
		var to = (!listenerMethod) ? dj_global : listenerObject;
		return dojo.event.kwConnect({srcObj:this, srcFunc:"sendMessage", adviceObj:to, adviceFunc:tf});
	};
	this.unsubscribe = function (listenerObject, listenerMethod) {
		var tf = (!listenerMethod) ? listenerObject : listenerMethod;
		var to = (!listenerMethod) ? null : listenerObject;
		return dojo.event.kwDisconnect({srcObj:this, srcFunc:"sendMessage", adviceObj:to, adviceFunc:tf});
	};
	this._getJoinPoint = function () {
		return dojo.event.MethodJoinPoint.getForMethod(this, "sendMessage");
	};
	this.setSquelch = function (shouldSquelch) {
		this._getJoinPoint().squelch = shouldSquelch;
	};
	this.destroy = function () {
		this._getJoinPoint().disconnect();
	};
	this.registerPublisher = function (publisherObject, publisherMethod) {
		dojo.event.connect(publisherObject, publisherMethod, this, "sendMessage");
	};
	this.sendMessage = function (message) {
	};
};


__CPAN_FILE__ src/event/common.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.event.common");
dojo.require("dojo.lang.array");
dojo.require("dojo.lang.extras");
dojo.require("dojo.lang.func");
dojo.event = new function () {
	this._canTimeout = dojo.lang.isFunction(dj_global["setTimeout"]) || dojo.lang.isAlien(dj_global["setTimeout"]);
	function interpolateArgs(args, searchForNames) {
		var dl = dojo.lang;
		var ao = {srcObj:dj_global, srcFunc:null, adviceObj:dj_global, adviceFunc:null, aroundObj:null, aroundFunc:null, adviceType:(args.length > 2) ? args[0] : "after", precedence:"last", once:false, delay:null, rate:0, adviceMsg:false, maxCalls:-1};
		switch (args.length) {
		  case 0:
			return;
		  case 1:
			return;
		  case 2:
			ao.srcFunc = args[0];
			ao.adviceFunc = args[1];
			break;
		  case 3:
			if ((dl.isObject(args[0])) && (dl.isString(args[1])) && (dl.isString(args[2]))) {
				ao.adviceType = "after";
				ao.srcObj = args[0];
				ao.srcFunc = args[1];
				ao.adviceFunc = args[2];
			} else {
				if ((dl.isString(args[1])) && (dl.isString(args[2]))) {
					ao.srcFunc = args[1];
					ao.adviceFunc = args[2];
				} else {
					if ((dl.isObject(args[0])) && (dl.isString(args[1])) && (dl.isFunction(args[2]))) {
						ao.adviceType = "after";
						ao.srcObj = args[0];
						ao.srcFunc = args[1];
						var tmpName = dl.nameAnonFunc(args[2], ao.adviceObj, searchForNames);
						ao.adviceFunc = tmpName;
					} else {
						if ((dl.isFunction(args[0])) && (dl.isObject(args[1])) && (dl.isString(args[2]))) {
							ao.adviceType = "after";
							ao.srcObj = dj_global;
							var tmpName = dl.nameAnonFunc(args[0], ao.srcObj, searchForNames);
							ao.srcFunc = tmpName;
							ao.adviceObj = args[1];
							ao.adviceFunc = args[2];
						}
					}
				}
			}
			break;
		  case 4:
			if ((dl.isObject(args[0])) && (dl.isObject(args[2]))) {
				ao.adviceType = "after";
				ao.srcObj = args[0];
				ao.srcFunc = args[1];
				ao.adviceObj = args[2];
				ao.adviceFunc = args[3];
			} else {
				if ((dl.isString(args[0])) && (dl.isString(args[1])) && (dl.isObject(args[2]))) {
					ao.adviceType = args[0];
					ao.srcObj = dj_global;
					ao.srcFunc = args[1];
					ao.adviceObj = args[2];
					ao.adviceFunc = args[3];
				} else {
					if ((dl.isString(args[0])) && (dl.isFunction(args[1])) && (dl.isObject(args[2]))) {
						ao.adviceType = args[0];
						ao.srcObj = dj_global;
						var tmpName = dl.nameAnonFunc(args[1], dj_global, searchForNames);
						ao.srcFunc = tmpName;
						ao.adviceObj = args[2];
						ao.adviceFunc = args[3];
					} else {
						if ((dl.isString(args[0])) && (dl.isObject(args[1])) && (dl.isString(args[2])) && (dl.isFunction(args[3]))) {
							ao.srcObj = args[1];
							ao.srcFunc = args[2];
							var tmpName = dl.nameAnonFunc(args[3], dj_global, searchForNames);
							ao.adviceObj = dj_global;
							ao.adviceFunc = tmpName;
						} else {
							if (dl.isObject(args[1])) {
								ao.srcObj = args[1];
								ao.srcFunc = args[2];
								ao.adviceObj = dj_global;
								ao.adviceFunc = args[3];
							} else {
								if (dl.isObject(args[2])) {
									ao.srcObj = dj_global;
									ao.srcFunc = args[1];
									ao.adviceObj = args[2];
									ao.adviceFunc = args[3];
								} else {
									ao.srcObj = ao.adviceObj = ao.aroundObj = dj_global;
									ao.srcFunc = args[1];
									ao.adviceFunc = args[2];
									ao.aroundFunc = args[3];
								}
							}
						}
					}
				}
			}
			break;
		  case 6:
			ao.srcObj = args[1];
			ao.srcFunc = args[2];
			ao.adviceObj = args[3];
			ao.adviceFunc = args[4];
			ao.aroundFunc = args[5];
			ao.aroundObj = dj_global;
			break;
		  default:
			ao.srcObj = args[1];
			ao.srcFunc = args[2];
			ao.adviceObj = args[3];
			ao.adviceFunc = args[4];
			ao.aroundObj = args[5];
			ao.aroundFunc = args[6];
			ao.once = args[7];
			ao.delay = args[8];
			ao.rate = args[9];
			ao.adviceMsg = args[10];
			ao.maxCalls = (!isNaN(parseInt(args[11]))) ? args[11] : -1;
			break;
		}
		if (dl.isFunction(ao.aroundFunc)) {
			var tmpName = dl.nameAnonFunc(ao.aroundFunc, ao.aroundObj, searchForNames);
			ao.aroundFunc = tmpName;
		}
		if (dl.isFunction(ao.srcFunc)) {
			ao.srcFunc = dl.getNameInObj(ao.srcObj, ao.srcFunc);
		}
		if (dl.isFunction(ao.adviceFunc)) {
			ao.adviceFunc = dl.getNameInObj(ao.adviceObj, ao.adviceFunc);
		}
		if ((ao.aroundObj) && (dl.isFunction(ao.aroundFunc))) {
			ao.aroundFunc = dl.getNameInObj(ao.aroundObj, ao.aroundFunc);
		}
		if (!ao.srcObj) {
			dojo.raise("bad srcObj for srcFunc: " + ao.srcFunc);
		}
		if (!ao.adviceObj) {
			dojo.raise("bad adviceObj for adviceFunc: " + ao.adviceFunc);
		}
		if (!ao.adviceFunc) {
			dojo.debug("bad adviceFunc for srcFunc: " + ao.srcFunc);
			dojo.debugShallow(ao);
		}
		return ao;
	}
	this.connect = function () {
		if (arguments.length == 1) {
			var ao = arguments[0];
		} else {
			var ao = interpolateArgs(arguments, true);
		}
		if (dojo.lang.isArray(ao.srcObj) && ao.srcObj != "") {
			var tmpAO = {};
			for (var x in ao) {
				tmpAO[x] = ao[x];
			}
			var mjps = [];
			dojo.lang.forEach(ao.srcObj, function (src) {
				if ((dojo.render.html.capable) && (dojo.lang.isString(src))) {
					src = dojo.byId(src);
				}
				tmpAO.srcObj = src;
				mjps.push(dojo.event.connect.call(dojo.event, tmpAO));
			});
			return mjps;
		}
		var mjp = dojo.event.MethodJoinPoint.getForMethod(ao.srcObj, ao.srcFunc);
		if (ao.adviceFunc) {
			var mjp2 = dojo.event.MethodJoinPoint.getForMethod(ao.adviceObj, ao.adviceFunc);
		}
		mjp.kwAddAdvice(ao);
		return mjp;
	};
	this.log = function (a1, a2) {
		var kwArgs;
		if ((arguments.length == 1) && (typeof a1 == "object")) {
			kwArgs = a1;
		} else {
			kwArgs = {srcObj:a1, srcFunc:a2};
		}
		kwArgs.adviceFunc = function () {
			var argsStr = [];
			for (var x = 0; x < arguments.length; x++) {
				argsStr.push(arguments[x]);
			}
			dojo.debug("(" + kwArgs.srcObj + ")." + kwArgs.srcFunc, ":", argsStr.join(", "));
		};
		this.kwConnect(kwArgs);
	};
	this.connectBefore = function () {
		var args = ["before"];
		for (var i = 0; i < arguments.length; i++) {
			args.push(arguments[i]);
		}
		return this.connect.apply(this, args);
	};
	this.connectAround = function () {
		var args = ["around"];
		for (var i = 0; i < arguments.length; i++) {
			args.push(arguments[i]);
		}
		return this.connect.apply(this, args);
	};
	this.connectOnce = function () {
		var ao = interpolateArgs(arguments, true);
		ao.once = true;
		return this.connect(ao);
	};
	this.connectRunOnce = function () {
		var ao = interpolateArgs(arguments, true);
		ao.maxCalls = 1;
		return this.connect(ao);
	};
	this._kwConnectImpl = function (kwArgs, disconnect) {
		var fn = (disconnect) ? "disconnect" : "connect";
		if (typeof kwArgs["srcFunc"] == "function") {
			kwArgs.srcObj = kwArgs["srcObj"] || dj_global;
			var tmpName = dojo.lang.nameAnonFunc(kwArgs.srcFunc, kwArgs.srcObj, true);
			kwArgs.srcFunc = tmpName;
		}
		if (typeof kwArgs["adviceFunc"] == "function") {
			kwArgs.adviceObj = kwArgs["adviceObj"] || dj_global;
			var tmpName = dojo.lang.nameAnonFunc(kwArgs.adviceFunc, kwArgs.adviceObj, true);
			kwArgs.adviceFunc = tmpName;
		}
		kwArgs.srcObj = kwArgs["srcObj"] || dj_global;
		kwArgs.adviceObj = kwArgs["adviceObj"] || kwArgs["targetObj"] || dj_global;
		kwArgs.adviceFunc = kwArgs["adviceFunc"] || kwArgs["targetFunc"];
		return dojo.event[fn](kwArgs);
	};
	this.kwConnect = function (kwArgs) {
		return this._kwConnectImpl(kwArgs, false);
	};
	this.disconnect = function () {
		if (arguments.length == 1) {
			var ao = arguments[0];
		} else {
			var ao = interpolateArgs(arguments, true);
		}
		if (!ao.adviceFunc) {
			return;
		}
		if (dojo.lang.isString(ao.srcFunc) && (ao.srcFunc.toLowerCase() == "onkey")) {
			if (dojo.render.html.ie) {
				ao.srcFunc = "onkeydown";
				this.disconnect(ao);
			}
			ao.srcFunc = "onkeypress";
		}
		if (!ao.srcObj[ao.srcFunc]) {
			return null;
		}
		var mjp = dojo.event.MethodJoinPoint.getForMethod(ao.srcObj, ao.srcFunc, true);
		mjp.removeAdvice(ao.adviceObj, ao.adviceFunc, ao.adviceType, ao.once);
		return mjp;
	};
	this.kwDisconnect = function (kwArgs) {
		return this._kwConnectImpl(kwArgs, true);
	};
};
dojo.event.MethodInvocation = function (join_point, obj, args) {
	this.jp_ = join_point;
	this.object = obj;
	this.args = [];
	for (var x = 0; x < args.length; x++) {
		this.args[x] = args[x];
	}
	this.around_index = -1;
};
dojo.event.MethodInvocation.prototype.proceed = function () {
	this.around_index++;
	if (this.around_index >= this.jp_.around.length) {
		return this.jp_.object[this.jp_.methodname].apply(this.jp_.object, this.args);
	} else {
		var ti = this.jp_.around[this.around_index];
		var mobj = ti[0] || dj_global;
		var meth = ti[1];
		return mobj[meth].call(mobj, this);
	}
};
dojo.event.MethodJoinPoint = function (obj, funcName) {
	this.object = obj || dj_global;
	this.methodname = funcName;
	this.methodfunc = this.object[funcName];
	this.squelch = false;
};
dojo.event.MethodJoinPoint.getForMethod = function (obj, funcName) {
	if (!obj) {
		obj = dj_global;
	}
	var ofn = obj[funcName];
	if (!ofn) {
		ofn = obj[funcName] = function () {
		};
		if (!obj[funcName]) {
			dojo.raise("Cannot set do-nothing method on that object " + funcName);
		}
	} else {
		if ((typeof ofn != "function") && (!dojo.lang.isFunction(ofn)) && (!dojo.lang.isAlien(ofn))) {
			return null;
		}
	}
	var jpname = funcName + "$joinpoint";
	var jpfuncname = funcName + "$joinpoint$method";
	var joinpoint = obj[jpname];
	if (!joinpoint) {
		var isNode = false;
		if (dojo.event["browser"]) {
			if ((obj["attachEvent"]) || (obj["nodeType"]) || (obj["addEventListener"])) {
				isNode = true;
				dojo.event.browser.addClobberNodeAttrs(obj, [jpname, jpfuncname, funcName]);
			}
		}
		var origArity = ofn.length;
		obj[jpfuncname] = ofn;
		joinpoint = obj[jpname] = new dojo.event.MethodJoinPoint(obj, jpfuncname);
		if (!isNode) {
			obj[funcName] = function () {
				return joinpoint.run.apply(joinpoint, arguments);
			};
		} else {
			obj[funcName] = function () {
				var args = [];
				if (!arguments.length) {
					var evt = null;
					try {
						if (obj.ownerDocument) {
							evt = obj.ownerDocument.parentWindow.event;
						} else {
							if (obj.documentElement) {
								evt = obj.documentElement.ownerDocument.parentWindow.event;
							} else {
								if (obj.event) {
									evt = obj.event;
								} else {
									evt = window.event;
								}
							}
						}
					}
					catch (e) {
						evt = window.event;
					}
					if (evt) {
						args.push(dojo.event.browser.fixEvent(evt, this));
					}
				} else {
					for (var x = 0; x < arguments.length; x++) {
						if ((x == 0) && (dojo.event.browser.isEvent(arguments[x]))) {
							args.push(dojo.event.browser.fixEvent(arguments[x], this));
						} else {
							args.push(arguments[x]);
						}
					}
				}
				return joinpoint.run.apply(joinpoint, args);
			};
		}
		obj[funcName].__preJoinArity = origArity;
	}
	return joinpoint;
};
dojo.lang.extend(dojo.event.MethodJoinPoint, {squelch:false, unintercept:function () {
	this.object[this.methodname] = this.methodfunc;
	this.before = [];
	this.after = [];
	this.around = [];
}, disconnect:dojo.lang.forward("unintercept"), run:function () {
	var obj = this.object || dj_global;
	var args = arguments;
	var aargs = [];
	for (var x = 0; x < args.length; x++) {
		aargs[x] = args[x];
	}
	var unrollAdvice = function (marr) {
		if (!marr) {
			dojo.debug("Null argument to unrollAdvice()");
			return;
		}
		var callObj = marr[0] || dj_global;
		var callFunc = marr[1];
		if (!callObj[callFunc]) {
			dojo.raise("function \"" + callFunc + "\" does not exist on \"" + callObj + "\"");
		}
		var aroundObj = marr[2] || dj_global;
		var aroundFunc = marr[3];
		var msg = marr[6];
		var maxCount = marr[7];
		if (maxCount > -1) {
			if (maxCount == 0) {
				return;
			}
			marr[7]--;
		}
		var undef;
		var to = {args:[], jp_:this, object:obj, proceed:function () {
			return callObj[callFunc].apply(callObj, to.args);
		}};
		to.args = aargs;
		var delay = parseInt(marr[4]);
		var hasDelay = ((!isNaN(delay)) && (marr[4] !== null) && (typeof marr[4] != "undefined"));
		if (marr[5]) {
			var rate = parseInt(marr[5]);
			var cur = new Date();
			var timerSet = false;
			if ((marr["last"]) && ((cur - marr.last) <= rate)) {
				if (dojo.event._canTimeout) {
					if (marr["delayTimer"]) {
						clearTimeout(marr.delayTimer);
					}
					var tod = parseInt(rate * 2);
					var mcpy = dojo.lang.shallowCopy(marr);
					marr.delayTimer = setTimeout(function () {
						mcpy[5] = 0;
						unrollAdvice(mcpy);
					}, tod);
				}
				return;
			} else {
				marr.last = cur;
			}
		}
		if (aroundFunc) {
			aroundObj[aroundFunc].call(aroundObj, to);
		} else {
			if ((hasDelay) && ((dojo.render.html) || (dojo.render.svg))) {
				dj_global["setTimeout"](function () {
					if (msg) {
						callObj[callFunc].call(callObj, to);
					} else {
						callObj[callFunc].apply(callObj, args);
					}
				}, delay);
			} else {
				if (msg) {
					callObj[callFunc].call(callObj, to);
				} else {
					callObj[callFunc].apply(callObj, args);
				}
			}
		}
	};
	var unRollSquelch = function () {
		if (this.squelch) {
			try {
				return unrollAdvice.apply(this, arguments);
			}
			catch (e) {
				dojo.debug(e);
			}
		} else {
			return unrollAdvice.apply(this, arguments);
		}
	};
	if ((this["before"]) && (this.before.length > 0)) {
		dojo.lang.forEach(this.before.concat(new Array()), unRollSquelch);
	}
	var result;
	try {
		if ((this["around"]) && (this.around.length > 0)) {
			var mi = new dojo.event.MethodInvocation(this, obj, args);
			result = mi.proceed();
		} else {
			if (this.methodfunc) {
				result = this.object[this.methodname].apply(this.object, args);
			}
		}
	}
	catch (e) {
		if (!this.squelch) {
			dojo.debug(e, "when calling", this.methodname, "on", this.object, "with arguments", args);
			dojo.raise(e);
		}
	}
	if ((this["after"]) && (this.after.length > 0)) {
		dojo.lang.forEach(this.after.concat(new Array()), unRollSquelch);
	}
	return (this.methodfunc) ? result : null;
}, getArr:function (kind) {
	var type = "after";
	if ((typeof kind == "string") && (kind.indexOf("before") != -1)) {
		type = "before";
	} else {
		if (kind == "around") {
			type = "around";
		}
	}
	if (!this[type]) {
		this[type] = [];
	}
	return this[type];
}, kwAddAdvice:function (args) {
	this.addAdvice(args["adviceObj"], args["adviceFunc"], args["aroundObj"], args["aroundFunc"], args["adviceType"], args["precedence"], args["once"], args["delay"], args["rate"], args["adviceMsg"], args["maxCalls"]);
}, addAdvice:function (thisAdviceObj, thisAdvice, thisAroundObj, thisAround, adviceType, precedence, once, delay, rate, asMessage, maxCalls) {
	var arr = this.getArr(adviceType);
	if (!arr) {
		dojo.raise("bad this: " + this);
	}
	var ao = [thisAdviceObj, thisAdvice, thisAroundObj, thisAround, delay, rate, asMessage, maxCalls];
	if (once) {
		if (this.hasAdvice(thisAdviceObj, thisAdvice, adviceType, arr) >= 0) {
			return;
		}
	}
	if (precedence == "first") {
		arr.unshift(ao);
	} else {
		arr.push(ao);
	}
}, hasAdvice:function (thisAdviceObj, thisAdvice, adviceType, arr) {
	if (!arr) {
		arr = this.getArr(adviceType);
	}
	var ind = -1;
	for (var x = 0; x < arr.length; x++) {
		var aao = (typeof thisAdvice == "object") ? (new String(thisAdvice)).toString() : thisAdvice;
		var a1o = (typeof arr[x][1] == "object") ? (new String(arr[x][1])).toString() : arr[x][1];
		if ((arr[x][0] == thisAdviceObj) && (a1o == aao)) {
			ind = x;
		}
	}
	return ind;
}, removeAdvice:function (thisAdviceObj, thisAdvice, adviceType, once) {
	var arr = this.getArr(adviceType);
	var ind = this.hasAdvice(thisAdviceObj, thisAdvice, adviceType, arr);
	if (ind == -1) {
		return false;
	}
	while (ind != -1) {
		arr.splice(ind, 1);
		if (once) {
			break;
		}
		ind = this.hasAdvice(thisAdviceObj, thisAdvice, adviceType, arr);
	}
	return true;
}});


__CPAN_FILE__ src/event/__package__.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.kwCompoundRequire({common:["dojo.event.common", "dojo.event.topic"], browser:["dojo.event.browser"], dashboard:["dojo.event.browser"]});
dojo.provide("dojo.event.*");


__CPAN_DIR__ src/dnd
__CPAN_FILE__ src/dnd/DragAndDrop.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.require("dojo.lang.common");
dojo.require("dojo.lang.func");
dojo.require("dojo.lang.declare");
dojo.provide("dojo.dnd.DragAndDrop");
dojo.declare("dojo.dnd.DragSource", null, {type:"", onDragEnd:function (evt) {
}, onDragStart:function (evt) {
}, onSelected:function (evt) {
}, unregister:function () {
	dojo.dnd.dragManager.unregisterDragSource(this);
}, reregister:function () {
	dojo.dnd.dragManager.registerDragSource(this);
}});
dojo.declare("dojo.dnd.DragObject", null, {type:"", register:function () {
	var dm = dojo.dnd.dragManager;
	if (dm["registerDragObject"]) {
		dm.registerDragObject(this);
	}
}, onDragStart:function (evt) {
}, onDragMove:function (evt) {
}, onDragOver:function (evt) {
}, onDragOut:function (evt) {
}, onDragEnd:function (evt) {
}, onDragLeave:dojo.lang.forward("onDragOut"), onDragEnter:dojo.lang.forward("onDragOver"), ondragout:dojo.lang.forward("onDragOut"), ondragover:dojo.lang.forward("onDragOver")});
dojo.declare("dojo.dnd.DropTarget", null, {acceptsType:function (type) {
	if (!dojo.lang.inArray(this.acceptedTypes, "*")) {
		if (!dojo.lang.inArray(this.acceptedTypes, type)) {
			return false;
		}
	}
	return true;
}, accepts:function (dragObjects) {
	if (!dojo.lang.inArray(this.acceptedTypes, "*")) {
		for (var i = 0; i < dragObjects.length; i++) {
			if (!dojo.lang.inArray(this.acceptedTypes, dragObjects[i].type)) {
				return false;
			}
		}
	}
	return true;
}, unregister:function () {
	dojo.dnd.dragManager.unregisterDropTarget(this);
}, onDragOver:function (evt) {
}, onDragOut:function (evt) {
}, onDragMove:function (evt) {
}, onDropStart:function (evt) {
}, onDrop:function (evt) {
}, onDropEnd:function () {
}}, function () {
	this.acceptedTypes = [];
});
dojo.dnd.DragEvent = function () {
	this.dragSource = null;
	this.dragObject = null;
	this.target = null;
	this.eventStatus = "success";
};
dojo.declare("dojo.dnd.DragManager", null, {selectedSources:[], dragObjects:[], dragSources:[], registerDragSource:function (source) {
}, dropTargets:[], registerDropTarget:function (target) {
}, lastDragTarget:null, currentDragTarget:null, onKeyDown:function () {
}, onMouseOut:function () {
}, onMouseMove:function () {
}, onMouseUp:function () {
}});


__CPAN_FILE__ src/dnd/TreeDragAndDropV3.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.dnd.TreeDragAndDropV3");
dojo.require("dojo.dnd.HtmlDragAndDrop");
dojo.require("dojo.lang.func");
dojo.require("dojo.lang.array");
dojo.require("dojo.lang.extras");
dojo.require("dojo.Deferred");
dojo.require("dojo.html.layout");
dojo.dnd.TreeDragSourceV3 = function (node, syncController, type, treeNode) {
	this.controller = syncController;
	this.treeNode = treeNode;
	dojo.dnd.HtmlDragSource.call(this, node, type);
};
dojo.inherits(dojo.dnd.TreeDragSourceV3, dojo.dnd.HtmlDragSource);
dojo.dnd.TreeDropTargetV3 = function (domNode, controller, type, treeNode) {
	this.treeNode = treeNode;
	this.controller = controller;
	dojo.dnd.HtmlDropTarget.call(this, domNode, type);
};
dojo.inherits(dojo.dnd.TreeDropTargetV3, dojo.dnd.HtmlDropTarget);
dojo.lang.extend(dojo.dnd.TreeDropTargetV3, {autoExpandDelay:1500, autoExpandTimer:null, position:null, indicatorStyle:"2px black groove", showIndicator:function (position) {
	if (this.position == position) {
		return;
	}
	this.hideIndicator();
	this.position = position;
	var node = this.treeNode;
	node.contentNode.style.width = dojo.html.getBorderBox(node.labelNode).width + "px";
	if (position == "onto") {
		node.contentNode.style.border = this.indicatorStyle;
	} else {
		if (position == "before") {
			node.contentNode.style.borderTop = this.indicatorStyle;
		} else {
			if (position == "after") {
				node.contentNode.style.borderBottom = this.indicatorStyle;
			}
		}
	}
}, hideIndicator:function () {
	this.treeNode.contentNode.style.borderBottom = "";
	this.treeNode.contentNode.style.borderTop = "";
	this.treeNode.contentNode.style.border = "";
	this.treeNode.contentNode.style.width = "";
	this.position = null;
}, onDragOver:function (e) {
	var accepts = dojo.dnd.HtmlDropTarget.prototype.onDragOver.apply(this, arguments);
	if (accepts && this.treeNode.isFolder && !this.treeNode.isExpanded) {
		this.setAutoExpandTimer();
	}
	if (accepts) {
		this.cacheNodeCoords();
	}
	return accepts;
}, accepts:function (dragObjects) {
	var accepts = dojo.dnd.HtmlDropTarget.prototype.accepts.apply(this, arguments);
	if (!accepts) {
		return false;
	}
	for (var i = 0; i < dragObjects.length; i++) {
		var sourceTreeNode = dragObjects[i].treeNode;
		if (sourceTreeNode === this.treeNode) {
			return false;
		}
	}
	return true;
}, setAutoExpandTimer:function () {
	var _this = this;
	var autoExpand = function () {
		if (dojo.dnd.dragManager.currentDropTarget === _this) {
			_this.controller.expand(_this.treeNode);
			dojo.dnd.dragManager.cacheTargetLocations();
		}
	};
	this.autoExpandTimer = dojo.lang.setTimeout(autoExpand, _this.autoExpandDelay);
}, getAcceptPosition:function (e, dragObjects) {
	var DndMode = this.treeNode.tree.DndMode;
	if (DndMode & dojo.widget.TreeV3.prototype.DndModes.ONTO && this.treeNode.actionIsDisabledNow(this.treeNode.actions.ADDCHILD)) {
		DndMode &= ~dojo.widget.TreeV3.prototype.DndModes.ONTO;
	}
	var position = this.getPosition(e, DndMode);
	if (position == "onto") {
		return position;
	}
	for (var i = 0; i < dragObjects.length; i++) {
		var source = dragObjects[i].dragSource;
		if (source.treeNode && this.isAdjacentNode(source.treeNode, position)) {
			continue;
		}
		if (!this.controller.canMove(source.treeNode ? source.treeNode : source, this.treeNode.parent)) {
			return false;
		}
	}
	return position;
}, onDropEnd:function (e) {
	this.clearAutoExpandTimer();
	this.hideIndicator();
}, onDragOut:function (e) {
	this.clearAutoExpandTimer();
	this.hideIndicator();
}, clearAutoExpandTimer:function () {
	if (this.autoExpandTimer) {
		clearTimeout(this.autoExpandTimer);
		this.autoExpandTimer = null;
	}
}, onDragMove:function (e, dragObjects) {
	var position = this.getAcceptPosition(e, dragObjects);
	if (position) {
		this.showIndicator(position);
	}
}, isAdjacentNode:function (sourceNode, position) {
	if (sourceNode === this.treeNode) {
		return true;
	}
	if (sourceNode.getNextSibling() === this.treeNode && position == "before") {
		return true;
	}
	if (sourceNode.getPreviousSibling() === this.treeNode && position == "after") {
		return true;
	}
	return false;
}, cacheNodeCoords:function () {
	var node = this.treeNode.contentNode;
	this.cachedNodeY = dojo.html.getAbsolutePosition(node).y;
	this.cachedNodeHeight = dojo.html.getBorderBox(node).height;
}, getPosition:function (e, DndMode) {
	var mousey = e.pageY || e.clientY + dojo.body().scrollTop;
	var relY = mousey - this.cachedNodeY;
	var p = relY / this.cachedNodeHeight;
	var position = "";
	if (DndMode & dojo.widget.TreeV3.prototype.DndModes.ONTO && DndMode & dojo.widget.TreeV3.prototype.DndModes.BETWEEN) {
		if (p <= 0.33) {
			position = "before";
		} else {
			if (p <= 0.66 || this.treeNode.isExpanded && this.treeNode.children.length && !this.treeNode.isLastChild()) {
				position = "onto";
			} else {
				position = "after";
			}
		}
	} else {
		if (DndMode & dojo.widget.TreeV3.prototype.DndModes.BETWEEN) {
			if (p <= 0.5 || this.treeNode.isExpanded && this.treeNode.children.length && !this.treeNode.isLastChild()) {
				position = "before";
			} else {
				position = "after";
			}
		} else {
			if (DndMode & dojo.widget.TreeV3.prototype.DndModes.ONTO) {
				position = "onto";
			}
		}
	}
	return position;
}, getTargetParentIndex:function (source, position) {
	var index = position == "before" ? this.treeNode.getParentIndex() : this.treeNode.getParentIndex() + 1;
	if (source.treeNode && this.treeNode.parent === source.treeNode.parent && this.treeNode.getParentIndex() > source.treeNode.getParentIndex()) {
		index--;
	}
	return index;
}, onDrop:function (e) {
	var position = this.position;
	var source = e.dragObject.dragSource;
	var targetParent, targetIndex;
	if (position == "onto") {
		targetParent = this.treeNode;
		targetIndex = 0;
	} else {
		targetIndex = this.getTargetParentIndex(source, position);
		targetParent = this.treeNode.parent;
	}
	var r = this.getDropHandler(e, source, targetParent, targetIndex)();
	return r;
}, getDropHandler:function (e, source, targetParent, targetIndex) {
	var handler;
	var _this = this;
	handler = function () {
		var result;
		if (source.treeNode) {
			result = _this.controller.move(source.treeNode, targetParent, targetIndex, true);
		} else {
			if (dojo.lang.isFunction(source.onDrop)) {
				source.onDrop(targetParent, targetIndex);
			}
			var treeNode = source.getTreeNode();
			if (treeNode) {
				result = _this.controller.createChild(targetParent, targetIndex, treeNode, true);
			} else {
				result = true;
			}
		}
		if (result instanceof dojo.Deferred) {
			var isSuccess = result.fired == 0;
			if (!isSuccess) {
				_this.handleDropError(source, targetParent, targetIndex, result);
			}
			return isSuccess;
		} else {
			return result;
		}
	};
	return handler;
}, handleDropError:function (source, parent, index, result) {
	dojo.debug("TreeDropTargetV3.handleDropError: DND error occured");
	dojo.debugShallow(result);
}});


__CPAN_FILE__ src/dnd/Sortable.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.dnd.Sortable");
dojo.require("dojo.dnd.*");
dojo.dnd.Sortable = function () {
};
dojo.lang.extend(dojo.dnd.Sortable, {ondragstart:function (e) {
	var dragObject = e.target;
	while (dragObject.parentNode && dragObject.parentNode != this) {
		dragObject = dragObject.parentNode;
	}
	return dragObject;
}});


__CPAN_FILE__ src/dnd/HtmlDragManager.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.dnd.HtmlDragManager");
dojo.require("dojo.dnd.DragAndDrop");
dojo.require("dojo.event.*");
dojo.require("dojo.lang.array");
dojo.require("dojo.html.common");
dojo.require("dojo.html.layout");
dojo.declare("dojo.dnd.HtmlDragManager", dojo.dnd.DragManager, {disabled:false, nestedTargets:false, mouseDownTimer:null, dsCounter:0, dsPrefix:"dojoDragSource", dropTargetDimensions:[], currentDropTarget:null, previousDropTarget:null, _dragTriggered:false, selectedSources:[], dragObjects:[], dragSources:[], dropTargets:[], currentX:null, currentY:null, lastX:null, lastY:null, mouseDownX:null, mouseDownY:null, threshold:7, dropAcceptable:false, cancelEvent:function (e) {
	e.stopPropagation();
	e.preventDefault();
}, registerDragSource:function (ds) {
	if (ds["domNode"]) {
		var dp = this.dsPrefix;
		var dpIdx = dp + "Idx_" + (this.dsCounter++);
		ds.dragSourceId = dpIdx;
		this.dragSources[dpIdx] = ds;
		ds.domNode.setAttribute(dp, dpIdx);
		if (dojo.render.html.ie) {
			dojo.event.browser.addListener(ds.domNode, "ondragstart", this.cancelEvent);
		}
	}
}, unregisterDragSource:function (ds) {
	if (ds["domNode"]) {
		var dp = this.dsPrefix;
		var dpIdx = ds.dragSourceId;
		delete ds.dragSourceId;
		delete this.dragSources[dpIdx];
		ds.domNode.setAttribute(dp, null);
		if (dojo.render.html.ie) {
			dojo.event.browser.removeListener(ds.domNode, "ondragstart", this.cancelEvent);
		}
	}
}, registerDropTarget:function (dt) {
	this.dropTargets.push(dt);
}, unregisterDropTarget:function (dt) {
	var index = dojo.lang.find(this.dropTargets, dt, true);
	if (index >= 0) {
		this.dropTargets.splice(index, 1);
	}
}, getDragSource:function (e) {
	var tn = e.target;
	if (tn === dojo.body()) {
		return;
	}
	var ta = dojo.html.getAttribute(tn, this.dsPrefix);
	while ((!ta) && (tn)) {
		tn = tn.parentNode;
		if ((!tn) || (tn === dojo.body())) {
			return;
		}
		ta = dojo.html.getAttribute(tn, this.dsPrefix);
	}
	return this.dragSources[ta];
}, onKeyDown:function (e) {
}, onMouseDown:function (e) {
	if (this.disabled) {
		return;
	}
	if (dojo.render.html.ie) {
		if (e.button != 1) {
			return;
		}
	} else {
		if (e.which != 1) {
			return;
		}
	}
	var target = e.target.nodeType == dojo.html.TEXT_NODE ? e.target.parentNode : e.target;
	if (dojo.html.isTag(target, "button", "textarea", "input", "select", "option")) {
		return;
	}
	var ds = this.getDragSource(e);
	if (!ds) {
		return;
	}
	if (!dojo.lang.inArray(this.selectedSources, ds)) {
		this.selectedSources.push(ds);
		ds.onSelected();
	}
	this.mouseDownX = e.pageX;
	this.mouseDownY = e.pageY;
	e.preventDefault();
	dojo.event.connect(document, "onmousemove", this, "onMouseMove");
}, onMouseUp:function (e, cancel) {
	if (this.selectedSources.length == 0) {
		return;
	}
	this.mouseDownX = null;
	this.mouseDownY = null;
	this._dragTriggered = false;
	e.dragSource = this.dragSource;
	if ((!e.shiftKey) && (!e.ctrlKey)) {
		if (this.currentDropTarget) {
			this.currentDropTarget.onDropStart();
		}
		dojo.lang.forEach(this.dragObjects, function (tempDragObj) {
			var ret = null;
			if (!tempDragObj) {
				return;
			}
			if (this.currentDropTarget) {
				e.dragObject = tempDragObj;
				var ce = this.currentDropTarget.domNode.childNodes;
				if (ce.length > 0) {
					e.dropTarget = ce[0];
					while (e.dropTarget == tempDragObj.domNode) {
						e.dropTarget = e.dropTarget.nextSibling;
					}
				} else {
					e.dropTarget = this.currentDropTarget.domNode;
				}
				if (this.dropAcceptable) {
					ret = this.currentDropTarget.onDrop(e);
				} else {
					this.currentDropTarget.onDragOut(e);
				}
			}
			e.dragStatus = this.dropAcceptable && ret ? "dropSuccess" : "dropFailure";
			dojo.lang.delayThese([function () {
				try {
					tempDragObj.dragSource.onDragEnd(e);
				}
				catch (err) {
					var ecopy = {};
					for (var i in e) {
						if (i == "type") {
							ecopy.type = "mouseup";
							continue;
						}
						ecopy[i] = e[i];
					}
					tempDragObj.dragSource.onDragEnd(ecopy);
				}
			}, function () {
				tempDragObj.onDragEnd(e);
			}]);
		}, this);
		this.selectedSources = [];
		this.dragObjects = [];
		this.dragSource = null;
		if (this.currentDropTarget) {
			this.currentDropTarget.onDropEnd();
		}
	} else {
	}
	dojo.event.disconnect(document, "onmousemove", this, "onMouseMove");
	this.currentDropTarget = null;
}, onScroll:function () {
	for (var i = 0; i < this.dragObjects.length; i++) {
		if (this.dragObjects[i].updateDragOffset) {
			this.dragObjects[i].updateDragOffset();
		}
	}
	if (this.dragObjects.length) {
		this.cacheTargetLocations();
	}
}, _dragStartDistance:function (x, y) {
	if ((!this.mouseDownX) || (!this.mouseDownX)) {
		return;
	}
	var dx = Math.abs(x - this.mouseDownX);
	var dx2 = dx * dx;
	var dy = Math.abs(y - this.mouseDownY);
	var dy2 = dy * dy;
	return parseInt(Math.sqrt(dx2 + dy2), 10);
}, cacheTargetLocations:function () {
	dojo.profile.start("cacheTargetLocations");
	this.dropTargetDimensions = [];
	dojo.lang.forEach(this.dropTargets, function (tempTarget) {
		var tn = tempTarget.domNode;
		if (!tn || !tempTarget.accepts([this.dragSource])) {
			return;
		}
		var abs = dojo.html.getAbsolutePosition(tn, true);
		var bb = dojo.html.getBorderBox(tn);
		this.dropTargetDimensions.push([[abs.x, abs.y], [abs.x + bb.width, abs.y + bb.height], tempTarget]);
	}, this);
	dojo.profile.end("cacheTargetLocations");
}, onMouseMove:function (e) {
	if ((dojo.render.html.ie) && (e.button != 1)) {
		this.currentDropTarget = null;
		this.onMouseUp(e, true);
		return;
	}
	if ((this.selectedSources.length) && (!this.dragObjects.length)) {
		var dx;
		var dy;
		if (!this._dragTriggered) {
			this._dragTriggered = (this._dragStartDistance(e.pageX, e.pageY) > this.threshold);
			if (!this._dragTriggered) {
				return;
			}
			dx = e.pageX - this.mouseDownX;
			dy = e.pageY - this.mouseDownY;
		}
		this.dragSource = this.selectedSources[0];
		dojo.lang.forEach(this.selectedSources, function (tempSource) {
			if (!tempSource) {
				return;
			}
			var tdo = tempSource.onDragStart(e);
			if (tdo) {
				tdo.onDragStart(e);
				tdo.dragOffset.y += dy;
				tdo.dragOffset.x += dx;
				tdo.dragSource = tempSource;
				this.dragObjects.push(tdo);
			}
		}, this);
		this.previousDropTarget = null;
		this.cacheTargetLocations();
	}
	dojo.lang.forEach(this.dragObjects, function (dragObj) {
		if (dragObj) {
			dragObj.onDragMove(e);
		}
	});
	if (this.currentDropTarget) {
		var c = dojo.html.toCoordinateObject(this.currentDropTarget.domNode, true);
		var dtp = [[c.x, c.y], [c.x + c.width, c.y + c.height]];
	}
	if ((!this.nestedTargets) && (dtp) && (this.isInsideBox(e, dtp))) {
		if (this.dropAcceptable) {
			this.currentDropTarget.onDragMove(e, this.dragObjects);
		}
	} else {
		var bestBox = this.findBestTarget(e);
		if (bestBox.target === null) {
			if (this.currentDropTarget) {
				this.currentDropTarget.onDragOut(e);
				this.previousDropTarget = this.currentDropTarget;
				this.currentDropTarget = null;
			}
			this.dropAcceptable = false;
			return;
		}
		if (this.currentDropTarget !== bestBox.target) {
			if (this.currentDropTarget) {
				this.previousDropTarget = this.currentDropTarget;
				this.currentDropTarget.onDragOut(e);
			}
			this.currentDropTarget = bestBox.target;
			e.dragObjects = this.dragObjects;
			this.dropAcceptable = this.currentDropTarget.onDragOver(e);
		} else {
			if (this.dropAcceptable) {
				this.currentDropTarget.onDragMove(e, this.dragObjects);
			}
		}
	}
}, findBestTarget:function (e) {
	var _this = this;
	var bestBox = new Object();
	bestBox.target = null;
	bestBox.points = null;
	dojo.lang.every(this.dropTargetDimensions, function (tmpDA) {
		if (!_this.isInsideBox(e, tmpDA)) {
			return true;
		}
		bestBox.target = tmpDA[2];
		bestBox.points = tmpDA;
		return Boolean(_this.nestedTargets);
	});
	return bestBox;
}, isInsideBox:function (e, coords) {
	if ((e.pageX > coords[0][0]) && (e.pageX < coords[1][0]) && (e.pageY > coords[0][1]) && (e.pageY < coords[1][1])) {
		return true;
	}
	return false;
}, onMouseOver:function (e) {
}, onMouseOut:function (e) {
}});
dojo.dnd.dragManager = new dojo.dnd.HtmlDragManager();
(function () {
	var d = document;
	var dm = dojo.dnd.dragManager;
	dojo.event.connect(d, "onkeydown", dm, "onKeyDown");
	dojo.event.connect(d, "onmouseover", dm, "onMouseOver");
	dojo.event.connect(d, "onmouseout", dm, "onMouseOut");
	dojo.event.connect(d, "onmousedown", dm, "onMouseDown");
	dojo.event.connect(d, "onmouseup", dm, "onMouseUp");
	dojo.event.connect(window, "onscroll", dm, "onScroll");
})();


__CPAN_FILE__ src/dnd/HtmlDragCopy.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.dnd.HtmlDragCopy");
dojo.require("dojo.dnd.*");
dojo.declare("dojo.dnd.HtmlDragCopySource", dojo.dnd.HtmlDragSource, function (node, type, copyOnce) {
	this.copyOnce = copyOnce;
	this.makeCopy = true;
}, {onDragStart:function () {
	var dragObj = new dojo.dnd.HtmlDragCopyObject(this.dragObject, this.type, this);
	if (this.dragClass) {
		dragObj.dragClass = this.dragClass;
	}
	if (this.constrainToContainer) {
		dragObj.constrainTo(this.constrainingContainer || this.domNode.parentNode);
	}
	return dragObj;
}, onSelected:function () {
	for (var i = 0; i < this.dragObjects.length; i++) {
		dojo.dnd.dragManager.selectedSources.push(new dojo.dnd.HtmlDragCopySource(this.dragObjects[i]));
	}
}});
dojo.declare("dojo.dnd.HtmlDragCopyObject", dojo.dnd.HtmlDragObject, function (dragObject, type, source) {
	this.copySource = source;
}, {onDragStart:function (e) {
	dojo.dnd.HtmlDragCopyObject.superclass.onDragStart.apply(this, arguments);
	if (this.copySource.makeCopy) {
		this.sourceNode = this.domNode;
		this.domNode = this.domNode.cloneNode(true);
	}
}, onDragEnd:function (e) {
	switch (e.dragStatus) {
	  case "dropFailure":
		var startCoords = dojo.html.getAbsolutePosition(this.dragClone, true);
		var endCoords = {left:this.dragStartPosition.x + 1, top:this.dragStartPosition.y + 1};
		var anim = dojo.lfx.slideTo(this.dragClone, endCoords, 500, dojo.lfx.easeOut);
		var dragObject = this;
		dojo.event.connect(anim, "onEnd", function (e) {
			dojo.lang.setTimeout(function () {
				dojo.html.removeNode(dragObject.dragClone);
				dragObject.dragClone = null;
				if (dragObject.copySource.makeCopy) {
					dojo.html.removeNode(dragObject.domNode);
					dragObject.domNode = dragObject.sourceNode;
					dragObject.sourceNode = null;
				}
			}, 200);
		});
		anim.play();
		dojo.event.topic.publish("dragEnd", {source:this});
		return;
	}
	dojo.dnd.HtmlDragCopyObject.superclass.onDragEnd.apply(this, arguments);
	this.copySource.dragObject = this.domNode;
	if (this.copySource.copyOnce) {
		this.copySource.makeCopy = false;
	}
	new dojo.dnd.HtmlDragCopySource(this.sourceNode, this.type, this.copySource.copyOnce);
	this.sourceNode = null;
}});


__CPAN_FILE__ src/dnd/HtmlDragMove.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.dnd.HtmlDragMove");
dojo.require("dojo.dnd.*");
dojo.declare("dojo.dnd.HtmlDragMoveSource", dojo.dnd.HtmlDragSource, {onDragStart:function () {
	var dragObj = new dojo.dnd.HtmlDragMoveObject(this.dragObject, this.type);
	if (this.constrainToContainer) {
		dragObj.constrainTo(this.constrainingContainer);
	}
	return dragObj;
}, onSelected:function () {
	for (var i = 0; i < this.dragObjects.length; i++) {
		dojo.dnd.dragManager.selectedSources.push(new dojo.dnd.HtmlDragMoveSource(this.dragObjects[i]));
	}
}});
dojo.declare("dojo.dnd.HtmlDragMoveObject", dojo.dnd.HtmlDragObject, {onDragStart:function (e) {
	dojo.html.clearSelection();
	this.dragClone = this.domNode;
	if (dojo.html.getComputedStyle(this.domNode, "position") != "absolute") {
		this.domNode.style.position = "relative";
	}
	var left = parseInt(dojo.html.getComputedStyle(this.domNode, "left"));
	var top = parseInt(dojo.html.getComputedStyle(this.domNode, "top"));
	this.dragStartPosition = {x:isNaN(left) ? 0 : left, y:isNaN(top) ? 0 : top};
	this.scrollOffset = dojo.html.getScroll().offset;
	this.dragOffset = {y:this.dragStartPosition.y - e.pageY, x:this.dragStartPosition.x - e.pageX};
	this.containingBlockPosition = {x:0, y:0};
	if (this.constrainToContainer) {
		this.constraints = this.getConstraints();
	}
	dojo.event.connect(this.domNode, "onclick", this, "_squelchOnClick");
}, onDragEnd:function (e) {
}, setAbsolutePosition:function (x, y) {
	if (!this.disableY) {
		this.domNode.style.top = y + "px";
	}
	if (!this.disableX) {
		this.domNode.style.left = x + "px";
	}
}, _squelchOnClick:function (e) {
	dojo.event.browser.stopEvent(e);
	dojo.event.disconnect(this.domNode, "onclick", this, "_squelchOnClick");
}});


__CPAN_FILE__ src/dnd/__package__.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.kwCompoundRequire({common:["dojo.dnd.DragAndDrop"], browser:["dojo.dnd.HtmlDragAndDrop"], dashboard:["dojo.dnd.HtmlDragAndDrop"]});
dojo.provide("dojo.dnd.*");


__CPAN_FILE__ src/dnd/HtmlDragAndDrop.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.dnd.HtmlDragAndDrop");
dojo.require("dojo.dnd.HtmlDragManager");
dojo.require("dojo.dnd.DragAndDrop");
dojo.require("dojo.html.*");
dojo.require("dojo.html.display");
dojo.require("dojo.html.util");
dojo.require("dojo.html.selection");
dojo.require("dojo.html.iframe");
dojo.require("dojo.lang.extras");
dojo.require("dojo.lfx.*");
dojo.require("dojo.event.*");
dojo.declare("dojo.dnd.HtmlDragSource", dojo.dnd.DragSource, {dragClass:"", onDragStart:function () {
	var dragObj = new dojo.dnd.HtmlDragObject(this.dragObject, this.type);
	if (this.dragClass) {
		dragObj.dragClass = this.dragClass;
	}
	if (this.constrainToContainer) {
		dragObj.constrainTo(this.constrainingContainer || this.domNode.parentNode);
	}
	return dragObj;
}, setDragHandle:function (node) {
	node = dojo.byId(node);
	dojo.dnd.dragManager.unregisterDragSource(this);
	this.domNode = node;
	dojo.dnd.dragManager.registerDragSource(this);
}, setDragTarget:function (node) {
	this.dragObject = node;
}, constrainTo:function (container) {
	this.constrainToContainer = true;
	if (container) {
		this.constrainingContainer = container;
	}
}, onSelected:function () {
	for (var i = 0; i < this.dragObjects.length; i++) {
		dojo.dnd.dragManager.selectedSources.push(new dojo.dnd.HtmlDragSource(this.dragObjects[i]));
	}
}, addDragObjects:function (el) {
	for (var i = 0; i < arguments.length; i++) {
		this.dragObjects.push(dojo.byId(arguments[i]));
	}
}}, function (node, type) {
	node = dojo.byId(node);
	this.dragObjects = [];
	this.constrainToContainer = false;
	if (node) {
		this.domNode = node;
		this.dragObject = node;
		this.type = (type) || (this.domNode.nodeName.toLowerCase());
		dojo.dnd.DragSource.prototype.reregister.call(this);
	}
});
dojo.declare("dojo.dnd.HtmlDragObject", dojo.dnd.DragObject, {dragClass:"", opacity:0.5, createIframe:true, disableX:false, disableY:false, createDragNode:function () {
	var node = this.domNode.cloneNode(true);
	if (this.dragClass) {
		dojo.html.addClass(node, this.dragClass);
	}
	if (this.opacity < 1) {
		dojo.html.setOpacity(node, this.opacity);
	}
	var ltn = node.tagName.toLowerCase();
	var isTr = (ltn == "tr");
	if ((isTr) || (ltn == "tbody")) {
		var doc = this.domNode.ownerDocument;
		var table = doc.createElement("table");
		if (isTr) {
			var tbody = doc.createElement("tbody");
			table.appendChild(tbody);
			tbody.appendChild(node);
		} else {
			table.appendChild(node);
		}
		var tmpSrcTr = ((isTr) ? this.domNode : this.domNode.firstChild);
		var tmpDstTr = ((isTr) ? node : node.firstChild);
		var domTds = tmpSrcTr.childNodes;
		var cloneTds = tmpDstTr.childNodes;
		for (var i = 0; i < domTds.length; i++) {
			if ((cloneTds[i]) && (cloneTds[i].style)) {
				cloneTds[i].style.width = dojo.html.getContentBox(domTds[i]).width + "px";
			}
		}
		node = table;
	}
	if ((dojo.render.html.ie55 || dojo.render.html.ie60) && this.createIframe) {
		with (node.style) {
			top = "0px";
			left = "0px";
		}
		var outer = document.createElement("div");
		outer.appendChild(node);
		this.bgIframe = new dojo.html.BackgroundIframe(outer);
		outer.appendChild(this.bgIframe.iframe);
		node = outer;
	}
	node.style.zIndex = 999;
	return node;
}, onDragStart:function (e) {
	dojo.html.clearSelection();
	this.scrollOffset = dojo.html.getScroll().offset;
	this.dragStartPosition = dojo.html.getAbsolutePosition(this.domNode, true);
	this.dragOffset = {y:this.dragStartPosition.y - e.pageY, x:this.dragStartPosition.x - e.pageX};
	this.dragClone = this.createDragNode();
	this.containingBlockPosition = this.domNode.offsetParent ? dojo.html.getAbsolutePosition(this.domNode.offsetParent, true) : {x:0, y:0};
	if (this.constrainToContainer) {
		this.constraints = this.getConstraints();
	}
	with (this.dragClone.style) {
		position = "absolute";
		top = this.dragOffset.y + e.pageY + "px";
		left = this.dragOffset.x + e.pageX + "px";
	}
	dojo.body().appendChild(this.dragClone);
	dojo.event.topic.publish("dragStart", {source:this});
}, getConstraints:function () {
	if (this.constrainingContainer.nodeName.toLowerCase() == "body") {
		var viewport = dojo.html.getViewport();
		var width = viewport.width;
		var height = viewport.height;
		var scroll = dojo.html.getScroll().offset;
		var x = scroll.x;
		var y = scroll.y;
	} else {
		var content = dojo.html.getContentBox(this.constrainingContainer);
		width = content.width;
		height = content.height;
		x = this.containingBlockPosition.x + dojo.html.getPixelValue(this.constrainingContainer, "padding-left", true) + dojo.html.getBorderExtent(this.constrainingContainer, "left");
		y = this.containingBlockPosition.y + dojo.html.getPixelValue(this.constrainingContainer, "padding-top", true) + dojo.html.getBorderExtent(this.constrainingContainer, "top");
	}
	var mb = dojo.html.getMarginBox(this.domNode);
	return {minX:x, minY:y, maxX:x + width - mb.width, maxY:y + height - mb.height};
}, updateDragOffset:function () {
	var scroll = dojo.html.getScroll().offset;
	if (scroll.y != this.scrollOffset.y) {
		var diff = scroll.y - this.scrollOffset.y;
		this.dragOffset.y += diff;
		this.scrollOffset.y = scroll.y;
	}
	if (scroll.x != this.scrollOffset.x) {
		var diff = scroll.x - this.scrollOffset.x;
		this.dragOffset.x += diff;
		this.scrollOffset.x = scroll.x;
	}
}, onDragMove:function (e) {
	this.updateDragOffset();
	var x = this.dragOffset.x + e.pageX;
	var y = this.dragOffset.y + e.pageY;
	if (this.constrainToContainer) {
		if (x < this.constraints.minX) {
			x = this.constraints.minX;
		}
		if (y < this.constraints.minY) {
			y = this.constraints.minY;
		}
		if (x > this.constraints.maxX) {
			x = this.constraints.maxX;
		}
		if (y > this.constraints.maxY) {
			y = this.constraints.maxY;
		}
	}
	this.setAbsolutePosition(x, y);
	dojo.event.topic.publish("dragMove", {source:this});
}, setAbsolutePosition:function (x, y) {
	if (!this.disableY) {
		this.dragClone.style.top = y + "px";
	}
	if (!this.disableX) {
		this.dragClone.style.left = x + "px";
	}
}, onDragEnd:function (e) {
	switch (e.dragStatus) {
	  case "dropSuccess":
		dojo.html.removeNode(this.dragClone);
		this.dragClone = null;
		break;
	  case "dropFailure":
		var startCoords = dojo.html.getAbsolutePosition(this.dragClone, true);
		var endCoords = {left:this.dragStartPosition.x + 1, top:this.dragStartPosition.y + 1};
		var anim = dojo.lfx.slideTo(this.dragClone, endCoords, 300);
		var dragObject = this;
		dojo.event.connect(anim, "onEnd", function (e) {
			dojo.html.removeNode(dragObject.dragClone);
			dragObject.dragClone = null;
		});
		anim.play();
		break;
	}
	dojo.event.topic.publish("dragEnd", {source:this});
}, constrainTo:function (container) {
	this.constrainToContainer = true;
	if (container) {
		this.constrainingContainer = container;
	} else {
		this.constrainingContainer = this.domNode.parentNode;
	}
}}, function (node, type) {
	this.domNode = dojo.byId(node);
	this.type = type;
	this.constrainToContainer = false;
	this.dragSource = null;
	dojo.dnd.DragObject.prototype.register.call(this);
});
dojo.declare("dojo.dnd.HtmlDropTarget", dojo.dnd.DropTarget, {vertical:false, onDragOver:function (e) {
	if (!this.accepts(e.dragObjects)) {
		return false;
	}
	this.childBoxes = [];
	for (var i = 0, child; i < this.domNode.childNodes.length; i++) {
		child = this.domNode.childNodes[i];
		if (child.nodeType != dojo.html.ELEMENT_NODE) {
			continue;
		}
		var pos = dojo.html.getAbsolutePosition(child, true);
		var inner = dojo.html.getBorderBox(child);
		this.childBoxes.push({top:pos.y, bottom:pos.y + inner.height, left:pos.x, right:pos.x + inner.width, height:inner.height, width:inner.width, node:child});
	}
	return true;
}, _getNodeUnderMouse:function (e) {
	for (var i = 0, child; i < this.childBoxes.length; i++) {
		with (this.childBoxes[i]) {
			if (e.pageX >= left && e.pageX <= right && e.pageY >= top && e.pageY <= bottom) {
				return i;
			}
		}
	}
	return -1;
}, createDropIndicator:function () {
	this.dropIndicator = document.createElement("div");
	with (this.dropIndicator.style) {
		position = "absolute";
		zIndex = 999;
		if (this.vertical) {
			borderLeftWidth = "1px";
			borderLeftColor = "black";
			borderLeftStyle = "solid";
			height = dojo.html.getBorderBox(this.domNode).height + "px";
			top = dojo.html.getAbsolutePosition(this.domNode, true).y + "px";
		} else {
			borderTopWidth = "1px";
			borderTopColor = "black";
			borderTopStyle = "solid";
			width = dojo.html.getBorderBox(this.domNode).width + "px";
			left = dojo.html.getAbsolutePosition(this.domNode, true).x + "px";
		}
	}
}, onDragMove:function (e, dragObjects) {
	var i = this._getNodeUnderMouse(e);
	if (!this.dropIndicator) {
		this.createDropIndicator();
	}
	var gravity = this.vertical ? dojo.html.gravity.WEST : dojo.html.gravity.NORTH;
	var hide = false;
	if (i < 0) {
		if (this.childBoxes.length) {
			var before = (dojo.html.gravity(this.childBoxes[0].node, e) & gravity);
			if (before) {
				hide = true;
			}
		} else {
			var before = true;
		}
	} else {
		var child = this.childBoxes[i];
		var before = (dojo.html.gravity(child.node, e) & gravity);
		if (child.node === dragObjects[0].dragSource.domNode) {
			hide = true;
		} else {
			var currentPosChild = before ? (i > 0 ? this.childBoxes[i - 1] : child) : (i < this.childBoxes.length - 1 ? this.childBoxes[i + 1] : child);
			if (currentPosChild.node === dragObjects[0].dragSource.domNode) {
				hide = true;
			}
		}
	}
	if (hide) {
		this.dropIndicator.style.display = "none";
		return;
	} else {
		this.dropIndicator.style.display = "";
	}
	this.placeIndicator(e, dragObjects, i, before);
	if (!dojo.html.hasParent(this.dropIndicator)) {
		dojo.body().appendChild(this.dropIndicator);
	}
}, placeIndicator:function (e, dragObjects, boxIndex, before) {
	var targetProperty = this.vertical ? "left" : "top";
	var child;
	if (boxIndex < 0) {
		if (this.childBoxes.length) {
			child = before ? this.childBoxes[0] : this.childBoxes[this.childBoxes.length - 1];
		} else {
			this.dropIndicator.style[targetProperty] = dojo.html.getAbsolutePosition(this.domNode, true)[this.vertical ? "x" : "y"] + "px";
		}
	} else {
		child = this.childBoxes[boxIndex];
	}
	if (child) {
		this.dropIndicator.style[targetProperty] = (before ? child[targetProperty] : child[this.vertical ? "right" : "bottom"]) + "px";
		if (this.vertical) {
			this.dropIndicator.style.height = child.height + "px";
			this.dropIndicator.style.top = child.top + "px";
		} else {
			this.dropIndicator.style.width = child.width + "px";
			this.dropIndicator.style.left = child.left + "px";
		}
	}
}, onDragOut:function (e) {
	if (this.dropIndicator) {
		dojo.html.removeNode(this.dropIndicator);
		delete this.dropIndicator;
	}
}, onDrop:function (e) {
	this.onDragOut(e);
	var i = this._getNodeUnderMouse(e);
	var gravity = this.vertical ? dojo.html.gravity.WEST : dojo.html.gravity.NORTH;
	if (i < 0) {
		if (this.childBoxes.length) {
			if (dojo.html.gravity(this.childBoxes[0].node, e) & gravity) {
				return this.insert(e, this.childBoxes[0].node, "before");
			} else {
				return this.insert(e, this.childBoxes[this.childBoxes.length - 1].node, "after");
			}
		}
		return this.insert(e, this.domNode, "append");
	}
	var child = this.childBoxes[i];
	if (dojo.html.gravity(child.node, e) & gravity) {
		return this.insert(e, child.node, "before");
	} else {
		return this.insert(e, child.node, "after");
	}
}, insert:function (e, refNode, position) {
	var node = e.dragObject.domNode;
	if (position == "before") {
		return dojo.html.insertBefore(node, refNode);
	} else {
		if (position == "after") {
			return dojo.html.insertAfter(node, refNode);
		} else {
			if (position == "append") {
				refNode.appendChild(node);
				return true;
			}
		}
	}
	return false;
}}, function (node, types) {
	if (arguments.length == 0) {
		return;
	}
	this.domNode = dojo.byId(node);
	dojo.dnd.DropTarget.call(this);
	if (types && dojo.lang.isString(types)) {
		types = [types];
	}
	this.acceptedTypes = types || [];
	dojo.dnd.dragManager.registerDropTarget(this);
});


__CPAN_FILE__ src/dnd/TreeDragAndDrop.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.dnd.TreeDragAndDrop");
dojo.require("dojo.dnd.HtmlDragAndDrop");
dojo.require("dojo.lang.func");
dojo.require("dojo.lang.array");
dojo.require("dojo.lang.extras");
dojo.require("dojo.html.layout");
dojo.dnd.TreeDragSource = function (node, syncController, type, treeNode) {
	this.controller = syncController;
	this.treeNode = treeNode;
	dojo.dnd.HtmlDragSource.call(this, node, type);
};
dojo.inherits(dojo.dnd.TreeDragSource, dojo.dnd.HtmlDragSource);
dojo.lang.extend(dojo.dnd.TreeDragSource, {onDragStart:function () {
	var dragObject = dojo.dnd.HtmlDragSource.prototype.onDragStart.call(this);
	dragObject.treeNode = this.treeNode;
	dragObject.onDragStart = dojo.lang.hitch(dragObject, function (e) {
		this.savedSelectedNode = this.treeNode.tree.selector.selectedNode;
		if (this.savedSelectedNode) {
			this.savedSelectedNode.unMarkSelected();
		}
		var result = dojo.dnd.HtmlDragObject.prototype.onDragStart.apply(this, arguments);
		var cloneGrid = this.dragClone.getElementsByTagName("img");
		for (var i = 0; i < cloneGrid.length; i++) {
			cloneGrid.item(i).style.backgroundImage = "url()";
		}
		return result;
	});
	dragObject.onDragEnd = function (e) {
		if (this.savedSelectedNode) {
			this.savedSelectedNode.markSelected();
		}
		return dojo.dnd.HtmlDragObject.prototype.onDragEnd.apply(this, arguments);
	};
	return dragObject;
}, onDragEnd:function (e) {
	var res = dojo.dnd.HtmlDragSource.prototype.onDragEnd.call(this, e);
	return res;
}});
dojo.dnd.TreeDropTarget = function (domNode, controller, type, treeNode) {
	this.treeNode = treeNode;
	this.controller = controller;
	dojo.dnd.HtmlDropTarget.apply(this, [domNode, type]);
};
dojo.inherits(dojo.dnd.TreeDropTarget, dojo.dnd.HtmlDropTarget);
dojo.lang.extend(dojo.dnd.TreeDropTarget, {autoExpandDelay:1500, autoExpandTimer:null, position:null, indicatorStyle:"2px black solid", showIndicator:function (position) {
	if (this.position == position) {
		return;
	}
	this.hideIndicator();
	this.position = position;
	if (position == "before") {
		this.treeNode.labelNode.style.borderTop = this.indicatorStyle;
	} else {
		if (position == "after") {
			this.treeNode.labelNode.style.borderBottom = this.indicatorStyle;
		} else {
			if (position == "onto") {
				this.treeNode.markSelected();
			}
		}
	}
}, hideIndicator:function () {
	this.treeNode.labelNode.style.borderBottom = "";
	this.treeNode.labelNode.style.borderTop = "";
	this.treeNode.unMarkSelected();
	this.position = null;
}, onDragOver:function (e) {
	var accepts = dojo.dnd.HtmlDropTarget.prototype.onDragOver.apply(this, arguments);
	if (accepts && this.treeNode.isFolder && !this.treeNode.isExpanded) {
		this.setAutoExpandTimer();
	}
	return accepts;
}, accepts:function (dragObjects) {
	var accepts = dojo.dnd.HtmlDropTarget.prototype.accepts.apply(this, arguments);
	if (!accepts) {
		return false;
	}
	var sourceTreeNode = dragObjects[0].treeNode;
	if (dojo.lang.isUndefined(sourceTreeNode) || !sourceTreeNode || !sourceTreeNode.isTreeNode) {
		dojo.raise("Source is not TreeNode or not found");
	}
	if (sourceTreeNode === this.treeNode) {
		return false;
	}
	return true;
}, setAutoExpandTimer:function () {
	var _this = this;
	var autoExpand = function () {
		if (dojo.dnd.dragManager.currentDropTarget === _this) {
			_this.controller.expand(_this.treeNode);
		}
	};
	this.autoExpandTimer = dojo.lang.setTimeout(autoExpand, _this.autoExpandDelay);
}, getDNDMode:function () {
	return this.treeNode.tree.DNDMode;
}, getAcceptPosition:function (e, sourceTreeNode) {
	var DNDMode = this.getDNDMode();
	if (DNDMode & dojo.widget.Tree.prototype.DNDModes.ONTO && !(!this.treeNode.actionIsDisabled(dojo.widget.TreeNode.prototype.actions.ADDCHILD) && sourceTreeNode.parent !== this.treeNode && this.controller.canMove(sourceTreeNode, this.treeNode))) {
		DNDMode &= ~dojo.widget.Tree.prototype.DNDModes.ONTO;
	}
	var position = this.getPosition(e, DNDMode);
	if (position == "onto" || (!this.isAdjacentNode(sourceTreeNode, position) && this.controller.canMove(sourceTreeNode, this.treeNode.parent))) {
		return position;
	} else {
		return false;
	}
}, onDragOut:function (e) {
	this.clearAutoExpandTimer();
	this.hideIndicator();
}, clearAutoExpandTimer:function () {
	if (this.autoExpandTimer) {
		clearTimeout(this.autoExpandTimer);
		this.autoExpandTimer = null;
	}
}, onDragMove:function (e, dragObjects) {
	var sourceTreeNode = dragObjects[0].treeNode;
	var position = this.getAcceptPosition(e, sourceTreeNode);
	if (position) {
		this.showIndicator(position);
	}
}, isAdjacentNode:function (sourceNode, position) {
	if (sourceNode === this.treeNode) {
		return true;
	}
	if (sourceNode.getNextSibling() === this.treeNode && position == "before") {
		return true;
	}
	if (sourceNode.getPreviousSibling() === this.treeNode && position == "after") {
		return true;
	}
	return false;
}, getPosition:function (e, DNDMode) {
	var node = dojo.byId(this.treeNode.labelNode);
	var mousey = e.pageY || e.clientY + dojo.body().scrollTop;
	var nodey = dojo.html.getAbsolutePosition(node).y;
	var height = dojo.html.getBorderBox(node).height;
	var relY = mousey - nodey;
	var p = relY / height;
	var position = "";
	if (DNDMode & dojo.widget.Tree.prototype.DNDModes.ONTO && DNDMode & dojo.widget.Tree.prototype.DNDModes.BETWEEN) {
		if (p <= 0.3) {
			position = "before";
		} else {
			if (p <= 0.7) {
				position = "onto";
			} else {
				position = "after";
			}
		}
	} else {
		if (DNDMode & dojo.widget.Tree.prototype.DNDModes.BETWEEN) {
			if (p <= 0.5) {
				position = "before";
			} else {
				position = "after";
			}
		} else {
			if (DNDMode & dojo.widget.Tree.prototype.DNDModes.ONTO) {
				position = "onto";
			}
		}
	}
	return position;
}, getTargetParentIndex:function (sourceTreeNode, position) {
	var index = position == "before" ? this.treeNode.getParentIndex() : this.treeNode.getParentIndex() + 1;
	if (this.treeNode.parent === sourceTreeNode.parent && this.treeNode.getParentIndex() > sourceTreeNode.getParentIndex()) {
		index--;
	}
	return index;
}, onDrop:function (e) {
	var position = this.position;
	this.onDragOut(e);
	var sourceTreeNode = e.dragObject.treeNode;
	if (!dojo.lang.isObject(sourceTreeNode)) {
		dojo.raise("TreeNode not found in dragObject");
	}
	if (position == "onto") {
		return this.controller.move(sourceTreeNode, this.treeNode, 0);
	} else {
		var index = this.getTargetParentIndex(sourceTreeNode, position);
		return this.controller.move(sourceTreeNode, this.treeNode.parent, index);
	}
}});
dojo.dnd.TreeDNDController = function (treeController) {
	this.treeController = treeController;
	this.dragSources = {};
	this.dropTargets = {};
};
dojo.lang.extend(dojo.dnd.TreeDNDController, {listenTree:function (tree) {
	dojo.event.topic.subscribe(tree.eventNames.createDOMNode, this, "onCreateDOMNode");
	dojo.event.topic.subscribe(tree.eventNames.moveFrom, this, "onMoveFrom");
	dojo.event.topic.subscribe(tree.eventNames.moveTo, this, "onMoveTo");
	dojo.event.topic.subscribe(tree.eventNames.addChild, this, "onAddChild");
	dojo.event.topic.subscribe(tree.eventNames.removeNode, this, "onRemoveNode");
	dojo.event.topic.subscribe(tree.eventNames.treeDestroy, this, "onTreeDestroy");
}, unlistenTree:function (tree) {
	dojo.event.topic.unsubscribe(tree.eventNames.createDOMNode, this, "onCreateDOMNode");
	dojo.event.topic.unsubscribe(tree.eventNames.moveFrom, this, "onMoveFrom");
	dojo.event.topic.unsubscribe(tree.eventNames.moveTo, this, "onMoveTo");
	dojo.event.topic.unsubscribe(tree.eventNames.addChild, this, "onAddChild");
	dojo.event.topic.unsubscribe(tree.eventNames.removeNode, this, "onRemoveNode");
	dojo.event.topic.unsubscribe(tree.eventNames.treeDestroy, this, "onTreeDestroy");
}, onTreeDestroy:function (message) {
	this.unlistenTree(message.source);
}, onCreateDOMNode:function (message) {
	this.registerDNDNode(message.source);
}, onAddChild:function (message) {
	this.registerDNDNode(message.child);
}, onMoveFrom:function (message) {
	var _this = this;
	dojo.lang.forEach(message.child.getDescendants(), function (node) {
		_this.unregisterDNDNode(node);
	});
}, onMoveTo:function (message) {
	var _this = this;
	dojo.lang.forEach(message.child.getDescendants(), function (node) {
		_this.registerDNDNode(node);
	});
}, registerDNDNode:function (node) {
	if (!node.tree.DNDMode) {
		return;
	}
	var source = null;
	var target = null;
	if (!node.actionIsDisabled(node.actions.MOVE)) {
		var source = new dojo.dnd.TreeDragSource(node.labelNode, this, node.tree.widgetId, node);
		this.dragSources[node.widgetId] = source;
	}
	var target = new dojo.dnd.TreeDropTarget(node.labelNode, this.treeController, node.tree.DNDAcceptTypes, node);
	this.dropTargets[node.widgetId] = target;
}, unregisterDNDNode:function (node) {
	if (this.dragSources[node.widgetId]) {
		dojo.dnd.dragManager.unregisterDragSource(this.dragSources[node.widgetId]);
		delete this.dragSources[node.widgetId];
	}
	if (this.dropTargets[node.widgetId]) {
		dojo.dnd.dragManager.unregisterDropTarget(this.dropTargets[node.widgetId]);
		delete this.dropTargets[node.widgetId];
	}
}});


__CPAN_DIR__ src/graphics
__CPAN_FILE__ src/graphics/color.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.graphics.color");
dojo.require("dojo.gfx.color");
dojo.deprecated("dojo.graphics.color.Color is now dojo.gfx.color.Color.", "0.5");
dojo.graphics.color.Color = dojo.gfx.color.Color;
dojo.graphics.color.named = dojo.gfx.color.named;
dojo.graphics.color.blend = function (a, b, weight) {
	dojo.deprecated("dojo.graphics.color.blend is now dojo.gfx.color.blend", "0.5");
	return dojo.gfx.color.blend(a, b, weight);
};
dojo.graphics.color.blendHex = function (a, b, weight) {
	dojo.deprecated("dojo.graphics.color.blendHex is now dojo.gfx.color.blendHex", "0.5");
	return dojo.gfx.color.rgb2hex(dojo.gfx.color.blend(dojo.gfx.color.hex2rgb(a), dojo.gfx.color.hex2rgb(b), weight));
};
dojo.graphics.color.extractRGB = function (color) {
	dojo.deprecated("dojo.graphics.color.extractRGB is now dojo.gfx.color.extractRGB", "0.5");
	return dojo.gfx.color.extractRGB(color);
};
dojo.graphics.color.hex2rgb = function (hex) {
	dojo.deprecated("dojo.graphics.color.hex2rgb is now dojo.gfx.color.hex2rgb", "0.5");
	return dojo.gfx.color.hex2rgb(hex);
};
dojo.graphics.color.rgb2hex = function (r, g, b) {
	dojo.deprecated("dojo.graphics.color.rgb2hex is now dojo.gfx.color.rgb2hex", "0.5");
	return dojo.gfx.color.rgb2hex;
};


__CPAN_FILE__ src/graphics/__package__.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.graphics.*");


__CPAN_FILE__ src/graphics/Colorspace.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.graphics.Colorspace");
dojo.require("dojo.gfx.Colorspace");
dojo.deprecated("dojo.graphics.Colorspace: use dojo.gfx.Colorspace instead.", "0.5");
dojo.graphics.Colorspace = dojo.gfx.Colorspace;


__CPAN_DIR__ src/graphics/color
__CPAN_FILE__ src/graphics/color/hsl.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.graphics.color.hsl");
dojo.require("dojo.gfx.color.hsl");
dojo.deprecated("dojo.graphics.color.hsl has been replaced with dojo.gfx.color.hsl", "0.5");
dojo.graphics.color.rgb2hsl = function (r, g, b) {
	dojo.deprecated("dojo.graphics.color.rgb2hsl has been replaced with dojo.gfx.color.rgb2hsl", "0.5");
	return dojo.gfx.color.rgb2hsl(r, g, b);
};
dojo.graphics.color.hsl2rgb = function (h, s, l) {
	dojo.deprecated("dojo.graphics.color.hsl2rgb has been replaced with dojo.gfx.color.hsl2rgb", "0.5");
	return dojo.gfx.color.hsl2rgb(h, s, l);
};
dojo.graphics.color.hsl2hex = function (h, s, l) {
	dojo.deprecated("dojo.graphics.color.hsl2hex has been replaced with dojo.gfx.color.hsl2hex", "0.5");
	return dojo.gfx.color.hsl2hex(h, s, l);
};
dojo.graphics.color.hex2hsl = function (hex) {
	dojo.deprecated("dojo.graphics.color.hex2hsl has been replaced with dojo.gfx.color.hex2hsl", "0.5");
	return dojo.gfx.color.hex2hsl(hex);
};


__CPAN_FILE__ src/graphics/color/hsv.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.graphics.color.hsv");
dojo.require("dojo.gfx.color.hsv");
dojo.deprecated("dojo.graphics.color.hsv has been replaced by dojo.gfx.color.hsv", "0.5");
dojo.graphics.color.rgb2hsv = function (r, g, b) {
	dojo.deprecated("dojo.graphics.color.rgb2hsv has been replaced by dojo.gfx.color.rgb2hsv", "0.5");
	return dojo.gfx.color.rgb2hsv(r, g, b);
};
dojo.graphics.color.hsv2rgb = function (h, s, v) {
	dojo.deprecated("dojo.graphics.color.hsv2rgb has been replaced by dojo.gfx.color.hsv2rgb", "0.5");
	return dojo.gfx.color.hsv2rgb(h, s, v);
};


__CPAN_DIR__ src/widget
__CPAN_FILE__ src/widget/TreeToggleOnSelect.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.widget.TreeToggleOnSelect");
dojo.require("dojo.widget.HtmlWidget");
dojo.widget.defineWidget("dojo.widget.TreeToggleOnSelect", dojo.widget.HtmlWidget, {selector:"", controller:"", selectEvent:"select", initialize:function () {
	this.selector = dojo.widget.byId(this.selector);
	this.controller = dojo.widget.byId(this.controller);
	dojo.event.topic.subscribe(this.selector.eventNames[this.selectEvent], this, "onSelectEvent");
}, onSelectEvent:function (message) {
	var node = message.node;
	node.isExpanded ? this.controller.collapse(node) : this.controller.expand(node);
}});


__CPAN_FILE__ src/widget/TreeEditor.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.require("dojo.widget.*");
dojo.require("dojo.widget.HtmlWidget");
dojo.require("dojo.widget.RichText");
dojo.provide("dojo.widget.TreeEditor");
dojo.widget.defineWidget("dojo.widget.TreeEditor", dojo.widget.HtmlWidget, {singleLineMode:false, saveOnBlur:true, sync:false, selectOnOpen:true, controller:null, node:null, richTextParams:{styleSheets:"src/widget/templates/TreeEditor.css"}, getContents:function () {
	return this.richText.getEditorContent();
}, open:function (node) {
	if (!this.richText) {
		this.richText = dojo.widget.createWidget("RichText", this.richTextParams, node.labelNode);
		dojo.event.connect("around", this.richText, "onKeyDown", this, "richText_onKeyDown");
		dojo.event.connect(this.richText, "onBlur", this, "richText_onBlur");
		var self = this;
		dojo.event.connect(this.richText, "onLoad", function () {
			if (self.selectOnOpen) {
				self.richText.execCommand("selectall");
			}
		});
	} else {
		this.richText.open(node.labelNode);
	}
	this.node = node;
}, close:function (save) {
	this.richText.close(save);
	this.node = null;
}, isClosed:function () {
	return !this.richText || this.richText.isClosed;
}, execCommand:function () {
	this.richText.execCommand.apply(this.richText, arguments);
}, richText_onKeyDown:function (invocation) {
	var e = invocation.args[0];
	if ((!e) && (this.object)) {
		e = dojo.event.browser.fixEvent(this.editor.window.event);
	}
	switch (e.keyCode) {
	  case e.KEY_ESCAPE:
		this.finish(false);
		dojo.event.browser.stopEvent(e);
		break;
	  case e.KEY_ENTER:
		if (e.ctrlKey && !this.singleLineMode) {
			this.execCommand("inserthtml", "<br/>");
		} else {
			this.finish(true);
		}
		dojo.event.browser.stopEvent(e);
		break;
	  default:
		return invocation.proceed();
	}
}, richText_onBlur:function () {
	this.finish(this.saveOnBlur);
}, finish:function (save) {
	return this.controller.editLabelFinish(save, this.sync);
}});


__CPAN_FILE__ src/widget/Form.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.widget.Form");
dojo.require("dojo.widget.*");
dojo.require("dojo.widget.HtmlWidget");
dojo.widget.defineWidget("dojo.widget.Form", dojo.widget.HtmlWidget, {isContainer:true, templateString:"<form dojoAttachPoint='containerNode' dojoAttachEvent='onSubmit:onSubmit'></form>", formElements:[], ignoreNullValues:false, postCreate:function (args, frag) {
	for (var key in args) {
		if (key == "dojotype") {
			continue;
		}
		var attr = document.createAttribute(key);
		attr.nodeValue = args[key];
		this.containerNode.setAttributeNode(attr);
	}
}, _createRepeaters:function (obj, widget) {
	for (var i = 0; i < widget.children.length; ++i) {
		if (widget.children[i].widgetType == "RepeaterContainer") {
			var rIndex = widget.children[i].index;
			var rIndexPos = rIndex.indexOf("%{index}");
			rIndex = rIndex.substr(0, rIndexPos - 1);
			var myObj = this._getObject(obj, rIndex);
			if (typeof (myObj) == "object" && myObj.length == 0) {
				myObj = new Array();
			}
			var rowCount = widget.children[i].getRowCount();
			for (var j = 0, len = rowCount; j < len; ++j) {
				widget.children[i].deleteRow(0);
			}
			for (var j = 0; j < myObj.length; j++) {
				widget.children[i].addRow(false);
			}
		}
		if (widget.children[i].isContainer) {
			this._createRepeaters(obj, widget.children[i]);
		}
	}
}, _createFormElements:function () {
	if (dojo.render.html.safari) {
		this.formElements = [];
		var elems = ["INPUT", "SELECT", "TEXTAREA"];
		for (var k = 0; k < elems.length; k++) {
			var list = this.containerNode.getElementsByTagName(elems[k]);
			for (var j = 0, len2 = list.length; j < len2; j++) {
				this.formElements.push(list[j]);
			}
		}
	} else {
		this.formElements = this.containerNode.elements;
	}
}, onSubmit:function (e) {
	e.preventDefault();
}, submit:function () {
	this.containerNode.submit();
}, _getFormElement:function (name) {
	if (dojo.render.html.ie) {
		for (var i = 0, len = this.formElements.length; i < len; i++) {
			var element = this.formElements[i];
			if (element.name == name) {
				return element;
			}
		}
	} else {
		var elem = this.formElements[name];
		if (typeof (elem) != "undefined") {
			return elem;
		}
	}
	return null;
}, _getObject:function (obj, searchString) {
	var namePath = [];
	namePath = searchString.split(".");
	var myObj = obj;
	var name = namePath[namePath.length - 1];
	for (var j = 0, len = namePath.length; j < len; ++j) {
		var p = namePath[j];
		if (typeof (myObj[p]) == "undefined") {
			myObj[p] = {};
		}
		myObj = myObj[p];
	}
	return myObj;
}, _setToContainers:function (obj, widget) {
	for (var i = 0, len = widget.children.length; i < len; ++i) {
		var currentWidget = widget.children[i];
		if (currentWidget.widgetType == "Repeater") {
			for (var j = 0, len = currentWidget.getRowCount(); j < len; ++j) {
				currentWidget._initRow(j);
			}
		}
		if (currentWidget.isContainer) {
			this._setToContainers(obj, currentWidget);
			continue;
		}
		switch (currentWidget.widgetType) {
		  case "Checkbox":
			currentWidget.setValue(currentWidget.inputNode.checked);
			break;
		  case "DropdownDatePicker":
			currentWidget.setValue(currentWidget.getValue());
			break;
		  case "Select":
			continue;
			break;
		  case "ComboBox":
			continue;
			break;
		  default:
			break;
		}
	}
}, setValues:function (obj) {
	this._createFormElements();
	this._createRepeaters(obj, this);
	for (var i = 0, len = this.formElements.length; i < len; i++) {
		var element = this.formElements[i];
		if (element.name == "") {
			continue;
		}
		var namePath = new Array();
		namePath = element.name.split(".");
		var myObj = obj;
		var name = namePath[namePath.length - 1];
		for (var j = 1, len2 = namePath.length; j < len2; ++j) {
			var p = namePath[j - 1];
			if (typeof (myObj[p]) == "undefined") {
				myObj = undefined;
				break;
			}
			myObj = myObj[p];
		}
		if (typeof (myObj) == "undefined") {
			continue;
		}
		if (typeof (myObj[name]) == "undefined" && this.ignoreNullValues) {
			continue;
		}
		var type = element.type;
		if (type == "hidden" || type == "text" || type == "textarea" || type == "password") {
			type = "text";
		}
		switch (type) {
		  case "checkbox":
			element.checked = false;
			if (typeof (myObj[name]) == "undefined") {
				continue;
			}
			for (var j = 0, len2 = myObj[name].length; j < len2; ++j) {
				if (element.value == myObj[name][j]) {
					element.checked = true;
				}
			}
			break;
		  case "radio":
			element.checked = false;
			if (typeof (myObj[name]) == "undefined") {
				continue;
			}
			if (myObj[name] == element.value) {
				element.checked = true;
			}
			break;
		  case "select-multiple":
			element.selectedIndex = -1;
			for (var j = 0, len2 = element.options.length; j < len2; ++j) {
				for (var k = 0, len3 = myObj[name].length; k < len3; ++k) {
					if (element.options[j].value == myObj[name][k]) {
						element.options[j].selected = true;
					}
				}
			}
			break;
		  case "select-one":
			element.selectedIndex = "0";
			for (var j = 0, len2 = element.options.length; j < len2; ++j) {
				if (element.options[j].value == myObj[name]) {
					element.options[j].selected = true;
				} else {
				}
			}
			break;
		  case "text":
			var value = "";
			if (typeof (myObj[name]) != "undefined") {
				value = myObj[name];
			}
			element.value = value;
			break;
		  default:
			dojo.debug("Not supported type (" + type + ")");
			break;
		}
	}
	this._setToContainers(obj, this);
}, getValues:function () {
	this._createFormElements();
	var obj = {};
	for (var i = 0, len = this.formElements.length; i < len; i++) {
		var elm = this.formElements[i];
		var namePath = [];
		if (elm.name == "") {
			continue;
		}
		namePath = elm.name.split(".");
		var myObj = obj;
		var name = namePath[namePath.length - 1];
		for (var j = 1, len2 = namePath.length; j < len2; ++j) {
			var nameIndex = null;
			var p = namePath[j - 1];
			var nameA = p.split("[");
			if (nameA.length > 1) {
				if (typeof (myObj[nameA[0]]) == "undefined") {
					myObj[nameA[0]] = [];
				}
				nameIndex = parseInt(nameA[1]);
				if (typeof (myObj[nameA[0]][nameIndex]) == "undefined") {
					myObj[nameA[0]][nameIndex] = {};
				}
			} else {
				if (typeof (myObj[nameA[0]]) == "undefined") {
					myObj[nameA[0]] = {};
				}
			}
			if (nameA.length == 1) {
				myObj = myObj[nameA[0]];
			} else {
				myObj = myObj[nameA[0]][nameIndex];
			}
		}
		if ((elm.type != "select-multiple" && elm.type != "checkbox" && elm.type != "radio") || (elm.type == "radio" && elm.checked)) {
			if (name == name.split("[")[0]) {
				myObj[name] = elm.value;
			} else {
			}
		} else {
			if (elm.type == "checkbox" && elm.checked) {
				if (typeof (myObj[name]) == "undefined") {
					myObj[name] = [];
				}
				myObj[name].push(elm.value);
			} else {
				if (elm.type == "select-multiple") {
					if (typeof (myObj[name]) == "undefined") {
						myObj[name] = [];
					}
					for (var jdx = 0, len3 = elm.options.length; jdx < len3; ++jdx) {
						if (elm.options[jdx].selected) {
							myObj[name].push(elm.options[jdx].value);
						}
					}
				}
			}
		}
		name = undefined;
	}
	return obj;
}});


__CPAN_FILE__ src/widget/Widget.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.widget.Widget");
dojo.require("dojo.lang.func");
dojo.require("dojo.lang.array");
dojo.require("dojo.lang.extras");
dojo.require("dojo.lang.declare");
dojo.require("dojo.ns");
dojo.require("dojo.widget.Manager");
dojo.require("dojo.event.*");
dojo.require("dojo.a11y");
dojo.declare("dojo.widget.Widget", null, function () {
	this.children = [];
	this.extraArgs = {};
}, {parent:null, isTopLevel:false, disabled:false, isContainer:false, widgetId:"", widgetType:"Widget", ns:"dojo", getNamespacedType:function () {
	return (this.ns ? this.ns + ":" + this.widgetType : this.widgetType).toLowerCase();
}, toString:function () {
	return "[Widget " + this.getNamespacedType() + ", " + (this.widgetId || "NO ID") + "]";
}, repr:function () {
	return this.toString();
}, enable:function () {
	this.disabled = false;
}, disable:function () {
	this.disabled = true;
}, onResized:function () {
	this.notifyChildrenOfResize();
}, notifyChildrenOfResize:function () {
	for (var i = 0; i < this.children.length; i++) {
		var child = this.children[i];
		if (child.onResized) {
			child.onResized();
		}
	}
}, create:function (args, fragment, parent, ns) {
	if (ns) {
		this.ns = ns;
	}
	this.satisfyPropertySets(args, fragment, parent);
	this.mixInProperties(args, fragment, parent);
	this.postMixInProperties(args, fragment, parent);
	dojo.widget.manager.add(this);
	this.buildRendering(args, fragment, parent);
	this.initialize(args, fragment, parent);
	this.postInitialize(args, fragment, parent);
	this.postCreate(args, fragment, parent);
	return this;
}, destroy:function (finalize) {
	if (this.parent) {
		this.parent.removeChild(this);
	}
	this.destroyChildren();
	this.uninitialize();
	this.destroyRendering(finalize);
	dojo.widget.manager.removeById(this.widgetId);
}, destroyChildren:function () {
	var widget;
	var i = 0;
	while (this.children.length > i) {
		widget = this.children[i];
		if (widget instanceof dojo.widget.Widget) {
			this.removeChild(widget);
			widget.destroy();
			continue;
		}
		i++;
	}
}, getChildrenOfType:function (type, recurse) {
	var ret = [];
	var isFunc = dojo.lang.isFunction(type);
	if (!isFunc) {
		type = type.toLowerCase();
	}
	for (var x = 0; x < this.children.length; x++) {
		if (isFunc) {
			if (this.children[x] instanceof type) {
				ret.push(this.children[x]);
			}
		} else {
			if (this.children[x].widgetType.toLowerCase() == type) {
				ret.push(this.children[x]);
			}
		}
		if (recurse) {
			ret = ret.concat(this.children[x].getChildrenOfType(type, recurse));
		}
	}
	return ret;
}, getDescendants:function () {
	var result = [];
	var stack = [this];
	var elem;
	while ((elem = stack.pop())) {
		result.push(elem);
		if (elem.children) {
			dojo.lang.forEach(elem.children, function (elem) {
				stack.push(elem);
			});
		}
	}
	return result;
}, isFirstChild:function () {
	return this === this.parent.children[0];
}, isLastChild:function () {
	return this === this.parent.children[this.parent.children.length - 1];
}, satisfyPropertySets:function (args) {
	return args;
}, mixInProperties:function (args, frag) {
	if ((args["fastMixIn"]) || (frag["fastMixIn"])) {
		for (var x in args) {
			this[x] = args[x];
		}
		return;
	}
	var undef;
	var lcArgs = dojo.widget.lcArgsCache[this.widgetType];
	if (lcArgs == null) {
		lcArgs = {};
		for (var y in this) {
			lcArgs[((new String(y)).toLowerCase())] = y;
		}
		dojo.widget.lcArgsCache[this.widgetType] = lcArgs;
	}
	var visited = {};
	for (var x in args) {
		if (!this[x]) {
			var y = lcArgs[(new String(x)).toLowerCase()];
			if (y) {
				args[y] = args[x];
				x = y;
			}
		}
		if (visited[x]) {
			continue;
		}
		visited[x] = true;
		if ((typeof this[x]) != (typeof undef)) {
			if (typeof args[x] != "string") {
				this[x] = args[x];
			} else {
				if (dojo.lang.isString(this[x])) {
					this[x] = args[x];
				} else {
					if (dojo.lang.isNumber(this[x])) {
						this[x] = new Number(args[x]);
					} else {
						if (dojo.lang.isBoolean(this[x])) {
							this[x] = (args[x].toLowerCase() == "false") ? false : true;
						} else {
							if (dojo.lang.isFunction(this[x])) {
								if (args[x].search(/[^\w\.]+/i) == -1) {
									this[x] = dojo.evalObjPath(args[x], false);
								} else {
									var tn = dojo.lang.nameAnonFunc(new Function(args[x]), this);
									dojo.event.kwConnect({srcObj:this, srcFunc:x, adviceObj:this, adviceFunc:tn});
								}
							} else {
								if (dojo.lang.isArray(this[x])) {
									this[x] = args[x].split(";");
								} else {
									if (this[x] instanceof Date) {
										this[x] = new Date(Number(args[x]));
									} else {
										if (typeof this[x] == "object") {
											if (this[x] instanceof dojo.uri.Uri) {
												this[x] = dojo.uri.dojoUri(args[x]);
											} else {
												var pairs = args[x].split(";");
												for (var y = 0; y < pairs.length; y++) {
													var si = pairs[y].indexOf(":");
													if ((si != -1) && (pairs[y].length > si)) {
														this[x][pairs[y].substr(0, si).replace(/^\s+|\s+$/g, "")] = pairs[y].substr(si + 1);
													}
												}
											}
										} else {
											this[x] = args[x];
										}
									}
								}
							}
						}
					}
				}
			}
		} else {
			this.extraArgs[x.toLowerCase()] = args[x];
		}
	}
}, postMixInProperties:function (args, frag, parent) {
}, initialize:function (args, frag, parent) {
	return false;
}, postInitialize:function (args, frag, parent) {
	return false;
}, postCreate:function (args, frag, parent) {
	return false;
}, uninitialize:function () {
	return false;
}, buildRendering:function (args, frag, parent) {
	dojo.unimplemented("dojo.widget.Widget.buildRendering, on " + this.toString() + ", ");
	return false;
}, destroyRendering:function () {
	dojo.unimplemented("dojo.widget.Widget.destroyRendering");
	return false;
}, addedTo:function (parent) {
}, addChild:function (child) {
	dojo.unimplemented("dojo.widget.Widget.addChild");
	return false;
}, removeChild:function (widget) {
	for (var x = 0; x < this.children.length; x++) {
		if (this.children[x] === widget) {
			this.children.splice(x, 1);
			widget.parent = null;
			break;
		}
	}
	return widget;
}, getPreviousSibling:function () {
	var idx = this.getParentIndex();
	if (idx <= 0) {
		return null;
	}
	return this.parent.children[idx - 1];
}, getSiblings:function () {
	return this.parent.children;
}, getParentIndex:function () {
	return dojo.lang.indexOf(this.parent.children, this, true);
}, getNextSibling:function () {
	var idx = this.getParentIndex();
	if (idx == this.parent.children.length - 1) {
		return null;
	}
	if (idx < 0) {
		return null;
	}
	return this.parent.children[idx + 1];
}});
dojo.widget.lcArgsCache = {};
dojo.widget.tags = {};
dojo.widget.tags.addParseTreeHandler = function (type) {
	dojo.deprecated("addParseTreeHandler", ". ParseTreeHandlers are now reserved for components. Any unfiltered DojoML tag without a ParseTreeHandler is assumed to be a widget", "0.5");
};
dojo.widget.tags["dojo:propertyset"] = function (fragment, widgetParser, parentComp) {
	var properties = widgetParser.parseProperties(fragment["dojo:propertyset"]);
};
dojo.widget.tags["dojo:connect"] = function (fragment, widgetParser, parentComp) {
	var properties = widgetParser.parseProperties(fragment["dojo:connect"]);
};
dojo.widget.buildWidgetFromParseTree = function (type, frag, parser, parentComp, insertionIndex, localProps) {
	dojo.a11y.setAccessibleMode();
	var stype = type.split(":");
	stype = (stype.length == 2) ? stype[1] : type;
	var localProperties = localProps || parser.parseProperties(frag[frag["ns"] + ":" + stype]);
	var twidget = dojo.widget.manager.getImplementation(stype, null, null, frag["ns"]);
	if (!twidget) {
		throw new Error("cannot find \"" + type + "\" widget");
	} else {
		if (!twidget.create) {
			throw new Error("\"" + type + "\" widget object has no \"create\" method and does not appear to implement *Widget");
		}
	}
	localProperties["dojoinsertionindex"] = insertionIndex;
	var ret = twidget.create(localProperties, frag, parentComp, frag["ns"]);
	return ret;
};
dojo.widget.defineWidget = function (widgetClass, renderer, superclasses, init, props) {
	if (dojo.lang.isString(arguments[3])) {
		dojo.widget._defineWidget(arguments[0], arguments[3], arguments[1], arguments[4], arguments[2]);
	} else {
		var args = [arguments[0]], p = 3;
		if (dojo.lang.isString(arguments[1])) {
			args.push(arguments[1], arguments[2]);
		} else {
			args.push("", arguments[1]);
			p = 2;
		}
		if (dojo.lang.isFunction(arguments[p])) {
			args.push(arguments[p], arguments[p + 1]);
		} else {
			args.push(null, arguments[p]);
		}
		dojo.widget._defineWidget.apply(this, args);
	}
};
dojo.widget.defineWidget.renderers = "html|svg|vml";
dojo.widget._defineWidget = function (widgetClass, renderer, superclasses, init, props) {
	var module = widgetClass.split(".");
	var type = module.pop();
	var regx = "\\.(" + (renderer ? renderer + "|" : "") + dojo.widget.defineWidget.renderers + ")\\.";
	var r = widgetClass.search(new RegExp(regx));
	module = (r < 0 ? module.join(".") : widgetClass.substr(0, r));
	dojo.widget.manager.registerWidgetPackage(module);
	var pos = module.indexOf(".");
	var nsName = (pos > -1) ? module.substring(0, pos) : module;
	props = (props) || {};
	props.widgetType = type;
	if ((!init) && (props["classConstructor"])) {
		init = props.classConstructor;
		delete props.classConstructor;
	}
	dojo.declare(widgetClass, superclasses, init, props);
};


__CPAN_FILE__ src/widget/DropdownDatePicker.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.widget.DropdownDatePicker");
dojo.require("dojo.widget.*");
dojo.require("dojo.widget.DropdownContainer");
dojo.require("dojo.widget.DatePicker");
dojo.require("dojo.event.*");
dojo.require("dojo.html.*");
dojo.require("dojo.date.format");
dojo.require("dojo.date.serialize");
dojo.require("dojo.string.common");
dojo.require("dojo.i18n.common");
dojo.requireLocalization("dojo.widget", "DropdownDatePicker", null, "ROOT");
dojo.widget.defineWidget("dojo.widget.DropdownDatePicker", dojo.widget.DropdownContainer, {iconURL:dojo.uri.moduleUri("dojo.widget", "templates/images/dateIcon.gif"), formatLength:"short", displayFormat:"", saveFormat:"", value:"", name:"", displayWeeks:6, adjustWeeks:false, startDate:"1492-10-12", endDate:"2941-10-12", weekStartsOn:"", staticDisplay:false, postMixInProperties:function (localProperties, frag) {
	dojo.widget.DropdownDatePicker.superclass.postMixInProperties.apply(this, arguments);
	var messages = dojo.i18n.getLocalization("dojo.widget", "DropdownDatePicker", this.lang);
	this.iconAlt = messages.selectDate;
	if (typeof (this.value) == "string" && this.value.toLowerCase() == "today") {
		this.value = new Date();
	}
	if (this.value && isNaN(this.value)) {
		var orig = this.value;
		this.value = dojo.date.fromRfc3339(this.value);
		if (!this.value) {
			this.value = new Date(orig);
			dojo.deprecated("dojo.widget.DropdownDatePicker", "date attributes must be passed in Rfc3339 format", "0.5");
		}
	}
	if (this.value && !isNaN(this.value)) {
		this.value = new Date(this.value);
	}
}, fillInTemplate:function (args, frag) {
	dojo.widget.DropdownDatePicker.superclass.fillInTemplate.call(this, args, frag);
	var dpArgs = {widgetContainerId:this.widgetId, lang:this.lang, value:this.value, startDate:this.startDate, endDate:this.endDate, displayWeeks:this.displayWeeks, weekStartsOn:this.weekStartsOn, adjustWeeks:this.adjustWeeks, staticDisplay:this.staticDisplay};
	this.datePicker = dojo.widget.createWidget("DatePicker", dpArgs, this.containerNode, "child");
	dojo.event.connect(this.datePicker, "onValueChanged", this, "_updateText");
	dojo.event.connect(this.inputNode, "onChange", this, "_updateText");
	if (this.value) {
		this._updateText();
	}
	this.containerNode.explodeClassName = "calendarBodyContainer";
	this.valueNode.name = this.name;
}, getValue:function () {
	return this.valueNode.value;
}, getDate:function () {
	return this.datePicker.value;
}, setValue:function (rfcDate) {
	this.setDate(rfcDate);
}, setDate:function (dateObj) {
	this.datePicker.setDate(dateObj);
	this._syncValueNode();
}, _updateText:function () {
	this.inputNode.value = this.datePicker.value ? dojo.date.format(this.datePicker.value, {formatLength:this.formatLength, datePattern:this.displayFormat, selector:"dateOnly", locale:this.lang}) : "";
	if (this.value < this.datePicker.startDate || this.value > this.datePicker.endDate) {
		this.inputNode.value = "";
	}
	this._syncValueNode();
	this.onValueChanged(this.getDate());
	this.hideContainer();
}, onValueChanged:function (dateObj) {
}, onInputChange:function () {
	var input = dojo.string.trim(this.inputNode.value);
	if (input) {
		var inputDate = dojo.date.parse(input, {formatLength:this.formatLength, datePattern:this.displayFormat, selector:"dateOnly", locale:this.lang});
		if (!this.datePicker._isDisabledDate(inputDate)) {
			this.setDate(inputDate);
		}
	} else {
		if (input == "") {
			this.datePicker.setDate("");
		}
		this.valueNode.value = input;
	}
	if (input) {
		this._updateText();
	}
}, _syncValueNode:function () {
	var date = this.datePicker.value;
	var value = "";
	switch (this.saveFormat.toLowerCase()) {
	  case "rfc":
	  case "iso":
	  case "":
		value = dojo.date.toRfc3339(date, "dateOnly");
		break;
	  case "posix":
	  case "unix":
		value = Number(date);
		break;
	  default:
		if (date) {
			value = dojo.date.format(date, {datePattern:this.saveFormat, selector:"dateOnly", locale:this.lang});
		}
	}
	this.valueNode.value = value;
}, destroy:function (finalize) {
	this.datePicker.destroy(finalize);
	dojo.widget.DropdownDatePicker.superclass.destroy.apply(this, arguments);
}});


__CPAN_FILE__ src/widget/Button.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.widget.Button");
dojo.require("dojo.lang.extras");
dojo.require("dojo.html.*");
dojo.require("dojo.html.selection");
dojo.require("dojo.widget.*");
dojo.widget.defineWidget("dojo.widget.Button", dojo.widget.HtmlWidget, {isContainer:true, caption:"", templateString:"<div dojoAttachPoint=\"buttonNode\" class=\"dojoButton\" style=\"position:relative;\" dojoAttachEvent=\"onMouseOver; onMouseOut; onMouseDown; onMouseUp; onClick:buttonClick; onKey:onKey; onFocus;\">\n  <div class=\"dojoButtonContents\" align=center dojoAttachPoint=\"containerNode\" style=\"position:absolute;z-index:2;\"></div>\n  <img dojoAttachPoint=\"leftImage\" style=\"position:absolute;left:0px;\">\n  <img dojoAttachPoint=\"centerImage\" style=\"position:absolute;z-index:1;\">\n  <img dojoAttachPoint=\"rightImage\" style=\"position:absolute;top:0px;right:0px;\">\n</div>\n", templateCssString:"/* ---- button --- */\n.dojoButton {\n\tpadding: 0 0 0 0;\n\tfont-size: 8pt;\n\twhite-space: nowrap;\n\tcursor: pointer;\n\tfont-family: Myriad, Tahoma, Verdana, sans-serif;\n}\n\n.dojoButton .dojoButtonContents {\n\tpadding: 2px 2px 2px 2px;\n\ttext-align: center;\t\t/* if icon and label are split across two lines, center icon */\n\tcolor: white;\n}\n\n.dojoButtonLeftPart .dojoButtonContents {\n\tpadding-right: 8px;\n}\n\n.dojoButtonDisabled {\n\tcursor: url(\"images/no.gif\"), default;\n}\n\n\n.dojoButtonContents img {\n\tvertical-align: middle;\t/* if icon and label are on same line, center them */\n}\n\n/* -------- colors ------------ */\n\n.dojoButtonHover .dojoButtonContents {\n}\n\n.dojoButtonDepressed .dojoButtonContents {\n\tcolor: #293a4b;\n}\n\n.dojoButtonDisabled .dojoButtonContents {\n\tcolor: #aaa;\n}\n\n\n/* ---------- drop down button specific ---------- */\n\n/* border between label and arrow (for drop down buttons */\n.dojoButton .border {\n\twidth: 1px;\n\tbackground: gray;\n}\n\n/* button arrow */\n.dojoButton .downArrow {\n\tpadding-left: 10px;\n\ttext-align: center;\n}\n\n.dojoButton.disabled .downArrow {\n\tcursor : default;\n}\n", templateCssPath:dojo.uri.moduleUri("dojo.widget", "templates/ButtonTemplate.css"), inactiveImg:"templates/images/soriaButton-", activeImg:"templates/images/soriaActive-", pressedImg:"templates/images/soriaPressed-", disabledImg:"templates/images/soriaDisabled-", width2height:1 / 3, fillInTemplate:function () {
	if (this.caption) {
		this.containerNode.appendChild(document.createTextNode(this.caption));
	}
	dojo.html.disableSelection(this.containerNode);
}, postCreate:function () {
	this._sizeMyself();
}, _sizeMyself:function () {
	if (this.domNode.parentNode) {
		var placeHolder = document.createElement("span");
		dojo.html.insertBefore(placeHolder, this.domNode);
	}
	dojo.body().appendChild(this.domNode);
	this._sizeMyselfHelper();
	if (placeHolder) {
		dojo.html.insertBefore(this.domNode, placeHolder);
		dojo.html.removeNode(placeHolder);
	}
}, _sizeMyselfHelper:function () {
	var mb = dojo.html.getMarginBox(this.containerNode);
	this.height = mb.height;
	this.containerWidth = mb.width;
	var endWidth = this.height * this.width2height;
	this.containerNode.style.left = endWidth + "px";
	this.leftImage.height = this.rightImage.height = this.centerImage.height = this.height;
	this.leftImage.width = this.rightImage.width = endWidth + 1;
	this.centerImage.width = this.containerWidth;
	this.centerImage.style.left = endWidth + "px";
	this._setImage(this.disabled ? this.disabledImg : this.inactiveImg);
	if (this.disabled) {
		dojo.html.prependClass(this.domNode, "dojoButtonDisabled");
		this.domNode.removeAttribute("tabIndex");
		dojo.widget.wai.setAttr(this.domNode, "waiState", "disabled", true);
	} else {
		dojo.html.removeClass(this.domNode, "dojoButtonDisabled");
		this.domNode.setAttribute("tabIndex", "0");
		dojo.widget.wai.setAttr(this.domNode, "waiState", "disabled", false);
	}
	this.domNode.style.height = this.height + "px";
	this.domNode.style.width = (this.containerWidth + 2 * endWidth) + "px";
}, onMouseOver:function (e) {
	if (this.disabled) {
		return;
	}
	if (!dojo.html.hasClass(this.buttonNode, "dojoButtonHover")) {
		dojo.html.prependClass(this.buttonNode, "dojoButtonHover");
	}
	this._setImage(this.activeImg);
}, onMouseDown:function (e) {
	if (this.disabled) {
		return;
	}
	dojo.html.prependClass(this.buttonNode, "dojoButtonDepressed");
	dojo.html.removeClass(this.buttonNode, "dojoButtonHover");
	this._setImage(this.pressedImg);
}, onMouseUp:function (e) {
	if (this.disabled) {
		return;
	}
	dojo.html.prependClass(this.buttonNode, "dojoButtonHover");
	dojo.html.removeClass(this.buttonNode, "dojoButtonDepressed");
	this._setImage(this.activeImg);
}, onMouseOut:function (e) {
	if (this.disabled) {
		return;
	}
	if (e.toElement && dojo.html.isDescendantOf(e.toElement, this.buttonNode)) {
		return;
	}
	dojo.html.removeClass(this.buttonNode, "dojoButtonHover");
	dojo.html.removeClass(this.buttonNode, "dojoButtonDepressed");
	this._setImage(this.inactiveImg);
}, onKey:function (e) {
	if (!e.key) {
		return;
	}
	var menu = dojo.widget.getWidgetById(this.menuId);
	if (e.key == e.KEY_ENTER || e.key == " ") {
		this.onMouseDown(e);
		this.buttonClick(e);
		dojo.lang.setTimeout(this, "onMouseUp", 75, e);
		dojo.event.browser.stopEvent(e);
	}
	if (menu && menu.isShowingNow && e.key == e.KEY_DOWN_ARROW) {
		dojo.event.disconnect(this.domNode, "onblur", this, "onBlur");
	}
}, onFocus:function (e) {
	var menu = dojo.widget.getWidgetById(this.menuId);
	if (menu) {
		dojo.event.connectOnce(this.domNode, "onblur", this, "onBlur");
	}
}, onBlur:function (e) {
	var menu = dojo.widget.getWidgetById(this.menuId);
	if (!menu) {
		return;
	}
	if (menu.close && menu.isShowingNow) {
		menu.close();
	}
}, buttonClick:function (e) {
	if (!this.disabled) {
		try {
			this.domNode.focus();
		}
		catch (e2) {
		}
		this.onClick(e);
	}
}, onClick:function (e) {
}, _setImage:function (prefix) {
	this.leftImage.src = dojo.uri.moduleUri("dojo.widget", prefix + "l.gif");
	this.centerImage.src = dojo.uri.moduleUri("dojo.widget", prefix + "c.gif");
	this.rightImage.src = dojo.uri.moduleUri("dojo.widget", prefix + "r.gif");
}, _toggleMenu:function (menuId) {
	var menu = dojo.widget.getWidgetById(menuId);
	if (!menu) {
		return;
	}
	if (menu.open && !menu.isShowingNow) {
		var pos = dojo.html.getAbsolutePosition(this.domNode, false);
		menu.open(pos.x, pos.y + this.height, this);
		dojo.event.disconnect(this.domNode, "onblur", this, "onBlur");
	} else {
		if (menu.close && menu.isShowingNow) {
			menu.close();
		} else {
			menu.toggle();
		}
	}
}, setCaption:function (content) {
	this.caption = content;
	this.containerNode.innerHTML = content;
	this._sizeMyself();
}, setDisabled:function (disabled) {
	this.disabled = disabled;
	this._sizeMyself();
}});
dojo.widget.defineWidget("dojo.widget.DropDownButton", dojo.widget.Button, {menuId:"", downArrow:"templates/images/whiteDownArrow.gif", disabledDownArrow:"templates/images/whiteDownArrow.gif", fillInTemplate:function () {
	dojo.widget.DropDownButton.superclass.fillInTemplate.apply(this, arguments);
	this.arrow = document.createElement("img");
	dojo.html.setClass(this.arrow, "downArrow");
	dojo.widget.wai.setAttr(this.domNode, "waiState", "haspopup", this.menuId);
}, _sizeMyselfHelper:function () {
	this.arrow.src = dojo.uri.moduleUri("dojo.widget", this.disabled ? this.disabledDownArrow : this.downArrow);
	this.containerNode.appendChild(this.arrow);
	dojo.widget.DropDownButton.superclass._sizeMyselfHelper.call(this);
}, onClick:function (e) {
	this._toggleMenu(this.menuId);
}});
dojo.widget.defineWidget("dojo.widget.ComboButton", dojo.widget.Button, {menuId:"", templateString:"<div class=\"dojoButton\" style=\"position:relative;top:0px;left:0px; text-align:none;\" dojoAttachEvent=\"onKey;onFocus\">\n\n\t<div dojoAttachPoint=\"buttonNode\" class=\"dojoButtonLeftPart\" style=\"position:absolute;left:0px;top:0px;\"\n\t\tdojoAttachEvent=\"onMouseOver; onMouseOut; onMouseDown; onMouseUp; onClick:buttonClick;\">\n\t\t<div class=\"dojoButtonContents\" dojoAttachPoint=\"containerNode\" style=\"position:absolute;top:0px;right:0px;z-index:2;\"></div>\n\t\t<img dojoAttachPoint=\"leftImage\" style=\"position:absolute;left:0px;top:0px;\">\n\t\t<img dojoAttachPoint=\"centerImage\" style=\"position:absolute;right:0px;top:0px;z-index:1;\">\n\t</div>\n\n\t<div dojoAttachPoint=\"rightPart\" class=\"dojoButtonRightPart\" style=\"position:absolute;top:0px;right:0px;\"\n\t\tdojoAttachEvent=\"onMouseOver:rightOver; onMouseOut:rightOut; onMouseDown:rightDown; onMouseUp:rightUp; onClick:rightClick;\">\n\t\t<img dojoAttachPoint=\"arrowBackgroundImage\" style=\"position:absolute;top:0px;left:0px;z-index:1;\">\n\t\t<img src=\"${dojoWidgetModuleUri}templates/images/whiteDownArrow.gif\"\n\t\t  \t\tstyle=\"z-index:2;position:absolute;left:3px;top:50%;\">\n\t\t<img dojoAttachPoint=\"rightImage\" style=\"position:absolute;top:0px;right:0px;\">\n\t</div>\n\n</div>\n", splitWidth:2, arrowWidth:5, _sizeMyselfHelper:function (e) {
	var mb = dojo.html.getMarginBox(this.containerNode);
	this.height = mb.height;
	this.containerWidth = mb.width;
	var endWidth = this.height / 3;
	if (this.disabled) {
		dojo.widget.wai.setAttr(this.domNode, "waiState", "disabled", true);
		this.domNode.removeAttribute("tabIndex");
	} else {
		dojo.widget.wai.setAttr(this.domNode, "waiState", "disabled", false);
		this.domNode.setAttribute("tabIndex", "0");
	}
	this.leftImage.height = this.rightImage.height = this.centerImage.height = this.arrowBackgroundImage.height = this.height;
	this.leftImage.width = endWidth + 1;
	this.centerImage.width = this.containerWidth;
	this.buttonNode.style.height = this.height + "px";
	this.buttonNode.style.width = endWidth + this.containerWidth + "px";
	this._setImage(this.disabled ? this.disabledImg : this.inactiveImg);
	this.arrowBackgroundImage.width = this.arrowWidth;
	this.rightImage.width = endWidth + 1;
	this.rightPart.style.height = this.height + "px";
	this.rightPart.style.width = this.arrowWidth + endWidth + "px";
	this._setImageR(this.disabled ? this.disabledImg : this.inactiveImg);
	this.domNode.style.height = this.height + "px";
	var totalWidth = this.containerWidth + this.splitWidth + this.arrowWidth + 2 * endWidth;
	this.domNode.style.width = totalWidth + "px";
}, _setImage:function (prefix) {
	this.leftImage.src = dojo.uri.moduleUri("dojo.widget", prefix + "l.gif");
	this.centerImage.src = dojo.uri.moduleUri("dojo.widget", prefix + "c.gif");
}, rightOver:function (e) {
	if (this.disabled) {
		return;
	}
	dojo.html.prependClass(this.rightPart, "dojoButtonHover");
	this._setImageR(this.activeImg);
}, rightDown:function (e) {
	if (this.disabled) {
		return;
	}
	dojo.html.prependClass(this.rightPart, "dojoButtonDepressed");
	dojo.html.removeClass(this.rightPart, "dojoButtonHover");
	this._setImageR(this.pressedImg);
}, rightUp:function (e) {
	if (this.disabled) {
		return;
	}
	dojo.html.prependClass(this.rightPart, "dojoButtonHover");
	dojo.html.removeClass(this.rightPart, "dojoButtonDepressed");
	this._setImageR(this.activeImg);
}, rightOut:function (e) {
	if (this.disabled) {
		return;
	}
	dojo.html.removeClass(this.rightPart, "dojoButtonHover");
	dojo.html.removeClass(this.rightPart, "dojoButtonDepressed");
	this._setImageR(this.inactiveImg);
}, rightClick:function (e) {
	if (this.disabled) {
		return;
	}
	try {
		this.domNode.focus();
	}
	catch (e2) {
	}
	this._toggleMenu(this.menuId);
}, _setImageR:function (prefix) {
	this.arrowBackgroundImage.src = dojo.uri.moduleUri("dojo.widget", prefix + "c.gif");
	this.rightImage.src = dojo.uri.moduleUri("dojo.widget", prefix + "r.gif");
}, onKey:function (e) {
	if (!e.key) {
		return;
	}
	var menu = dojo.widget.getWidgetById(this.menuId);
	if (e.key == e.KEY_ENTER || e.key == " ") {
		this.onMouseDown(e);
		this.buttonClick(e);
		dojo.lang.setTimeout(this, "onMouseUp", 75, e);
		dojo.event.browser.stopEvent(e);
	} else {
		if (e.key == e.KEY_DOWN_ARROW && e.altKey) {
			this.rightDown(e);
			this.rightClick(e);
			dojo.lang.setTimeout(this, "rightUp", 75, e);
			dojo.event.browser.stopEvent(e);
		} else {
			if (menu && menu.isShowingNow && e.key == e.KEY_DOWN_ARROW) {
				dojo.event.disconnect(this.domNode, "onblur", this, "onBlur");
			}
		}
	}
}});


__CPAN_FILE__ src/widget/TreeLoadingControllerV3.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.widget.TreeLoadingControllerV3");
dojo.require("dojo.widget.TreeBasicControllerV3");
dojo.require("dojo.event.*");
dojo.require("dojo.json");
dojo.require("dojo.io.*");
dojo.require("dojo.Deferred");
dojo.require("dojo.DeferredList");
dojo.declare("dojo.Error", Error, function (message, extra) {
	this.message = message;
	this.extra = extra;
	this.stack = (new Error()).stack;
});
dojo.declare("dojo.CommunicationError", dojo.Error, function () {
	this.name = "CommunicationError";
});
dojo.declare("dojo.LockedError", dojo.Error, function () {
	this.name = "LockedError";
});
dojo.declare("dojo.FormatError", dojo.Error, function () {
	this.name = "FormatError";
});
dojo.declare("dojo.RpcError", dojo.Error, function () {
	this.name = "RpcError";
});
dojo.widget.defineWidget("dojo.widget.TreeLoadingControllerV3", dojo.widget.TreeBasicControllerV3, {RpcUrl:"", RpcActionParam:"action", preventCache:true, checkValidRpcResponse:function (type, obj) {
	if (type != "load") {
		var extra = {};
		for (var i = 1; i < arguments.length; i++) {
			dojo.lang.mixin(extra, arguments[i]);
		}
		return new dojo.CommunicationError(obj, extra);
	}
	if (typeof obj != "object") {
		return new dojo.FormatError("Wrong server answer format " + (obj && obj.toSource ? obj.toSource() : obj) + " type " + (typeof obj), obj);
	}
	if (!dojo.lang.isUndefined(obj.error)) {
		return new dojo.RpcError(obj.error, obj);
	}
	return false;
}, getDeferredBindHandler:function (deferred) {
	return dojo.lang.hitch(this, function (type, obj) {
		var error = this.checkValidRpcResponse.apply(this, arguments);
		if (error) {
			deferred.errback(error);
			return;
		}
		deferred.callback(obj);
	});
}, getRpcUrl:function (action) {
	if (this.RpcUrl == "local") {
		var dir = document.location.href.substr(0, document.location.href.lastIndexOf("/"));
		var localUrl = dir + "/local/" + action;
		return localUrl;
	}
	if (!this.RpcUrl) {
		dojo.raise("Empty RpcUrl: can't load");
	}
	var url = this.RpcUrl;
	if (url.indexOf("/") != 0) {
		var protocol = document.location.href.replace(/:\/\/.*/, "");
		var prefix = document.location.href.substring(protocol.length + 3);
		if (prefix.lastIndexOf("/") != prefix.length - 1) {
			prefix = prefix.replace(/\/[^\/]+$/, "/");
		}
		if (prefix.lastIndexOf("/") != prefix.length - 1) {
			prefix = prefix + "/";
		}
		url = protocol + "://" + prefix + url;
	}
	return url + (url.indexOf("?") > -1 ? "&" : "?") + this.RpcActionParam + "=" + action;
}, loadProcessResponse:function (node, result) {
	if (!dojo.lang.isArray(result)) {
		throw new dojo.FormatError("loadProcessResponse: Not array loaded: " + result);
	}
	node.setChildren(result);
}, runRpc:function (kw) {
	var _this = this;
	var deferred = new dojo.Deferred();
	dojo.io.bind({url:kw.url, handle:this.getDeferredBindHandler(deferred), mimetype:"text/javascript", preventCache:this.preventCache, sync:kw.sync, content:{data:dojo.json.serialize(kw.params)}});
	return deferred;
}, loadRemote:function (node, sync) {
	var _this = this;
	var params = {node:this.getInfo(node), tree:this.getInfo(node.tree)};
	var deferred = this.runRpc({url:this.getRpcUrl("getChildren"), sync:sync, params:params});
	deferred.addCallback(function (res) {
		return _this.loadProcessResponse(node, res);
	});
	return deferred;
}, batchExpandTimeout:0, recurseToLevel:function (widget, level, callFunc, callObj, skipFirst, sync) {
	if (level == 0) {
		return;
	}
	if (!skipFirst) {
		var deferred = callFunc.call(callObj, widget, sync);
	} else {
		var deferred = dojo.Deferred.prototype.makeCalled();
	}
	var _this = this;
	var recurseOnExpand = function () {
		var children = widget.children;
		var deferreds = [];
		for (var i = 0; i < children.length; i++) {
			deferreds.push(_this.recurseToLevel(children[i], level - 1, callFunc, callObj, sync));
		}
		return new dojo.DeferredList(deferreds);
	};
	deferred.addCallback(recurseOnExpand);
	return deferred;
}, expandToLevel:function (nodeOrTree, level, sync) {
	return this.recurseToLevel(nodeOrTree, nodeOrTree.isTree ? level + 1 : level, this.expand, this, nodeOrTree.isTree, sync);
}, loadToLevel:function (nodeOrTree, level, sync) {
	return this.recurseToLevel(nodeOrTree, nodeOrTree.isTree ? level + 1 : level, this.loadIfNeeded, this, nodeOrTree.isTree, sync);
}, loadAll:function (nodeOrTree, sync) {
	return this.loadToLevel(nodeOrTree, Number.POSITIVE_INFINITY, sync);
}, expand:function (node, sync) {
	var _this = this;
	var deferred = this.startProcessing(node);
	deferred.addCallback(function () {
		return _this.loadIfNeeded(node, sync);
	});
	deferred.addCallback(function (res) {
		dojo.widget.TreeBasicControllerV3.prototype.expand(node);
		return res;
	});
	deferred.addBoth(function (res) {
		_this.finishProcessing(node);
		return res;
	});
	return deferred;
}, loadIfNeeded:function (node, sync) {
	var deferred;
	if (node.state == node.loadStates.UNCHECKED && node.isFolder && !node.children.length) {
		deferred = this.loadRemote(node, sync);
	} else {
		deferred = new dojo.Deferred();
		deferred.callback();
	}
	return deferred;
}, runStages:function (check, prepare, make, finalize, expose, args) {
	var _this = this;
	if (check && !check.apply(this, args)) {
		return false;
	}
	var deferred = dojo.Deferred.prototype.makeCalled();
	if (prepare) {
		deferred.addCallback(function () {
			return prepare.apply(_this, args);
		});
	}
	if (make) {
		deferred.addCallback(function () {
			var res = make.apply(_this, args);
			return res;
		});
	}
	if (finalize) {
		deferred.addBoth(function (res) {
			finalize.apply(_this, args);
			return res;
		});
	}
	if (expose) {
		deferred.addCallback(function (res) {
			expose.apply(_this, args);
			return res;
		});
	}
	return deferred;
}, startProcessing:function (nodesArray) {
	var deferred = new dojo.Deferred();
	var nodes = dojo.lang.isArray(nodesArray) ? nodesArray : arguments;
	for (var i = 0; i < nodes.length; i++) {
		if (nodes[i].isLocked()) {
			deferred.errback(new dojo.LockedError("item locked " + nodes[i], nodes[i]));
			return deferred;
		}
		if (nodes[i].isTreeNode) {
			nodes[i].markProcessing();
		}
		nodes[i].lock();
	}
	deferred.callback();
	return deferred;
}, finishProcessing:function (nodesArray) {
	var nodes = dojo.lang.isArray(nodesArray) ? nodesArray : arguments;
	for (var i = 0; i < nodes.length; i++) {
		if (!nodes[i].hasLock()) {
			continue;
		}
		nodes[i].unlock();
		if (nodes[i].isTreeNode) {
			nodes[i].unmarkProcessing();
		}
	}
}, refreshChildren:function (nodeOrTree, sync) {
	return this.runStages(null, this.prepareRefreshChildren, this.doRefreshChildren, this.finalizeRefreshChildren, this.exposeRefreshChildren, arguments);
}, prepareRefreshChildren:function (nodeOrTree, sync) {
	var deferred = this.startProcessing(nodeOrTree);
	nodeOrTree.destroyChildren();
	nodeOrTree.state = nodeOrTree.loadStates.UNCHECKED;
	return deferred;
}, doRefreshChildren:function (nodeOrTree, sync) {
	return this.loadRemote(nodeOrTree, sync);
}, finalizeRefreshChildren:function (nodeOrTree, sync) {
	this.finishProcessing(nodeOrTree);
}, exposeRefreshChildren:function (nodeOrTree, sync) {
	nodeOrTree.expand();
}, move:function (child, newParent, index) {
	return this.runStages(this.canMove, this.prepareMove, this.doMove, this.finalizeMove, this.exposeMove, arguments);
}, doMove:function (child, newParent, index) {
	child.tree.move(child, newParent, index);
	return true;
}, prepareMove:function (child, newParent, index, sync) {
	var deferred = this.startProcessing(newParent);
	deferred.addCallback(dojo.lang.hitch(this, function () {
		return this.loadIfNeeded(newParent, sync);
	}));
	return deferred;
}, finalizeMove:function (child, newParent) {
	this.finishProcessing(newParent);
}, prepareCreateChild:function (parent, index, data, sync) {
	var deferred = this.startProcessing(parent);
	deferred.addCallback(dojo.lang.hitch(this, function () {
		return this.loadIfNeeded(parent, sync);
	}));
	return deferred;
}, finalizeCreateChild:function (parent) {
	this.finishProcessing(parent);
}, prepareClone:function (child, newParent, index, deep, sync) {
	var deferred = this.startProcessing(child, newParent);
	deferred.addCallback(dojo.lang.hitch(this, function () {
		return this.loadIfNeeded(newParent, sync);
	}));
	return deferred;
}, finalizeClone:function (child, newParent) {
	this.finishProcessing(child, newParent);
}});


__CPAN_FILE__ src/widget/Tooltip.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.widget.Tooltip");
dojo.require("dojo.widget.ContentPane");
dojo.require("dojo.widget.PopupContainer");
dojo.require("dojo.uri.Uri");
dojo.require("dojo.widget.*");
dojo.require("dojo.event.*");
dojo.require("dojo.html.style");
dojo.require("dojo.html.util");
dojo.widget.defineWidget("dojo.widget.Tooltip", [dojo.widget.ContentPane, dojo.widget.PopupContainerBase], {caption:"", showDelay:500, hideDelay:100, connectId:"", templateCssString:".dojoTooltip {\n\tborder: solid black 1px;\n\tbackground: beige;\n\tcolor: black;\n\tposition: absolute;\n\tfont-size: small;\n\tpadding: 2px 2px 2px 2px;\n\tz-index: 10;\n\tdisplay: block;\n}\n", templateCssPath:dojo.uri.moduleUri("dojo.widget", "templates/TooltipTemplate.css"), fillInTemplate:function (args, frag) {
	if (this.caption != "") {
		this.domNode.appendChild(document.createTextNode(this.caption));
	}
	this._connectNode = dojo.byId(this.connectId);
	dojo.widget.Tooltip.superclass.fillInTemplate.call(this, args, frag);
	this.addOnLoad(this, "_loadedContent");
	dojo.html.addClass(this.domNode, "dojoTooltip");
	var source = this.getFragNodeRef(frag);
	dojo.html.copyStyle(this.domNode, source);
	this.applyPopupBasicStyle();
}, postCreate:function (args, frag) {
	dojo.event.connect(this._connectNode, "onmouseover", this, "_onMouseOver");
	dojo.widget.Tooltip.superclass.postCreate.call(this, args, frag);
}, _onMouseOver:function (e) {
	this._mouse = {x:e.pageX, y:e.pageY};
	if (!this._tracking) {
		dojo.event.connect(document.documentElement, "onmousemove", this, "_onMouseMove");
		this._tracking = true;
	}
	this._onHover(e);
}, _onMouseMove:function (e) {
	this._mouse = {x:e.pageX, y:e.pageY};
	if (dojo.html.overElement(this._connectNode, e) || dojo.html.overElement(this.domNode, e)) {
		this._onHover(e);
	} else {
		this._onUnHover(e);
	}
}, _onHover:function (e) {
	if (this._hover) {
		return;
	}
	this._hover = true;
	if (this._hideTimer) {
		clearTimeout(this._hideTimer);
		delete this._hideTimer;
	}
	if (!this.isShowingNow && !this._showTimer) {
		this._showTimer = setTimeout(dojo.lang.hitch(this, "open"), this.showDelay);
	}
}, _onUnHover:function (e) {
	if (!this._hover) {
		return;
	}
	this._hover = false;
	if (this._showTimer) {
		clearTimeout(this._showTimer);
		delete this._showTimer;
	}
	if (this.isShowingNow && !this._hideTimer) {
		this._hideTimer = setTimeout(dojo.lang.hitch(this, "close"), this.hideDelay);
	}
	if (!this.isShowingNow) {
		dojo.event.disconnect(document.documentElement, "onmousemove", this, "_onMouseMove");
		this._tracking = false;
	}
}, open:function () {
	if (this.isShowingNow) {
		return;
	}
	dojo.widget.PopupContainerBase.prototype.open.call(this, this._mouse.x, this._mouse.y, null, [this._mouse.x, this._mouse.y], "TL,TR,BL,BR", [10, 15]);
}, close:function () {
	if (this.isShowingNow) {
		if (this._showTimer) {
			clearTimeout(this._showTimer);
			delete this._showTimer;
		}
		if (this._hideTimer) {
			clearTimeout(this._hideTimer);
			delete this._hideTimer;
		}
		dojo.event.disconnect(document.documentElement, "onmousemove", this, "_onMouseMove");
		this._tracking = false;
		dojo.widget.PopupContainerBase.prototype.close.call(this);
	}
}, _position:function () {
	this.move(this._mouse.x, this._mouse.y, [10, 15], "TL,TR,BL,BR");
}, _loadedContent:function () {
	if (this.isShowingNow) {
		this._position();
	}
}, checkSize:function () {
}, uninitialize:function () {
	this.close();
	dojo.event.disconnect(this._connectNode, "onmouseover", this, "_onMouseOver");
}});


__CPAN_FILE__ src/widget/TreeLinkExtension.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.widget.TreeLinkExtension");
dojo.require("dojo.widget.HtmlWidget");
dojo.require("dojo.widget.TreeExtension");
dojo.widget.defineWidget("dojo.widget.TreeLinkExtension", dojo.widget.TreeExtension, function () {
	this.params = {};
}, {listenTreeEvents:["afterChangeTree"], listenTree:function (tree) {
	dojo.widget.TreeCommon.prototype.listenTree.call(this, tree);
	var labelNode = tree.labelNodeTemplate;
	var newLabel = this.makeALabel();
	dojo.html.setClass(newLabel, dojo.html.getClass(labelNode));
	labelNode.parentNode.replaceChild(newLabel, labelNode);
}, makeALabel:function () {
	var newLabel = document.createElement("a");
	for (var key in this.params) {
		if (key in {}) {
			continue;
		}
		newLabel.setAttribute(key, this.params[key]);
	}
	return newLabel;
}, onAfterChangeTree:function (message) {
	var _this = this;
	if (!message.oldTree) {
		this.listenNode(message.node);
	}
}, listenNode:function (node) {
	for (var key in node.object) {
		if (key in {}) {
			continue;
		}
		node.labelNode.setAttribute(key, node.object[key]);
	}
}});


__CPAN_FILE__ src/widget/TreeContextMenuV3.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.widget.TreeContextMenuV3");
dojo.require("dojo.event.*");
dojo.require("dojo.io.*");
dojo.require("dojo.widget.*");
dojo.require("dojo.widget.Menu2");
dojo.require("dojo.widget.TreeCommon");
dojo.widget.defineWidget("dojo.widget.TreeContextMenuV3", [dojo.widget.PopupMenu2, dojo.widget.TreeCommon], function () {
	this.listenedTrees = {};
}, {listenTreeEvents:["afterTreeCreate", "beforeTreeDestroy"], listenNodeFilter:function (elem) {
	return elem instanceof dojo.widget.Widget;
}, onAfterTreeCreate:function (message) {
	var tree = message.source;
	this.bindDomNode(tree.domNode);
}, onBeforeTreeDestroy:function (message) {
	this.unBindDomNode(message.source.domNode);
}, getTreeNode:function () {
	var source = this.getTopOpenEvent().target;
	var treeNode = this.domElement2TreeNode(source);
	return treeNode;
}, open:function () {
	var result = dojo.widget.PopupMenu2.prototype.open.apply(this, arguments);
	for (var i = 0; i < this.children.length; i++) {
		if (this.children[i].menuOpen) {
			this.children[i].menuOpen(this.getTreeNode());
		}
	}
	return result;
}, close:function () {
	for (var i = 0; i < this.children.length; i++) {
		if (this.children[i].menuClose) {
			this.children[i].menuClose(this.getTreeNode());
		}
	}
	var result = dojo.widget.PopupMenu2.prototype.close.apply(this, arguments);
	return result;
}});
dojo.widget.defineWidget("dojo.widget.TreeMenuItemV3", [dojo.widget.MenuItem2, dojo.widget.TreeCommon], function () {
	this.treeActions = [];
}, {treeActions:"", initialize:function (args, frag) {
	for (var i = 0; i < this.treeActions.length; i++) {
		this.treeActions[i] = this.treeActions[i].toUpperCase();
	}
}, getTreeNode:function () {
	var menu = this;
	while (!(menu instanceof dojo.widget.TreeContextMenuV3)) {
		menu = menu.parent;
	}
	var treeNode = menu.getTreeNode();
	return treeNode;
}, menuOpen:function (treeNode) {
	treeNode.viewEmphasize();
	this.setDisabled(false);
	var _this = this;
	dojo.lang.forEach(_this.treeActions, function (action) {
		_this.setDisabled(treeNode.actionIsDisabledNow(action));
	});
}, menuClose:function (treeNode) {
	treeNode.viewUnemphasize();
}, toString:function () {
	return "[" + this.widgetType + " node " + this.getTreeNode() + "]";
}});


__CPAN_FILE__ src/widget/TreeCommon.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.widget.TreeCommon");
dojo.require("dojo.widget.*");
dojo.declare("dojo.widget.TreeCommon", null, {listenTreeEvents:[], listenedTrees:{}, listenNodeFilter:null, listenTree:function (tree) {
	var _this = this;
	if (this.listenedTrees[tree.widgetId]) {
		return;
	}
	dojo.lang.forEach(this.listenTreeEvents, function (event) {
		var eventHandler = "on" + event.charAt(0).toUpperCase() + event.substr(1);
		dojo.event.topic.subscribe(tree.eventNames[event], _this, eventHandler);
	});
	var filter;
	if (this.listenNodeFilter) {
		this.processDescendants(tree, this.listenNodeFilter, this.listenNode, true);
	}
	this.listenedTrees[tree.widgetId] = true;
}, listenNode:function () {
}, unlistenNode:function () {
}, unlistenTree:function (tree, nodeFilter) {
	var _this = this;
	if (!this.listenedTrees[tree.widgetId]) {
		return;
	}
	dojo.lang.forEach(this.listenTreeEvents, function (event) {
		var eventHandler = "on" + event.charAt(0).toUpperCase() + event.substr(1);
		dojo.event.topic.unsubscribe(tree.eventNames[event], _this, eventHandler);
	});
	if (this.listenNodeFilter) {
		this.processDescendants(tree, this.listenNodeFilter, this.unlistenNode, true);
	}
	delete this.listenedTrees[tree.widgetId];
}, checkPathCondition:function (domElement, condition) {
	while (domElement && !domElement.widgetId) {
		if (condition.call(null, domElement)) {
			return true;
		}
		domElement = domElement.parentNode;
	}
	return false;
}, domElement2TreeNode:function (domElement) {
	while (domElement && !domElement.widgetId) {
		domElement = domElement.parentNode;
	}
	if (!domElement) {
		return null;
	}
	var widget = dojo.widget.byId(domElement.widgetId);
	if (!widget.isTreeNode) {
		return null;
	}
	return widget;
}, processDescendants:function (elem, filter, func, skipFirst) {
	var _this = this;
	if (!skipFirst) {
		if (!filter.call(_this, elem)) {
			return;
		}
		func.call(_this, elem);
	}
	var stack = [elem];
	while (elem = stack.pop()) {
		dojo.lang.forEach(elem.children, function (elem) {
			if (filter.call(_this, elem)) {
				func.call(_this, elem);
				stack.push(elem);
			}
		});
	}
}});


__CPAN_FILE__ src/widget/Toaster.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.widget.Toaster");
dojo.require("dojo.widget.*");
dojo.require("dojo.lfx.*");
dojo.require("dojo.html.iframe");
dojo.widget.defineWidget("dojo.widget.Toaster", dojo.widget.HtmlWidget, {templateString:"<div dojoAttachPoint=\"clipNode\"><div dojoAttachPoint=\"containerNode\" dojoAttachEvent=\"onClick:onSelect\"><div dojoAttachPoint=\"contentNode\"></div></div></div>", templateCssString:".dojoToasterClip {\n\tposition: absolute;\n\toverflow: hidden;\n}\n\n.dojoToasterContainer {\n\tdisplay: block;\n\tposition: absolute;\n\twidth: 17.5em;\n\tz-index: 5000;\n\tmargin: 0px;\n\tfont:0.75em Tahoma, Helvetica, Verdana, Arial;\n}\n\n.dojoToasterContent{\n\tpadding:1em;\n\tpadding-top:0.25em;\n\tbackground:#73c74a;\n}\n\n.dojoToasterMessage{ \n\tcolor:#fff;\n}\n.dojoToasterWarning{ }\n.dojoToasterError,\n.dojoToasterFatal{\n\tfont-weight:bold;\n\tcolor:#fff;\n}\n\n\n.dojoToasterWarning .dojoToasterContent{\n\tpadding:1em;\n\tpadding-top:0.25em;\n\tbackground:#d4d943;\n} \n\n.dojoToasterError .dojoToasterContent{\n\tpadding:1em;\n\tpadding-top:0.25em;\n\tbackground:#c46600;\n} \n", templateCssPath:dojo.uri.moduleUri("dojo.widget", "templates/Toaster.css"), messageTopic:"", messageTypes:{MESSAGE:"MESSAGE", WARNING:"WARNING", ERROR:"ERROR", FATAL:"FATAL"}, defaultType:"MESSAGE", clipCssClass:"dojoToasterClip", containerCssClass:"dojoToasterContainer", contentCssClass:"dojoToasterContent", messageCssClass:"dojoToasterMessage", warningCssClass:"dojoToasterWarning", errorCssClass:"dojoToasterError", fatalCssClass:"dojoToasterFatal", positionDirection:"br-up", positionDirectionTypes:["br-up", "br-left", "bl-up", "bl-right", "tr-down", "tr-left", "tl-down", "tl-right"], showDelay:2000, postCreate:function () {
	this.hide();
	dojo.html.setClass(this.clipNode, this.clipCssClass);
	dojo.html.addClass(this.containerNode, this.containerCssClass);
	dojo.html.setClass(this.contentNode, this.contentCssClass);
	if (this.messageTopic) {
		dojo.event.topic.subscribe(this.messageTopic, this, "_handleMessage");
	}
	if (!this.positionDirection || !dojo.lang.inArray(this.positionDirectionTypes, this.positionDirection)) {
		this.positionDirection = this.positionDirectionTypes.BRU;
	}
}, _handleMessage:function (msg) {
	if (dojo.lang.isString(msg)) {
		this.setContent(msg);
	} else {
		this.setContent(msg["message"], msg["type"], msg["delay"]);
	}
}, setContent:function (msg, messageType, delay) {
	var delay = delay || this.showDelay;
	if (this.slideAnim && this.slideAnim.status() == "playing") {
		dojo.lang.setTimeout(50, dojo.lang.hitch(this, function () {
			this.setContent(msg, messageType);
		}));
		return;
	} else {
		if (this.slideAnim) {
			this.slideAnim.stop();
			if (this.fadeAnim) {
				this.fadeAnim.stop();
			}
		}
	}
	if (!msg) {
		dojo.debug(this.widgetId + ".setContent() incoming content was null, ignoring.");
		return;
	}
	if (!this.positionDirection || !dojo.lang.inArray(this.positionDirectionTypes, this.positionDirection)) {
		dojo.raise(this.widgetId + ".positionDirection is an invalid value: " + this.positionDirection);
	}
	dojo.html.removeClass(this.containerNode, this.messageCssClass);
	dojo.html.removeClass(this.containerNode, this.warningCssClass);
	dojo.html.removeClass(this.containerNode, this.errorCssClass);
	dojo.html.removeClass(this.containerNode, this.fatalCssClass);
	dojo.html.clearOpacity(this.containerNode);
	if (msg instanceof String || typeof msg == "string") {
		this.contentNode.innerHTML = msg;
	} else {
		if (dojo.html.isNode(msg)) {
			this.contentNode.innerHTML = dojo.html.getContentAsString(msg);
		} else {
			dojo.raise("Toaster.setContent(): msg is of unknown type:" + msg);
		}
	}
	switch (messageType) {
	  case this.messageTypes.WARNING:
		dojo.html.addClass(this.containerNode, this.warningCssClass);
		break;
	  case this.messageTypes.ERROR:
		dojo.html.addClass(this.containerNode, this.errorCssClass);
		break;
	  case this.messageTypes.FATAL:
		dojo.html.addClass(this.containerNode, this.fatalCssClass);
		break;
	  case this.messageTypes.MESSAGE:
	  default:
		dojo.html.addClass(this.containerNode, this.messageCssClass);
		break;
	}
	this.show();
	var nodeSize = dojo.html.getMarginBox(this.containerNode);
	if (this.positionDirection.indexOf("-up") >= 0) {
		this.containerNode.style.left = 0 + "px";
		this.containerNode.style.top = nodeSize.height + 10 + "px";
	} else {
		if (this.positionDirection.indexOf("-left") >= 0) {
			this.containerNode.style.left = nodeSize.width + 10 + "px";
			this.containerNode.style.top = 0 + "px";
		} else {
			if (this.positionDirection.indexOf("-right") >= 0) {
				this.containerNode.style.left = 0 - nodeSize.width - 10 + "px";
				this.containerNode.style.top = 0 + "px";
			} else {
				if (this.positionDirection.indexOf("-down") >= 0) {
					this.containerNode.style.left = 0 + "px";
					this.containerNode.style.top = 0 - nodeSize.height - 10 + "px";
				} else {
					dojo.raise(this.widgetId + ".positionDirection is an invalid value: " + this.positionDirection);
				}
			}
		}
	}
	this.slideAnim = dojo.lfx.html.slideTo(this.containerNode, {top:0, left:0}, 450, null, dojo.lang.hitch(this, function (nodes, anim) {
		dojo.lang.setTimeout(dojo.lang.hitch(this, function (evt) {
			if (this.bgIframe) {
				this.bgIframe.hide();
			}
			this.fadeAnim = dojo.lfx.html.fadeOut(this.containerNode, 1000, null, dojo.lang.hitch(this, function (evt) {
				this.hide();
			})).play();
		}), delay);
	})).play();
}, _placeClip:function () {
	var scroll = dojo.html.getScroll();
	var view = dojo.html.getViewport();
	var nodeSize = dojo.html.getMarginBox(this.containerNode);
	this.clipNode.style.height = nodeSize.height + "px";
	this.clipNode.style.width = nodeSize.width + "px";
	if (this.positionDirection.match(/^t/)) {
		this.clipNode.style.top = scroll.top + "px";
	} else {
		if (this.positionDirection.match(/^b/)) {
			this.clipNode.style.top = (view.height - nodeSize.height - 2 + scroll.top) + "px";
		}
	}
	if (this.positionDirection.match(/^[tb]r-/)) {
		this.clipNode.style.left = (view.width - nodeSize.width - 1 - scroll.left) + "px";
	} else {
		if (this.positionDirection.match(/^[tb]l-/)) {
			this.clipNode.style.left = 0 + "px";
		}
	}
	this.clipNode.style.clip = "rect(0px, " + nodeSize.width + "px, " + nodeSize.height + "px, 0px)";
	if (dojo.render.html.ie) {
		if (!this.bgIframe) {
			this.bgIframe = new dojo.html.BackgroundIframe(this.containerNode);
			this.bgIframe.setZIndex(this.containerNode);
		}
		this.bgIframe.onResized();
		this.bgIframe.show();
	}
}, onSelect:function (e) {
}, show:function () {
	dojo.widget.Toaster.superclass.show.call(this);
	this._placeClip();
	if (!this._scrollConnected) {
		this._scrollConnected = true;
		dojo.event.connect(window, "onscroll", this, "_placeClip");
	}
}, hide:function () {
	dojo.widget.Toaster.superclass.hide.call(this);
	if (this._scrollConnected) {
		this._scrollConnected = false;
		dojo.event.disconnect(window, "onscroll", this, "_placeClip");
	}
	dojo.html.setOpacity(this.containerNode, 1);
}});


__CPAN_FILE__ src/widget/ContentPane.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.widget.ContentPane");
dojo.require("dojo.widget.*");
dojo.require("dojo.io.*");
dojo.require("dojo.widget.HtmlWidget");
dojo.require("dojo.string");
dojo.require("dojo.string.extras");
dojo.require("dojo.html.style");
dojo.widget.defineWidget("dojo.widget.ContentPane", dojo.widget.HtmlWidget, function () {
	this._styleNodes = [];
	this._onLoadStack = [];
	this._onUnloadStack = [];
	this._callOnUnload = false;
	this._ioBindObj;
	this.scriptScope;
	this.bindArgs = {};
}, {isContainer:true, adjustPaths:true, href:"", extractContent:true, parseContent:true, cacheContent:true, preload:false, refreshOnShow:false, handler:"", executeScripts:false, scriptSeparation:true, loadingMessage:"Loading...", isLoaded:false, postCreate:function (args, frag, parentComp) {
	if (this.handler !== "") {
		this.setHandler(this.handler);
	}
	if (this.isShowing() || this.preload) {
		this.loadContents();
	}
}, show:function () {
	if (this.refreshOnShow) {
		this.refresh();
	} else {
		this.loadContents();
	}
	dojo.widget.ContentPane.superclass.show.call(this);
}, refresh:function () {
	this.isLoaded = false;
	this.loadContents();
}, loadContents:function () {
	if (this.isLoaded) {
		return;
	}
	if (dojo.lang.isFunction(this.handler)) {
		this._runHandler();
	} else {
		if (this.href != "") {
			this._downloadExternalContent(this.href, this.cacheContent && !this.refreshOnShow);
		}
	}
}, setUrl:function (url) {
	this.href = url;
	this.isLoaded = false;
	if (this.preload || this.isShowing()) {
		this.loadContents();
	}
}, abort:function () {
	var bind = this._ioBindObj;
	if (!bind || !bind.abort) {
		return;
	}
	bind.abort();
	delete this._ioBindObj;
}, _downloadExternalContent:function (url, useCache) {
	this.abort();
	this._handleDefaults(this.loadingMessage, "onDownloadStart");
	var self = this;
	this._ioBindObj = dojo.io.bind(this._cacheSetting({url:url, mimetype:"text/html", handler:function (type, data, xhr) {
		delete self._ioBindObj;
		if (type == "load") {
			self.onDownloadEnd.call(self, url, data);
		} else {
			var e = {responseText:xhr.responseText, status:xhr.status, statusText:xhr.statusText, responseHeaders:xhr.getAllResponseHeaders(), text:"Error loading '" + url + "' (" + xhr.status + " " + xhr.statusText + ")"};
			self._handleDefaults.call(self, e, "onDownloadError");
			self.onLoad();
		}
	}}, useCache));
}, _cacheSetting:function (bindObj, useCache) {
	for (var x in this.bindArgs) {
		if (dojo.lang.isUndefined(bindObj[x])) {
			bindObj[x] = this.bindArgs[x];
		}
	}
	if (dojo.lang.isUndefined(bindObj.useCache)) {
		bindObj.useCache = useCache;
	}
	if (dojo.lang.isUndefined(bindObj.preventCache)) {
		bindObj.preventCache = !useCache;
	}
	if (dojo.lang.isUndefined(bindObj.mimetype)) {
		bindObj.mimetype = "text/html";
	}
	return bindObj;
}, onLoad:function (e) {
	this._runStack("_onLoadStack");
	this.isLoaded = true;
}, onUnLoad:function (e) {
	dojo.deprecated(this.widgetType + ".onUnLoad, use .onUnload (lowercased load)", 0.5);
}, onUnload:function (e) {
	this._runStack("_onUnloadStack");
	delete this.scriptScope;
	if (this.onUnLoad !== dojo.widget.ContentPane.prototype.onUnLoad) {
		this.onUnLoad.apply(this, arguments);
	}
}, _runStack:function (stName) {
	var st = this[stName];
	var err = "";
	var scope = this.scriptScope || window;
	for (var i = 0; i < st.length; i++) {
		try {
			st[i].call(scope);
		}
		catch (e) {
			err += "\n" + st[i] + " failed: " + e.description;
		}
	}
	this[stName] = [];
	if (err.length) {
		var name = (stName == "_onLoadStack") ? "addOnLoad" : "addOnUnLoad";
		this._handleDefaults(name + " failure\n " + err, "onExecError", "debug");
	}
}, addOnLoad:function (obj, func) {
	this._pushOnStack(this._onLoadStack, obj, func);
}, addOnUnload:function (obj, func) {
	this._pushOnStack(this._onUnloadStack, obj, func);
}, addOnUnLoad:function () {
	dojo.deprecated(this.widgetType + ".addOnUnLoad, use addOnUnload instead. (lowercased Load)", 0.5);
	this.addOnUnload.apply(this, arguments);
}, _pushOnStack:function (stack, obj, func) {
	if (typeof func == "undefined") {
		stack.push(obj);
	} else {
		stack.push(function () {
			obj[func]();
		});
	}
}, destroy:function () {
	this.onUnload();
	dojo.widget.ContentPane.superclass.destroy.call(this);
}, onExecError:function (e) {
}, onContentError:function (e) {
}, onDownloadError:function (e) {
}, onDownloadStart:function (e) {
}, onDownloadEnd:function (url, data) {
	data = this.splitAndFixPaths(data, url);
	this.setContent(data);
}, _handleDefaults:function (e, handler, messType) {
	if (!handler) {
		handler = "onContentError";
	}
	if (dojo.lang.isString(e)) {
		e = {text:e};
	}
	if (!e.text) {
		e.text = e.toString();
	}
	e.toString = function () {
		return this.text;
	};
	if (typeof e.returnValue != "boolean") {
		e.returnValue = true;
	}
	if (typeof e.preventDefault != "function") {
		e.preventDefault = function () {
			this.returnValue = false;
		};
	}
	this[handler](e);
	if (e.returnValue) {
		switch (messType) {
		  case true:
		  case "alert":
			alert(e.toString());
			break;
		  case "debug":
			dojo.debug(e.toString());
			break;
		  default:
			if (this._callOnUnload) {
				this.onUnload();
			}
			this._callOnUnload = false;
			if (arguments.callee._loopStop) {
				dojo.debug(e.toString());
			} else {
				arguments.callee._loopStop = true;
				this._setContent(e.toString());
			}
		}
	}
	arguments.callee._loopStop = false;
}, splitAndFixPaths:function (s, url) {
	var titles = [], scripts = [], tmp = [];
	var match = [], requires = [], attr = [], styles = [];
	var str = "", path = "", fix = "", tagFix = "", tag = "", origPath = "";
	if (!url) {
		url = "./";
	}
	if (s) {
		var regex = /<title[^>]*>([\s\S]*?)<\/title>/i;
		while (match = regex.exec(s)) {
			titles.push(match[1]);
			s = s.substring(0, match.index) + s.substr(match.index + match[0].length);
		}
		if (this.adjustPaths) {
			var regexFindTag = /<[a-z][a-z0-9]*[^>]*\s(?:(?:src|href|style)=[^>])+[^>]*>/i;
			var regexFindAttr = /\s(src|href|style)=(['"]?)([\w()\[\]\/.,\\'"-:;#=&?\s@]+?)\2/i;
			var regexProtocols = /^(?:[#]|(?:(?:https?|ftps?|file|javascript|mailto|news):))/;
			while (tag = regexFindTag.exec(s)) {
				str += s.substring(0, tag.index);
				s = s.substring((tag.index + tag[0].length), s.length);
				tag = tag[0];
				tagFix = "";
				while (attr = regexFindAttr.exec(tag)) {
					path = "";
					origPath = attr[3];
					switch (attr[1].toLowerCase()) {
					  case "src":
					  case "href":
						if (regexProtocols.exec(origPath)) {
							path = origPath;
						} else {
							path = (new dojo.uri.Uri(url, origPath).toString());
						}
						break;
					  case "style":
						path = dojo.html.fixPathsInCssText(origPath, url);
						break;
					  default:
						path = origPath;
					}
					fix = " " + attr[1] + "=" + attr[2] + path + attr[2];
					tagFix += tag.substring(0, attr.index) + fix;
					tag = tag.substring((attr.index + attr[0].length), tag.length);
				}
				str += tagFix + tag;
			}
			s = str + s;
		}
		regex = /(?:<(style)[^>]*>([\s\S]*?)<\/style>|<link ([^>]*rel=['"]?stylesheet['"]?[^>]*)>)/i;
		while (match = regex.exec(s)) {
			if (match[1] && match[1].toLowerCase() == "style") {
				styles.push(dojo.html.fixPathsInCssText(match[2], url));
			} else {
				if (attr = match[3].match(/href=(['"]?)([^'">]*)\1/i)) {
					styles.push({path:attr[2]});
				}
			}
			s = s.substring(0, match.index) + s.substr(match.index + match[0].length);
		}
		var regex = /<script([^>]*)>([\s\S]*?)<\/script>/i;
		var regexSrc = /src=(['"]?)([^"']*)\1/i;
		var regexDojoJs = /.*(\bdojo\b\.js(?:\.uncompressed\.js)?)$/;
		var regexInvalid = /(?:var )?\bdjConfig\b(?:[\s]*=[\s]*\{[^}]+\}|\.[\w]*[\s]*=[\s]*[^;\n]*)?;?|dojo\.hostenv\.writeIncludes\(\s*\);?/g;
		var regexRequires = /dojo\.(?:(?:require(?:After)?(?:If)?)|(?:widget\.(?:manager\.)?registerWidgetPackage)|(?:(?:hostenv\.)?setModulePrefix|registerModulePath)|defineNamespace)\((['"]).*?\1\)\s*;?/;
		while (match = regex.exec(s)) {
			if (this.executeScripts && match[1]) {
				if (attr = regexSrc.exec(match[1])) {
					if (regexDojoJs.exec(attr[2])) {
						dojo.debug("Security note! inhibit:" + attr[2] + " from  being loaded again.");
					} else {
						scripts.push({path:attr[2]});
					}
				}
			}
			if (match[2]) {
				var sc = match[2].replace(regexInvalid, "");
				if (!sc) {
					continue;
				}
				while (tmp = regexRequires.exec(sc)) {
					requires.push(tmp[0]);
					sc = sc.substring(0, tmp.index) + sc.substr(tmp.index + tmp[0].length);
				}
				if (this.executeScripts) {
					scripts.push(sc);
				}
			}
			s = s.substr(0, match.index) + s.substr(match.index + match[0].length);
		}
		if (this.extractContent) {
			match = s.match(/<body[^>]*>\s*([\s\S]+)\s*<\/body>/im);
			if (match) {
				s = match[1];
			}
		}
		if (this.executeScripts && this.scriptSeparation) {
			var regex = /(<[a-zA-Z][a-zA-Z0-9]*\s[^>]*?\S=)((['"])[^>]*scriptScope[^>]*>)/;
			var regexAttr = /([\s'";:\(])scriptScope(.*)/;
			str = "";
			while (tag = regex.exec(s)) {
				tmp = ((tag[3] == "'") ? "\"" : "'");
				fix = "";
				str += s.substring(0, tag.index) + tag[1];
				while (attr = regexAttr.exec(tag[2])) {
					tag[2] = tag[2].substring(0, attr.index) + attr[1] + "dojo.widget.byId(" + tmp + this.widgetId + tmp + ").scriptScope" + attr[2];
				}
				str += tag[2];
				s = s.substr(tag.index + tag[0].length);
			}
			s = str + s;
		}
	}
	return {"xml":s, "styles":styles, "titles":titles, "requires":requires, "scripts":scripts, "url":url};
}, _setContent:function (cont) {
	this.destroyChildren();
	for (var i = 0; i < this._styleNodes.length; i++) {
		if (this._styleNodes[i] && this._styleNodes[i].parentNode) {
			this._styleNodes[i].parentNode.removeChild(this._styleNodes[i]);
		}
	}
	this._styleNodes = [];
	try {
		var node = this.containerNode || this.domNode;
		while (node.firstChild) {
			dojo.html.destroyNode(node.firstChild);
		}
		if (typeof cont != "string") {
			node.appendChild(cont);
		} else {
			node.innerHTML = cont;
		}
	}
	catch (e) {
		e.text = "Couldn't load content:" + e.description;
		this._handleDefaults(e, "onContentError");
	}
}, setContent:function (data) {
	this.abort();
	if (this._callOnUnload) {
		this.onUnload();
	}
	this._callOnUnload = true;
	if (!data || dojo.html.isNode(data)) {
		this._setContent(data);
		this.onResized();
		this.onLoad();
	} else {
		if (typeof data.xml != "string") {
			this.href = "";
			data = this.splitAndFixPaths(data);
		}
		this._setContent(data.xml);
		for (var i = 0; i < data.styles.length; i++) {
			if (data.styles[i].path) {
				this._styleNodes.push(dojo.html.insertCssFile(data.styles[i].path, dojo.doc(), false, true));
			} else {
				this._styleNodes.push(dojo.html.insertCssText(data.styles[i]));
			}
		}
		if (this.parseContent) {
			for (var i = 0; i < data.requires.length; i++) {
				try {
					eval(data.requires[i]);
				}
				catch (e) {
					e.text = "ContentPane: error in package loading calls, " + (e.description || e);
					this._handleDefaults(e, "onContentError", "debug");
				}
			}
		}
		var _self = this;
		function asyncParse() {
			if (_self.executeScripts) {
				_self._executeScripts(data.scripts);
			}
			if (_self.parseContent) {
				var node = _self.containerNode || _self.domNode;
				var parser = new dojo.xml.Parse();
				var frag = parser.parseElement(node, null, true);
				dojo.widget.getParser().createSubComponents(frag, _self);
			}
			_self.onResized();
			_self.onLoad();
		}
		if (dojo.hostenv.isXDomain && data.requires.length) {
			dojo.addOnLoad(asyncParse);
		} else {
			asyncParse();
		}
	}
}, setHandler:function (handler) {
	var fcn = dojo.lang.isFunction(handler) ? handler : window[handler];
	if (!dojo.lang.isFunction(fcn)) {
		this._handleDefaults("Unable to set handler, '" + handler + "' not a function.", "onExecError", true);
		return;
	}
	this.handler = function () {
		return fcn.apply(this, arguments);
	};
}, _runHandler:function () {
	var ret = true;
	if (dojo.lang.isFunction(this.handler)) {
		this.handler(this, this.domNode);
		ret = false;
	}
	this.onLoad();
	return ret;
}, _executeScripts:function (scripts) {
	var self = this;
	var tmp = "", code = "";
	for (var i = 0; i < scripts.length; i++) {
		if (scripts[i].path) {
			dojo.io.bind(this._cacheSetting({"url":scripts[i].path, "load":function (type, scriptStr) {
				dojo.lang.hitch(self, tmp = ";" + scriptStr);
			}, "error":function (type, error) {
				error.text = type + " downloading remote script";
				self._handleDefaults.call(self, error, "onExecError", "debug");
			}, "mimetype":"text/plain", "sync":true}, this.cacheContent));
			code += tmp;
		} else {
			code += scripts[i];
		}
	}
	try {
		if (this.scriptSeparation) {
			delete this.scriptScope;
			this.scriptScope = new (new Function("_container_", code + "; return this;"))(self);
		} else {
			var djg = dojo.global();
			if (djg.execScript) {
				djg.execScript(code);
			} else {
				var djd = dojo.doc();
				var sc = djd.createElement("script");
				sc.appendChild(djd.createTextNode(code));
				(this.containerNode || this.domNode).appendChild(sc);
			}
		}
	}
	catch (e) {
		e.text = "Error running scripts from content:\n" + e.description;
		this._handleDefaults(e, "onExecError", "debug");
	}
}});


__CPAN_FILE__ src/widget/Select.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.widget.Select");
dojo.require("dojo.widget.ComboBox");
dojo.require("dojo.widget.*");
dojo.require("dojo.widget.html.stabile");
dojo.widget.defineWidget("dojo.widget.Select", dojo.widget.ComboBox, {forceValidOption:true, setValue:function (value) {
	this.comboBoxValue.value = value;
	dojo.widget.html.stabile.setState(this.widgetId, this.getState(), true);
	this.onValueChanged(value);
}, setLabel:function (value) {
	this.comboBoxSelectionValue.value = value;
	if (this.textInputNode.value != value) {
		this.textInputNode.value = value;
	}
}, getLabel:function () {
	return this.comboBoxSelectionValue.value;
}, getState:function () {
	return {value:this.getValue(), label:this.getLabel()};
}, onKeyUp:function (evt) {
	this.setLabel(this.textInputNode.value);
}, setState:function (state) {
	this.setValue(state.value);
	this.setLabel(state.label);
}, setAllValues:function (value1, value2) {
	this.setLabel(value1);
	this.setValue(value2);
}});


__CPAN_FILE__ src/widget/TreeTimeoutIterator.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.widget.TreeTimeoutIterator");
dojo.require("dojo.event.*");
dojo.require("dojo.json");
dojo.require("dojo.io.*");
dojo.require("dojo.widget.TreeCommon");
dojo.declare("dojo.widget.TreeTimeoutIterator", null, function (elem, callFunc, callObj) {
	var _this = this;
	this.currentParent = elem;
	this.callFunc = callFunc;
	this.callObj = callObj ? callObj : this;
	this.stack = [];
}, {maxStackDepth:Number.POSITIVE_INFINITY, stack:null, currentParent:null, currentIndex:0, filterFunc:function () {
	return true;
}, finishFunc:function () {
	return true;
}, setFilter:function (func, obj) {
	this.filterFunc = func;
	this.filterObj = obj;
}, setMaxLevel:function (level) {
	this.maxStackDepth = level - 2;
}, forward:function (timeout) {
	var _this = this;
	if (this.timeout) {
		var tid = setTimeout(function () {
			_this.processNext();
			clearTimeout(tid);
		}, _this.timeout);
	} else {
		return this.processNext();
	}
}, start:function (processFirst) {
	if (processFirst) {
		return this.callFunc.call(this.callObj, this.currentParent, this);
	}
	return this.processNext();
}, processNext:function () {
	var handler;
	var _this = this;
	var found;
	var next;
	if (this.maxStackDepth == -2) {
		return;
	}
	while (true) {
		var children = this.currentParent.children;
		if (children && children.length) {
			do {
				next = children[this.currentIndex];
			} while (this.currentIndex++ < children.length && !(found = this.filterFunc.call(this.filterObj, next)));
			if (found) {
				if (next.isFolder && this.stack.length <= this.maxStackDepth) {
					this.moveParent(next, 0);
				}
				return this.callFunc.call(this.callObj, next, this);
			}
		}
		if (this.stack.length) {
			this.popParent();
			continue;
		}
		break;
	}
	return this.finishFunc.call(this.finishObj);
}, setFinish:function (func, obj) {
	this.finishFunc = func;
	this.finishObj = obj;
}, popParent:function () {
	var p = this.stack.pop();
	this.currentParent = p[0];
	this.currentIndex = p[1];
}, moveParent:function (nextParent, nextIndex) {
	this.stack.push([this.currentParent, this.currentIndex]);
	this.currentParent = nextParent;
	this.currentIndex = nextIndex;
}});


__CPAN_FILE__ src/widget/DocPane.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.widget.DocPane");
dojo.require("dojo.widget.*");
dojo.require("dojo.io.*");
dojo.require("dojo.event.*");
dojo.require("dojo.widget.HtmlWidget");
dojo.require("dojo.widget.Editor2");
dojo.require("dojo.widget.Dialog");
dojo.require("dojo.html.common");
dojo.require("dojo.html.display");
dojo.widget.DocPane = function () {
	dojo.event.topic.subscribe("/docs/function/results", this, "onDocResults");
	dojo.event.topic.subscribe("/docs/package/results", this, "onPkgResults");
	dojo.event.topic.subscribe("/docs/function/detail", this, "onDocSelectFunction");
};
dojo.widget.defineWidget("dojo.widget.DocPane", dojo.widget.HtmlWidget, {dialog:null, dialogBg:null, dialogFg:null, logIn:null, edit:null, save:null, cancel:null, detail:null, result:null, packag:null, fn:null, fnLink:null, count:null, row:null, summary:null, description:null, variables:null, vRow:null, vLink:null, vDesc:null, methods:null, mRow:null, mLink:null, mDesc:null, requires:null, rRow:null, rRow2:null, rH3:null, rLink:null, parameters:null, pRow:null, pLink:null, pDesc:null, pOpt:null, pType:null, sType:null, sName:null, sParams:null, sPType:null, sPTypeSave:null, sPName:null, sPNameSave:null, pkgDescription:null, _appends:[], templateString:"<div class=\"dojoDocPane\">\n\t<div dojoAttachPoint=\"containerNode\" class=\"container\"></div>\n\n\t<div dojoAttachPoint=\"dialog\" class=\"dialog\">\n\t\t<div class=\"container\" dojoAttachPoint=\"dialogBg\">\n\t\t\t<div class=\"docDialog\" dojoAttachPoint=\"dialogFg\">\n\t\t\t\t<h2>Log In</h2>\n\t\t\t\t<p><input id=\"dojoDocUserName\" dojoAttachPoint=\"userName\"><label for=\"dojoDocUserName\">User Name:</label></p>\n\t\t\t\t<p><input id=\"dojoDocPassword\" dojoAttachPoint=\"password\" type=\"password\"><label for=\"dojoDocPassword\">Password:</label></p>\n\t\t\t\t<p><input type=\"button\" dojoAttachPoint=\"cancel\" value=\"cancel\"> <input type=\"button\" dojoAttachPoint=\"logIn\" value=\"Log In\"></p>\n\t\t\t\t<p></p>\n\t\t\t</div>\n\t\t</div>\n\t</div>\n\n\t<div dojoAttachPoint=\"nav\" class=\"nav\"><span>Detail</span> | <span>Source</span> | <span>Examples</span> | <span>Walkthrough</span></div>\n\n\t<div dojoAttachPoint=\"detail\" class=\"detail\">\n\t\t<h1>Detail: <span class=\"fn\" dojoAttachPoint=\"fn\">dojo.select</span></h1>\n\t\t<div class=\"description\" dojoAttachPoint=\"description\">Description</div>\n\t\t<div class=\"params\" dojoAttachPoint=\"parameters\">\n\t\t\t<h2>Parameters</h2>\n\t\t\t<div class=\"row\" dojoAttachPoint=\"pRow\">\n\t\t\t\t<span dojoAttachPoint=\"pOpt\"><em>optional</em> </span>\n\t\t\t\t<span><span dojoAttachPoint=\"pType\">type</span> </span>\n\t\t\t\t<a href=\"#\" dojoAttachPoint=\"pLink\">variable</a>\n\t\t\t\t<span> - <span dojoAttachPoint=\"pDesc\"></span></span>\n\t\t\t</div>\n\t\t</div>\n\t\t<div class=\"variables\" dojoAttachPoint=\"variables\">\n\t\t\t<h2>Variables</h2>\n\t\t\t<div class\"row\" dojoAttachPoint=\"vRow\">\n\t\t\t\t<a href=\"#\" dojoAttachPoint=\"vLink\">variable</a><span> - <span dojoAttachPoint=\"vDesc\"></span></span>\n\t\t\t</div>\n\t\t</div>\n\t\t<div class=\"signature\">\n\t\t\t<h2>Signature</h2>\n\t\t\t<div class=\"source\">\n\t\t\t\t<span class=\"return\" dojoAttachPoint=\"sType\">returnType</span> \n\t\t\t\t<span class=\"function\" dojoAttachPoint=\"sName\">foo</span>\n\t\t\t\t(<span class=\"params\" dojoAttachPoint=\"sParams\">\n\t\t\t\t\t<span class=\"type\" dojoAttachPoint=\"sPType\">type </span>\n\t\t\t\t\t<span class=\"name\" dojoAttachPoint=\"sPName\">paramName</span>\n\t\t\t\t</span>)\n\t\t\t</div>\n\t\t</div>\n\t</div>\n\t\n\t<div dojoAttachPoint=\"result\" class=\"result\">\n\t\t<h1>Search Results: <span dojoAttachPoint=\"count\">0</span> matches</h1>\n\t\t<div class=\"row\" dojoAttachPoint=\"row\">\n\t\t\t<a href=\"#\" dojoAttachPoint=\"fnLink\">dojo.fnLink</a>\n\t\t\t<span> - <span class=\"summary\" dojoAttachPoint=\"summary\">summary</span></span>\n\t\t</div>\n\t</div>\n\n\t<div dojoAttachPoint=\"packag\" class=\"package\">\n\t\t<h1>Package: \n\t\t\t<span class=\"pkg\" dojoAttachPoint=\"pkg\">dojo.package</span> \n\t\t\t<span class=\"edit\" dojoAttachPoint=\"edit\">[edit]</span> \n\t\t\t<span class=\"save\" dojoAttachPoint=\"save\">[save]</span>\n\t\t</h1>\n\t\t<div dojoAttachPoint=\"pkgDescription\" class=\"description\">Description</div>\n\t\t<div class=\"methods\" dojoAttachPoint=\"methods\">\n\t\t\t<h2>Methods</h2>\n\t\t\t<div class=\"row\" dojoAttachPoint=\"mRow\">\n\t\t\t\t<a href=\"#\" dojoAttachPoint=\"mLink\">method</a>\n\t\t\t\t<span> - <span class=\"description\" dojoAttachPoint=\"mDesc\"></span></span>\n\t\t\t</div>\n\t\t</div>\n\t\t<div class=\"requires\" dojoAttachPoint=\"requires\">\n\t\t\t<h2>Requires</h2>\n\t\t\t<div class=\"row\" dojoAttachPoint=\"rRow\">\n\t\t\t\t<h3 dojoAttachPoint=\"rH3\">Environment</h3>\n\t\t\t\t<div dojoAttachPoint=\"rRow2\"><a href=\"#\" dojoAttachPoint=\"rLink\" class=\"package\">require</a></div>\n\t\t\t</div>\n\t\t</div>\n\t</div>\n</div>\n", templateCssString:".dojoDocPane { padding:1em; font: 1em Georgia,Times,\"Times New Roman\",serif; }\n\n.dojoDocPane .container{ }\n\n.dojoDocPane .dialog{ }\n.dojoDocPane .dialog .container{ padding: 0.5em; background: #fff; border: 2px solid #333; }\n.dojoDocPane .dialog .docDialog{ background: transparent; width: 20em; }\n.dojoDocPane .dialog .docDialog h2{ margin-top: 0; padding-top: 0; }\n.dojoDocPane .dialog .docDialog input { float: right; margin-right: 1em; }\n.dojoDocPane .dialog .docDialog p{ clear: both; }\n#dojoDocUserName, #dojoDocPassword { width: 10em; }\n\n.dojoDocPane .nav{ }\n.dojoDocPane .nav span{ }\n\n.dojoDocPane .detail{ }\n.dojoDocPane .detail h1{ }\n.dojoDocPane .detail h1 span.fn{ }\n.dojoDocPane .detail .description{ }\n.dojoDocPane .detail .params{ }\n.dojoDocPane .detail .params .row{ }\n.dojoDocPane .detail .params .row span{ }\n.dojoDocPane .detail .variables{ }\n.dojoDocPane .detail .variables .row{ }\n.dojoDocPane .detail .signature{ }\n.dojoDocPane .detail .signature .source{ white-space: pre; font: 0.8em Monaco, Courier, \"Courier New\", monospace; }\n.dojoDocPane .detail .signature .source .return{ color:#369; }\n.dojoDocPane .detail .signature .source .function{ color: #98543F; font-weight: bold; }\n.dojoDocPane .detail .signature .source .params{ }\n.dojoDocPane .detail .signature .source .params .type{ font-style: italic; color: #d17575; }\n.dojoDocPane .detail .signature .source .params .name{ color: #d14040; }\n\n.dojoDocPane .result{ }\n.dojoDocPane .result h1{ }\n.dojoDocPane .result .row{ }\n.dojoDocPane .result .row .summary{ }\n\n.dojoDocPane .package{ }\n.dojoDocPane .package h1{ }\n.dojoDocPane .package .row{ }\n.dojoDocPane .package .row .summary{ }\n.dojoDocPane .package .description{ }\n.dojoDocPane .package .methods{ }\n.dojoDocPane .package .methods h2{ }\n.dojoDocPane .package .methods .row{ }\n.dojoDocPane .package .methods .row .description{ }\n.dojoDocPane .package .requires{ }\n.dojoDocPane .package .requires h2{ }\n.dojoDocPane .package .requires .row{ }\n", templateCssPath:dojo.uri.moduleUri("dojo.widget", "templates/DocPane.css"), isContainer:true, fillInTemplate:function () {
	this.requires = dojo.html.removeNode(this.requires);
	this.rRow.style.display = "none";
	this.rRow2.style.display = "none";
	this.methods = dojo.html.removeNode(this.methods);
	this.mRow.style.display = "none";
	this.dialog = dojo.widget.createWidget("dialog", {}, this.dialog);
	this.dialog.setCloseControl(this.cancel);
	dojo.html.setOpacity(this.dialogBg, 0.8);
	dojo.html.setOpacity(this.dialogFg, 1);
	dojo.event.connect(this.edit, "onclick", dojo.lang.hitch(this, function () {
		if (!this._isLoggedIn) {
			this.dialog.show();
		}
	}));
	dojo.event.connect(this.logIn, "onclick", this, "_logIn");
	dojo.event.connect(this.save, "onclick", this, "_save");
	dojo.event.connect(dojo.docs, "logInSuccess", this, "_loggedIn");
	this.homeSave = this.containerNode.cloneNode(true);
	this.detailSave = dojo.html.removeNode(this.detail);
	this.resultSave = dojo.html.removeNode(this.result);
	this.packageSave = dojo.html.removeNode(this.packag);
	this.results = dojo.html.removeNode(this.results);
	this.rowParent = this.row.parentNode;
	this.rowSave = dojo.html.removeNode(this.row);
	this.vParent = this.vRow.parentNode;
	this.vSave = dojo.html.removeNode(this.vRow);
	this.pParent = this.pRow.parentNode;
	this.pSave = dojo.html.removeNode(this.pRow);
	this.sPTypeSave = dojo.html.removeNode(this.sPType);
	this.sPNameSave = dojo.html.removeNode(this.sPName);
	this.navSave = dojo.html.removeNode(this.nav);
}, _logIn:function () {
	dojo.docs.setUserName(this.userName.value);
	dojo.docs.setPassword(this.password.value);
}, _loggedIn:function () {
	this._isLoggedIn = true;
	this.dialog.hide();
	this.pkgEditor = dojo.widget.createWidget("editor2", {toolbarAlwaysVisible:true}, this.pkgDescription);
}, _save:function () {
	if (this.pkgEditor) {
		dojo.docs.savePackage(this._pkgPath, {description:this.pkgEditor.getEditorContent()});
	}
}, onDocSelectFunction:function (message) {
	dojo.debug("onDocSelectFunction()");
	for (var key in message) {
		dojo.debug(key + ": " + dojo.json.serialize(message[key]));
	}
	var meta = message.meta;
	if (meta) {
		var variables = meta.variables;
		var this_variables = meta.this_variables;
		var child_variables = meta.child_variables;
		var parameters = meta.parameters;
	}
	var doc = message.doc;
	dojo.debug(dojo.json.serialize(doc));
	var appends = this._appends;
	dojo.html.removeChildren(this.domNode);
	this.fn.innerHTML = message.name;
	this.variables.style.display = "block";
	var all = [];
	if (variables) {
		all = variables;
	}
	if (this_variables) {
		all = all.concat(this_variables);
	}
	if (child_variables) {
		all = all.concat(child_variables);
	}
	if (!all.length) {
		this.variables.style.display = "none";
	} else {
		for (var i = 0, one; one = all[i]; i++) {
			this.vLink.innerHTML = one;
			this.vDesc.parentNode.style.display = "none";
			appends.push(this.vParent.appendChild(this.vSave.cloneNode(true)));
		}
	}
	this.sParams.innerHTML = "";
	var first = true;
	for (var param in parameters) {
		var paramType = parameters[param].type;
		var paramSummary = parameters[param].summary;
		var paramName = param;
		this.parameters.style.display = "block";
		this.pLink.innerHTML = paramName;
		this.pOpt.style.display = "none";
		if (parameters[param].opt) {
			this.pOpt.style.display = "inline";
		}
		this.pType.parentNode.style.display = "none";
		if (parameters[param][0]) {
			this.pType.parentNode.style.display = "inline";
			this.pType.innerHTML = paramType;
		}
		this.pDesc.parentNode.style.display = "none";
		if (paramSummary) {
			this.pDesc.parentNode.style.display = "inline";
			this.pDesc.innerHTML = paramSummary;
		}
		appends.push(this.pParent.appendChild(this.pSave.cloneNode(true)));
		if (!first) {
			this.sParams.appendChild(document.createTextNode(", "));
		}
		first = false;
		if (paramType) {
			dojo.debug(this.sPTypeSave);
			this.sPTypeSave.innerHTML = paramType;
			this.sParams.appendChild(this.sPTypeSave.cloneNode(true));
			this.sParams.appendChild(document.createTextNode(" "));
		}
		dojo.debug(this.sPNameSave);
		this.sPNameSave.innerHTML = paramName;
		this.sParams.appendChild(this.sPNameSave.cloneNode(true));
	}
	if (message.returns) {
		this.sType.innerHTML = message.returns;
	} else {
		this.sType.innerHTML = "void";
	}
	this.sName.innerHTML = message.name;
	this.domNode.appendChild(this.navSave);
	this.domNode.appendChild(this.detailSave.cloneNode(true));
	for (var i = 0, append; append = appends[i]; i++) {
		dojo.html.removeNode(append);
	}
}, onPkgResult:function (results) {
	if (this.pkgEditor) {
		this.pkgEditor.close(true);
		dojo.debug(this.pkgDescription);
	}
	var methods = results.methods;
	var requires = results.requires;
	var description = results.description;
	this._pkgPath = results.path;
	var requireLinks = [];
	var appends = this._appends;
	while (appends.length) {
		dojo.html.removeNode(appends.shift());
	}
	dojo.html.removeChildren(this.domNode);
	this.pkg.innerHTML = results.pkg;
	var hasRequires = false;
	for (var env in requires) {
		hasRequires = true;
		this.rH3.style.display = "none";
		if (env != "common") {
			this.rH3.style.display = "";
			this.rH3.innerHTML = env;
		}
		for (var i = 0, require; require = requires[env][i]; i++) {
			requireLinks.push({name:require});
			this.rLink.innerHTML = require;
			this.rLink.href = "#" + require;
			var rRow2 = this.rRow2.parentNode.insertBefore(this.rRow2.cloneNode(true), this.rRow2);
			rRow2.style.display = "";
			appends.push(rRow2);
		}
		var rRow = this.rRow.parentNode.insertBefore(this.rRow.cloneNode(true), this.rRow);
		rRow.style.display = "";
		appends.push(rRow);
	}
	if (hasRequires) {
		appends.push(this.packageSave.appendChild(this.requires.cloneNode(true)));
	}
	if (results.size) {
		for (var i = 0, method; method = methods[i]; i++) {
			this.mLink.innerHTML = method.name;
			this.mLink.href = "#" + method.name;
			this.mDesc.parentNode.style.display = "none";
			if (method.summary) {
				this.mDesc.parentNode.style.display = "inline";
				this.mDesc.innerHTML = method.summary;
			}
			var mRow = this.mRow.parentNode.insertBefore(this.mRow.cloneNode(true), this.mRow);
			mRow.style.display = "";
			appends.push(mRow);
		}
		appends.push(this.packageSave.appendChild(this.methods.cloneNode(true)));
	}
	this.domNode.appendChild(this.packageSave);
	this.pkgDescription.innerHTML = description;
	function makeSelect(fOrP, x) {
		return function (e) {
			dojo.event.topic.publish("/docs/" + fOrP + "/select", x);
		};
	}
	var as = this.domNode.getElementsByTagName("a");
	for (var i = 0, a; a = as[i]; i++) {
		if (a.className == "docMLink") {
			dojo.event.connect(a, "onclick", makeSelect("function", methods[i]));
		} else {
			if (a.className == "docRLink") {
				dojo.event.connect(a, "onclick", makeSelect("package", requireLinks[i]));
			}
		}
	}
}, onDocResults:function (fns) {
	dojo.debug("onDocResults(): called");
	if (fns.length == 1) {
		dojo.event.topic.publish("/docs/function/select", fns[0]);
		return;
	}
	dojo.html.removeChildren(this.domNode);
	this.count.innerHTML = fns.length;
	var appends = [];
	for (var i = 0, fn; fn = fns[i]; i++) {
		this.fnLink.innerHTML = fn.name;
		this.fnLink.href = "#" + fn.name;
		if (fn.id) {
			this.fnLink.href = this.fnLink.href + "," + fn.id;
		}
		this.summary.parentNode.style.display = "none";
		if (fn.summary) {
			this.summary.parentNode.style.display = "inline";
			this.summary.innerHTML = fn.summary;
		}
		appends.push(this.rowParent.appendChild(this.rowSave.cloneNode(true)));
	}
	function makeSelect(x) {
		return function (e) {
			dojo.event.topic.publish("/docs/function/select", x);
		};
	}
	this.domNode.appendChild(this.resultSave.cloneNode(true));
	var as = this.domNode.getElementsByTagName("a");
	for (var i = 0, a; a = as[i]; i++) {
		dojo.event.connect(a, "onclick", makeSelect(fns[i]));
	}
	for (var i = 0, append; append = appends[i]; i++) {
		this.rowParent.removeChild(append);
	}
}});


__CPAN_FILE__ src/widget/Editor2Toolbar.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.widget.Editor2Toolbar");
dojo.require("dojo.lang.*");
dojo.require("dojo.widget.*");
dojo.require("dojo.event.*");
dojo.require("dojo.html.layout");
dojo.require("dojo.html.display");
dojo.require("dojo.widget.RichText");
dojo.require("dojo.widget.PopupContainer");
dojo.require("dojo.widget.ColorPalette");
dojo.lang.declare("dojo.widget.HandlerManager", null, function () {
	this._registeredHandlers = [];
}, {registerHandler:function (obj, func) {
	if (arguments.length == 2) {
		this._registeredHandlers.push(function () {
			return obj[func].apply(obj, arguments);
		});
	} else {
		this._registeredHandlers.push(obj);
	}
}, removeHandler:function (func) {
	for (var i = 0; i < this._registeredHandlers.length; i++) {
		if (func === this._registeredHandlers[i]) {
			delete this._registeredHandlers[i];
			return;
		}
	}
	dojo.debug("HandlerManager handler " + func + " is not registered, can not remove.");
}, destroy:function () {
	for (var i = 0; i < this._registeredHandlers.length; i++) {
		delete this._registeredHandlers[i];
	}
}});
dojo.widget.Editor2ToolbarItemManager = new dojo.widget.HandlerManager;
dojo.lang.mixin(dojo.widget.Editor2ToolbarItemManager, {getToolbarItem:function (name) {
	var item;
	name = name.toLowerCase();
	for (var i = 0; i < this._registeredHandlers.length; i++) {
		item = this._registeredHandlers[i](name);
		if (item) {
			return item;
		}
	}
	switch (name) {
	  case "bold":
	  case "copy":
	  case "cut":
	  case "delete":
	  case "indent":
	  case "inserthorizontalrule":
	  case "insertorderedlist":
	  case "insertunorderedlist":
	  case "italic":
	  case "justifycenter":
	  case "justifyfull":
	  case "justifyleft":
	  case "justifyright":
	  case "outdent":
	  case "paste":
	  case "redo":
	  case "removeformat":
	  case "selectall":
	  case "strikethrough":
	  case "subscript":
	  case "superscript":
	  case "underline":
	  case "undo":
	  case "unlink":
	  case "createlink":
	  case "insertimage":
	  case "htmltoggle":
		item = new dojo.widget.Editor2ToolbarButton(name);
		break;
	  case "forecolor":
	  case "hilitecolor":
		item = new dojo.widget.Editor2ToolbarColorPaletteButton(name);
		break;
	  case "plainformatblock":
		item = new dojo.widget.Editor2ToolbarFormatBlockPlainSelect("formatblock");
		break;
	  case "formatblock":
		item = new dojo.widget.Editor2ToolbarFormatBlockSelect("formatblock");
		break;
	  case "fontsize":
		item = new dojo.widget.Editor2ToolbarFontSizeSelect("fontsize");
		break;
	  case "fontname":
		item = new dojo.widget.Editor2ToolbarFontNameSelect("fontname");
		break;
	  case "inserttable":
	  case "insertcell":
	  case "insertcol":
	  case "insertrow":
	  case "deletecells":
	  case "deletecols":
	  case "deleterows":
	  case "mergecells":
	  case "splitcell":
		dojo.debug(name + " is implemented in dojo.widget.Editor2Plugin.TableOperation, please require it first.");
		break;
	  case "inserthtml":
	  case "blockdirltr":
	  case "blockdirrtl":
	  case "dirltr":
	  case "dirrtl":
	  case "inlinedirltr":
	  case "inlinedirrtl":
		dojo.debug("Not yet implemented toolbar item: " + name);
		break;
	  default:
		dojo.debug("dojo.widget.Editor2ToolbarItemManager.getToolbarItem: Unknown toolbar item: " + name);
	}
	return item;
}});
dojo.addOnUnload(dojo.widget.Editor2ToolbarItemManager, "destroy");
dojo.declare("dojo.widget.Editor2ToolbarButton", null, function (name) {
	this._name = name;
}, {create:function (node, toolbar, nohover) {
	this._domNode = node;
	var cmd = toolbar.parent.getCommand(this._name);
	if (cmd) {
		this._domNode.title = cmd.getText();
	}
	this.disableSelection(this._domNode);
	this._parentToolbar = toolbar;
	dojo.event.connect(this._domNode, "onclick", this, "onClick");
	if (!nohover) {
		dojo.event.connect(this._domNode, "onmouseover", this, "onMouseOver");
		dojo.event.connect(this._domNode, "onmouseout", this, "onMouseOut");
	}
}, disableSelection:function (rootnode) {
	dojo.html.disableSelection(rootnode);
	var nodes = rootnode.all || rootnode.getElementsByTagName("*");
	for (var x = 0; x < nodes.length; x++) {
		dojo.html.disableSelection(nodes[x]);
	}
}, onMouseOver:function () {
	var curInst = dojo.widget.Editor2Manager.getCurrentInstance();
	if (curInst) {
		var _command = curInst.getCommand(this._name);
		if (_command && _command.getState() != dojo.widget.Editor2Manager.commandState.Disabled) {
			this.highlightToolbarItem();
		}
	}
}, onMouseOut:function () {
	this.unhighlightToolbarItem();
}, destroy:function () {
	this._domNode = null;
	this._parentToolbar = null;
}, onClick:function (e) {
	if (this._domNode && !this._domNode.disabled && this._parentToolbar.checkAvailability()) {
		e.preventDefault();
		e.stopPropagation();
		var curInst = dojo.widget.Editor2Manager.getCurrentInstance();
		if (curInst) {
			var _command = curInst.getCommand(this._name);
			if (_command) {
				_command.execute();
			}
		}
	}
}, refreshState:function () {
	var curInst = dojo.widget.Editor2Manager.getCurrentInstance();
	var em = dojo.widget.Editor2Manager;
	if (curInst) {
		var _command = curInst.getCommand(this._name);
		if (_command) {
			var state = _command.getState();
			if (state != this._lastState) {
				switch (state) {
				  case em.commandState.Latched:
					this.latchToolbarItem();
					break;
				  case em.commandState.Enabled:
					this.enableToolbarItem();
					break;
				  case em.commandState.Disabled:
				  default:
					this.disableToolbarItem();
				}
				this._lastState = state;
			}
		}
	}
	return em.commandState.Enabled;
}, latchToolbarItem:function () {
	this._domNode.disabled = false;
	this.removeToolbarItemStyle(this._domNode);
	dojo.html.addClass(this._domNode, this._parentToolbar.ToolbarLatchedItemStyle);
}, enableToolbarItem:function () {
	this._domNode.disabled = false;
	this.removeToolbarItemStyle(this._domNode);
	dojo.html.addClass(this._domNode, this._parentToolbar.ToolbarEnabledItemStyle);
}, disableToolbarItem:function () {
	this._domNode.disabled = true;
	this.removeToolbarItemStyle(this._domNode);
	dojo.html.addClass(this._domNode, this._parentToolbar.ToolbarDisabledItemStyle);
}, highlightToolbarItem:function () {
	dojo.html.addClass(this._domNode, this._parentToolbar.ToolbarHighlightedItemStyle);
}, unhighlightToolbarItem:function () {
	dojo.html.removeClass(this._domNode, this._parentToolbar.ToolbarHighlightedItemStyle);
}, removeToolbarItemStyle:function () {
	dojo.html.removeClass(this._domNode, this._parentToolbar.ToolbarEnabledItemStyle);
	dojo.html.removeClass(this._domNode, this._parentToolbar.ToolbarLatchedItemStyle);
	dojo.html.removeClass(this._domNode, this._parentToolbar.ToolbarDisabledItemStyle);
	this.unhighlightToolbarItem();
}});
dojo.declare("dojo.widget.Editor2ToolbarDropDownButton", dojo.widget.Editor2ToolbarButton, {onClick:function () {
	if (this._domNode && !this._domNode.disabled && this._parentToolbar.checkAvailability()) {
		if (!this._dropdown) {
			this._dropdown = dojo.widget.createWidget("PopupContainer", {});
			this._domNode.appendChild(this._dropdown.domNode);
		}
		if (this._dropdown.isShowingNow) {
			this._dropdown.close();
		} else {
			this.onDropDownShown();
			this._dropdown.open(this._domNode, null, this._domNode);
		}
	}
}, destroy:function () {
	this.onDropDownDestroy();
	if (this._dropdown) {
		this._dropdown.destroy();
	}
	dojo.widget.Editor2ToolbarDropDownButton.superclass.destroy.call(this);
}, onDropDownShown:function () {
}, onDropDownDestroy:function () {
}});
dojo.declare("dojo.widget.Editor2ToolbarColorPaletteButton", dojo.widget.Editor2ToolbarDropDownButton, {onDropDownShown:function () {
	if (!this._colorpalette) {
		this._colorpalette = dojo.widget.createWidget("ColorPalette", {});
		this._dropdown.addChild(this._colorpalette);
		this.disableSelection(this._dropdown.domNode);
		this.disableSelection(this._colorpalette.domNode);
		dojo.event.connect(this._colorpalette, "onColorSelect", this, "setColor");
		dojo.event.connect(this._dropdown, "open", this, "latchToolbarItem");
		dojo.event.connect(this._dropdown, "close", this, "enableToolbarItem");
	}
}, setColor:function (color) {
	this._dropdown.close();
	var curInst = dojo.widget.Editor2Manager.getCurrentInstance();
	if (curInst) {
		var _command = curInst.getCommand(this._name);
		if (_command) {
			_command.execute(color);
		}
	}
}});
dojo.declare("dojo.widget.Editor2ToolbarFormatBlockPlainSelect", dojo.widget.Editor2ToolbarButton, {create:function (node, toolbar) {
	this._domNode = node;
	this._parentToolbar = toolbar;
	this._domNode = node;
	this.disableSelection(this._domNode);
	dojo.event.connect(this._domNode, "onchange", this, "onChange");
}, destroy:function () {
	this._domNode = null;
}, onChange:function () {
	if (this._parentToolbar.checkAvailability()) {
		var sv = this._domNode.value.toLowerCase();
		var curInst = dojo.widget.Editor2Manager.getCurrentInstance();
		if (curInst) {
			var _command = curInst.getCommand(this._name);
			if (_command) {
				_command.execute(sv);
			}
		}
	}
}, refreshState:function () {
	if (this._domNode) {
		dojo.widget.Editor2ToolbarFormatBlockPlainSelect.superclass.refreshState.call(this);
		var curInst = dojo.widget.Editor2Manager.getCurrentInstance();
		if (curInst) {
			var _command = curInst.getCommand(this._name);
			if (_command) {
				var format = _command.getValue();
				if (!format) {
					format = "";
				}
				dojo.lang.forEach(this._domNode.options, function (item) {
					if (item.value.toLowerCase() == format.toLowerCase()) {
						item.selected = true;
					}
				});
			}
		}
	}
}});
dojo.declare("dojo.widget.Editor2ToolbarComboItem", dojo.widget.Editor2ToolbarDropDownButton, {href:null, create:function (node, toolbar) {
	dojo.widget.Editor2ToolbarComboItem.superclass.create.apply(this, arguments);
	if (!this._contentPane) {
		dojo.require("dojo.widget.ContentPane");
		this._contentPane = dojo.widget.createWidget("ContentPane", {preload:"true"});
		this._contentPane.addOnLoad(this, "setup");
		this._contentPane.setUrl(this.href);
	}
}, onMouseOver:function (e) {
	if (this._lastState != dojo.widget.Editor2Manager.commandState.Disabled) {
		dojo.html.addClass(e.currentTarget, this._parentToolbar.ToolbarHighlightedSelectStyle);
	}
}, onMouseOut:function (e) {
	dojo.html.removeClass(e.currentTarget, this._parentToolbar.ToolbarHighlightedSelectStyle);
}, onDropDownShown:function () {
	if (!this._dropdown.__addedContentPage) {
		this._dropdown.addChild(this._contentPane);
		this._dropdown.__addedContentPage = true;
	}
}, setup:function () {
}, onChange:function (e) {
	if (this._parentToolbar.checkAvailability()) {
		var name = e.currentTarget.getAttribute("dropDownItemName");
		var curInst = dojo.widget.Editor2Manager.getCurrentInstance();
		if (curInst) {
			var _command = curInst.getCommand(this._name);
			if (_command) {
				_command.execute(name);
			}
		}
	}
	this._dropdown.close();
}, onMouseOverItem:function (e) {
	dojo.html.addClass(e.currentTarget, this._parentToolbar.ToolbarHighlightedSelectItemStyle);
}, onMouseOutItem:function (e) {
	dojo.html.removeClass(e.currentTarget, this._parentToolbar.ToolbarHighlightedSelectItemStyle);
}});
dojo.declare("dojo.widget.Editor2ToolbarFormatBlockSelect", dojo.widget.Editor2ToolbarComboItem, {href:dojo.uri.moduleUri("dojo.widget", "templates/Editor2/EditorToolbar_FormatBlock.html"), setup:function () {
	dojo.widget.Editor2ToolbarFormatBlockSelect.superclass.setup.call(this);
	var nodes = this._contentPane.domNode.all || this._contentPane.domNode.getElementsByTagName("*");
	this._blockNames = {};
	this._blockDisplayNames = {};
	for (var x = 0; x < nodes.length; x++) {
		var node = nodes[x];
		dojo.html.disableSelection(node);
		var name = node.getAttribute("dropDownItemName");
		if (name) {
			this._blockNames[name] = node;
			var childrennodes = node.getElementsByTagName(name);
			this._blockDisplayNames[name] = childrennodes[childrennodes.length - 1].innerHTML;
		}
	}
	for (var name in this._blockNames) {
		dojo.event.connect(this._blockNames[name], "onclick", this, "onChange");
		dojo.event.connect(this._blockNames[name], "onmouseover", this, "onMouseOverItem");
		dojo.event.connect(this._blockNames[name], "onmouseout", this, "onMouseOutItem");
	}
}, onDropDownDestroy:function () {
	if (this._blockNames) {
		for (var name in this._blockNames) {
			delete this._blockNames[name];
			delete this._blockDisplayNames[name];
		}
	}
}, refreshState:function () {
	dojo.widget.Editor2ToolbarFormatBlockSelect.superclass.refreshState.call(this);
	if (this._lastState != dojo.widget.Editor2Manager.commandState.Disabled) {
		var curInst = dojo.widget.Editor2Manager.getCurrentInstance();
		if (curInst) {
			var _command = curInst.getCommand(this._name);
			if (_command) {
				var format = _command.getValue();
				if (format == this._lastSelectedFormat && this._blockDisplayNames) {
					return this._lastState;
				}
				this._lastSelectedFormat = format;
				var label = this._domNode.getElementsByTagName("label")[0];
				var isSet = false;
				if (this._blockDisplayNames) {
					for (var name in this._blockDisplayNames) {
						if (name == format) {
							label.innerHTML = this._blockDisplayNames[name];
							isSet = true;
							break;
						}
					}
					if (!isSet) {
						label.innerHTML = "&nbsp;";
					}
				}
			}
		}
	}
	return this._lastState;
}});
dojo.declare("dojo.widget.Editor2ToolbarFontSizeSelect", dojo.widget.Editor2ToolbarComboItem, {href:dojo.uri.moduleUri("dojo.widget", "templates/Editor2/EditorToolbar_FontSize.html"), setup:function () {
	dojo.widget.Editor2ToolbarFormatBlockSelect.superclass.setup.call(this);
	var nodes = this._contentPane.domNode.all || this._contentPane.domNode.getElementsByTagName("*");
	this._fontsizes = {};
	this._fontSizeDisplayNames = {};
	for (var x = 0; x < nodes.length; x++) {
		var node = nodes[x];
		dojo.html.disableSelection(node);
		var name = node.getAttribute("dropDownItemName");
		if (name) {
			this._fontsizes[name] = node;
			this._fontSizeDisplayNames[name] = node.getElementsByTagName("font")[0].innerHTML;
		}
	}
	for (var name in this._fontsizes) {
		dojo.event.connect(this._fontsizes[name], "onclick", this, "onChange");
		dojo.event.connect(this._fontsizes[name], "onmouseover", this, "onMouseOverItem");
		dojo.event.connect(this._fontsizes[name], "onmouseout", this, "onMouseOutItem");
	}
}, onDropDownDestroy:function () {
	if (this._fontsizes) {
		for (var name in this._fontsizes) {
			delete this._fontsizes[name];
			delete this._fontSizeDisplayNames[name];
		}
	}
}, refreshState:function () {
	dojo.widget.Editor2ToolbarFormatBlockSelect.superclass.refreshState.call(this);
	if (this._lastState != dojo.widget.Editor2Manager.commandState.Disabled) {
		var curInst = dojo.widget.Editor2Manager.getCurrentInstance();
		if (curInst) {
			var _command = curInst.getCommand(this._name);
			if (_command) {
				var size = _command.getValue();
				if (size == this._lastSelectedSize && this._fontSizeDisplayNames) {
					return this._lastState;
				}
				this._lastSelectedSize = size;
				var label = this._domNode.getElementsByTagName("label")[0];
				var isSet = false;
				if (this._fontSizeDisplayNames) {
					for (var name in this._fontSizeDisplayNames) {
						if (name == size) {
							label.innerHTML = this._fontSizeDisplayNames[name];
							isSet = true;
							break;
						}
					}
					if (!isSet) {
						label.innerHTML = "&nbsp;";
					}
				}
			}
		}
	}
	return this._lastState;
}});
dojo.declare("dojo.widget.Editor2ToolbarFontNameSelect", dojo.widget.Editor2ToolbarFontSizeSelect, {href:dojo.uri.moduleUri("dojo.widget", "templates/Editor2/EditorToolbar_FontName.html")});
dojo.widget.defineWidget("dojo.widget.Editor2Toolbar", dojo.widget.HtmlWidget, function () {
	dojo.event.connect(this, "fillInTemplate", dojo.lang.hitch(this, function () {
		if (dojo.render.html.ie) {
			this.domNode.style.zoom = 1;
		}
	}));
}, {templateString:"<div dojoAttachPoint=\"domNode\" class=\"EditorToolbarDomNode\" unselectable=\"on\">\n\t<table cellpadding=\"3\" cellspacing=\"0\" border=\"0\">\n\t\t<!--\n\t\t\tour toolbar should look something like:\n\n\t\t\t+=======+=======+=======+=============================================+\n\t\t\t| w   w | style | copy  | bo | it | un | le | ce | ri |\n\t\t\t| w w w | style |=======|==============|==============|\n\t\t\t|  w w  | style | paste |  undo | redo | change style |\n\t\t\t+=======+=======+=======+=============================================+\n\t\t-->\n\t\t<tbody>\n\t\t\t<tr valign=\"top\">\n\t\t\t\t<td rowspan=\"2\">\n\t\t\t\t\t<div class=\"bigIcon\" dojoAttachPoint=\"wikiWordButton\"\n\t\t\t\t\t\tdojoOnClick=\"wikiWordClick; buttonClick;\">\n\t\t\t\t\t\t<span style=\"font-size: 30px; margin-left: 5px;\">\n\t\t\t\t\t\t\tW\n\t\t\t\t\t\t</span>\n\t\t\t\t\t</div>\n\t\t\t\t</td>\n\t\t\t\t<td rowspan=\"2\">\n\t\t\t\t\t<div class=\"bigIcon\" dojoAttachPoint=\"styleDropdownButton\"\n\t\t\t\t\t\tdojoOnClick=\"styleDropdownClick; buttonClick;\">\n\t\t\t\t\t\t<span unselectable=\"on\"\n\t\t\t\t\t\t\tstyle=\"font-size: 30px; margin-left: 5px;\">\n\t\t\t\t\t\t\tS\n\t\t\t\t\t\t</span>\n\t\t\t\t\t</div>\n\t\t\t\t\t<div class=\"StyleDropdownContainer\" style=\"display: none;\"\n\t\t\t\t\t\tdojoAttachPoint=\"styleDropdownContainer\">\n\t\t\t\t\t\t<table cellpadding=\"0\" cellspacing=\"0\" border=\"0\"\n\t\t\t\t\t\t\theight=\"100%\" width=\"100%\">\n\t\t\t\t\t\t\t<tr valign=\"top\">\n\t\t\t\t\t\t\t\t<td rowspan=\"2\">\n\t\t\t\t\t\t\t\t\t<div style=\"height: 245px; overflow: auto;\">\n\t\t\t\t\t\t\t\t\t\t<div class=\"headingContainer\"\n\t\t\t\t\t\t\t\t\t\t\tunselectable=\"on\"\n\t\t\t\t\t\t\t\t\t\t\tdojoOnClick=\"normalTextClick\">normal</div>\n\t\t\t\t\t\t\t\t\t\t<h1 class=\"headingContainer\"\n\t\t\t\t\t\t\t\t\t\t\tunselectable=\"on\"\n\t\t\t\t\t\t\t\t\t\t\tdojoOnClick=\"h1TextClick\">Heading 1</h1>\n\t\t\t\t\t\t\t\t\t\t<h2 class=\"headingContainer\"\n\t\t\t\t\t\t\t\t\t\t\tunselectable=\"on\"\n\t\t\t\t\t\t\t\t\t\t\tdojoOnClick=\"h2TextClick\">Heading 2</h2>\n\t\t\t\t\t\t\t\t\t\t<h3 class=\"headingContainer\"\n\t\t\t\t\t\t\t\t\t\t\tunselectable=\"on\"\n\t\t\t\t\t\t\t\t\t\t\tdojoOnClick=\"h3TextClick\">Heading 3</h3>\n\t\t\t\t\t\t\t\t\t\t<h4 class=\"headingContainer\"\n\t\t\t\t\t\t\t\t\t\t\tunselectable=\"on\"\n\t\t\t\t\t\t\t\t\t\t\tdojoOnClick=\"h4TextClick\">Heading 4</h4>\n\t\t\t\t\t\t\t\t\t\t<div class=\"headingContainer\"\n\t\t\t\t\t\t\t\t\t\t\tunselectable=\"on\"\n\t\t\t\t\t\t\t\t\t\t\tdojoOnClick=\"blahTextClick\">blah</div>\n\t\t\t\t\t\t\t\t\t\t<div class=\"headingContainer\"\n\t\t\t\t\t\t\t\t\t\t\tunselectable=\"on\"\n\t\t\t\t\t\t\t\t\t\t\tdojoOnClick=\"blahTextClick\">blah</div>\n\t\t\t\t\t\t\t\t\t\t<div class=\"headingContainer\"\n\t\t\t\t\t\t\t\t\t\t\tunselectable=\"on\"\n\t\t\t\t\t\t\t\t\t\t\tdojoOnClick=\"blahTextClick\">blah</div>\n\t\t\t\t\t\t\t\t\t\t<div class=\"headingContainer\">blah</div>\n\t\t\t\t\t\t\t\t\t\t<div class=\"headingContainer\">blah</div>\n\t\t\t\t\t\t\t\t\t\t<div class=\"headingContainer\">blah</div>\n\t\t\t\t\t\t\t\t\t\t<div class=\"headingContainer\">blah</div>\n\t\t\t\t\t\t\t\t\t</div>\n\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t\t<!--\n\t\t\t\t\t\t\t\t<td>\n\t\t\t\t\t\t\t\t\t<span class=\"iconContainer\" dojoOnClick=\"buttonClick;\">\n\t\t\t\t\t\t\t\t\t\t<span class=\"icon justifyleft\" \n\t\t\t\t\t\t\t\t\t\t\tstyle=\"float: left;\">&nbsp;</span>\n\t\t\t\t\t\t\t\t\t</span>\n\t\t\t\t\t\t\t\t\t<span class=\"iconContainer\" dojoOnClick=\"buttonClick;\">\n\t\t\t\t\t\t\t\t\t\t<span class=\"icon justifycenter\" \n\t\t\t\t\t\t\t\t\t\t\tstyle=\"float: left;\">&nbsp;</span>\n\t\t\t\t\t\t\t\t\t</span>\n\t\t\t\t\t\t\t\t\t<span class=\"iconContainer\" dojoOnClick=\"buttonClick;\">\n\t\t\t\t\t\t\t\t\t\t<span class=\"icon justifyright\" \n\t\t\t\t\t\t\t\t\t\t\tstyle=\"float: left;\">&nbsp;</span>\n\t\t\t\t\t\t\t\t\t</span>\n\t\t\t\t\t\t\t\t\t<span class=\"iconContainer\" dojoOnClick=\"buttonClick;\">\n\t\t\t\t\t\t\t\t\t\t<span class=\"icon justifyfull\" \n\t\t\t\t\t\t\t\t\t\t\tstyle=\"float: left;\">&nbsp;</span>\n\t\t\t\t\t\t\t\t\t</span>\n\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t\t-->\n\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t<tr valign=\"top\">\n\t\t\t\t\t\t\t\t<td>\n\t\t\t\t\t\t\t\t\tthud\n\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t</table>\n\t\t\t\t\t</div>\n\t\t\t\t</td>\n\t\t\t\t<td>\n\t\t\t\t\t<!-- copy -->\n\t\t\t\t\t<span class=\"iconContainer\" dojoAttachPoint=\"copyButton\"\n\t\t\t\t\t\tunselectable=\"on\"\n\t\t\t\t\t\tdojoOnClick=\"copyClick; buttonClick;\">\n\t\t\t\t\t\t<span class=\"icon copy\" \n\t\t\t\t\t\t\tunselectable=\"on\"\n\t\t\t\t\t\t\tstyle=\"float: left;\">&nbsp;</span> copy\n\t\t\t\t\t</span>\n\t\t\t\t\t<!-- \"droppable\" options -->\n\t\t\t\t\t<span class=\"iconContainer\" dojoAttachPoint=\"boldButton\"\n\t\t\t\t\t\tunselectable=\"on\"\n\t\t\t\t\t\tdojoOnClick=\"boldClick; buttonClick;\">\n\t\t\t\t\t\t<span class=\"icon bold\" unselectable=\"on\">&nbsp;</span>\n\t\t\t\t\t</span>\n\t\t\t\t\t<span class=\"iconContainer\" dojoAttachPoint=\"italicButton\"\n\t\t\t\t\t\tdojoOnClick=\"italicClick; buttonClick;\">\n\t\t\t\t\t\t<span class=\"icon italic\" unselectable=\"on\">&nbsp;</span>\n\t\t\t\t\t</span>\n\t\t\t\t\t<span class=\"iconContainer\" dojoAttachPoint=\"underlineButton\"\n\t\t\t\t\t\tdojoOnClick=\"underlineClick; buttonClick;\">\n\t\t\t\t\t\t<span class=\"icon underline\" unselectable=\"on\">&nbsp;</span>\n\t\t\t\t\t</span>\n\t\t\t\t\t<span class=\"iconContainer\" dojoAttachPoint=\"leftButton\"\n\t\t\t\t\t\tdojoOnClick=\"leftClick; buttonClick;\">\n\t\t\t\t\t\t<span class=\"icon justifyleft\" unselectable=\"on\">&nbsp;</span>\n\t\t\t\t\t</span>\n\t\t\t\t\t<span class=\"iconContainer\" dojoAttachPoint=\"fullButton\"\n\t\t\t\t\t\tdojoOnClick=\"fullClick; buttonClick;\">\n\t\t\t\t\t\t<span class=\"icon justifyfull\" unselectable=\"on\">&nbsp;</span>\n\t\t\t\t\t</span>\n\t\t\t\t\t<span class=\"iconContainer\" dojoAttachPoint=\"rightButton\"\n\t\t\t\t\t\tdojoOnClick=\"rightClick; buttonClick;\">\n\t\t\t\t\t\t<span class=\"icon justifyright\" unselectable=\"on\">&nbsp;</span>\n\t\t\t\t\t</span>\n\t\t\t\t</td>\n\t\t\t</tr>\n\t\t\t<tr>\n\t\t\t\t<td>\n\t\t\t\t\t<!-- paste -->\n\t\t\t\t\t<span class=\"iconContainer\" dojoAttachPoint=\"pasteButton\"\n\t\t\t\t\t\tdojoOnClick=\"pasteClick; buttonClick;\" unselectable=\"on\">\n\t\t\t\t\t\t<span class=\"icon paste\" style=\"float: left;\" unselectable=\"on\">&nbsp;</span> paste\n\t\t\t\t\t</span>\n\t\t\t\t\t<!-- \"droppable\" options -->\n\t\t\t\t\t<span class=\"iconContainer\" dojoAttachPoint=\"undoButton\"\n\t\t\t\t\t\tdojoOnClick=\"undoClick; buttonClick;\" unselectable=\"on\">\n\t\t\t\t\t\t<span class=\"icon undo\" style=\"float: left;\" unselectable=\"on\">&nbsp;</span> undo\n\t\t\t\t\t</span>\n\t\t\t\t\t<span class=\"iconContainer\" dojoAttachPoint=\"redoButton\"\n\t\t\t\t\t\tdojoOnClick=\"redoClick; buttonClick;\" unselectable=\"on\">\n\t\t\t\t\t\t<span class=\"icon redo\" style=\"float: left;\" unselectable=\"on\">&nbsp;</span> redo\n\t\t\t\t\t</span>\n\t\t\t\t</td>\t\n\t\t\t</tr>\n\t\t</tbody>\n\t</table>\n</div>\n", templateCssString:".StyleDropdownContainer {\n\tposition: absolute;\n\tz-index: 1000;\n\toverflow: auto;\n\tcursor: default;\n\twidth: 250px;\n\theight: 250px;\n\tbackground-color: white;\n\tborder: 1px solid black;\n}\n\n.ColorDropdownContainer {\n\tposition: absolute;\n\tz-index: 1000;\n\toverflow: auto;\n\tcursor: default;\n\twidth: 250px;\n\theight: 150px;\n\tbackground-color: white;\n\tborder: 1px solid black;\n}\n\n.EditorToolbarDomNode {\n\tbackground-image: url(buttons/bg-fade.png);\n\tbackground-repeat: repeat-x;\n\tbackground-position: 0px -50px;\n}\n\n.EditorToolbarSmallBg {\n\tbackground-image: url(images/toolbar-bg.gif);\n\tbackground-repeat: repeat-x;\n\tbackground-position: 0px 0px;\n}\n\n/*\nbody {\n\tbackground:url(images/blank.gif) fixed;\n}*/\n\n.IEFixedToolbar {\n\tposition:absolute;\n\t/* top:0; */\n\ttop: expression(eval((document.documentElement||document.body).scrollTop));\n}\n\ndiv.bigIcon {\n\twidth: 40px;\n\theight: 40px; \n\t/* background-color: white; */\n\t/* border: 1px solid #a6a7a3; */\n\tfont-family: Verdana, Trebuchet, Tahoma, Arial;\n}\n\n.iconContainer {\n\tfont-family: Verdana, Trebuchet, Tahoma, Arial;\n\tfont-size: 13px;\n\tfloat: left;\n\theight: 18px;\n\tdisplay: block;\n\t/* background-color: white; */\n\tcursor: pointer;\n\tpadding: 1px 4px 1px 1px; /* almost the same as a transparent border */\n\tborder: 0px;\n}\n\n.dojoE2TBIcon {\n\tdisplay: block;\n\ttext-align: center;\n\tmin-width: 18px;\n\twidth: 18px;\n\theight: 18px;\n\t/* background-color: #a6a7a3; */\n\tbackground-repeat: no-repeat;\n\tbackground-image: url(buttons/aggregate.gif);\n}\n\n\n.dojoE2TBIcon[class~=dojoE2TBIcon] {\n}\n\n.ToolbarButtonLatched {\n	border: #316ac5 1px solid; !important;\n	padding: 0px 3px 0px 0px; !important; /* make room for border */\n	background-color: #c1d2ee;\n}\n\n.ToolbarButtonHighlighted {\n	border: #316ac5 1px solid; !important;\n	padding: 0px 3px 0px 0px; !important; /* make room for border */\n	background-color: #dff1ff;\n}\n\n.ToolbarButtonDisabled{\n	filter: gray() alpha(opacity=30); /* IE */\n	opacity: 0.30; /* Safari, Opera and Mozilla */\n}\n\n.headingContainer {\n\twidth: 150px;\n\theight: 30px;\n\tmargin: 0px;\n\t/* padding-left: 5px; */\n\toverflow: hidden;\n\tline-height: 25px;\n\tborder-bottom: 1px solid black;\n\tborder-top: 1px solid white;\n}\n\n.EditorToolbarDomNode select {\n\tfont-size: 14px;\n}\n \n.dojoE2TBIcon_Sep { width: 5px; min-width: 5px; max-width: 5px; background-position: 0px 0px}\n.dojoE2TBIcon_Backcolor { background-position: -18px 0px}\n.dojoE2TBIcon_Bold { background-position: -36px 0px}\n.dojoE2TBIcon_Cancel { background-position: -54px 0px}\n.dojoE2TBIcon_Copy { background-position: -72px 0px}\n.dojoE2TBIcon_Link { background-position: -90px 0px}\n.dojoE2TBIcon_Cut { background-position: -108px 0px}\n.dojoE2TBIcon_Delete { background-position: -126px 0px}\n.dojoE2TBIcon_TextColor { background-position: -144px 0px}\n.dojoE2TBIcon_BackgroundColor { background-position: -162px 0px}\n.dojoE2TBIcon_Indent { background-position: -180px 0px}\n.dojoE2TBIcon_HorizontalLine { background-position: -198px 0px}\n.dojoE2TBIcon_Image { background-position: -216px 0px}\n.dojoE2TBIcon_NumberedList { background-position: -234px 0px}\n.dojoE2TBIcon_Table { background-position: -252px 0px}\n.dojoE2TBIcon_BulletedList { background-position: -270px 0px}\n.dojoE2TBIcon_Italic { background-position: -288px 0px}\n.dojoE2TBIcon_CenterJustify { background-position: -306px 0px}\n.dojoE2TBIcon_BlockJustify { background-position: -324px 0px}\n.dojoE2TBIcon_LeftJustify { background-position: -342px 0px}\n.dojoE2TBIcon_RightJustify { background-position: -360px 0px}\n.dojoE2TBIcon_left_to_right { background-position: -378px 0px}\n.dojoE2TBIcon_list_bullet_indent { background-position: -396px 0px}\n.dojoE2TBIcon_list_bullet_outdent { background-position: -414px 0px}\n.dojoE2TBIcon_list_num_indent { background-position: -432px 0px}\n.dojoE2TBIcon_list_num_outdent { background-position: -450px 0px}\n.dojoE2TBIcon_Outdent { background-position: -468px 0px}\n.dojoE2TBIcon_Paste { background-position: -486px 0px}\n.dojoE2TBIcon_Redo { background-position: -504px 0px}\ndojoE2TBIcon_RemoveFormat { background-position: -522px 0px}\n.dojoE2TBIcon_right_to_left { background-position: -540px 0px}\n.dojoE2TBIcon_Save { background-position: -558px 0px}\n.dojoE2TBIcon_Space { background-position: -576px 0px}\n.dojoE2TBIcon_StrikeThrough { background-position: -594px 0px}\n.dojoE2TBIcon_Subscript { background-position: -612px 0px}\n.dojoE2TBIcon_Superscript { background-position: -630px 0px}\n.dojoE2TBIcon_Underline { background-position: -648px 0px}\n.dojoE2TBIcon_Undo { background-position: -666px 0px}\n.dojoE2TBIcon_WikiWord { background-position: -684px 0px}\n\n", templateCssPath:dojo.uri.moduleUri("dojo.widget", "templates/EditorToolbar.css"), ToolbarLatchedItemStyle:"ToolbarButtonLatched", ToolbarEnabledItemStyle:"ToolbarButtonEnabled", ToolbarDisabledItemStyle:"ToolbarButtonDisabled", ToolbarHighlightedItemStyle:"ToolbarButtonHighlighted", ToolbarHighlightedSelectStyle:"ToolbarSelectHighlighted", ToolbarHighlightedSelectItemStyle:"ToolbarSelectHighlightedItem", postCreate:function () {
	var nodes = dojo.html.getElementsByClass("dojoEditorToolbarItem", this.domNode);
	this.items = {};
	for (var x = 0; x < nodes.length; x++) {
		var node = nodes[x];
		var itemname = node.getAttribute("dojoETItemName");
		if (itemname) {
			var item = dojo.widget.Editor2ToolbarItemManager.getToolbarItem(itemname);
			if (item) {
				item.create(node, this);
				this.items[itemname.toLowerCase()] = item;
			} else {
				node.style.display = "none";
			}
		}
	}
}, update:function () {
	for (var cmd in this.items) {
		this.items[cmd].refreshState();
	}
}, shareGroup:"", checkAvailability:function () {
	if (!this.shareGroup) {
		this.parent.focus();
		return true;
	}
	var curInst = dojo.widget.Editor2Manager.getCurrentInstance();
	if (this.shareGroup == curInst.toolbarGroup) {
		return true;
	}
	return false;
}, destroy:function () {
	for (var it in this.items) {
		this.items[it].destroy();
		delete this.items[it];
	}
	dojo.widget.Editor2Toolbar.superclass.destroy.call(this);
}});


__CPAN_FILE__ src/widget/Slider.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.widget.Slider");
dojo.require("dojo.event.*");
dojo.require("dojo.dnd.*");
dojo.require("dojo.dnd.HtmlDragMove");
dojo.require("dojo.widget.*");
dojo.require("dojo.html.layout");
dojo.widget.defineWidget("dojo.widget.Slider", dojo.widget.HtmlWidget, {minimumX:0, minimumY:0, maximumX:10, maximumY:10, snapValuesX:0, snapValuesY:0, _snapToGrid:true, isEnableX:true, isEnableY:true, _valueSizeX:0, _valueSizeY:0, _minX:0, _minY:0, _constraintWidth:0, _constraintHeight:0, _clipLeft:0, _clipRight:0, _clipTop:0, _clipBottom:0, _clipXdelta:0, _clipYdelta:0, initialValueX:0, initialValueY:0, flipX:false, flipY:false, clickSelect:true, activeDrag:false, templateCssString:".sliderMain {\n  border: 0px !important;\n  border-spacing: 0px !important;\n  line-height: 0px !important;\n  padding: 0px !important;\n  display: -moz-inline-table !important;\n  display: inline !important;\n  -moz-user-focus: normal !important;\n}\n\n.sliderComponent {\n  border: 0px;\n  padding: 0px;\n  margin: 0px;\n}\n\n.sliderHandle { \n  top: 0px;\n  left: 0px;\n  z-index: 1000;\n  position: absolute !important;\n}\n\n.sliderOutsetButton { \n  border-style: outset;\n  border-width: 0px 1px 1px 0px;\n  border-color: black;\n}\n\n.sliderInsetButton { \n  border-style: inset;\n  border-width: 1px 0px 0px 1px;\n  border-color: black;\n}\n\n.sliderButtonY {\n  margin: 0px;\n  padding: 0px;\n  z-index: 900;\n}\n\n.sliderButtonX {\n  margin: 0px;\n  padding: 0px;\n  z-index: 900;\n}\n\n.sliderBackground { \n  z-index: 0;\n  display: block !important;\n  position: relative !important;\n}\n\n.sliderProgressBackground { \n  z-index: 800;\n  position: absolute !important;\n  clip: rect(0px,0px,0px,0px);\n}\n\n.sliderBackgroundSizeOnly { \n}\n", templateCssPath:dojo.uri.moduleUri("dojo.widget", "templates/Slider.css"), templateString:"<table _=\"weird end tag formatting is to prevent whitespace from becoming &nbsp;\" \n\tclass=\"sliderMain\" \n\tdojoAttachPoint=\"focusNode\" \n\tdojoAttachEvent=\"onmousedown:_setFocus; onkey:_handleKeyEvents; onkeyup:_buttonReleased; onmouseup:_buttonReleased; onmousewheel:_mouseWheeled;\"\n\ttabindex=\"0\" cols=3 cellpadding=0 cellspacing=0 style=\"\">\n\t<tr valign=middle align=center>\n\t\t<td class=\"sliderComponent\" colspan=3 dojoAttachPoint=topBorderNode style=\"\"\n\t\t\t><img class=\"sliderOutsetButton sliderButtonY\"\n\t\t\t\tdojoAttachPoint=topButtonNode \n\t\t\t\tdojoAttachEvent=\"onmousedown:_topButtonPressed; onmousemove:_discardEvent; ondblclick:_topButtonDoubleClicked;\"\n\t\t\t\tsrc=\"${this.topButtonSrc}\" \n\t\t\t\tstyle=\"${this.buttonStyleY}\"\n\t\t></td>\n\t</tr>\n\t<tr valign=middle align=center>\n\t\t<td class=\"sliderComponent\" dojoAttachPoint=leftBorderNode style=\"\"\n\t\t\t><img class=\"sliderOutsetButton sliderButtonX\"\n\t\t\t\tdojoAttachPoint=leftButtonNode\n\t\t\t\tdojoAttachEvent=\"onmousedown:_leftButtonPressed; onmousemove:_discardEvent; ondblclick:_leftButtonDoubleClicked;\"\n\t\t\t\tsrc=\"${this.leftButtonSrc}\" \n\t\t\t\tstyle=\"${this.buttonStyleX}\"\n\t\t></td>\n\t\t<td dojoAttachPoint=constrainingContainerNode \n\t\t\tclass=\"sliderComponent sliderBackground\"\n\t\t\tstyle=\"${this.backgroundStyle}\"\n\t\t\t><img src=\"${this.handleSrc}\" \n\t\t\t\tclass=sliderHandle\n\t\t\t\tdojoAttachPoint=sliderHandleNode\n\t\t\t\tstyle=\"${this.handleStyle}\"\n\t\t\t><img src=\"${this.progressBackgroundSrc}\"\n\t\t\t\tclass=\"sliderBackgroundSizeOnly sliderProgressBackground\"\n\t\t\t\tdojoAttachPoint=progressBackgroundNode\n\t\t\t\tstyle=\"${this.backgroundSize}\"\n\t\t\t><img src=\"${this.backgroundSrc}\" \n\t\t\t\tclass=sliderBackgroundSizeOnly\n\t\t\t\tdojoAttachPoint=sliderBackgroundNode\n\t\t\t\tstyle=\"${this.backgroundSize}\"\n\t\t></td>\n\t\t<td class=\"sliderComponent\" dojoAttachPoint=rightBorderNode style=\"\"\n\t\t\t><img class=\"sliderOutsetButton sliderButtonX\"\n\t\t\t\tdojoAttachPoint=rightButtonNode\n\t\t\t\tdojoAttachEvent=\"onmousedown:_rightButtonPressed; onmousemove:_discardEvent; ondblclick:_rightButtonDoubleClicked;\"\n\t\t\t\tsrc=\"${this.rightButtonSrc}\" \n\t\t\t\tstyle=\"${this.buttonStyleX}\"\n\t\t></td>\n\t</tr>\n\t<tr valign=middle align=center>\n\t\t<td class=\"sliderComponent\" colspan=3 dojoAttachPoint=bottomBorderNode style=\"\"\n\t\t\t><img class=\"sliderOutsetButton sliderButtonY\"\n\t\t\t\tdojoAttachPoint=bottomButtonNode \n\t\t\t\tdojoAttachEvent=\"onmousedown:_bottomButtonPressed; onmousemove:_discardEvent; ondblclick:_bottomButtonDoubleClicked;\"\n\t\t\t\tsrc=\"${this.bottomButtonSrc}\" \n\t\t\t\tstyle=\"${this.buttonStyleY}\"\n\t\t></td>\n\t</tr>\n</table>\n", _isDragInProgress:false, bottomButtonSrc:dojo.uri.moduleUri("dojo.widget", "templates/images/slider_down_arrow.png"), topButtonSrc:dojo.uri.moduleUri("dojo.widget", "templates/images/slider_up_arrow.png"), leftButtonSrc:dojo.uri.moduleUri("dojo.widget", "templates/images/slider_left_arrow.png"), rightButtonSrc:dojo.uri.moduleUri("dojo.widget", "templates/images/slider_right_arrow.png"), backgroundSrc:dojo.uri.moduleUri("dojo.widget", "templates/images/blank.gif"), progressBackgroundSrc:dojo.uri.moduleUri("dojo.widget", "templates/images/blank.gif"), backgroundSize:"width:200px;height:200px;", backgroundStyle:"", buttonStyleX:"", buttonStyleY:"", handleStyle:"", handleSrc:dojo.uri.moduleUri("dojo.widget", "templates/images/slider-button.png"), showButtons:true, _eventCount:0, _typamaticTimer:null, _typamaticFunction:null, defaultTimeout:500, timeoutChangeRate:0.9, _currentTimeout:this.defaultTimeout, _handleKeyEvents:function (evt) {
	if (!evt.key) {
		return;
	}
	if (!evt.ctrlKey && !evt.altKey) {
		switch (evt.key) {
		  case evt.KEY_LEFT_ARROW:
			dojo.event.browser.stopEvent(evt);
			this._leftButtonPressed(evt);
			return;
		  case evt.KEY_RIGHT_ARROW:
			dojo.event.browser.stopEvent(evt);
			this._rightButtonPressed(evt);
			return;
		  case evt.KEY_DOWN_ARROW:
			dojo.event.browser.stopEvent(evt);
			this._bottomButtonPressed(evt);
			return;
		  case evt.KEY_UP_ARROW:
			dojo.event.browser.stopEvent(evt);
			this._topButtonPressed(evt);
			return;
		}
	}
	this._eventCount++;
}, _pressButton:function (buttonNode) {
	buttonNode.className = buttonNode.className.replace("Outset", "Inset");
}, _releaseButton:function (buttonNode) {
	buttonNode.className = buttonNode.className.replace("Inset", "Outset");
}, _buttonPressed:function (evt, buttonNode) {
	this._setFocus();
	if (typeof evt == "object") {
		if (this._typamaticTimer != null) {
			if (this._typamaticNode == buttonNode) {
				return;
			}
			clearTimeout(this._typamaticTimer);
		}
		this._buttonReleased(null);
		this._eventCount++;
		this._typamaticTimer = null;
		this._currentTimeout = this.defaultTimeout;
		dojo.event.browser.stopEvent(evt);
	} else {
		if (evt != this._eventCount) {
			this._buttonReleased(null);
			return false;
		}
	}
	if (buttonNode == this.leftButtonNode && this.isEnableX) {
		this._snapX(dojo.html.getPixelValue(this.sliderHandleNode, "left") - this._valueSizeX);
	} else {
		if (buttonNode == this.rightButtonNode && this.isEnableX) {
			this._snapX(dojo.html.getPixelValue(this.sliderHandleNode, "left") + this._valueSizeX);
		} else {
			if (buttonNode == this.topButtonNode && this.isEnableY) {
				this._snapY(dojo.html.getPixelValue(this.sliderHandleNode, "top") - this._valueSizeY);
			} else {
				if (buttonNode == this.bottomButtonNode && this.isEnableY) {
					this._snapY(dojo.html.getPixelValue(this.sliderHandleNode, "top") + this._valueSizeY);
				} else {
					return false;
				}
			}
		}
	}
	this._pressButton(buttonNode);
	this.notifyListeners();
	this._typamaticNode = buttonNode;
	this._typamaticTimer = dojo.lang.setTimeout(this, "_buttonPressed", this._currentTimeout, this._eventCount, buttonNode);
	this._currentTimeout = Math.round(this._currentTimeout * this.timeoutChangeRate);
	return false;
}, _bottomButtonPressed:function (evt) {
	return this._buttonPressed(evt, this.bottomButtonNode);
}, _bottomButtonDoubleClicked:function (evt) {
	var rc = this._bottomButtonPressed(evt);
	dojo.lang.setTimeout(this, "_buttonReleased", 50, null);
	return rc;
}, _topButtonPressed:function (evt) {
	return this._buttonPressed(evt, this.topButtonNode);
}, _topButtonDoubleClicked:function (evt) {
	var rc = this._topButtonPressed(evt);
	dojo.lang.setTimeout(this, "_buttonReleased", 50, null);
	return rc;
}, _leftButtonPressed:function (evt) {
	return this._buttonPressed(evt, this.leftButtonNode);
}, _leftButtonDoubleClicked:function (evt) {
	var rc = this._leftButtonPressed(evt);
	dojo.lang.setTimeout(this, "_buttonReleased", 50, null);
	return rc;
}, _rightButtonPressed:function (evt) {
	return this._buttonPressed(evt, this.rightButtonNode);
}, _rightButtonDoubleClicked:function (evt) {
	var rc = this._rightButtonPressed(evt);
	dojo.lang.setTimeout(this, "_buttonReleased", 50, null);
	return rc;
}, _buttonReleased:function (evt) {
	if (typeof evt == "object" && evt != null && typeof evt.keyCode != "undefined" && evt.keyCode != null) {
		var keyCode = evt.keyCode;
		switch (keyCode) {
		  case evt.KEY_LEFT_ARROW:
		  case evt.KEY_RIGHT_ARROW:
		  case evt.KEY_DOWN_ARROW:
		  case evt.KEY_UP_ARROW:
			dojo.event.browser.stopEvent(evt);
			break;
		}
	}
	this._releaseButton(this.topButtonNode);
	this._releaseButton(this.bottomButtonNode);
	this._releaseButton(this.leftButtonNode);
	this._releaseButton(this.rightButtonNode);
	this._eventCount++;
	if (this._typamaticTimer != null) {
		clearTimeout(this._typamaticTimer);
	}
	this._typamaticTimer = null;
	this._currentTimeout = this.defaultTimeout;
}, _mouseWheeled:function (evt) {
	var scrollAmount = 0;
	if (typeof evt.wheelDelta == "number") {
		scrollAmount = evt.wheelDelta;
	} else {
		if (typeof evt.detail == "number") {
			scrollAmount = -evt.detail;
		}
	}
	if (this.isEnableY) {
		if (scrollAmount > 0) {
			this._topButtonPressed(evt);
			this._buttonReleased(evt);
		} else {
			if (scrollAmount < 0) {
				this._bottomButtonPressed(evt);
				this._buttonReleased(evt);
			}
		}
	} else {
		if (this.isEnableX) {
			if (scrollAmount > 0) {
				this._rightButtonPressed(evt);
				this._buttonReleased(evt);
			} else {
				if (scrollAmount < 0) {
					this._leftButtonPressed(evt);
					this._buttonReleased(evt);
				}
			}
		}
	}
}, _discardEvent:function (evt) {
	dojo.event.browser.stopEvent(evt);
}, _setFocus:function () {
	if (this.focusNode.focus) {
		this.focusNode.focus();
	}
}, fillInTemplate:function (args, frag) {
	var source = this.getFragNodeRef(frag);
	dojo.html.copyStyle(this.domNode, source);
	var padding = this.domNode.style.padding;
	if (dojo.lang.isString(padding) && padding != "" && padding != "0px" && padding != "0px 0px 0px 0px") {
		this.topBorderNode.style.padding = this.bottomBorderNode.style.padding = padding;
		this.topBorderNode.style.paddingBottom = "0px";
		this.bottomBorderNode.style.paddingTop = "0px";
		this.rightBorderNode.style.paddingRight = this.domNode.style.paddingRight;
		this.leftBorderNode.style.paddingLeft = this.domNode.style.paddingLeft;
		this.domNode.style.padding = "0px 0px 0px 0px";
	}
	var borderWidth = this.domNode.style.borderWidth;
	if (dojo.lang.isString(borderWidth) && borderWidth != "" && borderWidth != "0px" && borderWidth != "0px 0px 0px 0px") {
		this.topBorderNode.style.borderStyle = this.rightBorderNode.style.borderStyle = this.bottomBorderNode.style.borderStyle = this.leftBorderNode.style.borderStyle = this.domNode.style.borderStyle;
		this.topBorderNode.style.borderColor = this.rightBorderNode.style.borderColor = this.bottomBorderNode.style.borderColor = this.leftBorderNode.style.borderColor = this.domNode.style.borderColor;
		this.topBorderNode.style.borderWidth = this.bottomBorderNode.style.borderWidth = borderWidth;
		this.topBorderNode.style.borderBottomWidth = "0px";
		this.bottomBorderNode.style.borderTopWidth = "0px";
		this.rightBorderNode.style.borderRightWidth = this.domNode.style.borderRightWidth;
		this.leftBorderNode.style.borderLeftWidth = this.domNode.style.borderLeftWidth;
		this.domNode.style.borderWidth = "0px 0px 0px 0px";
	}
	this._handleMove = new dojo.widget._SliderDragMoveSource(this.sliderHandleNode);
	this._handleMove.setParent(this);
	if (this.clickSelect) {
		dojo.event.connect(this.constrainingContainerNode, "onmousedown", this, "_onClick");
	}
	if (this.isEnableX) {
		this.setValueX(!isNaN(this.initialValueX) ? this.initialValueX : (!isNaN(this.minimumX) ? this.minimumX : 0));
	}
	if (!this.isEnableX || !this.showButtons) {
		this.rightButtonNode.style.width = "1px";
		this.rightButtonNode.style.visibility = "hidden";
		this.leftButtonNode.style.width = "1px";
		this.leftButtonNode.style.visibility = "hidden";
	}
	if (this.isEnableY) {
		this.setValueY(!isNaN(this.initialValueY) ? this.initialValueY : (!isNaN(this.minimumY) ? this.minimumY : 0));
	}
	if (!this.isEnableY || !this.showButtons) {
		this.bottomButtonNode.style.width = "1px";
		this.bottomButtonNode.style.visibility = "hidden";
		this.topButtonNode.style.width = "1px";
		this.topButtonNode.style.visibility = "hidden";
	}
	if (this.focusNode.addEventListener) {
		this.focusNode.addEventListener("DOMMouseScroll", dojo.lang.hitch(this, "_mouseWheeled"), false);
	}
}, _snapX:function (x) {
	if (x < 0) {
		x = 0;
	} else {
		if (x > this._constraintWidth) {
			x = this._constraintWidth;
		} else {
			var selectedValue = Math.round(x / this._valueSizeX);
			x = Math.round(selectedValue * this._valueSizeX);
		}
	}
	this.sliderHandleNode.style.left = x + "px";
	if (this.flipX) {
		this._clipLeft = x + this._clipXdelta;
	} else {
		this._clipRight = x + this._clipXdelta;
	}
	this.progressBackgroundNode.style.clip = "rect(" + this._clipTop + "px," + this._clipRight + "px," + this._clipBottom + "px," + this._clipLeft + "px)";
}, _calc_valueSizeX:function () {
	var constrainingCtrBox = dojo.html.getContentBox(this.constrainingContainerNode);
	var sliderHandleBox = dojo.html.getContentBox(this.sliderHandleNode);
	if (isNaN(constrainingCtrBox.width) || isNaN(sliderHandleBox.width) || constrainingCtrBox.width <= 0 || sliderHandleBox.width <= 0) {
		return false;
	}
	this._constraintWidth = constrainingCtrBox.width + dojo.html.getPadding(this.constrainingContainerNode).width - sliderHandleBox.width;
	if (this.flipX) {
		this._clipLeft = this._clipRight = constrainingCtrBox.width;
	} else {
		this._clipLeft = this._clipRight = 0;
	}
	this._clipXdelta = sliderHandleBox.width >> 1;
	if (!this.isEnableY) {
		this._clipTop = 0;
		this._clipBottom = constrainingCtrBox.height;
	}
	if (this._constraintWidth <= 0) {
		return false;
	}
	if (this.snapValuesX == 0) {
		this.snapValuesX = this._constraintWidth + 1;
	}
	this._valueSizeX = this._constraintWidth / (this.snapValuesX - 1);
	return true;
}, setValueX:function (value) {
	if (0 == this._valueSizeX) {
		if (this._calc_valueSizeX() == false) {
			dojo.lang.setTimeout(this, "setValueX", 100, value);
			return;
		}
	}
	if (isNaN(value)) {
		value = 0;
	}
	if (value > this.maximumX) {
		value = this.maximumX;
	} else {
		if (value < this.minimumX) {
			value = this.minimumX;
		}
	}
	var pixelPercent = (value - this.minimumX) / (this.maximumX - this.minimumX);
	if (this.flipX) {
		pixelPercent = 1 - pixelPercent;
	}
	this._snapX(pixelPercent * this._constraintWidth);
	this.notifyListeners();
}, getValueX:function () {
	var pixelPercent = dojo.html.getPixelValue(this.sliderHandleNode, "left") / this._constraintWidth;
	if (this.flipX) {
		pixelPercent = 1 - pixelPercent;
	}
	return Math.round(pixelPercent * (this.snapValuesX - 1)) * ((this.maximumX - this.minimumX) / (this.snapValuesX - 1)) + this.minimumX;
}, _snapY:function (y) {
	if (y < 0) {
		y = 0;
	} else {
		if (y > this._constraintHeight) {
			y = this._constraintHeight;
		} else {
			var selectedValue = Math.round(y / this._valueSizeY);
			y = Math.round(selectedValue * this._valueSizeY);
		}
	}
	this.sliderHandleNode.style.top = y + "px";
	if (this.flipY) {
		this._clipTop = y + this._clipYdelta;
	} else {
		this._clipBottom = y + this._clipYdelta;
	}
	this.progressBackgroundNode.style.clip = "rect(" + this._clipTop + "px," + this._clipRight + "px," + this._clipBottom + "px," + this._clipLeft + "px)";
}, _calc_valueSizeY:function () {
	var constrainingCtrBox = dojo.html.getContentBox(this.constrainingContainerNode);
	var sliderHandleBox = dojo.html.getContentBox(this.sliderHandleNode);
	if (isNaN(constrainingCtrBox.height) || isNaN(sliderHandleBox.height) || constrainingCtrBox.height <= 0 || sliderHandleBox.height <= 0) {
		return false;
	}
	this._constraintHeight = constrainingCtrBox.height + dojo.html.getPadding(this.constrainingContainerNode).height - sliderHandleBox.height;
	if (this.flipY) {
		this._clipTop = this._clipBottom = constrainingCtrBox.height;
	} else {
		this._clipTop = this._clipBottom = 0;
	}
	this._clipYdelta = sliderHandleBox.height >> 1;
	if (!this.isEnableX) {
		this._clipLeft = 0;
		this._clipRight = constrainingCtrBox.width;
	}
	if (this._constraintHeight <= 0) {
		return false;
	}
	if (this.snapValuesY == 0) {
		this.snapValuesY = this._constraintHeight + 1;
	}
	this._valueSizeY = this._constraintHeight / (this.snapValuesY - 1);
	return true;
}, setValueY:function (value) {
	if (0 == this._valueSizeY) {
		if (this._calc_valueSizeY() == false) {
			dojo.lang.setTimeout(this, "setValueY", 100, value);
			return;
		}
	}
	if (isNaN(value)) {
		value = 0;
	}
	if (value > this.maximumY) {
		value = this.maximumY;
	} else {
		if (value < this.minimumY) {
			value = this.minimumY;
		}
	}
	var pixelPercent = (value - this.minimumY) / (this.maximumY - this.minimumY);
	if (this.flipY) {
		pixelPercent = 1 - pixelPercent;
	}
	this._snapY(pixelPercent * this._constraintHeight);
	this.notifyListeners();
}, getValueY:function () {
	var pixelPercent = dojo.html.getPixelValue(this.sliderHandleNode, "top") / this._constraintHeight;
	if (this.flipY) {
		pixelPercent = 1 - pixelPercent;
	}
	return Math.round(pixelPercent * (this.snapValuesY - 1)) * ((this.maximumY - this.minimumY) / (this.snapValuesY - 1)) + this.minimumY;
}, _onClick:function (evt) {
	if (this._isDragInProgress) {
		return;
	}
	var parent = dojo.html.getAbsolutePosition(this.constrainingContainerNode, true, dojo.html.boxSizing.MARGIN_BOX);
	var content = dojo.html.getContentBox(this._handleMove.domNode);
	if (this.isEnableX) {
		var x = evt.pageX - parent.x - (content.width >> 1);
		this._snapX(x);
	}
	if (this.isEnableY) {
		var y = evt.pageY - parent.y - (content.height >> 1);
		this._snapY(y);
	}
	this.notifyListeners();
}, notifyListeners:function () {
	this.onValueChanged(this.getValueX(), this.getValueY());
}, onValueChanged:function (x, y) {
}});
dojo.widget.defineWidget("dojo.widget.SliderHorizontal", dojo.widget.Slider, {isEnableX:true, isEnableY:false, initialValue:"", snapValues:"", minimum:"", maximum:"", buttonStyle:"", backgroundSize:"height:10px;width:200px;", backgroundSrc:dojo.uri.moduleUri("dojo.widget", "templates/images/slider-bg.gif"), flip:false, postMixInProperties:function () {
	dojo.widget.SliderHorizontal.superclass.postMixInProperties.apply(this, arguments);
	if (!isNaN(parseFloat(this.initialValue))) {
		this.initialValueX = parseFloat(this.initialValue);
	}
	if (!isNaN(parseFloat(this.minimum))) {
		this.minimumX = parseFloat(this.minimum);
	}
	if (!isNaN(parseFloat(this.maximum))) {
		this.maximumX = parseFloat(this.maximum);
	}
	if (!isNaN(parseInt(this.snapValues))) {
		this.snapValuesX = parseInt(this.snapValues);
	}
	if (dojo.lang.isString(this.buttonStyle) && this.buttonStyle != "") {
		this.buttonStyleX = this.buttonStyle;
	}
	if (dojo.lang.isBoolean(this.flip)) {
		this.flipX = this.flip;
	}
}, notifyListeners:function () {
	this.onValueChanged(this.getValueX());
}, getValue:function () {
	return this.getValueX();
}, setValue:function (value) {
	this.setValueX(value);
}, onValueChanged:function (value) {
}});
dojo.widget.defineWidget("dojo.widget.SliderVertical", dojo.widget.Slider, {isEnableX:false, isEnableY:true, initialValue:"", snapValues:"", minimum:"", maximum:"", buttonStyle:"", backgroundSize:"width:10px;height:200px;", backgroundSrc:dojo.uri.moduleUri("dojo.widget", "templates/images/slider-bg-vert.gif"), flip:false, postMixInProperties:function () {
	dojo.widget.SliderVertical.superclass.postMixInProperties.apply(this, arguments);
	if (!isNaN(parseFloat(this.initialValue))) {
		this.initialValueY = parseFloat(this.initialValue);
	}
	if (!isNaN(parseFloat(this.minimum))) {
		this.minimumY = parseFloat(this.minimum);
	}
	if (!isNaN(parseFloat(this.maximum))) {
		this.maximumY = parseFloat(this.maximum);
	}
	if (!isNaN(parseInt(this.snapValues))) {
		this.snapValuesY = parseInt(this.snapValues);
	}
	if (dojo.lang.isString(this.buttonStyle) && this.buttonStyle != "") {
		this.buttonStyleY = this.buttonStyle;
	}
	if (dojo.lang.isBoolean(this.flip)) {
		this.flipY = this.flip;
	}
}, notifyListeners:function () {
	this.onValueChanged(this.getValueY());
}, getValue:function () {
	return this.getValueY();
}, setValue:function (value) {
	this.setValueY(value);
}, onValueChanged:function (value) {
}});
dojo.declare("dojo.widget._SliderDragMoveSource", dojo.dnd.HtmlDragMoveSource, {slider:null, onDragStart:function (evt) {
	this.slider._isDragInProgress = true;
	var dragObj = this.createDragMoveObject();
	this.slider.notifyListeners();
	return dragObj;
}, onDragEnd:function (evt) {
	this.slider._isDragInProgress = false;
	this.slider.notifyListeners();
}, createDragMoveObject:function () {
	var dragObj = new dojo.widget._SliderDragMoveObject(this.dragObject, this.type);
	dragObj.slider = this.slider;
	if (this.dragClass) {
		dragObj.dragClass = this.dragClass;
	}
	return dragObj;
}, setParent:function (slider) {
	this.slider = slider;
}});
dojo.declare("dojo.widget._SliderDragMoveObject", dojo.dnd.HtmlDragMoveObject, {slider:null, onDragMove:function (evt) {
	this.updateDragOffset();
	if (this.slider.isEnableX) {
		var x = this.dragOffset.x + evt.pageX;
		this.slider._snapX(x);
	}
	if (this.slider.isEnableY) {
		var y = this.dragOffset.y + evt.pageY;
		this.slider._snapY(y);
	}
	if (this.slider.activeDrag) {
		this.slider.notifyListeners();
	}
}});


__CPAN_FILE__ src/widget/AnimatedPng.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.widget.AnimatedPng");
dojo.require("dojo.widget.*");
dojo.require("dojo.widget.HtmlWidget");
dojo.widget.defineWidget("dojo.widget.AnimatedPng", dojo.widget.HtmlWidget, {isContainer:false, width:0, height:0, aniSrc:"", interval:100, _blankSrc:dojo.uri.moduleUri("dojo.widget", "templates/images/blank.gif"), templateString:"<img class=\"dojoAnimatedPng\" />", postCreate:function () {
	this.cellWidth = this.width;
	this.cellHeight = this.height;
	var img = new Image();
	var self = this;
	img.onload = function () {
		self._initAni(img.width, img.height);
	};
	img.src = this.aniSrc;
}, _initAni:function (w, h) {
	this.domNode.src = this._blankSrc;
	this.domNode.width = this.cellWidth;
	this.domNode.height = this.cellHeight;
	this.domNode.style.backgroundImage = "url(" + this.aniSrc + ")";
	this.domNode.style.backgroundRepeat = "no-repeat";
	this.aniCols = Math.floor(w / this.cellWidth);
	this.aniRows = Math.floor(h / this.cellHeight);
	this.aniCells = this.aniCols * this.aniRows;
	this.aniFrame = 0;
	window.setInterval(dojo.lang.hitch(this, "_tick"), this.interval);
}, _tick:function () {
	this.aniFrame++;
	if (this.aniFrame == this.aniCells) {
		this.aniFrame = 0;
	}
	var col = this.aniFrame % this.aniCols;
	var row = Math.floor(this.aniFrame / this.aniCols);
	var bx = -1 * col * this.cellWidth;
	var by = -1 * row * this.cellHeight;
	this.domNode.style.backgroundPosition = bx + "px " + by + "px";
}});


__CPAN_FILE__ src/widget/TreeDocIconExtension.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.widget.TreeDocIconExtension");
dojo.require("dojo.widget.HtmlWidget");
dojo.require("dojo.widget.TreeExtension");
dojo.widget.defineWidget("dojo.widget.TreeDocIconExtension", [dojo.widget.TreeExtension], {templateCssString:"\n/* CSS for TreeDocIconExtension */\n\n\n/* long vertical line under docIcon, connecting w/ children */\n.TreeStateChildrenYes-ExpandOpen .TreeIconContent {\n	background-image : url('../templates/images/TreeV3/i_long.gif');\n	background-repeat : no-repeat;\n	background-position: 18px 9px;\n}\n\n/* close has higher priority */\n.TreeStateChildrenYes-ExpandClosed .TreeIconContent {\n	background-image : url();\n}\n\n/* higher priotity: same length and appear after background-definition */\n.TreeStateChildrenNo-ExpandLeaf .TreeIconContent {\n	background-image : url();\n}\n\n.TreeStateChildrenNo-ExpandClosed .TreeIconContent {\n	background-image : url();\n}\n\n.TreeStateChildrenNo-ExpandOpen .TreeIconContent {\n	background-image : url();\n}\n\n\n/* highest priority */\n.TreeIconDocument {\n	background-image: url('../templates/images/TreeV3/document.gif');\n}\n\n.TreeExpandOpen .TreeIconFolder {\n	background-image: url('../templates/images/TreeV3/open.gif');\n}\n\n.TreeExpandClosed .TreeIconFolder {\n	background-image: url('../templates/images/TreeV3/closed.gif');\n}\n\n/* generic class for docIcon */\n.TreeIcon {\n	width: 18px;\n	height: 18px;\n	float: left;\n	display: inline;\n	background-repeat : no-repeat;\n}\n\ndiv.TreeContent {\n	margin-left: 36px;\n}\n", templateCssPath:dojo.uri.moduleUri("dojo.widget", "templates/TreeDocIcon.css"), listenTreeEvents:["afterChangeTree", "afterSetFolder", "afterUnsetFolder"], listenNodeFilter:function (elem) {
	return elem instanceof dojo.widget.Widget;
}, getnodeDocType:function (node) {
	var nodeDocType = node.getnodeDocType();
	if (!nodeDocType) {
		nodeDocType = node.isFolder ? "Folder" : "Document";
	}
	return nodeDocType;
}, setnodeDocTypeClass:function (node) {
	var reg = new RegExp("(^|\\s)" + node.tree.classPrefix + "Icon\\w+", "g");
	var clazz = dojo.html.getClass(node.iconNode).replace(reg, "") + " " + node.tree.classPrefix + "Icon" + this.getnodeDocType(node);
	dojo.html.setClass(node.iconNode, clazz);
}, onAfterSetFolder:function (message) {
	if (message.source.iconNode) {
		this.setnodeDocTypeClass(message.source);
	}
}, onAfterUnsetFolder:function (message) {
	this.setnodeDocTypeClass(message.source);
}, listenNode:function (node) {
	node.contentIconNode = document.createElement("div");
	var clazz = node.tree.classPrefix + "IconContent";
	if (dojo.render.html.ie) {
		clazz = clazz + " " + node.tree.classPrefix + "IEIconContent";
	}
	dojo.html.setClass(node.contentIconNode, clazz);
	node.contentNode.parentNode.replaceChild(node.contentIconNode, node.expandNode);
	node.iconNode = document.createElement("div");
	dojo.html.setClass(node.iconNode, node.tree.classPrefix + "Icon" + " " + node.tree.classPrefix + "Icon" + this.getnodeDocType(node));
	node.contentIconNode.appendChild(node.expandNode);
	node.contentIconNode.appendChild(node.iconNode);
	dojo.dom.removeNode(node.contentNode);
	node.contentIconNode.appendChild(node.contentNode);
}, onAfterChangeTree:function (message) {
	var _this = this;
	if (!message.oldTree || !this.listenedTrees[message.oldTree.widgetId]) {
		this.processDescendants(message.node, this.listenNodeFilter, this.listenNode);
	}
}});


__CPAN_FILE__ src/widget/TreeRPCController.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.widget.TreeRPCController");
dojo.require("dojo.event.*");
dojo.require("dojo.json");
dojo.require("dojo.io.*");
dojo.require("dojo.widget.TreeLoadingController");
dojo.widget.defineWidget("dojo.widget.TreeRPCController", dojo.widget.TreeLoadingController, {doMove:function (child, newParent, index) {
	var params = {child:this.getInfo(child), childTree:this.getInfo(child.tree), newParent:this.getInfo(newParent), newParentTree:this.getInfo(newParent.tree), newIndex:index};
	var success;
	this.runRPC({url:this.getRPCUrl("move"), load:function (response) {
		success = this.doMoveProcessResponse(response, child, newParent, index);
	}, sync:true, lock:[child, newParent], params:params});
	return success;
}, doMoveProcessResponse:function (response, child, newParent, index) {
	if (!dojo.lang.isUndefined(response.error)) {
		this.RPCErrorHandler("server", response.error);
		return false;
	}
	var args = [child, newParent, index];
	return dojo.widget.TreeLoadingController.prototype.doMove.apply(this, args);
}, doRemoveNode:function (node, callObj, callFunc) {
	var params = {node:this.getInfo(node), tree:this.getInfo(node.tree)};
	this.runRPC({url:this.getRPCUrl("removeNode"), load:function (response) {
		this.doRemoveNodeProcessResponse(response, node, callObj, callFunc);
	}, params:params, lock:[node]});
}, doRemoveNodeProcessResponse:function (response, node, callObj, callFunc) {
	if (!dojo.lang.isUndefined(response.error)) {
		this.RPCErrorHandler("server", response.error);
		return false;
	}
	if (!response) {
		return false;
	}
	if (response == true) {
		var args = [node, callObj, callFunc];
		dojo.widget.TreeLoadingController.prototype.doRemoveNode.apply(this, args);
		return;
	} else {
		if (dojo.lang.isObject(response)) {
			dojo.raise(response.error);
		} else {
			dojo.raise("Invalid response " + response);
		}
	}
}, doCreateChild:function (parent, index, output, callObj, callFunc) {
	var params = {tree:this.getInfo(parent.tree), parent:this.getInfo(parent), index:index, data:output};
	this.runRPC({url:this.getRPCUrl("createChild"), load:function (response) {
		this.doCreateChildProcessResponse(response, parent, index, callObj, callFunc);
	}, params:params, lock:[parent]});
}, doCreateChildProcessResponse:function (response, parent, index, callObj, callFunc) {
	if (!dojo.lang.isUndefined(response.error)) {
		this.RPCErrorHandler("server", response.error);
		return false;
	}
	if (!dojo.lang.isObject(response)) {
		dojo.raise("Invalid result " + response);
	}
	var args = [parent, index, response, callObj, callFunc];
	dojo.widget.TreeLoadingController.prototype.doCreateChild.apply(this, args);
}});


__CPAN_FILE__ src/widget/TreeEmphasizeOnSelect.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.widget.TreeEmphasizeOnSelect");
dojo.require("dojo.widget.HtmlWidget");
dojo.require("dojo.widget.TreeSelectorV3");
dojo.require("dojo.html.selection");
dojo.widget.defineWidget("dojo.widget.TreeEmphasizeOnSelect", dojo.widget.HtmlWidget, {selector:"", initialize:function () {
	this.selector = dojo.widget.byId(this.selector);
	dojo.event.topic.subscribe(this.selector.eventNames.select, this, "onSelect");
	dojo.event.topic.subscribe(this.selector.eventNames.deselect, this, "onDeselect");
}, onSelect:function (message) {
	message.node.viewEmphasize();
}, onDeselect:function (message) {
	message.node.viewUnemphasize();
}});


__CPAN_FILE__ src/widget/TreeRpcControllerV3.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.widget.TreeRpcControllerV3");
dojo.require("dojo.event.*");
dojo.require("dojo.json");
dojo.require("dojo.io.*");
dojo.require("dojo.widget.TreeLoadingControllerV3");
dojo.widget.defineWidget("dojo.widget.TreeRpcControllerV3", dojo.widget.TreeLoadingControllerV3, {extraRpcOnEdit:false, doMove:function (child, newParent, index, sync) {
	var params = {child:this.getInfo(child), childTree:this.getInfo(child.tree), oldParent:this.getInfo(child.parent), oldParentTree:this.getInfo(child.parent.tree), newParent:this.getInfo(newParent), newParentTree:this.getInfo(newParent.tree), newIndex:index};
	var deferred = this.runRpc({url:this.getRpcUrl("move"), sync:sync, params:params});
	var _this = this;
	var args = arguments;
	deferred.addCallback(function () {
		dojo.widget.TreeBasicControllerV3.prototype.doMove.apply(_this, args);
	});
	return deferred;
}, prepareDetach:function (node, sync) {
	var deferred = this.startProcessing(node);
	return deferred;
}, finalizeDetach:function (node) {
	this.finishProcessing(node);
}, doDetach:function (node, sync) {
	var params = {node:this.getInfo(node), tree:this.getInfo(node.tree)};
	var deferred = this.runRpc({url:this.getRpcUrl("detach"), sync:sync, params:params});
	var _this = this;
	var args = arguments;
	deferred.addCallback(function () {
		dojo.widget.TreeBasicControllerV3.prototype.doDetach.apply(_this, args);
	});
	return deferred;
}, requestEditConfirmation:function (node, action, sync) {
	if (!this.extraRpcOnEdit) {
		return dojo.Deferred.prototype.makeCalled();
	}
	var _this = this;
	var deferred = this.startProcessing(node);
	var params = {node:this.getInfo(node), tree:this.getInfo(node.tree)};
	deferred.addCallback(function () {
		return _this.runRpc({url:_this.getRpcUrl(action), sync:sync, params:params});
	});
	deferred.addBoth(function (r) {
		_this.finishProcessing(node);
		return r;
	});
	return deferred;
}, editLabelSave:function (node, newContent, sync) {
	var deferred = this.startProcessing(node);
	var _this = this;
	var params = {node:this.getInfo(node), tree:this.getInfo(node.tree), newContent:newContent};
	deferred.addCallback(function () {
		return _this.runRpc({url:_this.getRpcUrl("editLabelSave"), sync:sync, params:params});
	});
	deferred.addBoth(function (r) {
		_this.finishProcessing(node);
		return r;
	});
	return deferred;
}, editLabelStart:function (node, sync) {
	if (!this.canEditLabel(node)) {
		return false;
	}
	var _this = this;
	if (!this.editor.isClosed()) {
		var deferred = this.editLabelFinish(this.editor.saveOnBlur, sync);
		deferred.addCallback(function () {
			return _this.editLabelStart(node, sync);
		});
		return deferred;
	}
	var deferred = this.requestEditConfirmation(node, "editLabelStart", sync);
	deferred.addCallback(function () {
		_this.doEditLabelStart(node);
	});
	return deferred;
}, editLabelFinish:function (save, sync) {
	var _this = this;
	var node = this.editor.node;
	var deferred = dojo.Deferred.prototype.makeCalled();
	if (!save && !node.isPhantom) {
		deferred = this.requestEditConfirmation(this.editor.node, "editLabelFinishCancel", sync);
	}
	if (save) {
		if (node.isPhantom) {
			deferred = this.sendCreateChildRequest(node.parent, node.getParentIndex(), {title:this.editor.getContents()}, sync);
		} else {
			deferred = this.editLabelSave(node, this.editor.getContents(), sync);
		}
	}
	deferred.addCallback(function (server_data) {
		_this.doEditLabelFinish(save, server_data);
	});
	deferred.addErrback(function (r) {
		_this.doEditLabelFinish(false);
		return false;
	});
	return deferred;
}, createAndEdit:function (parent, index, sync) {
	var data = {title:parent.tree.defaultChildTitle};
	if (!this.canCreateChild(parent, index, data)) {
		return false;
	}
	if (!this.editor.isClosed()) {
		var deferred = this.editLabelFinish(this.editor.saveOnBlur, sync);
		deferred.addCallback(function () {
			return _this.createAndEdit(parent, index, sync);
		});
		return deferred;
	}
	var _this = this;
	var deferred = this.prepareCreateChild(parent, index, data, sync);
	deferred.addCallback(function () {
		var child = _this.makeDefaultNode(parent, index);
		child.isPhantom = true;
		return child;
	});
	deferred.addBoth(function (r) {
		_this.finalizeCreateChild(parent, index, data, sync);
		return r;
	});
	deferred.addCallback(function (child) {
		var d = _this.exposeCreateChild(parent, index, data, sync);
		d.addCallback(function () {
			return child;
		});
		return d;
	});
	deferred.addCallback(function (child) {
		_this.doEditLabelStart(child);
		return child;
	});
	return deferred;
}, prepareDestroyChild:function (node, sync) {
	var deferred = this.startProcessing(node);
	return deferred;
}, finalizeDestroyChild:function (node) {
	this.finishProcessing(node);
}, doDestroyChild:function (node, sync) {
	var params = {node:this.getInfo(node), tree:this.getInfo(node.tree)};
	var deferred = this.runRpc({url:this.getRpcUrl("destroyChild"), sync:sync, params:params});
	var _this = this;
	var args = arguments;
	deferred.addCallback(function () {
		dojo.widget.TreeBasicControllerV3.prototype.doDestroyChild.apply(_this, args);
	});
	return deferred;
}, sendCreateChildRequest:function (parent, index, data, sync) {
	var params = {tree:this.getInfo(parent.tree), parent:this.getInfo(parent), index:index, data:data};
	var deferred = this.runRpc({url:this.getRpcUrl("createChild"), sync:sync, params:params});
	return deferred;
}, doCreateChild:function (parent, index, data, sync) {
	if (dojo.lang.isUndefined(data.title)) {
		data.title = parent.tree.defaultChildTitle;
	}
	var deferred = this.sendCreateChildRequest(parent, index, data, sync);
	var _this = this;
	var args = arguments;
	deferred.addCallback(function (server_data) {
		dojo.lang.mixin(data, server_data);
		return dojo.widget.TreeBasicControllerV3.prototype.doCreateChild.call(_this, parent, index, data);
	});
	return deferred;
}, doClone:function (child, newParent, index, deep, sync) {
	var params = {child:this.getInfo(child), oldParent:this.getInfo(child.parent), oldParentTree:this.getInfo(child.parent.tree), newParent:this.getInfo(newParent), newParentTree:this.getInfo(newParent.tree), index:index, deep:deep ? true : false, tree:this.getInfo(child.tree)};
	var deferred = this.runRpc({url:this.getRpcUrl("clone"), sync:sync, params:params});
	var _this = this;
	var args = arguments;
	deferred.addCallback(function () {
		dojo.widget.TreeBasicControllerV3.prototype.doClone.apply(_this, args);
	});
	return deferred;
}});


__CPAN_FILE__ src/widget/TaskBar.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.widget.TaskBar");
dojo.require("dojo.widget.*");
dojo.require("dojo.widget.FloatingPane");
dojo.require("dojo.widget.HtmlWidget");
dojo.require("dojo.event.*");
dojo.require("dojo.html.selection");
dojo.widget.defineWidget("dojo.widget.TaskBarItem", dojo.widget.HtmlWidget, {iconSrc:"", caption:"Untitled", templateString:"<div class=\"dojoTaskBarItem\" dojoAttachEvent=\"onClick\">\n</div>\n", templateCssString:".dojoTaskBarItem {\n\tdisplay: inline-block;\n\tbackground-color: ThreeDFace;\n\tborder: outset 2px;\n\tmargin-right: 5px;\n\tcursor: pointer;\n\theight: 35px;\n\twidth: 100px;\n\tfont-size: 10pt;\n\twhite-space: nowrap;\n\ttext-align: center;\n\tfloat: left;\n\toverflow: hidden;\n}\n\n.dojoTaskBarItem img {\n\tvertical-align: middle;\n\tmargin-right: 5px;\n\tmargin-left: 5px;\t\n\theight: 32px;\n\twidth: 32px;\n}\n\n.dojoTaskBarItem a {\n\t color: black;\n\ttext-decoration: none;\n}\n\n\n", templateCssPath:dojo.uri.moduleUri("dojo.widget", "templates/TaskBar.css"), fillInTemplate:function () {
	if (this.iconSrc) {
		var img = document.createElement("img");
		img.src = this.iconSrc;
		this.domNode.appendChild(img);
	}
	this.domNode.appendChild(document.createTextNode(this.caption));
	dojo.html.disableSelection(this.domNode);
}, postCreate:function () {
	this.window = dojo.widget.getWidgetById(this.windowId);
	this.window.explodeSrc = this.domNode;
	dojo.event.connect(this.window, "destroy", this, "destroy");
}, onClick:function () {
	this.window.toggleDisplay();
}});
dojo.widget.defineWidget("dojo.widget.TaskBar", dojo.widget.FloatingPane, function () {
	this._addChildStack = [];
}, {resizable:false, titleBarDisplay:false, addChild:function (child) {
	if (!this.containerNode) {
		this._addChildStack.push(child);
	} else {
		if (this._addChildStack.length > 0) {
			var oarr = this._addChildStack;
			this._addChildStack = [];
			dojo.lang.forEach(oarr, this.addChild, this);
		}
	}
	var tbi = dojo.widget.createWidget("TaskBarItem", {windowId:child.widgetId, caption:child.title, iconSrc:child.iconSrc});
	dojo.widget.TaskBar.superclass.addChild.call(this, tbi);
}});


__CPAN_FILE__ src/widget/TabContainer.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.widget.TabContainer");
dojo.require("dojo.lang.func");
dojo.require("dojo.widget.*");
dojo.require("dojo.widget.PageContainer");
dojo.require("dojo.event.*");
dojo.require("dojo.html.selection");
dojo.require("dojo.widget.html.layout");
dojo.widget.defineWidget("dojo.widget.TabContainer", dojo.widget.PageContainer, {labelPosition:"top", closeButton:"none", templateString:null, templateString:"<div id=\"${this.widgetId}\" class=\"dojoTabContainer\">\n\t<div dojoAttachPoint=\"tablistNode\"></div>\n\t<div class=\"dojoTabPaneWrapper\" dojoAttachPoint=\"containerNode\" dojoAttachEvent=\"onKey\" waiRole=\"tabpanel\"></div>\n</div>\n", templateCssString:".dojoTabContainer {\n\tposition : relative;\n}\n\n.dojoTabPaneWrapper {\n\tborder : 1px solid #6290d2;\n\t_zoom: 1; /* force IE6 layout mode so top border doesnt disappear */\n\tdisplay: block;\n\tclear: both;\n\toverflow: hidden;\n}\n\n.dojoTabLabels-top {\n\tposition : relative;\n\ttop : 0px;\n\tleft : 0px;\n\toverflow : visible;\n\tmargin-bottom : -1px;\n\twidth : 100%;\n\tz-index: 2;\t/* so the bottom of the tab label will cover up the border of dojoTabPaneWrapper */\n}\n\n.dojoTabNoLayout.dojoTabLabels-top .dojoTab {\n\tmargin-bottom: -1px;\n\t_margin-bottom: 0px; /* IE filter so top border lines up correctly */\n}\n\n.dojoTab {\n\tposition : relative;\n\tfloat : left;\n\tpadding-left : 9px;\n\tborder-bottom : 1px solid #6290d2;\n\tbackground : url(images/tab_left.gif) no-repeat left top;\n\tcursor: pointer;\n\twhite-space: nowrap;\n\tz-index: 3;\n}\n\n.dojoTab div {\n\tdisplay : block;\n\tpadding : 4px 15px 4px 6px;\n\tbackground : url(images/tab_top_right.gif) no-repeat right top;\n\tcolor : #333;\n\tfont-size : 90%;\n}\n\n.dojoTab .close {\n\tdisplay : inline-block;\n\theight : 12px;\n\twidth : 12px;\n\tpadding : 0 12px 0 0;\n\tmargin : 0 -10px 0 10px;\n\tcursor : default;\n\tfont-size: small;\n}\n\n.dojoTab .closeImage {\n\tbackground : url(images/tab_close.gif) no-repeat right top;\n}\n\n.dojoTab .closeHover {\n\tbackground-image : url(images/tab_close_h.gif);\n}\n\n.dojoTab.current {\n\tpadding-bottom : 1px;\n\tborder-bottom : 0;\n\tbackground-position : 0 -150px;\n}\n\n.dojoTab.current div {\n\tpadding-bottom : 5px;\n\tmargin-bottom : -1px;\n\tbackground-position : 100% -150px;\n}\n\n/* bottom tabs */\n\n.dojoTabLabels-bottom {\n\tposition : relative;\n\tbottom : 0px;\n\tleft : 0px;\n\toverflow : visible;\n\tmargin-top : -1px;\n\twidth : 100%;\n\tz-index: 2;\n}\n\n.dojoTabNoLayout.dojoTabLabels-bottom {\n\tposition : relative;\n}\n\n.dojoTabLabels-bottom .dojoTab {\n\tborder-top :  1px solid #6290d2;\n\tborder-bottom : 0;\n\tbackground : url(images/tab_bot_left.gif) no-repeat left bottom;\n}\n\n.dojoTabLabels-bottom .dojoTab div {\n\tbackground : url(images/tab_bot_right.gif) no-repeat right bottom;\n}\n\n.dojoTabLabels-bottom .dojoTab.current {\n\tborder-top : 0;\n\tbackground : url(images/tab_bot_left_curr.gif) no-repeat left bottom;\n}\n\n.dojoTabLabels-bottom .dojoTab.current div {\n\tpadding-top : 4px;\n\tbackground : url(images/tab_bot_right_curr.gif) no-repeat right bottom;\n}\n\n/* right-h tabs */\n\n.dojoTabLabels-right-h {\n\toverflow : visible;\n\tmargin-left : -1px;\n\tz-index: 2;\n}\n\n.dojoTabLabels-right-h .dojoTab {\n\tpadding-left : 0;\n\tborder-left :  1px solid #6290d2;\n\tborder-bottom : 0;\n\tbackground : url(images/tab_bot_right.gif) no-repeat right bottom;\n\tfloat : none;\n}\n\n.dojoTabLabels-right-h .dojoTab div {\n\tpadding : 4px 15px 4px 15px;\n}\n\n.dojoTabLabels-right-h .dojoTab.current {\n\tborder-left :  0;\n\tborder-bottom :  1px solid #6290d2;\n}\n\n/* left-h tabs */\n\n.dojoTabLabels-left-h {\n\toverflow : visible;\n\tmargin-right : -1px;\n\tz-index: 2;\n}\n\n.dojoTabLabels-left-h .dojoTab {\n\tborder-right :  1px solid #6290d2;\n\tborder-bottom : 0;\n\tfloat : none;\n\tbackground : url(images/tab_top_left.gif) no-repeat left top;\n}\n\n.dojoTabLabels-left-h .dojoTab.current {\n\tborder-right : 0;\n\tborder-bottom :  1px solid #6290d2;\n\tpadding-bottom : 0;\n\tbackground : url(images/tab_top_left.gif) no-repeat 0 -150px;\n}\n\n.dojoTabLabels-left-h .dojoTab div {\n\tbackground : 0;\n\tborder-bottom :  1px solid #6290d2;\n}\n", templateCssPath:dojo.uri.moduleUri("dojo.widget", "templates/TabContainer.css"), selectedTab:"", postMixInProperties:function () {
	if (this.selectedTab) {
		dojo.deprecated("selectedTab deprecated, use selectedChild instead, will be removed in", "0.5");
		this.selectedChild = this.selectedTab;
	}
	if (this.closeButton != "none") {
		dojo.deprecated("closeButton deprecated, use closable='true' on each child instead, will be removed in", "0.5");
	}
	dojo.widget.TabContainer.superclass.postMixInProperties.apply(this, arguments);
}, fillInTemplate:function () {
	this.tablist = dojo.widget.createWidget("TabController", {id:this.widgetId + "_tablist", labelPosition:this.labelPosition, doLayout:this.doLayout, containerId:this.widgetId}, this.tablistNode);
	dojo.widget.TabContainer.superclass.fillInTemplate.apply(this, arguments);
}, postCreate:function (args, frag) {
	dojo.widget.TabContainer.superclass.postCreate.apply(this, arguments);
	this.onResized();
}, _setupChild:function (tab) {
	if (this.closeButton == "tab" || this.closeButton == "pane") {
		tab.closable = true;
	}
	dojo.html.addClass(tab.domNode, "dojoTabPane");
	dojo.widget.TabContainer.superclass._setupChild.apply(this, arguments);
}, onResized:function () {
	if (!this.doLayout) {
		return;
	}
	var labelAlign = this.labelPosition.replace(/-h/, "");
	var children = [{domNode:this.tablist.domNode, layoutAlign:labelAlign}, {domNode:this.containerNode, layoutAlign:"client"}];
	dojo.widget.html.layout(this.domNode, children);
	if (this.selectedChildWidget) {
		var containerSize = dojo.html.getContentBox(this.containerNode);
		this.selectedChildWidget.resizeTo(containerSize.width, containerSize.height);
	}
}, selectTab:function (tab, callingWidget) {
	dojo.deprecated("use selectChild() rather than selectTab(), selectTab() will be removed in", "0.5");
	this.selectChild(tab, callingWidget);
}, onKey:function (e) {
	if (e.keyCode == e.KEY_UP_ARROW && e.ctrlKey) {
		var button = this.correspondingTabButton || this.selectedTabWidget.tabButton;
		button.focus();
		dojo.event.browser.stopEvent(e);
	} else {
		if (e.keyCode == e.KEY_DELETE && e.altKey) {
			if (this.selectedChildWidget.closable) {
				this.closeChild(this.selectedChildWidget);
				dojo.event.browser.stopEvent(e);
			}
		}
	}
}, destroy:function () {
	this.tablist.destroy();
	dojo.widget.TabContainer.superclass.destroy.apply(this, arguments);
}});
dojo.widget.defineWidget("dojo.widget.TabController", dojo.widget.PageController, {templateString:"<div wairole='tablist' dojoAttachEvent='onKey'></div>", labelPosition:"top", doLayout:true, "class":"", buttonWidget:"TabButton", postMixInProperties:function () {
	if (!this["class"]) {
		this["class"] = "dojoTabLabels-" + this.labelPosition + (this.doLayout ? "" : " dojoTabNoLayout");
	}
	dojo.widget.TabController.superclass.postMixInProperties.apply(this, arguments);
}});
dojo.widget.defineWidget("dojo.widget.TabButton", dojo.widget.PageButton, {templateString:"<div class='dojoTab' dojoAttachEvent='onClick'>" + "<div dojoAttachPoint='innerDiv'>" + "<span dojoAttachPoint='titleNode' tabIndex='-1' waiRole='tab'>${this.label}</span>" + "<span dojoAttachPoint='closeButtonNode' class='close closeImage' style='${this.closeButtonStyle}'" + "	dojoAttachEvent='onMouseOver:onCloseButtonMouseOver; onMouseOut:onCloseButtonMouseOut; onClick:onCloseButtonClick'></span>" + "</div>" + "</div>", postMixInProperties:function () {
	this.closeButtonStyle = this.closeButton ? "" : "display: none";
	dojo.widget.TabButton.superclass.postMixInProperties.apply(this, arguments);
}, fillInTemplate:function () {
	dojo.html.disableSelection(this.titleNode);
	dojo.widget.TabButton.superclass.fillInTemplate.apply(this, arguments);
}, onCloseButtonClick:function (evt) {
	evt.stopPropagation();
	dojo.widget.TabButton.superclass.onCloseButtonClick.apply(this, arguments);
}});
dojo.widget.defineWidget("dojo.widget.a11y.TabButton", dojo.widget.TabButton, {imgPath:dojo.uri.moduleUri("dojo.widget", "templates/images/tab_close.gif"), templateString:"<div class='dojoTab' dojoAttachEvent='onClick;onKey'>" + "<div dojoAttachPoint='innerDiv'>" + "<span dojoAttachPoint='titleNode' tabIndex='-1' waiRole='tab'>${this.label}</span>" + "<img class='close' src='${this.imgPath}' alt='[x]' style='${this.closeButtonStyle}'" + "	dojoAttachEvent='onClick:onCloseButtonClick'>" + "</div>" + "</div>"});


__CPAN_FILE__ src/widget/TitlePane.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.widget.TitlePane");
dojo.require("dojo.widget.*");
dojo.require("dojo.widget.ContentPane");
dojo.require("dojo.html.style");
dojo.require("dojo.lfx.*");
dojo.widget.defineWidget("dojo.widget.TitlePane", dojo.widget.ContentPane, {labelNodeClass:"", containerNodeClass:"", label:"", open:true, templateString:"<div dojoAttachPoint=\"domNode\">\n<div dojoAttachPoint=\"labelNode\" dojoAttachEvent=\"onclick: onLabelClick\"></div>\n<div dojoAttachPoint=\"containerNode\"></div>\n</div>\n", postCreate:function () {
	if (this.label) {
		this.labelNode.appendChild(document.createTextNode(this.label));
	}
	if (this.labelNodeClass) {
		dojo.html.addClass(this.labelNode, this.labelNodeClass);
	}
	if (this.containerNodeClass) {
		dojo.html.addClass(this.containerNode, this.containerNodeClass);
	}
	if (!this.open) {
		dojo.html.hide(this.containerNode);
	}
	dojo.widget.TitlePane.superclass.postCreate.apply(this, arguments);
}, onLabelClick:function () {
	if (this.open) {
		dojo.lfx.wipeOut(this.containerNode, 250).play();
		this.open = false;
	} else {
		dojo.lfx.wipeIn(this.containerNode, 250).play();
		this.open = true;
	}
}, setLabel:function (label) {
	this.labelNode.innerHTML = label;
}});


__CPAN_FILE__ src/widget/CurrencyTextbox.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.widget.CurrencyTextbox");
dojo.require("dojo.widget.IntegerTextbox");
dojo.require("dojo.validate.common");
dojo.widget.defineWidget("dojo.widget.CurrencyTextbox", dojo.widget.IntegerTextbox, {mixInProperties:function (localProperties, frag) {
	dojo.widget.CurrencyTextbox.superclass.mixInProperties.apply(this, arguments);
	if (localProperties.fractional) {
		this.flags.fractional = (localProperties.fractional == "true");
	} else {
		if (localProperties.cents) {
			dojo.deprecated("dojo.widget.IntegerTextbox", "use fractional attr instead of cents", "0.5");
			this.flags.fractional = (localProperties.cents == "true");
		}
	}
	if (localProperties.symbol) {
		this.flags.symbol = localProperties.symbol;
	}
	if (localProperties.min) {
		this.flags.min = parseFloat(localProperties.min);
	}
	if (localProperties.max) {
		this.flags.max = parseFloat(localProperties.max);
	}
}, isValid:function () {
	return dojo.validate.isCurrency(this.textbox.value, this.flags);
}, isInRange:function () {
	return dojo.validate.isInRange(this.textbox.value, this.flags);
}});


__CPAN_FILE__ src/widget/Clock.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.widget.Clock");
dojo.require("dojo.widget.*");
dojo.require("dojo.gfx.*");
dojo.require("dojo.uri.Uri");
dojo.require("dojo.lang.common");
dojo.require("dojo.lang.timing.Timer");
dojo.widget.defineWidget("dojo.widget.Clock", dojo.widget.HtmlWidget, function () {
	var self = this;
	this.timeZoneOffset = 0;
	this.label = "";
	this.date = new Date();
	this.handColor = "#788598";
	this.handStroke = "#6f7b8c";
	this.secondHandColor = [201, 4, 5, 0.8];
	this.topLabelColor = "#efefef";
	this.labelColor = "#fff";
	this.timer = new dojo.lang.timing.Timer(1000);
	this.center = {x:75, y:75};
	this.hands = {hour:null, minute:null, second:null};
	this.shadows = {hour:{shadow:null, shift:{dx:2, dy:2}}, minute:{shadow:null, shift:{dx:2, dy:3}}, second:{shadow:null, shift:{dx:4, dy:4}}};
	this.image = dojo.uri.moduleUri("dojo.widget", "templates/images/clock.png");
	this.surface = null;
	this.labelNode = null;
	this.topLabelNode = null;
	this.draw = function () {
		self.date = new Date();
		var h = (self.date.getHours() + self.timeZoneOffset) % 12;
		var m = self.date.getMinutes();
		var s = self.date.getSeconds();
		self.placeHour(h, m, s);
		self.placeMinute(m, s);
		self.placeSecond(s);
		self.topLabelNode.innerHTML = ((self.date.getHours() + self.timeZoneOffset) > 11) ? "PM" : "AM";
	};
	this.timer.onTick = self.draw;
}, {set:function (dt) {
	this.date = dt;
	if (!this.timer.isRunning) {
		this.draw();
	}
}, start:function () {
	this.timer.start();
}, stop:function () {
	this.timer.stop();
}, _initPoly:function (parent, points) {
	var path = parent.createPath();
	var first = true;
	dojo.lang.forEach(points, function (c) {
		if (first) {
			path.moveTo(c.x, c.y);
			first = false;
		} else {
			path.lineTo(c.x, c.y);
		}
	});
	return path;
}, _placeHand:function (shape, angle, shift) {
	var move = {dx:this.center.x + (shift ? shift.dx : 0), dy:this.center.y + (shift ? shift.dy : 0)};
	return shape.setTransform([move, dojo.gfx.matrix.rotateg(-angle)]);
}, placeHour:function (h, m, s) {
	var angle = 30 * (h + m / 60 + s / 3600);
	this._placeHand(this.hands.hour, angle);
	this._placeHand(this.shadows.hour.shadow, angle, this.shadows.hour.shift);
}, placeMinute:function (m, s) {
	var angle = 6 * (m + s / 60);
	this._placeHand(this.hands.minute, angle);
	this._placeHand(this.shadows.minute.shadow, angle, this.shadows.minute.shift);
}, placeSecond:function (s) {
	var angle = 6 * s;
	this._placeHand(this.hands.second, angle);
	this._placeHand(this.shadows.second.shadow, angle, this.shadows.second.shift);
}, init:function () {
	if (this.domNode.style.position != "absolute") {
		this.domNode.style.position = "relative";
	}
	while (this.domNode.childNodes.length > 0) {
		this.domNode.removeChild(this.domNode.childNodes[0]);
	}
	this.domNode.style.width = "150px";
	this.domNode.style.height = "150px";
	this.surface = dojo.gfx.createSurface(this.domNode, 150, 150);
	this.surface.createRect({width:150, height:150});
	this.surface.createImage({width:150, height:150, src:this.image + ""});
	var hP = [{x:-3, y:-4}, {x:3, y:-4}, {x:1, y:-27}, {x:-1, y:-27}, {x:-3, y:-4}];
	var mP = [{x:-3, y:-4}, {x:3, y:-4}, {x:1, y:-38}, {x:-1, y:-38}, {x:-3, y:-4}];
	var sP = [{x:-2, y:-2}, {x:2, y:-2}, {x:1, y:-45}, {x:-1, y:-45}, {x:-2, y:-2}];
	this.shadows.hour.shadow = this._initPoly(this.surface, hP).setFill([0, 0, 0, 0.1]);
	this.hands.hour = this._initPoly(this.surface, hP).setStroke({color:this.handStroke, width:1}).setFill({type:"linear", x1:0, y1:0, x2:0, y2:-27, colors:[{offset:0, color:"#fff"}, {offset:0.33, color:this.handColor}]});
	this.shadows.minute.shadow = this._initPoly(this.surface, mP).setFill([0, 0, 0, 0.1]);
	this.hands.minute = this._initPoly(this.surface, mP).setStroke({color:this.handStroke, width:1}).setFill({type:"linear", x1:0, y1:0, x2:0, y2:-38, colors:[{offset:0, color:"#fff"}, {offset:0.33, color:this.handColor}]});
	this.surface.createCircle({r:6}).setStroke({color:this.handStroke, width:2}).setFill("#fff").setTransform({dx:75, dy:75});
	this.shadows.second.shadow = this._initPoly(this.surface, sP).setFill([0, 0, 0, 0.1]);
	this.hands.second = this._initPoly(this.surface, sP).setFill(this.secondHandColor);
	this.surface.createCircle({r:4}).setFill(this.secondHandColor).setTransform({dx:75, dy:75});
	this.topLabelNode = document.createElement("div");
	with (this.topLabelNode.style) {
		position = "absolute";
		top = "3px";
		left = "0px";
		color = this.topLabelColor;
		textAlign = "center";
		width = "150px";
		fontFamily = "sans-serif";
		fontSize = "11px";
		textTransform = "uppercase";
		fontWeight = "bold";
	}
	this.topLabelNode.innerHTML = ((this.date.getHours() + this.timeZoneOffset) > 11) ? "PM" : "AM";
	this.domNode.appendChild(this.topLabelNode);
	this.labelNode = document.createElement("div");
	with (this.labelNode.style) {
		position = "absolute";
		top = "134px";
		left = "0px";
		color = this.labelColor;
		textAlign = "center";
		width = "150px";
		fontFamily = "sans-serif";
		fontSize = "10px";
		textTransform = "uppercase";
		fontWeight = "bold";
	}
	this.labelNode.innerHTML = this.label || "&nbsp;";
	this.domNode.appendChild(this.labelNode);
	this.draw();
}, postCreate:function () {
	this.init();
	this.start();
}});


__CPAN_FILE__ src/widget/TreeBasicControllerV3.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.widget.TreeBasicControllerV3");
dojo.require("dojo.event.*");
dojo.require("dojo.json");
dojo.require("dojo.io.*");
dojo.require("dojo.widget.TreeCommon");
dojo.require("dojo.widget.TreeNodeV3");
dojo.require("dojo.widget.TreeV3");
dojo.widget.defineWidget("dojo.widget.TreeBasicControllerV3", [dojo.widget.HtmlWidget, dojo.widget.TreeCommon], function () {
	this.listenedTrees = {};
}, {listenTreeEvents:["afterSetFolder", "afterTreeCreate", "beforeTreeDestroy"], listenNodeFilter:function (elem) {
	return elem instanceof dojo.widget.Widget;
}, editor:null, initialize:function (args) {
	if (args.editor) {
		this.editor = dojo.widget.byId(args.editor);
		this.editor.controller = this;
	}
}, getInfo:function (elem) {
	return elem.getInfo();
}, onBeforeTreeDestroy:function (message) {
	this.unlistenTree(message.source);
}, onAfterSetFolder:function (message) {
	if (message.source.expandLevel > 0) {
		this.expandToLevel(message.source, message.source.expandLevel);
	}
	if (message.source.loadLevel > 0) {
		this.loadToLevel(message.source, message.source.loadLevel);
	}
}, _focusNextVisible:function (nodeWidget) {
	if (nodeWidget.isFolder && nodeWidget.isExpanded && nodeWidget.children.length > 0) {
		returnWidget = nodeWidget.children[0];
	} else {
		while (nodeWidget.isTreeNode && nodeWidget.isLastChild()) {
			nodeWidget = nodeWidget.parent;
		}
		if (nodeWidget.isTreeNode) {
			var returnWidget = nodeWidget.parent.children[nodeWidget.getParentIndex() + 1];
		}
	}
	if (returnWidget && returnWidget.isTreeNode) {
		this._focusLabel(returnWidget);
		return returnWidget;
	}
}, _focusPreviousVisible:function (nodeWidget) {
	var returnWidget = nodeWidget;
	if (!nodeWidget.isFirstChild()) {
		var previousSibling = nodeWidget.parent.children[nodeWidget.getParentIndex() - 1];
		nodeWidget = previousSibling;
		while (nodeWidget.isFolder && nodeWidget.isExpanded && nodeWidget.children.length > 0) {
			returnWidget = nodeWidget;
			nodeWidget = nodeWidget.children[nodeWidget.children.length - 1];
		}
	} else {
		nodeWidget = nodeWidget.parent;
	}
	if (nodeWidget && nodeWidget.isTreeNode) {
		returnWidget = nodeWidget;
	}
	if (returnWidget && returnWidget.isTreeNode) {
		this._focusLabel(returnWidget);
		return returnWidget;
	}
}, _focusZoomIn:function (nodeWidget) {
	var returnWidget = nodeWidget;
	if (nodeWidget.isFolder && !nodeWidget.isExpanded) {
		this.expand(nodeWidget);
	} else {
		if (nodeWidget.children.length > 0) {
			nodeWidget = nodeWidget.children[0];
		}
	}
	if (nodeWidget && nodeWidget.isTreeNode) {
		returnWidget = nodeWidget;
	}
	if (returnWidget && returnWidget.isTreeNode) {
		this._focusLabel(returnWidget);
		return returnWidget;
	}
}, _focusZoomOut:function (node) {
	var returnWidget = node;
	if (node.isFolder && node.isExpanded) {
		this.collapse(node);
	} else {
		node = node.parent;
	}
	if (node && node.isTreeNode) {
		returnWidget = node;
	}
	if (returnWidget && returnWidget.isTreeNode) {
		this._focusLabel(returnWidget);
		return returnWidget;
	}
}, onFocusNode:function (e) {
	var node = this.domElement2TreeNode(e.target);
	if (node) {
		node.viewFocus();
		dojo.event.browser.stopEvent(e);
	}
}, onBlurNode:function (e) {
	var node = this.domElement2TreeNode(e.target);
	if (!node) {
		return;
	}
	var labelNode = node.labelNode;
	labelNode.setAttribute("tabIndex", "-1");
	node.viewUnfocus();
	dojo.event.browser.stopEvent(e);
	node.tree.domNode.setAttribute("tabIndex", "0");
}, _focusLabel:function (node) {
	var lastFocused = node.tree.lastFocused;
	var labelNode;
	if (lastFocused && lastFocused.labelNode) {
		labelNode = lastFocused.labelNode;
		dojo.event.disconnect(labelNode, "onblur", this, "onBlurNode");
		labelNode.setAttribute("tabIndex", "-1");
		dojo.html.removeClass(labelNode, "TreeLabelFocused");
	}
	labelNode = node.labelNode;
	labelNode.setAttribute("tabIndex", "0");
	node.tree.lastFocused = node;
	dojo.html.addClass(labelNode, "TreeLabelFocused");
	dojo.event.connectOnce(labelNode, "onblur", this, "onBlurNode");
	dojo.event.connectOnce(labelNode, "onfocus", this, "onFocusNode");
	labelNode.focus();
}, onKey:function (e) {
	if (!e.key || e.ctrkKey || e.altKey) {
		return;
	}
	var nodeWidget = this.domElement2TreeNode(e.target);
	if (!nodeWidget) {
		return;
	}
	var treeWidget = nodeWidget.tree;
	if (treeWidget.lastFocused && treeWidget.lastFocused.labelNode) {
		nodeWidget = treeWidget.lastFocused;
	}
	switch (e.key) {
	  case e.KEY_TAB:
		if (e.shiftKey) {
			treeWidget.domNode.setAttribute("tabIndex", "-1");
		}
		break;
	  case e.KEY_RIGHT_ARROW:
		this._focusZoomIn(nodeWidget);
		dojo.event.browser.stopEvent(e);
		break;
	  case e.KEY_LEFT_ARROW:
		this._focusZoomOut(nodeWidget);
		dojo.event.browser.stopEvent(e);
		break;
	  case e.KEY_UP_ARROW:
		this._focusPreviousVisible(nodeWidget);
		dojo.event.browser.stopEvent(e);
		break;
	  case e.KEY_DOWN_ARROW:
		this._focusNextVisible(nodeWidget);
		dojo.event.browser.stopEvent(e);
		break;
	}
}, onFocusTree:function (e) {
	if (!e.currentTarget) {
		return;
	}
	try {
		var treeWidget = this.getWidgetByNode(e.currentTarget);
		if (!treeWidget || !treeWidget.isTree) {
			return;
		}
		var nodeWidget = this.getWidgetByNode(treeWidget.domNode.firstChild);
		if (nodeWidget && nodeWidget.isTreeNode) {
			if (treeWidget.lastFocused && treeWidget.lastFocused.isTreeNode) {
				nodeWidget = treeWidget.lastFocused;
			}
			this._focusLabel(nodeWidget);
		}
	}
	catch (e) {
	}
}, onAfterTreeCreate:function (message) {
	var tree = message.source;
	dojo.event.browser.addListener(tree.domNode, "onKey", dojo.lang.hitch(this, this.onKey));
	dojo.event.browser.addListener(tree.domNode, "onmousedown", dojo.lang.hitch(this, this.onTreeMouseDown));
	dojo.event.browser.addListener(tree.domNode, "onclick", dojo.lang.hitch(this, this.onTreeClick));
	dojo.event.browser.addListener(tree.domNode, "onfocus", dojo.lang.hitch(this, this.onFocusTree));
	tree.domNode.setAttribute("tabIndex", "0");
	if (tree.expandLevel) {
		this.expandToLevel(tree, tree.expandLevel);
	}
	if (tree.loadLevel) {
		this.loadToLevel(tree, tree.loadLevel);
	}
}, onTreeMouseDown:function (e) {
}, onTreeClick:function (e) {
	var domElement = e.target;
	var node = this.domElement2TreeNode(domElement);
	if (!node || !node.isTreeNode) {
		return;
	}
	var checkExpandClick = function (el) {
		return el === node.expandNode;
	};
	if (this.checkPathCondition(domElement, checkExpandClick)) {
		this.processExpandClick(node);
	}
	this._focusLabel(node);
}, processExpandClick:function (node) {
	if (node.isExpanded) {
		this.collapse(node);
	} else {
		this.expand(node);
	}
}, batchExpandTimeout:20, expandAll:function (nodeOrTree) {
	return this.expandToLevel(nodeOrTree, Number.POSITIVE_INFINITY);
}, collapseAll:function (nodeOrTree) {
	var _this = this;
	var filter = function (elem) {
		return (elem instanceof dojo.widget.Widget) && elem.isFolder && elem.isExpanded;
	};
	if (nodeOrTree.isTreeNode) {
		this.processDescendants(nodeOrTree, filter, this.collapse);
	} else {
		if (nodeOrTree.isTree) {
			dojo.lang.forEach(nodeOrTree.children, function (c) {
				_this.processDescendants(c, filter, _this.collapse);
			});
		}
	}
}, expandToNode:function (node, withSelected) {
	n = withSelected ? node : node.parent;
	s = [];
	while (!n.isExpanded) {
		s.push(n);
		n = n.parent;
	}
	dojo.lang.forEach(s, function (n) {
		n.expand();
	});
}, expandToLevel:function (nodeOrTree, level) {
	dojo.require("dojo.widget.TreeTimeoutIterator");
	var _this = this;
	var filterFunc = function (elem) {
		var res = elem.isFolder || elem.children && elem.children.length;
		return res;
	};
	var callFunc = function (node, iterator) {
		_this.expand(node, true);
		iterator.forward();
	};
	var iterator = new dojo.widget.TreeTimeoutIterator(nodeOrTree, callFunc, this);
	iterator.setFilter(filterFunc);
	iterator.timeout = this.batchExpandTimeout;
	iterator.setMaxLevel(nodeOrTree.isTreeNode ? level - 1 : level);
	return iterator.start(nodeOrTree.isTreeNode);
}, getWidgetByNode:function (node) {
	var widgetId;
	var newNode = node;
	while (!(widgetId = newNode.widgetId)) {
		newNode = newNode.parentNode;
		if (newNode == null) {
			break;
		}
	}
	if (widgetId) {
		return dojo.widget.byId(widgetId);
	} else {
		if (node == null) {
			return null;
		} else {
			return dojo.widget.manager.byNode(node);
		}
	}
}, expand:function (node) {
	if (node.isFolder) {
		node.expand();
	}
}, collapse:function (node) {
	if (node.isFolder) {
		node.collapse();
	}
}, canEditLabel:function (node) {
	if (node.actionIsDisabledNow(node.actions.EDIT)) {
		return false;
	}
	return true;
}, editLabelStart:function (node) {
	if (!this.canEditLabel(node)) {
		return false;
	}
	if (!this.editor.isClosed()) {
		this.editLabelFinish(this.editor.saveOnBlur);
	}
	this.doEditLabelStart(node);
}, editLabelFinish:function (save) {
	this.doEditLabelFinish(save);
}, doEditLabelStart:function (node) {
	if (!this.editor) {
		dojo.raise(this.widgetType + ": no editor specified");
	}
	this.editor.open(node);
}, doEditLabelFinish:function (save, server_data) {
	if (!this.editor) {
		dojo.raise(this.widgetType + ": no editor specified");
	}
	var node = this.editor.node;
	var editorTitle = this.editor.getContents();
	this.editor.close(save);
	if (save) {
		var data = {title:editorTitle};
		if (server_data) {
			dojo.lang.mixin(data, server_data);
		}
		if (node.isPhantom) {
			var parent = node.parent;
			var index = node.getParentIndex();
			node.destroy();
			dojo.widget.TreeBasicControllerV3.prototype.doCreateChild.call(this, parent, index, data);
		} else {
			var title = server_data && server_data.title ? server_data.title : editorTitle;
			node.setTitle(title);
		}
	} else {
		if (node.isPhantom) {
			node.destroy();
		}
	}
}, makeDefaultNode:function (parent, index) {
	var data = {title:parent.tree.defaultChildTitle};
	return dojo.widget.TreeBasicControllerV3.prototype.doCreateChild.call(this, parent, index, data);
}, runStages:function (check, prepare, make, finalize, expose, args) {
	if (check && !check.apply(this, args)) {
		return false;
	}
	if (prepare && !prepare.apply(this, args)) {
		return false;
	}
	var result = make.apply(this, args);
	if (finalize) {
		finalize.apply(this, args);
	}
	if (!result) {
		return result;
	}
	if (expose) {
		expose.apply(this, args);
	}
	return result;
}});
dojo.lang.extend(dojo.widget.TreeBasicControllerV3, {createAndEdit:function (parent, index) {
	var data = {title:parent.tree.defaultChildTitle};
	if (!this.canCreateChild(parent, index, data)) {
		return false;
	}
	var child = this.doCreateChild(parent, index, data);
	if (!child) {
		return false;
	}
	this.exposeCreateChild(parent, index, data);
	child.isPhantom = true;
	if (!this.editor.isClosed()) {
		this.editLabelFinish(this.editor.saveOnBlur);
	}
	this.doEditLabelStart(child);
}});
dojo.lang.extend(dojo.widget.TreeBasicControllerV3, {canClone:function (child, newParent, index, deep) {
	return true;
}, clone:function (child, newParent, index, deep) {
	return this.runStages(this.canClone, this.prepareClone, this.doClone, this.finalizeClone, this.exposeClone, arguments);
}, exposeClone:function (child, newParent) {
	if (newParent.isTreeNode) {
		this.expand(newParent);
	}
}, doClone:function (child, newParent, index, deep) {
	var cloned = child.clone(deep);
	newParent.addChild(cloned, index);
	return cloned;
}});
dojo.lang.extend(dojo.widget.TreeBasicControllerV3, {canDetach:function (child) {
	if (child.actionIsDisabledNow(child.actions.DETACH)) {
		return false;
	}
	return true;
}, detach:function (node) {
	return this.runStages(this.canDetach, this.prepareDetach, this.doDetach, this.finalizeDetach, this.exposeDetach, arguments);
}, doDetach:function (node, callObj, callFunc) {
	node.detach();
}});
dojo.lang.extend(dojo.widget.TreeBasicControllerV3, {canDestroyChild:function (child) {
	if (child.parent && !this.canDetach(child)) {
		return false;
	}
	return true;
}, destroyChild:function (node) {
	return this.runStages(this.canDestroyChild, this.prepareDestroyChild, this.doDestroyChild, this.finalizeDestroyChild, this.exposeDestroyChild, arguments);
}, doDestroyChild:function (node) {
	node.destroy();
}});
dojo.lang.extend(dojo.widget.TreeBasicControllerV3, {canMoveNotANode:function (child, parent) {
	if (child.treeCanMove) {
		return child.treeCanMove(parent);
	}
	return true;
}, canMove:function (child, newParent) {
	if (!child.isTreeNode) {
		return this.canMoveNotANode(child, newParent);
	}
	if (child.actionIsDisabledNow(child.actions.MOVE)) {
		return false;
	}
	if (child.parent !== newParent && newParent.actionIsDisabledNow(newParent.actions.ADDCHILD)) {
		return false;
	}
	var node = newParent;
	while (node.isTreeNode) {
		if (node === child) {
			return false;
		}
		node = node.parent;
	}
	return true;
}, move:function (child, newParent, index) {
	return this.runStages(this.canMove, this.prepareMove, this.doMove, this.finalizeMove, this.exposeMove, arguments);
}, doMove:function (child, newParent, index) {
	child.tree.move(child, newParent, index);
	return true;
}, exposeMove:function (child, newParent) {
	if (newParent.isTreeNode) {
		this.expand(newParent);
	}
}});
dojo.lang.extend(dojo.widget.TreeBasicControllerV3, {canCreateChild:function (parent, index, data) {
	if (parent.actionIsDisabledNow(parent.actions.ADDCHILD)) {
		return false;
	}
	return true;
}, createChild:function (parent, index, data) {
	if (!data) {
		data = {title:parent.tree.defaultChildTitle};
	}
	return this.runStages(this.canCreateChild, this.prepareCreateChild, this.doCreateChild, this.finalizeCreateChild, this.exposeCreateChild, [parent, index, data]);
}, prepareCreateChild:function () {
	return true;
}, finalizeCreateChild:function () {
}, doCreateChild:function (parent, index, data) {
	var newChild = parent.tree.createNode(data);
	parent.addChild(newChild, index);
	return newChild;
}, exposeCreateChild:function (parent) {
	return this.expand(parent);
}});


__CPAN_FILE__ src/widget/TreeDisableWrapExtension.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.widget.TreeDisableWrapExtension");
dojo.require("dojo.widget.HtmlWidget");
dojo.require("dojo.widget.TreeExtension");
dojo.widget.defineWidget("dojo.widget.TreeDisableWrapExtension", dojo.widget.TreeExtension, {templateCssString:"\n/* CSS for TreeDisableWrapExtension */\n\n.TreeDisableWrap {\n\twhite-space: nowrap;\n}\n.TreeIEDisableWrap {\n\twidth: expression( 5 + firstChild.offsetWidth );\n}\n", templateCssPath:dojo.uri.moduleUri("dojo.widget", "templates/TreeDisableWrap.css"), listenTree:function (tree) {
	var wrappingDiv = document.createElement("div");
	var clazz = tree.classPrefix + "DisableWrap";
	if (dojo.render.html.ie) {
		clazz = clazz + " " + tree.classPrefix + "IEDisableWrap";
	}
	dojo.html.setClass(wrappingDiv, clazz);
	var table = document.createElement("table");
	wrappingDiv.appendChild(table);
	var tbody = document.createElement("tbody");
	table.appendChild(tbody);
	var tr = document.createElement("tr");
	tbody.appendChild(tr);
	var td = document.createElement("td");
	tr.appendChild(td);
	if (tree.domNode.parentNode) {
		tree.domNode.parentNode.replaceChild(wrappingDiv, tree.domNode);
	}
	td.appendChild(tree.domNode);
	tree.domNode = wrappingDiv;
}});


__CPAN_FILE__ src/widget/Toggler.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.widget.Toggler");
dojo.require("dojo.widget.*");
dojo.require("dojo.event.*");
dojo.widget.defineWidget("dojo.widget.Toggler", dojo.widget.HtmlWidget, {targetId:"", fillInTemplate:function () {
	dojo.event.connect(this.domNode, "onclick", this, "onClick");
}, onClick:function () {
	var pane = dojo.widget.byId(this.targetId);
	if (!pane) {
		return;
	}
	pane.explodeSrc = this.domNode;
	pane.toggleShowing();
}});


__CPAN_FILE__ src/widget/TreeLoadingController.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.widget.TreeLoadingController");
dojo.require("dojo.widget.TreeBasicController");
dojo.require("dojo.event.*");
dojo.require("dojo.json");
dojo.require("dojo.io.*");
dojo.widget.defineWidget("dojo.widget.TreeLoadingController", dojo.widget.TreeBasicController, {RPCUrl:"", RPCActionParam:"action", RPCErrorHandler:function (type, obj, evt) {
	alert("RPC Error: " + (obj.message || "no message"));
}, preventCache:true, getRPCUrl:function (action) {
	if (this.RPCUrl == "local") {
		var dir = document.location.href.substr(0, document.location.href.lastIndexOf("/"));
		var localUrl = dir + "/" + action;
		return localUrl;
	}
	if (!this.RPCUrl) {
		dojo.raise("Empty RPCUrl: can't load");
	}
	return this.RPCUrl + (this.RPCUrl.indexOf("?") > -1 ? "&" : "?") + this.RPCActionParam + "=" + action;
}, loadProcessResponse:function (node, result, callObj, callFunc) {
	if (!dojo.lang.isUndefined(result.error)) {
		this.RPCErrorHandler("server", result.error);
		return false;
	}
	var newChildren = result;
	if (!dojo.lang.isArray(newChildren)) {
		dojo.raise("loadProcessResponse: Not array loaded: " + newChildren);
	}
	for (var i = 0; i < newChildren.length; i++) {
		newChildren[i] = dojo.widget.createWidget(node.widgetType, newChildren[i]);
		node.addChild(newChildren[i]);
	}
	node.state = node.loadStates.LOADED;
	if (dojo.lang.isFunction(callFunc)) {
		callFunc.apply(dojo.lang.isUndefined(callObj) ? this : callObj, [node, newChildren]);
	}
}, getInfo:function (obj) {
	return obj.getInfo();
}, runRPC:function (kw) {
	var _this = this;
	var handle = function (type, data, evt) {
		if (kw.lock) {
			dojo.lang.forEach(kw.lock, function (t) {
				t.unlock();
			});
		}
		if (type == "load") {
			kw.load.call(this, data);
		} else {
			this.RPCErrorHandler(type, data, evt);
		}
	};
	if (kw.lock) {
		dojo.lang.forEach(kw.lock, function (t) {
			t.lock();
		});
	}
	dojo.io.bind({url:kw.url, handle:dojo.lang.hitch(this, handle), mimetype:"text/json", preventCache:_this.preventCache, sync:kw.sync, content:{data:dojo.json.serialize(kw.params)}});
}, loadRemote:function (node, sync, callObj, callFunc) {
	var _this = this;
	var params = {node:this.getInfo(node), tree:this.getInfo(node.tree)};
	this.runRPC({url:this.getRPCUrl("getChildren"), load:function (result) {
		_this.loadProcessResponse(node, result, callObj, callFunc);
	}, sync:sync, lock:[node], params:params});
}, expand:function (node, sync, callObj, callFunc) {
	if (node.state == node.loadStates.UNCHECKED && node.isFolder) {
		this.loadRemote(node, sync, this, function (node, newChildren) {
			this.expand(node, sync, callObj, callFunc);
		});
		return;
	}
	dojo.widget.TreeBasicController.prototype.expand.apply(this, arguments);
}, doMove:function (child, newParent, index) {
	if (newParent.isTreeNode && newParent.state == newParent.loadStates.UNCHECKED) {
		this.loadRemote(newParent, true);
	}
	return dojo.widget.TreeBasicController.prototype.doMove.apply(this, arguments);
}, doCreateChild:function (parent, index, data, callObj, callFunc) {
	if (parent.state == parent.loadStates.UNCHECKED) {
		this.loadRemote(parent, true);
	}
	return dojo.widget.TreeBasicController.prototype.doCreateChild.apply(this, arguments);
}});


__CPAN_FILE__ src/widget/RegexpTextbox.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.widget.RegexpTextbox");
dojo.require("dojo.widget.ValidationTextbox");
dojo.widget.defineWidget("dojo.widget.RegexpTextbox", dojo.widget.ValidationTextbox, {mixInProperties:function (localProperties, frag) {
	dojo.widget.RegexpTextbox.superclass.mixInProperties.apply(this, arguments);
	if (localProperties.regexp) {
		this.flags.regexp = localProperties.regexp;
	}
	if (localProperties.flags) {
		this.flags.flags = localProperties.flags;
	}
}, isValid:function () {
	var regexp = new RegExp(this.flags.regexp, this.flags.flags);
	return regexp.test(this.textbox.value);
}});


__CPAN_FILE__ src/widget/Tree.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.widget.Tree");
dojo.require("dojo.widget.*");
dojo.require("dojo.event.*");
dojo.require("dojo.io.*");
dojo.require("dojo.widget.HtmlWidget");
dojo.require("dojo.widget.TreeNode");
dojo.require("dojo.html.common");
dojo.require("dojo.html.selection");
dojo.widget.defineWidget("dojo.widget.Tree", dojo.widget.HtmlWidget, function () {
	this.eventNames = {};
	this.tree = this;
	this.DNDAcceptTypes = [];
	this.actionsDisabled = [];
}, {widgetType:"Tree", eventNamesDefault:{createDOMNode:"createDOMNode", treeCreate:"treeCreate", treeDestroy:"treeDestroy", treeClick:"treeClick", iconClick:"iconClick", titleClick:"titleClick", moveFrom:"moveFrom", moveTo:"moveTo", addChild:"addChild", removeNode:"removeNode", expand:"expand", collapse:"collapse"}, isContainer:true, DNDMode:"off", lockLevel:0, strictFolders:true, DNDModes:{BETWEEN:1, ONTO:2}, DNDAcceptTypes:"", templateCssString:"\n.dojoTree {\n\tfont: caption;\n\tfont-size: 11px;\n\tfont-weight: normal;\n\toverflow: auto;\n}\n\n\n.dojoTreeNodeLabelTitle {\n\tpadding-left: 2px;\n\tcolor: WindowText;\n}\n\n.dojoTreeNodeLabel {\n\tcursor:hand;\n\tcursor:pointer;\n}\n\n.dojoTreeNodeLabelTitle:hover {\n\ttext-decoration: underline;\n}\n\n.dojoTreeNodeLabelSelected {\n\tbackground-color: Highlight;\n\tcolor: HighlightText;\n}\n\n.dojoTree div {\n\twhite-space: nowrap;\n}\n\n.dojoTree img, .dojoTreeNodeLabel img {\n\tvertical-align: middle;\n}\n\n", templateCssPath:dojo.uri.moduleUri("dojo.widget", "templates/images/Tree/Tree.css"), templateString:"<div class=\"dojoTree\"></div>", isExpanded:true, isTree:true, objectId:"", controller:"", selector:"", menu:"", expandLevel:"", blankIconSrc:dojo.uri.moduleUri("dojo.widget", "templates/images/Tree/treenode_blank.gif"), gridIconSrcT:dojo.uri.moduleUri("dojo.widget", "templates/images/Tree/treenode_grid_t.gif"), gridIconSrcL:dojo.uri.moduleUri("dojo.widget", "templates/images/Tree/treenode_grid_l.gif"), gridIconSrcV:dojo.uri.moduleUri("dojo.widget", "templates/images/Tree/treenode_grid_v.gif"), gridIconSrcP:dojo.uri.moduleUri("dojo.widget", "templates/images/Tree/treenode_grid_p.gif"), gridIconSrcC:dojo.uri.moduleUri("dojo.widget", "templates/images/Tree/treenode_grid_c.gif"), gridIconSrcX:dojo.uri.moduleUri("dojo.widget", "templates/images/Tree/treenode_grid_x.gif"), gridIconSrcY:dojo.uri.moduleUri("dojo.widget", "templates/images/Tree/treenode_grid_y.gif"), gridIconSrcZ:dojo.uri.moduleUri("dojo.widget", "templates/images/Tree/treenode_grid_z.gif"), expandIconSrcPlus:dojo.uri.moduleUri("dojo.widget", "templates/images/Tree/treenode_expand_plus.gif"), expandIconSrcMinus:dojo.uri.moduleUri("dojo.widget", "templates/images/Tree/treenode_expand_minus.gif"), expandIconSrcLoading:dojo.uri.moduleUri("dojo.widget", "templates/images/Tree/treenode_loading.gif"), iconWidth:18, iconHeight:18, showGrid:true, showRootGrid:true, actionIsDisabled:function (action) {
	var _this = this;
	return dojo.lang.inArray(_this.actionsDisabled, action);
}, actions:{ADDCHILD:"ADDCHILD"}, getInfo:function () {
	var info = {widgetId:this.widgetId, objectId:this.objectId};
	return info;
}, initializeController:function () {
	if (this.controller != "off") {
		if (this.controller) {
			this.controller = dojo.widget.byId(this.controller);
		} else {
			dojo.require("dojo.widget.TreeBasicController");
			this.controller = dojo.widget.createWidget("TreeBasicController", {DNDController:(this.DNDMode ? "create" : ""), dieWithTree:true});
		}
		this.controller.listenTree(this);
	} else {
		this.controller = null;
	}
}, initializeSelector:function () {
	if (this.selector != "off") {
		if (this.selector) {
			this.selector = dojo.widget.byId(this.selector);
		} else {
			dojo.require("dojo.widget.TreeSelector");
			this.selector = dojo.widget.createWidget("TreeSelector", {dieWithTree:true});
		}
		this.selector.listenTree(this);
	} else {
		this.selector = null;
	}
}, initialize:function (args, frag) {
	var _this = this;
	for (name in this.eventNamesDefault) {
		if (dojo.lang.isUndefined(this.eventNames[name])) {
			this.eventNames[name] = this.widgetId + "/" + this.eventNamesDefault[name];
		}
	}
	for (var i = 0; i < this.actionsDisabled.length; i++) {
		this.actionsDisabled[i] = this.actionsDisabled[i].toUpperCase();
	}
	if (this.DNDMode == "off") {
		this.DNDMode = 0;
	} else {
		if (this.DNDMode == "between") {
			this.DNDMode = this.DNDModes.ONTO | this.DNDModes.BETWEEN;
		} else {
			if (this.DNDMode == "onto") {
				this.DNDMode = this.DNDModes.ONTO;
			}
		}
	}
	this.expandLevel = parseInt(this.expandLevel);
	this.initializeSelector();
	this.initializeController();
	if (this.menu) {
		this.menu = dojo.widget.byId(this.menu);
		this.menu.listenTree(this);
	}
	this.containerNode = this.domNode;
}, postCreate:function () {
	this.createDOMNode();
}, createDOMNode:function () {
	dojo.html.disableSelection(this.domNode);
	for (var i = 0; i < this.children.length; i++) {
		this.children[i].parent = this;
		var node = this.children[i].createDOMNode(this, 0);
		this.domNode.appendChild(node);
	}
	if (!this.showRootGrid) {
		for (var i = 0; i < this.children.length; i++) {
			this.children[i].expand();
		}
	}
	dojo.event.topic.publish(this.eventNames.treeCreate, {source:this});
}, destroy:function () {
	dojo.event.topic.publish(this.tree.eventNames.treeDestroy, {source:this});
	return dojo.widget.HtmlWidget.prototype.destroy.apply(this, arguments);
}, addChild:function (child, index) {
	var message = {child:child, index:index, parent:this, domNodeInitialized:child.domNodeInitialized};
	this.doAddChild.apply(this, arguments);
	dojo.event.topic.publish(this.tree.eventNames.addChild, message);
}, doAddChild:function (child, index) {
	if (dojo.lang.isUndefined(index)) {
		index = this.children.length;
	}
	if (!child.isTreeNode) {
		dojo.raise("You can only add TreeNode widgets to a " + this.widgetType + " widget!");
		return;
	}
	if (this.isTreeNode) {
		if (!this.isFolder) {
			this.setFolder();
		}
	}
	var _this = this;
	dojo.lang.forEach(child.getDescendants(), function (elem) {
		elem.tree = _this.tree;
	});
	child.parent = this;
	if (this.isTreeNode) {
		this.state = this.loadStates.LOADED;
	}
	if (index < this.children.length) {
		dojo.html.insertBefore(child.domNode, this.children[index].domNode);
	} else {
		this.containerNode.appendChild(child.domNode);
		if (this.isExpanded && this.isTreeNode) {
			this.showChildren();
		}
	}
	this.children.splice(index, 0, child);
	if (child.domNodeInitialized) {
		var d = this.isTreeNode ? this.depth : -1;
		child.adjustDepth(d - child.depth + 1);
		child.updateIconTree();
	} else {
		child.depth = this.isTreeNode ? this.depth + 1 : 0;
		child.createDOMNode(child.tree, child.depth);
	}
	var prevSibling = child.getPreviousSibling();
	if (child.isLastChild() && prevSibling) {
		prevSibling.updateExpandGridColumn();
	}
}, makeBlankImg:function () {
	var img = document.createElement("img");
	img.style.width = this.iconWidth + "px";
	img.style.height = this.iconHeight + "px";
	img.src = this.blankIconSrc;
	img.style.verticalAlign = "middle";
	return img;
}, updateIconTree:function () {
	if (!this.isTree) {
		this.updateIcons();
	}
	for (var i = 0; i < this.children.length; i++) {
		this.children[i].updateIconTree();
	}
}, toString:function () {
	return "[" + this.widgetType + " ID:" + this.widgetId + "]";
}, move:function (child, newParent, index) {
	var oldParent = child.parent;
	var oldTree = child.tree;
	this.doMove.apply(this, arguments);
	var newParent = child.parent;
	var newTree = child.tree;
	var message = {oldParent:oldParent, oldTree:oldTree, newParent:newParent, newTree:newTree, child:child};
	dojo.event.topic.publish(oldTree.eventNames.moveFrom, message);
	dojo.event.topic.publish(newTree.eventNames.moveTo, message);
}, doMove:function (child, newParent, index) {
	child.parent.doRemoveNode(child);
	newParent.doAddChild(child, index);
}, removeNode:function (child) {
	if (!child.parent) {
		return;
	}
	var oldTree = child.tree;
	var oldParent = child.parent;
	var removedChild = this.doRemoveNode.apply(this, arguments);
	dojo.event.topic.publish(this.tree.eventNames.removeNode, {child:removedChild, tree:oldTree, parent:oldParent});
	return removedChild;
}, doRemoveNode:function (child) {
	if (!child.parent) {
		return;
	}
	var parent = child.parent;
	var children = parent.children;
	var index = child.getParentIndex();
	if (index < 0) {
		dojo.raise("Couldn't find node " + child + " for removal");
	}
	children.splice(index, 1);
	dojo.html.removeNode(child.domNode);
	if (parent.children.length == 0 && !parent.isTree) {
		parent.containerNode.style.display = "none";
	}
	if (index == children.length && index > 0) {
		children[index - 1].updateExpandGridColumn();
	}
	if (parent instanceof dojo.widget.Tree && index == 0 && children.length > 0) {
		children[0].updateExpandGrid();
	}
	child.parent = child.tree = null;
	return child;
}, markLoading:function () {
}, unMarkLoading:function () {
}, lock:function () {
	!this.lockLevel && this.markLoading();
	this.lockLevel++;
}, unlock:function () {
	if (!this.lockLevel) {
		dojo.raise("unlock: not locked");
	}
	this.lockLevel--;
	!this.lockLevel && this.unMarkLoading();
}, isLocked:function () {
	var node = this;
	while (true) {
		if (node.lockLevel) {
			return true;
		}
		if (node instanceof dojo.widget.Tree) {
			break;
		}
		node = node.parent;
	}
	return false;
}, flushLock:function () {
	this.lockLevel = 0;
	this.unMarkLoading();
}});


__CPAN_FILE__ src/widget/Chart.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.widget.Chart");
dojo.require("dojo.widget.*");
dojo.require("dojo.gfx.color");
dojo.require("dojo.gfx.color.hsl");
dojo.declare("dojo.widget.Chart", null, function () {
	this.series = [];
}, {isContainer:false, assignColors:function () {
	var hue = 30;
	var sat = 120;
	var lum = 120;
	var steps = Math.round(330 / this.series.length);
	for (var i = 0; i < this.series.length; i++) {
		var c = dojo.gfx.color.hsl2rgb(hue, sat, lum);
		if (!this.series[i].color) {
			this.series[i].color = dojo.gfx.color.rgb2hex(c[0], c[1], c[2]);
		}
		hue += steps;
	}
}, parseData:function (table) {
	var thead = table.getElementsByTagName("thead")[0];
	var tbody = table.getElementsByTagName("tbody")[0];
	if (!(thead && tbody)) {
		dojo.raise("dojo.widget.Chart: supplied table must define a head and a body.");
	}
	var columns = thead.getElementsByTagName("tr")[0].getElementsByTagName("th");
	for (var i = 1; i < columns.length; i++) {
		var key = "column" + i;
		var label = columns[i].innerHTML;
		var plotType = columns[i].getAttribute("plotType") || "line";
		var color = columns[i].getAttribute("color");
		var ds = new dojo.widget.Chart.DataSeries(key, label, plotType, color);
		this.series.push(ds);
	}
	var rows = tbody.rows;
	var xMin = Number.MAX_VALUE, xMax = Number.MIN_VALUE;
	var yMin = Number.MAX_VALUE, yMax = Number.MIN_VALUE;
	var ignore = ["accesskey", "align", "bgcolor", "class", "colspan", "height", "id", "nowrap", "rowspan", "style", "tabindex", "title", "valign", "width"];
	for (var i = 0; i < rows.length; i++) {
		var row = rows[i];
		var cells = row.cells;
		var x = Number.MIN_VALUE;
		for (var j = 0; j < cells.length; j++) {
			if (j == 0) {
				x = parseFloat(cells[j].innerHTML);
				xMin = Math.min(xMin, x);
				xMax = Math.max(xMax, x);
			} else {
				var ds = this.series[j - 1];
				var y = parseFloat(cells[j].innerHTML);
				yMin = Math.min(yMin, y);
				yMax = Math.max(yMax, y);
				var o = {x:x, value:y};
				var attrs = cells[j].attributes;
				for (var k = 0; k < attrs.length; k++) {
					var attr = attrs.item(k);
					var bIgnore = false;
					for (var l = 0; l < ignore.length; l++) {
						if (attr.nodeName.toLowerCase() == ignore[l]) {
							bIgnore = true;
							break;
						}
					}
					if (!bIgnore) {
						o[attr.nodeName] = attr.nodeValue;
					}
				}
				ds.add(o);
			}
		}
	}
	return {x:{min:xMin, max:xMax}, y:{min:yMin, max:yMax}};
}});
dojo.declare("dojo.widget.Chart.DataSeries", null, function (key, label, plotType, color) {
	this.id = "DataSeries" + dojo.widget.Chart.DataSeries.count++;
	this.key = key;
	this.label = label || this.id;
	this.plotType = plotType || "line";
	this.color = color;
	this.values = [];
}, {add:function (v) {
	if (v.x == null || v.value == null) {
		dojo.raise("dojo.widget.Chart.DataSeries.add: v must have both an 'x' and 'value' property.");
	}
	this.values.push(v);
}, clear:function () {
	this.values = [];
}, createRange:function (len) {
	var idx = this.values.length - 1;
	var length = (len || this.values.length);
	return {"index":idx, "length":length, "start":Math.max(idx - length, 0)};
}, getMean:function (len) {
	var range = this.createRange(len);
	if (range.index < 0) {
		return 0;
	}
	var t = 0;
	var c = 0;
	for (var i = range.index; i >= range.start; i--) {
		var n = parseFloat(this.values[i].value);
		if (!isNaN(n)) {
			t += n;
			c++;
		}
	}
	t /= Math.max(c, 1);
	return t;
}, getMovingAverage:function (len) {
	var range = this.createRange(len);
	if (range.index < 0) {
		return 0;
	}
	var t = 0;
	var c = 0;
	for (var i = range.index; i >= range.start; i--) {
		var n = parseFloat(this.values[i].value);
		if (!isNaN(n)) {
			t += n;
			c++;
		}
	}
	t /= Math.max(c, 1);
	return t;
}, getVariance:function (len) {
	var range = this.createRange(len);
	if (range.index < 0) {
		return 0;
	}
	var t = 0;
	var s = 0;
	var c = 0;
	for (var i = range.index; i >= range.start; i--) {
		var n = parseFloat(this.values[i].value);
		if (!isNaN(n)) {
			t += n;
			s += Math.pow(n, 2);
			c++;
		}
	}
	return (s / c) - Math.pow(t / c, 2);
}, getStandardDeviation:function (len) {
	return Math.sqrt(this.getVariance(len));
}, getMax:function (len) {
	var range = this.createRange(len);
	if (range.index < 0) {
		return 0;
	}
	var t = 0;
	for (var i = range.index; i >= range.start; i--) {
		var n = parseFloat(this.values[i].value);
		if (!isNaN(n)) {
			t = Math.max(n, t);
		}
	}
	return t;
}, getMin:function (len) {
	var range = this.createRange(len);
	if (range.index < 0) {
		return 0;
	}
	var t = 0;
	for (var i = range.index; i >= range.start; i--) {
		var n = parseFloat(this.values[i].value);
		if (!isNaN(n)) {
			t = Math.min(n, t);
		}
	}
	return t;
}, getMedian:function (len) {
	var range = this.createRange(len);
	if (range.index < 0) {
		return 0;
	}
	var a = [];
	for (var i = range.index; i >= range.start; i--) {
		var n = parseFloat(this.values[i].value);
		if (!isNaN(n)) {
			var b = false;
			for (var j = 0; j < a.length && !b; j++) {
				if (n == a[j]) {
					b = true;
				}
			}
			if (!b) {
				a.push(n);
			}
		}
	}
	a.sort();
	if (a.length > 0) {
		return a[Math.ceil(a.length / 2)];
	}
	return 0;
}, getMode:function (len) {
	var range = this.createRange(len);
	if (range.index < 0) {
		return 0;
	}
	var o = {};
	var ret = 0;
	var m = 0;
	for (var i = range.index; i >= range.start; i--) {
		var n = parseFloat(this.values[i].value);
		if (!isNaN(n)) {
			if (!o[this.values[i].value]) {
				o[this.values[i].value] = 1;
			} else {
				o[this.values[i].value]++;
			}
		}
	}
	for (var p in o) {
		if (m < o[p]) {
			m = o[p];
			ret = p;
		}
	}
	return parseFloat(ret);
}});
dojo.requireIf(dojo.render.svg.capable, "dojo.widget.svg.Chart");
dojo.requireIf(!dojo.render.svg.capable && dojo.render.vml.capable, "dojo.widget.vml.Chart");


__CPAN_FILE__ src/widget/Textbox.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.widget.Textbox");
dojo.require("dojo.widget.*");
dojo.require("dojo.widget.HtmlWidget");
dojo.require("dojo.widget.Manager");
dojo.require("dojo.widget.Parse");
dojo.require("dojo.xml.Parse");
dojo.require("dojo.lang.array");
dojo.require("dojo.lang.common");
dojo.require("dojo.i18n.common");
dojo.requireLocalization("dojo.widget", "validate", null, "fr,ja,zh-cn,ROOT");
dojo.widget.defineWidget("dojo.widget.Textbox", dojo.widget.HtmlWidget, {className:"", name:"", value:"", type:"", trim:false, uppercase:false, lowercase:false, ucFirst:false, digit:false, htmlfloat:"none", templateString:"<span style='float:${this.htmlfloat};'>\n\t<input dojoAttachPoint='textbox' dojoAttachEvent='onblur;onfocus'\n\t\tid='${this.widgetId}' name='${this.name}'\n\t\tclass='${this.className}' type='${this.type}' >\n</span>\n", textbox:null, fillInTemplate:function () {
	this.textbox.value = this.value;
}, filter:function () {
	if (this.trim) {
		this.textbox.value = this.textbox.value.replace(/(^\s*|\s*$)/g, "");
	}
	if (this.uppercase) {
		this.textbox.value = this.textbox.value.toUpperCase();
	}
	if (this.lowercase) {
		this.textbox.value = this.textbox.value.toLowerCase();
	}
	if (this.ucFirst) {
		this.textbox.value = this.textbox.value.replace(/\b\w+\b/g, function (word) {
			return word.substring(0, 1).toUpperCase() + word.substring(1).toLowerCase();
		});
	}
	if (this.digit) {
		this.textbox.value = this.textbox.value.replace(/\D/g, "");
	}
}, onfocus:function () {
}, onblur:function () {
	this.filter();
}, mixInProperties:function (localProperties, frag) {
	dojo.widget.Textbox.superclass.mixInProperties.apply(this, arguments);
	if (localProperties["class"]) {
		this.className = localProperties["class"];
	}
}});


__CPAN_FILE__ src/widget/TreeExtension.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.widget.TreeExtension");
dojo.require("dojo.widget.HtmlWidget");
dojo.require("dojo.widget.TreeCommon");
dojo.widget.defineWidget("dojo.widget.TreeExtension", [dojo.widget.HtmlWidget, dojo.widget.TreeCommon], function () {
	this.listenedTrees = {};
}, {});


__CPAN_FILE__ src/widget/GoogleMap.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.widget.GoogleMap");
dojo.require("dojo.event.*");
dojo.require("dojo.math");
dojo.require("dojo.widget.*");
dojo.require("dojo.uri.Uri");
dojo.require("dojo.widget.HtmlWidget");
(function () {
	var gkey = djConfig["gMapKey"] || djConfig["googleMapKey"];
	var uri = new dojo.uri.Uri(window.location.href);
	if (uri.host == "www.dojotoolkit.org") {
		gkey = "ABQIAAAACUNdgv_7FGOmUslbm9l6_hRqjp7ri2mNiOEYqetD3xnFHpt5rBSjszDd1sdufPyQKUTyCf_YxoIxvw";
	} else {
		if (uri.host == "blog.dojotoolkit.org") {
			gkey = "ABQIAAAACUNdgv_7FGOmUslbm9l6_hSkep6Av1xaMhVn3yCLkorJeXeLARQ6fammI_P3qSGleTJhoI5_1JmP_Q";
		} else {
			if (uri.host == "archive.dojotoolkit.org") {
				gkey = "ABQIAAAACUNdgv_7FGOmUslbm9l6_hTaQpDt0dyGLIHbXMPTzg1kWeAfwRTwZNyrUfbfxYE9yIvRivEjcXoDTg";
			} else {
				if (uri.host == "dojotoolkit.org") {
					gkey = "ABQIAAAACUNdgv_7FGOmUslbm9l6_hSaOaO_TgJ5c3mtQFnk5JO2zD5dZBRZk-ieqVs7BORREYNzAERmcJoEjQ";
				}
			}
		}
	}
	if (!dojo.hostenv.post_load_) {
		if (!gkey || gkey == "") {
			dojo.raise("dojo.widget.GoogleMap: The Google Map widget requires a proper API key in order to be used.");
		}
		var tag = "<scr" + "ipt src='http://maps.google.com/maps?file=api&amp;v=2&amp;key=" + gkey + "'></scri" + "pt>";
		if (!dj_global["GMap2"]) {
			document.write(tag);
		}
	} else {
		dojo.debug("Cannot initialize Google Map system after the page has been loaded! Please either manually include the script block provided by Google in your page or require() the GoogleMap widget before onload has fired.");
	}
})();
dojo.widget.defineWidget("dojo.widget.GoogleMap", dojo.widget.HtmlWidget, function () {
	this.map = null;
	this.geocoder = null;
	this.data = [];
	this.datasrc = "";
	this.controls = ["largemap", "scale", "maptype"];
}, {templatePath:null, templateCssPath:null, isContainer:false, _defaultPoint:{lat:39.10662, lng:-94.578209}, setControls:function () {
	var methodmap = {largemap:GLargeMapControl, smallmap:GSmallMapControl, smallzoom:GSmallZoomControl, scale:GScaleControl, maptype:GMapTypeControl, overview:GOverviewMapControl};
	for (var i = 0; i < this.controls.length; i++) {
		this.map.addControl(new (methodmap[this.controls[i].toLowerCase()])());
	}
}, findCenter:function (bounds) {
	if (this.data.length == 1) {
		return (new GLatLng(this.data[0].lat, this.data[0].lng));
	}
	var clat = (bounds.getNorthEast().lat() + bounds.getSouthWest().lat()) / 2;
	var clng = (bounds.getNorthEast().lng() + bounds.getSouthWest().lng()) / 2;
	return (new GLatLng(clat, clng));
}, createPinpoint:function (pt, overlay) {
	var m = new GMarker(pt);
	if (overlay) {
		GEvent.addListener(m, "click", function () {
			m.openInfoWindowHtml("<div>" + overlay + "</div>");
		});
	}
	return m;
}, plot:function (obj) {
	var p = new GLatLng(obj.lat, obj.lng);
	var d = obj.description || null;
	var m = this.createPinpoint(p, d);
	this.map.addOverlay(m);
}, plotAddress:function (address) {
	var self = this;
	this.geocoder.getLocations(address, function (response) {
		if (!response || response.Status.code != 200) {
			alert("The address \"" + address + "\" was not found.");
			return;
		}
		var obj = {lat:response.Placemark[0].Point.coordinates[1], lng:response.Placemark[0].Point.coordinates[0], description:response.Placemark[0].address};
		self.data.push(obj);
		self.render();
	});
}, parse:function (table) {
	this.data = [];
	var h = table.getElementsByTagName("thead")[0];
	if (!h) {
		return;
	}
	var a = [];
	var cols = h.getElementsByTagName("td");
	if (cols.length == 0) {
		cols = h.getElementsByTagName("th");
	}
	for (var i = 0; i < cols.length; i++) {
		var c = cols[i].innerHTML.toLowerCase();
		if (c == "long") {
			c = "lng";
		}
		a.push(c);
	}
	var b = table.getElementsByTagName("tbody")[0];
	if (!b) {
		return;
	}
	for (var i = 0; i < b.childNodes.length; i++) {
		if (!(b.childNodes[i].nodeName && b.childNodes[i].nodeName.toLowerCase() == "tr")) {
			continue;
		}
		var cells = b.childNodes[i].getElementsByTagName("td");
		var o = {};
		for (var j = 0; j < a.length; j++) {
			var col = a[j];
			if (col == "lat" || col == "lng") {
				o[col] = parseFloat(cells[j].innerHTML);
			} else {
				o[col] = cells[j].innerHTML;
			}
		}
		this.data.push(o);
	}
}, render:function () {
	if (this.data.length == 0) {
		this.map.setCenter(new GLatLng(this._defaultPoint.lat, this._defaultPoint.lng), 4);
		return;
	}
	this.map.clearOverlays();
	var bounds = new GLatLngBounds();
	var d = this.data;
	for (var i = 0; i < d.length; i++) {
		bounds.extend(new GLatLng(d[i].lat, d[i].lng));
	}
	var zoom = Math.min((this.map.getBoundsZoomLevel(bounds) - 1), 14);
	this.map.setCenter(this.findCenter(bounds), zoom);
	for (var i = 0; i < this.data.length; i++) {
		this.plot(this.data[i]);
	}
}, initialize:function (args, frag) {
	if (this.datasrc) {
		this.parse(dojo.byId(this.datasrc));
	} else {
		if (this.domNode.getElementsByTagName("table")[0]) {
			this.parse(this.domNode.getElementsByTagName("table")[0]);
		}
	}
}, postCreate:function () {
	while (this.domNode.childNodes.length > 0) {
		this.domNode.removeChild(this.domNode.childNodes[0]);
	}
	if (this.domNode.style.position != "absolute") {
		this.domNode.style.position = "relative";
	}
	this.map = new GMap2(this.domNode);
	try {
		this.geocoder = new GClientGeocoder();
	}
	catch (ex) {
	}
	this.render();
	this.setControls();
}});


__CPAN_FILE__ src/widget/MonthlyCalendar.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.widget.MonthlyCalendar");
dojo.require("dojo.date.common");
dojo.require("dojo.date.format");
dojo.require("dojo.widget.*");
dojo.require("dojo.widget.DatePicker");
dojo.require("dojo.event.*");
dojo.require("dojo.html.*");
dojo.require("dojo.experimental");
dojo.experimental("dojo.widget.MonthlyCalendar");
dojo.widget.defineWidget("dojo.widget.MonthlyCalendar", dojo.widget.DatePicker, {dayWidth:"wide", templateString:"<div class=\"datePickerContainer\" dojoAttachPoint=\"datePickerContainerNode\">\n\t<h3 class=\"monthLabel\">\n\t<!--\n\t<span \n\t\tdojoAttachPoint=\"decreaseWeekNode\" \n\t\tdojoAttachEvent=\"onClick: onIncrementWeek;\" \n\t\tclass=\"incrementControl\">\n\t\t<img src=\"${dojoWidgetModuleUri}templates/decrementWeek.gif\" alt=\"&uarr;\" />\n\t</span>\n\t-->\n\t<span \n\t\tdojoAttachPoint=\"decreaseMonthNode\" \n\t\tdojoAttachEvent=\"onClick: onIncrementMonth;\" class=\"incrementControl\">\n\t\t<img src=\"${dojoWidgetModuleUri}templates/decrementMonth.gif\" \n\t\t\talt=\"&uarr;\" dojoAttachPoint=\"decrementMonthImageNode\">\n\t</span>\n\t<span dojoAttachPoint=\"monthLabelNode\" class=\"month\">July</span>\n\t<span \n\t\tdojoAttachPoint=\"increaseMonthNode\" \n\t\tdojoAttachEvent=\"onClick: onIncrementMonth;\" class=\"incrementControl\">\n\t\t<img src=\"${dojoWidgetModuleUri}templates/incrementMonth.gif\" \n\t\t\talt=\"&darr;\"  dojoAttachPoint=\"incrementMonthImageNode\">\n\t</span>\n\t<!--\n\t\t<span dojoAttachPoint=\"increaseWeekNode\" \n\t\t\tdojoAttachEvent=\"onClick: onIncrementWeek;\" \n\t\t\tclass=\"incrementControl\">\n\t\t\t<img src=\"${dojoWidgetModuleUri}templates/incrementWeek.gif\" \n\t\t\talt=\"&darr;\" />\n\t\t</span>\n\t-->\n\t</h3>\n\t<table class=\"calendarContainer\">\n\t\t<thead>\n\t\t\t<tr dojoAttachPoint=\"dayLabelsRow\">\n\t\t\t\t<td></td>\n\t\t\t\t<td></td>\n\t\t\t\t<td></td>\n\t\t\t\t<td></td>\n\t\t\t\t<td></td>\n\t\t\t\t<td></td>\n\t\t\t\t<td></td>\n\t\t\t</tr>\n\t\t</thead>\n\t\t<tbody dojoAttachPoint=\"calendarDatesContainerNode\" \n\t\t\tdojoAttachEvent=\"onClick: onSetDate;\">\n\t\t\t<tr dojoAttachPoint=\"calendarRow0\">\n\t\t\t\t<td></td>\n\t\t\t\t<td></td>\n\t\t\t\t<td></td>\n\t\t\t\t<td></td>\n\t\t\t\t<td></td>\n\t\t\t\t<td></td>\n\t\t\t\t<td></td>\n\t\t\t</tr>\n\t\t\t<tr dojoAttachPoint=\"calendarRow1\">\n\t\t\t\t<td></td>\n\t\t\t\t<td></td>\n\t\t\t\t<td></td>\n\t\t\t\t<td></td>\n\t\t\t\t<td></td>\n\t\t\t\t<td></td>\n\t\t\t\t<td></td>\n\t\t\t</tr>\n\t\t\t<tr dojoAttachPoint=\"calendarRow2\">\n\t\t\t\t<td></td>\n\t\t\t\t<td></td>\n\t\t\t\t<td></td>\n\t\t\t\t<td></td>\n\t\t\t\t<td></td>\n\t\t\t\t<td></td>\n\t\t\t\t<td></td>\n\t\t\t</tr>\n\t\t\t<tr dojoAttachPoint=\"calendarRow3\">\n\t\t\t\t<td></td>\n\t\t\t\t<td></td>\n\t\t\t\t<td></td>\n\t\t\t\t<td></td>\n\t\t\t\t<td></td>\n\t\t\t\t<td></td>\n\t\t\t\t<td></td>\n\t\t\t</tr>\n\t\t\t<tr dojoAttachPoint=\"calendarRow4\">\n\t\t\t\t<td></td>\n\t\t\t\t<td></td>\n\t\t\t\t<td></td>\n\t\t\t\t<td></td>\n\t\t\t\t<td></td>\n\t\t\t\t<td></td>\n\t\t\t\t<td></td>\n\t\t\t</tr>\n\t\t\t<tr dojoAttachPoint=\"calendarRow5\">\n\t\t\t\t<td></td>\n\t\t\t\t<td></td>\n\t\t\t\t<td></td>\n\t\t\t\t<td></td>\n\t\t\t\t<td></td>\n\t\t\t\t<td></td>\n\t\t\t\t<td></td>\n\t\t\t</tr>\n\t\t</tbody>\n\t</table>\n\t<h3 class=\"yearLabel\">\n\t\t<span dojoAttachPoint=\"previousYearLabelNode\"\n\t\t\tdojoAttachEvent=\"onClick: onIncrementYear;\" class=\"previousYear\"></span>\n\t\t<span class=\"selectedYear\" dojoAttachPoint=\"currentYearLabelNode\"></span>\n\t\t<span dojoAttachPoint=\"nextYearLabelNode\" \n\t\t\tdojoAttachEvent=\"onClick: onIncrementYear;\" class=\"nextYear\"></span>\n\t</h3>\n</div>\n", templateCssString:".datePickerContainer {\n\tmargin:0.5em 2em 0.5em 0;\n\t/*width:10em;*/\n\tfloat:left;\n}\n\n.previousMonth {\n\tbackground-color:#bbbbbb;\n}\n\n.currentMonth {\n\tbackground-color:#8f8f8f;\n}\n\n.nextMonth {\n\tbackground-color:#eeeeee;\n}\n\n.currentDate {\n\ttext-decoration:underline;\n\tfont-style:italic;\n}\n\n.selectedItem {\n\tbackground-color:#3a3a3a;\n\tcolor:#ffffff;\n}\n\n.calendarContainer {\n\tborder-collapse:collapse;\n\tborder-spacing:0;\n\tborder-bottom:1px solid #e6e6e6;\n\toverflow: hidden;\n\ttext-align: right;\n}\n\n.calendarContainer thead{\n\tborder-bottom:1px solid #e6e6e6;\n}\n\n.calendarContainer tbody * td {\n		height: 100px;\n		border: 1px solid gray;\n}\n\n.calendarContainer td {\n		width: 100px;\n		padding: 2px;\n\tvertical-align: top;\n}\n\n.monthLabel {\n\tfont-size:0.9em;\n\tfont-weight:400;\n\tmargin:0;\n\ttext-align:center;\n}\n\n.monthLabel .month {\n\tpadding:0 0.4em 0 0.4em;\n}\n\n.yearLabel {\n\tfont-size:0.9em;\n\tfont-weight:400;\n\tmargin:0.25em 0 0 0;\n\ttext-align:right;\n\tcolor:#a3a3a3;\n}\n\n.yearLabel .selectedYear {\n\tcolor:#000;\n\tpadding:0 0.2em;\n}\n\n.nextYear, .previousYear {\n\tcursor:pointer;cursor:hand;\n}\n\n.incrementControl {\n\tcursor:pointer;cursor:hand;\n\twidth:1em;\n}\n\n.dojoMonthlyCalendarEvent {\n\tfont-size:0.7em;\n\toverflow: hidden;\n\tfont-color: grey;\n\twhite-space: nowrap;\n\ttext-align: left;\n}\n", templateCssPath:dojo.uri.moduleUri("dojo.widget", "templates/MonthlyCalendar.css"), initializer:function () {
	this.iCalendars = [];
}, addCalendar:function (cal) {
	dojo.debug("Adding Calendar");
	this.iCalendars.push(cal);
	dojo.debug("Starting init");
	this.initUI();
	dojo.debug("done init");
}, createDayContents:function (node, mydate) {
	dojo.html.removeChildren(node);
	node.appendChild(document.createTextNode(mydate.getDate()));
	for (var x = 0; x < this.iCalendars.length; x++) {
		var evts = this.iCalendars[x].getEvents(mydate);
		if ((dojo.lang.isArray(evts)) && (evts.length > 0)) {
			for (var y = 0; y < evts.length; y++) {
				var el = document.createElement("div");
				dojo.html.addClass(el, "dojoMonthlyCalendarEvent");
				el.appendChild(document.createTextNode(evts[y].summary.value));
				el.width = dojo.html.getContentBox(node).width;
				node.appendChild(el);
			}
		}
	}
}, initUI:function () {
	var dayLabels = dojo.date.getNames("days", this.dayWidth, "standAlone", this.lang);
	var dayLabelNodes = this.dayLabelsRow.getElementsByTagName("td");
	for (var i = 0; i < 7; i++) {
		dayLabelNodes.item(i).innerHTML = dayLabels[i];
	}
	this.selectedIsUsed = false;
	this.currentIsUsed = false;
	var currentClassName = "";
	var previousDate = new Date();
	var calendarNodes = this.calendarDatesContainerNode.getElementsByTagName("td");
	var currentCalendarNode;
	previousDate.setHours(8);
	var nextDate = new Date(this.firstSaturday.year, this.firstSaturday.month, this.firstSaturday.date, 8);
	var lastDay = new Date(this.firstSaturday.year, this.firstSaturday.month, this.firstSaturday.date + 42, 8);
	if (this.iCalendars.length > 0) {
		for (var x = 0; x < this.iCalendars.length; x++) {
			this.iCalendars[x].preComputeRecurringEvents(lastDay);
		}
	}
	if (this.firstSaturday.date < 7) {
		var dayInWeek = 6;
		for (var i = this.firstSaturday.date; i > 0; i--) {
			currentCalendarNode = calendarNodes.item(dayInWeek);
			this.createDayContents(currentCalendarNode, nextDate);
			dojo.html.setClass(currentCalendarNode, this.getDateClassName(nextDate, "current"));
			dayInWeek--;
			previousDate = nextDate;
			nextDate = this.incrementDate(nextDate, false);
		}
		for (var i = dayInWeek; i > -1; i--) {
			currentCalendarNode = calendarNodes.item(i);
			this.createDayContents(currentCalendarNode, nextDate);
			dojo.html.setClass(currentCalendarNode, this.getDateClassName(nextDate, "previous"));
			previousDate = nextDate;
			nextDate = this.incrementDate(nextDate, false);
		}
	} else {
		nextDate.setDate(1);
		for (var i = 0; i < 7; i++) {
			currentCalendarNode = calendarNodes.item(i);
			this.createDayContents(currentCalendarNode, nextDate);
			dojo.html.setClass(currentCalendarNode, this.getDateClassName(nextDate, "current"));
			previousDate = nextDate;
			nextDate = this.incrementDate(nextDate, true);
		}
	}
	previousDate.setDate(this.firstSaturday.date);
	previousDate.setMonth(this.firstSaturday.month);
	previousDate.setFullYear(this.firstSaturday.year);
	nextDate = this.incrementDate(previousDate, true);
	var count = 7;
	currentCalendarNode = calendarNodes.item(count);
	while ((nextDate.getMonth() == previousDate.getMonth()) && (count < 42)) {
		this.createDayContents(currentCalendarNode, nextDate);
		dojo.html.setClass(currentCalendarNode, this.getDateClassName(nextDate, "current"));
		currentCalendarNode = calendarNodes.item(++count);
		previousDate = nextDate;
		nextDate = this.incrementDate(nextDate, true);
	}
	while (count < 42) {
		this.createDayContents(currentCalendarNode, nextDate);
		dojo.html.setClass(currentCalendarNode, this.getDateClassName(nextDate, "next"));
		currentCalendarNode = calendarNodes.item(++count);
		previousDate = nextDate;
		nextDate = this.incrementDate(nextDate, true);
	}
	this.setMonthLabel(this.firstSaturday.month);
	this.setYearLabels(this.firstSaturday.year);
}});
dojo.widget.MonthlyCalendar.util = new function () {
	this.toRfcDate = function (jsDate) {
		if (!jsDate) {
			jsDate = this.today;
		}
		var year = jsDate.getFullYear();
		var month = jsDate.getMonth() + 1;
		if (month < 10) {
			month = "0" + month.toString();
		}
		var date = jsDate.getDate();
		if (date < 10) {
			date = "0" + date.toString();
		}
		return year + "-" + month + "-" + date + "T00:00:00+00:00";
	};
	this.fromRfcDate = function (rfcDate) {
		var tempDate = rfcDate.split("-");
		if (tempDate.length < 3) {
			return new Date();
		}
		return new Date(parseInt(tempDate[0]), (parseInt(tempDate[1], 10) - 1), parseInt(tempDate[2].substr(0, 2), 10));
	};
	this.initFirstSaturday = function (month, year) {
		if (!month) {
			month = this.date.getMonth();
		}
		if (!year) {
			year = this.date.getFullYear();
		}
		var firstOfMonth = new Date(year, month, 1);
		return {year:year, month:month, date:7 - firstOfMonth.getDay()};
	};
};


__CPAN_FILE__ src/widget/TreeWithNode.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.require("dojo.lang.declare");
dojo.provide("dojo.widget.TreeWithNode");
dojo.declare("dojo.widget.TreeWithNode", null, function () {
}, {loadStates:{UNCHECKED:"UNCHECKED", LOADING:"LOADING", LOADED:"LOADED"}, state:"UNCHECKED", objectId:"", isContainer:true, lockLevel:0, lock:function () {
	this.lockLevel++;
}, unlock:function () {
	if (!this.lockLevel) {
		dojo.raise(this.widgetType + " unlock: not locked");
	}
	this.lockLevel--;
}, expandLevel:0, loadLevel:0, hasLock:function () {
	return this.lockLevel > 0;
}, isLocked:function () {
	var node = this;
	while (true) {
		if (node.lockLevel) {
			return true;
		}
		if (!node.parent || node.isTree) {
			break;
		}
		node = node.parent;
	}
	return false;
}, flushLock:function () {
	this.lockLevel = 0;
}, actionIsDisabled:function (action) {
	var disabled = false;
	if (dojo.lang.inArray(this.actionsDisabled, action)) {
		disabled = true;
	}
	if (this.isTreeNode) {
		if (!this.tree.allowAddChildToLeaf && action == this.actions.ADDCHILD && !this.isFolder) {
			disabled = true;
		}
	}
	return disabled;
}, actionIsDisabledNow:function (action) {
	return this.actionIsDisabled(action) || this.isLocked();
}, setChildren:function (childrenArray) {
	if (this.isTreeNode && !this.isFolder) {
		this.setFolder();
	} else {
		if (this.isTreeNode) {
			this.state = this.loadStates.LOADED;
		}
	}
	var hadChildren = this.children.length > 0;
	if (hadChildren && childrenArray) {
		this.destroyChildren();
	}
	if (childrenArray) {
		this.children = childrenArray;
	}
	var hasChildren = this.children.length > 0;
	if (this.isTreeNode && hasChildren != hadChildren) {
		this.viewSetHasChildren();
	}
	for (var i = 0; i < this.children.length; i++) {
		var child = this.children[i];
		if (!(child instanceof dojo.widget.Widget)) {
			child = this.children[i] = this.tree.createNode(child);
			var childWidgetCreated = true;
		} else {
			var childWidgetCreated = false;
		}
		if (!child.parent) {
			child.parent = this;
			if (this.tree !== child.tree) {
				child.updateTree(this.tree);
			}
			child.viewAddLayout();
			this.containerNode.appendChild(child.domNode);
			var message = {child:child, index:i, parent:this, childWidgetCreated:childWidgetCreated};
			delete dojo.widget.manager.topWidgets[child.widgetId];
			dojo.event.topic.publish(this.tree.eventNames.afterAddChild, message);
		}
		if (this.tree.eagerWidgetInstantiation) {
			dojo.lang.forEach(this.children, function (child) {
				child.setChildren();
			});
		}
	}
}, doAddChild:function (child, index) {
	return this.addChild(child, index, true);
}, addChild:function (child, index, dontPublishEvent) {
	if (dojo.lang.isUndefined(index)) {
		index = this.children.length;
	}
	if (!child.isTreeNode) {
		dojo.raise("You can only add TreeNode widgets to a " + this.widgetType + " widget!");
		return;
	}
	this.children.splice(index, 0, child);
	child.parent = this;
	child.addedTo(this, index, dontPublishEvent);
	delete dojo.widget.manager.topWidgets[child.widgetId];
}, onShow:function () {
	this.animationInProgress = false;
}, onHide:function () {
	this.animationInProgress = false;
}});


__CPAN_FILE__ src/widget/RadioGroup.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.widget.RadioGroup");
dojo.require("dojo.lang.common");
dojo.require("dojo.event.browser");
dojo.require("dojo.html.selection");
dojo.require("dojo.widget.*");
dojo.require("dojo.widget.HtmlWidget");
dojo.widget.defineWidget("dojo.widget.RadioGroup", dojo.widget.HtmlWidget, function () {
	this.selectedItem = null;
	this.items = [];
	this.selected = [];
	this.groupCssClass = "radioGroup";
	this.selectedCssClass = "selected";
	this.itemContentCssClass = "itemContent";
}, {isContainer:false, templatePath:null, templateCssPath:null, postCreate:function () {
	this._parseStructure();
	dojo.html.addClass(this.domNode, this.groupCssClass);
	this._setupChildren();
	dojo.event.browser.addListener(this.domNode, "onclick", dojo.lang.hitch(this, "onSelect"));
	if (this.selectedItem) {
		this._selectItem(this.selectedItem);
	}
}, _parseStructure:function () {
	if (this.domNode.tagName.toLowerCase() != "ul" && this.domNode.tagName.toLowerCase() != "ol") {
		dojo.raise("RadioGroup: Expected ul or ol content.");
		return;
	}
	this.items = [];
	var nl = this.domNode.getElementsByTagName("li");
	for (var i = 0; i < nl.length; i++) {
		if (nl[i].parentNode == this.domNode) {
			this.items.push(nl[i]);
		}
	}
}, add:function (node) {
	if (node.parentNode != this.domNode) {
		this.domNode.appendChild(node);
	}
	this.items.push(node);
	this._setup(node);
}, remove:function (node) {
	var idx = -1;
	for (var i = 0; i < this.items.length; i++) {
		if (this.items[i] == node) {
			idx = i;
			break;
		}
	}
	if (idx < 0) {
		return;
	}
	this.items.splice(idx, 1);
	node.parentNode.removeChild(node);
}, clear:function () {
	for (var i = 0; i < this.items.length; i++) {
		this.domNode.removeChild(this.items[i]);
	}
	this.items = [];
}, clearSelections:function () {
	for (var i = 0; i < this.items.length; i++) {
		dojo.html.removeClass(this.items[i], this.selectedCssClass);
	}
	this.selectedItem = null;
}, _setup:function (node) {
	var span = document.createElement("span");
	dojo.html.disableSelection(span);
	dojo.html.addClass(span, this.itemContentCssClass);
	dojo.dom.moveChildren(node, span);
	node.appendChild(span);
	if (this.selected.length > 0) {
		var uid = dojo.html.getAttribute(node, "id");
		if (uid && uid == this.selected) {
			this.selectedItem = node;
		}
	}
	dojo.event.browser.addListener(node, "onclick", dojo.lang.hitch(this, "onItemSelect"));
	if (dojo.html.hasAttribute(node, "onitemselect")) {
		var tn = dojo.lang.nameAnonFunc(new Function(dojo.html.getAttribute(node, "onitemselect")), this);
		dojo.event.browser.addListener(node, "onclick", dojo.lang.hitch(this, tn));
	}
}, _setupChildren:function () {
	for (var i = 0; i < this.items.length; i++) {
		this._setup(this.items[i]);
	}
}, _selectItem:function (node, event, nofire) {
	if (this.selectedItem) {
		dojo.html.removeClass(this.selectedItem, this.selectedCssClass);
	}
	this.selectedItem = node;
	dojo.html.addClass(this.selectedItem, this.selectedCssClass);
	if (!dj_undef("currentTarget", event)) {
		return;
	}
	if (!nofire) {
		if (dojo.render.html.ie) {
			this.selectedItem.fireEvent("onclick");
		} else {
			var e = document.createEvent("MouseEvents");
			e.initEvent("click", true, false);
			this.selectedItem.dispatchEvent(e);
		}
	}
}, getValue:function () {
	return this.selectedItem;
}, onSelect:function (e) {
}, onItemSelect:function (e) {
	if (!dj_undef("currentTarget", e)) {
		this._selectItem(e.currentTarget, e);
	}
}});


__CPAN_FILE__ src/widget/Repeater.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.widget.Repeater");
dojo.require("dojo.widget.HtmlWidget");
dojo.require("dojo.string");
dojo.require("dojo.event.*");
dojo.require("dojo.experimental");
dojo.experimental("dojo.widget.Repeater");
dojo.widget.defineWidget("dojo.widget.Repeater", dojo.widget.HtmlWidget, {name:"", rowTemplate:"", myObject:null, pattern:"", useDnd:false, isContainer:true, initialize:function (args, frag) {
	var node = this.getFragNodeRef(frag);
	node.removeAttribute("dojotype");
	this.setRow(dojo.string.trim(node.innerHTML), {});
	node.innerHTML = "";
	frag = null;
}, postCreate:function (args, frag) {
	if (this.useDnd) {
		dojo.require("dojo.dnd.*");
		var dnd = new dojo.dnd.HtmlDropTarget(this.domNode, [this.widgetId]);
	}
}, _reIndexRows:function () {
	for (var i = 0, len = this.domNode.childNodes.length; i < len; i++) {
		var elems = ["INPUT", "SELECT", "TEXTAREA"];
		for (var k = 0; k < elems.length; k++) {
			var list = this.domNode.childNodes[i].getElementsByTagName(elems[k]);
			for (var j = 0, len2 = list.length; j < len2; j++) {
				var name = list[j].name;
				var index = dojo.string.escape("regexp", this.pattern);
				index = index.replace(/(%\\\{index\\\})/g, "%{index}");
				var nameRegexp = dojo.string.substituteParams(index, {"index":"[0-9]*"});
				var newName = dojo.string.substituteParams(this.pattern, {"index":"" + i});
				var re = new RegExp(nameRegexp, "g");
				list[j].name = name.replace(re, newName);
			}
		}
	}
}, onDeleteRow:function (e) {
	var index = dojo.string.escape("regexp", this.pattern);
	index = index.replace(/%\\\{index\\\}/g, "%{index}");
	var nameRegexp = dojo.string.substituteParams(index, {"index":"([0-9]*)"});
	var re = new RegExp(nameRegexp, "g");
	this.deleteRow(re.exec(e.target.name)[1]);
}, hasRows:function () {
	if (this.domNode.childNodes.length > 0) {
		return true;
	}
	return false;
}, getRowCount:function () {
	return this.domNode.childNodes.length;
}, deleteRow:function (idx) {
	this.domNode.removeChild(this.domNode.childNodes[idx]);
	this._reIndexRows();
}, _changeRowPosition:function (e) {
	if (e.dragStatus == "dropFailure") {
		this.domNode.removeChild(e["dragSource"].domNode);
	} else {
		if (e.dragStatus == "dropSuccess") {
		}
	}
	this._reIndexRows();
}, setRow:function (template, myObject) {
	template = template.replace(/\%\{(index)\}/g, "0");
	this.rowTemplate = template;
	this.myObject = myObject;
}, getRow:function () {
	return this.rowTemplate;
}, _initRow:function (node) {
	if (typeof (node) == "number") {
		node = this.domNode.childNodes[node];
	}
	var elems = ["INPUT", "SELECT", "IMG"];
	for (var k = 0; k < elems.length; k++) {
		var list = node.getElementsByTagName(elems[k]);
		for (var i = 0, len = list.length; i < len; i++) {
			var child = list[i];
			if (child.nodeType != 1) {
				continue;
			}
			if (child.getAttribute("rowFunction") != null) {
				if (typeof (this.myObject[child.getAttribute("rowFunction")]) == "undefined") {
					dojo.debug("Function " + child.getAttribute("rowFunction") + " not found");
				} else {
					this.myObject[child.getAttribute("rowFunction")](child);
				}
			} else {
				if (child.getAttribute("rowAction") != null) {
					if (child.getAttribute("rowAction") == "delete") {
						child.name = dojo.string.substituteParams(this.pattern, {"index":"" + (this.getRowCount() - 1)});
						dojo.event.connect(child, "onclick", this, "onDeleteRow");
					}
				}
			}
		}
	}
}, onAddRow:function (e) {
}, addRow:function (doInit) {
	if (typeof (doInit) == "undefined") {
		doInit = true;
	}
	var node = document.createElement("span");
	node.innerHTML = this.getRow();
	if (node.childNodes.length == 1) {
		node = node.childNodes[0];
	}
	this.domNode.appendChild(node);
	var parser = new dojo.xml.Parse();
	var frag = parser.parseElement(node, null, true);
	dojo.widget.getParser().createSubComponents(frag, this);
	this._reIndexRows();
	if (doInit) {
		this._initRow(node);
	}
	if (this.useDnd) {
		node = new dojo.dnd.HtmlDragSource(node, this.widgetId);
		dojo.event.connect(node, "onDragEnd", this, "_changeRowPosition");
	}
	this.onAddRow(node);
}});


__CPAN_FILE__ src/widget/DropdownContainer.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.widget.DropdownContainer");
dojo.require("dojo.widget.*");
dojo.require("dojo.widget.HtmlWidget");
dojo.require("dojo.widget.PopupContainer");
dojo.require("dojo.event.*");
dojo.require("dojo.html.layout");
dojo.require("dojo.html.display");
dojo.require("dojo.html.iframe");
dojo.require("dojo.html.util");
dojo.widget.defineWidget("dojo.widget.DropdownContainer", dojo.widget.HtmlWidget, {inputWidth:"7em", id:"", inputId:"", inputName:"", iconURL:dojo.uri.moduleUri("dojo.widget", "templates/images/combo_box_arrow.png"), copyClasses:false, iconAlt:"", containerToggle:"plain", containerToggleDuration:150, templateString:"<span style=\"white-space:nowrap\"><input type=\"hidden\" name=\"\" value=\"\" dojoAttachPoint=\"valueNode\" /><input name=\"\" type=\"text\" value=\"\" style=\"vertical-align:middle;\" dojoAttachPoint=\"inputNode\" autocomplete=\"off\" /> <img src=\"${this.iconURL}\" alt=\"${this.iconAlt}\" dojoAttachEvent=\"onclick:onIconClick\" dojoAttachPoint=\"buttonNode\" style=\"vertical-align:middle; cursor:pointer; cursor:hand\" /></span>", templateCssPath:"", isContainer:true, attachTemplateNodes:function () {
	dojo.widget.DropdownContainer.superclass.attachTemplateNodes.apply(this, arguments);
	this.popup = dojo.widget.createWidget("PopupContainer", {toggle:this.containerToggle, toggleDuration:this.containerToggleDuration});
	this.containerNode = this.popup.domNode;
}, fillInTemplate:function (args, frag) {
	this.domNode.appendChild(this.popup.domNode);
	if (this.id) {
		this.domNode.id = this.id;
	}
	if (this.inputId) {
		this.inputNode.id = this.inputId;
	}
	if (this.inputName) {
		this.inputNode.name = this.inputName;
	}
	this.inputNode.style.width = this.inputWidth;
	this.inputNode.disabled = this.disabled;
	if (this.copyClasses) {
		this.inputNode.style = "";
		this.inputNode.className = this.getFragNodeRef(frag).className;
	}
	dojo.event.connect(this.inputNode, "onchange", this, "onInputChange");
}, onIconClick:function (evt) {
	if (this.disabled) {
		return;
	}
	if (!this.popup.isShowingNow) {
		this.popup.open(this.inputNode, this, this.buttonNode);
	} else {
		this.popup.close();
	}
}, hideContainer:function () {
	if (this.popup.isShowingNow) {
		this.popup.close();
	}
}, onInputChange:function () {
}, enable:function () {
	this.inputNode.disabled = false;
	dojo.widget.DropdownContainer.superclass.enable.apply(this, arguments);
}, disable:function () {
	this.inputNode.disabled = true;
	dojo.widget.DropdownContainer.superclass.disable.apply(this, arguments);
}});


__CPAN_FILE__ src/widget/validate.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.widget.validate");
dojo.deprecated("dojo.widget.validate", "use one of the specific widgets in dojo.widget.<name>Textbox instead", "0.5");


__CPAN_FILE__ src/widget/LinkPane.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.widget.LinkPane");
dojo.require("dojo.widget.*");
dojo.require("dojo.widget.ContentPane");
dojo.require("dojo.html.style");
dojo.widget.defineWidget("dojo.widget.LinkPane", dojo.widget.ContentPane, {templateString:"<div class=\"dojoLinkPane\"></div>", fillInTemplate:function (args, frag) {
	var source = this.getFragNodeRef(frag);
	this.label += source.innerHTML;
	var source = this.getFragNodeRef(frag);
	dojo.html.copyStyle(this.domNode, source);
}});


__CPAN_FILE__ src/widget/TreeV3.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.widget.TreeV3");
dojo.require("dojo.widget.TreeWithNode");
dojo.require("dojo.widget.*");
dojo.require("dojo.event.*");
dojo.require("dojo.io.*");
dojo.require("dojo.widget.HtmlWidget");
dojo.require("dojo.widget.TreeNodeV3");
dojo.widget.defineWidget("dojo.widget.TreeV3", [dojo.widget.HtmlWidget, dojo.widget.TreeWithNode], function () {
	this.eventNames = {};
	this.DndAcceptTypes = [];
	this.actionsDisabled = [];
	this.listeners = [];
	this.tree = this;
}, {DndMode:"", defaultChildWidget:null, defaultChildTitle:"New Node", eagerWidgetInstantiation:false, eventNamesDefault:{afterTreeCreate:"afterTreeCreate", beforeTreeDestroy:"beforeTreeDestroy", beforeNodeDestroy:"beforeNodeDestroy", afterChangeTree:"afterChangeTree", afterSetFolder:"afterSetFolder", afterUnsetFolder:"afterUnsetFolder", beforeMoveFrom:"beforeMoveFrom", beforeMoveTo:"beforeMoveTo", afterMoveFrom:"afterMoveFrom", afterMoveTo:"afterMoveTo", afterAddChild:"afterAddChild", afterDetach:"afterDetach", afterExpand:"afterExpand", beforeExpand:"beforeExpand", afterSetTitle:"afterSetTitle", afterCollapse:"afterCollapse", beforeCollapse:"beforeCollapse"}, classPrefix:"Tree", style:"", allowAddChildToLeaf:true, unsetFolderOnEmpty:true, DndModes:{BETWEEN:1, ONTO:2}, DndAcceptTypes:"", templateCssString:"/* indent for all tree children excepts root */\n.TreeNode {\n	background-image : url('../templates/images/TreeV3/i.gif');\n	background-position : top left;\n	background-repeat : repeat-y;\n	margin-left: 19px;\n	zoom: 1;\n}\n.TreeIsRoot {\n	margin-left: 0;\n}\n \n/* left vertical line (grid) for all nodes */\n.TreeIsLast {\n	background-image: url('../templates/images/TreeV3/i_half.gif');\n	background-repeat : no-repeat;\n}\n \n.TreeExpandOpen .TreeExpand {\n	background-image: url('../templates/images/TreeV3/expand_minus.gif');\n}\n \n/* closed is higher priority than open */\n.TreeExpandClosed .TreeExpand {\n	background-image: url('../templates/images/TreeV3/expand_plus.gif');\n}\n \n/* highest priority */\n.TreeExpandLeaf .TreeExpand {\n	background-image: url('../templates/images/TreeV3/expand_leaf.gif');\n}\n\n/* \nshould always override any expand setting, but do not touch children.\nif I add .TreeExpand .TreeExpandLoading same time and put it to top/bottom, then it will take precedence over +- for all descendants or always fail\nso I have to remove TreeExpand and process this one specifically\n*/\n\n.TreeExpandLoading   {\n	width: 18px;\n	height: 18px;\n	float: left;\n	display: inline;\n	background-repeat : no-repeat;\n	background-image: url('../templates/images/TreeV3/expand_loading.gif');\n}\n \n.TreeContent {\n	min-height: 18px;\n	min-width: 18px;\n	margin-left:18px;\n	cursor: default;\n	/* can't make inline - multiline bugs */\n}\n\n.TreeIEContent {\n\theight: 18px;\n}\n \n.TreeExpand {\n	width: 18px;\n	height: 18px;\n	float: left;\n	display: inline;\n	background-repeat : no-repeat;\n}\n \n/* same style as IE selection */\n.TreeNodeEmphasized {\n	background-color: Highlight;\n	color: HighlightText;\n}\n \n.TreeContent .RichTextEditable, .TreeContent .RichTextEditable iframe {\n	  background-color: #ffc;\n	  color: black;\n}\n\n/* don't use :focus due to opera's lack of support on div's */\n.TreeLabelFocused {\n	  outline: 1px invert dotted;\n}\n", templateCssPath:dojo.uri.moduleUri("dojo.widget", "templates/TreeV3.css"), templateString:"<div style=\"${this.style}\">\n</div>", isExpanded:true, isTree:true, createNode:function (data) {
	data.tree = this.widgetId;
	if (data.widgetName) {
		return dojo.widget.createWidget(data.widgetName, data);
	} else {
		if (this.defaultChildWidget.prototype.createSimple) {
			return this.defaultChildWidget.prototype.createSimple(data);
		} else {
			var ns = this.defaultChildWidget.prototype.ns;
			var wt = this.defaultChildWidget.prototype.widgetType;
			return dojo.widget.createWidget(ns + ":" + wt, data);
		}
	}
}, makeNodeTemplate:function () {
	var domNode = document.createElement("div");
	dojo.html.setClass(domNode, this.classPrefix + "Node " + this.classPrefix + "ExpandLeaf " + this.classPrefix + "ChildrenNo");
	this.nodeTemplate = domNode;
	var expandNode = document.createElement("div");
	var clazz = this.classPrefix + "Expand";
	if (dojo.render.html.ie) {
		clazz = clazz + " " + this.classPrefix + "IEExpand";
	}
	dojo.html.setClass(expandNode, clazz);
	this.expandNodeTemplate = expandNode;
	var labelNode = document.createElement("span");
	dojo.html.setClass(labelNode, this.classPrefix + "Label");
	this.labelNodeTemplate = labelNode;
	var contentNode = document.createElement("div");
	var clazz = this.classPrefix + "Content";
	if (dojo.render.html.ie && !dojo.render.html.ie70) {
		clazz = clazz + " " + this.classPrefix + "IEContent";
	}
	dojo.html.setClass(contentNode, clazz);
	this.contentNodeTemplate = contentNode;
	domNode.appendChild(expandNode);
	domNode.appendChild(contentNode);
	contentNode.appendChild(labelNode);
}, makeContainerNodeTemplate:function () {
	var div = document.createElement("div");
	div.style.display = "none";
	dojo.html.setClass(div, this.classPrefix + "Container");
	this.containerNodeTemplate = div;
}, actions:{ADDCHILD:"ADDCHILD"}, getInfo:function () {
	var info = {widgetId:this.widgetId, objectId:this.objectId};
	return info;
}, adjustEventNames:function () {
	for (var name in this.eventNamesDefault) {
		if (dojo.lang.isUndefined(this.eventNames[name])) {
			this.eventNames[name] = this.widgetId + "/" + this.eventNamesDefault[name];
		}
	}
}, adjustDndMode:function () {
	var _this = this;
	var DndMode = 0;
	dojo.lang.forEach(this.DndMode.split(";"), function (elem) {
		var mode = _this.DndModes[dojo.string.trim(elem).toUpperCase()];
		if (mode) {
			DndMode = DndMode | mode;
		}
	});
	this.DndMode = DndMode;
}, destroy:function () {
	dojo.event.topic.publish(this.tree.eventNames.beforeTreeDestroy, {source:this});
	return dojo.widget.HtmlWidget.prototype.destroy.apply(this, arguments);
}, initialize:function (args) {
	this.domNode.widgetId = this.widgetId;
	for (var i = 0; i < this.actionsDisabled.length; i++) {
		this.actionsDisabled[i] = this.actionsDisabled[i].toUpperCase();
	}
	if (!args.defaultChildWidget) {
		this.defaultChildWidget = dojo.widget.TreeNodeV3;
	} else {
		this.defaultChildWidget = dojo.lang.getObjPathValue(args.defaultChildWidget);
	}
	this.adjustEventNames();
	this.adjustDndMode();
	this.makeNodeTemplate();
	this.makeContainerNodeTemplate();
	this.containerNode = this.domNode;
	dojo.html.setClass(this.domNode, this.classPrefix + "Container");
	var _this = this;
	dojo.lang.forEach(this.listeners, function (elem) {
		var t = dojo.lang.isString(elem) ? dojo.widget.byId(elem) : elem;
		t.listenTree(_this);
	});
}, postCreate:function () {
	dojo.event.topic.publish(this.eventNames.afterTreeCreate, {source:this});
}, move:function (child, newParent, index) {
	if (!child.parent) {
		dojo.raise(this.widgetType + ": child can be moved only while it's attached");
	}
	var oldParent = child.parent;
	var oldTree = child.tree;
	var oldIndex = child.getParentIndex();
	var newTree = newParent.tree;
	var newParent = newParent;
	var newIndex = index;
	var message = {oldParent:oldParent, oldTree:oldTree, oldIndex:oldIndex, newParent:newParent, newTree:newTree, newIndex:newIndex, child:child};
	dojo.event.topic.publish(oldTree.eventNames.beforeMoveFrom, message);
	dojo.event.topic.publish(newTree.eventNames.beforeMoveTo, message);
	this.doMove.apply(this, arguments);
	dojo.event.topic.publish(oldTree.eventNames.afterMoveFrom, message);
	dojo.event.topic.publish(newTree.eventNames.afterMoveTo, message);
}, doMove:function (child, newParent, index) {
	child.doDetach();
	newParent.doAddChild(child, index);
}, toString:function () {
	return "[" + this.widgetType + " ID:" + this.widgetId + "]";
}});


__CPAN_FILE__ src/widget/ResizableTextarea.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.widget.ResizableTextarea");
dojo.require("dojo.widget.*");
dojo.require("dojo.widget.LayoutContainer");
dojo.require("dojo.widget.ResizeHandle");
dojo.widget.defineWidget("dojo.widget.ResizableTextarea", dojo.widget.HtmlWidget, {templateString:"<div>\n\t<div style=\"border: 2px solid black; width: 90%; height: 200px;\"\n\t\tdojoAttachPoint=\"rootLayoutNode\">\n\t\t<div dojoAttachPoint=\"textAreaContainerNode\" \n\t\t\tstyle=\"border: 0px; margin: 0px; overflow: hidden;\">\n\t\t</div>\n\t\t<div dojoAttachPoint=\"statusBarContainerNode\" class=\"statusBar\">\n\t\t\t<div dojoAttachPoint=\"statusLabelNode\" \n\t\t\t\tclass=\"statusPanel\"\n\t\t\t\tstyle=\"padding-right: 0px; z-index: 1;\">drag to resize</div>\n\t\t\t<div dojoAttachPoint=\"resizeHandleNode\"></div>\n\t\t</div>\n\t</div>\n</div>\n", templateCssString:"div.statusBar {\n\tbackground-color: ThreeDFace;\n\theight: 28px;\n\tpadding: 1px;\n\toverflow: hidden;\n\tfont-size: 12px;\n}\n\ndiv.statusPanel {\n\tbackground-color: ThreeDFace;\n\tborder: 1px solid;\n\tborder-color: ThreeDShadow ThreeDHighlight ThreeDHighlight ThreeDShadow;\n\tmargin: 1px;\n\tpadding: 2px 6px;\n}\n", templateCssPath:dojo.uri.moduleUri("dojo.widget", "templates/ResizableTextarea.css"), fillInTemplate:function (args, frag) {
	this.textAreaNode = this.getFragNodeRef(frag).cloneNode(true);
	dojo.body().appendChild(this.domNode);
	this.rootLayout = dojo.widget.createWidget("LayoutContainer", {minHeight:50, minWidth:100}, this.rootLayoutNode);
	this.textAreaContainer = dojo.widget.createWidget("LayoutContainer", {layoutAlign:"client"}, this.textAreaContainerNode);
	this.rootLayout.addChild(this.textAreaContainer);
	this.textAreaContainer.domNode.appendChild(this.textAreaNode);
	with (this.textAreaNode.style) {
		width = "100%";
		height = "100%";
	}
	this.statusBar = dojo.widget.createWidget("LayoutContainer", {layoutAlign:"bottom", minHeight:28}, this.statusBarContainerNode);
	this.rootLayout.addChild(this.statusBar);
	this.statusLabel = dojo.widget.createWidget("LayoutContainer", {layoutAlign:"client", minWidth:50}, this.statusLabelNode);
	this.statusBar.addChild(this.statusLabel);
	this.resizeHandle = dojo.widget.createWidget("ResizeHandle", {targetElmId:this.rootLayout.widgetId}, this.resizeHandleNode);
	this.statusBar.addChild(this.resizeHandle);
}});


__CPAN_FILE__ src/widget/DomWidget.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.widget.DomWidget");
dojo.require("dojo.event.*");
dojo.require("dojo.widget.Widget");
dojo.require("dojo.dom");
dojo.require("dojo.html.style");
dojo.require("dojo.xml.Parse");
dojo.require("dojo.uri.*");
dojo.require("dojo.lang.func");
dojo.require("dojo.lang.extras");
dojo.widget._cssFiles = {};
dojo.widget._cssStrings = {};
dojo.widget._templateCache = {};
dojo.widget.defaultStrings = {dojoRoot:dojo.hostenv.getBaseScriptUri(), dojoWidgetModuleUri:dojo.uri.moduleUri("dojo.widget"), baseScriptUri:dojo.hostenv.getBaseScriptUri()};
dojo.widget.fillFromTemplateCache = function (obj, templatePath, templateString, avoidCache) {
	var tpath = templatePath || obj.templatePath;
	var tmplts = dojo.widget._templateCache;
	if (!tpath && !obj["widgetType"]) {
		do {
			var dummyName = "__dummyTemplate__" + dojo.widget._templateCache.dummyCount++;
		} while (tmplts[dummyName]);
		obj.widgetType = dummyName;
	}
	var wt = tpath ? tpath.toString() : obj.widgetType;
	var ts = tmplts[wt];
	if (!ts) {
		tmplts[wt] = {"string":null, "node":null};
		if (avoidCache) {
			ts = {};
		} else {
			ts = tmplts[wt];
		}
	}
	if ((!obj.templateString) && (!avoidCache)) {
		obj.templateString = templateString || ts["string"];
	}
	if (obj.templateString) {
		obj.templateString = this._sanitizeTemplateString(obj.templateString);
	}
	if ((!obj.templateNode) && (!avoidCache)) {
		obj.templateNode = ts["node"];
	}
	if ((!obj.templateNode) && (!obj.templateString) && (tpath)) {
		var tstring = this._sanitizeTemplateString(dojo.hostenv.getText(tpath));
		obj.templateString = tstring;
		if (!avoidCache) {
			tmplts[wt]["string"] = tstring;
		}
	}
	if ((!ts["string"]) && (!avoidCache)) {
		ts.string = obj.templateString;
	}
};
dojo.widget._sanitizeTemplateString = function (tString) {
	if (tString) {
		tString = tString.replace(/^\s*<\?xml(\s)+version=[\'\"](\d)*.(\d)*[\'\"](\s)*\?>/im, "");
		var matches = tString.match(/<body[^>]*>\s*([\s\S]+)\s*<\/body>/im);
		if (matches) {
			tString = matches[1];
		}
	} else {
		tString = "";
	}
	return tString;
};
dojo.widget._templateCache.dummyCount = 0;
dojo.widget.attachProperties = ["dojoAttachPoint", "id"];
dojo.widget.eventAttachProperty = "dojoAttachEvent";
dojo.widget.onBuildProperty = "dojoOnBuild";
dojo.widget.waiNames = ["waiRole", "waiState"];
dojo.widget.wai = {waiRole:{name:"waiRole", "namespace":"http://www.w3.org/TR/xhtml2", alias:"x2", prefix:"wairole:"}, waiState:{name:"waiState", "namespace":"http://www.w3.org/2005/07/aaa", alias:"aaa", prefix:""}, setAttr:function (node, ns, attr, value) {
	if (dojo.render.html.ie) {
		node.setAttribute(this[ns].alias + ":" + attr, this[ns].prefix + value);
	} else {
		node.setAttributeNS(this[ns]["namespace"], attr, this[ns].prefix + value);
	}
}, getAttr:function (node, ns, attr) {
	if (dojo.render.html.ie) {
		return node.getAttribute(this[ns].alias + ":" + attr);
	} else {
		return node.getAttributeNS(this[ns]["namespace"], attr);
	}
}, removeAttr:function (node, ns, attr) {
	var success = true;
	if (dojo.render.html.ie) {
		success = node.removeAttribute(this[ns].alias + ":" + attr);
	} else {
		node.removeAttributeNS(this[ns]["namespace"], attr);
	}
	return success;
}};
dojo.widget.attachTemplateNodes = function (rootNode, targetObj, events) {
	var elementNodeType = dojo.dom.ELEMENT_NODE;
	function trim(str) {
		return str.replace(/^\s+|\s+$/g, "");
	}
	if (!rootNode) {
		rootNode = targetObj.domNode;
	}
	if (rootNode.nodeType != elementNodeType) {
		return;
	}
	var nodes = rootNode.all || rootNode.getElementsByTagName("*");
	var _this = targetObj;
	for (var x = -1; x < nodes.length; x++) {
		var baseNode = (x == -1) ? rootNode : nodes[x];
		var attachPoint = [];
		if (!targetObj.widgetsInTemplate || !baseNode.getAttribute("dojoType")) {
			for (var y = 0; y < this.attachProperties.length; y++) {
				var tmpAttachPoint = baseNode.getAttribute(this.attachProperties[y]);
				if (tmpAttachPoint) {
					attachPoint = tmpAttachPoint.split(";");
					for (var z = 0; z < attachPoint.length; z++) {
						if (dojo.lang.isArray(targetObj[attachPoint[z]])) {
							targetObj[attachPoint[z]].push(baseNode);
						} else {
							targetObj[attachPoint[z]] = baseNode;
						}
					}
					break;
				}
			}
			var attachEvent = baseNode.getAttribute(this.eventAttachProperty);
			if (attachEvent) {
				var evts = attachEvent.split(";");
				for (var y = 0; y < evts.length; y++) {
					if ((!evts[y]) || (!evts[y].length)) {
						continue;
					}
					var thisFunc = null;
					var tevt = trim(evts[y]);
					if (evts[y].indexOf(":") >= 0) {
						var funcNameArr = tevt.split(":");
						tevt = trim(funcNameArr[0]);
						thisFunc = trim(funcNameArr[1]);
					}
					if (!thisFunc) {
						thisFunc = tevt;
					}
					var tf = function () {
						var ntf = new String(thisFunc);
						return function (evt) {
							if (_this[ntf]) {
								_this[ntf](dojo.event.browser.fixEvent(evt, this));
							}
						};
					}();
					dojo.event.browser.addListener(baseNode, tevt, tf, false, true);
				}
			}
			for (var y = 0; y < events.length; y++) {
				var evtVal = baseNode.getAttribute(events[y]);
				if ((evtVal) && (evtVal.length)) {
					var thisFunc = null;
					var domEvt = events[y].substr(4);
					thisFunc = trim(evtVal);
					var funcs = [thisFunc];
					if (thisFunc.indexOf(";") >= 0) {
						funcs = dojo.lang.map(thisFunc.split(";"), trim);
					}
					for (var z = 0; z < funcs.length; z++) {
						if (!funcs[z].length) {
							continue;
						}
						var tf = function () {
							var ntf = new String(funcs[z]);
							return function (evt) {
								if (_this[ntf]) {
									_this[ntf](dojo.event.browser.fixEvent(evt, this));
								}
							};
						}();
						dojo.event.browser.addListener(baseNode, domEvt, tf, false, true);
					}
				}
			}
		}
		var tmpltPoint = baseNode.getAttribute(this.templateProperty);
		if (tmpltPoint) {
			targetObj[tmpltPoint] = baseNode;
		}
		dojo.lang.forEach(dojo.widget.waiNames, function (name) {
			var wai = dojo.widget.wai[name];
			var val = baseNode.getAttribute(wai.name);
			if (val) {
				if (val.indexOf("-") == -1) {
					dojo.widget.wai.setAttr(baseNode, wai.name, "role", val);
				} else {
					var statePair = val.split("-");
					dojo.widget.wai.setAttr(baseNode, wai.name, statePair[0], statePair[1]);
				}
			}
		}, this);
		var onBuild = baseNode.getAttribute(this.onBuildProperty);
		if (onBuild) {
			eval("var node = baseNode; var widget = targetObj; " + onBuild);
		}
	}
};
dojo.widget.getDojoEventsFromStr = function (str) {
	var re = /(dojoOn([a-z]+)(\s?))=/gi;
	var evts = str ? str.match(re) || [] : [];
	var ret = [];
	var lem = {};
	for (var x = 0; x < evts.length; x++) {
		if (evts[x].length < 1) {
			continue;
		}
		var cm = evts[x].replace(/\s/, "");
		cm = (cm.slice(0, cm.length - 1));
		if (!lem[cm]) {
			lem[cm] = true;
			ret.push(cm);
		}
	}
	return ret;
};
dojo.declare("dojo.widget.DomWidget", dojo.widget.Widget, function () {
	if ((arguments.length > 0) && (typeof arguments[0] == "object")) {
		this.create(arguments[0]);
	}
}, {templateNode:null, templateString:null, templateCssString:null, preventClobber:false, domNode:null, containerNode:null, widgetsInTemplate:false, addChild:function (widget, overrideContainerNode, pos, ref, insertIndex) {
	if (!this.isContainer) {
		dojo.debug("dojo.widget.DomWidget.addChild() attempted on non-container widget");
		return null;
	} else {
		if (insertIndex == undefined) {
			insertIndex = this.children.length;
		}
		this.addWidgetAsDirectChild(widget, overrideContainerNode, pos, ref, insertIndex);
		this.registerChild(widget, insertIndex);
	}
	return widget;
}, addWidgetAsDirectChild:function (widget, overrideContainerNode, pos, ref, insertIndex) {
	if ((!this.containerNode) && (!overrideContainerNode)) {
		this.containerNode = this.domNode;
	}
	var cn = (overrideContainerNode) ? overrideContainerNode : this.containerNode;
	if (!pos) {
		pos = "after";
	}
	if (!ref) {
		if (!cn) {
			cn = dojo.body();
		}
		ref = cn.lastChild;
	}
	if (!insertIndex) {
		insertIndex = 0;
	}
	widget.domNode.setAttribute("dojoinsertionindex", insertIndex);
	if (!ref) {
		cn.appendChild(widget.domNode);
	} else {
		if (pos == "insertAtIndex") {
			dojo.dom.insertAtIndex(widget.domNode, ref.parentNode, insertIndex);
		} else {
			if ((pos == "after") && (ref === cn.lastChild)) {
				cn.appendChild(widget.domNode);
			} else {
				dojo.dom.insertAtPosition(widget.domNode, cn, pos);
			}
		}
	}
}, registerChild:function (widget, insertionIndex) {
	widget.dojoInsertionIndex = insertionIndex;
	var idx = -1;
	for (var i = 0; i < this.children.length; i++) {
		if (this.children[i].dojoInsertionIndex <= insertionIndex) {
			idx = i;
		}
	}
	this.children.splice(idx + 1, 0, widget);
	widget.parent = this;
	widget.addedTo(this, idx + 1);
	delete dojo.widget.manager.topWidgets[widget.widgetId];
}, removeChild:function (widget) {
	dojo.dom.removeNode(widget.domNode);
	return dojo.widget.DomWidget.superclass.removeChild.call(this, widget);
}, getFragNodeRef:function (frag) {
	if (!frag) {
		return null;
	}
	if (!frag[this.getNamespacedType()]) {
		dojo.raise("Error: no frag for widget type " + this.getNamespacedType() + ", id " + this.widgetId + " (maybe a widget has set it's type incorrectly)");
	}
	return frag[this.getNamespacedType()]["nodeRef"];
}, postInitialize:function (args, frag, parentComp) {
	var sourceNodeRef = this.getFragNodeRef(frag);
	if (parentComp && (parentComp.snarfChildDomOutput || !sourceNodeRef)) {
		parentComp.addWidgetAsDirectChild(this, "", "insertAtIndex", "", args["dojoinsertionindex"], sourceNodeRef);
	} else {
		if (sourceNodeRef) {
			if (this.domNode && (this.domNode !== sourceNodeRef)) {
				this._sourceNodeRef = dojo.dom.replaceNode(sourceNodeRef, this.domNode);
			}
		}
	}
	if (parentComp) {
		parentComp.registerChild(this, args.dojoinsertionindex);
	} else {
		dojo.widget.manager.topWidgets[this.widgetId] = this;
	}
	if (this.widgetsInTemplate) {
		var parser = new dojo.xml.Parse();
		var subContainerNode;
		var subnodes = this.domNode.getElementsByTagName("*");
		for (var i = 0; i < subnodes.length; i++) {
			if (subnodes[i].getAttribute("dojoAttachPoint") == "subContainerWidget") {
				subContainerNode = subnodes[i];
			}
			if (subnodes[i].getAttribute("dojoType")) {
				subnodes[i].setAttribute("isSubWidget", true);
			}
		}
		if (this.isContainer && !this.containerNode) {
			if (subContainerNode) {
				var src = this.getFragNodeRef(frag);
				if (src) {
					dojo.dom.moveChildren(src, subContainerNode);
					frag["dojoDontFollow"] = true;
				}
			} else {
				dojo.debug("No subContainerWidget node can be found in template file for widget " + this);
			}
		}
		var templatefrag = parser.parseElement(this.domNode, null, true);
		dojo.widget.getParser().createSubComponents(templatefrag, this);
		var subwidgets = [];
		var stack = [this];
		var w;
		while ((w = stack.pop())) {
			for (var i = 0; i < w.children.length; i++) {
				var cwidget = w.children[i];
				if (cwidget._processedSubWidgets || !cwidget.extraArgs["issubwidget"]) {
					continue;
				}
				subwidgets.push(cwidget);
				if (cwidget.isContainer) {
					stack.push(cwidget);
				}
			}
		}
		for (var i = 0; i < subwidgets.length; i++) {
			var widget = subwidgets[i];
			if (widget._processedSubWidgets) {
				dojo.debug("This should not happen: widget._processedSubWidgets is already true!");
				return;
			}
			widget._processedSubWidgets = true;
			if (widget.extraArgs["dojoattachevent"]) {
				var evts = widget.extraArgs["dojoattachevent"].split(";");
				for (var j = 0; j < evts.length; j++) {
					var thisFunc = null;
					var tevt = dojo.string.trim(evts[j]);
					if (tevt.indexOf(":") >= 0) {
						var funcNameArr = tevt.split(":");
						tevt = dojo.string.trim(funcNameArr[0]);
						thisFunc = dojo.string.trim(funcNameArr[1]);
					}
					if (!thisFunc) {
						thisFunc = tevt;
					}
					if (dojo.lang.isFunction(widget[tevt])) {
						dojo.event.kwConnect({srcObj:widget, srcFunc:tevt, targetObj:this, targetFunc:thisFunc});
					} else {
						alert(tevt + " is not a function in widget " + widget);
					}
				}
			}
			if (widget.extraArgs["dojoattachpoint"]) {
				this[widget.extraArgs["dojoattachpoint"]] = widget;
			}
		}
	}
	if (this.isContainer && !frag["dojoDontFollow"]) {
		dojo.widget.getParser().createSubComponents(frag, this);
	}
}, buildRendering:function (args, frag) {
	var ts = dojo.widget._templateCache[this.widgetType];
	if (args["templatecsspath"]) {
		args["templateCssPath"] = args["templatecsspath"];
	}
	var cpath = args["templateCssPath"] || this.templateCssPath;
	if (cpath && !dojo.widget._cssFiles[cpath.toString()]) {
		if ((!this.templateCssString) && (cpath)) {
			this.templateCssString = dojo.hostenv.getText(cpath);
			this.templateCssPath = null;
		}
		dojo.widget._cssFiles[cpath.toString()] = true;
	}
	if ((this["templateCssString"]) && (!dojo.widget._cssStrings[this.templateCssString])) {
		dojo.html.insertCssText(this.templateCssString, null, cpath);
		dojo.widget._cssStrings[this.templateCssString] = true;
	}
	if ((!this.preventClobber) && ((this.templatePath) || (this.templateNode) || ((this["templateString"]) && (this.templateString.length)) || ((typeof ts != "undefined") && ((ts["string"]) || (ts["node"]))))) {
		this.buildFromTemplate(args, frag);
	} else {
		this.domNode = this.getFragNodeRef(frag);
	}
	this.fillInTemplate(args, frag);
}, buildFromTemplate:function (args, frag) {
	var avoidCache = false;
	if (args["templatepath"]) {
		args["templatePath"] = args["templatepath"];
	}
	dojo.widget.fillFromTemplateCache(this, args["templatePath"], null, avoidCache);
	var ts = dojo.widget._templateCache[this.templatePath ? this.templatePath.toString() : this.widgetType];
	if ((ts) && (!avoidCache)) {
		if (!this.templateString.length) {
			this.templateString = ts["string"];
		}
		if (!this.templateNode) {
			this.templateNode = ts["node"];
		}
	}
	var matches = false;
	var node = null;
	var tstr = this.templateString;
	if ((!this.templateNode) && (this.templateString)) {
		matches = this.templateString.match(/\$\{([^\}]+)\}/g);
		if (matches) {
			var hash = this.strings || {};
			for (var key in dojo.widget.defaultStrings) {
				if (dojo.lang.isUndefined(hash[key])) {
					hash[key] = dojo.widget.defaultStrings[key];
				}
			}
			for (var i = 0; i < matches.length; i++) {
				var key = matches[i];
				key = key.substring(2, key.length - 1);
				var kval = (key.substring(0, 5) == "this.") ? dojo.lang.getObjPathValue(key.substring(5), this) : hash[key];
				var value;
				if ((kval) || (dojo.lang.isString(kval))) {
					value = new String((dojo.lang.isFunction(kval)) ? kval.call(this, key, this.templateString) : kval);
					while (value.indexOf("\"") > -1) {
						value = value.replace("\"", "&quot;");
					}
					tstr = tstr.replace(matches[i], value);
				}
			}
		} else {
			this.templateNode = this.createNodesFromText(this.templateString, true)[0];
			if (!avoidCache) {
				ts.node = this.templateNode;
			}
		}
	}
	if ((!this.templateNode) && (!matches)) {
		dojo.debug("DomWidget.buildFromTemplate: could not create template");
		return false;
	} else {
		if (!matches) {
			node = this.templateNode.cloneNode(true);
			if (!node) {
				return false;
			}
		} else {
			node = this.createNodesFromText(tstr, true)[0];
		}
	}
	this.domNode = node;
	this.attachTemplateNodes();
	if (this.isContainer && this.containerNode) {
		var src = this.getFragNodeRef(frag);
		if (src) {
			dojo.dom.moveChildren(src, this.containerNode);
		}
	}
}, attachTemplateNodes:function (baseNode, targetObj) {
	if (!baseNode) {
		baseNode = this.domNode;
	}
	if (!targetObj) {
		targetObj = this;
	}
	return dojo.widget.attachTemplateNodes(baseNode, targetObj, dojo.widget.getDojoEventsFromStr(this.templateString));
}, fillInTemplate:function () {
}, destroyRendering:function () {
	try {
		dojo.dom.destroyNode(this.domNode);
		delete this.domNode;
	}
	catch (e) {
	}
	if (this._sourceNodeRef) {
		try {
			dojo.dom.destroyNode(this._sourceNodeRef);
		}
		catch (e) {
		}
	}
}, createNodesFromText:function () {
	dojo.unimplemented("dojo.widget.DomWidget.createNodesFromText");
}});


__CPAN_FILE__ src/widget/FisheyeList.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.widget.FisheyeList");
dojo.require("dojo.widget.*");
dojo.require("dojo.widget.HtmlWidget");
dojo.require("dojo.html.style");
dojo.require("dojo.html.selection");
dojo.require("dojo.html.util");
dojo.require("dojo.event.*");
dojo.widget.defineWidget("dojo.widget.FisheyeList", dojo.widget.HtmlWidget, function () {
	this.pos = {x:-1, y:-1};
	this.EDGE = {CENTER:0, LEFT:1, RIGHT:2, TOP:3, BOTTOM:4};
	this.timerScale = 1;
}, {templateString:"<div class=\"dojoHtmlFisheyeListBar\"></div>", templateCssString:".dojoHtmlFisheyeListItemLabel {\n\tfont-family: Arial, Helvetica, sans-serif;\n\tbackground-color: #eee;\n\tborder: 2px solid #666;\n\tpadding: 2px;\n\ttext-align: center;\n\tposition: absolute;\n\tdisplay: none;\n}\n\n.dojoHtmlFisheyeListItemLabel.selected {\n\tdisplay: block;\n}\n\n.dojoHtmlFisheyeListItemImage {\n\tborder: 0px;\n\tposition: absolute;\n}\n\n.dojoHtmlFisheyeListItem {\n\tposition: absolute;\n\tz-index: 2;\n}\n\n.dojoHtmlFisheyeListBar {\n\tposition: relative;\n}\n", templateCssPath:dojo.uri.moduleUri("dojo.widget", "templates/FisheyeList.css"), isContainer:true, snarfChildDomOutput:true, itemWidth:40, itemHeight:40, itemMaxWidth:150, itemMaxHeight:150, orientation:"horizontal", conservativeTrigger:false, effectUnits:2, itemPadding:10, attachEdge:"center", labelEdge:"bottom", enableCrappySvgSupport:false, fillInTemplate:function () {
	dojo.html.disableSelection(this.domNode);
	this.isHorizontal = (this.orientation == "horizontal");
	this.selectedNode = -1;
	this.isOver = false;
	this.hitX1 = -1;
	this.hitY1 = -1;
	this.hitX2 = -1;
	this.hitY2 = -1;
	this.anchorEdge = this._toEdge(this.attachEdge, this.EDGE.CENTER);
	this.labelEdge = this._toEdge(this.labelEdge, this.EDGE.TOP);
	if (this.isHorizontal && (this.anchorEdge == this.EDGE.LEFT)) {
		this.anchorEdge = this.EDGE.CENTER;
	}
	if (this.isHorizontal && (this.anchorEdge == this.EDGE.RIGHT)) {
		this.anchorEdge = this.EDGE.CENTER;
	}
	if (!this.isHorizontal && (this.anchorEdge == this.EDGE.TOP)) {
		this.anchorEdge = this.EDGE.CENTER;
	}
	if (!this.isHorizontal && (this.anchorEdge == this.EDGE.BOTTOM)) {
		this.anchorEdge = this.EDGE.CENTER;
	}
	if (this.labelEdge == this.EDGE.CENTER) {
		this.labelEdge = this.EDGE.TOP;
	}
	if (this.isHorizontal && (this.labelEdge == this.EDGE.LEFT)) {
		this.labelEdge = this.EDGE.TOP;
	}
	if (this.isHorizontal && (this.labelEdge == this.EDGE.RIGHT)) {
		this.labelEdge = this.EDGE.TOP;
	}
	if (!this.isHorizontal && (this.labelEdge == this.EDGE.TOP)) {
		this.labelEdge = this.EDGE.LEFT;
	}
	if (!this.isHorizontal && (this.labelEdge == this.EDGE.BOTTOM)) {
		this.labelEdge = this.EDGE.LEFT;
	}
	this.proximityLeft = this.itemWidth * (this.effectUnits - 0.5);
	this.proximityRight = this.itemWidth * (this.effectUnits - 0.5);
	this.proximityTop = this.itemHeight * (this.effectUnits - 0.5);
	this.proximityBottom = this.itemHeight * (this.effectUnits - 0.5);
	if (this.anchorEdge == this.EDGE.LEFT) {
		this.proximityLeft = 0;
	}
	if (this.anchorEdge == this.EDGE.RIGHT) {
		this.proximityRight = 0;
	}
	if (this.anchorEdge == this.EDGE.TOP) {
		this.proximityTop = 0;
	}
	if (this.anchorEdge == this.EDGE.BOTTOM) {
		this.proximityBottom = 0;
	}
	if (this.anchorEdge == this.EDGE.CENTER) {
		this.proximityLeft /= 2;
		this.proximityRight /= 2;
		this.proximityTop /= 2;
		this.proximityBottom /= 2;
	}
}, postCreate:function () {
	this._initializePositioning();
	if (!this.conservativeTrigger) {
		dojo.event.connect(document.documentElement, "onmousemove", this, "_onMouseMove");
	}
	dojo.event.connect(document.documentElement, "onmouseout", this, "_onBodyOut");
	dojo.event.connect(this, "addChild", this, "_initializePositioning");
}, _initializePositioning:function () {
	this.itemCount = this.children.length;
	this.barWidth = (this.isHorizontal ? this.itemCount : 1) * this.itemWidth;
	this.barHeight = (this.isHorizontal ? 1 : this.itemCount) * this.itemHeight;
	this.totalWidth = this.proximityLeft + this.proximityRight + this.barWidth;
	this.totalHeight = this.proximityTop + this.proximityBottom + this.barHeight;
	for (var i = 0; i < this.children.length; i++) {
		this.children[i].posX = this.itemWidth * (this.isHorizontal ? i : 0);
		this.children[i].posY = this.itemHeight * (this.isHorizontal ? 0 : i);
		this.children[i].cenX = this.children[i].posX + (this.itemWidth / 2);
		this.children[i].cenY = this.children[i].posY + (this.itemHeight / 2);
		var isz = this.isHorizontal ? this.itemWidth : this.itemHeight;
		var r = this.effectUnits * isz;
		var c = this.isHorizontal ? this.children[i].cenX : this.children[i].cenY;
		var lhs = this.isHorizontal ? this.proximityLeft : this.proximityTop;
		var rhs = this.isHorizontal ? this.proximityRight : this.proximityBottom;
		var siz = this.isHorizontal ? this.barWidth : this.barHeight;
		var range_lhs = r;
		var range_rhs = r;
		if (range_lhs > c + lhs) {
			range_lhs = c + lhs;
		}
		if (range_rhs > (siz - c + rhs)) {
			range_rhs = siz - c + rhs;
		}
		this.children[i].effectRangeLeft = range_lhs / isz;
		this.children[i].effectRangeRght = range_rhs / isz;
	}
	this.domNode.style.width = this.barWidth + "px";
	this.domNode.style.height = this.barHeight + "px";
	for (var i = 0; i < this.children.length; i++) {
		var itm = this.children[i];
		var elm = itm.domNode;
		elm.style.left = itm.posX + "px";
		elm.style.top = itm.posY + "px";
		elm.style.width = this.itemWidth + "px";
		elm.style.height = this.itemHeight + "px";
		if (itm.svgNode) {
			itm.svgNode.style.position = "absolute";
			itm.svgNode.style.left = this.itemPadding + "%";
			itm.svgNode.style.top = this.itemPadding + "%";
			itm.svgNode.style.width = (100 - 2 * this.itemPadding) + "%";
			itm.svgNode.style.height = (100 - 2 * this.itemPadding) + "%";
			itm.svgNode.style.zIndex = 1;
			itm.svgNode.setSize(this.itemWidth, this.itemHeight);
		} else {
			itm.imgNode.style.left = this.itemPadding + "%";
			itm.imgNode.style.top = this.itemPadding + "%";
			itm.imgNode.style.width = (100 - 2 * this.itemPadding) + "%";
			itm.imgNode.style.height = (100 - 2 * this.itemPadding) + "%";
		}
	}
	this._calcHitGrid();
}, _onBodyOut:function (e) {
	if (dojo.html.overElement(dojo.body(), e)) {
		return;
	}
	this._setDormant(e);
}, _setDormant:function (e) {
	if (!this.isOver) {
		return;
	}
	this.isOver = false;
	if (this.conservativeTrigger) {
		dojo.event.disconnect(document.documentElement, "onmousemove", this, "_onMouseMove");
	}
	this._onGridMouseMove(-1, -1);
}, _setActive:function (e) {
	if (this.isOver) {
		return;
	}
	this.isOver = true;
	if (this.conservativeTrigger) {
		dojo.event.connect(document.documentElement, "onmousemove", this, "_onMouseMove");
		this.timerScale = 0;
		this._onMouseMove(e);
		this._expandSlowly();
	}
}, _onMouseMove:function (e) {
	if ((e.pageX >= this.hitX1) && (e.pageX <= this.hitX2) && (e.pageY >= this.hitY1) && (e.pageY <= this.hitY2)) {
		if (!this.isOver) {
			this._setActive(e);
		}
		this._onGridMouseMove(e.pageX - this.hitX1, e.pageY - this.hitY1);
	} else {
		if (this.isOver) {
			this._setDormant(e);
		}
	}
}, onResized:function () {
	this._calcHitGrid();
}, _onGridMouseMove:function (x, y) {
	this.pos = {x:x, y:y};
	this._paint();
}, _paint:function () {
	var x = this.pos.x;
	var y = this.pos.y;
	if (this.itemCount <= 0) {
		return;
	}
	var pos = this.isHorizontal ? x : y;
	var prx = this.isHorizontal ? this.proximityLeft : this.proximityTop;
	var siz = this.isHorizontal ? this.itemWidth : this.itemHeight;
	var sim = this.isHorizontal ? (1 - this.timerScale) * this.itemWidth + this.timerScale * this.itemMaxWidth : (1 - this.timerScale) * this.itemHeight + this.timerScale * this.itemMaxHeight;
	var cen = ((pos - prx) / siz) - 0.5;
	var max_off_cen = (sim / siz) - 0.5;
	if (max_off_cen > this.effectUnits) {
		max_off_cen = this.effectUnits;
	}
	var off_weight = 0;
	if (this.anchorEdge == this.EDGE.BOTTOM) {
		var cen2 = (y - this.proximityTop) / this.itemHeight;
		off_weight = (cen2 > 0.5) ? 1 : y / (this.proximityTop + (this.itemHeight / 2));
	}
	if (this.anchorEdge == this.EDGE.TOP) {
		var cen2 = (y - this.proximityTop) / this.itemHeight;
		off_weight = (cen2 < 0.5) ? 1 : (this.totalHeight - y) / (this.proximityBottom + (this.itemHeight / 2));
	}
	if (this.anchorEdge == this.EDGE.RIGHT) {
		var cen2 = (x - this.proximityLeft) / this.itemWidth;
		off_weight = (cen2 > 0.5) ? 1 : x / (this.proximityLeft + (this.itemWidth / 2));
	}
	if (this.anchorEdge == this.EDGE.LEFT) {
		var cen2 = (x - this.proximityLeft) / this.itemWidth;
		off_weight = (cen2 < 0.5) ? 1 : (this.totalWidth - x) / (this.proximityRight + (this.itemWidth / 2));
	}
	if (this.anchorEdge == this.EDGE.CENTER) {
		if (this.isHorizontal) {
			off_weight = y / (this.totalHeight);
		} else {
			off_weight = x / (this.totalWidth);
		}
		if (off_weight > 0.5) {
			off_weight = 1 - off_weight;
		}
		off_weight *= 2;
	}
	for (var i = 0; i < this.itemCount; i++) {
		var weight = this._weighAt(cen, i);
		if (weight < 0) {
			weight = 0;
		}
		this._setItemSize(i, weight * off_weight);
	}
	var main_p = Math.round(cen);
	var offset = 0;
	if (cen < 0) {
		main_p = 0;
	} else {
		if (cen > this.itemCount - 1) {
			main_p = this.itemCount - 1;
		} else {
			offset = (cen - main_p) * ((this.isHorizontal ? this.itemWidth : this.itemHeight) - this.children[main_p].sizeMain);
		}
	}
	this._positionElementsFrom(main_p, offset);
}, _weighAt:function (cen, i) {
	var dist = Math.abs(cen - i);
	var limit = ((cen - i) > 0) ? this.children[i].effectRangeRght : this.children[i].effectRangeLeft;
	return (dist > limit) ? 0 : (1 - dist / limit);
}, _setItemSize:function (p, scale) {
	scale *= this.timerScale;
	var w = Math.round(this.itemWidth + ((this.itemMaxWidth - this.itemWidth) * scale));
	var h = Math.round(this.itemHeight + ((this.itemMaxHeight - this.itemHeight) * scale));
	if (this.isHorizontal) {
		this.children[p].sizeW = w;
		this.children[p].sizeH = h;
		this.children[p].sizeMain = w;
		this.children[p].sizeOff = h;
		var y = 0;
		if (this.anchorEdge == this.EDGE.TOP) {
			y = (this.children[p].cenY - (this.itemHeight / 2));
		} else {
			if (this.anchorEdge == this.EDGE.BOTTOM) {
				y = (this.children[p].cenY - (h - (this.itemHeight / 2)));
			} else {
				y = (this.children[p].cenY - (h / 2));
			}
		}
		this.children[p].usualX = Math.round(this.children[p].cenX - (w / 2));
		this.children[p].domNode.style.top = y + "px";
		this.children[p].domNode.style.left = this.children[p].usualX + "px";
	} else {
		this.children[p].sizeW = w;
		this.children[p].sizeH = h;
		this.children[p].sizeOff = w;
		this.children[p].sizeMain = h;
		var x = 0;
		if (this.anchorEdge == this.EDGE.LEFT) {
			x = this.children[p].cenX - (this.itemWidth / 2);
		} else {
			if (this.anchorEdge == this.EDGE.RIGHT) {
				x = this.children[p].cenX - (w - (this.itemWidth / 2));
			} else {
				x = this.children[p].cenX - (w / 2);
			}
		}
		this.children[p].domNode.style.left = x + "px";
		this.children[p].usualY = Math.round(this.children[p].cenY - (h / 2));
		this.children[p].domNode.style.top = this.children[p].usualY + "px";
	}
	this.children[p].domNode.style.width = w + "px";
	this.children[p].domNode.style.height = h + "px";
	if (this.children[p].svgNode) {
		this.children[p].svgNode.setSize(w, h);
	}
}, _positionElementsFrom:function (p, offset) {
	var pos = 0;
	if (this.isHorizontal) {
		pos = Math.round(this.children[p].usualX + offset);
		this.children[p].domNode.style.left = pos + "px";
	} else {
		pos = Math.round(this.children[p].usualY + offset);
		this.children[p].domNode.style.top = pos + "px";
	}
	this._positionLabel(this.children[p]);
	var bpos = pos;
	for (var i = p - 1; i >= 0; i--) {
		bpos -= this.children[i].sizeMain;
		if (this.isHorizontal) {
			this.children[i].domNode.style.left = bpos + "px";
		} else {
			this.children[i].domNode.style.top = bpos + "px";
		}
		this._positionLabel(this.children[i]);
	}
	var apos = pos;
	for (var i = p + 1; i < this.itemCount; i++) {
		apos += this.children[i - 1].sizeMain;
		if (this.isHorizontal) {
			this.children[i].domNode.style.left = apos + "px";
		} else {
			this.children[i].domNode.style.top = apos + "px";
		}
		this._positionLabel(this.children[i]);
	}
}, _positionLabel:function (itm) {
	var x = 0;
	var y = 0;
	var mb = dojo.html.getMarginBox(itm.lblNode);
	if (this.labelEdge == this.EDGE.TOP) {
		x = Math.round((itm.sizeW / 2) - (mb.width / 2));
		y = -mb.height;
	}
	if (this.labelEdge == this.EDGE.BOTTOM) {
		x = Math.round((itm.sizeW / 2) - (mb.width / 2));
		y = itm.sizeH;
	}
	if (this.labelEdge == this.EDGE.LEFT) {
		x = -mb.width;
		y = Math.round((itm.sizeH / 2) - (mb.height / 2));
	}
	if (this.labelEdge == this.EDGE.RIGHT) {
		x = itm.sizeW;
		y = Math.round((itm.sizeH / 2) - (mb.height / 2));
	}
	itm.lblNode.style.left = x + "px";
	itm.lblNode.style.top = y + "px";
}, _calcHitGrid:function () {
	var pos = dojo.html.getAbsolutePosition(this.domNode, true);
	this.hitX1 = pos.x - this.proximityLeft;
	this.hitY1 = pos.y - this.proximityTop;
	this.hitX2 = this.hitX1 + this.totalWidth;
	this.hitY2 = this.hitY1 + this.totalHeight;
}, _toEdge:function (inp, def) {
	return this.EDGE[inp.toUpperCase()] || def;
}, _expandSlowly:function () {
	if (!this.isOver) {
		return;
	}
	this.timerScale += 0.2;
	this._paint();
	if (this.timerScale < 1) {
		dojo.lang.setTimeout(this, "_expandSlowly", 10);
	}
}, destroy:function () {
	dojo.event.disconnect(document.documentElement, "onmouseout", this, "_onBodyOut");
	dojo.event.disconnect(document.documentElement, "onmousemove", this, "_onMouseMove");
	dojo.widget.FisheyeList.superclass.destroy.call(this);
}});
dojo.widget.defineWidget("dojo.widget.FisheyeListItem", dojo.widget.HtmlWidget, {iconSrc:"", svgSrc:"", caption:"", id:"", _blankImgPath:dojo.uri.moduleUri("dojo.widget", "templates/images/blank.gif"), templateString:"<div class=\"dojoHtmlFisheyeListItem\">" + "  <img class=\"dojoHtmlFisheyeListItemImage\" dojoAttachPoint=\"imgNode\" dojoAttachEvent=\"onMouseOver;onMouseOut;onClick\">" + "  <div class=\"dojoHtmlFisheyeListItemLabel\" dojoAttachPoint=\"lblNode\"></div>" + "</div>", fillInTemplate:function () {
	if (this.svgSrc != "") {
		this.svgNode = this._createSvgNode(this.svgSrc);
		this.domNode.appendChild(this.svgNode);
		this.imgNode.style.display = "none";
	} else {
		if ((this.iconSrc.toLowerCase().substring(this.iconSrc.length - 4) == ".png") && (dojo.render.html.ie) && (!dojo.render.html.ie70)) {
			if (dojo.dom.hasParent(this.imgNode) && this.id != "") {
				var parent = this.imgNode.parentNode;
				parent.setAttribute("id", this.id);
			}
			this.imgNode.style.filter = "progid:DXImageTransform.Microsoft.AlphaImageLoader(src='" + this.iconSrc + "', sizingMethod='scale')";
			this.imgNode.src = this._blankImgPath.toString();
		} else {
			if (dojo.dom.hasParent(this.imgNode) && this.id != "") {
				var parent = this.imgNode.parentNode;
				parent.setAttribute("id", this.id);
			}
			this.imgNode.src = this.iconSrc;
		}
	}
	if (this.lblNode) {
		this.lblNode.appendChild(document.createTextNode(this.caption));
	}
	dojo.html.disableSelection(this.domNode);
}, _createSvgNode:function (src) {
	var elm = document.createElement("embed");
	elm.src = src;
	elm.type = "image/svg+xml";
	elm.style.width = "1px";
	elm.style.height = "1px";
	elm.loaded = 0;
	elm.setSizeOnLoad = false;
	elm.onload = function () {
		this.svgRoot = this.getSVGDocument().rootElement;
		this.svgDoc = this.getSVGDocument().documentElement;
		this.zeroWidth = this.svgRoot.width.baseVal.value;
		this.zeroHeight = this.svgRoot.height.baseVal.value;
		this.loaded = true;
		if (this.setSizeOnLoad) {
			this.setSize(this.setWidth, this.setHeight);
		}
	};
	elm.setSize = function (w, h) {
		if (!this.loaded) {
			this.setWidth = w;
			this.setHeight = h;
			this.setSizeOnLoad = true;
			return;
		}
		this.style.width = w + "px";
		this.style.height = h + "px";
		this.svgRoot.width.baseVal.value = w;
		this.svgRoot.height.baseVal.value = h;
		var scale_x = w / this.zeroWidth;
		var scale_y = h / this.zeroHeight;
		for (var i = 0; i < this.svgDoc.childNodes.length; i++) {
			if (this.svgDoc.childNodes[i].setAttribute) {
				this.svgDoc.childNodes[i].setAttribute("transform", "scale(" + scale_x + "," + scale_y + ")");
			}
		}
	};
	return elm;
}, onMouseOver:function (e) {
	if (!this.parent.isOver) {
		this.parent._setActive(e);
	}
	if (this.caption != "") {
		dojo.html.addClass(this.lblNode, "selected");
		this.parent._positionLabel(this);
	}
}, onMouseOut:function (e) {
	dojo.html.removeClass(this.lblNode, "selected");
}, onClick:function (e) {
}});


__CPAN_FILE__ src/widget/ProgressBar.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.widget.ProgressBar");
dojo.require("dojo.widget.*");
dojo.require("dojo.event");
dojo.require("dojo.dom");
dojo.require("dojo.html.style");
dojo.require("dojo.string.*");
dojo.require("dojo.lfx.*");
dojo.widget.defineWidget("dojo.widget.ProgressBar", dojo.widget.HtmlWidget, {progressValue:0, maxProgressValue:100, width:300, height:30, frontPercentClass:"frontPercent", backPercentClass:"backPercent", frontBarClass:"frontBar", backBarClass:"backBar", hasText:false, isVertical:false, showOnlyIntegers:false, dataSource:"", pollInterval:3000, duration:1000, templateString:"<div dojoAttachPoint=\"containerNode\" style=\"position:relative;overflow:hidden\">\n\t<div style=\"position:absolute;display:none;width:100%;text-align:center\" dojoAttachPoint=\"backPercentLabel\" class=\"dojoBackPercentLabel\"></div>\n\t<div style=\"position:absolute;overflow:hidden;width:100%;height:100%\" dojoAttachPoint=\"internalProgress\">\n\t<div style=\"position:absolute;display:none;width:100%;text-align:center\" dojoAttachPoint=\"frontPercentLabel\" class=\"dojoFrontPercentLabel\"></div></div>\n</div>\n", templateCssString:".backBar{\n\tborder:1px solid #84a3d1;\n}\n.frontBar{\n\tbackground:url(\"images/bar.gif\") repeat bottom left;\n\tbackground-attachment: fixed;\n}\n.h-frontBar{\n\tbackground:url(\"images/h-bar.gif\") repeat bottom left;\n\tbackground-attachment: fixed;\n}\n.simpleFrontBar{\n\tbackground: red;\n}\n.frontPercent,.backPercent{\n\tfont:bold 13px helvetica;\n}\n.backPercent{\n\tcolor:#293a4b;\n}\n.frontPercent{\n\tcolor:#fff;\n}\n", templateCssPath:dojo.uri.moduleUri("dojo.widget", "templates/ProgressBar.css"), containerNode:null, internalProgress:null, _pixelUnitRatio:0, _pixelPercentRatio:0, _unitPercentRatio:0, _unitPixelRatio:0, _floatDimension:0, _intDimension:0, _progressPercentValue:"0%", _floatMaxProgressValue:0, _dimension:"width", _pixelValue:0, _oInterval:null, _animation:null, _animationStopped:true, _progressValueBak:false, _hasTextBak:false, fillInTemplate:function (args, frag) {
	this.internalProgress.className = this.frontBarClass;
	this.containerNode.className = this.backBarClass;
	if (this.isVertical) {
		this.internalProgress.style.bottom = "0px";
		this.internalProgress.style.left = "0px";
		this._dimension = "height";
	} else {
		this.internalProgress.style.top = "0px";
		this.internalProgress.style.left = "0px";
		this._dimension = "width";
	}
	this.frontPercentLabel.className = this.frontPercentClass;
	this.backPercentLabel.className = this.backPercentClass;
	this.progressValue = "" + this.progressValue;
	this.domNode.style.height = this.height + "px";
	this.domNode.style.width = this.width + "px";
	this._intDimension = parseInt("0" + eval("this." + this._dimension));
	this._floatDimension = parseFloat("0" + eval("this." + this._dimension));
	this._pixelPercentRatio = this._floatDimension / 100;
	this.setMaxProgressValue(this.maxProgressValue, true);
	this.setProgressValue(dojo.string.trim(this.progressValue), true);
	dojo.debug("float dimension: " + this._floatDimension);
	dojo.debug("this._unitPixelRatio: " + this._unitPixelRatio);
	this.showText(this.hasText);
}, showText:function (visible) {
	if (visible) {
		this.backPercentLabel.style.display = "block";
		this.frontPercentLabel.style.display = "block";
	} else {
		this.backPercentLabel.style.display = "none";
		this.frontPercentLabel.style.display = "none";
	}
	this.hasText = visible;
}, postCreate:function (args, frag) {
	this.render();
}, _backupValues:function () {
	this._progressValueBak = this.progressValue;
	this._hasTextBak = this.hasText;
}, _restoreValues:function () {
	this.setProgressValue(this._progressValueBak);
	this.showText(this._hasTextBak);
}, _setupAnimation:function () {
	var _self = this;
	dojo.debug("internalProgress width: " + this.internalProgress.style.width);
	this._animation = dojo.lfx.html.slideTo(this.internalProgress, {top:0, left:parseInt(this.width) - parseInt(this.internalProgress.style.width)}, parseInt(this.duration), null, function () {
		var _backAnim = dojo.lfx.html.slideTo(_self.internalProgress, {top:0, left:0}, parseInt(_self.duration));
		dojo.event.connect(_backAnim, "onEnd", function () {
			if (!_self._animationStopped) {
				_self._animation.play();
			}
		});
		if (!_self._animationStopped) {
			_backAnim.play();
		}
		_backAnim = null;
	});
}, getMaxProgressValue:function () {
	return this.maxProgressValue;
}, setMaxProgressValue:function (maxValue, noRender) {
	if (!this._animationStopped) {
		return;
	}
	this.maxProgressValue = maxValue;
	this._floatMaxProgressValue = parseFloat("0" + this.maxProgressValue);
	this._pixelUnitRatio = this._floatDimension / this.maxProgressValue;
	this._unitPercentRatio = this._floatMaxProgressValue / 100;
	this._unitPixelRatio = this._floatMaxProgressValue / this._floatDimension;
	this.setProgressValue(this.progressValue, true);
	if (!noRender) {
		this.render();
	}
}, setProgressValue:function (value, noRender) {
	if (!this._animationStopped) {
		return;
	}
	this._progressPercentValue = "0%";
	var _value = dojo.string.trim("" + value);
	var _floatValue = parseFloat("0" + _value);
	var _intValue = parseInt("0" + _value);
	var _pixelValue = 0;
	if (dojo.string.endsWith(_value, "%", false)) {
		this._progressPercentValue = Math.min(_floatValue.toFixed(1), 100) + "%";
		_value = Math.min((_floatValue) * this._unitPercentRatio, this.maxProgressValue);
		_pixelValue = Math.min((_floatValue) * this._pixelPercentRatio, eval("this." + this._dimension));
	} else {
		this.progressValue = Math.min(_floatValue, this.maxProgressValue);
		this._progressPercentValue = Math.min((_floatValue / this._unitPercentRatio).toFixed(1), 100) + "%";
		_pixelValue = Math.min(_floatValue / this._unitPixelRatio, eval("this." + this._dimension));
	}
	this.progressValue = dojo.string.trim(_value);
	this._pixelValue = _pixelValue;
	if (!noRender) {
		this.render();
	}
}, getProgressValue:function () {
	return this.progressValue;
}, getProgressPercentValue:function () {
	return this._progressPercentValue;
}, setDataSource:function (dataSource) {
	this.dataSource = dataSource;
}, setPollInterval:function (pollInterval) {
	this.pollInterval = pollInterval;
}, start:function () {
	var _showFunction = dojo.lang.hitch(this, this._showRemoteProgress);
	this._oInterval = setInterval(_showFunction, this.pollInterval);
}, startAnimation:function () {
	if (this._animationStopped) {
		this._backupValues();
		this.setProgressValue("10%");
		this._animationStopped = false;
		this._setupAnimation();
		this.showText(false);
		this.internalProgress.style.height = "105%";
		this._animation.play();
	}
}, stopAnimation:function () {
	if (this._animation) {
		this._animationStopped = true;
		this._animation.stop();
		this.internalProgress.style.height = "100%";
		this.internalProgress.style.left = "0px";
		this._restoreValues();
		this._setLabelPosition();
	}
}, _showRemoteProgress:function () {
	var _self = this;
	if ((this.getMaxProgressValue() == this.getProgressValue()) && this._oInterval) {
		clearInterval(this._oInterval);
		this._oInterval = null;
		this.setProgressValue("100%");
		return;
	}
	var bArgs = {url:_self.dataSource, method:"POST", mimetype:"text/json", error:function (type, errorObj) {
		dojo.debug("[ProgressBar] showRemoteProgress error");
	}, load:function (type, data, evt) {
		_self.setProgressValue((_self._oInterval ? data["progress"] : "100%"));
	}};
	dojo.io.bind(bArgs);
}, render:function () {
	this._setPercentLabel(dojo.string.trim(this._progressPercentValue));
	this._setPixelValue(this._pixelValue);
	this._setLabelPosition();
}, _setLabelPosition:function () {
	var _widthFront = dojo.html.getContentBox(this.frontPercentLabel).width;
	var _heightFront = dojo.html.getContentBox(this.frontPercentLabel).height;
	var _widthBack = dojo.html.getContentBox(this.backPercentLabel).width;
	var _heightBack = dojo.html.getContentBox(this.backPercentLabel).height;
	var _leftFront = (parseInt(this.width) - _widthFront) / 2 + "px";
	var _bottomFront = (parseInt(this.height) - parseInt(_heightFront)) / 2 + "px";
	var _leftBack = (parseInt(this.width) - _widthBack) / 2 + "px";
	var _bottomBack = (parseInt(this.height) - parseInt(_heightBack)) / 2 + "px";
	this.frontPercentLabel.style.left = _leftFront;
	this.backPercentLabel.style.left = _leftBack;
	this.frontPercentLabel.style.bottom = _bottomFront;
	this.backPercentLabel.style.bottom = _bottomBack;
}, _setPercentLabel:function (percentValue) {
	dojo.dom.removeChildren(this.frontPercentLabel);
	dojo.dom.removeChildren(this.backPercentLabel);
	var _percentValue = this.showOnlyIntegers == false ? percentValue : parseInt(percentValue) + "%";
	this.frontPercentLabel.appendChild(document.createTextNode(_percentValue));
	this.backPercentLabel.appendChild(document.createTextNode(_percentValue));
}, _setPixelValue:function (value) {
	eval("this.internalProgress.style." + this._dimension + " = " + value + " + 'px'");
	this.onChange();
}, onChange:function () {
}});


__CPAN_FILE__ src/widget/UsTextbox.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.widget.UsTextbox");
dojo.require("dojo.widget.ValidationTextbox");
dojo.require("dojo.validate.us");
dojo.widget.defineWidget("dojo.widget.UsStateTextbox", dojo.widget.ValidationTextbox, {mixInProperties:function (localProperties) {
	dojo.widget.UsStateTextbox.superclass.mixInProperties.apply(this, arguments);
	if (localProperties.allowterritories) {
		this.flags.allowTerritories = (localProperties.allowterritories == "true");
	}
	if (localProperties.allowmilitary) {
		this.flags.allowMilitary = (localProperties.allowmilitary == "true");
	}
}, isValid:function () {
	return dojo.validate.us.isState(this.textbox.value, this.flags);
}});
dojo.widget.defineWidget("dojo.widget.UsZipTextbox", dojo.widget.ValidationTextbox, {isValid:function () {
	return dojo.validate.us.isZipCode(this.textbox.value);
}});
dojo.widget.defineWidget("dojo.widget.UsSocialSecurityNumberTextbox", dojo.widget.ValidationTextbox, {isValid:function () {
	return dojo.validate.us.isSocialSecurityNumber(this.textbox.value);
}});
dojo.widget.defineWidget("dojo.widget.UsPhoneNumberTextbox", dojo.widget.ValidationTextbox, {isValid:function () {
	return dojo.validate.us.isPhoneNumber(this.textbox.value);
}});


__CPAN_FILE__ src/widget/TreeControllerExtension.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.widget.TreeControllerExtension");
dojo.declare("dojo.widget.TreeControllerExtension", null, {saveExpandedIndices:function (node, field) {
	var obj = {};
	for (var i = 0; i < node.children.length; i++) {
		if (node.children[i].isExpanded) {
			var key = dojo.lang.isUndefined(field) ? i : node.children[i][field];
			obj[key] = this.saveExpandedIndices(node.children[i], field);
		}
	}
	return obj;
}, restoreExpandedIndices:function (node, savedIndices, field) {
	var _this = this;
	var handler = function (node, savedIndices) {
		this.node = node;
		this.savedIndices = savedIndices;
		this.process = function () {
			_this.restoreExpandedIndices(this.node, this.savedIndices, field);
		};
	};
	for (var i = 0; i < node.children.length; i++) {
		var child = node.children[i];
		var found = false;
		var key = -1;
		if (dojo.lang.isUndefined(field) && savedIndices[i]) {
			found = true;
			key = i;
		}
		if (field) {
			for (var key in savedIndices) {
				if (key == child[field]) {
					found = true;
					break;
				}
			}
		}
		if (found) {
			var h = new handler(child, savedIndices[key]);
			_this.expand(child, false, h, h.process);
		} else {
			if (child.isExpanded) {
				dojo.lang.forEach(child.getDescendants(), function (elem) {
					_this.collapse(elem);
				});
			}
		}
	}
}});


__CPAN_FILE__ src/widget/RealNumberTextbox.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.widget.RealNumberTextbox");
dojo.require("dojo.widget.IntegerTextbox");
dojo.require("dojo.validate.common");
dojo.widget.defineWidget("dojo.widget.RealNumberTextbox", dojo.widget.IntegerTextbox, {mixInProperties:function (localProperties, frag) {
	dojo.widget.RealNumberTextbox.superclass.mixInProperties.apply(this, arguments);
	if (localProperties.places) {
		this.flags.places = Number(localProperties.places);
	}
	if ((localProperties.exponent == "true") || (localProperties.exponent == "always")) {
		this.flags.exponent = true;
	} else {
		if ((localProperties.exponent == "false") || (localProperties.exponent == "never")) {
			this.flags.exponent = false;
		} else {
			this.flags.exponent = [true, false];
		}
	}
	if ((localProperties.esigned == "true") || (localProperties.esigned == "always")) {
		this.flags.eSigned = true;
	} else {
		if ((localProperties.esigned == "false") || (localProperties.esigned == "never")) {
			this.flags.eSigned = false;
		} else {
			this.flags.eSigned = [true, false];
		}
	}
	if (localProperties.min) {
		this.flags.min = parseFloat(localProperties.min);
	}
	if (localProperties.max) {
		this.flags.max = parseFloat(localProperties.max);
	}
}, isValid:function () {
	return dojo.validate.isRealNumber(this.textbox.value, this.flags);
}, isInRange:function () {
	return dojo.validate.isInRange(this.textbox.value, this.flags);
}});


__CPAN_FILE__ src/widget/ComboBox.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.widget.ComboBox");
dojo.require("dojo.widget.*");
dojo.require("dojo.event.*");
dojo.require("dojo.io.*");
dojo.require("dojo.html.*");
dojo.require("dojo.string");
dojo.require("dojo.widget.html.stabile");
dojo.require("dojo.widget.PopupContainer");
dojo.declare("dojo.widget.incrementalComboBoxDataProvider", null, function (options) {
	this.searchUrl = options.dataUrl;
	this._cache = {};
	this._inFlight = false;
	this._lastRequest = null;
	this.allowCache = false;
}, {_addToCache:function (keyword, data) {
	if (this.allowCache) {
		this._cache[keyword] = data;
	}
}, startSearch:function (searchStr, callback) {
	if (this._inFlight) {
	}
	var tss = encodeURIComponent(searchStr);
	var realUrl = dojo.string.substituteParams(this.searchUrl, {"searchString":tss});
	var _this = this;
	var request = this._lastRequest = dojo.io.bind({url:realUrl, method:"get", mimetype:"text/json", load:function (type, data, evt) {
		_this._inFlight = false;
		if (!dojo.lang.isArray(data)) {
			var arrData = [];
			for (var key in data) {
				arrData.push([data[key], key]);
			}
			data = arrData;
		}
		_this._addToCache(searchStr, data);
		if (request == _this._lastRequest) {
			callback(data);
		}
	}});
	this._inFlight = true;
}});
dojo.declare("dojo.widget.basicComboBoxDataProvider", null, function (options, node) {
	this._data = [];
	this.searchLimit = 30;
	this.searchType = "STARTSTRING";
	this.caseSensitive = false;
	if (!dj_undef("dataUrl", options) && !dojo.string.isBlank(options.dataUrl)) {
		this._getData(options.dataUrl);
	} else {
		if ((node) && (node.nodeName.toLowerCase() == "select")) {
			var opts = node.getElementsByTagName("option");
			var ol = opts.length;
			var data = [];
			for (var x = 0; x < ol; x++) {
				var text = opts[x].textContent || opts[x].innerText || opts[x].innerHTML;
				var keyValArr = [String(text), String(opts[x].value)];
				data.push(keyValArr);
				if (opts[x].selected) {
					options.setAllValues(keyValArr[0], keyValArr[1]);
				}
			}
			this.setData(data);
		}
	}
}, {_getData:function (url) {
	dojo.io.bind({url:url, load:dojo.lang.hitch(this, function (type, data, evt) {
		if (!dojo.lang.isArray(data)) {
			var arrData = [];
			for (var key in data) {
				arrData.push([data[key], key]);
			}
			data = arrData;
		}
		this.setData(data);
	}), mimetype:"text/json"});
}, startSearch:function (searchStr, callback) {
	this._performSearch(searchStr, callback);
}, _performSearch:function (searchStr, callback) {
	var st = this.searchType;
	var ret = [];
	if (!this.caseSensitive) {
		searchStr = searchStr.toLowerCase();
	}
	for (var x = 0; x < this._data.length; x++) {
		if ((this.searchLimit > 0) && (ret.length >= this.searchLimit)) {
			break;
		}
		var dataLabel = new String((!this.caseSensitive) ? this._data[x][0].toLowerCase() : this._data[x][0]);
		if (dataLabel.length < searchStr.length) {
			continue;
		}
		if (st == "STARTSTRING") {
			if (searchStr == dataLabel.substr(0, searchStr.length)) {
				ret.push(this._data[x]);
			}
		} else {
			if (st == "SUBSTRING") {
				if (dataLabel.indexOf(searchStr) >= 0) {
					ret.push(this._data[x]);
				}
			} else {
				if (st == "STARTWORD") {
					var idx = dataLabel.indexOf(searchStr);
					if (idx == 0) {
						ret.push(this._data[x]);
					}
					if (idx <= 0) {
						continue;
					}
					var matches = false;
					while (idx != -1) {
						if (" ,/(".indexOf(dataLabel.charAt(idx - 1)) != -1) {
							matches = true;
							break;
						}
						idx = dataLabel.indexOf(searchStr, idx + 1);
					}
					if (!matches) {
						continue;
					} else {
						ret.push(this._data[x]);
					}
				}
			}
		}
	}
	callback(ret);
}, setData:function (pdata) {
	this._data = pdata;
}});
dojo.widget.defineWidget("dojo.widget.ComboBox", dojo.widget.HtmlWidget, {forceValidOption:false, searchType:"stringstart", dataProvider:null, autoComplete:true, searchDelay:100, dataUrl:"", fadeTime:200, maxListLength:8, mode:"local", selectedResult:null, dataProviderClass:"", buttonSrc:dojo.uri.moduleUri("dojo.widget", "templates/images/combo_box_arrow.png"), dropdownToggle:"fade", templateString:"<span _=\"whitespace and CR's between tags adds &nbsp; in FF\"\n\tclass=\"dojoComboBoxOuter\"\n\t><input style=\"display:none\"  tabindex=\"-1\" name=\"\" value=\"\" \n\t\tdojoAttachPoint=\"comboBoxValue\"\n\t><input style=\"display:none\"  tabindex=\"-1\" name=\"\" value=\"\" \n\t\tdojoAttachPoint=\"comboBoxSelectionValue\"\n\t><input type=\"text\" autocomplete=\"off\" class=\"dojoComboBox\"\n\t\tdojoAttachEvent=\"key:_handleKeyEvents; keyUp: onKeyUp; compositionEnd; onResize;\"\n\t\tdojoAttachPoint=\"textInputNode\"\n\t><img hspace=\"0\"\n\t\tvspace=\"0\"\n\t\tclass=\"dojoComboBox\"\n\t\tdojoAttachPoint=\"downArrowNode\"\n\t\tdojoAttachEvent=\"onMouseUp: handleArrowClick; onResize;\"\n\t\tsrc=\"${this.buttonSrc}\"\n></span>\n", templateCssString:".dojoComboBoxOuter {\n\tborder: 0px !important;\n\tmargin: 0px !important;\n\tpadding: 0px !important;\n\tbackground: transparent !important;\n\twhite-space: nowrap !important;\n}\n\n.dojoComboBox {\n\tborder: 1px inset #afafaf;\n\tmargin: 0px;\n\tpadding: 0px;\n\tvertical-align: middle !important;\n\tfloat: none !important;\n\tposition: static !important;\n\tdisplay: inline !important;\n}\n\n/* the input box */\ninput.dojoComboBox {\n\tborder-right-width: 0px !important; \n\tmargin-right: 0px !important;\n\tpadding-right: 0px !important;\n}\n\n/* the down arrow */\nimg.dojoComboBox {\n\tborder-left-width: 0px !important;\n\tpadding-left: 0px !important;\n\tmargin-left: 0px !important;\n}\n\n/* IE vertical-alignment calculations can be off by +-1 but these margins are collapsed away */\n.dj_ie img.dojoComboBox {\n\tmargin-top: 1px; \n\tmargin-bottom: 1px; \n}\n\n/* the drop down */\n.dojoComboBoxOptions {\n\tfont-family: Verdana, Helvetica, Garamond, sans-serif;\n\t/* font-size: 0.7em; */\n\tbackground-color: white;\n\tborder: 1px solid #afafaf;\n\tposition: absolute;\n\tz-index: 1000; \n\toverflow: auto;\n\tcursor: default;\n}\n\n.dojoComboBoxItem {\n\tpadding-left: 2px;\n\tpadding-top: 2px;\n\tmargin: 0px;\n}\n\n.dojoComboBoxItemEven {\n\tbackground-color: #f4f4f4;\n}\n\n.dojoComboBoxItemOdd {\n\tbackground-color: white;\n}\n\n.dojoComboBoxItemHighlight {\n\tbackground-color: #63709A;\n\tcolor: white;\n}\n", templateCssPath:dojo.uri.moduleUri("dojo.widget", "templates/ComboBox.css"), setValue:function (value) {
	this.comboBoxValue.value = value;
	if (this.textInputNode.value != value) {
		this.textInputNode.value = value;
		dojo.widget.html.stabile.setState(this.widgetId, this.getState(), true);
		this.onValueChanged(value);
	}
}, onValueChanged:function (value) {
}, getValue:function () {
	return this.comboBoxValue.value;
}, getState:function () {
	return {value:this.getValue()};
}, setState:function (state) {
	this.setValue(state.value);
}, enable:function () {
	this.disabled = false;
	this.textInputNode.removeAttribute("disabled");
}, disable:function () {
	this.disabled = true;
	this.textInputNode.setAttribute("disabled", true);
}, _getCaretPos:function (element) {
	if (dojo.lang.isNumber(element.selectionStart)) {
		return element.selectionStart;
	} else {
		if (dojo.render.html.ie) {
			var tr = document.selection.createRange().duplicate();
			var ntr = element.createTextRange();
			tr.move("character", 0);
			ntr.move("character", 0);
			try {
				ntr.setEndPoint("EndToEnd", tr);
				return String(ntr.text).replace(/\r/g, "").length;
			}
			catch (e) {
				return 0;
			}
		}
	}
}, _setCaretPos:function (element, location) {
	location = parseInt(location);
	this._setSelectedRange(element, location, location);
}, _setSelectedRange:function (element, start, end) {
	if (!end) {
		end = element.value.length;
	}
	if (element.setSelectionRange) {
		element.focus();
		element.setSelectionRange(start, end);
	} else {
		if (element.createTextRange) {
			var range = element.createTextRange();
			with (range) {
				collapse(true);
				moveEnd("character", end);
				moveStart("character", start);
				select();
			}
		} else {
			element.value = element.value;
			element.blur();
			element.focus();
			var dist = parseInt(element.value.length) - end;
			var tchar = String.fromCharCode(37);
			var tcc = tchar.charCodeAt(0);
			for (var x = 0; x < dist; x++) {
				var te = document.createEvent("KeyEvents");
				te.initKeyEvent("keypress", true, true, null, false, false, false, false, tcc, tcc);
				element.dispatchEvent(te);
			}
		}
	}
}, _handleKeyEvents:function (evt) {
	if (evt.ctrlKey || evt.altKey || !evt.key) {
		return;
	}
	this._prev_key_backspace = false;
	this._prev_key_esc = false;
	var k = dojo.event.browser.keys;
	var doSearch = true;
	switch (evt.key) {
	  case k.KEY_DOWN_ARROW:
		if (!this.popupWidget.isShowingNow) {
			this._startSearchFromInput();
		}
		this._highlightNextOption();
		dojo.event.browser.stopEvent(evt);
		return;
	  case k.KEY_UP_ARROW:
		this._highlightPrevOption();
		dojo.event.browser.stopEvent(evt);
		return;
	  case k.KEY_TAB:
		if (!this.autoComplete && this.popupWidget.isShowingNow && this._highlighted_option) {
			dojo.event.browser.stopEvent(evt);
			this._selectOption({"target":this._highlighted_option, "noHide":false});
			this._setSelectedRange(this.textInputNode, this.textInputNode.value.length, null);
		} else {
			this._selectOption();
			return;
		}
		break;
	  case k.KEY_ENTER:
		if (this.popupWidget.isShowingNow) {
			dojo.event.browser.stopEvent(evt);
		}
		if (this.autoComplete) {
			this._selectOption();
			return;
		}
	  case " ":
		if (this.popupWidget.isShowingNow && this._highlighted_option) {
			dojo.event.browser.stopEvent(evt);
			this._selectOption();
			this._hideResultList();
			return;
		}
		break;
	  case k.KEY_ESCAPE:
		this._hideResultList();
		this._prev_key_esc = true;
		return;
	  case k.KEY_BACKSPACE:
		this._prev_key_backspace = true;
		if (!this.textInputNode.value.length) {
			this.setAllValues("", "");
			this._hideResultList();
			doSearch = false;
		}
		break;
	  case k.KEY_RIGHT_ARROW:
	  case k.KEY_LEFT_ARROW:
		doSearch = false;
		break;
	  default:
		if (evt.charCode == 0) {
			doSearch = false;
		}
	}
	if (this.searchTimer) {
		clearTimeout(this.searchTimer);
	}
	if (doSearch) {
		this._blurOptionNode();
		this.searchTimer = setTimeout(dojo.lang.hitch(this, this._startSearchFromInput), this.searchDelay);
	}
}, compositionEnd:function (evt) {
	evt.key = evt.keyCode;
	this._handleKeyEvents(evt);
}, onKeyUp:function (evt) {
	this.setValue(this.textInputNode.value);
}, setSelectedValue:function (value) {
	this.comboBoxSelectionValue.value = value;
}, setAllValues:function (value1, value2) {
	this.setSelectedValue(value2);
	this.setValue(value1);
}, _focusOptionNode:function (node) {
	if (this._highlighted_option != node) {
		this._blurOptionNode();
		this._highlighted_option = node;
		dojo.html.addClass(this._highlighted_option, "dojoComboBoxItemHighlight");
	}
}, _blurOptionNode:function () {
	if (this._highlighted_option) {
		dojo.html.removeClass(this._highlighted_option, "dojoComboBoxItemHighlight");
		this._highlighted_option = null;
	}
}, _highlightNextOption:function () {
	if ((!this._highlighted_option) || !this._highlighted_option.parentNode) {
		this._focusOptionNode(this.optionsListNode.firstChild);
	} else {
		if (this._highlighted_option.nextSibling) {
			this._focusOptionNode(this._highlighted_option.nextSibling);
		}
	}
	dojo.html.scrollIntoView(this._highlighted_option);
}, _highlightPrevOption:function () {
	if (this._highlighted_option && this._highlighted_option.previousSibling) {
		this._focusOptionNode(this._highlighted_option.previousSibling);
	} else {
		this._highlighted_option = null;
		this._hideResultList();
		return;
	}
	dojo.html.scrollIntoView(this._highlighted_option);
}, _itemMouseOver:function (evt) {
	if (evt.target === this.optionsListNode) {
		return;
	}
	this._focusOptionNode(evt.target);
	dojo.html.addClass(this._highlighted_option, "dojoComboBoxItemHighlight");
}, _itemMouseOut:function (evt) {
	if (evt.target === this.optionsListNode) {
		return;
	}
	this._blurOptionNode();
}, onResize:function () {
	var inputSize = dojo.html.getContentBox(this.textInputNode);
	if (inputSize.height <= 0) {
		dojo.lang.setTimeout(this, "onResize", 100);
		return;
	}
	var buttonSize = {width:inputSize.height, height:inputSize.height};
	dojo.html.setContentBox(this.downArrowNode, buttonSize);
}, fillInTemplate:function (args, frag) {
	dojo.html.applyBrowserClass(this.domNode);
	var source = this.getFragNodeRef(frag);
	if (!this.name && source.name) {
		this.name = source.name;
	}
	this.comboBoxValue.name = this.name;
	this.comboBoxSelectionValue.name = this.name + "_selected";
	dojo.html.copyStyle(this.domNode, source);
	dojo.html.copyStyle(this.textInputNode, source);
	dojo.html.copyStyle(this.downArrowNode, source);
	with (this.downArrowNode.style) {
		width = "0px";
		height = "0px";
	}
	var dpClass;
	if (this.dataProviderClass) {
		if (typeof this.dataProviderClass == "string") {
			dpClass = dojo.evalObjPath(this.dataProviderClass);
		} else {
			dpClass = this.dataProviderClass;
		}
	} else {
		if (this.mode == "remote") {
			dpClass = dojo.widget.incrementalComboBoxDataProvider;
		} else {
			dpClass = dojo.widget.basicComboBoxDataProvider;
		}
	}
	this.dataProvider = new dpClass(this, this.getFragNodeRef(frag));
	this.popupWidget = new dojo.widget.createWidget("PopupContainer", {toggle:this.dropdownToggle, toggleDuration:this.toggleDuration});
	dojo.event.connect(this, "destroy", this.popupWidget, "destroy");
	this.optionsListNode = this.popupWidget.domNode;
	this.domNode.appendChild(this.optionsListNode);
	dojo.html.addClass(this.optionsListNode, "dojoComboBoxOptions");
	dojo.event.connect(this.optionsListNode, "onclick", this, "_selectOption");
	dojo.event.connect(this.optionsListNode, "onmouseover", this, "_onMouseOver");
	dojo.event.connect(this.optionsListNode, "onmouseout", this, "_onMouseOut");
	dojo.event.connect(this.optionsListNode, "onmouseover", this, "_itemMouseOver");
	dojo.event.connect(this.optionsListNode, "onmouseout", this, "_itemMouseOut");
}, _openResultList:function (results) {
	if (this.disabled) {
		return;
	}
	this._clearResultList();
	if (!results.length) {
		this._hideResultList();
	}
	if ((this.autoComplete) && (results.length) && (!this._prev_key_backspace) && (this.textInputNode.value.length > 0)) {
		var cpos = this._getCaretPos(this.textInputNode);
		if ((cpos + 1) > this.textInputNode.value.length) {
			this.textInputNode.value += results[0][0].substr(cpos);
			this._setSelectedRange(this.textInputNode, cpos, this.textInputNode.value.length);
		}
	}
	var even = true;
	while (results.length) {
		var tr = results.shift();
		if (tr) {
			var td = document.createElement("div");
			td.appendChild(document.createTextNode(tr[0]));
			td.setAttribute("resultName", tr[0]);
			td.setAttribute("resultValue", tr[1]);
			td.className = "dojoComboBoxItem " + ((even) ? "dojoComboBoxItemEven" : "dojoComboBoxItemOdd");
			even = (!even);
			this.optionsListNode.appendChild(td);
		}
	}
	this._showResultList();
}, _onFocusInput:function () {
	this._hasFocus = true;
}, _onBlurInput:function () {
	this._hasFocus = false;
	this._handleBlurTimer(true, 500);
}, _handleBlurTimer:function (clear, millisec) {
	if (this.blurTimer && (clear || millisec)) {
		clearTimeout(this.blurTimer);
	}
	if (millisec) {
		this.blurTimer = dojo.lang.setTimeout(this, "_checkBlurred", millisec);
	}
}, _onMouseOver:function (evt) {
	if (!this._mouseover_list) {
		this._handleBlurTimer(true, 0);
		this._mouseover_list = true;
	}
}, _onMouseOut:function (evt) {
	var relTarget = evt.relatedTarget;
	try {
		if (!relTarget || relTarget.parentNode != this.optionsListNode) {
			this._mouseover_list = false;
			this._handleBlurTimer(true, 100);
			this._tryFocus();
		}
	}
	catch (e) {
	}
}, _isInputEqualToResult:function (result) {
	var input = this.textInputNode.value;
	if (!this.dataProvider.caseSensitive) {
		input = input.toLowerCase();
		result = result.toLowerCase();
	}
	return (input == result);
}, _isValidOption:function () {
	var tgt = dojo.html.firstElement(this.optionsListNode);
	var isValidOption = false;
	while (!isValidOption && tgt) {
		if (this._isInputEqualToResult(tgt.getAttribute("resultName"))) {
			isValidOption = true;
		} else {
			tgt = dojo.html.nextElement(tgt);
		}
	}
	return isValidOption;
}, _checkBlurred:function () {
	if (!this._hasFocus && !this._mouseover_list) {
		this._hideResultList();
		if (!this.textInputNode.value.length) {
			this.setAllValues("", "");
			return;
		}
		var isValidOption = this._isValidOption();
		if (this.forceValidOption && !isValidOption) {
			this.setAllValues("", "");
			return;
		}
		if (!isValidOption) {
			this.setSelectedValue("");
		}
	}
}, _selectOption:function (evt) {
	var tgt = null;
	if (!evt) {
		evt = {target:this._highlighted_option};
	}
	if (!dojo.html.isDescendantOf(evt.target, this.optionsListNode)) {
		if (!this.textInputNode.value.length) {
			return;
		}
		tgt = dojo.html.firstElement(this.optionsListNode);
		if (!tgt || !this._isInputEqualToResult(tgt.getAttribute("resultName"))) {
			return;
		}
	} else {
		tgt = evt.target;
	}
	while ((tgt.nodeType != 1) || (!tgt.getAttribute("resultName"))) {
		tgt = tgt.parentNode;
		if (tgt === dojo.body()) {
			return false;
		}
	}
	this.selectedResult = [tgt.getAttribute("resultName"), tgt.getAttribute("resultValue")];
	this.setAllValues(tgt.getAttribute("resultName"), tgt.getAttribute("resultValue"));
	if (!evt.noHide) {
		this._hideResultList();
		this._setSelectedRange(this.textInputNode, 0, null);
	}
	this._tryFocus();
}, _clearResultList:function () {
	if (this.optionsListNode.innerHTML) {
		this.optionsListNode.innerHTML = "";
	}
}, _hideResultList:function () {
	this.popupWidget.close();
}, _showResultList:function () {
	var childs = this.optionsListNode.childNodes;
	if (childs.length) {
		var visibleCount = Math.min(childs.length, this.maxListLength);
		with (this.optionsListNode.style) {
			display = "";
			if (visibleCount == childs.length) {
				height = "";
			} else {
				height = visibleCount * dojo.html.getMarginBox(childs[0]).height + "px";
			}
			width = (dojo.html.getMarginBox(this.domNode).width - 2) + "px";
		}
		this.popupWidget.open(this.domNode, this, this.downArrowNode);
	} else {
		this._hideResultList();
	}
}, handleArrowClick:function () {
	this._handleBlurTimer(true, 0);
	this._tryFocus();
	if (this.popupWidget.isShowingNow) {
		this._hideResultList();
	} else {
		this._startSearch("");
	}
}, _tryFocus:function () {
	try {
		this.textInputNode.focus();
	}
	catch (e) {
	}
}, _startSearchFromInput:function () {
	this._startSearch(this.textInputNode.value);
}, _startSearch:function (key) {
	this.dataProvider.startSearch(key, dojo.lang.hitch(this, "_openResultList"));
}, postCreate:function () {
	this.onResize();
	dojo.event.connect(this.textInputNode, "onblur", this, "_onBlurInput");
	dojo.event.connect(this.textInputNode, "onfocus", this, "_onFocusInput");
	if (this.disabled) {
		this.disable();
	}
	var s = dojo.widget.html.stabile.getState(this.widgetId);
	if (s) {
		this.setState(s);
	}
}});


__CPAN_FILE__ src/widget/SplitContainer.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.widget.SplitContainer");
dojo.require("dojo.widget.*");
dojo.require("dojo.widget.ContentPane");
dojo.require("dojo.widget.HtmlWidget");
dojo.require("dojo.html.style");
dojo.require("dojo.html.layout");
dojo.require("dojo.html.selection");
dojo.require("dojo.io.cookie");
dojo.widget.defineWidget("dojo.widget.SplitContainer", dojo.widget.HtmlWidget, function () {
	this.sizers = [];
}, {isContainer:true, templateCssString:".dojoSplitContainer{\n\tposition: relative;\n\toverflow: hidden;\n\tdisplay: block;\n}\n\n.dojoSplitPane{\n\tposition: absolute;\n}\n\n.dojoSplitContainerSizerH,\n.dojoSplitContainerSizerV {\n\tfont-size: 1px;\n\tcursor: move;\n\tcursor: w-resize;\n\tbackground-color: ThreeDFace;\n\tborder: 1px solid;\n\tborder-color: ThreeDHighlight ThreeDShadow ThreeDShadow ThreeDHighlight;\n\tmargin: 0;\n}\n\n.dojoSplitContainerSizerV {\n\tcursor: n-resize;\n}\n\n.dojoSplitContainerVirtualSizerH,\n.dojoSplitContainerVirtualSizerV {\n\tfont-size: 1px;\n\tcursor: move;\n\tcursor: w-resize;\n\tbackground-color: ThreeDShadow;\n\t-moz-opacity: 0.5;\n\topacity: 0.5;\n\tfilter: Alpha(Opacity=50);\n\tmargin: 0;\n}\n\n.dojoSplitContainerVirtualSizerV {\n\tcursor: n-resize;\n}\n", templateCssPath:dojo.uri.moduleUri("dojo.widget", "templates/SplitContainer.css"), activeSizing:false, sizerWidth:15, orientation:"horizontal", persist:true, postMixInProperties:function () {
	dojo.widget.SplitContainer.superclass.postMixInProperties.apply(this, arguments);
	this.isHorizontal = (this.orientation == "horizontal");
}, fillInTemplate:function () {
	dojo.widget.SplitContainer.superclass.fillInTemplate.apply(this, arguments);
	dojo.html.addClass(this.domNode, "dojoSplitContainer");
	if (dojo.render.html.moz) {
		this.domNode.style.overflow = "-moz-scrollbars-none";
	}
	var content = dojo.html.getContentBox(this.domNode);
	this.paneWidth = content.width;
	this.paneHeight = content.height;
}, onResized:function (e) {
	var content = dojo.html.getContentBox(this.domNode);
	this.paneWidth = content.width;
	this.paneHeight = content.height;
	this._layoutPanels();
}, postCreate:function (args, fragment, parentComp) {
	dojo.widget.SplitContainer.superclass.postCreate.apply(this, arguments);
	for (var i = 0; i < this.children.length; i++) {
		with (this.children[i].domNode.style) {
			position = "absolute";
		}
		dojo.html.addClass(this.children[i].domNode, "dojoSplitPane");
		if (i == this.children.length - 1) {
			break;
		}
		this._addSizer();
	}
	if (typeof this.sizerWidth == "object") {
		try {
			this.sizerWidth = parseInt(this.sizerWidth.toString());
		}
		catch (e) {
			this.sizerWidth = 15;
		}
	}
	this.virtualSizer = document.createElement("div");
	this.virtualSizer.style.position = "absolute";
	this.virtualSizer.style.display = "none";
	this.virtualSizer.style.zIndex = 10;
	this.virtualSizer.className = this.isHorizontal ? "dojoSplitContainerVirtualSizerH" : "dojoSplitContainerVirtualSizerV";
	this.domNode.appendChild(this.virtualSizer);
	dojo.html.disableSelection(this.virtualSizer);
	if (this.persist) {
		this._restoreState();
	}
	this.resizeSoon();
}, _injectChild:function (child) {
	with (child.domNode.style) {
		position = "absolute";
	}
	dojo.html.addClass(child.domNode, "dojoSplitPane");
}, _addSizer:function () {
	var i = this.sizers.length;
	this.sizers[i] = document.createElement("div");
	this.sizers[i].style.position = "absolute";
	this.sizers[i].className = this.isHorizontal ? "dojoSplitContainerSizerH" : "dojoSplitContainerSizerV";
	var self = this;
	var handler = (function () {
		var sizer_i = i;
		return function (e) {
			self.beginSizing(e, sizer_i);
		};
	})();
	dojo.event.connect(this.sizers[i], "onmousedown", handler);
	this.domNode.appendChild(this.sizers[i]);
	dojo.html.disableSelection(this.sizers[i]);
}, removeChild:function (widget) {
	if (this.sizers.length > 0) {
		for (var x = 0; x < this.children.length; x++) {
			if (this.children[x] === widget) {
				var i = this.sizers.length - 1;
				this.domNode.removeChild(this.sizers[i]);
				this.sizers.length = i;
				break;
			}
		}
	}
	dojo.widget.SplitContainer.superclass.removeChild.call(this, widget, arguments);
	this.onResized();
}, addChild:function (widget) {
	dojo.widget.SplitContainer.superclass.addChild.apply(this, arguments);
	this._injectChild(widget);
	if (this.children.length > 1) {
		this._addSizer();
	}
	this._layoutPanels();
}, _layoutPanels:function () {
	if (this.children.length == 0) {
		return;
	}
	var space = this.isHorizontal ? this.paneWidth : this.paneHeight;
	if (this.children.length > 1) {
		space -= this.sizerWidth * (this.children.length - 1);
	}
	var out_of = 0;
	for (var i = 0; i < this.children.length; i++) {
		out_of += this.children[i].sizeShare;
	}
	var pix_per_unit = space / out_of;
	var total_size = 0;
	for (var i = 0; i < this.children.length - 1; i++) {
		var size = Math.round(pix_per_unit * this.children[i].sizeShare);
		this.children[i].sizeActual = size;
		total_size += size;
	}
	this.children[this.children.length - 1].sizeActual = space - total_size;
	this._checkSizes();
	var pos = 0;
	var size = this.children[0].sizeActual;
	this._movePanel(this.children[0], pos, size);
	this.children[0].position = pos;
	pos += size;
	for (var i = 1; i < this.children.length; i++) {
		this._moveSlider(this.sizers[i - 1], pos, this.sizerWidth);
		this.sizers[i - 1].position = pos;
		pos += this.sizerWidth;
		size = this.children[i].sizeActual;
		this._movePanel(this.children[i], pos, size);
		this.children[i].position = pos;
		pos += size;
	}
}, _movePanel:function (panel, pos, size) {
	if (this.isHorizontal) {
		panel.domNode.style.left = pos + "px";
		panel.domNode.style.top = 0;
		panel.resizeTo(size, this.paneHeight);
	} else {
		panel.domNode.style.left = 0;
		panel.domNode.style.top = pos + "px";
		panel.resizeTo(this.paneWidth, size);
	}
}, _moveSlider:function (slider, pos, size) {
	if (this.isHorizontal) {
		slider.style.left = pos + "px";
		slider.style.top = 0;
		dojo.html.setMarginBox(slider, {width:size, height:this.paneHeight});
	} else {
		slider.style.left = 0;
		slider.style.top = pos + "px";
		dojo.html.setMarginBox(slider, {width:this.paneWidth, height:size});
	}
}, _growPane:function (growth, pane) {
	if (growth > 0) {
		if (pane.sizeActual > pane.sizeMin) {
			if ((pane.sizeActual - pane.sizeMin) > growth) {
				pane.sizeActual = pane.sizeActual - growth;
				growth = 0;
			} else {
				growth -= pane.sizeActual - pane.sizeMin;
				pane.sizeActual = pane.sizeMin;
			}
		}
	}
	return growth;
}, _checkSizes:function () {
	var total_min_size = 0;
	var total_size = 0;
	for (var i = 0; i < this.children.length; i++) {
		total_size += this.children[i].sizeActual;
		total_min_size += this.children[i].sizeMin;
	}
	if (total_min_size <= total_size) {
		var growth = 0;
		for (var i = 0; i < this.children.length; i++) {
			if (this.children[i].sizeActual < this.children[i].sizeMin) {
				growth += this.children[i].sizeMin - this.children[i].sizeActual;
				this.children[i].sizeActual = this.children[i].sizeMin;
			}
		}
		if (growth > 0) {
			if (this.isDraggingLeft) {
				for (var i = this.children.length - 1; i >= 0; i--) {
					growth = this._growPane(growth, this.children[i]);
				}
			} else {
				for (var i = 0; i < this.children.length; i++) {
					growth = this._growPane(growth, this.children[i]);
				}
			}
		}
	} else {
		for (var i = 0; i < this.children.length; i++) {
			this.children[i].sizeActual = Math.round(total_size * (this.children[i].sizeMin / total_min_size));
		}
	}
}, beginSizing:function (e, i) {
	this.paneBefore = this.children[i];
	this.paneAfter = this.children[i + 1];
	this.isSizing = true;
	this.sizingSplitter = this.sizers[i];
	this.originPos = dojo.html.getAbsolutePosition(this.children[0].domNode, true, dojo.html.boxSizing.MARGIN_BOX);
	if (this.isHorizontal) {
		var client = (e.layerX ? e.layerX : e.offsetX);
		var screen = e.pageX;
		this.originPos = this.originPos.x;
	} else {
		var client = (e.layerY ? e.layerY : e.offsetY);
		var screen = e.pageY;
		this.originPos = this.originPos.y;
	}
	this.startPoint = this.lastPoint = screen;
	this.screenToClientOffset = screen - client;
	this.dragOffset = this.lastPoint - this.paneBefore.sizeActual - this.originPos - this.paneBefore.position;
	if (!this.activeSizing) {
		this._showSizingLine();
	}
	dojo.event.connect(document.documentElement, "onmousemove", this, "changeSizing");
	dojo.event.connect(document.documentElement, "onmouseup", this, "endSizing");
	dojo.event.browser.stopEvent(e);
}, changeSizing:function (e) {
	this.lastPoint = this.isHorizontal ? e.pageX : e.pageY;
	if (this.activeSizing) {
		this.movePoint();
		this._updateSize();
	} else {
		this.movePoint();
		this._moveSizingLine();
	}
	dojo.event.browser.stopEvent(e);
}, endSizing:function (e) {
	if (!this.activeSizing) {
		this._hideSizingLine();
	}
	this._updateSize();
	this.isSizing = false;
	dojo.event.disconnect(document.documentElement, "onmousemove", this, "changeSizing");
	dojo.event.disconnect(document.documentElement, "onmouseup", this, "endSizing");
	if (this.persist) {
		this._saveState(this);
	}
}, movePoint:function () {
	var p = this.lastPoint - this.screenToClientOffset;
	var a = p - this.dragOffset;
	a = this.legaliseSplitPoint(a);
	p = a + this.dragOffset;
	this.lastPoint = p + this.screenToClientOffset;
}, legaliseSplitPoint:function (a) {
	a += this.sizingSplitter.position;
	this.isDraggingLeft = (a > 0) ? true : false;
	if (!this.activeSizing) {
		if (a < this.paneBefore.position + this.paneBefore.sizeMin) {
			a = this.paneBefore.position + this.paneBefore.sizeMin;
		}
		if (a > this.paneAfter.position + (this.paneAfter.sizeActual - (this.sizerWidth + this.paneAfter.sizeMin))) {
			a = this.paneAfter.position + (this.paneAfter.sizeActual - (this.sizerWidth + this.paneAfter.sizeMin));
		}
	}
	a -= this.sizingSplitter.position;
	this._checkSizes();
	return a;
}, _updateSize:function () {
	var pos = this.lastPoint - this.dragOffset - this.originPos;
	var start_region = this.paneBefore.position;
	var end_region = this.paneAfter.position + this.paneAfter.sizeActual;
	this.paneBefore.sizeActual = pos - start_region;
	this.paneAfter.position = pos + this.sizerWidth;
	this.paneAfter.sizeActual = end_region - this.paneAfter.position;
	for (var i = 0; i < this.children.length; i++) {
		this.children[i].sizeShare = this.children[i].sizeActual;
	}
	this._layoutPanels();
}, _showSizingLine:function () {
	this._moveSizingLine();
	if (this.isHorizontal) {
		dojo.html.setMarginBox(this.virtualSizer, {width:this.sizerWidth, height:this.paneHeight});
	} else {
		dojo.html.setMarginBox(this.virtualSizer, {width:this.paneWidth, height:this.sizerWidth});
	}
	this.virtualSizer.style.display = "block";
}, _hideSizingLine:function () {
	this.virtualSizer.style.display = "none";
}, _moveSizingLine:function () {
	var pos = this.lastPoint - this.startPoint + this.sizingSplitter.position;
	if (this.isHorizontal) {
		this.virtualSizer.style.left = pos + "px";
	} else {
		var pos = (this.lastPoint - this.startPoint) + this.sizingSplitter.position;
		this.virtualSizer.style.top = pos + "px";
	}
}, _getCookieName:function (i) {
	return this.widgetId + "_" + i;
}, _restoreState:function () {
	for (var i = 0; i < this.children.length; i++) {
		var cookieName = this._getCookieName(i);
		var cookieValue = dojo.io.cookie.getCookie(cookieName);
		if (cookieValue != null) {
			var pos = parseInt(cookieValue);
			if (typeof pos == "number") {
				this.children[i].sizeShare = pos;
			}
		}
	}
}, _saveState:function () {
	for (var i = 0; i < this.children.length; i++) {
		var cookieName = this._getCookieName(i);
		dojo.io.cookie.setCookie(cookieName, this.children[i].sizeShare, null, null, null, null);
	}
}});
dojo.lang.extend(dojo.widget.Widget, {sizeMin:10, sizeShare:10});
dojo.widget.defineWidget("dojo.widget.SplitContainerPanel", dojo.widget.ContentPane, {});


__CPAN_FILE__ src/widget/TreeExpandToNodeOnSelect.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.widget.TreeExpandToNodeOnSelect");
dojo.require("dojo.widget.HtmlWidget");
dojo.widget.defineWidget("dojo.widget.TreeExpandToNodeOnSelect", dojo.widget.HtmlWidget, {selector:"", controller:"", withSelected:false, initialize:function () {
	this.selector = dojo.widget.byId(this.selector);
	this.controller = dojo.widget.byId(this.controller);
	dojo.event.topic.subscribe(this.selector.eventNames.select, this, "onSelect");
}, onSelectEvent:function (message) {
	this.controller.expandToNode(message.node, this.withSelected);
}});


__CPAN_FILE__ src/widget/FloatingPane.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.widget.FloatingPane");
dojo.require("dojo.widget.*");
dojo.require("dojo.widget.Manager");
dojo.require("dojo.html.*");
dojo.require("dojo.html.layout");
dojo.require("dojo.html.iframe");
dojo.require("dojo.html.selection");
dojo.require("dojo.lfx.shadow");
dojo.require("dojo.widget.html.layout");
dojo.require("dojo.widget.ContentPane");
dojo.require("dojo.dnd.HtmlDragMove");
dojo.require("dojo.widget.Dialog");
dojo.require("dojo.widget.ResizeHandle");
dojo.declare("dojo.widget.FloatingPaneBase", null, {title:"", iconSrc:"", hasShadow:false, constrainToContainer:false, taskBarId:"", resizable:true, titleBarDisplay:true, windowState:"normal", displayCloseAction:false, displayMinimizeAction:false, displayMaximizeAction:false, _max_taskBarConnectAttempts:5, _taskBarConnectAttempts:0, templateString:"<div id=\"${this.widgetId}\" dojoAttachEvent=\"onMouseDown\" class=\"dojoFloatingPane\">\n\t<div dojoAttachPoint=\"titleBar\" class=\"dojoFloatingPaneTitleBar\"  style=\"display:none\">\n\t  \t<img dojoAttachPoint=\"titleBarIcon\"  class=\"dojoFloatingPaneTitleBarIcon\">\n\t\t<div dojoAttachPoint=\"closeAction\" dojoAttachEvent=\"onClick:closeWindow\"\n   \t  \t\tclass=\"dojoFloatingPaneCloseIcon\"></div>\n\t\t<div dojoAttachPoint=\"restoreAction\" dojoAttachEvent=\"onClick:restoreWindow\"\n   \t  \t\tclass=\"dojoFloatingPaneRestoreIcon\"></div>\n\t\t<div dojoAttachPoint=\"maximizeAction\" dojoAttachEvent=\"onClick:maximizeWindow\"\n   \t  \t\tclass=\"dojoFloatingPaneMaximizeIcon\"></div>\n\t\t<div dojoAttachPoint=\"minimizeAction\" dojoAttachEvent=\"onClick:minimizeWindow\"\n   \t  \t\tclass=\"dojoFloatingPaneMinimizeIcon\"></div>\n\t  \t<div dojoAttachPoint=\"titleBarText\" class=\"dojoFloatingPaneTitleText\">${this.title}</div>\n\t</div>\n\n\t<div id=\"${this.widgetId}_container\" dojoAttachPoint=\"containerNode\" class=\"dojoFloatingPaneClient\"></div>\n\n\t<div dojoAttachPoint=\"resizeBar\" class=\"dojoFloatingPaneResizebar\" style=\"display:none\"></div>\n</div>\n", templateCssString:"\n/********** Outer Window ***************/\n\n.dojoFloatingPane {\n\t/* essential css */\n\tposition: absolute;\n\toverflow: visible;\t\t/* so drop shadow is displayed */\n\tz-index: 10;\n\n\t/* styling css */\n\tborder: 1px solid;\n\tborder-color: ThreeDHighlight ThreeDShadow ThreeDShadow ThreeDHighlight;\n\tbackground-color: ThreeDFace;\n}\n\n\n/********** Title Bar ****************/\n\n.dojoFloatingPaneTitleBar {\n\tvertical-align: top;\n\tmargin: 2px 2px 2px 2px;\n\tz-index: 10;\n\tbackground-color: #7596c6;\n\tcursor: default;\n\toverflow: hidden;\n\tborder-color: ThreeDHighlight ThreeDShadow ThreeDShadow ThreeDHighlight;\n\tvertical-align: middle;\n}\n\n.dojoFloatingPaneTitleText {\n\tfloat: left;\n\tpadding: 2px 4px 2px 2px;\n\twhite-space: nowrap;\n\tcolor: CaptionText;\n\tfont: small-caption;\n}\n\n.dojoTitleBarIcon {\n\tfloat: left;\n\theight: 22px;\n\twidth: 22px;\n\tvertical-align: middle;\n\tmargin-right: 5px;\n\tmargin-left: 5px;\n}\n\n.dojoFloatingPaneActions{\n\tfloat: right;\n\tposition: absolute;\n\tright: 2px;\n\ttop: 2px;\n\tvertical-align: middle;\n}\n\n\n.dojoFloatingPaneActionItem {\n\tvertical-align: middle;\n\tmargin-right: 1px;\n\theight: 22px;\n\twidth: 22px;\n}\n\n\n.dojoFloatingPaneTitleBarIcon {\n\t/* essential css */\n\tfloat: left;\n\n\t/* styling css */\n\tmargin-left: 2px;\n\tmargin-right: 4px;\n\theight: 22px;\n}\n\n/* minimize/maximize icons are specified by CSS only */\n.dojoFloatingPaneMinimizeIcon,\n.dojoFloatingPaneMaximizeIcon,\n.dojoFloatingPaneRestoreIcon,\n.dojoFloatingPaneCloseIcon {\n\tvertical-align: middle;\n\theight: 22px;\n\twidth: 22px;\n\tfloat: right;\n}\n.dojoFloatingPaneMinimizeIcon {\n\tbackground-image: url(images/floatingPaneMinimize.gif);\n}\n.dojoFloatingPaneMaximizeIcon {\n\tbackground-image: url(images/floatingPaneMaximize.gif);\n}\n.dojoFloatingPaneRestoreIcon {\n\tbackground-image: url(images/floatingPaneRestore.gif);\n}\n.dojoFloatingPaneCloseIcon {\n\tbackground-image: url(images/floatingPaneClose.gif);\n}\n\n/* bar at bottom of window that holds resize handle */\n.dojoFloatingPaneResizebar {\n\tz-index: 10;\n\theight: 13px;\n\tbackground-color: ThreeDFace;\n}\n\n/************* Client Area ***************/\n\n.dojoFloatingPaneClient {\n\tposition: relative;\n\tz-index: 10;\n\tborder: 1px solid;\n\tborder-color: ThreeDShadow ThreeDHighlight ThreeDHighlight ThreeDShadow;\n\tmargin: 2px;\n\tbackground-color: ThreeDFace;\n\tpadding: 8px;\n\tfont-family: Verdana, Helvetica, Garamond, sans-serif;\n\tfont-size: 12px;\n\toverflow: auto;\n}\n\n", templateCssPath:dojo.uri.moduleUri("dojo.widget", "templates/FloatingPane.css"), fillInFloatingPaneTemplate:function (args, frag) {
	var source = this.getFragNodeRef(frag);
	dojo.html.copyStyle(this.domNode, source);
	dojo.body().appendChild(this.domNode);
	if (!this.isShowing()) {
		this.windowState = "minimized";
	}
	if (this.iconSrc == "") {
		dojo.html.removeNode(this.titleBarIcon);
	} else {
		this.titleBarIcon.src = this.iconSrc.toString();
	}
	if (this.titleBarDisplay) {
		this.titleBar.style.display = "";
		dojo.html.disableSelection(this.titleBar);
		this.titleBarIcon.style.display = (this.iconSrc == "" ? "none" : "");
		this.minimizeAction.style.display = (this.displayMinimizeAction ? "" : "none");
		this.maximizeAction.style.display = (this.displayMaximizeAction && this.windowState != "maximized" ? "" : "none");
		this.restoreAction.style.display = (this.displayMaximizeAction && this.windowState == "maximized" ? "" : "none");
		this.closeAction.style.display = (this.displayCloseAction ? "" : "none");
		this.drag = new dojo.dnd.HtmlDragMoveSource(this.domNode);
		if (this.constrainToContainer) {
			this.drag.constrainTo();
		}
		this.drag.setDragHandle(this.titleBar);
		var self = this;
		dojo.event.topic.subscribe("dragMove", function (info) {
			if (info.source.domNode == self.domNode) {
				dojo.event.topic.publish("floatingPaneMove", {source:self});
			}
		});
	}
	if (this.resizable) {
		this.resizeBar.style.display = "";
		this.resizeHandle = dojo.widget.createWidget("ResizeHandle", {targetElmId:this.widgetId, id:this.widgetId + "_resize"});
		this.resizeBar.appendChild(this.resizeHandle.domNode);
	}
	if (this.hasShadow) {
		this.shadow = new dojo.lfx.shadow(this.domNode);
	}
	this.bgIframe = new dojo.html.BackgroundIframe(this.domNode);
	if (this.taskBarId) {
		this._taskBarSetup();
	}
	dojo.body().removeChild(this.domNode);
}, postCreate:function () {
	if (dojo.hostenv.post_load_) {
		this._setInitialWindowState();
	} else {
		dojo.addOnLoad(this, "_setInitialWindowState");
	}
}, maximizeWindow:function (evt) {
	var mb = dojo.html.getMarginBox(this.domNode);
	this.previous = {width:mb.width || this.width, height:mb.height || this.height, left:this.domNode.style.left, top:this.domNode.style.top, bottom:this.domNode.style.bottom, right:this.domNode.style.right};
	if (this.domNode.parentNode.style.overflow.toLowerCase() != "hidden") {
		this.parentPrevious = {overflow:this.domNode.parentNode.style.overflow};
		dojo.debug(this.domNode.parentNode.style.overflow);
		this.domNode.parentNode.style.overflow = "hidden";
	}
	this.domNode.style.left = dojo.html.getPixelValue(this.domNode.parentNode, "padding-left", true) + "px";
	this.domNode.style.top = dojo.html.getPixelValue(this.domNode.parentNode, "padding-top", true) + "px";
	if ((this.domNode.parentNode.nodeName.toLowerCase() == "body")) {
		var viewport = dojo.html.getViewport();
		var padding = dojo.html.getPadding(dojo.body());
		this.resizeTo(viewport.width - padding.width, viewport.height - padding.height);
	} else {
		var content = dojo.html.getContentBox(this.domNode.parentNode);
		this.resizeTo(content.width, content.height);
	}
	this.maximizeAction.style.display = "none";
	this.restoreAction.style.display = "";
	if (this.resizeHandle) {
		this.resizeHandle.domNode.style.display = "none";
	}
	this.drag.setDragHandle(null);
	this.windowState = "maximized";
}, minimizeWindow:function (evt) {
	this.hide();
	for (var attr in this.parentPrevious) {
		this.domNode.parentNode.style[attr] = this.parentPrevious[attr];
	}
	this.lastWindowState = this.windowState;
	this.windowState = "minimized";
}, restoreWindow:function (evt) {
	if (this.windowState == "minimized") {
		this.show();
		if (this.lastWindowState == "maximized") {
			this.domNode.parentNode.style.overflow = "hidden";
			this.windowState = "maximized";
		} else {
			this.windowState = "normal";
		}
	} else {
		if (this.windowState == "maximized") {
			for (var attr in this.previous) {
				this.domNode.style[attr] = this.previous[attr];
			}
			for (var attr in this.parentPrevious) {
				this.domNode.parentNode.style[attr] = this.parentPrevious[attr];
			}
			this.resizeTo(this.previous.width, this.previous.height);
			this.previous = null;
			this.parentPrevious = null;
			this.restoreAction.style.display = "none";
			this.maximizeAction.style.display = this.displayMaximizeAction ? "" : "none";
			if (this.resizeHandle) {
				this.resizeHandle.domNode.style.display = "";
			}
			this.drag.setDragHandle(this.titleBar);
			this.windowState = "normal";
		} else {
		}
	}
}, toggleDisplay:function () {
	if (this.windowState == "minimized") {
		this.restoreWindow();
	} else {
		this.minimizeWindow();
	}
}, closeWindow:function (evt) {
	dojo.html.removeNode(this.domNode);
	this.destroy();
}, onMouseDown:function (evt) {
	this.bringToTop();
}, bringToTop:function () {
	var floatingPanes = dojo.widget.manager.getWidgetsByType(this.widgetType);
	var windows = [];
	for (var x = 0; x < floatingPanes.length; x++) {
		if (this.widgetId != floatingPanes[x].widgetId) {
			windows.push(floatingPanes[x]);
		}
	}
	windows.sort(function (a, b) {
		return a.domNode.style.zIndex - b.domNode.style.zIndex;
	});
	windows.push(this);
	var floatingPaneStartingZ = 100;
	for (x = 0; x < windows.length; x++) {
		windows[x].domNode.style.zIndex = floatingPaneStartingZ + x * 2;
	}
}, _setInitialWindowState:function () {
	if (this.isShowing()) {
		this.width = -1;
		var mb = dojo.html.getMarginBox(this.domNode);
		this.resizeTo(mb.width, mb.height);
	}
	if (this.windowState == "maximized") {
		this.maximizeWindow();
		this.show();
		return;
	}
	if (this.windowState == "normal") {
		this.show();
		return;
	}
	if (this.windowState == "minimized") {
		this.hide();
		return;
	}
	this.windowState = "minimized";
}, _taskBarSetup:function () {
	var taskbar = dojo.widget.getWidgetById(this.taskBarId);
	if (!taskbar) {
		if (this._taskBarConnectAttempts < this._max_taskBarConnectAttempts) {
			dojo.lang.setTimeout(this, this._taskBarSetup, 50);
			this._taskBarConnectAttempts++;
		} else {
			dojo.debug("Unable to connect to the taskBar");
		}
		return;
	}
	taskbar.addChild(this);
}, showFloatingPane:function () {
	this.bringToTop();
}, onFloatingPaneShow:function () {
	var mb = dojo.html.getMarginBox(this.domNode);
	this.resizeTo(mb.width, mb.height);
}, resizeTo:function (width, height) {
	dojo.html.setMarginBox(this.domNode, {width:width, height:height});
	dojo.widget.html.layout(this.domNode, [{domNode:this.titleBar, layoutAlign:"top"}, {domNode:this.resizeBar, layoutAlign:"bottom"}, {domNode:this.containerNode, layoutAlign:"client"}]);
	dojo.widget.html.layout(this.containerNode, this.children, "top-bottom");
	this.bgIframe.onResized();
	if (this.shadow) {
		this.shadow.size(width, height);
	}
	this.onResized();
}, checkSize:function () {
}, destroyFloatingPane:function () {
	if (this.resizeHandle) {
		this.resizeHandle.destroy();
		this.resizeHandle = null;
	}
}});
dojo.widget.defineWidget("dojo.widget.FloatingPane", [dojo.widget.ContentPane, dojo.widget.FloatingPaneBase], {fillInTemplate:function (args, frag) {
	this.fillInFloatingPaneTemplate(args, frag);
	dojo.widget.FloatingPane.superclass.fillInTemplate.call(this, args, frag);
}, postCreate:function () {
	dojo.widget.FloatingPaneBase.prototype.postCreate.apply(this, arguments);
	dojo.widget.FloatingPane.superclass.postCreate.apply(this, arguments);
}, show:function () {
	dojo.widget.FloatingPane.superclass.show.apply(this, arguments);
	this.showFloatingPane();
}, onShow:function () {
	dojo.widget.FloatingPane.superclass.onShow.call(this);
	this.onFloatingPaneShow();
}, destroy:function () {
	this.destroyFloatingPane();
	dojo.widget.FloatingPane.superclass.destroy.apply(this, arguments);
}});
dojo.widget.defineWidget("dojo.widget.ModalFloatingPane", [dojo.widget.FloatingPane, dojo.widget.ModalDialogBase], {windowState:"minimized", displayCloseAction:true, postCreate:function () {
	dojo.widget.ModalDialogBase.prototype.postCreate.call(this);
	dojo.widget.ModalFloatingPane.superclass.postCreate.call(this);
}, show:function () {
	this.showModalDialog();
	dojo.widget.ModalFloatingPane.superclass.show.apply(this, arguments);
	this.bg.style.zIndex = this.domNode.style.zIndex - 1;
}, hide:function () {
	this.hideModalDialog();
	dojo.widget.ModalFloatingPane.superclass.hide.apply(this, arguments);
}, closeWindow:function () {
	this.hide();
	dojo.widget.ModalFloatingPane.superclass.closeWindow.apply(this, arguments);
}});


__CPAN_FILE__ src/widget/YahooMap.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.widget.YahooMap");
dojo.require("dojo.event.*");
dojo.require("dojo.math");
dojo.require("dojo.widget.*");
dojo.require("dojo.widget.HtmlWidget");
(function () {
	var yappid = djConfig["yAppId"] || djConfig["yahooAppId"] || "dojotoolkit";
	if (!dojo.hostenv.post_load_) {
		if (yappid == "dojotoolkit") {
			dojo.debug("please provide a unique Yahoo App ID in djConfig.yahooAppId when using the map widget");
		}
		var tag = "<scr" + "ipt src='http://api.maps.yahoo.com/ajaxymap?v=3.0&appid=" + yappid + "'></scri" + "pt>";
		if (!dj_global["YMap"]) {
			document.write(tag);
		}
	} else {
		dojo.debug("cannot initialize map system after the page has been loaded! Please either manually include the script block provided by Yahoo in your page or require() the YahooMap widget before onload has fired");
	}
})();
dojo.widget.defineWidget("dojo.widget.YahooMap", dojo.widget.HtmlWidget, function () {
	this.map = null;
	this.datasrc = "";
	this.data = [];
	this.width = 0;
	this.height = 0;
	this.controls = ["zoomlong", "maptype", "pan"];
}, {isContainer:false, templatePath:null, templateCssPath:null, findCenter:function (aPts) {
	var start = new YGeoPoint(37, -90);
	if (aPts.length == 0) {
		return start;
	}
	var minLat, maxLat, minLon, maxLon, cLat, cLon;
	minLat = maxLat = aPts[0].Lat;
	minLon = maxLon = aPts[0].Lon;
	for (var i = 0; i < aPts.length; i++) {
		minLat = Math.min(minLat, aPts[i].Lat);
		maxLat = Math.max(maxLat, aPts[i].Lat);
		minLon = Math.min(minLon, aPts[i].Lon);
		maxLon = Math.max(maxLon, aPts[i].Lon);
	}
	cLat = dojo.math.round((minLat + maxLat) / 2, 6);
	cLon = dojo.math.round((minLon + maxLon) / 2, 6);
	return new YGeoPoint(cLat, cLon);
}, setControls:function () {
	var methodmap = {maptype:"addTypeControl", pan:"addPanControl", zoomlong:"addZoomLong", zoomshort:"addZoomShort"};
	var c = this.controls;
	for (var i = 0; i < c.length; i++) {
		var controlMethod = methodmap[c[i].toLowerCase()];
		if (this.map[controlMethod]) {
			this.map[controlMethod]();
		}
	}
}, parse:function (table) {
	this.data = [];
	var h = table.getElementsByTagName("thead")[0];
	if (!h) {
		return;
	}
	var a = [];
	var cols = h.getElementsByTagName("td");
	if (cols.length == 0) {
		cols = h.getElementsByTagName("th");
	}
	for (var i = 0; i < cols.length; i++) {
		var c = cols[i].innerHTML.toLowerCase();
		if (c == "long") {
			c = "lng";
		}
		a.push(c);
	}
	var b = table.getElementsByTagName("tbody")[0];
	if (!b) {
		return;
	}
	for (var i = 0; i < b.childNodes.length; i++) {
		if (!(b.childNodes[i].nodeName && b.childNodes[i].nodeName.toLowerCase() == "tr")) {
			continue;
		}
		var cells = b.childNodes[i].getElementsByTagName("td");
		var o = {};
		for (var j = 0; j < a.length; j++) {
			var col = a[j];
			if (col == "lat" || col == "lng") {
				o[col] = parseFloat(cells[j].innerHTML);
			} else {
				o[col] = cells[j].innerHTML;
			}
		}
		this.data.push(o);
	}
}, render:function () {
	var pts = [];
	var d = this.data;
	for (var i = 0; i < d.length; i++) {
		var pt = new YGeoPoint(d[i].lat, d[i].lng);
		pts.push(pt);
		var icon = d[i].icon || null;
		if (icon) {
			icon = new YImage(icon);
		}
		var m = new YMarker(pt, icon);
		if (d[i].description) {
			m.addAutoExpand("<div>" + d[i].description + "</div>");
		}
		this.map.addOverlay(m);
	}
	var c = this.findCenter(pts);
	var z = this.map.getZoomLevel(pts);
	this.map.drawZoomAndCenter(c, z);
}, initialize:function (args, frag) {
	if (!YMap || !YGeoPoint) {
		dojo.raise("dojo.widget.YahooMap: The Yahoo Map script must be included in order to use this widget.");
	}
	if (this.datasrc) {
		this.parse(dojo.byId(this.datasrc));
	} else {
		if (this.domNode.getElementsByTagName("table")[0]) {
			this.parse(this.domNode.getElementsByTagName("table")[0]);
		}
	}
}, postCreate:function () {
	while (this.domNode.childNodes.length > 0) {
		this.domNode.removeChild(this.domNode.childNodes[0]);
	}
	if (this.width > 0 && this.height > 0) {
		this.map = new YMap(this.domNode, YAHOO_MAP_REG, new YSize(this.width, this.height));
	} else {
		this.map = new YMap(this.domNode);
	}
	this.setControls();
	this.render();
}});


__CPAN_FILE__ src/widget/TreeDemo.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.widget.TreeDemo");
dojo.require("dojo.Deferred");
dojo.widget.TreeDemo = {reportIfDefered:function (res) {
	if (res instanceof dojo.Deferred) {
		res.addCallbacks(function (res) {
			return res;
		}, function (err) {
			dojo.debug("Error");
			dojo.debugShallow(err);
		});
	}
}, resetRandomChildren:function (maxCount) {
	this.randomChildrenMaxCount = maxCount;
	this.randomChildrenCount = 0;
	this.randomChildrenDepth = 0;
}, makeRandomChildren:function (title) {
	this.randomChildrenDepth++;
	var children = [];
	for (var i = 1; i <= 5; i++) {
		var t = title + (this.randomChildrenDepth == 1 ? "" : ".") + i;
		var node = {title:t};
		children.push(node);
		this.randomChildrenCount++;
		if (this.randomChildrenCount >= this.randomChildrenMaxCount) {
			break;
		}
	}
	var i = 1;
	var _this = this;
	dojo.lang.forEach(children, function (child) {
		var t = title + (_this.randomChildrenDepth == 1 ? "" : ".") + i;
		i++;
		if (_this.randomChildrenCount < _this.randomChildrenMaxCount && (_this.randomChildrenDepth == 1 && child === children[0] || _this.randomChildrenDepth < 5 && Math.random() > 0.3)) {
			child.children = _this.makeRandomChildren(t);
		}
	});
	this.randomChildrenDepth--;
	return children;
}, bindDemoMenu:function (controller) {
	var _t = this;
	dojo.event.topic.subscribe("treeContextMenuDestroy/engage", function (menuItem) {
		var node = menuItem.getTreeNode();
		_t.reportIfDefered(controller.destroyChild(node));
	});
	dojo.event.topic.subscribe("treeContextMenuRefresh/engage", function (menuItem) {
		var node = menuItem.getTreeNode();
		_t.reportIfDefered(controller.refreshChildren(node));
	});
	dojo.event.topic.subscribe("treeContextMenuCreate/engage", function (menuItem) {
		var node = menuItem.getTreeNode();
		var d = controller.createAndEdit(node, 0);
		_t.reportIfDefered(d);
	});
	dojo.event.topic.subscribe("treeContextMenuUp/engage", function (menuItem) {
		var node = menuItem.getTreeNode();
		if (node.isFirstChild()) {
			return;
		}
		_t.reportIfDefered(controller.move(node, node.parent, node.getParentIndex() - 1));
	});
	dojo.event.topic.subscribe("treeContextMenuDown/engage", function (menuItem) {
		var node = menuItem.getTreeNode();
		if (node.isLastChild()) {
			return;
		}
		_t.reportIfDefered(controller.move(node, node.parent, node.getParentIndex() + 1));
	});
	dojo.event.topic.subscribe("treeContextMenuEdit/engage", function (menuItem) {
		var node = menuItem.getTreeNode();
		_t.reportIfDefered(controller.editLabelStart(node));
	});
}};


__CPAN_FILE__ src/widget/SvgWidget.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.require("dojo.widget.DomWidget");
dojo.provide("dojo.widget.SvgWidget");
dojo.provide("dojo.widget.SVGWidget");
dojo.require("dojo.dom");
dojo.require("dojo.experimental");
dojo.experimental("dojo.widget.SvgWidget");
dojo.widget.declare("dojo.widget.SvgWidget", dojo.widget.DomWidget, {createNodesFromText:function (txt, wrap) {
	return dojo.svg.createNodesFromText(txt, wrap);
}});
dojo.widget.SVGWidget = dojo.widget.SvgWidget;
try {
	(function () {
		var tf = function () {
			var rw = new function () {
				dojo.widget.SvgWidget.call(this);
				this.buildRendering = function () {
					return;
				};
				this.destroyRendering = function () {
					return;
				};
				this.postInitialize = function () {
					return;
				};
				this.widgetType = "SVGRootWidget";
				this.domNode = document.documentElement;
			};
			var wm = dojo.widget.manager;
			wm.root = rw;
			wm.add(rw);
			wm.getWidgetFromNode = function (node) {
				var filter = function (x) {
					if (x.domNode == node) {
						return true;
					}
				};
				var widgets = [];
				while ((node) && (widgets.length < 1)) {
					widgets = this.getWidgetsByFilter(filter);
					node = node.parentNode;
				}
				if (widgets.length > 0) {
					return widgets[0];
				} else {
					return null;
				}
			};
			wm.getWidgetFromEvent = function (domEvt) {
				return this.getWidgetFromNode(domEvt.target);
			};
			wm.getWidgetFromPrimitive = wm.getWidgetFromNode;
		};
		dojo.event.connect(dojo.hostenv, "loaded", tf);
	})();
}
catch (e) {
	alert(e);
}


__CPAN_FILE__ src/widget/SortableTable.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.widget.SortableTable");
dojo.deprecated("SortableTable will be removed in favor of FilteringTable.", "0.5");
dojo.require("dojo.lang.common");
dojo.require("dojo.date.format");
dojo.require("dojo.html.*");
dojo.require("dojo.html.selection");
dojo.require("dojo.html.util");
dojo.require("dojo.html.style");
dojo.require("dojo.event.*");
dojo.require("dojo.widget.*");
dojo.require("dojo.widget.HtmlWidget");
dojo.widget.defineWidget("dojo.widget.SortableTable", dojo.widget.HtmlWidget, function () {
	this.data = [];
	this.selected = [];
	this.columns = [];
}, {enableMultipleSelect:false, maximumNumberOfSelections:0, enableAlternateRows:false, minRows:0, defaultDateFormat:"%D", sortIndex:0, sortDirection:0, valueField:"Id", headClass:"", tbodyClass:"", headerClass:"", headerSortUpClass:"selected", headerSortDownClass:"selected", rowClass:"", rowAlternateClass:"alt", rowSelectedClass:"selected", columnSelected:"sorted-column", isContainer:false, templatePath:null, templateCssPath:null, getTypeFromString:function (s) {
	var parts = s.split("."), i = 0, obj = dj_global;
	do {
		obj = obj[parts[i++]];
	} while (i < parts.length && obj);
	return (obj != dj_global) ? obj : null;
}, compare:function (o1, o2) {
	for (var p in o1) {
		if (!(p in o2)) {
			return false;
		}
		if (o1[p].valueOf() != o2[p].valueOf()) {
			return false;
		}
	}
	return true;
}, isSelected:function (o) {
	for (var i = 0; i < this.selected.length; i++) {
		if (this.compare(this.selected[i], o)) {
			return true;
		}
	}
	return false;
}, removeFromSelected:function (o) {
	var idx = -1;
	for (var i = 0; i < this.selected.length; i++) {
		if (this.compare(this.selected[i], o)) {
			idx = i;
			break;
		}
	}
	if (idx >= 0) {
		this.selected.splice(idx, 1);
	}
}, getSelection:function () {
	return this.selected;
}, getValue:function () {
	var a = [];
	for (var i = 0; i < this.selected.length; i++) {
		if (this.selected[i][this.valueField]) {
			a.push(this.selected[i][this.valueField]);
		}
	}
	return a.join();
}, reset:function () {
	this.columns = [];
	this.data = [];
	this.resetSelections(this.domNode.getElementsByTagName("tbody")[0]);
}, resetSelections:function (body) {
	this.selected = [];
	var idx = 0;
	var rows = body.getElementsByTagName("tr");
	for (var i = 0; i < rows.length; i++) {
		if (rows[i].parentNode == body) {
			rows[i].removeAttribute("selected");
			if (this.enableAlternateRows && idx % 2 == 1) {
				rows[i].className = this.rowAlternateClass;
			} else {
				rows[i].className = "";
			}
			idx++;
		}
	}
}, getObjectFromRow:function (row) {
	var cells = row.getElementsByTagName("td");
	var o = {};
	for (var i = 0; i < this.columns.length; i++) {
		if (this.columns[i].sortType == "__markup__") {
			o[this.columns[i].getField()] = cells[i].innerHTML;
		} else {
			var text = dojo.html.renderedTextContent(cells[i]);
			var val = text;
			if (this.columns[i].getType() != String) {
				var val = new (this.columns[i].getType())(text);
			}
			o[this.columns[i].getField()] = val;
		}
	}
	if (dojo.html.hasAttribute(row, "value")) {
		o[this.valueField] = dojo.html.getAttribute(row, "value");
	}
	return o;
}, setSelectionByRow:function (row) {
	var o = this.getObjectFromRow(row);
	var b = false;
	for (var i = 0; i < this.selected.length; i++) {
		if (this.compare(this.selected[i], o)) {
			b = true;
			break;
		}
	}
	if (!b) {
		this.selected.push(o);
	}
}, parseColumns:function (node) {
	this.reset();
	var row = node.getElementsByTagName("tr")[0];
	var cells = row.getElementsByTagName("td");
	if (cells.length == 0) {
		cells = row.getElementsByTagName("th");
	}
	for (var i = 0; i < cells.length; i++) {
		var o = {field:null, format:null, noSort:false, sortType:"String", dataType:String, sortFunction:null, label:null, align:"left", valign:"middle", getField:function () {
			return this.field || this.label;
		}, getType:function () {
			return this.dataType;
		}};
		if (dojo.html.hasAttribute(cells[i], "align")) {
			o.align = dojo.html.getAttribute(cells[i], "align");
		}
		if (dojo.html.hasAttribute(cells[i], "valign")) {
			o.valign = dojo.html.getAttribute(cells[i], "valign");
		}
		if (dojo.html.hasAttribute(cells[i], "nosort")) {
			o.noSort = dojo.html.getAttribute(cells[i], "nosort") == "true";
		}
		if (dojo.html.hasAttribute(cells[i], "sortusing")) {
			var trans = dojo.html.getAttribute(cells[i], "sortusing");
			var f = this.getTypeFromString(trans);
			if (f != null && f != window && typeof (f) == "function") {
				o.sortFunction = f;
			}
		}
		if (dojo.html.hasAttribute(cells[i], "field")) {
			o.field = dojo.html.getAttribute(cells[i], "field");
		}
		if (dojo.html.hasAttribute(cells[i], "format")) {
			o.format = dojo.html.getAttribute(cells[i], "format");
		}
		if (dojo.html.hasAttribute(cells[i], "dataType")) {
			var sortType = dojo.html.getAttribute(cells[i], "dataType");
			if (sortType.toLowerCase() == "html" || sortType.toLowerCase() == "markup") {
				o.sortType = "__markup__";
				o.noSort = true;
			} else {
				var type = this.getTypeFromString(sortType);
				if (type) {
					o.sortType = sortType;
					o.dataType = type;
				}
			}
		}
		o.label = dojo.html.renderedTextContent(cells[i]);
		this.columns.push(o);
		if (dojo.html.hasAttribute(cells[i], "sort")) {
			this.sortIndex = i;
			var dir = dojo.html.getAttribute(cells[i], "sort");
			if (!isNaN(parseInt(dir))) {
				dir = parseInt(dir);
				this.sortDirection = (dir != 0) ? 1 : 0;
			} else {
				this.sortDirection = (dir.toLowerCase() == "desc") ? 1 : 0;
			}
		}
	}
}, parseData:function (data) {
	this.data = [];
	this.selected = [];
	for (var i = 0; i < data.length; i++) {
		var o = {};
		for (var j = 0; j < this.columns.length; j++) {
			var field = this.columns[j].getField();
			if (this.columns[j].sortType == "__markup__") {
				o[field] = String(data[i][field]);
			} else {
				var type = this.columns[j].getType();
				var val = data[i][field];
				var t = this.columns[j].sortType.toLowerCase();
				if (type == String) {
					o[field] = val;
				} else {
					if (val != null) {
						o[field] = new type(val);
					} else {
						o[field] = new type();
					}
				}
			}
		}
		if (data[i][this.valueField] && !o[this.valueField]) {
			o[this.valueField] = data[i][this.valueField];
		}
		this.data.push(o);
	}
}, parseDataFromTable:function (tbody) {
	this.data = [];
	this.selected = [];
	var rows = tbody.getElementsByTagName("tr");
	for (var i = 0; i < rows.length; i++) {
		if (dojo.html.getAttribute(rows[i], "ignoreIfParsed") == "true") {
			continue;
		}
		var o = {};
		var cells = rows[i].getElementsByTagName("td");
		for (var j = 0; j < this.columns.length; j++) {
			var field = this.columns[j].getField();
			if (this.columns[j].sortType == "__markup__") {
				o[field] = cells[j].innerHTML;
			} else {
				var type = this.columns[j].getType();
				var val = dojo.html.renderedTextContent(cells[j]);
				if (type == String) {
					o[field] = val;
				} else {
					if (val != null) {
						o[field] = new type(val);
					} else {
						o[field] = new type();
					}
				}
			}
		}
		if (dojo.html.hasAttribute(rows[i], "value") && !o[this.valueField]) {
			o[this.valueField] = dojo.html.getAttribute(rows[i], "value");
		}
		this.data.push(o);
		if (dojo.html.getAttribute(rows[i], "selected") == "true") {
			this.selected.push(o);
		}
	}
}, showSelections:function () {
	var body = this.domNode.getElementsByTagName("tbody")[0];
	var rows = body.getElementsByTagName("tr");
	var idx = 0;
	for (var i = 0; i < rows.length; i++) {
		if (rows[i].parentNode == body) {
			if (dojo.html.getAttribute(rows[i], "selected") == "true") {
				rows[i].className = this.rowSelectedClass;
			} else {
				if (this.enableAlternateRows && idx % 2 == 1) {
					rows[i].className = this.rowAlternateClass;
				} else {
					rows[i].className = "";
				}
			}
			idx++;
		}
	}
}, render:function (bDontPreserve) {
	var data = [];
	var body = this.domNode.getElementsByTagName("tbody")[0];
	if (!bDontPreserve) {
		this.parseDataFromTable(body);
	}
	for (var i = 0; i < this.data.length; i++) {
		data.push(this.data[i]);
	}
	var col = this.columns[this.sortIndex];
	if (!col.noSort) {
		var field = col.getField();
		if (col.sortFunction) {
			var sort = col.sortFunction;
		} else {
			var sort = function (a, b) {
				if (a[field] > b[field]) {
					return 1;
				}
				if (a[field] < b[field]) {
					return -1;
				}
				return 0;
			};
		}
		data.sort(sort);
		if (this.sortDirection != 0) {
			data.reverse();
		}
	}
	while (body.childNodes.length > 0) {
		body.removeChild(body.childNodes[0]);
	}
	for (var i = 0; i < data.length; i++) {
		var row = document.createElement("tr");
		dojo.html.disableSelection(row);
		if (data[i][this.valueField]) {
			row.setAttribute("value", data[i][this.valueField]);
		}
		if (this.isSelected(data[i])) {
			row.className = this.rowSelectedClass;
			row.setAttribute("selected", "true");
		} else {
			if (this.enableAlternateRows && i % 2 == 1) {
				row.className = this.rowAlternateClass;
			}
		}
		for (var j = 0; j < this.columns.length; j++) {
			var cell = document.createElement("td");
			cell.setAttribute("align", this.columns[j].align);
			cell.setAttribute("valign", this.columns[j].valign);
			dojo.html.disableSelection(cell);
			if (this.sortIndex == j) {
				cell.className = this.columnSelected;
			}
			if (this.columns[j].sortType == "__markup__") {
				cell.innerHTML = data[i][this.columns[j].getField()];
				for (var k = 0; k < cell.childNodes.length; k++) {
					var node = cell.childNodes[k];
					if (node && node.nodeType == dojo.html.ELEMENT_NODE) {
						dojo.html.disableSelection(node);
					}
				}
			} else {
				if (this.columns[j].getType() == Date) {
					var format = this.defaultDateFormat;
					if (this.columns[j].format) {
						format = this.columns[j].format;
					}
					cell.appendChild(document.createTextNode(dojo.date.strftime(data[i][this.columns[j].getField()], format)));
				} else {
					cell.appendChild(document.createTextNode(data[i][this.columns[j].getField()]));
				}
			}
			row.appendChild(cell);
		}
		body.appendChild(row);
		dojo.event.connect(row, "onclick", this, "onUISelect");
	}
	var minRows = parseInt(this.minRows);
	if (!isNaN(minRows) && minRows > 0 && data.length < minRows) {
		var mod = 0;
		if (data.length % 2 == 0) {
			mod = 1;
		}
		var nRows = minRows - data.length;
		for (var i = 0; i < nRows; i++) {
			var row = document.createElement("tr");
			row.setAttribute("ignoreIfParsed", "true");
			if (this.enableAlternateRows && i % 2 == mod) {
				row.className = this.rowAlternateClass;
			}
			for (var j = 0; j < this.columns.length; j++) {
				var cell = document.createElement("td");
				cell.appendChild(document.createTextNode("\xa0"));
				row.appendChild(cell);
			}
			body.appendChild(row);
		}
	}
}, onSelect:function (e) {
}, onUISelect:function (e) {
	var row = dojo.html.getParentByType(e.target, "tr");
	var body = dojo.html.getParentByType(row, "tbody");
	if (this.enableMultipleSelect) {
		if (e.metaKey || e.ctrlKey) {
			if (this.isSelected(this.getObjectFromRow(row))) {
				this.removeFromSelected(this.getObjectFromRow(row));
				row.removeAttribute("selected");
			} else {
				this.setSelectionByRow(row);
				row.setAttribute("selected", "true");
			}
		} else {
			if (e.shiftKey) {
				var startRow;
				var rows = body.getElementsByTagName("tr");
				for (var i = 0; i < rows.length; i++) {
					if (rows[i].parentNode == body) {
						if (rows[i] == row) {
							break;
						}
						if (dojo.html.getAttribute(rows[i], "selected") == "true") {
							startRow = rows[i];
						}
					}
				}
				if (!startRow) {
					startRow = row;
					for (; i < rows.length; i++) {
						if (dojo.html.getAttribute(rows[i], "selected") == "true") {
							row = rows[i];
							break;
						}
					}
				}
				this.resetSelections(body);
				if (startRow == row) {
					row.setAttribute("selected", "true");
					this.setSelectionByRow(row);
				} else {
					var doSelect = false;
					for (var i = 0; i < rows.length; i++) {
						if (rows[i].parentNode == body) {
							rows[i].removeAttribute("selected");
							if (rows[i] == startRow) {
								doSelect = true;
							}
							if (doSelect) {
								this.setSelectionByRow(rows[i]);
								rows[i].setAttribute("selected", "true");
							}
							if (rows[i] == row) {
								doSelect = false;
							}
						}
					}
				}
			} else {
				this.resetSelections(body);
				row.setAttribute("selected", "true");
				this.setSelectionByRow(row);
			}
		}
	} else {
		this.resetSelections(body);
		row.setAttribute("selected", "true");
		this.setSelectionByRow(row);
	}
	this.showSelections();
	this.onSelect(e);
	e.stopPropagation();
	e.preventDefault();
}, onHeaderClick:function (e) {
	var oldIndex = this.sortIndex;
	var oldDirection = this.sortDirection;
	var source = e.target;
	var row = dojo.html.getParentByType(source, "tr");
	var cellTag = "td";
	if (row.getElementsByTagName(cellTag).length == 0) {
		cellTag = "th";
	}
	var headers = row.getElementsByTagName(cellTag);
	var header = dojo.html.getParentByType(source, cellTag);
	for (var i = 0; i < headers.length; i++) {
		if (headers[i] == header) {
			if (i != oldIndex) {
				this.sortIndex = i;
				this.sortDirection = 0;
				headers[i].className = this.headerSortDownClass;
			} else {
				this.sortDirection = (oldDirection == 0) ? 1 : 0;
				if (this.sortDirection == 0) {
					headers[i].className = this.headerSortDownClass;
				} else {
					headers[i].className = this.headerSortUpClass;
				}
			}
		} else {
			headers[i].className = this.headerClass;
		}
	}
	this.render();
}, postCreate:function () {
	var thead = this.domNode.getElementsByTagName("thead")[0];
	if (this.headClass.length > 0) {
		thead.className = this.headClass;
	}
	dojo.html.disableSelection(this.domNode);
	this.parseColumns(thead);
	var header = "td";
	if (thead.getElementsByTagName(header).length == 0) {
		header = "th";
	}
	var headers = thead.getElementsByTagName(header);
	for (var i = 0; i < headers.length; i++) {
		if (!this.columns[i].noSort) {
			dojo.event.connect(headers[i], "onclick", this, "onHeaderClick");
		}
		if (this.sortIndex == i) {
			if (this.sortDirection == 0) {
				headers[i].className = this.headerSortDownClass;
			} else {
				headers[i].className = this.headerSortUpClass;
			}
		}
	}
	var tbody = this.domNode.getElementsByTagName("tbody")[0];
	if (this.tbodyClass.length > 0) {
		tbody.className = this.tbodyClass;
	}
	this.parseDataFromTable(tbody);
	this.render(true);
}});


__CPAN_FILE__ src/widget/ValidationTextbox.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.widget.ValidationTextbox");
dojo.require("dojo.widget.Textbox");
dojo.require("dojo.i18n.common");
dojo.widget.defineWidget("dojo.widget.ValidationTextbox", dojo.widget.Textbox, function () {
	this.flags = {};
}, {required:false, rangeClass:"range", invalidClass:"invalid", missingClass:"missing", classPrefix:"dojoValidate", size:"", maxlength:"", promptMessage:"", invalidMessage:"", missingMessage:"", rangeMessage:"", listenOnKeyPress:true, htmlfloat:"none", lastCheckedValue:null, templateString:"<span style='float:${this.htmlfloat};'>\n\t<input dojoAttachPoint='textbox' type='${this.type}' dojoAttachEvent='onblur;onfocus;onkeyup'\n\t\tid='${this.widgetId}' name='${this.name}' size='${this.size}' maxlength='${this.maxlength}'\n\t\tclass='${this.className}' style=''>\n\t<span dojoAttachPoint='invalidSpan' class='${this.invalidClass}'>${this.messages.invalidMessage}</span>\n\t<span dojoAttachPoint='missingSpan' class='${this.missingClass}'>${this.messages.missingMessage}</span>\n\t<span dojoAttachPoint='rangeSpan' class='${this.rangeClass}'>${this.messages.rangeMessage}</span>\n</span>\n", templateCssString:".dojoValidateEmpty{\n\tbackground-color: #00FFFF;\n}\n.dojoValidateValid{\n\tbackground-color: #cfc;\n}\n.dojoValidateInvalid{\n\tbackground-color: #fcc;\n}\n.dojoValidateRange{\n\tbackground-color: #ccf;\n}\n", templateCssPath:dojo.uri.moduleUri("dojo.widget", "templates/Validate.css"), invalidSpan:null, missingSpan:null, rangeSpan:null, getValue:function () {
	return this.textbox.value;
}, setValue:function (value) {
	this.textbox.value = value;
	this.update();
}, isValid:function () {
	return true;
}, isInRange:function () {
	return true;
}, isEmpty:function () {
	return (/^\s*$/.test(this.textbox.value));
}, isMissing:function () {
	return (this.required && this.isEmpty());
}, update:function () {
	this.lastCheckedValue = this.textbox.value;
	this.missingSpan.style.display = "none";
	this.invalidSpan.style.display = "none";
	this.rangeSpan.style.display = "none";
	var empty = this.isEmpty();
	var valid = true;
	if (this.promptMessage != this.textbox.value) {
		valid = this.isValid();
	}
	var missing = this.isMissing();
	if (missing) {
		this.missingSpan.style.display = "";
	} else {
		if (!empty && !valid) {
			this.invalidSpan.style.display = "";
		} else {
			if (!empty && !this.isInRange()) {
				this.rangeSpan.style.display = "";
			}
		}
	}
	this.highlight();
}, updateClass:function (className) {
	var pre = this.classPrefix;
	dojo.html.removeClass(this.textbox, pre + "Empty");
	dojo.html.removeClass(this.textbox, pre + "Valid");
	dojo.html.removeClass(this.textbox, pre + "Invalid");
	dojo.html.addClass(this.textbox, pre + className);
}, highlight:function () {
	if (this.isEmpty()) {
		this.updateClass("Empty");
	} else {
		if (this.isValid() && this.isInRange()) {
			this.updateClass("Valid");
		} else {
			if (this.textbox.value != this.promptMessage) {
				this.updateClass("Invalid");
			} else {
				this.updateClass("Empty");
			}
		}
	}
}, onfocus:function (evt) {
	if (!this.listenOnKeyPress) {
		this.updateClass("Empty");
	}
}, onblur:function (evt) {
	this.filter();
	this.update();
}, onkeyup:function (evt) {
	if (this.listenOnKeyPress) {
		this.update();
	} else {
		if (this.textbox.value != this.lastCheckedValue) {
			this.updateClass("Empty");
		}
	}
}, postMixInProperties:function (localProperties, frag) {
	dojo.widget.ValidationTextbox.superclass.postMixInProperties.apply(this, arguments);
	this.messages = dojo.i18n.getLocalization("dojo.widget", "validate", this.lang);
	dojo.lang.forEach(["invalidMessage", "missingMessage", "rangeMessage"], function (prop) {
		if (this[prop]) {
			this.messages[prop] = this[prop];
		}
	}, this);
}, fillInTemplate:function () {
	dojo.widget.ValidationTextbox.superclass.fillInTemplate.apply(this, arguments);
	this.textbox.isValid = function () {
		this.isValid.call(this);
	};
	this.textbox.isMissing = function () {
		this.isMissing.call(this);
	};
	this.textbox.isInRange = function () {
		this.isInRange.call(this);
	};
	dojo.html.setClass(this.invalidSpan, this.invalidClass);
	this.update();
	this.filter();
	if (dojo.render.html.ie) {
		dojo.html.addClass(this.domNode, "ie");
	}
	if (dojo.render.html.moz) {
		dojo.html.addClass(this.domNode, "moz");
	}
	if (dojo.render.html.opera) {
		dojo.html.addClass(this.domNode, "opera");
	}
	if (dojo.render.html.safari) {
		dojo.html.addClass(this.domNode, "safari");
	}
}});


__CPAN_FILE__ src/widget/AccordionContainer.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.widget.AccordionContainer");
dojo.require("dojo.widget.*");
dojo.require("dojo.html.*");
dojo.require("dojo.lfx.html");
dojo.require("dojo.html.selection");
dojo.require("dojo.widget.html.layout");
dojo.require("dojo.widget.PageContainer");
dojo.widget.defineWidget("dojo.widget.AccordionContainer", dojo.widget.HtmlWidget, {isContainer:true, labelNodeClass:"label", containerNodeClass:"accBody", duration:250, fillInTemplate:function () {
	with (this.domNode.style) {
		if (position != "absolute") {
			position = "relative";
		}
		overflow = "hidden";
	}
}, addChild:function (widget) {
	var child = this._addChild(widget);
	this._setSizes();
	return child;
}, _addChild:function (widget) {
	if (widget.open) {
		dojo.deprecated("open parameter deprecated, use 'selected=true' instead will be removed in ", "0.5");
		dojo.debug(widget.widgetId + ": open == " + widget.open);
		widget.selected = true;
	}
	if (widget.widgetType != "AccordionPane") {
		var wrapper = dojo.widget.createWidget("AccordionPane", {label:widget.label, selected:widget.selected, labelNodeClass:this.labelNodeClass, containerNodeClass:this.containerNodeClass, allowCollapse:this.allowCollapse});
		wrapper.addChild(widget);
		this.addWidgetAsDirectChild(wrapper);
		this.registerChild(wrapper, this.children.length);
		return wrapper;
	} else {
		dojo.html.addClass(widget.containerNode, this.containerNodeClass);
		dojo.html.addClass(widget.labelNode, this.labelNodeClass);
		this.addWidgetAsDirectChild(widget);
		this.registerChild(widget, this.children.length);
		return widget;
	}
}, postCreate:function () {
	var tmpChildren = this.children;
	this.children = [];
	dojo.html.removeChildren(this.domNode);
	dojo.lang.forEach(tmpChildren, dojo.lang.hitch(this, "_addChild"));
	this._setSizes();
}, removeChild:function (widget) {
	dojo.widget.AccordionContainer.superclass.removeChild.call(this, widget);
	this._setSizes();
}, onResized:function () {
	this._setSizes();
}, _setSizes:function () {
	var totalCollapsedHeight = 0;
	var openIdx = 0;
	dojo.lang.forEach(this.children, function (child, idx) {
		totalCollapsedHeight += child.getLabelHeight();
		if (child.selected) {
			openIdx = idx;
		}
	});
	var mySize = dojo.html.getContentBox(this.domNode);
	var y = 0;
	dojo.lang.forEach(this.children, function (child, idx) {
		var childCollapsedHeight = child.getLabelHeight();
		child.resizeTo(mySize.width, mySize.height - totalCollapsedHeight + childCollapsedHeight);
		child.domNode.style.zIndex = idx + 1;
		child.domNode.style.position = "absolute";
		child.domNode.style.top = y + "px";
		y += (idx == openIdx) ? dojo.html.getBorderBox(child.domNode).height : childCollapsedHeight;
	});
}, selectChild:function (page) {
	dojo.lang.forEach(this.children, function (child) {
		child.setSelected(child == page);
	});
	var y = 0;
	var anims = [];
	dojo.lang.forEach(this.children, function (child, idx) {
		if (child.domNode.style.top != (y + "px")) {
			anims.push(dojo.lfx.html.slideTo(child.domNode, {top:y, left:0}, this.duration));
		}
		y += child.selected ? dojo.html.getBorderBox(child.domNode).height : child.getLabelHeight();
	}, this);
	dojo.lfx.combine(anims).play();
}});
dojo.widget.defineWidget("dojo.widget.AccordionPane", dojo.widget.HtmlWidget, {label:"", "class":"dojoAccordionPane", labelNodeClass:"label", containerNodeClass:"accBody", selected:false, templateString:"<div dojoAttachPoint=\"domNode\">\n<div dojoAttachPoint=\"labelNode\" dojoAttachEvent=\"onclick: onLabelClick\" class=\"${this.labelNodeClass}\">${this.label}</div>\n<div dojoAttachPoint=\"containerNode\" style=\"overflow: hidden;\" class=\"${this.containerNodeClass}\"></div>\n</div>\n", templateCssString:".dojoAccordionPane .label {\n\tcolor: #000;\n\tfont-weight: bold;\n\tbackground: url(\"images/soriaAccordionOff.gif\") repeat-x top left #85aeec;\n\tborder:1px solid #d9d9d9;\n\tfont-size:0.9em;\n}\n\n.dojoAccordionPane-selected .label {\n\tbackground: url(\"images/soriaAccordionSelected.gif\") repeat-x top left #85aeec;\n\tborder:1px solid #84a3d1;\n}\n\n.dojoAccordionPane .label:hover {\n\tcursor: pointer;\n}\n\n.dojoAccordionPane .accBody {\n\tbackground: #fff;\n\toverflow: auto;\n\tborder:1px solid #84a3d1;\n}\n", templateCssPath:dojo.uri.moduleUri("dojo.widget", "templates/AccordionPane.css"), isContainer:true, fillInTemplate:function () {
	dojo.html.addClass(this.domNode, this["class"]);
	dojo.widget.AccordionPane.superclass.fillInTemplate.call(this);
	dojo.html.disableSelection(this.labelNode);
	this.setSelected(this.selected);
}, setLabel:function (label) {
	this.labelNode.innerHTML = label;
}, resizeTo:function (width, height) {
	dojo.html.setMarginBox(this.domNode, {width:width, height:height});
	var children = [{domNode:this.labelNode, layoutAlign:"top"}, {domNode:this.containerNode, layoutAlign:"client"}];
	dojo.widget.html.layout(this.domNode, children);
	var childSize = dojo.html.getContentBox(this.containerNode);
	this.children[0].resizeTo(childSize.width, childSize.height);
}, getLabelHeight:function () {
	return dojo.html.getMarginBox(this.labelNode).height;
}, onLabelClick:function () {
	this.parent.selectChild(this);
}, setSelected:function (isSelected) {
	this.selected = isSelected;
	(isSelected ? dojo.html.addClass : dojo.html.removeClass)(this.domNode, this["class"] + "-selected");
	var child = this.children[0];
	if (child) {
		if (isSelected) {
			if (!child.isShowing()) {
				child.show();
			} else {
				child.onShow();
			}
		} else {
			child.onHide();
		}
	}
}});
dojo.lang.extend(dojo.widget.Widget, {open:false});


__CPAN_FILE__ src/widget/TreeNode.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.widget.TreeNode");
dojo.require("dojo.html.*");
dojo.require("dojo.event.*");
dojo.require("dojo.io.*");
dojo.widget.defineWidget("dojo.widget.TreeNode", dojo.widget.HtmlWidget, function () {
	this.actionsDisabled = [];
}, {widgetType:"TreeNode", loadStates:{UNCHECKED:"UNCHECKED", LOADING:"LOADING", LOADED:"LOADED"}, actions:{MOVE:"MOVE", REMOVE:"REMOVE", EDIT:"EDIT", ADDCHILD:"ADDCHILD"}, isContainer:true, lockLevel:0, templateString:("<div class=\"dojoTreeNode\"> " + "<span treeNode=\"${this.widgetId}\" class=\"dojoTreeNodeLabel\" dojoAttachPoint=\"labelNode\"> " + "\t\t<span dojoAttachPoint=\"titleNode\" dojoAttachEvent=\"onClick: onTitleClick\" class=\"dojoTreeNodeLabelTitle\">${this.title}</span> " + "</span> " + "<span class=\"dojoTreeNodeAfterLabel\" dojoAttachPoint=\"afterLabelNode\">${this.afterLabel}</span> " + "<div dojoAttachPoint=\"containerNode\" style=\"display:none\"></div> " + "</div>").replace(/(>|<)\s+/g, "$1"), childIconSrc:"", childIconFolderSrc:dojo.uri.moduleUri("dojo.widget", "templates/images/Tree/closed.gif"), childIconDocumentSrc:dojo.uri.moduleUri("dojo.widget", "templates/images/Tree/document.gif"), childIcon:null, isTreeNode:true, objectId:"", afterLabel:"", afterLabelNode:null, expandIcon:null, title:"", object:"", isFolder:false, labelNode:null, titleNode:null, imgs:null, expandLevel:"", tree:null, depth:0, isExpanded:false, state:null, domNodeInitialized:false, isFirstChild:function () {
	return this.getParentIndex() == 0 ? true : false;
}, isLastChild:function () {
	return this.getParentIndex() == this.parent.children.length - 1 ? true : false;
}, lock:function () {
	return this.tree.lock.apply(this, arguments);
}, unlock:function () {
	return this.tree.unlock.apply(this, arguments);
}, isLocked:function () {
	return this.tree.isLocked.apply(this, arguments);
}, cleanLock:function () {
	return this.tree.cleanLock.apply(this, arguments);
}, actionIsDisabled:function (action) {
	var _this = this;
	var disabled = false;
	if (this.tree.strictFolders && action == this.actions.ADDCHILD && !this.isFolder) {
		disabled = true;
	}
	if (dojo.lang.inArray(_this.actionsDisabled, action)) {
		disabled = true;
	}
	if (this.isLocked()) {
		disabled = true;
	}
	return disabled;
}, getInfo:function () {
	var info = {widgetId:this.widgetId, objectId:this.objectId, index:this.getParentIndex(), isFolder:this.isFolder};
	return info;
}, initialize:function (args, frag) {
	this.state = this.loadStates.UNCHECKED;
	for (var i = 0; i < this.actionsDisabled.length; i++) {
		this.actionsDisabled[i] = this.actionsDisabled[i].toUpperCase();
	}
	this.expandLevel = parseInt(this.expandLevel);
}, adjustDepth:function (depthDiff) {
	for (var i = 0; i < this.children.length; i++) {
		this.children[i].adjustDepth(depthDiff);
	}
	this.depth += depthDiff;
	if (depthDiff > 0) {
		for (var i = 0; i < depthDiff; i++) {
			var img = this.tree.makeBlankImg();
			this.imgs.unshift(img);
			dojo.html.insertBefore(this.imgs[0], this.domNode.firstChild);
		}
	}
	if (depthDiff < 0) {
		for (var i = 0; i < -depthDiff; i++) {
			this.imgs.shift();
			dojo.html.removeNode(this.domNode.firstChild);
		}
	}
}, markLoading:function () {
	this._markLoadingSavedIcon = this.expandIcon.src;
	this.expandIcon.src = this.tree.expandIconSrcLoading;
}, unMarkLoading:function () {
	if (!this._markLoadingSavedIcon) {
		return;
	}
	var im = new Image();
	im.src = this.tree.expandIconSrcLoading;
	if (this.expandIcon.src == im.src) {
		this.expandIcon.src = this._markLoadingSavedIcon;
	}
	this._markLoadingSavedIcon = null;
}, setFolder:function () {
	dojo.event.connect(this.expandIcon, "onclick", this, "onTreeClick");
	this.expandIcon.src = this.isExpanded ? this.tree.expandIconSrcMinus : this.tree.expandIconSrcPlus;
	this.isFolder = true;
}, createDOMNode:function (tree, depth) {
	this.tree = tree;
	this.depth = depth;
	this.imgs = [];
	for (var i = 0; i < this.depth + 1; i++) {
		var img = this.tree.makeBlankImg();
		this.domNode.insertBefore(img, this.labelNode);
		this.imgs.push(img);
	}
	this.expandIcon = this.imgs[this.imgs.length - 1];
	this.childIcon = this.tree.makeBlankImg();
	this.imgs.push(this.childIcon);
	dojo.html.insertBefore(this.childIcon, this.titleNode);
	if (this.children.length || this.isFolder) {
		this.setFolder();
	} else {
		this.state = this.loadStates.LOADED;
	}
	dojo.event.connect(this.childIcon, "onclick", this, "onIconClick");
	for (var i = 0; i < this.children.length; i++) {
		this.children[i].parent = this;
		var node = this.children[i].createDOMNode(this.tree, this.depth + 1);
		this.containerNode.appendChild(node);
	}
	if (this.children.length) {
		this.state = this.loadStates.LOADED;
	}
	this.updateIcons();
	this.domNodeInitialized = true;
	dojo.event.topic.publish(this.tree.eventNames.createDOMNode, {source:this});
	return this.domNode;
}, onTreeClick:function (e) {
	dojo.event.topic.publish(this.tree.eventNames.treeClick, {source:this, event:e});
}, onIconClick:function (e) {
	dojo.event.topic.publish(this.tree.eventNames.iconClick, {source:this, event:e});
}, onTitleClick:function (e) {
	dojo.event.topic.publish(this.tree.eventNames.titleClick, {source:this, event:e});
}, markSelected:function () {
	dojo.html.addClass(this.titleNode, "dojoTreeNodeLabelSelected");
}, unMarkSelected:function () {
	dojo.html.removeClass(this.titleNode, "dojoTreeNodeLabelSelected");
}, updateExpandIcon:function () {
	if (this.isFolder) {
		this.expandIcon.src = this.isExpanded ? this.tree.expandIconSrcMinus : this.tree.expandIconSrcPlus;
	} else {
		this.expandIcon.src = this.tree.blankIconSrc;
	}
}, updateExpandGrid:function () {
	if (this.tree.showGrid) {
		if (this.depth) {
			this.setGridImage(-2, this.isLastChild() ? this.tree.gridIconSrcL : this.tree.gridIconSrcT);
		} else {
			if (this.isFirstChild()) {
				this.setGridImage(-2, this.isLastChild() ? this.tree.gridIconSrcX : this.tree.gridIconSrcY);
			} else {
				this.setGridImage(-2, this.isLastChild() ? this.tree.gridIconSrcL : this.tree.gridIconSrcT);
			}
		}
	} else {
		this.setGridImage(-2, this.tree.blankIconSrc);
	}
}, updateChildGrid:function () {
	if ((this.depth || this.tree.showRootGrid) && this.tree.showGrid) {
		this.setGridImage(-1, (this.children.length && this.isExpanded) ? this.tree.gridIconSrcP : this.tree.gridIconSrcC);
	} else {
		if (this.tree.showGrid && !this.tree.showRootGrid) {
			this.setGridImage(-1, (this.children.length && this.isExpanded) ? this.tree.gridIconSrcZ : this.tree.blankIconSrc);
		} else {
			this.setGridImage(-1, this.tree.blankIconSrc);
		}
	}
}, updateParentGrid:function () {
	var parent = this.parent;
	for (var i = 0; i < this.depth; i++) {
		var idx = this.imgs.length - (3 + i);
		var img = (this.tree.showGrid && !parent.isLastChild()) ? this.tree.gridIconSrcV : this.tree.blankIconSrc;
		this.setGridImage(idx, img);
		parent = parent.parent;
	}
}, updateExpandGridColumn:function () {
	if (!this.tree.showGrid) {
		return;
	}
	var _this = this;
	var icon = this.isLastChild() ? this.tree.blankIconSrc : this.tree.gridIconSrcV;
	dojo.lang.forEach(_this.getDescendants(), function (node) {
		node.setGridImage(_this.depth, icon);
	});
	this.updateExpandGrid();
}, updateIcons:function () {
	this.imgs[0].style.display = this.tree.showRootGrid ? "inline" : "none";
	this.buildChildIcon();
	this.updateExpandGrid();
	this.updateChildGrid();
	this.updateParentGrid();
	dojo.profile.stop("updateIcons");
}, buildChildIcon:function () {
	if (this.childIconSrc) {
		this.childIcon.src = this.childIconSrc;
	}
	this.childIcon.style.display = this.childIconSrc ? "inline" : "none";
}, setGridImage:function (idx, src) {
	if (idx < 0) {
		idx = this.imgs.length + idx;
	}
	this.imgs[idx].style.backgroundImage = "url(" + src + ")";
}, updateIconTree:function () {
	this.tree.updateIconTree.call(this);
}, expand:function () {
	if (this.isExpanded) {
		return;
	}
	if (this.children.length) {
		this.showChildren();
	}
	this.isExpanded = true;
	this.updateExpandIcon();
	dojo.event.topic.publish(this.tree.eventNames.expand, {source:this});
}, collapse:function () {
	if (!this.isExpanded) {
		return;
	}
	this.hideChildren();
	this.isExpanded = false;
	this.updateExpandIcon();
	dojo.event.topic.publish(this.tree.eventNames.collapse, {source:this});
}, hideChildren:function () {
	this.tree.toggleObj.hide(this.containerNode, this.toggleDuration, this.explodeSrc, dojo.lang.hitch(this, "onHide"));
	if (dojo.exists(dojo, "dnd.dragManager.dragObjects") && dojo.dnd.dragManager.dragObjects.length) {
		dojo.dnd.dragManager.cacheTargetLocations();
	}
}, showChildren:function () {
	this.tree.toggleObj.show(this.containerNode, this.toggleDuration, this.explodeSrc, dojo.lang.hitch(this, "onShow"));
	if (dojo.exists(dojo, "dnd.dragManager.dragObjects") && dojo.dnd.dragManager.dragObjects.length) {
		dojo.dnd.dragManager.cacheTargetLocations();
	}
}, addChild:function () {
	return this.tree.addChild.apply(this, arguments);
}, doAddChild:function () {
	return this.tree.doAddChild.apply(this, arguments);
}, edit:function (props) {
	dojo.lang.mixin(this, props);
	if (props.title) {
		this.titleNode.innerHTML = this.title;
	}
	if (props.afterLabel) {
		this.afterLabelNode.innerHTML = this.afterLabel;
	}
	if (props.childIconSrc) {
		this.buildChildIcon();
	}
}, removeNode:function () {
	return this.tree.removeNode.apply(this, arguments);
}, doRemoveNode:function () {
	return this.tree.doRemoveNode.apply(this, arguments);
}, toString:function () {
	return "[" + this.widgetType + " Tree:" + this.tree + " ID:" + this.widgetId + " Title:" + this.title + "]";
}});


__CPAN_FILE__ src/widget/TreeSelectorV3.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.widget.TreeSelectorV3");
dojo.require("dojo.widget.HtmlWidget");
dojo.require("dojo.widget.TreeCommon");
dojo.widget.defineWidget("dojo.widget.TreeSelectorV3", [dojo.widget.HtmlWidget, dojo.widget.TreeCommon], function () {
	this.eventNames = {};
	this.listenedTrees = {};
	this.selectedNodes = [];
	this.lastClicked = {};
}, {listenTreeEvents:["afterTreeCreate", "afterCollapse", "afterChangeTree", "afterDetach", "beforeTreeDestroy"], listenNodeFilter:function (elem) {
	return elem instanceof dojo.widget.Widget;
}, allowedMulti:true, dblselectTimeout:300, eventNamesDefault:{select:"select", deselect:"deselect", dblselect:"dblselect"}, onAfterTreeCreate:function (message) {
	var tree = message.source;
	dojo.event.browser.addListener(tree.domNode, "onclick", dojo.lang.hitch(this, this.onTreeClick));
	if (dojo.render.html.ie) {
		dojo.event.browser.addListener(tree.domNode, "ondblclick", dojo.lang.hitch(this, this.onTreeDblClick));
	}
	dojo.event.browser.addListener(tree.domNode, "onKey", dojo.lang.hitch(this, this.onKey));
}, onKey:function (e) {
	if (!e.key || e.ctrkKey || e.altKey) {
		return;
	}
	switch (e.key) {
	  case e.KEY_ENTER:
		var node = this.domElement2TreeNode(e.target);
		if (node) {
			this.processNode(node, e);
		}
	}
}, onAfterChangeTree:function (message) {
	if (!message.oldTree && message.node.selected) {
		this.select(message.node);
	}
	if (!message.newTree || !this.listenedTrees[message.newTree.widgetId]) {
		if (this.selectedNode && message.node.children) {
			this.deselectIfAncestorMatch(message.node);
		}
	}
}, initialize:function (args) {
	for (name in this.eventNamesDefault) {
		if (dojo.lang.isUndefined(this.eventNames[name])) {
			this.eventNames[name] = this.widgetId + "/" + this.eventNamesDefault[name];
		}
	}
}, onBeforeTreeDestroy:function (message) {
	this.unlistenTree(message.source);
}, onAfterCollapse:function (message) {
	this.deselectIfAncestorMatch(message.source);
}, onTreeDblClick:function (event) {
	this.onTreeClick(event);
}, checkSpecialEvent:function (event) {
	return event.shiftKey || event.ctrlKey;
}, onTreeClick:function (event) {
	var node = this.domElement2TreeNode(event.target);
	if (!node) {
		return;
	}
	var checkLabelClick = function (domElement) {
		return domElement === node.labelNode;
	};
	if (this.checkPathCondition(event.target, checkLabelClick)) {
		this.processNode(node, event);
	}
}, processNode:function (node, event) {
	if (node.actionIsDisabled(node.actions.SELECT)) {
		return;
	}
	if (dojo.lang.inArray(this.selectedNodes, node)) {
		if (this.checkSpecialEvent(event)) {
			this.deselect(node);
			return;
		}
		var _this = this;
		var i = 0;
		var selectedNode;
		while (this.selectedNodes.length > i) {
			selectedNode = this.selectedNodes[i];
			if (selectedNode !== node) {
				this.deselect(selectedNode);
				continue;
			}
			i++;
		}
		var wasJustClicked = this.checkRecentClick(node);
		eventName = wasJustClicked ? this.eventNames.dblselect : this.eventNames.select;
		if (wasJustClicked) {
			eventName = this.eventNames.dblselect;
			this.forgetLastClicked();
		} else {
			eventName = this.eventNames.select;
			this.setLastClicked(node);
		}
		dojo.event.topic.publish(eventName, {node:node});
		return;
	}
	this.deselectIfNoMulti(event);
	this.setLastClicked(node);
	this.select(node);
}, forgetLastClicked:function () {
	this.lastClicked = {};
}, setLastClicked:function (node) {
	this.lastClicked.date = new Date();
	this.lastClicked.node = node;
}, checkRecentClick:function (node) {
	var diff = new Date() - this.lastClicked.date;
	if (this.lastClicked.node && diff < this.dblselectTimeout) {
		return true;
	} else {
		return false;
	}
}, deselectIfNoMulti:function (event) {
	if (!this.checkSpecialEvent(event) || !this.allowedMulti) {
		this.deselectAll();
	}
}, deselectIfAncestorMatch:function (ancestor) {
	var _this = this;
	dojo.lang.forEach(this.selectedNodes, function (node) {
		var selectedNode = node;
		node = node.parent;
		while (node && node.isTreeNode) {
			if (node === ancestor) {
				_this.deselect(selectedNode);
				return;
			}
			node = node.parent;
		}
	});
}, onAfterDetach:function (message) {
	this.deselectIfAncestorMatch(message.child);
}, select:function (node) {
	var index = dojo.lang.find(this.selectedNodes, node, true);
	if (index >= 0) {
		return;
	}
	this.selectedNodes.push(node);
	dojo.event.topic.publish(this.eventNames.select, {node:node});
}, deselect:function (node) {
	var index = dojo.lang.find(this.selectedNodes, node, true);
	if (index < 0) {
		return;
	}
	this.selectedNodes.splice(index, 1);
	dojo.event.topic.publish(this.eventNames.deselect, {node:node});
}, deselectAll:function () {
	while (this.selectedNodes.length) {
		this.deselect(this.selectedNodes[0]);
	}
}});


__CPAN_FILE__ src/widget/PageContainer.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.widget.PageContainer");
dojo.require("dojo.lang.func");
dojo.require("dojo.widget.*");
dojo.require("dojo.event.*");
dojo.require("dojo.html.selection");
dojo.widget.defineWidget("dojo.widget.PageContainer", dojo.widget.HtmlWidget, {isContainer:true, doLayout:true, templateString:"<div dojoAttachPoint='containerNode'></div>", selectedChild:"", fillInTemplate:function (args, frag) {
	var source = this.getFragNodeRef(frag);
	dojo.html.copyStyle(this.domNode, source);
	dojo.widget.PageContainer.superclass.fillInTemplate.apply(this, arguments);
}, postCreate:function (args, frag) {
	if (this.children.length) {
		dojo.lang.forEach(this.children, this._setupChild, this);
		var initialChild;
		if (this.selectedChild) {
			this.selectChild(this.selectedChild);
		} else {
			for (var i = 0; i < this.children.length; i++) {
				if (this.children[i].selected) {
					this.selectChild(this.children[i]);
					break;
				}
			}
			if (!this.selectedChildWidget) {
				this.selectChild(this.children[0]);
			}
		}
	}
}, addChild:function (child) {
	dojo.widget.PageContainer.superclass.addChild.apply(this, arguments);
	this._setupChild(child);
	this.onResized();
	if (!this.selectedChildWidget) {
		this.selectChild(child);
	}
}, _setupChild:function (page) {
	page.hide();
	page.domNode.style.position = "relative";
	dojo.event.topic.publish(this.widgetId + "-addChild", page);
}, removeChild:function (page) {
	dojo.widget.PageContainer.superclass.removeChild.apply(this, arguments);
	if (this._beingDestroyed) {
		return;
	}
	dojo.event.topic.publish(this.widgetId + "-removeChild", page);
	this.onResized();
	if (this.selectedChildWidget === page) {
		this.selectedChildWidget = undefined;
		if (this.children.length > 0) {
			this.selectChild(this.children[0], true);
		}
	}
}, selectChild:function (page, callingWidget) {
	page = dojo.widget.byId(page);
	this.correspondingPageButton = callingWidget;
	if (this.selectedChildWidget) {
		this._hideChild(this.selectedChildWidget);
	}
	this.selectedChildWidget = page;
	this.selectedChild = page.widgetId;
	this._showChild(page);
	page.isFirstChild = (page == this.children[0]);
	page.isLastChild = (page == this.children[this.children.length - 1]);
	dojo.event.topic.publish(this.widgetId + "-selectChild", page);
}, forward:function () {
	var index = dojo.lang.find(this.children, this.selectedChildWidget);
	this.selectChild(this.children[index + 1]);
}, back:function () {
	var index = dojo.lang.find(this.children, this.selectedChildWidget);
	this.selectChild(this.children[index - 1]);
}, onResized:function () {
	if (this.doLayout && this.selectedChildWidget) {
		with (this.selectedChildWidget.domNode.style) {
			top = dojo.html.getPixelValue(this.containerNode, "padding-top", true);
			left = dojo.html.getPixelValue(this.containerNode, "padding-left", true);
		}
		var content = dojo.html.getContentBox(this.containerNode);
		this.selectedChildWidget.resizeTo(content.width, content.height);
	}
}, _showChild:function (page) {
	if (this.doLayout) {
		var content = dojo.html.getContentBox(this.containerNode);
		page.resizeTo(content.width, content.height);
	}
	page.selected = true;
	page.show();
}, _hideChild:function (page) {
	page.selected = false;
	page.hide();
}, closeChild:function (page) {
	var remove = page.onClose(this, page);
	if (remove) {
		this.removeChild(page);
		page.destroy();
	}
}, destroy:function () {
	this._beingDestroyed = true;
	dojo.event.topic.destroy(this.widgetId + "-addChild");
	dojo.event.topic.destroy(this.widgetId + "-removeChild");
	dojo.event.topic.destroy(this.widgetId + "-selectChild");
	dojo.widget.PageContainer.superclass.destroy.apply(this, arguments);
}});
dojo.widget.defineWidget("dojo.widget.PageController", dojo.widget.HtmlWidget, {templateString:"<span wairole='tablist' dojoAttachEvent='onKey'></span>", isContainer:true, containerId:"", buttonWidget:"PageButton", "class":"dojoPageController", fillInTemplate:function () {
	dojo.html.addClass(this.domNode, this["class"]);
	dojo.widget.wai.setAttr(this.domNode, "waiRole", "role", "tablist");
}, postCreate:function () {
	this.pane2button = {};
	var container = dojo.widget.byId(this.containerId);
	if (container) {
		dojo.lang.forEach(container.children, this.onAddChild, this);
	}
	dojo.event.topic.subscribe(this.containerId + "-addChild", this, "onAddChild");
	dojo.event.topic.subscribe(this.containerId + "-removeChild", this, "onRemoveChild");
	dojo.event.topic.subscribe(this.containerId + "-selectChild", this, "onSelectChild");
}, destroy:function () {
	dojo.event.topic.unsubscribe(this.containerId + "-addChild", this, "onAddChild");
	dojo.event.topic.unsubscribe(this.containerId + "-removeChild", this, "onRemoveChild");
	dojo.event.topic.unsubscribe(this.containerId + "-selectChild", this, "onSelectChild");
	dojo.widget.PageController.superclass.destroy.apply(this, arguments);
}, onAddChild:function (page) {
	var button = dojo.widget.createWidget(this.buttonWidget, {label:page.label, closeButton:page.closable});
	this.addChild(button);
	this.domNode.appendChild(button.domNode);
	this.pane2button[page] = button;
	page.controlButton = button;
	var _this = this;
	dojo.event.connect(button, "onClick", function () {
		_this.onButtonClick(page);
	});
	dojo.event.connect(button, "onCloseButtonClick", function () {
		_this.onCloseButtonClick(page);
	});
}, onRemoveChild:function (page) {
	if (this._currentChild == page) {
		this._currentChild = null;
	}
	var button = this.pane2button[page];
	if (button) {
		button.destroy();
	}
	this.pane2button[page] = null;
}, onSelectChild:function (page) {
	if (this._currentChild) {
		var oldButton = this.pane2button[this._currentChild];
		oldButton.clearSelected();
	}
	var newButton = this.pane2button[page];
	newButton.setSelected();
	this._currentChild = page;
}, onButtonClick:function (page) {
	var container = dojo.widget.byId(this.containerId);
	container.selectChild(page, false, this);
}, onCloseButtonClick:function (page) {
	var container = dojo.widget.byId(this.containerId);
	container.closeChild(page);
}, onKey:function (evt) {
	if ((evt.keyCode == evt.KEY_RIGHT_ARROW) || (evt.keyCode == evt.KEY_LEFT_ARROW)) {
		var current = 0;
		var next = null;
		var current = dojo.lang.find(this.children, this.pane2button[this._currentChild]);
		if (evt.keyCode == evt.KEY_RIGHT_ARROW) {
			next = this.children[(current + 1) % this.children.length];
		} else {
			next = this.children[(current + (this.children.length - 1)) % this.children.length];
		}
		dojo.event.browser.stopEvent(evt);
		next.onClick();
	}
}});
dojo.widget.defineWidget("dojo.widget.PageButton", dojo.widget.HtmlWidget, {templateString:"<span class='item'>" + "<span dojoAttachEvent='onClick' dojoAttachPoint='titleNode' class='selectButton'>${this.label}</span>" + "<span dojoAttachEvent='onClick:onCloseButtonClick' class='closeButton'>[X]</span>" + "</span>", label:"foo", closeButton:false, onClick:function () {
	this.focus();
}, onCloseButtonMouseOver:function () {
	dojo.html.addClass(this.closeButtonNode, "closeHover");
}, onCloseButtonMouseOut:function () {
	dojo.html.removeClass(this.closeButtonNode, "closeHover");
}, onCloseButtonClick:function (evt) {
}, setSelected:function () {
	dojo.html.addClass(this.domNode, "current");
	this.titleNode.setAttribute("tabIndex", "0");
}, clearSelected:function () {
	dojo.html.removeClass(this.domNode, "current");
	this.titleNode.setAttribute("tabIndex", "-1");
}, focus:function () {
	if (this.titleNode.focus) {
		this.titleNode.focus();
	}
}});
dojo.lang.extend(dojo.widget.Widget, {label:"", selected:false, closable:false, onClose:function () {
	return true;
}});


__CPAN_FILE__ src/widget/TreeDeselectOnDblselect.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.widget.TreeDeselectOnDblselect");
dojo.require("dojo.widget.HtmlWidget");
dojo.require("dojo.widget.TreeSelectorV3");
dojo.deprecated("Does anyone still need this extension? (TreeDeselectOnDblselect)");
dojo.widget.defineWidget("dojo.widget.TreeDeselectOnDblselect", [dojo.widget.HtmlWidget], {selector:"", initialize:function () {
	this.selector = dojo.widget.byId(this.selector);
	dojo.event.topic.subscribe(this.selector.eventNames.dblselect, this, "onDblselect");
}, onDblselect:function (message) {
	this.selector.deselect(message.node);
}});


__CPAN_FILE__ src/widget/DebugConsole.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.widget.DebugConsole");
dojo.require("dojo.widget.Widget");
dojo.require("dojo.widget.*");
dojo.require("dojo.widget.FloatingPane");
dojo.widget.defineWidget("dojo.widget.DebugConsole", dojo.widget.FloatingPane, {fillInTemplate:function () {
	dojo.widget.DebugConsole.superclass.fillInTemplate.apply(this, arguments);
	this.containerNode.id = "debugConsoleClientPane";
	djConfig.isDebug = true;
	djConfig.debugContainerId = this.containerNode.id;
}});


__CPAN_FILE__ src/widget/HtmlWidget.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.widget.HtmlWidget");
dojo.require("dojo.widget.DomWidget");
dojo.require("dojo.html.util");
dojo.require("dojo.html.display");
dojo.require("dojo.html.layout");
dojo.require("dojo.lang.extras");
dojo.require("dojo.lang.func");
dojo.require("dojo.lfx.toggle");
dojo.declare("dojo.widget.HtmlWidget", dojo.widget.DomWidget, {templateCssPath:null, templatePath:null, lang:"", toggle:"plain", toggleDuration:150, initialize:function (args, frag) {
}, postMixInProperties:function (args, frag) {
	if (this.lang === "") {
		this.lang = null;
	}
	this.toggleObj = dojo.lfx.toggle[this.toggle.toLowerCase()] || dojo.lfx.toggle.plain;
}, createNodesFromText:function (txt, wrap) {
	return dojo.html.createNodesFromText(txt, wrap);
}, destroyRendering:function (finalize) {
	try {
		if (this.bgIframe) {
			this.bgIframe.remove();
			delete this.bgIframe;
		}
		if (!finalize && this.domNode) {
			dojo.event.browser.clean(this.domNode);
		}
		dojo.widget.HtmlWidget.superclass.destroyRendering.call(this);
	}
	catch (e) {
	}
}, isShowing:function () {
	return dojo.html.isShowing(this.domNode);
}, toggleShowing:function () {
	if (this.isShowing()) {
		this.hide();
	} else {
		this.show();
	}
}, show:function () {
	if (this.isShowing()) {
		return;
	}
	this.animationInProgress = true;
	this.toggleObj.show(this.domNode, this.toggleDuration, null, dojo.lang.hitch(this, this.onShow), this.explodeSrc);
}, onShow:function () {
	this.animationInProgress = false;
	this.checkSize();
}, hide:function () {
	if (!this.isShowing()) {
		return;
	}
	this.animationInProgress = true;
	this.toggleObj.hide(this.domNode, this.toggleDuration, null, dojo.lang.hitch(this, this.onHide), this.explodeSrc);
}, onHide:function () {
	this.animationInProgress = false;
}, _isResized:function (w, h) {
	if (!this.isShowing()) {
		return false;
	}
	var wh = dojo.html.getMarginBox(this.domNode);
	var width = w || wh.width;
	var height = h || wh.height;
	if (this.width == width && this.height == height) {
		return false;
	}
	this.width = width;
	this.height = height;
	return true;
}, checkSize:function () {
	if (!this._isResized()) {
		return;
	}
	this.onResized();
}, resizeTo:function (w, h) {
	dojo.html.setMarginBox(this.domNode, {width:w, height:h});
	if (this.isShowing()) {
		this.onResized();
	}
}, resizeSoon:function () {
	if (this.isShowing()) {
		dojo.lang.setTimeout(this, this.onResized, 0);
	}
}, onResized:function () {
	dojo.lang.forEach(this.children, function (child) {
		if (child.checkSize) {
			child.checkSize();
		}
	});
}});


__CPAN_FILE__ src/widget/ShowAction.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.widget.ShowAction");
dojo.require("dojo.widget.*");
dojo.widget.defineWidget("dojo.widget.ShowAction", dojo.widget.HtmlWidget, {on:"", action:"fade", duration:350, from:"", to:"", auto:"false", postMixInProperties:function () {
	if (dojo.render.html.opera) {
		this.action = this.action.split("/").pop();
	}
}});


__CPAN_FILE__ src/widget/__package__.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.kwCompoundRequire({common:["dojo.xml.Parse", "dojo.widget.Widget", "dojo.widget.Parse", "dojo.widget.Manager"], browser:["dojo.widget.DomWidget", "dojo.widget.HtmlWidget"], dashboard:["dojo.widget.DomWidget", "dojo.widget.HtmlWidget"], svg:["dojo.widget.SvgWidget"], rhino:["dojo.widget.SwtWidget"]});
dojo.provide("dojo.widget.*");


__CPAN_FILE__ src/widget/Menu2.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.widget.Menu2");
dojo.require("dojo.widget.PopupContainer");
dojo.declare("dojo.widget.MenuBase", null, function () {
	this.eventNames = {open:""};
}, {isContainer:true, isMenu:true, eventNaming:"default", templateCssString:"\n.dojoPopupMenu2 {\n\tposition: absolute;\n\tborder: 1px solid #7298d0;\n\tbackground:#85aeec url(images/soriaMenuBg.gif) repeat-x bottom left !important;\n\tpadding: 1px;\n\tmargin-top: 1px;\n\tmargin-bottom: 1px;\n}\n\n.dojoMenuItem2{\n\twhite-space: nowrap;\n\tfont: menu;\n\tmargin: 0;\n}\n\n.dojoMenuItem2Hover {\n\tbackground-color: #D2E4FD;\n\tcursor:pointer;\n\tcursor:hand;\n}\n\n.dojoMenuItem2Icon {\n\tposition: relative;\n\tbackground-position: center center;\n\tbackground-repeat: no-repeat;\n\twidth: 16px;\n\theight: 16px;\n\tpadding-right: 3px;\n}\n\n.dojoMenuItem2Label {\n\tposition: relative;\n\tvertical-align: middle;\n}\n\n/* main label text */\n.dojoMenuItem2Label {\n\tposition: relative;\n\tvertical-align: middle;\n}\n\n.dojoMenuItem2Accel {\n\tposition: relative;\n\tvertical-align: middle;\n\tpadding-left: 3px;\n}\n\n.dojoMenuItem2Disabled .dojoMenuItem2Label,\n.dojoMenuItem2Disabled .dojoMenuItem2Accel {\n\tcolor: #607a9e;\n}\n\n.dojoMenuItem2Submenu {\n\tposition: relative;\n\tbackground-position: center center;\n\tbackground-repeat: no-repeat;\n\tbackground-image: url(images/submenu_off.gif);\n\twidth: 5px;\n\theight: 9px;\n\tpadding-left: 3px;\n}\n.dojoMenuItem2Hover .dojoMenuItem2Submenu {\n\tbackground-image: url(images/submenu_on.gif);\n}\n\n.dojoMenuItem2Disabled .dojoMenuItem2Submenu {\n\tbackground-image: url(images/submenu_disabled.gif);\n}\n\n.dojoMenuSeparator2 {\n\tfont-size: 1px;\n\tmargin: 0;\n}\n\n.dojoMenuSeparator2Top {\n\theight: 50%;\n\tborder-bottom: 1px solid #7a98c4;\n\tmargin: 0px 2px;\n\tfont-size: 1px;\n}\n\n.dojoMenuSeparator2Bottom {\n\theight: 50%;\n\tborder-top: 1px solid #c9deff;\n\tmargin: 0px 2px;\n\tfont-size: 1px;\n}\n\n.dojoMenuBar2 {\n\tbackground:#85aeec url(images/soriaBarBg.gif) repeat-x top left;\n\t/*border-bottom:1px solid #6b9fec;*/\n\tpadding: 1px;\n}\n\n.dojoMenuBar2 .dojoMenuItem2 {\n\twhite-space: nowrap;\n\tfont: menu;\n\tmargin: 0;\n\tposition: relative;\n\tvertical-align: middle;\n\tz-index: 1;\n\tpadding: 3px 8px;\n\tdisplay: inline;/* needed in khtml to display correctly */\n\tdisplay: -moz-inline-box;/* needed in firefox */\n\tcursor:pointer;\n\tcursor:hand;\n}\n\n.dojoMenuBar2 .dojoMenuItem2Hover {\n\tbackground-color:#d2e4fd;\n}\n\n.dojoMenuBar2 .dojoMenuItem2Disabled span {\n\tcolor: #4f6582;\n}\n", templateCssPath:dojo.uri.moduleUri("dojo.widget", "templates/Menu2.css"), submenuDelay:500, initialize:function (args, frag) {
	if (this.eventNaming == "default") {
		for (var eventName in this.eventNames) {
			this.eventNames[eventName] = this.widgetId + "/" + eventName;
		}
	}
}, _moveToNext:function (evt) {
	this._highlightOption(1);
	return true;
}, _moveToPrevious:function (evt) {
	this._highlightOption(-1);
	return true;
}, _moveToParentMenu:function (evt) {
	if (this._highlighted_option && this.parentMenu) {
		if (evt._menu2UpKeyProcessed) {
			return true;
		} else {
			this._highlighted_option.onUnhover();
			this.closeSubmenu();
			evt._menu2UpKeyProcessed = true;
		}
	}
	return false;
}, _moveToChildMenu:function (evt) {
	if (this._highlighted_option && this._highlighted_option.submenuId) {
		this._highlighted_option._onClick(true);
		return true;
	}
	return false;
}, _selectCurrentItem:function (evt) {
	if (this._highlighted_option) {
		this._highlighted_option._onClick();
		return true;
	}
	return false;
}, processKey:function (evt) {
	if (evt.ctrlKey || evt.altKey || !evt.key) {
		return false;
	}
	var rval = false;
	switch (evt.key) {
	  case evt.KEY_DOWN_ARROW:
		rval = this._moveToNext(evt);
		break;
	  case evt.KEY_UP_ARROW:
		rval = this._moveToPrevious(evt);
		break;
	  case evt.KEY_RIGHT_ARROW:
		rval = this._moveToChildMenu(evt);
		break;
	  case evt.KEY_LEFT_ARROW:
		rval = this._moveToParentMenu(evt);
		break;
	  case " ":
	  case evt.KEY_ENTER:
		if (rval = this._selectCurrentItem(evt)) {
			break;
		}
	  case evt.KEY_ESCAPE:
	  case evt.KEY_TAB:
		this.close(true);
		rval = true;
		break;
	}
	return rval;
}, _findValidItem:function (dir, curItem) {
	if (curItem) {
		curItem = dir > 0 ? curItem.getNextSibling() : curItem.getPreviousSibling();
	}
	for (var i = 0; i < this.children.length; ++i) {
		if (!curItem) {
			curItem = dir > 0 ? this.children[0] : this.children[this.children.length - 1];
		}
		if (curItem.onHover && curItem.isShowing()) {
			return curItem;
		}
		curItem = dir > 0 ? curItem.getNextSibling() : curItem.getPreviousSibling();
	}
}, _highlightOption:function (dir) {
	var item;
	if ((!this._highlighted_option)) {
		item = this._findValidItem(dir);
	} else {
		item = this._findValidItem(dir, this._highlighted_option);
	}
	if (item) {
		if (this._highlighted_option) {
			this._highlighted_option.onUnhover();
		}
		item.onHover();
		dojo.html.scrollIntoView(item.domNode);
		try {
			var node = dojo.html.getElementsByClass("dojoMenuItem2Label", item.domNode)[0];
			node.focus();
		}
		catch (e) {
		}
	}
}, onItemClick:function (item) {
}, closeSubmenu:function (force) {
	if (this.currentSubmenu == null) {
		return;
	}
	this.currentSubmenu.close(force);
	this.currentSubmenu = null;
	this.currentSubmenuTrigger.is_open = false;
	this.currentSubmenuTrigger._closedSubmenu(force);
	this.currentSubmenuTrigger = null;
}});
dojo.widget.defineWidget("dojo.widget.PopupMenu2", [dojo.widget.HtmlWidget, dojo.widget.PopupContainerBase, dojo.widget.MenuBase], function () {
	this.targetNodeIds = [];
}, {templateString:"<table class=\"dojoPopupMenu2\" border=0 cellspacing=0 cellpadding=0 style=\"display: none; position: absolute;\">" + "<tbody dojoAttachPoint=\"containerNode\"></tbody>" + "</table>", submenuOverlap:5, contextMenuForWindow:false, parentMenu:null, postCreate:function () {
	if (this.contextMenuForWindow) {
		var doc = dojo.body();
		this.bindDomNode(doc);
	} else {
		if (this.targetNodeIds.length > 0) {
			dojo.lang.forEach(this.targetNodeIds, this.bindDomNode, this);
		}
	}
	this._subscribeSubitemsOnOpen();
}, _subscribeSubitemsOnOpen:function () {
	var subItems = this.getChildrenOfType(dojo.widget.MenuItem2);
	for (var i = 0; i < subItems.length; i++) {
		dojo.event.topic.subscribe(this.eventNames.open, subItems[i], "menuOpen");
	}
}, getTopOpenEvent:function () {
	var menu = this;
	while (menu.parentMenu) {
		menu = menu.parentMenu;
	}
	return menu.openEvent;
}, bindDomNode:function (node) {
	node = dojo.byId(node);
	var win = dojo.html.getElementWindow(node);
	if (dojo.html.isTag(node, "iframe") == "iframe") {
		win = dojo.html.iframeContentWindow(node);
		node = dojo.withGlobal(win, dojo.body);
	}
	dojo.widget.Menu2.OperaAndKonqFixer.fixNode(node);
	dojo.event.kwConnect({srcObj:node, srcFunc:"oncontextmenu", targetObj:this, targetFunc:"onOpen", once:true});
	if (dojo.render.html.moz && win.document.designMode.toLowerCase() == "on") {
		dojo.event.browser.addListener(node, "contextmenu", dojo.lang.hitch(this, "onOpen"));
	}
	dojo.widget.PopupManager.registerWin(win);
}, unBindDomNode:function (nodeName) {
	var node = dojo.byId(nodeName);
	dojo.event.kwDisconnect({srcObj:node, srcFunc:"oncontextmenu", targetObj:this, targetFunc:"onOpen", once:true});
	dojo.widget.Menu2.OperaAndKonqFixer.cleanNode(node);
}, _openAsSubmenu:function (parent, explodeSrc, orient) {
	if (this.isShowingNow) {
		return;
	}
	this.parentMenu = parent;
	this.open(explodeSrc, parent, explodeSrc, orient);
}, close:function (force) {
	if (this.animationInProgress) {
		dojo.widget.PopupContainerBase.prototype.close.call(this, force);
		return;
	}
	if (this._highlighted_option) {
		this._highlighted_option.onUnhover();
	}
	dojo.widget.PopupContainerBase.prototype.close.call(this, force);
	this.parentMenu = null;
}, closeAll:function (force) {
	if (this.parentMenu) {
		this.parentMenu.closeAll(force);
	} else {
		this.close(force);
	}
}, _openSubmenu:function (submenu, from_item) {
	submenu._openAsSubmenu(this, from_item.arrow, {"TR":"TL", "TL":"TR"});
	this.currentSubmenu = submenu;
	this.currentSubmenuTrigger = from_item;
	this.currentSubmenuTrigger.is_open = true;
}, focus:function () {
	if (this.currentSubmenuTrigger) {
		if (this.currentSubmenuTrigger.caption) {
			try {
				this.currentSubmenuTrigger.caption.focus();
			}
			catch (e) {
			}
		} else {
			try {
				this.currentSubmenuTrigger.domNode.focus();
			}
			catch (e) {
			}
		}
	}
}, onOpen:function (e) {
	this.openEvent = e;
	if (e["target"]) {
		this.openedForWindow = dojo.html.getElementWindow(e.target);
	} else {
		this.openedForWindow = null;
	}
	var x = e.pageX, y = e.pageY;
	var win = dojo.html.getElementWindow(e.target);
	var iframe = win._frameElement || win.frameElement;
	if (iframe) {
		var cood = dojo.html.abs(iframe, true);
		x += cood.x - dojo.withGlobal(win, dojo.html.getScroll).left;
		y += cood.y - dojo.withGlobal(win, dojo.html.getScroll).top;
	}
	this.open(x, y, null, [x, y]);
	dojo.event.browser.stopEvent(e);
}});
dojo.widget.defineWidget("dojo.widget.MenuItem2", dojo.widget.HtmlWidget, function () {
	this.eventNames = {engage:""};
}, {templateString:"<tr class=\"dojoMenuItem2\" dojoAttachEvent=\"onMouseOver: onHover; onMouseOut: onUnhover; onClick: _onClick; onKey:onKey;\">" + "<td><div class=\"${this.iconClass}\" style=\"${this.iconStyle}\"></div></td>" + "<td tabIndex=\"-1\" class=\"dojoMenuItem2Label\" dojoAttachPoint=\"caption\">${this.caption}</td>" + "<td class=\"dojoMenuItem2Accel\">${this.accelKey}</td>" + "<td><div class=\"dojoMenuItem2Submenu\" style=\"display:${this.arrowDisplay};\" dojoAttachPoint=\"arrow\"></div></td>" + "</tr>", is_hovering:false, hover_timer:null, is_open:false, topPosition:0, caption:"Untitled", accelKey:"", iconSrc:"", disabledClass:"dojoMenuItem2Disabled", iconClass:"dojoMenuItem2Icon", submenuId:"", eventNaming:"default", highlightClass:"dojoMenuItem2Hover", postMixInProperties:function () {
	this.iconStyle = "";
	if (this.iconSrc) {
		if ((this.iconSrc.toLowerCase().substring(this.iconSrc.length - 4) == ".png") && (dojo.render.html.ie55 || dojo.render.html.ie60)) {
			this.iconStyle = "filter: progid:DXImageTransform.Microsoft.AlphaImageLoader(src='" + this.iconSrc + "', sizingMethod='image')";
		} else {
			this.iconStyle = "background-image: url(" + this.iconSrc + ")";
		}
	}
	this.arrowDisplay = this.submenuId ? "block" : "none";
	dojo.widget.MenuItem2.superclass.postMixInProperties.apply(this, arguments);
}, fillInTemplate:function () {
	dojo.html.disableSelection(this.domNode);
	if (this.disabled) {
		this.setDisabled(true);
	}
	if (this.eventNaming == "default") {
		for (var eventName in this.eventNames) {
			this.eventNames[eventName] = this.widgetId + "/" + eventName;
		}
	}
}, onHover:function () {
	this.onUnhover();
	if (this.is_hovering) {
		return;
	}
	if (this.is_open) {
		return;
	}
	if (this.parent._highlighted_option) {
		this.parent._highlighted_option.onUnhover();
	}
	this.parent.closeSubmenu();
	this.parent._highlighted_option = this;
	dojo.widget.PopupManager.setFocusedMenu(this.parent);
	this._highlightItem();
	if (this.is_hovering) {
		this._stopSubmenuTimer();
	}
	this.is_hovering = true;
	this._startSubmenuTimer();
}, onUnhover:function () {
	if (!this.is_open) {
		this._unhighlightItem();
	}
	this.is_hovering = false;
	this.parent._highlighted_option = null;
	if (this.parent.parentMenu) {
		dojo.widget.PopupManager.setFocusedMenu(this.parent.parentMenu);
	}
	this._stopSubmenuTimer();
}, _onClick:function (focus) {
	var displayingSubMenu = false;
	if (this.disabled) {
		return false;
	}
	if (this.submenuId) {
		if (!this.is_open) {
			this._stopSubmenuTimer();
			this._openSubmenu();
		}
		displayingSubMenu = true;
	} else {
		this.onUnhover();
		this.parent.closeAll(true);
	}
	this.onClick();
	dojo.event.topic.publish(this.eventNames.engage, this);
	if (displayingSubMenu && focus) {
		dojo.widget.getWidgetById(this.submenuId)._highlightOption(1);
	}
	return;
}, onClick:function () {
	this.parent.onItemClick(this);
}, _highlightItem:function () {
	dojo.html.addClass(this.domNode, this.highlightClass);
}, _unhighlightItem:function () {
	dojo.html.removeClass(this.domNode, this.highlightClass);
}, _startSubmenuTimer:function () {
	this._stopSubmenuTimer();
	if (this.disabled) {
		return;
	}
	var self = this;
	var closure = function () {
		return function () {
			self._openSubmenu();
		};
	}();
	this.hover_timer = dojo.lang.setTimeout(closure, this.parent.submenuDelay);
}, _stopSubmenuTimer:function () {
	if (this.hover_timer) {
		dojo.lang.clearTimeout(this.hover_timer);
		this.hover_timer = null;
	}
}, _openSubmenu:function () {
	if (this.disabled) {
		return;
	}
	this.parent.closeSubmenu();
	var submenu = dojo.widget.getWidgetById(this.submenuId);
	if (submenu) {
		this.parent._openSubmenu(submenu, this);
	}
}, _closedSubmenu:function () {
	this.onUnhover();
}, setDisabled:function (value) {
	this.disabled = value;
	if (this.disabled) {
		dojo.html.addClass(this.domNode, this.disabledClass);
	} else {
		dojo.html.removeClass(this.domNode, this.disabledClass);
	}
}, enable:function () {
	this.setDisabled(false);
}, disable:function () {
	this.setDisabled(true);
}, menuOpen:function (message) {
}});
dojo.widget.defineWidget("dojo.widget.MenuSeparator2", dojo.widget.HtmlWidget, {templateString:"<tr class=\"dojoMenuSeparator2\"><td colspan=4>" + "<div class=\"dojoMenuSeparator2Top\"></div>" + "<div class=\"dojoMenuSeparator2Bottom\"></div>" + "</td></tr>", postCreate:function () {
	dojo.html.disableSelection(this.domNode);
}});
dojo.widget.defineWidget("dojo.widget.MenuBar2", [dojo.widget.HtmlWidget, dojo.widget.MenuBase], {menuOverlap:2, templateString:"<div class=\"dojoMenuBar2\" dojoAttachPoint=\"containerNode\" tabIndex=\"0\"></div>", close:function (force) {
	if (this._highlighted_option) {
		this._highlighted_option.onUnhover();
	}
	this.closeSubmenu(force);
}, closeAll:function (force) {
	this.close(force);
}, processKey:function (evt) {
	if (evt.ctrlKey || evt.altKey) {
		return false;
	}
	var rval = false;
	switch (evt.key) {
	  case evt.KEY_DOWN_ARROW:
		rval = this._moveToChildMenu(evt);
		break;
	  case evt.KEY_UP_ARROW:
		rval = this._moveToParentMenu(evt);
		break;
	  case evt.KEY_RIGHT_ARROW:
		rval = this._moveToNext(evt);
		break;
	  case evt.KEY_LEFT_ARROW:
		rval = this._moveToPrevious(evt);
		break;
	  default:
		rval = dojo.widget.MenuBar2.superclass.processKey.apply(this, arguments);
		break;
	}
	return rval;
}, postCreate:function () {
	dojo.widget.MenuBar2.superclass.postCreate.apply(this, arguments);
	this.isShowingNow = true;
}, _openSubmenu:function (submenu, from_item) {
	submenu._openAsSubmenu(this, from_item.domNode, {"BL":"TL", "TL":"BL"});
	this.currentSubmenu = submenu;
	this.currentSubmenuTrigger = from_item;
	this.currentSubmenuTrigger.is_open = true;
}});
dojo.widget.defineWidget("dojo.widget.MenuBarItem2", dojo.widget.MenuItem2, {templateString:"<span class=\"dojoMenuItem2\" dojoAttachEvent=\"onMouseOver: onHover; onMouseOut: onUnhover; onClick: _onClick;\">${this.caption}</span>"});
dojo.widget.Menu2.OperaAndKonqFixer = new function () {
	var implement = true;
	var delfunc = false;
	if (!dojo.lang.isFunction(dojo.doc().oncontextmenu)) {
		dojo.doc().oncontextmenu = function () {
			implement = false;
			delfunc = true;
		};
	}
	if (dojo.doc().createEvent) {
		try {
			var e = dojo.doc().createEvent("MouseEvents");
			e.initMouseEvent("contextmenu", 1, 1, dojo.global(), 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, null);
			dojo.doc().dispatchEvent(e);
		}
		catch (e) {
		}
	} else {
		implement = false;
	}
	if (delfunc) {
		delete dojo.doc().oncontextmenu;
	}
	this.fixNode = function (node) {
		if (implement) {
			if (!dojo.lang.isFunction(node.oncontextmenu)) {
				node.oncontextmenu = function (e) {
				};
			}
			if (dojo.render.html.opera) {
				node._menufixer_opera = function (e) {
					if (e.ctrlKey) {
						this.oncontextmenu(e);
					}
				};
				dojo.event.connect(node, "onclick", node, "_menufixer_opera");
			} else {
				node._menufixer_konq = function (e) {
					if (e.button == 2) {
						e.preventDefault();
						this.oncontextmenu(e);
					}
				};
				dojo.event.connect(node, "onmousedown", node, "_menufixer_konq");
			}
		}
	};
	this.cleanNode = function (node) {
		if (implement) {
			if (node._menufixer_opera) {
				dojo.event.disconnect(node, "onclick", node, "_menufixer_opera");
				delete node._menufixer_opera;
			} else {
				if (node._menufixer_konq) {
					dojo.event.disconnect(node, "onmousedown", node, "_menufixer_konq");
					delete node._menufixer_konq;
				}
			}
			if (node.oncontextmenu) {
				delete node.oncontextmenu;
			}
		}
	};
};


__CPAN_FILE__ src/widget/FilteringTable.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.widget.FilteringTable");
dojo.require("dojo.date.format");
dojo.require("dojo.math");
dojo.require("dojo.collections.Store");
dojo.require("dojo.html.*");
dojo.require("dojo.html.util");
dojo.require("dojo.html.style");
dojo.require("dojo.html.selection");
dojo.require("dojo.event.*");
dojo.require("dojo.widget.*");
dojo.require("dojo.widget.HtmlWidget");
dojo.widget.defineWidget("dojo.widget.FilteringTable", dojo.widget.HtmlWidget, function () {
	this.store = new dojo.collections.Store();
	this.valueField = "Id";
	this.multiple = false;
	this.maxSelect = 0;
	this.maxSortable = 1;
	this.minRows = 0;
	this.defaultDateFormat = "%D";
	this.isInitialized = false;
	this.alternateRows = false;
	this.columns = [];
	this.sortInformation = [{index:0, direction:0}];
	this.headClass = "";
	this.tbodyClass = "";
	this.headerClass = "";
	this.headerUpClass = "selectedUp";
	this.headerDownClass = "selectedDown";
	this.rowClass = "";
	this.rowAlternateClass = "alt";
	this.rowSelectedClass = "selected";
	this.columnSelected = "sorted-column";
}, {isContainer:false, templatePath:null, templateCssPath:null, getTypeFromString:function (s) {
	var parts = s.split("."), i = 0, obj = dj_global;
	do {
		obj = obj[parts[i++]];
	} while (i < parts.length && obj);
	return (obj != dj_global) ? obj : null;
}, getByRow:function (row) {
	return this.store.getByKey(dojo.html.getAttribute(row, "value"));
}, getDataByRow:function (row) {
	return this.store.getDataByKey(dojo.html.getAttribute(row, "value"));
}, getRow:function (obj) {
	var rows = this.domNode.tBodies[0].rows;
	for (var i = 0; i < rows.length; i++) {
		if (this.store.getDataByKey(dojo.html.getAttribute(rows[i], "value")) == obj) {
			return rows[i];
		}
	}
	return null;
}, getColumnIndex:function (fieldPath) {
	for (var i = 0; i < this.columns.length; i++) {
		if (this.columns[i].getField() == fieldPath) {
			return i;
		}
	}
	return -1;
}, getSelectedData:function () {
	var data = this.store.get();
	var a = [];
	for (var i = 0; i < data.length; i++) {
		if (data[i].isSelected) {
			a.push(data[i].src);
		}
	}
	if (this.multiple) {
		return a;
	} else {
		return a[0];
	}
}, isSelected:function (obj) {
	var data = this.store.get();
	for (var i = 0; i < data.length; i++) {
		if (data[i].src == obj) {
			return true;
		}
	}
	return false;
}, isValueSelected:function (val) {
	var v = this.store.getByKey(val);
	if (v) {
		return v.isSelected;
	}
	return false;
}, isIndexSelected:function (idx) {
	var v = this.store.getByIndex(idx);
	if (v) {
		return v.isSelected;
	}
	return false;
}, isRowSelected:function (row) {
	var v = this.getByRow(row);
	if (v) {
		return v.isSelected;
	}
	return false;
}, reset:function () {
	this.store.clearData();
	this.columns = [];
	this.sortInformation = [{index:0, direction:0}];
	this.resetSelections();
	this.isInitialized = false;
	this.onReset();
}, resetSelections:function () {
	this.store.forEach(function (element) {
		element.isSelected = false;
	});
}, onReset:function () {
}, select:function (obj) {
	var data = this.store.get();
	for (var i = 0; i < data.length; i++) {
		if (data[i].src == obj) {
			data[i].isSelected = true;
			break;
		}
	}
	this.onDataSelect(obj);
}, selectByValue:function (val) {
	this.select(this.store.getDataByKey(val));
}, selectByIndex:function (idx) {
	this.select(this.store.getDataByIndex(idx));
}, selectByRow:function (row) {
	this.select(this.getDataByRow(row));
}, selectAll:function () {
	this.store.forEach(function (element) {
		element.isSelected = true;
	});
}, onDataSelect:function (obj) {
}, toggleSelection:function (obj) {
	var data = this.store.get();
	for (var i = 0; i < data.length; i++) {
		if (data[i].src == obj) {
			data[i].isSelected = !data[i].isSelected;
			break;
		}
	}
	this.onDataToggle(obj);
}, toggleSelectionByValue:function (val) {
	this.toggleSelection(this.store.getDataByKey(val));
}, toggleSelectionByIndex:function (idx) {
	this.toggleSelection(this.store.getDataByIndex(idx));
}, toggleSelectionByRow:function (row) {
	this.toggleSelection(this.getDataByRow(row));
}, toggleAll:function () {
	this.store.forEach(function (element) {
		element.isSelected = !element.isSelected;
	});
}, onDataToggle:function (obj) {
}, _meta:{field:null, format:null, filterer:null, noSort:false, sortType:"String", dataType:String, sortFunction:null, filterFunction:null, label:null, align:"left", valign:"middle", getField:function () {
	return this.field || this.label;
}, getType:function () {
	return this.dataType;
}}, createMetaData:function (obj) {
	for (var p in this._meta) {
		if (!obj[p]) {
			obj[p] = this._meta[p];
		}
	}
	if (!obj.label) {
		obj.label = obj.field;
	}
	if (!obj.filterFunction) {
		obj.filterFunction = this._defaultFilter;
	}
	return obj;
}, parseMetadata:function (head) {
	this.columns = [];
	this.sortInformation = [];
	var row = head.getElementsByTagName("tr")[0];
	var cells = row.getElementsByTagName("td");
	if (cells.length == 0) {
		cells = row.getElementsByTagName("th");
	}
	for (var i = 0; i < cells.length; i++) {
		var o = this.createMetaData({});
		if (dojo.html.hasAttribute(cells[i], "align")) {
			o.align = dojo.html.getAttribute(cells[i], "align");
		}
		if (dojo.html.hasAttribute(cells[i], "valign")) {
			o.valign = dojo.html.getAttribute(cells[i], "valign");
		}
		if (dojo.html.hasAttribute(cells[i], "nosort")) {
			o.noSort = (dojo.html.getAttribute(cells[i], "nosort") == "true");
		}
		if (dojo.html.hasAttribute(cells[i], "sortusing")) {
			var trans = dojo.html.getAttribute(cells[i], "sortusing");
			var f = this.getTypeFromString(trans);
			if (f != null && f != window && typeof (f) == "function") {
				o.sortFunction = f;
			}
		}
		o.label = dojo.html.renderedTextContent(cells[i]);
		if (dojo.html.hasAttribute(cells[i], "field")) {
			o.field = dojo.html.getAttribute(cells[i], "field");
		} else {
			if (o.label.length > 0) {
				o.field = o.label;
			} else {
				o.field = "field" + i;
			}
		}
		if (dojo.html.hasAttribute(cells[i], "format")) {
			o.format = dojo.html.getAttribute(cells[i], "format");
		}
		if (dojo.html.hasAttribute(cells[i], "dataType")) {
			var sortType = dojo.html.getAttribute(cells[i], "dataType");
			if (sortType.toLowerCase() == "html" || sortType.toLowerCase() == "markup") {
				o.sortType = "__markup__";
			} else {
				var type = this.getTypeFromString(sortType);
				if (type) {
					o.sortType = sortType;
					o.dataType = type;
				}
			}
		}
		if (dojo.html.hasAttribute(cells[i], "filterusing")) {
			var trans = dojo.html.getAttribute(cells[i], "filterusing");
			var f = this.getTypeFromString(trans);
			if (f != null && f != window && typeof (f) == "function") {
				o.filterFunction = f;
			}
		}
		this.columns.push(o);
		if (dojo.html.hasAttribute(cells[i], "sort")) {
			var info = {index:i, direction:0};
			var dir = dojo.html.getAttribute(cells[i], "sort");
			if (!isNaN(parseInt(dir))) {
				dir = parseInt(dir);
				info.direction = (dir != 0) ? 1 : 0;
			} else {
				info.direction = (dir.toLowerCase() == "desc") ? 1 : 0;
			}
			this.sortInformation.push(info);
		}
	}
	if (this.sortInformation.length == 0) {
		this.sortInformation.push({index:0, direction:0});
	} else {
		if (this.sortInformation.length > this.maxSortable) {
			this.sortInformation.length = this.maxSortable;
		}
	}
}, parseData:function (body) {
	if (body.rows.length == 0 && this.columns.length == 0) {
		return;
	}
	var self = this;
	this["__selected__"] = [];
	var arr = this.store.getFromHtml(this.columns, body, function (obj, row) {
		if (typeof (obj[self.valueField]) == "undefined" || obj[self.valueField] == null) {
			obj[self.valueField] = dojo.html.getAttribute(row, "value");
		}
		if (dojo.html.getAttribute(row, "selected") == "true") {
			self["__selected__"].push(obj);
		}
	});
	this.store.setData(arr, true);
	this.render();
	for (var i = 0; i < this["__selected__"].length; i++) {
		this.select(this["__selected__"][i]);
	}
	this.renderSelections();
	delete this["__selected__"];
	this.isInitialized = true;
}, onSelect:function (e) {
	var row = dojo.html.getParentByType(e.target, "tr");
	if (dojo.html.hasAttribute(row, "emptyRow")) {
		return;
	}
	var body = dojo.html.getParentByType(row, "tbody");
	if (this.multiple) {
		if (e.shiftKey) {
			var startRow;
			var rows = body.rows;
			for (var i = 0; i < rows.length; i++) {
				if (rows[i] == row) {
					break;
				}
				if (this.isRowSelected(rows[i])) {
					startRow = rows[i];
				}
			}
			if (!startRow) {
				startRow = row;
				for (; i < rows.length; i++) {
					if (this.isRowSelected(rows[i])) {
						row = rows[i];
						break;
					}
				}
			}
			this.resetSelections();
			if (startRow == row) {
				this.toggleSelectionByRow(row);
			} else {
				var doSelect = false;
				for (var i = 0; i < rows.length; i++) {
					if (rows[i] == startRow) {
						doSelect = true;
					}
					if (doSelect) {
						this.selectByRow(rows[i]);
					}
					if (rows[i] == row) {
						doSelect = false;
					}
				}
			}
		} else {
			this.toggleSelectionByRow(row);
		}
	} else {
		this.resetSelections();
		this.toggleSelectionByRow(row);
	}
	this.renderSelections();
}, onSort:function (e) {
	var oldIndex = this.sortIndex;
	var oldDirection = this.sortDirection;
	var source = e.target;
	var row = dojo.html.getParentByType(source, "tr");
	var cellTag = "td";
	if (row.getElementsByTagName(cellTag).length == 0) {
		cellTag = "th";
	}
	var headers = row.getElementsByTagName(cellTag);
	var header = dojo.html.getParentByType(source, cellTag);
	for (var i = 0; i < headers.length; i++) {
		dojo.html.setClass(headers[i], this.headerClass);
		if (headers[i] == header) {
			if (this.sortInformation[0].index != i) {
				this.sortInformation.unshift({index:i, direction:0});
			} else {
				this.sortInformation[0] = {index:i, direction:(~this.sortInformation[0].direction) & 1};
			}
		}
	}
	this.sortInformation.length = Math.min(this.sortInformation.length, this.maxSortable);
	for (var i = 0; i < this.sortInformation.length; i++) {
		var idx = this.sortInformation[i].index;
		var dir = (~this.sortInformation[i].direction) & 1;
		dojo.html.setClass(headers[idx], dir == 0 ? this.headerDownClass : this.headerUpClass);
	}
	this.render();
}, onFilter:function () {
}, _defaultFilter:function (obj) {
	return true;
}, setFilter:function (field, fn) {
	for (var i = 0; i < this.columns.length; i++) {
		if (this.columns[i].getField() == field) {
			this.columns[i].filterFunction = fn;
			break;
		}
	}
	this.applyFilters();
}, setFilterByIndex:function (idx, fn) {
	this.columns[idx].filterFunction = fn;
	this.applyFilters();
}, clearFilter:function (field) {
	for (var i = 0; i < this.columns.length; i++) {
		if (this.columns[i].getField() == field) {
			this.columns[i].filterFunction = this._defaultFilter;
			break;
		}
	}
	this.applyFilters();
}, clearFilterByIndex:function (idx) {
	this.columns[idx].filterFunction = this._defaultFilter;
	this.applyFilters();
}, clearFilters:function () {
	for (var i = 0; i < this.columns.length; i++) {
		this.columns[i].filterFunction = this._defaultFilter;
	}
	var rows = this.domNode.tBodies[0].rows;
	for (var i = 0; i < rows.length; i++) {
		rows[i].style.display = "";
		if (this.alternateRows) {
			dojo.html[((i % 2 == 1) ? "addClass" : "removeClass")](rows[i], this.rowAlternateClass);
		}
	}
	this.onFilter();
}, applyFilters:function () {
	var alt = 0;
	var rows = this.domNode.tBodies[0].rows;
	for (var i = 0; i < rows.length; i++) {
		var b = true;
		var row = rows[i];
		for (var j = 0; j < this.columns.length; j++) {
			var value = this.store.getField(this.getDataByRow(row), this.columns[j].getField());
			if (this.columns[j].getType() == Date && value != null && !value.getYear) {
				value = new Date(value);
			}
			if (!this.columns[j].filterFunction(value)) {
				b = false;
				break;
			}
		}
		row.style.display = (b ? "" : "none");
		if (b && this.alternateRows) {
			dojo.html[((alt++ % 2 == 1) ? "addClass" : "removeClass")](row, this.rowAlternateClass);
		}
	}
	this.onFilter();
}, createSorter:function (info) {
	var self = this;
	var sortFunctions = [];
	function createSortFunction(fieldIndex, dir) {
		var meta = self.columns[fieldIndex];
		var field = meta.getField();
		return function (rowA, rowB) {
			if (dojo.html.hasAttribute(rowA, "emptyRow")) {
				return 1;
			}
			if (dojo.html.hasAttribute(rowB, "emptyRow")) {
				return -1;
			}
			var a = self.store.getField(self.getDataByRow(rowA), field);
			var b = self.store.getField(self.getDataByRow(rowB), field);
			var ret = 0;
			if (a > b) {
				ret = 1;
			}
			if (a < b) {
				ret = -1;
			}
			return dir * ret;
		};
	}
	var current = 0;
	var max = Math.min(info.length, this.maxSortable, this.columns.length);
	while (current < max) {
		var direction = (info[current].direction == 0) ? 1 : -1;
		sortFunctions.push(createSortFunction(info[current].index, direction));
		current++;
	}
	return function (rowA, rowB) {
		var idx = 0;
		while (idx < sortFunctions.length) {
			var ret = sortFunctions[idx++](rowA, rowB);
			if (ret != 0) {
				return ret;
			}
		}
		return 0;
	};
}, createRow:function (obj) {
	var row = document.createElement("tr");
	dojo.html.disableSelection(row);
	if (obj.key != null) {
		row.setAttribute("value", obj.key);
	}
	for (var j = 0; j < this.columns.length; j++) {
		var cell = document.createElement("td");
		cell.setAttribute("align", this.columns[j].align);
		cell.setAttribute("valign", this.columns[j].valign);
		dojo.html.disableSelection(cell);
		var val = this.store.getField(obj.src, this.columns[j].getField());
		if (typeof (val) == "undefined") {
			val = "";
		}
		this.fillCell(cell, this.columns[j], val);
		row.appendChild(cell);
	}
	return row;
}, fillCell:function (cell, meta, val) {
	if (meta.sortType == "__markup__") {
		cell.innerHTML = val;
	} else {
		if (meta.getType() == Date) {
			val = new Date(val);
			if (!isNaN(val)) {
				var format = this.defaultDateFormat;
				if (meta.format) {
					format = meta.format;
				}
				cell.innerHTML = dojo.date.strftime(val, format);
			} else {
				cell.innerHTML = val;
			}
		} else {
			if ("Number number int Integer float Float".indexOf(meta.getType()) > -1) {
				if (val.length == 0) {
					val = "0";
				}
				var n = parseFloat(val, 10) + "";
				if (n.indexOf(".") > -1) {
					n = dojo.math.round(parseFloat(val, 10), 2);
				}
				cell.innerHTML = n;
			} else {
				cell.innerHTML = val;
			}
		}
	}
}, prefill:function () {
	this.isInitialized = false;
	var body = this.domNode.tBodies[0];
	while (body.childNodes.length > 0) {
		body.removeChild(body.childNodes[0]);
	}
	if (this.minRows > 0) {
		for (var i = 0; i < this.minRows; i++) {
			var row = document.createElement("tr");
			if (this.alternateRows) {
				dojo.html[((i % 2 == 1) ? "addClass" : "removeClass")](row, this.rowAlternateClass);
			}
			row.setAttribute("emptyRow", "true");
			for (var j = 0; j < this.columns.length; j++) {
				var cell = document.createElement("td");
				cell.innerHTML = "&nbsp;";
				row.appendChild(cell);
			}
			body.appendChild(row);
		}
	}
}, init:function () {
	this.isInitialized = false;
	var head = this.domNode.getElementsByTagName("thead")[0];
	if (head.getElementsByTagName("tr").length == 0) {
		var row = document.createElement("tr");
		for (var i = 0; i < this.columns.length; i++) {
			var cell = document.createElement("td");
			cell.setAttribute("align", this.columns[i].align);
			cell.setAttribute("valign", this.columns[i].valign);
			dojo.html.disableSelection(cell);
			cell.innerHTML = this.columns[i].label;
			row.appendChild(cell);
			if (!this.columns[i].noSort) {
				dojo.event.connect(cell, "onclick", this, "onSort");
			}
		}
		dojo.html.prependChild(row, head);
	}
	if (this.store.get().length == 0) {
		return false;
	}
	var idx = this.domNode.tBodies[0].rows.length;
	if (!idx || idx == 0 || this.domNode.tBodies[0].rows[0].getAttribute("emptyRow") == "true") {
		idx = 0;
		var body = this.domNode.tBodies[0];
		while (body.childNodes.length > 0) {
			body.removeChild(body.childNodes[0]);
		}
		var data = this.store.get();
		for (var i = 0; i < data.length; i++) {
			var row = this.createRow(data[i]);
			body.appendChild(row);
			idx++;
		}
	}
	if (this.minRows > 0 && idx < this.minRows) {
		idx = this.minRows - idx;
		for (var i = 0; i < idx; i++) {
			row = document.createElement("tr");
			row.setAttribute("emptyRow", "true");
			for (var j = 0; j < this.columns.length; j++) {
				cell = document.createElement("td");
				cell.innerHTML = "&nbsp;";
				row.appendChild(cell);
			}
			body.appendChild(row);
		}
	}
	var row = this.domNode.getElementsByTagName("thead")[0].rows[0];
	var cellTag = "td";
	if (row.getElementsByTagName(cellTag).length == 0) {
		cellTag = "th";
	}
	var headers = row.getElementsByTagName(cellTag);
	for (var i = 0; i < headers.length; i++) {
		dojo.html.setClass(headers[i], this.headerClass);
	}
	for (var i = 0; i < this.sortInformation.length; i++) {
		var idx = this.sortInformation[i].index;
		var dir = (~this.sortInformation[i].direction) & 1;
		dojo.html.setClass(headers[idx], dir == 0 ? this.headerDownClass : this.headerUpClass);
	}
	this.isInitialized = true;
	return this.isInitialized;
}, render:function () {
	if (!this.isInitialized) {
		var b = this.init();
		if (!b) {
			this.prefill();
			return;
		}
	}
	var rows = [];
	var body = this.domNode.tBodies[0];
	var emptyRowIdx = -1;
	for (var i = 0; i < body.rows.length; i++) {
		rows.push(body.rows[i]);
	}
	var sortFunction = this.createSorter(this.sortInformation);
	if (sortFunction) {
		rows.sort(sortFunction);
	}
	for (var i = 0; i < rows.length; i++) {
		if (this.alternateRows) {
			dojo.html[((i % 2 == 1) ? "addClass" : "removeClass")](rows[i], this.rowAlternateClass);
		}
		dojo.html[(this.isRowSelected(body.rows[i]) ? "addClass" : "removeClass")](body.rows[i], this.rowSelectedClass);
		body.appendChild(rows[i]);
	}
}, renderSelections:function () {
	var body = this.domNode.tBodies[0];
	for (var i = 0; i < body.rows.length; i++) {
		dojo.html[(this.isRowSelected(body.rows[i]) ? "addClass" : "removeClass")](body.rows[i], this.rowSelectedClass);
	}
}, initialize:function () {
	var self = this;
	dojo.event.connect(this.store, "onSetData", function () {
		self.store.forEach(function (element) {
			element.isSelected = false;
		});
		self.isInitialized = false;
		var body = self.domNode.tBodies[0];
		if (body) {
			while (body.childNodes.length > 0) {
				body.removeChild(body.childNodes[0]);
			}
		}
		self.render();
	});
	dojo.event.connect(this.store, "onClearData", function () {
		self.isInitialized = false;
		self.render();
	});
	dojo.event.connect(this.store, "onAddData", function (addedObject) {
		var row = self.createRow(addedObject);
		self.domNode.tBodies[0].appendChild(row);
		self.render();
	});
	dojo.event.connect(this.store, "onAddDataRange", function (arr) {
		for (var i = 0; i < arr.length; i++) {
			arr[i].isSelected = false;
			var row = self.createRow(arr[i]);
			self.domNode.tBodies[0].appendChild(row);
		}
		self.render();
	});
	dojo.event.connect(this.store, "onRemoveData", function (removedObject) {
		var rows = self.domNode.tBodies[0].rows;
		for (var i = 0; i < rows.length; i++) {
			if (self.getDataByRow(rows[i]) == removedObject.src) {
				rows[i].parentNode.removeChild(rows[i]);
				break;
			}
		}
		self.render();
	});
	dojo.event.connect(this.store, "onUpdateField", function (obj, fieldPath, val) {
		var row = self.getRow(obj);
		var idx = self.getColumnIndex(fieldPath);
		if (row && row.cells[idx] && self.columns[idx]) {
			self.fillCell(row.cells[idx], self.columns[idx], val);
		}
	});
}, postCreate:function () {
	this.store.keyField = this.valueField;
	if (this.domNode) {
		if (this.domNode.nodeName.toLowerCase() != "table") {
		}
		if (this.domNode.getElementsByTagName("thead")[0]) {
			var head = this.domNode.getElementsByTagName("thead")[0];
			if (this.headClass.length > 0) {
				head.className = this.headClass;
			}
			dojo.html.disableSelection(this.domNode);
			this.parseMetadata(head);
			var header = "td";
			if (head.getElementsByTagName(header).length == 0) {
				header = "th";
			}
			var headers = head.getElementsByTagName(header);
			for (var i = 0; i < headers.length; i++) {
				if (!this.columns[i].noSort) {
					dojo.event.connect(headers[i], "onclick", this, "onSort");
				}
			}
		} else {
			this.domNode.appendChild(document.createElement("thead"));
		}
		if (this.domNode.tBodies.length < 1) {
			var body = document.createElement("tbody");
			this.domNode.appendChild(body);
		} else {
			var body = this.domNode.tBodies[0];
		}
		if (this.tbodyClass.length > 0) {
			body.className = this.tbodyClass;
		}
		dojo.event.connect(body, "onclick", this, "onSelect");
		this.parseData(body);
	}
}});


__CPAN_FILE__ src/widget/Manager.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.widget.Manager");
dojo.require("dojo.lang.array");
dojo.require("dojo.lang.func");
dojo.require("dojo.event.*");
dojo.widget.manager = new function () {
	this.widgets = [];
	this.widgetIds = [];
	this.topWidgets = {};
	var widgetTypeCtr = {};
	var renderPrefixCache = [];
	this.getUniqueId = function (widgetType) {
		var widgetId;
		do {
			widgetId = widgetType + "_" + (widgetTypeCtr[widgetType] != undefined ? ++widgetTypeCtr[widgetType] : widgetTypeCtr[widgetType] = 0);
		} while (this.getWidgetById(widgetId));
		return widgetId;
	};
	this.add = function (widget) {
		this.widgets.push(widget);
		if (!widget.extraArgs["id"]) {
			widget.extraArgs["id"] = widget.extraArgs["ID"];
		}
		if (widget.widgetId == "") {
			if (widget["id"]) {
				widget.widgetId = widget["id"];
			} else {
				if (widget.extraArgs["id"]) {
					widget.widgetId = widget.extraArgs["id"];
				} else {
					widget.widgetId = this.getUniqueId(widget.ns + "_" + widget.widgetType);
				}
			}
		}
		if (this.widgetIds[widget.widgetId]) {
			dojo.debug("widget ID collision on ID: " + widget.widgetId);
		}
		this.widgetIds[widget.widgetId] = widget;
	};
	this.destroyAll = function () {
		for (var x = this.widgets.length - 1; x >= 0; x--) {
			try {
				this.widgets[x].destroy(true);
				delete this.widgets[x];
			}
			catch (e) {
			}
		}
	};
	this.remove = function (widgetIndex) {
		if (dojo.lang.isNumber(widgetIndex)) {
			var tw = this.widgets[widgetIndex].widgetId;
			delete this.topWidgets[tw];
			delete this.widgetIds[tw];
			this.widgets.splice(widgetIndex, 1);
		} else {
			this.removeById(widgetIndex);
		}
	};
	this.removeById = function (id) {
		if (!dojo.lang.isString(id)) {
			id = id["widgetId"];
			if (!id) {
				dojo.debug("invalid widget or id passed to removeById");
				return;
			}
		}
		for (var i = 0; i < this.widgets.length; i++) {
			if (this.widgets[i].widgetId == id) {
				this.remove(i);
				break;
			}
		}
	};
	this.getWidgetById = function (id) {
		if (dojo.lang.isString(id)) {
			return this.widgetIds[id];
		}
		return id;
	};
	this.getWidgetsByType = function (type) {
		var lt = type.toLowerCase();
		var getType = (type.indexOf(":") < 0 ? function (x) {
			return x.widgetType.toLowerCase();
		} : function (x) {
			return x.getNamespacedType();
		});
		var ret = [];
		dojo.lang.forEach(this.widgets, function (x) {
			if (getType(x) == lt) {
				ret.push(x);
			}
		});
		return ret;
	};
	this.getWidgetsByFilter = function (unaryFunc, onlyOne) {
		var ret = [];
		dojo.lang.every(this.widgets, function (x) {
			if (unaryFunc(x)) {
				ret.push(x);
				if (onlyOne) {
					return false;
				}
			}
			return true;
		});
		return (onlyOne ? ret[0] : ret);
	};
	this.getAllWidgets = function () {
		return this.widgets.concat();
	};
	this.getWidgetByNode = function (node) {
		var w = this.getAllWidgets();
		node = dojo.byId(node);
		for (var i = 0; i < w.length; i++) {
			if (w[i].domNode == node) {
				return w[i];
			}
		}
		return null;
	};
	this.byId = this.getWidgetById;
	this.byType = this.getWidgetsByType;
	this.byFilter = this.getWidgetsByFilter;
	this.byNode = this.getWidgetByNode;
	var knownWidgetImplementations = {};
	var widgetPackages = ["dojo.widget"];
	for (var i = 0; i < widgetPackages.length; i++) {
		widgetPackages[widgetPackages[i]] = true;
	}
	this.registerWidgetPackage = function (pname) {
		if (!widgetPackages[pname]) {
			widgetPackages[pname] = true;
			widgetPackages.push(pname);
		}
	};
	this.getWidgetPackageList = function () {
		return dojo.lang.map(widgetPackages, function (elt) {
			return (elt !== true ? elt : undefined);
		});
	};
	this.getImplementation = function (widgetName, ctorObject, mixins, ns) {
		var impl = this.getImplementationName(widgetName, ns);
		if (impl) {
			var ret = ctorObject ? new impl(ctorObject) : new impl();
			return ret;
		}
	};
	function buildPrefixCache() {
		for (var renderer in dojo.render) {
			if (dojo.render[renderer]["capable"] === true) {
				var prefixes = dojo.render[renderer].prefixes;
				for (var i = 0; i < prefixes.length; i++) {
					renderPrefixCache.push(prefixes[i].toLowerCase());
				}
			}
		}
	}
	var findImplementationInModule = function (lowerCaseWidgetName, module) {
		if (!module) {
			return null;
		}
		for (var i = 0, l = renderPrefixCache.length, widgetModule; i <= l; i++) {
			widgetModule = (i < l ? module[renderPrefixCache[i]] : module);
			if (!widgetModule) {
				continue;
			}
			for (var name in widgetModule) {
				if (name.toLowerCase() == lowerCaseWidgetName) {
					return widgetModule[name];
				}
			}
		}
		return null;
	};
	var findImplementation = function (lowerCaseWidgetName, moduleName) {
		var module = dojo.evalObjPath(moduleName, false);
		return (module ? findImplementationInModule(lowerCaseWidgetName, module) : null);
	};
	this.getImplementationName = function (widgetName, ns) {
		var lowerCaseWidgetName = widgetName.toLowerCase();
		ns = ns || "dojo";
		var imps = knownWidgetImplementations[ns] || (knownWidgetImplementations[ns] = {});
		var impl = imps[lowerCaseWidgetName];
		if (impl) {
			return impl;
		}
		if (!renderPrefixCache.length) {
			buildPrefixCache();
		}
		var nsObj = dojo.ns.get(ns);
		if (!nsObj) {
			dojo.ns.register(ns, ns + ".widget");
			nsObj = dojo.ns.get(ns);
		}
		if (nsObj) {
			nsObj.resolve(widgetName);
		}
		impl = findImplementation(lowerCaseWidgetName, nsObj.module);
		if (impl) {
			return (imps[lowerCaseWidgetName] = impl);
		}
		nsObj = dojo.ns.require(ns);
		if ((nsObj) && (nsObj.resolver)) {
			nsObj.resolve(widgetName);
			impl = findImplementation(lowerCaseWidgetName, nsObj.module);
			if (impl) {
				return (imps[lowerCaseWidgetName] = impl);
			}
		}
		dojo.deprecated("dojo.widget.Manager.getImplementationName", "Could not locate widget implementation for \"" + widgetName + "\" in \"" + nsObj.module + "\" registered to namespace \"" + nsObj.name + "\". " + "Developers must specify correct namespaces for all non-Dojo widgets", "0.5");
		for (var i = 0; i < widgetPackages.length; i++) {
			impl = findImplementation(lowerCaseWidgetName, widgetPackages[i]);
			if (impl) {
				return (imps[lowerCaseWidgetName] = impl);
			}
		}
		throw new Error("Could not locate widget implementation for \"" + widgetName + "\" in \"" + nsObj.module + "\" registered to namespace \"" + nsObj.name + "\"");
	};
	this.resizing = false;
	this.onWindowResized = function () {
		if (this.resizing) {
			return;
		}
		try {
			this.resizing = true;
			for (var id in this.topWidgets) {
				var child = this.topWidgets[id];
				if (child.checkSize) {
					child.checkSize();
				}
			}
		}
		catch (e) {
		}
		finally {
			this.resizing = false;
		}
	};
	if (typeof window != "undefined") {
		dojo.addOnLoad(this, "onWindowResized");
		dojo.event.connect(window, "onresize", this, "onWindowResized");
	}
};
(function () {
	var dw = dojo.widget;
	var dwm = dw.manager;
	var h = dojo.lang.curry(dojo.lang, "hitch", dwm);
	var g = function (oldName, newName) {
		dw[(newName || oldName)] = h(oldName);
	};
	g("add", "addWidget");
	g("destroyAll", "destroyAllWidgets");
	g("remove", "removeWidget");
	g("removeById", "removeWidgetById");
	g("getWidgetById");
	g("getWidgetById", "byId");
	g("getWidgetsByType");
	g("getWidgetsByFilter");
	g("getWidgetsByType", "byType");
	g("getWidgetsByFilter", "byFilter");
	g("getWidgetByNode", "byNode");
	dw.all = function (n) {
		var widgets = dwm.getAllWidgets.apply(dwm, arguments);
		if (arguments.length > 0) {
			return widgets[n];
		}
		return widgets;
	};
	g("registerWidgetPackage");
	g("getImplementation", "getWidgetImplementation");
	g("getImplementationName", "getWidgetImplementationName");
	dw.widgets = dwm.widgets;
	dw.widgetIds = dwm.widgetIds;
	dw.root = dwm.root;
})();


__CPAN_FILE__ src/widget/DatePicker.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.widget.DatePicker");
dojo.require("dojo.date.common");
dojo.require("dojo.date.format");
dojo.require("dojo.date.serialize");
dojo.require("dojo.widget.*");
dojo.require("dojo.widget.HtmlWidget");
dojo.require("dojo.event.*");
dojo.require("dojo.dom");
dojo.require("dojo.html.style");
dojo.widget.defineWidget("dojo.widget.DatePicker", dojo.widget.HtmlWidget, {value:"", name:"", displayWeeks:6, adjustWeeks:false, startDate:"1492-10-12", endDate:"2941-10-12", weekStartsOn:"", staticDisplay:false, dayWidth:"narrow", classNames:{previous:"previousMonth", disabledPrevious:"previousMonthDisabled", current:"currentMonth", disabledCurrent:"currentMonthDisabled", next:"nextMonth", disabledNext:"nextMonthDisabled", currentDate:"currentDate", selectedDate:"selectedDate"}, templateString:"<div class=\"datePickerContainer\" dojoAttachPoint=\"datePickerContainerNode\">\n\t<table cellspacing=\"0\" cellpadding=\"0\" class=\"calendarContainer\">\n\t\t<thead>\n\t\t\t<tr>\n\t\t\t\t<td class=\"monthWrapper\" valign=\"top\">\n\t\t\t\t\t<table class=\"monthContainer\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\">\n\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t<td class=\"monthCurve monthCurveTL\" valign=\"top\"></td>\n\t\t\t\t\t\t\t<td class=\"monthLabelContainer\" valign=\"top\">\n\t\t\t\t\t\t\t\t<span dojoAttachPoint=\"increaseWeekNode\" \n\t\t\t\t\t\t\t\t\tdojoAttachEvent=\"onClick: onIncrementWeek;\" \n\t\t\t\t\t\t\t\t\tclass=\"incrementControl increase\">\n\t\t\t\t\t\t\t\t\t<img src=\"${dojoWidgetModuleUri}templates/images/incrementMonth.png\" \n\t\t\t\t\t\t\t\t\talt=\"&darr;\" style=\"width:7px;height:5px;\" />\n\t\t\t\t\t\t\t\t</span>\n\t\t\t\t\t\t\t\t<span \n\t\t\t\t\t\t\t\t\tdojoAttachPoint=\"increaseMonthNode\" \n\t\t\t\t\t\t\t\t\tdojoAttachEvent=\"onClick: onIncrementMonth;\" class=\"incrementControl increase\">\n\t\t\t\t\t\t\t\t\t<img src=\"${dojoWidgetModuleUri}templates/images/incrementMonth.png\" \n\t\t\t\t\t\t\t\t\t\talt=\"&darr;\"  dojoAttachPoint=\"incrementMonthImageNode\">\n\t\t\t\t\t\t\t\t</span>\n\t\t\t\t\t\t\t\t<span \n\t\t\t\t\t\t\t\t\tdojoAttachPoint=\"decreaseWeekNode\" \n\t\t\t\t\t\t\t\t\tdojoAttachEvent=\"onClick: onIncrementWeek;\" \n\t\t\t\t\t\t\t\t\tclass=\"incrementControl decrease\">\n\t\t\t\t\t\t\t\t\t<img src=\"${dojoWidgetModuleUri}templates/images/decrementMonth.png\" alt=\"&uarr;\" style=\"width:7px;height:5px;\" />\n\t\t\t\t\t\t\t\t</span>\n\t\t\t\t\t\t\t\t<span \n\t\t\t\t\t\t\t\t\tdojoAttachPoint=\"decreaseMonthNode\" \n\t\t\t\t\t\t\t\t\tdojoAttachEvent=\"onClick: onIncrementMonth;\" class=\"incrementControl decrease\">\n\t\t\t\t\t\t\t\t\t<img src=\"${dojoWidgetModuleUri}templates/images/decrementMonth.png\" \n\t\t\t\t\t\t\t\t\t\talt=\"&uarr;\" dojoAttachPoint=\"decrementMonthImageNode\">\n\t\t\t\t\t\t\t\t</span>\n\t\t\t\t\t\t\t\t<span dojoAttachPoint=\"monthLabelNode\" class=\"month\"></span>\n\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t<td class=\"monthCurve monthCurveTR\" valign=\"top\"></td>\n\t\t\t\t\t\t</tr>\n\t\t\t\t\t</table>\n\t\t\t\t</td>\n\t\t\t</tr>\n\t\t</thead>\n\t\t<tbody>\n\t\t\t<tr>\n\t\t\t\t<td colspan=\"3\">\n\t\t\t\t\t<table class=\"calendarBodyContainer\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\">\n\t\t\t\t\t\t<thead>\n\t\t\t\t\t\t\t<tr dojoAttachPoint=\"dayLabelsRow\">\n\t\t\t\t\t\t\t\t<td></td>\n\t\t\t\t\t\t\t\t<td></td>\n\t\t\t\t\t\t\t\t<td></td>\n\t\t\t\t\t\t\t\t<td></td>\n\t\t\t\t\t\t\t\t<td></td>\n\t\t\t\t\t\t\t\t<td></td>\n\t\t\t\t\t\t\t\t<td></td>\n\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t</thead>\n\t\t\t\t\t\t<tbody dojoAttachPoint=\"calendarDatesContainerNode\" \n\t\t\t\t\t\t\tdojoAttachEvent=\"onClick: _handleUiClick;\">\n\t\t\t\t\t\t\t<tr dojoAttachPoint=\"calendarWeekTemplate\">\n\t\t\t\t\t\t\t\t<td></td>\n\t\t\t\t\t\t\t\t<td></td>\n\t\t\t\t\t\t\t\t<td></td>\n\t\t\t\t\t\t\t\t<td></td>\n\t\t\t\t\t\t\t\t<td></td>\n\t\t\t\t\t\t\t\t<td></td>\n\t\t\t\t\t\t\t\t<td></td>\n\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t</tbody>\n\t\t\t\t\t</table>\n\t\t\t\t</td>\n\t\t\t</tr>\n\t\t</tbody>\n\t\t<tfoot>\n\t\t\t<tr>\n\t\t\t\t<td colspan=\"3\" class=\"yearWrapper\">\n\t\t\t\t\t<table cellspacing=\"0\" cellpadding=\"0\" border=\"0\" class=\"yearContainer\">\n\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t<td class=\"curveBL\" valign=\"top\"></td>\n\t\t\t\t\t\t\t<td valign=\"top\">\n\t\t\t\t\t\t\t\t<h3 class=\"yearLabel\">\n\t\t\t\t\t\t\t\t\t<span dojoAttachPoint=\"previousYearLabelNode\"\n\t\t\t\t\t\t\t\t\t\tdojoAttachEvent=\"onClick: onIncrementYear;\" class=\"previousYear\"></span>\n\t\t\t\t\t\t\t\t\t<span class=\"selectedYear\" dojoAttachPoint=\"currentYearLabelNode\"></span>\n\t\t\t\t\t\t\t\t\t<span dojoAttachPoint=\"nextYearLabelNode\" \n\t\t\t\t\t\t\t\t\t\tdojoAttachEvent=\"onClick: onIncrementYear;\" class=\"nextYear\"></span>\n\t\t\t\t\t\t\t\t</h3>\n\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t<td class=\"curveBR\" valign=\"top\"></td>\n\t\t\t\t\t\t</tr>\n\t\t\t\t\t</table>\n\t\t\t\t</td>\n\t\t\t</tr>\n\t\t</tfoot>\n\t</table>\n</div>\n", templateCssString:".datePickerContainer {\n\twidth:164px; /* needed for proper user styling */\n}\n\n.calendarContainer {\n/*\tborder:1px solid #566f8f;*/\n}\n\n.calendarBodyContainer {\n\twidth:100%; /* needed for the explode effect (explain?) */\n\tbackground: #7591bc url(\"images/dpBg.gif\") top left repeat-x;\n}\n\n.calendarBodyContainer thead tr td {\n\tcolor:#293a4b;\n\tfont:bold 0.75em Helvetica, Arial, Verdana, sans-serif;\n\ttext-align:center;\n\tpadding:0.25em;\n\tbackground: url(\"images/dpHorizLine.gif\") bottom left repeat-x;\n}\n\n.calendarBodyContainer tbody tr td {\n\tcolor:#fff;\n\tfont:bold 0.7em Helvetica, Arial, Verdana, sans-serif;\n\ttext-align:center;\n\tpadding:0.4em;\n\tbackground: url(\"images/dpVertLine.gif\") top right repeat-y;\n\tcursor:pointer;\n\tcursor:hand;\n}\n\n\n.monthWrapper {\n\tpadding-bottom:2px;\n\tbackground: url(\"images/dpHorizLine.gif\") bottom left repeat-x;\n}\n\n.monthContainer {\n\twidth:100%;\n}\n\n.monthLabelContainer {\n\ttext-align:center;\n\tfont:bold 0.75em Helvetica, Arial, Verdana, sans-serif;\n\tbackground: url(\"images/dpMonthBg.png\") repeat-x top left !important;\n\tcolor:#293a4b;\n\tpadding:0.25em;\n}\n\n.monthCurve {\n\twidth:12px;\n}\n\n.monthCurveTL {\n\tbackground: url(\"images/dpCurveTL.png\") no-repeat top left !important;\n}\n\n.monthCurveTR {\n\t\tbackground: url(\"images/dpCurveTR.png\") no-repeat top right !important;\n}\n\n\n.yearWrapper {\n\tbackground: url(\"images/dpHorizLineFoot.gif\") top left repeat-x;\n\tpadding-top:2px;\n}\n\n.yearContainer {\n\twidth:100%;\n}\n\n.yearContainer td {\n\tbackground:url(\"images/dpYearBg.png\") top left repeat-x;\n}\n\n.yearContainer .yearLabel {\n\tmargin:0;\n\tpadding:0.45em 0 0.45em 0;\n\tcolor:#fff;\n\tfont:bold 0.75em Helvetica, Arial, Verdana, sans-serif;\n\ttext-align:center;\n}\n\n.curveBL {\n\tbackground: url(\"images/dpCurveBL.png\") bottom left no-repeat !important;\n\twidth:9px !important;\n\tpadding:0;\n\tmargin:0;\n}\n\n.curveBR {\n\tbackground: url(\"images/dpCurveBR.png\") bottom right no-repeat !important;\n\twidth:9px !important;\n\tpadding:0;\n\tmargin:0;\n}\n\n\n.previousMonth {\n\tbackground-color:#6782a8 !important;\n}\n\n.previousMonthDisabled {\n\tbackground-color:#a4a5a6 !important;\n\tcursor:default !important\n}\n.currentMonth {\n}\n\n.currentMonthDisabled {\n\tbackground-color:#bbbbbc !important;\n\tcursor:default !important\n}\n.nextMonth {\n\tbackground-color:#6782a8 !important;\n}\n.nextMonthDisabled {\n\tbackground-color:#a4a5a6 !important;\n\tcursor:default !important;\n}\n\n.currentDate {\n\ttext-decoration:underline;\n\tfont-style:italic;\n}\n\n.selectedDate {\n\tbackground-color:#fff !important;\n\tcolor:#6782a8 !important;\n}\n\n.yearLabel .selectedYear {\n\tpadding:0.2em;\n\tbackground-color:#9ec3fb !important;\n}\n\n.nextYear, .previousYear {\n\tcursor:pointer;cursor:hand;\n\tpadding:0;\n}\n\n.nextYear {\n\tmargin:0 0 0 0.55em;\n}\n\n.previousYear {\n\tmargin:0 0.55em 0 0;\n}\n\n.incrementControl {\n\tcursor:pointer;cursor:hand;\n\twidth:1em;\n}\n\n.increase {\n\tfloat:right;\n}\n\n.decrease {\n\tfloat:left;\n}\n\n.lastColumn {\n\tbackground-image:none !important;\n}\n\n\n", templateCssPath:dojo.uri.moduleUri("dojo.widget", "templates/DatePicker.css"), postMixInProperties:function () {
	dojo.widget.DatePicker.superclass.postMixInProperties.apply(this, arguments);
	if (!this.weekStartsOn) {
		this.weekStartsOn = dojo.date.getFirstDayOfWeek(this.lang);
	}
	this.today = new Date();
	this.today.setHours(0, 0, 0, 0);
	if (typeof (this.value) == "string" && this.value.toLowerCase() == "today") {
		this.value = new Date();
	} else {
		if (this.value && (typeof this.value == "string") && (this.value.split("-").length > 2)) {
			this.value = dojo.date.fromRfc3339(this.value);
			this.value.setHours(0, 0, 0, 0);
		}
	}
}, fillInTemplate:function (args, frag) {
	dojo.widget.DatePicker.superclass.fillInTemplate.apply(this, arguments);
	var source = this.getFragNodeRef(frag);
	dojo.html.copyStyle(this.domNode, source);
	this.weekTemplate = dojo.dom.removeNode(this.calendarWeekTemplate);
	this._preInitUI(this.value ? this.value : this.today, false, true);
	var dayLabels = dojo.lang.unnest(dojo.date.getNames("days", this.dayWidth, "standAlone", this.lang));
	if (this.weekStartsOn > 0) {
		for (var i = 0; i < this.weekStartsOn; i++) {
			dayLabels.push(dayLabels.shift());
		}
	}
	var dayLabelNodes = this.dayLabelsRow.getElementsByTagName("td");
	for (i = 0; i < 7; i++) {
		dayLabelNodes.item(i).innerHTML = dayLabels[i];
	}
	if (this.value) {
		this.setValue(this.value);
	}
}, getValue:function () {
	return dojo.date.toRfc3339(new Date(this.value), "dateOnly");
}, getDate:function () {
	return this.value;
}, setValue:function (rfcDate) {
	this.setDate(rfcDate);
}, setDate:function (dateObj) {
	if (dateObj == "") {
		this.value = "";
		this._preInitUI(this.curMonth, false, true);
	} else {
		if (typeof dateObj == "string") {
			this.value = dojo.date.fromRfc3339(dateObj);
			this.value.setHours(0, 0, 0, 0);
		} else {
			this.value = new Date(dateObj);
			this.value.setHours(0, 0, 0, 0);
		}
	}
	if (this.selectedNode != null) {
		dojo.html.removeClass(this.selectedNode, this.classNames.selectedDate);
	}
	if (this.clickedNode != null) {
		dojo.debug("adding selectedDate");
		dojo.html.addClass(this.clickedNode, this.classNames.selectedDate);
		this.selectedNode = this.clickedNode;
	} else {
		this._preInitUI(this.value, false, true);
	}
	this.clickedNode = null;
	this.onValueChanged(this.value);
}, _preInitUI:function (dateObj, initFirst, initUI) {
	if (typeof (this.startDate) == "string") {
		this.startDate = dojo.date.fromRfc3339(this.startDate);
	}
	if (typeof (this.endDate) == "string") {
		this.endDate = dojo.date.fromRfc3339(this.endDate);
	}
	this.startDate.setHours(0, 0, 0, 0);
	this.endDate.setHours(24, 0, 0, -1);
	if (dateObj < this.startDate || dateObj > this.endDate) {
		dateObj = new Date((dateObj < this.startDate) ? this.startDate : this.endDate);
	}
	this.firstDay = this._initFirstDay(dateObj, initFirst);
	this.selectedIsUsed = false;
	this.currentIsUsed = false;
	var nextDate = new Date(this.firstDay);
	var tmpMonth = nextDate.getMonth();
	this.curMonth = new Date(nextDate);
	this.curMonth.setDate(nextDate.getDate() + 6);
	this.curMonth.setDate(1);
	if (this.displayWeeks == "" || this.adjustWeeks) {
		this.adjustWeeks = true;
		this.displayWeeks = Math.ceil((dojo.date.getDaysInMonth(this.curMonth) + this._getAdjustedDay(this.curMonth)) / 7);
	}
	var days = this.displayWeeks * 7;
	if (dojo.date.diff(this.startDate, this.endDate, dojo.date.dateParts.DAY) < days) {
		this.staticDisplay = true;
		if (dojo.date.diff(nextDate, this.endDate, dojo.date.dateParts.DAY) > days) {
			this._preInitUI(this.startDate, true, false);
			nextDate = new Date(this.firstDay);
		}
		this.curMonth = new Date(nextDate);
		this.curMonth.setDate(nextDate.getDate() + 6);
		this.curMonth.setDate(1);
		var curClass = (nextDate.getMonth() == this.curMonth.getMonth()) ? "current" : "previous";
	}
	if (initUI) {
		this._initUI(days);
	}
}, _initUI:function (days) {
	dojo.dom.removeChildren(this.calendarDatesContainerNode);
	for (var i = 0; i < this.displayWeeks; i++) {
		this.calendarDatesContainerNode.appendChild(this.weekTemplate.cloneNode(true));
	}
	var nextDate = new Date(this.firstDay);
	this._setMonthLabel(this.curMonth.getMonth());
	this._setYearLabels(this.curMonth.getFullYear());
	var calendarNodes = this.calendarDatesContainerNode.getElementsByTagName("td");
	var calendarRows = this.calendarDatesContainerNode.getElementsByTagName("tr");
	var currentCalendarNode;
	for (i = 0; i < days; i++) {
		currentCalendarNode = calendarNodes.item(i);
		currentCalendarNode.innerHTML = nextDate.getDate();
		currentCalendarNode.setAttribute("djDateValue", nextDate.valueOf());
		var curClass = (nextDate.getMonth() != this.curMonth.getMonth() && Number(nextDate) < Number(this.curMonth)) ? "previous" : (nextDate.getMonth() == this.curMonth.getMonth()) ? "current" : "next";
		var mappedClass = curClass;
		if (this._isDisabledDate(nextDate)) {
			var classMap = {previous:"disabledPrevious", current:"disabledCurrent", next:"disabledNext"};
			mappedClass = classMap[curClass];
		}
		dojo.html.setClass(currentCalendarNode, this._getDateClassName(nextDate, mappedClass));
		if (dojo.html.hasClass(currentCalendarNode, this.classNames.selectedDate)) {
			this.selectedNode = currentCalendarNode;
		}
		nextDate = dojo.date.add(nextDate, dojo.date.dateParts.DAY, 1);
	}
	this.lastDay = dojo.date.add(nextDate, dojo.date.dateParts.DAY, -1);
	this._initControls();
}, _initControls:function () {
	var d = this.firstDay;
	var d2 = this.lastDay;
	var decWeek, incWeek, decMonth, incMonth, decYear, incYear;
	decWeek = incWeek = decMonth = incMonth = decYear = incYear = !this.staticDisplay;
	with (dojo.date.dateParts) {
		var add = dojo.date.add;
		if (decWeek && add(d, DAY, (-1 * (this._getAdjustedDay(d) + 1))) < this.startDate) {
			decWeek = decMonth = decYear = false;
		}
		if (incWeek && d2 > this.endDate) {
			incWeek = incMonth = incYear = false;
		}
		if (decMonth && add(d, DAY, -1) < this.startDate) {
			decMonth = decYear = false;
		}
		if (incMonth && add(d2, DAY, 1) > this.endDate) {
			incMonth = incYear = false;
		}
		if (decYear && add(d2, YEAR, -1) < this.startDate) {
			decYear = false;
		}
		if (incYear && add(d, YEAR, 1) > this.endDate) {
			incYear = false;
		}
	}
	function enableControl(node, enabled) {
		dojo.html.setVisibility(node, enabled ? "" : "hidden");
	}
	enableControl(this.decreaseWeekNode, decWeek);
	enableControl(this.increaseWeekNode, incWeek);
	enableControl(this.decreaseMonthNode, decMonth);
	enableControl(this.increaseMonthNode, incMonth);
	enableControl(this.previousYearLabelNode, decYear);
	enableControl(this.nextYearLabelNode, incYear);
}, _incrementWeek:function (evt) {
	var d = new Date(this.firstDay);
	switch (evt.target) {
	  case this.increaseWeekNode.getElementsByTagName("img").item(0):
	  case this.increaseWeekNode:
		var tmpDate = dojo.date.add(d, dojo.date.dateParts.WEEK, 1);
		if (tmpDate < this.endDate) {
			d = dojo.date.add(d, dojo.date.dateParts.WEEK, 1);
		}
		break;
	  case this.decreaseWeekNode.getElementsByTagName("img").item(0):
	  case this.decreaseWeekNode:
		if (d >= this.startDate) {
			d = dojo.date.add(d, dojo.date.dateParts.WEEK, -1);
		}
		break;
	}
	this._preInitUI(d, true, true);
}, _incrementMonth:function (evt) {
	var d = new Date(this.curMonth);
	var tmpDate = new Date(this.firstDay);
	switch (evt.currentTarget) {
	  case this.increaseMonthNode.getElementsByTagName("img").item(0):
	  case this.increaseMonthNode:
		tmpDate = dojo.date.add(tmpDate, dojo.date.dateParts.DAY, this.displayWeeks * 7);
		if (tmpDate < this.endDate) {
			d = dojo.date.add(d, dojo.date.dateParts.MONTH, 1);
		} else {
			var revertToEndDate = true;
		}
		break;
	  case this.decreaseMonthNode.getElementsByTagName("img").item(0):
	  case this.decreaseMonthNode:
		if (tmpDate > this.startDate) {
			d = dojo.date.add(d, dojo.date.dateParts.MONTH, -1);
		} else {
			var revertToStartDate = true;
		}
		break;
	}
	if (revertToStartDate) {
		d = new Date(this.startDate);
	} else {
		if (revertToEndDate) {
			d = new Date(this.endDate);
		}
	}
	this._preInitUI(d, false, true);
}, _incrementYear:function (evt) {
	var year = this.curMonth.getFullYear();
	var tmpDate = new Date(this.firstDay);
	switch (evt.target) {
	  case this.nextYearLabelNode:
		tmpDate = dojo.date.add(tmpDate, dojo.date.dateParts.YEAR, 1);
		if (tmpDate < this.endDate) {
			year++;
		} else {
			var revertToEndDate = true;
		}
		break;
	  case this.previousYearLabelNode:
		tmpDate = dojo.date.add(tmpDate, dojo.date.dateParts.YEAR, -1);
		if (tmpDate > this.startDate) {
			year--;
		} else {
			var revertToStartDate = true;
		}
		break;
	}
	var d;
	if (revertToStartDate) {
		d = new Date(this.startDate);
	} else {
		if (revertToEndDate) {
			d = new Date(this.endDate);
		} else {
			d = new Date(year, this.curMonth.getMonth(), 1);
		}
	}
	this._preInitUI(d, false, true);
}, onIncrementWeek:function (evt) {
	evt.stopPropagation();
	if (!this.staticDisplay) {
		this._incrementWeek(evt);
	}
}, onIncrementMonth:function (evt) {
	evt.stopPropagation();
	if (!this.staticDisplay) {
		this._incrementMonth(evt);
	}
}, onIncrementYear:function (evt) {
	evt.stopPropagation();
	if (!this.staticDisplay) {
		this._incrementYear(evt);
	}
}, _setMonthLabel:function (monthIndex) {
	this.monthLabelNode.innerHTML = dojo.date.getNames("months", "wide", "standAlone", this.lang)[monthIndex];
}, _setYearLabels:function (year) {
	var y = year - 1;
	var that = this;
	function f(n) {
		that[n + "YearLabelNode"].innerHTML = dojo.date.format(new Date(y++, 0), {formatLength:"yearOnly", locale:that.lang});
	}
	f("previous");
	f("current");
	f("next");
}, _getDateClassName:function (date, monthState) {
	var currentClassName = this.classNames[monthState];
	if ((!this.selectedIsUsed && this.value) && (Number(date) == Number(this.value))) {
		currentClassName = this.classNames.selectedDate + " " + currentClassName;
		this.selectedIsUsed = true;
	}
	if ((!this.currentIsUsed) && (Number(date) == Number(this.today))) {
		currentClassName = currentClassName + " " + this.classNames.currentDate;
		this.currentIsUsed = true;
	}
	return currentClassName;
}, onClick:function (evt) {
	dojo.event.browser.stopEvent(evt);
}, _handleUiClick:function (evt) {
	var eventTarget = evt.target;
	if (eventTarget.nodeType != dojo.dom.ELEMENT_NODE) {
		eventTarget = eventTarget.parentNode;
	}
	dojo.event.browser.stopEvent(evt);
	this.selectedIsUsed = this.todayIsUsed = false;
	if (dojo.html.hasClass(eventTarget, this.classNames["disabledPrevious"]) || dojo.html.hasClass(eventTarget, this.classNames["disabledCurrent"]) || dojo.html.hasClass(eventTarget, this.classNames["disabledNext"])) {
		return;
	}
	this.clickedNode = eventTarget;
	this.setDate(new Date(Number(dojo.html.getAttribute(eventTarget, "djDateValue"))));
}, onValueChanged:function (date) {
}, _isDisabledDate:function (dateObj) {
	if (dateObj < this.startDate || dateObj > this.endDate) {
		return true;
	}
	return this.isDisabledDate(dateObj, this.lang);
}, isDisabledDate:function (dateObj, locale) {
	return false;
}, _initFirstDay:function (dateObj, adj) {
	var d = new Date(dateObj);
	if (!adj) {
		d.setDate(1);
	}
	d.setDate(d.getDate() - this._getAdjustedDay(d, this.weekStartsOn));
	d.setHours(0, 0, 0, 0);
	return d;
}, _getAdjustedDay:function (dateObj) {
	var days = [0, 1, 2, 3, 4, 5, 6];
	if (this.weekStartsOn > 0) {
		for (var i = 0; i < this.weekStartsOn; i++) {
			days.unshift(days.pop());
		}
	}
	return days[dateObj.getDay()];
}, destroy:function () {
	dojo.widget.DatePicker.superclass.destroy.apply(this, arguments);
	dojo.html.destroyNode(this.weekTemplate);
}});


__CPAN_FILE__ src/widget/RichText.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.widget.RichText");
dojo.require("dojo.widget.*");
dojo.require("dojo.html.*");
dojo.require("dojo.html.layout");
dojo.require("dojo.html.selection");
dojo.require("dojo.event.*");
dojo.require("dojo.string.extras");
dojo.require("dojo.uri.Uri");
dojo.require("dojo.Deferred");
if (!djConfig["useXDomain"] || djConfig["allowXdRichTextSave"]) {
	if (dojo.hostenv.post_load_) {
		(function () {
			var savetextarea = dojo.doc().createElement("textarea");
			savetextarea.id = "dojo.widget.RichText.savedContent";
			savetextarea.style = "display:none;position:absolute;top:-100px;left:-100px;height:3px;width:3px;overflow:hidden;";
			dojo.body().appendChild(savetextarea);
		})();
	} else {
		try {
			dojo.doc().write("<textarea id=\"dojo.widget.RichText.savedContent\" " + "style=\"display:none;position:absolute;top:-100px;left:-100px;height:3px;width:3px;overflow:hidden;\"></textarea>");
		}
		catch (e) {
		}
	}
}
dojo.widget.defineWidget("dojo.widget.RichText", dojo.widget.HtmlWidget, function () {
	this.contentPreFilters = [];
	this.contentPostFilters = [];
	this.contentDomPreFilters = [];
	this.contentDomPostFilters = [];
	this.editingAreaStyleSheets = [];
	if (dojo.render.html.moz) {
		this.contentPreFilters.push(this._fixContentForMoz);
	}
	this._keyHandlers = {};
	if (dojo.Deferred) {
		this.onLoadDeferred = new dojo.Deferred();
	}
}, {inheritWidth:false, focusOnLoad:false, saveName:"", styleSheets:"", _content:"", height:"", minHeight:"1em", isClosed:true, isLoaded:false, useActiveX:false, relativeImageUrls:false, _SEPARATOR:"@@**%%__RICHTEXTBOUNDRY__%%**@@", onLoadDeferred:null, fillInTemplate:function () {
	dojo.event.topic.publish("dojo.widget.RichText::init", this);
	this.open();
	dojo.event.connect(this, "onKeyPressed", this, "afterKeyPress");
	dojo.event.connect(this, "onKeyPress", this, "keyPress");
	dojo.event.connect(this, "onKeyDown", this, "keyDown");
	dojo.event.connect(this, "onKeyUp", this, "keyUp");
	this.setupDefaultShortcuts();
}, setupDefaultShortcuts:function () {
	var ctrl = this.KEY_CTRL;
	var exec = function (cmd, arg) {
		return arguments.length == 1 ? function () {
			this.execCommand(cmd);
		} : function () {
			this.execCommand(cmd, arg);
		};
	};
	this.addKeyHandler("b", ctrl, exec("bold"));
	this.addKeyHandler("i", ctrl, exec("italic"));
	this.addKeyHandler("u", ctrl, exec("underline"));
	this.addKeyHandler("a", ctrl, exec("selectall"));
	this.addKeyHandler("s", ctrl, function () {
		this.save(true);
	});
	this.addKeyHandler("1", ctrl, exec("formatblock", "h1"));
	this.addKeyHandler("2", ctrl, exec("formatblock", "h2"));
	this.addKeyHandler("3", ctrl, exec("formatblock", "h3"));
	this.addKeyHandler("4", ctrl, exec("formatblock", "h4"));
	this.addKeyHandler("\\", ctrl, exec("insertunorderedlist"));
	if (!dojo.render.html.ie) {
		this.addKeyHandler("Z", ctrl, exec("redo"));
	}
}, events:["onBlur", "onFocus", "onKeyPress", "onKeyDown", "onKeyUp", "onClick"], open:function (element) {
	if (this.onLoadDeferred.fired >= 0) {
		this.onLoadDeferred = new dojo.Deferred();
	}
	var h = dojo.render.html;
	if (!this.isClosed) {
		this.close();
	}
	dojo.event.topic.publish("dojo.widget.RichText::open", this);
	this._content = "";
	if ((arguments.length == 1) && (element["nodeName"])) {
		this.domNode = element;
	}
	if ((this.domNode["nodeName"]) && (this.domNode.nodeName.toLowerCase() == "textarea")) {
		this.textarea = this.domNode;
		var html = this._preFilterContent(this.textarea.value);
		this.domNode = dojo.doc().createElement("div");
		dojo.html.copyStyle(this.domNode, this.textarea);
		var tmpFunc = dojo.lang.hitch(this, function () {
			with (this.textarea.style) {
				display = "block";
				position = "absolute";
				left = top = "-1000px";
				if (h.ie) {
					this.__overflow = overflow;
					overflow = "hidden";
				}
			}
		});
		if (h.ie) {
			setTimeout(tmpFunc, 10);
		} else {
			tmpFunc();
		}
		if (!h.safari) {
			dojo.html.insertBefore(this.domNode, this.textarea);
		}
		if (this.textarea.form) {
			dojo.event.connect("before", this.textarea.form, "onsubmit", dojo.lang.hitch(this, function () {
				this.textarea.value = this.getEditorContent();
			}));
		}
		var editor = this;
		dojo.event.connect(this, "postCreate", function () {
			dojo.html.insertAfter(editor.textarea, editor.domNode);
		});
	} else {
		var html = this._preFilterContent(dojo.string.trim(this.domNode.innerHTML));
	}
	if (html == "") {
		html = "&nbsp;";
	}
	var content = dojo.html.getContentBox(this.domNode);
	this._oldHeight = content.height;
	this._oldWidth = content.width;
	this._firstChildContributingMargin = this._getContributingMargin(this.domNode, "top");
	this._lastChildContributingMargin = this._getContributingMargin(this.domNode, "bottom");
	this.savedContent = html;
	this.domNode.innerHTML = "";
	this.editingArea = dojo.doc().createElement("div");
	this.domNode.appendChild(this.editingArea);
	if ((this.domNode["nodeName"]) && (this.domNode.nodeName == "LI")) {
		this.domNode.innerHTML = " <br>";
	}
	if (this.saveName != "" && (!djConfig["useXDomain"] || djConfig["allowXdRichTextSave"])) {
		var saveTextarea = dojo.doc().getElementById("dojo.widget.RichText.savedContent");
		if (saveTextarea.value != "") {
			var datas = saveTextarea.value.split(this._SEPARATOR);
			for (var i = 0; i < datas.length; i++) {
				var data = datas[i].split(":");
				if (data[0] == this.saveName) {
					html = data[1];
					datas.splice(i, 1);
					break;
				}
			}
		}
		dojo.event.connect("before", window, "onunload", this, "_saveContent");
	}
	if (h.ie70 && this.useActiveX) {
		dojo.debug("activeX in ie70 is not currently supported, useActiveX is ignored for now.");
		this.useActiveX = false;
	}
	if (this.useActiveX && h.ie) {
		var self = this;
		setTimeout(function () {
			self._drawObject(html);
		}, 0);
	} else {
		if (h.ie || this._safariIsLeopard() || h.opera) {
			this.iframe = dojo.doc().createElement("iframe");
			this.iframe.src = "javascript:void(0)";
			this.editorObject = this.iframe;
			with (this.iframe.style) {
				border = "0";
				width = "100%";
			}
			this.iframe.frameBorder = 0;
			this.editingArea.appendChild(this.iframe);
			this.window = this.iframe.contentWindow;
			this.document = this.window.document;
			this.document.open();
			this.document.write("<html><head><style>body{margin:0;padding:0;border:0;overflow:hidden;}</style></head><body><div></div></body></html>");
			this.document.close();
			this.editNode = this.document.body.firstChild;
			this.editNode.contentEditable = true;
			with (this.iframe.style) {
				if (h.ie70) {
					if (this.height) {
						height = this.height;
					}
					if (this.minHeight) {
						minHeight = this.minHeight;
					}
				} else {
					height = this.height ? this.height : this.minHeight;
				}
			}
			var formats = ["p", "pre", "address", "h1", "h2", "h3", "h4", "h5", "h6", "ol", "div", "ul"];
			var localhtml = "";
			for (var i in formats) {
				if (formats[i].charAt(1) != "l") {
					localhtml += "<" + formats[i] + "><span>content</span></" + formats[i] + ">";
				} else {
					localhtml += "<" + formats[i] + "><li>content</li></" + formats[i] + ">";
				}
			}
			with (this.editNode.style) {
				position = "absolute";
				left = "-2000px";
				top = "-2000px";
			}
			this.editNode.innerHTML = localhtml;
			var node = this.editNode.firstChild;
			while (node) {
				dojo.withGlobal(this.window, "selectElement", dojo.html.selection, [node.firstChild]);
				var nativename = node.tagName.toLowerCase();
				this._local2NativeFormatNames[nativename] = this.queryCommandValue("formatblock");
				this._native2LocalFormatNames[this._local2NativeFormatNames[nativename]] = nativename;
				node = node.nextSibling;
			}
			with (this.editNode.style) {
				position = "";
				left = "";
				top = "";
			}
			this.editNode.innerHTML = html;
			if (this.height) {
				this.document.body.style.overflowY = "scroll";
			}
			dojo.lang.forEach(this.events, function (e) {
				dojo.event.connect(this.editNode, e.toLowerCase(), this, e);
			}, this);
			this.onLoad();
		} else {
			this._drawIframe(html);
			this.editorObject = this.iframe;
		}
	}
	if (this.domNode.nodeName == "LI") {
		this.domNode.lastChild.style.marginTop = "-1.2em";
	}
	dojo.html.addClass(this.domNode, "RichTextEditable");
	this.isClosed = false;
}, _hasCollapseableMargin:function (element, side) {
	if (dojo.html.getPixelValue(element, "border-" + side + "-width", false)) {
		return false;
	} else {
		if (dojo.html.getPixelValue(element, "padding-" + side, false)) {
			return false;
		} else {
			return true;
		}
	}
}, _getContributingMargin:function (element, topOrBottom) {
	if (topOrBottom == "top") {
		var siblingAttr = "previousSibling";
		var childSiblingAttr = "nextSibling";
		var childAttr = "firstChild";
		var marginProp = "margin-top";
		var siblingMarginProp = "margin-bottom";
	} else {
		var siblingAttr = "nextSibling";
		var childSiblingAttr = "previousSibling";
		var childAttr = "lastChild";
		var marginProp = "margin-bottom";
		var siblingMarginProp = "margin-top";
	}
	var elementMargin = dojo.html.getPixelValue(element, marginProp, false);
	function isSignificantNode(element) {
		return !(element.nodeType == 3 && dojo.string.isBlank(element.data)) && dojo.html.getStyle(element, "display") != "none" && !dojo.html.isPositionAbsolute(element);
	}
	var childMargin = 0;
	var child = element[childAttr];
	while (child) {
		while ((!isSignificantNode(child)) && child[childSiblingAttr]) {
			child = child[childSiblingAttr];
		}
		childMargin = Math.max(childMargin, dojo.html.getPixelValue(child, marginProp, false));
		if (!this._hasCollapseableMargin(child, topOrBottom)) {
			break;
		}
		child = child[childAttr];
	}
	if (!this._hasCollapseableMargin(element, topOrBottom)) {
		return parseInt(childMargin);
	}
	var contextMargin = 0;
	var sibling = element[siblingAttr];
	while (sibling) {
		if (isSignificantNode(sibling)) {
			contextMargin = dojo.html.getPixelValue(sibling, siblingMarginProp, false);
			break;
		}
		sibling = sibling[siblingAttr];
	}
	if (!sibling) {
		contextMargin = dojo.html.getPixelValue(element.parentNode, marginProp, false);
	}
	if (childMargin > elementMargin) {
		return parseInt(Math.max((childMargin - elementMargin) - contextMargin, 0));
	} else {
		return 0;
	}
}, _drawIframe:function (html) {
	var oldMoz = Boolean(dojo.render.html.moz && (typeof window.XML == "undefined"));
	if (!this.iframe) {
		var currentDomain = (new dojo.uri.Uri(dojo.doc().location)).host;
		this.iframe = dojo.doc().createElement("iframe");
		with (this.iframe) {
			style.border = "none";
			style.lineHeight = "0";
			style.verticalAlign = "bottom";
			scrolling = this.height ? "auto" : "no";
		}
	}
	if (djConfig["useXDomain"] && !djConfig["dojoRichTextFrameUrl"]) {
		dojo.debug("dojo.widget.RichText: When using cross-domain Dojo builds," + " please save src/widget/templates/richtextframe.html to your domain and set djConfig.dojoRichTextFrameUrl" + " to the path on your domain to richtextframe.html");
	}
	this.iframe.src = (djConfig["dojoRichTextFrameUrl"] || dojo.uri.moduleUri("dojo.widget", "templates/richtextframe.html")) + ((dojo.doc().domain != currentDomain) ? ("#" + dojo.doc().domain) : "");
	this.iframe.width = this.inheritWidth ? this._oldWidth : "100%";
	if (this.height) {
		this.iframe.style.height = this.height;
	} else {
		var height = this._oldHeight;
		if (this._hasCollapseableMargin(this.domNode, "top")) {
			height += this._firstChildContributingMargin;
		}
		if (this._hasCollapseableMargin(this.domNode, "bottom")) {
			height += this._lastChildContributingMargin;
		}
		this.iframe.height = height;
	}
	var tmpContent = dojo.doc().createElement("div");
	tmpContent.innerHTML = html;
	this.editingArea.appendChild(tmpContent);
	if (this.relativeImageUrls) {
		var imgs = tmpContent.getElementsByTagName("img");
		for (var i = 0; i < imgs.length; i++) {
			imgs[i].src = (new dojo.uri.Uri(dojo.global().location, imgs[i].src)).toString();
		}
		html = tmpContent.innerHTML;
	}
	var firstChild = dojo.html.firstElement(tmpContent);
	var lastChild = dojo.html.lastElement(tmpContent);
	if (firstChild) {
		firstChild.style.marginTop = this._firstChildContributingMargin + "px";
	}
	if (lastChild) {
		lastChild.style.marginBottom = this._lastChildContributingMargin + "px";
	}
	this.editingArea.appendChild(this.iframe);
	if (dojo.render.html.safari) {
		this.iframe.src = this.iframe.src;
	}
	var _iframeInitialized = false;
	var ifrFunc = dojo.lang.hitch(this, function () {
		if (!_iframeInitialized) {
			_iframeInitialized = true;
		} else {
			return;
		}
		if (!this.editNode) {
			if (this.iframe.contentWindow) {
				this.window = this.iframe.contentWindow;
				this.document = this.iframe.contentWindow.document;
			} else {
				if (this.iframe.contentDocument) {
					this.window = this.iframe.contentDocument.window;
					this.document = this.iframe.contentDocument;
				}
			}
			var getStyle = (function (domNode) {
				return function (style) {
					return dojo.html.getStyle(domNode, style);
				};
			})(this.domNode);
			var font = getStyle("font-weight") + " " + getStyle("font-size") + " " + getStyle("font-family");
			var lineHeight = "1.0";
			var lineHeightStyle = dojo.html.getUnitValue(this.domNode, "line-height");
			if (lineHeightStyle.value && lineHeightStyle.units == "") {
				lineHeight = lineHeightStyle.value;
			}
			dojo.html.insertCssText("body,html{background:transparent;padding:0;margin:0;}" + "body{top:0;left:0;right:0;" + (((this.height) || (dojo.render.html.opera)) ? "" : "position:fixed;") + "font:" + font + ";" + "min-height:" + this.minHeight + ";" + "line-height:" + lineHeight + "}" + "p{margin: 1em 0 !important;}" + "body > *:first-child{padding-top:0 !important;margin-top:" + this._firstChildContributingMargin + "px !important;}" + "body > *:last-child{padding-bottom:0 !important;margin-bottom:" + this._lastChildContributingMargin + "px !important;}" + "li > ul:-moz-first-node, li > ol:-moz-first-node{padding-top:1.2em;}\n" + "li{min-height:1.2em;}" + "", this.document);
			dojo.html.removeNode(tmpContent);
			this.document.body.innerHTML = html;
			if (oldMoz || dojo.render.html.safari) {
				this.document.designMode = "on";
			}
			this.onLoad();
		} else {
			dojo.html.removeNode(tmpContent);
			this.editNode.innerHTML = html;
			this.onDisplayChanged();
		}
	});
	if (this.editNode) {
		ifrFunc();
	} else {
		if (dojo.render.html.moz) {
			this.iframe.onload = function () {
				setTimeout(ifrFunc, 250);
			};
		} else {
			this.iframe.onload = ifrFunc;
		}
	}
}, _applyEditingAreaStyleSheets:function () {
	var files = [];
	if (this.styleSheets) {
		files = this.styleSheets.split(";");
		this.styleSheets = "";
	}
	files = files.concat(this.editingAreaStyleSheets);
	this.editingAreaStyleSheets = [];
	if (files.length > 0) {
		for (var i = 0; i < files.length; i++) {
			var url = files[i];
			if (url) {
				this.addStyleSheet(dojo.uri.dojoUri(url));
			}
		}
	}
}, addStyleSheet:function (uri) {
	var url = uri.toString();
	if (dojo.lang.find(this.editingAreaStyleSheets, url) > -1) {
		dojo.debug("dojo.widget.RichText.addStyleSheet: Style sheet " + url + " is already applied to the editing area!");
		return;
	}
	if (url.charAt(0) == "." || (url.charAt(0) != "/" && !uri.host)) {
		url = (new dojo.uri.Uri(dojo.global().location, url)).toString();
	}
	this.editingAreaStyleSheets.push(url);
	if (this.document.createStyleSheet) {
		this.document.createStyleSheet(url);
	} else {
		var head = this.document.getElementsByTagName("head")[0];
		var stylesheet = this.document.createElement("link");
		with (stylesheet) {
			rel = "stylesheet";
			type = "text/css";
			href = url;
		}
		head.appendChild(stylesheet);
	}
}, removeStyleSheet:function (uri) {
	var url = uri.toString();
	if (url.charAt(0) == "." || (url.charAt(0) != "/" && !uri.host)) {
		url = (new dojo.uri.Uri(dojo.global().location, url)).toString();
	}
	var index = dojo.lang.find(this.editingAreaStyleSheets, url);
	if (index == -1) {
		dojo.debug("dojo.widget.RichText.removeStyleSheet: Style sheet " + url + " is not applied to the editing area so it can not be removed!");
		return;
	}
	delete this.editingAreaStyleSheets[index];
	var links = this.document.getElementsByTagName("link");
	for (var i = 0; i < links.length; i++) {
		if (links[i].href == url) {
			if (dojo.render.html.ie) {
				links[i].href = "";
			}
			dojo.html.removeNode(links[i]);
			break;
		}
	}
}, _drawObject:function (html) {
	this.object = dojo.html.createExternalElement(dojo.doc(), "object");
	with (this.object) {
		classid = "clsid:2D360201-FFF5-11D1-8D03-00A0C959BC0A";
		width = this.inheritWidth ? this._oldWidth : "100%";
		style.height = this.height ? this.height : (this._oldHeight + "px");
		Scrollbars = this.height ? true : false;
		Appearance = this._activeX.appearance.flat;
	}
	this.editorObject = this.object;
	this.editingArea.appendChild(this.object);
	this.object.attachEvent("DocumentComplete", dojo.lang.hitch(this, "onLoad"));
	dojo.lang.forEach(this.events, function (e) {
		this.object.attachEvent(e.toLowerCase(), dojo.lang.hitch(this, e));
	}, this);
	this.object.DocumentHTML = "<!doctype HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\" \"http://www.w3.org/TR/html4/strict.dtd\">" + "<html><title></title>" + "<style type=\"text/css\">" + "	body,html { padding: 0; margin: 0; }" + (this.height ? "" : "	body,  { overflow: hidden; }") + "</style>" + "<body><div>" + html + "<div></body></html>";
	this._cacheLocalBlockFormatNames();
}, _local2NativeFormatNames:{}, _native2LocalFormatNames:{}, _cacheLocalBlockFormatNames:function () {
	if (!this._native2LocalFormatNames["p"]) {
		var obj = this.object;
		var error = false;
		if (!obj) {
			try {
				obj = dojo.html.createExternalElement(dojo.doc(), "object");
				obj.classid = "clsid:2D360201-FFF5-11D1-8D03-00A0C959BC0A";
				dojo.body().appendChild(obj);
				obj.DocumentHTML = "<html><head></head><body></body></html>";
			}
			catch (e) {
				error = true;
			}
		}
		try {
			var oNamesParm = new ActiveXObject("DEGetBlockFmtNamesParam.DEGetBlockFmtNamesParam");
			obj.ExecCommand(this._activeX.command["getblockformatnames"], 0, oNamesParm);
			var vbNamesArray = new VBArray(oNamesParm.Names);
			var localFormats = vbNamesArray.toArray();
			var nativeFormats = ["p", "pre", "address", "h1", "h2", "h3", "h4", "h5", "h6", "ol", "ul", "", "", "", "", "div"];
			for (var i = 0; i < nativeFormats.length; ++i) {
				if (nativeFormats[i].length > 0) {
					this._local2NativeFormatNames[localFormats[i]] = nativeFormats[i];
					this._native2LocalFormatNames[nativeFormats[i]] = localFormats[i];
				}
			}
		}
		catch (e) {
			error = true;
		}
		if (obj && !this.object) {
			dojo.body().removeChild(obj);
		}
	}
	return !error;
}, _isResized:function () {
	return false;
}, onLoad:function (e) {
	this.isLoaded = true;
	if (this.object) {
		this.document = this.object.DOM;
		this.window = this.document.parentWindow;
		this.editNode = this.document.body.firstChild;
		this.editingArea.style.height = this.height ? this.height : this.minHeight;
		if (!this.height) {
			this.connect(this, "onDisplayChanged", "_updateHeight");
		}
		this.window._frameElement = this.object;
	} else {
		if (this.iframe && !dojo.render.html.ie) {
			this.editNode = this.document.body;
			if (!this.height) {
				this.connect(this, "onDisplayChanged", "_updateHeight");
			}
			try {
				this.document.execCommand("useCSS", false, true);
				this.document.execCommand("styleWithCSS", false, false);
			}
			catch (e2) {
			}
			if (dojo.render.html.safari) {
				this.connect(this.editNode, "onblur", "onBlur");
				this.connect(this.editNode, "onfocus", "onFocus");
				this.connect(this.editNode, "onclick", "onFocus");
				this.interval = setInterval(dojo.lang.hitch(this, "onDisplayChanged"), 750);
			} else {
				if (dojo.render.html.mozilla || dojo.render.html.opera) {
					var doc = this.document;
					var addListener = dojo.event.browser.addListener;
					var self = this;
					dojo.lang.forEach(this.events, function (e) {
						var l = addListener(self.document, e.substr(2).toLowerCase(), dojo.lang.hitch(self, e));
						if (e == "onBlur") {
							var unBlur = {unBlur:function (e) {
								dojo.event.browser.removeListener(doc, "blur", l);
							}};
							dojo.event.connect("before", self, "close", unBlur, "unBlur");
						}
					});
				}
			}
		} else {
			if (dojo.render.html.ie) {
				if (!this.height) {
					this.connect(this, "onDisplayChanged", "_updateHeight");
				}
				this.editNode.style.zoom = 1;
			}
		}
	}
	this._applyEditingAreaStyleSheets();
	if (this.focusOnLoad) {
		this.focus();
	}
	this.onDisplayChanged(e);
	if (this.onLoadDeferred) {
		this.onLoadDeferred.callback(true);
	}
}, onKeyDown:function (e) {
	if ((!e) && (this.object)) {
		e = dojo.event.browser.fixEvent(this.window.event);
	}
	if ((dojo.render.html.ie) && (e.keyCode == e.KEY_TAB)) {
		e.preventDefault();
		e.stopPropagation();
		this.execCommand((e.shiftKey ? "outdent" : "indent"));
	} else {
		if (dojo.render.html.ie) {
			if ((65 <= e.keyCode) && (e.keyCode <= 90)) {
				e.charCode = e.keyCode;
				this.onKeyPress(e);
			}
		}
	}
}, onKeyUp:function (e) {
	return;
}, KEY_CTRL:1, onKeyPress:function (e) {
	if ((!e) && (this.object)) {
		e = dojo.event.browser.fixEvent(this.window.event);
	}
	var modifiers = e.ctrlKey ? this.KEY_CTRL : 0;
	if (this._keyHandlers[e.key]) {
		var handlers = this._keyHandlers[e.key], i = 0, handler;
		while (handler = handlers[i++]) {
			if (modifiers == handler.modifiers) {
				e.preventDefault();
				handler.handler.call(this);
				break;
			}
		}
	}
	dojo.lang.setTimeout(this, this.onKeyPressed, 1, e);
}, addKeyHandler:function (key, modifiers, handler) {
	if (!(this._keyHandlers[key] instanceof Array)) {
		this._keyHandlers[key] = [];
	}
	this._keyHandlers[key].push({modifiers:modifiers || 0, handler:handler});
}, onKeyPressed:function (e) {
	this.onDisplayChanged();
}, onClick:function (e) {
	this.onDisplayChanged(e);
}, onBlur:function (e) {
}, _initialFocus:true, onFocus:function (e) {
	if ((dojo.render.html.mozilla) && (this._initialFocus)) {
		this._initialFocus = false;
		if (dojo.string.trim(this.editNode.innerHTML) == "&nbsp;") {
			this.placeCursorAtStart();
		}
	}
}, blur:function () {
	if (this.iframe) {
		this.window.blur();
	} else {
		if (this.object) {
			this.document.body.blur();
		} else {
			if (this.editNode) {
				this.editNode.blur();
			}
		}
	}
}, focus:function () {
	if (this.iframe && !dojo.render.html.ie) {
		this.window.focus();
	} else {
		if (this.object) {
			this.document.focus();
		} else {
			if (this.editNode && this.editNode.focus) {
				this.editNode.focus();
			} else {
				dojo.debug("Have no idea how to focus into the editor!");
			}
		}
	}
}, onDisplayChanged:function (e) {
}, _activeX:{command:{bold:5000, italic:5023, underline:5048, justifycenter:5024, justifyleft:5025, justifyright:5026, cut:5003, copy:5002, paste:5032, "delete":5004, undo:5049, redo:5033, removeformat:5034, selectall:5035, unlink:5050, indent:5018, outdent:5031, insertorderedlist:5030, insertunorderedlist:5051, inserttable:5022, insertcell:5019, insertcol:5020, insertrow:5021, deletecells:5005, deletecols:5006, deleterows:5007, mergecells:5029, splitcell:5047, setblockformat:5043, getblockformat:5011, getblockformatnames:5012, setfontname:5044, getfontname:5013, setfontsize:5045, getfontsize:5014, setbackcolor:5042, getbackcolor:5010, setforecolor:5046, getforecolor:5015, findtext:5008, font:5009, hyperlink:5016, image:5017, lockelement:5027, makeabsolute:5028, sendbackward:5036, bringforward:5037, sendbelowtext:5038, bringabovetext:5039, sendtoback:5040, bringtofront:5041, properties:5052}, ui:{"default":0, prompt:1, noprompt:2}, status:{notsupported:0, disabled:1, enabled:3, latched:7, ninched:11}, appearance:{flat:0, inset:1}, state:{unchecked:0, checked:1, gray:2}}, _normalizeCommand:function (cmd) {
	var drh = dojo.render.html;
	var command = cmd.toLowerCase();
	if (command == "formatblock") {
		if (drh.safari) {
			command = "heading";
		}
	} else {
		if (this.object) {
			switch (command) {
			  case "createlink":
				command = "hyperlink";
				break;
			  case "insertimage":
				command = "image";
				break;
			}
		} else {
			if (command == "hilitecolor" && !drh.mozilla) {
				command = "backcolor";
			}
		}
	}
	return command;
}, _safariIsLeopard:function () {
	var gt420 = false;
	if (dojo.render.html.safari) {
		var tmp = dojo.render.html.UA.split("AppleWebKit/")[1];
		var ver = parseFloat(tmp.split(" ")[0]);
		if (ver >= 420) {
			gt420 = true;
		}
	}
	return gt420;
}, queryCommandAvailable:function (command) {
	var ie = 1;
	var mozilla = 1 << 1;
	var safari = 1 << 2;
	var opera = 1 << 3;
	var safari420 = 1 << 4;
	var gt420 = this._safariIsLeopard();
	function isSupportedBy(browsers) {
		return {ie:Boolean(browsers & ie), mozilla:Boolean(browsers & mozilla), safari:Boolean(browsers & safari), safari420:Boolean(browsers & safari420), opera:Boolean(browsers & opera)};
	}
	var supportedBy = null;
	switch (command.toLowerCase()) {
	  case "bold":
	  case "italic":
	  case "underline":
	  case "subscript":
	  case "superscript":
	  case "fontname":
	  case "fontsize":
	  case "forecolor":
	  case "hilitecolor":
	  case "justifycenter":
	  case "justifyfull":
	  case "justifyleft":
	  case "justifyright":
	  case "delete":
	  case "selectall":
		supportedBy = isSupportedBy(mozilla | ie | safari | opera);
		break;
	  case "createlink":
	  case "unlink":
	  case "removeformat":
	  case "inserthorizontalrule":
	  case "insertimage":
	  case "insertorderedlist":
	  case "insertunorderedlist":
	  case "indent":
	  case "outdent":
	  case "formatblock":
	  case "inserthtml":
	  case "undo":
	  case "redo":
	  case "strikethrough":
		supportedBy = isSupportedBy(mozilla | ie | opera | safari420);
		break;
	  case "blockdirltr":
	  case "blockdirrtl":
	  case "dirltr":
	  case "dirrtl":
	  case "inlinedirltr":
	  case "inlinedirrtl":
		supportedBy = isSupportedBy(ie);
		break;
	  case "cut":
	  case "copy":
	  case "paste":
		supportedBy = isSupportedBy(ie | mozilla | safari420);
		break;
	  case "inserttable":
		supportedBy = isSupportedBy(mozilla | (this.object ? ie : 0));
		break;
	  case "insertcell":
	  case "insertcol":
	  case "insertrow":
	  case "deletecells":
	  case "deletecols":
	  case "deleterows":
	  case "mergecells":
	  case "splitcell":
		supportedBy = isSupportedBy(this.object ? ie : 0);
		break;
	  default:
		return false;
	}
	return (dojo.render.html.ie && supportedBy.ie) || (dojo.render.html.mozilla && supportedBy.mozilla) || (dojo.render.html.safari && supportedBy.safari) || (gt420 && supportedBy.safari420) || (dojo.render.html.opera && supportedBy.opera);
}, execCommand:function (command, argument) {
	var returnValue;
	this.focus();
	command = this._normalizeCommand(command);
	if (argument != undefined) {
		if (command == "heading") {
			throw new Error("unimplemented");
		} else {
			if (command == "formatblock") {
				if (this.object) {
					argument = this._native2LocalFormatNames[argument];
				} else {
					if (dojo.render.html.ie) {
						argument = "<" + argument + ">";
					}
				}
			}
		}
	}
	if (this.object) {
		switch (command) {
		  case "hilitecolor":
			command = "setbackcolor";
			break;
		  case "forecolor":
		  case "backcolor":
		  case "fontsize":
		  case "fontname":
			command = "set" + command;
			break;
		  case "formatblock":
			command = "setblockformat";
		}
		if (command == "strikethrough") {
			command = "inserthtml";
			var range = this.document.selection.createRange();
			if (!range.htmlText) {
				return;
			}
			argument = range.htmlText.strike();
		} else {
			if (command == "inserthorizontalrule") {
				command = "inserthtml";
				argument = "<hr>";
			}
		}
		if (command == "inserthtml") {
			var range = this.document.selection.createRange();
			if (this.document.selection.type.toUpperCase() == "CONTROL") {
				for (var i = 0; i < range.length; i++) {
					range.item(i).outerHTML = argument;
				}
			} else {
				range.pasteHTML(argument);
				range.select();
			}
			returnValue = true;
		} else {
			if (arguments.length == 1) {
				returnValue = this.object.ExecCommand(this._activeX.command[command], this._activeX.ui.noprompt);
			} else {
				returnValue = this.object.ExecCommand(this._activeX.command[command], this._activeX.ui.noprompt, argument);
			}
		}
	} else {
		if (command == "inserthtml") {
			if (dojo.render.html.ie) {
				var insertRange = this.document.selection.createRange();
				insertRange.pasteHTML(argument);
				insertRange.select();
				return true;
			} else {
				return this.document.execCommand(command, false, argument);
			}
		} else {
			if ((command == "unlink") && (this.queryCommandEnabled("unlink")) && (dojo.render.html.mozilla)) {
				var selection = this.window.getSelection();
				var selectionRange = selection.getRangeAt(0);
				var selectionStartContainer = selectionRange.startContainer;
				var selectionStartOffset = selectionRange.startOffset;
				var selectionEndContainer = selectionRange.endContainer;
				var selectionEndOffset = selectionRange.endOffset;
				var a = dojo.withGlobal(this.window, "getAncestorElement", dojo.html.selection, ["a"]);
				dojo.withGlobal(this.window, "selectElement", dojo.html.selection, [a]);
				returnValue = this.document.execCommand("unlink", false, null);
				var selectionRange = this.document.createRange();
				selectionRange.setStart(selectionStartContainer, selectionStartOffset);
				selectionRange.setEnd(selectionEndContainer, selectionEndOffset);
				selection.removeAllRanges();
				selection.addRange(selectionRange);
				return returnValue;
			} else {
				if ((command == "hilitecolor") && (dojo.render.html.mozilla)) {
					this.document.execCommand("useCSS", false, false);
					returnValue = this.document.execCommand(command, false, argument);
					this.document.execCommand("useCSS", false, true);
				} else {
					if ((dojo.render.html.ie) && ((command == "backcolor") || (command == "forecolor"))) {
						argument = arguments.length > 1 ? argument : null;
						returnValue = this.document.execCommand(command, false, argument);
					} else {
						argument = arguments.length > 1 ? argument : null;
						if (argument || command != "createlink") {
							returnValue = this.document.execCommand(command, false, argument);
						}
					}
				}
			}
		}
	}
	this.onDisplayChanged();
	return returnValue;
}, queryCommandEnabled:function (command) {
	command = this._normalizeCommand(command);
	if (this.object) {
		switch (command) {
		  case "hilitecolor":
			command = "setbackcolor";
			break;
		  case "forecolor":
		  case "backcolor":
		  case "fontsize":
		  case "fontname":
			command = "set" + command;
			break;
		  case "formatblock":
			command = "setblockformat";
			break;
		  case "strikethrough":
			command = "bold";
			break;
		  case "inserthorizontalrule":
			return true;
		}
		if (typeof this._activeX.command[command] == "undefined") {
			return false;
		}
		var status = this.object.QueryStatus(this._activeX.command[command]);
		return ((status != this._activeX.status.notsupported) && (status != this._activeX.status.disabled));
	} else {
		if (dojo.render.html.mozilla) {
			if (command == "unlink") {
				return dojo.withGlobal(this.window, "hasAncestorElement", dojo.html.selection, ["a"]);
			} else {
				if (command == "inserttable") {
					return true;
				}
			}
		}
		var elem = (dojo.render.html.ie) ? this.document.selection.createRange() : this.document;
		return elem.queryCommandEnabled(command);
	}
}, queryCommandState:function (command) {
	command = this._normalizeCommand(command);
	if (this.object) {
		if (command == "forecolor") {
			command = "setforecolor";
		} else {
			if (command == "backcolor") {
				command = "setbackcolor";
			} else {
				if (command == "strikethrough") {
					return dojo.withGlobal(this.window, "hasAncestorElement", dojo.html.selection, ["strike"]);
				} else {
					if (command == "inserthorizontalrule") {
						return false;
					}
				}
			}
		}
		if (typeof this._activeX.command[command] == "undefined") {
			return null;
		}
		var status = this.object.QueryStatus(this._activeX.command[command]);
		return ((status == this._activeX.status.latched) || (status == this._activeX.status.ninched));
	} else {
		return this.document.queryCommandState(command);
	}
}, queryCommandValue:function (command) {
	command = this._normalizeCommand(command);
	if (this.object) {
		switch (command) {
		  case "forecolor":
		  case "backcolor":
		  case "fontsize":
		  case "fontname":
			command = "get" + command;
			return this.object.execCommand(this._activeX.command[command], this._activeX.ui.noprompt);
		  case "formatblock":
			var retvalue = this.object.execCommand(this._activeX.command["getblockformat"], this._activeX.ui.noprompt);
			if (retvalue) {
				return this._local2NativeFormatNames[retvalue];
			}
		}
	} else {
		if (dojo.render.html.ie && command == "formatblock") {
			return this._local2NativeFormatNames[this.document.queryCommandValue(command)] || this.document.queryCommandValue(command);
		}
		return this.document.queryCommandValue(command);
	}
}, placeCursorAtStart:function () {
	this.focus();
	if (dojo.render.html.moz && this.editNode.firstChild && this.editNode.firstChild.nodeType != dojo.dom.TEXT_NODE) {
		dojo.withGlobal(this.window, "selectElementChildren", dojo.html.selection, [this.editNode.firstChild]);
	} else {
		dojo.withGlobal(this.window, "selectElementChildren", dojo.html.selection, [this.editNode]);
	}
	dojo.withGlobal(this.window, "collapse", dojo.html.selection, [true]);
}, placeCursorAtEnd:function () {
	this.focus();
	if (dojo.render.html.moz && this.editNode.lastChild && this.editNode.lastChild.nodeType != dojo.dom.TEXT_NODE) {
		dojo.withGlobal(this.window, "selectElementChildren", dojo.html.selection, [this.editNode.lastChild]);
	} else {
		dojo.withGlobal(this.window, "selectElementChildren", dojo.html.selection, [this.editNode]);
	}
	dojo.withGlobal(this.window, "collapse", dojo.html.selection, [false]);
}, replaceEditorContent:function (html) {
	html = this._preFilterContent(html);
	if (this.isClosed) {
		this.domNode.innerHTML = html;
	} else {
		if (this.window && this.window.getSelection && !dojo.render.html.moz) {
			this.editNode.innerHTML = html;
		} else {
			if ((this.window && this.window.getSelection) || (this.document && this.document.selection)) {
				this.execCommand("selectall");
				if (dojo.render.html.moz && !html) {
					html = "&nbsp;";
				}
				this.execCommand("inserthtml", html);
			}
		}
	}
}, _preFilterContent:function (html) {
	var ec = html;
	dojo.lang.forEach(this.contentPreFilters, function (ef) {
		ec = ef(ec);
	});
	if (this.contentDomPreFilters.length > 0) {
		var dom = dojo.doc().createElement("div");
		dom.style.display = "none";
		dojo.body().appendChild(dom);
		dom.innerHTML = ec;
		dojo.lang.forEach(this.contentDomPreFilters, function (ef) {
			dom = ef(dom);
		});
		ec = dom.innerHTML;
		dojo.body().removeChild(dom);
	}
	return ec;
}, _postFilterContent:function (html) {
	var ec = html;
	if (this.contentDomPostFilters.length > 0) {
		var dom = this.document.createElement("div");
		dom.innerHTML = ec;
		dojo.lang.forEach(this.contentDomPostFilters, function (ef) {
			dom = ef(dom);
		});
		ec = dom.innerHTML;
	}
	dojo.lang.forEach(this.contentPostFilters, function (ef) {
		ec = ef(ec);
	});
	return ec;
}, _lastHeight:0, _updateHeight:function () {
	if (!this.isLoaded) {
		return;
	}
	if (this.height) {
		return;
	}
	var height = dojo.html.getBorderBox(this.editNode).height;
	if (!height) {
		height = dojo.html.getBorderBox(this.document.body).height;
	}
	if (height == 0) {
		dojo.debug("Can not figure out the height of the editing area!");
		return;
	}
	this._lastHeight = height;
	this.editorObject.style.height = this._lastHeight + "px";
	this.window.scrollTo(0, 0);
}, _saveContent:function (e) {
	var saveTextarea = dojo.doc().getElementById("dojo.widget.RichText.savedContent");
	saveTextarea.value += this._SEPARATOR + this.saveName + ":" + this.getEditorContent();
}, getEditorContent:function () {
	var ec = "";
	try {
		ec = (this._content.length > 0) ? this._content : this.editNode.innerHTML;
		if (dojo.string.trim(ec) == "&nbsp;") {
			ec = "";
		}
	}
	catch (e) {
	}
	if (dojo.render.html.ie && !this.object) {
		var re = new RegExp("(?:<p>&nbsp;</p>[\n\r]*)+$", "i");
		ec = ec.replace(re, "");
	}
	ec = this._postFilterContent(ec);
	if (this.relativeImageUrls) {
		var siteBase = dojo.global().location.protocol + "//" + dojo.global().location.host;
		var pathBase = dojo.global().location.pathname;
		if (pathBase.match(/\/$/)) {
		} else {
			var pathParts = pathBase.split("/");
			if (pathParts.length) {
				pathParts.pop();
			}
			pathBase = pathParts.join("/") + "/";
		}
		var sameSite = new RegExp("(<img[^>]* src=[\"'])(" + siteBase + "(" + pathBase + ")?)", "ig");
		ec = ec.replace(sameSite, "$1");
	}
	return ec;
}, close:function (save, force) {
	if (this.isClosed) {
		return false;
	}
	if (arguments.length == 0) {
		save = true;
	}
	this._content = this._postFilterContent(this.editNode.innerHTML);
	var changed = (this.savedContent != this._content);
	if (this.interval) {
		clearInterval(this.interval);
	}
	if (dojo.render.html.ie && !this.object) {
		dojo.event.browser.clean(this.editNode);
	}
	if (this.iframe) {
		delete this.iframe;
	}
	if (this.textarea) {
		with (this.textarea.style) {
			position = "";
			left = top = "";
			if (dojo.render.html.ie) {
				overflow = this.__overflow;
				this.__overflow = null;
			}
		}
		if (save) {
			this.textarea.value = this._content;
		} else {
			this.textarea.value = this.savedContent;
		}
		dojo.html.removeNode(this.domNode);
		this.domNode = this.textarea;
	} else {
		if (save) {
			if (dojo.render.html.moz) {
				var nc = dojo.doc().createElement("span");
				this.domNode.appendChild(nc);
				nc.innerHTML = this.editNode.innerHTML;
			} else {
				this.domNode.innerHTML = this._content;
			}
		} else {
			this.domNode.innerHTML = this.savedContent;
		}
	}
	dojo.html.removeClass(this.domNode, "RichTextEditable");
	this.isClosed = true;
	this.isLoaded = false;
	delete this.editNode;
	if (this.window._frameElement) {
		this.window._frameElement = null;
	}
	this.window = null;
	this.document = null;
	this.object = null;
	this.editingArea = null;
	this.editorObject = null;
	return changed;
}, destroyRendering:function () {
}, destroy:function () {
	this.destroyRendering();
	if (!this.isClosed) {
		this.close(false);
	}
	dojo.widget.RichText.superclass.destroy.call(this);
}, connect:function (targetObj, targetFunc, thisFunc) {
	dojo.event.connect(targetObj, targetFunc, this, thisFunc);
}, disconnect:function (targetObj, targetFunc, thisFunc) {
	dojo.event.disconnect(targetObj, targetFunc, this, thisFunc);
}, disconnectAllWithRoot:function (targetObj) {
	dojo.deprecated("disconnectAllWithRoot", "is deprecated. No need to disconnect manually", "0.5");
}, _fixContentForMoz:function (html) {
	html = html.replace(/<strong([ \>])/gi, "<b$1");
	html = html.replace(/<\/strong>/gi, "</b>");
	html = html.replace(/<em([ \>])/gi, "<i$1");
	html = html.replace(/<\/em>/gi, "</i>");
	return html;
}});


__CPAN_FILE__ src/widget/TreeContextMenu.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.widget.TreeContextMenu");
dojo.require("dojo.event.*");
dojo.require("dojo.io.*");
dojo.require("dojo.widget.Menu2");
dojo.widget.defineWidget("dojo.widget.TreeContextMenu", dojo.widget.PopupMenu2, function () {
	this.listenedTrees = [];
}, {open:function (x, y, parentMenu, explodeSrc) {
	var result = dojo.widget.PopupMenu2.prototype.open.apply(this, arguments);
	dojo.event.topic.publish(this.eventNames.open, {menu:this});
	return result;
}, listenTree:function (tree) {
	var nodes = tree.getDescendants();
	for (var i = 0; i < nodes.length; i++) {
		if (!nodes[i].isTreeNode) {
			continue;
		}
		this.bindDomNode(nodes[i].labelNode);
	}
	var _this = this;
	dojo.event.topic.subscribe(tree.eventNames.createDOMNode, this, "onCreateDOMNode");
	dojo.event.topic.subscribe(tree.eventNames.moveFrom, this, "onMoveFrom");
	dojo.event.topic.subscribe(tree.eventNames.moveTo, this, "onMoveTo");
	dojo.event.topic.subscribe(tree.eventNames.removeNode, this, "onRemoveNode");
	dojo.event.topic.subscribe(tree.eventNames.addChild, this, "onAddChild");
	dojo.event.topic.subscribe(tree.eventNames.treeDestroy, this, "onTreeDestroy");
	this.listenedTrees.push(tree);
}, unlistenTree:function (tree) {
	dojo.event.topic.unsubscribe(tree.eventNames.createDOMNode, this, "onCreateDOMNode");
	dojo.event.topic.unsubscribe(tree.eventNames.moveFrom, this, "onMoveFrom");
	dojo.event.topic.unsubscribe(tree.eventNames.moveTo, this, "onMoveTo");
	dojo.event.topic.unsubscribe(tree.eventNames.removeNode, this, "onRemoveNode");
	dojo.event.topic.unsubscribe(tree.eventNames.addChild, this, "onAddChild");
	dojo.event.topic.unsubscribe(tree.eventNames.treeDestroy, this, "onTreeDestroy");
	for (var i = 0; i < this.listenedTrees.length; i++) {
		if (this.listenedTrees[i] === tree) {
			this.listenedTrees.splice(i, 1);
			break;
		}
	}
}, onTreeDestroy:function (message) {
	this.unlistenTree(message.source);
}, bindTreeNode:function (node) {
	var _this = this;
	dojo.lang.forEach(node.getDescendants(), function (e) {
		_this.bindDomNode(e.labelNode);
	});
}, unBindTreeNode:function (node) {
	var _this = this;
	dojo.lang.forEach(node.getDescendants(), function (e) {
		_this.unBindDomNode(e.labelNode);
	});
}, onCreateDOMNode:function (message) {
	this.bindTreeNode(message.source);
}, onMoveFrom:function (message) {
	if (!dojo.lang.inArray(this.listenedTrees, message.newTree)) {
		this.unBindTreeNode(message.child);
	}
}, onMoveTo:function (message) {
	if (dojo.lang.inArray(this.listenedTrees, message.newTree)) {
		this.bindTreeNode(message.child);
	}
}, onRemoveNode:function (message) {
	this.unBindTreeNode(message.child);
}, onAddChild:function (message) {
	if (message.domNodeInitialized) {
		this.bindTreeNode(message.child);
	}
}});
dojo.widget.defineWidget("dojo.widget.TreeMenuItem", dojo.widget.MenuItem2, {treeActions:"", initialize:function (args, frag) {
	this.treeActions = this.treeActions.split(",");
	for (var i = 0; i < this.treeActions.length; i++) {
		this.treeActions[i] = this.treeActions[i].toUpperCase();
	}
}, getTreeNode:function () {
	var menu = this;
	while (!(menu instanceof dojo.widget.TreeContextMenu)) {
		menu = menu.parent;
	}
	var source = menu.getTopOpenEvent().target;
	while (!source.getAttribute("treeNode") && source.tagName != "body") {
		source = source.parentNode;
	}
	if (source.tagName == "body") {
		dojo.raise("treeNode not detected");
	}
	var treeNode = dojo.widget.manager.getWidgetById(source.getAttribute("treeNode"));
	return treeNode;
}, menuOpen:function (message) {
	var treeNode = this.getTreeNode();
	this.setDisabled(false);
	var _this = this;
	dojo.lang.forEach(_this.treeActions, function (action) {
		_this.setDisabled(treeNode.actionIsDisabled(action));
	});
}, toString:function () {
	return "[" + this.widgetType + " node " + this.getTreeNode() + "]";
}});


__CPAN_FILE__ src/widget/Rounded.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.widget.Rounded");
dojo.widget.tags.addParseTreeHandler("dojo:rounded");
dojo.require("dojo.widget.*");
dojo.require("dojo.widget.ContentPane");
dojo.require("dojo.html.style");
dojo.require("dojo.html.display");
dojo.require("dojo.gfx.color");
dojo.deprecated("dojo.widget.Rounded will be removed in version 0.5; you can now apply rounded corners to any block element using dojo.lfx.rounded.", "0.5");
dojo.widget.defineWidget("dojo.widget.Rounded", dojo.widget.ContentPane, {isSafari:dojo.render.html.safari, boxMargin:"50px", radius:14, domNode:"", corners:"TR,TL,BR,BL", antiAlias:true, fillInTemplate:function (args, frag) {
	dojo.widget.Rounded.superclass.fillInTemplate.call(this, args, frag);
	dojo.html.insertCssFile(this.templateCssPath);
	if (this.domNode.style.height <= 0) {
		var minHeight = (this.radius * 1) + this.domNode.clientHeight;
		this.domNode.style.height = minHeight + "px";
	}
	if (this.domNode.style.width <= 0) {
		var minWidth = (this.radius * 1) + this.domNode.clientWidth;
		this.domNode.style.width = minWidth + "px";
	}
	var cornersAvailable = ["TR", "TL", "BR", "BL"];
	var cornersPassed = this.corners.split(",");
	this.settings = {antiAlias:this.antiAlias};
	var setCorner = function (currentCorner) {
		var val = currentCorner.toLowerCase();
		if (dojo.lang.inArray(cornersPassed, currentCorner)) {
			this.settings[val] = {radius:this.radius, enabled:true};
		} else {
			this.settings[val] = {radius:0};
		}
	};
	dojo.lang.forEach(cornersAvailable, setCorner, this);
	this.domNode.style.margin = this.boxMargin;
	this.curvyCorners(this.settings);
	this.applyCorners();
}, curvyCorners:function (settings) {
	this.box = this.domNode;
	this.topContainer = null;
	this.bottomContainer = null;
	this.masterCorners = [];
	var boxHeight = dojo.html.getStyle(this.box, "height");
	if (boxHeight == "") {
		boxHeight = "0px";
	}
	var boxWidth = dojo.html.getStyle(this.box, "width");
	var borderWidth = dojo.html.getStyle(this.box, "borderTopWidth");
	if (borderWidth == "") {
		borderWidth = "0px";
	}
	var borderColour = dojo.html.getStyle(this.box, "borderTopColor");
	if (borderWidth > 0) {
		this.antiAlias = true;
	}
	var boxColour = dojo.html.getStyle(this.box, "backgroundColor");
	var backgroundImage = dojo.html.getStyle(this.box, "backgroundImage");
	var boxPosition = dojo.html.getStyle(this.box, "position");
	this.boxHeight = parseInt(((boxHeight != "" && boxHeight != "auto" && boxHeight.indexOf("%") == -1) ? boxHeight.substring(0, boxHeight.indexOf("px")) : this.box.scrollHeight));
	this.boxWidth = parseInt(((boxWidth != "" && boxWidth != "auto" && boxWidth.indexOf("%") == -1) ? boxWidth.substring(0, boxWidth.indexOf("px")) : this.box.scrollWidth));
	this.borderWidth = parseInt(((borderWidth != "" && borderWidth.indexOf("px") !== -1) ? borderWidth.slice(0, borderWidth.indexOf("px")) : 0));
	var test = new dojo.gfx.color.Color(boxColour);
	this.boxColour = ((boxColour != "" && boxColour != "transparent") ? ((boxColour.substr(0, 3) == "rgb") ? this.rgb2Hex(boxColour) : boxColour) : "#ffffff");
	this.borderColour = ((borderColour != "" && borderColour != "transparent" && this.borderWidth > 0) ? ((borderColour.substr(0, 3) == "rgb") ? this.rgb2Hex(borderColour) : borderColour) : this.boxColour);
	this.borderString = this.borderWidth + "px" + " solid " + this.borderColour;
	this.backgroundImage = ((backgroundImage != "none") ? backgroundImage : "");
	if (boxPosition != "absolute") {
		this.box.style.position = "relative";
	}
	this.applyCorners = function () {
		for (var t = 0; t < 2; t++) {
			switch (t) {
			  case 0:
				if (this.settings.tl.enabled || this.settings.tr.enabled) {
					var newMainContainer = document.createElement("DIV");
					with (newMainContainer.style) {
						width = "100%";
						fontSize = "1px";
						overflow = "hidden";
						position = "absolute";
						paddingLeft = this.borderWidth + "px";
						paddingRight = this.borderWidth + "px";
						var topMaxRadius = Math.max(this.settings.tl ? this.settings.tl.radius : 0, this.settings.tr ? this.settings.tr.radius : 0);
						height = topMaxRadius + "px";
						top = 0 - topMaxRadius + "px";
						left = 0 - this.borderWidth + "px";
					}
					this.topContainer = this.box.appendChild(newMainContainer);
				}
				break;
			  case 1:
				if (this.settings.bl.enabled || this.settings.br.enabled) {
					var newMainContainer = document.createElement("DIV");
					with (newMainContainer.style) {
						width = "100%";
						fontSize = "1px";
						overflow = "hidden";
						position = "absolute";
						paddingLeft = this.borderWidth + "px";
						paddingRight = this.borderWidth + "px";
						var botMaxRadius = Math.max(this.settings.bl ? this.settings.bl.radius : 0, this.settings.br ? this.settings.br.radius : 0);
						height = botMaxRadius + "px";
						bottom = 0 - botMaxRadius + "px";
						left = 0 - this.borderWidth + "px";
					}
					this.bottomContainer = this.box.appendChild(newMainContainer);
				}
				break;
			}
		}
		if (this.topContainer) {
			this.box.style.borderTopWidth = "0px";
		}
		if (this.bottomContainer) {
			this.box.style.borderBottomWidth = "0px";
		}
		var corners = ["tr", "tl", "br", "bl"];
		for (var i in corners) {
			var cc = corners[i];
			if (!this.settings[cc]) {
				if (((cc == "tr" || cc == "tl") && this.topContainer != null) || ((cc == "br" || cc == "bl") && this.bottomContainer != null)) {
					var newCorner = document.createElement("DIV");
					newCorner.style.position = "relative";
					newCorner.style.fontSize = "1px";
					newCorner.style.overflow = "hidden";
					if (this.backgroundImage == "") {
						newCorner.style.backgroundColor = this.boxColour;
					} else {
						newCorner.style.backgroundImage = this.backgroundImage;
					}
					switch (cc) {
					  case "tl":
						with (newCorner.style) {
							height = topMaxRadius - this.borderWidth + "px";
							marginRight = this.settings.tr.radius - (this.borderWidth * 2) + "px";
							borderLeft = this.borderString;
							borderTop = this.borderString;
							left = -this.borderWidth + "px";
						}
						break;
					  case "tr":
						with (newCorner.style) {
							height = topMaxRadius - this.borderWidth + "px";
							marginLeft = this.settings.tl.radius - (this.borderWidth * 2) + "px";
							borderRight = this.borderString;
							borderTop = this.borderString;
							backgroundPosition = "-" + this.boxWidth + "px 0px";
							left = this.borderWidth + "px";
						}
						break;
					  case "bl":
						with (newCorner.style) {
							height = botMaxRadius - this.borderWidth + "px";
							marginRight = this.settings.br.radius - (this.borderWidth * 2) + "px";
							borderLeft = this.borderString;
							borderBottom = this.borderString;
							left = -this.borderWidth + "px";
						}
						break;
					  case "br":
						with (newCorner.style) {
							height = botMaxRadius - this.borderWidth + "px";
							marginLeft = this.settings.bl.radius - (this.borderWidth * 2) + "px";
							borderRight = this.borderString;
							borderBottom = this.borderString;
							left = this.borderWidth + "px";
						}
						break;
					}
				}
			} else {
				if (this.masterCorners[this.settings[cc].radius]) {
					var newCorner = this.masterCorners[this.settings[cc].radius].cloneNode(true);
				} else {
					var newCorner = document.createElement("DIV");
					with (newCorner.style) {
						height = this.settings[cc].radius + "px";
						width = this.settings[cc].radius + "px";
						position = "absolute";
						fontSize = "1px";
						overflow = "hidden";
					}
					var borderRadius = parseInt(this.settings[cc].radius - this.borderWidth);
					for (var intx = 0, j = this.settings[cc].radius; intx < j; intx++) {
						if ((intx + 1) >= borderRadius) {
							var y1 = -1;
						} else {
							var y1 = (Math.floor(Math.sqrt(Math.pow(borderRadius, 2) - Math.pow((intx + 1), 2))) - 1);
						}
						if (borderRadius != j) {
							if ((intx) >= borderRadius) {
								var y2 = -1;
							} else {
								var y2 = Math.ceil(Math.sqrt(Math.pow(borderRadius, 2) - Math.pow(intx, 2)));
							}
							if ((intx + 1) >= j) {
								var y3 = -1;
							} else {
								var y3 = (Math.floor(Math.sqrt(Math.pow(j, 2) - Math.pow((intx + 1), 2))) - 1);
							}
						}
						if ((intx) >= j) {
							var y4 = -1;
						} else {
							var y4 = Math.ceil(Math.sqrt(Math.pow(j, 2) - Math.pow(intx, 2)));
						}
						if (y1 > -1) {
							this.drawPixel(intx, 0, this.boxColour, 100, (y1 + 1), newCorner, -1, this.settings[cc].radius);
						}
						if (borderRadius != j) {
							if (this.antiAlias) {
								for (var inty = (y1 + 1); inty < y2; inty++) {
									if (this.backgroundImage != "") {
										var borderFract = (this.pixelFraction(intx, inty, borderRadius) * 100);
										if (borderFract < 30) {
											this.drawPixel(intx, inty, this.borderColour, 100, 1, newCorner, 0, this.settings[cc].radius);
										} else {
											this.drawPixel(intx, inty, this.borderColour, 100, 1, newCorner, -1, this.settings[cc].radius);
										}
									} else {
										var pixelcolour = dojo.gfx.color.blend(this.boxColour, this.borderColour, this.pixelFraction(intx, inty, borderRadius));
										this.drawPixel(intx, inty, pixelcolour, 100, 1, newCorner, 0, this.settings[cc].radius);
									}
								}
							}
							if (y3 >= y2) {
								if (y1 == -1) {
									y1 = 0;
								}
								this.drawPixel(intx, y2, this.borderColour, 100, (y3 - y2 + 1), newCorner, 0, this.settings[cc].radius);
							}
							var outsideColour = this.borderColour;
						} else {
							var outsideColour = this.boxColour;
							var y3 = y1;
						}
						if (this.antiAlias) {
							for (var inty = (y3 + 1); inty < y4; inty++) {
								this.drawPixel(intx, inty, outsideColour, (this.pixelFraction(intx, inty, j) * 100), 1, newCorner, ((this.borderWidth > 0) ? 0 : -1), this.settings[cc].radius);
							}
						}
					}
					this.masterCorners[this.settings[cc].radius] = newCorner.cloneNode(true);
				}
				if (cc != "br") {
					for (var t = 0, k = newCorner.childNodes.length; t < k; t++) {
						var pixelBar = newCorner.childNodes[t];
						var pixelBarTop = parseInt(pixelBar.style.top.substring(0, pixelBar.style.top.indexOf("px")));
						var pixelBarLeft = parseInt(pixelBar.style.left.substring(0, pixelBar.style.left.indexOf("px")));
						var pixelBarHeight = parseInt(pixelBar.style.height.substring(0, pixelBar.style.height.indexOf("px")));
						if (cc == "tl" || cc == "bl") {
							pixelBar.style.left = this.settings[cc].radius - pixelBarLeft - 1 + "px";
						}
						if (cc == "tr" || cc == "tl") {
							pixelBar.style.top = this.settings[cc].radius - pixelBarHeight - pixelBarTop + "px";
						}
						var value;
						switch (cc) {
						  case "tr":
							value = (-1 * (Math.abs((this.boxWidth - this.settings[cc].radius + this.borderWidth) + pixelBarLeft) - (Math.abs(this.settings[cc].radius - pixelBarHeight - pixelBarTop - this.borderWidth))));
							pixelBar.style.backgroundPosition = value + "px";
							break;
						  case "tl":
							value = (-1 * (Math.abs((this.settings[cc].radius - pixelBarLeft - 1) - this.borderWidth) - (Math.abs(this.settings[cc].radius - pixelBarHeight - pixelBarTop - this.borderWidth))));
							pixelBar.style.backgroundPosition = value + "px";
							break;
						  case "bl":
							value = (-1 * (Math.abs((this.settings[cc].radius - pixelBarLeft - 1) - this.borderWidth) - (Math.abs((this.boxHeight + this.settings[cc].radius + pixelBarTop) - this.borderWidth))));
							pixelBar.style.backgroundPosition = value + "px";
							break;
						}
					}
				}
			}
			if (newCorner) {
				switch (cc) {
				  case "tl":
					if (newCorner.style.position == "absolute") {
						newCorner.style.top = "0px";
					}
					if (newCorner.style.position == "absolute") {
						newCorner.style.left = "0px";
					}
					if (this.topContainer) {
						this.topContainer.appendChild(newCorner);
					}
					break;
				  case "tr":
					if (newCorner.style.position == "absolute") {
						newCorner.style.top = "0px";
					}
					if (newCorner.style.position == "absolute") {
						newCorner.style.right = "0px";
					}
					if (this.topContainer) {
						this.topContainer.appendChild(newCorner);
					}
					break;
				  case "bl":
					if (newCorner.style.position == "absolute") {
						newCorner.style.bottom = "0px";
					}
					if (newCorner.style.position == "absolute") {
						newCorner.style.left = "0px";
					}
					if (this.bottomContainer) {
						this.bottomContainer.appendChild(newCorner);
					}
					break;
				  case "br":
					if (newCorner.style.position == "absolute") {
						newCorner.style.bottom = "0px";
					}
					if (newCorner.style.position == "absolute") {
						newCorner.style.right = "0px";
					}
					if (this.bottomContainer) {
						this.bottomContainer.appendChild(newCorner);
					}
					break;
				}
			}
		}
		var radiusDiff = [];
		radiusDiff["t"] = this.settings.tl.enabled && this.settings.tr.enabled ? Math.abs(this.settings.tl.radius - this.settings.tr.radius) : 0;
		radiusDiff["b"] = this.settings.bl.enabled && this.settings.br.enabled ? Math.abs(this.settings.bl.radius - this.settings.br.radius) : 0;
		for (var z in radiusDiff) {
			if (radiusDiff[z]) {
				var smallerCornerType = ((this.settings[z + "l"].radius < this.settings[z + "r"].radius) ? z + "l" : z + "r");
				var newFiller = document.createElement("DIV");
				with (newFiller.style) {
					height = radiusDiff[z] + "px";
					width = this.settings[smallerCornerType].radius + "px";
					position = "absolute";
					fontSize = "1px";
					overflow = "hidden";
					backgroundColor = this.boxColour;
				}
				switch (smallerCornerType) {
				  case "tl":
					with (newFiller.style) {
						bottom = "0px";
						left = "0px";
						borderLeft = this.borderString;
					}
					this.topContainer.appendChild(newFiller);
					break;
				  case "tr":
					with (newFiller.style) {
						bottom = "0px";
						right = "0px";
						borderRight = this.borderString;
					}
					this.topContainer.appendChild(newFiller);
					break;
				  case "bl":
					with (newFiller.style) {
						top = "0px";
						left = "0px";
						borderLeft = this.borderString;
					}
					this.bottomContainer.appendChild(newFiller);
					break;
				  case "br":
					with (newFiller.style) {
						top = "0px";
						right = "0px";
						borderRight = this.borderString;
					}
					this.bottomContainer.appendChild(newFiller);
					break;
				}
			}
			var newFillerBar = document.createElement("DIV");
			with (newFillerBar.style) {
				position = "relative";
				fontSize = "1px";
				overflow = "hidden";
				backgroundColor = this.boxColour;
			}
			switch (z) {
			  case "t":
				if (this.topContainer) {
					with (newFillerBar.style) {
						height = topMaxRadius - this.borderWidth + "px";
						marginLeft = this.settings.tl.radius - this.borderWidth + "px";
						marginRight = this.settings.tr.radius - this.borderWidth + "px";
						borderTop = this.borderString;
					}
					this.topContainer.appendChild(newFillerBar);
				}
				break;
			  case "b":
				if (this.bottomContainer) {
					with (newFillerBar.style) {
						height = botMaxRadius - this.borderWidth + "px";
						marginLeft = this.settings.bl.radius - this.borderWidth + "px";
						marginRight = this.settings.br.radius - this.borderWidth + "px";
						borderBottom = this.borderString;
					}
					this.bottomContainer.appendChild(newFillerBar);
				}
				break;
			}
		}
	};
	this.drawPixel = function (intx, inty, colour, transAmount, height, newCorner, image, cornerRadius) {
		var pixel = document.createElement("DIV");
		pixel.style.height = height + "px";
		pixel.style.width = "1px";
		pixel.style.position = "absolute";
		pixel.style.fontSize = "1px";
		pixel.style.overflow = "hidden";
		if (image == -1 && this.backgroundImage != "") {
			pixel.style.backgroundImage = this.backgroundImage;
			pixel.style.backgroundPosition = "-" + (this.boxWidth - (cornerRadius - intx) + this.borderWidth) + "px -" + ((this.boxHeight + cornerRadius + inty) - this.borderWidth) + "px";
		} else {
			pixel.style.backgroundColor = colour;
		}
		if (transAmount != 100) {
			dojo.html.setOpacity(pixel, transAmount);
		}
		pixel.style.top = inty + "px";
		pixel.style.left = intx + "px";
		newCorner.appendChild(pixel);
	};
}, pixelFraction:function (x, y, r) {
	var pixelfraction = 0;
	var xvalues = [];
	var yvalues = [];
	var point = 0;
	var whatsides = "";
	var intersect = Math.sqrt((Math.pow(r, 2) - Math.pow(x, 2)));
	if ((intersect >= y) && (intersect < (y + 1))) {
		whatsides = "Left";
		xvalues[point] = 0;
		yvalues[point] = intersect - y;
		point = point + 1;
	}
	var intersect = Math.sqrt((Math.pow(r, 2) - Math.pow(y + 1, 2)));
	if ((intersect >= x) && (intersect < (x + 1))) {
		whatsides = whatsides + "Top";
		xvalues[point] = intersect - x;
		yvalues[point] = 1;
		point = point + 1;
	}
	var intersect = Math.sqrt((Math.pow(r, 2) - Math.pow(x + 1, 2)));
	if ((intersect >= y) && (intersect < (y + 1))) {
		whatsides = whatsides + "Right";
		xvalues[point] = 1;
		yvalues[point] = intersect - y;
		point = point + 1;
	}
	var intersect = Math.sqrt((Math.pow(r, 2) - Math.pow(y, 2)));
	if ((intersect >= x) && (intersect < (x + 1))) {
		whatsides = whatsides + "Bottom";
		xvalues[point] = intersect - x;
		yvalues[point] = 0;
	}
	switch (whatsides) {
	  case "LeftRight":
		pixelfraction = Math.min(yvalues[0], yvalues[1]) + ((Math.max(yvalues[0], yvalues[1]) - Math.min(yvalues[0], yvalues[1])) / 2);
		break;
	  case "TopRight":
		pixelfraction = 1 - (((1 - xvalues[0]) * (1 - yvalues[1])) / 2);
		break;
	  case "TopBottom":
		pixelfraction = Math.min(xvalues[0], xvalues[1]) + ((Math.max(xvalues[0], xvalues[1]) - Math.min(xvalues[0], xvalues[1])) / 2);
		break;
	  case "LeftBottom":
		pixelfraction = (yvalues[0] * xvalues[1]) / 2;
		break;
	  default:
		pixelfraction = 1;
	}
	return pixelfraction;
}, rgb2Hex:function (rgbColour) {
	try {
		var rgbArray = this.rgb2Array(rgbColour);
		var red = parseInt(rgbArray[0]);
		var green = parseInt(rgbArray[1]);
		var blue = parseInt(rgbArray[2]);
		var hexColour = "#" + this.intToHex(red) + this.intToHex(green) + this.intToHex(blue);
	}
	catch (e) {
		alert("There was an error converting the RGB value to Hexadecimal in function rgb2Hex");
	}
	return hexColour;
}, intToHex:function (strNum) {
	var base = strNum / 16;
	var rem = strNum % 16;
	var base = base - (rem / 16);
	var baseS = this.makeHex(base);
	var remS = this.makeHex(rem);
	return baseS + "" + remS;
}, makeHex:function (x) {
	if ((x >= 0) && (x <= 9)) {
		return x;
	} else {
		switch (x) {
		  case 10:
			return "A";
		  case 11:
			return "B";
		  case 12:
			return "C";
		  case 13:
			return "D";
		  case 14:
			return "E";
		  case 15:
			return "F";
		}
	}
}, rgb2Array:function (rgbColour) {
	var rgbValues = rgbColour.substring(4, rgbColour.indexOf(")"));
	var rgbArray = rgbValues.split(", ");
	return rgbArray;
}});


__CPAN_FILE__ src/widget/IntegerTextbox.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.widget.IntegerTextbox");
dojo.require("dojo.widget.ValidationTextbox");
dojo.require("dojo.validate.common");
dojo.widget.defineWidget("dojo.widget.IntegerTextbox", dojo.widget.ValidationTextbox, {mixInProperties:function (localProperties, frag) {
	dojo.widget.IntegerTextbox.superclass.mixInProperties.apply(this, arguments);
	if ((localProperties.signed == "true") || (localProperties.signed == "always")) {
		this.flags.signed = true;
	} else {
		if ((localProperties.signed == "false") || (localProperties.signed == "never")) {
			this.flags.signed = false;
			this.flags.min = 0;
		} else {
			this.flags.signed = [true, false];
		}
	}
	if (localProperties.separator) {
		this.flags.separator = localProperties.separator;
	}
	if (localProperties.min) {
		this.flags.min = parseInt(localProperties.min);
	}
	if (localProperties.max) {
		this.flags.max = parseInt(localProperties.max);
	}
}, isValid:function () {
	return dojo.validate.isInteger(this.textbox.value, this.flags);
}, isInRange:function () {
	return dojo.validate.isInRange(this.textbox.value, this.flags);
}});


__CPAN_FILE__ src/widget/Checkbox.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.widget.Checkbox");
dojo.require("dojo.widget.*");
dojo.require("dojo.widget.HtmlWidget");
dojo.require("dojo.event.*");
dojo.require("dojo.html.style");
dojo.require("dojo.html.selection");
dojo.widget.defineWidget("dojo.widget.Checkbox", dojo.widget.HtmlWidget, {templateString:"<span style=\"display: inline-block;\" tabIndex=\"${this.tabIndex}\" waiRole=\"checkbox\" id=\"${this.id}\">\n\t<img dojoAttachPoint=\"imageNode\" class=\"dojoHtmlCheckbox\" src=\"${dojoWidgetModuleUri}templates/images/blank.gif\" alt=\"\" />\n\t<input type=\"checkbox\" name=\"${this.name}\" style=\"display: none\" value=\"${this.value}\"\n\t\tdojoAttachPoint=\"inputNode\">\n</span>\n", templateCssString:".dojoHtmlCheckbox {\n\tborder: 0px;\n\twidth: 16px;\n\theight: 16px;\n\tmargin: 2px;\n\tvertical-align: middle;\n}\n\n.dojoHtmlCheckboxOn {\n\tbackground: url(check.gif) 0px 0px;\n}\n.dojoHtmlCheckboxOff {\n\tbackground: url(check.gif) -16px 0px;\n}\n.dojoHtmlCheckboxDisabledOn {\n\tbackground: url(check.gif) -32px 0px;\n}\n.dojoHtmlCheckboxDisabledOff {\n\tbackground: url(check.gif) -48px 0px;\n}\n.dojoHtmlCheckboxOnHover {\n\tbackground: url(check.gif) -64px 0px;\n}\n.dojoHtmlCheckboxOffHover {\n\tbackground: url(check.gif) -80px 0px;\n}\n", templateCssPath:dojo.uri.moduleUri("dojo.widget", "templates/Checkbox.css"), name:"", id:"", checked:false, tabIndex:"", value:"on", postMixInProperties:function () {
	dojo.widget.Checkbox.superclass.postMixInProperties.apply(this, arguments);
	if (!this.disabled && this.tabIndex == "") {
		this.tabIndex = "0";
	}
}, fillInTemplate:function () {
	this._setInfo();
}, postCreate:function () {
	var notcon = true;
	this.id = this.id != "" ? this.id : this.widgetId;
	if (this.id != "") {
		var labels = document.getElementsByTagName("label");
		if (labels != null && labels.length > 0) {
			for (var i = 0; i < labels.length; i++) {
				if (labels[i].htmlFor == this.id) {
					labels[i].id = (labels[i].htmlFor + "label");
					this._connectEvents(labels[i]);
					dojo.widget.wai.setAttr(this.domNode, "waiState", "labelledby", labels[i].id);
					break;
				}
			}
		}
	}
	this._connectEvents(this.domNode);
	this.inputNode.checked = this.checked;
}, _connectEvents:function (node) {
	dojo.event.connect(node, "onmouseover", this, "mouseOver");
	dojo.event.connect(node, "onmouseout", this, "mouseOut");
	dojo.event.connect(node, "onkey", this, "onKey");
	dojo.event.connect(node, "onclick", this, "_onClick");
	dojo.html.disableSelection(node);
}, _onClick:function (e) {
	if (this.disabled == false) {
		this.checked = !this.checked;
		this._setInfo();
	}
	e.preventDefault();
	e.stopPropagation();
	this.onClick();
}, setValue:function (bool) {
	if (this.disabled == false) {
		this.checked = bool;
		this._setInfo();
	}
}, onClick:function () {
}, onKey:function (e) {
	var k = dojo.event.browser.keys;
	if (e.key == " ") {
		this._onClick(e);
	}
}, mouseOver:function (e) {
	this._hover(e, true);
}, mouseOut:function (e) {
	this._hover(e, false);
}, _hover:function (e, isOver) {
	if (this.disabled == false) {
		var state = this.checked ? "On" : "Off";
		var style = "dojoHtmlCheckbox" + state + "Hover";
		if (isOver) {
			dojo.html.addClass(this.imageNode, style);
		} else {
			dojo.html.removeClass(this.imageNode, style);
		}
	}
}, _setInfo:function () {
	var state = "dojoHtmlCheckbox" + (this.disabled ? "Disabled" : "") + (this.checked ? "On" : "Off");
	dojo.html.setClass(this.imageNode, "dojoHtmlCheckbox " + state);
	this.inputNode.checked = this.checked;
	if (this.disabled) {
		this.inputNode.setAttribute("disabled", true);
	} else {
		this.inputNode.removeAttribute("disabled");
	}
	dojo.widget.wai.setAttr(this.domNode, "waiState", "checked", this.checked);
}});
dojo.widget.defineWidget("dojo.widget.a11y.Checkbox", dojo.widget.Checkbox, {templateString:"<span class='dojoHtmlCheckbox'>\n\t<input type=\"checkbox\" name=\"${this.name}\" tabIndex=\"${this.tabIndex}\" id=\"${this.id}\" value=\"${this.value}\"\n\t\t dojoAttachEvent=\"onClick: _onClick;\" dojoAttachPoint=\"inputNode\"> \n</span>\n", fillInTemplate:function () {
}, postCreate:function (args, frag) {
	this.inputNode.checked = this.checked;
	if (this.disabled) {
		this.inputNode.setAttribute("disabled", true);
	}
}, _onClick:function () {
	this.onClick();
}});


__CPAN_FILE__ src/widget/Editor.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.widget.Editor");
dojo.deprecated("dojo.widget.Editor", "is replaced by dojo.widget.Editor2", "0.5");
dojo.require("dojo.io.*");
dojo.require("dojo.widget.*");
dojo.require("dojo.widget.Toolbar");
dojo.require("dojo.widget.RichText");
dojo.require("dojo.widget.ColorPalette");
dojo.require("dojo.string.extras");
dojo.widget.tags.addParseTreeHandler("dojo:Editor");
dojo.widget.Editor = function () {
	dojo.widget.HtmlWidget.call(this);
	this.contentFilters = [];
	this._toolbars = [];
};
dojo.inherits(dojo.widget.Editor, dojo.widget.HtmlWidget);
dojo.widget.Editor.itemGroups = {textGroup:["bold", "italic", "underline", "strikethrough"], blockGroup:["formatBlock", "fontName", "fontSize"], justifyGroup:["justifyleft", "justifycenter", "justifyright"], commandGroup:["save", "cancel"], colorGroup:["forecolor", "hilitecolor"], listGroup:["insertorderedlist", "insertunorderedlist"], indentGroup:["outdent", "indent"], linkGroup:["createlink", "insertimage", "inserthorizontalrule"]};
dojo.widget.Editor.formatBlockValues = {"Normal":"p", "Main heading":"h2", "Sub heading":"h3", "Sub sub heading":"h4", "Preformatted":"pre"};
dojo.widget.Editor.fontNameValues = {"Arial":"Arial, Helvetica, sans-serif", "Verdana":"Verdana, sans-serif", "Times New Roman":"Times New Roman, serif", "Courier":"Courier New, monospace"};
dojo.widget.Editor.fontSizeValues = {"1 (8 pt)":"1", "2 (10 pt)":"2", "3 (12 pt)":"3", "4 (14 pt)":"4", "5 (18 pt)":"5", "6 (24 pt)":"6", "7 (36 pt)":"7"};
dojo.widget.Editor.defaultItems = ["commandGroup", "|", "blockGroup", "|", "textGroup", "|", "colorGroup", "|", "justifyGroup", "|", "listGroup", "indentGroup", "|", "linkGroup"];
dojo.widget.Editor.supportedCommands = ["save", "cancel", "|", "-", "/", " "];
dojo.lang.extend(dojo.widget.Editor, {widgetType:"Editor", saveUrl:"", saveMethod:"post", saveArgName:"editorContent", closeOnSave:false, items:dojo.widget.Editor.defaultItems, formatBlockItems:dojo.lang.shallowCopy(dojo.widget.Editor.formatBlockValues), fontNameItems:dojo.lang.shallowCopy(dojo.widget.Editor.fontNameValues), fontSizeItems:dojo.lang.shallowCopy(dojo.widget.Editor.fontSizeValues), getItemProperties:function (name) {
	var props = {};
	switch (name.toLowerCase()) {
	  case "bold":
	  case "italic":
	  case "underline":
	  case "strikethrough":
		props.toggleItem = true;
		break;
	  case "justifygroup":
		props.defaultButton = "justifyleft";
		props.preventDeselect = true;
		props.buttonGroup = true;
		break;
	  case "listgroup":
		props.buttonGroup = true;
		break;
	  case "save":
	  case "cancel":
		props.label = dojo.string.capitalize(name);
		break;
	  case "forecolor":
	  case "hilitecolor":
		props.name = name;
		props.toggleItem = true;
		props.icon = this.getCommandImage(name);
		break;
	  case "formatblock":
		props.name = "formatBlock";
		props.values = this.formatBlockItems;
		break;
	  case "fontname":
		props.name = "fontName";
		props.values = this.fontNameItems;
	  case "fontsize":
		props.name = "fontSize";
		props.values = this.fontSizeItems;
	}
	return props;
}, validateItems:true, focusOnLoad:true, minHeight:"1em", _richText:null, _richTextType:"RichText", _toolbarContainer:null, _toolbarContainerType:"ToolbarContainer", _toolbars:[], _toolbarType:"Toolbar", _toolbarItemType:"ToolbarItem", buildRendering:function (args, frag) {
	var node = frag["dojo:" + this.widgetType.toLowerCase()]["nodeRef"];
	var trt = dojo.widget.createWidget(this._richTextType, {focusOnLoad:this.focusOnLoad, minHeight:this.minHeight}, node);
	var _this = this;
	setTimeout(function () {
		_this.setRichText(trt);
		_this.initToolbar();
		_this.fillInTemplate(args, frag);
	}, 0);
}, setRichText:function (richText) {
	if (this._richText && this._richText == richText) {
		dojo.debug("Already set the richText to this richText!");
		return;
	}
	if (this._richText && !this._richText.isClosed) {
		dojo.debug("You are switching richTexts yet you haven't closed the current one. Losing reference!");
	}
	this._richText = richText;
	dojo.event.connect(this._richText, "close", this, "onClose");
	dojo.event.connect(this._richText, "onLoad", this, "onLoad");
	dojo.event.connect(this._richText, "onDisplayChanged", this, "updateToolbar");
	if (this._toolbarContainer) {
		this._toolbarContainer.enable();
		this.updateToolbar(true);
	}
}, initToolbar:function () {
	if (this._toolbarContainer) {
		return;
	}
	this._toolbarContainer = dojo.widget.createWidget(this._toolbarContainerType);
	var tb = this.addToolbar();
	var last = true;
	for (var i = 0; i < this.items.length; i++) {
		if (this.items[i] == "\n") {
			tb = this.addToolbar();
		} else {
			if ((this.items[i] == "|") && (!last)) {
				last = true;
			} else {
				last = this.addItem(this.items[i], tb);
			}
		}
	}
	this.insertToolbar(this._toolbarContainer.domNode, this._richText.domNode);
}, insertToolbar:function (tbNode, richTextNode) {
	dojo.html.insertBefore(tbNode, richTextNode);
}, addToolbar:function (toolbar) {
	this.initToolbar();
	if (!(toolbar instanceof dojo.widget.Toolbar)) {
		toolbar = dojo.widget.createWidget(this._toolbarType);
	}
	this._toolbarContainer.addChild(toolbar);
	this._toolbars.push(toolbar);
	return toolbar;
}, addItem:function (item, tb, dontValidate) {
	if (!tb) {
		tb = this._toolbars[0];
	}
	var cmd = ((item) && (!dojo.lang.isUndefined(item["getValue"]))) ? cmd = item["getValue"]() : item;
	var groups = dojo.widget.Editor.itemGroups;
	if (item instanceof dojo.widget.ToolbarItem) {
		tb.addChild(item);
	} else {
		if (groups[cmd]) {
			var group = groups[cmd];
			var worked = true;
			if (cmd == "justifyGroup" || cmd == "listGroup") {
				var btnGroup = [cmd];
				for (var i = 0; i < group.length; i++) {
					if (dontValidate || this.isSupportedCommand(group[i])) {
						btnGroup.push(this.getCommandImage(group[i]));
					} else {
						worked = false;
					}
				}
				if (btnGroup.length) {
					var btn = tb.addChild(btnGroup, null, this.getItemProperties(cmd));
					dojo.event.connect(btn, "onClick", this, "_action");
					dojo.event.connect(btn, "onChangeSelect", this, "_action");
				}
				return worked;
			} else {
				for (var i = 0; i < group.length; i++) {
					if (!this.addItem(group[i], tb)) {
						worked = false;
					}
				}
				return worked;
			}
		} else {
			if ((!dontValidate) && (!this.isSupportedCommand(cmd))) {
				return false;
			}
			if (dontValidate || this.isSupportedCommand(cmd)) {
				cmd = cmd.toLowerCase();
				if (cmd == "formatblock") {
					var select = dojo.widget.createWidget("ToolbarSelect", {name:"formatBlock", values:this.formatBlockItems});
					tb.addChild(select);
					var _this = this;
					dojo.event.connect(select, "onSetValue", function (item, value) {
						_this.onAction("formatBlock", value);
					});
				} else {
					if (cmd == "fontname") {
						var select = dojo.widget.createWidget("ToolbarSelect", {name:"fontName", values:this.fontNameItems});
						tb.addChild(select);
						dojo.event.connect(select, "onSetValue", dojo.lang.hitch(this, function (item, value) {
							this.onAction("fontName", value);
						}));
					} else {
						if (cmd == "fontsize") {
							var select = dojo.widget.createWidget("ToolbarSelect", {name:"fontSize", values:this.fontSizeItems});
							tb.addChild(select);
							dojo.event.connect(select, "onSetValue", dojo.lang.hitch(this, function (item, value) {
								this.onAction("fontSize", value);
							}));
						} else {
							if (dojo.lang.inArray(cmd, ["forecolor", "hilitecolor"])) {
								var btn = tb.addChild(dojo.widget.createWidget("ToolbarColorDialog", this.getItemProperties(cmd)));
								dojo.event.connect(btn, "onSetValue", this, "_setValue");
							} else {
								var btn = tb.addChild(this.getCommandImage(cmd), null, this.getItemProperties(cmd));
								if (cmd == "save") {
									dojo.event.connect(btn, "onClick", this, "_save");
								} else {
									if (cmd == "cancel") {
										dojo.event.connect(btn, "onClick", this, "_close");
									} else {
										dojo.event.connect(btn, "onClick", this, "_action");
										dojo.event.connect(btn, "onChangeSelect", this, "_action");
									}
								}
							}
						}
					}
				}
			}
		}
	}
	return true;
}, enableToolbar:function () {
	if (this._toolbarContainer) {
		this._toolbarContainer.domNode.style.display = "";
		this._toolbarContainer.enable();
	}
}, disableToolbar:function (hide) {
	if (hide) {
		if (this._toolbarContainer) {
			this._toolbarContainer.domNode.style.display = "none";
		}
	} else {
		if (this._toolbarContainer) {
			this._toolbarContainer.disable();
		}
	}
}, _updateToolbarLastRan:null, _updateToolbarTimer:null, _updateToolbarFrequency:500, updateToolbar:function (force) {
	if (!this._toolbarContainer) {
		return;
	}
	var diff = new Date() - this._updateToolbarLastRan;
	if (!force && this._updateToolbarLastRan && (diff < this._updateToolbarFrequency)) {
		clearTimeout(this._updateToolbarTimer);
		var _this = this;
		this._updateToolbarTimer = setTimeout(function () {
			_this.updateToolbar();
		}, this._updateToolbarFrequency / 2);
		return;
	} else {
		this._updateToolbarLastRan = new Date();
	}
	var items = this._toolbarContainer.getItems();
	for (var i = 0; i < items.length; i++) {
		var item = items[i];
		if (item instanceof dojo.widget.ToolbarSeparator) {
			continue;
		}
		var cmd = item._name;
		if (cmd == "save" || cmd == "cancel") {
			continue;
		} else {
			if (cmd == "justifyGroup") {
				try {
					if (!this._richText.queryCommandEnabled("justifyleft")) {
						item.disable(false, true);
					} else {
						item.enable(false, true);
						var jitems = item.getItems();
						for (var j = 0; j < jitems.length; j++) {
							var name = jitems[j]._name;
							var value = this._richText.queryCommandValue(name);
							if (typeof value == "boolean" && value) {
								value = name;
								break;
							} else {
								if (typeof value == "string") {
									value = "justify" + value;
								} else {
									value = null;
								}
							}
						}
						if (!value) {
							value = "justifyleft";
						}
						item.setValue(value, false, true);
					}
				}
				catch (err) {
				}
			} else {
				if (cmd == "listGroup") {
					var litems = item.getItems();
					for (var j = 0; j < litems.length; j++) {
						this.updateItem(litems[j]);
					}
				} else {
					this.updateItem(item);
				}
			}
		}
	}
}, updateItem:function (item) {
	try {
		var cmd = item._name;
		var enabled = this._richText.queryCommandEnabled(cmd);
		item.setEnabled(enabled, false, true);
		var active = this._richText.queryCommandState(cmd);
		if (active && cmd == "underline") {
			active = !this._richText.queryCommandEnabled("unlink");
		}
		item.setSelected(active, false, true);
		return true;
	}
	catch (err) {
		return false;
	}
}, supportedCommands:dojo.widget.Editor.supportedCommands.concat(), isSupportedCommand:function (cmd) {
	var yes = dojo.lang.inArray(cmd, this.supportedCommands);
	if (!yes) {
		try {
			var richText = this._richText || dojo.widget.HtmlRichText.prototype;
			yes = richText.queryCommandAvailable(cmd);
		}
		catch (E) {
		}
	}
	return yes;
}, getCommandImage:function (cmd) {
	if (cmd == "|") {
		return cmd;
	} else {
		return dojo.uri.moduleUri("dojo.widget", "templates/buttons/" + cmd + ".gif");
	}
}, _action:function (e) {
	this._fire("onAction", e.getValue());
}, _setValue:function (a, b) {
	this._fire("onAction", a.getValue(), b);
}, _save:function (e) {
	if (!this._richText.isClosed) {
		if (this.saveUrl.length) {
			var content = {};
			content[this.saveArgName] = this.getHtml();
			dojo.io.bind({method:this.saveMethod, url:this.saveUrl, content:content});
		} else {
			dojo.debug("please set a saveUrl for the editor");
		}
		if (this.closeOnSave) {
			this._richText.close(e.getName().toLowerCase() == "save");
		}
	}
}, _close:function (e) {
	if (!this._richText.isClosed) {
		this._richText.close(e.getName().toLowerCase() == "save");
	}
}, onAction:function (cmd, value) {
	switch (cmd) {
	  case "createlink":
		if (!(value = prompt("Please enter the URL of the link:", "http://"))) {
			return;
		}
		break;
	  case "insertimage":
		if (!(value = prompt("Please enter the URL of the image:", "http://"))) {
			return;
		}
		break;
	}
	this._richText.execCommand(cmd, value);
}, fillInTemplate:function (args, frag) {
}, _fire:function (eventName) {
	if (dojo.lang.isFunction(this[eventName])) {
		var args = [];
		if (arguments.length == 1) {
			args.push(this);
		} else {
			for (var i = 1; i < arguments.length; i++) {
				args.push(arguments[i]);
			}
		}
		this[eventName].apply(this, args);
	}
}, getHtml:function () {
	this._richText.contentFilters = this._richText.contentFilters.concat(this.contentFilters);
	return this._richText.getEditorContent();
}, getEditorContent:function () {
	return this.getHtml();
}, onClose:function (save, hide) {
	this.disableToolbar(hide);
	if (save) {
		this._fire("onSave");
	} else {
		this._fire("onCancel");
	}
}, onLoad:function () {
}, onSave:function () {
}, onCancel:function () {
}});


__CPAN_FILE__ src/widget/PopupContainer.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.widget.PopupContainer");
dojo.require("dojo.html.style");
dojo.require("dojo.html.layout");
dojo.require("dojo.html.selection");
dojo.require("dojo.html.iframe");
dojo.require("dojo.event.*");
dojo.require("dojo.widget.*");
dojo.require("dojo.widget.HtmlWidget");
dojo.declare("dojo.widget.PopupContainerBase", null, function () {
	this.queueOnAnimationFinish = [];
}, {isShowingNow:false, currentSubpopup:null, beginZIndex:1000, parentPopup:null, parent:null, popupIndex:0, aroundBox:dojo.html.boxSizing.BORDER_BOX, openedForWindow:null, processKey:function (evt) {
	return false;
}, applyPopupBasicStyle:function () {
	with (this.domNode.style) {
		display = "none";
		position = "absolute";
	}
}, aboutToShow:function () {
}, open:function (x, y, parent, explodeSrc, orient, padding) {
	if (this.isShowingNow) {
		return;
	}
	if (this.animationInProgress) {
		this.queueOnAnimationFinish.push(this.open, arguments);
		return;
	}
	this.aboutToShow();
	var around = false, node, aroundOrient;
	if (typeof x == "object") {
		node = x;
		aroundOrient = explodeSrc;
		explodeSrc = parent;
		parent = y;
		around = true;
	}
	this.parent = parent;
	dojo.body().appendChild(this.domNode);
	explodeSrc = explodeSrc || parent["domNode"] || [];
	var parentPopup = null;
	this.isTopLevel = true;
	while (parent) {
		if (parent !== this && (parent.setOpenedSubpopup != undefined && parent.applyPopupBasicStyle != undefined)) {
			parentPopup = parent;
			this.isTopLevel = false;
			parentPopup.setOpenedSubpopup(this);
			break;
		}
		parent = parent.parent;
	}
	this.parentPopup = parentPopup;
	this.popupIndex = parentPopup ? parentPopup.popupIndex + 1 : 1;
	if (this.isTopLevel) {
		var button = dojo.html.isNode(explodeSrc) ? explodeSrc : null;
		dojo.widget.PopupManager.opened(this, button);
	}
	if (this.isTopLevel && !dojo.withGlobal(this.openedForWindow || dojo.global(), dojo.html.selection.isCollapsed)) {
		this._bookmark = dojo.withGlobal(this.openedForWindow || dojo.global(), dojo.html.selection.getBookmark);
	} else {
		this._bookmark = null;
	}
	if (explodeSrc instanceof Array) {
		explodeSrc = {left:explodeSrc[0], top:explodeSrc[1], width:0, height:0};
	}
	with (this.domNode.style) {
		display = "";
		zIndex = this.beginZIndex + this.popupIndex;
	}
	if (around) {
		this.move(node, padding, aroundOrient);
	} else {
		this.move(x, y, padding, orient);
	}
	this.domNode.style.display = "none";
	this.explodeSrc = explodeSrc;
	this.show();
	this.isShowingNow = true;
}, move:function (x, y, padding, orient) {
	var around = (typeof x == "object");
	if (around) {
		var aroundOrient = padding;
		var node = x;
		padding = y;
		if (!aroundOrient) {
			aroundOrient = {"BL":"TL", "TL":"BL"};
		}
		dojo.html.placeOnScreenAroundElement(this.domNode, node, padding, this.aroundBox, aroundOrient);
	} else {
		if (!orient) {
			orient = "TL,TR,BL,BR";
		}
		dojo.html.placeOnScreen(this.domNode, x, y, padding, true, orient);
	}
}, close:function (force) {
	if (force) {
		this.domNode.style.display = "none";
	}
	if (this.animationInProgress) {
		this.queueOnAnimationFinish.push(this.close, []);
		return;
	}
	this.closeSubpopup(force);
	this.hide();
	if (this.bgIframe) {
		this.bgIframe.hide();
		this.bgIframe.size({left:0, top:0, width:0, height:0});
	}
	if (this.isTopLevel) {
		dojo.widget.PopupManager.closed(this);
	}
	this.isShowingNow = false;
	if (this.parent) {
		setTimeout(dojo.lang.hitch(this, function () {
			try {
				if (this.parent["focus"]) {
					this.parent.focus();
				} else {
					this.parent.domNode.focus();
				}
			}
			catch (e) {
				dojo.debug("No idea how to focus to parent", e);
			}
		}), 10);
	}
	if (this._bookmark && dojo.withGlobal(this.openedForWindow || dojo.global(), dojo.html.selection.isCollapsed)) {
		if (this.openedForWindow) {
			this.openedForWindow.focus();
		}
		try {
			dojo.withGlobal(this.openedForWindow || dojo.global(), "moveToBookmark", dojo.html.selection, [this._bookmark]);
		}
		catch (e) {
		}
	}
	this._bookmark = null;
}, closeAll:function (force) {
	if (this.parentPopup) {
		this.parentPopup.closeAll(force);
	} else {
		this.close(force);
	}
}, setOpenedSubpopup:function (popup) {
	this.currentSubpopup = popup;
}, closeSubpopup:function (force) {
	if (this.currentSubpopup == null) {
		return;
	}
	this.currentSubpopup.close(force);
	this.currentSubpopup = null;
}, onShow:function () {
	dojo.widget.PopupContainer.superclass.onShow.apply(this, arguments);
	this.openedSize = {w:this.domNode.style.width, h:this.domNode.style.height};
	if (dojo.render.html.ie) {
		if (!this.bgIframe) {
			this.bgIframe = new dojo.html.BackgroundIframe();
			this.bgIframe.setZIndex(this.domNode);
		}
		this.bgIframe.size(this.domNode);
		this.bgIframe.show();
	}
	this.processQueue();
}, processQueue:function () {
	if (!this.queueOnAnimationFinish.length) {
		return;
	}
	var func = this.queueOnAnimationFinish.shift();
	var args = this.queueOnAnimationFinish.shift();
	func.apply(this, args);
}, onHide:function () {
	dojo.widget.HtmlWidget.prototype.onHide.call(this);
	if (this.openedSize) {
		with (this.domNode.style) {
			width = this.openedSize.w;
			height = this.openedSize.h;
		}
	}
	this.processQueue();
}});
dojo.widget.defineWidget("dojo.widget.PopupContainer", [dojo.widget.HtmlWidget, dojo.widget.PopupContainerBase], {isContainer:true, fillInTemplate:function () {
	this.applyPopupBasicStyle();
	dojo.widget.PopupContainer.superclass.fillInTemplate.apply(this, arguments);
}});
dojo.widget.PopupManager = new function () {
	this.currentMenu = null;
	this.currentButton = null;
	this.currentFocusMenu = null;
	this.focusNode = null;
	this.registeredWindows = [];
	this.registerWin = function (win) {
		if (!win.__PopupManagerRegistered) {
			dojo.event.connect(win.document, "onmousedown", this, "onClick");
			dojo.event.connect(win, "onscroll", this, "onClick");
			dojo.event.connect(win.document, "onkey", this, "onKey");
			win.__PopupManagerRegistered = true;
			this.registeredWindows.push(win);
		}
	};
	this.registerAllWindows = function (targetWindow) {
		if (!targetWindow) {
			targetWindow = dojo.html.getDocumentWindow(window.top && window.top.document || window.document);
		}
		this.registerWin(targetWindow);
		for (var i = 0; i < targetWindow.frames.length; i++) {
			try {
				var win = dojo.html.getDocumentWindow(targetWindow.frames[i].document);
				if (win) {
					this.registerAllWindows(win);
				}
			}
			catch (e) {
			}
		}
	};
	this.unRegisterWin = function (win) {
		if (win.__PopupManagerRegistered) {
			dojo.event.disconnect(win.document, "onmousedown", this, "onClick");
			dojo.event.disconnect(win, "onscroll", this, "onClick");
			dojo.event.disconnect(win.document, "onkey", this, "onKey");
			win.__PopupManagerRegistered = false;
		}
	};
	this.unRegisterAllWindows = function () {
		for (var i = 0; i < this.registeredWindows.length; ++i) {
			this.unRegisterWin(this.registeredWindows[i]);
		}
		this.registeredWindows = [];
	};
	dojo.addOnLoad(this, "registerAllWindows");
	dojo.addOnUnload(this, "unRegisterAllWindows");
	this.closed = function (menu) {
		if (this.currentMenu == menu) {
			this.currentMenu = null;
			this.currentButton = null;
			this.currentFocusMenu = null;
		}
	};
	this.opened = function (menu, button) {
		if (menu == this.currentMenu) {
			return;
		}
		if (this.currentMenu) {
			this.currentMenu.close();
		}
		this.currentMenu = menu;
		this.currentFocusMenu = menu;
		this.currentButton = button;
	};
	this.setFocusedMenu = function (menu) {
		this.currentFocusMenu = menu;
	};
	this.onKey = function (e) {
		if (!e.key) {
			return;
		}
		if (!this.currentMenu || !this.currentMenu.isShowingNow) {
			return;
		}
		var m = this.currentFocusMenu;
		while (m) {
			if (m.processKey(e)) {
				e.preventDefault();
				e.stopPropagation();
				break;
			}
			m = m.parentPopup || m.parentMenu;
		}
	}, this.onClick = function (e) {
		if (!this.currentMenu) {
			return;
		}
		var scrolloffset = dojo.html.getScroll().offset;
		var m = this.currentMenu;
		while (m) {
			if (dojo.html.overElement(m.domNode, e) || dojo.html.isDescendantOf(e.target, m.domNode)) {
				return;
			}
			m = m.currentSubpopup;
		}
		if (this.currentButton && dojo.html.overElement(this.currentButton, e)) {
			return;
		}
		this.currentMenu.closeAll(true);
	};
};


__CPAN_FILE__ src/widget/Dialog.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.widget.Dialog");
dojo.require("dojo.widget.*");
dojo.require("dojo.widget.ContentPane");
dojo.require("dojo.event.*");
dojo.require("dojo.gfx.color");
dojo.require("dojo.html.layout");
dojo.require("dojo.html.display");
dojo.require("dojo.html.iframe");
dojo.declare("dojo.widget.ModalDialogBase", null, {isContainer:true, focusElement:"", bgColor:"black", bgOpacity:0.4, followScroll:true, closeOnBackgroundClick:false, trapTabs:function (e) {
	if (e.target == this.tabStartOuter) {
		if (this._fromTrap) {
			this.tabStart.focus();
			this._fromTrap = false;
		} else {
			this._fromTrap = true;
			this.tabEnd.focus();
		}
	} else {
		if (e.target == this.tabStart) {
			if (this._fromTrap) {
				this._fromTrap = false;
			} else {
				this._fromTrap = true;
				this.tabEnd.focus();
			}
		} else {
			if (e.target == this.tabEndOuter) {
				if (this._fromTrap) {
					this.tabEnd.focus();
					this._fromTrap = false;
				} else {
					this._fromTrap = true;
					this.tabStart.focus();
				}
			} else {
				if (e.target == this.tabEnd) {
					if (this._fromTrap) {
						this._fromTrap = false;
					} else {
						this._fromTrap = true;
						this.tabStart.focus();
					}
				}
			}
		}
	}
}, clearTrap:function (e) {
	var _this = this;
	setTimeout(function () {
		_this._fromTrap = false;
	}, 100);
}, postCreate:function () {
	with (this.domNode.style) {
		position = "absolute";
		zIndex = 999;
		display = "none";
		overflow = "visible";
	}
	var b = dojo.body();
	b.appendChild(this.domNode);
	this.bg = document.createElement("div");
	this.bg.className = "dialogUnderlay";
	with (this.bg.style) {
		position = "absolute";
		left = top = "0px";
		zIndex = 998;
		display = "none";
	}
	b.appendChild(this.bg);
	this.setBackgroundColor(this.bgColor);
	this.bgIframe = new dojo.html.BackgroundIframe();
	if (this.bgIframe.iframe) {
		with (this.bgIframe.iframe.style) {
			position = "absolute";
			left = top = "0px";
			zIndex = 90;
			display = "none";
		}
	}
	if (this.closeOnBackgroundClick) {
		dojo.event.kwConnect({srcObj:this.bg, srcFunc:"onclick", adviceObj:this, adviceFunc:"onBackgroundClick", once:true});
	}
}, uninitialize:function () {
	this.bgIframe.remove();
	dojo.html.removeNode(this.bg, true);
}, setBackgroundColor:function (color) {
	if (arguments.length >= 3) {
		color = new dojo.gfx.color.Color(arguments[0], arguments[1], arguments[2]);
	} else {
		color = new dojo.gfx.color.Color(color);
	}
	this.bg.style.backgroundColor = color.toString();
	return this.bgColor = color;
}, setBackgroundOpacity:function (op) {
	if (arguments.length == 0) {
		op = this.bgOpacity;
	}
	dojo.html.setOpacity(this.bg, op);
	try {
		this.bgOpacity = dojo.html.getOpacity(this.bg);
	}
	catch (e) {
		this.bgOpacity = op;
	}
	return this.bgOpacity;
}, _sizeBackground:function () {
	if (this.bgOpacity > 0) {
		var viewport = dojo.html.getViewport();
		var h = viewport.height;
		var w = viewport.width;
		with (this.bg.style) {
			width = w + "px";
			height = h + "px";
		}
		var scroll_offset = dojo.html.getScroll().offset;
		this.bg.style.top = scroll_offset.y + "px";
		this.bg.style.left = scroll_offset.x + "px";
		var viewport = dojo.html.getViewport();
		if (viewport.width != w) {
			this.bg.style.width = viewport.width + "px";
		}
		if (viewport.height != h) {
			this.bg.style.height = viewport.height + "px";
		}
	}
	this.bgIframe.size(this.bg);
}, _showBackground:function () {
	if (this.bgOpacity > 0) {
		this.bg.style.display = "block";
	}
	if (this.bgIframe.iframe) {
		this.bgIframe.iframe.style.display = "block";
	}
}, placeModalDialog:function () {
	var scroll_offset = dojo.html.getScroll().offset;
	var viewport_size = dojo.html.getViewport();
	var mb;
	if (this.isShowing()) {
		mb = dojo.html.getMarginBox(this.domNode);
	} else {
		dojo.html.setVisibility(this.domNode, false);
		dojo.html.show(this.domNode);
		mb = dojo.html.getMarginBox(this.domNode);
		dojo.html.hide(this.domNode);
		dojo.html.setVisibility(this.domNode, true);
	}
	var x = scroll_offset.x + (viewport_size.width - mb.width) / 2;
	var y = scroll_offset.y + (viewport_size.height - mb.height) / 2;
	with (this.domNode.style) {
		left = x + "px";
		top = y + "px";
	}
}, _onKey:function (evt) {
	if (evt.key) {
		var node = evt.target;
		while (node != null) {
			if (node == this.domNode) {
				return;
			}
			node = node.parentNode;
		}
		if (evt.key != evt.KEY_TAB) {
			dojo.event.browser.stopEvent(evt);
		} else {
			if (!dojo.render.html.opera) {
				try {
					this.tabStart.focus();
				}
				catch (e) {
				}
			}
		}
	}
}, showModalDialog:function () {
	if (this.followScroll && !this._scrollConnected) {
		this._scrollConnected = true;
		dojo.event.connect(window, "onscroll", this, "_onScroll");
	}
	dojo.event.connect(document.documentElement, "onkey", this, "_onKey");
	this.placeModalDialog();
	this.setBackgroundOpacity();
	this._sizeBackground();
	this._showBackground();
	this._fromTrap = true;
	setTimeout(dojo.lang.hitch(this, function () {
		try {
			this.tabStart.focus();
		}
		catch (e) {
		}
	}), 50);
}, hideModalDialog:function () {
	if (this.focusElement) {
		dojo.byId(this.focusElement).focus();
		dojo.byId(this.focusElement).blur();
	}
	this.bg.style.display = "none";
	this.bg.style.width = this.bg.style.height = "1px";
	if (this.bgIframe.iframe) {
		this.bgIframe.iframe.style.display = "none";
	}
	dojo.event.disconnect(document.documentElement, "onkey", this, "_onKey");
	if (this._scrollConnected) {
		this._scrollConnected = false;
		dojo.event.disconnect(window, "onscroll", this, "_onScroll");
	}
}, _onScroll:function () {
	var scroll_offset = dojo.html.getScroll().offset;
	this.bg.style.top = scroll_offset.y + "px";
	this.bg.style.left = scroll_offset.x + "px";
	this.placeModalDialog();
}, checkSize:function () {
	if (this.isShowing()) {
		this._sizeBackground();
		this.placeModalDialog();
		this.onResized();
	}
}, onBackgroundClick:function () {
	if (this.lifetime - this.timeRemaining >= this.blockDuration) {
		return;
	}
	this.hide();
}});
dojo.widget.defineWidget("dojo.widget.Dialog", [dojo.widget.ContentPane, dojo.widget.ModalDialogBase], {templateString:"<div id=\"${this.widgetId}\" class=\"dojoDialog\" dojoattachpoint=\"wrapper\">\n\t<span dojoattachpoint=\"tabStartOuter\" dojoonfocus=\"trapTabs\" dojoonblur=\"clearTrap\"\ttabindex=\"0\"></span>\n\t<span dojoattachpoint=\"tabStart\" dojoonfocus=\"trapTabs\" dojoonblur=\"clearTrap\" tabindex=\"0\"></span>\n\t<div dojoattachpoint=\"containerNode\" style=\"position: relative; z-index: 2;\"></div>\n\t<span dojoattachpoint=\"tabEnd\" dojoonfocus=\"trapTabs\" dojoonblur=\"clearTrap\" tabindex=\"0\"></span>\n\t<span dojoattachpoint=\"tabEndOuter\" dojoonfocus=\"trapTabs\" dojoonblur=\"clearTrap\" tabindex=\"0\"></span>\n</div>\n", blockDuration:0, lifetime:0, closeNode:"", postMixInProperties:function () {
	dojo.widget.Dialog.superclass.postMixInProperties.apply(this, arguments);
	if (this.closeNode) {
		this.setCloseControl(this.closeNode);
	}
}, postCreate:function () {
	dojo.widget.Dialog.superclass.postCreate.apply(this, arguments);
	dojo.widget.ModalDialogBase.prototype.postCreate.apply(this, arguments);
}, show:function () {
	if (this.lifetime) {
		this.timeRemaining = this.lifetime;
		if (this.timerNode) {
			this.timerNode.innerHTML = Math.ceil(this.timeRemaining / 1000);
		}
		if (this.blockDuration && this.closeNode) {
			if (this.lifetime > this.blockDuration) {
				this.closeNode.style.visibility = "hidden";
			} else {
				this.closeNode.style.display = "none";
			}
		}
		if (this.timer) {
			clearInterval(this.timer);
		}
		this.timer = setInterval(dojo.lang.hitch(this, "_onTick"), 100);
	}
	this.showModalDialog();
	dojo.widget.Dialog.superclass.show.call(this);
}, onLoad:function () {
	this.placeModalDialog();
	dojo.widget.Dialog.superclass.onLoad.call(this);
}, fillInTemplate:function () {
}, hide:function () {
	this.hideModalDialog();
	dojo.widget.Dialog.superclass.hide.call(this);
	if (this.timer) {
		clearInterval(this.timer);
	}
}, setTimerNode:function (node) {
	this.timerNode = node;
}, setCloseControl:function (node) {
	this.closeNode = dojo.byId(node);
	dojo.event.connect(this.closeNode, "onclick", this, "hide");
}, setShowControl:function (node) {
	node = dojo.byId(node);
	dojo.event.connect(node, "onclick", this, "show");
}, _onTick:function () {
	if (this.timer) {
		this.timeRemaining -= 100;
		if (this.lifetime - this.timeRemaining >= this.blockDuration) {
			if (this.closeNode) {
				this.closeNode.style.visibility = "visible";
			}
		}
		if (!this.timeRemaining) {
			clearInterval(this.timer);
			this.hide();
		} else {
			if (this.timerNode) {
				this.timerNode.innerHTML = Math.ceil(this.timeRemaining / 1000);
			}
		}
	}
}});


__CPAN_FILE__ src/widget/Interne