# -*- perl -*-

# t/001_load.t - check module loading and create testing directory

use Test::More tests => 7;
use Cwd;

BEGIN { use_ok( 'Bio::Seq' ); }
BEGIN { use_ok( 'Bio::ORA' ); }


my $inseq = Bio::Seq->new(-seq => 'TACTTCTTGCTCTCCCACCTGGCCGTCATTGACATGTCCTATGCTTCAACAGTGTCCCCAAGATGCTGGCAAACTTGGTGAAGCAGAATAGAACCATCTCCTTTGTCCCGTGCATTATGCGACTTACTTGTATCTGGCCTTTGCTCACGCAGAGTGCCTGATTTTGGTGGTGATGTCTTATGATCGGTACGTGGCCATCTGCCACCCCCTCCATTACTCTGTCATCATGAGCTGGAGGGCATGCATGGTCCTGGTTGTCACTTCCTGGGTGTTTAGCTTCCTCCTGGCTCTGGTCCATGTGATTCTCATCCTGAGGCTCCCATTCTGCGGACCTCATGAAGTCAACCACTTCTTCTGTGAGCTCCTGTCTGTCCTCAGGCTGGCCTGCGCTGACACCAGGCTCAACCAGGTCGTCATCTTTGTTGCCTGTGTGCTTATCTTACCGGGGTCGCTCTGCCTGGTGCTGGTGTCCTACACATGCATCCTCCTCGCCATCCTGAGGATCCAGTCCGGGGAGGGCCGCAGGAAGGCCTTCTCCACCTGCTCCTCCCACCTCTGCGTGGTCGGGCTCTTCTTTGGCAGCGCCATCGTCATGTACATGAGCCCCAAGTCCCGCCATCCTGAGGAGCAGCAGAAGGTCCTGT', -alphabet => 'dna', -id => 'test');
isa_ok ($inseq, 'Bio::Seq');
if ( $inseq ) {
  my $ORA_obj = Bio::ORA->new( $inseq, undef, undef, getcwd() . '/scripts/or.hmm' );
  isa_ok ($ORA_obj, 'Bio::ORA');
  my $nb = $ORA_obj->find();
  ok ($nb);
  if ($nb) {
    ok( $ORA_obj->{'_hmmor'}[0] == 1.2e-101 );
    ok( ($ORA_obj->{'_result'}[2] - $ORA_obj->{'_result'}[1] + 1) == 540 );
  }
}
