/*
 * Decompiled with CFR 0.152.
 */
package org.ttt.salt.gui;

import java.awt.Toolkit;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;

public abstract class TBXAbstractAction
extends AbstractAction {
    public static final String RCSID = "$Id: TBXAbstractAction.java 1 2008-05-23 03:51:58Z lanhel $";
    protected static final Logger LOGGER = Logger.getLogger("org.ttt.salt.gui");
    private static ResourceBundle bundle;
    private static final Map<Class, TBXAbstractAction> ACTIONS;
    private static final Map<Class, Collection<TBXAbstractAction>> OBSERVABLE_TO_ACTIONS;

    public static void setResourceBundle(ResourceBundle bndl) {
        bundle = bndl;
    }

    public static Action getAction(Class clazz) {
        if (!ACTIONS.containsKey(clazz)) {
            try {
                Class[] ptype = new Class[]{};
                Object[] param = new Object[]{};
                Constructor init = clazz.getConstructor(ptype);
                TBXAbstractAction action = (TBXAbstractAction)init.newInstance(param);
                ACTIONS.put(action.getClass(), action);
                Class[] obs = action.getObservableClasses();
                for (int i = 0; i < obs.length; ++i) {
                    if (!OBSERVABLE_TO_ACTIONS.containsKey(obs[i])) {
                        OBSERVABLE_TO_ACTIONS.put(obs[i], new ArrayList());
                    }
                    Collection<TBXAbstractAction> c = OBSERVABLE_TO_ACTIONS.get(obs[i]);
                    c.add(action);
                }
            }
            catch (NoSuchMethodException err) {
                LOGGER.log(Level.SEVERE, "", err);
            }
            catch (IllegalAccessException err) {
                LOGGER.log(Level.SEVERE, "", err);
            }
            catch (InstantiationException err) {
                LOGGER.log(Level.SEVERE, "", err);
            }
            catch (InvocationTargetException err) {
                LOGGER.log(Level.SEVERE, "", err);
            }
        }
        return ACTIONS.get(clazz);
    }

    protected TBXAbstractAction(String id) {
        URL url;
        String smicon;
        this.putValue("ActionCommandKey", id);
        this.putValue("Name", bundle.getString(id));
        this.putValue("ShortDescription", bundle.getString(id + "ShortDescription"));
        this.putValue("LongDescription", bundle.getString(id + "LongDescription"));
        String accel = bundle.getString(id + "AcceleratorKey");
        if (accel != null && accel.length() > 0) {
            KeyStroke ret = KeyStroke.getKeyStroke(accel);
            int keycode = ret.getKeyCode();
            int mod = ret.getModifiers();
            if ((mod & 2) == 2) {
                int pmod = mod;
                pmod ^= 0xFFFFFFFD;
                if ((pmod &= Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != mod) {
                    ret = KeyStroke.getKeyStroke(keycode, pmod, true);
                }
            }
            this.putValue("AcceleratorKey", ret);
        }
        if (!System.getProperty("os.name").equals("Mac OS X")) {
            try {
                String mnemonic = bundle.getString(id + "Mnemonic");
                if (mnemonic != null && mnemonic.length() > 0) {
                    Integer ret = new Integer(mnemonic.charAt(0));
                    this.putValue("MnemonicKey", ret);
                }
            }
            catch (MissingResourceException err) {
                LOGGER.log(Level.FINE, "Mnemonic for {0} not found.", id);
            }
        }
        if ((smicon = bundle.getString(id + "SmallIcon")) != null && smicon.length() > 0 && (url = this.getClass().getClassLoader().getResource(smicon)) != null) {
            ImageIcon ret = new ImageIcon(url);
            this.putValue("SmallIcon", ret);
        }
    }

    protected ResourceBundle getResourceBundle() {
        return bundle;
    }

    protected Class[] getObservableClasses() {
        return new Class[0];
    }

    protected void linkToListenable(Class listenertype, Object obj) {
    }

    protected void unlinkFromListenable(Class listenertype, Object obj) {
    }

    public static void linkToListenerObjects(Class listenertype, Object obj) {
        Collection<TBXAbstractAction> c = OBSERVABLE_TO_ACTIONS.get(listenertype);
        if (c != null) {
            for (TBXAbstractAction a : c) {
                a.linkToListenable(listenertype, obj);
            }
        }
    }

    public static void unlinkFromListenerObjects(Class listenertype, Object obj) {
        Collection<TBXAbstractAction> c = OBSERVABLE_TO_ACTIONS.get(listenertype);
        if (c != null) {
            for (TBXAbstractAction a : c) {
                a.unlinkFromListenable(listenertype, obj);
            }
        }
    }

    static {
        ACTIONS = new HashMap<Class, TBXAbstractAction>();
        OBSERVABLE_TO_ACTIONS = new HashMap<Class, Collection<TBXAbstractAction>>();
    }
}

