/*
 * Decompiled with CFR 0.152.
 */
package org.ttt.salt.gui;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.UIManager;
import org.flyingtitans.util.GetOpt;
import org.ttt.salt.gui.Aqua;
import org.ttt.salt.gui.TBXValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Main {
    public static final String RCSID = "$Id: Main.java 45 2008-08-11 05:19:39Z lanhel $";
    private static final String OPTIONS = "h";
    private static final String[] LONG_OPTIONS = new String[]{"help", "version", "environment", "lang=", "country=", "variant="};
    private static Main instance;
    private final GetOpt options = new GetOpt();
    private final ResourceBundle bundle;
    private int fileCount;
    private boolean quit;

    public static void main(String[] argv) throws IOException {
        try {
            instance = new Main(argv);
            Main obj = Main.getInstance();
            obj.dispatch();
        }
        catch (SecurityException e) {
            System.err.println(e);
        }
        catch (Throwable e) {
            System.err.println(e);
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static Main getInstance() {
        return instance;
    }

    private Main(String[] argv) {
        try {
            this.options.parseArgs(argv, OPTIONS, LONG_OPTIONS);
            String lang = this.options.containsOption("--lang") ? this.options.getParameter("--lang") : Locale.getDefault().getLanguage();
            String country = this.options.containsOption("--country") ? this.options.getParameter("--country") : Locale.getDefault().getCountry();
            String variant = this.options.containsOption("--variant") ? this.options.getParameter("--variant") : Locale.getDefault().getVariant();
            Locale def = new Locale(lang, country, variant);
            Locale.setDefault(def);
        }
        catch (IllegalArgumentException e) {
            System.err.println("Illegal command line parameter.");
            System.err.println("Use -h for more information.");
            System.exit(2);
        }
        this.bundle = ResourceBundle.getBundle("org.ttt.salt.gui.Main", Locale.getDefault());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signalQuit() {
        if (!this.quit) {
            Main main = this;
            synchronized (main) {
                this.quit = true;
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatch() throws IOException {
        boolean exit = false;
        if (this.options.containsOption("-h") || this.options.containsOption("--help")) {
            System.out.println(this.bundle.getString("Usage"));
            exit = true;
        }
        if (this.options.containsOption("--version")) {
            String rcsidpat = "^\\$Id(: (\\S+) (\\d+) (\\d{4})-(\\d{2})-(\\d{2}) (\\d{2}):(\\d{2}):(\\d{2})Z (\\S+))?\\s*\\$$";
            Matcher matcher = Pattern.compile(rcsidpat).matcher(RCSID);
            if (matcher.matches() && matcher.group(1) != null) {
                String version = matcher.group(3);
                Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
                cal.set(Integer.parseInt(matcher.group(4)), Integer.parseInt(matcher.group(5)), Integer.parseInt(matcher.group(6)), Integer.parseInt(matcher.group(7)), Integer.parseInt(matcher.group(8)), Integer.parseInt(matcher.group(9)));
                String msg = this.bundle.getString("Version");
                System.out.println(MessageFormat.format(msg, matcher.group(3), cal.getTime()));
            } else {
                String msg = this.bundle.getString("VersionBad");
                System.out.println(MessageFormat.format(msg, RCSID));
            }
            exit = true;
        }
        if (this.options.containsOption("--environment")) {
            System.out.println("Arguments:");
            System.out.println("\t" + this.options);
            System.out.println();
            System.out.println("Environment:");
            String spaces = "                            ";
            TreeMap<Object, Object> env = new TreeMap<Object, Object>(System.getProperties());
            Iterator iter = env.keySet().iterator();
            while (iter.hasNext()) {
                String name = iter.next().toString();
                String value = env.get(name).toString();
                System.out.print(name);
                int pad = name.length() < spaces.length() ? name.length() : spaces.length() - 1;
                System.out.print(spaces.substring(pad));
                System.out.print("= ");
                System.out.println(value);
            }
            System.out.println();
        }
        if (exit) {
            System.exit(0);
        }
        this.checkSystem();
        this.initSystem();
        List<String> paths = Arrays.asList(this.options.getArgs());
        List<File> files = this.checkFiles(paths);
        TBXValidator.validateFiles(files);
        TBXValidator.getInstance().setVisible(true);
        Main main = this;
        synchronized (main) {
            boolean done = false;
            while (!done) {
                try {
                    while (!this.quit) {
                        this.wait();
                    }
                    done = TBXValidator.getInstance().closeAllWindows();
                    this.quit = false;
                }
                catch (InterruptedException err) {
                    Thread.interrupted();
                }
            }
            System.exit(0);
        }
    }

    private void checkSystem() {
    }

    private void initSystem() {
        try {
            if (System.getProperty("os.name").equals("Mac OS X")) {
                new Aqua();
            }
            String name = UIManager.getCrossPlatformLookAndFeelClassName();
            UIManager.setLookAndFeel(name);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private List<File> checkFiles(List<String> files) throws IOException {
        ArrayList<File> ret = new ArrayList<File>();
        ListIterator<String> paths = files.listIterator();
        while (paths.hasNext()) {
            String path = paths.next();
            File file = path.startsWith(File.separator) ? new File(path) : new File(System.getProperty("user.dir"), path);
            if (!file.exists()) {
                System.out.println("File does not exists: " + file);
                continue;
            }
            if (!file.canRead()) {
                System.out.println("Security violation: " + file);
                continue;
            }
            ret.add(file);
        }
        return ret;
    }
}

