/*
 * Decompiled with CFR 0.152.
 */
package org.flyingtitans.xml;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public class ElementalParser {
    public static final String RCSID = "$Id: ElementalParser.java 79 2008-11-01 01:55:12Z lanhel $";
    public Token type = Token.NONE;
    public String sval = "";
    private Reader reader;
    private int c;
    private final StringBuffer buf = new StringBuffer();

    public ElementalParser(InputStream in) throws IOException {
        if (!in.markSupported()) {
            in = new BufferedInputStream(in);
        }
        in.mark(16);
        int b0 = in.read();
        int b1 = in.read();
        in.reset();
        this.reader = b0 == 254 && b1 == 255 ? new InputStreamReader(in, "UTF-16") : new InputStreamReader(in, "UTF-8");
    }

    public ElementalParser(Reader rdr) throws IOException {
        this.reader = rdr;
    }

    public Token next() throws IOException {
        this.buf.setLength(0);
        this.read();
        if (this.c == -1 && this.sval.length() == 0) {
            this.type = Token.EOF;
        } else if (this.sval.startsWith("<?xml") && this.sval.endsWith("?>")) {
            this.type = Token.XMLDECL;
        } else if (this.sval.startsWith("<?") && this.sval.endsWith("?>")) {
            this.type = Token.PI;
        } else if (this.sval.startsWith("<?")) {
            this.type = Token.ILLFORMED;
        } else if (this.sval.startsWith("<!--")) {
            this.readToEndOfComment();
        } else if (this.sval.startsWith("<!DOCTYPE") && this.sval.endsWith(">")) {
            this.type = Token.DOCTYPEDECL;
        } else if (this.sval.startsWith("<![CDATA[")) {
            this.readToEndOfCDATA();
        } else {
            this.type = this.sval.startsWith("<!") ? Token.ILLFORMED : (this.sval.startsWith("</") && this.sval.endsWith(">") ? Token.END : (this.sval.startsWith("<") && this.sval.endsWith("/>") ? Token.EMPTY : (this.sval.startsWith("<") && this.sval.endsWith(">") ? Token.START : (this.sval.startsWith("<") ? Token.ILLFORMED : Token.CONTENT))));
        }
        return this.type;
    }

    private void read() throws IOException {
        if (this.c == 0) {
            this.c = this.reader.read();
        }
        if (this.c != -1) {
            int stop = this.c == 60 ? 62 : 60;
            this.buf.append((char)this.c);
            this.c = this.reader.read();
            while (this.c != -1 && this.c != stop) {
                this.buf.append((char)this.c);
                this.c = this.reader.read();
            }
            if (stop == 62) {
                this.buf.append('>');
                this.c = this.reader.read();
            }
        }
        this.sval = this.buf.toString();
    }

    private void readToEndOfComment() throws IOException {
        this.type = Token.COMMENT;
        while (this.c != -1 && !this.sval.endsWith("-->")) {
            while (this.c != -1 && this.c != 62) {
                this.buf.append((char)this.c);
                this.c = this.reader.read();
            }
            this.buf.append('>');
            this.c = this.reader.read();
            this.sval = this.buf.toString();
        }
        this.sval = this.buf.toString();
    }

    private void readToEndOfCDATA() throws IOException {
        this.type = Token.CDATA;
        while (this.c != -1 && !this.sval.endsWith("]]>")) {
            while (this.c != -1 && this.c != 62) {
                this.buf.append((char)this.c);
                this.c = this.reader.read();
            }
            this.buf.append('>');
            this.c = this.reader.read();
        }
        this.sval = this.buf.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Token {
        NONE,
        XMLDECL,
        COMMENT,
        PI,
        DOCTYPEDECL,
        CDATA,
        START,
        END,
        EMPTY,
        CONTENT,
        EOF,
        ILLFORMED;

    }
}

