/**
 * @defgroup workerframeenc Encodings
 * @ingroup workerframe
 * @brief Encoding tables for character set conversion.
 *
 * These files are all generated automatically by <code>build/gen_tables.pl</code>.
 *  
 * @copydoc copyrighttext
*/

/**
 * @file
 * @ingroup workerframeenc
 * @brief Dicop Project - Definition of character encodings, code pages, case folding and mappings
 * 
 * @english
 *
 * <b>This file has been automatically generated by <code>build/gen_tables.pl</code>.
 * Do not edit, all changes are lost!</b>
 *
 * @endenglish
 *
 * @deutsch
 *
 * <b>Diese Datei wurde automatisch generiert von <code>build/gen_tables.pl</code>.
 * Hier nicht editieren, da alle &Auml;nderungen verloren gehen!</b>
 *
 * @enddeutsch
 *  
 * @version 0.02 
 * @date Wed Aug 29 12:40:21 2007
 *  
 * @copydoc copyrighttext
*/

#ifndef DICOP_MAPPINGS_H
#define DICOP_MAPPINGS_H

#include "encoding/encodings.h"
#include "encoding/utf8.h"
#include "encoding/koi8_r.h"
#include "encoding/koi8_u.h"
#include "encoding/macroman.h"
#include "encoding/maccentraleurroman.h"
#include "encoding/macicelandic.h"
#include "encoding/maccroatian.h"
#include "encoding/macromanian.h"
#include "encoding/macrumanian.h"
#include "encoding/maccyrillic.h"
#include "encoding/macukrainian.h"
#include "encoding/macgreek.h"
#include "encoding/macturkish.h"
#include "encoding/macsami.h"
#include "encoding/cp1250.h"
#include "encoding/cp1251.h"
#include "encoding/cp1252.h"
#include "encoding/cp1253.h"
#include "encoding/cp1254.h"
#include "encoding/cp1255.h"
#include "encoding/cp1256.h"
#include "encoding/cp1257.h"
#include "encoding/cp1258.h"
#include "encoding/cp437.h"
#include "encoding/cp737.h"
#include "encoding/cp775.h"
#include "encoding/cp850.h"
#include "encoding/cp852.h"
#include "encoding/cp855.h"
#include "encoding/cp857.h"
#include "encoding/cp860.h"
#include "encoding/cp861.h"
#include "encoding/cp862.h"
#include "encoding/cp865.h"
#include "encoding/cp866.h"
#include "encoding/cp869.h"
#include "encoding/cp874.h"
#include "encoding/iso_8859_1.h"
#include "encoding/iso_8859_2.h"
#include "encoding/iso_8859_3.h"
#include "encoding/iso_8859_4.h"
#include "encoding/iso_8859_5.h"
#include "encoding/iso_8859_6.h"
#include "encoding/iso_8859_7.h"
#include "encoding/iso_8859_8.h"
#include "encoding/iso_8859_9.h"
#include "encoding/iso_8859_10.h"
#include "encoding/iso_8859_11.h"
#include "encoding/iso_8859_13.h"
#include "encoding/iso_8859_14.h"
#include "encoding/iso_8859_15.h"
#include "encoding/iso_8859_16.h"

const char _encoding_names[INVALID_ENCODING + 1][40] = {
  "ASCII",
  "ISO-8859-1 (Western European)",
  "ISO-8859-2 (Eastern European)",
  "ISO-8859-3 (Southern European)",
  "ISO-8859-4 (Baltic)",
  "ISO-8859-5 (Cyrillic)",
  "ISO-8859-6 (Arabic)",
  "ISO-8859-7 (Greek)",
  "ISO-8859-8 (Hebrew)",
  "ISO-8859-9 (Turkish)",
  "ISO-8859-10 (Nordic)",
  "ISO-8859-11 (Thai)",
  "ISO-8859-13 (Baltic Rim)",
  "ISO-8859-14 (Celtic)",
  "ISO-8859-15 (Western European)",
  "ISO-8859-16 (South-Eastern European)",
  "KOI8-R (Russian)",
  "KOI8-U (Ukrainian)",
  "CP437 (US)",
  "CP737 (Greek)",
  "CP775 (Baltic)",
  "CP850 (Western European)",
  "CP852 (Latin 2)",
  "CP855 (Cyrillic)",
  "CP857 (Turkish)",
  "CP858 (CP850 + Euro)",
  "CP860 (Portuguese)",
  "CP861 (Icelandic)",
  "CP862 (Hebrew)",
  "CP863 (French-Canadian)",
  "CP865 (Nordic)",
  "CP866 (Russian)",
  "CP869 (Greek)",
  "CP874 (Thai)",
  "CP1250 (Central European)",
  "CP1251 (Cyrillic)",
  "CP1252 (Western European)",
  "CP1253 (Greek)",
  "CP1254 (Turkish)",
  "CP1255 (Hebrew)",
  "CP1256 (Arabic)",
  "CP1257 (Baltic)",
  "CP1258 (Vietnam)",
  "MacRoman",
  "MacCentralEurRoman",
  "MacIcelandic",
  "MacCroatian",
  "MacRomanian",
  "MacRumanian",
  "MacCyrillic",
  "MacUkrainian",
  "MacGreek",
  "MacTurkish",
  "MacArabic",
  "MacFarsi",
  "MacSami",
  "MacHebrew",
  "UTF-8",
  "UTF-16",
  "UTF-16BE (big endian)",
  "UTF-16LE (little endian)",
  "UTF-32",
  "UTF-32BE (big endian)",
  "UTF-32LE (little endian)",
  "EUC-KISX0213",
  "Shift_JISX0213",
  "SHIFT_JIS",
  "HZ",
  "GBK",
  "GB18030",
  "CP950 (BIG5)",
  "BIG5-HKSCS (BIG5 Hongkong)",
  "invalid encoding"  };


/** Mapping Encoding to UTF-8 */
unsigned long* encoding_mappings[INVALID_ENCODING + 1] = {
  NULL,			/* ASCII */
  enc_iso_8859_1,
  enc_iso_8859_2,
  enc_iso_8859_3,
  enc_iso_8859_4,
  enc_iso_8859_5,
  enc_iso_8859_6,
  enc_iso_8859_7,
  enc_iso_8859_8,
  enc_iso_8859_9,
  enc_iso_8859_10,
  enc_iso_8859_11,
  enc_iso_8859_13,
  enc_iso_8859_14,
  enc_iso_8859_15,
  enc_iso_8859_16,
  enc_koi8_r,
  enc_koi8_u,
  enc_cp437,
  enc_cp737,
  enc_cp775,
  enc_cp850,
  enc_cp852,
  enc_cp855,
  enc_cp857,
  NULL,			/* CP858 (CP850 + Euro) */
  enc_cp860,
  enc_cp861,
  enc_cp862,
  NULL,			/* CP863 (French-Canadian) */
  enc_cp865,
  enc_cp866,
  enc_cp869,
  enc_cp874,
  enc_cp1250,
  enc_cp1251,
  enc_cp1252,
  enc_cp1253,
  enc_cp1254,
  enc_cp1255,
  enc_cp1256,
  enc_cp1257,
  enc_cp1258,
  enc_macroman,
  enc_maccentraleurroman,
  enc_macicelandic,
  enc_maccroatian,
  enc_macromanian,
  enc_macrumanian,
  enc_maccyrillic,
  enc_macukrainian,
  enc_macgreek,
  enc_macturkish,
  NULL,			/* MacArabic */
  NULL,			/* MacFarsi */
  enc_macsami,
  NULL,			/* MacHebrew */
  NULL,			/* UTF-8 */
  NULL,			/* UTF-16 */
  NULL,			/* UTF-16BE (big endian) */
  NULL,			/* UTF-16LE (little endian) */
  NULL,			/* UTF-32 */
  NULL,			/* UTF-32BE (big endian) */
  NULL,			/* UTF-32LE (little endian) */
  NULL,			/* EUC-KISX0213 */
  NULL,			/* Shift_JISX0213 */
  NULL,			/* SHIFT_JIS */
  NULL,			/* HZ */
  NULL,			/* GBK */
  NULL,			/* GB18030 */
  NULL,			/* CP950 (BIG5) */
  NULL,			/* BIG5-HKSCS (BIG5 Hongkong) */
  NULL,			/* invalid encoding */
  };

/** Mapping UTF-8 to Encoding */
unsigned long* encoding_tables[INVALID_ENCODING+1] = {
  NULL,			/* ASCII */
  encoding_iso_8859_1,
  encoding_iso_8859_2,
  encoding_iso_8859_3,
  encoding_iso_8859_4,
  encoding_iso_8859_5,
  encoding_iso_8859_6,
  encoding_iso_8859_7,
  encoding_iso_8859_8,
  encoding_iso_8859_9,
  encoding_iso_8859_10,
  encoding_iso_8859_11,
  encoding_iso_8859_13,
  encoding_iso_8859_14,
  encoding_iso_8859_15,
  encoding_iso_8859_16,
  encoding_koi8_r,
  encoding_koi8_u,
  encoding_cp437,
  encoding_cp737,
  encoding_cp775,
  encoding_cp850,
  encoding_cp852,
  encoding_cp855,
  encoding_cp857,
  NULL,			/* CP858 (CP850 + Euro) */
  encoding_cp860,
  encoding_cp861,
  encoding_cp862,
  NULL,			/* CP863 (French-Canadian) */
  encoding_cp865,
  encoding_cp866,
  encoding_cp869,
  encoding_cp874,
  encoding_cp1250,
  encoding_cp1251,
  encoding_cp1252,
  encoding_cp1253,
  encoding_cp1254,
  encoding_cp1255,
  encoding_cp1256,
  encoding_cp1257,
  encoding_cp1258,
  encoding_macroman,
  encoding_maccentraleurroman,
  encoding_macicelandic,
  encoding_maccroatian,
  encoding_macromanian,
  encoding_macrumanian,
  encoding_maccyrillic,
  encoding_macukrainian,
  encoding_macgreek,
  encoding_macturkish,
  NULL,			/* MacArabic */
  NULL,			/* MacFarsi */
  encoding_macsami,
  NULL,			/* MacHebrew */
  NULL,			/* UTF-8 */
  NULL,			/* UTF-16 */
  NULL,			/* UTF-16BE (big endian) */
  NULL,			/* UTF-16LE (little endian) */
  NULL,			/* UTF-32 */
  NULL,			/* UTF-32BE (big endian) */
  NULL,			/* UTF-32LE (little endian) */
  NULL,			/* EUC-KISX0213 */
  NULL,			/* Shift_JISX0213 */
  NULL,			/* SHIFT_JIS */
  NULL,			/* HZ */
  NULL,			/* GBK */
  NULL,			/* GB18030 */
  NULL,			/* CP950 (BIG5) */
  NULL,			/* BIG5-HKSCS (BIG5 Hongkong) */
  NULL,			/* invalid encoding */
  };

/** Mapping to Unicode codepoint */
unsigned long* codepoint_tables[INVALID_ENCODING+1] = {
  NULL,			/* ASCII */
  cp_iso_8859_1,
  cp_iso_8859_2,
  cp_iso_8859_3,
  cp_iso_8859_4,
  cp_iso_8859_5,
  cp_iso_8859_6,
  cp_iso_8859_7,
  cp_iso_8859_8,
  cp_iso_8859_9,
  cp_iso_8859_10,
  cp_iso_8859_11,
  cp_iso_8859_13,
  cp_iso_8859_14,
  cp_iso_8859_15,
  cp_iso_8859_16,
  cp_koi8_r,
  cp_koi8_u,
  cp_cp437,
  cp_cp737,
  cp_cp775,
  cp_cp850,
  cp_cp852,
  cp_cp855,
  cp_cp857,
  NULL,			/* CP858 (CP850 + Euro) */
  cp_cp860,
  cp_cp861,
  cp_cp862,
  NULL,			/* CP863 (French-Canadian) */
  cp_cp865,
  cp_cp866,
  cp_cp869,
  cp_cp874,
  cp_cp1250,
  cp_cp1251,
  cp_cp1252,
  cp_cp1253,
  cp_cp1254,
  cp_cp1255,
  cp_cp1256,
  cp_cp1257,
  cp_cp1258,
  cp_macroman,
  cp_maccentraleurroman,
  cp_macicelandic,
  cp_maccroatian,
  cp_macromanian,
  cp_macrumanian,
  cp_maccyrillic,
  cp_macukrainian,
  cp_macgreek,
  cp_macturkish,
  NULL,			/* MacArabic */
  NULL,			/* MacFarsi */
  cp_macsami,
  NULL,			/* MacHebrew */
  NULL,			/* UTF-8 */
  NULL,			/* UTF-16 */
  NULL,			/* UTF-16BE (big endian) */
  NULL,			/* UTF-16LE (little endian) */
  NULL,			/* UTF-32 */
  NULL,			/* UTF-32BE (big endian) */
  NULL,			/* UTF-32LE (little endian) */
  NULL,			/* EUC-KISX0213 */
  NULL,			/* Shift_JISX0213 */
  NULL,			/* SHIFT_JIS */
  NULL,			/* HZ */
  NULL,			/* GBK */
  NULL,			/* GB18030 */
  NULL,			/* CP950 (BIG5) */
  NULL,			/* BIG5-HKSCS (BIG5 Hongkong) */
  NULL,			/* invalid encoding */
  };

/** Mapping to UPPERCASE */
unsigned char* uppercase_tables[INVALID_ENCODING+1] = {
  NULL,			/* ASCII */
  uc_iso_8859_1,
  uc_iso_8859_2,
  uc_iso_8859_3,
  uc_iso_8859_4,
  uc_iso_8859_5,
  uc_iso_8859_6,
  uc_iso_8859_7,
  uc_iso_8859_8,
  uc_iso_8859_9,
  uc_iso_8859_10,
  uc_iso_8859_11,
  uc_iso_8859_13,
  uc_iso_8859_14,
  uc_iso_8859_15,
  uc_iso_8859_16,
  uc_koi8_r,
  uc_koi8_u,
  uc_cp437,
  uc_cp737,
  uc_cp775,
  uc_cp850,
  uc_cp852,
  uc_cp855,
  uc_cp857,
  NULL,			/* CP858 (CP850 + Euro) */
  uc_cp860,
  uc_cp861,
  uc_cp862,
  NULL,			/* CP863 (French-Canadian) */
  uc_cp865,
  uc_cp866,
  uc_cp869,
  uc_cp874,
  uc_cp1250,
  uc_cp1251,
  uc_cp1252,
  uc_cp1253,
  uc_cp1254,
  uc_cp1255,
  uc_cp1256,
  uc_cp1257,
  uc_cp1258,
  uc_macroman,
  uc_maccentraleurroman,
  uc_macicelandic,
  uc_maccroatian,
  uc_macromanian,
  uc_macrumanian,
  uc_maccyrillic,
  uc_macukrainian,
  uc_macgreek,
  uc_macturkish,
  NULL,			/* MacArabic */
  NULL,			/* MacFarsi */
  uc_macsami,
  NULL,			/* MacHebrew */
  NULL,			/* UTF-8 */
  NULL,			/* UTF-16 */
  NULL,			/* UTF-16BE (big endian) */
  NULL,			/* UTF-16LE (little endian) */
  NULL,			/* UTF-32 */
  NULL,			/* UTF-32BE (big endian) */
  NULL,			/* UTF-32LE (little endian) */
  NULL,			/* EUC-KISX0213 */
  NULL,			/* Shift_JISX0213 */
  NULL,			/* SHIFT_JIS */
  NULL,			/* HZ */
  NULL,			/* GBK */
  NULL,			/* GB18030 */
  NULL,			/* CP950 (BIG5) */
  NULL,			/* BIG5-HKSCS (BIG5 Hongkong) */
  NULL,			/* invalid encoding */
  };

/** Mapping to lowercase */
unsigned char* lowercase_tables[INVALID_ENCODING+1] = {
  NULL,			/* ASCII */
  lc_iso_8859_1,
  lc_iso_8859_2,
  lc_iso_8859_3,
  lc_iso_8859_4,
  lc_iso_8859_5,
  lc_iso_8859_6,
  lc_iso_8859_7,
  lc_iso_8859_8,
  lc_iso_8859_9,
  lc_iso_8859_10,
  lc_iso_8859_11,
  lc_iso_8859_13,
  lc_iso_8859_14,
  lc_iso_8859_15,
  lc_iso_8859_16,
  lc_koi8_r,
  lc_koi8_u,
  lc_cp437,
  lc_cp737,
  lc_cp775,
  lc_cp850,
  lc_cp852,
  lc_cp855,
  lc_cp857,
  NULL,			/* CP858 (CP850 + Euro) */
  lc_cp860,
  lc_cp861,
  lc_cp862,
  NULL,			/* CP863 (French-Canadian) */
  lc_cp865,
  lc_cp866,
  lc_cp869,
  lc_cp874,
  lc_cp1250,
  lc_cp1251,
  lc_cp1252,
  lc_cp1253,
  lc_cp1254,
  lc_cp1255,
  lc_cp1256,
  lc_cp1257,
  lc_cp1258,
  lc_macroman,
  lc_maccentraleurroman,
  lc_macicelandic,
  lc_maccroatian,
  lc_macromanian,
  lc_macrumanian,
  lc_maccyrillic,
  lc_macukrainian,
  lc_macgreek,
  lc_macturkish,
  NULL,			/* MacArabic */
  NULL,			/* MacFarsi */
  lc_macsami,
  NULL,			/* MacHebrew */
  NULL,			/* UTF-8 */
  NULL,			/* UTF-16 */
  NULL,			/* UTF-16BE (big endian) */
  NULL,			/* UTF-16LE (little endian) */
  NULL,			/* UTF-32 */
  NULL,			/* UTF-32BE (big endian) */
  NULL,			/* UTF-32LE (little endian) */
  NULL,			/* EUC-KISX0213 */
  NULL,			/* Shift_JISX0213 */
  NULL,			/* SHIFT_JIS */
  NULL,			/* HZ */
  NULL,			/* GBK */
  NULL,			/* GB18030 */
  NULL,			/* CP950 (BIG5) */
  NULL,			/* BIG5-HKSCS (BIG5 Hongkong) */
  NULL,			/* invalid encoding */
  };

#endif
