#!/usr/bin/perl
use strict;
use warnings;
use DR::SAP;
use DR::SAP::WSDL::VendorMaintenance;
use Try::Tiny;
use HTTP::Response;
use Test::More qw(no_plan);

DR::SAP::WSDL::VendorMaintenance->initialize(file => 'share/VendorMaintenance.wsdl');
my $sap = DR::SAP->new(username => 'PIRMSSU', password => 'Digital123');
$sap->transport_hook(transport_hook());
my $trace;
try {
	my $response = $sap->display_vendor(
		platform_id      => 'RW',
		platform_account => 'v27877',
		account_group    => 'vendor',
	);
	isa_ok($response->vendor, 'DR::SAP::Data::Vendor', '$response->vendor');
	$trace = $response->trace;
} catch {
	diag $_;
	$trace = $sap->trace;
};
set_case('missing');
try {
	my $response = $sap->display_vendor(
		platform_id      => 'RW',
		platform_account => 'v27877',
		account_group    => 'vendor',
	);
	ok ! $response->vendor, 'no vendor returned';
	diag explain $response->messages;
	$trace = $response->trace;
} catch {
	diag $_;
	$trace = $sap->trace;
};

CHECK {
	my $xml = parse_xml();
	my $CASE = 'default';

	sub set_case {
		$CASE = shift;
	}

	sub transport_hook {
		set_case(@_) if(@_);
		return sub {
			my ( $request, $trace ) = @_;
			my $content = $request->decoded_content;
			is( $content, $xml->{$CASE}->{REQUEST}, qq("$CASE" request translated as expected") );
			return HTTP::Response->new( 200, 'Constant', [ 'Content-Type' => 'text/xml' ], $xml->{$CASE}->{RESPONSE} );
		};

	}
}

sub parse_xml {
	my @data = <DATA>;
	my($all,$case,$phase);
	while(@data){
		my $l = shift @data;
		if ( $l =~ m/^# (?:(.+?): )?(REQUEST|RESPONSE)$/ ) {
			$case = $1 || 'default';
			$phase = $2;
		} elsif($l =~ m/^$/){
			next;
		} elsif($case && $phase){
			($all->{$case}->{$phase} ||= '') .= $l
		}
	}
	return $all;
}

__DATA__
# default: REQUEST
<?xml version="1.0" encoding="UTF-8"?>
<SOAP-ENV:Envelope xmlns:SOAP-ENV="http://schemas.xmlsoap.org/soap/envelope/"><SOAP-ENV:Body><p2:VENDOR_MAINTENANCE xmlns:p2="http://itasca.digitalriver.com/ECC/VendorMaintenance"><ZTRANSTYPE>D</ZTRANSTYPE><ZPLATFORMID>RW</ZPLATFORMID><ZPLATFORMACCT>v27877</ZPLATFORMACCT><ZACCOUNTGROUP>ZCLN</ZACCOUNTGROUP><ZCOMPCODE></ZCOMPCODE><ZPURCHORG>1000</ZPURCHORG></p2:VENDOR_MAINTENANCE></SOAP-ENV:Body></SOAP-ENV:Envelope>
# default: RESPONSE
<SOAP:Envelope xmlns:SOAP='http://schemas.xmlsoap.org/soap/envelope/'><SOAP:Header/><SOAP:Body><n0:VENDOR_MAINTENANCE xmlns:n0='http://itasca.digitalriver.com/ECC/VendorMaintenance' xmlns:prx='urn:sap.com:proxy:HCD:/1SAI/TASFEB69AE3BBDD387C7F03:700:2008/06/25'><ZTRANSTYPE>D</ZTRANSTYPE><ZPLATFORMID>RW</ZPLATFORMID><ZPLATFORMACCT>v27877</ZPLATFORMACCT><ZACCOUNTGROUP>ZCLN</ZACCOUNTGROUP><ZCOMPCODE>1220</ZCOMPCODE><ZPURCHORG>1000</ZPURCHORG><ZVENDORNAME>Jerel Co</ZVENDORNAME><ZSTREET>862 Pascal Street</ZSTREET><ZOTHERADDR01>NULL</ZOTHERADDR01><ZPOBOX>NULL</ZPOBOX><ZCITY>Saint Paul</ZCITY><ZCOUNTRY>US</ZCOUNTRY><ZREGION>MN</ZREGION><ZPOSTALCODE>55104</ZPOSTALCODE><ZVATREG>NULL</ZVATREG><ZTIN>NULL</ZTIN><ZWEBURL>http://www.cratestreet.com</ZWEBURL><ZPAYTHRESHOLD>NULL</ZPAYTHRESHOLD><ZPRINTLOGO>0</ZPRINTLOGO><ZPAYMODE>AUTO</ZPAYMODE><ZMAINCONTACT>JEREL THOMPSON</ZMAINCONTACT><ZMAINEMAIL>jthompson2@digitalriver.com</ZMAINEMAIL><ZBIZCONTACT>NULL</ZBIZCONTACT><ZSALESCONTACT>jthompson2@digitalriver.com</ZSALESCONTACT><ZKEYGENCONTACT>NULL</ZKEYGENCONTACT><ZPAYCONTACT>NULL</ZPAYCONTACT><ZREMITCONTACT>NULL</ZREMITCONTACT><ZPHONE>262 914 8500</ZPHONE><ZFAX>NULL</ZFAX><ZPAYCURR>USD</ZPAYCURR><ZSETTLEMENTCURRENCY>USD</ZSETTLEMENTCURRENCY><ZPAYMETHOD>F</ZPAYMETHOD><ZPAYTERMS>0013</ZPAYTERMS><ZEPASSPORT_WEBMONEY>NULL</ZEPASSPORT_WEBMONEY><ZSKIPCHKRUN>NULL</ZSKIPCHKRUN><BANK><ZBANKACCTHOLDER>NULL</ZBANKACCTHOLDER><ZIBAN>NULL</ZIBAN><ZACCTNUM>NULL</ZACCTNUM><ZSWIFT>NULL</ZSWIFT><ZROUTING>NULL</ZROUTING><ZSORTCODE>NULL</ZSORTCODE><ZBANKNAME>NULL</ZBANKNAME><ZBANKADDR01>NULL</ZBANKADDR01><ZBANKADDR02>NULL</ZBANKADDR02><ZBANKCITY>NULL</ZBANKCITY><ZBANKREGION>NULL</ZBANKREGION><ZBANKPOSTCODE>NULL</ZBANKPOSTCODE><ZBANKCOUNTRY>NULL</ZBANKCOUNTRY><ZBANKCOMMENT>NULL</ZBANKCOMMENT></BANK><INTER_BANK><ZSWIFT>NULL</ZSWIFT><ZROUTING>NULL</ZROUTING><ZSORTCODE>NULL</ZSORTCODE><ZBANKNAME>NULL</ZBANKNAME><ZBANKADDR01>NULL</ZBANKADDR01><ZBANKADDR02>NULL</ZBANKADDR02><ZBANKCITY>NULL</ZBANKCITY><ZBANKREGION>NULL</ZBANKREGION><ZBANKPOSTCODE>NULL</ZBANKPOSTCODE><ZBANKCOUNTRY>NULL</ZBANKCOUNTRY></INTER_BANK><ZCHECKSUM>NULL</ZCHECKSUM></n0:VENDOR_MAINTENANCE></SOAP:Body></SOAP:Envelope>
# missing: REQUEST
<?xml version="1.0" encoding="UTF-8"?>
<SOAP-ENV:Envelope xmlns:SOAP-ENV="http://schemas.xmlsoap.org/soap/envelope/"><SOAP-ENV:Body><p2:VENDOR_MAINTENANCE xmlns:p2="http://itasca.digitalriver.com/ECC/VendorMaintenance"><ZTRANSTYPE>D</ZTRANSTYPE><ZPLATFORMID>RW</ZPLATFORMID><ZPLATFORMACCT>v27877</ZPLATFORMACCT><ZACCOUNTGROUP>ZCLN</ZACCOUNTGROUP><ZCOMPCODE></ZCOMPCODE><ZPURCHORG>1000</ZPURCHORG></p2:VENDOR_MAINTENANCE></SOAP-ENV:Body></SOAP-ENV:Envelope>
# missing: RESPONSE
<SOAP:Envelope xmlns:SOAP='http://schemas.xmlsoap.org/soap/envelope/'><SOAP:Header/><SOAP:Body><n0:VENDOR_MAINTENANCE xmlns:n0='http://itasca.digitalriver.com/ECC/VendorMaintenance'
xmlns:prx='urn:sap.com:proxy:HCD:/1SAI/TAEFEB69AE3BBDD387C7F03:700:2008/06/25'><ZTRANSTYPE>D</ZTRANSTYPE><ZPLATFORMID>RW</ZPLATFORMID><ZPLATFORMACCT>v5455555</ZPLATFORMACCT><ZACCOUNTGROUP>NULL</ZACCOUNTGROUP><ZCOMPCODE>NULL</ZCOMPCODE><ZPURCHORG>1000</ZPURCHORG><ZVENDORNAME>NULL</ZVENDORNAME><ZSTREET>NULL</ZSTREET><ZOTHERADDR01>NULL</ZOTHERADDR01><ZPOBOX>NULL</ZPOBOX><ZCITY>NULL</ZCITY><ZCOUNTRY>NUL</ZCOUNTRY><ZREGION>NULL</ZREGION><ZPOSTALCODE>NULL</ZPOSTALCODE><ZVATREG>NULL</ZVATREG><ZTIN>NULL</ZTIN><ZWEBURL>NULL</ZWEBURL><ZPAYTHRESHOLD>NULL</ZPAYTHRESHOLD><ZPRINTLOGO>NULL</ZPRINTLOGO><ZPAYMODE>NULL</ZPAYMODE><ZMAINCONTACT>NULL</ZMAINCONTACT><ZMAINEMAIL>NULL</ZMAINEMAIL><ZBIZCONTACT>NULL</ZBIZCONTACT><ZSALESCONTACT>NULL</ZSALESCONTACT><ZKEYGENCONTACT>NULL</ZKEYGENCONTACT><ZPAYCONTACT>NULL</ZPAYCONTACT><ZREMITCONTACT>NULL</ZREMITCONTACT><ZPHONE>NULL</ZPHONE><ZFAX>NULL</ZFAX><ZPAYCURR>NULL</ZPAYCURR><ZSETTLEMENTCURRENCY>NULL</ZSETTLEMENTCURRENCY><ZPAYMETHOD>NULL</ZPAYMETHOD><ZPAYTERMS>NULL</ZPAYTERMS><ZEPASSPORT_WEBMONEY>NULL</ZEPASSPORT_WEBMONEY><ZSKIPCHKRUN>NULL</ZSKIPCHKRUN><BANK><ZBANKACCTHOLDER>NULL</ZBANKACCTHOLDER><ZIBAN>NULL</ZIBAN><ZACCTNUM>NULL</ZACCTNUM><ZSWIFT>NULL</ZSWIFT><ZROUTING>NULL</ZROUTING><ZSORTCODE>NULL</ZSORTCODE><ZBANKNAME>NULL</ZBANKNAME><ZBANKADDR01>NULL</ZBANKADDR01><ZBANKADDR02>NULL</ZBANKADDR02><ZBANKCITY>NULL</ZBANKCITY><ZBANKREGION>NULL</ZBANKREGION><ZBANKPOSTCODE>NULL</ZBANKPOSTCODE><ZBANKCOUNTRY>NULL</ZBANKCOUNTRY><ZBANKCOMMENT>NULL</ZBANKCOMMENT></BANK><INTER_BANK><ZSWIFT>NULL</ZSWIFT><ZROUTING>NULL</ZROUTING><ZSORTCODE>NULL</ZSORTCODE><ZBANKNAME>NULL</ZBANKNAME><ZBANKADDR01>NULL</ZBANKADDR01><ZBANKADDR02>NULL</ZBANKADDR02><ZBANKCITY>NULL</ZBANKCITY><ZBANKREGION>NULL</ZBANKREGION><ZBANKPOSTCODE>NULL</ZBANKPOSTCODE><ZBANKCOUNTRY>NULL</ZBANKCOUNTRY></INTER_BANK><ZCHECKSUM>NULL</ZCHECKSUM><ZGLOBALMSG><TYPE>E</TYPE><ID>ZW</ID><NUMBER>030</NUMBER><MESSAGE>Vendor does not exist.</MESSAGE></ZGLOBALMSG></n0:VENDOR_MAINTENANCE></SOAP:Body></SOAP:Envelope>
