package Acme::MetaSyntactic::pm_groups;
use strict;
use Acme::MetaSyntactic::List;
our @ISA = qw( Acme::MetaSyntactic::List );
__PACKAGE__->init();

our %Remote = (
    source  => 'http://www.pm.org/groups/perl_mongers.xml',
    extract => sub {
        return
            map { Acme::MetaSyntactic::RemoteList::tr_nonword($_) }
            map { s/#/Pound_/g; $_ }
            $_[0] =~ m!<group id="\d+" status="active">\s*<name>\s*([^<]+)\s*</nam!g;
    },
);

1;

=head1 NAME

Acme::MetaSyntactic::pm_groups - The Perl Mongers groups theme

=head1 DESCRIPTION

List all the B<active> Perl Mongers groups, as described in the master
Perl Mongers file L<http://www.pm.org/groups/perl_mongers.xml>.

=head1 CONTRIBUTOR

Philippe "BooK" Bruhat

Introduced in version 0.49, published on November 21, 2005.

=head1 SEE ALSO

L<Acme::MetaSyntactic>, L<Acme::MetaSyntactic::List>.

=cut

__DATA__
# names
Albany_pm
Albuquerque_pm
Anchorage_pm
AnnArbor_pm
AOL_pm
Atlanta_pm
Austin_pm
Baltimore_pm
Boston_pm
Boulder_pm
Cambridge_pm
Champaign_Urbana_pm
Charlotte_pm
Chicago_pm
CGI_pm
DFW_pm
Dayton_pm
DC_pm
DesMoines_pm
Detroit_pm
Gainesville_pm
GrandRapids_pm
Harrisburg_pm
Hartford_pm
HudsonValley_pm
Humboldt_pm
Houston_pm
Jacksonville_pm
JPL_pm
Knoxville_pm
KansasCity_pm
LasVegas_pm
Lexington_pm
Miami_pm
Milwaukee_pm
Minneapolis_pm
Montr_eacute_al_pm
Omaha_pm
OrangeCounty_pm
Philadelphia_pm
Phoenix_pm
PikesPeak_pm
Pittsburgh_pm
PDX_pm
Raleigh_pm
RhodeIsland_pm
Rochester_pm
SanAntonio_pm
SanDiego_pm
SanFrancisco_pm
Seattle_pm
Sonoma_pm
StLouis_pm
TampaBay_pm
Tallahassee_pm
ThousandOaks_pm
Toronto_pm
Vancouver_pm
Winnipeg_pm
Sao_Paulo_pm
Aarhus_pm
Amsterdam_pm
Bath_pm
Belfast_pm
Braga_pm
Edinburgh_pm
Glasgow_pm
Goteborg_pm
Copenhagen_pm
Lisbon_pm
London_pm
Lund_pm
Moscow_pm
Munich_pm
Paris_pm
Porto_pm
Roma_pm
Stockholm_pm
Vienna_pm
Auckland_pm
Brisbane_pm
CentralCoast_pm
Malaysia_pm
Melbourne_pm
Perth_pm
Sydney_pm
Bangkok_pm
Delhi_pm
HongKong_pm
Pune_pm
Tokyo_pm
Israel_pm
Algarve_pm
Oxford_pm
Lawton_pm
Columbia_pm
Guimaraes_pm
Sofia_pm
Caracas_pm
Cola_pm
Bangalore_pm
Oslo_pm
Madrid_pm
PortoAlegre_pm
Budapest_pm
Purdue_pm
Frankfurt_pm
Richmond_pm
HamptonRoads_pm
Istanbul_pm
Tijuana_pm
Kolkata_pm
NewOrleans_pm
Kansai_pm
Aalesund_pm
OklahomaCity_pm
Madras_pm
Burnaby_pm
Granada_pm
Seneca_pm
Ulm_pm
Rio_pm
Taipei_pm
Los_Angeles_pm
Athens_pm
NWArkansas_pm
Oakland_pm
Birmingham_pm
Bloomington_Normal_pm
Colombo_pm
Bangsar_pm
RenoTahoe_pm
NCSU_pm
Toulouse_pm
Niederrhein_pm
Izmir_pm
kraljevo_pm
iran_pm
Taichung_pm
Barcelona_pm
Tyneside_pm
Santa_Fe_Los_Alamos_pm
Victoria_pm
Rousse_pm
Brasilia_pm
Wellington_pm
Marseille_pm
Oeiras_pm
StPaul_pm
Prague_pm
ValleKas_pm
ValleyPerl_pm
Guadalajara_pm
Dublin_pm
Morris_County_pm
Berlin_pm
Tulsa_pm
WestTexas_pm
Bologna_pm
Clemson_pm
Shadrinsk_pm
Rioja_pm
WYPUG_pm
Jogja_pm
stttelkom_pm
Nordest_pm
CaFe_pm
SiouxLand_pm
Malaga_pm
Tucson_pm
Devon_and_Cornwall_pm
CostaRica_pm
Nomads_pm
Lyon_pm
Basel_pm
DBI_pm
PerlSemNY_pm
Bruxelles_pm
SouthFlorida_pm
CAMEL_pm
Belgrade_pm
bali_pm
Yuma_pm
Zurich_pm
China_pm
Fortaleza_pm
Boise_pm
Destin_pm
NEPenn_pm
Gabrovo_pm
Bucharest_pm
WhiteMountain_pm
NH_pm
Kaohsiung_pm
Depok_pm
Mignon_pm
Alphen_pm
kw_pm
SpringfieldMO_pm
Canberra_pm
Terere_pm
Dresden_pm
Leuven_pm
Maine_pm
Cologne_pm
Hamburg_pm
Iassy_pm
Cascavel_pm
Guatemala_pm
Helsingborg_pm
Csy_pm
Lebanon_pm
Calgary_pm
SWOK_pm
Galicia_pm
Buffalo_pm
Vlaanderen_pm
NewCastle_pm
ZA_pm
Jalisco_pm
Saarland_pm
Shibuya_pm
German_pm
Kiel_pm
Camelot_pm
Malazgirt_pm
KernCounty_pm
Africa_pm
Princeton_pm
Pisa_pm
LagunaNiguel_pm
PhPerl_pm
Dominican_Republic_pm
Recife_pm
arnhem_pm
Thane_pm
Stuttgart_pm
Brasil_pm
torino_pm
Oegstgeest_pm
salerno_pm
Gombe_pm
dahut_pm
Orlando_pm
ClassicCity_pm
Northfield_pm
Samara_pm
SantoDomingo_pm
Jakarta_pm
Roederbergweg_pm
Mexico_pm
Korean_Perl_User_Group_pm
may_pm
Valladolid_pm
Kamloops_pm
Pakistan_pm
tutorial_pm_org_pm
austria_marchfeld_pm
JERL_pm
rubbercity_pm
Bielefeld_pm
Cedar_Valley_Perl_Mongers_pm
aalborg_pm
plovdiv_pm
Tempe_East_Valley_Perlmongers_pm
kampala_pm
StonyBrook_pm
Maracaibo_pm
LA_Belle_pm
ooubafsan_pm
ph_pm
hanoi_pm
Sri_Lanka_pm
ABE_pm
mytutorial_pm
Mk_pm
mississippi_pm
Angola_pm
NE_Oklahoma_Perl_Users_Group_pm
Nottingham_pm
Yerevan_pm
nova_pm
Eindhoven_pm
turkperl_pm
Jerusalem_pm
Vitoria_pm
cypriots_pm
ankara_pm
italia_pm
Geneva_pm
Aarau_pm
Cascais_pm
Ljubljana_pm
Belem_pm
Aberdeen_pm
Paderborn_pm
Campinas_pm
BH_pm
Argentina_pm
brazosvalley_pm
groningen_pm
innsbruck_pm
Santiago_pm
Pound_Perl_pm
Erlangen_pm
Viana_pm
Salvador_pm
Taubate_pm
Lafayette_pm
Amiga_pm
Charleston_pm
Asheville_pm
Chemnitz_pm
MiltonKeynes_pm
