/*
    This file was generated by the command

       cfunctions similar-image.c

    at 23:43:00 on Wednesday 17 February 2016, local time.
*/
#ifndef CFH_SIMILAR_IMAGE_H
#define CFH_SIMILAR_IMAGE_H

/* From 'similar-image.c': */

#line 10 "similar-image.c"
typedef struct point {
    double average_grey_level;
    int d[8];
}
point_t;
#define SIZE 9
typedef struct simage {
    /* The width of the image in pixels. */
    unsigned int width;
    /* The height of the image in pixels. */
    unsigned int height;
    /* The image data. */
    unsigned char * data;
    /* The P-value for this image, see equation in article. */
    unsigned int p;
    /* The grid of values. */
    point_t grid[SIZE*SIZE];
    double w10;
    double h10;
}
simage_t;
typedef enum {
    simage_ok,
    /* malloc failed. */
    simage_memory_failure,
    /* x or y is outside the image dimensions. */
    simage_status_bounds,
simage_status_bad_image,
}
simage_status_t;
typedef enum {
    much_darker = -2,
    darker = -1,
    same = 0,
    lighter = 1,
    much_lighter = 2,
}
comparison_t;

#line 84 "similar-image.c"
int x_y_to_entry (int x , int y );

#line 102 "similar-image.c"
simage_status_t simage_dump (simage_t * s );

#line 114 "similar-image.c"
simage_status_t simage_init (simage_t * s , unsigned int width , unsigned int height );

#line 139 "similar-image.c"
simage_status_t simage_free (simage_t * s );

#line 148 "similar-image.c"
simage_status_t simage_set_pixel (simage_t * s , int x , int y , unsigned char grey );

#line 156 "similar-image.c"
simage_status_t simage_fill_entry (simage_t * s , int i , int j );

#line 209 "similar-image.c"
simage_status_t simage_fill_entries (simage_t * s );

#line 231 "similar-image.c"
int xo_yo_to_count (int xo , int yo );

#line 244 "similar-image.c"
int diff (int thisgrey , int thatgrey );

#line 273 "similar-image.c"
simage_status_t simage_make_point_diffs (simage_t * s , int x , int y );

#line 321 "similar-image.c"
simage_status_t simage_make_differences (simage_t * s );

#line 337 "similar-image.c"
simage_status_t simage_check_image (simage_t * s );

#line 353 "similar-image.c"
simage_status_t simage_fill_grid (simage_t * s );

#line 362 "similar-image.c"
simage_status_t simage_diff (simage_t * s1 , simage_t * s2 , double * total_diff );

#endif /* CFH_SIMILAR_IMAGE_H */
