use Test::More tests => 29;
BEGIN { use_ok('POE::Component::IRC::Common', qw(:ALL)) }
ok( 'SIMPLE' eq u_irc( 'simple' ), "Upper simple test" );
ok( 'simple' eq l_irc( 'SIMPLE' ), "Lower simple test" );
ok( 'C0MPL~[X]' eq u_irc ( 'c0mpl^{x}' ), "Upper complex test" );
ok( 'c0mpl^{x}' eq l_irc ( 'C0MPL~[X]' ), "Lower complex test" );
ok( 'C0MPL~[X]' eq u_irc ( 'c0mpl~[x]', 'ascii' ), "Upper complex test ascii" );
ok( 'c0mpl^{x}' eq l_irc ( 'C0MPL^{X}', 'ascii' ), "Lower complex test ascii" );
ok( 'C0MPL~[X]' eq u_irc ( 'c0mpl~{x}', 'strict-rfc1459' ), "Upper complex test strict" );
ok( 'c0mpl^{x}' eq l_irc ( 'C0MPL^[X]', 'strict-rfc1459' ), "Lower complex test strict" );
my $hashref = parse_mode_line( qw(ov rita bob) );
ok( $hashref->{modes}->[0] eq '+o', "Parse mode test 1" );
ok( $hashref->{args}->[0] eq 'rita', "Parse mode test 2" );
my $hashref2 = parse_mode_line( qw(-b +b!*@*) );
ok( $hashref2->{modes}->[0] eq '-b', "Parse mode test 3" );
ok( $hashref2->{args}->[0] eq '+b!*@*', "Parse mode test 4" );
my $hashref3 = parse_mode_line( qw(+b -b!*@*) );
ok( $hashref3->{modes}->[0] eq '+b', "Parse mode test 5" );
ok( $hashref3->{args}->[0] eq '-b!*@*', "Parse mode test 6" );
my $banmask = parse_ban_mask( 'stalin*' );
ok( $banmask eq 'stalin*!*@*', "Parse ban mask test 1" );
ok( matches_mask( $banmask, 'stalin!joe@kremlin.ru' ), "Matches Mask test 1" );
ok( !matches_mask( $banmask, 'BinGOs!foo@blah.com' ), "Matches Mask test 2" );
my $nick = parse_user('BinGOs!null@fubar.com');
my @args = parse_user('BinGOs!null@fubar.com');
ok( $nick eq 'BinGOs', "Parse User Test 1" );
ok( $nick eq $args[0], "Parse User Test 2" );
ok( $args[1] eq 'null', "Parse User Test 3" );
ok( $args[2] eq 'fubar.com', "Parse User Test 4" );
my $colored = "\x0304,05Hi, I'm a color junkie\x03";
ok ( has_color($colored), "Has Color Test");
ok ( strip_color($colored) eq "Hi, I'm a color junkie", "Strip Color Test" );
my $formatted = "This is \x02bold\x0f and this is \x1funderlined\x0f";
ok ( has_formatting($formatted), "Has Formatting Test" );
my $stripped = strip_formatting($formatted);
ok ( $stripped eq 'This is bold and this is underlined', "Strip Formatting Test" );
ok( irc_ip_get_version('100.0.0.1') == 4, "IPv4" );
ok( irc_ip_get_version('2001:0db8:0000:0000:0000:0000:1428:57ab') == 6, "IPv6" );
ok( !irc_ip_get_version('blah'), "Not an IP" );
