use Test::More qw(no_plan);
use App::RecordStream::Test::OperationHelper;

use strict;
use warnings;

BEGIN { use_ok( 'App::RecordStream::Operation::toptable' ) };

my $stream1 = <<STREAM;
{"c":"0","a":"2","b":"2","d":"2","ct":2}
{"c":"0","a":"0","b":"2","d":"0","ct":3}
{"c":"0","a":"1","b":"1","d":"0","ct":7}
{"c":"1","a":"2","b":"2","d":"1","ct":8}
{"c":"0","a":"2","b":"0","d":"2","ct":1}
{"c":"2","a":"0","b":"0","d":"1","ct":1}
{"c":"2","a":"2","b":"1","d":"2","ct":3}
{"c":"2","a":"0","b":"0","d":"0","ct":22}
{"c":"2","a":"0","b":"0","d":"2","ct":6}
{"c":"2","a":"1","b":"1","d":"1","ct":4}
{"c":"2","a":"0","b":"2","d":"2","ct":27}
{"c":"1","a":"1","b":"0","d":"0","ct":17}
{"c":"2","a":"0","b":"2","d":"1","ct":4}
{"c":"1","a":"1","b":"0","d":"1","ct":2}
{"c":"1","a":"0","b":"0","d":"0","ct":4}
{"c":"0","a":"0","b":"0","d":"2","ct":23}
{"c":"0","a":"0","b":"1","d":"0","ct":24}
{"c":"1","a":"2","b":"2","d":"2","ct":26}
{"c":"1","a":"1","b":"1","d":"1","ct":8}
{"c":"0","a":"2","b":"0","d":"1","ct":1}
{"c":"2","a":"2","b":"1","d":"1","ct":21}
{"c":"1","a":"1","b":"1","d":"0","ct":7}
{"c":"0","a":"1","b":"0","d":"2","ct":8}
{"c":"2","a":"0","b":"2","d":"0","ct":2}
{"c":"2","a":"2","b":"2","d":"2","ct":26}
{"c":"1","a":"1","b":"2","d":"1","ct":24}
{"c":"1","a":"0","b":"2","d":"1","ct":1}
{"c":"0","a":"1","b":"1","d":"1","ct":5}
{"c":"0","a":"0","b":"0","d":"0","ct":27}
{"c":"2","a":"2","b":"0","d":"2","ct":25}
{"c":"2","a":"1","b":"2","d":"1","ct":1}
{"c":"1","a":"2","b":"1","d":"1","ct":21}
{"c":"0","a":"0","b":"2","d":"2","ct":20}
{"c":"2","a":"2","b":"2","d":"1","ct":22}
{"c":"1","a":"2","b":"1","d":"0","ct":9}
{"c":"0","a":"1","b":"0","d":"0","ct":28}
STREAM

my $table1a = <<TABLE;
+-+-+-+--+--+--+--+-+--+--+--+--+
| | |a|0 |  |  |1 | |  |2 |  |  |
+-+-+-+--+--+--+--+-+--+--+--+--+
| | |b|0 |1 |2 |0 |1|2 |0 |1 |2 |
+-+-+-+--+--+--+--+-+--+--+--+--+
|c|d| |  |  |  |  | |  |  |  |  |
+-+-+-+--+--+--+--+-+--+--+--+--+
|0|0| |27|24|3 |28|7|  |  |  |  |
+-+-+-+--+--+--+--+-+--+--+--+--+
| |1| |  |  |  |  |5|  |1 |  |  |
+-+-+-+--+--+--+--+-+--+--+--+--+
| |2| |23|  |20|8 | |  |1 |  |2 |
+-+-+-+--+--+--+--+-+--+--+--+--+
|1|0| |4 |  |  |17|7|  |  |9 |  |
+-+-+-+--+--+--+--+-+--+--+--+--+
| |1| |  |  |1 |2 |8|24|  |21|8 |
+-+-+-+--+--+--+--+-+--+--+--+--+
| |2| |  |  |  |  | |  |  |  |26|
+-+-+-+--+--+--+--+-+--+--+--+--+
|2|0| |22|  |2 |  | |  |  |  |  |
+-+-+-+--+--+--+--+-+--+--+--+--+
| |1| |1 |  |4 |  |4|1 |  |21|22|
+-+-+-+--+--+--+--+-+--+--+--+--+
| |2| |6 |  |27|  | |  |25|3 |26|
+-+-+-+--+--+--+--+-+--+--+--+--+
TABLE

App::RecordStream::Test::OperationHelper->test_output(
   'toptable',
   ['--x', 'a,b', '--y', 'c,d'],
   $stream1,
   $table1a,
);

my $table1a_records = <<RECORDS;
{"c":"0","a":{"1":{"b":{"1":7,"0":28,"2":""}},"0":{"b":{"1":24,"0":27,"2":3}},"2":{"b":{"1":"","0":"","2":""}}},"d":"0"}
{"c":"0","a":{"1":{"b":{"1":5,"0":"","2":""}},"0":{"b":{"1":"","0":"","2":""}},"2":{"b":{"1":"","0":1,"2":""}}},"d":"1"}
{"c":"0","a":{"1":{"b":{"1":"","0":8,"2":""}},"0":{"b":{"1":"","0":23,"2":20}},"2":{"b":{"1":"","0":1,"2":2}}},"d":"2"}
{"c":"1","a":{"1":{"b":{"1":7,"0":17,"2":""}},"0":{"b":{"1":"","0":4,"2":""}},"2":{"b":{"1":9,"0":"","2":""}}},"d":"0"}
{"c":"1","a":{"1":{"b":{"1":8,"0":2,"2":24}},"0":{"b":{"1":"","0":"","2":1}},"2":{"b":{"1":21,"0":"","2":8}}},"d":"1"}
{"c":"1","a":{"1":{"b":{"1":"","0":"","2":""}},"0":{"b":{"1":"","0":"","2":""}},"2":{"b":{"1":"","0":"","2":26}}},"d":"2"}
{"c":"2","a":{"1":{"b":{"1":"","0":"","2":""}},"0":{"b":{"1":"","0":22,"2":2}},"2":{"b":{"1":"","0":"","2":""}}},"d":"0"}
{"c":"2","a":{"1":{"b":{"1":4,"0":"","2":1}},"0":{"b":{"1":"","0":1,"2":4}},"2":{"b":{"1":21,"0":"","2":22}}},"d":"1"}
{"c":"2","a":{"1":{"b":{"1":"","0":"","2":""}},"0":{"b":{"1":"","0":6,"2":27}},"2":{"b":{"1":3,"0":25,"2":26}}},"d":"2"}
RECORDS

App::RecordStream::Test::OperationHelper->do_match(
   'toptable',
   ['--x', 'a,b', '--y', 'c,d', '--records'],
   $stream1,
   $table1a_records,
);

my $table1b = <<TABLE;
+-+-+-+-+-+-+--+-+--+--+
| |a|0| |1| |  |2|  |  |
+-+-+-+-+-+-+--+-+--+--+
| |b|0|2|0|1|2 |0|1 |2 |
+-+-+-+-+-+-+--+-+--+--+
|c| | | | | |  | |  |  |
+-+-+-+-+-+-+--+-+--+--+
|0| | | | |5|  |1|  |  |
+-+-+-+-+-+-+--+-+--+--+
|1| | |1|2|8|24| |21|8 |
+-+-+-+-+-+-+--+-+--+--+
|2| |1|4| |4|1 | |21|22|
+-+-+-+-+-+-+--+-+--+--+
TABLE

App::RecordStream::Test::OperationHelper->test_output(
   'toptable',
   ['--x', 'a,b', '--y', 'c', '--p', 'd=1'],
   $stream1,
   $table1b,
);

my $table1c = <<TABLE;
+-+-+-+--+--+--+
| | |a|0 |  |  |
+-+-+-+--+--+--+
| | |b|0 |1 |2 |
+-+-+-+--+--+--+
|c|d| |  |  |  |
+-+-+-+--+--+--+
|0|0| |27|24|3 |
+-+-+-+--+--+--+
| |2| |23|  |20|
+-+-+-+--+--+--+
|1|0| |4 |  |  |
+-+-+-+--+--+--+
| |1| |  |  |1 |
+-+-+-+--+--+--+
|2|0| |22|  |2 |
+-+-+-+--+--+--+
| |1| |1 |  |4 |
+-+-+-+--+--+--+
| |2| |6 |  |27|
+-+-+-+--+--+--+
TABLE

App::RecordStream::Test::OperationHelper->test_output(
   'toptable',
   ['--x', 'a,b', '--y', 'c,d', '--pin', 'a=0'],
   $stream1,
   $table1c,
);

my $stream2 = <<STREAM;
{"avg_d":2,"c":"0","a":"2","b":"2","ct":2}
{"avg_d":0.448275862068966,"c":"2","a":"0","b":"0","ct":29}
{"avg_d":1,"c":"2","a":"1","b":"1","ct":4}
{"avg_d":0.105263157894737,"c":"1","a":"1","b":"0","ct":19}
{"avg_d":0,"c":"1","a":"0","b":"0","ct":4}
{"avg_d":0,"c":"0","a":"0","b":"1","ct":24}
{"avg_d":1.76470588235294,"c":"1","a":"2","b":"2","ct":34}
{"avg_d":1.5,"c":"0","a":"2","b":"0","ct":2}
{"avg_d":1.125,"c":"2","a":"2","b":"1","ct":24}
{"avg_d":0.509090909090909,"c":"1","a":"1","b":"1","ct":55}
{"avg_d":1.75757575757576,"c":"2","a":"0","b":"2","ct":33}
{"avg_d":1,"c":"1","a":"1","b":"2","ct":24}
{"avg_d":1,"c":"1","a":"0","b":"2","ct":1}
{"avg_d":0.78125,"c":"0","a":"1","b":"1","ct":32}
{"avg_d":0.92,"c":"0","a":"0","b":"0","ct":50}
{"avg_d":2,"c":"2","a":"2","b":"0","ct":25}
{"avg_d":1,"c":"2","a":"1","b":"2","ct":1}
{"avg_d":1.73913043478261,"c":"0","a":"0","b":"2","ct":23}
{"avg_d":1.54166666666667,"c":"2","a":"2","b":"2","ct":48}
{"avg_d":0.7,"c":"1","a":"2","b":"1","ct":30}
{"avg_d":0.444444444444444,"c":"0","a":"1","b":"0","ct":36}
STREAM

my $table2 = <<TABLE;
+-+-+-----+-----------------+--+-----------------+--+----------------+--+
| | |b    |0                |  |1                |  |2               |  |
+-+-+-----+-----------------+--+-----------------+--+----------------+--+
| | |FIELD|avg_d            |ct|avg_d            |ct|avg_d           |ct|
+-+-+-----+-----------------+--+-----------------+--+----------------+--+
|c|a|     |                 |  |                 |  |                |  |
+-+-+-----+-----------------+--+-----------------+--+----------------+--+
|0|0|     |0.92             |50|0                |24|1.73913043478261|23|
+-+-+-----+-----------------+--+-----------------+--+----------------+--+
| |1|     |0.444444444444444|36|0.78125          |32|                |  |
+-+-+-----+-----------------+--+-----------------+--+----------------+--+
| |2|     |1.5              |2 |                 |  |2               |2 |
+-+-+-----+-----------------+--+-----------------+--+----------------+--+
|1|0|     |0                |4 |                 |  |1               |1 |
+-+-+-----+-----------------+--+-----------------+--+----------------+--+
| |1|     |0.105263157894737|19|0.509090909090909|55|1               |24|
+-+-+-----+-----------------+--+-----------------+--+----------------+--+
| |2|     |                 |  |0.7              |30|1.76470588235294|34|
+-+-+-----+-----------------+--+-----------------+--+----------------+--+
|2|0|     |0.448275862068966|29|                 |  |1.75757575757576|33|
+-+-+-----+-----------------+--+-----------------+--+----------------+--+
| |1|     |                 |  |1                |4 |1               |1 |
+-+-+-----+-----------------+--+-----------------+--+----------------+--+
| |2|     |2                |25|1.125            |24|1.54166666666667|48|
+-+-+-----+-----------------+--+-----------------+--+----------------+--+
TABLE


App::RecordStream::Test::OperationHelper->test_output(
   'toptable',
   ['--x', 'b,FIELD', '--y', 'c,a'],
   $stream2,
   $table2,
);

# Test Keygroups
App::RecordStream::Test::OperationHelper->test_output(
   'toptable',
   ['--x', '!b!,FIELD', '--y', '!^(a|c)$!', '--v', '!avg_d|ct!'],
   $stream2,
   $table2,
);

my $pin_records = <<RECORDS;
{"c":"2","a":{"1":{"b":{"1":"","2":""}},"0":{"b":{"0":22,"2":2}},"2":{"b":{"1":"","0":"","2":""}}},"d":"0"}
{"c":"2","a":{"1":{"b":{"1":4,"2":1}},"0":{"b":{"0":1,"2":4}},"2":{"b":{"1":21,"0":"","2":22}}},"d":"1"}
{"c":"2","a":{"1":{"b":{"1":"","2":""}},"0":{"b":{"0":6,"2":27}},"2":{"b":{"1":3,"0":25,"2":26}}},"d":"2"}
RECORDS

App::RecordStream::Test::OperationHelper->do_match(
   'toptable',
   ['--x', 'a,b', '--y', 'c,d', '--pin', 'c=2', '--records'],
   $stream1,
   $pin_records,
);
