package Bundle::WWW::Scraper::ISBN::Drivers;

use strict;
use vars qw($VERSION);

$VERSION = "1.03";

1;

__END__

=head1 NAME

Bundle::WWW::Scraper::ISBN::Drivers - a Bundle for WWW::Scraper::ISBN drivers.

=head1 SYNOPSIS

    perl -MCPAN -e install Bundle::WWW::Scraper::ISBN::Drivers

=head1 DESCRIPTION

C<Bundle::WWW::Scraper::ISBN::Drivers> provides a bundle to install all known
C<WWW::Scraper::ISBN> type drivers, as well as the core C<WWW::Scraper::ISBN>
prerequisites.

=head1 CONTENTS

WWW::Scraper::ISBN          0.25

WWW::Scraper::ISBN::Driver  0.18

WWW::Scraper::ISBN::Record

WWW::Scraper::ISBN::A1Books_Driver

WWW::Scraper::ISBN::AmazonDE_Driver

WWW::Scraper::ISBN::AmazonFR_Driver

WWW::Scraper::ISBN::AmazonUK_Driver

WWW::Scraper::ISBN::AmazonUS_Driver

WWW::Scraper::ISBN::BookDepository_Driver

WWW::Scraper::ISBN::Booktopia_Driver

WWW::Scraper::ISBN::EmporiumBooks_Driver

WWW::Scraper::ISBN::ISBNdb_Driver

WWW::Scraper::ISBN::ISBNnu_Driver

WWW::Scraper::ISBN::LibUniIt_Driver

WWW::Scraper::ISBN::LOC_Driver

WWW::Scraper::ISBN::ORA_Driver

WWW::Scraper::ISBN::OpenLibrary_Driver

WWW::Scraper::ISBN::Pearson_Driver

WWW::Scraper::ISBN::Siciliano_Driver

WWW::Scraper::ISBN::TheNile_Driver

WWW::Scraper::ISBN::TWApexbook_Driver

WWW::Scraper::ISBN::TWBooks_Driver

WWW::Scraper::ISBN::TWCwbook_Driver

WWW::Scraper::ISBN::TWEslitebooks_Driver

WWW::Scraper::ISBN::TWKingstone_Driver

WWW::Scraper::ISBN::TWPchome_Driver

WWW::Scraper::ISBN::TWSanmin_Driver

WWW::Scraper::ISBN::TWSilkbook_Driver

WWW::Scraper::ISBN::TWSoidea_Driver

WWW::Scraper::ISBN::TWSrbook_Driver

WWW::Scraper::ISBN::TWTenlong_Driver

WWW::Scraper::ISBN::TWYlib_Driver

WWW::Scraper::ISBN::Wheelers_Driver

WWW::Scraper::ISBN::WordPower_Driver

WWW::Scraper::ISBN::Yahoo_Driver

=head1 BUGS, PATCHES & FIXES

There are no known bugs at the time of this release. However, if you spot a
bug or are experiencing difficulties that are not explained within the POD
documentation, please send an email to barbie@cpan.org or submit a bug to the
RT system (http://rt.cpan.org/Public/Dist/Display.html?Name=Bundle-WWW-Scraper-ISBN-Drivers).
However, it would help greatly if you are able to pinpoint problems or even
supply a patch.

Fixes are dependant upon their severity and my availablity. Should a fix not
be forthcoming, please feel free to (politely) remind me.

If you write a new driver, please add an RT ticket to the above queue,
and I'll add it to the list.

=head1 AUTHOR

  Barbie, <barbie@cpan.org>
  Miss Barbell Productions, <http://www.missbarbell.co.uk/>

=head1 COPYRIGHT & LICENSE

  Copyright (C) 2010 Barbie for Miss Barbell Productions

  This module is free software; you can redistribute it and/or
  modify it under the Artistic Licence v2.

=cut
