/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.content;

import java.util.Collection;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.content.CoverageContentType;
import org.opengis.metadata.content.RangeDimension;

@XmlType(name="MD_AttributeGroup_Type", propOrder={"contentType", "attribute"})
@XmlRootElement(name="MD_AttributeGroup")
@UML(identifier="MD_AttributeGroup", specification=Specification.ISO_19115)
public class DefaultAttributeGroup
extends ISOMetadata {
    private static final long serialVersionUID = -2198484393626051875L;
    private Collection<CoverageContentType> contentTypes;
    private Collection<RangeDimension> attributes;

    public DefaultAttributeGroup() {
    }

    public DefaultAttributeGroup(CoverageContentType coverageContentType, RangeDimension rangeDimension) {
        this.contentTypes = this.singleton(coverageContentType, CoverageContentType.class);
        this.attributes = this.singleton(rangeDimension, RangeDimension.class);
    }

    public DefaultAttributeGroup(DefaultAttributeGroup defaultAttributeGroup) {
        super(defaultAttributeGroup);
        if (defaultAttributeGroup != null) {
            this.contentTypes = this.copyCollection(defaultAttributeGroup.getContentTypes(), CoverageContentType.class);
            this.attributes = this.copyCollection(defaultAttributeGroup.getAttributes(), RangeDimension.class);
        }
    }

    @XmlElement(name="contentType", required=true)
    @UML(identifier="contentType", obligation=Obligation.MANDATORY, specification=Specification.ISO_19115)
    public Collection<CoverageContentType> getContentTypes() {
        this.contentTypes = this.nonNullCollection(this.contentTypes, CoverageContentType.class);
        return this.contentTypes;
    }

    public void setContentTypes(Collection<? extends CoverageContentType> collection) {
        this.contentTypes = this.writeCollection(collection, this.contentTypes, CoverageContentType.class);
    }

    @XmlElement(name="attribute")
    @UML(identifier="attribute", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<RangeDimension> getAttributes() {
        this.attributes = this.nonNullCollection(this.attributes, RangeDimension.class);
        return this.attributes;
    }

    public void setAttributes(Collection<? extends RangeDimension> collection) {
        this.attributes = this.writeCollection(collection, this.attributes, RangeDimension.class);
    }
}

