/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.util;

import com.gargoylesoftware.htmlunit.WebAssert;
import com.gargoylesoftware.htmlunit.util.StringUtils;
import com.gargoylesoftware.htmlunit.util.URLCreator;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.BitSet;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.net.URLCodec;

public final class UrlUtils {
    private static final BitSet PATH_ALLOWED_CHARS;
    private static final BitSet QUERY_ALLOWED_CHARS;
    private static final BitSet ANCHOR_ALLOWED_CHARS;
    private static final URLCreator URL_CREATOR;

    private UrlUtils() {
    }

    public static URL toUrlSafe(String url) {
        try {
            return UrlUtils.toUrlUnsafe(url);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public static URL toUrlUnsafe(String url) throws MalformedURLException {
        WebAssert.notNull("url", url);
        return URL_CREATOR.toUrlUnsafeClassic(url);
    }

    public static URL encodeUrl(URL url, boolean minimalQueryEncoding) {
        String p = url.getProtocol();
        if ("javascript".equalsIgnoreCase(p) || "about".equalsIgnoreCase(p) || "data".equalsIgnoreCase(p)) {
            return url;
        }
        try {
            String anchor;
            String query;
            String path = url.getPath();
            if (path != null) {
                path = UrlUtils.encode(path, PATH_ALLOWED_CHARS, "utf-8");
            }
            if ((query = url.getQuery()) != null) {
                query = minimalQueryEncoding ? org.apache.commons.lang3.StringUtils.replace((String)query, (String)" ", (String)"%20") : UrlUtils.encode(query, QUERY_ALLOWED_CHARS, "windows-1252");
            }
            if ((anchor = url.getRef()) != null) {
                anchor = UrlUtils.encode(anchor, ANCHOR_ALLOWED_CHARS, "utf-8");
            }
            return UrlUtils.createNewUrl(url.getProtocol(), url.getHost(), url.getPort(), path, anchor, query);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public static String encodeAnchor(String anchor) {
        if (anchor != null) {
            anchor = UrlUtils.encode(anchor, ANCHOR_ALLOWED_CHARS, "utf-8");
        }
        return anchor;
    }

    public static String decode(String escaped) {
        try {
            byte[] bytes = escaped.getBytes("US-ASCII");
            byte[] bytes2 = URLCodec.decodeUrl((byte[])bytes);
            return new String(bytes2, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        catch (DecoderException e) {
            throw new RuntimeException(e);
        }
    }

    private static String encode(String unescaped, BitSet allowed, String charset) {
        try {
            byte[] bytes = unescaped.getBytes(charset);
            byte[] bytes2 = URLCodec.encodeUrl((BitSet)allowed, (byte[])bytes);
            return new String(bytes2, "US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static URL getUrlWithNewProtocol(URL u, String newProtocol) throws MalformedURLException {
        return UrlUtils.createNewUrl(newProtocol, u.getHost(), u.getPort(), u.getPath(), u.getRef(), u.getQuery());
    }

    public static URL getUrlWithNewHost(URL u, String newHost) throws MalformedURLException {
        return UrlUtils.createNewUrl(u.getProtocol(), newHost, u.getPort(), u.getPath(), u.getRef(), u.getQuery());
    }

    public static URL getUrlWithNewPort(URL u, int newPort) throws MalformedURLException {
        return UrlUtils.createNewUrl(u.getProtocol(), u.getHost(), newPort, u.getPath(), u.getRef(), u.getQuery());
    }

    public static URL getUrlWithNewPath(URL u, String newPath) throws MalformedURLException {
        return UrlUtils.createNewUrl(u.getProtocol(), u.getHost(), u.getPort(), newPath, u.getRef(), u.getQuery());
    }

    public static URL getUrlWithNewRef(URL u, String newRef) throws MalformedURLException {
        return UrlUtils.createNewUrl(u.getProtocol(), u.getHost(), u.getPort(), u.getPath(), newRef, u.getQuery());
    }

    public static URL getUrlWithNewQuery(URL u, String newQuery) throws MalformedURLException {
        return UrlUtils.createNewUrl(u.getProtocol(), u.getHost(), u.getPort(), u.getPath(), u.getRef(), newQuery);
    }

    private static URL createNewUrl(String protocol, String host, int port, String path, String ref, String query) throws MalformedURLException {
        StringBuilder s = new StringBuilder();
        s.append(protocol);
        s.append("://");
        s.append(host);
        if (port != -1) {
            s.append(":").append(port);
        }
        if (path != null && path.length() > 0) {
            if ('/' != path.charAt(0)) {
                s.append("/");
            }
            s.append(path);
        }
        if (query != null) {
            s.append("?").append(query);
        }
        if (ref != null) {
            if (ref.length() <= 0 || '#' != ref.charAt(0)) {
                s.append("#");
            }
            s.append(ref);
        }
        URL url = new URL(s.toString());
        return url;
    }

    public static String resolveUrl(String baseUrl, String relativeUrl) {
        if (baseUrl == null) {
            throw new IllegalArgumentException("Base URL must not be null");
        }
        if (relativeUrl == null) {
            throw new IllegalArgumentException("Relative URL must not be null");
        }
        Url url = UrlUtils.resolveUrl(UrlUtils.parseUrl(baseUrl.trim()), relativeUrl.trim());
        return url.toString();
    }

    public static String resolveUrl(URL baseUrl, String relativeUrl) {
        if (baseUrl == null) {
            throw new IllegalArgumentException("Base URL must not be null");
        }
        return UrlUtils.resolveUrl(baseUrl.toExternalForm(), relativeUrl);
    }

    private static Url parseUrl(String spec) {
        int semicolonIndex;
        int questionMarkIndex;
        int locationEndIndex;
        int locationStartIndex;
        String scheme;
        int colonIndex;
        Url url = new Url();
        int startIndex = 0;
        int endIndex = spec.length();
        int crosshatchIndex = StringUtils.indexOf(spec, '#', startIndex, endIndex);
        if (crosshatchIndex >= 0) {
            url.fragment_ = spec.substring(crosshatchIndex + 1, endIndex);
            endIndex = crosshatchIndex;
        }
        if ((colonIndex = StringUtils.indexOf(spec, ':', startIndex, endIndex)) > 0 && UrlUtils.isValidScheme(scheme = spec.substring(startIndex, colonIndex))) {
            url.scheme_ = scheme;
            startIndex = colonIndex + 1;
        }
        if (spec.startsWith("//", startIndex)) {
            locationStartIndex = startIndex + 2;
            locationEndIndex = StringUtils.indexOf(spec, '/', locationStartIndex, endIndex);
            if (locationEndIndex >= 0) {
                startIndex = locationEndIndex;
            }
        } else {
            locationStartIndex = -1;
            locationEndIndex = -1;
        }
        if ((questionMarkIndex = StringUtils.indexOf(spec, '?', startIndex, endIndex)) >= 0) {
            if (locationStartIndex >= 0 && locationEndIndex < 0) {
                locationEndIndex = questionMarkIndex;
                startIndex = questionMarkIndex;
            }
            url.query_ = spec.substring(questionMarkIndex + 1, endIndex);
            endIndex = questionMarkIndex;
        }
        if ((semicolonIndex = StringUtils.indexOf(spec, ';', startIndex, endIndex)) >= 0) {
            if (locationStartIndex >= 0 && locationEndIndex < 0) {
                locationEndIndex = semicolonIndex;
                startIndex = semicolonIndex;
            }
            url.parameters_ = spec.substring(semicolonIndex + 1, endIndex);
            endIndex = semicolonIndex;
        }
        if (locationStartIndex >= 0 && locationEndIndex < 0) {
            locationEndIndex = endIndex;
        } else if (startIndex < endIndex) {
            url.path_ = spec.substring(startIndex, endIndex);
        }
        if (locationStartIndex >= 0 && locationEndIndex >= 0) {
            url.location_ = spec.substring(locationStartIndex, locationEndIndex);
        }
        return url;
    }

    private static boolean isValidScheme(String scheme) {
        int length = scheme.length();
        if (length < 1) {
            return false;
        }
        char c = scheme.charAt(0);
        if (!Character.isLetter(c)) {
            return false;
        }
        for (int i = 1; i < length; ++i) {
            c = scheme.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '.' || c == '+' || c == '-') continue;
            return false;
        }
        return true;
    }

    private static Url resolveUrl(Url baseUrl, String relativeUrl) {
        int slashIndex;
        String pathSegment;
        int pathSegmentIndex;
        Url url = UrlUtils.parseUrl(relativeUrl);
        if (baseUrl == null) {
            return url;
        }
        if (relativeUrl.isEmpty()) {
            return new Url(baseUrl);
        }
        if (url.scheme_ != null) {
            return url;
        }
        url.scheme_ = baseUrl.scheme_;
        if (url.location_ != null) {
            return url;
        }
        url.location_ = baseUrl.location_;
        if (url.path_ != null && url.path_.length() > 0 && '/' == url.path_.charAt(0)) {
            url.path_ = UrlUtils.removeLeadingSlashPoints(url.path_);
            return url;
        }
        if (url.path_ == null) {
            url.path_ = baseUrl.path_;
            if (url.parameters_ != null) {
                return url;
            }
            url.parameters_ = baseUrl.parameters_;
            if (url.query_ != null) {
                return url;
            }
            url.query_ = baseUrl.query_;
            return url;
        }
        String basePath = baseUrl.path_;
        String path = "";
        if (basePath != null) {
            int lastSlashIndex = basePath.lastIndexOf(47);
            if (lastSlashIndex >= 0) {
                path = basePath.substring(0, lastSlashIndex + 1);
            }
        } else {
            path = "/";
        }
        path = path.concat(url.path_);
        while ((pathSegmentIndex = path.indexOf("/./")) >= 0) {
            path = path.substring(0, pathSegmentIndex + 1).concat(path.substring(pathSegmentIndex + 3));
        }
        if (path.endsWith("/.")) {
            path = path.substring(0, path.length() - 1);
        }
        while ((pathSegmentIndex = path.indexOf("/../")) > 0) {
            pathSegment = path.substring(0, pathSegmentIndex);
            slashIndex = pathSegment.lastIndexOf(47);
            if (slashIndex >= 0) {
                if ("..".equals(pathSegment.substring(slashIndex))) continue;
                path = path.substring(0, slashIndex + 1).concat(path.substring(pathSegmentIndex + 4));
                continue;
            }
            path = path.substring(pathSegmentIndex + 4);
        }
        if (path.endsWith("/..") && (slashIndex = (pathSegment = path.substring(0, path.length() - 3)).lastIndexOf(47)) >= 0) {
            path = path.substring(0, slashIndex + 1);
        }
        path = UrlUtils.removeLeadingSlashPoints(path);
        url.path_ = path;
        return url;
    }

    private static String removeLeadingSlashPoints(String path) {
        while (path.startsWith("/..")) {
            path = path.substring(3);
        }
        return path;
    }

    static {
        int i;
        int i2;
        PATH_ALLOWED_CHARS = new BitSet(256);
        QUERY_ALLOWED_CHARS = new BitSet(256);
        ANCHOR_ALLOWED_CHARS = new BitSet(256);
        URL_CREATOR = URLCreator.getCreator();
        BitSet reserved = new BitSet(256);
        reserved.set(59);
        reserved.set(47);
        reserved.set(63);
        reserved.set(58);
        reserved.set(64);
        reserved.set(38);
        reserved.set(61);
        reserved.set(43);
        reserved.set(36);
        reserved.set(44);
        BitSet mark = new BitSet(256);
        mark.set(45);
        mark.set(95);
        mark.set(46);
        mark.set(33);
        mark.set(126);
        mark.set(42);
        mark.set(39);
        mark.set(40);
        mark.set(41);
        BitSet alpha = new BitSet(256);
        for (i2 = 97; i2 <= 122; ++i2) {
            alpha.set(i2);
        }
        for (i2 = 65; i2 <= 90; ++i2) {
            alpha.set(i2);
        }
        BitSet digit = new BitSet(256);
        for (int i3 = 48; i3 <= 57; ++i3) {
            digit.set(i3);
        }
        BitSet alphanumeric = new BitSet(256);
        alphanumeric.or(alpha);
        alphanumeric.or(digit);
        BitSet unreserved = new BitSet(256);
        unreserved.or(alphanumeric);
        unreserved.or(mark);
        BitSet hex = new BitSet(256);
        hex.or(digit);
        for (i = 97; i <= 102; ++i) {
            hex.set(i);
        }
        for (i = 65; i <= 70; ++i) {
            hex.set(i);
        }
        BitSet escaped = new BitSet(256);
        escaped.set(37);
        escaped.or(hex);
        BitSet uric = new BitSet(256);
        uric.or(reserved);
        uric.or(unreserved);
        uric.or(escaped);
        BitSet pchar = new BitSet(256);
        pchar.or(unreserved);
        pchar.or(escaped);
        pchar.set(58);
        pchar.set(64);
        pchar.set(38);
        pchar.set(61);
        pchar.set(43);
        pchar.set(36);
        pchar.set(44);
        BitSet param = pchar;
        BitSet segment = new BitSet(256);
        segment.or(pchar);
        segment.set(59);
        segment.or(param);
        BitSet pathSegments = new BitSet(256);
        pathSegments.set(47);
        pathSegments.or(segment);
        BitSet absPath = new BitSet(256);
        absPath.set(47);
        absPath.or(pathSegments);
        BitSet allowedAbsPath = new BitSet(256);
        allowedAbsPath.or(absPath);
        BitSet allowedFragment = new BitSet(256);
        allowedFragment.or(uric);
        BitSet allowedQuery = new BitSet(256);
        allowedQuery.or(uric);
        PATH_ALLOWED_CHARS.or(allowedAbsPath);
        QUERY_ALLOWED_CHARS.or(allowedQuery);
        ANCHOR_ALLOWED_CHARS.or(allowedFragment);
    }

    private static class Url {
        private String scheme_;
        private String location_;
        private String path_;
        private String parameters_;
        private String query_;
        private String fragment_;

        public Url() {
        }

        public Url(Url url) {
            this.scheme_ = url.scheme_;
            this.location_ = url.location_;
            this.path_ = url.path_;
            this.parameters_ = url.parameters_;
            this.query_ = url.query_;
            this.fragment_ = url.fragment_;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.scheme_ != null) {
                sb.append(this.scheme_);
                sb.append(':');
            }
            if (this.location_ != null) {
                sb.append("//");
                sb.append(this.location_);
            }
            if (this.path_ != null) {
                sb.append(this.path_);
            }
            if (this.parameters_ != null) {
                sb.append(';');
                sb.append(this.parameters_);
            }
            if (this.query_ != null) {
                sb.append('?');
                sb.append(this.query_);
            }
            if (this.fragment_ != null) {
                sb.append('#');
                sb.append(this.fragment_);
            }
            return sb.toString();
        }
    }
}

