/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.css;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.WebAssert;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSSPrimitiveValue;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSSValue;
import com.gargoylesoftware.htmlunit.javascript.host.css.ComputedCSSStyleDeclaration;
import com.gargoylesoftware.htmlunit.javascript.host.css.SelectorSpecificity;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLCanvasElement;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLHtmlElement;
import com.steadystate.css.dom.CSSValueImpl;
import com.steadystate.css.parser.CSSOMParser;
import com.steadystate.css.parser.SACParserCSS21;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.css.sac.ErrorHandler;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.Parser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSSStyleDeclaration
extends SimpleScriptable {
    private static final String AZIMUTH = "azimuth";
    private static final String BACKGROUND = "background";
    private static final String BACKGROUND_ATTACHMENT = "background-attachment";
    private static final String BACKGROUND_COLOR = "background-color";
    private static final String BACKGROUND_IMAGE = "background-image";
    private static final String BACKGROUND_POSITION = "background-position";
    private static final String BACKGROUND_POSITION_X = "background-position-x";
    private static final String BACKGROUND_POSITION_Y = "background-position-y";
    private static final String BACKGROUND_REPEAT = "background-repeat";
    private static final String BEHAVIOR = "behavior";
    private static final String BORDER = "border";
    private static final String BORDER_BOTTOM = "border-bottom";
    private static final String BORDER_BOTTOM_COLOR = "border-bottom-color";
    private static final String BORDER_BOTTOM_STYLE = "border-bottom-style";
    private static final String BORDER_BOTTOM_WIDTH = "border-bottom-width";
    private static final String BORDER_COLLAPSE = "border-collapse";
    private static final String BORDER_COLOR = "border-color";
    private static final String BORDER_LEFT = "border-left";
    private static final String BORDER_LEFT_COLOR = "border-left-color";
    private static final String BORDER_LEFT_STYLE = "border-left-style";
    private static final String BORDER_WIDTH = "border-width";
    private static final String BORDER_LEFT_WIDTH = "border-left-width";
    private static final String BORDER_RIGHT = "border-right";
    private static final String BORDER_RIGHT_COLOR = "border-right-color";
    private static final String BORDER_RIGHT_STYLE = "border-right-style";
    private static final String BORDER_RIGHT_WIDTH = "border-right-width";
    private static final String BORDER_SPACING = "border-spacing";
    private static final String BORDER_STYLE = "border-style";
    private static final String BORDER_TOP = "border-top";
    private static final String BORDER_TOP_COLOR = "border-top-color";
    private static final String BORDER_TOP_STYLE = "border-top-style";
    private static final String BORDER_TOP_WIDTH = "border-top-width";
    private static final String BOTTOM = "bottom";
    private static final String CAPTION_SIDE = "caption-side";
    private static final String CLEAR = "clear";
    private static final String CLIP = "clip";
    private static final String COLOR = "color";
    private static final String CONTENT = "content";
    private static final String COUNTER_INCREMENT = "counter-increment";
    private static final String COUNTER_RESET = "counter-reset";
    private static final String CUE = "cue";
    private static final String CUE_AFTER = "cue-after";
    private static final String CUE_BEFORE = "cue-before";
    private static final String CURSOR = "cursor";
    private static final String DIRECTION = "direction";
    private static final String DISPLAY = "display";
    private static final String ELEVATION = "elevation";
    private static final String EMPTY_CELLS = "empty-cells";
    private static final String FILTER = "filter";
    private static final String FONT = "font";
    private static final String FONT_FAMILY = "font-family";
    private static final String FONT_SIZE = "font-size";
    private static final String FONT_SIZE_ADJUST = "font-size-adjust";
    private static final String FONT_STRETCH = "font-stretch";
    private static final String FONT_STYLE = "font-style";
    private static final String FONT_VARIANT = "font-variant";
    private static final String FONT_WEIGHT = "font-weight";
    private static final String HEIGHT = "height";
    private static final String IME_MODE = "ime-mode";
    private static final String LAYOUT_FLOW = "layout-flow";
    private static final String LAYOUT_GRID = "layout-grid";
    private static final String LAYOUT_GRID_CHAR = "layout-grid-char";
    private static final String LAYOUT_GRID_LINE = "layout-grid-line";
    private static final String LAYOUT_GRID_MODE = "layout-grid-mode";
    private static final String LAYOUT_GRID_TYPE = "layout-grid-type";
    private static final String LEFT = "left";
    private static final String LETTER_SPACING = "letter-spacing";
    private static final String LINE_BREAK = "line-break";
    private static final String LINE_HEIGHT = "line-height";
    private static final String LIST_STYLE = "list-style";
    private static final String LIST_STYLE_IMAGE = "list-style-image";
    private static final String LIST_STYLE_POSITION = "list-style-position";
    private static final String LIST_STYLE_TYPE = "list-style-type";
    private static final String MARGIN_BOTTOM = "margin-bottom";
    private static final String MARGIN_LEFT = "margin-left";
    private static final String MARGIN_RIGHT = "margin-right";
    private static final String MARGIN = "margin";
    private static final String MARGIN_TOP = "margin-top";
    private static final String MARKER_OFFSET = "marker-offset";
    private static final String MARKS = "marks";
    private static final String MAX_HEIGHT = "max-height";
    private static final String MAX_WIDTH = "max-width";
    private static final String MIN_HEIGHT = "min-height";
    private static final String MIN_WIDTH = "min-width";
    private static final String MOZ_APPEARANCE = "-moz-appearance";
    private static final String MOZ_BACKGROUND_CLIP = "-moz-background-clip";
    private static final String MOZ_BACKGROUND_INLINE_POLICY = "-moz-background-inline-policy";
    private static final String MOZ_BACKGROUND_ORIGIN = "-moz-background-origin";
    private static final String MOZ_BINDING = "-moz-binding";
    private static final String MOZ_BORDER_BOTTOM_COLORS = "-moz-border-bottom-colors";
    private static final String MOZ_BORDER_LEFT_COLORS = "-moz-border-left-colors";
    private static final String MOZ_BORDER_RADIUS = "-moz-border-radius";
    private static final String MOZ_BORDER_RADIUS_BOTTOMLEFT = "-moz-border-radius-bottomleft";
    private static final String MOZ_BORDER_RADIUS_BOTTOMRIGHT = "-moz-border-radius-bottomright";
    private static final String MOZ_BORDER_RADIUS_TOPLEFT = "-moz-border-radius-topleft";
    private static final String MOZ_BORDER_RADIUS_TOPRIGHT = "-moz-border-radius-topright";
    private static final String MOZ_BORDER_RIGHT_COLORS = "-moz-border-right-colors";
    private static final String MOZ_BORDER_TOP_COLORS = "-moz-border-top-colors";
    private static final String MOZ_BOX_ALIGN = "-moz-box-align";
    private static final String MOZ_BOX_DIRECTION = "-moz-box-direction";
    private static final String MOZ_BOX_FLEX = "-moz-box-flex";
    private static final String MOZ_BOX_ORDINAL_GROUP = "-moz-box-ordinal-group";
    private static final String MOZ_BOX_ORIENT = "-moz-box-orient";
    private static final String MOZ_BOX_PACK = "-moz-box-pack";
    private static final String MOZ_BOX_SIZING = "-moz-box-sizing";
    private static final String MOZ_COLUMN_COUNT = "-moz-column-count";
    private static final String MOZ_COLUMN_GAP = "-moz-column-gap";
    private static final String MOZ_COLUMN_WIDTH = "-moz-column-width";
    private static final String MOZ_FLOAT_EDGE = "-moz-float-edge";
    private static final String MOZ_FORCE_BROKEN_IMAGE_ICON = "-moz-force-broken-image-icon";
    private static final String MOZ_IMAGE_REGION = "-moz-image-region";
    private static final String MOZ_MARGIN_END = "-moz-margin-end";
    private static final String MOZ_MARGIN_START = "-moz-margin-start";
    private static final String MOZ_OPACITY = "-moz-opacity";
    private static final String MOZ_OUTLINE = "-moz-outline";
    private static final String MOZ_OUTLINE_COLOR = "-moz-outline-color";
    private static final String MOZ_OUTLINE_OFFSET = "-moz-outline-offset";
    private static final String MOZ_OUTLINE_RADIUS = "-mz-outline-radius";
    private static final String MOZ_OUTLINE_RADIUS_BOTTOMLEFT = "-moz-outline-radius-bottomleft";
    private static final String MOZ_OUTLINE_RADIUS_BOTTOMRIGHT = "-moz-outline-radius-bottomright";
    private static final String MOZ_OUTLINE_RADIUS_TOPLEFT = "-moz-outline-radius-topleft";
    private static final String MOZ_OUTLINE_RADIUS_TOPRIGHT = "-moz-outline-radius-topright";
    private static final String MOZ_OUTLINE_STYLE = "-moz-outline-style";
    private static final String MOZ_OUTLINE_WIDTH = "-moz-outline-width";
    private static final String MOZ_PADDING_END = "-moz-padding-end";
    private static final String MOZ_PADDING_START = "-moz-padding-start";
    private static final String MOZ_USER_FOCUS = "-moz-user-focus";
    private static final String MOZ_USER_INPUT = "-moz-user-input";
    private static final String MOZ_USER_MODIFY = "-moz-user-modify";
    private static final String MOZ_USER_SELECT = "-moz-user-select";
    private static final String MS_INTERPOLATION_MODE = "ms-interpolation-mode";
    private static final String OPACITY = "opacity";
    private static final String ORPHANS = "orphans";
    private static final String OUTLINE = "outline";
    private static final String OUTLINE_COLOR = "outline-color";
    private static final String OUTLINE_OFFSET = "outline-offset";
    private static final String OUTLINE_STYLE = "outline-style";
    private static final String OUTLINE_WIDTH = "outline-width";
    private static final String OVERFLOW = "overflow";
    private static final String OVERFLOW_X = "overflow-x";
    private static final String OVERFLOW_Y = "overflow-y";
    private static final String PADDING_BOTTOM = "padding-bottom";
    private static final String PADDING_LEFT = "padding-left";
    private static final String PADDING_RIGHT = "padding-right";
    private static final String PADDING = "padding";
    private static final String PADDING_TOP = "padding-top";
    private static final String PAGE = "page";
    private static final String PAGE_BREAK_AFTER = "page-break-after";
    private static final String PAGE_BREAK_BEFORE = "page-break-before";
    private static final String PAGE_BREAK_INSIDE = "page-break-inside";
    private static final String PAUSE = "pause";
    private static final String PAUSE_AFTER = "pause-after";
    private static final String PAUSE_BEFORE = "pause-before";
    private static final String PITCH = "pitch";
    private static final String PITCH_RANGE = "pitch-range";
    private static final String POSITION = "position";
    private static final String QUOTES = "quotes";
    private static final String RICHNESS = "richness";
    private static final String RIGHT = "right";
    private static final String RUBY_ALIGN = "ruby-align";
    private static final String RUBY_OVERHANG = "ruby-overhang";
    private static final String RUBY_POSITION = "ruby-position";
    private static final String SCROLLBAR3D_LIGHT_COLOR = "scrollbar3d-light-color";
    private static final String SCROLLBAR_ARROW_COLOR = "scrollbar-arrow-color";
    private static final String SCROLLBAR_BASE_COLOR = "scrollbar-base-color";
    private static final String SCROLLBAR_DARK_SHADOW_COLOR = "scrollbar-dark-shadow-color";
    private static final String SCROLLBAR_FACE_COLOR = "scrollbar-face-color";
    private static final String SCROLLBAR_HIGHLIGHT_COLOR = "scrollbar-highlight-color";
    private static final String SCROLLBAR_SHADOW_COLOR = "scrollbar-shadow-color";
    private static final String SCROLLBAR_TRACK_COLOR = "scrollbar-track-color";
    private static final String SIZE = "size";
    private static final String SPEAK = "speak";
    private static final String SPEAK_HEADER = "speak-header";
    private static final String SPEAK_NUMERAL = "speak-numeral";
    private static final String SPEAK_PUNCTUATION = "speak-punctuation";
    private static final String SPEECH_RATE = "speech-rate";
    private static final String STRESS = "stress";
    private static final String FLOAT = "float";
    private static final String TABLE_LAYOUT = "table-layout";
    private static final String TEXT_ALIGN = "text-align";
    private static final String TEXT_ALIGN_LAST = "text-align-last";
    private static final String TEXT_AUTOSPACE = "text-autospace";
    private static final String TEXT_DECORATION = "text-decoration";
    private static final String TEXT_INDENT = "text-indent";
    private static final String TEXT_JUSTIFY = "text-justify";
    private static final String TEXT_JUSTIFY_TRIM = "text-justify-trim";
    private static final String TEXT_KASHIDA = "text-kashida";
    private static final String TEXT_KASHIDA_SPACE = "text-kashida-space";
    private static final String TEXT_OVERFLOW = "text-overflow";
    private static final String TEXT_SHADOW = "text-shadow";
    private static final String TEXT_TRANSFORM = "text-transform";
    private static final String TEXT_UNDERLINE_POSITION = "text-underline-position";
    private static final String TOP = "top";
    private static final String UNICODE_BIDI = "unicode-bidi";
    private static final String VERTICAL_ALIGN = "vertical-align";
    private static final String VISIBILITY = "visibility";
    private static final String VOICE_FAMILY = "voice-family";
    private static final String VOLUME = "volume";
    private static final String WHITE_SPACE = "white-space";
    private static final String WIDOWS = "widows";
    private static final String WIDTH = "width";
    private static final String WORD_BREAK = "word-break";
    private static final String WORD_SPACING = "word-spacing";
    private static final String WORD_WRAP = "word-wrap";
    private static final String WRITING_MODE = "writing-mode";
    private static final String Z_INDEX = "z-index";
    private static final String ZOOM = "zoom";
    private static final Pattern COLOR_PATTERN = Pattern.compile("(rgb.*?\\(.*?\\d{1,3}.*?,.*?\\d{1,3}.*?,.*?\\d{1,3}.*?\\))");
    private static final Pattern VALUES_SPLIT_PATTERN = Pattern.compile("\\s+");
    private static final Pattern TO_INT_PATTERN = Pattern.compile("(\\d+).*");
    private static final Log LOG = LogFactory.getLog(CSSStyleDeclaration.class);
    private static Map<String, String> CSSColors_ = new HashMap<String, String>();
    private static Map<String, String> CamelizeCache_ = new HashMap<String, String>();
    private static final MessageFormat URL_FORMAT = new MessageFormat("url({0})");
    private HTMLElement jsElement_;
    private org.w3c.dom.css.CSSStyleDeclaration styleDeclaration_;
    private long currentElementIndex_;

    public CSSStyleDeclaration() {
    }

    public CSSStyleDeclaration(HTMLElement element) {
        this.setParentScope(element.getParentScope());
        this.setPrototype(this.getPrototype(this.getClass()));
        this.initialize(element);
    }

    CSSStyleDeclaration(Scriptable parentScope, org.w3c.dom.css.CSSStyleDeclaration styleDeclaration) {
        this.setParentScope(parentScope);
        this.setPrototype(this.getPrototype(this.getClass()));
        this.styleDeclaration_ = styleDeclaration;
    }

    void initialize(HTMLElement htmlElement) {
        WebAssert.notNull("htmlElement", htmlElement);
        this.jsElement_ = htmlElement;
        this.setDomNode(htmlElement.getDomNodeOrNull(), false);
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CSS_SUPPORTS_BEHAVIOR_PROPERTY)) {
            for (StyleElement element : this.getStyleMap().values()) {
                if (!BEHAVIOR.equals(element.getName())) continue;
                try {
                    Object[] url = URL_FORMAT.parse(element.getValue());
                    if (url.length <= 0) continue;
                    this.jsElement_.jsxFunction_addBehavior((String)url[0]);
                    break;
                }
                catch (ParseException e) {
                    LOG.warn((Object)("Invalid behavior: '" + element.getValue() + "'."));
                }
            }
        }
    }

    protected HTMLElement getElement() {
        return this.jsElement_;
    }

    protected String getStyleAttribute(String name) {
        if (this.styleDeclaration_ != null) {
            return this.styleDeclaration_.getPropertyValue(name);
        }
        StyleElement element = this.getStyleMap().get(name);
        if (element != null && element.getValue() != null) {
            return element.getValue();
        }
        return "";
    }

    private String getStyleAttribute(String name1, String name2, Shorthand shorthand) {
        String value;
        if (this.styleDeclaration_ != null) {
            String value1 = this.styleDeclaration_.getPropertyValue(name1);
            String value2 = this.styleDeclaration_.getPropertyValue(name2);
            if ("".equals(value1) && "".equals(value2)) {
                return "";
            }
            if (!"".equals(value1) && "".equals(value2)) {
                return value1;
            }
            value = value2;
        } else {
            Map<String, StyleElement> styleMap = this.getStyleMap();
            StyleElement element1 = styleMap.get(name1);
            StyleElement element2 = styleMap.get(name2);
            if (element1 == null && element2 == null) {
                return "";
            }
            if (element1 != null && element2 == null) {
                return element1.getValue();
            }
            if (element1 == null && element2 != null) {
                value = element2.getValue();
            } else {
                if (element1.getIndex() > element2.getIndex()) {
                    return element1.getValue();
                }
                value = element2.getValue();
            }
        }
        String[] values = VALUES_SPLIT_PATTERN.split(value, 0);
        switch (shorthand) {
            case TOP: {
                return values[0];
            }
            case RIGHT: {
                if (values.length > 1) {
                    return values[1];
                }
                return values[0];
            }
            case BOTTOM: {
                if (values.length > 2) {
                    return values[2];
                }
                return values[0];
            }
            case LEFT: {
                if (values.length > 3) {
                    return values[3];
                }
                if (values.length > 1) {
                    return values[1];
                }
                return values[0];
            }
        }
        throw new IllegalStateException("Unknown shorthand value: " + (Object)((Object)shorthand));
    }

    protected void setStyleAttribute(String name, String newValue) {
        if (this.styleDeclaration_ != null) {
            this.styleDeclaration_.setProperty(name, newValue, null);
            return;
        }
        this.replaceStyleAttribute(name, newValue);
    }

    private void replaceStyleAttribute(String name, String value) {
        if (StringUtils.isBlank((String)value)) {
            this.removeStyleAttribute(name);
        } else {
            Map<String, StyleElement> styleMap = this.getStyleMap();
            StyleElement old = styleMap.get(name);
            long index = old != null ? old.getIndex() : this.getCurrentElementIndex();
            StyleElement element = new StyleElement(name, value, index);
            styleMap.put(name, element);
            this.writeToElement(styleMap);
        }
    }

    private void removeStyleAttribute(String name) {
        if (null != this.styleDeclaration_) {
            this.styleDeclaration_.removeProperty(name);
            return;
        }
        Map<String, StyleElement> styleMap = this.getStyleMap();
        if (!styleMap.containsKey(name)) {
            return;
        }
        styleMap.remove(name);
        this.writeToElement(styleMap);
    }

    protected Map<String, StyleElement> getStyleMap() {
        LinkedHashMap<String, StyleElement> styleMap = new LinkedHashMap<String, StyleElement>();
        String styleAttribute = this.jsElement_.getDomNodeOrDie().getAttribute("style");
        for (String token : StringUtils.split((String)styleAttribute, (char)';')) {
            int index = token.indexOf(":");
            if (index == -1) continue;
            String key = token.substring(0, index).trim().toLowerCase();
            String value = token.substring(index + 1).trim();
            StyleElement element = new StyleElement(key, value, this.getCurrentElementIndex());
            styleMap.put(key, element);
        }
        return styleMap;
    }

    private void writeToElement(Map<String, StyleElement> styleMap) {
        StringBuilder buffer = new StringBuilder();
        TreeSet<StyleElement> sortedValues = new TreeSet<StyleElement>(styleMap.values());
        for (StyleElement e : sortedValues) {
            if (buffer.length() > 0) {
                buffer.append(" ");
            }
            buffer.append(e.getName());
            buffer.append(": ");
            buffer.append(e.getValue());
            buffer.append(";");
        }
        this.jsElement_.getDomNodeOrDie().setAttribute("style", buffer.toString());
    }

    protected long getCurrentElementIndex() {
        return this.currentElementIndex_++;
    }

    protected static String camelize(String string) {
        if (string == null) {
            return null;
        }
        String result = CamelizeCache_.get(string);
        if (null != result) {
            return result;
        }
        int pos = string.indexOf(45);
        if (pos == -1 || pos >= string.length() - 1) {
            return string;
        }
        StringBuilder buffer = new StringBuilder(string);
        buffer.deleteCharAt(pos);
        buffer.setCharAt(pos, Character.toUpperCase(buffer.charAt(pos)));
        for (int i = pos + 1; i < buffer.length() - 1; ++i) {
            if (buffer.charAt(i) != '-') continue;
            buffer.deleteCharAt(i);
            buffer.setCharAt(i, Character.toUpperCase(buffer.charAt(i)));
        }
        result = buffer.toString();
        CamelizeCache_.put(string, result);
        return result;
    }

    public String jsxGet_azimuth() {
        return this.getStyleAttribute(AZIMUTH);
    }

    public void jsxSet_azimuth(String azimuth) {
        this.setStyleAttribute(AZIMUTH, azimuth);
    }

    public String jsxGet_background() {
        return this.getStyleAttribute(BACKGROUND);
    }

    public void jsxSet_background(String background) {
        this.setStyleAttribute(BACKGROUND, background);
    }

    public String jsxGet_backgroundAttachment() {
        return this.getStyleAttribute(BACKGROUND_ATTACHMENT);
    }

    public void jsxSet_backgroundAttachment(String backgroundAttachment) {
        this.setStyleAttribute(BACKGROUND_ATTACHMENT, backgroundAttachment);
    }

    public String jsxGet_backgroundColor() {
        String value = this.getStyleAttribute(BACKGROUND_COLOR);
        if (value.length() == 0 && (value = CSSStyleDeclaration.findColor(this.getStyleAttribute(BACKGROUND))) == null) {
            value = "";
        }
        return value;
    }

    public void jsxSet_backgroundColor(String backgroundColor) {
        this.setStyleAttribute(BACKGROUND_COLOR, backgroundColor);
    }

    public String jsxGet_backgroundImage() {
        return this.getStyleAttribute(BACKGROUND_IMAGE);
    }

    public void jsxSet_backgroundImage(String backgroundImage) {
        this.setStyleAttribute(BACKGROUND_IMAGE, backgroundImage);
    }

    public String jsxGet_backgroundPosition() {
        return this.getStyleAttribute(BACKGROUND_POSITION);
    }

    public void jsxSet_backgroundPosition(String backgroundPosition) {
        this.setStyleAttribute(BACKGROUND_POSITION, backgroundPosition);
    }

    public String jsxGet_backgroundPositionX() {
        return this.getStyleAttribute(BACKGROUND_POSITION_X);
    }

    public void jsxSet_backgroundPositionX(String backgroundPositionX) {
        this.setStyleAttribute(BACKGROUND_POSITION_X, backgroundPositionX);
    }

    public String jsxGet_backgroundPositionY() {
        return this.getStyleAttribute(BACKGROUND_POSITION_Y);
    }

    public void jsxSet_backgroundPositionY(String backgroundPositionY) {
        this.setStyleAttribute(BACKGROUND_POSITION_Y, backgroundPositionY);
    }

    public String jsxGet_backgroundRepeat() {
        return this.getStyleAttribute(BACKGROUND_REPEAT);
    }

    public void jsxSet_backgroundRepeat(String backgroundRepeat) {
        this.setStyleAttribute(BACKGROUND_REPEAT, backgroundRepeat);
    }

    public String jsxGet_behavior() {
        return this.getStyleAttribute(BEHAVIOR);
    }

    public void jsxSet_behavior(String behavior) {
        this.setStyleAttribute(BEHAVIOR, behavior);
        this.jsElement_.jsxFunction_removeBehavior(0);
        this.jsElement_.jsxFunction_removeBehavior(1);
        this.jsElement_.jsxFunction_removeBehavior(2);
        if (behavior.length() != 0) {
            try {
                Object[] url = URL_FORMAT.parse(behavior);
                if (url.length > 0) {
                    this.jsElement_.jsxFunction_addBehavior((String)url[0]);
                }
            }
            catch (ParseException e) {
                LOG.warn((Object)("Invalid behavior: '" + behavior + "'."));
            }
        }
    }

    public String jsxGet_border() {
        return this.getStyleAttribute(BORDER);
    }

    public void jsxSet_border(String border) {
        this.setStyleAttribute(BORDER, border);
    }

    public String jsxGet_borderBottom() {
        return this.getStyleAttribute(BORDER_BOTTOM);
    }

    public void jsxSet_borderBottom(String borderBottom) {
        this.setStyleAttribute(BORDER_BOTTOM, borderBottom);
    }

    public String jsxGet_borderBottomColor() {
        String value = this.getStyleAttribute(BORDER_BOTTOM_COLOR);
        if (value.length() == 0) {
            value = CSSStyleDeclaration.findColor(this.getStyleAttribute(BORDER_BOTTOM));
            if (value == null) {
                value = CSSStyleDeclaration.findColor(this.getStyleAttribute(BORDER));
            }
            if (value == null) {
                value = "";
            }
        }
        return value;
    }

    public void jsxSet_borderBottomColor(String borderBottomColor) {
        this.setStyleAttribute(BORDER_BOTTOM_COLOR, borderBottomColor);
    }

    public String jsxGet_borderBottomStyle() {
        String value = this.getStyleAttribute(BORDER_BOTTOM_STYLE);
        if (value.length() == 0) {
            value = CSSStyleDeclaration.findBorderStyle(this.getStyleAttribute(BORDER_BOTTOM));
            if (value == null) {
                value = CSSStyleDeclaration.findBorderStyle(this.getStyleAttribute(BORDER));
            }
            if (value == null) {
                value = "";
            }
        }
        return value;
    }

    public void jsxSet_borderBottomStyle(String borderBottomStyle) {
        this.setStyleAttribute(BORDER_BOTTOM_STYLE, borderBottomStyle);
    }

    public String jsxGet_borderBottomWidth() {
        return this.getBorderWidth(Shorthand.BOTTOM);
    }

    public void jsxSet_borderBottomWidth(String borderBottomWidth) {
        this.setStyleAttributePixelInt(BORDER_BOTTOM_WIDTH, borderBottomWidth);
    }

    public String jsxGet_borderCollapse() {
        return this.getStyleAttribute(BORDER_COLLAPSE);
    }

    public void jsxSet_borderCollapse(String borderCollapse) {
        this.setStyleAttribute(BORDER_COLLAPSE, borderCollapse);
    }

    public String jsxGet_borderColor() {
        return this.getStyleAttribute(BORDER_COLOR);
    }

    public void jsxSet_borderColor(String borderColor) {
        this.setStyleAttribute(BORDER_COLOR, borderColor);
    }

    public String jsxGet_borderLeft() {
        return this.getStyleAttribute(BORDER_LEFT);
    }

    public void jsxSet_borderLeft(String borderLeft) {
        this.setStyleAttribute(BORDER_LEFT, borderLeft);
    }

    public String jsxGet_borderLeftColor() {
        String value = this.getStyleAttribute(BORDER_LEFT_COLOR);
        if (value.length() == 0) {
            value = CSSStyleDeclaration.findColor(this.getStyleAttribute(BORDER_LEFT));
            if (value == null) {
                value = CSSStyleDeclaration.findColor(this.getStyleAttribute(BORDER));
            }
            if (value == null) {
                value = "";
            }
        }
        return value;
    }

    public void jsxSet_borderLeftColor(String borderLeftColor) {
        this.setStyleAttribute(BORDER_LEFT_COLOR, borderLeftColor);
    }

    public String jsxGet_borderLeftStyle() {
        String value = this.getStyleAttribute(BORDER_LEFT_STYLE);
        if (value.length() == 0) {
            value = CSSStyleDeclaration.findBorderStyle(this.getStyleAttribute(BORDER_LEFT));
            if (value == null) {
                value = CSSStyleDeclaration.findBorderStyle(this.getStyleAttribute(BORDER));
            }
            if (value == null) {
                value = "";
            }
        }
        return value;
    }

    public void jsxSet_borderLeftStyle(String borderLeftStyle) {
        this.setStyleAttribute(BORDER_LEFT_STYLE, borderLeftStyle);
    }

    public String jsxGet_borderLeftWidth() {
        return this.getBorderWidth(Shorthand.LEFT);
    }

    private String getBorderWidth(Shorthand side) {
        String value = this.getStyleAttribute("border-" + (Object)((Object)side) + "-width");
        if (value.length() == 0) {
            String[] values;
            String borderWidth;
            value = CSSStyleDeclaration.findBorderWidth(this.getStyleAttribute("border-" + (Object)((Object)side)));
            if (value == null && !StringUtils.isEmpty((String)(borderWidth = this.getStyleAttribute(BORDER_WIDTH))) && (values = VALUES_SPLIT_PATTERN.split(borderWidth, 0)).length > side.ordinal()) {
                value = values[side.ordinal()];
            }
            if (value == null) {
                value = CSSStyleDeclaration.findBorderWidth(this.getStyleAttribute(BORDER));
            }
            if (value == null) {
                value = "";
            }
        }
        return value;
    }

    public void jsxSet_borderLeftWidth(String borderLeftWidth) {
        this.setStyleAttributePixelInt(BORDER_LEFT_WIDTH, borderLeftWidth);
    }

    public String jsxGet_borderRight() {
        return this.getStyleAttribute(BORDER_RIGHT);
    }

    public void jsxSet_borderRight(String borderRight) {
        this.setStyleAttribute(BORDER_RIGHT, borderRight);
    }

    public String jsxGet_borderRightColor() {
        String value = this.getStyleAttribute(BORDER_RIGHT_COLOR);
        if (value.length() == 0) {
            value = CSSStyleDeclaration.findColor(this.getStyleAttribute(BORDER_RIGHT));
            if (value == null) {
                value = CSSStyleDeclaration.findColor(this.getStyleAttribute(BORDER));
            }
            if (value == null) {
                value = "";
            }
        }
        return value;
    }

    public void jsxSet_borderRightColor(String borderRightColor) {
        this.setStyleAttribute(BORDER_RIGHT_COLOR, borderRightColor);
    }

    public String jsxGet_borderRightStyle() {
        String value = this.getStyleAttribute(BORDER_RIGHT_STYLE);
        if (value.length() == 0) {
            value = CSSStyleDeclaration.findBorderStyle(this.getStyleAttribute(BORDER_RIGHT));
            if (value == null) {
                value = CSSStyleDeclaration.findBorderStyle(this.getStyleAttribute(BORDER));
            }
            if (value == null) {
                value = "";
            }
        }
        return value;
    }

    public void jsxSet_borderRightStyle(String borderRightStyle) {
        this.setStyleAttribute(BORDER_RIGHT_STYLE, borderRightStyle);
    }

    public String jsxGet_borderRightWidth() {
        return this.getBorderWidth(Shorthand.RIGHT);
    }

    public void jsxSet_borderRightWidth(String borderRightWidth) {
        this.setStyleAttributePixelInt(BORDER_RIGHT_WIDTH, borderRightWidth);
    }

    public String jsxGet_borderSpacing() {
        return this.getStyleAttribute(BORDER_SPACING);
    }

    public void jsxSet_borderSpacing(String borderSpacing) {
        this.setStyleAttribute(BORDER_SPACING, borderSpacing);
    }

    public String jsxGet_borderStyle() {
        return this.getStyleAttribute(BORDER_STYLE);
    }

    public void jsxSet_borderStyle(String borderStyle) {
        this.setStyleAttribute(BORDER_STYLE, borderStyle);
    }

    public String jsxGet_borderTop() {
        return this.getStyleAttribute(BORDER_TOP);
    }

    public void jsxSet_borderTop(String borderTop) {
        this.setStyleAttribute(BORDER_TOP, borderTop);
    }

    public String jsxGet_borderTopColor() {
        String value = this.getStyleAttribute(BORDER_TOP_COLOR);
        if (value.length() == 0) {
            value = CSSStyleDeclaration.findColor(this.getStyleAttribute(BORDER_TOP));
            if (value == null) {
                value = CSSStyleDeclaration.findColor(this.getStyleAttribute(BORDER));
            }
            if (value == null) {
                value = "";
            }
        }
        return value;
    }

    public void jsxSet_borderTopColor(String borderTopColor) {
        this.setStyleAttribute(BORDER_TOP_COLOR, borderTopColor);
    }

    public String jsxGet_borderTopStyle() {
        String value = this.getStyleAttribute(BORDER_TOP_STYLE);
        if (value.length() == 0) {
            value = CSSStyleDeclaration.findBorderStyle(this.getStyleAttribute(BORDER_TOP));
            if (value == null) {
                value = CSSStyleDeclaration.findBorderStyle(this.getStyleAttribute(BORDER));
            }
            if (value == null) {
                value = "";
            }
        }
        return value;
    }

    public void jsxSet_borderTopStyle(String borderTopStyle) {
        this.setStyleAttribute(BORDER_TOP_STYLE, borderTopStyle);
    }

    public String jsxGet_borderTopWidth() {
        return this.getBorderWidth(Shorthand.TOP);
    }

    public void jsxSet_borderTopWidth(String borderTopWidth) {
        this.setStyleAttributePixelInt(BORDER_TOP_WIDTH, borderTopWidth);
    }

    public String jsxGet_borderWidth() {
        return this.getStyleAttribute(BORDER_WIDTH);
    }

    public void jsxSet_borderWidth(String borderWidth) {
        this.setStyleAttribute(BORDER_WIDTH, borderWidth);
    }

    public String jsxGet_bottom() {
        return this.getStyleAttribute(BOTTOM);
    }

    public void jsxSet_bottom(String bottom) {
        this.setStyleAttributePixelInt(BOTTOM, bottom);
    }

    public String jsxGet_captionSide() {
        return this.getStyleAttribute(CAPTION_SIDE);
    }

    public void jsxSet_captionSide(String captionSide) {
        this.setStyleAttribute(CAPTION_SIDE, captionSide);
    }

    public String jsxGet_clear() {
        return this.getStyleAttribute(CLEAR);
    }

    public void jsxSet_clear(String clear) {
        this.setStyleAttribute(CLEAR, clear);
    }

    public String jsxGet_clip() {
        return this.getStyleAttribute(CLIP);
    }

    public void jsxSet_clip(String clip) {
        this.setStyleAttribute(CLIP, clip);
    }

    public String jsxGet_color() {
        return this.getStyleAttribute(COLOR);
    }

    public void jsxSet_color(String color) {
        this.setStyleAttribute(COLOR, color);
    }

    public String jsxGet_content() {
        return this.getStyleAttribute(CONTENT);
    }

    public void jsxSet_content(String content) {
        this.setStyleAttribute(CONTENT, content);
    }

    public String jsxGet_counterIncrement() {
        return this.getStyleAttribute(COUNTER_INCREMENT);
    }

    public void jsxSet_counterIncrement(String counterIncrement) {
        this.setStyleAttribute(COUNTER_INCREMENT, counterIncrement);
    }

    public String jsxGet_counterReset() {
        return this.getStyleAttribute(COUNTER_RESET);
    }

    public void jsxSet_counterReset(String counterReset) {
        this.setStyleAttribute(COUNTER_RESET, counterReset);
    }

    public String jsxGet_cssFloat() {
        return this.getStyleAttribute(FLOAT);
    }

    public void jsxSet_cssFloat(String value) {
        this.setStyleAttribute(FLOAT, value);
    }

    public String jsxGet_cssText() {
        return this.jsElement_.getDomNodeOrDie().getAttribute("style");
    }

    public void jsxSet_cssText(String value) {
        this.jsElement_.getDomNodeOrDie().setAttribute("style", value);
    }

    public String jsxGet_cue() {
        return this.getStyleAttribute(CUE);
    }

    public void jsxSet_cue(String cue) {
        this.setStyleAttribute(CUE, cue);
    }

    public String jsxGet_cueAfter() {
        return this.getStyleAttribute(CUE_AFTER);
    }

    public void jsxSet_cueAfter(String cueAfter) {
        this.setStyleAttribute(CUE_AFTER, cueAfter);
    }

    public String jsxGet_cueBefore() {
        return this.getStyleAttribute(CUE_BEFORE);
    }

    public void jsxSet_cueBefore(String cueBefore) {
        this.setStyleAttribute(CUE_BEFORE, cueBefore);
    }

    public String jsxGet_cursor() {
        return this.getStyleAttribute(CURSOR);
    }

    public void jsxSet_cursor(String cursor) {
        this.setStyleAttribute(CURSOR, cursor);
    }

    public String jsxGet_direction() {
        return this.getStyleAttribute(DIRECTION);
    }

    public void jsxSet_direction(String direction) {
        this.setStyleAttribute(DIRECTION, direction);
    }

    public String jsxGet_display() {
        return this.getStyleAttribute(DISPLAY);
    }

    public void jsxSet_display(String display) {
        this.setStyleAttribute(DISPLAY, display);
    }

    public String jsxGet_elevation() {
        return this.getStyleAttribute(ELEVATION);
    }

    public void jsxSet_elevation(String elevation) {
        this.setStyleAttribute(ELEVATION, elevation);
    }

    public String jsxGet_emptyCells() {
        return this.getStyleAttribute(EMPTY_CELLS);
    }

    public void jsxSet_emptyCells(String emptyCells) {
        this.setStyleAttribute(EMPTY_CELLS, emptyCells);
    }

    public String jsxGet_filter() {
        return this.getStyleAttribute(FILTER);
    }

    public void jsxSet_filter(String filter) {
        this.setStyleAttribute(FILTER, filter);
    }

    public String jsxGet_font() {
        return this.getStyleAttribute(FONT);
    }

    public void jsxSet_font(String font) {
        this.setStyleAttribute(FONT, font);
    }

    public String jsxGet_fontFamily() {
        return this.getStyleAttribute(FONT_FAMILY);
    }

    public void jsxSet_fontFamily(String fontFamily) {
        this.setStyleAttribute(FONT_FAMILY, fontFamily);
    }

    public String jsxGet_fontSize() {
        return this.getStyleAttribute(FONT_SIZE);
    }

    public void jsxSet_fontSize(String fontSize) {
        this.setStyleAttributePixelInt(FONT_SIZE, fontSize);
    }

    public String jsxGet_fontSizeAdjust() {
        return this.getStyleAttribute(FONT_SIZE_ADJUST);
    }

    public void jsxSet_fontSizeAdjust(String fontSizeAdjust) {
        this.setStyleAttribute(FONT_SIZE_ADJUST, fontSizeAdjust);
    }

    public String jsxGet_fontStretch() {
        return this.getStyleAttribute(FONT_STRETCH);
    }

    public void jsxSet_fontStretch(String fontStretch) {
        this.setStyleAttribute(FONT_STRETCH, fontStretch);
    }

    public String jsxGet_fontStyle() {
        return this.getStyleAttribute(FONT_STYLE);
    }

    public void jsxSet_fontStyle(String fontStyle) {
        this.setStyleAttribute(FONT_STYLE, fontStyle);
    }

    public String jsxGet_fontVariant() {
        return this.getStyleAttribute(FONT_VARIANT);
    }

    public void jsxSet_fontVariant(String fontVariant) {
        this.setStyleAttribute(FONT_VARIANT, fontVariant);
    }

    public String jsxGet_fontWeight() {
        return this.getStyleAttribute(FONT_WEIGHT);
    }

    public void jsxSet_fontWeight(String fontWeight) {
        this.setStyleAttribute(FONT_WEIGHT, fontWeight);
    }

    public String jsxGet_height() {
        return this.getStyleAttribute(HEIGHT);
    }

    public void jsxSet_height(String height) {
        this.setStyleAttributePixelInt(HEIGHT, height);
    }

    public String jsxGet_imeMode() {
        return this.getStyleAttribute(IME_MODE);
    }

    public void jsxSet_imeMode(String imeMode) {
        this.setStyleAttribute(IME_MODE, imeMode);
    }

    public String jsxGet_layoutFlow() {
        return this.getStyleAttribute(LAYOUT_FLOW);
    }

    public void jsxSet_layoutFlow(String layoutFlow) {
        this.setStyleAttribute(LAYOUT_FLOW, layoutFlow);
    }

    public String jsxGet_layoutGrid() {
        return this.getStyleAttribute(LAYOUT_GRID);
    }

    public void jsxSet_layoutGrid(String layoutGrid) {
        this.setStyleAttribute(LAYOUT_GRID_CHAR, layoutGrid);
    }

    public String jsxGet_layoutGridChar() {
        return this.getStyleAttribute(LAYOUT_GRID_CHAR);
    }

    public void jsxSet_layoutGridChar(String layoutGridChar) {
        this.setStyleAttribute(LAYOUT_GRID_CHAR, layoutGridChar);
    }

    public String jsxGet_layoutGridLine() {
        return this.getStyleAttribute(LAYOUT_GRID_LINE);
    }

    public void jsxSet_layoutGridLine(String layoutGridLine) {
        this.setStyleAttribute(LAYOUT_GRID_LINE, layoutGridLine);
    }

    public String jsxGet_layoutGridMode() {
        return this.getStyleAttribute(LAYOUT_GRID_MODE);
    }

    public void jsxSet_layoutGridMode(String layoutGridMode) {
        this.setStyleAttribute(LAYOUT_GRID_MODE, layoutGridMode);
    }

    public String jsxGet_layoutGridType() {
        return this.getStyleAttribute(LAYOUT_GRID_TYPE);
    }

    public void jsxSet_layoutGridType(String layoutGridType) {
        this.setStyleAttribute(LAYOUT_GRID_TYPE, layoutGridType);
    }

    public String jsxGet_left() {
        return this.getStyleAttribute(LEFT);
    }

    public void jsxSet_left(String left) {
        this.setStyleAttributePixelInt(LEFT, left);
    }

    public int jsxGet_length() {
        return 0;
    }

    public String jsxGet_letterSpacing() {
        return this.getStyleAttribute(LETTER_SPACING);
    }

    public void jsxSet_letterSpacing(String letterSpacing) {
        this.setStyleAttributePixelInt(LETTER_SPACING, letterSpacing);
    }

    public String jsxGet_lineBreak() {
        return this.getStyleAttribute(LINE_BREAK);
    }

    public void jsxSet_lineBreak(String lineBreak) {
        this.setStyleAttribute(LINE_BREAK, lineBreak);
    }

    public String jsxGet_lineHeight() {
        return this.getStyleAttribute(LINE_HEIGHT);
    }

    public void jsxSet_lineHeight(String lineHeight) {
        this.setStyleAttribute(LINE_HEIGHT, lineHeight);
    }

    public String jsxGet_listStyle() {
        return this.getStyleAttribute(LIST_STYLE);
    }

    public void jsxSet_listStyle(String listStyle) {
        this.setStyleAttribute(LIST_STYLE, listStyle);
    }

    public String jsxGet_listStyleImage() {
        return this.getStyleAttribute(LIST_STYLE_IMAGE);
    }

    public void jsxSet_listStyleImage(String listStyleImage) {
        this.setStyleAttribute(LIST_STYLE_IMAGE, listStyleImage);
    }

    public String jsxGet_listStylePosition() {
        return this.getStyleAttribute(LIST_STYLE_POSITION);
    }

    public void jsxSet_listStylePosition(String listStylePosition) {
        this.setStyleAttribute(LIST_STYLE_POSITION, listStylePosition);
    }

    public String jsxGet_listStyleType() {
        return this.getStyleAttribute(LIST_STYLE_TYPE);
    }

    public void jsxSet_listStyleType(String listStyleType) {
        this.setStyleAttribute(LIST_STYLE_TYPE, listStyleType);
    }

    public String jsxGet_margin() {
        return this.getStyleAttribute(MARGIN);
    }

    public void jsxSet_margin(String margin) {
        this.setStyleAttribute(MARGIN, margin);
    }

    public String jsxGet_marginBottom() {
        return this.getStyleAttribute(MARGIN_BOTTOM, MARGIN, Shorthand.BOTTOM);
    }

    public void jsxSet_marginBottom(String marginBottom) {
        this.setStyleAttributePixelInt(MARGIN_BOTTOM, marginBottom);
    }

    public String jsxGet_marginLeft() {
        return this.getStyleAttribute(MARGIN_LEFT, MARGIN, Shorthand.LEFT);
    }

    public void jsxSet_marginLeft(String marginLeft) {
        this.setStyleAttributePixelInt(MARGIN_LEFT, marginLeft);
    }

    public String jsxGet_marginRight() {
        return this.getStyleAttribute(MARGIN_RIGHT, MARGIN, Shorthand.RIGHT);
    }

    public void jsxSet_marginRight(String marginRight) {
        this.setStyleAttributePixelInt(MARGIN_RIGHT, marginRight);
    }

    public String jsxGet_marginTop() {
        return this.getStyleAttribute(MARGIN_TOP, MARGIN, Shorthand.TOP);
    }

    public void jsxSet_marginTop(String marginTop) {
        this.setStyleAttributePixelInt(MARGIN_TOP, marginTop);
    }

    public String jsxGet_markerOffset() {
        return this.getStyleAttribute(MARKER_OFFSET);
    }

    public void jsxSet_markerOffset(String markerOffset) {
        this.setStyleAttribute(MARKER_OFFSET, markerOffset);
    }

    public String jsxGet_marks() {
        return this.getStyleAttribute(MARKS);
    }

    public void jsxSet_marks(String marks) {
        this.setStyleAttribute(MARKS, marks);
    }

    public String jsxGet_maxHeight() {
        return this.getStyleAttribute(MAX_HEIGHT);
    }

    public void jsxSet_maxHeight(String maxHeight) {
        this.setStyleAttributePixelInt(MAX_HEIGHT, maxHeight);
    }

    public String jsxGet_maxWidth() {
        return this.getStyleAttribute(MAX_WIDTH);
    }

    public void jsxSet_maxWidth(String maxWidth) {
        this.setStyleAttributePixelInt(MAX_WIDTH, maxWidth);
    }

    public String jsxGet_minHeight() {
        return this.getStyleAttribute(MIN_HEIGHT);
    }

    public void jsxSet_minHeight(String minHeight) {
        this.setStyleAttributePixelInt(MIN_HEIGHT, minHeight);
    }

    public String jsxGet_minWidth() {
        return this.getStyleAttribute(MIN_WIDTH);
    }

    public void jsxSet_minWidth(String minWidth) {
        this.setStyleAttributePixelInt(MIN_WIDTH, minWidth);
    }

    public String jsxGet_MozAppearance() {
        return this.getStyleAttribute(MOZ_APPEARANCE);
    }

    public void jsxSet_MozAppearance(String mozAppearance) {
        this.setStyleAttribute(MOZ_APPEARANCE, mozAppearance);
    }

    public String jsxGet_MozBackgroundClip() {
        return this.getStyleAttribute(MOZ_BACKGROUND_CLIP);
    }

    public void jsxSet_MozBackgroundClip(String mozBackgroundClip) {
        this.setStyleAttribute(MOZ_BACKGROUND_CLIP, mozBackgroundClip);
    }

    public String jsxGet_MozBackgroundInlinePolicy() {
        return this.getStyleAttribute(MOZ_BACKGROUND_INLINE_POLICY);
    }

    public void jsxSet_MozBackgroundInlinePolicy(String mozBackgroundInlinePolicy) {
        this.setStyleAttribute(MOZ_BACKGROUND_INLINE_POLICY, mozBackgroundInlinePolicy);
    }

    public String jsxGet_MozBackgroundOrigin() {
        return this.getStyleAttribute(MOZ_BACKGROUND_ORIGIN);
    }

    public void jsxSet_MozBackgroundOrigin(String mozBackgroundOrigin) {
        this.setStyleAttribute(MOZ_BACKGROUND_ORIGIN, mozBackgroundOrigin);
    }

    public String jsxGet_MozBinding() {
        return this.getStyleAttribute(MOZ_BINDING);
    }

    public void jsxSet_MozBinding(String mozBinding) {
        this.setStyleAttribute(MOZ_BINDING, mozBinding);
    }

    public String jsxGet_MozBorderBottomColors() {
        return this.getStyleAttribute(MOZ_BORDER_BOTTOM_COLORS);
    }

    public void jsxSet_MozBorderBottomColors(String mozBorderBottomColors) {
        this.setStyleAttribute(MOZ_BORDER_BOTTOM_COLORS, mozBorderBottomColors);
    }

    public String jsxGet_MozBorderLeftColors() {
        return this.getStyleAttribute(MOZ_BORDER_LEFT_COLORS);
    }

    public void jsxSet_MozBorderLeftColors(String mozBorderLeftColors) {
        this.setStyleAttribute(MOZ_BORDER_LEFT_COLORS, mozBorderLeftColors);
    }

    public String jsxGet_MozBorderRadius() {
        return this.getStyleAttribute(MOZ_BORDER_RADIUS);
    }

    public void jsxSet_MozBorderRadius(String mozBorderRadius) {
        this.setStyleAttribute(MOZ_BORDER_RADIUS, mozBorderRadius);
    }

    public String jsxGet_MozBorderRadiusBottomleft() {
        return this.getStyleAttribute(MOZ_BORDER_RADIUS_BOTTOMLEFT);
    }

    public void jsxSet_MozBorderRadiusBottomleft(String mozBorderRadiusBottomleft) {
        this.setStyleAttribute(MOZ_BORDER_RADIUS_BOTTOMLEFT, mozBorderRadiusBottomleft);
    }

    public String jsxGet_MozBorderRadiusBottomright() {
        return this.getStyleAttribute(MOZ_BORDER_RADIUS_BOTTOMRIGHT);
    }

    public void jsxSet_MozBorderRadiusBottomright(String mozBorderRadiusBottomright) {
        this.setStyleAttribute(MOZ_BORDER_RADIUS_BOTTOMRIGHT, mozBorderRadiusBottomright);
    }

    public String jsxGet_MozBorderRadiusTopleft() {
        return this.getStyleAttribute(MOZ_BORDER_RADIUS_TOPLEFT);
    }

    public void jsxSet_MozBorderRadiusTopleft(String mozBorderRadiusTopleft) {
        this.setStyleAttribute(MOZ_BORDER_RADIUS_TOPLEFT, mozBorderRadiusTopleft);
    }

    public String jsxGet_MozBorderRadiusTopright() {
        return this.getStyleAttribute(MOZ_BORDER_RADIUS_TOPRIGHT);
    }

    public void jsxSet_MozBorderRadiusTopright(String mozBorderRadiusTopright) {
        this.setStyleAttribute(MOZ_BORDER_RADIUS_TOPRIGHT, mozBorderRadiusTopright);
    }

    public String jsxGet_MozBorderRightColors() {
        return this.getStyleAttribute(MOZ_BORDER_RIGHT_COLORS);
    }

    public void jsxSet_MozBorderRightColors(String mozBorderRightColors) {
        this.setStyleAttribute(MOZ_BORDER_RIGHT_COLORS, mozBorderRightColors);
    }

    public String jsxGet_MozBorderTopColors() {
        return this.getStyleAttribute(MOZ_BORDER_TOP_COLORS);
    }

    public void jsxSet_MozBorderTopColors(String mozBorderTopColors) {
        this.setStyleAttribute(MOZ_BORDER_TOP_COLORS, mozBorderTopColors);
    }

    public String jsxGet_MozBoxAlign() {
        return this.getStyleAttribute(MOZ_BOX_ALIGN);
    }

    public void jsxSet_MozBoxAlign(String mozBoxAlign) {
        this.setStyleAttribute(MOZ_BOX_ALIGN, mozBoxAlign);
    }

    public String jsxGet_MozBoxDirection() {
        return this.getStyleAttribute(MOZ_BOX_DIRECTION);
    }

    public void jsxSet_MozBoxDirection(String mozBoxDirection) {
        this.setStyleAttribute(MOZ_BOX_DIRECTION, mozBoxDirection);
    }

    public String jsxGet_MozBoxFlex() {
        return this.getStyleAttribute(MOZ_BOX_FLEX);
    }

    public void jsxSet_MozBoxFlex(String mozBoxFlex) {
        this.setStyleAttribute(MOZ_BOX_FLEX, mozBoxFlex);
    }

    public String jsxGet_MozBoxOrdinalGroup() {
        return this.getStyleAttribute(MOZ_BOX_ORDINAL_GROUP);
    }

    public void jsxSet_MozBoxOrdinalGroup(String mozBoxOrdinalGroup) {
        this.setStyleAttribute(MOZ_BOX_ORDINAL_GROUP, mozBoxOrdinalGroup);
    }

    public String jsxGet_MozBoxOrient() {
        return this.getStyleAttribute(MOZ_BOX_ORIENT);
    }

    public void jsxSet_MozBoxOrient(String mozBoxOrient) {
        this.setStyleAttribute(MOZ_BOX_ORIENT, mozBoxOrient);
    }

    public String jsxGet_MozBoxPack() {
        return this.getStyleAttribute(MOZ_BOX_PACK);
    }

    public void jsxSet_MozBoxPack(String mozBoxPack) {
        this.setStyleAttribute(MOZ_BOX_PACK, mozBoxPack);
    }

    public String jsxGet_MozBoxSizing() {
        return this.getStyleAttribute(MOZ_BOX_SIZING);
    }

    public void jsxSet_MozBoxSizing(String mozBoxSizing) {
        this.setStyleAttribute(MOZ_BOX_SIZING, mozBoxSizing);
    }

    public String jsxGet_MozColumnCount() {
        return this.getStyleAttribute(MOZ_COLUMN_COUNT);
    }

    public void jsxSet_MozColumnCount(String mozColumnCount) {
        this.setStyleAttribute(MOZ_COLUMN_COUNT, mozColumnCount);
    }

    public String jsxGet_MozColumnGap() {
        return this.getStyleAttribute(MOZ_COLUMN_GAP);
    }

    public void jsxSet_MozColumnGap(String mozColumnGap) {
        this.setStyleAttribute(MOZ_COLUMN_GAP, mozColumnGap);
    }

    public String jsxGet_MozColumnWidth() {
        return this.getStyleAttribute(MOZ_COLUMN_WIDTH);
    }

    public void jsxSet_MozColumnWidth(String mozColumnWidth) {
        this.setStyleAttribute(MOZ_COLUMN_WIDTH, mozColumnWidth);
    }

    public String jsxGet_MozFloatEdge() {
        return this.getStyleAttribute(MOZ_FLOAT_EDGE);
    }

    public void jsxSet_MozFloatEdge(String mozFloatEdge) {
        this.setStyleAttribute(MOZ_FLOAT_EDGE, mozFloatEdge);
    }

    public String jsxGet_MozForceBrokenImageIcon() {
        return this.getStyleAttribute(MOZ_FORCE_BROKEN_IMAGE_ICON);
    }

    public void jsxSet_MozForceBrokenImageIcon(String mozForceBrokenImageIcon) {
        this.setStyleAttribute(MOZ_FORCE_BROKEN_IMAGE_ICON, mozForceBrokenImageIcon);
    }

    public String jsxGet_MozImageRegion() {
        return this.getStyleAttribute(MOZ_IMAGE_REGION);
    }

    public void jsxSet_MozImageRegion(String mozImageRegion) {
        this.setStyleAttribute(MOZ_IMAGE_REGION, mozImageRegion);
    }

    public String jsxGet_MozMarginEnd() {
        return this.getStyleAttribute(MOZ_MARGIN_END);
    }

    public void jsxSet_MozMarginEnd(String mozMarginEnd) {
        this.setStyleAttribute(MOZ_MARGIN_END, mozMarginEnd);
    }

    public String jsxGet_MozMarginStart() {
        return this.getStyleAttribute(MOZ_MARGIN_START);
    }

    public void jsxSet_MozMarginStart(String mozMarginStart) {
        this.setStyleAttribute(MOZ_MARGIN_START, mozMarginStart);
    }

    public String jsxGet_MozOpacity() {
        return this.getStyleAttribute(MOZ_OPACITY);
    }

    public void jsxSet_MozOpacity(String mozOpacity) {
        this.setStyleAttribute(MOZ_OPACITY, mozOpacity);
    }

    public String jsxGet_MozOutline() {
        return this.getStyleAttribute(MOZ_OUTLINE);
    }

    public void jsxSet_MozOutline(String mozOutline) {
        this.setStyleAttribute(MOZ_OUTLINE, mozOutline);
    }

    public String jsxGet_MozOutlineColor() {
        return this.getStyleAttribute(MOZ_OUTLINE_COLOR);
    }

    public void jsxSet_MozOutlineColor(String mozOutlineColor) {
        this.setStyleAttribute(MOZ_OUTLINE_COLOR, mozOutlineColor);
    }

    public String jsxGet_MozOutlineOffset() {
        return this.getStyleAttribute(MOZ_OUTLINE_OFFSET);
    }

    public void jsxSet_MozOutlineOffset(String mozOutlineOffset) {
        this.setStyleAttribute(MOZ_OUTLINE_OFFSET, mozOutlineOffset);
    }

    public String jsxGet_MozOutlineRadius() {
        return this.getStyleAttribute(MOZ_OUTLINE_RADIUS);
    }

    public void jsxSet_MozOutlineRadius(String mozOutlineRadius) {
        this.setStyleAttribute(MOZ_OUTLINE_RADIUS, mozOutlineRadius);
    }

    public String jsxGet_MozOutlineRadiusBottomleft() {
        return this.getStyleAttribute(MOZ_OUTLINE_RADIUS_BOTTOMLEFT);
    }

    public void jsxSet_MozOutlineRadiusBottomleft(String mozOutlineRadiusBottomleft) {
        this.setStyleAttribute(MOZ_OUTLINE_RADIUS_BOTTOMLEFT, mozOutlineRadiusBottomleft);
    }

    public String jsxGet_MozOutlineRadiusBottomright() {
        return this.getStyleAttribute(MOZ_OUTLINE_RADIUS_BOTTOMRIGHT);
    }

    public void jsxSet_MozOutlineRadiusBottomright(String mozOutlineRadiusBottomright) {
        this.setStyleAttribute(MOZ_OUTLINE_RADIUS_BOTTOMRIGHT, mozOutlineRadiusBottomright);
    }

    public String jsxGet_MozOutlineRadiusTopleft() {
        return this.getStyleAttribute(MOZ_OUTLINE_RADIUS_TOPLEFT);
    }

    public void jsxSet_MozOutlineRadiusTopleft(String mozOutlineRadiusTopleft) {
        this.setStyleAttribute(MOZ_OUTLINE_RADIUS_TOPLEFT, mozOutlineRadiusTopleft);
    }

    public String jsxGet_MozOutlineRadiusTopright() {
        return this.getStyleAttribute(MOZ_OUTLINE_RADIUS_TOPRIGHT);
    }

    public void jsxSet_MozOutlineRadiusTopright(String mozOutlineRadiusTopright) {
        this.setStyleAttribute(MOZ_OUTLINE_RADIUS_TOPRIGHT, mozOutlineRadiusTopright);
    }

    public String jsxGet_MozOutlineStyle() {
        return this.getStyleAttribute(MOZ_OUTLINE_STYLE);
    }

    public void jsxSet_MozOutlineStyle(String mozOutlineStyle) {
        this.setStyleAttribute(MOZ_OUTLINE_STYLE, mozOutlineStyle);
    }

    public String jsxGet_MozOutlineWidth() {
        return this.getStyleAttribute(MOZ_OUTLINE_WIDTH);
    }

    public void jsxSet_MozOutlineWidth(String mozOutlineWidth) {
        this.setStyleAttribute(MOZ_OUTLINE_WIDTH, mozOutlineWidth);
    }

    public String jsxGet_MozPaddingEnd() {
        return this.getStyleAttribute(MOZ_PADDING_END);
    }

    public void jsxSet_MozPaddingEnd(String mozPaddingEnd) {
        this.setStyleAttribute(MOZ_PADDING_END, mozPaddingEnd);
    }

    public String jsxGet_MozPaddingStart() {
        return this.getStyleAttribute(MOZ_PADDING_START);
    }

    public void jsxSet_MozPaddingStart(String mozPaddingStart) {
        this.setStyleAttribute(MOZ_PADDING_START, mozPaddingStart);
    }

    public String jsxGet_MozUserFocus() {
        return this.getStyleAttribute(MOZ_USER_FOCUS);
    }

    public void jsxSet_MozUserFocus(String mozUserFocus) {
        this.setStyleAttribute(MOZ_USER_FOCUS, mozUserFocus);
    }

    public String jsxGet_MozUserInput() {
        return this.getStyleAttribute(MOZ_USER_INPUT);
    }

    public void jsxSet_MozUserInput(String mozUserInput) {
        this.setStyleAttribute(MOZ_USER_INPUT, mozUserInput);
    }

    public String jsxGet_MozUserModify() {
        return this.getStyleAttribute(MOZ_USER_MODIFY);
    }

    public void jsxSet_MozUserModify(String mozUserModify) {
        this.setStyleAttribute(MOZ_USER_MODIFY, mozUserModify);
    }

    public String jsxGet_MozUserSelect() {
        return this.getStyleAttribute(MOZ_USER_SELECT);
    }

    public void jsxSet_MozUserSelect(String mozUserSelect) {
        this.setStyleAttribute(MOZ_USER_SELECT, mozUserSelect);
    }

    public String jsxGet_msInterpolationMode() {
        return this.getStyleAttribute(MS_INTERPOLATION_MODE);
    }

    public void jsxSet_msInterpolationMode(String msInterpolationMode) {
        this.setStyleAttribute(MS_INTERPOLATION_MODE, msInterpolationMode);
    }

    public String jsxGet_opacity() {
        return this.getStyleAttribute(OPACITY);
    }

    public void jsxSet_opacity(String opacity) {
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_23)) {
            this.setStyleAttribute(OPACITY, opacity);
        } else if (com.gargoylesoftware.htmlunit.util.StringUtils.isFloat(opacity, true) || opacity.length() == 0) {
            this.setStyleAttribute(OPACITY, opacity.trim());
        }
    }

    public String jsxGet_orphans() {
        return this.getStyleAttribute(ORPHANS);
    }

    public void jsxSet_orphans(String orphans) {
        this.setStyleAttribute(ORPHANS, orphans);
    }

    public String jsxGet_outline() {
        return this.getStyleAttribute(OUTLINE);
    }

    public void jsxSet_outline(String outline) {
        this.setStyleAttribute(OUTLINE, outline);
    }

    public String jsxGet_outlineColor() {
        return this.getStyleAttribute(OUTLINE_COLOR);
    }

    public void jsxSet_outlineColor(String outlineColor) {
        this.setStyleAttribute(OUTLINE_COLOR, outlineColor);
    }

    public String jsxGet_outlineOffset() {
        return this.getStyleAttribute(OUTLINE_OFFSET);
    }

    public void jsxSet_outlineOffset(String outlineOffset) {
        this.setStyleAttribute(OUTLINE_OFFSET, outlineOffset);
    }

    public String jsxGet_outlineStyle() {
        return this.getStyleAttribute(OUTLINE_STYLE);
    }

    public void jsxSet_outlineStyle(String outlineStyle) {
        this.setStyleAttribute(OUTLINE_STYLE, outlineStyle);
    }

    public String jsxGet_outlineWidth() {
        return this.getStyleAttribute(OUTLINE_WIDTH);
    }

    public void jsxSet_outlineWidth(String outlineWidth) {
        this.setStyleAttributePixelInt(OUTLINE_WIDTH, outlineWidth);
    }

    public String jsxGet_overflow() {
        return this.getStyleAttribute(OVERFLOW);
    }

    public void jsxSet_overflow(String overflow) {
        this.setStyleAttribute(OVERFLOW, overflow);
    }

    public String jsxGet_overflowX() {
        return this.getStyleAttribute(OVERFLOW_X);
    }

    public void jsxSet_overflowX(String overflowX) {
        this.setStyleAttribute(OVERFLOW_X, overflowX);
    }

    public String jsxGet_overflowY() {
        return this.getStyleAttribute(OVERFLOW_Y);
    }

    public void jsxSet_overflowY(String overflowY) {
        this.setStyleAttribute(OVERFLOW_Y, overflowY);
    }

    public String jsxGet_padding() {
        return this.getStyleAttribute(PADDING);
    }

    public void jsxSet_padding(String padding) {
        this.setStyleAttribute(PADDING, padding);
    }

    public String jsxGet_paddingBottom() {
        return this.getStyleAttribute(PADDING_BOTTOM, PADDING, Shorthand.BOTTOM);
    }

    public void jsxSet_paddingBottom(String paddingBottom) {
        this.setStyleAttributePixelInt(PADDING_BOTTOM, paddingBottom);
    }

    public String jsxGet_paddingLeft() {
        return this.getStyleAttribute(PADDING_LEFT, PADDING, Shorthand.LEFT);
    }

    public void jsxSet_paddingLeft(String paddingLeft) {
        this.setStyleAttributePixelInt(PADDING_LEFT, paddingLeft);
    }

    public String jsxGet_paddingRight() {
        return this.getStyleAttribute(PADDING_RIGHT, PADDING, Shorthand.RIGHT);
    }

    public void jsxSet_paddingRight(String paddingRight) {
        this.setStyleAttributePixelInt(PADDING_RIGHT, paddingRight);
    }

    public String jsxGet_paddingTop() {
        return this.getStyleAttribute(PADDING_TOP, PADDING, Shorthand.TOP);
    }

    public void jsxSet_paddingTop(String paddingTop) {
        this.setStyleAttributePixelInt(PADDING_TOP, paddingTop);
    }

    public String jsxGet_page() {
        return this.getStyleAttribute(PAGE);
    }

    public void jsxSet_page(String page) {
        this.setStyleAttribute(PAGE, page);
    }

    public String jsxGet_pageBreakAfter() {
        return this.getStyleAttribute(PAGE_BREAK_AFTER);
    }

    public void jsxSet_pageBreakAfter(String pageBreakAfter) {
        this.setStyleAttribute(PAGE_BREAK_AFTER, pageBreakAfter);
    }

    public String jsxGet_pageBreakBefore() {
        return this.getStyleAttribute(PAGE_BREAK_BEFORE);
    }

    public void jsxSet_pageBreakBefore(String pageBreakBefore) {
        this.setStyleAttribute(PAGE_BREAK_BEFORE, pageBreakBefore);
    }

    public String jsxGet_pageBreakInside() {
        return this.getStyleAttribute(PAGE_BREAK_INSIDE);
    }

    public void jsxSet_pageBreakInside(String pageBreakInside) {
        this.setStyleAttribute(PAGE_BREAK_INSIDE, pageBreakInside);
    }

    public String jsxGet_pause() {
        return this.getStyleAttribute(PAUSE);
    }

    public void jsxSet_pause(String pause) {
        this.setStyleAttribute(PAUSE, pause);
    }

    public String jsxGet_pauseAfter() {
        return this.getStyleAttribute(PAUSE_AFTER);
    }

    public void jsxSet_pauseAfter(String pauseAfter) {
        this.setStyleAttribute(PAUSE_AFTER, pauseAfter);
    }

    public String jsxGet_pauseBefore() {
        return this.getStyleAttribute(PAUSE_BEFORE);
    }

    public void jsxSet_pauseBefore(String pauseBefore) {
        this.setStyleAttribute(PAUSE_BEFORE, pauseBefore);
    }

    public String jsxGet_pitch() {
        return this.getStyleAttribute(PITCH);
    }

    public void jsxSet_pitch(String pitch) {
        this.setStyleAttribute(PITCH, pitch);
    }

    public String jsxGet_pitchRange() {
        return this.getStyleAttribute(PITCH_RANGE);
    }

    public void jsxSet_pitchRange(String pitchRange) {
        this.setStyleAttribute(PITCH_RANGE, pitchRange);
    }

    public int jsxGet_pixelBottom() {
        return CSSStyleDeclaration.pixelValue(this.jsxGet_bottom());
    }

    public void jsxSet_pixelBottom(int pixelBottom) {
        this.jsxSet_bottom(pixelBottom + "px");
    }

    public int jsxGet_pixelLeft() {
        return CSSStyleDeclaration.pixelValue(this.jsxGet_left());
    }

    public void jsxSet_pixelLeft(int pixelLeft) {
        this.jsxSet_left(pixelLeft + "px");
    }

    public int jsxGet_pixelRight() {
        return CSSStyleDeclaration.pixelValue(this.jsxGet_right());
    }

    public void jsxSet_pixelRight(int pixelRight) {
        this.jsxSet_right(pixelRight + "px");
    }

    public int jsxGet_pixelTop() {
        return CSSStyleDeclaration.pixelValue(this.jsxGet_top());
    }

    public void jsxSet_pixelTop(int pixelTop) {
        this.jsxSet_top(pixelTop + "px");
    }

    public int jsxGet_posBottom() {
        return 0;
    }

    public void jsxSet_posBottom(int posBottom) {
    }

    public int jsxGet_posHeight() {
        return 0;
    }

    public void jsxSet_posHeight(int posHeight) {
    }

    public String jsxGet_position() {
        return this.getStyleAttribute(POSITION);
    }

    public void jsxSet_position(String position) {
        this.setStyleAttribute(POSITION, position);
    }

    public int jsxGet_posLeft() {
        return 0;
    }

    public void jsxSet_posLeft(int posLeft) {
    }

    public int jsxGet_posRight() {
        return 0;
    }

    public void jsxSet_posRight(int posRight) {
    }

    public int jsxGet_posTop() {
        return 0;
    }

    public void jsxSet_posTop(int posTop) {
    }

    public int jsxGet_posWidth() {
        return 0;
    }

    public void jsxSet_posWidth(int posWidth) {
    }

    public String jsxGet_quotes() {
        return this.getStyleAttribute(QUOTES);
    }

    public void jsxSet_quotes(String quotes) {
        this.setStyleAttribute(QUOTES, quotes);
    }

    public String jsxGet_richness() {
        return this.getStyleAttribute(RICHNESS);
    }

    public void jsxSet_richness(String richness) {
        this.setStyleAttribute(RICHNESS, richness);
    }

    public String jsxGet_right() {
        return this.getStyleAttribute(RIGHT);
    }

    public void jsxSet_right(String right) {
        this.setStyleAttributePixelInt(RIGHT, right);
    }

    public String jsxGet_rubyAlign() {
        return this.getStyleAttribute(RUBY_ALIGN);
    }

    public void jsxSet_rubyAlign(String rubyAlign) {
        this.setStyleAttribute(RUBY_ALIGN, rubyAlign);
    }

    public String jsxGet_rubyOverhang() {
        return this.getStyleAttribute(RUBY_OVERHANG);
    }

    public void jsxSet_rubyOverhang(String rubyOverhang) {
        this.setStyleAttribute(RUBY_OVERHANG, rubyOverhang);
    }

    public String jsxGet_rubyPosition() {
        return this.getStyleAttribute(RUBY_POSITION);
    }

    public void jsxSet_rubyPosition(String rubyPosition) {
        this.setStyleAttribute(RUBY_POSITION, rubyPosition);
    }

    public String jsxGet_scrollbar3dLightColor() {
        return this.getStyleAttribute(SCROLLBAR3D_LIGHT_COLOR);
    }

    public void jsxSet_scrollbar3dLightColor(String scrollbar3dLightColor) {
        this.setStyleAttribute(SCROLLBAR3D_LIGHT_COLOR, scrollbar3dLightColor);
    }

    public String jsxGet_scrollbarArrowColor() {
        return this.getStyleAttribute(SCROLLBAR_ARROW_COLOR);
    }

    public void jsxSet_scrollbarArrowColor(String scrollbarArrowColor) {
        this.setStyleAttribute(SCROLLBAR_ARROW_COLOR, scrollbarArrowColor);
    }

    public String jsxGet_scrollbarBaseColor() {
        return this.getStyleAttribute(SCROLLBAR_BASE_COLOR);
    }

    public void jsxSet_scrollbarBaseColor(String scrollbarBaseColor) {
        this.setStyleAttribute(SCROLLBAR_BASE_COLOR, scrollbarBaseColor);
    }

    public String jsxGet_scrollbarDarkShadowColor() {
        return this.getStyleAttribute(SCROLLBAR_DARK_SHADOW_COLOR);
    }

    public void jsxSet_scrollbarDarkShadowColor(String scrollbarDarkShadowColor) {
        this.setStyleAttribute(SCROLLBAR_DARK_SHADOW_COLOR, scrollbarDarkShadowColor);
    }

    public String jsxGet_scrollbarFaceColor() {
        return this.getStyleAttribute(SCROLLBAR_FACE_COLOR);
    }

    public void jsxSet_scrollbarFaceColor(String scrollbarFaceColor) {
        this.setStyleAttribute(SCROLLBAR_FACE_COLOR, scrollbarFaceColor);
    }

    public String jsxGet_scrollbarHighlightColor() {
        return this.getStyleAttribute(SCROLLBAR_HIGHLIGHT_COLOR);
    }

    public void jsxSet_scrollbarHighlightColor(String scrollbarHighlightColor) {
        this.setStyleAttribute(SCROLLBAR_HIGHLIGHT_COLOR, scrollbarHighlightColor);
    }

    public String jsxGet_scrollbarShadowColor() {
        return this.getStyleAttribute(SCROLLBAR_SHADOW_COLOR);
    }

    public void jsxSet_scrollbarShadowColor(String scrollbarShadowColor) {
        this.setStyleAttribute(SCROLLBAR_SHADOW_COLOR, scrollbarShadowColor);
    }

    public String jsxGet_scrollbarTrackColor() {
        return this.getStyleAttribute(SCROLLBAR_TRACK_COLOR);
    }

    public void jsxSet_scrollbarTrackColor(String scrollbarTrackColor) {
        this.setStyleAttribute(SCROLLBAR_TRACK_COLOR, scrollbarTrackColor);
    }

    public String jsxGet_size() {
        return this.getStyleAttribute(SIZE);
    }

    public void jsxSet_size(String size) {
        this.setStyleAttribute(SIZE, size);
    }

    public String jsxGet_speak() {
        return this.getStyleAttribute(SPEAK);
    }

    public void jsxSet_speak(String speak) {
        this.setStyleAttribute(SPEAK, speak);
    }

    public String jsxGet_speakHeader() {
        return this.getStyleAttribute(SPEAK_HEADER);
    }

    public void jsxSet_speakHeader(String speakHeader) {
        this.setStyleAttribute(SPEAK_HEADER, speakHeader);
    }

    public String jsxGet_speakNumeral() {
        return this.getStyleAttribute(SPEAK_NUMERAL);
    }

    public void jsxSet_speakNumeral(String speakNumeral) {
        this.setStyleAttribute(SPEAK_NUMERAL, speakNumeral);
    }

    public String jsxGet_speakPunctuation() {
        return this.getStyleAttribute(SPEAK_PUNCTUATION);
    }

    public void jsxSet_speakPunctuation(String speakPunctuation) {
        this.setStyleAttribute(SPEAK_PUNCTUATION, speakPunctuation);
    }

    public String jsxGet_speechRate() {
        return this.getStyleAttribute(SPEECH_RATE);
    }

    public void jsxSet_speechRate(String speechRate) {
        this.setStyleAttribute(SPEECH_RATE, speechRate);
    }

    public String jsxGet_stress() {
        return this.getStyleAttribute(STRESS);
    }

    public void jsxSet_stress(String stress) {
        this.setStyleAttribute(STRESS, stress);
    }

    public String jsxGet_styleFloat() {
        return this.getStyleAttribute(FLOAT);
    }

    public void jsxSet_styleFloat(String value) {
        this.setStyleAttribute(FLOAT, value);
    }

    public String jsxGet_tableLayout() {
        return this.getStyleAttribute(TABLE_LAYOUT);
    }

    public void jsxSet_tableLayout(String tableLayout) {
        this.setStyleAttribute(TABLE_LAYOUT, tableLayout);
    }

    public String jsxGet_textAlign() {
        return this.getStyleAttribute(TEXT_ALIGN);
    }

    public void jsxSet_textAlign(String textAlign) {
        this.setStyleAttribute(TEXT_ALIGN, textAlign);
    }

    public String jsxGet_textAlignLast() {
        return this.getStyleAttribute(TEXT_ALIGN_LAST);
    }

    public void jsxSet_textAlignLast(String textAlignLast) {
        this.setStyleAttribute(TEXT_ALIGN_LAST, textAlignLast);
    }

    public String jsxGet_textAutospace() {
        return this.getStyleAttribute(TEXT_AUTOSPACE);
    }

    public void jsxSet_textAutospace(String textAutospace) {
        this.setStyleAttribute(TEXT_AUTOSPACE, textAutospace);
    }

    public String jsxGet_textDecoration() {
        return this.getStyleAttribute(TEXT_DECORATION);
    }

    public void jsxSet_textDecoration(String textDecoration) {
        this.setStyleAttribute(TEXT_DECORATION, textDecoration);
    }

    public boolean jsxGet_textDecorationBlink() {
        return false;
    }

    public void jsxSet_textDecorationBlink(boolean textDecorationBlink) {
    }

    public boolean jsxGet_textDecorationLineThrough() {
        return false;
    }

    public void jsxSet_textDecorationLineThrough(boolean textDecorationLineThrough) {
    }

    public boolean jsxGet_textDecorationNone() {
        return false;
    }

    public void jsxSet_textDecorationNone(boolean textDecorationNone) {
    }

    public boolean jsxGet_textDecorationOverline() {
        return false;
    }

    public void jsxSet_textDecorationOverline(boolean textDecorationOverline) {
    }

    public boolean jsxGet_textDecorationUnderline() {
        return false;
    }

    public void jsxSet_textDecorationUnderline(boolean textDecorationUnderline) {
    }

    public String jsxGet_textIndent() {
        return this.getStyleAttribute(TEXT_INDENT);
    }

    public void jsxSet_textIndent(String textIndent) {
        this.setStyleAttributePixelInt(TEXT_INDENT, textIndent);
    }

    public String jsxGet_textJustify() {
        return this.getStyleAttribute(TEXT_JUSTIFY);
    }

    public void jsxSet_textJustify(String textJustify) {
        this.setStyleAttribute(TEXT_JUSTIFY, textJustify);
    }

    public String jsxGet_textJustifyTrim() {
        return this.getStyleAttribute(TEXT_JUSTIFY_TRIM);
    }

    public void jsxSet_textJustifyTrim(String textJustifyTrim) {
        this.setStyleAttribute(TEXT_JUSTIFY_TRIM, textJustifyTrim);
    }

    public String jsxGet_textKashida() {
        return this.getStyleAttribute(TEXT_KASHIDA);
    }

    public void jsxSet_textKashida(String textKashida) {
        this.setStyleAttribute(TEXT_KASHIDA, textKashida);
    }

    public String jsxGet_textKashidaSpace() {
        return this.getStyleAttribute(TEXT_KASHIDA_SPACE);
    }

    public void jsxSet_textKashidaSpace(String textKashidaSpace) {
        this.setStyleAttribute(TEXT_KASHIDA_SPACE, textKashidaSpace);
    }

    public String jsxGet_textOverflow() {
        return this.getStyleAttribute(TEXT_OVERFLOW);
    }

    public void jsxSet_textOverflow(String textOverflow) {
        this.setStyleAttribute(TEXT_OVERFLOW, textOverflow);
    }

    public String jsxGet_textShadow() {
        return this.getStyleAttribute(TEXT_SHADOW);
    }

    public void jsxSet_textShadow(String textShadow) {
        this.setStyleAttribute(TEXT_SHADOW, textShadow);
    }

    public String jsxGet_textTransform() {
        return this.getStyleAttribute(TEXT_TRANSFORM);
    }

    public void jsxSet_textTransform(String textTransform) {
        this.setStyleAttribute(TEXT_TRANSFORM, textTransform);
    }

    public String jsxGet_textUnderlinePosition() {
        return this.getStyleAttribute(TEXT_UNDERLINE_POSITION);
    }

    public void jsxSet_textUnderlinePosition(String textUnderlinePosition) {
        this.setStyleAttribute(TEXT_UNDERLINE_POSITION, textUnderlinePosition);
    }

    public String jsxGet_top() {
        return this.getStyleAttribute(TOP);
    }

    public void jsxSet_top(String top) {
        this.setStyleAttributePixelInt(TOP, top);
    }

    public String jsxGet_unicodeBidi() {
        return this.getStyleAttribute(UNICODE_BIDI);
    }

    public void jsxSet_unicodeBidi(String unicodeBidi) {
        this.setStyleAttribute(UNICODE_BIDI, unicodeBidi);
    }

    public String jsxGet_verticalAlign() {
        return this.getStyleAttribute(VERTICAL_ALIGN);
    }

    public void jsxSet_verticalAlign(String verticalAlign) {
        this.setStyleAttributePixelInt(VERTICAL_ALIGN, verticalAlign);
    }

    public String jsxGet_visibility() {
        return this.getStyleAttribute(VISIBILITY);
    }

    public void jsxSet_visibility(String visibility) {
        this.setStyleAttribute(VISIBILITY, visibility);
    }

    public String jsxGet_voiceFamily() {
        return this.getStyleAttribute(VOICE_FAMILY);
    }

    public void jsxSet_voiceFamily(String voiceFamily) {
        this.setStyleAttribute(VOICE_FAMILY, voiceFamily);
    }

    public String jsxGet_volume() {
        return this.getStyleAttribute(VOLUME);
    }

    public void jsxSet_volume(String volume) {
        this.setStyleAttribute(VOLUME, volume);
    }

    public String jsxGet_whiteSpace() {
        return this.getStyleAttribute(WHITE_SPACE);
    }

    public void jsxSet_whiteSpace(String whiteSpace) {
        this.setStyleAttribute(WHITE_SPACE, whiteSpace);
    }

    public String jsxGet_widows() {
        return this.getStyleAttribute(WIDOWS);
    }

    public void jsxSet_widows(String widows) {
        this.setStyleAttribute(WIDOWS, widows);
    }

    public String jsxGet_width() {
        return this.getStyleAttribute(WIDTH);
    }

    public void jsxSet_width(String width) {
        this.setStyleAttributePixelInt(WIDTH, width);
    }

    public String jsxGet_wordBreak() {
        return this.getStyleAttribute(WORD_BREAK);
    }

    public void jsxSet_wordBreak(String wordBreak) {
        this.setStyleAttribute(WORD_BREAK, wordBreak);
    }

    public String jsxGet_wordSpacing() {
        return this.getStyleAttribute(WORD_SPACING);
    }

    public void jsxSet_wordSpacing(String wordSpacing) {
        this.setStyleAttributePixelInt(WORD_SPACING, wordSpacing);
    }

    public String jsxGet_wordWrap() {
        return this.getStyleAttribute(WORD_WRAP);
    }

    public void jsxSet_wordWrap(String wordWrap) {
        this.setStyleAttribute(WORD_WRAP, wordWrap);
    }

    public String jsxGet_writingMode() {
        return this.getStyleAttribute(WRITING_MODE);
    }

    public void jsxSet_writingMode(String writingMode) {
        this.setStyleAttribute(WRITING_MODE, writingMode);
    }

    public Object jsxGet_zIndex() {
        String value = this.getStyleAttribute(Z_INDEX);
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_24)) {
            if (value == null || value.length() == 0) {
                return 0;
            }
            return Integer.valueOf(value);
        }
        return value;
    }

    protected void setRoundedStyleAttribute(String name, Object value) {
        if (value == null || value.toString().length() == 0) {
            this.setStyleAttribute(name, "0");
        } else {
            Double d = value instanceof Double ? (Double)value : Double.valueOf(value.toString());
            this.setStyleAttribute(name, Integer.toString(Math.round(d.floatValue())));
        }
    }

    protected void setIntegerStyleAttribute(String name, Object value) {
        if (value == null || value.toString().length() == 0) {
            this.setStyleAttribute(name, "0");
            return;
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            if (number.doubleValue() % 1.0 == 0.0) {
                this.setStyleAttribute(name, Integer.toString(number.intValue()));
            }
        } else {
            String valueString = value.toString();
            if (valueString.indexOf(46) == -1) {
                this.setStyleAttribute(name, valueString);
            }
        }
    }

    public void jsxSet_zIndex(Object zIndex) {
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_25)) {
            this.setRoundedStyleAttribute(Z_INDEX, zIndex);
        } else {
            this.setIntegerStyleAttribute(Z_INDEX, zIndex);
        }
    }

    public String jsxGet_zoom() {
        return this.getStyleAttribute(ZOOM);
    }

    public void jsxSet_zoom(String zoom) {
        this.setStyleAttribute(ZOOM, zoom);
    }

    public String jsxFunction_getPropertyValue(String name) {
        Object value;
        if (name != null && name.contains("-") && (value = CSSStyleDeclaration.getProperty((Scriptable)this, (String)CSSStyleDeclaration.camelize(name))) instanceof String) {
            return (String)value;
        }
        return this.getStyleAttribute(name);
    }

    public CSSValue jsxFunction_getPropertyCSSValue(String name) {
        String cssText;
        org.w3c.dom.css.CSSValue cssValue;
        LOG.info((Object)("getPropertyCSSValue(" + name + "): getPropertyCSSValue support is experimental"));
        if (this.styleDeclaration_ == null) {
            String uri = ((DomNode)this.getDomNodeOrDie()).getPage().getWebResponse().getWebRequest().getUrl().toExternalForm();
            String styleAttribute = this.jsElement_.getDomNodeOrDie().getAttribute("style");
            InputSource source = new InputSource((Reader)new StringReader(styleAttribute));
            source.setURI(uri);
            ErrorHandler errorHandler = this.getWindow().getWebWindow().getWebClient().getCssErrorHandler();
            CSSOMParser parser = new CSSOMParser((Parser)new SACParserCSS21());
            parser.setErrorHandler(errorHandler);
            try {
                this.styleDeclaration_ = parser.parseStyleDeclaration(source);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if ((cssValue = this.styleDeclaration_.getPropertyCSSValue(name)) == null) {
            CSSValueImpl newValue = new CSSValueImpl();
            newValue.setFloatValue((short)5, 0.0f);
            cssValue = newValue;
        }
        if ((cssText = cssValue.getCssText()).startsWith("rgb(")) {
            String formatedCssText = StringUtils.replace((String)cssText, (String)",", (String)", ");
            cssValue.setCssText(formatedCssText);
        }
        return new CSSPrimitiveValue(this.jsElement_, (org.w3c.dom.css.CSSPrimitiveValue)cssValue);
    }

    public void jsxFunction_setExpression(String propertyName, String expression, String language) {
    }

    public boolean jsxFunction_removeExpression(String propertyName) {
        return true;
    }

    public Object jsxFunction_getAttribute(String name, int flag) {
        if (flag == 1) {
            return this.getStyleAttribute(name);
        }
        Map<String, StyleElement> map = this.getStyleMap();
        for (String key : map.keySet()) {
            if (!key.equalsIgnoreCase(name)) continue;
            return map.get(key).getValue();
        }
        return "";
    }

    public void jsxFunction_setAttribute(String name, String value, Object flag) {
        int flagInt = flag == Undefined.instance ? 1 : (int)Context.toNumber((Object)flag);
        if (flagInt == 0) {
            Map<String, StyleElement> map = this.getStyleMap();
            for (String key : map.keySet()) {
                if (!key.equalsIgnoreCase(name)) continue;
                this.setStyleAttribute(key, value);
            }
        } else if (this.getStyleAttribute(name).length() > 0) {
            this.setStyleAttribute(name, value);
        }
    }

    public boolean jsxFunction_removeAttribute(String name, Object flag) {
        int flagInt = flag == Undefined.instance ? 1 : (int)Context.toNumber((Object)flag);
        if (flagInt == 0) {
            String lastName = null;
            Map<String, StyleElement> map = this.getStyleMap();
            for (String key : map.keySet()) {
                if (!key.equalsIgnoreCase(name)) continue;
                lastName = key;
            }
            if (lastName != null) {
                this.removeStyleAttribute(lastName);
                return true;
            }
            return false;
        }
        String s = this.getStyleAttribute(name);
        if (s.length() > 0) {
            this.removeStyleAttribute(name);
            return true;
        }
        return false;
    }

    private static String findColor(String text) {
        String[] tokens;
        Matcher m = COLOR_PATTERN.matcher(text);
        if (m.find()) {
            return m.group(1);
        }
        for (String token : tokens = StringUtils.split((String)text, (char)' ')) {
            if (CSSStyleDeclaration.isColorKeyword(token)) {
                return token;
            }
            if (!CSSStyleDeclaration.isColorHexadecimal(token)) continue;
            return token;
        }
        return null;
    }

    private static String findBorderStyle(String text) {
        for (String token : StringUtils.split((String)text, (char)' ')) {
            if (!CSSStyleDeclaration.isBorderStyle(token)) continue;
            return token;
        }
        return null;
    }

    private static String findBorderWidth(String text) {
        for (String token : StringUtils.split((String)text, (char)' ')) {
            if (!CSSStyleDeclaration.isBorderWidth(token)) continue;
            return token;
        }
        return null;
    }

    private static boolean isColorHexadecimal(String token) {
        return token.toLowerCase().matches("#([0-9a-f]{3}|[0-9a-f]{6})");
    }

    private static boolean isColorKeyword(String token) {
        return CSSColors_.containsKey(token.toLowerCase());
    }

    public static String toRGBColor(String color) {
        String rgbValue = CSSColors_.get(color.toLowerCase());
        if (rgbValue != null) {
            return rgbValue;
        }
        return color;
    }

    private static boolean isBorderStyle(String token) {
        return "none".equalsIgnoreCase(token) || "hidden".equalsIgnoreCase(token) || "dotted".equalsIgnoreCase(token) || "dashed".equalsIgnoreCase(token) || "solid".equalsIgnoreCase(token) || "double".equalsIgnoreCase(token) || "groove".equalsIgnoreCase(token) || "ridge".equalsIgnoreCase(token) || "inset".equalsIgnoreCase(token) || "outset".equalsIgnoreCase(token);
    }

    private static boolean isBorderWidth(String token) {
        return "thin".equalsIgnoreCase(token) || "medium".equalsIgnoreCase(token) || "thick".equalsIgnoreCase(token) || CSSStyleDeclaration.isLength(token);
    }

    private static boolean isLength(String token) {
        if (token.endsWith("em") || token.endsWith("ex") || token.endsWith("px") || token.endsWith("in") || token.endsWith("cm") || token.endsWith("mm") || token.endsWith("pt") || token.endsWith("pc") || token.endsWith("%")) {
            token = token.endsWith("%") ? token.substring(0, token.length() - 1) : token.substring(0, token.length() - 2);
            try {
                Float.parseFloat(token);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    protected static int pixelValue(HTMLElement element, CssValue value) {
        String s = value.get(element);
        if (s.endsWith("%") || s.length() == 0 && element instanceof HTMLHtmlElement) {
            int i = NumberUtils.toInt((String)TO_INT_PATTERN.matcher(s).replaceAll("$1"), (int)100);
            HTMLElement parent = element.getParentHTMLElement();
            int absoluteValue = parent == null ? value.getWindowDefaultValue() : CSSStyleDeclaration.pixelValue(parent, value);
            return (int)((double)i / 100.0 * (double)absoluteValue);
        }
        if (s.length() == 0 && element instanceof HTMLCanvasElement) {
            return value.getWindowDefaultValue();
        }
        return CSSStyleDeclaration.pixelValue(s);
    }

    protected static int pixelValue(String value) {
        int i = NumberUtils.toInt((String)TO_INT_PATTERN.matcher(value).replaceAll("$1"), (int)0);
        if (value.endsWith("px")) {
            return i;
        }
        if (value.endsWith("em")) {
            return i * 16;
        }
        if (value.endsWith("ex")) {
            return i * 10;
        }
        if (value.endsWith("in")) {
            return i * 150;
        }
        if (value.endsWith("cm")) {
            return i * 50;
        }
        if (value.endsWith("mm")) {
            return i * 5;
        }
        if (value.endsWith("pt")) {
            return i * 2;
        }
        if (value.endsWith("pc")) {
            return i * 24;
        }
        return i;
    }

    public String toString() {
        if (this.jsElement_ == null) {
            return "CSSStyleDeclaration for 'null'";
        }
        String style = this.jsElement_.getDomNodeOrDie().getAttribute("style");
        return "CSSStyleDeclaration for '" + style + "'";
    }

    protected void setStyleAttributePixelInt(String name, String value) {
        if (value.endsWith("px")) {
            value = value.substring(0, value.length() - 2);
        }
        try {
            float floatValue = Float.parseFloat(value);
            value = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_26) ? Integer.toString((int)floatValue) + "px" : (floatValue % 1.0f == 0.0f ? Integer.toString((int)floatValue) + "px" : Float.toString(floatValue) + "px");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setStyleAttribute(name, value);
    }

    static {
        CSSColors_.put("aqua", "rgb(0, 255, 255)");
        CSSColors_.put("black", "rgb(0, 0, 0)");
        CSSColors_.put("blue", "rgb(0, 0, 255)");
        CSSColors_.put("fuchsia", "rgb(255, 0, 255)");
        CSSColors_.put("gray", "rgb(128, 128, 128)");
        CSSColors_.put("green", "rgb(0, 128, 0)");
        CSSColors_.put("lime", "rgb(0, 255, 0)");
        CSSColors_.put("maroon", "rgb(128, 0, 0)");
        CSSColors_.put("navy", "rgb(0, 0, 128)");
        CSSColors_.put("olive", "rgb(128, 128, 0)");
        CSSColors_.put("purple", "rgb(128, 0, 128)");
        CSSColors_.put("red", "rgb(255, 0, 0)");
        CSSColors_.put("silver", "rgb(192, 192, 192)");
        CSSColors_.put("teal", "rgb(0, 128, 128)");
        CSSColors_.put("white", "rgb(255, 255, 255)");
        CSSColors_.put("yellow", "rgb(255, 255, 0)");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class StyleElement
    implements Comparable<StyleElement> {
        private final String name_;
        private final String value_;
        private final String priority_;
        private final long index_;
        private final SelectorSpecificity specificity_;

        protected StyleElement(String name, String value, String priority, SelectorSpecificity specificity, long index) {
            this.name_ = name;
            this.value_ = value;
            this.priority_ = priority;
            this.index_ = index;
            this.specificity_ = specificity;
        }

        protected StyleElement(String name, String value, long index) {
            this(name, value, "", SelectorSpecificity.FROM_STYLE_ATTRIBUTE, index);
        }

        protected StyleElement(String name, String value) {
            this(name, value, Long.MIN_VALUE);
        }

        public String getName() {
            return this.name_;
        }

        public String getValue() {
            return this.value_;
        }

        public String getPriority() {
            return this.priority_;
        }

        public SelectorSpecificity getSpecificity() {
            return this.specificity_;
        }

        public long getIndex() {
            return this.index_;
        }

        public boolean isDefault() {
            return this.index_ == Long.MIN_VALUE;
        }

        public String toString() {
            return "[" + this.index_ + "]" + this.name_ + "=" + this.value_;
        }

        @Override
        public int compareTo(StyleElement e) {
            if (e != null) {
                long styleIndex = e.index_;
                return this.index_ < styleIndex ? -1 : (this.index_ == styleIndex ? 0 : 1);
            }
            return 1;
        }
    }

    protected static abstract class CssValue {
        private final int windowDefaultValue_;

        public CssValue(int windowDefaultValue) {
            this.windowDefaultValue_ = windowDefaultValue;
        }

        public int getWindowDefaultValue() {
            return this.windowDefaultValue_;
        }

        public final String get(HTMLElement element) {
            ComputedCSSStyleDeclaration style = element.jsxGet_currentStyle();
            String value = this.get(style);
            return value;
        }

        public abstract String get(ComputedCSSStyleDeclaration var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Shorthand {
        TOP("top"),
        RIGHT("right"),
        BOTTOM("bottom"),
        LEFT("left");

        private final String string_;

        private Shorthand(String stringRepresentation) {
            this.string_ = stringRepresentation;
        }

        public String toString() {
            return this.string_;
        }
    }
}

