/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.html.DomCharacterData;
import com.gargoylesoftware.htmlunit.html.HtmlStyle;
import com.gargoylesoftware.htmlunit.util.StringUtils;
import java.io.PrintWriter;
import org.w3c.dom.DOMException;
import org.w3c.dom.Text;

public class DomText
extends DomCharacterData
implements Text {
    private static final long serialVersionUID = 6589779086230288951L;
    public static final String NODE_NAME = "#text";

    public DomText(SgmlPage page, String data) {
        super(page, data);
    }

    public DomText splitText(int offset) {
        if (offset < 0 || offset > this.getLength()) {
            throw new IllegalArgumentException("offset: " + offset + " data.length: " + this.getLength());
        }
        DomText newText = this.createSplitTextNode(offset);
        this.setData(this.getData().substring(0, offset));
        if (this.getParentNode() != null) {
            this.getParentNode().insertBefore(newText, this.getNextSibling());
        }
        return newText;
    }

    protected DomText createSplitTextNode(int offset) {
        return new DomText(this.getPage(), this.getData().substring(offset));
    }

    @Deprecated
    public DomText splitDomText(int offset) {
        return this.splitText(offset);
    }

    public boolean isElementContentWhitespace() {
        throw new UnsupportedOperationException("DomText.isElementContentWhitespace is not yet implemented.");
    }

    public String getWholeText() {
        throw new UnsupportedOperationException("DomText.getWholeText is not yet implemented.");
    }

    public Text replaceWholeText(String content) throws DOMException {
        throw new UnsupportedOperationException("DomText.replaceWholeText is not yet implemented.");
    }

    public short getNodeType() {
        return 3;
    }

    public String getNodeName() {
        return NODE_NAME;
    }

    protected void printXml(String indent, PrintWriter printWriter) {
        if (this.getData().trim().length() != 0) {
            printWriter.print(indent);
            String data = this.getData();
            if (!(this.getParentNode() instanceof HtmlStyle && data.startsWith("<!--") && data.endsWith("-->"))) {
                data = StringUtils.escapeXmlChars(data);
            }
            printWriter.println(data);
        }
        this.printChildrenAsXml(indent, printWriter);
    }

    public String toString() {
        return this.asText();
    }

    protected boolean isTrimmedText() {
        return false;
    }
}

