/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.SelectableTextInput;
import java.io.Serializable;
import org.w3c.dom.ranges.Range;

class SelectionDelegate
implements Serializable {
    private static final long serialVersionUID = -5611492671640559880L;
    private final SelectableTextInput element_;

    public SelectionDelegate(SelectableTextInput element) {
        this.element_ = element;
    }

    public void select() {
        this.element_.focus();
        this.element_.setSelectionStart(0);
        this.element_.setSelectionEnd(this.element_.getText().length());
    }

    public String getSelectedText() {
        Range selection = this.getSelectionInner();
        if (selection != null) {
            return this.element_.getText().substring(selection.getStartOffset(), selection.getEndOffset());
        }
        return null;
    }

    public int getSelectionStart() {
        Range selection = this.getSelectionInner();
        if (selection != null) {
            return selection.getStartOffset();
        }
        return this.element_.getText().length();
    }

    public void setSelectionStart(int selectionStart) {
        if (this.element_.getPage() instanceof HtmlPage) {
            HtmlPage page = (HtmlPage)this.element_.getPage();
            int length = this.element_.getText().length();
            selectionStart = Math.max(0, Math.min(selectionStart, length));
            page.getSelection().setStart(this.element_, selectionStart);
            if (page.getSelection().getEndContainer() != this.element_) {
                page.getSelection().setEnd(this.element_, length);
            } else if (page.getSelection().getEndOffset() < selectionStart) {
                page.getSelection().setEnd(this.element_, selectionStart);
            }
        }
    }

    public int getSelectionEnd() {
        Range selection = this.getSelectionInner();
        if (selection != null) {
            return selection.getEndOffset();
        }
        return this.element_.getText().length();
    }

    public void setSelectionEnd(int selectionEnd) {
        if (this.element_.getPage() instanceof HtmlPage) {
            HtmlPage page = (HtmlPage)this.element_.getPage();
            int length = this.element_.getText().length();
            selectionEnd = Math.min(length, Math.max(selectionEnd, 0));
            page.getSelection().setEnd(this.element_, selectionEnd);
            if (page.getSelection().getStartContainer() != this.element_) {
                page.getSelection().setStart(this.element_, 0);
            } else if (page.getSelection().getStartOffset() > selectionEnd) {
                page.getSelection().setStart(this.element_, selectionEnd);
            }
        }
    }

    private Range getSelectionInner() {
        Range selection;
        if (this.element_.getPage() instanceof HtmlPage && (selection = ((HtmlPage)this.element_.getPage()).getSelection()).getStartContainer() == this.element_ && selection.getEndContainer() == this.element_) {
            return selection;
        }
        return null;
    }
}

