package Data::Object::Autobox::Any;

use 5.014;

use strict;
use warnings;

use Data::Object ();

our $VERSION = '1.03'; # VERSION

# BUILD

sub new {
  Data::Object->any(pop);
}

1;

=encoding utf8

=head1 NAME

Data::Object::Autobox::Any

=cut

=head1 ABSTRACT

Data-Object Autoboxing for Any Objects

=cut

=head1 SYNOPSIS

  use Data::Object::Autobox::Any;

=cut

=head1 DESCRIPTION

This package implements autoboxing via L<Data::Object::Autobox> for
L<Data::Object::Any> objects.

=cut

=head1 METHODS

This package implements the following methods.

=cut

=head2 new

  new(Any $arg1) : AnyObject

Construct a new object.

=over 4

=item new example

  my $any = Data::Object::Autobox::Any->new(\*main);

=back

=cut

=head1 AUTHOR

Al Newkirk, C<awncorp@cpan.org>

=head1 LICENSE

Copyright (C) 2011-2019, Al Newkirk, et al.

This is free software; you can redistribute it and/or modify it under the same
terms as the Perl 5 programming language system itself.

=head1 STATUS

=begin html

<a href="https://travis-ci.org/iamalnewkirk/do" target="_blank">
<img src="https://travis-ci.org/iamalnewkirk/do.svg?branch=master"/>
</a>

=end html

=head1 SEE ALSO

To get the most out of this distribution, consider reading the following:

L<Data::Object::Class>

L<Data::Object::Role>

L<Data::Object::Rule>

L<Data::Object::Library>

L<Data::Object::Signatures>

L<Contributing|https://github.com/iamalnewkirk/do/README-DEVEL.mkdn>

L<GitHub|https://github.com/iamalnewkirk/do>

=cut