use JSON::Fast;
unit role Shodan::API::Exploit;

=begin pod
=head1 NAME

Shodan::API::Exploit

=head1 DESCRIPTION

A L<raku-lang|https://raku.org/> client for L<Shodan|https://www.shodan.io/>,
a search engine for Internet-connected devices. This client provides an
interface for the L<Shodan Exploit API|https://developer.shodan.io/api/exploits/rest>.

=head1 METHODS
=end pod

#|(Search across a variety of data sources for exploits and use facets to get
summary information.)
method exploit-search(Str :$query!,
                      Str :$facets = 'author,platform,port,source,type',
                      Int :$page   = 1 --> Hash)
{
    return self!exploit.request(
                                   route        => "/api/search",
                                   query-params => {
                                                       query  => $query,
                                                       facets => $facets,
                                                       page   => $page
                                                   }
                               );
}

#|(This method behaves identical to the "/search" method with the difference
that it doesn't return any results.)
method exploit-count(Str :$query!,
                     Str :$facets = 'author,platform,port,source,type' --> Hash)
{
    return self!exploit.request(
                                   route        => "/api/count",
                                   query-params => {
                                                       query  => $query,
                                                       facets => $facets
                                                   }
                               );
}

=begin pod
=head1 AUTHOR

"Sarah Fuller", C<< <"sarah at averna . id . au"> >>

=head1 COPYRIGHT AND LICENSE
=begin para
Copyright 2022 Sarah Fuller
This library is free software; you can redistribute it and/or modify it under
the Artistic License 2.0.
=end para
=end pod
