package List::Objects::WithUtils::Array;
{
  $List::Objects::WithUtils::Array::VERSION = '1.002000';
}
use strictures 1;

use Role::Tiny::With;
with 'List::Objects::WithUtils::Role::Array',
     'List::Objects::WithUtils::Role::WithJunctions';

use Exporter 'import';
our @EXPORT = 'array';
sub array { __PACKAGE__->new(@_) }

1;

=pod

=head1 NAME

List::Objects::WithUtils::Array - An array container class

=head1 SYNOPSIS

  use List::Objects::WithUtils 'array';

  my $array = array(qw/ a b c /);

=head1 DESCRIPTION

See L<List::Objects::WithUtils::Role::Array> for a description of available
methods.

This class also consumes L<List::Objects::WithUtils::Role::WithJunctions>.

=head2 array

Creates a new array container object.

=head1 AUTHOR

Jon Portnoy <avenj@cobaltirc.org>

Derived from L<Data::Perl> by Matt Phillips (CPAN: MATTP) et al

Licensed under the same terms as Perl

=cut
