#  Massage @INC library to support WebDyne installation into
#  non standard dir
#
package perl5lib;
use strict qw(vars);
use Config;
use Cwd qw(realpath);
use lib;
use File::Spec;
no warnings;
local $^W=0;


#  Get location of library include file (perl5lib.pm) for this
#  particular type of OS
#
my $Perllib_dn={

    MSWin32	    => $ENV{'windir'},
    MSWin64	    => $ENV{'windir'},

}->{$^O} || '/etc';
my $Perllib_cn=File::Spec->catfile($Perllib_dn, 'perl5lib.pm');
my @Perllib_dn=@{do($Perllib_cn) if (-f $Perllib_cn)};


#  Run main routine to adjust @INC
#
&main();


sub import {


    #  Only run main routine again if user spects different prefix on use, eg
    #  use perl5lib ("/opt/foo")
    #
    &main($_[1]) if $_[1];

}


sub main {


    #  Prefix is supplied as ARG, quit if same as standard Perl
    #  prefix
    #
    my $prefix_dn = shift() ||  &prefix();
    if (($prefix_dn eq $Config{'prefix'}) && !@Perllib_dn)  { return 1 }


    #  Prefix not the same, generate site and privlib dirs from
    #  Config hints.
    #
    my $sitelib_dn=$Config{'sitelib'};
    my $privlib_dn=$Config{'privlib'};

    my @prefix_perl_dn=File::Spec->splitdir($Config{'prefix'});
    my @inc;

    foreach my $dn (grep {-d $_} ($prefix_dn, @Perllib_dn)) {

	my @prefix_dn=File::Spec->splitdir($dn);

	my @sitelib_dn=File::Spec->splitdir($sitelib_dn);
	for (@prefix_perl_dn) {shift @sitelib_dn};
	my $sitelib=File::Spec->catdir(@prefix_dn, @sitelib_dn);


	my @privlib_dn=File::Spec->splitdir($privlib_dn);
	for (@prefix_perl_dn) {shift @privlib_dn};
	my $privlib=File::Spec->catdir(@prefix_dn, @privlib_dn);

	push @inc, $sitelib, $privlib;

	#  Seem to need for earlier versions of Perl
	#
	$sitelib=~s/perl5//;
	$privlib=~s/perl5//;

	# Catdir cleans up paths, gets rid of stray //'s
	#
	push @inc, File::Spec->catdir($sitelib);
	push @inc, File::Spec->catdir($privlib);
	#  Need arch libs added manually for earlier versions too
	#
	push @inc, File::Spec->catdir($sitelib, $Config{'archname'});
	push @inc, File::Spec->catdir($privlib, $Config{'archname'});
	push @inc, File::Spec->catdir($prefix_dn, 'lib', $Config{'version'}, $Config{'archname'});

    }


    #  Add to @INC 
    #
    'lib'->import(grep {-d $_} @inc);

}


sub prefix {

    my @prefix_dn=(File::Spec->splitpath(File::Spec->rel2abs(__FILE__)));
    pop @prefix_dn;
    realpath(File::Spec->catdir(@prefix_dn, File::Spec->updir()));

}


sub add {

    my $dn=shift() || return;
    my %perllib_dn=map { $_=>1 } @Perllib_dn;
    unless ($perllib_dn{$dn}) {
	push @Perllib_dn, $dn;
	&save(\@Perllib_dn);
    }

}


sub del {

    my $dn=shift() || return;
    my %perllib_dn=map { $_=>1 } @Perllib_dn;
    if ($perllib_dn{$dn}) {
	@Perllib_dn=grep {$_ ne $dn} @Perllib_dn;
	&save(\@Perllib_dn);
    }

}


sub save {

    my $perllib_dn_ar=shift();
    require IO::File;
    require Fcntl;
    my $fh=IO::File->new($Perllib_cn, &Fcntl::O_WRONLY|&Fcntl::O_CREAT|&Fcntl::O_TRUNC) ||
	die("unable to open file '$Perllib_cn', $!");
    require Data::Dumper;
    $Data::Dumper::Indent=1;
    print $fh &Data::Dumper::Dumper($perllib_dn_ar);
    $fh->close();

}


sub update {
    &add(&prefix);
}


1;
