use strict; use warnings;

BEGIN { require './t/lib/ok.pl' }
use Text::Tabs;
use Text::Wrap;

print "1..4\n";

my @w; $SIG{'__WARN__'} = sub { @w = @_ };

() = expand( undef );
print "# @w", "\n" x $w[-1] !~ /(?!\z)\Z/ if @w;
ok( !( () = splice @w ), 'expand accepts undef silently' );

() = unexpand( undef, undef, undef );
print "# @w", "\n" x $w[-1] !~ /(?!\z)\Z/ if @w;
ok( !( () = splice @w ), 'unexpand accepts undef silently' );

() = wrap( undef, undef, ( ( "abc " x 20 ) . "abc\n" ) x 5, undef );
print "# @w", "\n" x $w[-1] !~ /(?!\z)\Z/ if @w;
ok( !( () = splice @w ), 'wrap accepts undef silently' );

() = fill( undef, undef, ( ( "abc " x 20 ) . "abc\n" ) x 5, undef );
print "# @w", "\n" x $w[-1] !~ /(?!\z)\Z/ if @w;
ok( !( () = splice @w ), 'fill accepts undef silently' );
