#!/usr/bin/perl

use strict;
use warnings;
no warnings 'syntax';

use lib ".";

use Regex::Common;
use Test::More;
use t::zip::Zip;

my $r = eval "require Test::Regexp; 1";

unless ($r) {
    print "1..0 # SKIP Test::Regexp not found\n";
    exit;
}

test_zips
  country => "Belgium",
  name    => "Belgian zip codes",
  prefix  => {
    iso     => "BE",
    cept    => "B",
    invalid => "FR",
  },
  prefix_test_set => [ 4480, 5555 ],
  ;

done_testing;

sub valid_zip_codes {
    1000, 1005 .. 1012, 1020, 1030 .. 1031,
      1040 .. 1041, 1043 .. 1045, 1047 .. 1050, 1060, 1070,
      1080 .. 1083, 1090, 1100, 1105, 1110, 1120, 1130,
      1140, 1150, 1160, 1170, 1180, 1190, 1200 .. 1201,
      1210, 1212, 1300 .. 1301, 1310, 1315, 1320, 1325,
      1330 .. 1332, 1340 .. 1342, 1348, 1350, 1357, 1360,
      1367, 1370, 1380, 1390, 1400 .. 1402, 1404, 1410,
      1414, 1420 .. 1421, 1428, 1430, 1435, 1440,
      1450, 1457, 1460 .. 1461, 1470 .. 1474, 1476, 1480,
      1490, 1495, 1500 .. 1502, 1540 .. 1541, 1547, 1560,
      1570, 1600 .. 1602, 1620, 1630, 1640,
      1650 .. 1654, 1670 .. 1671, 1673 .. 1674, 1700 .. 1703,
      1730 .. 1731, 1740 .. 1742, 1745, 1750, 1755,
      1760 .. 1761, 1770, 1780, 1785, 1790, 1800, 1804,
      1818, 1820, 1830 .. 1831, 1840, 1850 .. 1853,
      1860 .. 1861, 1880, 1910, 1930 .. 1934, 1950, 1970,
      1980 .. 1982,

      2000, 2018, 2020, 2030, 2040, 2050, 2060, 2070,
      2100, 2110, 2140, 2150, 2160, 2170, 2180, 2200,
      2220 .. 2223, 2230, 2235, 2240, 2242 .. 2243,
      2250, 2260, 2270, 2275, 2280, 2288, 2290, 2300,
      2310, 2320 .. 2323, 2328, 2330, 2340, 2350,
      2360, 2370, 2380 .. 2382, 2387, 2390, 2400,
      2430 .. 2431, 2440, 2450, 2460, 2470, 2480,
      2490 .. 2491, 2500, 2520, 2530 .. 2531, 2540, 2547,
      2550, 2560, 2570, 2580, 2590, 2600, 2610, 2620,
      2627, 2630, 2640, 2650, 2660, 2800 .. 2801,
      2811 .. 2812, 2820, 2830, 2840, 2845, 2850,
      2860 .. 2861, 2870, 2880, 2890, 2900, 2910, 2920,
      2930, 2940, 2950, 2960, 2970, 2980, 2990,

      3000 .. 3001, 3010, 3012, 3018, 3020, 3040,
      3050 .. 3054, 3060 .. 3061, 3070 .. 3071, 3078, 3080,
      3090, 3110 .. 3111, 3118, 3120, 3128, 3130,
      3140, 3150, 3190 .. 3191, 3200 .. 3202, 3210 .. 3212,
      3220 .. 3221, 3270 .. 3272, 3290, 3293 .. 3294,
      3300, 3320 .. 3321, 3350, 3360, 3370,
      3380 .. 3381, 3384, 3390 .. 3391, 3400 .. 3401,
      3404, 3440, 3450, 3454, 3460 .. 3461, 3470 .. 3473,
      3500 .. 3501, 3510 .. 3512, 3520, 3530, 3540, 3545,
      3550, 3560, 3570, 3580 .. 3583, 3590, 3600,
      3620 .. 3621, 3630 .. 3631, 3640, 3650, 3660, 3665,
      3668, 3670, 3680, 3690, 3700, 3717, 3720 .. 3724,
      3730, 3732, 3740, 3742, 3746, 3770, 3790 .. 3793,
      3798, 3800, 3803, 3806, 3830 .. 3832, 3840, 3850,
      3870, 3890 .. 3891, 3900, 3910, 3920, 3930,
      3940 .. 3941, 3945, 3950, 3960, 3970 .. 3971,
      3980, 3990,

      4000, 4020, 4030 .. 4032, 4040 .. 4042, 4050 .. 4053,
      4090, 4100 .. 4102, 4120 .. 4122, 4130,
      4140 .. 4141, 4151, 4160 .. 4163, 4170 .. 4171,
      4180 .. 4181, 4190, 4210, 4217 .. 4219, 4250,
      4252 .. 4254, 4257, 4260 .. 4261, 4263, 4280,
      4287, 4300, 4317, 4340, 4342, 4347, 4350 .. 4351,
      4357, 4360, 4367, 4400, 4420, 4430 .. 4432,
      4450 .. 4453, 4458, 4460, 4470, 4480, 4500, 4520,
      4530, 4537, 4540, 4550, 4557, 4560, 4570, 4577,
      4590, 4600 .. 4602, 4606 .. 4608, 4610,
      4620 .. 4621, 4623 .. 4624, 4630 .. 4633, 4650 .. 4654,
      4670 .. 4672, 4680 .. 4684, 4690, 4700 .. 4701,
      4710 .. 4711, 4720 .. 4721, 4728, 4730 .. 4731,
      4750, 4760 .. 4761, 4770 .. 4771, 4780,
      4782 .. 4784, 4790 .. 4791, 4800 .. 4802, 4820 .. 4821,
      4830 .. 4831, 4834, 4837, 4840 .. 4841, 4845,
      4850 .. 4852, 4860 .. 4861, 4870, 4877, 4880, 4890,
      4900, 4910, 4920, 4950, 4960, 4970, 4980, 4983,
      4987, 4990,

      5000 .. 5004, 5020 .. 5022, 5024, 5030 .. 5032,
      5060, 5070, 5080 .. 5081, 5100 .. 5101, 5140, 5150,
      5170, 5190, 5300, 5310, 5330, 5332 .. 5334,
      5336, 5340, 5350 .. 5354, 5360 .. 5364, 5370, 5372,
      5374, 5376 .. 5377, 5380, 5500 .. 5504,
      5520 .. 5524, 5530, 5537, 5540 .. 5544, 5550, 5555,
      5560 .. 5564, 5570 .. 5576, 5580, 5590, 5600,
      5620 .. 5621, 5630, 5640 .. 5641, 5644, 5646,
      5650 .. 5651, 5660, 5670, 5680,

      6000 .. 6001, 6010, 6020, 6030 .. 6032, 6040 .. 6044,
      6060 .. 6061, 6110 .. 6111, 6120, 6140 .. 6142,
      6150, 6180 .. 6183, 6200, 6210 .. 6211,
      6220 .. 6224, 6230, 6238, 6240, 6250, 6280,
      6440 .. 6441, 6460 .. 6464, 6470, 6500, 6511,
      6530 .. 6534, 6536, 6540, 6542 .. 6543, 6560, 6567,
      6590 .. 6594, 6596, 6600, 6630, 6637, 6640, 6642,
      6660 .. 6663, 6666, 6670 .. 6674, 6680 .. 6681,
      6686 .. 6688, 6690, 6692, 6698, 6700, 6704, 6706,
      6717, 6720 .. 6721, 6723 .. 6724, 6730,
      6740 .. 6743, 6747, 6750, 6760 .. 6762, 6767, 6769,
      6780 .. 6782, 6790 .. 6792, 6800, 6810 .. 6813,
      6820 .. 6821, 6823 .. 6824, 6830 .. 6834, 6836, 6838,
      6840, 6850 .. 6853, 6856, 6860, 6870, 6880,
      6887, 6890, 6900, 6920 .. 6922, 6924, 6927,
      6929, 6940 .. 6941, 6950 .. 6953, 6960,
      6970 .. 6972, 6980, 6982 .. 6984, 6986 .. 6987,
      6990, 6997,

      7000, 7010 .. 7012, 7020 .. 7022, 7024,
      7030 .. 7034, 7040 .. 7041, 7050, 7060 .. 7063,
      7070, 7080, 7090, 7100, 7110, 7120, 7130 .. 7131,
      7133 .. 7134, 7140 .. 7141, 7160, 7170, 7180 .. 7181,
      7190 .. 7191, 7300 .. 7301, 7320 .. 7322, 7330 .. 7334,
      7340, 7350, 7370, 7380, 7382, 7387, 7390,
      7500 .. 7504, 7506, 7520 .. 7522, 7530 .. 7534,
      7536, 7538, 7540, 7542 .. 7543, 7548,
      7600 .. 7604, 7608, 7610 .. 7611, 7618,
      7620 .. 7624, 7640 .. 7643, 7700, 7711 .. 7712,
      7730, 7740, 7742 .. 7743, 7750, 7760, 7780 .. 7784,
      7800 .. 7804, 7810 .. 7812, 7822 .. 7823, 7830, 7850,
      7860 .. 7864, 7866, 7870, 7880, 7890, 7900 .. 7901,
      7903 .. 7904, 7906, 7910 .. 7912, 7940 .. 7943,
      7950 .. 7951, 7970 .. 7973,

      8000, 8020, 8200, 8210 .. 8211, 8300 .. 8301,
      8310, 8340, 8370, 8377, 8380, 8400, 8420 .. 8421,
      8430 .. 8434, 8450, 8460, 8470, 8480, 8490,
      8500 .. 8501, 8510 .. 8511, 8520, 8530 .. 8531,
      8540, 8550 .. 8554, 8560, 8570, 8572 .. 8573,
      8580 .. 8583, 8587, 8600, 8610, 8620, 8630, 8640,
      8647, 8650, 8660, 8670, 8680, 8690 .. 8691,
      8700, 8710, 8720, 8730, 8740, 8750, 8755, 8760,
      8770, 8780, 8790 .. 8793, 8800, 8810, 8820, 8830,
      8840, 8850 .. 8851, 8860, 8870, 8880, 8890,
      8900, 8902, 8904, 8906, 8908, 8920, 8930, 8940,
      8950 .. 8954, 8956 .. 8958, 8970, 8972, 8978, 8980,

      9000, 9030 .. 9032, 9040 .. 9042, 9050 .. 9052,
      9060, 9070, 9080, 9090, 9100, 9111 .. 9112,
      9120, 9130, 9140, 9150, 9160, 9170, 9180, 9185,
      9190, 9200, 9220, 9230, 9240, 9250, 9255, 9260,
      9270, 9280, 9290, 9300, 9308, 9310, 9320, 9340,
      9400 .. 9404, 9406, 9420, 9450 .. 9451, 9470,
      9472 .. 9473, 9500, 9506, 9520 .. 9521, 9550 .. 9552,
      9570 .. 9572, 9600, 9620, 9630, 9636, 9660 .. 9661,
      9667, 9680 .. 9681, 9688, 9690, 9700, 9750,
      9770 .. 9772, 9790, 9800, 9810, 9820, 9830 .. 9831,
      9840, 9850, 9860, 9870, 9880 .. 9881, 9890, 9900,
      9910, 9920 .. 9921, 9930 .. 9932, 9940, 9950,
      9960 .. 9961, 9968, 9970 .. 9971, 9980 .. 9982,
      9988, 9990 .. 9992,;
}

__END__
