package t::APL;

# Copyright (C) 2006-2007, Parrot Foundation.
# $Id: APL.pm 36833 2009-02-17 20:09:26Z allison $

# Fail a little more gracefully for those without Test::Base installed.

use strict;
use warnings;

BEGIN {
    eval {
        require Test::Base;
        import Test::Base qw/ -Base /;
    };
    if ($@) {
        eval 'use Test::More skip_all => "APL tests require Test::Base.;";';
        exit 0;
    }
}

use Parrot::Config;
use Parrot::Test;

our @EXPORT = qw(run_apl_is);

#BEGIN {
#  # APL *really* needs unicode to function, bail out if we don't have it.
#  if (!$PConfig{has_icu}) {
#    plan skip_all => "No unicode library available.";
#    exit 0;
#  }
#}

# Note - we don't just use the special SKIP entry in the DATA stream because
# it doesn't actually output the skipped test in the TAP output. It just
# fails to run the test.

# mark todo tests with TODO - but, unless an environment variable is set,
# skip the tests - speed things up for end users, give developers the ability
# to easily see if anything new is passing.

sub run_apl_is() {
    foreach my $block (blocks) {
        my $apl = $block->APL;
        my $output;
        if ( defined( $block->out ) ) {
            $output = $block->out;
            if ($output) {
                $output .= "\n";    # XXX a slight hack
            }
            else {
                $output = "0\n"
                    ; # XXX MAJOR hack - Test::Base is borkedly converting the 0 into the empty string. Why?
            }
        }
        else {
            $output = "\n";    # this lets todo tests not bother specifying an out.
                               # XXX also gives us a way to specify a blank output,
                               # Since we're converting an explicit blank output to 0
        }
        if ( $output =~ m/\n\n$/smx ) {
            chomp $output;     # XXX Keep hackin' it up!
        }

        my $todo = $block->todo;
        if ( defined($todo) ) {
            if ( !$todo ) {
                $todo = "not implemented";
            }
            if ( $ENV{APLDEV} ) {
            TODO: {
                    local $TODO = $todo;
                    Parrot::Test::language_output_is( 'APL', $apl, $output, $block->name );
                }
            }
            else {
            SKIP: {
                    skip( "not implemented", 1 );
                    Parrot::Test::language_output_is( 'APL', $apl, $output, $block->name );
                }
            }
        }
        else {
            Parrot::Test::language_output_is( 'APL', $apl, $output, $block->name );
        }
    }
}

# Local Variables:
#   mode: cperl
#   cperl-indent-level: 4
#   fill-column: 100
# End:
# vim: expandtab shiftwidth=4:
