# Descrip.MMS for perl5 on VMS
# Last revised  4-Dec-1995 by Charles Bailey  bailey@genetics.upenn.edu
#
#: This file uses MMS syntax, and can be processed using DEC's MMS product,
#: or the free MMK clone (available by ftp at ftp.spc.edu).  If you want to
#: a Unix-style MAKE tool, run this file through mms2make.pl, which should
#: be found in the same directory as this file.  (There should be a pre-made
#: copy of Makefile for VAXC in this directory to allow you to build perl.)
#:
#: Lines beginning with "#:" will be removed by mms2make.pl when converting
#: this file to MAKE syntax.
#:
#:	Usage:
#: Building with VAX C, on system without DEC C installed or with VAX C default:
#:	$ MMS
#: Building with VAX C, on system with DEC C installed as default C compiler:
#:	$ MMS /MACRO=("cc=CC/VAXC")
#: Building with DEC C, on system without VAX C installed or with DEC C default:
#:	$ MMS /MACRO=("decc=1")
#: Building with DEC C, on system with VAX C installed as default C compiler:
#:	$ MMS /MACRO=("decc=1","cc=CC/DECC")
#: Building with GNU C, on system with GCC command installed in DCLTABLES:
#:	$ MMS /MACRO=("gnuc=1")
#: Building with GNU C, on system without GCC command installed in DCLTABLES:
#:	$ MMS /MACRO=("gnuc=1") gcc_cld_setup,all
#:	note: `gcc_cld_setup' target must explicitly precede `all' or `[mini]perl'
#:
#: To each of the above, add /Macro="__AXP__=1" if building on an AXP,
#:                           /Macro="__DEBUG__=1" to build a debug version
#:                           (i.e. VMS debugger, not perl -D), and
#:                           /Macro="SOCKET=1" to include socket support.
#
#	tidy      -- purge files generated by executing this file
#	clean     -- remove all files generated by executing this file
#	cleansrc  -- `clean' + purge *.c,*.h,descrip.mms
#	gcc_cld_setup -- GCC initialization; see above
#	crtl.opt  -- compiler-specific linker options file (made automatically)
#

#### Start of system configuration section. ####


#: >>>>> Architecture-specific options <<<<<
.ifdef AXE
# File type to use for object files
O = .abj
# File type to use for object libraries
OLB = .alb
# File type to use for executable images
E = .axe
.else
# File type to use for object files
O = .obj
# File type to use for object libraries
OLB = .olb
# File type to use for executable images
E = .exe
.endif

.ifdef __AXP__
DECC = 1
ARCH = VMS_AXP
.else
ARCH = VMS_VAX
.endif
ARCHDIR =  [.lib.$(ARCH)]
ARCHCORE = [.lib.$(ARCH).CORE]
ARCHAUTO = [.lib.$(ARCH).auto]


#: >>>>>Compiler-specific options <<<<<
.ifdef GNUC
.first
	@ If F$TrnLnm("Sys").eqs."" Then Define/NoLog SYS GNU_CC_Include:[VMS]
CC = gcc
# -fno-builtin avoids bug in gcc up to version 2.6.2 which can destroy
# data when memcpy() is called on large (>64 kB) blocks of memory
# (fixed in gcc 2.6.3)
XTRACCFLAGS = /Obj=$(MMS$TARGET_NAME)$(O)/NoCase_Hack/Optimize=2/CC1="""""-fno-builtin"""""
DBGSPECFLAGS =
XTRADEF = ,GNUC_ATTRIBUTE_CHECK
XTRAOBJS =
LIBS1 = GNU_CC:[000000]GCCLIB.OLB/Library
LIBS2 = VAXCRTL/Shareable
.else
XTRAOBJS = 
LIBS1 = $(XTRAOBJS)
DBGSPECFLAGS = /Show=(Source,Include,Expansion)
.ifdef decc
# Some versions of DECCRTL on AXP have a bug in chdir() which causes the change
# to persist after the image exits, even when this was not requested, iff
# SYSNAM is enabled.  This is fixed in CSC Patch # AXPACRT04_061, but turning
# off SYSNAM for the MM[SK] subprocess doesn't hurt anything, so we do it
# just in case.
.first
	@ Set Process/Privilege=(NoSYSNAM)
LIBS2 = 
XTRACCFLAGS = /Include=[]/Standard=Relaxed_ANSI/Prefix=All/Obj=$(MMS$TARGET_NAME)$(O)
XTRADEF =
.else # VAXC
.first
	@ If F$TrnLnm("Sys").eqs."" Then Define/NoLog SYS Sys$Library
XTRACCFLAGS = /Include=[]/Object=$(O)
XTRADEF =
LIBS2 = VAXCRTL/Shareable
.endif
.endif


#: >>>>> Configuration options <<<<<
#: __DEBUG__: builds images with full VMS debugger support
.ifdef __DEBUG__
DBGCCFLAGS = /List/Debug/NoOpt$(DBGSPECFLAGS)
DBGLINKFLAGS = /Trace/Debug/Map/Full/Cross
DBG = DBG
.else
DBGCCFLAGS = /NoList
DBGLINKFLAGS = /NoMap
DBG = 
.endif

#: SOCKET: build in support for TCP/IP sockets
#: By default, used SOCKETSHR library; see ReadMe.VMS
#: for information on changing socket support
.ifdef SOCKET
SOCKDEF = ,VMS_DO_SOCKETS
SOCKLIB = SocketShr/Share
# N.B. the targets for $(SOCKC) and $(SOCKH) assume that the permanent
# copies live in [.vms], and the `clean' target will delete copies of
# these files in the current default directory.
SOCKC = sockadapt.c
SOCKH = sockadapt.h
SOCKCLIS = ,$(SOCKC)
SOCKHLIS = ,$(SOCKH)
SOCKOBJ = ,sockadapt$(O)
SOCKPM = [.lib]Socket.pm
.else
SOCKDEF =
SOCKLIB =
SOCKC =
SOCKH =
SOCKCLIS =
SOCKHLIS =
SOCKOBJ =
SOCKPM =
.endif

# C preprocessor manifest "DEBUGGING" ==> perl -D, not the VMS debugger
CFLAGS = /Define=(DEBUGGING$(SOCKDEF)$(XTRADEF))$(XTRACCFLAGS)$(DBGCCFLAGS)
LINKFLAGS = $(DBGLINKFLAGS)

MAKE = $(MMS)
MAKEFILE = [.VMS]Descrip.MMS   # this file
NOOP = continue

# Macros to invoke a copy of miniperl during the build.  Targets which
# are built using these macros should depend on $(MINIPERL_EXE)
MINIPERL_EXE = Sys$Disk:[]miniperl$(E)
MINIPERL = MCR $(MINIPERL_EXE) "-I[.lib]"
XSUBPP = $(MINIPERL) [.lib.extutils]xsubpp
# Macro to invoke a preexisting copy of Perl.  This is used to regenerate
# some header files when rebuilding Perl, but premade versions are provided
# in the distribution, so it's OK if this doesn't work; it's here to make
# life easier for those who modify Perl and rebuild it.
INSTPERL = perl

# Space-separated list of "static" extensions to build into perlshr (case counts).
MYEXT = DynaLoader
# object files for these extensions; the trailing comma is required if
# there are any object files specified
# These must be built separately, or you must add rules below to build them
myextobj = [.ext.dynaloader]dl_vms$(O),
#: We include the Socket extension by default if we're building with socket
#: support, since it's small and not really worth bothering to keep track
#: of separately.
.ifdef SOCKET
EXT = $(MYEXT) Socket
extobj = $(myextobj) [.ext.socket]socket$(O), 
.else
EXT = $(MYEXT)
extobj = $(myextobj)
.endif


#### End of system configuration section. ####


h1 = EXTERN.h, INTERN.h, XSUB.h, av.h, config.h, cop.h, cv.h
h2 = embed.h, form.h, gv.h, handy.h, hv.h, keywords.h, mg.h, op.h
h3 = opcode.h, patchlevel.h, perl.h, perly.h, pp.h, proto.h, regcomp.h
h4 = regexp.h, scope.h, sv.h, vmsish.h, util.h
h = $(h1), $(h2), $(h3), $(h4) $(SOCKHLIS)

c1 = av.c, scope.c, op.c, doop.c, doio.c, dump.c, hv.c, mg.c
c2 = perl.c, perly.c, pp.c, pp_hot.c, pp_ctl.c, pp_sys.c, regcomp.c, regexec.c
c3 = gv.c, sv.c, taint.c, toke.c, util.c, deb.c, run.c, globals.c, vms.c $(SOCKCLIS)

c = $(c1), $(c2), $(c3), miniperlmain.c, perlmain.c

obj1 = perl$(O), gv$(O), toke$(O), perly$(O), op$(O), regcomp$(O), dump$(O), util$(O), mg$(O)
obj2 = hv$(O), av$(O), run$(O), pp_hot$(O), sv$(O), pp$(O), scope$(O), pp_ctl$(O), pp_sys$(O)
obj3 = doop$(O), doio$(O), regexec$(O), taint$(O), deb$(O), globals$(O), vms$(O) $(SOCKOBJ)

obj = $(obj1), $(obj2), $(obj3)

ac1 = $(ARCHCORE)EXTERN.h $(ARCHCORE)INTERN.h  $(ARCHCORE)XSUB.h $(ARCHCORE)av.h
ac2 = $(ARCHCORE)config.h $(ARCHCORE)cop.h $(ARCHCORE)cv.h $(ARCHCORE)embed.h
ac3 = $(ARCHCORE)form.h $(ARCHCORE)gv.h $(ARCHCORE)handy.h $(ARCHCORE)hv.h
ac4 = $(ARCHCORE)keywords.h $(ARCHCORE)mg.h $(ARCHCORE)op.h $(ARCHCORE)opcode.h
ac5 = $(ARCHCORE)patchlevel.h $(ARCHCORE)perl.h $(ARCHCORE)perly.h
ac6 = $(ARCHCORE)pp.h $(ARCHCORE)proto.h $(ARCHCORE)regcomp.h
ac7 = $(ARCHCORE)regexp.h $(ARCHCORE)scope.h $(ARCHCORE)sv.h $(ARCHCORE)util.h
ac8 = $(ARCHCORE)vmsish.h $(ARCHCORE)$(DBG)libperl$(OLB) $(ARCHCORE)perlshr_attr.opt
ac9 = $(ARCHCORE)$(DBG)perlshr_bld.opt
.ifdef SOCKET
acs = $(ARCHCORE)$(SOCKH)
.else
acs =
.endif

CRTL = []crtl.opt
CRTLOPTS =,$(CRTL)/Options

.SUFFIXES
.SUFFIXES $(O) .c .xs

.xs.c :
	$(XSUBPP) $(MMS$SOURCE) >$(MMS$TARGET)


.c$(O) :
	$(CC) $(CFLAGS) $(MMS$SOURCE)

.xs$(O) :
	$(XSUBPP) $(MMS$SOURCE) >$(MMS$SOURCE_NAME).c
	$(CC) $(CFLAGS) $(MMS$SOURCE_NAME).c

all : base extras archcorefiles preplibrary
	@ $(NOOP)
base : miniperl$(E) perl$(E)
	@ $(NOOP)
extras :  [.lib]Config.pm [.lib.$(ARCH)]Config.pm [.lib]DynaLoader.pm [.lib.VMS]Filespec.pm [.lib.extutils]MM_VMS.pm
	@ $(NOOP)
archcorefiles :  $(ac1) $(ac2) $(ac3) $(ac4) $(ac5) $(ac6) $(ac7) $(ac8) $(ac9) $(acs) $(ARCHAUTO)time.stamp
	@ $(NOOP)

miniperl_objs = miniperlmain$(O), $(obj)
$(MINIPERL_EXE) :  miniperlmain$(O), $(DBG)libperl$(OLB) $(CRTL)
	Link $(LINKFLAGS)/NoDebug/Exe=$(MMS$TARGET) miniperlmain$(O), $(DBG)libperl$(OLB)/Library/Include=globals $(CRTLOPTS)
miniperl$(E) :  $(miniperl_objs), $(DBG)libperl$(OLB) $(CRTL)
	Link $(LINKFLAGS)/Exe=$(DBG)$(MMS$TARGET) miniperlmain$(O),$(DBG)libperl$(OLB)/Library/Include=globals  $(CRTLOPTS)

$(DBG)libperl$(OLB) : $(obj)
	@ If F$Search("$(MMS$TARGET)").eqs."" Then Library/Object/Create $(MMS$TARGET)
	Library/Object/Replace $(MMS$TARGET) $(obj1)
	Library/Object/Replace $(MMS$TARGET) $(obj2)
	Library/Object/Replace $(MMS$TARGET) $(obj3)

perlmain.c : miniperlmain.c $(MINIPERL_EXE) [.vms]writemain.pl
	$(MINIPERL) [.VMS]Writemain.pl "$(EXT)"

perl$(E) : perlmain$(O), perlshr$(E), $(MINIPERL_EXE)
	@ @[.vms]genopt "PerlShr.Opt/Write" "|" "''F$Environment("Default")'$(DBG)PerlShr$(E)/Share"
	Link $(LINKFLAGS)/Exe=$(DBG)$(MMS$TARGET) perlmain$(O), perlshr.opt/Option, perlshr_attr.opt/Option
perlshr$(E) : $(DBG)libperl$(OLB) $(extobj) $(DBG)perlshr_xtras.ts
	Link /NoTrace$(LINKFLAGS)/Share=$(DBG)$(MMS$TARGET) $(extobj) []$(DBG)perlshr_bld.opt/Option, perlshr_attr.opt/Option
# The following files are built in one go by gen_shrfls.pl:
#  perlshr_attr.opt, $(DBG)perlshr_bld.opt - VAX and AXP
#  perlshr_gbl*.mar, perlshr_gbl*$(O) - VAX only
.ifdef DECC_PIPES_BROKEN
# This is a backup target used only with older versions of the DECCRTL which
# can't deal with pipes properly.  See ReadMe.VMS for details.
$(DBG)perlshr_xtras.ts : perl.h config.h vmsish.h proto.h [.vms]gen_shrfls.pl $(MINIPERL_EXE) $(MAKEFILE) $(CRTL)
	$(CC) $(CFLAGS)/NoObject/NoList/PreProcess=perl.i perl.h
	$(MINIPERL) [.vms]gen_shrfls.pl "~~NOCC~~perl.i" "$(O)" "$(DBG)" "$(OLB)" "$(EXT)" "$(CRTL)"
	@ Delete/NoLog/NoConfirm perl.i;
	@ If F$Search("$(DBG)perlshr_xtras.ts").nes."" Then Delete/NoLog/NoConfirm $(DBG)perlshr_xtras.ts;*
	@ Copy NLA0: $(DBG)perlshr_xtras.ts
.else
$(DBG)perlshr_xtras.ts : perl.h config.h vmsish.h proto.h [.vms]gen_shrfls.pl $(MINIPERL_EXE) $(MAKEFILE) $(CRTL)
	$(MINIPERL) [.vms]gen_shrfls.pl "$(CC)$(CFLAGS)" "$(O)" "$(DBG)" "$(OLB)" "$(EXT)" "$(CRTL)"
	@ If F$Search("$(DBG)perlshr_xtras.ts").nes."" Then Delete/NoLog/NoConfirm $(DBG)perlshr_xtras.ts;*
	@ Copy NLA0: $(DBG)perlshr_xtras.ts
.endif

[.lib.$(ARCH)]config.pm : [.lib]config.pm
	Create/Directory [.lib.$(ARCH)]
	Copy $(MMS$SOURCE) $(MMS$TARGET)

[.lib]config.pm : [.vms]config.vms [.vms]genconfig.pl $(MINIPERL_EXE)
	$(MINIPERL) [.VMS]GenConfig.Pl cc=$(CC)$(CFLAGS) ldflags=$(LINKFLAGS) obj_ext=$(O) exe_ext=$(E) lib_ext=$(OLB)
	$(MINIPERL) ConfigPM.

[.ext.dynaloader]dl_vms.c : [.ext.dynaloader]dl_vms.xs $(MINIPERL_EXE)
	$(XSUBPP) $(MMS$SOURCE) >$(MMS$TARGET)

[.ext.dynaloader]dl_vms$(O) : [.ext.dynaloader]dl_vms.c
	$(CC) $(CFLAGS) /Object=$(MMS$TARGET) $(MMS$SOURCE)

[.lib]DynaLoader.pm : [.ext.dynaloader]dynaloader.pm
	Copy/Log/NoConfirm [.ext.dynaloader]dynaloader.pm [.lib]DynaLoader.pm

[.lib.VMS]Filespec.pm : [.vms.ext]Filespec.pm
	@ If F$Search("[.lib]VMS.Dir").eqs."" Then Create/Directory [.lib.VMS]
	Copy/Log/NoConfirm $(MMS$SOURCE) $(MMS$TARGET)

[.lib.ExtUtils]MM_VMS.pm : [.vms.ext]MM_VMS.pm
	Copy/Log/NoConfirm $(MMS$SOURCE) $(MMS$TARGET)

preplibrary : $(MINIPERL_EXE) [.lib]DynaLoader.pm [.lib.VMS]Filespec.pm [.lib.ExtUtils]MM_VMS.pm $(SOCKPM)
	@ Write Sys$Output "Autosplitting Perl library . . ."
	@ Create/Directory [.lib.auto]
	@ $(MINIPERL) -e "use AutoSplit; autosplit_lib_modules(@ARGV)" [.lib]*.pm [.lib.*]*.pm

.ifdef SOCKET
$(SOCKOBJ) : $(SOCKC) $(SOCKH)

vmsish.h : $(SOCKH)

$(SOCKC) : [.vms]$(SOCKC)
	Copy/Log/NoConfirm [.vms]$(SOCKC) []$(SOCKC)

$(SOCKH) : [.vms]$(SOCKH)
	Copy/Log/NoConfirm [.vms]$(SOCKH) []$(SOCKH)

[.ext.Socket]Socket.c : [.ext.Socket]Socket.xs $(MINIPERL_EXE)
	$(XSUBPP) $(MMS$SOURCE) >$(MMS$TARGET)

[.ext.Socket]Socket$(O) : [.ext.Socket]Socket.c
	$(CC) $(CFLAGS) /Object=$(MMS$TARGET) $(MMS$SOURCE)

[.lib]Socket.pm : [.ext.Socket]Socket.pm
	Copy/Log/NoConfirm $(MMS$SOURCE) $(MMS$TARGET)
.endif

# The following three header files are generated automatically
#	keywords.h :	keywords.pl
#	opcode.h :	opcode.pl
#	embed.h :	embed.pl global.sym interp.sym
# The correct versions should be already supplied with the perl kit,
# in case you don't have perl available.
# To force them to run, type
#	MMS regen_headers
regen_headers :
	$(INSTPERL) keywords.pl
	$(INSTPERL) opcode.pl
	$(INSTPERL) embed.pl

# VMS uses modified perly.[ch] with tags for globaldefs if using DEC compiler
perly.c : [.vms]perly_c.vms
	Copy/Log $(MMS$SOURCE) $(MMS$TARGET)
perly.h : [.vms]perly_h.vms
	Copy/Log $(MMS$SOURCE) $(MMS$TARGET)

# I now supply perly.c with the kits, so the following section is
# commented out if you don't have byacc.
# Altered for VMS by Charles Bailey  bailey@genetics.upenn.edu
# perly.c:
# 	@ Write Sys$Output "Expect 80 shift/reduce and 62 reduce/reduce conflicts"
# 	\$(BYACC) -d perly.y
# Has to be done by hand or by POSIX shell under VMS
# 	sh \$(shellflags) ./perly.fixer y.tab.c perly.c
# 	rename y.tab.h perly.h
# 	$(INSTPERL) [.vms]vms_yfix.pl perly.c perly.h [.vms]perly_c.vms [.vms]perly_h.vms

perly$(O) : perly.c, perly.h, $(h)
	$(CC) $(CFLAGS) $(MMS$SOURCE)

test : all
	- @[.VMS]Test.Com

# CORE subset for MakeMaker, so we can build Perl without sources
# Should move to VMS installperl when we get one
$(ARCHCORE)EXTERN.h : EXTERN.h
	@ If F$Search("[.lib.$(ARCH)]CORE.dir").eqs."" Then Create/Directory $(ARCHCORE)
	Copy/Log $(MMS$SOURCE) $(MMS$TARGET)
$(ARCHCORE)INTERN.h : INTERN.h
	@ If F$Search("[.lib.$(ARCH)]CORE.dir").eqs."" Then Create/Directory $(ARCHCORE)
	Copy/Log $(MMS$SOURCE) $(MMS$TARGET)
$(ARCHCORE)XSUB.h : XSUB.h
	@ If F$Search("[.lib.$(ARCH)]CORE.dir").eqs."" Then Create/Directory $(ARCHCORE)
	Copy/Log $(MMS$SOURCE) $(MMS$TARGET)
$(ARCHCORE)av.h : av.h
	@ If F$Search("[.lib.$(ARCH)]CORE.dir").eqs."" Then Create/Directory $(ARCHCORE)
	Copy/Log $(MMS$SOURCE) $(MMS$TARGET)
$(ARCHCORE)config.h : config.h
	@ If F$Search("[.lib.$(ARCH)]CORE.dir").eqs."" Then Create/Directory $(ARCHCORE)
	Copy/Log $(MMS$SOURCE) $(MMS$TARGET)
$(ARCHCORE)cop.h : cop.h
	@ If F$Search("[.lib.$(ARCH)]CORE.dir").eqs."" Then Create/Directory $(ARCHCORE)
	Copy/Log $(MMS$SOURCE) $(MMS$TARGET)
$(ARCHCORE)cv.h : cv.h
	@ If F$Search("[.lib.$(ARCH)]CORE.dir").eqs."" Then Create/Directory $(ARCHCORE)
	Copy/Log $(MMS$SOURCE) $(MMS$TARGET)
$(ARCHCORE)embed.h : embed.h
	@ If F$Search("[.lib.$(ARCH)]CORE.dir").eqs."" Then Create/Directory $(ARCHCORE)
	Copy/Log $(MMS$SOURCE) $(MMS$TARGET)
$(ARCHCORE)form.h : form.h
	@ If F$Search("[.lib.$(ARCH)]CORE.dir").eqs."" Then Create/Directory $(ARCHCORE)
	Copy/Log $(MMS$SOURCE) $(MMS$TARGET)
$(ARCHCORE)gv.h : gv.h
	@ If F$Search("[.lib.$(ARCH)]CORE.dir").eqs."" Then Create/Directory $(ARCHCORE)
	Copy/Log $(MMS$SOURCE) $(MMS$TARGET)
$(ARCHCORE)handy.h : handy.h
	@ If F$Search("[.lib.$(ARCH)]CORE.dir").eqs."" Then Create/Directory $(ARCHCORE)
	Copy/Log $(MMS$SOURCE) $(MMS$TARGET)
$(ARCHCORE)hv.h : hv.h
	@ If F$Search("[.lib.$(ARCH)]CORE.dir").eqs."" Then Create/Directory $(ARCHCORE)
	Copy/Log $(MMS$SOURCE) $(MMS$TARGET)
$(ARCHCORE)keywords.h : keywords.h
	@ If F$Search("[.lib.$(ARCH)]CORE.dir").eqs."" Then Create/Directory $(ARCHCORE)
	Copy/Log $(MMS$SOURCE) $(MMS$TARGET)
$(ARCHCORE)mg.h : mg.h
	@ If F$Search("[.lib.$(ARCH)]CORE.dir").eqs."" Then Create/Directory $(ARCHCORE)
	Copy/Log $(MMS$SOURCE) $(MMS$TARGET)
$(ARCHCORE)op.h : op.h
	@ If F$Search("[.lib.$(ARCH)]CORE.dir").eqs."" Then Create/Directory $(ARCHCORE)
	Copy/Log $(MMS$SOURCE) $(MMS$TARGET)
$(ARCHCORE)opcode.h : opcode.h
	@ If F$Search("[.lib.$(ARCH)]CORE.dir").eqs."" Then Create/Directory $(ARCHCORE)
	Copy/Log $(MMS$SOURCE) $(MMS$TARGET)
$(ARCHCORE)patchlevel.h : patchlevel.h
	@ If F$Search("[.lib.$(ARCH)]CORE.dir").eqs."" Then Create/Directory $(ARCHCORE)
	Copy/Log $(MMS$SOURCE) $(MMS$TARGET)
$(ARCHCORE)perl.h : perl.h
	@ If F$Search("[.lib.$(ARCH)]CORE.dir").eqs."" Then Create/Directory $(ARCHCORE)
	Copy/Log $(MMS$SOURCE) $(MMS$TARGET)
$(ARCHCORE)perly.h : perly.h
	@ If F$Search("[.lib.$(ARCH)]CORE.dir").eqs."" Then Create/Directory $(ARCHCORE)
	Copy/Log $(MMS$SOURCE) $(MMS$TARGET)
$(ARCHCORE)pp.h : pp.h
	@ If F$Search("[.lib.$(ARCH)]CORE.dir").eqs."" Then Create/Directory $(ARCHCORE)
	Copy/Log $(MMS$SOURCE) $(MMS$TARGET)
$(ARCHCORE)proto.h : proto.h
	@ If F$Search("[.lib.$(ARCH)]CORE.dir").eqs."" Then Create/Directory $(ARCHCORE)
	Copy/Log $(MMS$SOURCE) $(MMS$TARGET)
$(ARCHCORE)regcomp.h : regcomp.h
	@ If F$Search("[.lib.$(ARCH)]CORE.dir").eqs."" Then Create/Directory $(ARCHCORE)
	Copy/Log $(MMS$SOURCE) $(MMS$TARGET)
$(ARCHCORE)regexp.h : regexp.h
	@ If F$Search("[.lib.$(ARCH)]CORE.dir").eqs."" Then Create/Directory $(ARCHCORE)
	Copy/Log $(MMS$SOURCE) $(MMS$TARGET)
$(ARCHCORE)scope.h : scope.h
	@ If F$Search("[.lib.$(ARCH)]CORE.dir").eqs."" Then Create/Directory $(ARCHCORE)
	Copy/Log $(MMS$SOURCE) $(MMS$TARGET)
$(ARCHCORE)sv.h : sv.h
	@ If F$Search("[.lib.$(ARCH)]CORE.dir").eqs."" Then Create/Directory $(ARCHCORE)
	Copy/Log $(MMS$SOURCE) $(MMS$TARGET)
$(ARCHCORE)util.h : util.h
	@ If F$Search("[.lib.$(ARCH)]CORE.dir").eqs."" Then Create/Directory $(ARCHCORE)
	Copy/Log $(MMS$SOURCE) $(MMS$TARGET)
$(ARCHCORE)vmsish.h : vmsish.h
	@ If F$Search("[.lib.$(ARCH)]CORE.dir").eqs."" Then Create/Directory $(ARCHCORE)
	Copy/Log $(MMS$SOURCE) $(MMS$TARGET)
.ifdef SOCKET
$(ARCHCORE)$(SOCKH) : $(SOCKH)
	@ If F$Search("[.lib.$(ARCH)]CORE.dir").eqs."" Then Create/Directory $(ARCHCORE)
	Copy/Log $(MMS$SOURCE) $(MMS$TARGET)
.endif
$(ARCHCORE)$(DBG)libperl$(OLB) : $(DBG)libperl$(OLB) $(DBG)perlshr_xtras.ts
	@ If F$Search("[.lib.$(ARCH)]CORE.dir").eqs."" Then Create/Directory $(ARCHCORE)
	Copy/Log $(MMS$SOURCE) $(MMS$TARGET)
$(ARCHCORE)perlshr_attr.opt : $(DBG)perlshr_xtras.ts
	@ If F$Search("[.lib.$(ARCH)]CORE.dir").eqs."" Then Create/Directory $(ARCHCORE)
	Copy/Log perlshr_attr.opt $(MMS$TARGET)
$(ARCHCORE)$(DBG)perlshr_bld.opt : $(DBG)perlshr_xtras.ts
	@ If F$Search("[.lib.$(ARCH)]CORE.dir").eqs."" Then Create/Directory $(ARCHCORE)
	Copy/Log $(DBG)perlshr_bld.opt $(MMS$TARGET)
$(ARCHAUTO)time.stamp :
	@ If F$Search("[.lib.$(ARCH)]auto.dir").eqs."" Then Create/Directory $(ARCHAUTO)
	@ If F$Search("$(MMS$TARGET)").eqs."" Then Copy/NoConfirm _NLA0: $(MMS$TARGET)

# AUTOMATICALLY GENERATED MAKE DEPENDENCIES--PUT NOTHING BELOW THIS LINE
av$(O) : EXTERN.h
av$(O) : av.c
av$(O) : av.h
av$(O) : config.h
av$(O) : cop.h
av$(O) : cv.h
av$(O) : embed.h
av$(O) : form.h
av$(O) : gv.h
av$(O) : handy.h
av$(O) : hv.h
av$(O) : mg.h
av$(O) : op.h
av$(O) : opcode.h
av$(O) : perl.h
av$(O) : perly.h
av$(O) : pp.h
av$(O) : proto.h
av$(O) : regexp.h
av$(O) : scope.h
av$(O) : sv.h
av$(O) : vmsish.h
av$(O) : util.h
scope$(O) : EXTERN.h
scope$(O) : av.h
scope$(O) : config.h
scope$(O) : cop.h
scope$(O) : cv.h
scope$(O) : embed.h
scope$(O) : form.h
scope$(O) : gv.h
scope$(O) : handy.h
scope$(O) : hv.h
scope$(O) : mg.h
scope$(O) : op.h
scope$(O) : opcode.h
scope$(O) : perl.h
scope$(O) : perly.h
scope$(O) : pp.h
scope$(O) : proto.h
scope$(O) : regexp.h
scope$(O) : scope.c
scope$(O) : scope.h
scope$(O) : sv.h
scope$(O) : vmsish.h
scope$(O) : util.h
op$(O) : EXTERN.h
op$(O) : av.h
op$(O) : config.h
op$(O) : cop.h
op$(O) : cv.h
op$(O) : embed.h
op$(O) : form.h
op$(O) : gv.h
op$(O) : handy.h
op$(O) : hv.h
op$(O) : mg.h
op$(O) : op.c
op$(O) : op.h
op$(O) : opcode.h
op$(O) : perl.h
op$(O) : perly.h
op$(O) : pp.h
op$(O) : proto.h
op$(O) : regexp.h
op$(O) : scope.h
op$(O) : sv.h
op$(O) : vmsish.h
op$(O) : util.h
doop$(O) : EXTERN.h
doop$(O) : av.h
doop$(O) : config.h
doop$(O) : cop.h
doop$(O) : cv.h
doop$(O) : doop.c
doop$(O) : embed.h
doop$(O) : form.h
doop$(O) : gv.h
doop$(O) : handy.h
doop$(O) : hv.h
doop$(O) : mg.h
doop$(O) : op.h
doop$(O) : opcode.h
doop$(O) : perl.h
doop$(O) : perly.h
doop$(O) : pp.h
doop$(O) : proto.h
doop$(O) : regexp.h
doop$(O) : scope.h
doop$(O) : sv.h
doop$(O) : vmsish.h
doop$(O) : util.h
doio$(O) : EXTERN.h
doio$(O) : av.h
doio$(O) : config.h
doio$(O) : cop.h
doio$(O) : cv.h
doio$(O) : doio.c
doio$(O) : embed.h
doio$(O) : form.h
doio$(O) : gv.h
doio$(O) : handy.h
doio$(O) : hv.h
doio$(O) : mg.h
doio$(O) : op.h
doio$(O) : opcode.h
doio$(O) : perl.h
doio$(O) : perly.h
doio$(O) : pp.h
doio$(O) : proto.h
doio$(O) : regexp.h
doio$(O) : scope.h
doio$(O) : sv.h
doio$(O) : vmsish.h
doio$(O) : util.h
dump$(O) : EXTERN.h
dump$(O) : av.h
dump$(O) : config.h
dump$(O) : cop.h
dump$(O) : cv.h
dump$(O) : dump.c
dump$(O) : embed.h
dump$(O) : form.h
dump$(O) : gv.h
dump$(O) : handy.h
dump$(O) : hv.h
dump$(O) : mg.h
dump$(O) : op.h
dump$(O) : opcode.h
dump$(O) : perl.h
dump$(O) : perly.h
dump$(O) : pp.h
dump$(O) : proto.h
dump$(O) : regexp.h
dump$(O) : scope.h
dump$(O) : sv.h
dump$(O) : vmsish.h
dump$(O) : util.h
hv$(O) : EXTERN.h
hv$(O) : av.h
hv$(O) : config.h
hv$(O) : cop.h
hv$(O) : cv.h
hv$(O) : embed.h
hv$(O) : form.h
hv$(O) : gv.h
hv$(O) : handy.h
hv$(O) : hv.c
hv$(O) : hv.h
hv$(O) : mg.h
hv$(O) : op.h
hv$(O) : opcode.h
hv$(O) : perl.h
hv$(O) : perly.h
hv$(O) : pp.h
hv$(O) : proto.h
hv$(O) : regexp.h
hv$(O) : scope.h
hv$(O) : sv.h
hv$(O) : vmsish.h
hv$(O) : util.h
mg$(O) : EXTERN.h
mg$(O) : av.h
mg$(O) : config.h
mg$(O) : cop.h
mg$(O) : cv.h
mg$(O) : embed.h
mg$(O) : form.h
mg$(O) : gv.h
mg$(O) : handy.h
mg$(O) : hv.h
mg$(O) : mg.c
mg$(O) : mg.h
mg$(O) : op.h
mg$(O) : opcode.h
mg$(O) : perl.h
mg$(O) : perly.h
mg$(O) : pp.h
mg$(O) : proto.h
mg$(O) : regexp.h
mg$(O) : scope.h
mg$(O) : sv.h
mg$(O) : vmsish.h
mg$(O) : util.h
perl$(O) : EXTERN.h
perl$(O) : av.h
perl$(O) : config.h
perl$(O) : cop.h
perl$(O) : cv.h
perl$(O) : embed.h
perl$(O) : form.h
perl$(O) : gv.h
perl$(O) : handy.h
perl$(O) : hv.h
perl$(O) : mg.h
perl$(O) : op.h
perl$(O) : opcode.h
perl$(O) : perl.c
perl$(O) : perl.h
perl$(O) : perly.h
perl$(O) : pp.h
perl$(O) : proto.h
perl$(O) : regexp.h
perl$(O) : scope.h
perl$(O) : sv.h
perl$(O) : vmsish.h
perl$(O) : util.h
perly$(O) : EXTERN.h
perly$(O) : av.h
perly$(O) : config.h
perly$(O) : cop.h
perly$(O) : cv.h
perly$(O) : embed.h
perly$(O) : form.h
perly$(O) : gv.h
perly$(O) : handy.h
perly$(O) : hv.h
perly$(O) : mg.h
perly$(O) : op.h
perly$(O) : opcode.h
perly$(O) : perl.h
perly$(O) : perly.h
perly$(O) : perly.c
perly$(O) : pp.h
perly$(O) : proto.h
perly$(O) : regexp.h
perly$(O) : scope.h
perly$(O) : sv.h
perly$(O) : vmsish.h
perly$(O) : util.h
pp$(O) : EXTERN.h
pp$(O) : av.h
pp$(O) : config.h
pp$(O) : cop.h
pp$(O) : cv.h
pp$(O) : embed.h
pp$(O) : form.h
pp$(O) : gv.h
pp$(O) : handy.h
pp$(O) : hv.h
pp$(O) : mg.h
pp$(O) : op.h
pp$(O) : opcode.h
pp$(O) : perl.h
pp$(O) : perly.h
pp$(O) : pp.c
pp$(O) : pp.h
pp$(O) : proto.h
pp$(O) : regexp.h
pp$(O) : scope.h
pp$(O) : sv.h
pp$(O) : vmsish.h
pp$(O) : util.h
pp_ctl$(O) : EXTERN.h
pp_ctl$(O) : av.h
pp_ctl$(O) : config.h
pp_ctl$(O) : cop.h
pp_ctl$(O) : cv.h
pp_ctl$(O) : embed.h
pp_ctl$(O) : form.h
pp_ctl$(O) : gv.h
pp_ctl$(O) : handy.h
pp_ctl$(O) : hv.h
pp_ctl$(O) : mg.h
pp_ctl$(O) : op.h
pp_ctl$(O) : opcode.h
pp_ctl$(O) : perl.h
pp_ctl$(O) : perly.h
pp_ctl$(O) : pp_ctl.c
pp_ctl$(O) : pp.h
pp_ctl$(O) : proto.h
pp_ctl$(O) : regexp.h
pp_ctl$(O) : scope.h
pp_ctl$(O) : sv.h
pp_ctl$(O) : vmsish.h
pp_ctl$(O) : util.h
pp_hot$(O) : EXTERN.h
pp_hot$(O) : av.h
pp_hot$(O) : config.h
pp_hot$(O) : cop.h
pp_hot$(O) : cv.h
pp_hot$(O) : embed.h
pp_hot$(O) : form.h
pp_hot$(O) : gv.h
pp_hot$(O) : handy.h
pp_hot$(O) : hv.h
pp_hot$(O) : mg.h
pp_hot$(O) : op.h
pp_hot$(O) : opcode.h
pp_hot$(O) : perl.h
pp_hot$(O) : perly.h
pp_hot$(O) : pp_hot.c
pp_hot$(O) : pp.h
pp_hot$(O) : proto.h
pp_hot$(O) : regexp.h
pp_hot$(O) : scope.h
pp_hot$(O) : sv.h
pp_hot$(O) : vmsish.h
pp_hot$(O) : util.h
pp_sys$(O) : EXTERN.h
pp_sys$(O) : av.h
pp_sys$(O) : config.h
pp_sys$(O) : cop.h
pp_sys$(O) : cv.h
pp_sys$(O) : embed.h
pp_sys$(O) : form.h
pp_sys$(O) : gv.h
pp_sys$(O) : handy.h
pp_sys$(O) : hv.h
pp_sys$(O) : mg.h
pp_sys$(O) : op.h
pp_sys$(O) : opcode.h
pp_sys$(O) : perl.h
pp_sys$(O) : perly.h
pp_sys$(O) : pp_sys.c
pp_sys$(O) : pp.h
pp_sys$(O) : proto.h
pp_sys$(O) : regexp.h
pp_sys$(O) : scope.h
pp_sys$(O) : sv.h
pp_sys$(O) : vmsish.h
pp_sys$(O) : util.h
regcomp$(O) : EXTERN.h
regcomp$(O) : INTERN.h
regcomp$(O) : av.h
regcomp$(O) : config.h
regcomp$(O) : cop.h
regcomp$(O) : cv.h
regcomp$(O) : embed.h
regcomp$(O) : form.h
regcomp$(O) : gv.h
regcomp$(O) : handy.h
regcomp$(O) : hv.h
regcomp$(O) : mg.h
regcomp$(O) : op.h
regcomp$(O) : opcode.h
regcomp$(O) : perl.h
regcomp$(O) : perly.h
regcomp$(O) : pp.h
regcomp$(O) : proto.h
regcomp$(O) : regcomp.c
regcomp$(O) : regcomp.h
regcomp$(O) : regexp.h
regcomp$(O) : scope.h
regcomp$(O) : sv.h
regcomp$(O) : vmsish.h
regcomp$(O) : util.h
regexec$(O) : EXTERN.h
regexec$(O) : av.h
regexec$(O) : config.h
regexec$(O) : cop.h
regexec$(O) : cv.h
regexec$(O) : embed.h
regexec$(O) : form.h
regexec$(O) : gv.h
regexec$(O) : handy.h
regexec$(O) : hv.h
regexec$(O) : mg.h
regexec$(O) : op.h
regexec$(O) : opcode.h
regexec$(O) : perl.h
regexec$(O) : perly.h
regexec$(O) : pp.h
regexec$(O) : proto.h
regexec$(O) : regcomp.h
regexec$(O) : regexec.c
regexec$(O) : regexp.h
regexec$(O) : scope.h
regexec$(O) : sv.h
regexec$(O) : vmsish.h
regexec$(O) : util.h
gv$(O) : EXTERN.h
gv$(O) : av.h
gv$(O) : config.h
gv$(O) : cop.h
gv$(O) : cv.h
gv$(O) : embed.h
gv$(O) : form.h
gv$(O) : gv.c
gv$(O) : gv.h
gv$(O) : handy.h
gv$(O) : hv.h
gv$(O) : mg.h
gv$(O) : op.h
gv$(O) : opcode.h
gv$(O) : perl.h
gv$(O) : perly.h
gv$(O) : pp.h
gv$(O) : proto.h
gv$(O) : regexp.h
gv$(O) : scope.h
gv$(O) : sv.h
gv$(O) : vmsish.h
gv$(O) : util.h
sv$(O) : EXTERN.h
sv$(O) : av.h
sv$(O) : config.h
sv$(O) : cop.h
sv$(O) : cv.h
sv$(O) : embed.h
sv$(O) : form.h
sv$(O) : gv.h
sv$(O) : handy.h
sv$(O) : hv.h
sv$(O) : mg.h
sv$(O) : op.h
sv$(O) : opcode.h
sv$(O) : perl.h
sv$(O) : perly.h
sv$(O) : pp.h
sv$(O) : proto.h
sv$(O) : regexp.h
sv$(O) : scope.h
sv$(O) : sv.c
sv$(O) : sv.h
sv$(O) : vmsish.h
sv$(O) : util.h
taint$(O) : EXTERN.h
taint$(O) : av.h
taint$(O) : config.h
taint$(O) : cop.h
taint$(O) : cv.h
taint$(O) : embed.h
taint$(O) : form.h
taint$(O) : gv.h
taint$(O) : handy.h
taint$(O) : hv.h
taint$(O) : mg.h
taint$(O) : op.h
taint$(O) : opcode.h
taint$(O) : perl.h
taint$(O) : perly.h
taint$(O) : pp.h
taint$(O) : proto.h
taint$(O) : regexp.h
taint$(O) : scope.h
taint$(O) : sv.h
taint$(O) : taint.c
taint$(O) : vmsish.h
taint$(O) : util.h
toke$(O) : EXTERN.h
toke$(O) : av.h
toke$(O) : config.h
toke$(O) : cop.h
toke$(O) : cv.h
toke$(O) : embed.h
toke$(O) : form.h
toke$(O) : gv.h
toke$(O) : handy.h
toke$(O) : hv.h
toke$(O) : keywords.h
toke$(O) : mg.h
toke$(O) : op.h
toke$(O) : opcode.h
toke$(O) : perl.h
toke$(O) : perly.h
toke$(O) : pp.h
toke$(O) : proto.h
toke$(O) : regexp.h
toke$(O) : scope.h
toke$(O) : sv.h
toke$(O) : toke.c
toke$(O) : vmsish.h
toke$(O) : util.h
util$(O) : EXTERN.h
util$(O) : av.h
util$(O) : config.h
util$(O) : cop.h
util$(O) : cv.h
util$(O) : embed.h
util$(O) : form.h
util$(O) : gv.h
util$(O) : handy.h
util$(O) : hv.h
util$(O) : mg.h
util$(O) : op.h
util$(O) : opcode.h
util$(O) : perl.h
util$(O) : perly.h
util$(O) : pp.h
util$(O) : proto.h
util$(O) : regexp.h
util$(O) : scope.h
util$(O) : sv.h
util$(O) : vmsish.h
util$(O) : util.c
util$(O) : util.h
deb$(O) : EXTERN.h
deb$(O) : av.h
deb$(O) : config.h
deb$(O) : cop.h
deb$(O) : cv.h
deb$(O) : deb.c
deb$(O) : embed.h
deb$(O) : form.h
deb$(O) : gv.h
deb$(O) : handy.h
deb$(O) : hv.h
deb$(O) : mg.h
deb$(O) : op.h
deb$(O) : opcode.h
deb$(O) : perl.h
deb$(O) : perly.h
deb$(O) : pp.h
deb$(O) : proto.h
deb$(O) : regexp.h
deb$(O) : scope.h
deb$(O) : sv.h
deb$(O) : vmsish.h
deb$(O) : util.h
run$(O) : EXTERN.h
run$(O) : av.h
run$(O) : config.h
run$(O) : cop.h
run$(O) : cv.h
run$(O) : embed.h
run$(O) : form.h
run$(O) : gv.h
run$(O) : handy.h
run$(O) : hv.h
run$(O) : mg.h
run$(O) : op.h
run$(O) : opcode.h
run$(O) : perl.h
run$(O) : perly.h
run$(O) : pp.h
run$(O) : proto.h
run$(O) : regexp.h
run$(O) : run.c
run$(O) : scope.h
run$(O) : sv.h
run$(O) : vmsish.h
run$(O) : util.h
vms$(O) : EXTERN.h
vms$(O) : av.h
vms$(O) : config.h
vms$(O) : cop.h
vms$(O) : cv.h
vms$(O) : embed.h
vms$(O) : form.h
vms$(O) : gv.h
vms$(O) : handy.h
vms$(O) : hv.h
vms$(O) : mg.h
vms$(O) : op.h
vms$(O) : opcode.h
vms$(O) : perl.h
vms$(O) : perly.h
vms$(O) : pp.h
vms$(O) : proto.h
vms$(O) : regexp.h
vms$(O) : vms.c
vms$(O) : scope.h
vms$(O) : sv.h
vms$(O) : vmsish.h
vms$(O) : util.h
miniperlmain$(O) : EXTERN.h
miniperlmain$(O) : av.h
miniperlmain$(O) : config.h
miniperlmain$(O) : cop.h
miniperlmain$(O) : cv.h
miniperlmain$(O) : embed.h
miniperlmain$(O) : form.h
miniperlmain$(O) : gv.h
miniperlmain$(O) : handy.h
miniperlmain$(O) : hv.h
miniperlmain$(O) : mg.h
miniperlmain$(O) : miniperlmain.c
miniperlmain$(O) : op.h
miniperlmain$(O) : opcode.h
miniperlmain$(O) : perl.h
miniperlmain$(O) : perly.h
miniperlmain$(O) : pp.h
miniperlmain$(O) : proto.h
miniperlmain$(O) : regexp.h
miniperlmain$(O) : scope.h
miniperlmain$(O) : sv.h
miniperlmain$(O) : vmsish.h
miniperlmain$(O) : util.h
perlmain$(O) : EXTERN.h
perlmain$(O) : av.h
perlmain$(O) : config.h
perlmain$(O) : cop.h
perlmain$(O) : cv.h
perlmain$(O) : embed.h
perlmain$(O) : form.h
perlmain$(O) : gv.h
perlmain$(O) : handy.h
perlmain$(O) : hv.h
perlmain$(O) : mg.h
perlmain$(O) : op.h
perlmain$(O) : opcode.h
perlmain$(O) : perl.h
perlmain$(O) : perly.h
perlmain$(O) : perlmain.c
perlmain$(O) : pp.h
perlmain$(O) : proto.h
perlmain$(O) : regexp.h
perlmain$(O) : scope.h
perlmain$(O) : sv.h
perlmain$(O) : vmsish.h
perlmain$(O) : util.h
globals$(O) : INTERN.h
globals$(O) : av.h
globals$(O) : config.h
globals$(O) : cop.h
globals$(O) : cv.h
globals$(O) : embed.h
globals$(O) : form.h
globals$(O) : gv.h
globals$(O) : handy.h
globals$(O) : hv.h
globals$(O) : mg.h
globals$(O) : op.h
globals$(O) : opcode.h
globals$(O) : perl.h
globals$(O) : perly.h
globals$(O) : globals.c
globals$(O) : pp.h
globals$(O) : proto.h
globals$(O) : regexp.h
globals$(O) : scope.h
globals$(O) : sv.h
globals$(O) : vmsish.h
globals$(O) : util.h

config.h : [.vms]config.vms
	Copy/Log/NoConfirm [.vms]config.vms []config.h

vmsish.h : [.vms]vmsish.h
	Copy/Log/NoConfirm [.vms]vmsish.h []vmsish.h

vms.c : [.vms]vms.c
	Copy/Log/Noconfirm [.vms]vms.c []

$(CRTL) : $(MAKEFILE)
	@ @[.vms]genopt "$(CRTL)/Write" "|" "$(LIBS1)|$(LIBS2)|$(SOCKLIB)"


cleanlis :
	- If F$Search("*.Lis").nes."" Then Delete/NoConfirm/Log *.Lis;*
	- If F$Search("*.CPP").nes."" Then Delete/NoConfirm/Log *.CPP;*
	- If F$Search("*.Map").nes."" Then Delete/NoConfirm/Log *.Map;*

tidy : cleanlis
	- If F$Search("*.Opt;-1").nes."" Then Purge/NoConfirm/Log *.Opt
	- If F$Search("*$(O);-1").nes."" Then Purge/NoConfirm/Log *$(O)
	- If F$Search("*$(E);-1").nes."" Then Purge/NoConfirm/Log *$(E)
	- If F$Search("Config.H;-1").nes."" Then Purge/NoConfirm/Log Config.H
	- If F$Search("Config.SH;-1").nes."" Then Purge/NoConfirm/Log Config.SH
	- If F$Search("perly.c;-1").nes."" Then Purge/NoConfirm/Log perly.c
	- If F$Search("perly.h;-1").nes."" Then Purge/NoConfirm/Log perly.h
	- If F$Search("VMSish.H;-1").nes."" Then Purge/NoConfirm/Log VMSish.H
	- If F$Search("VMS.C;-1")   .nes."" Then Purge/NoConfirm/Log VMS.C
	- If F$Search("Perlmain.C;-1")   .nes."" Then Purge/NoConfirm/Log Perlmain.C
	- If F$Search("Perlshr_Gbl*.Mar;-1")   .nes."" Then Purge/NoConfirm/Log Perlshr_Gbl*.Mar
	- If F$Search("[.Ext.DynaLoader]DL_VMS$(O);-1").nes."" Then Purge/NoConfirm/Log [.Ext.DynaLoader]DL_VMS$(O)
	- If F$Search("[.Ext.DynaLoader]DL_VMS.C;-1").nes."" Then Purge/NoConfirm/Log [.Ext.DynaLoader]DL_VMS.C
	- If F$Search("[.VMS.Ext...]*.C;-1").nes."" Then Purge/NoConfirm/Log [.VMS.Ext...]*.C
	- If F$Search("[.VMS.Ext...]*$(O);-1").nes."" Then Purge/NoConfirm/Log [.VMS.Ext...]*$(O)
	- If F$Search("[.Lib.Auto...]*.al;-1").nes."" Then Purge/NoConfirm/Log [.Lib.Auto...]*.al
	- If F$Search("[.Lib.Auto...]autosplit.ix;-1").nes."" Then Purge/NoConfirm/Log [.Lib.Auto...]autosplit.ix
	- If F$Search("[.Lib]DynaLoader.pm;-1").nes."" Then Purge/NoConfirm/Log [.Lib]DynaLoader.pm
	- If F$Search("[.Lib]Socket.pm;-1").nes."" Then Purge/NoConfirm/Log [.Lib]Socket.pm
	- If F$Search("[.Lib]Config.pm;-1").nes."" Then Purge/NoConfirm/Log [.Lib]Config.pm
	- If F$Search("[.Lib.$(ARCH)]Config.pm;-1").nes."" Then Purge/NoConfirm/Log [.Lib.$(ARCH)]Config.pm
	- If F$Search("[.Lib.VMS]*.*;-1").nes."" Then Purge/NoConfirm/Log [.Lib.VMS]*.*
	- If F$Search("[.Lib.ExtUtils]MM_VMS.pm;-1").nes."" Then Purge/NoConfirm/Log [.Lib.ExtUtils]MM_VMS.pm
	- If F$Search("$(ARCHCORE)*.*").nes."" Then Purge/NoConfirm/Log $(ARCHCORE)*.*

clean : tidy
	- If F$Search("*.Opt").nes."" Then Delete/NoConfirm/Log *.Opt;*/Exclude=PerlShr_*.Opt
	- If F$Search("*$(O);*") .nes."" Then Delete/NoConfirm/Log *$(O);*
	- If F$Search("Config.H").nes."" Then Delete/NoConfirm/Log Config.H;*
	- If F$Search("Config.SH").nes."" Then Delete/NoConfirm/Log Config.SH;*
	- If F$Search(F$Parse("Sys$Disk:[]","$(SOCKH)")).nes."" Then Delete/NoConfirm/Log $(SOCKH);*
	- If F$Search(F$Parse("Sys$Disk:[]","$(SOCKC)")).nes."" Then Delete/NoConfirm/Log $(SOCKC);*
	- If F$Search("perly.c").nes."" Then Delete/NoConfirm/Log perly.c;*
	- If F$Search("perly.h").nes."" Then Delete/NoConfirm/Log perly.h;*
	- If F$Search("VMSish.H").nes."" Then Delete/NoConfirm/Log VMSish.H;*
	- If F$Search("VMS.C")   .nes."" Then Delete/NoConfirm/Log VMS.C;*
	- If F$Search("Perlmain.C")   .nes."" Then Delete/NoConfirm/Log Perlmain.C;*
	- If F$Search("Perlshr_Gbl*.Mar")   .nes."" Then Delete/NoConfirm/Log Perlshr_Gbl*.Mar;*
	- If F$Search("*.TS").nes."" Then Delete/NoConfirm/Log *.TS;*
	- If F$Search("[.Ext.DynaLoader]DL_VMS$(O)").nes."" Then Delete/NoConfirm/Log [.Ext.DynaLoader]DL_VMS$(O);*
	- If F$Search("[.Ext.DynaLoader]DL_VMS.C").nes."" Then Delete/NoConfirm/Log [.Ext.DynaLoader]DL_VMS.C;*
	- If F$Search("[.Ext.Socket]Socket$(O)").nes."" Then Delete/NoConfirm/Log [.Ext.Socket]Socket$(O);*
	- If F$Search("[.Ext.Socket]Socket.C").nes."" Then Delete/NoConfirm/Log [.Ext.Socket]Socket.C;*
	- If F$Search("[.VMS.Ext...]*.C").nes."" Then Delete/NoConfirm/Log [.VMS.Ext...]*.C;*
	- If F$Search("[.VMS.Ext...]*$(O)").nes."" Then Delete/NoConfirm/Log [.VMS.Ext...]*$(O);*

realclean : clean
	- If F$Search("*$(OLB)").nes."" Then Delete/NoConfirm/Log *$(OLB);*
	- If F$Search("*.Opt").nes."" Then Delete/NoConfirm/Log *.Opt;*
	- $(MINIPERL) -e "use File::Path; rmtree(['lib/auto','lib/VMS','lib/$(ARCH)'],1,0);"
	- If F$Search("[.Lib]DynaLoader.pm").nes."" Then Delete/NoConfirm/Log [.Lib]DynaLoader.pm;*
	- If F$Search("[.Lib.ExtUtils]MM_VMS.pm").nes."" Then Delete/NoConfirm/Log [.Lib.ExtUtils]MM_VMS.pm;*
	- If F$Search("*$(E)").nes."" Then Delete/NoConfirm/Log *$(E);*
	- If F$Search("[.Lib]Config.pm").nes."" Then Delete/NoConfirm/Log [.Lib]Config.pm;*
	- If F$Search("[.Lib.$(ARCH)]Config.pm").nes."" Then Delete/NoConfirm/Log [.Lib.$(ARCH)]Config.pm;*

cleansrc : clean
	- If F$Search("*.C;-1").nes."" Then Purge/NoConfirm/Log *.C
	- If F$Search("*.H;-1").nes."" Then Purge/NoConfirm/Log *.H
	- If F$Search("*.VMS;-1").nes."" Then Purge/NoConfirm/Log *.VMS
	- If F$Search("[.VMS]$(MAKEFILE);-1").nes."" Then Purge/NoConfirm/Log [.VMS]$(MAKEFILE)
	- If F$Search("[.VMS]*.C;-1").nes."" Then Purge/NoConfirm/Log [.VMS]*.C
	- If F$Search("[.VMS]*.H;-1").nes."" Then Purge/NoConfirm/Log [.VMS]*.H
	- If F$Search("[.VMS]*.Pl;-1").nes."" Then Purge/NoConfirm/Log [.VMS]*.Pl
	- If F$Search("[.VMS]*.VMS;-1").nes."" Then Purge/NoConfirm/Log [.VMS]*.VMS
	- If F$Search("[.VMS...]*.pm;-1").nes."" Then Purge/NoConfirm/Log [.VMS...]*.pm
	- If F$Search("[.VMS...]*.xs;-1").nes."" Then Purge/NoConfirm/Log [.VMS...]*.xs
