use Evo::Base -strict;
use Test::More tests => 3;
use Promises6 'deferred';

my $d;

$d = deferred;
$d->promise->then(sub($v) {fail}, sub($val) { is $val, 'foo' });
$d->reject('foo');

$d = deferred;
$d->promise->then(sub { deferred->reject('reason')->promise })

  # skip rej
  ->then(sub($v) {fail},)

  # reject cb because skipped
  ->then(sub($v) {fail}, sub($v) { deferred->reject('reason')->promise })

  # reject cb because rejected
  ->then(sub($v) {fail}, sub($v) { deferred->reject('reason')->promise })

  # skip rej
  ->then(sub($v) {fail},)

  # rej because skipped
  ->then(sub($v) {fail}, sub($v) { pass; 'foo' })

  # fulfill
  ->then(sub($v) { is $v, 'foo' }, sub($v) {fail});

$d->resolve('S');

done_testing;
