package Mojo::Pua::Class;
use Mojo::Base 'Mojo::UserAgent';
use Evo 'Mojo::Promise::Class; Carp croak; Mojo::Pua::Error';
use Evo::Promise::Deferred;


sub start ($self, $tx, $cb_empty = undef) {

  croak "Got callback but this class returns a Promise" if $cb_empty;
  my $p = Mojo::Promise::Class->new;
  my $d = Evo::Promise::Deferred->new(promise => $p);


  my $pcb = sub ($ua, $tx) {
    my $res = $tx->success;
    return $d->resolve($res) if $res;

    my $err  = $tx->error;
    my $perr = Mojo::Pua::Error->new(
      res     => $tx->res,
      message => $err->{message},
      code    => $err->{code}
    );
    $d->reject($perr);
  };

  $self->SUPER::start($tx, $pcb);

  $p;
}


1;

# ABSTRACT: HTTP Client Class + Evo::Promises

__END__

=pod

=encoding UTF-8

=head1 NAME

Mojo::Pua::Class - HTTP Client Class + Evo::Promises

=head1 VERSION

version 0.004

=head1 SYNOPSIS

  use Evo 'Mojo::Pua::Class';
  my $ua = Mojo::Pua::Class->new();

  $ua->get("http://alexbyk.com/")

    ->then(sub($res) { say $res->dom->at('title') })

    ->catch(sub($err) { say "ERR: $err"; say $err->res->body if $err->res; })

    ->finally(sub { Mojo::IOLoop->stop; });

  Mojo::IOLoop->start;

=head2 DESCRIPTION

C<Mojo::Pua::Class> inherits all methods from L<Mojo::UserAgent> but returns L<Evo::Promise::Class> object for each request

=head1 AUTHOR

alexbyk <alexbyk.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by alexbyk.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
