package Apache::Template;

use ExtUtils::MakeMaker;
use lib qw( lib );
use Apache::Template;
use Apache::ExtUtils qw( command_table );
use Apache::src ();


my @directives = (
    #-- parsing/style options --
    {   name         => 'TT2Tags',
        errmsg       => 'tag style or start and end tags for template directives',
        args_how     => 'TAKE12',
        req_override => 'RSRC_CONF | ACCESS_CONF',
    },
    {   name         => 'TT2PreChomp',
        errmsg       => 'flag to remove newline and whitespace before directives',
        args_how     => 'FLAG',
        req_override => 'RSRC_CONF | ACCESS_CONF',
    },
    {   name         => 'TT2PostChomp',
        errmsg       => 'flag to remove newline and whitespace after directives',
        args_how     => 'FLAG',
        req_override => 'RSRC_CONF | ACCESS_CONF',
    },
    {   name         => 'TT2Trim',
        errmsg       => 'flag to trim whitespace surrounding template output',
        args_how     => 'FLAG',
        req_override => 'RSRC_CONF | ACCESS_CONF',
    },
    {   name         => 'TT2AnyCase',
        errmsg       => 'flag to allow directive keywords in any case',
        args_how     => 'FLAG',
        req_override => 'RSRC_CONF | ACCESS_CONF',
    },
    {   name         => 'TT2Interpolate',
        errmsg       => 'flag to interpolate embedded variable references',
        args_how     => 'FLAG',
        req_override => 'RSRC_CONF | ACCESS_CONF',
    },

    #-- file/directory options --
    {   name         => 'TT2IncludePath',
        errmsg       => 'local path(s) containing templates',
        args_how     => 'ITERATE',
        req_override => 'RSRC_CONF | ACCESS_CONF',
    },
    {   name         => 'TT2Absolute',
        errmsg       => 'flag to enable absolute filenames',
        args_how     => 'FLAG',
        req_override => 'RSRC_CONF | ACCESS_CONF',
    },
    {   name         => 'TT2Relative',  
        errmsg       => 'flag to enable relative filenames',
        args_how     => 'FLAG',
        req_override => 'RSRC_CONF | ACCESS_CONF',
    },
    {   name         => 'TT2Delimiter',
        errmsg       => 'alternative directory delimiter',
        args_how     => 'TAKE1',
        req_override => 'RSRC_CONF | ACCESS_CONF',
    },

    #-- service template options --
    {   name         => 'TT2PreProcess',
        errmsg       => 'template(s) to process before each main template',
        args_how     => 'ITERATE',
        req_override => 'RSRC_CONF | ACCESS_CONF',
    },
    {   name         => 'TT2PostProcess',
        errmsg       => 'template(s) to process after each main template',
        args_how     => 'ITERATE',
        req_override => 'RSRC_CONF | ACCESS_CONF',
    },
    {   name         => 'TT2Process',
        errmsg       => 'template(s) to process instead of each main template',
        args_how     => 'ITERATE',
        req_override => 'RSRC_CONF | ACCESS_CONF',
    },
    {   name         => 'TT2Wrapper',
        errmsg       => 'template(s) to wrap around each main template',
        args_how     => 'ITERATE',
        req_override => 'RSRC_CONF | ACCESS_CONF',
    },
    {   name         => 'TT2Default',
        errmsg       => 'default template to process when another template is not found',
        args_how     => 'TAKE1',
        req_override => 'RSRC_CONF | ACCESS_CONF',
    },
    {   name         => 'TT2Error',
        errmsg       => 'template to process when an uncaught error occurs',
        args_how     => 'TAKE1',
        req_override => 'RSRC_CONF | ACCESS_CONF',
    },
    {   name         => 'TT2Tolerant',
        errmsg       => 'flag to set error tolerance for providers',
        args_how     => 'FLAG',
        req_override => 'RSRC_CONF | ACCESS_CONF',
    },

    #-- variable options --
    {   name         => 'TT2Variable',
        errmsg       => 'define a template variable',
        args_how     => 'TAKE2',
        req_override => 'RSRC_CONF | ACCESS_CONF',
    },
    {   name         => 'TT2Constant',
        errmsg       => 'define a constant variable',
        args_how     => 'TAKE2',
        req_override => 'RSRC_CONF | ACCESS_CONF',
    },
    {   name         => 'TT2ConstantsNamespace',
        errmsg       => 'define variable namespace for constants',
        args_how     => 'TAKE1',
        req_override => 'RSRC_CONF | ACCESS_CONF',
    },

    #-- runtime template processing options --
    {   name         => 'TT2EvalPerl',
        errmsg       => 'flag to allow PERL blocks to be evaluated',
        args_how     => 'FLAG',
        req_override => 'RSRC_CONF | ACCESS_CONF',
    },
    {   name         => 'TT2LoadPerl',
        errmsg       => 'flag to allow regular Perl modules to be loaded as plugins',
        args_how     => 'FLAG',
        req_override => 'RSRC_CONF | ACCESS_CONF',
    },
    {   name         => 'TT2Recursion',
        errmsg       => 'flag to enable recursion into templates',
        args_how     => 'FLAG',
        req_override => 'RSRC_CONF | ACCESS_CONF',
    },

    #-- plugin and filter options --
    {   name         => 'TT2PluginBase',
        errmsg       => 'packages in which to locate for plugins',
        args_how     => 'ITERATE',
        req_override => 'RSRC_CONF | ACCESS_CONF',
    },

    #-- caching options --
    {   name         => 'TT2AutoReset',
        errmsg       => 'flag to reset (clear) any BLOCK definitions before processing',
        args_how     => 'TAKE1',
        req_override => 'RSRC_CONF | ACCESS_CONF',
    },
    {   name         => 'TT2CacheSize',
        errmsg       => 'integer limit to the number of compiled templates to cache in memory',
        args_how     => 'TAKE1',
        req_override => 'RSRC_CONF | ACCESS_CONF',
    },
    {   name         => 'TT2CompileExt',
        errmsg       => 'filename extension for caching compiled templates back to disk',
        args_how     => 'TAKE1',
        req_override => 'RSRC_CONF | ACCESS_CONF',
    },
    {   name         => 'TT2CompileDir',
        errmsg       => 'path to directory for caching compiled templates back to disk',
        args_how     => 'TAKE1',
        req_override => 'RSRC_CONF | ACCESS_CONF',
    },

    #-- misc options --
    {   name         => 'TT2Debug',
        errmsg       => 'flag to enable debugging',
        args_how     => 'FLAG',
        req_override => 'RSRC_CONF | ACCESS_CONF',
    },

    # -- service options --
    {   name         => 'TT2Headers',
        errmsg       => 'list of keywords indicating HTTP headers to add',
        args_how     => 'ITERATE',
        req_override => 'RSRC_CONF | ACCESS_CONF',
    },
    {   name         => 'TT2Params',
        errmsg       => 'list of keywords indicating parameters to add as template variables',
        args_how     => 'ITERATE',
        req_override => 'RSRC_CONF | ACCESS_CONF',
    },
    {   name         => 'TT2ServiceModule',
        errmsg       => 'name of class which implements template service module',
        args_how     => 'TAKE1',
        req_override => 'RSRC_CONF | ACCESS_CONF',
    },
);

command_table(\@directives);
    
WriteMakefile(
    'NAME'         => 'Apache::Template',
    'VERSION_FROM' => 'lib/Apache/Template.pm',
    'PMLIBDIRS'    => [ 'lib' ],
    'INC'          => Apache::src->new->inc,
    'PREREQ_PM'    => { 
        Template             => 2.10,
        Digest::MD5          => 2.09,
        Apache::Request      => 0,
        Apache::ModuleConfig => 0 
    },
);


