use strict;
use warnings;
use Test::More;
use Digest::Groestl qw(groestl_384 groestl_384_hex);

my $len = 0;

while (my $line = <DATA>) {
    chomp $line;
    my ($msg, $digest) = split '\|', $line, 2;
    my $data = pack 'H*', $msg;
    $digest = lc $digest;

    if ($len and not $len % 8) {
        my $md = Digest::Groestl->new(384)->add($data)->hexdigest;
        is($md, $digest, "new/add/hexdigest: $len bits of $msg");
        is(
            groestl_384_hex($data), $digest,
            "groestl_384_hex: $len bits of $msg"
        );
        ok(
            groestl_384($data) eq pack('H*', $digest),
            "groestl_384: $len bits of $msg"
        );
    }

    my $md = Digest::Groestl->new(384)->add_bits($data, $len)->hexdigest;
    is($md, $digest, "new/add_bits/hexdigest: $len bits of $msg");
}
continue { $len++ }

done_testing;

__DATA__
00|ac353c1095ace21439251007862d6c62f829ddbe6de4f78e68d310a9205a736d8b11d99bffe448f57a1cfa2934f044a5
00|1d50aef76b4f8d6eb8990161048163c61daaba5e86efd0a8d06db126e6e2dec46ec26361970f6e06d356de6b76c2b229
C0|06defe33a4aa21467ebe7aac57d0a7d4824485beb416c9f1882e4afee3ddffc7bb9ca5292524e98ac956d7c96844f32a
C0|94363191113efbcfbf55f2820c3faa905157c43133c892ae8c1aa584b2678665c1a1c9444e861507768ef75358382676
80|5ba53f07cb977c65df8c23ce943c0d8370d167701c102ba2dd191b9dbefb076cdedc06b6e07732daaff59de3fec76835
48|3ca9c7220e75d6e1f08bb2ff2ebe12c84d561ccec8d93578b299e3fac15a2a7c9e08cd5bd052bea434ed7a688b53b187
50|b4a0fe4e8a2837fa40d668e889ac714157ce165da34e7506bba88908b76b6e4ec54e9b5a7bfb45f58b150bf43150f26e
98|c79e8cad836786e798c9e2cbfd02ecdec04a65b556f1e0e23c53a7f6197da8c7105b89f29ce0385e7f7dd840cbd0034e
CC|180967815d83acfd0c771c2140f5eed93eb4b346fc7b88e73d1febb77c6e11ea7834e35ecfabe03083a520dacb76e7b7
9800|5e8da6db37acfc7beff268a985d6d296fea1e2da0ca6d0e908a7110de60b9d928911e9aa1986f8f39b2bd3e6601a2120
9D40|b423cee0f7ff118021aaeab1bd06918fa1ea26c91815b674e1e7121550a53d9d18dfe4b78ad1e52ad79e17ca5cc9dc4b
AA80|4d4a6f9e186e3585c38440f25b5c8f3aac06eed02378fc24db7a287de140504f0814a17e872b0e82100a89ea62e3fb2c
9830|7afcc722e85b497a5c42ee7ffdec373db65bf2fcd37e8f3992d24607b34a0d70a053a45cb9c6ccf10b2aa12a2b4bdee2
5030|2a38572247db5af0dade71e7154e7dd5d48dc4fbbfbe9d14e89078eb9dbd3aab175dff528bc52e8c1fec9704227d1e1b
4D24|8acc166ade9fc5f14cab54c776e662f1b4d58c60c84a5af2cadd28c7b4b68d0e1e0fab1e9d1b33f448424d2d603870cd
CBDE|fbb418193d7affaf0963470d110b95048c887eb0a04c5dc50b7780076efd11ccf83c141e7c5f893f5b6ab9f70b425973
41FB|0d997470158f646947c3105eafeb0a34d09d007becb83ebfc1fef41233eb92f6fd9225381f3939475669505b12bb724e
4FF400|02ba10db31e5cb22dde9fe42e8ea75bdaa1e48fe9a5f70f932b4daeab0eac2ec5c130e19d8409c2dab32be080c3ec7ff
FD0440|8e134126dda2ac4a4af01f455cb3017f458875ecf53e1b6bd4b82fc1df5e1514f959579fbe37107c81f637af80a52791
424D00|b1766f2107fed98c60b9f3da63157106c0acefe63db1e225f7d04e19533713cb59cfe4fa908ee570bcef16316d6f2a06
3FDEE0|263a899c929ea3e16a29b877c1de7ff0d32296968ebcad8edc5829c7fb784181608775e9851359d40aa8add63b660401
335768|2b54e44dbc5cae7bd25feadd44bc809a5eca1761e815469b4792bb15b7b5003f1a65e92e2af031a05109c3f8a12aea5c
051E7C|8f0f7174a2b04044bde2ed9767e3645fae8bf4b9ba47a40ab193b0cfd766099cc794ced368872e0b8bde85f05a1c3754
717F8C|8194040a71652e359610dbcdf504549b96bcd55fe97b3be1402d3446e80b853cc8f964887ef16c635595aad7ce671d8c
1F877C|cfbc8c4b1c59e39e8ffacb28d81ec520e9a65466737a88a19c62bb442cfde76879d9575404a3bb86cd2ad867d765c3de
EB35CF80|88df7bec601e0c60f0d1d134e7d5f9f3359ce9fa7be68aea0c2cc26b47bb8bfbd4af681f7f8e29fafeaebe737cffc51c
B406C480|f37a680db4939b857ce2673862eae7378abcb1732fdad9c6b890637881956bc8d31ce4c1bde96a654ee9d271e89a78ac
CEE88040|877d35bff2be652f2bd70d0bbd41b2649a7efe7c2c750e774318f51939f8888cd6e60bef075aec109a1bc24be7e8a459
C584DB70|551cc6d6de86b4fcf7a760cc202b9f771ddd024abd175b5c9cbf385f030e123e58990a6f9cc2b1379490afe8c9f5c97e
53587BC8|a7467e4d0208136fa302acbf07aac91447bd85c74cfb6ef8e7a584b079a121fe26ce82bb442a88e8ef9ec4d86b0d5d82
69A305B0|8dad5805b78ebaa47c96be85c0511311c46bf22005f611b6adbf66804ae387de6623e8cf9f3e871a5df30cc46939bbc6
C9375ECE|b9376571a8d613b5eb2a4f1b9ef8ec14bc0c0f042770ddcf19d9cf162216abcb3d32d3ca30f449f0d9bc39b4503690ad
C1ECFDFC|5e67844ddb8626edecf9c40d826904058c126dc221a7136977600fdc3f0f2b0f1da9daaab54ed2687017955aadc60086
8D73E8A280|c3e2a82525a1ac79aeb0bffad8cf47a7f3e65a94c2004f61b18c3a64405549b0f2b130eef6a5b11c7c2a3eb344a89273
06F2522080|95b89fcec4e86497ad42102726766bbb74b09e834662d443606e5356ac27357804db4378b1918b71a26e9a16f9766d73
3EF6C36F20|dc2cab558cd9c7a75c46ea7ead9265cf7b91238a2cbfb5322b173ec8dbf47b5554ca00005cebaf969218c98d8651820a
0127A1D340|e9683c8c6a12b4d1be4cf5be22f4f31596c7b6adbee19eb4f19e51129d3a72bd9da8604d020111074ceb454f6abe36b4
6A6AB6C210|987088f5907f69a733049dd5c4151c092b5b475e4fcc95206759f056916790188e95f64dd650723c606e839cf7d89fbf
AF3175E160|2a999eb3a1a74b8cf1e9f92dfd42608ca935240f6f745213030831fc4c18650e5f0b15bd9313040474446fad24538b83
B66609ED86|e3e77f0a9c1f3a7e07310daca3af9ea8652321de33b62d46dcc17bd604f052558914bdc76bf2328cee5e82774fa13132
21F134AC57|0b4ef95bde916910c738750330c0dd99587cb4569847a38187d14b83664aaa892615720b9cecaa28518115db54504df6
3DC2AADFFC80|8a7f28dec35807b32c08cf27b33ca2da7fed0b47644a3112777b8deb64f313b58558dd69ff9ead823183ba483d421de5
9202736D2240|aaa26ca02396820d30c60d62ce3659a95710563fdbc1838b3c1b989366ac022b81370f79833276cd6f6d7b28f122c273
F219BD629820|e55a972a2927df1844d17685158b7eb0384c255946b375352bf36c4eba7cdfb031d1f816670de5183f147dbd643fe72f
F3511EE2C4B0|feba38f12d117a4a2a1c429b4a65d43560fc84b93c90e3aaa9a091cd8a5ba65fd482a0db646ffc03af2569e05ffe8237
3ECAB6BF7720|1e78652e1b8606b6dc4dfcef45d6b2e49e6bdf191ad69f9a787c1f696a7a142446d4f036fb3a2aaa6a4463232a8bc875
CD62F688F498|1fee3a7a29cde852ae8f6087bab57d57cb3467ee3a3f70ae357186e84cd8f06adb23325932f5353c25ca4dd4742ac997
C2CBAA33A9F8|6c9dcf1f0417f0f8da60e1ae57386ff8ff2a57b3ba96e07943b2a9c5a8d1db4659428113a7477a5038382339ae358a91
C6F50BB74E29|3e3197ba9eca972f90ea2c04ff35b8410d96a949ebe4847fff070497a20281b4aab2bbe23df5381cb1bba90bd67c627c
79F1B4CCC62A00|38f3cf4e162c2ba8411333954f87f1f33b3c08d62050c2a4ee81c8a096c82164059151f4940dc1ad48dedc4e81684987
