#include "template-hsc.h"
#line 48 "DynamicLinker.hsc"
#include "HsUnix.h"

int main (int argc, char *argv [])
{
#if __GLASGOW_HASKELL__ && __GLASGOW_HASKELL__ < 409
    printf ("{-# OPTIONS -optc-D__GLASGOW_HASKELL__=%d #-}\n", 603);
#endif
    printf ("{-# OPTIONS %s #-}\n", "-#include \"HsUnix.h\"");
    hsc_line (1, "DynamicLinker.hsc");
    fputs ("-----------------------------------------------------------------------------\n"
           "", stdout);
    hsc_line (2, "DynamicLinker.hsc");
    fputs ("-- |\n"
           "-- Module      :  System.Posix.DynamicLinker\n"
           "-- Copyright   :  (c) Volker Stolz <vs@foldr.org> 2003\n"
           "-- License     :  BSD-style (see the file libraries/base/LICENSE)\n"
           "-- \n"
           "-- Maintainer  :  vs@foldr.org\n"
           "-- Stability   :  provisional\n"
           "-- Portability :  non-portable (requires POSIX)\n"
           "--\n"
           "-- Dynamic linker support through dlopen()\n"
           "-----------------------------------------------------------------------------\n"
           "\n"
           "module System.Posix.DynamicLinker (\n"
           "\n"
           "    module System.Posix.DynamicLinker.Prim,\n"
           "    dlopen,\n"
           "    dlsym,\n"
           "    dlerror,\n"
           "    dlclose,\n"
           "    withDL, withDL_,\n"
           "    undl,\n"
           "    )\n"
           "\n"
           "--  Usage:\n"
           "--  ******\n"
           "--  \n"
           "--  Let\'s assume you want to open a local shared library \\\'foo\\\' (.\\/libfoo.so)\n"
           "--  offering a function\n"
           "--    @char \\* mogrify (char\\*,int)@\n"
           "--  and invoke @str = mogrify(\"test\",1)@:\n"
           "-- \n"
           "--  \n"
           "--  type Fun = CString -> Int -> IO CString\n"
           "--  foreign import dynamic unsafe fun__ :: FunPtr Fun -> Fun\n"
           "-- \n"
           "--  withDL \"libfoo.so\" [RTLD_NOW] \\$ \\\\ mod -> do\n"
           "--     funptr <- dlsym mod \"mogrify\"\n"
           "--     let fun = fun__ funptr\n"
           "--     withCString \"test\" \\$ \\\\ str -> do\n"
           "--       strptr <- fun str 1\n"
           "--       strstr <- peekCString strptr\n"
           "--       ...\n"
           "--  \n"
           "\n"
           "where\n"
           "\n"
           "", stdout);
    fputs ("\n"
           "", stdout);
    hsc_line (49, "DynamicLinker.hsc");
    fputs ("\n"
           "import System.Posix.DynamicLinker.Prim\n"
           "import Control.Exception\t( bracket )\n"
           "import Control.Monad\t( liftM )\n"
           "import Foreign.Ptr\t( Ptr, nullPtr, FunPtr, nullFunPtr )\n"
           "import Foreign.C.String\t( withCString, peekCString )\n"
           "\n"
           "dlopen :: String -> [RTLDFlags] -> IO DL\n"
           "dlopen path flags = do\n"
           "  withCString path $ \\ p -> do\n"
           "    liftM DLHandle $ throwDLErrorIf \"dlopen\" (== nullPtr) $ c_dlopen p (packRTLDFlags flags)\n"
           "\n"
           "dlclose :: DL -> IO ()\n"
           "dlclose (DLHandle h) = throwDLErrorIf_ \"dlclose\" (== 0) $ c_dlclose h\n"
           "dlclose h = error $ \"dlclose: invalid argument\" ++ (show h)\n"
           "\n"
           "dlerror :: IO String\n"
           "dlerror = c_dlerror >>= peekCString \n"
           "\n"
           "-- |\'dlsym\' returns the address binding of the symbol described in @symbol@,\n"
           "-- as it occurs in the shared object identified by @source@.\n"
           "\n"
           "dlsym :: DL -> String -> IO (FunPtr a)\n"
           "dlsym source symbol = do\n"
           "  withCString symbol $ \\ s -> do\n"
           "    throwDLErrorIf \"dlsym\" (== nullFunPtr) $ c_dlsym (packDL source) s\n"
           "\n"
           "withDL :: String -> [RTLDFlags] -> (DL -> IO a) -> IO a\n"
           "withDL mod flags f = bracket (dlopen mod flags) (dlclose) f\n"
           "\n"
           "withDL_ :: String -> [RTLDFlags] -> (DL -> IO a) -> IO ()\n"
           "withDL_ mod flags f = withDL mod flags f >> return ()\n"
           "\n"
           "-- |\'undl\' obtains the raw handle. You mustn\'t do something like\n"
           "-- @withDL mod flags $ liftM undl >>= \\ p -> use p@\n"
           "\n"
           "undl :: DL -> Ptr ()\n"
           "undl = packDL\n"
           "\n"
           "throwDLErrorIf :: String -> (a -> Bool) -> IO a -> IO a\n"
           "throwDLErrorIf s p f = do\n"
           "  r <- f\n"
           "  if (p r)\n"
           "    then dlerror >>= \\ err -> ioError (userError ( s ++ \": \" ++ err))\n"
           "    else return r\n"
           "\n"
           "throwDLErrorIf_ s p f = throwDLErrorIf s p f >> return ()\n"
           "", stdout);
    return 0;
}
