# Generated by default/object.tt
package Paws::Rekognition::ShotSegment;
  use Moose;
  has Confidence => (is => 'ro', isa => 'Num');
  has Index => (is => 'ro', isa => 'Int');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Rekognition::ShotSegment

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Rekognition::ShotSegment object:

  $service_obj->Method(Att1 => { Confidence => $value, ..., Index => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Rekognition::ShotSegment object:

  $result = $service_obj->Method(...);
  $result->Att1->Confidence

=head1 DESCRIPTION

Information about a shot detection segment detected in a video. For
more information, see SegmentDetection.

=head1 ATTRIBUTES


=head2 Confidence => Num

The confidence that Amazon Rekognition Video has in the accuracy of the
detected segment.


=head2 Index => Int

An Identifier for a shot detection segment detected in a video.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Rekognition>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

