/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ling;

import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.ling.LabelFactory;
import edu.stanford.nlp.ling.TaggedWordFactory;
import edu.stanford.nlp.ling.Word;

public class LabeledWord
extends Word {
    private Label tag;
    private static String divider = "/";
    private static final long serialVersionUID = -7252006452127051085L;

    public LabeledWord() {
    }

    public LabeledWord(String word) {
        super(word);
    }

    public LabeledWord(String word, Label tag) {
        super(word);
        this.tag = tag;
    }

    public LabeledWord(Label word, Label tag) {
        super(word);
        this.tag = tag;
    }

    public Label tag() {
        return this.tag;
    }

    public void setTag(Label tag) {
        this.tag = tag;
    }

    public String toString() {
        return this.word() + divider + this.tag;
    }

    public static void setDivider(String divider) {
        LabeledWord.divider = divider;
    }

    public LabelFactory labelFactory() {
        return LabelFactoryHolder.lf;
    }

    public static LabelFactory factory() {
        return LabelFactoryHolder.lf;
    }

    private static class LabelFactoryHolder {
        private static final LabelFactory lf = new TaggedWordFactory();

        private LabelFactoryHolder() {
        }
    }
}

