# Generated by default/object.tt
package Paws::GlueDataBrew::FormatOptions;
  use Moose;
  has Csv => (is => 'ro', isa => 'Paws::GlueDataBrew::CsvOptions');
  has Excel => (is => 'ro', isa => 'Paws::GlueDataBrew::ExcelOptions');
  has Json => (is => 'ro', isa => 'Paws::GlueDataBrew::JsonOptions');

1;

### main pod documentation begin ###

=head1 NAME

Paws::GlueDataBrew::FormatOptions

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::GlueDataBrew::FormatOptions object:

  $service_obj->Method(Att1 => { Csv => $value, ..., Json => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::GlueDataBrew::FormatOptions object:

  $result = $service_obj->Method(...);
  $result->Att1->Csv

=head1 DESCRIPTION

Represents a set of options that define the structure of either
comma-separated value (CSV), Excel, or JSON input.

=head1 ATTRIBUTES


=head2 Csv => L<Paws::GlueDataBrew::CsvOptions>

Options that define how CSV input is to be interpreted by DataBrew.


=head2 Excel => L<Paws::GlueDataBrew::ExcelOptions>

Options that define how Excel input is to be interpreted by DataBrew.


=head2 Json => L<Paws::GlueDataBrew::JsonOptions>

Options that define how JSON input is to be interpreted by DataBrew.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::GlueDataBrew>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

