# Generated by default/object.tt
package Paws::Kinesis::StartingPosition;
  use Moose;
  has SequenceNumber => (is => 'ro', isa => 'Str');
  has Timestamp => (is => 'ro', isa => 'Str');
  has Type => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Kinesis::StartingPosition

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Kinesis::StartingPosition object:

  $service_obj->Method(Att1 => { SequenceNumber => $value, ..., Type => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Kinesis::StartingPosition object:

  $result = $service_obj->Method(...);
  $result->Att1->SequenceNumber

=head1 DESCRIPTION

This class has no description

=head1 ATTRIBUTES


=head2 SequenceNumber => Str

The sequence number of the data record in the shard from which to start
streaming. To specify a sequence number, set C<StartingPosition> to
C<AT_SEQUENCE_NUMBER> or C<AFTER_SEQUENCE_NUMBER>.


=head2 Timestamp => Str

The time stamp of the data record from which to start reading. To
specify a time stamp, set C<StartingPosition> to C<Type AT_TIMESTAMP>.
A time stamp is the Unix epoch date with precision in milliseconds. For
example, C<2016-04-04T19:58:46.480-00:00> or C<1459799926.480>. If a
record with this exact time stamp does not exist, records will be
streamed from the next (later) record. If the time stamp is older than
the current trim horizon, records will be streamed from the oldest
untrimmed data record (C<TRIM_HORIZON>).


=head2 B<REQUIRED> Type => Str

You can set the starting position to one of the following values:

C<AT_SEQUENCE_NUMBER>: Start streaming from the position denoted by the
sequence number specified in the C<SequenceNumber> field.

C<AFTER_SEQUENCE_NUMBER>: Start streaming right after the position
denoted by the sequence number specified in the C<SequenceNumber>
field.

C<AT_TIMESTAMP>: Start streaming from the position denoted by the time
stamp specified in the C<Timestamp> field.

C<TRIM_HORIZON>: Start streaming at the last untrimmed record in the
shard, which is the oldest data record in the shard.

C<LATEST>: Start streaming just after the most recent record in the
shard, so that you always read the most recent data in the shard.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Kinesis>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

