## no critic: TestingAndDebugging::RequireStrict
package Sah::SchemaR::language::code;

our $DATE = '2023-08-07'; # DATE
our $VERSION = '0.005'; # VERSION

our $rschema = do{my$var={base=>"str",clsets_after_base=>[{description=>"\nAccept only current (not retired) codes. Alpha-2 or alpha-3 codes are accepted.\n\n",examples=>[{valid=>0,value=>""},{summary=>"Indonesian (2 letter)",valid=>1,value=>"id"},{summary=>"Indonesian (3 letter)",valid=>1,validated_value=>"ind",value=>"IND"},{summary=>"Unknown language code",valid=>0,value=>"qqq"}],in=>["km","nn","vo","fa","rm","en","aa","oc","mr","ab","tn","lu","oj","cy","sv","lt","sl","tr","lb","la","jv","ps","nr","pi","bm","dv","mn","or","af","ny","ff","ht","ie","tk","ty","ha","cr","su","av","lv","ja","st","id","bh","da","be","my","vi","sa","mk","gd","hu","qu","pl","nd","sw","mh","fo","si","zh","ss","ee","sg","ne","lo","kk","ky","ik","th","te","hi","bn","ch","ce","pt","ho","kr","kj","li","pa","gn","lg","as","so","fi","rn","om","br","ug","kn","ms","ku","ng","iu","mi","se","sh","ru","de","ba","tg","gu","ts","sq","co","ti","am","ia","he","ka","tw","it","os","es","ga","sd","mg","eo","no","to","wa","cs","sm","gv","gl","ae","kl","kv","nv","el","hz","bo","nl","sr","ay","cu","tl","ak","fy","yo","xh","sc","sn","dz","ko","io","ml","hr","ca","ro","uk","bg","ks","ii","ur","ki","rw","is","et","zu","hy","wo","nb","ta","kw","tt","az","na","an","ve","ln","fr","za","ar","yi","sk","cv","eu","mt","kg","bs","fj","bi","ig","uz","itb","loj","kjm","bis","rir","vmz","mun","dks","bgv","anr","zrp","cax","mlg","cui","gwr","kro","skv","cat","ach","tkw","kek","kwc","aup","kwh","bin","nuv","mtv","xyl","sxe","mli","yly","nyw","mus","ilb","aeb","yua","ukh","bgi","skg","mnw","nat","tuz","bwg","mtg","brj","cuv","nug","pes","cts","sea","ski","bgg","til","bcd","ctn","mpd","paf","nui","kmw","wwr","mlv","aeu","mti","ilu","bwi","yty","ipk","nax","prl","itz","vmb","ymd","auj","pkr","ylr","pom","aqr","cpe","rga","zcd","xak","tep","ulm","ogg","rwa","owi","dnu","gia","hmv","lop","cco","vmu","igl","any","xdy","aez","zin","mqw","esh","szy","tub","jbj","nco","mox","hmg","der","dza","rmo","tsh","tsc","syb","wgy","brp","fie","mot","tuu","hmi","aya","oin","xun","tbm","bki","sgg","irr","jos","wkr","bea","bzr","dii","ugh","uro","rof","wom","tmh","xlg","swi","tmc","dig","sgi","bkg","cnl","myl","xtv","swg","xli","nok","nfd","byz","adw","ofo","nnl","tra","dgs","fal","bkv","ysd","div","zyb","kkh","kkc","tpx","sin","var","era","tww","cfd","kzx","cok","kiq","bxe","xtg","pia","swv","xpd","gzi","sis","mdr","tgw","dgn","oyb","xti","dws","mxo","kfp","gom","thr","tpt","gbd","srp","bfo","okv","cjn","eve","abt","mak","cda","gaf","yaq","mji","tve","ldo","mfe","klm","wky","bzy","jav","iry","kuf","mjg","ges","zkv","ksw","cjs","byb","abx","nql","mvk","mdy","hrk","tae","kfj","oki","gvf","wes","rka","rei","jut","phw","lbs","njs","yrb","thy","zkg","mjv","ydg","okg","njn","wen","led","lbn","ktm","pwr","apm","zea","wrl","ikl","ram","nda","vay","waf","reg","tod","kfy","ssq","lwm","mdj","mwu","btu","mxx","iin","mgb","ksn","nib","tce","kzo","epo","nmm","khk","mgu","tpo","nbc","lgm","vaj","nbh","niu","gew","mxt","hml","mwb","kss","mck","ahb","bpk","pxm","cmm","gcf","xkb","zmq","knf","wew","cbc","lbw","urt","igg","srr","sha","kym","cib","bzj","dae","urx","omq","kde","mmf","phn","xku","otz","lif","que","owl","blb","luq","bgl","tig","adn","sju","opk","mgz","jie","jow","niz","vap","olu","pdu","zzj","juo","prg","aja","dbm","thp","bmq","tii","xoo","hum","kfr","zpk","ads","pri","mtl","bwl","zlu","nul","gkp","mdp","dmc","sjb","mwz","btz","bft","sbf","umn","abo","xkz","dgw","xns","otu","kqf","tgn","cul","dhr","bzp","sad","ase","twn","dra","tgs","soe","tiv","siw","ums","bfx","sry","otb","ztu","mll","xnn","eiv","dww","blz","dep","xgb","enu","okl","nao","bha","ytp","lva","tnu","ojb","wrg","wdu","grv","rel","ame","slu","spk","ovd","jal","nqg","tnb","xxt","uss","izr","wri","enb","iki","xgu","brr","ala","gdb","mkb","mqs","hih","hbu","auy","duu","zad","aqp","nvo","fon","mjl","yyr","krt","pkp","laa","stb","gri","bjz","ory","lor","ude","stu","xmf","krx","ybk","fos","bsq","cao","eza","ppq","mbq","kpa","anj","dub","grg","mqn","hbb","ikv","ter","ziw","tza","ata","wrv","gdu","mku","gwj","lkm","dsh","nyn","ghn","csm","fai","biw","boe","nni","rmt","clw","llh","bry","llc","tqu","slz","tkn","nct","nng","rmx","pcf","moo","fag","bbf","tnz","msf","ncx","tqb","tks","fut","ghs","nys","qvz","jbr","ntw","yna","szp","bad","myv","xtl","smq","mkz","wsk","mns","dil","bkl","kmn","anp","nnv","cng","loy","swl","myg","lth","tey","lre","ltc","bjb","bju","cni","nxk","nsm","aur","bvd","orr","mnn","duz","aac","zha","aah","nlw","hsl","rhg","kms","seu","huk","etr","pao","ysc","yub","aea","ila","ttr","aki","jrt","zpm","kkd","bdw","ayz","jpa","opm","xph","xpc","akg","kvl","wul","seb","dyr","axe","mzw","typ","tmd","kby","xhv","xmt","inj","akv","gul","ita","tlr","obt","sch","unx","nkp","zbt","dtp","xmx","krf","snr","kal","giz","jmn","khm","sya","nmk","fuf","pni","pyn","tua","wib","bbt","dyy","afo","yuz","lgk","kxs","ayu","bbx","ayb","rmf","kxn","png","ncf","wmm","msx","toc","yil","toh","ptw","wbh","wiu","lec","tty","jms","leh","sez","pys","pnv","sny","lsp","gmm","xrn","kyk","dna","yej","giu","gbh","new","xel","vma","psm","nkj","inp","bpm","mcm","gib","sqr","suj","plw","tly","rgu","tyj","kbr","wyn","yae","pib","tdi","hov","lmp","chn","gsm","wni","bnr","mxf","agv","mip","ngp","mhi","glw","trb","pmm","ndz","wng","tru","awv","bqy","tdg","ain","csk","bup","kcv","fro","uvl","mhg","mph","bcc","mpc","bch","wtw","rnn","pbc","mfq","djj","pbh","piu","lit","gng","tdv","hoi","arj","nsk","nxm","awg","cdz","knx","taq","agi","mmt","kcg","beb","uby","kwd","knt","gyn","ihb","awi","beu","nhn","roo","mmx","gni","urf","lix","kci","acd","wlw","agg","gct","piz","wao","bqr","rkb","spm","yra","tsd","yww","ids","crv","nrg","hlt","buj","ndu","han","trz","bny","ndb","ygw","has","mij","ngj","lmj","gvo","nri","ise","kie","mrn","onr","bxq","kow","sbx","hvn","zch","ybm","kuo","qxr","ymh","vko","mel","kqx","cri","ymc","bez","bya","ibo","gao","htx","xcm","kqt","gqi","och","mrs","ubr","bff","sbt","crg","arp","shu","ulk","qxp","lio","hid","mmo","xka","jiq","lue","zac","aha","gpe","zah","onp","haw","oac","yiv","arr","bla","tjp","kno","ywn","ygs","xam","cia","shb","pok","bme","xeg","ajz","tpf","pnl","kos","yig","mga","bqp","nwy","nia","buy","djr","kzf","hyx","qwm","yii","ngy","mwa","bta","miy","bnj","soq","mrw","asq","kon","lmy","txc","txh","frt","tcq","kem","rnw","dru","ary","ddg","kag","aoe","aiw","gui","sse","kut","tjj","gax","hto","vkt","kai","aad","ddi","onj","zuy","kux","gat","kjk","kqo","ota","wuv","kvv","chw","lhh","abf","gug","shz","drb","bvh","sbo","bvc","run","wln","lld","mir","sds","wat","ngr","zme","lmr","bnp","akl","zla","xso","nhw","kvg","quq","kav","sja","bah","bac","bqj","ola","pda","daq","avd","wls","kvi","bur","rus","kdq","nwr","ypo","xbe","wax","sdn","aju","gjn","lab","sta","ich","cbd","klk","cen","snj","ptn","doh","doc","kpu","obo","lsr","caf","kxw","boq","fss","dty","xmo","mei","atu","mka","gda","crl","yey","atb","hba","kbp","dua","tyy","kpb","lau","tlj","suy","mam","jmw","sla","cky","ktk","pln","pug","ykn","nes","rji","rak","sme","xga","mev","alu","bhb","apk","alb","ena","jek","nbd","hrm","bhu","nen","lvu","qva","xwa","xiy","tna","xrw","uon","nrl","pax","ttj","naf","pls","rjg","azj","pui","bja","tlp","laz","nkr","nzi","hol","sac","sqj","sah","sur","bdn","tyr","kbj","agl","atz","gnl","ohu","bds","tbk","zhb","yer","snp","kpz","lfn","wok","amq","dtr","lsy","ebk","kcl","ttp","xir","iff","tdl","hke","mzs","mso","mhl","vgt","gok","svc","ynu","bbo","bhz","iya","aft","alz","zoq","ckr","dmd","ppe","mbe","com","mzn","bse","nbn","ned","ibb","jbk","gab","kuu","vku","bnm","drt","nqq","lda","byf","pld","cdo","bfa","kub","nbs","bsv","spy","gau","mbv","ksh","pmr","ksc","ibu","ndo","kep","hea","yal","xaj","grq","xcy","nxr","phh","auk","cbs","bsg","wau","cze","wab","cbn","uve","bsi","wsr","ppi","yby","mbi","kil","emw","gaz","brk","rob","dmn","sht","smv","pmy","mee","bqm","tmw","spr","jyy","mzd","nnq","shx","lnl","ura","kuz","adh","rou","vkz","beo","dms","osi","kkw","mxa","tek","xnh","twc","smi","lok","twh","jna","tjm","tgh","pio","waz","tgc","ero","cnq","umc","xap","pue","kej","xcr","bdd","smg","tro","zpr","uuu","axl","zmv","azm","ttm","ssi","rwo","vmf","aoi","gue","lpe","kod","kfk","dym","kae","dde","cop","ush","zhx","khy","aog","ssg","oht","omv","fly","mqh","mqc","maj","iml","ayo","tlm","zmi","dsn","tuf","afu","ssv","omg","psy","elm","tsw","xbg","mcy","nop","bpy","dzo","rma","zmg","nca","paz","snm","hin","afb","xbi","gmy","kve","omi","coj","att","kgw","flr","lui","avn","opy","lls","khr","lax","bmg","kpt","prq","avs","lln","hrp","kra","lat","zpy","kpx","acw","mvp","ghc","ghh","bmi","nyh","nyc","tzx","kww","tiq","atx","lug","aan","gld","rpn","mnc","mnh","bhx","ukw","alt","luv","ium","gmr","pau","lts","seo","ltn","kbm","noj","pab","srk","bpr","mcr","sqm","aas","afz","bht","bmv","alx","map","psr","kmh","kmc","bbu","bih","nhd","yno","gyd","kwn","kgs","kiv","msu","ayt","ifa","lsm","swq","acn","bkq","diq","moa","clc","sml","clh","mar","acs","psp","mcp","noy","bpp","inm","nre","msb","kws","kgn","bbb","muh","muc","pcb","uks","khp","git","unz","bjf","lng","kii","zsl","isi","aid","tfr","yon","jjr","peh","ctc","cre","rnd","cth","zpj","xtq","isg","lyn","kig","lni","chd","nlc","mvr","gix","pgk","xmz","aaw","jdg","alo","yux","slf","wne","nor","yai","jru","tde","mjq","may","set","mcj","mhe","bpj","ffm","nkm","xgf","mrd","enf","dtm","yag","msz","mbl","yut","ppl","bzk","irk","jrb","bsl","bho","naa","ato","idd","xmu","tzo","stf","hiw","thk","yav","obu","ess","hoe","caa","mdk","kpo","zpp","age","mvy","gdf","mkf","tss","lao","dlm","gne","cor","tsn","awe","duf","zbu","ckm","xmb","esn","kce","had","khj","jaq","unu","xsu","rzh","uiv","hlu","ndt","cuq","ems","pne","zum","ypb","tms","rkt","oum","jua","aqk","xar","mlq","tmn","dmw","key","xsb","emn","arm","ndx","ugn","hlb","djm","dgc","dgh","htu","knz","kqb","spp","kks","sbb","dro","lul","bgq","pmj","sih","nuq","sbu","mtq","bwq","uig","dek","liz","skq","mmz","kqu","bml","kkn","aba","vun","trx","xay","pqe","imi","zml","tpa","nif","ake","mgf","ycl","ker","kza","xhe","ypz","vot","ggk","pix","mwf","ank","btf","ert","xrd","pit","gec","oml","geh","ybj","trt","ljw","cjh","nbw","bex","knb","mmu","kqz","kxd","gsp","wec","liu","ngm","cbw","lbc","weh","xkf","mim","aol","njh","sho","xdk","sbz","ssl","blf","hmq","axg","nwm","jmd","bum","lib","mmb","knu","bet","pdt","ijo","wor","nne","boi","jks","gva","dtk","meq","ebr","mxz","kly","sjt","zas","bzm","bxl","olt","tbr","lrv","heb","kyj","suk","bog","nkk","yro","fod","waa","ndf","apy","ldb","bov","ray","vam","txn","dlk","koc","koh","bfu","cdf","kty","nmj","ztx","byo","gaa","lri","iba","ott","gor","thm","ztt","dbp","kua","bfb","hup","vka","otx","puq","urz","lrg","mye","rbl","hch","mdm","txs","lhn","trf","amg","bvn","tal","glh","glc","mxb","mnd","mwt","btt","nix","pif","ofu","hya","mgt","btx","kyp","nit","mxu","woy","ami","lxm","lzl","kmd","tby","wth","ike","bcw","mpw","lhs","klr","bef","udg","xzh","sdh","goy","uru","sdc","ozm","jer","roa","xkx","gre","huj","blt","tvl","ban","dbj","xkt","oog","mfl","blx","nyd","aht","udi","amv","bas","bfz","rar","pwm","apr","nmp","urb","wlh","wlc","ruc","ruh","rsb","tkd","lkj","jii","rmu","gwm","tqt","phd","ncu","anm","sfb","dos","vwa","wif","cgk","uly","fub","iyx","kjr","rim","fuu","poy","sov","tow","asv","jig","nsp","afa","tuo","ncb","pre","rmb","don","pth","lew","syo","wbw","bjx","jiv","csp","asg","buk","lcf","sog","neh","nec","gbw","soi","lmk","ykh","dno","asi","ksd","bjt","yiq","xdm","plc","plh","mik","sxl","ngk","krz","tnt","twd","slx","guq","yuf","aqm","wdt","sas","ylm","por","tci","ark","xxb","xnd","xwt","dav","ilo","umd","enx","sef","bdc","fil","bdh","quv","tnx","kjy","slt","kaq","ncz","tgd","paa","san","rmz","xpw","npl","tcg","kru","dem","kdg","dag","mzc","mzh","scw","svs","dut","mkx","gdx","qug","ito","dai","add","kvq","kdi","dux","mkt","gdt","djk","qui","stt","utr","ige","csj","krb","mfg","tav","saw","xpn","caz","mhq","tdq","tvi","mje","dgd","yss","vmx","dnt","ysn","izm","ixl","udl","brm","mfi","utp","xps","sid","csy","bjo","bqk","tai","agq","syx","yde","oke","tux","tqo","znk","jod","pop","ifb","ree","nsy","scs","bba","kcq","lkr","jae","pca","naz","tem","xud","aml","iyo","scn","mfv","tag","ifu","onk","mou","tut","kjj","lom","gnq","len","wed","njd","vrs","dow","cab","lrl","duo","zba","bxv","swe","hbo","ton","csr","itx","kxc","laf","una","kxh","sge","vel","mko","gdo","xma","kpf","jbm","itt","tos","cau","fer","les","jmc","wbs","xle","sto","bnk","bhf","moz","kjp","crq","bol","tno","lky","uzb","bxi","qvo","xwo","gbs","eno","hdn","nau","ian","fnb","ged","gbn","nab","jpx","jra","orm","hds","nsr","aum","slo","bxg","xte","alf","pze","goj","sba","pbn","akq","ped","oge","ctd","bcn","mpn","byt","dby","oto","kqa","huy","cpi","aic","aih","abu","ktp","byx","abb","lgr","kdl","hnj","dal","rap","cpg","app","nmr","bvw","bcs","mps","pbs","chh","chc","qul","srm","kzz","juu","ypa","pdo","kbk","cld","nhh","bid","nhc","olo","tpz","cmr","sjo","sqk","tcl","npg","klp","ntd","baw","xsa","hla","mud","npi","jub","hme","tbj","kyr","raj","apj","kna","zaw","idc","pnq","ktj","nmy","blo","sxg","aho","abz","asl","xko","hac","ttk","mma","hah","sol","lia","mle","kfm","hur","dbr","gop","kzb","tbp","bge","dhm","jil","kyy","yms","klj","snk","mwo","bto","ymn","tlk","ske","mgo","nio","tpu","wca","mrc","mte","bwe","mrh","kzu","elk","hvc","nue","kwv","dml","hve","siq","nuh","ify","nuc","mre","mtc","bwc","nsb","bwh","yxl","mth","lyg","isn","kin","skc","moy","bek","skh","acv","yoi","nar","lns","ukg","rmp","noa","tdd","bro","lnn","wnd","uki","nsu","kgv","yog","mhd","kis","bjm","bgc","erk","kwi","awd","ant","mlc","mlh","coa","tqm","hhy","bmw","gwt","gnd","kcd","hae","trk","aci","rit","kgg","csu","krj","csb","teo","hod","luw","cuh","cuc","ide","kwg","ukv","agd","car","kgi","anx","ggt","loo","ccp","gwx","tsg","hmc","omw","fuj","maa","hmh","nsz","nbl","ljl","xbw","esg","dum","lkb","gdm","mkm","lku","ncj","jbo","nhe","tsi","gye","lbq","nay","stm","zmw","mor","esi","aqt","ccj","che","tnm","zgh","yan","geq","mva","zro","qvm","enm","krp","cay","pkt","hra","xgm","hhr","aie","nkf","csz","cbl","ssw","ndk","oro","tsv","crd","ogc","hgw","auo","slm","efa","yas","pzh","xtc","kyz","xre","mdx","xth","mxj","nlq","kkg","otm","jnj","avl","tpr","smw","lll","juy","ztm","tht","tmv","mdt","xhd","uis","akd","peq","vls","djf","kki","kea","kzr","xlc","dbb","sro","tmg","pye","hsh","nmz","hub","aal","bfp","bzt","dpp","emg","olm","yuk","lgz","sgc","sgh","sjm","muq","bzx","irx","biq","ldp","swh","tmi","zlm","swc","urj","huu","sek","bkh","aby","bkc","dic","dbu","dih","kkv","emi","kyb","cim","mbw","jur","tpy","zkh","rgk","xaa","bsw","kzy","buf","jah","jac","blm","ahm","pnd","mif","ngf","kfo","lmf","mxp","xor","kyu","rwk","okc","okh","wik","dsl","dho","nmb","huz","imn","pfl","lgb","urp","abr","qwa","lwu","ldj","mwm","btm","mgm","ayk","lgu","nim","mjc","mjh","nmu","bfj","ims","hil","hkn","abp","nbv","cbg","ktb","bss","pps","srt","mbs","urr","apb","rab","jeu","goz","iro","lvk","bzo","mqq","apu","cbi","jeb","rau","alk","uha","spa","bsn","hks","mze","yrm","mbn","bfy","srx","med","ktu","ppn","lji","nbi","klb","vao","tpj","bde","bym","pud","jup","tsl","tbz","cbv","nbg","xop","bnf","mxr","atk","yba","esl","gko","kpk","klu","ple","ktz","hnu","dmv","kwl","apz","jya","oym","smn","bfr","raz","acl","gob","pma","kmq","sms","gou","ury","nzd","mnq","nee","ynk","kgl","abj","wfg","dhx","prc","mxy","prh","klz","kfx","ebu","oss","tkq","wsa","nyq","tbu","tih","yol","tic","dmg","her","kzp","yxg","bqf","fse","pwo","nxa","tpp","jqr","kft","wob","osn","ukl","zmn","krr","lox","snf","wle","ano","rue","dsi","wma","caj","ycn","hig","tex","grh","grc","tet","tum","xbn","hii","xed","sde","utu","zms","fla","lot","omn","phq","tlf","kha","sym","yid","wrh","fuy","ulb","ikh","wgo","mca","ssn","bpa","psa","brx","aon","ksq","sss","kjz","vmm","mop","wwo","xxr","rmy","gle","aos","brt","gma","ulu","yaw","xdo","shk","ttf","naj","kad","ddd","aai","tgq","ltg","aux","myh","myc","ylo","cnc","pko","avv","lnw","cnh","orx","opa","ilm","tml","aem","zpa","lti","ort","ccr","aag","xnq","kry","cap","hpo","twq","kiw","koe","gud","aut","nap","aav","bms","ncr","llg","adq","avi","lun","wud","gpn","kvd","kju","moj","lus","jbt","itm","kjb","lli","fur","kkl","bmn","poz","fah","nnc","nnh","lof","bvl","scg","xpv","xmr","hrz","tan","quw","mvz","sgd","lhl","tlt","obr","snx","lso","xld","cob","daw","tef","kdw","lzn","bkd","did","lbe","cou","ino","sci","elx","tas","nhq","unr","tlx","csa","cje","evn","xpi","nou","jrr","ysg","ttt","azt","xtd","nsa","tvn","afp","bal","fkv","cfg","brf","maz","mfs","chq","ett","msy","xhc","tvs","tcw","mfn","akc","bby","akh","xpg","etx","scv","wxa","nob","aiq","alm","lev","wbv","mvb","sqx","gbg","auf","suo","asw","mrq","bxn","eyo","coz","kbx","yrk","nko","sow","sie","tov","jvd","bxs","dto","gbi","iai","zal","kbt","xmy","ivv","mvu","sqt","mjd","bhm","dge","hru","atm","tzm","lka","wbi","lei","bbr","haq","jad","pap","msr","zkd","uya","kpm","mab","toi","lam","mau","gbv","okd","ydd","tog","cko","pnc","pnh","byk","noz","kcc","nps","kch","bcv","mpv","pbv","aek","mmr","sby","ilk","vkp","awh","lir","awc","kup","dba","gnh","gnc","kqy","gap","agc","agh","fin","gcr","oie","sal","hoh","npn","hoc","knr","aro","srf","wap","djo","skd","mpi","bci","pbi","itk","amw","nud","bnt","bwd","mtd","cpn","keu","pbg","bcg","keb","mpg","bnx","xsy","mhc","cps","bgd","tdc","gvp","tdh","wnc","oci","qxt","nle","ymg","lga","syk","ont","nma","kny","gaj","tuk","sbr","onx","pee","mmy","crc","ymi","cte","crh","vkj","kuj","rop","dol","kqr","liy","icl","lwa","sxs","xsr","mue","dnk","nrc","nte","vmk","gvj","lmo","kff","mio","xab","hmd","shm","kya","bqt","kez","cle","nwo","buo","xau","bqx","frp","sxn","waj","bie","bow","kxq","cma","gvy","kme","xcb","mdf","wbl","lel","gdk","mkk","txi","oav","yih","bno","tol","stk","thf","plq","lrn","kla","xsp","txg","frr","zav","ven","ybb","cdm","neq","way","vaf","ypp","xcu","duk","mne","bon","pmz","ndm","arx","zag","eke","cqd","ghe","apa","sxw","raa","nye","zem","spu","knj","gay","tke","iby","ptq","kta","kuy","tnk","bzf","gbl","spb","zai","rkm","kqp","wdk","mmj","art","lij","bos","ror","xwk","grd","sbp","kvh","kvc","zos","wuh","fry","oon","xpl","bvv","bux","bqo","bjk","fiw","bai","war","ngt","nwx","mit","but","woa","yzk","xsj","ysl","fad","ngx","nnd","mzq","gvr","mix","wsu","lmx","bag","tba","mqe","bem","oos","pmb","rth","cwt","goa","rtc","sbj","lhi","qxo","kur","lip","bvi","bdq","kah","kac","kqj","mmp","ono","ams","bav","nfl","scl","tjo","bvg","guc","pim","guh","hna","knp","amn","ibr","gar","trm","azo","tto","xkk","jwi","ahk","gim","puc","mcb","gmu","par","sos","ula","rwm","eto","msp","pcp","ass","bbp","tge","dyo","son","twe","gmb","koq","asn","bxw","cik","lcm","blk","mcu","bpu","psu","ewe","dov","nik","lst","mgk","aym","tlo","ade","wmb","uta","elo","khu","rif","khb","int","xmj","meh","yml","mec","wim","btk","mwk","anf","sno","ywq","gwf","doi","zpz","vgr","qus","pbl","mpl","bcl","afr","uvh","bpz","mcz","ckx","das","prd","ruq","czh","pcj","kdn","dan","bbj","gmz","sdq","msj","qun","kja","def","otk","taw","sav","ckt","pay","uur","iow","zpu","sut","kse","tyt","sag","nkt","tcn","mfw","sem","xmp","tcs","nkx","kbo","khz","yet","tvw","dtt","ecs","sqo","sjk","sux","yum","olk","tyx","sai","zpb","igs","bsh","phg","bsc","nwb","kfa","bub","lim","ngu","mbc","mbh","miu","ksv","mmm","lmu","dsq","kyf","sve","jid","pip","phi","knm","lmb","ngb","nxx","buu","xao","ign","mib","iws","hkh","trp","ndj","sod","ihp","jcs","ksi","iii","zil","cdj","nmf","arz","rcf","pmx","xvo","ksg","mjw","shy","cwb","pmt","phv","sae","rmk","nck","bep","trj","mul","umi","ndp","keo","buz","xtw","twg","xng","tgi","aaq","dju","pij","smc","djb","cll","twi","smh","kqm","xct","umg","krk","tcd","ybx","ngz","miz","jge","bil","sbm","xni","prs","adi","dad","spt","bej","oub","kdd","shr","osc","nll","sgw","qud","ipo","xxk","huf","tgv","arb","xsm","tis","dbf","aru","ctl","pel","sww","tin","adg","dry","spx","diw","prn","doe","llq","sra","ypm","bkw","ice","xbc","ldk","hmw","omc","gel","bhy","wij","obm","bae","foi","ckb","xmm","sep","grn","mqg","unm","bfk","grs","ych","cku","mqi","aly","zmc","zmh","cbq","mao","xib","yup","usi","nku","dtb","bve","rri","iks","wrs","hwc","inz","aua","nqn","ved","lay","rdb","tfo","zpt","nbq","ora","tyu","ssc","ssh","zpx","hro","kpy","mvo","aoc","njl","lbl","opt","wel","zra","sub","iqu","mqv","aty","yeu","nkb","wrn","dtu","mtw","ayp","wpc","bww","txe","nyv","yuj","xul","kmi","whg","mys","nuw","cns","ckz","nsf","mcx","bpx","mng","skw","alr","bra","tkv","bhr","kmg","mct","sej","bpt","pst","gmx","rsk","bgw","mni","myn","urk","mlw","nyi","bmh","loa","bmc","gip","nnn","kpr","fan","inb","kht","kmv","eki","msm","wmx","sil","bbm","mxk","atr","pcm","tea","wmt","luc","tyz","zae","ekg","cuw","nyg","suz","lsb","ood","tkg","mnv","coo","lcp","csf","nkz","dgl","lar","khx","ctg","kbb","nli","xok","myw","peg","atp","nus","rwr","mts","bws","bgn","adl","pam","muv","sks","gir","mvx","snz","cnw","tft","lnh","hrx","zpo","mvt","lap","skn","opo","squ","pei","pka","fcs","nlg","kkq","yme","hrt","aqa","biv","nun","yla","juk","isc","kih","kbu","ish","kic","mtn","bwn","bgs","rgr","nlv","nti","max","alp","mls","egl","yuy","mui","dkg","tgl","ayr","big","mug","azz","ttz","sey","cus","pev","abk","emq","ntg","cli","twl","wir","yta","nnw","etz","mat","bhp","mln","tmq","ksl","kbz","kho","hms","gga","kzk","cox","elu","tpk","laj","tlu","grw","ria","tlb","wmo","kpj","snu","hmn","ana","giy","cot","tzj","atj","gwa","ikw","bce","dyb","mpe","bhj","wrw","pbe","ser","sza","pzn","xda","etu","not","ulf","vif","wiy","ttu","uum","wwa","pso","fwe","azb","phl","yur","ttb","wga","bpo","mco","pof","etb","yah","zgn","dyu","yac","alj","xts","onu","ekl","gof","nyl","gso","mok","mfd","bey","ghl","tkl","sii","qxu","dgg","ifk","shp","ukq","pmo","gzn","qwt","gbe","cdr","frm","xtn","tvd","dgi","ubu","tju","sig","onb","xls","kml","bkn","hss","acq","prw","nxo","try","din","lee","wbe","bqu","tiw","zza","siv","pwa","piy","sgs","jog","swn","ndr","tad","pga","wof","kgq","rom","xug","sgn","sws","hsn","bnz","bqb","xln","bks","dis","mnl","tbf","xat","gev","wam","cjv","okn","igw","raf","spo","weg","apf","lbg","ren","jas","ktf","cdy","wka","ber","bza","lbi","res","wei","ira","shj","sce","nji","nak","esq","jan","zkn","gvm","oks","tsq","mda","gka","gei","cak","bnu","cji","ybo","vor","xpe","ket","kum","vkm","mjn","klf","tha","trr","lbv","ibm","gam","xco","mjs","geg","ndy","err","vaa","bnb","bqz","bxd","pir","jvn","mql","kex","lwo","gox","cga","otr","jml","aae","kog","yis","xky","dhu","vec","srz","kzm","yin","byj","nmo","bly","crw","lrc","ssd","cwa","ciy","got","tpm","lgo","aod","afk","koi","sjr","cmo","ywg","tbt","olr","bua","kfb","xbd","ave","mgy","nwa","ygi","niy","kyo","xes","zmd","kfu","nga","zyp","bty","doq","lle","mia","lma","boh","tbx","ijj","kov","wli","ara","blr","zoh","dse","jet","zoc","rui","kcw","apx","rax","pfe","sdg","gnw","bmd","oua","jum","ixc","sru","cir","ktx","aww","zty","byp","srb","dbo","pak","glv","oty","rug","agw","huo","xom","ktt","wlg","wun","lud","kvn","xkr","apt","rat","how","ahr","wti","mwr","wlv","rts","btr","abm","glg","gun","lpn","kfz","kas","zyj","dds","amc","amh","klx","ddn","mhw","gus","kan","saq","klt","nir","mgr","wnw","kef","dja","sdv","tez","nam","ptv","sty","pli","neg","pus","soh","soc","mky","mvf","yki","dnj","hal","aub","yea","asc","vmj","ash","loz","txq","dta","duy","nei","nka","plg","wji","bjr","rjs","yyz","wak","eya","auu","sua","oru","tya","ykg","maf","dme","izz","brz","kjt","gak","plv","sly","pti","mrl","tuj","tqr","nvm","mbd","men","ceg","nev","qvy","ilp","cam","mes","jbu","jih","wdy","jic","tny","zaq","kjx","vkk","pnw","lko","kuk","quc","chl","quh","teb","cso","bjy","baq","cof","orz","dur","mzg","dac","yyu","dah","kdc","kdh","ina","auz","frk","lob","bdv","vmp","mom","ail","str","lou","czn","rnl","ifm","lsa","gdr","mkr","teu","mzi","enr","brb","jsl","lje","xwr","nbe","tnr","pot","bvq","bdi","tcc","akw","tch","slr","nof","nso","uan","pox","vit","gyl","bdg","nzs","tup","pqw","xgr","bru","mzv","kjo","kqk","tnp","qvp","lzh","aey","sbk","syr","gll","tur","tah","tac","lkt","ojp","slp","dcc","bjj","sqa","pku","wll","ypk","ity","dup","ylu","bcq","kba","mpq","mfc","mfh","zpf","mkp","aks","anz","ylb","pkb","dnr","sdl","evh","vmr","xxm","stp","jpr","tuy","wwb","knk","slj","puw","wgu","tqp","xri","syy","ygl","mcf","poo","nsx","dya","szb","nst","bxc","xrg","lik","dez","ywl","bxh","qvj","xwj","kxv","wgb","kke","ymq","ccm","tta","mmk","wdj","aza","aer","pnn","jmi","riu","stj","sna","cst","gxx","ggb","vmy","ncm","anu","dny","rmm","mkj","gwu","gdj","mew","gwb","tme","ggu","aqz","sfm","anb","kxi","uge","kol","eme","pns","khf","fum","bjp","itr","tla","csx","rib","kcs","nph","tbo","pgu","thz","gyg","nhg","kvw","chv","cmt","pwb","urm","ebo","zlj","bdl","agn","aws","yha","woo","mwp","btp","rsm","mdz","kyx","oyy","nhi","ags","awn","tse","gyi","gnn","kyt","mgp","bqa","kcn","ese","hos","scq","tdn","aig","rys","byr","cip","wyi","rtw","wnn","eja","lwt","lnd","chi","hno","rng","nmx","xpq","uba","blp","tja","kaw","zna","pmf","ddw","mhn","ona","nhv","nmt","chg","ahp","isd","mhs","kid","guw","xkp","aii","cpc","ryn","pck","mzl","mxm","bbk","tds","qxa","goo","bzz","lgt","msk","cel","yry","bfm","unk","crn","vau","nij","mgj","hav","sjp","mdb","gku","mdu","btj","crs","ldm","klo","bna","yad","fsl","ehu","gqn","mrg","xmk","gbq","pgz","obk","thu","bzu","wku","mrv","sxc","iru","pll","kwe","hvv","toq","hux","leq","xkj","wbq","ykl","hai","ace","hut","blj","idi","kto","ztp","dbt","apo","hag","rao","bzb","wkb","nrn","kge","hem","kqw","gog","hni","cho","csl","frs","sbw","czk","tbv","lrr","hng","lha","goi","bva","kot","xtm","ver","aio","zhd","sif","ore","fij","yxu","swm","bor","woi","amy","dmu","uji","dim","bkm","tbi","ebg","gov","pdc","wog","dmb","tbg","sgm","nzk","gyo","nsl","baa","ywt","ynd","jbe","nho","lbf","apg","hao","xkc","cpp","rag","ahh","rem","knw","oor","zaa","okm","jka","rut","jei","cbb","ktg","sdx","gvs","wan","lad","eee","wlx","loe","kpd","rai","gvn","was","cic","api","sdt","liw","cbu","cih","tee","blh","blc","mmw","oaa","jam","zor","ckq","kti","klv","pjt","atd","ido","mjm","nic","bhd","nih","suq","nbu","mgc","mgh","kun","gas","vkn","nkq","klg","mro","gef","mek","amr","boy","txa","rav","lkl","apv","bth","mwh","mwc","bre","btc","kli","nbb","fip","ktv","ald","kus","ibn","gan","ykt","odt","aau","nex","kvk","kdy","pef","day","mfj","bjh","pan","bjc","saa","rxw","quy","kjv","plt","drd","pas","ltu","sor","mtm","bwm","asr","num","rbp","dsz","dbl","net","hul","aab","skm","sva","bxp","kak","bif","avu","cet","llb","kji","ptt","llu","taj","mlm","kfe","guk","avb","ecy","kjg","msw","arq","pcw","tcy","bbw","lmq","asy","soy","zbw","mkc","gdc","hib","afn","gdh","mkh","pov","yik","ica","lwl","sre","sth","doa","miq","mzx","ltz","ngq","dar","buq","lgl","kdr","shd","hmm","mzt","qur","dsb","kxo","mfp","afs","aaz","nml","viv","xmw","duh","duc","ecr","bdt","poi","vig","slc","cml","slh","tap","ojc","zgm","pog","tnh","tnc","jiy","kyl","enc","bxj","uli","enh","qvh","bdx","qvc","xwc","xmn","tar","grm","tcp","mqf","vra","tsb","syc","pto","tuc","tuh","lki","wba","lea","crk","tsu","kll","xms","esu","unn","ndd","soj","gba","vmc","asj","nrk","yko","vmh","cdd","plo","nqm","bnq","jel","apl","ral","wrm","acz","qup","mfr","dcr","ktl","ior","kwz","neo","kdp","qxq","bdo","kck","trd","wol","aec","tbl","tsz","jhi","bxr","mnf","awk","pid","nsg","csv","vae","gnk","cfa","xrt","agk","mym","xpa","qya","yob","paw","tay","mde","gke","kmf","the","hok","nsi","uku","bed","daj","bbn","mfy","pcn","kwu","kdj","msn","kgb","kxx","itc","ire","bze","acu","nnm","fam","bqq","csi","jmx","mzo","nyf","mhk","pyx","gol","acb","kgu","asp","nfa","csg","nsv","bbs","tdk","sop","tvy","kxt","kwb","mss","wnk","tkf","pol","kkz","nhx","kns","mmn","tlq","kyg","lin","dee","cmi","iwm","dzd","fir","waw","boj","lis","ijc","igm","gcn","vil","knn","amp","nmv","nht","cmg","snq","ull","ayd","kyi","emz","gaw","lgg","ttq","aix","lcd","tmz","nmg","cht","yle","zca","koo","oca","lgi","chx","ksf","lwg","gid","kuw","byc","pnk","byh","nmi","ait","kyv","twf","kqs","kkb","yud","amj","fwa","kjl","sbs","mrt","npy","bop","sbn","mrx","sed","sze","mpa","kbq","bca","hts","kqn","huv","tgf","kku","dbv","glo","hyw","sqq","xsn","emb","ugb","udj","row","hat","dbg","gwe","tmb","ane","ruo","hug","wlo","adf","ypn","gge","sdo","tmu","akk","prm","cpy","sxr","hui","vep","idt","tim","emu","hax","dbi","rsn","nhf","gyf","nol","urn","myk","agm","xow","cnk","nxi","wsg","xuo","hom","bau","yxa","bab","teq","dma","xqt","kcm","loq","gnm","wsi","bsr","awm","nxg","mbr","juw","pht","smy","lhu","mhm","bvu","sio","nke","aif","jns","wnm","tye","zaz","tdm","kst","sue","mxs","abw","col","ksx","dgo","brq","mxn","ofs","chf","drc","bvb","wsv","yee","gsg","fak","nnk","pmi","tgt","sld","kzw","twx","crm","txu","smr","bfn","mby","cjo","ybi","xcg","spv","bsy","geo","xgd","mrf","nba","egx","lja","end","bfs","grk","xwd","xnt","mal","txb","tgx","tnd","twt","auq","wdd","ldn","zsr","std","wrk","ikk","cba","zab","adt","spi","vlp","lse","gdd","nrm","adx","zau","jku","bvz","shh","shc","ine","haf","njo","nqk","spg","vbk","mvl","xcv","weo","lbo","lla","mie","zpv","xyk","zmr","nge","mow","krn","srq","yap","muo","mqx","svb","kel","ycr","lme","nto","sjd","mqt","old","bio","clo","fox","nwe","krs","xbr","ava","bue","omr","zpi","sab","doz","prk","akm","lnj","xhm","ssr","tik","aor","rrt","nlo","pqm","cwe","aaa","kij","otd","zpg","cto","peo","sau","luy","jgb","bhc","nid","psg","mnx","omy","bhh","mgd","dje","ccs","kmt","khv","xby","bpg","mcg","naw","btd","ccn","xal","yaj","kmx","zmy","alc","alh","mci","bpi","iwk","gmg","psi","saz","sfs","rmn","dob","tkt","kxf","caw","lah","lac","ncn","nyt","kip","lur","fli","xkd","gmv","hia","ght","pnm","khi","wmg","nyx","fun","bld","atc","tzh","are","ath","bpv","mcv","wmi","khg","bmr","oue","rms","tkx","kpc","ncs","kph","qtz","pfa","cid","kfq","ssy","uzs","nef","zkk","isr","lup","kir","one","pex","tfi","rro","jak","mvg","spl","gbb","nan","lcc","lch","efi","mav","gbu","gih","gic","pum","byd","cvn","nlx","nas","thq","plf","bmp","ssj","uzn","zne","mdq","mvi","aoj","ctt","ydk","okk","wih","leu","wic","cas","mem","sfw","tsa","mag","ivb","bix","bzq","xbj","ybl","mut","tou","dkx","tob","mai","bit","yay","ntx","zmj","mux","ayh","ayc","mjk","mqo","can","xcl","mvv","hrv","leb","wbb","clt","rmw","xpz","cog","nov","ssp","mos","eko","kga","scb","nfu","bmj","gsl","nyo","gbz","gho","kiy","kwa","scu","fqs","lqr","aca","luj","zqe","pml","mon","krw","ycp","noi","xpu","bne","lya","yar","kmo","yuc","uka","nzm","nxl","sgk","zmp","toz","omp","mno","cov","nog","swk","oyd","xbp","uam","bkk","seh","sec","cyo","lez","dik","bdf","xpb","cdh","sit","cdc","ocu","hmk","kzs","dgx","kso","dnd","khl","vmd","ymb","kof","fll","dgt","osp","xav","tpn","bfw","six","kbe","kzn","xvi","yim","xdq","anq","syd","rkh","xag","smp","tud","xem","xut","bsj","gml","mbj","eud","zeh","imy","xai","ndh","ndc","psl","bcz","mpz","pho","mcl","bpl","ele","jun","njx","lbx","nuk","tma","bwk","deq","mtk","zpl","ipi","bec","beh","kev","ema","ymz","sdf","itd","uga","ado","sne","ruf","wum","uwa","kvm","xon","njt","urw","lbt","jus","wet","bgk","rsw","erh","gum","imr","pic","pbu","pih","mlk","tgo","mpu","bcu","aze","trh","trc","tte","mxw","kka","ego","kei","umo","abn","aed","ppp","xno","wtf","mbp","gex","abs","cuk","bsp","rtm","ewo","pbb","smj","bcb","keg","mpb","two","kam","zbc","sng","mkw","scx","kxa","eli","hif","ctz","sys","pez","tli","zmm","ttv","stw","tus","jma","doo","syn","tun","xbm","sni","kyq","xmc","tlg","duw","xmh","sct","mej","jle","zib","nlz","sxk","ngl","xgw","aom","mil","vms","ssm","biz","hgm","kee","dyg","xhr","ojw","xpt","tti","akr","tlv","slw","lml","puj","kzd","jgo","xpx","nmq","snv","pny","xra","tnw","dnn","qvw","muz","xww","azg","ttg","lgq","bul","ntz","enw","dyi","gbx","mep","jpn","nlu","zul","ils","aes","kbg","peb","bjw","sao","aaf","arl","ctu","xve","qwe","abd","aen","ziz","kbi","pnr","llf","ntu","muu","lum","its","bib","wbt","let","xod","eot","xae","lex","vrt","jud","pup","huq","tqw","clu","bmm","dbq","pch","mub","pcc","biu","bbh","bbc","aky","tox","msc","msh","kbv","ida","hor","knc","dgz","xkw","gup","bnv","agr","tyl","cad","njb","gcc","yrs","ijn","lbb","mbm","coe","nju","ciw","lbu","lih","lic","weu","ppm","awr","bxk","ijs","siz","bsm","jko","yrn","gnr","kcr","zao","kap","blw","cry","mmc","haa","mmh","yel","dwz","yij","byn","tdr","rbk","niw","bni","mgw","xil","noe","txo","pbt","mhr","mpt","bct","bng","mra","ckl","kvp","mpx","bys","mww","btw","geb","ymx","kaj","kqc","kqh","dwu","ddj","oni","xep","awy","dgb","bqv","aia","smm","zng","sbc","tjg","bvo","siu","sbh","efe","crr","njz","lsl","kcy","lbz","jje","nsq","cha","hoy","ong","sib","gqr","tak","hre","otw","zyn","ubi","guj","tji","mve","inl","agy","xuu","gya","nha","bao","job","csq","zlw","bqi","yph","kvj","zsm","mod","mfk","wny","bqg","tvk","mae","tdy","dmf","mhy","xsc","xsh","nrr","sjw","yip","xub","gez","zts","xnb","quk","gla","umu","ext","otn","pbo","tgu","dak","bco","mpo","kdk","kvy","frc","wuy","txt","twb","kkf","gme","dji","nrp","yir","arv","tdj","twu","tgb","txx","pse","ztn","bpe","ots","mhj","xnu","mce","umb","zls","adu","sjn","gta","roc","roh","arg","gnj","kay","zax","kjq","crp","tmf","khe","xer","pdn","kcj","sda","krd","tck","hoj","wla","ari","sjs","kbl","ksz","agj","zln","oui","wme","zat","adb","xnz","mhp","xks","bln","fud","mii","bat","ywa","ngi","ahs","lmi","sok","yrw","ttl","wnp","axm","nwg","cin","bug","ask","gvc","ngg","mig","rmd","wah","wac","ncd","tgz","phu","xkn","bls","wur","kvr","bui","nwi","yga","ahn","bax","lmg","nis","mgs","mwn","ccd","btn","ksu","gah","ibh","zpe","gac","ngv","cgg","lmv","lht","gur","tll","bvt","koa","hop","oco","poq","kar","snl","ddr","bvx","kcp","hca","mgn","ksb","mws","bts","buv","nin","crj","cwg","ymo","kuc","byw","adz","kuh","bql","aew","mnb","kmu","mqz","mxd","lsv","lfa","ism","kim","cyb","bjs","ybe","jnd","xpo","pnp","pac","bjn","pah","whu","mnu","xce","kmb","goq","lnm","yso","bda","akj","pur","yhl","nyu","itw","tbq","lsi","tqn","kgf","dox","tku","amk","mer","mza","ing","qxl","spe","kwf","tkb","dot","nzy","urd","tjl","sco","acf","nyb","ubl","bnl","too","hbn","xii","akp","hed","nkv","mnz","dun","mks","gds","svx","mqb","puy","suv","sts","tuw","dlg","leo","syw","tyv","nxe","stn","pnj","cea","vro","ktq","lrk","pta","yev","kmz","mqu","gdn","mkn","afh","raq","dus","apq","wja","xiv","enn","vmw","nzr","nea","ffi","usu","nki","dnw","qvn","sui","tnn","sls","yam","ldd","sax","ojs","tyi","gse","sln","tkz","tns","ckv","nkg","sat","klq","uar","pla","oda","yka","yei","pme","mey","bfd","bok","xgn","qvs","dti","gbo","jye","sug","yot","wgi","szg","bgr","rgs","xru","anv","fap","gin","nnp","bhw","hmy","lcs","kfl","skr","gis","wgg","alw","nac","nah","yox","xrb","asm","nur","mtr","axk","bwr","rgn","som","act","ggg","cac","law","cah","pyu","gcd","rhp","kgx","kxb","dso","ani","dhl","knd","kwt","cur","gwi","ayn","oia","dof","jim","kgt","szv","atw","myp","kwx","zia","ays","hio","mmd","acx","kpw","gwg","dbe","win","lid","dzn","xaq","grj","mlr","jmb","cnp","ang","hue","nvh","tsx","cla","moh","avo","sky","moc","cme","bia","mty","bwy","dei","nuy","dka","esx","bgy","hld","wrp","ikp","xsd","mua","faj","est","qum","nnj","hmr","kye","deg","tst","kdm","dam","sbd","sen","keq","cta","tcm","pea","kxz","kqd","yli","srl","lwe","aao","dev","saf","myj","pkg","yun","nla","zhw","cuy","ses","lto","aqg","zgr","nme","ylg","cds","lrm","jay","mru","bzv","mdg","kzc","vai","tpc","nbo","gyz","kkx","vjk","nhz","eip","mdi","mvq","gea","kkt","vut","cja","tip","xtr","vem","cdn","vag","thi","nse","mrb","rey","nja","bzi","wea","bkr","iri","dir","zaf","cse","vav","zen","bom","und","ndn","emx","idb","hau","swr","aul","xmd","idu","hab","mdv","sgr","bzg","nds","maq","chz","mjy","cbo","yak","thv","tmt","shw","ajw","xoc","pgi","tij","okr","bes","dmo","rer","gyb","nhb","pwg","xty","xua","pcd","ben","nhu","bbd","pgg","lke","zom","msd","pwi","brl","zkr","juc","juh","udm","kik","isk","baf","coq","mrz","ers","rnb","rxd","sgy","chu","pis","aib","trs","dga","xyj","noq","mjr","xly","haz","dwa","diy","trn","bky","abc","abh","bvf","lol","swy","sia","chb","amm","tel","wyb","pin","koz","ruu","wlu","sdb","mjp","ajs","sgj","aql","bew","xyy","yll","sri","fmu","ada","ugo","bkj","gtu","ihw","dij","srg","tmo","rub","ute","swj","urc","sdu","ajn","urh","cbt","piw","tiy","bmk","drn","twa","poe","erw","zpq","nbt","xtj","del","xna","trw","ytl","mxh","srv","mxc","glb","ega","kko","luk","glu","ljx","uma","bcf","pbf","zkp","pad","drs","tga","vie","ule","wtb","swp","gmq","sdz","ldh","ril","omk","dip","dhi","bkp","anl","ggl","bpq","mcq","bfh","bfc","xlp","psq","kfv","sgp","zmk","dhg","ruz","kou","mjj","shn","kfg","khq","jaj","pha","rkw","heh","kje","ygu","dhv","xqa","gft","ssk","ndw","aok","afd","tir","xtp","dmx","kfi","sxm","ywu","szl","okj","prr","rej","shs","mzb","nxq","log","scf","myy","rod","teg","hix","jee","ynn","mlj","grr","kwo","nez","tam","nya","loi","smk","hit","gha","ape","eka","kgo","yns","krh","krc","kte","plz","cuj","tka","tei","mzu","brv","skj","wha","frd","tvm","pgl","cya","mna","nuj","brg","zhn","mtj","fbl","bdu","bwj","yuw","bdb","lov","xpf","nny","fay","kma","bgj","pmq","hmp","mfm","kle","zsk","ikr","bri","tev","wrr","sew","cup","mzz","bsk","hne","aug","gbf","bzl","wkl","bxm","ppk","plu","mbk","bhs","odu","yku","aat","cch","rpt","ccc","ibd","aln","lvs","gad","org","fvr","neb","cnr","aax","mlp","bhn","neu","zrg","usa","aui","giw","goe","kud","als","ori","plb","gry","hkk","myr","gju","llx","avt","spq","far","woe","nnr","kpn","ptu","las","bgp","mqa","fuh","wry","tbe","fuc","hmj","atn","val","tzn","eso","bdz","mtp","ufi","bwp","lef","nqy","wbf","mdl","ats","nup","orv","tso","ceb","rmh","jbi","rmc","thl","nch","kps","skp","lan","ncc","wad","tof","nce","zun","gly","rme","sak","kva","wua","bot","ars","pdi","tib","mrp","ygr","arn","emm","box","ywr","tbh","tiu","sjg","fue","tbc","npo","bqw","ael","tmm","woc","pru","sfe","ebc","paq","dda","hap","cpo","kaa","tjw","lrt","xyb","oti","aij","goc","goh","djn","svk","ztg","kkm","zpd","vum","qxw","ruy","wly","chj","cce","gua","lpa","itl","kor","onw","hnh","mwi","bti","blv","yia","klh","klc","prz","dok","amx","bpd","mcd","tiz","mgg","nig","psd","glr","mrj","tul","syl","btg","mwg","nii","xkv","bnw","mgi","gmd","nhp","amt","bli","mwv","wlr","btv","bus","kth","ngn","kre","ktc","jgk","min","igb","koy","ahg","chp","lmn","wmd","rah","xkg","rac","aph","apc","jeh","rnp","sxo","bun","niv","mgv","vml","xki","aip","mis","khd","haj","sdr","ngs","ahi","ins","ikz","gjr","wrz","ptr","acm","nnu","fau","jit","lsn","kwm","tao","lss","bjv","kjh","kjc","nnb","bdy","inn","fab","nxd","vsl","bvk","myb","sox","kbw","plr","yom","tvo","bjg","asx","mzy","ykr","pmd","cnb","bfe","ner","nza","bji","cnu","grz","bak","kif","mfo","sot","kxp","myu","frq","yzg","ast","yes","nkn","ojg","ulc","wrb","tct","qvi","bxo","slg","dts","vic","duv","xgg","tni","sun","tyn","pua","zak","kuq","bdr","cey","ttw","sus","yrl","stv","sli","xwg","pty","mxe","eng","gaq","yaf","tys","oji","wdg","nnz","vbb","faz","nks","tcx","tng","poh","wru","dtn","mkv","xgi","iku","poc","kdx","myz","env","xin","ure","uth","dax","stg","waq","byl","dui","ney","kxj","snw","gdg","mkg","qux","tnv","cks","gru","esm","dug","slv","grb","sti","ply","ckn","ojv","xis","tsm","kdt","spd","yky","dln","mzr","mea","mki","gdi","zxx","zgb","tvt","nej","ogu","kxy","mlz","mfx","bll","zdj","etn","iqw","abe","vmg","dng","azn","ttn","pyy","mzp","xjb","tts","suw","tuv","tvx","ahl","ssf","aso","dni","ogb","ets","xkl","vmi","mft","aof","dyn","nkw","soo","tug","bwz","liq","bdp","xad","hmb","nuz","mwl","lkh","lkc","ymk","tat","sns","skz","mmq","jio","tln","syi","pna","tax","zmf","knq","tls","snn","him","tui","bgz","hmu","dnv","vmv","mgl","nil","mlb","jmr","otl","avm","xsq","bmf","cuu","mzj","cub","csc","csh","lsw","kxr","luf","mpk","nep","kdo","llm","bck","dao","ilv","ztl","iti","mlu","bwb","nsc","mtb","nsh","hmz","bgu","xrr","nub","tco","sjl","kbs","ilg","ptp","skb","sqs","tpe","kqq","pqa","sku","sqn","nuu","sbq","bgb","xha","kze","ked","kbn","itv","mtu","ili","bdj","bwu","aka","dul","lro","wyr","nmc","nmh","byi","bnn","chr","gqa","sgz","mvd","nbm","lgh","mju","rup","mjb","sdp","byg","stl","air","lwh","xzp","tok","veo","mkl","gdl","cra","diz","wbk","hay","lek","cpx","bkz","bns","fmp","rnr","mad","nww","qvl","byv","xwl","oku","enl","buw","kyc","kyh","gbk","xmq","npx","jab","bsf","boo","tnl","mbf","nra","ife","nhr","gyr","cmc","lmw","sll","reb","jau","mry","okb","miw","xgl","zku","ngw","fit","moe","bku","awa","yhs","aiy","huh","huc","gna","hsb","cod","bqn","xlb","diu","dmm","sgb","bbq","kca","har","swu","yxm","sdj","vnm","arw","msq","hoa","chy","mjz","swb","idr","kop","bjl","wyy","zoo","sgu","xpk","dib","xlu","aga","vsv","bqs","cae","onn","mrr","glj","ygp","zkz","gyy","xtb","zns","nhy","tjs","nae","qxn","jaz","zyg","sck","tql","qxs","tda","djw","nod","fkk","smf","okz","ons","amo","xtu","tjn","vsi","mha","dri","cxh","iir","pmh","ksr","pbm","xya","guu","llk","bcm","mpm","kab","avk","kau","gub","ady","drg","sij","wep","cpf","fif","afe","sel","wub","pww","kvb","tia","twy","bsx","vto","xny","cjp","ajg","pra","srn","mbx","yiz","bst","xuj","mbt","egy","yul","phr","ppt","srs","kvu","wuu","aak","tgy","aji","kjd","lbj","adr","shi","upi","rwl","njj","sip","xeu","rmq","ncq","osx","gil","kaz","kfs","ksy","lcl","spc","guz","kfn","ost","shg","xeb","fuq","wkw","bzw","umr","hik","smt","shv","upv","xch","kvz","xcc","imo","ayl","tgr","pae","xup","vid","mdw","dhn","ocm","twr","gej","ybh","yiu","dhs","dzl","smx","ymm","xnr","wil","dsk","nzu","kue","gfk","god","cna","sst","pej","brs","mff","aot","zhi","iso","kio","xpm","eky","nlj","cfm","mez","nyy","hnd","bel","zph","ibe","gae","zpc","vnk","ssx","nzb","ysm","aox","mxq","brn","dmk","vol","tes","clj","los","wae","zmt","for","mny","omx","kmy","zmx","ntj","taf","lon","wod","gve","ytw","omt","nna","trl","muj","faa","yng","mqr","pil","ten","tbd","ghr","tom","wmh","wmc","lut","nyr","rad","kpi","ekr","apd","bmx","lag","ggw","lem","ktd","wbm","meu","alv","ati","tkr","bhv","bmt","gww","flh","kpg","meb","khc","anw","khh","pep","atg","jbn","nbk","ctp","nzz","lai","roe","gra","www","ors","mch","bpc","pub","bph","mcc","bfq","kpv","zrn","psc","bhg","kmr","psh","ndl","mup","yao","szw","cbk","ntp","kld","aus","mqy","atv","ali","fre","bhi","gmh","bip","lvi","ldq","aun","alg","bxf","orn","mnr","zrs","puu","gbm","lav","ntr","pnu","rin","hle","xse","jbw","mur","mqj","mac","dzg","hma","mah","kmp","ann","ayi","zmo","kyd","gwn","wig","omo","ans","akz","xbo","mnp","wii","bir","ayg","pnb","dkr","tkp","mvh","asf","shl","orw","hrc","sso","szs","gii","auw","nmd","ekp","zga","kit","nyp","ist","szn","hwo","sbe","per","zwa","kix","kzq","wiv","tpq","kqe","gig","cly","brw","hps","sei","ska","yug","abq","pkn","emk","nua","aqn","xhu","mnj","yln","biy","yat","mta","aku","bwa","sam","muy","akb","yui","bga","mqp","seg","kmj","yax","nty","tcf","noh","noc","pnz","jdt","pks","tew","cty","pey","mme","kdf","sev","yvt","luo","kkk","drl","quf","hud","low","coh","coc","usp","dbd","lie","den","mla","gce","nyj","bmo","des","nly","svm","cua","kne","irn","bzn","lkd","mse","nrb","xur","phj","pce","tgp","jaa","bbe","all","zka","kfw","xac","ump","ndi","mbo","lvl","bof","caq","ppo","cjy","mhz","oka","yda","bso","jkm","gey","bhl","ndg","zam","rki","jor","bzs","rea","twp","zeg","nru","dwr","kpl","naq","ths","njy","qwc","lby","kcz","esk","qwh","van","tzl","txm","atl","gnz","sir","mds","ehs","tsk","ndv","gkn","mdn","dhw","vas","crb","agz","ksj","gqu","lal","cdi","dgr","hoz","thn","gza","ger","nrz","kgk","wnu","amf","smo","trg","ynl","bvm","pig","nsd","xta","lhm","erg","mhu","xnj","imt","bev","tri","ack","mhb","kec","keh","ryu","kwk","eri","wnb","tgj","tdb","pgn","ukk","bam","kcb","xme","beg","sga","gnb","ksp","xla","agu","awb","ihi","wer","adj","bka","awu","oso","trv","bei","lbr","njr","srw","yok","gnu","crz","axx","agb","dwy","dia","moq","une","pgs","pwn","kcu","csd","piv","swa","siy","hob","zbe","xpr","xht","xmv","mdd","gkd","ulw","yau","akt","wal","byq","thd","gvl","puo","hji","ysr","azc","tth","ttc","tre","ley","hak","pie","bxa","toy","yab","pow","etc","eth","akx","kul","vkl","meo","gby","fom","obi","lks","nfr","ung","lnz","snc","lkn","bzd","wkd","tlh","bee","xmg","tlc","mqm","hdy","mrk","gal","kiz","ibl","uni","elh","hvk","pci","tkm","ler","bbi","wbr","ysy","msi","ekm","pnt","nde","nym","csn","tor","aik","msg","pnx","pgd","taa","faf","css","bbg","xpy","nnf","pcg","czo","eaa","yaz","chk","nss","bbv","mfa","kbh","msv","kiu","isu","kbc","nhk","kmm","lnb","sqh","saj","myf","jhs","dop","iar","gbr","mnm","lnu","nsn","tva","kib","rol","cde","bap","klw","nms","bcr","mpr","wci","pbr","mht","mmv","see","tdt","ksm","liv","lgs","fgr","kxk","tdx","vmq","yue","lws","lgn","txj","nmn","knv","mhx","bnc","awx","ktw","agt","zaj","kys","mmi","ggd","hot","raw","bvp","kcx","apw","kng","cmn","lhp","mmg","kct","cms","euq","and","awt","kni","axb","agx","phm","gwd","gnt","kyn","lig","tuq","fia","hus","xsi","tif","ypg","prf","aye","npa","pal","nrx","sbv","pby","mpy","tbw","bcy","kvo","nrt","kqv","hun","dze","baj","dbn","bqc","bqh","wie","ded","wow","xfa","hti","crt","xsv","guo","lpo","sbg","egm","gie","umm","kqg","gow","qxc","xnm","qxh","sbi","lce","ymr","bvj","jkp","aeq","crx","zap","kqi","rge","aqd","cpa","ddo","twm","kao","tqq","won","kpe","zsu","xet","eze","dbw","uda","ago","huw","oar","ate","arc","arh","rog","ted","tbn","xum","hoo","bvy","bkf","dif","zar","kco","tbs","bdk","gno","zuh","wos","lae","jkr","awo","osu","ymp","swf","mbz","msl","yix","mho","hnn","sim","bbl","pcl","txr","mzk","ama","wno","gos","ale","smu","tdo","brd","gon","mpj","bhe","bcj","djc","smb","bay","yit","hns","gut","obl","kax","tnq","zay","cro","kls","xml","aud","nmw","kui","bvr","cgc","ibg","enq","cjm","gag","wav","gem","kug","lww","lpx","gux","gjk","gai","lra","zbl","cek","kln","mbb","buc","kyw","buh","nwc","bsb","kts","jaf","kuv","nek","mpp","kvx","wux","bcp","jen","pbp","yne","wai","bar","ras","aps","duq","kvt","lmh","wut","boa","lmc","txy","odk","ykk","apn","smz","mkq","gdq","ran","bsu","stq","wag","njm","mic","plk","mbu","mih","ppu","wem","ngc","ngh","ktn","lbm","inc","kda","inh","daa","bmb","met","she","pav","glk","say","mum","qua","luu","mlf","kjn","ntm","lsh","zlq","csw","lsc","aoz","lub","ssz","kjs","bim","sbl","clm","wtk","bmu","icr","srd","gbp","dor","kql","skf","ako","top","sdk","xsl","nsw","xho","dva","pai","nuf","pux","mtf","otq","bwf","nlm","wbp","lep","ztq","xpj","put","wxw","bgf","wlk","ctm","tca","ruk","pem","zmz","pag","yec","mml","soa","gbj","dre","bmz","dth","pon","vis","asa","doy","mwq","btq","ssu","lil","aou","niq","suc","mgq","aob","gcl","ssb","luz","tyh","uln","nkc","scp","nkh","vin","knl","dhd","sar","pos","omb","zmu","xbb","afi","kok","kfd","blq","hmf","xpp","pno","qyp","ckh","zim","xkq","afg","jia","wbj","lej","zmb","omu","ysp","czt","toj","kwr","gro","rbb","cut","ndq","wmw","mfz","mas","hij","acr","bfl","cag","nav","gjm","mlx","aap","khw","anc","anh","man","gwc","mlt","gek","cai","kgr","ldl","yva","cjk","mef","cux","tsy","psw","mvs","skx","bpw","jda","mcw","tfn","ykm","cvg","lbk","szc","nux","bxu","esy","yor","nqo","bgt","nai","fni","lzz","bwx","xdc","mtx","puf","nut","iko","wro","bxb","bgx","yaa","mtt","gmw","bnd","bwt","ukr","mvn","fng","cav","nag","skt","llp","nem","taz","bdm","xjt","url","non","rsl","lna","bye","mfb","tvu","kgy","znd","hhi","myo","ues","aqc","mfu","kia","kwy","isa","trq","nos","acy","zpw","iou","cno","pkc","pkh","mov","llj","tau","dgk","yhd","ije","nno","mog","hmx","fao","cos","uky","mzm","mxl","yre","hmt","sik","bqd","bxz","deh","dec","con","tsr","beq","dwk","jnl","yoy","moi","tab","ygm","snd","swt","ayq","cbj","sxb","sgx","bkt","xas","iwo","bkx","tpv","ccl","igo","xan","tmr","dix","sxu","ite","bzh","bzc","irh","swx","tld","kzv","sgt","giq","yif","xcw","ncl","tpg","rml","thh","xvs","qws","kzg","mdh","mdc","vnp","dyd","kom","nbj","xtt","vah","ful","tpi","ima","zik","ile","aee","azd","xvn","epi","ttd","kzi","lcq","kkr","tmy","bik","kaf","pmw","mjt","krl","dkk","emy","seq","ugy","cpu","abi","ken","kbd","clk","wtm","cpb","kes","gsw","vme","ntk","guf","yuq","abg","mjx","dne","muk","jls","jui","ret","jax","npb","kky","kvf","abv","pek","ljp","rum","xog","nbp","wlm","zkt","tue","fiu","xzm","okx","pro","nlk","npu","xoi","tio","jat","mxg","qve","xwe","nbr","urv","pms","jng","chm","gsn","amb","wym","kkj","kew","dmy","tdf","gss","yxy","sle","xto","mxi","jct","amu","aim","ghk","nyk","sma","boz","pmn","mhf","jni","ekk","swo","due","mnk","wss","tmj","uri","ynq","ind","kcf","whk","nxn","dio","bko","osa","urg","zsa","lrz","cbr","xlo","udu","ste","src","srh","mxv","agf","lsd","mke","gde","gym","kmk","nhm","bou","ham","dmr","tix","atq","heg","xaw","oko","bsa","uhn","spn","amz","nal","prx","nrf","kpq","mba","kfh","kfc","hei","hka","kkp","prt","sps","zko","nby","laq","eit","usk","jao","bob","tit","mjo","mqk","cby","alq","ybn","bfi","ldg","dtd","mrm","xyt","nkd","emp","bje","bhq","crf","cal","bfg","ldi","xcn","krv","zpn","brh","mwe","bte","jul","izh","brc","drq","bgo","tcu","wrx","nqt","ikx","mto","bwo","fpe","nuo","tcb","ikt","zps","tsp","nie","akf","sko","djd","mge","now","kri","ard","cuo","tec","ble","teh","grt","qub","xnk","bma","loc","cow","loh","kgj","cie","asz","abl","soz","kwj","kdu","tgk","mlo","dau","hir","lua","gpa","xke","grx","ole","jiu","rmi","wms","sje","nci","tsj","pym","fln","bud","shq","maw","oma","nnt","khn","fat","zma","fui","tpl","ncg","mid","khs","hmo","rmg","ukp","tcz","ngd","fax","kxm","kzl","wmn","lmd","zle","ksk","jib","ote","orc","hrw","bps","mcs","orh","aar","cnx","rmv","ccg","quz","pss","acp","mvw","gmn","asb","xrm","phk","auh","ogo","myx","kdz","auc","kwp","daz","hwa","sob","sou","fuv","kgp","asu","bpn","mcn","cwd","cnt","ssa","zte","psn","aoa"],match=>"\\A[a-z]{2,3}\\z",summary=>"Language code (alpha-2 or alpha-3)","x.in.summaries"=>["Central Khmer","Norwegian Nynorsk","Volapuk","Persian","Romansh","English","Afar","Occitan (post 1500)","Marathi","Abkhazian","Tswana","Luba-Katanga","Ojibwa","Welsh","Swedish","Lithuanian","Slovenian","Turkish","Luxembourgish","Latin","Javanese","Pushto","Ndebele, South","Pali","Bambara","Divehi","Mongolian","Oriya","Afrikaans","Chichewa","Fulah","Haitian","Interlingue","Turkmen","Tahitian","Hausa","Cree","Sundanese","Avaric","Latvian","Japanese","Sotho, Southern","Indonesian","Bihari languages","Danish","Belarusian","Burmese","Vietnamese","Sanskrit","Macedonian","Gaelic","Hungarian","Quechua","Polish","Ndebele, North","Swahili","Marshallese","Faroese","Sinhala","Chinese","Swati","Ewe","Sango","Nepali","Lao","Kazakh","Kirghiz","Inupiaq","Thai","Telugu","Hindi","Bengali","Chamorro","Chechen","Portuguese","Hiri Motu","Kanuri","Kuanyama","Limburgan","Panjabi","Guarani","Ganda","Assamese","Somali","Finnish","Rundi","Oromo","Breton","Uighur","Kannada","Malay","Kurdish","Ndonga","Inuktitut","Maori","Northern Sami","Serbo-Croatian","Russian","German","Bashkir","Tajik","Gujarati","Tsonga","Albanian","Corsican","Tigrinya","Amharic","Interlingua (International Auxiliary Language Association)","Hebrew","Georgian","Twi","Italian","Ossetian","Spanish","Irish","Sindhi","Malagasy","Esperanto","Norwegian","Tonga (Tonga Islands)","Walloon","Czech","Samoan","Manx","Galician","Avestan","Kalaallisut","Komi","Navajo","Greek, Modern (1453-)","Herero","Tibetan","Dutch","Serbian","Aymara","Church Slavic","Tagalog","Akan","Western Frisian","Yoruba","Xhosa","Sardinian","Shona","Dzongkha","Korean","Ido","Malayalam","Croatian","Catalan","Romanian","Ukrainian","Bulgarian","Kashmiri","Sichuan Yi","Urdu","Kikuyu","Kinyarwanda","Icelandic","Estonian","Zulu","Armenian","Wolof","Bokmal, Norwegian","Tamil","Cornish","Tatar","Azerbaijani","Nauru","Aragonese","Venda","Lingala","French","Zhuang","Arabic","Yiddish","Slovak","Chuvash","Basque","Maltese","Kongo","Bosnian","Fijian","Bislama","Igbo","Uzbek","Binongan Itneg","Lou","Khang","Bislama","Ribun","Mazatlan Mazatec","Munda languages","Southeastern Dinka","Warkay-Bipim","Andh","Zarphatic","Chiquitano","Malagasy","Cuiba","Gwere","Kru languages","Skou","Catalan","Acoli","Teanu","Kekchi","Likwala","Makayam","Kowiai","Bini","Northern Nuni","Asaro'o","Yalakalore","Sighu","Malimpung","Nyalayu","Nyaw","Creek","Ila","Tunisian Arabic","Yucateco","Ukhwejo","Giangan","Sakalava Malagasy","Mon","Cahungwarya","Turka","Barwe","Una","Bieria","Cuvok","Nungali","Iranian Persian","Northern Catanduanes Bikol","Semai","Sika","Bugun","Tillamook","North Babar","Chhintange","Machinere","Paranawat","Ngumbi","Komo (Democratic Republic of Congo)","Warrwa","Motlav","Akeu","Maiwa (Papua New Guinea)","Ili'uun","Baniwa","Yatay","Inupiaq","Nakwi","Peruvian Sign Language","Itza","Barbaram","Muda","Awjilah","Attapady Kurumba","Yalarnnga","Southeastern Pomo","Arha","Creoles and pidgins, English based","Roria","Las Delicias Zapotec","Maku","Tepecano","Ulumanda'","Ogbogolo","Rawo","Owiniga","Danau","Kija","Hmong Do","Lopa","Comaltepec Chinantec","Muluridyi","Igala","Anyin","Malayic Dayak","Aeka","Zinza","Murupi","Eshtehardi","Sakizaya","Tubatulabal","Arandai","Sibe","Molima","Southwestern Guiyang Hmong","Deori","Tunzu","Sinte Romani","Tsuvan","Tswa","Central Subanen","Warrgamay","Barapasi","Fyer","Bari","Tututni","Northern Huishui Hmong","Awar","Inebu One","Unggaranggu","Tagbu","Baki","Swiss-German Sign Language","Ir","Jordanian Sign Language","Keerray-Woorroong","Beaver","Biri","Dimbong","Kubachi","Ura (Papua New Guinea)","Rombo","Wom (Nigeria)","Tamashek","Ligurian (Ancient)","Sui","Tumak","Digo","Suga","Buraka","Lalana Chinantec","Moma","Thawa","Swabian","Liburnian","Nooksack","Ahwai","Banaro","Amundava","Ofo","Northern Rengma Naga","Tirahi","Dogoso","South Fali","Bekwarra","Samatao","Divehi","Yongbei Zhuang","Khun","Odoodee","Acatepec Me'phaa","Sinhala","Huarijio","Eravallan","Tuwari","Cara","Kamarian","Santa Teresa Cora","Kosadle","Birale","Transalpine Gaulish","Pima Bajo","Shekhawati","Oyster Bay Tasmanian","Gazi","Siuslaw","Mandar","Tagwana Senoufo","Dagoman","Oy","Sinicahua Mixtec","Dutton World Speedwords","Mbowe","Korwa","Goan Konkani","Rana Tharu","Tlachichilco Tepehua","Karajarri","Serbian","Malba Birifor","Orokaiva","Chenapian","Even","Ambulas","Makasar","Choni","Gende","Yaqui","Kim Mun","Te'un","Loo","Morisyen","Migum","Wangkayutyuru","Obanliku","Javanese","Iraya","Western Katu","Tu","Geser-Gorom","Krevinian","S'gaw Karen","Shor","Bikya","Inabaknon","Ngendelengo","Mekmek","Male (Ethiopia)","Haruku","Tariana","Kemiehua","Okiek","Golin","Cameroon Pidgin","Kraol","Reli","Jutish","Phangduwali","Libyan Sign Language","Nisa","Yareba","Tha","Koguryo","Mannan","Yidgha","Koko Babangk","Liangmai Naga","Sorbian languages","Lendu","Rmeet","Kurti","Powari","Mescalero-Chiricahua Apache","Zeeuws","Warlmanpa","Ikulu","Canela","Ndasa","Wayu","Wakona","Kara (Tanzania)","Toma","Kumaoni","So'a","Laomian","Mangbetu","Mittu","Batu","Mahou","Thiin","Mararit","Kasiguranin","Nakame","Southern Tutchone","Kaningi","Esperanto","Manangba","Halh Mongolian","Mailu","Tai Pao","Chang Naga","Lega-Mwenga","Sekele","Ngamo","Niuean","Gera","Jamiltepec Mixtec","Luopohe Hmong","Juwal","Southern Kisi","Mbunda","Axamb","Orowe","Quetzaltepec Mixe","Michigamea","Guadeloupean Creole French","Northern Nago","Mituku","Mankanya","Wejewa","Carapana","Tolaki","Urat","Igana","Serer","Shall-Zwall","Kpatili","Ci Gbe","Belize Kriol English","Duupa","Urimo","Oto-Manguean languages","Makonde","Mundat","Phoenician","Kaamba","Ixtenco Otomi","Limbu","Quechua","Old Welsh","Bilua","Lucumi","Bo (Laos)","Tigre","Adang","Ume Sami","Kopkaka","Mbugwe","Jilbe","Jowulu","Ningil","Vaiphei","Kuvale","Kayan","Zuojiang Zhuang","Jiba","Prussian","Aja (South Sudan)","Duguri","Thompson","Bomu","Tiene","Xukuru","Hungana","Kachhi","Tlacolulita Zapotec","Adamorobe Sign Language","Paici","Montol","Bwela","Zul","Nusa Laut","Guinea Kpelle","Mbala","Gavak","Sajau Basap","Moingi","Batak Alas-Kluet","Balti","Chabu","Makyan Naga","Abon","Kurtokha","Daungwurrung","Kanashi","Otuke","Kakabai","Tandaganon","Culina","Dhargari","Kemberano","Sandawe","American Sign Language","Twendi","Dravidian languages","Nume","Songomeno","Tiv","Siwai","Pendau","Bantayanon","Sera","Old Tibetan","Guila Zapotec","Malua Bay","Northern Kankanay","Askopan","Dawawa","Balantak","Pidgin Delaware","Gbin","Enu","Old Kentish Sign Language","Naaba","Bharia","Thopho","Maku'a","Tay Khang","Northwestern Ojibwa","Warungu","Wadjigu","Central Grebo","Rendille","Yanesha'","Selaru","Sengo","Elfdalian","Yalahatan","Southern Nago","Western Tunebo","Tambora","us-Saare","Izere","Wariyangga","Markweeta","Iko","Unggumi","Birao","Alago","Pottangi Ollar Gadaba","Mal Paharia","West Makian","Pamosu","Habu","Awiyaana","Drung","Cajonos Zapotec","Atakapa","Nyokon","Fon","Mandeali","Yir Yoront","Tumari Kanuri","Pukapuka","Southern Subanen","Northern Subanen","Ghari","Baruga","Odia (individual language)","Teen","Udihe","Samtao","Mingrelian","Karon","Bokha","Siraya","Bassa","Chacobo","Ezaa","Pei","Maisin","Kutto","Anor","Dubli","Madi","Moronene","Huba","Iku-Gora-Ankwa","Tereno","Zigula","Tanzanian Sign Language","Pele-Ata","Waruna","Gudu","Konyanka Maninka","Gwi","Kalaamaya","Daasanach","Nyankole","Ghanongga","Central Sierra Miwok","Faiwol","Kol (Cameroon)","Mundabli","North Nuaulu","Domari","Chulym","Lamu","Burui","Lele (Guinea)","Touo","Ma'ya","Toku-No-Shima","Chothe Naga","Maring Naga","Romam","Paliyan","Monom","Finongan","Baibai","Ten'edn","Mekwei","Central Puebla Nahuatl","Tembe","Takestani","Futuna-Aniwa","Guhu-Samane","Nyungar","Northern Pastaza Quichua","Jofotek-Bromnya","Nottoway","Aluo","Suabo","Banda languages","Erzya","Tijaltepec Mixtec","Samo","Makasae","Waskia","Mansi","Dilling","Berik","Awtuw","Angika","Nugunu (Australia)","Northern Qiang","Loke","Swedish Sign Language","Manta","Thur","Tulishi","Laurentian","Late Middle Chinese","Banggarla","Busuu","Ashaninka","Koki Naga","Sumi Naga","Aruek","Baeggu","Oruma","Southern Mnong","Duli-Gey","Ari","Zhuang","Abu' Arapesh","Walangama","Hausa Sign Language","Rohingya","Kamasau","Serui-Laut","Hulung","Edolo","Northern Paiute","Yassic","Yugambal","Areba","Ile Ape","Tera","Aiome","Jakattoe","Mixtepec Zapotec","Kinuku","Baham","Mai Brat","Jewish Palestinian Aramaic","Oksapmin","North Midlands Tasmanian","Pecheneg","Anakalangu","Kayaw","Silimo","Shempire Senoufo","Dyarim","Ayerrerenge","Deg","Thaypan","Haruai","Manga Kanuri","Khua","Matbat","Jungle Inga","Akhvakh","Sea Island Creole English","Italian","Talise","Old Breton","Sakachep","Munda","Niuatoputapu","Batui","Kadazan Dusun","Salawati","Koro (Vanuatu)","Sihan","Kalaallisut","South Giziga","Makuri Naga","Central Khmer","Siang","Namakura","Pular","Aoheng","Poyanawa","Wiarumus","Southern Toussian","Mburku","Djabugay","Eloyi","Yuracare","Lingarak","Kangjia","Ayu","Bubia","Ayizo Gbe","Kalo Finnish Romani","Kanowit-Tanjong Melanau","Pangu","Notsi","Maiwa (Indonesia)","Moresada","Coyutla Totonac","Yindjilandji","Gitonga","Pentlatch","Wanda","Wiru","Leco","Sikaritai","Mashi (Nigeria)","Lenje","Senthang Chin","Paraguayan Sign Language","Pinigura","Saniyo-Hiyewe","Panamanian Sign Language","Gbaya-Mbodomo","Arin","Kamayo","Upper Grand Valley Dani","Yevanic","Mulao","Defi Gbe","Nepal Bhasa","Kelo","Martuyhunira","Pauserna","Nakai","Inapari","Biyom","Malaccan Creole Portuguese","Gibanawa","Siculo Arabic","Shubi","Brooke's Point Palawano","Talysh","Ringgou","Tai Do","Kafa","Wyandot","Pume","Yine","Tomadino","Hovongan","Limbum","Chinook jargon","Guatemalan Sign Language","Ndzwani Comorian","Butmas-Tur","Malgbe","Remontado Dumagat","Apasco-Apoala Mixtec","Ngulu","Ma'di","Glavda","Terebu","Pomo","Ndogo","Wanggom","Turoyo","Jair Awyu","Bengkala Sign Language","Western Tamang","Ainu","Jola-Kasa","Busoa","Kete","French, Old (842-ca.1400)","Lote","Margu","Maung","Southern Balochi","Mangarrayi","Bariai","Wotu","Roon","Patamona","Moba","Djeebbana","E'napa Woromaipu","Pintupi-Luritja","Lithuanian","Ngangam","Toro","Holikachuk","Arapaso","Naskapi","Numidian","Anguthimri","Koda","Kendayan","Tamasheq","Agariya","Malalamai","Tyap","Bebele","Ubykh","Kwaio","Panoan Katukina","Guyanese Creole English","Iha Based Pidgin","Aekyom","Blagar","Central Nahuatl","Rotokas","Madak","Gooniyandi","Uradhi","Liabuku","Kamantan","Gikyode","Walak","Angor","Colonia Tovar German","Pije","Wappo","Burusu","Rikbaktsa","Akukem","Yerakai","Tsakonian","Yawarawarga","Idesa","Chaura","Narango","Matu Chin","Basa-Gurmana","Dugun","Hangaza","Tora","Bintulu","Kenswei Nsei","Yagwoia","Haisla","Abar","Ngie","West Lembata","Gaviao Do Jiparana","Chokri Naga","Italian Sign Language","Kibet","Cheke Holo","Northern One","Beele","Kugama","Seberuang","Sabu","Central Hongshuihe Zhuang","Yaben","Kumukio","Canar Highland Quichua","Mili","Kodeoha","Central Melanau","Mser","Saotomense","Southern Muji","Bena (Tanzania)","Batak","Igbo","Gants","Middle Hittite","Comecrudo","Klias River Kadazan","Guiqiong","Old Chinese","Maragus","Ubir","Bofi","Kimki","Michif","Arapaho","Chadian Arabic","Meriam Mir","Puno Quechua","Liki","Hidatsa","Mangga Buang","Kalkoti","Guanyinqiao","Luvale","Ocotlan Zapotec","Ahanta","Ghanaian Pidgin English","Zangwal","Sartang","Hawaiian","Oroch","Northern Nisu","Karo (Brazil)","Siksika","Tjupany","Kono (Sierra Leone)","Yawanawa","Yolnu Sign Language","Xam","Cia-Cia","Ninam","Pokanga","Limassa","Xegwi","Amri Karbi","Tarpia","Paleni","Kosraean","Wusa Nasu","Irish, Middle (900-1200)","Busa","Nottoway-Meherrin","Nias","Bullom So","Djambarrpuyngu","Da'a Kaili","Armenian (family)","Kuman (Russia)","Yidiny","Tibea","Mwatebu","Bata","Ayutla Mixtec","Eastern Tawbuid","Kanasi","Maranao","Austrian Sign Language","Kongo","Lamboya","Tsetsaut","Thracian","Fortsenal","Kaiy","Kemak","Rungwa","Rukai","Moroccan Arabic","Fataluku","Kajaman","Angal Enen","Aari","Eastern Bolivian Guarani","Balangingi","Kutenai","Tjungundji","Borana-Arsi-Guji Oromo","Minica Huitoto","Tenggarong Kutai Malay","Karekare","Amal","West Goodenough","Onjob","Zumaya","Kukatja","Kenati","Highland Konjo","Eastern Krahn","Turkish, Ottoman (1500-1928)","Wuvulu-Aua","Kola","Chuwabu","Laha (Indonesia)","Abai Sungai","Paraguayan Guarani","Syenara Senoufo","Dair","Bure","Sabum","Baelelea","Rundi","Walloon","Ladin","Isthmus Mixe","Sened","Kaninuwa","Engdewu","Mangerr","Lamalera","Bola","Aklanon","Zula","Solano","Western Huasteca Nahuatl","Kuni-Boazi","Quinqui","Katukina","Epena","Bahamas Creole English","Badui","Bandial","Walungge","Anam","Dandami Maria","Alviri-Vidari","Wallisian","Kwang","Burmese","Russian","Koch","Nawaru","Alo Phola","Bigambal","Watam","Gallurese Sardinian","Judeo-Moroccan Arabic","Gonja","Linear A","Settla","Etkywan","Carijona","Kono (Nigeria)","Cen","Riverain Sango","Patani","Dong","Northern Dong","Kafoa","Obo Manobo","Aruop","Southern Carrier","Konai","Bogaya","Finland-Swedish Sign Language","Dotyali","Morerebi","Midob","Reel","Mbre","Gade Lohar","Northern East Cree","Yeyi","Zaiwa","Hamba","Kabiye","Duala","Tiyaa","Mullu Kurumba","Laba","Talinga-Bwisi","Suya","Mam","Mouwase","Slavic languages","Cakfem-Mushere","Kaniet","Palenquero","Phuie","Kua-nsi","Bhoti Kinnauri","Raji","Tulu-Bohuai","Northern Sami","Galatian","Mano","'Are'are","Bhili","Kiowa Apache","Albanian","Apali","Jeri Kuo","Ngbinda","Horned Miao","Bhunjia","Nengone","Levuka","Ambo-Pasco Quechua","Kwaza","Xipaya","Tacana","Karawa","Kulon","Ngarluma","Pankarare","Tooro","Nabak","San Marcos Tlacoyalco Popoloca","Rajong","North Azerbaijani","Puinave","Budza","Filomena Mata-Coahuitlan Totonac","Aribwatsa","Nukuoro","Nzima","Holu","Meskwaki","Albanian languages","Yakut","Mwaghavul","Baldemu","Tai Daeng","Kari","Fembe","Arta","Gangulu","Old Hungarian","Burunge","Calamian Tagbanwa","Zhaba","Tarok","Siane","Kupsabiny","Lingua Franca Nova","Longto","Amahai","Lotud","Mauritian Sign Language","Eastern Bontok","Kela (Papua New Guinea)","Tombelala","Xiriana","Ifo","Sur","Hunde","Macanese","Mombum","Mauwake","Vlaamse Gebarentaal","Gowli","Vincentian Creole English","Yahuna","Northern Bobo Madare","Bada (Indonesia)","Iyayu","Afitti","Alur","Tabasco Zoque","Kairak","Madhi Madhi","Papi","Molale","Comanche","Mazanderani","Wushi","Kuri","Nde-Gbite","Ibibio","Barikewa","Gabri","Upper Kuskokwim","Kurrama","Batanga","Drents","Kyan-Karyaw Naga","Kla-Dan","Bete","Polari","Min Dong Chinese","Bari","Kutep","Namibian Sign Language","Baga Sobane","Sabaot","Mudhili Gadaba","Mbulungish","Kolsch","Paynamar","Southern Kalinga","Ibu","Ndonga","Kaikadi","Northern Qiandong Miao","Yalunka","Ararandewara","Gorovu","Cayuse","Ninggerum","Phukha","Heyo","Cashinahua","Bashkardi","Waura","Czech","Wab","Nyahkur","West Uvean","Bassossi","Owenia","Paipai","Yaweyuha","Ilianen Manobo","Kariya","Emplawas","West Central Oromo","Birked","Tae'","Mande languages","Shasta","Samvedi","Papuan Malay","Mengen","Wumboko","Temuan","Saparua","Jaya","Malimba","Ngindo","She","South Central Banda","Urarina","Kunza","Adhola","Runga","Koro Zuba","Beami","Dampelas","Osing","Teke-Kukuya","Northwest Oaxaca Mixtec","Ibali Teke","Kuanhua","Teshenawa","Sami languages","Loko","Tai Don","Jangshung","Timucua","Tobagonian Creole English","Piapoco","Wampur","Tigak","Horpa","Chung","Marrucinian","Apalachee","Puelche","Kadar","Carian","Bunama","Simbali","Tarao Naga","Santiago Xanica Zapotec","U","Lower Southern Aranda","Mbariman-Gudhinma","Ipalapa Amuzgo","Northern Tutchone","Sansi","Rawa","Mainfrankisch","Anindilyakwa","Gurindji","Lepki","Kodi","Kinnauri","Yanda Dom Dogon","Ketangalan","Doondo","Coptic","Ushojo","Chinese (family)","Kele (Democratic Republic of Congo)","Angoram","Seimat","Old Hittite","Omotic languages","Flaaitaal","Tlazoyaltepec Mixtec","Mangole","Jalapa De Diaz Mazatec","Miluk","Ayoreo","Tolomako","Negeri Sembilan Malay","Dusner","Central Tunebo","Awutu","Shark Bay","Omagua","Piscataway","Eleme","Tsishingini","Bunganditj","South Watut","Numanggang","Bishnupriya","Dzongkha","Rama","Marti Ke","Iyo","Pankararu","Southern Ma'di","Hindi","Gulf Arabic","Kombio","Mycenaean Greek","Kalabakan","Omi","Cochimi","Pamplona Atta","Karon Dori","Fuliiru","Luiseno","Avatime","Ofaye","Lithuanian Sign Language","Kharia","Tiwa","Bamwe","Karata","Asheninka Perene","Aushiri","Lele (Chad)","Nhirrpi","Kumhali","Latin","Mazaltepec Zapotec","Mountain Koiali","Hijazi Arabic","Duri","Hiberno-Scottish Gaelic","Northern Ghale","Bagirmi","Nyikina","Nyanga-li","Tabriak","Kwinti","Tiefo","Arutani","Ganda","Anambe","Nanai","Repanbitip","Manchu","Mono (Democratic Republic of Congo)","Bhalay","Ukwuani-Aboh-Ndoni","Southern Altai","Luwati","Iu Mien","Mirning","Palauan","Tachoni","Suarmin","Latunde","Iwal","Nonuya","Parecis","Serudung Murut","Koronadal Blaan","Menya","Suma","Aasax","Obokuitai","Bhattiyali","Bum","Amol","Austronesian languages","Portuguese Sign Language","Kalam","Southern Dong","Kulung (Nigeria)","Bihari languages","Chiripa","Yong","Kayardild","Kwangali","Kumbainggar","Kimbu","Musom","Magbukun Ayta","Amganad Ifugao","Saamia","Sharwa","Achang","Bakairi","Dimli (individual language)","Mwan","Chilcotin","Central Sama","Chilisso","Marathi","Acroa","Philippine Sign Language","Makaa","Noy","Kaure","Minaean","Southern Rengma Naga","Masbatenyo","Kwese","Karingani","Barai","Mundu","Ajumbu","Pear","Urubu-Kaapor Sign Language","Kapori","Gitxsan","Unde Kaili","Barzani Jewish Neo-Aramaic","Langobardic","Kitsai","Zambian Sign Language","Nkem-Nkum","Alngith","Teribe","Yongkom","Bankal","Bonan","Chetco","Cree","Ruund","Thaiphum Chin","Quiavicuzas Zapotec","Tumshuqese","Irish Sign Language","Luyana","Kimaama","Daantanai'","Highland Oaxaca Chontal","Nalca","Marau","Gilima","Rerep","Mori Bawah","Solong","Jadgali","Larike-Wakasihu","Southern Yukaghir","Swiss-Italian Sign Language","Waneci","Norwegian","Yagnobi","Japreria","Tiranige Diga Dogon","Malaryan","Malay","Sentani","Mvanip","Besisi","Binji","Maasina Fulfulde","Namat","Gabrielino-Fernandeno","Western Magar","Forest Enets","Tomo Kan Dogon","Yamana","Momare","Maxakali","Yopno","Pipil","Nicaragua Creole English","Iraqw","Judeo-Arabic","Basa-Gumna","Bhojpuri","Namla","Atong (Cameroon)","Ede Idaca","Kamu","Tzotzil","Seta","Hiw","Tharaka","Yangben","Obulom","Central Siberian Yupik","Horom","Chorti","Mangbutu","Ikposo","El Alto Zapotec","Angal","Indus Kohistani","Guduf-Gava","Miya","Taiwan Sign Language","Lao","Dalmatian","Ganang","Cornish","Tswana","Aweti","Dumbea","Bu (Bauchi State)","Chakavian","Mbonga","Salvadoran Sign Language","Kaivi","Hatam","Kuturmi","Yaqay","Unubahe","Sanuma","Razihi","Iyive","Hieroglyphic Luwian","Ndunga","Cun","Pacific Gulf Yupik","Western Penan","Kumzari","Labo Phowa","Tima","Rangpuri","Ouma","Juma","Aninka","Karami","Western Maninkakan","Taman (Indonesia)","Mudburra","Kupia","Sambal","Eman","Armenian","Nduga","Ugandan Sign Language","Halbi","Jamsay Dogon","Casiguran Dumagat Agta","Dghwede","Hitu","Kalamse","Kovai","Supyire Senoufo","Giiwo","Simbo","Daro-Matu Melanau","Olu'bo","Bagri","Southern Pumi","Zire","Nukumanu","Stod Bhoti","Muong","Southern Bobo Madare","Uighur","Dek","Libinza","Sininkere","Mabaale","Seroa","Bomboli","Kon Keu","Abe","Vunjo","Tringgus-Sembaan Bidayuh","Kayan Mahakam","Eastern Malayo-Polynesian languages","Anamgura","Matngala","Taupota","Nek","Akawaio","Maklew","Lolopo","Kera","Western Karaboro","Khetrani","Phuza","Votic","Kungarakany","Piu","Murrinh-Patha","Goemai","Birgit","Eritai","Gundungurra","Pitta Pitta","Gboloo Grebo","Ombo","Hutterite German","Hasha","Tunggare","Yirandali","Upper Chehalis","Southern Ngbandi","Jur Modo","Lubuagan Kalinga","Mmaala","Korana","Brunei","Wasembo","We Western","Logorik","Ngatik Men's Creole","Kinabalian","Lakkia","Weh","Khengkha","Alacatlatzala Mixtec","Alor","Lotha Naga","Shanga","Dharuk","Sara Kaba","Western Sisaala","Buol","Eastern Qiandong Miao","Mato Grosso Arara","Nyamusa-Molo","Yamdena","Bulu (Cameroon)","Likum","Momina","Kono (Guinea)","Guiberoua Bete","Plautdietsch","Ijo languages","Woria","Ngandyera","Barbareno","Amami Koniya Sign Language","Guana (Paraguay)","Tene Kan Dogon","Merey","Ebrie","Central Masela","Kalao","Ter Sami","Santo Domingo Albarradas Zapotec","Bolondo","Jalkunan","Old Lithuanian","Tumtum","Larevat","Hebrew","Karao","Sukuma","Bamako Sign Language","Nokuku","Yaroame","Foodo","Walla Walla","Nadruvian","Apalai","Duya","Tuwuli","Rapa","Vanimo","West Tarangan","Dahalik","Kpati","Koyo","Gahri","Chiru","Kango (Bas-Uele District)","Ngombe (Central African Republic)","Zaachila Zapotec","Biyo","Ga","Marachi","Iban","Temoaya Otomi","Gorontalo","Aheu","Tejalapan Zapotec","Duwai","Kuanyama","Pauri Bareli","Hupa","Kariyarra","Texcatepec Otomi","Puquina","Uru-Eu-Wau-Wau","Laragia","Myene","Miraya Bikol","Huichol","Mayogo","Tonsea","Lahanan","Trinidadian Creole English","Amurdak","Buna","Tal","Northwest Pashai","Bon Gula","Tezoatlan Mixtec","Monde","Moken","Bete-Bendi","Hema","Pingelapese","Efutop","Hya","Mongol","Batak Karo","Kang","Southeastern Kolami","Mada (Cameroon)","Weyto","Amis","Lakurumau","Litzlitz","Majukayang Kalinga","Tabaru","Wathawurrung","Eastern Canadian Inuktitut","Bana","Mapidian","Mlahso","Khaling","Benabena","Muduga","Zhang-Zhung","Southern Kurdish","Goundo","Urumi","Sassarese Sardinian","Koonzime","Jere","Romance languages","Karore","Greek, Modern (1453-)","Northern Guiyang Hmong","Tai Dam","Tuvalu","Balinese","Ida'an","Kantosi","Ong","Putai","Mag-Indi Ayta","Nyore","Ahtena","Udi","Ambelau","Basa","Mahasu Pahari","Rarotongan","Molbog","Arop-Lokep","Nimanbur","Urubu-Kaapor","Welaun","Mwali Comorian","Ruuli","Ruga","Romano-Serbian","Tukudede","Remun","Jiiddu","Tavringer Romani","Awngthim","Western Totonac","Phudagi","Chumburung","Anal","Langue des signes de Belgique Francophone","Dogose","Awa (China)","Wik-Keyangan","Chocangacakha","Buli","Adamawa Fulfulde","Yaka (Congo)","Kurudu","Nyaturu","Furu","Pogolo","Sonsorol","Jemez","Asoa","Jingulu","Nepalese Sign Language","Afro-Asiatic languages","Tucano","Central Nicobarese","Principense","Rembarrnga","Toura (Papua New Guinea)","Pataxo Ha-Ha-Hae","Ledo Kaili","Suoy","Woi","Banao Itneg","Shuar","Southern Ping Chinese","Cishingini","Bugawac","Lubu","Sogdian","Nyenkha","Nedebang","Gabi-Gabi","Sonha","Lamkang","Khamnigan Mongol","Ndrulo","Buruwai","Kuanua","Balanta-Ganja","Miqie","Edomite","Central Palawano","Paulohi","Mikasuki","Selian","Dalabon","Sota Kanum","Tontemboan","Twents","Salampasu","Ache","Havasupai-Walapai-Yavapai","Atohwaim","Wendat","Sasak","Limi","Portuguese","Wara","Arikapu","Boro (Ghana)","Na-Dene languages","Wotjobaluk","Taita","Iloko","Umbindhamu","Enxet","Cebaara Senoufo","Embera-Baudo","Filipino","Baka (South Sudan)","Sacapulteco","Tanema","Erave","Sila","Capanahua","Natchez","Ciwogai","Papuan languages","Sanskrit","Marma","Northwestern Tasmanian","Southeastern Puebla Nahuatl","Tamagario","Kurukh","Dem","Seba","Dagbani","Madagascar Sign Language","Wichi Lhamtes Guisnay","Sha","Savosavo","Dutch","Kinamiging Manobo","Godwari","Chimborazo Highland Quichua","Itonama","Day","Lidzonka","Geba Karen","Kumam","Duungooma","Vamale","Kungardutyi","Eastern Maroon Creole","Quileute","Budeh Stieng","Etulo","Igede","Songlai Chin","Karkin","Mogofin","Tatuyo","Sawi","Kapinawa","Canichana","Mandan","Tita","Tulai","Muskum","Dagaari Dioula","Yessan-Mayo","Tamazola Mixtec","Mid Grand Valley Dani","Sani","Kizamani","Ixil","Wuzlam","Barambu","Wandala","Amba (Solomon Islands)","Pisidian","Sidamo","Siyin Chin","Mid-Southern Banda","Banda-Mbres","Tai languages","Aghem","Samay","Yangum Dey","Okpe (Southwestern Edo)","Tuxinawa","Toaripi","Manangkari","Wojenaka","Pwapwa","Batad Ifugao","Rejang Kayan","Nasal","North Slavey","Baatonum","Kamo","Pari","Yabem","Santa Ines Ahuatempan Popoloca","Coatepec Nahuatl","Timne","Umiida","War-Jaintia","Mesaka","Sicilian","Mandjak","Tagoi","Mayoyao Ifugao","Kabore One","Mogum","Altaic languages","Khinalugh","Loma (Liberia)","Gana","Lenca","Wedau","Ndonde Hamba","Varisi","Doyayo","Garifuna","Lari","Dupaninan Agta","Balaibalan","Berakou","Swedish","Ancient Hebrew","Tonga (Tonga Islands)","Costa Rican Sign Language","Itik","Konso","Lafofa","North Watut","Karo (Ethiopia)","Segai","Veluws","Mingang Doso","Ghodoberi","Mushungulu","Komba","Bijim","Maeng Itneg","Highland Totonac","Caucasian languages","Feroge","Lese","Machame","West Bengal Sign Language","Lemnian","Stoney","Bierebo","Odiai","Mukulu","Pwo Eastern Karen","Iyo'wujwa Chorote","Bole","Toromono","Lokoya","Uzbek","Pirlatapa","Napo Lowland Quechua","Written Oirat","Gbesi Gbe","Enggano","Northern Haida","Nauru","Iatmul","Fanbak","Gade","Mo'da","Southern Nambikuara","Japanese (family)","Jarai","Oromo","Honduras Sign Language","Maritime Sign Language","Asu (Nigeria)","Slovak","Bangala","Ketengban","Alege","Pesse","Gowlan","Ngambay","Kpasam","Ak","Mala (Papua New Guinea)","Old Georgian","Tedim Chin","Bali (Nigeria)","Mindiri","Berti","Dibiyaso","Otomian languages","Mum","Hulaula","Chinese Pidgin English","Ainbai","Ai-Cham","Abure","Kaduo","Qaqet","Bankon","Lengo","Tsikimba","Hmong Njua","Dahalo","Rapanui","Cappadocian Greek","Apma","Nimbari","Boga","Kohumono","Dadibi","Central Pame","Chinook","Catawba","North Bolivian Quechua","Saramaccan","Kalabra","Ju","Phala","Padoe","Grass Koiari","Chaldean Neo-Aramaic","Nahari","Bidiyo","Tabasco Nahuatl","Livvi","Tinputz","Mro-Khimi Chin","Xibe","Albanian Sign Language","Taman (Myanmar)","Ponyo-Gongwang Naga","Kamasa","Northern Tidung","Bambili-Bambui","Sabaean","Halia","Mednyj Aleut","Nepali (individual language)","Wannu","Eastern Huishui Hmong","Tiang","Kuruaya","Rajasthani","Jicarilla Apache","Dera (Nigeria)","Mitla Zapotec","Idon","Pana (Burkina Faso)","Plapo Krumen","Namuyi","Anii","Shuhi","Ahom","Abui","Asilulu","Kiorr","Gurani","Totoro","Mama","Hahon","Solos","West-Central Limba","Manambu","Khunsari","Halkomelem","Dabarre","Yeretuar","Kaibobo","Taworta","Bauria","Zemba","Jilim","Kambaira","Mysian","Khalaj","Soninke","Central Maewo","Rinconada Bikol","Yamna","Taloki","Seke (Vanuatu)","Meta'","Nganasan","Tampuan","Yanomami","Maricopa","Mono (Solomon Islands)","Bwe Karen","Mara Chin","Kayupulau","Elkei","Haitian Vodoun Culture Language","Ngundu","Sara Kaba Naa","Dameli","San Dionisio Del Mar Huave","Sonia","Ndunda","Keley-I Kallahan","Nukuini","Martha's Vineyard Sign Language","Munit","Bwile","Lower Nossob","Bishuo","Yardliyawarra","Munggui","Lyngngam","Isanzu","Kinyarwanda","Ma Manda","Shekkacho","Bebeli","Sikule","Achumawi","Yonaguni","Iguta","Lamnso'","Ukuriguma","Rempi","Woun Meu","Tai Nua","Brokkat","Lorediakarkar","Wandarang","Kui (India)","Sierra Negra Nahuatl","Karas","Yogad","Mbugu","Kis","Bajelani","Haryanvi","South Efate","Awa-Cuaiquer","Arawakan languages","Antakarinya","Cao Lan","Mape","Cocos Islands Malay","Turumsa","Hoyahoya","Bomwali","Gawar-Bati","Zulgo-Gemzek","Ngkalmpw Kanum","Eastern Oromo","Turkic languages","Aka-Cari","Ritharrngu","Kusunda","Central Sudanic languages","Kinaray-A","Kashubian","Teso","Holma","Luo (Cameroon)","Chuka","Usila Chinantec","Idere","Sara Kaba Deme","Kuku","Agarabi","Galibi Carib","Selangor Sign Language","Andra-Hus","Gitua","Lombo","Chakma","Gua","Tausug","Central Huishui Hmong","South Tairora","Ko","San Jeronimo Tecoatl Mazatec","Southwestern Huishui Hmong","Nisenan","Ndebele, South","Li'o","Kambiwa","Aheri Gondi","Dutch, Middle (ca.1050-1350)","Kabras","Laal","Moklen","Kungkari","Northern Puebla Nahuatl","Lojban","Eastern Huasteca Nahuatl","Tsimshian","Gyem","Wampar","Ngarrindjeri","Setaman","Mbo (Democratic Republic of Congo)","Moro","North Alaskan Inupiatun","Angaite","Kasanga","Chechen","Tabla","Standard Moroccan Tamazight","Mayangna","Geme","Manam","Zaparo","Margos-Yarowilca-Lauricocha Quechua","English, Middle (1100-1500)","Durop","Cayuga","Maleng","Hrangkhol","Dharumbal","Kerak","Amara","Inpui Naga","Coos","Bualkhaw Chin","Swati","Ndaka","Orokolo","Tsogo","Coeur d'Alene","Ogbah","Haigwai","Auyokawa","Pangutaran Sama","Efai","Nugunu (Cameroon)","Pazeh","Katcha-Kadugli-Miri","Kayabi","Kreye","Dizin","Yitha Yitha","Miju-Mishmi","Lao Naga","Mabaka Valley Kalinga","Eastern Highland Otomi","Yemsa","Eastern Egyptian Bedawi Arabic","Tupari","Sumbawa","Lilau","Juray","San Agustin Mixtepec Zapotec","Tahltan","Tembo (Motembo)","Mbere","Hadrami","Uisai","Ukpet-Ehom","Southern Pomo","Vlaams","Djangun","Kagulu","Kabuverdianu","Karang","Lycian","Deno","Campidanese Sardinian","Ternateno","Pye Krumen","Hungarian Sign Language","Nawdm","Huambisa","Afade","Beba","Brithenig","Papar","Eastern Meohang","Oloma","Yuki","Ligenza","Kipsigis","Shughni","Mapun","Eastern Xiangxi Miao","Kelengazxo Bozo","Kamberau","Bipi","Tso","Swahili (individual language)","Tutuba","Malay (individual language)","Congo Swahili","Uralic languages","Murui Huitoto","Sekani","Bakoko","Aneme Wake","Baka (Cameroon)","Lakota Dida","Bondum Dom Dogon","Kumiai","Kangean","Mussau-Emira","Butbut Kalinga","Cimbrian","Maring","Juruna","Trumai","Khorezmian","Rangkas","Andalusian Arabic","Baiso","Kango (Tshopo District)","Bushoong","Jah Hut","Popti'","Beli (South Sudan)","Mobumrin Aizi","Mpinda","Mofu-Gudur","Trans-New Guinea languages","Koro (Cote d'Ivoire)","South Lembata","Tlahuitoltepec Mixe","Korubo","Western Kayah","Rwa","Kobo","Koresh-e Rostam","Wikalkan","Danish Sign Language","Dhodia","Big Nambas","Hunzib","Imonda","Pfaelzisch","Laghu","Uru-Pa-In","Abron","Corongo Ancash Quechua","Lawu","Lemoro","Sar","Batak Mandailing","Mambae","Akuku","Longgu","Nilamba","San Juan Colorado Mixtec","Mwera (Nyasa)","Northeast Maidu","Bafanji","Marsian","Hiligaynon","Mel-Khaonh","Abellen Ayta","Ngamambo","Chimila","Kambaata","Akoose","San Luis Temalacayuca Popoloca","Sauri","Sarangani Manobo","Lehalurup","Sa'a","Camling","Jonkor Bourmataguil","Gozarkhani","Iroquoian languages","Lavukaleve","Bozaba","Minokok","Apurina","Chachi","Jebero","Raute","Alak","Uhami","Spanish","Barasana-Eduria","Hong Kong Sign Language","Morawa","Yirrk-Mel","Macaguan","Bagheli","Sirmauri","Melpa","Kituba (Democratic Republic of Congo)","Papapana","Laiyolo","Mao Naga","Kiliwa","Vao","Tapiete","Bade","Bidjara","Punan Aput","Hupde","Ts'un-Lao","Ditammari","Cacua","Nagarchal","Kopar","Masiwang","Murik (Malaysia)","Ati","Yala","Egypt Sign Language","Kok-Nar","Kpan","Klao","Palu'e","Juhoan","Hung","Dumpas","Kofyar","Safeyoka","Jiarong","Wayampi","Inari Sami","Bazigar","Rahambuu","Akar-Bale","Playero","Paama","Kwama","Skolt Sami","Gavar","Orya","Nzadi","Minriq","Nelemwa-Nixumwak","Naukan Yupik","Kunggari","Aka-Bea","Yafi","Dhungaloo","Parachi","Southeastern Nochixtlan Mixtec","Porohanon","Kabola","Kullu Pahari","Embu","Ossetian","Tee","Warembori","Nayini","Tubar","Timugon Murut","Yola","Tira","Upper Kinabatangan","Herero","Kaidipang","Yagara","Baga Kaloum","Finnish Sign Language","Pwo Western Karen","Nauete","Pisaflores Tepehua","Jaqaru","Kanjari","We Northern","Old Sundanese","Ukrainian Sign Language","Mbangwe","Krung","Loun","Noon","Wolane","Andoque","Rusyn","Disa","Mawa (Nigeria)","Chane","Yucuna","Kamwe","Tennet","Gbiri-Niragu","Greek, Ancient (to 1453)","Tetum","Tumbuka","Kenaboi","Hinduri","Hdi","Surubu","Utu","Mbesa","Kalispel-Pend d'Oreille","Otuho","Minoan","Phana'","Telefol","Khasi","Maya Samo","Yiddish","Wiradjuri","Fuyug","Ulukwumi","Ikhin-Arokho","Waigeo","Maca","Waata","Daakaka","Asue Awyu","Bodo (India)","Bumbita Arapesh","Kwaami","So","Bumthangkha","Mitlatongo Mixtec","Mopan Maya","Wetamut","Koropo","Vlax Romani","Irish","Taikat","Bitare","Gambera","Uma' Lung","Yawalapiti","Kwandu","Shilluk","Tuotomb","Nalu","Adara","Dongotono","Arifama-Miniafia","Tring","Latgalian","Aura","Makah","Mayeka","Naluo Yi","Coong","Pokoot","Ava-Canoeiro","Lanima","Hakha Chin","Oro","Okpamheri","Iranun (Malaysia)","Tamnim Citak","Arem","Lachiguiri Zapotec","Leti (Indonesia)","Adivasi Oriya","Cacaopera","Ambrak","Ngoni (Mozambique)","Kryts","Chipaya","Hpon","Tasawaq","Northeast Kiwai","Kacipo-Bale Suri","Yocoboue Dida","Austral","Neapolitan","Austro-Asiatic languages","Bilma Kanuri","Ncane","Lole","Adangbe","Avikam","Lunda","Wudu","Taiap","Kui (Indonesia)","Kashaya","Monzombo","Lushai","Jabuti","Itu Mbon Uzo","Q'anjob'al","Teke-Laali","Friulian","Kosarek Yale","Bina (Papua New Guinea)","Malayo-Polynesian languages","Baissa Fali","Nancere","Ngiemboon","Logol","Bolivian Sign Language","Sanggau","Northern Tasmanian","Meroitic","Harzani","Tangale","Tena Lowland Quichua","Mesqan","Surigaonon","Lahul Lohar","Sou Nama","Old Burmese","Sam","Laos Sign Language","Lydian","Chicomuceltec","Davawenyo","Teressa","Koneraw","Leinong Naga","Binukid","Didinga","Lak","Wamey","Inoke-Yate","Sri Lankan Creole Malay","Elamite","Tay Boi","Huaxcaleca Nahuatl","Mundari","Khehek","Chiltepec Chinantec","Chru","Evenki","Pictish","Ewage-Notu","Jiru","Sonaga","Muslim Tat","Faire Atta","Diuxi-Tilantongo Mixtec","Sangtam Naga","Tavoyan","Tapei","Baluchi","Kven Finnish","Como Karim","Bira","Central Mazahua","Mexican Sign Language","Quiotepec Chinantec","Etruscan","Aruamu","Hunnic","Taveta","Tecpatlan Totonac","Cross River Mbembe","Mpur","Befang","Angal Heneng","Phrygian","Eten","Sheni","Waxianghua","Bokmal, Norwegian","Aimaq","Amblong","Lamma","Wajarri","Mattole","Kufr Qassem Sign Language (KQSL)","Gbanziri","Arauan languages","Bouni","Australian Aborigines Sign Language","North Marquesan","Burduna","Keiyo","Chochotec","Ap Ma","Nenets","Nkonya","Sowanda","Simaa","Upper Taromi","Javindo","Busam","Tommo So Dogon","Galela","Iaai","Zauzou","Abadi","Mayaguduna","Ivatan","Marfa","Soqotri","Northwest Maidu","Bathari","Degenan","Hruso","Ata","Central Atlas Tamazight","Lakalei","Vwanji","Lemio","Girawa","Ha","Jahanka","Papiamento","Mongolian Sign Language","Kadu","Doko-Uyanga","Koho","Yutanduchi Mixtec","Tonga (Zambia)","Lamba","Huautla Mazatec","Gbanu","Okodia","Eastern Yiddish","Tonga (Nyasa)","Anufo","Pannei","Penrhyn","Biao","Nayi","Lubila","Nipsan","Vono","Shoo-Minda-Nye","Mungkip","Pnar","Haeke","Western Xiangxi Miao","Soli","Ilongot","Korlai Creole Portuguese","Awbono","Liberian English","Cicipu","Kunimaipa","Bangime","Lere","Guanche","Koorete","Gal","Agatu","Ngelima","Finnish","Guianese Creole French","Okolie","Salishan languages","Hobyot","Mondropolon","Ho","Kaningra","Araona","Nafi","Wapishana","Jangkang","Southern Sierra Miwok","Mpade","Baoule","Parkwa","Judeo-Italian","Western Neo-Aramaic","Ngala","Bantu languages","Bwaidoka","Mualang","Cherepon","Akebu","Paraujano","Baga Pokur","Kele","Marba","Bangubangu","Saisiyat","Mocho","Capiznon","Rathwi Bareli","Embera-Tado","Para Gaviao","Thulung","Wantoat","Occitan (post 1500)","Santa Ana de Tusi Pasco Quechua","East Nyala","Yamongeri","Lungga","Sukur","Ontenu","Maram Naga","Kanyok","Gadsup","Turkmen","Sembakung Murut","Onin Based Pidgin","Taje","Migaama","Lonwolwol","Moji","Tepinapa Chinantec","Crimean Tatar","Kujarge","Kuria","Kriol","Doso","Kimaragang","Banda-Bambari","Icelandic Sign Language","Lwalu","Sasaru","Sherpa","Media Lengua","Dengka","Noric","Nathembo","Makhuwa-Shirima","Guaja","Lombard","Koya","Pinotepa Nacional Mixtec","Sambe","Large Flowery Miao","Shahrudi","Kwaya","Bamukumbit","Kukele","Lealao Chinantec","Nauo","Terei","Kauwera","Baangi","Arpitan","Sangir","Waffa","Bepour","Rema","Smarky Kanum","Maa","Guyani","Bakole","Cumbric","Moksha","Wakhi","Lele (Democratic Republic of Congo)","Gadang","Byep","Ikpeng","Old Avar","Western Yiddish","Bantoanon","Tolowa","Arammba","Thangmi","Palaic","Lorang","Klamath-Modoc","Silopi","Tangut","Northern Frisian","Yatzachi Zapotec","Venda","Yemba","Chepang","North Central Mixe","Wayana","Vafsi","Phupa","Curonian","Uyajitaya","Naba","Bine","Southern Pame","Ndam","Arua (Rodonia State)","Zaghawa","Ekit","Chuanqiandian Cluster Miao","Southern Ghale","Apache languages","Saxwe Gbe","Dungmali","Nyengo","Zeem","Sapuan","Western Kanjobal","Gayo","Takwane","Ibani","Pattapu","Katua","Kuuku-Ya'u","Kwamera","Boikin","Gamit","Sepa (Indonesia)","Isthmus Zapotec","Marka","Kimre","Wadikali","Majhwar","Artificial languages","Ligurian","Bosnian","Rongga","Wangkumara","Guruntum-Mbaaru","Sangu (Tanzania)","Komodo","Kove","Francisco Leon Zoque","Wutunhua","Western Frisian","Onge","Port Sorell Tasmanian","Baniva","Boghom","Balo","Barok","Fiwaga","Bamileke languages","Waray","Kriang","Middle Newar","Southern Puebla Mixtec","Bungain","Kuwema","Zokhuo","Subi","Yugoslavian Sign Language","Wagi","Nggwahyi","West Ambae","Mori Atas","Gurung","Mixtepec Mixtec","Wasu","Laimbue","Tuki","Aikana","Matepi","Bemba","Old Ossetic","Pambia","Ratahan","Kuwaataay","Guro","Rungtu Chin","Surbakhal","Lahu Shi","Southern Conchucos Ancash Quechua","Kurdish","Sekpele","Belanda Viri","Bahnar","Kara (Central African Republic)","Kachin","Koromira","Siawi","Onondaga","Southern Amami-Oshima","Vengo","Ayiwo","Shina","Temacine Tamazight","Bonkeng","Wayuu","Powhatan","Guahibo","Mina (Cameroon)","Kwanja","Amanab","Ibuoro","Galeya","Tregami","Awing","Lower Ta'oih","Kachok","Jwira-Pepesa","Akha","Gimi (Eastern Highlands)","Punan Merap","Machiguenga","Gumalu","Panamint","Seeku","Fungwa","Amba (Uganda)","Eton (Cameroon)","Maritsaua","Pacahuara","Ipulo","West Central Banda","Eastern Gorkha Tamang","Jola-Fonyi","Songhai languages","Tewa (Indonesia)","Gula'alaa","Kota (Gabon)","Xingu Asurini","Bankagooma","Chitkuli Kinnauri","Tungag","Pa'o Karen","Cameroon Mambila","Bongu","Sauraseni Prakrit","Ewe","Dombe","Southern Nicobarese","Trinidad and Tobago Sign Language","Mawes","Aymara","Talodi","Adele","Wambaya","Otank","El Molo","Nkhumbi","Tarifit","Lu","Intha","Majera","Southwestern Tlaxiaco Mixtec","Iamalele","Marra","Wik-Mungkan","Batak languages","Kita Maninkakan","Animere","Snohomish","Wuding-Luquan Yi","Gowro","Dogri","Texmelucan Zapotec","Vaghri","Santiago del Estero Quichua","Mak (Nigeria)","Middle Watut","Central Bikol","Afrikaans","Uri","Bilba","Mawan","Caka","Daho-Doo","Parsi-Dari","Megleno Romanian","Huizhou Chinese","Parenga","Kunda","Danish","Ghomala'","Mgbolizhia","Semandang","Ma (Democratic Republic of Congo)","Quinault","Mlap","Dezfuli","Old Turkish","Tai","Saafi-Saafi","Chukot","Pech","Ura (Vanuatu)","Iowa-Oto","Yalalag Zapotec","Subtiaba","Kuni","Tay Tac","Sango","Nyika (Tanzania)","Tichurong","Mulaha","Semitic languages","Kuku-Mu'inh","Torres Strait Creole","Nkoroo","Keliko","Keapara","Yetfa","Sedoa","Toro Tegu Dogon","Ecuadorian Sign Language","Sorkhei","Kemi Sami","Sumerian","Quechan","Olkol","Teke-Tyee","South American Indian languages","Yautepec Zapotec","Interglossa","Kati","Phuong","Bassari","Nyabwa","Kodava","Bua","Limburgan","Guerrero Nahuatl","Macushi","Mangseng","Cacaloxtepec Mixtec","Kusu","Maii","Lamenu","Tadaksahak","Kouya","Serili","Bu (Kaduna State)","Pero","Philippine languages","Kanamari","Merei","Northern Ngbandi","Nafri","Budu","Khao","Ignaciano","Atatlahuca Mixtec","Sepik Iwam","Khah","Kok Borok","Ndamba","Songoora","Iha","Jamaican Country Sign Language","Krisa","Sichuan Yi","Zialo","Churahi","Tangkhul Naga (India)","Egyptian Arabic","Reunion Creole French","Poumei Naga","Volscian","Kusaghe","Karbi","Tachawit","Maindo","Tuamotuan","Pahlavani","Sabane","Romkun","Na-kara","Besoa","Toram","Multiple languages","Ukit","Ndo","Kakwa","Bukwen","Tawande","Tereweng","Middle Mongolian","Lawunuia","Eastern Abnaki","Kapriman","Pijao","Som","Djinba","Chala","Twi","Samei","Khisa","Classical Tibetan","Morrobalama","Kerek","Tafi","Yawiyo","Ngungwel","Coatzospan Mixtec","Judeo-Georgian","Bile","Sagala","Ngarigu","Dari","Adi","Marik","Spiti Bhoti","Beja","Glio-Oubi","Yankunytjatjara","Shi","Oscan","Nihali","Sebat Bet Gurage","Calderon Highland Quichua","Ipiko","Ke'o","Humene","Tingui-Boto","Standard Arabic","Kasem","Masadiit Itneg","Edopi","Arua (Amazonas State)","Tlacoatzintepec Chinantec","Pekal","Sowa","Tindi","Andegerebinha","Darai","South Picene","Northwestern Dinka","Prasuni","Doe","Lolak","Saruga","Phuma","Bekwel","Icelandic","Bactrian","Leelau","Western Mashan Hmong","Mochica","ut-Ma'in","Bhele","Wik-Iiyanh","Moabite","Bare","Foi","Central Kurdish","Manado Malay","Sicite Senoufo","Guarani","Kota Bangun Kutai Malay","Unami","Ban Khor Sign Language","Gresi","Chesu","Koasati","Mariri","Alyawarr","Margany","Makolkol","Tsucuba","Maori","Iberian","Yukpa","Usui","Bouna Kulango","Labuk-Kinabatangan Kadazan","Berau Malay","Ririo","Inuit Sign Language","Waris","Hawai'i Creole English","Ineseno","Asumboa","Nen","Veddah","Lama Bai","Rudbari","Tefaro","San Vicente Coatlan Zapotec","Nggem","Oroha","Kua","Suba-Simbiti","Shihhi Arabic","San Baltazar Loxicha Zapotec","Haroi","Koryak","Marovo","Pemon","Njalgulgule","Libon Bikol","Opata","Welsh","Kara (Korea)","Suku","Iquito","Mosimo","Aneityum","Yerukula","Khoibu Naga","Warnang","Tebul Ure Dogon","Southern Binukidnon","North Mesopotamian Arabic","Maco","Bwa","Totoli","Nyulnyul","Karkar-Yuri","Ngunawal","Kami (Nigeria)","North Wahgi","Mesmes","Nguluwan","Central Asmat","Cakchiquel-Quiche Mixed Language","Northwestern Nisu","Mpiemo","Palya Bareli","Eastern Mnong","Skepi Creole Dutch","Alutor","Braj","Mur Pano","Bara Malagasy","Kate","Mengisa","Sene","Barrow Point","Central Pashto","Magoma","Ruthenian","Bhatri","Manipuri","Mayan languages","Urak Lawoi'","Moloko","Ama (Sudan)","Kein","Loloda","Biem","Gimi (West New Britain)","Ngete","Korafe-Yegha","Fang","Inga","Khamti","Karipuna Creole French","Eki","Agusan Manobo","Womo","Tumulung Sisaala","Babango","Monumbo","Waimiri-Atroari","Nigerian Pidgin","Temiar","Walmajarri","Aringa","Tay","Yareni Zapotec","Ekari","Chukwa","Nyindu","Sunwar","Burundian Sign Language","Tohono O'odham","Tesaka Malagasy","Rennell-Bellona","Comox","Western Lawa","Cuba Sign Language","Nkari","Andaandi","Larteh","Kanu","Chittagonian","Kaxuiana","Grangali","Xokleng","Muyuw","Pengo","Pudtol Atta","Nuer","Marwari (India)","Yora","Bomboma","Western Balochi","Galo","Pampanga","Muthuvan","Maia","Red Gelao","Meoswar","Kou","Ngawn Chin","Ternate","Lanoh","Hunsrik","Amatlan Zapotec","Mpotovoro","Laka (Chad)","Kolibugan Subanon","Opao","Squamish","Chichimeca-Jonaz","Ardhamagadhi Prakrit","Quebec Sign Language","Gela","Kaeku","Yameo","Hertevin","Alacalufan languages","Southern Birifor","Anong","Yaul","Wapan","Isconahua","Kilmeri","Kabutra","Esan","Kickapoo","Matagalpa","Wunai Bunu","Tagabawa","Resigaro","Orizaba Nahuatl","Natioro","North Moluccan Malay","Alune","Masalit","Emilian","East Yugur","Musi","Kadung","Tagalog","Central Aymara","Biangai","Musgu","Highland Puebla Nahuatl","Tsum","Secoya","Cushitic languages","Pemono","Abkhazian","Eastern Minyag","Ngantangarra","Chakali","Tawara","Wirafed","Talu","Southern Nuni","Semimi","San Francisco Matlatzinca","Bima","Malango","Tumleo","Kumalu","Duhwa","Khotanese","Southern Qiandong Miao","Gao","Kazukuru","Nanti","Elu","Tupinikin","Lango (Uganda)","Tulehu","Gweda","Riang (India)","Tobelo","Wom (Papua New Guinea)","Karaja","Senggi","Hmong","Andaqui","Giyug","Caquinte","Tz'utujil","Atikamekw","Mbato","Ikwere","Bamenyam","Dyaberdyaber","Majang","Bahing","Gugu Warra","Mezontla Popoloca","Serrano","Semelai","Jejara Naga","Darkinyung","Ejagham","Nomatsiguenga","Usku","Vili","Wiyot","Torau","Urum","Waama","Polish Sign Language","Fwe","South Azerbaijani","Phalura","Yurok","Gaa","Wagaya","Anasi","Coatlan Mixe","Poke","Etebi","Yazgulyam","Guibian Zhuang","Dyula","Pass Valley Yali","Alangan","Sindihui Mixtec","Unua","Kol (Bangladesh)","Gofa","Nyeu","Southwest Gbaya","Morori","Mendankwe-Nkwen","Beli (Papua New Guinea)","Ghulfan","Tokelau","Shom Peng","Arequipa-La Union Quechua","Doga","Tuwali Ifugao","Shipibo-Conibo","Ukwa","Pom","Gane","Kwalhioqua-Tlatskanai","Niksek","Cinda-Regi-Tiyal","French, Middle (ca.1400-1600)","Northern Tlaxiaco Mixtec","Tsuvadi","Northern Dagara","Umbu-Ungu","Tjurruru","Paasaal","Lingao","Lusitanian","Tanudan Kalinga","Bukitan","Harsusi","Ta'izzi-Adeni Arabic","Parawen","Ndambomo","Turung","Dinka","Lyele","Waritai","Boguru","Tiwi","Zaza","Sumariup","Pawaia","Piya-Kwonci","Samogitian","Jogi","Sawknah","Ndoola","Tause","Sudanese Creole Arabic","Gambian Wolof","Kamoro","Romany","Kunigami","Sign Languages","Seluwasan","Xiang Chinese","Beezen","Bagusa","Alanic","Northern Sorsoganon","Dimasa","Tiale","Mandara","Katawixi","Eviya","Wampanoag","Chuave","Oki-No-Erabu","Igwe","Western Meohang","Spokane","Wergaia","Pahanan Agta","Laopang","Rengao","New Caledonian Javanese","Kwami","Chadong","Kw'adza","Berber languages","Bandi","La'bi","Reshe","Kiunum","Iranian languages","Shatt","Dongxiang","Gudanji","Nakanai","Esselen","Jandai","Kanan","Gurmana","Oko-Eni-Osayen","Thai Sign Language","Mada (Nigeria)","Guya","Gebe","Kaqchikel","Bentong","Chamalal","Yabong","Voro","Liberia Kpelle","Ket","Kumyk","Kamakan","Ma (Papua New Guinea)","Kendeje","Thai","Taushiro","Lavatbura-Lamusong","Agoi","Kandawo","Chorasmian","Miship","Gengle","Lutos","Erre","Vaagri Booli","Bookan","Bakaka","Pela","Piratapuyo","Caribbean Javanese","Mbelime","Kukna","Luwo","Gobu","Changriwa","Otoro","Jumli","Arbereshe Albanian","Cogui","Yis","Uma' Lasan","Dhurga","Venetian","Shahmirzadi","Kais","Riang Lai","Bina (Nigeria)","Moyon Naga","Notre","Chrau","Northern Luri","Siroi","Kabwa","Chaima","Gothic","Tampulma","Lango (South Sudan)","Andarum","Nanubae","Komi-Permyak","Siar-Lak","Central Mnong","Yinhawangka","Tembo (Kitembo)","Olrat","Buriat","Northwestern Kolami","Bindal","Avestan","Mbunga","Nawathinehena","Yiningayi","Ngiti","Kelon","Kesawai","Maridan","Katkari","Ngbaka","Zyphe Chin","Bobot","Dominican Sign Language","Lele (Papua New Guinea)","Miami","East Limba","Boma","Kapin","Ede Ije","Kudu-Camo","Waioli","Arabic","Blang","Chimalapa Zoque","Dutch Sign Language","Manem","Copainala Zoque","Rufiji","Kabwari","Aputai","Rang","Pere","Savi","Western Bolivian Guarani","Baga Manduri","Tagargrent","Jumjum","Ixcatec","Surui","Tiri","Kaxarari","Awun","Yatee Zapotec","Bumaji","Sora","Dulbu","Parakana","Manx","Old Tamil","Roviana","Kahua","Hu","Komo (Sudan)","Ketum","Kunbarlang","Bungu","Ludian","Border Kuna","Xakriaba","Apatani","Razajerdi","Honi","Ahirani","Berta","Marwari","Wichi Lhamtes Vejoz","Yurats","Baetora","Abanyom","Galician","Mbya Guarani","Long Phuri Naga","Koromfe","Kashmiri","Youjiang Zhuang","Donno So Dogon","Amahuaca","Amharic","Koluwawa","Dendi (Benin)","Mbukushu","Guinean Sign Language","Kannada","Samburu","Nukna","Nimboran","Mambwe-Lungu","Wintu","Kpessi","Djadjawurrung","Eastern Sudanic languages","Tetserret","Ngan'gityemerri","Port Vato","Siberian Tatar","Pali","Negidal","Pushto","Aka","So (Democratic Republic of Congo)","East Makian","Peripheral Mongolian","Yoke","Dan","Halang","Alugu","Ravula","Casuarina Coast Asmat","Ixtayutla Mixtec","Abishira","Lozi","Tii","Daur","Dicamay Agta","Neo-Hittite","Nkoya","Pilaga","Warji","Binumarien","Rajbanshi","Ayizi","Wakashan languages","Eyak","Auye","Sulka","Ormuri","Tauya","Northern Yukaghir","Mafa","Dugwor","Izii","Bilbil","Phrae Pwo Karen","Gamkonora","Southwest Palawano","Selayar","Pindiini","Mortlockese","Tugutil","Torona","Namiae","Dibabawon Manobo","Mende","Chamacoco","Nyaheun","Queyu","Iranun (Philippines)","Cemuhi","Masmaje","Jukun Takum","sTodsde","Wadjabangayi","Tol","Tongwe","Aloapam Zapotec","Ramopa","Kaur","Banyjima","Khayo","Kepo'","K'iche'","Cahuilla","South Bolivian Quechua","Tetete","Sochiapam Chinantec","Bayali","Basque","Colorado","Ormu","Dii","Monastic Sign Language","Dambi","Yau (Sandaun Province)","Gwahatike","Kutu","Tem","Interlingua (International Auxiliary Language Association)","Uzbeki Arabic","Frankish","Lobi","Bodo Parja","Soyaltepec Mazatec","Mangue","Aimele","Straits Salish","Louisiana Creole","Zenzontepec Chatino","Ranglong","Teke-Fuumu","Lasgerdi","Wipi","Malas","Soo","Ixcatlan Mazatec","Emumu","Brao","Japanese Sign Language","Rampi","Kwerba Mamberamo","Konyak Naga","Menik","Potawatomi","Birri","Burun","Datooga","Akwa","Turks And Caicos Creole English","Salar","Nomane","Pedi","Kuan","Polabian","Viti","Gayil","Bonggi","New Zealand Sign Language","Tupi languages","Western Malayo-Polynesian languages","Garza","Eastern Bru","Manza","Harijan Kinnauri","Kotafon Gbe","Whitesands","Pacaraos Quechua","Literary Chinese","Amele","Safwa","Syriac","Garlali","Turkish","Tahitian","Lowland Tarahumara","Lakota","Old Japanese","Lamaholot","Deccan","Kanauji","Shama-Sambuga","Paku","Wali (Sudan)","Yupik languages","Moyadan Itneg","Duano","Aribwaung","Bench","Kalarko","Matis","Mba","Matal","San Pedro Quiatoni Zapotec","Moikodi","Akaselem","Anem","Yaleba","Pokomo","Danaru","Saudi Arabian Sign Language","Uvbie","Marenje","Minkin","Southeastern Tepehuan","Judeo-Persian","Tugen","Wakabunga","Kuranko","Saluma","Puluwatese","Wirangu","Tomoip","Krikati-Timbira","Al-Sayyid Bedouin Sign Language","Yangum Gel","Matses","Central Pomo","Nsongo","Dyan","Ngalum","Tase Naga","Molengue","Minang","Lika","Dengese","Western Lalu","Buhutu","Loja Highland Quichua","Wajuk","Kuvi","Wagawaga","Kakabe","Qila Muji","Malaccan Creole Malay","Tutelo","Mukha-Dora","Wadjiginy","Azha","Eastern Arrernte","Pinai-Hagahai","Jimi (Nigeria)","Riung","Matya Samo","Shona","Northern Ohlone","We Southern","Gbii","Ayautla Mazatec","Nambo","Anuak","Deni","Roma","Mokilese","Guwamu","Gurdjar","Maaka","Gwa","Tremembe","Gagu","Akuntsu","Small Flowery Miao","Andoa","Keningau Murut","Ughele","Kol (Papua New Guinea)","Emerillon","Ponosakan","Khuen","Fum","Fanamaket","Iteri","Southwestern Tepehuan","Cambodian Sign Language","Bribri Sign Language","Koenoem","Phom Naga","Tawala","Pagu","Tayart Tamajeq","Gbayi","Tetelcingo Nahuatl","Wersing","Chuvash","Camtho","Panawa","Urapmin","Teke-Ebo","Liujiang Zhuang","Indonesian Bajau","Agutaynen","South Awyu","Baha Buyang","Manombai","Kala Lagaw Ya","Budibud","Miriwoong Sign Language","Surui Do Para","Rapoisi","Oya'oya","Zacatlan-Ahuacatlan-Tepetzintla Nahuatl","Esimbi","Awngi","Tunisian Sign Language","Gyele","Gumatj","Kayagar","Eastern Magar","Tchumbuli","Nubi","Ese Ejja","Ho Chi Minh City Sign Language","Sa'och","Tondano","Antigua and Barbuda Creole English","Yaeyama","Baruya","Chiapanec","Woiwurrung","Rathawi","Wunumara","Ejamat","Lewotobi","Lundayeh","Chinese","Northern Hindko","Ronga","Nama (Papua New Guinea)","Mohegan-Pequot","Ubang","Blablanga","Tajuasohn","Kawi","Zan Gula","Pamona","Dawera-Daweloor","Mocheno","Ona","Temascaltepec Nahuatl","Namonuito","Chagatai","Aproumu Aizi","Isnag","Buru (Indonesia)","Koshin","Gun","Kabatei","Assyrian Neo-Aramaic","Ajyininka Apurucayali","Northern Amami-Oshima","Paite Chin","Mazatlan Mixe","Meramera","Babanki","Doutai","Chiquian Ancash Quechua","Gone Dau","Evant","Pahi","Mansaka","Celtic languages","Yarluyandi","Mmen","Enawene-Nawe","El Nayar Cora","Vanuma","Ngaju","Abureni","Havu","Surjapuri","Morigi","Ungkue","Mboko","Bacanese Malay","Seselwa Creole French","Landoma","Kapya","Bonerate","Yagua","French Sign Language","Ehueun","Guana (Brazil)","Mising","Ancient Macedonian","Gbaya-Bozoum","Papua New Guinean Sign Language","Southern Bontok","Thuri","Burmeso","Kunduvadi","Mangareva","Sicanian","Irula","Shwe Palaung","Kwerba","Santa Maria Del Mar Huave","Toposa","Nupode Huitoto","Lembena","Kajali","Waddar","Khlula","Haida","Achinese","Humla","Bolongan","Idi","Kuot","Loxicha Zapotec","Ben Tey Dogon","Ambul","Hanga","Rao","Andio","Kumbaran","Norn","Komering","Hemba","Kandas","Gogo","Hani","Choctaw","Chinese Sign Language","Eastern Frisian","Simba","Knaanic","Tobo","Southern Yamphu","Hungu","Laha (Viet Nam)","Gobasi","Barein","Lagwan","Magdalena Penasco Mixtec","Mom Jango","Aiton","Dai Zhuang","Siamou","Orejon","Fijian","Yuyu","Samosa","Bororo","Kamang","Ami","Dubu","Tanjijili","Dime","Kom (Cameroon)","Gaam","Ebughu","Goo","Pennsylvania German","Wogamusin","Mombo Dogon","North Tairora","Singa","Nzakara","Gyalsumdo","Norwegian Sign Language","Babatana","Xishanba Lalo","Yandruwandha","Judeo-Berber","Takuu","Tinani","Ampanang","Hako","Kho'ini","Creoles and pidgins, Portuguese-based","Logooli","Aghu","Remo","Kung-Ekoka","Oorlams","Sierra de Juarez Zapotec","Middle Korean (10th-16th cent.)","Kaera","Rutul","Yei","Cabiyari","Kalkutung","Sibu Melanau","Gumawana","Wan","Ladino","E","Wali (Ghana)","Saluan","Koba","Ramoaaina","Kuku-Yalanji","Washo","Chickasaw","Apiaka","Shuadit","Col","Candoshi-Shapra","Chinali","Huehuetla Tepehua","Kuwaa","Bella Coola","Emae","Orok","Jamaican Creole English","Rayon Zoque","Kajakse","North Muyu","Maskelynes","Pitjantjatjara","Ata Manobo","Ido","Medebur","Niger-Kordofanian languages","Bhadrawahi","Nyiha (Tanzania)","Tirmaga-Chai Suri","Rongmei Naga","Morokodo","Makhuwa-Meetto","Kunama","Adiwasi Garasia","Koro Nulu","Nkami","Tagakaulo","Mru","Gerai","Mekeo","Amarakaeri","Bodo (Central African Republic)","Tombonuo","Sampang","Laeko-Libuat","Alapmunte","Biatah Bidayuh","Mouk-Aria","Are","Breton","Bati (Cameroon)","Kalumpang","Ndoe","Fipa","Eastern Katu","Alladian","Kusaal","Ibino","Gan Chinese","Kathu","Old Dutch","Abau","Neme","Korean Sign Language","Keder","Northeastern Pomo","Land Dayak languages","Mefele","Bahinemo","Panjabi","Bariji","Saba","Karuwali","Ayacucho Quechua","Kaikavian Literary Language","Plateau Malagasy","Darmiya","Papasena","Latu","Somrai","Mator","Biwat","Asuri","Niuafo'ou","Barababaraba","Mardin Sign Language","Dyirbal","Nete","Hula","Alumu-Tesu","Kutong","Svan","Bebil","Kalanguya","Biafada","Avokaya","Centuum","Lolo","Zabana","Enrekang","Lau","Eastern Tamang","Mulam","Kota (India)","Gumuz","Avau","Eteocypriot","Khmu","Mansoanka","Algerian Arabic","Pyapun","Tulu","Baba","Lamatuka","Yaosakor Asmat","Miyobe","West Berawan","Siliput","Gugu Badhun","Hibito","Defaka","Gadjerawang","Mon-Khmer languages","Upper Guinea Crioulo","Dongshanba Lalo","Ede Ica","Eastern Lawa","Sara","Shelta","Dom","Miskito","Mawayana","Luxembourgish","Ngurimi","Dargwa","Brem","Wala","Karaim","Kundal Shahi","Central Mashan Hmong","Mintil","Yanahuanca Pasco Quechua","Lower Sorbian","Kanoe","Makassar Malay","Afro-Seminole Creole","Amarasi","Ndemli","Iduna","Tsimihety Malagasy","Dungra Bhil","Duna","Eteocretan","Bokoto","Highland Popoluca","Viemo","Saliba","Campalagian","Southern Puget Sound Salish","Taabwa","Central Ojibwa","Minz Zhuang","Potiguara","Maiani","Tanimuca-Retuara","Buyuan Jinuo","Kalapuya","En","Bayungu","Ulithian","Tundra Enets","Huamalies-Dos de Mayo Huanuco Quechua","Budong-Budong","Cajamarca Quechua","Woccon","Manichaean Middle Persian","Central Tarahumara","Kota Marudu Talantang","Tawr Chin","Momuna","Vera'a","Tsamai","Classical Syriac","Zo'e","Mutu","Taulil","Laki","Warao","Lega-Shabunda","Plains Cree","Tsou","Kagan Kalagan","Moroccan Sign Language","Central Yupik","Kurnai","Nde-Nsele-Nta","Soi","Gbaya","Juxtlahuaca Mixtec","Sari","Ngarla","Yasa","Maraghei","Caddoan languages","Oluta Popoluca","Ndom","Bantik","Yelmek","Lipan Apache","Ralte","Warumungu","Acheron","Southern Pastaza Quechua","Marrithiyel","Negerhollands","Koroshi","Inor","Kwadi","Na-Meo","Kaningdon-Nindem","Qashqa'i","Morom","Kalanga","Turi","Wolof","Saidi Arabic","Tboli","Purepecha","Jehai","Russia Buriat","Mundani","Awabakal","Piaroa","Ngasa","Sumtu Chin","Vale","Gana","Dijim-Bwilim","Aranama-Tamique","Isarog Agta","Me'en","Pirriya","Quenya","Yoba","Pawnee","Atayal","Maba (Chad)","Ndai","Kare (Papua New Guinea)","Chitwania Tharu","Hokan languages","Nigerian Sign Language","Ukue","Bedoanas","Dar Fur Daju","Uneapa","Mayo","Piti","Kwakum","Karamojong","Vures","Kawe","Likuba","Italic languages","Iresim","Jenaama Bozo","Achuar-Shiwiar","Namia","Fam","Biritai","Coast Miwok","Western Juxtlahuaca Mixtec","Matipuhy","Giryama","Mungaka","Pyu (Myanmar)","Gola","Anca","Kobol","Algerian Sign Language","Dhao","Chilean Sign Language","Southwestern Nisu","Bakpinka","Tambas","Songe","Timor Pidgin","Koiwat","Kwa","West Masela","Wanukaka","Tukumanfed","Polish","Kaska","Isthmus-Mecayapan Nahuatl","Kensiu","Mamanwa","Tai Loi","Keyagana","Lingala","Dewoin","Embera-Chami","Iwam","Daza","Firan","Waiwai","Anjam","Lisu","Izon","Kanggape","Gaina","Vilela","Konkani (individual language)","Alamblak","Ngamini","Ometepec Nahuatl","Classical Mongolian","Sangu (Gabon)","Ullatan","Ayabadhu","Kiput","Mbessa","Nobonob","Lugbara","Tawallammat Tamajaq","Aighon","Lola","Tamanaku","Kwasio","Cholon","Yele","Coatecas Altas Zapotec","Konzo","Ocaina","Lengilu","Chantyal","Bafia","Wanga","Gidar","Kpagua","Ubaghara","Paunaka","Bhujel","Nyam","Arikem","Kayort","Northern Tiwa","Northern Kissi","Kwerisa","Judeo-Tripolitanian Arabic","Amdang","Fwai","Western Parbate Kham","Subiya","Marghi Central","Napu","Bonkiman","Sindhi Bhil","Maremgi","Sedang","Seze","Mpoto","Kamano","Central Bai","Hadza","Kaonde","San Mateo Del Mar Huave","Chalikha","Tumi","Dungu","Galambu","Western Armenian","Sou","Sanga (Nigeria)","Embaloh","Kuku-Ugbanh","Ujir","Dela-Oenale","Haitian","Dogul Dom Dogon","Gweno","Katbol","Xaracuu","Istro Romanian","Huachipaeri","Wolio","Dhofari Arabic","Ani Phowa","Gurr-goni","Bukar-Sadung Bidayuh","Iau","Akkadian","Kibiri","South Ucayali Asheninka","Saaroa","Huli","Veps","Idate","Timbe","Eastern Muria","Southern Haida","Doka","Rwandan Sign Language","Nhuwala","Gungabula","Nomlaki","Uruangnirin","Mamara Senoufo","Angaataha","Kowaki","Khumi Chin","Nindi","Adilabad Gondi","Kuo","Homa","Bada (Nigeria)","Mayawali","Bainouk-Gunyuno","Temein","Duma","Qatabanian","Gula (Central African Republic)","Lobala","Ginuman","Wusi","Bassa-Kontagora","Arawum","Ngad'a","Nukak Maku","Wapha","Phu Thai","Semnani","Lahu","Makhuwa-Moniga","Bukit Malay","Siouan languages","Duke","Agi","Jaunsari","Wanggamala","Kyanga","Zari","Taruma","Winye","Suena","Huitepec Mixtec","Pal","Columbia-Wenatchi","Kedang","Dogri (individual language)","Breri","Moi (Indonesia)","Old Frisian","Tabasco Chontal","Minderico","Bube","Wotapuri-Katarqalai","Yimas","German Sign Language","Fang (Cameroon)","Nankina","Northern Pumi","Central Tagbanwa","Sissala","Kariri-Xoco","Tewe","Moose Cree","Kayapo","Simeulue","Bunak","Memoni","Asheninka Pajonal","Yamphu","Cisalpine Gaulish","Sambalpuri","Sabah Bisaya","Georgian","Gudang","Elseng","Nyemba","Egyptian languages","Golpa","Ende","Southern Bai","Greek languages","Wadi Wadi","Narragansett","Malayalam","Tokharian B","Tagish","Angosturas Tunebo","Turiwara","Anus","Wandji","Laadan","Southern Rincon Zapotec","Sentinel","Garrwa","Ika","Chibchan languages","Western Tlacolula Valley Zapotec","Adnyamathanha","Saponi","Valpei","Lusengo","Gedaged","Narom","Amdo Tibetan","Zangskari","Labir","Bauzi","Shoshoni","Sonde","Indo-European languages","Haiphong Sign Language","Ao Naga","Kura Ede Nago","Sian","Southwestern Bontok","Mbara (Australia)","Chuvantsy","Wemale","Laven","Lala-Roba","Ocotepec Mixtec","Chichicapan Zapotec","Mayi-Kulan","Maranunggu","Ngemba","Moi (Congo)","Sapo","Siriono","Yapese","Nyong","Mamuju","Ulau-Suain","Kela (Democratic Republic of Congo)","Yilan Creole","Peve","Ntomba","Kildin Sami","Mok","Mochi","Nai","Lowland Oaxaca Chontal","Formosan languages","Ngwe","Gbaya (Sudan)","Kambera","Avaric","Beothuk","Old Marathi","Santa Maria Quiegolani Zapotec","Buglere","Dorze","Parauk","Aka-Bo","Leningitij","Middle Khmer (1400 to 1850 CE)","Swiss-French Sign Language","Tikar","Aore","Arritinngithigh","Ngul","Malecite-Passamaquoddy","Kwere","Ghotuo","Kilivila","Ot Danum","Guevea De Humboldt Zapotec","Embera-Catio","Persian, Old (ca.600-400 B.C.)","Saleman","Luyia","Ngbee","Biga","Ngandi","Penang Sign Language","Manikion","Old Malay","Bukharic","Moru","Zarma","South Caucasian languages","Kemtuik","Khvarshi","Batjala","Bonggo","Mapoyo","Nawuri","Batak Dairi","North Caucasian languages","Kalmyk","Banda-Yangere","Waboda","Mariyedi","Qawasqar","Alawa","Mese","Bagupi","I-Wak","Magyi","Southeast Pashai","Saurashtra","South African Sign Language","Balkan Romani","Dobu","Kathoriya Tharu","Manumanaw Karen","Callawalla","Lahnda","Lacandon","Nauna","Nyawaygi","Sheshi Kham","Laura","Fali","Mendalam Kayan","Gamo","Lamang","Kuke","Punan Batu 1","Khoisan languages","Western Minyag","Nganyaywana","Fulnio","Bolango","Atsahuaca","Tzeltal","Western Arrarnta","Athapascan languages","Bian Marind","Minanibai","Wamin","Khams Tibetan","Muinane","Oune","Romanian Sign Language","Tangko","Curripaco","Nicaraguan Sign Language","Kplang","Reserved for local use","Paafang","Chimariko","Korku","Saho","Southern Uzbek","Nefamese","Karankawa","Israeli Sign Language","Lumbu","Kirghiz","Oneida","Petats","Tofin Gbe","Waima","Jakun","Yucuane Mixtec","Selepet","Kaytetye","Min Nan Chinese","Legenyem","Luchazi","Efik","Satere-Mawe","Gagadu","Githabul","Gail","Puma","Benyadu'","Valle Nacional Chinantec","Nahali","Naasioi","Kochila Tharu","Central Malayo-Polynesian languages","Bulgebi","Sausi","Northern Uzbek","Zande (individual language)","Mbole","Miyako","Mufian","Wayanad Chetti","Yoidik","Kwamtim One","Wik-Me'anha","Kara (Papua New Guinea)","Wichita","Tsimane","Mangala","Sehwi","Tsaangi","Magahi","Ibatan","Bijori","Buli (Indonesia)","Birrpayi","Yukuben","Western Muria","Tho","Mazagway","Toba","Maithili","Berinomo","Agwagwune","Tangkhul Naga (Myanmar)","Maridjabin","Bo-Ung","Hadrami Arabic","Southern Aymara","Matukar","Modole","Chambri","Classical Armenian","Tagal Murut","Croatian","Lala-Bisa","Wabo","Lautu Chin","Welsh Romani","Bruny Island Tasmanian","Chong","Novial","Spanish Sign Language","Mossi","Koti","Koyaga","Chut","Mfumte","Bote-Majhi","Gusilay","Nyoro","Zoroastrian Dari","Ghomara","Kirikiri","Daw","Shumcho","Fas","Logir","Achagua","Luna","Qiubei Zhuang","Lingua Franca","Mongolian","Western Krahn","Chepya","Noiri","Punic","Bintauna","Layakha","Yabarana","Kwoma","Yuchi","Kaburi","Zeme Naga","South Nuaulu","Sangkong","Mpuono","To","Old Manipuri","Manobo languages","Cao Miao","Nogai","Malawi Sena","Oyda","Bibbulman","Uamue","Brokskat","Sena","Sechelt","Cuyonon","Lezghian","Southwestern Dinka","Biage","Northeastern Tasmanian","Chambeali","Sino-Tibetan languages","Chadic languages","Atzingo Matlatzinca","Maek","Sugut Dusun","Doghoro","Kofa","Daonda","Lusi","Mudu Koraga","Yambes","Kubi","North Fali","Ndra'ngith","Old Spanish","Xavante","Tupinamba","Bondo","Sumau","Kanju","Kokola","Kamviri","Yimchungru Naga","Kaitag","Jarawa (India)","Samoyedic languages","Rakahanga-Manihiki","Aghwan","Samaritan","Tuxa","Kembayan","Kuthant","Bangwinji","Middle Low German","Nadeb","Eudeve","Eastern Hongshuihe Zhuang","Milyan","Kaimbe","Ndali","Ndau","Puerto Rican Sign Language","Bainouk-Gunyaamolo","Mpi","Phunoi","Macaguaje","Broome Pearling Lugger Pidgin","Elepi","Juang","Kunyi","Lawangan","Nuu-chah-nulth","Tama (Chad)","Bauwaki","Dendi (Central African Republic)","Mbe'","Lachixio Zapotec","Ipili","Iceve-Maci","Biali","Kanikkaran","Emai-Iuleha-Ora","Muzi","Sarli","Southern Tidung","Ugaritic","Abu","Bau Bidayuh","Luguru","Wumbvu","Kuku-Uwanh","Kendem","Konkomba","Ndyuka-Trio Pidgin","Sop","Lachi","Jumla Sign Language","Perai","Bit","Rishiwa","Eruwa","Guambiano","Imroing","Pinji","Northern Pashto","Pitcairn-Norfolk","Ilwana","Sudest","Makurap","Awad Bing","Azerbaijani","Turaka","Copala Triqui","Bwanabwana","Namo","Kakanda","Eggon","Kei","Umotina","Abua","Argentine Sign Language","Pelende","Anglo-Norman","Watiwa","Malayo","Garre","Ambonese Malay","San Blas Kuna","Baga Sitemu","Rotuman","Ewondo","Paez","Lule Sami","Bainouk-Samik","Tese","Malak Malak","Tswapong","Kamba","Central Berawan","Sanga (Democratic Republic of Congo)","Kituba (Congo)","Sicel","Kairiru","Nding","Fiji Hindi","Zacatepec Chatino","Sinyar","Eastern Penan","Tlingit","Marimanindji","Titan","Satawalese","Tuscarora","Dima","Dongo","Senaya","Tunica","Middle Breton","Sensi","Kenga","Makhuwa-Marrevone","Tofanma","Dusun Witu","Kugu-Muminh","Southern Katang","Meyah","Ngile","Zimbabwe Sign Language","Nalogo","Southern Kalapuya","Lomwe","Guwa","Omie","Penoles Mixtec","Moksela","Semnam","Baloi","Haiom","Eastern Keres","Villa Viciosa Agta","Hernican","Western Ojibwa","Punthamara","Tobati","Araki","Taliabu","Sialum","Hano","Punan Tubu","Kadai","Ngomba","Southwestern Tasmanian","Nambya","Sa'ban","Pinyin","Kraho","Tonsawang","Dzuungoo","Huaylla Wanca Quechua","Mursi","Wemba Wemba","San Pedro Amuzgos Amuzgo","Tutong","Logba","Bulgarian","Natanzi","Enwan (Akwa Ibom State)","Djimini Senoufo","Eastern Xwla Gbe","Miriwoong","Japanese","Nchumbulu","Zulu","International Sign","Alsea","Khamba","Eastern Pomo","Bakwe","Sause","Aranadan","Arabela","Chol","Venetic","Quechuan (family)","Manide","Armenian Sign Language","Zizilivakan","Kaptiau","Panim","Hermit","Natugu","Yaaku","Luimbi","Isekiri","Bissa","Warnman","Lesing-Gelimi","Kokoda","Beti (Cote d'Ivoire)","Aequian","Luang","Burmbar","Worodougou","Pulabu","Tsat","Tonkawa","Caluyanun","Northern Betsimisaraka Malagasy","Daba","Pardhan","Mubi","Bouyei","Biete","Bugan","Batak Toba","Aka-Kol","Tobian","Sankaran Maninka","Masikoro Malagasy","Dera (Indonesia)","Idakho-Isukha-Tiriki","Horo","Central Kanuri","Daga","Kembra","Gunwinggu","Bonerif","Aguaruna","Thu Lao","Caddo","Nocte Naga","Mali","Yarsun","Kalabari","Label","Ombamba","Koreguaje","Ngadjunmaya","Chippewa","Labu","Lihir","Hlai","Rawngtu Chin","Papuma","Awera","Bukusu","Southeast Ijo","Siwi","Busami","Kubo","Yerong","Gureng Gureng","Katla","Ozolotepec Zapotec","Bezhta","Balangao","Cori","Michoacan Mazahua","Han","Mehinaku","Yela","Dewas Rai","Yindjibarndi","Blin","Todrah","Northern Bontok","Nimo","Bangi","Matumbi","Illyrian","Nimadi","Toto","Southern Pashto","Eastern Mari","Mian","Bendi","Benga","Mlabri","Cibak","Kompane","Misima-Panaeati","Burak","Hmong Daw","Butuanon","Kire","Northern Muji","Jju","Doromu-Koki","Kisankasa","Dhuwal","Jaru","Onin","Epi-Olmec","Edera Awyu","Bunoge Dogon","Koro Wachi","Arosi","Musasa","Mang","Kele (Papua New Guinea)","Tunjung","Bolgo","Sinagen","Sori-Harengan","Efe","Carolina Algonquian","Nyishi","Latvian Sign Language","Korandje","Lardil","Jejueo","Northern Sierra Miwok","Chamorro","Holiya","Olo","Sebop","Gor","Tala","Hre","Ottawa","Yongnan Zhuang","Ubi","Gujarati","Northern Tujia","Marwari (Pakistan)","Indonesian Sign Language","Southern Alta","Kxoe","Northwest Gbaya","Nhanda","Waimaha","Joba","Croatia Sign Language","West Slavic languages","Bakhtiari","Phupha","Psikye","Standard Malay","Mobilian","North Mofu","Wanyi","Bago-Kusuntu","Southeast Ambrym","Bo-Rukul","Tadyawan","Medefaidrin","Ma'anyan","Scythian","Shamang","Norra","Shawnee","Pholo","Betta Kurumba","Geez","Tilquiapan Zapotec","Kanakanabu","Chachapoyas Quechua","Gaelic","Munsee","Extremaduran","Tenango Otomi","Papel","Tanggu","Dakota","Kaluli","Miu","Numee","Yintale Karen","Cajun French","Wauyai","Citak","Western Tawbuid","Kalaktang Monpa","East Germanic languages","Djinang","North Picene","North Awyu","Arbore","Tajio","Termanu","Tobilung","Tatana","Central Malay","Santa Catarina Albarradas Zapotec","Bauni","Estado de Mexico Otomi","Mogholi","Nukunul","Itundujia Mixtec","Umbundu","South Slavic languages","Aduge","Sindarin","Guato","Cacgia Roglai","Romansh","Aragonese","Ngen","Kamayura","Xadani Zapotec","Western Keres","Creoles and pidgins","Toba-Maskoy","Korowai","Xerente","Podena","Kobiana","Toraja-Sa'dan","Kairui-Midiki","Tchitchege","Hadothi","Walio","Arikara","Senhaja De Srair","Kanembu","Kodaku","Argobba","Lianshan Zhuang","Old Uighur","Wambule","Tabaa Zapotec","Atauran","Kenzi","Balinese Malay","Kumbewaha","Southern Catanduanes Bikol","East Futuna","Chigmecatitlan Mixtec","Baltic languages","Kalou","Ngizim","Ashe","Lombi","Sokoro","Yarawata","Totela","Wanap","Middle Armenian","Ngayawung","Cinta Larga","Buginese","Ashkun","Guanano","Ngbaka Manza","San Miguel El Grande Mixtec","Traveller Danish","Watubela","Wasco-Wishram","Nachering","Tagalaka","Phuan","Kayan River Kayan","Balaesang","Wurrugu","Kerinci","Bongili","Southwest Tanna","Malyangapa","Ahan","Bamun","Lamogai","Nimi","Manda (Tanzania)","Nyamwanga","Cafundo Creole","Ratagnon","Khamyang","Alekano","Bih","Petapa Zapotec","Mixed Great Andamanese","Nagumi","Chiga","Lomaiviti","Lo-Toga","Farefare","Tetela","Bati (Indonesia)","Konomala","Hopi","Old Cornish","Texistepec Popoluca","Karen languages","Sangil","Dhudhuroa","Dibole","Kanga","Andaman Creole Hindi","Mbangi","Shambala","Mwimbi-Muthambi","Batak Simalungun","Bun","Ninzo","Southern East Cree","Chewong","Yangum Mon","Kwinsu","Belhariya","Adzera","Kushi","Bilakura","Ambakich","Muna","Kanite","Pano","Modang","Sivia Sign Language","Lefa","Masimasi","Karagas","Cayubaba","Bajan","West Yugur","Jandavra","Pochutec","Pancana","Pacoh","Banjar","Tenharim","Wahau Kayan","Mer","Celtiberian","Kimbundu","Gorap","Langam","Nisi (China)","Bayot","Aka-Jeru","Purubora","Hlepho Phowa","Nyungwe","Ito","Tibeto-Burman languages","Lashi","Tenino","Kube","Bussa","Upper Necaxa Totonac","Ambai","Meru","Santa Maria Zacatepec Mixtec","Degexit'an","Salasaca Highland Quichua","Sepa (Papua New Guinea)","Kwara'ae","Buksa","Dass","Nzakambay","Urdu","Tai Laing","Scots","Saint Lucian Creole French","Nyangbo","Buhi'non Bikol","Boon","Xicotepec De Juarez Totonac","Heiban","Xiri","Siwu","Herde","Nyika (Malawi and Zambia)","Moni","Dusun Deyah","Silacayoapan Mixtec","Ghandruk Sign Language","Skalvian","Mbuko","Purisimeno","Puroik","Shumashti","Tungus languages","Dolgan","Leti (Cameroon)","Kagate","Tuvinian","Nage","Owa","Pinjarup","Lower Chehalis","Voro","Katabaga","Loarki","Pai Tavytera","Yapunda","Khorasani Turkish","Mandari","Umanakaina","Kupang Malay","Afrihili","Saam","Dumi","A-Pucikwar","Waja","Indus Valley Language","Engenni","Makhuwa","Dir-Nyamzak-Mbarimi","Eastern Ngad'a","Foia Foia","Uya","Thangal Naga","Western Dani","North Junin Quechua","Suki","North Tanna","Singapore Sign Language","Yamba","Luri","Sa","Severn Ojibwa","Teke-Tsaayi","Ghanaian Sign Language","Salinan","Takua","Tenis","Kavalan","Nekgini","Santali","Rumu","Tairuma","Miani","Odut","Yakan","Yeni","Pwaamei","Hassaniyya","Bafut","Bonjo","Mongolian languages","San Martin Quechua","Ana Tinga Dogon","Northern Grebo","Judeo-Yemeni Arabic","Suganga","Yotti","Wahgi","Sengele","Bawm Chin","Southern Roglai","Marriammu","Denya","Paloor","Hinukh","Wancho Naga","Biak","Southern Guiyang Hmong","Lisabata-Nuniali","Kung","Saraiki","North Giziga","Wangkangurru","Alaba-K'abeena","Narak","Nahuatl languages","Yoron","Eastern Karaboro","Assamese","Nukuria","Mewari","Yaka (Central African Republic)","Bura-Pabir","Romagnol","Somali","Achterhoeks","Gurgula","Chuj","Lauje","Cahuarano","Puyuma","Ganggalida","Yahang","Kamaru","Krobu","Desiya","Andi","Dhalandji","Konda","Kwesten","Chhulung","Gwich'in","Sanaani Arabic","Oirata","Domu","Jimi (Cameroon)","Somyev","Isu (Fako Division)","Atsugewi","Piraha","Khirwar","Zia","Sorsogon Ayta","Tsoa","Maonan","Omani Arabic","Kobon","Moo","Dabe","Ho-Chunk","Nyindrou","Dzando","Aquitanian","Southern Grebo","Vame","Zumbun","Northern Ping Chinese","English, Old (ca.450-1100)","San Francisco Del Mar Huave","Nasarian","Mubami","Ron","Mohawk","Agavotaguerra","Sikaiana","Mocovi","Cerma","Badimaya","Nabi","Cwi Bwamu","Demisa","Nunggubuyu","Dakpakha","Eskimo-Aleut languages","Benggoi","Halang Doan","Waropen","Ikpeshi","Sidetic","Mundang","Faita","Estonian","Sipacapense","Nyangatom","Hmar","Krache","Degema","Tondi Songway Kiini","Kagoma","Damakawa","Southern Samo","Nanerige Senoufo","Kamar","Tataltepec Chatino","Tanahmerah","Peranakan Indonesian","Kerewo","Koy Sanjaq Surat","Angguruk Yali","Isirawa","Lewo Eleng","Algerian Saharan Arabic","Domung","Safaliba","Mangayat","Pak-Tong","Bena (Nigeria)","Ngombale","Zhoa","Cuitlatec","Koyraboro Senni Songhai","Tsotso","Arigidi","Magori","Mzieme Naga","Yelogu","Chadian Sign Language","Marama","Yan-nhangu","Mono (Cameroon)","Naami","Massalat","Bondoukou Kulango","Vai","Azoyu Me'phaa","Nkukoli","Geji","Kohin","Bajjika","Santa Maria La Alta Nahuatl","Eipomek","Mamvu","Moere","Geruma","Koi","Vute","Western Cham","Trimuris","Early Tripuri","Vemgo-Mabas","Chaudangsi","Vagla","Tai Long","Nsenga","Marino","Reyesano","Nzanyi","Bisu","Wewaw","Bakumpai","Rigwe","Dirim","Ayoquesco Zapotec","Czech Sign Language","Varli","Zenaga","Berom","Undetermined","Ngundi","Erromintxela","Indo-Portuguese","Hausa","Saweru","Aulua","Mbudum","Idoma","Hanoi Sign Language","Santa Lucia Monteverde Mixtec","Sangisari","Babuza","Low German","Chiquihuitlan Mazatec","Ozumacin Chinantec","Mahican","Izora","Yakama","Tahaggart Tamahaq","Tasmate","Shwai","Ajawa","O'chi'chi'","Pagi","Tilung","Kirike","Besme","Kemedzung","Rer Bare","Garus","Beng","Gapapaiwa","Yoloxochitl Mixtec","Alu Kurumba","Picard","Bengali","Noone","Bau","Pangwali","Kenyi","Zou","Yucatec Maya Sign Language","Patwin","Birwa","Zakhring","Jurchen","Hone","Udmurt","Kikuyu","Ishkashimi","Nubaca","Coquille","Marind","Ersu","Brunca Sign Language","Ngardi","Sanglechi","Church Slavic","Pijin","Ainu (China)","Chicahuaxtla Triqui","Southern Dagaare","Mayi-Yapi","Ngongo","Malavedan","Elymian","Hazaragi","Diri","Diuwe","Trinitario","Bokyi","Ambala Ayta","Tajiki Arabic","Boor","Mongo","Sarua","Akkala Sami","Chibcha","Ama (Papua New Guinea)","Telugu","Wangaaybuwan-Ngiyambaa","Piame","Korak","Lanas Lobu","Wuliwuli","Shabak","Malapandaram","Algerian Jewish Sign Language","Surgujia","Algic languages","Betawi","Yorta Yorta","Yil","Siriano","Far Western Muria","Adangme","Ugong","Pande","Aghu-Tharnggala","Bidhawal","Dai","Sulod","Temoq","Gungu","Ute-Southern Paiute","Sira","Urningangg","Sarudu","Andajin","Urhobo","Chayahuita","Pimbwe","Tiruray","Ghayavi","West Damar","Twana","San Juan Atzingo Popoloca","Erokwanas","Zoogocho Zapotec","Na","San Juan Teita Mixtec","Delaware","Ancient North Arabian","Torwali","Tanglang","Mvuba","Southern Sorsoganon","Manyika","Belning","Ega","Karko","Lunanakha","Gula (Chad)","Yuru","Umatilla","Bamu","Coyotepec Popoloca","Sao Paulo Kaingang","Paumari","Gedeo","Sagalla","Vietnamese","Lule","Matambwe","Suau","North Germanic languages","Sallands","Lamja-Dengsa-Tola","Riang Lang","Omok","Northeastern Dinka","Dhimal","Boko (Democratic Republic of Congo)","Anu-Hkongso Chin","Ganglau","Banda Malay","Ese","Blafe","Panyi Bai","Lepontic","Pasi","Kurmukar","Singpho","Mandandanyi","Dhangu-Djangu","Ruma","Koke","Mawak","Shan","Kudiya","Koyra Chiini Songhay","Zazao","Pa-Hng","Arakwal","Hehe","Kisar","Yugul","Dehu","Karakhanid","Gafat","Sunam","Ndobo","Arho","Andai","Tigrinya","San Miguel Piedras Mixtec","Dema","Kannada Kurumba","Samre","Wumeng Nasu","Silesian","Oko-Juwoi","Puri","Rejang","Shuswap","Tumzabt","Naxi","Logo","San Miguel Creole French","Macuna","Rogo","Teke-Tege","Hixkaryana","Jerung","Yana","Miltu","Taznatit","Kwomtari","Nez Perce","Tamil","Chichewa","Loma (Cote d'Ivoire)","Bolinao","Hittite","Ghadames","Bukiyip","Ekajuk","Krongo","Yansi","Kurama","Karachay-Balkar","Nubri","Paluan","Mashco Piro","Truka","Torricelli","Inapang","Western Bru","Seke (Nepal)","Sou Upaa","Fordata","Tela-Masbuar","Primitive Irish","Nopala Chatino","Mbula","Nyole","Baure","Nong Zhuang","Moskona","West Albay Bikol","Oroko","Laa Laa Bwamu","Yau (Morobe Province)","Basap","Lopi","Southeast Tasmanian","Nyangga","Southwestern Fars","Konni","Bangolan","Northern Pame","Northern Mashan Hmong","Marghi South","Kulung (Nepal)","Kaskean","Ikaranggal","Mokpwe","Teor","Wardaman","Sewa Bay","Cupeno","Maiadomu","Burushaski","Chhattisgarhi","Aguna","Gaikundi","Boano (Sulawesi)","Kalanadi","Mongolia Buriat","Uma","Palikur","Malol","Buwal","Odual","Kuamasi","Arvanitika Albanian","Atsam","Rapting","Chamicuro","Iwaidja","Gheg Albanian","Standard Latvian","Gaddang","Oring","Fur","Toura (Cote d'Ivoire)","Montenegrin","Mandobo Atas","Bargam","Bohtan Neo-Aramaic","Neo","Mirgan","Usarufa","Anuki","White Gelao","Gongduk","'Auhelawa","Tosk Albanian","Oriya","Polonombauk","Barclayville Grebo","Hunjara-Kaina Ke","Muniche","Gujari","Lauan","Au","Loreto-Ucayali Spanish","Fataleka","Woleaian","Narungga","Kepkiriwat","Bambam","Lama (Togo)","Eastern Balochi","Maba (Indonesia)","Western Niger Fulfulde","Merwari","Tanimbili","Pulaar","Ge","Ashtiani","Vehes","Tugun","Estonian Sign Language","Badeshi","Wichi Lhamtes Nocten","Ufim","Mandobo Bawah","Lelemi","Akyaung Ari Naga","Wara","Maltese Sign Language","Gros Ventre","Nupe-Nupe-Tako","Old Russian","Tsonga","Cebuano","Murkim","Badjiri","Carpathian Romani","Dangaura Tharu","Central Huasteca Nahuatl","Tehit","Sekapan","Laru","Ponam","Wamesa","Gizrra","Yale","Zuni","Gule","Angloromani","Sake","Bagvalal","Wikngenchera","Bongo","Najdi Arabic","Pa Di","Tibetan","Morouas","Yagaria","Mapudungun","Mamulique","Buamu","Yawuru","Dharawal","Adasen","Assangori","Borgu Fulfulde","Takia","Pochuri Naga","Buru (Nigeria)","Ambele","Tai Thanh","Wogeo","Puragi","Eastern Subanen","Beginci","Parya","Dadi Dadi","Hupla","Kpeego","Kara-Kalpak","Djabwurrung","Larantuka Malay","Yandjibara","Oti","Lishanid Noshan","Gorakor","German, Old High (ca.750-1050)","Jawoyn","Slovakian Sign Language","Xanaguia Zapotec","Kiong","Southeastern Ixtlan Zapotec","Vumbu","Jauja Wanca Quechua","Mala (Nigeria)","Waling","Ojitlan Chinantec","Chopi","Shiki","Lelepa","Itelmen","Korean","Old Nubian","Ani","Labo","Burate","Kibala","Yinggarda","Weliki","Kolbila","Providencia Sign Language","Dondo","Anmatyerre","Banda-Banda","Sharanahua","Tai Hongjin","Mpumpong","Ngalakgan","Plains Indian Sign Language","Glaro-Twabo","Western Mari","Tula","Sylheti","Gagnoa Bete","Aiklep","Nii","Kgalagadi","Bisis","Lijili","Maghdi","Isthmus-Pajapan Nahuatl","Amto","Bolia","Mentawai","Wailapa","Bateri","Bokobaru","Karanga","Ngwo","Panara","Kholok","Gwak","Minangkabau","Ebira","Koyukon","Qimant","Chipewyan","Lambadi","Mamainde","Rabha","Kagoro","Rasawa","Athpariya","Levantine Arabic","Jeh","Rongpo","Sorothaptic","Sherbro","Gilyak","Matengo","Malgana","Kenyan Sign Language","Burumakok","Uncoded languages","Badi Kanum","Hajong","Oraon Sadri","Gvoko","Tiagbamrin Aizi","Indian Sign Language","Ikizu","Gurindji Kriol","Waray (Australia)","Piamatsina","Mesopotamian Arabic","Dwang","Fayu","Jita","Tibetan Sign Language","Kwambi","Yami","Lasi","Bedjond","Khakas","Coastal Konjo","Nande","Bandjalang","Isinai","Fa d'Ambu","Ngando (Democratic Republic of Congo)","Venezuelan Sign Language","Bukat","Mbay","Swo","Kaiep","Palaka Senoufo","Yombe","Tidore","Bidyogo","Muratayak","Mozambican Sign Language","Yekora","Pallanganmiddang","Chinbon Chin","Betaf","Yahadian","Tigon Mbembe","Burji","Chenoua","Guramalum","Bashkir","Eastern Parbate Kham","Mbe","Sotho, Southern","Wadiyara Koli","Munduruku","Forak","E'ma Buyang","Asturian","Nyankpa","Nkangala","Eastern Ojibwa","Ulch","Waluwarra","T'en","Imbabura Highland Quichua","Barikanchi","Selungai Murut","Toro So Dogon","Virgin Islands Creole English","Duvle","Goreng","Tandia","Sundanese","Kombai","Western Highland Purepecha","Zanaki","Karipuna","West Coast Bajau","Ekai Chin","Long Wat","Susu","Nhengatu","Silt'e","Lower Silesian","Kwegu","Pathiya","Mele-Fila","English","Gata'","Yaka (Democratic Republic of Congo)","Tay Sa Pa","Ojibwa","Wadaginam","Nda'nda'","Southeast Babar","Northwestern Fars","North Asmat","Toda","Tobanga","Poqomchi'","Waru","Daats'iin","Mafea","Garingbal","Inuktitut","Poqomam","Kam","Classical Mandaic","Enwan (Edo State)","Xinca","Uru","ut-Hun","Dayi","Trieng","Wagiman","Bayono","Dumun","Neyo","Kulfa","Selee","Ga'dang","Mak (China)","Yauyos Quechua","Tangchangya","Tayo","Kistane","Esuma","Duruma","Slovenian","Grebo","Bulo Stieng","Bolyu","Kaang Chin","Ontong Java","Kisan","Turkish Sign Language","Kuy","Saep","Yakoma","Darlong","Marubo","Menka","Dhatki","Gundi","No linguistic content","Guibei Zhuang","Tutsa Naga","Neko","Ogbronuagum","Kayong","Malaynon","Melo","Biloxi","Ngazidja Comorian","Eton (Vanuatu)","Ikwo","Western Abnaki","Lungalunga","Dungan","Western Durango Nahuatl","Towei","Pyen","Movima","Minjungbal","Northeastern Thai","Sumbwa","Turkana","Taivoan","Igo","Thao","Dano","Lower Grand Valley Dani","Ogbia","Yekhee","Mainstream Kenyah","Miwa","Mokerang","Bragat","Dyangadi","Nkutu","Songo","Tunia","Bwisi","Libido","Bende","Adai","Humburi Senni Songhay","Tlamacazapa Nahuatl","Mirandese","Lakha","Kucong","Makwe","Tatar","South West Bay","Sekar","Musak","Jiamao","Talondo'","Seki","Punan Bah-Biau","Tamki","Mfinu","Kintaq","Tambotalo","Siona","Himachali languages","Tupuri","Banggai","Hamap","Danu","Valley Maidu","Maleu-Kilenge","Nila","Mbule","Kamara","Tilapa Otomi","Angkamuthi","Makhuwa-Saka","Bom-Kim","Tai Ya","Manya","Cubeo","Catalan Sign Language","Asho Chin","Seychelles Sign Language","Koro (Papua New Guinea)","Laua","Mbara (Chad)","Nepali","Kordofanian languages","Lasalimu","Bunuba","Daai Chin","Ilue","Lapaguia-Guivini Zapotec","Inlaod Itneg","To'abaita","Namosi-Naitasiri-Serua","Nshi","Anyin Morofo","Ngoshie","Hmong Shua","Mbongno","Raetic","Nubian languages","Taungyo","Sajalong","Kande","Garig-Ilgar","Patep","Saek","Sri Lankan Sign Language","Tippera","Krenak","Pa'a","Sakao","Susquehannock","Ngbundu","Sileibi","Bobongko","Harami","Kosena","Kerewe","Kare (Central African Republic)","Itawit","Tututepec Mixtec","Ili Turki","Bai (South Sudan)","Buli (Ghana)","Akan","Alabat Island Agta","Laro","Wayoro","Ngam","Monsang Naga","Buyu","Bunun","Cherokee","Ga'anda","Sursurunga","Mamboru","Ngbaka Ma'bo","Laghuu","Manna-Dora","Aromanian","Makalero","Sherdukpen","Baygo","Stellingwerfs","Airoran","White Lachi","Ancient Zapotec","Toki Pona","Ventureno","Mokole","Dirasha","Chara","Ding","Waigali","Haya","Leipon","Pu-Xian Chinese","Bungku","Bundeli","Fe'fe'","Nari Nari","Madurese","Ndwewe","Cajatambo North Lima Quechua","Medumba","Western Xwla Gbe","Oku","Enlhet","Bubi","Kyaka","Karok","Gaddi","Kuku-Mangk","Noipx","Hyam","Bauchi","Tiemacewe Bozo","Lenakel","Baba Malay","Ngom","Ife","Naro","Guarayu","Chamic languages","Lake Miwok","Salt-Yui","Rembong","Yaur","Mandaya","Okobo","Akoye","Galindan","Kaurna","Ngwaba","Tornedalen Finnish","Innu","Buhid","Awadhi","Yan-nhanu Sign Language","Ali","Huilliche","Hua","Kaansa","Upper Sorbian","Cocama-Cocamilla","Bulgarian Sign Language","Loup B","Diriku","Dama","Mag-antsi Ayta","Bamali","Khanty","Harari","Suwawa","Yinwum","Suundi","Vinmavis","Arawak","Caac","Hoava","Cheyenne","Majhi","Maore Comorian","Indri","Waube","Bulu (Papua New Guinea)","Western Fijian","Asuncion Mixtepec Zapotec","Salas","Kulina Pano","South Central Dinka","Cuneiform Luwian","Aguano","Valencian Sign Language","Bosngun","Lehar","Onobasulu","Maria (India)","Gula Iro","Gepo","Khazar","Gunya","Chazumba Mixtec","Mangas","Northern Oaxaca Nahuatl","Southern Tujia","Naka'ela","Northern Conchucos Ancash Quechua","Jawe","Yang Zhuang","Sadri","Lehali","Southern Qiang","Tagdal","Djawi","Northern Thai","Kirya-Konzel","Auwe","Old Khmer","Ono","Amo","Cuyamecalco Mixtec","Tonjon","Moldova Sign Language","Manda (India)","C'Lela","Cha'ari","Indo-Iranian languages","Maharastri Prakrit","Borong","Puebla Mazatec","Yaygir","Yanomamo","Lelak","Bannoni","Yosondua Mixtec","Kabyle","Kotava","Kanuri","Guajajara","Adyghe","Rungus","Numbami","Westphalien","Creoles and pidgins, French-based","Faifi","Putukwam","Selkup","Wunambal","Pwo Northern Karen","Kubu","Tidikelt Tamazight","Tawoyan","Yangkam","Vitou","Nyiyaparli","Cabecar","Aja (Benin)","Prakrit languages","Sranan Tongo","Mari (East Sepik Province)","Azhe","Basketo","Jennu Kurumba","Matigsalug Manobo","Egyptian (Ancient)","Yulu","Pahari-Potwari","Pare","Sarsi","Yinbaw Karen","Wu Chinese","Ankave","Togoyo","Ajie","Southern Kiwai","Ladakhi","Adonara","Tachelhit","Umeda","Ruwila","Njen","Sikkimese","Keoru-Ahia","Calo","Northern Katang","Old Saxon","Gilbertese","Kazakh","Bilaspuri","Kharia Thar","Lisela","Sape","Gusii","Kuk","Osatu","Shua","Eblan","Central-Eastern Niger Fulfulde","Wakawaka","Basa (Nigeria)","Umbugarla","Seit-Kaitetu","Simte","Shehri","Uripiv-Wala-Rano-Atchin","Chemakum","Tsakwambo","Camunic","Imbongu","Libyan Arabic","Tareng","Pagibete","Upper Umpqua","Vidunda","Mbosi","Dhanki","Old Cham","Southwestern Tarahumara","Gen","Yakha","Awu","Dhaiso","Dzalakha","Samba","Maay","Kangri","Wilawila","Dokshi","Teke-Nzikou","Kuman (Papua New Guinea)","Patpatar","Godie","Changthang","Sinasina","Northern Pomo","Baras","Naki","Atong (India)","Zhire","Isoko","Kiowa","Pumpokol","Eastern Kayah","Nyali","Falam Chin","Menominee","Nyakyusa-Ngonde","Southern Hindko","Belarusian","Totomachapan Zapotec","Akpes","Guarequena","Choapan Zapotec","Vano","Samberigi","Njebi","Myanmar Sign Language","Atorada","Juquila Mixe","Boruca","Domaaki","Volapuk","Tengger","Laitu Chin","Loniu","Walser","Maringarr","Fore","Manyawa","Old Mon","Koma","Bomitaba","Ngaanyatjarra","Tapirape","Malawi Lomwe","Wolani","Duwet","Yout Wam","Omotik","Nyangumarta","Traveller Scottish","Mabire","Fasu","Yango","Mander","Yom","Tama (Colombia)","Kaki Ae","Ghera","Tombulu","Waima'a","Wamas","Lushootseed","Nyiha (Malawi)","Rade","Kofei","Yace","Sudanese Arabic","Baimak","Rangi","Gogodala","Nomaande","Kokata","Wa","Motu","Atlantic-Congo languages","Attie","Tsakhur","Bahau","Biao Mon","Kwini","Foau","Kapingamarangi","Ikobi","Tukang Besi North","Anaang","Kehu","Kunja","Ivbie North-Okpela-Arhe","Nafusi","Nake","Western Highland Chatino","Nanga Dama Dogon","Lambya","Ronji","Rajput Garasia","Wawa","Orang Seletar","Maquiritari","Mbuk","Purum","Botlikh","Bitur","Badaga","Komi-Zyrian","Zerenkel","Iranian Sign Language","Binandere","Northern Kurdish","Southwest Pashai","Ndolo","Malvi","Yao","Sawai","Chavacano","Northern Tepehuan","Gamilaraay","Australian languages","Manggarai","Northern Altai","Amaimon","French","Bhilali","German, Middle High (ca.1050-1500)","Bila","Lavi","Lufu","Molmo One","Algonquian languages","Bilur","Orang Kanaq","Mono (USA)","Mairasi","Punu","Garhwali","Latvian","Delo","Jiongnai Bunu","Nungu","Hlersu","Sempan","Yawijibaya","Murle","Mamasa","Macedonian","Dazaga","Southern Mashan Hmong","Marshallese","Gimme","Obolo","Leyigha","Molo","Karey","Gwandara","Wik Ngathan","Utarmbung","Anserma","Alabama","Bolgarian","Min Bei Chinese","Minidien","Bisorio","Ginyanga","Western Panjabi","Kuijau","Tikopia","Mulgi","Auslan","Shendu","Oro Win","Niwer Mil","Sissano","Solomon Islands Sign Language","Girirra","Awyi","Ndumu","Ekpeye","Kinga","Agob","Nyang'i","Istriot","Sula","Hwana","Saliba","Persian","Zay","Khiamniungan Naga","Kaike","Vitu","Tukpa","Kalagan","Goaria","Eastern Highland Chatino","Bellari","Hawai'i Sign Language (HSL)","Seri","Skagit","Yug","Abaza","Pakanha","Eastern Maninkakan","Yuanga","Northern Alta","Hurrian","Munji","Langnian Buyang","Birhor","Yambeta","Cotabato Manobo","Akum","Bwatoo","Samaritan Aramaic","Muyang","Batak Angkola","Yuruti","Gwamhi-Wuri","Manipa","Segeju","Kumarbhag Paharia","Yauma","Mantsi","Malinaltepec Me'phaa","Nomu","Nuk","Pana (Central African Republic)","Judeo-Tat","Pakistan Sign Language","Tewa (USA)","Moundadan Chetty","Petjo","Mae","Mamusi","Nyarafolo Senoufo","Yavitero","Luo (Kenya and Tanzania)","Kokota","Paakantyi","Lambayeque Quechua","Huaulu","Tampias Lobu","Chonyi-Dzihana-Kauma","Cocopa","Uspanteco","Dadiya","Likila","Slave (Athapascan)","Malo","Galice","Nyanga","Bambalang","Desano","Nyamal","Slavomolisano","Cua","Kankanaey","Irantxe","Boano (Maluku)","Lakonde","Musey","Nara","Urartian","Pahari","Ruching Palaung","Tangoa","Jamamadi","Bangba","Allar","Kaimbulawa","Kharam Naga","Kachari","Umpila","Samba Leko","Mbo (Cameroon)","Lwel","Bolon","Car Nicobarese","Folopa","Jinyu Chinese","Mor (Mor Islands)","Okanagan","Yanda","Buso","Mobwa Karen","Enya","Bimin","Ndengereko","Miahuatlan Zapotec","Rakhine","Jora","Brazilian Sign Language","Rerau","Ere","Zenag","Narua","Dawro","Kpala","Khoekhoe","Thakali","Njyem","Classical Quechua","Lamalama","Konongo","Northwest Alaska Inupiatun","Huaylas Ancash Quechua","Valman","Talossan","Tomini","Mt. Iraya Agta","Ganzi","Siri","Maria (Papua New Guinea)","Miyakubo Sign Language","Tseku","Ndut","Gokana","Mbati","Dhanwar (Nepal)","Vasavi","Island Carib","Mt. Iriga Agta","Uare","Qau","Lalia","Chodri","Dogrib","Hozo","Thachanadan","Ganza","German","Lala","Kaiwa","Usan","Hamer-Banna","Samoan","Lishan Didan","Yangulam","Bamunka","Pisabo","Southern Nisu","Alcozauca Mixtec","Lhomi","Sie","Digaro-Mishmi","Ngoni (Tanzania)","Imotong","Daloa Bete","Trio","Aka-Kora","Mahongwe","Keiga","Keak","Central Okinawan","Kwakiutl","Ogea","Mokati","Tagin","Panchpargania","Paelignian","Muak Sa-aak","Bambara","Kawacha","Median","Belait","Irish, Old (to 900)","Gangte","Kaba","Kamula","Aguacateco","Awa (Papua New Guinea)","Ihievbe","Weri","Adioukrou","Kyak","Central Awyu","Ososo","Sediq","Bekati'","Lohorung","Njerep","Serua","Yokuts","Gnau","Cruzeno","Xaragure","Legbo","Dhuwaya","Dia","Mor (Bomberai Peninsula)","Uneme","Pangseng","Paiwan","Kami (Tanzania)","Chiangmai Sign Language","Pileni","Swahili","Sivandi","Mari (Madang Province)","East Berawan","Parthian","Hattic","Antankarana Malagasy","Mbum","Mag (Madang Province)","Ulwa","Yuwana","Akolet","Wolaitta","Basay","Kuuk Thaayorre","Gulay","Puoc","Haji","Sirenik Yupik","Uto-Aztecan languages","Upper Ta'oih","Tektiteko","East Tarangan","Lemolang","Hakka Chinese","Piro","Tairaha","Topoiyo","Yuhup","San Felipe Otlaltepec Popoloca","Etchemin","Ethiopian Sign Language","Aka-Kede","Kulere","Kulisusu","Kedah Malay","Gbari","Foma","Obispeno","Kisa","Nafaanra","Ngarinyin","Lonzo","Sinaugoro","Lakon","Bribri","Wakde","Klingon","Byangsi","Mengaka","Yecuatla Totonac","South Marquesan","Hadiyya","Hmwaveke","Galolen","Kisi","Ibaloi","Uni","El Hugeirat","Haveke","Duruwa","Takelma","Lenkau","Barombi","Wagdi","Sanie","Sabah Malay","Elip","Pontic","Ndebele, North","Nyamwezi","Colombian Sign Language","Togbo-Vara Banda","Ake","Moraid","Phong-Kniang","Gandhari","Lower Tanana","Fagani","Southern Ohlone","Barama","Puyo","Ngaing","Paniya","Min Zhong Chinese","Karenggapa","Lokaa","Chuukese","Nali","Karnai","Pattani Malay","Camsa","Maslam","Kirmanjki (individual language)","Isu (Menchum Division)","Kadiweu","Isthmus-Cosoleacaque Nahuatl","Kom (India)","Mbalanhu","Shau","Sahu","Bambassi","Jhankot Sign Language","Lukpa","Purari","Gbagyi","Mapena","Longuda","Nehan","Vaghua","Koalib","Romblomanon","Chenchu","Bantawa","Tado","Letemboi","Babine","Vangunu","Waci Gbe","Pangwa","Mandahuaca","Miriti","Seneca","Tetun Dili","Kumba","Liv","Guinea-Bissau Sign Language","Fongoro","Zayein Karen","Tandroy-Mahafaly Malagasy","Soyaltepec Mixtec","Yue Chinese","Malawian Sign Language","T'apo","Tarjumo","Xoo","Tabo","Maru","Bontok","Awara","Kato","Central Cagayan Agta","Zaramo","Baram Kayan","Musar","Gugadj","Hote","Rawang","Bumang","Kachama-Ganjule","Western Apache","Koongo","Mandarin Chinese","Lhokpu","North Ambrym","Kaian","Messapic","Basque (family)","Ansus","Arawete","Kanufi","Abipon","Aghul","Phimbi","Gawwada","Guntai","Northern Binukidnon","Ligbi","Tedaga","Nobiin","Huastec","Sio","Tifal","Phola","Paranan","Ayere","Nar Phu","Pahlavi","Ngurmbur","Sabine","Pyu (Papua New Guinea)","Mapia","Tagbanwa","Bacama","Dobel","Northern Kalapuya","Okolod","Hungarian","Djiwarli","Barakai","Duriankere","Boko (Benin)","Baima","Wik-Epa","Dedua","Wawonii","Faliscan","Hoti","Iyojwa'ja Chorote","Sudovian","Guayabero","Lipo","Seget","Benamanga","Gabogbo","Umon","Khe","Gorowa","Chincha Quechua","Ngumbarl","Panao Huanuco Quechua","Seti","Loncong","Malasar","Baan","Paku Karen","Aer","Carrier","Zapotec","Koitabu","Romano-Greek","Ampari Dogon","Palantla Chinantec","Dido","Tawang Monpa","Xaasongaxango","Tunni","Wongo","Kpelle","Sukurum","Xeta","Uzekwe","Bankan Tey Dogon","Uda","Tainae","Hukumina","Old Aramaic (up to 700 BCE)","Atemble","Official Aramaic (700-300 BCE)","Arhuaco","Northern Roglai","Tepo Krumen","Barro Negro Tunebo","Umbrian","Holoholo","Baybayanon","Beeke","Dieri","Rincon Zapotec","Kinalakna","Tanguat","Budukh","Northern Gondi","Tokano","Hanga Hundi","Pattani","Koro (India)","Awak","Southern One","Yamap","Sere","Amoltepec Mixtec","Molof","Axi Yi","Mashi (Zambia)","Hanunoo","Mende (Papua New Guinea)","Bats","Pardhi","Tartessian","Nigeria Mambila","Amanaye","Wano","Gronings","Aleut","Somray","Teme","Baraamu","Gondi","Martu Wangka","Bhaya","Bardi","Dar Daju Daju","Simbari","Batuley","Eastern Lalu","Caribbean Hindustani","Maleku Jaika","Oblo","Kao","Taino","Zayse-Zergulla","Crow","Kalasha","Malaysian Sign Language","Anuta","Nimoa","Kuikuro-Kalapalo","Burarra","Kagayanen","Ibanag","Enga","Eastern Cham","Gagauz","Waka","Germanic languages","Kupa","Lewo","Lopit","Gourmanchema","Kachi Koli","Borei","Rara Bakati'","Blissymbols","Eastern Khumi Chin","Kalenjin","Western Bukidnon Manobo","Bushi","Kudmali","Younuo Bunu","Classical Newari","Brunei Bisaya","South Muyu","Jara","Kur","Neku","Migabac","Parkari Koli","Wulna","Bali (Democratic Republic of Congo)","Dza","Badyara","Lang'e","Wares","Bavarian","Tegali","Arop-Sissano","Dusun Malang","Lahta Karen","Lambichhong","Wutung","Bora","Limilngan","Tanosy Malagasy","Od","Yakaikeke","Apinaye","Simeku","Bay Miwok","Mehri","Riantana","Bahonsuai","Saterfriesisch","Wa'ema","Angami Naga","Mi'kmaq","Kohistani Shina","Mbula-Bwazza","Chayuco Mixtec","Papora","Weme Gbe","Ngombe (Democratic Republic of Congo)","Ning","Karitiana","Lodhi","Indic languages","Worimi","Ingush","Dangaleat","Bembe","Mato","Sheko","Pakaasnovos","Gilaki","Saya","Maiwala","Quapaw","Lumba-Yakkha","Mal","Kunjen","Nateni","Lish","Liuqian Zhuang","Swampy Cree","Albarradas Sign Language","Uab Meto","Luba-Katanga","Sengseng","East Kewa","Bimoba","Botolan Sambal","Clallam","Watakataui","Somba-Siawari","Islander Creole English","Sardinian","Gbaya-Bossangoa","Dori'o","Kyenele","Sakirabia","Akurio","Papantla Totonac","Sos Kundi","South Slavey","Navut","Xhosa","Duau","Pe","Nusu","Puare","Murik (Papua New Guinea)","Queretaro Otomi","Boselewa","Mankiyali","Warlpiri","Lepcha","Quioquitani-Quieri Zapotec","Mpalitjanh","Putoh","Wardandi","Bangandu","Wailaki","Chitimacha","Ticuna","Che","Phende","Mbandja","Pangasinan","Yeniche","Man Met","Thai Song","Bodo Gadaba","Dolpo","Baramu","Adithinngithigh","Pohnpeian","Vishavan","Asu (Tanzania)","Dompo","Mun Chin","Batek","Susuami","Lillooet","A'ou","Nandi","Western Subanon","Malila","Abom","Grenadian Creole English","Southern Sama","Southern Luri","O'du","Unserdeutsch","Nkongho","Hyolmo","Khezha Naga","Vinza","Keninjal","Dhundari","Saraveca","Sayula Popoluca","East Ambae","Muruwari","Lower Burdekin","Akrukay","Konkani","Korra Koraga","Baluan-Pam","Hmong Don","Puyo-Paekche","Panobo","Quiripi","Chak","Mesme","Koroni","Afghan Sign Language","Jina","Alagwa","Lengola","Zimba","Omurano","Southern Lolopo","Zotung Chin","Tojolabal","Kwer","Groma","Rumai Palaung","Teutila Cuicatec","Ndombe","Mwani","Mabaan","Masai","Hijuk","Achi","Banda-Ndele","Nivacle","Navajo","Gunditjmara","Malfaxal","Para Arara","Khowar","Ngas","Nend","Mandingo","Gawri","Maltese","Ywom","Central American Indian languages","Abun","Kaan","Yawa","Chokwe","Megam","Tepeuxila Cuicatec","Tebul Sign Language","Port Sandwich","Massep","Seko Padang","Bo (Papua New Guinea)","Jad","Mawa (Chad)","Tanaina","Kap","Chug","Central Bontok","Semaq Beri","Mehek","China Buriat","Eskayan","Yoruba","N'Ko","Bughotu","North American Indian languages","Fania","Laz","Bu-Nao Bunu","Dacian","Tidaa Mixtec","Punan Merah","Nung (Viet Nam)","Olulumo-Ikom","Worrorra","Belanda Bor","Balkan Gagauz Turkish","Yaminahua","Mota","West Germanic languages","Banda (Indonesia)","Bafaw-Balong","Ukrainian","Minaveha","Fanagalo","Cavinena","Naga Pidgin","Sakata","North Efate","Nemi","Tocho","Buduma","Jaitmatang","Urali","Norse, Old","Russian Sign Language","Langbashe","Pouye","Bangka","Tunen","Kyerung","Zande languages","Hoia Hoia","Anfillo","Kioko","Archi","Mbwela","Kim","San Salvador Kongo","Isabi","San Martin Itunyoso Triqui","Eastern Nisu","Cypriot Arabic","Zaniza Zapotec","Tuma-Irumu","Con","Paekche","Pankhu","Mohave","Ladji Ladji","Upper Tanana","Dagba","Judeo-Iraqi Arabic","Biseni","Norwegian Nynorsk","Mongondow","Hmong-Mien languages","Faroese","Corsican","Kuuk-Yak","Mumuye","Maxi Gbe","Yaoure","Hamtai","Sikiana","Bung","Binahari","Dehwari","Dagik","Cofan","Akei","Beembe","Dawik Kui","Rawat","Yoy","Mboi","Tabassaran","Yagomi","Sindhi","Sawila","Ayi (Papua New Guinea)","Ede Cabe","Suba","Sierra Leone Sign Language","Boloki","Kamas","Iwur","Baikeno","Tanapag","Cutchi-Swahili","Isebe","Xamtanga","Jewish Babylonian Aramaic (ca. 200-1200 CE)","Dixon Reef","Upper Saxon","Itene","Mapos Buang","Southern Betsimisaraka Malagasy","Irarutu","Suruaha","Talaud","Komyandaret","Brokpake","Green Gelao","Ache","Coahuilteco","Michoacan Nahuatl","Kula","Baltic Romani","Northern Tarahumara","Vestinian","Sihuas Ancash Quechua","Kikai","Maguindanaon","Male (Papua New Guinea)","Vunapu","Dyugun","Komi","Ngarinyman","Tacahua Mixtec","Varhadi-Nagpuri","Fulah","Tok Pisin","Mala Malasar","Zimakani","Interlingue","Northeast Pashai","Eastern Durango Nahuatl","Vandalic","Epie","Tauade","Kelabit","Luhu","Kir-Balar","Tami","Bikol","Katso","Plains Miwok","Sauria Paharia","Karelian","Dakka","Epigraphic Mayan","Senara Senoufo","Uruguayan Sign Language","Pichis Asheninka","Abidji","Kenyang","Kabardian","Idu-Mishmi","Mewati","Ucayali-Yurua Asheninka","Kugbo","Swiss German","East Masela","Ikoma-Nata-Isenye","Gupapuyngu","Yuqui","Abaga","Mahali","Ndendeule","Mugom","Jamaican Sign Language","Ngadjuri","Retta","Jambi Malay","Nupbikha","Guugu Yimidhirr","Kabalai","Baharna Arabic","Penchal","Lampung Api","Romanian","Soga","Nnam","Middle Welsh","Kitan","Tuyuca","Finno-Ugrian languages","Zemgalian","Okpe (Northwestern Edo)","Provencal, Old (to 1500)","Ninia Yali","Puimei Naga","Kominimung","Teop","Jakati","Mbangala","Eastern Apurimac Quechua","Xwela Gbe","Numana","Uruava","Piemontese","Yangman","Mari","Nema","Ambo","Wymysorys","Kako","West Kewa","Demta","Talieng","Greek Sign Language","Yabula Yabula","Sholaga","Tokharian A","Mozarabic","Krymchak","Guerrero Amuzgo","Aimol","Geko Karen","Nyaneka","Southern Sami","Tieyaxo Bozo","Pam","Mamaa","Janji","Standard Estonian","Shanenawa","Umiray Dumaget Agta","Mandinka","Wasa","Samarokena","Urim","Yendang","Indonesian","Ukaan","Wahau Kenyah","Ngawun","Dibo","Kwa'","Osage","Urigina","Sarasira","Lemerig","Cashibo-Cacataibo","Loup A","Uduk","Liana-Seti","Logudorese Sardinian","Sarikoli","Metlatonoc Mixtec","Arguni","Lishana Deni","Mawchi","Gude","Ngabere","Limos Kalinga","Morelos Nahuatl","Bondei","Hewa","East Damar","Southern Tiwa","Aralle-Tabulahan","Helong","Kawaiisu","Old Korean (3rd-9th cent.)","Abinomn","Damal","Sanapana","Atampaya","Nalik","Purik","Jerriais","Korupun-Sela","Higaonon","Kurichiya","Konda-Dora","Heiltsuk","Kahe","Gugubera","Phai","Saposa","Kott","Ningera","Qabiao","Eitiep","Usaghade","Yanyuwa","Aweer","Tinigua","Malankuravan","Rajah Kabunsuwan Manobo","Carabayo","Algonquin","Yabaana","British Sign Language","Lenyima","Ditidaht","Merlav","Mayi-Thakurti","Koireng","Northern Embera","Biao-Jiao Mien","Tukang Besi South","Caramanta","Carolinian","Busang Kayan","Laari","Cotoname","Kavet","Santa Ines Yatzechi Zapotec","Brahui","Mwera (Chimwera)","Gamo-Ningi","Jirel","Ingrian","Berbice Creole Dutch","Dura","Baga Koga","Southeastern Tarahumara","Wae Rana","Nteng","Ik","Totontepec Mixe","Boro (Ethiopia)","Fernando Po Creole English","Nguon","Tanacross","Inuinnaqtun","Coatlan Zapotec","Northern Toussian","Niellim","Akpa","Seko Tengah","Djamindjung","Mango","Nyambo","Krio","Arabana","Cumanagoto","Terik","Balanta-Kentohe","Tehuelche","Garo","Huallaga Huanuco Quechua","Nganakarti","Lame","Inonhan","Cowlitz","Laarim","Gamale Kham","Cineni","As","Lampung Nyo","Temi","Kwanga","Kadaru","Tajik","Mlomp","Dar Sila Daju","Himarima","Luba-Lulua","Gupa-Abawa","Kereho","Guriaso","Olekha","Youle Jinuo","Lomavren","Wambon","Pite Sami","Classical Nahuatl","Tshangla","Fyam","Flinders Island","Ntcham","Sala","Mampruli","Omaha-Ponca","Nanticoke","Khandesi","Fanti","Manda (Australia)","Bagirmi Fulfulde","Tlacoapa Me'phaa","Nisga'a","Mandaic","Kasua","Hiri Motu","Traveller Norwegian","Ukpe-Bayobiri","Thado Chin","Ngando (Central African Republic)","Fala","Northern Khmer","Kayeli","Waamwang","Lumun","East Slavic languages","Kansa","Jibu","Mezquital Otomi","Orma","Warwar Feni","Sarangani Blaan","Mambai","Oroqen","Afar","Middle Cornish","Romanova","Samba Daka","Cusco Quechua","Kaulong","Eastern Acipa","Machinga","Gimnime","Assiniboine","Armazic","Phake","Aushi","Khana","Masaaba","Kwaja","Waorani","Kodia","Dao","Wane","Sobei","Southern Thai","Nigerian Fulfulde","Kaingang","Tocantins Asurini","Dzao Min","Masana","Woods Cree","Tepetotutla Chinantec","Nilo-Saharan languages","Elotepec Zapotec","Panasuan","Angolar"],"x.perl.coerce_rules"=>["From_str::to_lower"]}],clsets_after_type=>['$var->{clsets_after_base}[0]'],"clsets_after_type.alt.merge.merged"=>['$var->{clsets_after_base}[0]'],resolve_path=>["str"],type=>"str",v=>2};$var->{clsets_after_type}[0]=$var->{clsets_after_base}[0];$var->{"clsets_after_type.alt.merge.merged"}[0]=$var->{clsets_after_base}[0];$var};

1;
# ABSTRACT: Language code (alpha-2 or alpha-3)

__END__

=pod

=encoding UTF-8

=head1 NAME

Sah::SchemaR::language::code - Language code (alpha-2 or alpha-3)

=head1 VERSION

This document describes version 0.005 of Sah::SchemaR::language::code (from Perl distribution Sah-Schemas-Language), released on 2023-08-07.

=head1 DESCRIPTION

This module is automatically generated by Dist::Zilla::Plugin::Sah::Schemas during distribution build.

A Sah::SchemaR::* module is useful if a client wants to quickly lookup the base type of a schema without having to do any extra resolving. With Sah::Schema::*, one might need to do several lookups if a schema is based on another schema, and so on. Compare for example L<Sah::Schema::poseven> vs L<Sah::SchemaR::poseven>, where in Sah::SchemaR::poseven one can immediately get that the base type is C<int>. Currently L<Perinci::Sub::Complete> uses Sah::SchemaR::* instead of Sah::Schema::* for reduced startup overhead when doing tab completion.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Sah-Schemas-Language>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Sah-Schemas-Language>.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 CONTRIBUTING


To contribute, you can send patches by email/via RT, or send pull requests on
GitHub.

Most of the time, you don't need to build the distribution yourself. You can
simply modify the code, then test via:

 % prove -l

If you want to build the distribution (e.g. to try to install it locally on your
system), you can install L<Dist::Zilla>,
L<Dist::Zilla::PluginBundle::Author::PERLANCAR>,
L<Pod::Weaver::PluginBundle::Author::PERLANCAR>, and sometimes one or two other
Dist::Zilla- and/or Pod::Weaver plugins. Any additional steps required beyond
that are considered a bug and can be reported to me.

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2023, 2020, 2019, 2018 by perlancar <perlancar@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Sah-Schemas-Language>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=cut
