/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.objectbank.TokenizerFactory;
import edu.stanford.nlp.process.AbstractTokenizer;
import edu.stanford.nlp.process.Tokenizer;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeReader;
import edu.stanford.nlp.trees.TreeReaderFactory;
import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;

public class TreeTokenizerFactory
implements TokenizerFactory<Tree> {
    private TreeReaderFactory trf;

    public TreeTokenizerFactory(TreeReaderFactory trf) {
        this.trf = trf;
    }

    @Override
    public Tokenizer<Tree> getTokenizer(final Reader r) {
        return new AbstractTokenizer<Tree>(){
            TreeReader tr;
            {
                this.tr = TreeTokenizerFactory.this.trf.newTreeReader(r);
            }

            @Override
            public Tree getNext() {
                try {
                    return this.tr.readTree();
                }
                catch (IOException e) {
                    System.err.println("Error in reading tree.");
                    return null;
                }
            }
        };
    }

    @Override
    public Tokenizer<Tree> getTokenizer(Reader r, String extraOptions) {
        return this.getTokenizer(r);
    }

    @Override
    public Iterator<Tree> getIterator(Reader r) {
        return null;
    }

    @Override
    public void setOptions(String options) {
    }
}

