# Before `make install' is performed this script should be runnable with
# `make test'. After `make install' it should work as `perl 1.t'

#########################

# change 'tests => 1' to 'tests => last_test_to_print';

use strict;
use Test::More tests => 3;
BEGIN { use_ok('Lingua::Treebank') };

#########################

# Insert your test code below, the Test::More module is use()ed here so read
# its man page ( perldoc Test::More ) for help writing this test script.

my @utts = Lingua::Treebank->from_penn_fh(*DATA);

ok(@utts > 0, "successfully read in!");

cmp_ok(scalar @utts, '==', 335);

my $i = 0;
foreach (@utts) {
    $i++;
    my @words = $_->get_all_terminals();
#      diag (join '', "utterance $i: ", map {"$_"} @words, "\n");
}


__END__
*x*x*x*x*x*x*x*x*x*x*x*x*x*x*x*x*x*x*x*x*x*x*x*x*x*x*x*x*x*x*x*x*x*x*x*x*x*
*x*x*x*x*x*x*x*x*x*x*x*x*x*x*x*x*x*x*x*x*x*x*x*x*x*x*x*x*x*x*x*x*x*x*x*x*x*
*x*                                                                     *x*
*x*            Copyright (C) 1995 University of Pennsylvania            *x*
*x*                                                                     *x*
*x*    The data in this file are part of a preliminary version of the   *x*
*x*    Penn Treebank Corpus and should not be redistributed.  Any       *x*
*x*    research using this corpus or based on it should acknowledge     *x*
*x*    that fact, as well as the preliminary nature of the corpus.      *x*
*x*                                                                     *x*
*x*x*x*x*x*x*x*x*x*x*x*x*x*x*x*x*x*x*x*x*x*x*x*x*x*x*x*x*x*x*x*x*x*x*x*x*x*
*x*x*x*x*x*x*x*x*x*x*x*x*x*x*x*x*x*x*x*x*x*x*x*x*x*x*x*x*x*x*x*x*x*x*x*x*x*

( (CODE (SYM SpeakerB1) (. .) ))
( (INTJ (UH Hello) (. .) (-DFL- E_S) ))
( (CODE (SYM SpeakerA2) (. .) ))
( (INTJ (UH Hello) 
    (, ,)
    (-DFL- E_S) ))
( (CODE (SYM SpeakerB3) (. .) ))
( (INTJ (UH Hi) (. .) (-DFL- E_S) ))
( (CODE (SYM SpeakerA4) (. .) ))
( (INTJ (UH Hello) (-DFL- E_S) ))
( (S 
    (NP-SBJ (DT this) )
    (VP (VBZ is) 
      (NP-PRD (NNS Lois) ))
    (. .) (-DFL- E_S) ))
( (CODE (SYM SpeakerB5) (. .) ))
( (INTJ (UH Hi) 
    (, ,)
    (-DFL- E_S) ))
( (INTJ (UH hi) 
    (, ,)
    (-DFL- E_S) ))
( (S 
    (NP-SBJ (DT this) )
    (VP (VBZ is) 
      (NP-PRD (NNP Lisa) ))
    (. .) (-DFL- E_S) ))
( (CODE (SYM SpeakerA6) (. .) ))
( (S (CC And) 
    (, ,)
    (INTJ (UH uh) )
    (, ,) 
    (NP-SBJ (PRP I) )
    (VP (VBD called) 
      (PRN 
        (S 
          (NP-SBJ (PRP you) )
          (VP (VBP know) ))
        (, ,) )
      (PP (IN from) 
        (EDITED 
          (RM (-DFL- \[) )
          (EDITED 
            (RM (-DFL- \[) )
            (NP-UNF (DT that) )
            (, ,) 
            (IP (-DFL- \+) ))
          (NP-UNF (DT the) )
          (, ,) 
          (RS (-DFL- \]) )
          (IP (-DFL- \+) ))
        (NP (DT the) 
          (RS (-DFL- \]) )
          (NNP T) (NNP I) (NNP Data) (NNP Base) (NNP Calling) (NNPS Instructions) )))
    (. .) (-DFL- E_S) ))
( (CODE (SYM SpeakerB7) (. .) ))
( (INTJ (UH Uh-huh) (. .) (-DFL- E_S) ))
( (INTJ (UH Yeah) 
    (, ,)
    (-DFL- E_S) ))
( (S 
    (NP-SBJ (PRP I) )
    (VP (VBD got) 
      (NP (DT a) (NN call) )
      (ADVP-TMP (NN yesterday) )
      (ADVP (RB too) ))
    (. .) (-DFL- E_S) ))
( (S 
    (NP-SBJ (DT This) )
    (VP (VBZ is) 
      (NP-PRD (DT a) (JJ different) (NN subject) )
      (ADVP (RB though) ))
    (. .) (-DFL- E_S) ))
( (CODE (SYM SpeakerA8) (. .) ))
( (INTJ (UH Yeah) 
    (, ,)
    (-DFL- E_S) ))
( (S 
    (NP-SBJ (DT this) )
    (VP (VBZ is) 
      (PP-PRD (IN about) 
        (NP 
          (NP (NNS changes) )
          (PP (IN in) 
            (NP (DT the) (NNS women) ))
          (PP (IN in) 
            (NP-UNF (DT the) )))))
    (, ,) (-DFL- N_S) ))
( (CODE (SYM SpeakerB9) (. .) ))
( (INTJ (UH Uh-huh) (. .) (-DFL- E_S) ))
( (CODE (SYM SpeakerA10) (. .) ))
( (SQ 
    (S 
      (INTJ (UH Uh) )
      (, ,) 
      (NP-SBJ (EX there) )
      (VP (BES 's) 
        (ADVP (RB really) )
        (NP-PRD (DT a) (NN lot) )))
    (, ,) 
    (SQ (VBZ is) (RB n't) 
      (NP-SBJ (RB there) )
      (NP-PRD (-NONE- *?*) ))
    (. .) (-DFL- E_S) ))
( (CODE (SYM SpeakerB11) (. .) ))
( (INTJ (UH Yeah) (. .) (-DFL- E_S) ))
( (CODE (SYM SpeakerA12) (. .) ))
( (S 
    (NP-SBJ (PRP I) )
    (VP (VBP think) 
      (SBAR (-NONE- 0) 
        (S 
          (NP-SBJ (EX there) )
          (ADVP (RB really) )
          (VP (VBZ is) 
            (NP-PRD (-NONE- *?*) )))))
    (. .) (-DFL- E_S) ))
( (CODE (SYM SpeakerB13) (. .) ))
( (S 
    (NP-SBJ (PRP It) )
    (VP (BES 's) 
      (ADVP (RB kind) (RB of) )
      (NP-PRD 
        (NP (DT an) (JJ easy) (NN thing) )
        (SBAR 
          (WHNP-1 (-NONE- 0) )
          (S 
            (NP-SBJ (-NONE- *) )
            (VP (TO to) 
              (VP (VB talk) 
                (PP (IN about) 
                  (NP (-NONE- *T*-1) ))))))))
    (. .) (-DFL- E_S) ))
( (CODE (SYM SpeakerA14) (. .) ))
( (SQ 
    (S 
      (INTJ (UH Oh) )
      (, ,) 
      (NP-SBJ (PRP I) )
      (VP (VBP guess) 
        (SBAR (-NONE- 0) 
          (S 
            (NP-SBJ (DT the) (NN work) (NN force) )
            (VP (MD would) 
              (VP (VB be) 
                (NP-UNF-PRD (DT the) (JJ main) )))))))
    (, ,) 
    (SQ (MD would) (RB n't) 
      (NP-SBJ (PRP it) )
      (VP (-NONE- *?*) ))
    (. .) (-DFL- E_S) ))
( (CODE (SYM SpeakerB15) (. .) ))
( (INTJ 
    (INTJ (UH Yeah) )
    (, ,) 
    (INTJ (UH uh) )
    (, ,) (-DFL- E_S) ))
( (S 
    (NP-SBJ (PRP I) )
    (VP (VBP think) 
      (SBAR (-NONE- 0) 
        (S 
          (NP-SBJ-1 (PRP you) )
          (VP (VBP have) 
            (S 
              (NP-SBJ (-NONE- *-1) )
              (VP (TO to) 
                (VP (VB push) 
                  (NP (CD one) ))))))))
    (-DFL- E_S) ))
( (S 
    (CC and)
    (ADVP-TMP (RB then) )
    (NP-SBJ-1 (PRP we) )
    (VP (MD can) 
      (VP (VB start) 
        (S 
          (NP-SBJ (-NONE- *-1) )
          (VP (VBG recording) 
            (NP (PRP it) )))))
    (. .) (-DFL- E_S) ))
( (CODE (SYM SpeakerA16) (. .) ))
( (INTJ (UH Okay) (. .) (-DFL- E_S) ))
( (INTJ (RB All) (JJ right) (. .) (-DFL- E_S) ))
( (CODE (SYM SpeakerB17) (. .) ))
( (INTJ (UH Okay) (. .) (-DFL- E_S) ))
( (CODE (SYM SpeakerA18) (. .) ))
( (SQ (VBP Are) 
    (NP-SBJ (PRP you) )
    (ADJP-PRD (JJ ready) )
    (ADVP-TMP (RB now) )
    (. ?) (-DFL- E_S) ))
( (CODE (SYM SpeakerB19) (. .) ))
( (INTJ (UH Yes) (. .) (-DFL- E_S) ))
( (CODE (SYM SpeakerA20) (. .) ))
( (INTJ (UH Okay) 
    (, ,)
    (-DFL- E_S) ))
( (S 
    (SBAR-ADV (IN like) 
      (S 
        (NP-SBJ (PRP I) )
        (VP (VBD said) )))
    (NP-SBJ (PRP I) )
    (VP (VBP guess) 
      (SBAR (-NONE- 0) 
        (S 
          (NP-SBJ (PRP it) )
          (VP (MD would) 
            (VP (VB be) 
              (NP-PRD (DT the) (NN work) (NN force) )
              (PRN 
                (, ,)
                (S 
                  (NP-SBJ (PRP you) )
                  (VP (VBP know) ))
                (, ,) )
              (ADVP 
                (ADVP (RB as) (RB far) )
                (PP (IN as) 
                  (NP 
                    (NP (NNS changes) )
                    (PP (IN in) 
                      (NP (DT the) (NNS generations) ))))))))))
    (. .) (-DFL- E_S) ))
( (CODE (SYM SpeakerB21) (. .) ))
( (INTJ (UH Yes) 
    (, ,)
    (-DFL- E_S) ))
( (S 
    (NP-SBJ (PRP I) )
    (VP (VBP know) 
      (SBAR-PRP (IN because) 
        (, ,)
        (S 
          (NP-SBJ (PRP I) )
          (VP (VBP know) 
            (SBAR (-NONE- 0) 
              (S 
                (SBAR-TMP 
                  (WHADVP-1 (WRB when) )
                  (S 
                    (NP-SBJ (PRP$ my) (NN mother) )
                    (VP (VBD was) 
                      (EDITED 
                        (RM (-DFL- \[) )
                        (NP-PRD-UNF (DT a) )
                        (, ,) 
                        (IP (-DFL- \+) ))
                      (RS (-DFL- \]) )
                      (PRN 
                        (S 
                          (NP-SBJ (PRP you) )
                          (VP (VBP know) ))
                        (, ,) )
                      (VP (VBG going) 
                        (PP-DIR (IN into) 
                          (NP (DT the) (NN work) (NN force) ))
                        (ADVP-TMP (-NONE- *T*-1) )))))
                (NP-SBJ (RB there) )
                (VP (VBD was) (RB n't) 
                  (NP-PRD (RB very) (JJ many) (NNS opportunities) )
                  (PP (IN for) 
                    (NP (PRP her) ))
                  (PRN 
                    (, ,)
                    (S 
                      (NP-SBJ (PRP I) )
                      (VP (VBP guess) ))))))))))
    (, ,) (-DFL- E_S) ))
( (S 
    (NP-SBJ (PRP she) )
    (VP (BES 's) 
      (PP-PRD (IN in) 
        (NP (PRP$ her) (JJ late) (NNS forties) )))
    (. .) (-DFL- E_S) ))
( (S 
    (NP-SBJ-1 (PRP You) )
    (VP (VBD were) 
      (VP (JJ expected) 
        (S 
          (NP-SBJ (-NONE- *-1) )
          (VP (TO to) 
            (VP 
              (VP (VB stay) 
                (ADVP-LOC (RB home) ))
              (CC and) 
              (VP (VB take) 
                (NP (NN care) )
                (PP (IN of) 
                  (NP (DT the) (NNS kids) ))))))))
    (-DFL- E_S) ))
( (S 
    (CC and)
    (NP-SBJ (PRP I) )
    (VP (VBP 've) 
      (ADVP-TMP (RB never) )
      (VP (VBN faced) 
        (NP (DT that) )
        (ADVP (IN at) (DT all) )))
    (. .) (-DFL- E_S) ))
( (CODE (SYM SpeakerA22) (. .) ))
( (INTJ 
    (INTJ (UH Uh) )
    (, ,) 
    (INTJ (UH no) )
    (, ,) (-DFL- E_S) ))
( (S 
    (NP-SBJ (PRP I) )
    (VP (VBP think) 
      (SBAR (-NONE- 0) 
        (S 
          (EDITED 
            (RM (-DFL- \[) )
            (ADVP-TMP-UNF (RB no-) )
            (, ,) 
            (IP (-DFL- \+) ))
          (ADVP-TMP (RB now) )
          (, ,) 
          (RS (-DFL- \]) )
          (NP-SBJ (PRP you) )
          (VP (VBP go) 
            (PP-DIR (IN to) 
              (NP (NN work) ))
            (SBAR-TMP 
              (WHADVP-1 (WRB when) )
              (S 
                (NP-SBJ (PRP they) )
                (VP (VBP 're) 
                  (ADJP-PRD 
                    (NP-ADV (CD six) (NNS weeks) )
                    (JJ old) )
                  (PRN 
                    (, ,)
                    (S 
                      (NP-SBJ (PRP you) )
                      (VP (VBP know) )))
                  (ADVP-TMP (-NONE- *T*-1) ))))))))
    (, ,) (-DFL- E_S) ))
( (CODE (SYM SpeakerB23) (. .) ))
( (INTJ (UH Uh-huh) (. .) (-DFL- E_S) ))
( (CODE (SYM SpeakerA24) (. .) ))
( (S 
    (CC and)
    (NP-SBJ (PRP you) )
    (VP (VBP stay) 
      (ADVP-LOC (RB there) ))
    (. .) (-DFL- E_S) ))
( (S (CC And) 
    (NP-SBJ (PRP I) )
    (VP (VBP feel) 
      (SBAR (IN like) 
        (S 
          (NP-TMP (DT the) (JJ next) (NN generation) )
          (, ,) 
          (NP-SBJ (PRP you) )
          (VP (MD 'll) 
            (ADVP (RB probably) )
            (ADVP (RB just) )
            (VP (VB work) 
              (PP 
                (ADVP (RB right) )
                (IN along) 
                (PP (IN with) 
                  (NP (PRP$ your) (NN husband) )))
              (PRN 
                (, ,)
                (S 
                  (NP-SBJ (PRP you) )
                  (VP (VBP know) ))))))))
    (. .) (-DFL- E_S) ))
( (CODE (SYM SpeakerB25) (. .) ))
( (INTJ (UH Yeah) 
    (, ,)
    (-DFL- E_S) ))
( (INTJ (UH uh-huh) 
    (, ,)
    (-DFL- E_S) ))
( (S 
    (NP-SBJ (PRP I) )
    (VP (VBP think) 
      (SBAR (-NONE- 0) 
        (S 
          (NP-SBJ (PRP it) )
          (VP (HVS 's) 
            (ADVP (RB definitely) )
            (VP (VBN gotten) 
              (ADJP-PRD (JJR better) ))))))
    (. .) (-DFL- E_S) ))
( (CODE (SYM SpeakerA26) (. .) ))
( (S 
    (INTJ (UH Oh) )
    (, ,) 
    (NP-SBJ (PRP I) )
    (VP (VBP do) 
      (ADVP 
        (TYPO (^RB to) )))
    (, ,) ))
( (ADJP (JJ much) (. .) (-DFL- E_S) ))
( (S (CC And) 
    (NP-SBJ-1 (PRP it) )
    (VP (BES 's) 
      (ADVP (RB just) )
      (VP (VBG going) 
        (S 
          (NP-SBJ (-NONE- *-1) )
          (VP (TO to) 
            (VP (VB get) 
              (ADJP-PRD (JJR better) ))))))
    (. .) (-DFL- E_S) ))
( (CODE (SYM SpeakerB27) (. .) ))
( (INTJ (UH Uh-huh) (. .) (-DFL- E_S) ))
( (CODE (SYM SpeakerA28) (. .) ))
( (S 
    (NP-SBJ (PRP It) )
    (ADVP (RB really) )
    (VP (VBZ is) 
      (VP (-NONE- *?*) ))
    (. .) (-DFL- E_S) ))
( (CODE (SYM SpeakerB29) (. .) ))
( (SBAR-PRP (IN Because) 
    (S 
      (NP-SBJ (NNS women) )
      (VP (VBP are) 
        (PP-PRD (IN in) 
          (NP (DT every) (NN field) ))
        (ADVP-TMP (RB now) )))
    (, ,) (-DFL- E_S) ))
( (S 
    (PRN 
      (S 
        (NP-SBJ (PRP I) )
        (VP (VBP mean) )))
    (NP-SBJ (PRP I) )
    (VP (MD ca) (RB n't) 
      (VP (VB think) 
        (PP (IN of) 
          (NP 
            (NP (DT a) (NN field) )
            (SBAR 
              (WHNP-2 (WDT that) )
              (S 
                (NP-SBJ (PRP they) )
                (VP (VBP 're) (RB not) 
                  (ADJP-PRD (JJ involved) 
                    (PP (IN in) 
                      (NP (-NONE- *T*-2) ))))))))))
    (. .) (-DFL- E_S) ))
( (CODE (SYM SpeakerA30) (. .) ))
( (S 
    (INTJ (UH Oh) )
    (, ,) 
    (NP-SBJ (PRP I) )
    (VP (MD ca) (RB n't) 
      (ADVP (RB either) ))
    (, ,) ))
( (NP (RB not) (DT a) (CD one) (. .) (-DFL- E_S) ))
( (CODE (SYM SpeakerB31) (. .) ))
( (S (CC And) 
    (NP-SBJ (PRP I) )
    (VP (VBP know) 
      (SBAR (-NONE- 0) 
        (S 
          (ADVP (IN at) (JJS least) )
          (PP (IN in) 
            (NP (DT the) (JJ medical) (NN field) ))
          (, ,) 
          (NP-SBJ (PRP it) )
          (VP (VBZ seems) 
            (SBAR (IN like) 
              (S 
                (NP-SBJ (PRP they) )
                (VP (VBP 've) 
                  (VP (VBN come) 
                    (PRT (RP out) )
                    (PP (IN with) 
                      (NP 
                        (NP (DT a) (NN lot) (JJR further) (NNS advances) )
                        (ADVP 
                          (ADVP (RB as) (RB far) )
                          (PP (IN as) 
                            (NP 
                              (NP (JJ female) (NNS medications) )
                              (CC and) 
                              (NP (NNS things) ))))))
                    (SBAR-TMP (IN since) 
                      (S 
                        (NP-SBJ (NNS women) )
                        (VP (VBP have) 
                          (VP (VBN gotten) 
                            (PP (IN into) 
                              (NP (DT the) (NN doctor) (NN field) ))))))))))))))
    (. .) (-DFL- E_S) ))
( (CODE (SYM SpeakerA32) (. .) ))
( (INTJ (UH Uh-huh) (. .) (-DFL- E_S) ))
( (CODE (SYM SpeakerB33) (. .) ))
( (S 
    (NP-SBJ (PRP I) )
    (VP (VBP do) (RB n't) 
      (VP (VB think) 
        (SBAR (IN that) 
          (S 
            (NP-SBJ (NNS men) )
            (ADVP (RB really) )
            (VP (VBD took) 
              (NP 
                (NP (DT the) (NN time) )
                (SBAR 
                  (WHADVP-1 (-NONE- 0) )
                  (S 
                    (NP-SBJ (-NONE- *) )
                    (VP (TO to) 
                      (VP (VB work) 
                        (PP (IN on) 
                          (NP 
                            (NP (DT that) (NN sort) )
                            (PP (IN of) 
                              (NP (NN thing) ))))
                        (ADVP (-NONE- *T*-1) )))))))))))
    (. .) (-DFL- E_S) ))
( (CODE (SYM SpeakerA34) (. .) ))
( (INTJ (UH Yeah) 
    (, ,)
    (-DFL- E_S) ))
( (S 
    (ADVP (RB even) )
    (PP-LOC (IN in) 
      (NP (NNP Washington) ))
    (PRN 
      (, ,)
      (S 
        (NP-SBJ (PRP you) )
        (VP (VBP know) ))
      (, ,) )
    (NP-SBJ-1 (EX there) )
    (VP (VBZ seems) 
      (S 
        (NP-SBJ (-NONE- *-1) )
        (VP (TO to) 
          (VP (VB be) 
            (NP-PRD 
              (NP 
                (ADJP 
                  (NP-ADV (DT a) (RB lot) )
                  (JJR more) )
                (NNS women) )
              (ADJP (JJ involved) ))))))
    (. .) (-DFL- E_S) ))
( (CODE (SYM SpeakerB35) (. .) ))
( (INTJ (UH Yeah) (. .) (-DFL- E_S) ))
( (CODE (SYM SpeakerA36) (. .) ))
( (CODE (SYM SpeakerB37) (. .) ))
( (S 
    (ADVP (RB Hopefully) )
    (, ,) 
    (NP-TMP (DT the) (JJ next) (NN generation) )
    (, ,) 
    (NP-SBJ (PRP it) )
    (VP (MD wo) (RB n't) 
      (ADVP (RB even) )
      (VP (VB be) 
        (NP-PRD (DT an) (NN issue) )))
    (, ,) (-DFL- E_S) ))
( (S 
    (PRN 
      (S 
        (NP-SBJ (PRP I) )
        (VP (VBP mean) )))
    (NP-SBJ (NNS people) )
    (VP (MD will) 
      (ADVP (RB just) )
      (VP (VB look) 
        (PP (IN at) 
          (NP (PRP you) ))
        (PP 
          (PP (IN as) 
            (NP (DT a) (NN person) ))
          (CC and) (RB not) 
          (PP (IN as) 
            (NP 
              (NP (DT a) (NN man) )
              (CC or) 
              (NP (DT a) (NN woman) ))))))
    (, ,) (-DFL- E_S) ))
( (CODE (SYM SpeakerA38) (. .) ))
( (INTJ (UH Yeah) 
    (, ,)
    (-DFL- E_S) ))
( (INTJ (UH yeah) (. .) (-DFL- E_S) ))
( (CODE (SYM SpeakerB39) (. .) ))
( (S 
    (NP-SBJ (PRP I) )
    (VP (VBP think) 
      (SBAR (-NONE- 0) 
        (S 
          (NP-SBJ (DT that) )
          (VP (MD would) 
            (VP (VB be) 
              (NP-PRD (DT the) (JJS best) (NN goal) ))))))
    (. .) (-DFL- E_S) ))
( (CODE (SYM SpeakerA40) (. .) ))
( (S 
    (INTJ (UH Oh) )
    (, ,) 
    (NP-SBJ (PRP I) )
    (VP (VBP do) 
      (ADVP (RB too) ))
    (, ,) (-DFL- E_S) ))
( (NP 
    (ADVP (RB just) )
    (PRP$ your) (NNS qualifications) (-DFL- E_S) ))
( (S 
    (CC and)
    (NP-SBJ (DT that) )
    (VP (MD would) 
      (VP (VB be) 
        (NP-PRD (PRP it) )))
    (. .) (-DFL- E_S) ))
( (CODE (SYM SpeakerB41) (. .) ))
( (INTJ (UH Uh-huh) 
    (, ,)
    (-DFL- E_S) ))
( (ADVP (UH exactly) 
    (, ,)
    (-DFL- E_S) ))
( (FRAG (RB not) 
    (SBAR 
      (WHNP-1 (WDT what) (NN color) )
      (S 
        (NP-SBJ (PRP you) )
        (VP (VBP are) 
          (NP-PRD (-NONE- *T*-1) ))))
    (, ,) 
    (SBAR 
      (WHADJP-2 (WRB how) (JJ old) )
      (S 
        (NP-SBJ (PRP you) )
        (VP (VBP are) 
          (ADJP-PRD (-NONE- *T*-2) ))))
    (, ,) 
    (SBAR 
      (TYPO (WP what) )
      (S 
        (NP-SBJ (PRP you) )
        (VP (VBP 're) 
          (ADJP-PRD (JJ male) (CC or) (JJ female) ))))
    (. .) (-DFL- E_S) ))
( (S 
    (NP-SBJ (DT That) )
    (VP (MD would) 
      (VP (VB be) 
        (ADJP-PRD (JJ wonderful) )))
    (, ,) (-DFL- E_S) ))
( (S 
    (NP-SBJ (PRP I) )
    (VP (VBP guess) 
      (SBAR (-NONE- 0) 
        (S 
          (NP-SBJ (PRP it) )
          (VP (BES 's) 
            (ADVP (RB kind) (RB of) )
            (NP-PRD (DT an) (JJ ideal) (NN world) )
            (ADVP (RB though) ))))
      (, ,) 
      (INTJ (UH huh) ))
    (. .) (-DFL- E_S) ))
( (CODE (SYM SpeakerA42) (. .) ))
( (INTJ (UH Yeah) 
    (, ,)
    (-DFL- E_S) ))
( (S 
    (NP-SBJ (PRP I) )
    (ADVP (RB kind) (RB of) )
    (VP (VBP think) 
      (, ,)
      (SBAR 
        (ADVP (RB maybe) )
        (PP-TMP (IN in) 
          (NP (NN time) ))
        (, ,) (IN that) 
        (PRN 
          (, ,)
          (S 
            (NP-SBJ (PRP you) )
            (VP (VBP know) ))
          (, ,) )
        (S 
          (NP-SBJ (PRP you) )
          (VP (MD 'll) 
            (VP (VB go) 
              (PP (IN by) 
                (NP (JJ social) (NN security) (NNS numbers) ))))))
      (PRN 
        (, ,)
        (S 
          (NP-SBJ (PRP you) )
          (VP (VBP know) ))))
    (, ,) (-DFL- E_S) ))
( (CODE (SYM SpeakerB43) (. .) ))
( (INTJ (UH Yeah) (. .) (-DFL- E_S) ))
( (CODE (SYM SpeakerA44) (. .) ))
( (S 
    (CC and)
    (NP-MNR (DT that) (NN way) )
    (NP-SBJ (PRP they) )
    (VP (MD ca) (RB n't) 
      (VP (VB say) 
        (S-SEZ 
          (INTJ (UH well) )
          (NP-SBJ (PRP they) )
          (VP 
            (VP (VBD picked) 
              (NP-1 (DT a) (NN male) )
              (PP-2 (IN over) 
                (NP (DT a) (NN female) )))
            (, ,) 
            (VP 
              (NP-1 (JJ female) )
              (PP-2 (IN over) 
                (NP (DT a) (NN male) )))))
        (PRN 
          (, ,)
          (S 
            (NP-SBJ (PRP you) )
            (VP (VBP know) )))))
    (, ,) (-DFL- E_S) ))
( (CODE (SYM SpeakerB45) (. .) ))
( (INTJ (UH Exactly) 
    (, ,)
    (-DFL- E_S) ))
( (FRAG (CC or) 
    (NP 
      (NP (DT the) (NN way) )
      (SBAR 
        (WHADVP-1 (-NONE- 0) )
        (S 
          (NP-SBJ (PRP you) )
          (VP (VBP look) 
            (ADVP-MNR (-NONE- *T*-1) )))))
    (, ,) (-DFL- E_S) ))
( (FRAG (CC or) 
    (NP 
      (NP (DT the) (NN way) )
      (SBAR 
        (WHADVP (-NONE- 0) )
        (S-UNF 
          (NP-SBJ (PRP you) )
          (PRN 
            (, ,)
            (S 
              (NP-SBJ (PRP you) )
              (VP (VBP know) ))))))
    (, ,) (-DFL- N_S) ))
( (CODE (SYM SpeakerA46) (. .) ))
( (INTJ (UH Yeah) 
    (, ,)
    (-DFL- E_S) ))
( (INTJ (UH yeah) (. .) (-DFL- E_S) ))
( (CODE (SYM SpeakerB47) (. .) ))
( (NP 
    (NP (PRP$ your) (NN age) )
    (CC or) 
    (NP (NN anything) )
    (. .) (-DFL- E_S) ))
( (S 
    (NP-SBJ (PRP I) )
    (VP (VBP think) 
      (SBAR (-NONE- 0) 
        (S 
          (NP-SBJ (DT that) )
          (VP (MD would) 
            (VP (VB be) 
              (NP-PRD 
                (NP (DT a) (JJ wonderful) (NN way) )
                (SBAR 
                  (WHADVP-1 (-NONE- 0) )
                  (S 
                    (NP-SBJ (-NONE- *) )
                    (VP (TO to) 
                      (VP (VB do) 
                        (NP (PRP it) )
                        (ADVP-MNR (-NONE- *T*-1) )))))))))))
    (. .) (-DFL- E_S) ))
( (CODE (SYM SpeakerA48) (. .) ))
( (S 
    (NP-SBJ (PRP I) )
    (VP (VBP do) 
      (ADVP 
        (TYPO (TO to) )))
    (-DFL- E_S) ))
( (S 
    (ADVP (RB just) )
    (NP-SBJ (-NONE- *) )
    (VP 
      (VP (VB go) 
        (PP (IN by) 
          (NP (PRP$ your) (JJ social) (NN security) (NN number) )))
      (CONJP 
        (CC and)
        (RB then) )
      (VP (VB look) 
        (PP (IN at) 
          (NP 
            (NP 
              (TYPO (PRP you) )
              (NNS qualifications) )
            (EDITED 
              (RM (-DFL- \[) )
              (SBAR-UNF 
                (WHNP (WDT that) ))
              (, ,) 
              (IP (-DFL- \+) ))
            (PRN 
              (S 
                (NP-SBJ (PRP you) )
                (VP (VBP know) ))
              (, ,) )
            (SBAR 
              (WHNP-1 (WDT that) )
              (RS (-DFL- \]) )
              (S 
                (NP-SBJ (PRP you) )
                (VP (VBP have) 
                  (NP (-NONE- *T*-1) ))))))))
    (. .) (-DFL- E_S) ))
( (CODE (SYM SpeakerB49) (. .) ))
( (INTJ (UH Uh-huh) 
    (, ,)
    (-DFL- E_S) ))
( (S-UNF 
    (CONJP 
      (CC and)
      (RB then) )
    (, ,) (-DFL- N_S) ))
( (CODE (SYM SpeakerA50) (. .) ))
( (S-UNF 
    (CONJP (CC And) (RB then) )
    (SBAR-ADV (IN if) 
      (S 
        (NP-SBJ (PRP you) )
        (VP (VBP get) 
          (NP (PRP it) ))))
    (PRN 
      (, ,)
      (S 
        (NP-SBJ (PRP you) )
        (VP (VBP know) )))
    (ADVP-TMP (RB then) )
    (, ,) (-DFL- N_S) ))
( (CODE (SYM SpeakerB51) (. .) ))
( (INTJ (UH Uh-huh) 
    (, ,)
    (-DFL- E_S) ))
( (S (RB also) 
    (, ,)
    (SBAR-ADV (IN with) 
      (, ,)
      (INTJ (UH uh) )
      (, ,) 
      (S 
        (NP-SBJ (NNS women) )
        (PP-PRD (IN in) 
          (NP (DT the) (NN work) (NN force) ))))
    (NP-SBJ (PRP they) )
    (VP (VBP 've) 
      (VP (VBN gotten) 
        (NP 
          (ADJP 
            (NP-ADV (DT a) (NN lot) )
            (JJR more) )
          (NNS options) )
        (ADVP 
          (ADVP (RB as) (RB far) )
          (PP (IN as) 
            (PRN 
              (, ,)
              (S 
                (NP-SBJ (PRP you) )
                (VP (VBP know) ))
              (, ,) )
            (PRN 
              (SBARQ 
                (WHNP-1 (WP what) )
                (SQ (BES 's) 
                  (NP-SBJ-2 (PRP it) )
                  (VP (VBN called) 
                    (S 
                      (NP-SBJ (-NONE- *-2) )
                      (NP-PRD (-NONE- *T*-1) )))))
              (, ,) )
            (NP (NN job) (NN sharing) )))))
    (. .) (-DFL- E_S) ))
( (CODE (SYM SpeakerA52) (. .) ))
( (INTJ (UH Uh-huh) (. .) (-DFL- E_S) ))
( (CODE (SYM SpeakerB53) (. .) ))
( (SBAR-ADV 
    (INTJ (UH Like) )
    (IN if) 
    (S 
      (NP-SBJ-1 
        (NP (PRP you) )
        (CC and) 
        (NP (DT another) (NN lady) ))
      (VP (VBD were) 
        (S 
          (NP-SBJ (-NONE- *-1) )
          (VP (TO to) 
            (VP-UNF 
              (VP (VB share) 
                (NP (DT the) (JJ same) (JJ full) (NN time) (NN job) ))
              (, ,) (CC or) )))))
    (, ,) (-DFL- N_S) ))
( (CODE (SYM SpeakerA54) (. .) ))
( (INTJ 
    (INTJ (UH Oh) )
    (, ,) 
    (INTJ (UH yeah) )
    (. .) (-DFL- E_S) ))
( (CODE (SYM SpeakerB55) (. .) ))
( (CODE (SYM SpeakerA56) (. .) ))
( (S 
    (PP (IN As) 
      (NP 
        (NP (DT a) (NN matter) )
        (PP (IN of) 
          (NP (NN fact) ))))
    (, ,) 
    (NP-SBJ (DT that) )
    (VP (BES 's) 
      (SBAR-NOM-PRD 
        (WHNP-1 (WP what) )
        (S 
          (NP-SBJ (PRP I) )
          (VP (VBP 'm) 
            (VP (VBG doing) 
              (NP (-NONE- *T*-1) ))))))
    (. .) (-DFL- E_S) ))
( (CODE (SYM SpeakerB57) (. .) ))
( (SQ (VBZ Is) 
    (NP-SBJ (PRP it) )
    (NP-PRD (-NONE- *?*) )
    (. .) (-DFL- E_S) ))
( (CODE (SYM SpeakerA58) (. .) ))
( (INTJ (UH Uh-huh) 
    (, ,)
    (-DFL- E_S) ))
( (S 
    (NP-SBJ (PRP it) )
    (ADVP (RB sure) )
    (VP (VBZ is) 
      (NP-PRD (-NONE- *?*) ))
    (. .) (-DFL- E_S) ))
( (CODE (SYM SpeakerB59) (. .) ))
( (S 
    (NP-SBJ (DT That) )
    (VP (MD would) 
      (VP (VB be) 
        (ADJP-PRD (JJ great) )))
    (. .) (-DFL- E_S) ))
( (CODE (SYM SpeakerA60) (. .) ))
( (S 
    (NP-SBJ (PRP It) )
    (ADVP (RB sure) )
    (VP (VBZ is) 
      (ADJP-PRD (-NONE- *?*) ))
    (. .) (-DFL- E_S) ))
( (CODE (SYM SpeakerB61) (. .) ))
( (S (CC Or) 
    (, ,)
    (NP-TPC 
      (NP 
        (NP (DT a) (NN lot) )
        (PP (IN of) 
          (NP (NNS women) ))
        (SBAR 
          (WHNP-1 (-NONE- 0) )
          (S 
            (NP-SBJ (PRP I) )
            (VP (VBP know) 
              (ADVP-TMP (RB now) )
              (NP (-NONE- *T*-1) )))))
      (CC and) 
      (EDITED 
        (RM (-DFL- \[) )
        (NP-UNF (PRP$ my) )
        (, ,) 
        (IP (-DFL- \+) ))
      (INTJ (UH uh) )
      (, ,) 
      (NP 
        (NP (CD one) )
        (PP (IN of) 
          (NP (PRP$ my) 
            (RS (-DFL- \]) )
            (NNS supervisors) ))))
    (, ,) 
    (SBAR-TMP 
      (WHADVP-3 (WRB when) )
      (S 
        (NP-SBJ-2 (PRP she) )
        (VP (VBD went) 
          (PP (IN on) 
            (NP (NNP L) (NNP O) (NNP A) ))
          (S-PRP 
            (NP-SBJ (-NONE- *-2) )
            (VP (TO to) 
              (VP (VB have) 
                (NP (PRP$ her) (NN baby) ))))
          (ADVP-TMP (-NONE- *T*-3) ))))
    (, ,) 
    (NP-SBJ (PRP we) )
    (VP (VBD hooked) 
      (PRT (RP up) )
      (, ,) 
      (INTJ (UH uh) )
      (, ,) 
      (INTJ (UH uh) )
      (, ,) 
      (NP (DT a) (NN terminal) )
      (PP-LOC (IN at) 
        (NP (PRP$ her) (NN house) )))
    (-DFL- E_S) ))
( (S 
    (CC and)
    (EDITED 
      (RM (-DFL- \[) )
      (NP-SBJ (PRP she) )
      (, ,) 
      (IP (-DFL- \+) ))
    (PRN 
      (S 
        (NP-SBJ (PRP you) )
        (VP (VBP know) ))
      (, ,) )
    (NP-SBJ (PRP we) )
    (RS (-DFL- \]) )
    (VP (MD could) 
      (VP (VB send) 
        (NP (PRP$ her) )
        (NP (NNS messages) )))
    (, ,) (-DFL- E_S) ))
( (S 
    (EDITED 
      (RM (-DFL- \[) )
      (CC and) 
      (, ,)
      (IP (-DFL- \+) ))
    (CC and) 
    (RS (-DFL- \]) )
    (NP-SBJ (PRP she) )
    (VP 
      (VP (VBD kept) 
        (PP (IN in) 
          (NP (NN touch) ))
        (PP (IN like) 
          (NP (DT that) )))
      (, ,) 
      (CC and)
      (VP 
        (ADVP (RB basically) )
        (, ,) 
        (ADVP (RB just) )
        (VBD worked) 
        (PP-MNR (IN out) 
          (PP (IN of) 
            (NP (PRP$ her) (NN house) )))))
    (. .) (-DFL- E_S) ))
( (CODE (SYM SpeakerA62) (. .) ))
( (INTJ (UH Oh) (. .) (-DFL- E_S) ))
( (CODE (SYM SpeakerB63) (. .) ))
( (S 
    (NP-SBJ (PRP I) )
    (VP (MD would) 
      (ADVP (RB just) )
      (VP (VB take) 
        (NP (PRP her) )
        (NP (DT the) (JJ actual) (NN paperwork) )
        (ADVP-TMP (RB once) 
          (, ,)
          (INTJ (UH uh) )
          (, ,) 
          (NP (DT every) (NN week) 
            (QP (CC or) (CD two) )))))
    (, ,) (-DFL- E_S) ))
( (S 
    (CC and)
    (NP-SBJ (DT that) )
    (VP (VBD worked) 
      (PRT (RP out) )
      (ADVP-MNR (RB great) )
      (ADVP (RB too) ))
    (. .) (-DFL- E_S) ))
( (CODE (SYM SpeakerA64) (. .) ))
( (INTJ (UH Yeah) 
    (, ,)
    (-DFL- E_S) ))
( (INTJ (UH yeah) (-DFL- E_S) ))
( (S 
    (NP-SBJ (DT that) )
    (VP-UNF (VBZ is) )
    (. .) (-DFL- E_S) ))
( (CODE (SYM SpeakerB65) (. .) ))
( (S (CC And) 
    (NP-SBJ (DT that) )
    (VP (BES 's) 
      (NP-PRD (DT a) 
        (ADJP (RB real) (JJ attractive) )
        (NN option) )
      (, ,) 
      (SBAR-ADV (IN if) 
        (S 
          (NP-SBJ (PRP you) )
          (VP (VBP have) 
            (EDITED 
              (RM (-DFL- \[) )
              (NP-UNF (DT the) )
              (, ,) 
              (IP (-DFL- \+) ))
            (NP 
              (NP (DT the) 
                (RS (-DFL- \]) )
                (NN technology) )
              (PP (IN for) 
                (NP (PRP it) )))))))
    (. .) (-DFL- E_S) ))
( (CODE (SYM SpeakerA66) (. .) ))
( (INTJ (UH Uh-huh) (. .) (-DFL- E_S) ))
( (CODE (SYM SpeakerB67) (. .) ))
( (S 
    (NP-SBJ 
      (NP (DT All) )
      (SBAR 
        (WHNP-1 (-NONE- 0) )
        (S 
          (NP-SBJ (PRP it) )
          (RM (-DFL- \[) )
          (VP (VBD was) 
            (NP-PRD (-NONE- *T*-1) )))))
    (, ,) 
    (IP (-DFL- \+) )
    (VP-UNF (VBD was) 
      (, ,)
      (RS (-DFL- \]) )
      (PRN 
        (S 
          (NP-SBJ (PRP you) )
          (VP (VBP know) ))))
    (, ,) (-DFL- N_S) ))
( (S 
    (PRN 
      (S 
        (NP-SBJ (PRP I) )
        (VP (VBP mean) ))
      (, ,) )
    (NP-SBJ (PRP she) )
    (ADVP (RB just) )
    (VP (VBD used) 
      (NP (DT a) (NN phone) (NN modem) ))
    (-DFL- E_S) ))
( (S 
    (CC and)
    (RM (-DFL- \[) )
    (NP-SBJ (PRP she) )
    (VP (VBD was) 
      (IP (-DFL- \+) )
      (SBAR-PRD (UH like) 
        (S 
          (NP-SBJ (PRP she) )
          (VP (VBD was) 
            (RS (-DFL- \]) )
            (VP (VBG sitting) 
              (PP-LOC (IN in) 
                (NP (DT the) (NN office) )))))))
    (, ,) (-DFL- E_S) ))
( (S (RB so) 
    (NP-SBJ (PRP I) )
    (VP (VBP think) 
      (SBAR (-NONE- 0) 
        (S 
          (NP-SBJ (DT that) )
          (VP (BES 's) 
            (ADJP-PRD (RB real) (JJ nice) )
            (ADVP (RB too) )
            (, ,) 
            (S-TPC 
              (NP-SBJ (-NONE- *) )
              (VP (TO to) 
                (VP (VB come) 
                  (PRT (RP up) )
                  (PP (IN with) 
                    (NP (JJ different) (NNS options) )))))))))
    (. .) (-DFL- E_S) ))
( (SQ (VBP Do) 
    (NP-SBJ (PRP you) )
    (VP (VB like) 
      (NP (DT the) (NN job) (NN sharing) ))
    (. ?) (-DFL- E_S) ))
( (CODE (SYM SpeakerA68) (. .) ))
( (S 
    (INTJ (UH Oh) )
    (, ,) 
    (NP-SBJ (PRP I) )
    (VP (VBP do) )
    (, ,) (-DFL- E_S) ))
( (CODE (SYM SpeakerB69) (. .) ))
( (SQ (VBP Do) 
    (NP-SBJ (PRP you) )
    (. ?) (-DFL- E_S) ))
( (CODE (SYM SpeakerA70) (. .) ))
( (S 
    (NP-SBJ (PRP I) )
    (ADVP (RB really) )
    (VP (VBP do) )
    (, ,) (-DFL- E_S) ))
( (S 
    (NP-SBJ (PRP I) )
    (VP (VBP think) 
      (SBAR (-NONE- 0) 
        (S 
          (NP-SBJ (PRP it) )
          (VP (BES 's) 
            (ADJP-PRD (JJ great) )))))
    (. .) (-DFL- E_S) ))
( (CODE (SYM SpeakerB71) (. .) ))
( (SQ (VBP Do) 
    (NP-SBJ (PRP you) )
    (VP (VB work) 
      (INTJ (IN like) )
      (NP-UNF 
        (NP (JJ half) (NNS days) )
        (, ,) (CC or) 
        (NP (JJ half) (NNS weeks) )
        (CC or) ))
    (, ,) (-DFL- N_S) ))
( (CODE (SYM SpeakerA72) (. .) ))
( (S 
    (INTJ (UH Uh) )
    (, ,) 
    (INTJ (UH well) )
    (INTJ (UH like) )
    (, ,) 
    (NP-TMP (CD one) (NN week) )
    (S 
      (NP-SBJ (PRP she) )
      (VP (MD 'll) 
        (VP (VB work) 
          (NP (CD three) (NNS days) ))))
    (CC and) 
    (S 
      (NP-SBJ (PRP I) )
      (VP (MD 'll) 
        (VP (VB work) 
          (NP (CD two) ))))
    (-DFL- E_S) ))
( (S 
    (CC and)
    (NP-TMP (DT the) (JJ next) (NN week) )
    (PRN 
      (, ,)
      (S 
        (NP-SBJ (PRP you) )
        (VP (VBP know) ))
      (, ,) )
    (S 
      (NP-SBJ (PRP I) )
      (VP (MD 'll) 
        (VP (VB work) 
          (NP (CD three) ))))
    (-DFL- E_S) 
    (CC and)
    (S 
      (NP-SBJ (PRP she) )
      (VP (MD 'll) 
        (VP (VB work) 
          (NP (CD two) ))))
    (, ,) (-DFL- E_S) ))
( (CODE (SYM SpeakerB73) (. .) ))
( (S 
    (INTJ (UH Oh) )
    (, ,) 
    (INTJ (UH oh) )
    (NP-SBJ (DT that) )
    (VP (BES 's) 
      (ADJP-PRD (JJ great) ))
    (, ,) (-DFL- E_S) ))
( (CODE (SYM SpeakerA74) (. .) ))
( (S 
    (CC and)
    (NP-SBJ (PRP we) )
    (ADVP (RB just) )
    (VP (VBP share) 
      (PRT (RP off) )
      (PP (IN like) 
        (NP (DT that) )))
    (. .) (-DFL- E_S) ))
( (CODE (SYM SpeakerB75) (. .) ))
( (INTJ (UH Uh-huh) (. .) (-DFL- E_S) ))
( (SQ (VBP Do) 
    (NP-SBJ (PRP you) )
    (VP (VB get) 
      (NP (DT the) (JJ full) (NNS benefits) ))
    (. ?) (-DFL- E_S) ))
( (CODE (SYM SpeakerA76) (. .) ))
( (INTJ (UH Uh-huh) 
    (, ,)
    (-DFL- E_S) ))
( (INTJ (UH yeah) (-DFL- E_S) ))
( (S 
    (NP-SBJ (PRP we) )
    (VP (VBP get) 
      (NP (DT the) (JJ full) (NNS benefits) ))
    (. .) (-DFL- E_S) ))
( (CODE (SYM SpeakerB77) (. .) ))
( (S 
    (INTJ (UH Oh) )
    (, ,) 
    (NP-SBJ (DT that) )
    (VP (BES 's) 
      (ADJP-PRD (JJ wonderful) ))
    (. .) (-DFL- E_S) ))
( (CODE (SYM SpeakerA78) (. .) ))
( (S (CC But) 
    (NP-SBJ (PRP we) )
    (VP (VBP 've) 
      (ADVP (RB just) )
      (ADVP (RB really) )
      (VP (VBN got) 
        (NP 
          (NP (DT a) (JJ wonderful) (NN system) )
          (SBAR 
            (WHNP-1 (WDT that) )
            (S 
              (NP-SBJ (PRP we) )
              (VP (VBP 're) 
                (VP (VBG working) 
                  (PP (IN under) 
                    (NP (-NONE- *T*-1) )))))))))
    (. .) (-DFL- E_S) ))
( (CODE (SYM SpeakerB79) (. .) ))
( (INTJ (UH Yeah) 
    (, ,)
    (-DFL- E_S) ))
( (S 
    (ADVP (RB especially) )
    (PP (IN with) 
      (NP 
        (NP (NNS children) )
        (, ,) 
        (CC and)
        (NP 
          (NP 
            (ADJP (RB so) (JJ many) )
            (NNS things) )
          (VP (VBG going) 
            (PRT (RP on) )))))
    (, ,) 
    (NP-SBJ (DT that) )
    (VP (MD would) 
      (VP (VB be) 
        (ADJP-PRD (JJ great) )))
    (. .) (-DFL- E_S) ))
( (CODE (SYM SpeakerA80) (. .) ))
( (INTJ (UH Yeah) (. .) (-DFL- E_S) ))
( (CODE (SYM SpeakerB81) (. .) ))
( (CODE (SYM SpeakerA82) (. .) ))
( (S 
    (NP-SBJ (PRP It) )
    (ADVP (RB really) )
    (VP (VBZ is) 
      (ADJP-PRD (-NONE- *?*) ))
    (, ,) (-DFL- E_S) ))
( (S 
    (CC and)
    (NP-MNR (DT that) (NN way) )
    (NP-SBJ (PRP we) )
    (VP (VBP 're) (RB not) 
      (ADVP (RB really) )
      (VP (VBG missing) 
        (NP 
          (TYPO (GW any) (^NN thing) ))
        (PP-PRP (RP out) 
          (PRN 
            (, ,)
            (S 
              (NP-SBJ (PRP you) )
              (VP (VBP know) ))
            (, ,) )
          (PP (IN of) 
            (X (XX MUMBLEx) )
            (NP (NNS children) )))))
    (, ,) (-DFL- E_S) ))
( (CODE (SYM SpeakerB83) (. .) ))
( (NP-UNF (DT Either) (NN way) 
    (, ,)
    (-DFL- N_S) ))
( (CODE (SYM SpeakerA84) (. .) ))
( (INTJ (UH uh-huh) (. .) (-DFL- E_S) ))
( (CODE (SYM SpeakerB85) (. .) ))
( (INTJ (UH yeah) 
    (, ,)
    (-DFL- E_S) ))
( (S 
    (NP-SBJ (PRP you) )
    (VP (VBP have) 
      (NP 
        (NP (PRP$ your) (NN career) )
        (CC and) 
        (NP (PRP$ your) (NN home) (NN life) )))
    (, ,) (-DFL- E_S) ))
( (S 
    (CC and)
    (NP-SBJ (DT that) )
    (VP (MD would) 
      (VP (VB be) 
        (NP-PRD (DT a) (JJ nice) (NN way) )
        (, ,) 
        (SBAR-ADV 
          (ADVP (RB especially) )
          (IN if) 
          (S 
            (NP-SBJ (PRP you) )
            (VP (VBP have) 
              (NP (JJ young) (NNS children) ))))))
    (. .) (-DFL- E_S) ))
( (CODE (SYM SpeakerA86) (. .) ))
( (S 
    (INTJ (UH Oh) )
    (, ,) 
    (NP-SBJ (PRP it) )
    (VP (VBZ is) 
      (NP-PRD (-NONE- *?*) ))
    (, ,) (-DFL- E_S) ))
( (S 
    (NP-SBJ (PRP it) )
    (VP (VBZ is) 
      (NP-PRD (-NONE- *?*) ))
    (, ,) (-DFL- E_S) ))
( (S 
    (INTJ (UH well) )
    (NP-SBJ 
      (NP (DT both) )
      (PP (IN of) 
        (NP (PRP ours) )))
    (VP (VBZ is) 
      (NP-PRD (NN school) (NN age) ))
    (, ,) (-DFL- E_S) ))
( (S (CC but) 
    (NP-SBJ-1 (PRP we) )
    (VP (VBP do) (RB n't) 
      (VP (VB want) 
        (S 
          (NP-SBJ (-NONE- *-1) )
          (VP (TO to) 
            (VP (VB miss) 
              (NP 
                (NP 
                  (NP (DT any) )
                  (PP (IN of) 
                    (NP (DT those) (NNP P) (NNP T) (NNP A) (NNPS -s) )))
                (CC and) 
                (PRN 
                  (, ,)
                  (S 
                    (NP-SBJ (PRP you) )
                    (VP (VBP know) ))
                  (, ,) )
                (NP 
                  (NP (DT all) )
                  (PP (IN of) 
                    (NP (DT that) )))))))))
    (. .) (-DFL- E_S) ))
( (CODE (SYM SpeakerB87) (. .) ))
( (INTJ (UH Uh-huh) 
    (, ,)
    (-DFL- E_S) ))
( (INTJ 
    (INTJ (UH oh) )
    (, ,) 
    (INTJ (UH no) )
    (, ,) (-DFL- E_S) ))
( (S 
    (NP-SBJ (PRP I) )
    (VP-UNF (VBP think) )
    (, ,) (-DFL- N_S) ))
( (INTJ (UH yeah) (. .) (-DFL- E_S) ))
( (S 
    (NP-SBJ (PRP$ My) (NN son) )
    (VP (BES 's) 
      (ADVP (RB just) )
      (PP-PRD (IN in) 
        (NP (NN day-care) )))
    (-DFL- E_S) ))
( (S (CC but) 
    (NP-LOC (RB even) (IN that) )
    (NP-SBJ (PRP they) )
    (VP (VBP have) 
      (NP (JJ extracurricular) (NNS activities) ))
    (-DFL- E_S) ))
( (FRAG 
    (CC and)
    (S-ADV 
      (NP-SBJ (-NONE- *) )
      (ADJP-PRD 
        (ADJP (DT the) (JJR older) )
        (SBAR 
          (WHADJP-1 (-NONE- 0) )
          (S 
            (NP-SBJ (PRP they) )
            (VP (VBP get) 
              (ADJP-PRD (-NONE- *T*-1) ))))))
    (ADVP 
      (ADVP (DT the) (JJR more) )
      (SBAR (WDT that) 
        (S 
          (NP-SBJ (PRP you) )
          (VP (VBP 're) 
            (ADJP-PRD (JJ involved) 
              (PP (IN in) 
                (NP (DT that) )))))))
    (. .) (-DFL- E_S) ))
( (CODE (SYM SpeakerA88) (. .) ))
( (INTJ (UH Uh-huh) (. .) (-DFL- E_S) ))
( (S 
    (NP-SBJ (PRP I) )
    (VP (VBP think) 
      (SBAR (-NONE- 0) 
        (S 
          (NP-SBJ (PRP it) )
          (VP (BES 's) 
            (ADJP-PRD (JJ great) )))))
    (, ,) (-DFL- E_S) ))
( (S-UNF 
    (NP-SBJ (PRP I) )
    (ADVP (RB really) )
    (, ,) (-DFL- N_S) ))
( (CODE (SYM SpeakerB89) (. .) ))
( (INTJ (UH Yeah) 
    (, ,)
    (-DFL- E_S) ))
( (CODE (SYM SpeakerA90) (. .) ))
( (S 
    (CC and)
    (NP-SBJ (PRP I) )
    (VP (VBP look) 
      (PP (IN for) 
        (NP 
          (NP (JJR more) )
          (PP (IN of) 
            (NP (DT that) ))))
      (PP-TMP (IN in) 
        (NP (DT the) (JJ next) (NN generation) )))
    (. .) (-DFL- E_S) ))
( (CODE (SYM SpeakerB91) (. .) ))
( (S 
    (NP-SBJ (PRP I) )
    (VP (VBP do) 
      (ADVP (RB too) )
      (, ,) 
      (ADVP (RB especially) )
      (SBAR-TMP (IN as) 
        (S 
          (NP-SBJ (NNS women) )
          (VP 
            (VP (VBP get) 
              (PP (RP up) 
                (PP (IN in) 
                  (NP (NN management) ))))
            (EDITED 
              (RM (-DFL- \[) )
              (CC and) 
              (, ,)
              (IP (-DFL- \+) ))
            (CC and) 
            (RS (-DFL- \]) )
            (VP (MD can) 
              (VP (VB be) 
                (PP-PRD (RP in) 
                  (PP (IN on) 
                    (NP-UNF (DT those) (NN decision) (NN making) )))))))))
    (, ,) (-DFL- N_S) ))
( (S 
    (PRN 
      (S 
        (NP-SBJ (PRP you) )
        (VP (VBP know) ))
      (, ,) )
    (SBAR-TMP 
      (WHADVP-1 (WRB when) )
      (S 
        (NP-SBJ (DT that) (NN subject) )
        (VP (VBZ comes) 
          (PRT (RP up) )
          (ADVP-TMP (-NONE- *T*-1) ))))
    (NP-SBJ (PRP they) )
    (VP (MD can) 
      (VP (VB say) 
        (INTJ-SEZ (UH yes) )))
    (, ,) (-DFL- E_S) ))
( (S 
    (NP-SBJ (DT that) )
    (VP (MD would) 
      (VP (VB be) 
        (ADJP-PRD (JJ wonderful) )))
    (. .) (-DFL- E_S) ))
( (CODE (SYM SpeakerA92) (. .) ))
( (INTJ (UH Yes) 
    (, ,)
    (-DFL- E_S) ))
( (S 
    (INTJ (UH oh) )
    (, ,) 
    (NP-SBJ (PRP I) )
    (VP (VBP do) 
      (ADVP (RB too) ))
    (. .) (-DFL- E_S) ))
( (CODE (SYM SpeakerB93) (. .) ))
( (S (CC Plus) 
    (, ,)
    (NP-SBJ (PRP I) )
    (VP (VBP bet) 
      (SBAR (-NONE- 0) 
        (S 
          (NP-SBJ (PRP it) )
          (EDITED 
            (RM (-DFL- \[) )
            (VP-UNF (VBZ cuts) )
            (, ,) 
            (IP (-DFL- \+) ))
          (VP (VBZ cuts) 
            (RS (-DFL- \]) )
            (PRT (RP down) )
            (PP (IN on) 
              (NP (PRP$ your) (NN absenteeism) ))
            (SBAR-PRP (IN because) 
              (S 
                (NP-SBJ (PRP you) )
                (VP (VBP 've) 
                  (VP (VBN got) 
                    (NP 
                      (NP (CD two) (NNS days) (RP off) )
                      (SBAR 
                        (WHADVP-1 (WDT that) )
                        (S 
                          (NP-SBJ (PRP you) )
                          (VP (MD can) 
                            (VP (VB do) 
                              (NP (NN everything) )
                              (ADVP-TMP (-NONE- *T*-1) ))))))))))))))
    (, ,) (-DFL- E_S) ))
( (S (RB so) 
    (NP-SBJ-1 (PRP you) )
    (VP (VBP do) (RB n't) 
      (VP (VB have) 
        (S 
          (NP-SBJ (-NONE- *-1) )
          (VP (TO to) 
            (VP (-NONE- *?*) 
              (PRN 
                (, ,)
                (S 
                  (NP-SBJ (PRP you) )
                  (VP (VBP know) ))
                (, ,) )
              (SBAR-ADV (IN unless) 
                (S 
                  (S 
                    (NP-SBJ (PRP you) )
                    (VP (VBP 're) 
                      (ADVP (RB just) )
                      (ADJP-PRD (RB really) (JJ sick) )))
                  (, ,) (CC or) 
                  (S 
                    (NP-SBJ (DT the) (NN child) )
                    (VP (BES 's) 
                      (ADJP-PRD (JJ sick) ))))))))))
    (. .) (-DFL- E_S) ))
( (CODE (SYM SpeakerA94) (. .) ))
( (S 
    (NP-TMP 
      (NP (JJS Most) )
      (PP (IN of) 
        (NP (DT the) (NN time) )))
    (ADVP-TMP (RB now) )
    (PRN 
      (, ,)
      (S 
        (NP-SBJ (PRP you) )
        (VP (VBP know) ))
      (, ,) )
    (NP-SBJ (PRP it) )
    (VP (BES 's) 
      (ADVP (RB just) )
      (NP-PRD (DT the) (NN weekend) ))
    (, ,) (-DFL- E_S) ))
( (S-IMP (CC or) 
    (NP-SBJ (-NONE- *) )
    (ADVP (RB just) )
    (VP (VB forget) 
      (NP (PRP it) ))
    (. .) (-DFL- E_S) ))
( (CODE (SYM SpeakerB95) (. .) ))
( (INTJ (UH Uh-huh) 
    (, ,)
    (-DFL- E_S) ))
( (INTJ 
    (INTJ (UH oh) )
    (INTJ (UH yeah) )
    (, ,) (-DFL- E_S) ))
( (S 
    (NP-SBJ-1 (PRP I) )
    (VP (VBP have) 
      (S 
        (NP-SBJ (-NONE- *-1) )
        (VP (TO to) 
          (VP (VB plan) 
            (PP 
              (NP-ADV (NN way) )
              (IN in) 
              (NP (NN advance) ))
            (, ,) 
            (SBAR-PRP-UNF (IN because) )))))
    (, ,) (-DFL- N_S) ))
( (S (CC or) 
    (, ,)
    (SBAR-NOM-SBJ 
      (WHNP-1 (WP what) )
      (S 
        (NP-SBJ (PRP I) )
        (VP (VBP 've) 
          (VP (VBN done) 
            (NP (-NONE- *T*-1) )))))
    (VP (VBZ is) 
      (S-PRD 
        (NP-SBJ (-NONE- *) )
        (VP (VBN found) 
          (INTJ (UH like) )
          (NP 
            (NP 
              (NP 
                (NP (NNS doctors) (POS ') )
                (CC and) 
                (NP (NNS dentists) (POS ') ))
              (NN office) )
            (PP (IN with) 
              (NP (JJ extended) (NNS hours) ))))))
    (. .) (-DFL- E_S) ))
( (CODE (SYM SpeakerA96) (. .) ))
( (INTJ (UH Uh-huh) (. .) (-DFL- E_S) ))
( (CODE (SYM SpeakerB97) (. .) ))
( (S 
    (NP-SBJ (DT That) )
    (VP (HVS 's) 
      (VP (VBN been) 
        (ADJP-PRD (RB real) (JJ helpful) )
        (ADVP (RB too) )))
    (, ,) (-DFL- E_S) ))
( (S 
    (INTJ (UH like) )
    (NP-SBJ (PRP$ my) (NN doctor) )
    (VP (NNS stays) 
      (ADJP-PRD (JJ open) )
      (PP-TMP (IN til) 
        (NP 
          (NP (CD nine) )
          (PP-TMP (IN in) 
            (NP (DT the) (NN evening) )))))
    (. .) (-DFL- E_S) ))
( (S (RB So) 
    (NP-SBJ (DT that) )
    (VP (BES 's) 
      (ADJP-PRD (RB real) (JJ helpful) ))
    (, ,) (-DFL- E_S) ))
( (S (RB so) 
    (NP-SBJ-1 (PRP you) )
    (VP (VBP do) (RB n't) 
      (PRN 
        (, ,)
        (S 
          (NP-SBJ (PRP you) )
          (VP (VBP know) ))
        (, ,) )
      (VP (VB have) 
        (S 
          (NP-SBJ (-NONE- *-1) )
          (VP (TO to) 
            (VP 
              (VP (VB do) 
                (NP (PRP it) )
                (PP-TMP (IN during) 
                  (NP (NN office) (NNS hours) )))
              (, ,) 
              (VP (VB run) 
                (PRT (RB out) )
                (PP-TMP (IN on) 
                  (NP (PRP$ your) (NN lunch) (NN hour) ))))))))
    (. .) (-DFL- E_S) ))
( (S 
    (NP-SBJ (PRP I) )
    (VP (VBP do) (RB n't) 
      (VP (VB know) 
        (SBAR 
          (WHNP-1 (WRB how) (JJ many) (NNS times) )
          (S 
            (NP-SBJ-2 (PRP I) )
            (VP (VBP 've) 
              (VP (VBN done) 
                (NP (DT that) )
                (NP-TMP (-NONE- *T*-1) )
                (S-PRP 
                  (NP-SBJ (-NONE- *-2) )
                  (VP (TO to) 
                    (VP (VB do) 
                      (NP 
                        (NP (NN something) )
                        (, ,) 
                        (NP 
                          (NP (NN post) (NN office) )
                          (CC or) 
                          (NP (DT the) (NN bank) )
                          (CC or) 
                          (NP 
                            (NP (DT any) (NN kind) )
                            (PP (IN of) 
                              (NP (NN errand) ))))))))))))))
    (, ,) (-DFL- E_S) ))
( (CODE (SYM SpeakerA98) (. .) ))
( (S 
    (NP-SBJ (-NONE- *) )
    (VP (TO To) 
      (VP-UNF (VB do) ))
    (, ,) (-DFL- E_S) ))
( (INTJ (UH yeah) (. .) (-DFL- E_S) ))
( (CODE (SYM SpeakerB99) (. .) ))
( (S-UNF (RB so) (. .) (-DFL- N_S) ))
( (CODE (SYM SpeakerA100) (. .) ))
( (INTJ (UH Uh-huh) (. .) (-DFL- E_S) ))
( (S 
    (INTJ (UH Well) )
    (NP-SBJ (PRP I) )
    (VP (VBP think) 
      (SBAR (-NONE- 0) 
        (S 
          (NP-SBJ (PRP we) )
          (VP (VBP 've) 
            (ADVP (RB really) )
            (VP (VBN come) 
              (NP (DT a) (JJ long) (NN way) )
              (PP (IN in) 
                (NP (DT that) ))))))
      (SBAR-PRP-UNF (IN because) ))
    (, ,) (-DFL- N_S) ))
( (CODE (SYM SpeakerB101) (. .) ))
( (INTJ (UH Uh-huh) 
    (, ,)
    (-DFL- E_S) ))
( (S 
    (NP-SBJ (PRP I) )
    (VP (VBP guess) 
      (SBAR (-NONE- 0) 
        (S 
          (NP-SBJ (PRP I) )
          (VP (VBP take) 
            (NP (PRP it) )
            (PP (IN for) 
              (ADJP (JJ granted) ))
            (, ,) 
            (ADVP (RB kind) (RB of) )
            (, ,) 
            (SBAR-PRP (IN because) 
              (, ,)
              (S-UNF 
                (NP-SBJ (PRP I) )
                (ADVP (RB just) )))))))
    (, ,) (-DFL- N_S) ))
( (S 
    (NP-SBJ (PRP it) )
    (VP (HVS 's) 
      (ADVP-TMP (RB always) )
      (VP (VBN been) 
        (NP-MNR-PRD (DT that) (NN way) )))
    (. .) (-DFL- E_S) ))
( (CODE (SYM SpeakerA102) (. .) ))
( (INTJ (UH Uh-huh) (. .) (-DFL- E_S) ))
( (CODE (SYM SpeakerB103) (. .) ))
( (S (CC But) 
    (NP-SBJ (PRP I) )
    (VP-UNF (VBP know) )
    (, ,) (-DFL- N_S) ))
( (CODE (SYM SpeakerA104) (. .) ))
( (INTJ (UH Yeah) 
    (, ,)
    (-DFL- E_S) ))
( (S (CC but) 
    (NP-SBJ (PRP I) )
    (VP (MD can) 
      (EDITED 
        (RM (-DFL- \[) )
        (VP-UNF (VB rem-) )
        (, ,) 
        (IP (-DFL- \+) ))
      (VP (VB remember) 
        (RS (-DFL- \]) )
        (SBAR (-NONE- 0) 
          (S-UNF 
            (ADVP-TMP (RB back) )
            (S-ADV 
              (NP-SBJ (-NONE- *) )
              (VP (VBG growing) 
                (PRT (RP up) )))
            (, ,) 
            (NP-SBJ (PRP$ my) (NN mother) )))))
    (, ,) (-DFL- N_S) ))
( (S 
    (PRN 
      (S 
        (NP-SBJ (PRP I) )
        (VP (VBP mean) )))
    (NP-SBJ (PRP it) )
    (VP-UNF (VBD was) )
    (-DFL- N_S) ))
( (S 
    (NP-SBJ (PRP she) )
    (ADVP-TMP (RB always) )
    (VP (VBD worked) )
    (, ,) (-DFL- E_S) ))
( (S (CC but) 
    (NP-SBJ 
      (NP (PRP it) )
      (SBAR (-NONE- *EXP*-1) ))
    (VP (VBD was) (RB n't) 
      (ADJP-PRD (RB that) (JJ easy) )
      (SBAR-1 (IN for) 
        (S 
          (NP-SBJ (PRP her) )
          (VP (TO to) 
            (ADVP (RB just) )
            (VP (VB take) 
              (PRT (RP off) ))))))
    (. .) (-DFL- E_S) ))
( (CODE (SYM SpeakerB105) (. .) ))
( (INTJ 
    (INTJ (UH Oh) )
    (INTJ (UH no) )
    (, ,) (-DFL- E_S) ))
( (S 
    (NP-SBJ (PRP I) )
    (VP (MD can) 
      (VP (VB remember) 
        (S 
          (NP-SBJ (PRP$ my) (NN mother) )
          (VP (VBG getting) 
            (PP (IN in) 
              (NP (NN trouble) ))
            (SBAR-ADV (IN if) 
              (PRN 
                (, ,)
                (S 
                  (NP-SBJ (PRP you) )
                  (VP (VBP know) ))
                (, ,) )
              (S 
                (NP-SBJ 
                  (NP (CD one) )
                  (PP-UNF (IN of) ))
                (VP (VBD was) 
                  (ADJP-PRD (JJ sick) ))))))))
    (, ,) (-DFL- E_S) ))
( (S 
    (CC and)
    (NP-SBJ (PRP I) )
    (VP (VBP know) 
      (SBAR (-NONE- 0) 
        (S 
          (NP-SBJ (PRP she) )
          (ADVP (RB probably) )
          (VP (VBD did) (RB n't) 
            (VP (VB make) 
              (NP (RB hardly) (NN anything) )
              (PRN 
                (, ,)
                (S 
                  (NP-SBJ (PRP you) )
                  (VP (VBP know) ))
                (, ,) )
              (PP (JJ compared) 
                (PP (IN to) 
                  (NP 
                    (NP (DT the) (NN work) )
                    (SBAR 
                      (WHNP-1 (WDT that) )
                      (S 
                        (NP-SBJ (PRP she) )
                        (VP (VBD did) 
                          (NP (-NONE- *T*-1) ))))))))))))
    (. .) (-DFL- E_S) ))
( (CODE (SYM SpeakerA106) (. .) ))
( (INTJ 
    (INTJ (UH Oh) )
    (INTJ (UH yeah) )
    (. .) (-DFL- E_S) ))
( (CODE (SYM SpeakerB107) (. .) ))
( (S 
    (NP-SBJ (PRP I) )
    (VP (VBP think) 
      (SBAR (-NONE- 0) 
        (S 
          (NP-SBJ (EX there) )
          (VP (VBZ is) 
            (ADVP-TMP (RB still) )
            (NP-PRD 
              (NP (DT some) (NN discrimination) )
              (ADVP (EX there) )
              (SBAR 
                (WHADVP-1 (WRB where) )
                (EDITED 
                  (RM (-DFL- \[) )
                  (IN as) 
                  (, ,)
                  (IP (-DFL- \+) ))
                (RS (-DFL- \]) )
                (PRN 
                  (S 
                    (NP-SBJ (PRP you) )
                    (VP (VBP know) ))
                  (, ,) )
                (S 
                  (NP-SBJ (NNS men) 
                    (CC and)
                    (NNS women) )
                  (VP (VBP work) 
                    (PP (IN in) 
                      (NP (DT the) (JJ same) (NN job) ))
                    (ADVP (-NONE- *T*-1) )))))))))
    (, ,) (-DFL- E_S) ))
( (S 
    (NP-SBJ (PRP I) )
    (VP (VBP think) 
      (SBAR (-NONE- 0) 
        (S 
          (NP-SBJ-1 (NNS men) )
          (VP (VBP get) 
            (VP (VBN paid) 
              (NP (-NONE- *-1) )
              (NP (JJR more) ))))))
    (, ,) (-DFL- E_S) ))
( (CODE (SYM SpeakerA108) (. .) ))
( (S 
    (INTJ (UH Oh) )
    (, ,) 
    (NP-SBJ (PRP I) )
    (VP (VBP do) 
      (ADVP (RB too) ))
    (. .) (-DFL- E_S) ))
( (CODE (SYM SpeakerB109) (. .) ))
( (S (CC but) 
    (NP-SBJ (PRP I) )
    (VP (VBP think) 
      (SBAR (-NONE- 0) 
        (S 
          (NP-SBJ (DT that) )
          (VP (BES 's) 
            (VP (VBG improving) )))))
    (. .) (-DFL- E_S) ))
( (S 
    (NP-SBJ (PRP It) )
    (VP (BES 's) 
      (NP-PRD (PDT such) (DT a) (JJ slow) (NN process) ))
    (-DFL- E_S) ))
( (S 
    (NP-SBJ (PRP it) )
    (VP (BES 's) 
      (ADJP-PRD (JJ frustrating) ))
    (, ,) (-DFL- E_S) ))
( (S (CC but) 
    (, ,)
    (NP-SBJ (PRP you) )
    (VP (MD can) 
      (VP (VB see) 
        (SBAR (IN that) 
          (S 
            (NP-SBJ (PRP it) )
            (VP (BES 's) 
              (ADJP-PRD (JJ wrong) ))))))
    (-DFL- E_S) ))
( (CODE (SYM SpeakerA110) (. .) ))
( (INTJ (UH Yes) 
    (, ,)
    (-DFL- E_S) ))
( (INTJ (UH yes) (. .) (-DFL- E_S) ))
( (CODE (SYM SpeakerB111) (. .) ))
( (S 
    (CC and)
    (NP-SBJ-1 (PRP you) )
    (ADVP (RB just) )
    (VP (VBP want) 
      (S 
        (NP-SBJ (-NONE- *-1) )
        (VP (TO to) 
          (VP (VB make) 
            (S 
              (NP-SBJ (PRP it) )
              (ADJP-PRD (JJ right) ))))))
    (, ,) (-DFL- E_S) ))
( (S (CC but) 
    (ADVP (IN at) (JJS least) )
    (NP-SBJ (DT the) (NNS wheels) )
    (VP (VBP are) 
      (VP (VBG moving) 
        (ADVP-DIR (RB forward) )))
    (. .) (-DFL- E_S) ))
( (CODE (SYM SpeakerA112) (. .) ))
( (S 
    (NP-SBJ (PRP They) )
    (ADVP (RB really) )
    (VP (VBP are) 
      (VP (-NONE- *?*) ))
    (. .) (-DFL- E_S) ))
( (CODE (SYM SpeakerB113) (. .) ))
( (INTJ (UH Yeah) 
    (, ,)
    (-DFL- E_S) ))
( (S 
    (NP-SBJ (PRP I) )
    (VP (VBP think) 
      (SBAR (-NONE- 0) 
        (S 
          (NP-SBJ (PRP it) )
          (VP (BES 's) 
            (VP (VBG getting) 
              (ADJP-PRD (JJR better) 
                (, ,)
                (RB not) (JJR worse) ))))))
    (. .) (-DFL- E_S) ))
( (S 
    (INTJ (UH Well) )
    (, ,) 
    (NP-SBJ (PRP I) )
    (VP (MD should) 
      (ADVP (RB probably) )
      (VP (VB get) 
        (ADVP (RB back) )
        (PP (IN to) 
          (NP (PRP$ my) (NN job) ))))
    (. .) (-DFL- E_S) ))
( (CODE (SYM SpeakerA114) (. .) ))
( (S 
    (NP-SBJ (PRP I) )
    (VP (VBP know) )
    (, ,) (-DFL- E_S) ))
( (S 
    (NP-SBJ (PRP I) )
    (VP (VBP know) 
      (NP (DT the) (NN feeling) ))
    (. .) (-DFL- E_S) ))
( (CODE (SYM SpeakerB115) (. .) ))
( (S-IMP 
    (NP-SBJ (-NONE- *) )
    (VP (VB Call) 
      (ADVP (RB again) ))
    (. .) (-DFL- E_S) ))
( (CODE (SYM SpeakerA116) (. .) ))
( (INTJ (UH Okay) 
    (, ,)
    (-DFL- E_S) ))
( (S 
    (NP-SBJ (PRP I) )
    (ADVP (RB sure) )
    (VP (MD will) 
      (VP (-NONE- *?*) ))
    (. .) (-DFL- E_S) ))
( (INTJ (UH Bye-bye) (. .) (-DFL- E_S) ))
( (CODE (SYM SpeakerB117) (. .) ))
( (INTJ (UH Okay) 
    (, ,)
    (-DFL- E_S) ))
( (INTJ (UH bye-bye) (. .) (-DFL- E_S) ))
