# NEVER EDIT this file.  It was generated and will be overwritten without
# notice upon regeneration of this application.  You have been warned.
package Contact::GEN::BDay;

use strict;
use warnings;

use base 'Contact';
use JSON;
use Gantry::Utils::TablePerms;

use Contact::Model::bday qw(
    $BDAY
);

#-----------------------------------------------------------------
# $self->do_main( $contact )
#-----------------------------------------------------------------
sub do_main {
    my ( $self, $contact ) = @_;

    $self->stash->view->template( 'results.tt' );
    $self->stash->view->title( 'Birth Days' );

    my $real_location = $self->location() || '';
    if ( $real_location ) {
        $real_location =~ s{/+$}{};
        $real_location .= '/';
    }

    my $header_option_suffix = ( $contact ) ? "/$contact" : '';

    my @header_options = (
        {
            text => 'Add',
            link => $real_location . "add$header_option_suffix",
            type => 'create',
        },
    );

    my $retval = {
        headings       => [
            'Contact',
            'Birth Day',
        ],
    };

    my $params = $self->params;

    my $search = {};
    if ( $params->{ search } ) {
        my $form = $self->form();

        my @searches;
        foreach my $field ( @{ $form->{ fields } } ) {
            if ( $field->{ searchable } ) {
                push( @searches,
                    ( $field->{ name } => { 'like', "%$params->{ search }%"  } )
                );
            }
        }

        $search = {
            -or => \@searches
        } if scalar( @searches ) > 0;
    }

    my @row_options = (
        {
            text => 'Edit',
            type => 'update',
        },
        {
            text => 'Delete',
            type => 'delete',
        },
    );

    my $perm_obj = Gantry::Utils::TablePerms->new(
        {
            site           => $self,
            real_location  => $real_location,
            header_options => \@header_options,
            row_options    => \@row_options,
        }
    );

    $retval->{ header_options } = $perm_obj->real_header_options;

    my $limit_to_user_id = $perm_obj->limit_to_user_id;
    $search->{ user_id } = $limit_to_user_id if ( $limit_to_user_id );

    if ( $contact ) {
        $search->{ contact } = $contact;
    }

    my $schema = $self->get_schema();
    my @rows   = $BDAY->get_listing(
        {
            schema      => $schema,
            where       => $search,
        }
    );

    ROW:
    foreach my $row ( @rows ) {
        last ROW if $perm_obj->hide_all_data;

        my $id = $row->id;
        my $contact = ( $row->contact )
                ? $row->contact->foreign_display()
                : '';

        push(
            @{ $retval->{rows} }, {
                orm_row => $row,
                data => [
                    $contact,
                    $row->bday,
                ],
                options => $perm_obj->real_row_options( $row ),
            }
        );
    }

    if ( $params->{ json } ) {
        $self->template_disable( 1 );

        my $obj = {
            headings        => $retval->{ headings },
            header_options  => $retval->{ header_options },
            rows            => $retval->{ rows },
        };

        my $json = to_json( $obj, { allow_blessed => 1 } );
        return( $json );
    }

    $self->stash->view->data( $retval );
} # END do_main

1;

=head1 NAME

Contact::GEN::BDay - generated support module for Contact::BDay

=head1 SYNOPSIS

In Contact::BDay:

    use base 'Contact::GEN::BDay';

=head1 DESCRIPTION

This module was generated by bigtop and IS subject to regeneration.
Use it in Contact::BDay to provide the methods below.
Feel free to override them.

=head1 METHODS

=over 4

=item do_main


=back

=head1 AUTHOR

Generated by bigtop and subject to regeneration.

=cut

