# Generated by default/object.tt
package Paws::WAFV2::CustomResponse;
  use Moose;
  has CustomResponseBodyKey => (is => 'ro', isa => 'Str');
  has ResponseCode => (is => 'ro', isa => 'Int', required => 1);
  has ResponseHeaders => (is => 'ro', isa => 'ArrayRef[Paws::WAFV2::CustomHTTPHeader]');

1;

### main pod documentation begin ###

=head1 NAME

Paws::WAFV2::CustomResponse

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::WAFV2::CustomResponse object:

  $service_obj->Method(Att1 => { CustomResponseBodyKey => $value, ..., ResponseHeaders => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::WAFV2::CustomResponse object:

  $result = $service_obj->Method(...);
  $result->Att1->CustomResponseBodyKey

=head1 DESCRIPTION

A custom response to send to the client. You can define a custom
response for rule actions and default web ACL actions that are set to
BlockAction.

For information about customizing web requests and responses, see
Customizing web requests and responses in WAF
(https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html)
in the WAF Developer Guide
(https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).

=head1 ATTRIBUTES


=head2 CustomResponseBodyKey => Str

References the response body that you want WAF to return to the web
request client. You can define a custom response for a rule action or a
default web ACL action that is set to block. To do this, you first
define the response body key and value in the C<CustomResponseBodies>
setting for the WebACL or RuleGroup where you want to use it. Then, in
the rule action or web ACL default action C<BlockAction> setting, you
reference the response body using this key.


=head2 B<REQUIRED> ResponseCode => Int

The HTTP status code to return to the client.

For a list of status codes that you can use in your custom reqponses,
see Supported status codes for custom response
(https://docs.aws.amazon.com/waf/latest/developerguide/customizing-the-response-status-codes.html)
in the WAF Developer Guide
(https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).


=head2 ResponseHeaders => ArrayRef[L<Paws::WAFV2::CustomHTTPHeader>]

The HTTP headers to use in the response. Duplicate header names are not
allowed.

For information about the limits on count and size for custom request
and response settings, see WAF quotas
(https://docs.aws.amazon.com/waf/latest/developerguide/limits.html) in
the WAF Developer Guide
(https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::WAFV2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

