[![Actions Status](https://github.com/skaji/raku-HTTP-Tinyish/workflows/test/badge.svg)](https://github.com/skaji/raku-HTTP-Tinyish/actions)

NAME
====

HTTP::Tinyish - Raku port of HTTP::Tinyish

SYNOPSIS
========

Synchronous way:

```raku
my $http = HTTP::Tinyish.new(agent => "Mozilla/4.0");

my %res = $http.get("http://www.cpan.org/");
warn %res<status>;

$http.post:
  "http://example.com/post",
  headers => { "Content-Type" => "application/x-www-form-urlencoded" },
  content => "foo=bar&baz=quux",
;

$http.mirror:
  "http://www.cpan.org/modules/02packages.details.txt.gz",
  "./02packages.details.txt.gz",
;
```

Asynchronous way:

```raku
my $http = HTTP::Tinyish.new(:async);

my @url = <
  https://raku.org/
  https://doc.raku.org/
  https://design.raku.org/
>;

my @promise = @url.map: -> $url {
  $http.get($url).then: -> $promise {
    my %res = $promise.result;
    say "Done %res<status> %res<url>";
    %res;
  };
};

my @res = await @promise;
```

DESCRIPTION
===========

HTTP::Tinyish is a Raku port of [https://github.com/miyagawa/HTTP-Tinyish](https://github.com/miyagawa/HTTP-Tinyish). Currently only support curl.

Str VS Buf
----------

Raku distinguishes Str from Buf. HTTP::Tinyish handles data as Str by default (that is, encode/decode utf-8 if needed by default). If you want to handle data as Buf, please follow the instruction below.

If you want to send Buf content, just specify Buf in content:

```raku
my $binary-data = "file.bin".IO.slurp(:bin);
$http.post:
  "http://example.com/post",
  content => $binary-data,
;
```

If you want to recieve http content as Buf, then call request/get/post/... method with `bin => True `:

```raku
my %res = $http.get("http://example.com/image.png", bin => True);
does-ok %res<content>, Buf; # pass
```

And decode `%res<content> ` by yourself if you want.

COPYRIGHT AND LICENSE
=====================

Copyright 2015 Shoichi Kaji <skaji@cpan.org>

This library is free software; you can redistribute it and/or modify it under the Artistic License 2.0.

Original perl5 HTTP::Tinyish COPYRIGHT and LICENSE:

    COPYRIGHT
    Tatsuhiko Miyagawa, 2015-

    LICENSE
    This module is licensed under the same terms as Perl itself.

