# Generated by default/object.tt
package Paws::SecurityHub::AwsRdsDbClusterDetails;
  use Moose;
  has ActivityStreamStatus => (is => 'ro', isa => 'Str');
  has AllocatedStorage => (is => 'ro', isa => 'Int');
  has AssociatedRoles => (is => 'ro', isa => 'ArrayRef[Paws::SecurityHub::AwsRdsDbClusterAssociatedRole]');
  has AvailabilityZones => (is => 'ro', isa => 'ArrayRef[Str|Undef]');
  has BackupRetentionPeriod => (is => 'ro', isa => 'Int');
  has ClusterCreateTime => (is => 'ro', isa => 'Str');
  has CopyTagsToSnapshot => (is => 'ro', isa => 'Bool');
  has CrossAccountClone => (is => 'ro', isa => 'Bool');
  has CustomEndpoints => (is => 'ro', isa => 'ArrayRef[Str|Undef]');
  has DatabaseName => (is => 'ro', isa => 'Str');
  has DbClusterIdentifier => (is => 'ro', isa => 'Str');
  has DbClusterMembers => (is => 'ro', isa => 'ArrayRef[Paws::SecurityHub::AwsRdsDbClusterMember]');
  has DbClusterOptionGroupMemberships => (is => 'ro', isa => 'ArrayRef[Paws::SecurityHub::AwsRdsDbClusterOptionGroupMembership]');
  has DbClusterParameterGroup => (is => 'ro', isa => 'Str');
  has DbClusterResourceId => (is => 'ro', isa => 'Str');
  has DbSubnetGroup => (is => 'ro', isa => 'Str');
  has DeletionProtection => (is => 'ro', isa => 'Bool');
  has DomainMemberships => (is => 'ro', isa => 'ArrayRef[Paws::SecurityHub::AwsRdsDbDomainMembership]');
  has EnabledCloudWatchLogsExports => (is => 'ro', isa => 'ArrayRef[Str|Undef]');
  has Endpoint => (is => 'ro', isa => 'Str');
  has Engine => (is => 'ro', isa => 'Str');
  has EngineMode => (is => 'ro', isa => 'Str');
  has EngineVersion => (is => 'ro', isa => 'Str');
  has HostedZoneId => (is => 'ro', isa => 'Str');
  has HttpEndpointEnabled => (is => 'ro', isa => 'Bool');
  has IamDatabaseAuthenticationEnabled => (is => 'ro', isa => 'Bool');
  has KmsKeyId => (is => 'ro', isa => 'Str');
  has MasterUsername => (is => 'ro', isa => 'Str');
  has MultiAz => (is => 'ro', isa => 'Bool');
  has Port => (is => 'ro', isa => 'Int');
  has PreferredBackupWindow => (is => 'ro', isa => 'Str');
  has PreferredMaintenanceWindow => (is => 'ro', isa => 'Str');
  has ReaderEndpoint => (is => 'ro', isa => 'Str');
  has ReadReplicaIdentifiers => (is => 'ro', isa => 'ArrayRef[Str|Undef]');
  has Status => (is => 'ro', isa => 'Str');
  has StorageEncrypted => (is => 'ro', isa => 'Bool');
  has VpcSecurityGroups => (is => 'ro', isa => 'ArrayRef[Paws::SecurityHub::AwsRdsDbInstanceVpcSecurityGroup]');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SecurityHub::AwsRdsDbClusterDetails

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SecurityHub::AwsRdsDbClusterDetails object:

  $service_obj->Method(Att1 => { ActivityStreamStatus => $value, ..., VpcSecurityGroups => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SecurityHub::AwsRdsDbClusterDetails object:

  $result = $service_obj->Method(...);
  $result->Att1->ActivityStreamStatus

=head1 DESCRIPTION

Information about an Amazon RDS DB cluster.

=head1 ATTRIBUTES


=head2 ActivityStreamStatus => Str

The status of the database activity stream.


=head2 AllocatedStorage => Int

For all database engines except Aurora, specifies the allocated storage
size in gibibytes (GiB).


=head2 AssociatedRoles => ArrayRef[L<Paws::SecurityHub::AwsRdsDbClusterAssociatedRole>]

A list of the IAM roles that are associated with the DB cluster.


=head2 AvailabilityZones => ArrayRef[Str|Undef]

A list of Availability Zones (AZs) where instances in the DB cluster
can be created.


=head2 BackupRetentionPeriod => Int

The number of days for which automated backups are retained.


=head2 ClusterCreateTime => Str

Indicates when the DB cluster was created, in Universal Coordinated
Time (UTC).

Uses the C<date-time> format specified in RFC 3339 section 5.6,
Internet Date/Time Format
(https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
contain spaces. For example, C<2020-03-22T13:22:13.933Z>.


=head2 CopyTagsToSnapshot => Bool

Whether tags are copied from the DB cluster to snapshots of the DB
cluster.


=head2 CrossAccountClone => Bool

Whether the DB cluster is a clone of a DB cluster owned by a different
AWS account.


=head2 CustomEndpoints => ArrayRef[Str|Undef]

A list of custom endpoints for the DB cluster.


=head2 DatabaseName => Str

The name of the database.


=head2 DbClusterIdentifier => Str

The DB cluster identifier that the user assigned to the cluster. This
identifier is the unique key that identifies a DB cluster.


=head2 DbClusterMembers => ArrayRef[L<Paws::SecurityHub::AwsRdsDbClusterMember>]

The list of instances that make up the DB cluster.


=head2 DbClusterOptionGroupMemberships => ArrayRef[L<Paws::SecurityHub::AwsRdsDbClusterOptionGroupMembership>]

The list of option group memberships for this DB cluster.


=head2 DbClusterParameterGroup => Str

The name of the DB cluster parameter group for the DB cluster.


=head2 DbClusterResourceId => Str

The identifier of the DB cluster. The identifier must be unique within
each AWS Region and is immutable.


=head2 DbSubnetGroup => Str

The subnet group that is associated with the DB cluster, including the
name, description, and subnets in the subnet group.


=head2 DeletionProtection => Bool

Whether the DB cluster has deletion protection enabled.


=head2 DomainMemberships => ArrayRef[L<Paws::SecurityHub::AwsRdsDbDomainMembership>]

The Active Directory domain membership records that are associated with
the DB cluster.


=head2 EnabledCloudWatchLogsExports => ArrayRef[Str|Undef]

A list of log types that this DB cluster is configured to export to
CloudWatch Logs.


=head2 Endpoint => Str

The connection endpoint for the primary instance of the DB cluster.


=head2 Engine => Str

The name of the database engine to use for this DB cluster.


=head2 EngineMode => Str

The database engine mode of the DB cluster.


=head2 EngineVersion => Str

The version number of the database engine to use.


=head2 HostedZoneId => Str

Specifies the identifier that Amazon Route 53 assigns when you create a
hosted zone.


=head2 HttpEndpointEnabled => Bool

Whether the HTTP endpoint for an Aurora Serverless DB cluster is
enabled.


=head2 IamDatabaseAuthenticationEnabled => Bool

Whether the mapping of IAM accounts to database accounts is enabled.


=head2 KmsKeyId => Str

The ARN of the AWS KMS master key that is used to encrypt the database
instances in the DB cluster.


=head2 MasterUsername => Str

The name of the master user for the DB cluster.


=head2 MultiAz => Bool

Whether the DB cluster has instances in multiple Availability Zones.


=head2 Port => Int

The port number on which the DB instances in the DB cluster accept
connections.


=head2 PreferredBackupWindow => Str

The range of time each day when automated backups are created, if
automated backups are enabled.

Uses the format C<HH:MM-HH:MM>. For example, C<04:52-05:22>.


=head2 PreferredMaintenanceWindow => Str

The weekly time range during which system maintenance can occur, in
Universal Coordinated Time (UTC).

Uses the format C<E<lt>dayE<gt>:HH:MM-E<lt>dayE<gt>:HH:MM>.

For the day values, use
C<mon>|C<tue>|C<wed>|C<thu>|C<fri>|C<sat>|C<sun>.

For example, C<sun:09:32-sun:10:02>.


=head2 ReaderEndpoint => Str

The reader endpoint for the DB cluster.


=head2 ReadReplicaIdentifiers => ArrayRef[Str|Undef]

The identifiers of the read replicas that are associated with this DB
cluster.


=head2 Status => Str

The current status of this DB cluster.


=head2 StorageEncrypted => Bool

Whether the DB cluster is encrypted.


=head2 VpcSecurityGroups => ArrayRef[L<Paws::SecurityHub::AwsRdsDbInstanceVpcSecurityGroup>]

A list of VPC security groups that the DB cluster belongs to.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SecurityHub>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

